// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the Amazon Security Lake exceptions that you can use to find the source of
// problems and fix them.
func (c *Client) ListDatalakeExceptions(ctx context.Context, params *ListDatalakeExceptionsInput, optFns ...func(*Options)) (*ListDatalakeExceptionsOutput, error) {
	if params == nil {
		params = &ListDatalakeExceptionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDatalakeExceptions", params, optFns, c.addOperationListDatalakeExceptionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDatalakeExceptionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDatalakeExceptionsInput struct {

	// List the maximum number of failures in Security Lake.
	MaxFailures *int32

	// List if there are more results available. if nextToken is returned, You can make
	// the call again using the returned token to retrieve the next page
	NextToken *string

	// List the regions from which exceptions are retrieved.
	RegionSet []types.Region

	noSmithyDocumentSerde
}

type ListDatalakeExceptionsOutput struct {

	// Lists the non-retryable failures in the current region.
	//
	// This member is required.
	NonRetryableFailures []types.FailuresResponse

	// List if there are more results available. if nextToken is returned, You can make
	// the call again using the returned token to retrieve the next page
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDatalakeExceptionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDatalakeExceptions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDatalakeExceptions{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDatalakeExceptions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDatalakeExceptionsAPIClient is a client that implements the
// ListDatalakeExceptions operation.
type ListDatalakeExceptionsAPIClient interface {
	ListDatalakeExceptions(context.Context, *ListDatalakeExceptionsInput, ...func(*Options)) (*ListDatalakeExceptionsOutput, error)
}

var _ ListDatalakeExceptionsAPIClient = (*Client)(nil)

// ListDatalakeExceptionsPaginatorOptions is the paginator options for
// ListDatalakeExceptions
type ListDatalakeExceptionsPaginatorOptions struct {
	// List the maximum number of failures in Security Lake.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDatalakeExceptionsPaginator is a paginator for ListDatalakeExceptions
type ListDatalakeExceptionsPaginator struct {
	options   ListDatalakeExceptionsPaginatorOptions
	client    ListDatalakeExceptionsAPIClient
	params    *ListDatalakeExceptionsInput
	nextToken *string
	firstPage bool
}

// NewListDatalakeExceptionsPaginator returns a new ListDatalakeExceptionsPaginator
func NewListDatalakeExceptionsPaginator(client ListDatalakeExceptionsAPIClient, params *ListDatalakeExceptionsInput, optFns ...func(*ListDatalakeExceptionsPaginatorOptions)) *ListDatalakeExceptionsPaginator {
	if params == nil {
		params = &ListDatalakeExceptionsInput{}
	}

	options := ListDatalakeExceptionsPaginatorOptions{}
	if params.MaxFailures != nil {
		options.Limit = *params.MaxFailures
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDatalakeExceptionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDatalakeExceptionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDatalakeExceptions page.
func (p *ListDatalakeExceptionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDatalakeExceptionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxFailures = limit

	result, err := p.client.ListDatalakeExceptions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDatalakeExceptions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "ListDatalakeExceptions",
	}
}
