// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the expiration period and time-to-live (TTL) for which the exception
// message will remain. Exceptions are stored by default, for a 2 week period of
// time from when a record was created in Security Lake. This API does not take
// input parameters. This API does not take input parameters.
func (c *Client) GetDatalakeExceptionsExpiry(ctx context.Context, params *GetDatalakeExceptionsExpiryInput, optFns ...func(*Options)) (*GetDatalakeExceptionsExpiryOutput, error) {
	if params == nil {
		params = &GetDatalakeExceptionsExpiryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDatalakeExceptionsExpiry", params, optFns, c.addOperationGetDatalakeExceptionsExpiryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDatalakeExceptionsExpiryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDatalakeExceptionsExpiryInput struct {
	noSmithyDocumentSerde
}

type GetDatalakeExceptionsExpiryOutput struct {

	// The expiration period and time-to-live (TTL).
	//
	// This member is required.
	ExceptionMessageExpiry *int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDatalakeExceptionsExpiryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDatalakeExceptionsExpiry{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDatalakeExceptionsExpiry{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDatalakeExceptionsExpiry(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDatalakeExceptionsExpiry(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "GetDatalakeExceptionsExpiry",
	}
}
