// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Batch create custom vocabulary item for the specified locale in the specified
// bot.
func (c *Client) BatchCreateCustomVocabularyItem(ctx context.Context, params *BatchCreateCustomVocabularyItemInput, optFns ...func(*Options)) (*BatchCreateCustomVocabularyItemOutput, error) {
	if params == nil {
		params = &BatchCreateCustomVocabularyItemInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchCreateCustomVocabularyItem", params, optFns, c.addOperationBatchCreateCustomVocabularyItemMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchCreateCustomVocabularyItemOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchCreateCustomVocabularyItemInput struct {

	// The unique identifier of the bot to batch create the custom vocabulary item for.
	//
	// This member is required.
	BotId *string

	// The bot version of the bot to batch create the custom vocabulary item for.
	//
	// This member is required.
	BotVersion *string

	// The custom vocabulary item list of the bot to batch create the custom vocabulary
	// item for.
	//
	// This member is required.
	CustomVocabularyItemList []types.NewCustomVocabularyItem

	// The unique locale identifier of the bot to batch create the custom vocabulary
	// item for.
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

type BatchCreateCustomVocabularyItemOutput struct {

	// The unique identifier of the bot to batch create response for the custom
	// vocabulary item.
	BotId *string

	// The bot version of the bot to batch create the custom vocabulary item response
	// for.
	BotVersion *string

	// The errors of the action to batch create the custom vocabulary item response for
	// a bot.
	Errors []types.FailedCustomVocabularyItem

	// The unique locale identifier of the bot to batch create the custom vocabulary
	// item response for.
	LocaleId *string

	// The resources of the action to batch create the custom vocabulary item response
	// for a bot.
	Resources []types.CustomVocabularyItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchCreateCustomVocabularyItemMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchCreateCustomVocabularyItem{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchCreateCustomVocabularyItem{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpBatchCreateCustomVocabularyItemValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchCreateCustomVocabularyItem(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchCreateCustomVocabularyItem(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lex",
		OperationName: "BatchCreateCustomVocabularyItem",
	}
}
