// Code generated by smithy-go-codegen DO NOT EDIT.

package ecs

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/ecs/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsjson11_serializeOpCreateCapacityProvider struct {
}

func (*awsAwsjson11_serializeOpCreateCapacityProvider) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCapacityProvider) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCapacityProviderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.CreateCapacityProvider")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateCapacityProviderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateCluster struct {
}

func (*awsAwsjson11_serializeOpCreateCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.CreateCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateService struct {
}

func (*awsAwsjson11_serializeOpCreateService) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateService) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateServiceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.CreateService")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateServiceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateTaskSet struct {
}

func (*awsAwsjson11_serializeOpCreateTaskSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateTaskSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTaskSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.CreateTaskSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateTaskSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteAccountSetting struct {
}

func (*awsAwsjson11_serializeOpDeleteAccountSetting) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteAccountSetting) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccountSettingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DeleteAccountSetting")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteAccountSettingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteAttributes struct {
}

func (*awsAwsjson11_serializeOpDeleteAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DeleteAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCapacityProvider struct {
}

func (*awsAwsjson11_serializeOpDeleteCapacityProvider) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCapacityProvider) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCapacityProviderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DeleteCapacityProvider")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteCapacityProviderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCluster struct {
}

func (*awsAwsjson11_serializeOpDeleteCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DeleteCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteService struct {
}

func (*awsAwsjson11_serializeOpDeleteService) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteService) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteServiceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DeleteService")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteServiceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteTaskSet struct {
}

func (*awsAwsjson11_serializeOpDeleteTaskSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteTaskSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTaskSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DeleteTaskSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteTaskSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeregisterContainerInstance struct {
}

func (*awsAwsjson11_serializeOpDeregisterContainerInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeregisterContainerInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterContainerInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DeregisterContainerInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeregisterContainerInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeregisterTaskDefinition struct {
}

func (*awsAwsjson11_serializeOpDeregisterTaskDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeregisterTaskDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterTaskDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DeregisterTaskDefinition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeregisterTaskDefinitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeCapacityProviders struct {
}

func (*awsAwsjson11_serializeOpDescribeCapacityProviders) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeCapacityProviders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCapacityProvidersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DescribeCapacityProviders")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeCapacityProvidersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeClusters struct {
}

func (*awsAwsjson11_serializeOpDescribeClusters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeClusters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClustersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DescribeClusters")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeClustersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeContainerInstances struct {
}

func (*awsAwsjson11_serializeOpDescribeContainerInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeContainerInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeContainerInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DescribeContainerInstances")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeContainerInstancesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeServices struct {
}

func (*awsAwsjson11_serializeOpDescribeServices) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeServices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeServicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DescribeServices")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeServicesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeTaskDefinition struct {
}

func (*awsAwsjson11_serializeOpDescribeTaskDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeTaskDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTaskDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DescribeTaskDefinition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeTaskDefinitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeTasks struct {
}

func (*awsAwsjson11_serializeOpDescribeTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DescribeTasks")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeTasksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeTaskSets struct {
}

func (*awsAwsjson11_serializeOpDescribeTaskSets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeTaskSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTaskSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DescribeTaskSets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeTaskSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDiscoverPollEndpoint struct {
}

func (*awsAwsjson11_serializeOpDiscoverPollEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDiscoverPollEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DiscoverPollEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.DiscoverPollEndpoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDiscoverPollEndpointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpExecuteCommand struct {
}

func (*awsAwsjson11_serializeOpExecuteCommand) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpExecuteCommand) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExecuteCommandInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ExecuteCommand")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentExecuteCommandInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTaskProtection struct {
}

func (*awsAwsjson11_serializeOpGetTaskProtection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTaskProtection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTaskProtectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.GetTaskProtection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTaskProtectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListAccountSettings struct {
}

func (*awsAwsjson11_serializeOpListAccountSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListAccountSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAccountSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListAccountSettings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListAccountSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListAttributes struct {
}

func (*awsAwsjson11_serializeOpListAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListClusters struct {
}

func (*awsAwsjson11_serializeOpListClusters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListClusters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListClustersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListClusters")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListClustersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListContainerInstances struct {
}

func (*awsAwsjson11_serializeOpListContainerInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListContainerInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListContainerInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListContainerInstances")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListContainerInstancesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListServices struct {
}

func (*awsAwsjson11_serializeOpListServices) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListServices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListServicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListServices")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListServicesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListServicesByNamespace struct {
}

func (*awsAwsjson11_serializeOpListServicesByNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListServicesByNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListServicesByNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListServicesByNamespace")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListServicesByNamespaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTaskDefinitionFamilies struct {
}

func (*awsAwsjson11_serializeOpListTaskDefinitionFamilies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTaskDefinitionFamilies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTaskDefinitionFamiliesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListTaskDefinitionFamilies")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTaskDefinitionFamiliesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTaskDefinitions struct {
}

func (*awsAwsjson11_serializeOpListTaskDefinitions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTaskDefinitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTaskDefinitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListTaskDefinitions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTaskDefinitionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTasks struct {
}

func (*awsAwsjson11_serializeOpListTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.ListTasks")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTasksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutAccountSetting struct {
}

func (*awsAwsjson11_serializeOpPutAccountSetting) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutAccountSetting) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAccountSettingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.PutAccountSetting")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutAccountSettingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutAccountSettingDefault struct {
}

func (*awsAwsjson11_serializeOpPutAccountSettingDefault) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutAccountSettingDefault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAccountSettingDefaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.PutAccountSettingDefault")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutAccountSettingDefaultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutAttributes struct {
}

func (*awsAwsjson11_serializeOpPutAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.PutAttributes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutAttributesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutClusterCapacityProviders struct {
}

func (*awsAwsjson11_serializeOpPutClusterCapacityProviders) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutClusterCapacityProviders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutClusterCapacityProvidersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.PutClusterCapacityProviders")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutClusterCapacityProvidersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRegisterContainerInstance struct {
}

func (*awsAwsjson11_serializeOpRegisterContainerInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRegisterContainerInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterContainerInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.RegisterContainerInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRegisterContainerInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRegisterTaskDefinition struct {
}

func (*awsAwsjson11_serializeOpRegisterTaskDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRegisterTaskDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterTaskDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.RegisterTaskDefinition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRegisterTaskDefinitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRunTask struct {
}

func (*awsAwsjson11_serializeOpRunTask) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRunTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RunTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.RunTask")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRunTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartTask struct {
}

func (*awsAwsjson11_serializeOpStartTask) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.StartTask")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopTask struct {
}

func (*awsAwsjson11_serializeOpStopTask) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.StopTask")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSubmitAttachmentStateChanges struct {
}

func (*awsAwsjson11_serializeOpSubmitAttachmentStateChanges) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSubmitAttachmentStateChanges) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SubmitAttachmentStateChangesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.SubmitAttachmentStateChanges")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSubmitAttachmentStateChangesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSubmitContainerStateChange struct {
}

func (*awsAwsjson11_serializeOpSubmitContainerStateChange) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSubmitContainerStateChange) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SubmitContainerStateChangeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.SubmitContainerStateChange")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSubmitContainerStateChangeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSubmitTaskStateChange struct {
}

func (*awsAwsjson11_serializeOpSubmitTaskStateChange) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSubmitTaskStateChange) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SubmitTaskStateChangeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.SubmitTaskStateChange")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSubmitTaskStateChangeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateCapacityProvider struct {
}

func (*awsAwsjson11_serializeOpUpdateCapacityProvider) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateCapacityProvider) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCapacityProviderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateCapacityProvider")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateCapacityProviderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateCluster struct {
}

func (*awsAwsjson11_serializeOpUpdateCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateClusterSettings struct {
}

func (*awsAwsjson11_serializeOpUpdateClusterSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateClusterSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateClusterSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateClusterSettings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateClusterSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateContainerAgent struct {
}

func (*awsAwsjson11_serializeOpUpdateContainerAgent) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateContainerAgent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContainerAgentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateContainerAgent")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateContainerAgentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateContainerInstancesState struct {
}

func (*awsAwsjson11_serializeOpUpdateContainerInstancesState) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateContainerInstancesState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateContainerInstancesStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateContainerInstancesState")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateContainerInstancesStateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateService struct {
}

func (*awsAwsjson11_serializeOpUpdateService) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateService) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateServiceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateService")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateServiceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateServicePrimaryTaskSet struct {
}

func (*awsAwsjson11_serializeOpUpdateServicePrimaryTaskSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateServicePrimaryTaskSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateServicePrimaryTaskSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateServicePrimaryTaskSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateServicePrimaryTaskSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateTaskProtection struct {
}

func (*awsAwsjson11_serializeOpUpdateTaskProtection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateTaskProtection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTaskProtectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateTaskProtection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateTaskProtectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateTaskSet struct {
}

func (*awsAwsjson11_serializeOpUpdateTaskSet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateTaskSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTaskSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AmazonEC2ContainerServiceV20141113.UpdateTaskSet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateTaskSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAttachmentStateChange(v *types.AttachmentStateChange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachmentArn != nil {
		ok := object.Key("attachmentArn")
		ok.String(*v.AttachmentArn)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAttachmentStateChanges(v []types.AttachmentStateChange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAttachmentStateChange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAttribute(v *types.Attribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.TargetId != nil {
		ok := object.Key("targetId")
		ok.String(*v.TargetId)
	}

	if len(v.TargetType) > 0 {
		ok := object.Key("targetType")
		ok.String(string(v.TargetType))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAttributes(v []types.Attribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAutoScalingGroupProvider(v *types.AutoScalingGroupProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScalingGroupArn != nil {
		ok := object.Key("autoScalingGroupArn")
		ok.String(*v.AutoScalingGroupArn)
	}

	if v.ManagedScaling != nil {
		ok := object.Key("managedScaling")
		if err := awsAwsjson11_serializeDocumentManagedScaling(v.ManagedScaling, ok); err != nil {
			return err
		}
	}

	if len(v.ManagedTerminationProtection) > 0 {
		ok := object.Key("managedTerminationProtection")
		ok.String(string(v.ManagedTerminationProtection))
	}

	return nil
}

func awsAwsjson11_serializeDocumentAutoScalingGroupProviderUpdate(v *types.AutoScalingGroupProviderUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManagedScaling != nil {
		ok := object.Key("managedScaling")
		if err := awsAwsjson11_serializeDocumentManagedScaling(v.ManagedScaling, ok); err != nil {
			return err
		}
	}

	if len(v.ManagedTerminationProtection) > 0 {
		ok := object.Key("managedTerminationProtection")
		ok.String(string(v.ManagedTerminationProtection))
	}

	return nil
}

func awsAwsjson11_serializeDocumentAwsVpcConfiguration(v *types.AwsVpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AssignPublicIp) > 0 {
		ok := object.Key("assignPublicIp")
		ok.String(string(v.AssignPublicIp))
	}

	if v.SecurityGroups != nil {
		ok := object.Key("securityGroups")
		if err := awsAwsjson11_serializeDocumentStringList(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		ok := object.Key("subnets")
		if err := awsAwsjson11_serializeDocumentStringList(v.Subnets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCapacityProviderFieldList(v []types.CapacityProviderField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentCapacityProviderStrategy(v []types.CapacityProviderStrategyItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentCapacityProviderStrategyItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCapacityProviderStrategyItem(v *types.CapacityProviderStrategyItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Base != 0 {
		ok := object.Key("base")
		ok.Integer(v.Base)
	}

	if v.CapacityProvider != nil {
		ok := object.Key("capacityProvider")
		ok.String(*v.CapacityProvider)
	}

	if v.Weight != 0 {
		ok := object.Key("weight")
		ok.Integer(v.Weight)
	}

	return nil
}

func awsAwsjson11_serializeDocumentClusterConfiguration(v *types.ClusterConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecuteCommandConfiguration != nil {
		ok := object.Key("executeCommandConfiguration")
		if err := awsAwsjson11_serializeDocumentExecuteCommandConfiguration(v.ExecuteCommandConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentClusterFieldList(v []types.ClusterField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentClusterServiceConnectDefaultsRequest(v *types.ClusterServiceConnectDefaultsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Namespace != nil {
		ok := object.Key("namespace")
		ok.String(*v.Namespace)
	}

	return nil
}

func awsAwsjson11_serializeDocumentClusterSetting(v *types.ClusterSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentClusterSettings(v []types.ClusterSetting, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentClusterSetting(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCompatibilityList(v []types.Compatibility, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentContainerDefinition(v *types.ContainerDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("command")
		if err := awsAwsjson11_serializeDocumentStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Cpu != 0 {
		ok := object.Key("cpu")
		ok.Integer(v.Cpu)
	}

	if v.DependsOn != nil {
		ok := object.Key("dependsOn")
		if err := awsAwsjson11_serializeDocumentContainerDependencies(v.DependsOn, ok); err != nil {
			return err
		}
	}

	if v.DisableNetworking != nil {
		ok := object.Key("disableNetworking")
		ok.Boolean(*v.DisableNetworking)
	}

	if v.DnsSearchDomains != nil {
		ok := object.Key("dnsSearchDomains")
		if err := awsAwsjson11_serializeDocumentStringList(v.DnsSearchDomains, ok); err != nil {
			return err
		}
	}

	if v.DnsServers != nil {
		ok := object.Key("dnsServers")
		if err := awsAwsjson11_serializeDocumentStringList(v.DnsServers, ok); err != nil {
			return err
		}
	}

	if v.DockerLabels != nil {
		ok := object.Key("dockerLabels")
		if err := awsAwsjson11_serializeDocumentDockerLabelsMap(v.DockerLabels, ok); err != nil {
			return err
		}
	}

	if v.DockerSecurityOptions != nil {
		ok := object.Key("dockerSecurityOptions")
		if err := awsAwsjson11_serializeDocumentStringList(v.DockerSecurityOptions, ok); err != nil {
			return err
		}
	}

	if v.EntryPoint != nil {
		ok := object.Key("entryPoint")
		if err := awsAwsjson11_serializeDocumentStringList(v.EntryPoint, ok); err != nil {
			return err
		}
	}

	if v.Environment != nil {
		ok := object.Key("environment")
		if err := awsAwsjson11_serializeDocumentEnvironmentVariables(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.EnvironmentFiles != nil {
		ok := object.Key("environmentFiles")
		if err := awsAwsjson11_serializeDocumentEnvironmentFiles(v.EnvironmentFiles, ok); err != nil {
			return err
		}
	}

	if v.Essential != nil {
		ok := object.Key("essential")
		ok.Boolean(*v.Essential)
	}

	if v.ExtraHosts != nil {
		ok := object.Key("extraHosts")
		if err := awsAwsjson11_serializeDocumentHostEntryList(v.ExtraHosts, ok); err != nil {
			return err
		}
	}

	if v.FirelensConfiguration != nil {
		ok := object.Key("firelensConfiguration")
		if err := awsAwsjson11_serializeDocumentFirelensConfiguration(v.FirelensConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HealthCheck != nil {
		ok := object.Key("healthCheck")
		if err := awsAwsjson11_serializeDocumentHealthCheck(v.HealthCheck, ok); err != nil {
			return err
		}
	}

	if v.Hostname != nil {
		ok := object.Key("hostname")
		ok.String(*v.Hostname)
	}

	if v.Image != nil {
		ok := object.Key("image")
		ok.String(*v.Image)
	}

	if v.Interactive != nil {
		ok := object.Key("interactive")
		ok.Boolean(*v.Interactive)
	}

	if v.Links != nil {
		ok := object.Key("links")
		if err := awsAwsjson11_serializeDocumentStringList(v.Links, ok); err != nil {
			return err
		}
	}

	if v.LinuxParameters != nil {
		ok := object.Key("linuxParameters")
		if err := awsAwsjson11_serializeDocumentLinuxParameters(v.LinuxParameters, ok); err != nil {
			return err
		}
	}

	if v.LogConfiguration != nil {
		ok := object.Key("logConfiguration")
		if err := awsAwsjson11_serializeDocumentLogConfiguration(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Memory != nil {
		ok := object.Key("memory")
		ok.Integer(*v.Memory)
	}

	if v.MemoryReservation != nil {
		ok := object.Key("memoryReservation")
		ok.Integer(*v.MemoryReservation)
	}

	if v.MountPoints != nil {
		ok := object.Key("mountPoints")
		if err := awsAwsjson11_serializeDocumentMountPointList(v.MountPoints, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.PortMappings != nil {
		ok := object.Key("portMappings")
		if err := awsAwsjson11_serializeDocumentPortMappingList(v.PortMappings, ok); err != nil {
			return err
		}
	}

	if v.Privileged != nil {
		ok := object.Key("privileged")
		ok.Boolean(*v.Privileged)
	}

	if v.PseudoTerminal != nil {
		ok := object.Key("pseudoTerminal")
		ok.Boolean(*v.PseudoTerminal)
	}

	if v.ReadonlyRootFilesystem != nil {
		ok := object.Key("readonlyRootFilesystem")
		ok.Boolean(*v.ReadonlyRootFilesystem)
	}

	if v.RepositoryCredentials != nil {
		ok := object.Key("repositoryCredentials")
		if err := awsAwsjson11_serializeDocumentRepositoryCredentials(v.RepositoryCredentials, ok); err != nil {
			return err
		}
	}

	if v.ResourceRequirements != nil {
		ok := object.Key("resourceRequirements")
		if err := awsAwsjson11_serializeDocumentResourceRequirements(v.ResourceRequirements, ok); err != nil {
			return err
		}
	}

	if v.Secrets != nil {
		ok := object.Key("secrets")
		if err := awsAwsjson11_serializeDocumentSecretList(v.Secrets, ok); err != nil {
			return err
		}
	}

	if v.StartTimeout != nil {
		ok := object.Key("startTimeout")
		ok.Integer(*v.StartTimeout)
	}

	if v.StopTimeout != nil {
		ok := object.Key("stopTimeout")
		ok.Integer(*v.StopTimeout)
	}

	if v.SystemControls != nil {
		ok := object.Key("systemControls")
		if err := awsAwsjson11_serializeDocumentSystemControls(v.SystemControls, ok); err != nil {
			return err
		}
	}

	if v.Ulimits != nil {
		ok := object.Key("ulimits")
		if err := awsAwsjson11_serializeDocumentUlimitList(v.Ulimits, ok); err != nil {
			return err
		}
	}

	if v.User != nil {
		ok := object.Key("user")
		ok.String(*v.User)
	}

	if v.VolumesFrom != nil {
		ok := object.Key("volumesFrom")
		if err := awsAwsjson11_serializeDocumentVolumeFromList(v.VolumesFrom, ok); err != nil {
			return err
		}
	}

	if v.WorkingDirectory != nil {
		ok := object.Key("workingDirectory")
		ok.String(*v.WorkingDirectory)
	}

	return nil
}

func awsAwsjson11_serializeDocumentContainerDefinitions(v []types.ContainerDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentContainerDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentContainerDependencies(v []types.ContainerDependency, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentContainerDependency(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentContainerDependency(v *types.ContainerDependency, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Condition) > 0 {
		ok := object.Key("condition")
		ok.String(string(v.Condition))
	}

	if v.ContainerName != nil {
		ok := object.Key("containerName")
		ok.String(*v.ContainerName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentContainerInstanceFieldList(v []types.ContainerInstanceField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentContainerOverride(v *types.ContainerOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("command")
		if err := awsAwsjson11_serializeDocumentStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Cpu != nil {
		ok := object.Key("cpu")
		ok.Integer(*v.Cpu)
	}

	if v.Environment != nil {
		ok := object.Key("environment")
		if err := awsAwsjson11_serializeDocumentEnvironmentVariables(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.EnvironmentFiles != nil {
		ok := object.Key("environmentFiles")
		if err := awsAwsjson11_serializeDocumentEnvironmentFiles(v.EnvironmentFiles, ok); err != nil {
			return err
		}
	}

	if v.Memory != nil {
		ok := object.Key("memory")
		ok.Integer(*v.Memory)
	}

	if v.MemoryReservation != nil {
		ok := object.Key("memoryReservation")
		ok.Integer(*v.MemoryReservation)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.ResourceRequirements != nil {
		ok := object.Key("resourceRequirements")
		if err := awsAwsjson11_serializeDocumentResourceRequirements(v.ResourceRequirements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentContainerOverrides(v []types.ContainerOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentContainerOverride(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentContainerStateChange(v *types.ContainerStateChange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerName != nil {
		ok := object.Key("containerName")
		ok.String(*v.ContainerName)
	}

	if v.ExitCode != nil {
		ok := object.Key("exitCode")
		ok.Integer(*v.ExitCode)
	}

	if v.ImageDigest != nil {
		ok := object.Key("imageDigest")
		ok.String(*v.ImageDigest)
	}

	if v.NetworkBindings != nil {
		ok := object.Key("networkBindings")
		if err := awsAwsjson11_serializeDocumentNetworkBindings(v.NetworkBindings, ok); err != nil {
			return err
		}
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	if v.RuntimeId != nil {
		ok := object.Key("runtimeId")
		ok.String(*v.RuntimeId)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	return nil
}

func awsAwsjson11_serializeDocumentContainerStateChanges(v []types.ContainerStateChange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentContainerStateChange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDeploymentCircuitBreaker(v *types.DeploymentCircuitBreaker, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("enable")
		ok.Boolean(v.Enable)
	}

	{
		ok := object.Key("rollback")
		ok.Boolean(v.Rollback)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeploymentConfiguration(v *types.DeploymentConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeploymentCircuitBreaker != nil {
		ok := object.Key("deploymentCircuitBreaker")
		if err := awsAwsjson11_serializeDocumentDeploymentCircuitBreaker(v.DeploymentCircuitBreaker, ok); err != nil {
			return err
		}
	}

	if v.MaximumPercent != nil {
		ok := object.Key("maximumPercent")
		ok.Integer(*v.MaximumPercent)
	}

	if v.MinimumHealthyPercent != nil {
		ok := object.Key("minimumHealthyPercent")
		ok.Integer(*v.MinimumHealthyPercent)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeploymentController(v *types.DeploymentController, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDevice(v *types.Device, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("containerPath")
		ok.String(*v.ContainerPath)
	}

	if v.HostPath != nil {
		ok := object.Key("hostPath")
		ok.String(*v.HostPath)
	}

	if v.Permissions != nil {
		ok := object.Key("permissions")
		if err := awsAwsjson11_serializeDocumentDeviceCgroupPermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeviceCgroupPermissions(v []types.DeviceCgroupPermission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentDevicesList(v []types.Device, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDevice(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDockerLabelsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDockerVolumeConfiguration(v *types.DockerVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Autoprovision != nil {
		ok := object.Key("autoprovision")
		ok.Boolean(*v.Autoprovision)
	}

	if v.Driver != nil {
		ok := object.Key("driver")
		ok.String(*v.Driver)
	}

	if v.DriverOpts != nil {
		ok := object.Key("driverOpts")
		if err := awsAwsjson11_serializeDocumentStringMap(v.DriverOpts, ok); err != nil {
			return err
		}
	}

	if v.Labels != nil {
		ok := object.Key("labels")
		if err := awsAwsjson11_serializeDocumentStringMap(v.Labels, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeDocumentEFSAuthorizationConfig(v *types.EFSAuthorizationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessPointId != nil {
		ok := object.Key("accessPointId")
		ok.String(*v.AccessPointId)
	}

	if len(v.Iam) > 0 {
		ok := object.Key("iam")
		ok.String(string(v.Iam))
	}

	return nil
}

func awsAwsjson11_serializeDocumentEFSVolumeConfiguration(v *types.EFSVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizationConfig != nil {
		ok := object.Key("authorizationConfig")
		if err := awsAwsjson11_serializeDocumentEFSAuthorizationConfig(v.AuthorizationConfig, ok); err != nil {
			return err
		}
	}

	if v.FileSystemId != nil {
		ok := object.Key("fileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.RootDirectory != nil {
		ok := object.Key("rootDirectory")
		ok.String(*v.RootDirectory)
	}

	if len(v.TransitEncryption) > 0 {
		ok := object.Key("transitEncryption")
		ok.String(string(v.TransitEncryption))
	}

	if v.TransitEncryptionPort != nil {
		ok := object.Key("transitEncryptionPort")
		ok.Integer(*v.TransitEncryptionPort)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEnvironmentFile(v *types.EnvironmentFile, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEnvironmentFiles(v []types.EnvironmentFile, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentEnvironmentFile(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentEnvironmentVariables(v []types.KeyValuePair, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentKeyValuePair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentEphemeralStorage(v *types.EphemeralStorage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("sizeInGiB")
		ok.Integer(v.SizeInGiB)
	}

	return nil
}

func awsAwsjson11_serializeDocumentExecuteCommandConfiguration(v *types.ExecuteCommandConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LogConfiguration != nil {
		ok := object.Key("logConfiguration")
		if err := awsAwsjson11_serializeDocumentExecuteCommandLogConfiguration(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.Logging) > 0 {
		ok := object.Key("logging")
		ok.String(string(v.Logging))
	}

	return nil
}

func awsAwsjson11_serializeDocumentExecuteCommandLogConfiguration(v *types.ExecuteCommandLogConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchEncryptionEnabled {
		ok := object.Key("cloudWatchEncryptionEnabled")
		ok.Boolean(v.CloudWatchEncryptionEnabled)
	}

	if v.CloudWatchLogGroupName != nil {
		ok := object.Key("cloudWatchLogGroupName")
		ok.String(*v.CloudWatchLogGroupName)
	}

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3EncryptionEnabled {
		ok := object.Key("s3EncryptionEnabled")
		ok.Boolean(v.S3EncryptionEnabled)
	}

	if v.S3KeyPrefix != nil {
		ok := object.Key("s3KeyPrefix")
		ok.String(*v.S3KeyPrefix)
	}

	return nil
}

func awsAwsjson11_serializeDocumentFirelensConfiguration(v *types.FirelensConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Options != nil {
		ok := object.Key("options")
		if err := awsAwsjson11_serializeDocumentFirelensConfigurationOptionsMap(v.Options, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentFirelensConfigurationOptionsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentFSxWindowsFileServerAuthorizationConfig(v *types.FSxWindowsFileServerAuthorizationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CredentialsParameter != nil {
		ok := object.Key("credentialsParameter")
		ok.String(*v.CredentialsParameter)
	}

	if v.Domain != nil {
		ok := object.Key("domain")
		ok.String(*v.Domain)
	}

	return nil
}

func awsAwsjson11_serializeDocumentFSxWindowsFileServerVolumeConfiguration(v *types.FSxWindowsFileServerVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizationConfig != nil {
		ok := object.Key("authorizationConfig")
		if err := awsAwsjson11_serializeDocumentFSxWindowsFileServerAuthorizationConfig(v.AuthorizationConfig, ok); err != nil {
			return err
		}
	}

	if v.FileSystemId != nil {
		ok := object.Key("fileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.RootDirectory != nil {
		ok := object.Key("rootDirectory")
		ok.String(*v.RootDirectory)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHealthCheck(v *types.HealthCheck, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("command")
		if err := awsAwsjson11_serializeDocumentStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Interval != nil {
		ok := object.Key("interval")
		ok.Integer(*v.Interval)
	}

	if v.Retries != nil {
		ok := object.Key("retries")
		ok.Integer(*v.Retries)
	}

	if v.StartPeriod != nil {
		ok := object.Key("startPeriod")
		ok.Integer(*v.StartPeriod)
	}

	if v.Timeout != nil {
		ok := object.Key("timeout")
		ok.Integer(*v.Timeout)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHostEntry(v *types.HostEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Hostname != nil {
		ok := object.Key("hostname")
		ok.String(*v.Hostname)
	}

	if v.IpAddress != nil {
		ok := object.Key("ipAddress")
		ok.String(*v.IpAddress)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHostEntryList(v []types.HostEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentHostEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentHostVolumeProperties(v *types.HostVolumeProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourcePath != nil {
		ok := object.Key("sourcePath")
		ok.String(*v.SourcePath)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInferenceAccelerator(v *types.InferenceAccelerator, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceName != nil {
		ok := object.Key("deviceName")
		ok.String(*v.DeviceName)
	}

	if v.DeviceType != nil {
		ok := object.Key("deviceType")
		ok.String(*v.DeviceType)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInferenceAcceleratorOverride(v *types.InferenceAcceleratorOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceName != nil {
		ok := object.Key("deviceName")
		ok.String(*v.DeviceName)
	}

	if v.DeviceType != nil {
		ok := object.Key("deviceType")
		ok.String(*v.DeviceType)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInferenceAcceleratorOverrides(v []types.InferenceAcceleratorOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInferenceAcceleratorOverride(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentInferenceAccelerators(v []types.InferenceAccelerator, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInferenceAccelerator(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentKernelCapabilities(v *types.KernelCapabilities, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Add != nil {
		ok := object.Key("add")
		if err := awsAwsjson11_serializeDocumentStringList(v.Add, ok); err != nil {
			return err
		}
	}

	if v.Drop != nil {
		ok := object.Key("drop")
		if err := awsAwsjson11_serializeDocumentStringList(v.Drop, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentKeyValuePair(v *types.KeyValuePair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLinuxParameters(v *types.LinuxParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capabilities != nil {
		ok := object.Key("capabilities")
		if err := awsAwsjson11_serializeDocumentKernelCapabilities(v.Capabilities, ok); err != nil {
			return err
		}
	}

	if v.Devices != nil {
		ok := object.Key("devices")
		if err := awsAwsjson11_serializeDocumentDevicesList(v.Devices, ok); err != nil {
			return err
		}
	}

	if v.InitProcessEnabled != nil {
		ok := object.Key("initProcessEnabled")
		ok.Boolean(*v.InitProcessEnabled)
	}

	if v.MaxSwap != nil {
		ok := object.Key("maxSwap")
		ok.Integer(*v.MaxSwap)
	}

	if v.SharedMemorySize != nil {
		ok := object.Key("sharedMemorySize")
		ok.Integer(*v.SharedMemorySize)
	}

	if v.Swappiness != nil {
		ok := object.Key("swappiness")
		ok.Integer(*v.Swappiness)
	}

	if v.Tmpfs != nil {
		ok := object.Key("tmpfs")
		if err := awsAwsjson11_serializeDocumentTmpfsList(v.Tmpfs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentLoadBalancer(v *types.LoadBalancer, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerName != nil {
		ok := object.Key("containerName")
		ok.String(*v.ContainerName)
	}

	if v.ContainerPort != nil {
		ok := object.Key("containerPort")
		ok.Integer(*v.ContainerPort)
	}

	if v.LoadBalancerName != nil {
		ok := object.Key("loadBalancerName")
		ok.String(*v.LoadBalancerName)
	}

	if v.TargetGroupArn != nil {
		ok := object.Key("targetGroupArn")
		ok.String(*v.TargetGroupArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLoadBalancers(v []types.LoadBalancer, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentLogConfiguration(v *types.LogConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogDriver) > 0 {
		ok := object.Key("logDriver")
		ok.String(string(v.LogDriver))
	}

	if v.Options != nil {
		ok := object.Key("options")
		if err := awsAwsjson11_serializeDocumentLogConfigurationOptionsMap(v.Options, ok); err != nil {
			return err
		}
	}

	if v.SecretOptions != nil {
		ok := object.Key("secretOptions")
		if err := awsAwsjson11_serializeDocumentSecretList(v.SecretOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentLogConfigurationOptionsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentManagedAgentStateChange(v *types.ManagedAgentStateChange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerName != nil {
		ok := object.Key("containerName")
		ok.String(*v.ContainerName)
	}

	if len(v.ManagedAgentName) > 0 {
		ok := object.Key("managedAgentName")
		ok.String(string(v.ManagedAgentName))
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	return nil
}

func awsAwsjson11_serializeDocumentManagedAgentStateChanges(v []types.ManagedAgentStateChange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentManagedAgentStateChange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentManagedScaling(v *types.ManagedScaling, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceWarmupPeriod != nil {
		ok := object.Key("instanceWarmupPeriod")
		ok.Integer(*v.InstanceWarmupPeriod)
	}

	if v.MaximumScalingStepSize != nil {
		ok := object.Key("maximumScalingStepSize")
		ok.Integer(*v.MaximumScalingStepSize)
	}

	if v.MinimumScalingStepSize != nil {
		ok := object.Key("minimumScalingStepSize")
		ok.Integer(*v.MinimumScalingStepSize)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	if v.TargetCapacity != nil {
		ok := object.Key("targetCapacity")
		ok.Integer(*v.TargetCapacity)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMountPoint(v *types.MountPoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("containerPath")
		ok.String(*v.ContainerPath)
	}

	if v.ReadOnly != nil {
		ok := object.Key("readOnly")
		ok.Boolean(*v.ReadOnly)
	}

	if v.SourceVolume != nil {
		ok := object.Key("sourceVolume")
		ok.String(*v.SourceVolume)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMountPointList(v []types.MountPoint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentMountPoint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentNetworkBinding(v *types.NetworkBinding, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindIP != nil {
		ok := object.Key("bindIP")
		ok.String(*v.BindIP)
	}

	if v.ContainerPort != nil {
		ok := object.Key("containerPort")
		ok.Integer(*v.ContainerPort)
	}

	if v.ContainerPortRange != nil {
		ok := object.Key("containerPortRange")
		ok.String(*v.ContainerPortRange)
	}

	if v.HostPort != nil {
		ok := object.Key("hostPort")
		ok.Integer(*v.HostPort)
	}

	if v.HostPortRange != nil {
		ok := object.Key("hostPortRange")
		ok.String(*v.HostPortRange)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}

func awsAwsjson11_serializeDocumentNetworkBindings(v []types.NetworkBinding, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentNetworkBinding(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentNetworkConfiguration(v *types.NetworkConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsvpcConfiguration != nil {
		ok := object.Key("awsvpcConfiguration")
		if err := awsAwsjson11_serializeDocumentAwsVpcConfiguration(v.AwsvpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlacementConstraint(v *types.PlacementConstraint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("expression")
		ok.String(*v.Expression)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlacementConstraints(v []types.PlacementConstraint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPlacementConstraint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlacementStrategies(v []types.PlacementStrategy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPlacementStrategy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlacementStrategy(v *types.PlacementStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlatformDevice(v *types.PlatformDevice, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlatformDevices(v []types.PlatformDevice, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPlatformDevice(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPortMapping(v *types.PortMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AppProtocol) > 0 {
		ok := object.Key("appProtocol")
		ok.String(string(v.AppProtocol))
	}

	if v.ContainerPort != nil {
		ok := object.Key("containerPort")
		ok.Integer(*v.ContainerPort)
	}

	if v.ContainerPortRange != nil {
		ok := object.Key("containerPortRange")
		ok.String(*v.ContainerPortRange)
	}

	if v.HostPort != nil {
		ok := object.Key("hostPort")
		ok.Integer(*v.HostPort)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("protocol")
		ok.String(string(v.Protocol))
	}

	return nil
}

func awsAwsjson11_serializeDocumentPortMappingList(v []types.PortMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPortMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentProxyConfiguration(v *types.ProxyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerName != nil {
		ok := object.Key("containerName")
		ok.String(*v.ContainerName)
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsAwsjson11_serializeDocumentProxyConfigurationProperties(v.Properties, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentProxyConfigurationProperties(v []types.KeyValuePair, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentKeyValuePair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRepositoryCredentials(v *types.RepositoryCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CredentialsParameter != nil {
		ok := object.Key("credentialsParameter")
		ok.String(*v.CredentialsParameter)
	}

	return nil
}

func awsAwsjson11_serializeDocumentResource(v *types.Resource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DoubleValue != 0 {
		ok := object.Key("doubleValue")
		switch {
		case math.IsNaN(v.DoubleValue):
			ok.String("NaN")

		case math.IsInf(v.DoubleValue, 1):
			ok.String("Infinity")

		case math.IsInf(v.DoubleValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.DoubleValue)

		}
	}

	if v.IntegerValue != 0 {
		ok := object.Key("integerValue")
		ok.Integer(v.IntegerValue)
	}

	if v.LongValue != 0 {
		ok := object.Key("longValue")
		ok.Long(v.LongValue)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.StringSetValue != nil {
		ok := object.Key("stringSetValue")
		if err := awsAwsjson11_serializeDocumentStringList(v.StringSetValue, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsAwsjson11_serializeDocumentResourceRequirement(v *types.ResourceRequirement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentResourceRequirements(v []types.ResourceRequirement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentResourceRequirement(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentResources(v []types.Resource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentResource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentRuntimePlatform(v *types.RuntimePlatform, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CpuArchitecture) > 0 {
		ok := object.Key("cpuArchitecture")
		ok.String(string(v.CpuArchitecture))
	}

	if len(v.OperatingSystemFamily) > 0 {
		ok := object.Key("operatingSystemFamily")
		ok.String(string(v.OperatingSystemFamily))
	}

	return nil
}

func awsAwsjson11_serializeDocumentScale(v *types.Scale, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	if v.Value != 0 {
		ok := object.Key("value")
		switch {
		case math.IsNaN(v.Value):
			ok.String("NaN")

		case math.IsInf(v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(v.Value)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSecret(v *types.Secret, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.ValueFrom != nil {
		ok := object.Key("valueFrom")
		ok.String(*v.ValueFrom)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSecretList(v []types.Secret, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSecret(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentServiceConnectClientAlias(v *types.ServiceConnectClientAlias, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DnsName != nil {
		ok := object.Key("dnsName")
		ok.String(*v.DnsName)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	return nil
}

func awsAwsjson11_serializeDocumentServiceConnectClientAliasList(v []types.ServiceConnectClientAlias, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentServiceConnectClientAlias(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentServiceConnectConfiguration(v *types.ServiceConnectConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.LogConfiguration != nil {
		ok := object.Key("logConfiguration")
		if err := awsAwsjson11_serializeDocumentLogConfiguration(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		ok := object.Key("namespace")
		ok.String(*v.Namespace)
	}

	if v.Services != nil {
		ok := object.Key("services")
		if err := awsAwsjson11_serializeDocumentServiceConnectServiceList(v.Services, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentServiceConnectService(v *types.ServiceConnectService, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientAliases != nil {
		ok := object.Key("clientAliases")
		if err := awsAwsjson11_serializeDocumentServiceConnectClientAliasList(v.ClientAliases, ok); err != nil {
			return err
		}
	}

	if v.DiscoveryName != nil {
		ok := object.Key("discoveryName")
		ok.String(*v.DiscoveryName)
	}

	if v.IngressPortOverride != nil {
		ok := object.Key("ingressPortOverride")
		ok.Integer(*v.IngressPortOverride)
	}

	if v.PortName != nil {
		ok := object.Key("portName")
		ok.String(*v.PortName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentServiceConnectServiceList(v []types.ServiceConnectService, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentServiceConnectService(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentServiceFieldList(v []types.ServiceField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentServiceRegistries(v []types.ServiceRegistry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentServiceRegistry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentServiceRegistry(v *types.ServiceRegistry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerName != nil {
		ok := object.Key("containerName")
		ok.String(*v.ContainerName)
	}

	if v.ContainerPort != nil {
		ok := object.Key("containerPort")
		ok.Integer(*v.ContainerPort)
	}

	if v.Port != nil {
		ok := object.Key("port")
		ok.Integer(*v.Port)
	}

	if v.RegistryArn != nil {
		ok := object.Key("registryArn")
		ok.String(*v.RegistryArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentStringMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSystemControl(v *types.SystemControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Namespace != nil {
		ok := object.Key("namespace")
		ok.String(*v.Namespace)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSystemControls(v []types.SystemControl, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSystemControl(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTags(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTaskDefinitionFieldList(v []types.TaskDefinitionField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentTaskDefinitionPlacementConstraint(v *types.TaskDefinitionPlacementConstraint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("expression")
		ok.String(*v.Expression)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTaskDefinitionPlacementConstraints(v []types.TaskDefinitionPlacementConstraint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTaskDefinitionPlacementConstraint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTaskFieldList(v []types.TaskField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentTaskOverride(v *types.TaskOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerOverrides != nil {
		ok := object.Key("containerOverrides")
		if err := awsAwsjson11_serializeDocumentContainerOverrides(v.ContainerOverrides, ok); err != nil {
			return err
		}
	}

	if v.Cpu != nil {
		ok := object.Key("cpu")
		ok.String(*v.Cpu)
	}

	if v.EphemeralStorage != nil {
		ok := object.Key("ephemeralStorage")
		if err := awsAwsjson11_serializeDocumentEphemeralStorage(v.EphemeralStorage, ok); err != nil {
			return err
		}
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("executionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.InferenceAcceleratorOverrides != nil {
		ok := object.Key("inferenceAcceleratorOverrides")
		if err := awsAwsjson11_serializeDocumentInferenceAcceleratorOverrides(v.InferenceAcceleratorOverrides, ok); err != nil {
			return err
		}
	}

	if v.Memory != nil {
		ok := object.Key("memory")
		ok.String(*v.Memory)
	}

	if v.TaskRoleArn != nil {
		ok := object.Key("taskRoleArn")
		ok.String(*v.TaskRoleArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTaskSetFieldList(v []types.TaskSetField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentTmpfs(v *types.Tmpfs, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("containerPath")
		ok.String(*v.ContainerPath)
	}

	if v.MountOptions != nil {
		ok := object.Key("mountOptions")
		if err := awsAwsjson11_serializeDocumentStringList(v.MountOptions, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("size")
		ok.Integer(v.Size)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTmpfsList(v []types.Tmpfs, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTmpfs(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentUlimit(v *types.Ulimit, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("hardLimit")
		ok.Integer(v.HardLimit)
	}

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	{
		ok := object.Key("softLimit")
		ok.Integer(v.SoftLimit)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUlimitList(v []types.Ulimit, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentUlimit(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentVersionInfo(v *types.VersionInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AgentHash != nil {
		ok := object.Key("agentHash")
		ok.String(*v.AgentHash)
	}

	if v.AgentVersion != nil {
		ok := object.Key("agentVersion")
		ok.String(*v.AgentVersion)
	}

	if v.DockerVersion != nil {
		ok := object.Key("dockerVersion")
		ok.String(*v.DockerVersion)
	}

	return nil
}

func awsAwsjson11_serializeDocumentVolume(v *types.Volume, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DockerVolumeConfiguration != nil {
		ok := object.Key("dockerVolumeConfiguration")
		if err := awsAwsjson11_serializeDocumentDockerVolumeConfiguration(v.DockerVolumeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EfsVolumeConfiguration != nil {
		ok := object.Key("efsVolumeConfiguration")
		if err := awsAwsjson11_serializeDocumentEFSVolumeConfiguration(v.EfsVolumeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FsxWindowsFileServerVolumeConfiguration != nil {
		ok := object.Key("fsxWindowsFileServerVolumeConfiguration")
		if err := awsAwsjson11_serializeDocumentFSxWindowsFileServerVolumeConfiguration(v.FsxWindowsFileServerVolumeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Host != nil {
		ok := object.Key("host")
		if err := awsAwsjson11_serializeDocumentHostVolumeProperties(v.Host, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentVolumeFrom(v *types.VolumeFrom, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReadOnly != nil {
		ok := object.Key("readOnly")
		ok.Boolean(*v.ReadOnly)
	}

	if v.SourceContainer != nil {
		ok := object.Key("sourceContainer")
		ok.String(*v.SourceContainer)
	}

	return nil
}

func awsAwsjson11_serializeDocumentVolumeFromList(v []types.VolumeFrom, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentVolumeFrom(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentVolumeList(v []types.Volume, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentVolume(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentCreateCapacityProviderInput(v *CreateCapacityProviderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScalingGroupProvider != nil {
		ok := object.Key("autoScalingGroupProvider")
		if err := awsAwsjson11_serializeDocumentAutoScalingGroupProvider(v.AutoScalingGroupProvider, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateClusterInput(v *CreateClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviders != nil {
		ok := object.Key("capacityProviders")
		if err := awsAwsjson11_serializeDocumentStringList(v.CapacityProviders, ok); err != nil {
			return err
		}
	}

	if v.ClusterName != nil {
		ok := object.Key("clusterName")
		ok.String(*v.ClusterName)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsAwsjson11_serializeDocumentClusterConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.DefaultCapacityProviderStrategy != nil {
		ok := object.Key("defaultCapacityProviderStrategy")
		if err := awsAwsjson11_serializeDocumentCapacityProviderStrategy(v.DefaultCapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	if v.ServiceConnectDefaults != nil {
		ok := object.Key("serviceConnectDefaults")
		if err := awsAwsjson11_serializeDocumentClusterServiceConnectDefaultsRequest(v.ServiceConnectDefaults, ok); err != nil {
			return err
		}
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsAwsjson11_serializeDocumentClusterSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateServiceInput(v *CreateServiceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviderStrategy != nil {
		ok := object.Key("capacityProviderStrategy")
		if err := awsAwsjson11_serializeDocumentCapacityProviderStrategy(v.CapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.DeploymentConfiguration != nil {
		ok := object.Key("deploymentConfiguration")
		if err := awsAwsjson11_serializeDocumentDeploymentConfiguration(v.DeploymentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DeploymentController != nil {
		ok := object.Key("deploymentController")
		if err := awsAwsjson11_serializeDocumentDeploymentController(v.DeploymentController, ok); err != nil {
			return err
		}
	}

	if v.DesiredCount != nil {
		ok := object.Key("desiredCount")
		ok.Integer(*v.DesiredCount)
	}

	if v.EnableECSManagedTags {
		ok := object.Key("enableECSManagedTags")
		ok.Boolean(v.EnableECSManagedTags)
	}

	if v.EnableExecuteCommand {
		ok := object.Key("enableExecuteCommand")
		ok.Boolean(v.EnableExecuteCommand)
	}

	if v.HealthCheckGracePeriodSeconds != nil {
		ok := object.Key("healthCheckGracePeriodSeconds")
		ok.Integer(*v.HealthCheckGracePeriodSeconds)
	}

	if len(v.LaunchType) > 0 {
		ok := object.Key("launchType")
		ok.String(string(v.LaunchType))
	}

	if v.LoadBalancers != nil {
		ok := object.Key("loadBalancers")
		if err := awsAwsjson11_serializeDocumentLoadBalancers(v.LoadBalancers, ok); err != nil {
			return err
		}
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("networkConfiguration")
		if err := awsAwsjson11_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PlacementConstraints != nil {
		ok := object.Key("placementConstraints")
		if err := awsAwsjson11_serializeDocumentPlacementConstraints(v.PlacementConstraints, ok); err != nil {
			return err
		}
	}

	if v.PlacementStrategy != nil {
		ok := object.Key("placementStrategy")
		if err := awsAwsjson11_serializeDocumentPlacementStrategies(v.PlacementStrategy, ok); err != nil {
			return err
		}
	}

	if v.PlatformVersion != nil {
		ok := object.Key("platformVersion")
		ok.String(*v.PlatformVersion)
	}

	if len(v.PropagateTags) > 0 {
		ok := object.Key("propagateTags")
		ok.String(string(v.PropagateTags))
	}

	if v.Role != nil {
		ok := object.Key("role")
		ok.String(*v.Role)
	}

	if len(v.SchedulingStrategy) > 0 {
		ok := object.Key("schedulingStrategy")
		ok.String(string(v.SchedulingStrategy))
	}

	if v.ServiceConnectConfiguration != nil {
		ok := object.Key("serviceConnectConfiguration")
		if err := awsAwsjson11_serializeDocumentServiceConnectConfiguration(v.ServiceConnectConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	if v.ServiceRegistries != nil {
		ok := object.Key("serviceRegistries")
		if err := awsAwsjson11_serializeDocumentServiceRegistries(v.ServiceRegistries, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TaskDefinition != nil {
		ok := object.Key("taskDefinition")
		ok.String(*v.TaskDefinition)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateTaskSetInput(v *CreateTaskSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviderStrategy != nil {
		ok := object.Key("capacityProviderStrategy")
		if err := awsAwsjson11_serializeDocumentCapacityProviderStrategy(v.CapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ExternalId != nil {
		ok := object.Key("externalId")
		ok.String(*v.ExternalId)
	}

	if len(v.LaunchType) > 0 {
		ok := object.Key("launchType")
		ok.String(string(v.LaunchType))
	}

	if v.LoadBalancers != nil {
		ok := object.Key("loadBalancers")
		if err := awsAwsjson11_serializeDocumentLoadBalancers(v.LoadBalancers, ok); err != nil {
			return err
		}
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("networkConfiguration")
		if err := awsAwsjson11_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PlatformVersion != nil {
		ok := object.Key("platformVersion")
		ok.String(*v.PlatformVersion)
	}

	if v.Scale != nil {
		ok := object.Key("scale")
		if err := awsAwsjson11_serializeDocumentScale(v.Scale, ok); err != nil {
			return err
		}
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	if v.ServiceRegistries != nil {
		ok := object.Key("serviceRegistries")
		if err := awsAwsjson11_serializeDocumentServiceRegistries(v.ServiceRegistries, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TaskDefinition != nil {
		ok := object.Key("taskDefinition")
		ok.String(*v.TaskDefinition)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteAccountSettingInput(v *DeleteAccountSettingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.PrincipalArn != nil {
		ok := object.Key("principalArn")
		ok.String(*v.PrincipalArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteAttributesInput(v *DeleteAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsAwsjson11_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteCapacityProviderInput(v *DeleteCapacityProviderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProvider != nil {
		ok := object.Key("capacityProvider")
		ok.String(*v.CapacityProvider)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteClusterInput(v *DeleteClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteServiceInput(v *DeleteServiceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Force != nil {
		ok := object.Key("force")
		ok.Boolean(*v.Force)
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteTaskSetInput(v *DeleteTaskSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Force != nil {
		ok := object.Key("force")
		ok.Boolean(*v.Force)
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	if v.TaskSet != nil {
		ok := object.Key("taskSet")
		ok.String(*v.TaskSet)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeregisterContainerInstanceInput(v *DeregisterContainerInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerInstance != nil {
		ok := object.Key("containerInstance")
		ok.String(*v.ContainerInstance)
	}

	if v.Force != nil {
		ok := object.Key("force")
		ok.Boolean(*v.Force)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeregisterTaskDefinitionInput(v *DeregisterTaskDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TaskDefinition != nil {
		ok := object.Key("taskDefinition")
		ok.String(*v.TaskDefinition)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeCapacityProvidersInput(v *DescribeCapacityProvidersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviders != nil {
		ok := object.Key("capacityProviders")
		if err := awsAwsjson11_serializeDocumentStringList(v.CapacityProviders, ok); err != nil {
			return err
		}
	}

	if v.Include != nil {
		ok := object.Key("include")
		if err := awsAwsjson11_serializeDocumentCapacityProviderFieldList(v.Include, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeClustersInput(v *DescribeClustersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Clusters != nil {
		ok := object.Key("clusters")
		if err := awsAwsjson11_serializeDocumentStringList(v.Clusters, ok); err != nil {
			return err
		}
	}

	if v.Include != nil {
		ok := object.Key("include")
		if err := awsAwsjson11_serializeDocumentClusterFieldList(v.Include, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeContainerInstancesInput(v *DescribeContainerInstancesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerInstances != nil {
		ok := object.Key("containerInstances")
		if err := awsAwsjson11_serializeDocumentStringList(v.ContainerInstances, ok); err != nil {
			return err
		}
	}

	if v.Include != nil {
		ok := object.Key("include")
		if err := awsAwsjson11_serializeDocumentContainerInstanceFieldList(v.Include, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeServicesInput(v *DescribeServicesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Include != nil {
		ok := object.Key("include")
		if err := awsAwsjson11_serializeDocumentServiceFieldList(v.Include, ok); err != nil {
			return err
		}
	}

	if v.Services != nil {
		ok := object.Key("services")
		if err := awsAwsjson11_serializeDocumentStringList(v.Services, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeTaskDefinitionInput(v *DescribeTaskDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Include != nil {
		ok := object.Key("include")
		if err := awsAwsjson11_serializeDocumentTaskDefinitionFieldList(v.Include, ok); err != nil {
			return err
		}
	}

	if v.TaskDefinition != nil {
		ok := object.Key("taskDefinition")
		ok.String(*v.TaskDefinition)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeTaskSetsInput(v *DescribeTaskSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Include != nil {
		ok := object.Key("include")
		if err := awsAwsjson11_serializeDocumentTaskSetFieldList(v.Include, ok); err != nil {
			return err
		}
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	if v.TaskSets != nil {
		ok := object.Key("taskSets")
		if err := awsAwsjson11_serializeDocumentStringList(v.TaskSets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeTasksInput(v *DescribeTasksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Include != nil {
		ok := object.Key("include")
		if err := awsAwsjson11_serializeDocumentTaskFieldList(v.Include, ok); err != nil {
			return err
		}
	}

	if v.Tasks != nil {
		ok := object.Key("tasks")
		if err := awsAwsjson11_serializeDocumentStringList(v.Tasks, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDiscoverPollEndpointInput(v *DiscoverPollEndpointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerInstance != nil {
		ok := object.Key("containerInstance")
		ok.String(*v.ContainerInstance)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentExecuteCommandInput(v *ExecuteCommandInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Command != nil {
		ok := object.Key("command")
		ok.String(*v.Command)
	}

	if v.Container != nil {
		ok := object.Key("container")
		ok.String(*v.Container)
	}

	{
		ok := object.Key("interactive")
		ok.Boolean(v.Interactive)
	}

	if v.Task != nil {
		ok := object.Key("task")
		ok.String(*v.Task)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTaskProtectionInput(v *GetTaskProtectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Tasks != nil {
		ok := object.Key("tasks")
		if err := awsAwsjson11_serializeDocumentStringList(v.Tasks, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListAccountSettingsInput(v *ListAccountSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EffectiveSettings {
		ok := object.Key("effectiveSettings")
		ok.Boolean(v.EffectiveSettings)
	}

	if v.MaxResults != 0 {
		ok := object.Key("maxResults")
		ok.Integer(v.MaxResults)
	}

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.PrincipalArn != nil {
		ok := object.Key("principalArn")
		ok.String(*v.PrincipalArn)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListAttributesInput(v *ListAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("attributeName")
		ok.String(*v.AttributeName)
	}

	if v.AttributeValue != nil {
		ok := object.Key("attributeValue")
		ok.String(*v.AttributeValue)
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.TargetType) > 0 {
		ok := object.Key("targetType")
		ok.String(string(v.TargetType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListClustersInput(v *ListClustersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListContainerInstancesInput(v *ListContainerInstancesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Filter != nil {
		ok := object.Key("filter")
		ok.String(*v.Filter)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListServicesByNamespaceInput(v *ListServicesByNamespaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Namespace != nil {
		ok := object.Key("namespace")
		ok.String(*v.Namespace)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListServicesInput(v *ListServicesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if len(v.LaunchType) > 0 {
		ok := object.Key("launchType")
		ok.String(string(v.LaunchType))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SchedulingStrategy) > 0 {
		ok := object.Key("schedulingStrategy")
		ok.String(string(v.SchedulingStrategy))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTaskDefinitionFamiliesInput(v *ListTaskDefinitionFamiliesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FamilyPrefix != nil {
		ok := object.Key("familyPrefix")
		ok.String(*v.FamilyPrefix)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTaskDefinitionsInput(v *ListTaskDefinitionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FamilyPrefix != nil {
		ok := object.Key("familyPrefix")
		ok.String(*v.FamilyPrefix)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Sort) > 0 {
		ok := object.Key("sort")
		ok.String(string(v.Sort))
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTasksInput(v *ListTasksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerInstance != nil {
		ok := object.Key("containerInstance")
		ok.String(*v.ContainerInstance)
	}

	if len(v.DesiredStatus) > 0 {
		ok := object.Key("desiredStatus")
		ok.String(string(v.DesiredStatus))
	}

	if v.Family != nil {
		ok := object.Key("family")
		ok.String(*v.Family)
	}

	if len(v.LaunchType) > 0 {
		ok := object.Key("launchType")
		ok.String(string(v.LaunchType))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	if v.StartedBy != nil {
		ok := object.Key("startedBy")
		ok.String(*v.StartedBy)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutAccountSettingDefaultInput(v *PutAccountSettingDefaultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutAccountSettingInput(v *PutAccountSettingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.PrincipalArn != nil {
		ok := object.Key("principalArn")
		ok.String(*v.PrincipalArn)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutAttributesInput(v *PutAttributesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsAwsjson11_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutClusterCapacityProvidersInput(v *PutClusterCapacityProvidersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviders != nil {
		ok := object.Key("capacityProviders")
		if err := awsAwsjson11_serializeDocumentStringList(v.CapacityProviders, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.DefaultCapacityProviderStrategy != nil {
		ok := object.Key("defaultCapacityProviderStrategy")
		if err := awsAwsjson11_serializeDocumentCapacityProviderStrategy(v.DefaultCapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRegisterContainerInstanceInput(v *RegisterContainerInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsAwsjson11_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerInstanceArn != nil {
		ok := object.Key("containerInstanceArn")
		ok.String(*v.ContainerInstanceArn)
	}

	if v.InstanceIdentityDocument != nil {
		ok := object.Key("instanceIdentityDocument")
		ok.String(*v.InstanceIdentityDocument)
	}

	if v.InstanceIdentityDocumentSignature != nil {
		ok := object.Key("instanceIdentityDocumentSignature")
		ok.String(*v.InstanceIdentityDocumentSignature)
	}

	if v.PlatformDevices != nil {
		ok := object.Key("platformDevices")
		if err := awsAwsjson11_serializeDocumentPlatformDevices(v.PlatformDevices, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TotalResources != nil {
		ok := object.Key("totalResources")
		if err := awsAwsjson11_serializeDocumentResources(v.TotalResources, ok); err != nil {
			return err
		}
	}

	if v.VersionInfo != nil {
		ok := object.Key("versionInfo")
		if err := awsAwsjson11_serializeDocumentVersionInfo(v.VersionInfo, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRegisterTaskDefinitionInput(v *RegisterTaskDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerDefinitions != nil {
		ok := object.Key("containerDefinitions")
		if err := awsAwsjson11_serializeDocumentContainerDefinitions(v.ContainerDefinitions, ok); err != nil {
			return err
		}
	}

	if v.Cpu != nil {
		ok := object.Key("cpu")
		ok.String(*v.Cpu)
	}

	if v.EphemeralStorage != nil {
		ok := object.Key("ephemeralStorage")
		if err := awsAwsjson11_serializeDocumentEphemeralStorage(v.EphemeralStorage, ok); err != nil {
			return err
		}
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("executionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.Family != nil {
		ok := object.Key("family")
		ok.String(*v.Family)
	}

	if v.InferenceAccelerators != nil {
		ok := object.Key("inferenceAccelerators")
		if err := awsAwsjson11_serializeDocumentInferenceAccelerators(v.InferenceAccelerators, ok); err != nil {
			return err
		}
	}

	if len(v.IpcMode) > 0 {
		ok := object.Key("ipcMode")
		ok.String(string(v.IpcMode))
	}

	if v.Memory != nil {
		ok := object.Key("memory")
		ok.String(*v.Memory)
	}

	if len(v.NetworkMode) > 0 {
		ok := object.Key("networkMode")
		ok.String(string(v.NetworkMode))
	}

	if len(v.PidMode) > 0 {
		ok := object.Key("pidMode")
		ok.String(string(v.PidMode))
	}

	if v.PlacementConstraints != nil {
		ok := object.Key("placementConstraints")
		if err := awsAwsjson11_serializeDocumentTaskDefinitionPlacementConstraints(v.PlacementConstraints, ok); err != nil {
			return err
		}
	}

	if v.ProxyConfiguration != nil {
		ok := object.Key("proxyConfiguration")
		if err := awsAwsjson11_serializeDocumentProxyConfiguration(v.ProxyConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RequiresCompatibilities != nil {
		ok := object.Key("requiresCompatibilities")
		if err := awsAwsjson11_serializeDocumentCompatibilityList(v.RequiresCompatibilities, ok); err != nil {
			return err
		}
	}

	if v.RuntimePlatform != nil {
		ok := object.Key("runtimePlatform")
		if err := awsAwsjson11_serializeDocumentRuntimePlatform(v.RuntimePlatform, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TaskRoleArn != nil {
		ok := object.Key("taskRoleArn")
		ok.String(*v.TaskRoleArn)
	}

	if v.Volumes != nil {
		ok := object.Key("volumes")
		if err := awsAwsjson11_serializeDocumentVolumeList(v.Volumes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRunTaskInput(v *RunTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviderStrategy != nil {
		ok := object.Key("capacityProviderStrategy")
		if err := awsAwsjson11_serializeDocumentCapacityProviderStrategy(v.CapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Count != nil {
		ok := object.Key("count")
		ok.Integer(*v.Count)
	}

	if v.EnableECSManagedTags {
		ok := object.Key("enableECSManagedTags")
		ok.Boolean(v.EnableECSManagedTags)
	}

	if v.EnableExecuteCommand {
		ok := object.Key("enableExecuteCommand")
		ok.Boolean(v.EnableExecuteCommand)
	}

	if v.Group != nil {
		ok := object.Key("group")
		ok.String(*v.Group)
	}

	if len(v.LaunchType) > 0 {
		ok := object.Key("launchType")
		ok.String(string(v.LaunchType))
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("networkConfiguration")
		if err := awsAwsjson11_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsAwsjson11_serializeDocumentTaskOverride(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.PlacementConstraints != nil {
		ok := object.Key("placementConstraints")
		if err := awsAwsjson11_serializeDocumentPlacementConstraints(v.PlacementConstraints, ok); err != nil {
			return err
		}
	}

	if v.PlacementStrategy != nil {
		ok := object.Key("placementStrategy")
		if err := awsAwsjson11_serializeDocumentPlacementStrategies(v.PlacementStrategy, ok); err != nil {
			return err
		}
	}

	if v.PlatformVersion != nil {
		ok := object.Key("platformVersion")
		ok.String(*v.PlatformVersion)
	}

	if len(v.PropagateTags) > 0 {
		ok := object.Key("propagateTags")
		ok.String(string(v.PropagateTags))
	}

	if v.ReferenceId != nil {
		ok := object.Key("referenceId")
		ok.String(*v.ReferenceId)
	}

	if v.StartedBy != nil {
		ok := object.Key("startedBy")
		ok.String(*v.StartedBy)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TaskDefinition != nil {
		ok := object.Key("taskDefinition")
		ok.String(*v.TaskDefinition)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartTaskInput(v *StartTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerInstances != nil {
		ok := object.Key("containerInstances")
		if err := awsAwsjson11_serializeDocumentStringList(v.ContainerInstances, ok); err != nil {
			return err
		}
	}

	if v.EnableECSManagedTags {
		ok := object.Key("enableECSManagedTags")
		ok.Boolean(v.EnableECSManagedTags)
	}

	if v.EnableExecuteCommand {
		ok := object.Key("enableExecuteCommand")
		ok.Boolean(v.EnableExecuteCommand)
	}

	if v.Group != nil {
		ok := object.Key("group")
		ok.String(*v.Group)
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("networkConfiguration")
		if err := awsAwsjson11_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsAwsjson11_serializeDocumentTaskOverride(v.Overrides, ok); err != nil {
			return err
		}
	}

	if len(v.PropagateTags) > 0 {
		ok := object.Key("propagateTags")
		ok.String(string(v.PropagateTags))
	}

	if v.ReferenceId != nil {
		ok := object.Key("referenceId")
		ok.String(*v.ReferenceId)
	}

	if v.StartedBy != nil {
		ok := object.Key("startedBy")
		ok.String(*v.StartedBy)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TaskDefinition != nil {
		ok := object.Key("taskDefinition")
		ok.String(*v.TaskDefinition)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopTaskInput(v *StopTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	if v.Task != nil {
		ok := object.Key("task")
		ok.String(*v.Task)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSubmitAttachmentStateChangesInput(v *SubmitAttachmentStateChangesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attachments != nil {
		ok := object.Key("attachments")
		if err := awsAwsjson11_serializeDocumentAttachmentStateChanges(v.Attachments, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSubmitContainerStateChangeInput(v *SubmitContainerStateChangeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerName != nil {
		ok := object.Key("containerName")
		ok.String(*v.ContainerName)
	}

	if v.ExitCode != nil {
		ok := object.Key("exitCode")
		ok.Integer(*v.ExitCode)
	}

	if v.NetworkBindings != nil {
		ok := object.Key("networkBindings")
		if err := awsAwsjson11_serializeDocumentNetworkBindings(v.NetworkBindings, ok); err != nil {
			return err
		}
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	if v.RuntimeId != nil {
		ok := object.Key("runtimeId")
		ok.String(*v.RuntimeId)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	if v.Task != nil {
		ok := object.Key("task")
		ok.String(*v.Task)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSubmitTaskStateChangeInput(v *SubmitTaskStateChangeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attachments != nil {
		ok := object.Key("attachments")
		if err := awsAwsjson11_serializeDocumentAttachmentStateChanges(v.Attachments, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Containers != nil {
		ok := object.Key("containers")
		if err := awsAwsjson11_serializeDocumentContainerStateChanges(v.Containers, ok); err != nil {
			return err
		}
	}

	if v.ExecutionStoppedAt != nil {
		ok := object.Key("executionStoppedAt")
		ok.Double(smithytime.FormatEpochSeconds(*v.ExecutionStoppedAt))
	}

	if v.ManagedAgents != nil {
		ok := object.Key("managedAgents")
		if err := awsAwsjson11_serializeDocumentManagedAgentStateChanges(v.ManagedAgents, ok); err != nil {
			return err
		}
	}

	if v.PullStartedAt != nil {
		ok := object.Key("pullStartedAt")
		ok.Double(smithytime.FormatEpochSeconds(*v.PullStartedAt))
	}

	if v.PullStoppedAt != nil {
		ok := object.Key("pullStoppedAt")
		ok.Double(smithytime.FormatEpochSeconds(*v.PullStoppedAt))
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	if v.Task != nil {
		ok := object.Key("task")
		ok.String(*v.Task)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeys(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateCapacityProviderInput(v *UpdateCapacityProviderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScalingGroupProvider != nil {
		ok := object.Key("autoScalingGroupProvider")
		if err := awsAwsjson11_serializeDocumentAutoScalingGroupProviderUpdate(v.AutoScalingGroupProvider, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateClusterInput(v *UpdateClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsAwsjson11_serializeDocumentClusterConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.ServiceConnectDefaults != nil {
		ok := object.Key("serviceConnectDefaults")
		if err := awsAwsjson11_serializeDocumentClusterServiceConnectDefaultsRequest(v.ServiceConnectDefaults, ok); err != nil {
			return err
		}
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsAwsjson11_serializeDocumentClusterSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateClusterSettingsInput(v *UpdateClusterSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsAwsjson11_serializeDocumentClusterSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateContainerAgentInput(v *UpdateContainerAgentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerInstance != nil {
		ok := object.Key("containerInstance")
		ok.String(*v.ContainerInstance)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateContainerInstancesStateInput(v *UpdateContainerInstancesStateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ContainerInstances != nil {
		ok := object.Key("containerInstances")
		if err := awsAwsjson11_serializeDocumentStringList(v.ContainerInstances, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateServiceInput(v *UpdateServiceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviderStrategy != nil {
		ok := object.Key("capacityProviderStrategy")
		if err := awsAwsjson11_serializeDocumentCapacityProviderStrategy(v.CapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.DeploymentConfiguration != nil {
		ok := object.Key("deploymentConfiguration")
		if err := awsAwsjson11_serializeDocumentDeploymentConfiguration(v.DeploymentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DesiredCount != nil {
		ok := object.Key("desiredCount")
		ok.Integer(*v.DesiredCount)
	}

	if v.EnableECSManagedTags != nil {
		ok := object.Key("enableECSManagedTags")
		ok.Boolean(*v.EnableECSManagedTags)
	}

	if v.EnableExecuteCommand != nil {
		ok := object.Key("enableExecuteCommand")
		ok.Boolean(*v.EnableExecuteCommand)
	}

	if v.ForceNewDeployment {
		ok := object.Key("forceNewDeployment")
		ok.Boolean(v.ForceNewDeployment)
	}

	if v.HealthCheckGracePeriodSeconds != nil {
		ok := object.Key("healthCheckGracePeriodSeconds")
		ok.Integer(*v.HealthCheckGracePeriodSeconds)
	}

	if v.LoadBalancers != nil {
		ok := object.Key("loadBalancers")
		if err := awsAwsjson11_serializeDocumentLoadBalancers(v.LoadBalancers, ok); err != nil {
			return err
		}
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("networkConfiguration")
		if err := awsAwsjson11_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PlacementConstraints != nil {
		ok := object.Key("placementConstraints")
		if err := awsAwsjson11_serializeDocumentPlacementConstraints(v.PlacementConstraints, ok); err != nil {
			return err
		}
	}

	if v.PlacementStrategy != nil {
		ok := object.Key("placementStrategy")
		if err := awsAwsjson11_serializeDocumentPlacementStrategies(v.PlacementStrategy, ok); err != nil {
			return err
		}
	}

	if v.PlatformVersion != nil {
		ok := object.Key("platformVersion")
		ok.String(*v.PlatformVersion)
	}

	if len(v.PropagateTags) > 0 {
		ok := object.Key("propagateTags")
		ok.String(string(v.PropagateTags))
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	if v.ServiceConnectConfiguration != nil {
		ok := object.Key("serviceConnectConfiguration")
		if err := awsAwsjson11_serializeDocumentServiceConnectConfiguration(v.ServiceConnectConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ServiceRegistries != nil {
		ok := object.Key("serviceRegistries")
		if err := awsAwsjson11_serializeDocumentServiceRegistries(v.ServiceRegistries, ok); err != nil {
			return err
		}
	}

	if v.TaskDefinition != nil {
		ok := object.Key("taskDefinition")
		ok.String(*v.TaskDefinition)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateServicePrimaryTaskSetInput(v *UpdateServicePrimaryTaskSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.PrimaryTaskSet != nil {
		ok := object.Key("primaryTaskSet")
		ok.String(*v.PrimaryTaskSet)
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateTaskProtectionInput(v *UpdateTaskProtectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.ExpiresInMinutes != nil {
		ok := object.Key("expiresInMinutes")
		ok.Integer(*v.ExpiresInMinutes)
	}

	{
		ok := object.Key("protectionEnabled")
		ok.Boolean(v.ProtectionEnabled)
	}

	if v.Tasks != nil {
		ok := object.Key("tasks")
		if err := awsAwsjson11_serializeDocumentStringList(v.Tasks, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateTaskSetInput(v *UpdateTaskSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cluster != nil {
		ok := object.Key("cluster")
		ok.String(*v.Cluster)
	}

	if v.Scale != nil {
		ok := object.Key("scale")
		if err := awsAwsjson11_serializeDocumentScale(v.Scale, ok); err != nil {
			return err
		}
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	if v.TaskSet != nil {
		ok := object.Key("taskSet")
		ok.String(*v.TaskSet)
	}

	return nil
}
