// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get information about the resources in a scope.
func (c *Client) GetIpamResourceCidrs(ctx context.Context, params *GetIpamResourceCidrsInput, optFns ...func(*Options)) (*GetIpamResourceCidrsOutput, error) {
	if params == nil {
		params = &GetIpamResourceCidrsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIpamResourceCidrs", params, optFns, c.addOperationGetIpamResourceCidrsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIpamResourceCidrsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetIpamResourceCidrsInput struct {

	// The ID of the scope that the resource is in.
	//
	// This member is required.
	IpamScopeId *string

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation. Otherwise, it is
	// UnauthorizedOperation.
	DryRun *bool

	// One or more filters for the request. For more information about filtering, see
	// Filtering CLI output
	// (https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
	Filters []types.Filter

	// The ID of the IPAM pool that the resource is in.
	IpamPoolId *string

	// The maximum number of results to return in the request.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The ID of the resource.
	ResourceId *string

	// The ID of the Amazon Web Services account that owns the resource.
	ResourceOwner *string

	// The resource tag.
	ResourceTag *types.RequestIpamResourceTag

	// The resource type.
	ResourceType types.IpamResourceType

	noSmithyDocumentSerde
}

type GetIpamResourceCidrsOutput struct {

	// The resource CIDRs.
	IpamResourceCidrs []types.IpamResourceCidr

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIpamResourceCidrsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetIpamResourceCidrs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetIpamResourceCidrs{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetIpamResourceCidrsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIpamResourceCidrs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// GetIpamResourceCidrsAPIClient is a client that implements the
// GetIpamResourceCidrs operation.
type GetIpamResourceCidrsAPIClient interface {
	GetIpamResourceCidrs(context.Context, *GetIpamResourceCidrsInput, ...func(*Options)) (*GetIpamResourceCidrsOutput, error)
}

var _ GetIpamResourceCidrsAPIClient = (*Client)(nil)

// GetIpamResourceCidrsPaginatorOptions is the paginator options for
// GetIpamResourceCidrs
type GetIpamResourceCidrsPaginatorOptions struct {
	// The maximum number of results to return in the request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetIpamResourceCidrsPaginator is a paginator for GetIpamResourceCidrs
type GetIpamResourceCidrsPaginator struct {
	options   GetIpamResourceCidrsPaginatorOptions
	client    GetIpamResourceCidrsAPIClient
	params    *GetIpamResourceCidrsInput
	nextToken *string
	firstPage bool
}

// NewGetIpamResourceCidrsPaginator returns a new GetIpamResourceCidrsPaginator
func NewGetIpamResourceCidrsPaginator(client GetIpamResourceCidrsAPIClient, params *GetIpamResourceCidrsInput, optFns ...func(*GetIpamResourceCidrsPaginatorOptions)) *GetIpamResourceCidrsPaginator {
	if params == nil {
		params = &GetIpamResourceCidrsInput{}
	}

	options := GetIpamResourceCidrsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetIpamResourceCidrsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetIpamResourceCidrsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetIpamResourceCidrs page.
func (p *GetIpamResourceCidrsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetIpamResourceCidrsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetIpamResourceCidrs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetIpamResourceCidrs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "GetIpamResourceCidrs",
	}
}
