// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package panorama

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApplicationInstance = "CreateApplicationInstance"

// CreateApplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplicationInstance for more information on using the CreateApplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationInstanceRequest method.
//    req, resp := client.CreateApplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateApplicationInstance
func (c *Panorama) CreateApplicationInstanceRequest(input *CreateApplicationInstanceInput) (req *request.Request, output *CreateApplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateApplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/application-instances",
	}

	if input == nil {
		input = &CreateApplicationInstanceInput{}
	}

	output = &CreateApplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplicationInstance API operation for AWS Panorama.
//
// Creates an application instance and deploys it to a device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation CreateApplicationInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ServiceQuotaExceededException
//   The request would cause a limit to be exceeded.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateApplicationInstance
func (c *Panorama) CreateApplicationInstance(input *CreateApplicationInstanceInput) (*CreateApplicationInstanceOutput, error) {
	req, out := c.CreateApplicationInstanceRequest(input)
	return out, req.Send()
}

// CreateApplicationInstanceWithContext is the same as CreateApplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) CreateApplicationInstanceWithContext(ctx aws.Context, input *CreateApplicationInstanceInput, opts ...request.Option) (*CreateApplicationInstanceOutput, error) {
	req, out := c.CreateApplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJobForDevices = "CreateJobForDevices"

// CreateJobForDevicesRequest generates a "aws/request.Request" representing the
// client's request for the CreateJobForDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJobForDevices for more information on using the CreateJobForDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobForDevicesRequest method.
//    req, resp := client.CreateJobForDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateJobForDevices
func (c *Panorama) CreateJobForDevicesRequest(input *CreateJobForDevicesInput) (req *request.Request, output *CreateJobForDevicesOutput) {
	op := &request.Operation{
		Name:       opCreateJobForDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/jobs",
	}

	if input == nil {
		input = &CreateJobForDevicesInput{}
	}

	output = &CreateJobForDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJobForDevices API operation for AWS Panorama.
//
// Creates a job to run on one or more devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation CreateJobForDevices for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateJobForDevices
func (c *Panorama) CreateJobForDevices(input *CreateJobForDevicesInput) (*CreateJobForDevicesOutput, error) {
	req, out := c.CreateJobForDevicesRequest(input)
	return out, req.Send()
}

// CreateJobForDevicesWithContext is the same as CreateJobForDevices with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJobForDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) CreateJobForDevicesWithContext(ctx aws.Context, input *CreateJobForDevicesInput, opts ...request.Option) (*CreateJobForDevicesOutput, error) {
	req, out := c.CreateJobForDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNodeFromTemplateJob = "CreateNodeFromTemplateJob"

// CreateNodeFromTemplateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateNodeFromTemplateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNodeFromTemplateJob for more information on using the CreateNodeFromTemplateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNodeFromTemplateJobRequest method.
//    req, resp := client.CreateNodeFromTemplateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateNodeFromTemplateJob
func (c *Panorama) CreateNodeFromTemplateJobRequest(input *CreateNodeFromTemplateJobInput) (req *request.Request, output *CreateNodeFromTemplateJobOutput) {
	op := &request.Operation{
		Name:       opCreateNodeFromTemplateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/packages/template-job",
	}

	if input == nil {
		input = &CreateNodeFromTemplateJobInput{}
	}

	output = &CreateNodeFromTemplateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNodeFromTemplateJob API operation for AWS Panorama.
//
// Creates a camera stream node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation CreateNodeFromTemplateJob for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreateNodeFromTemplateJob
func (c *Panorama) CreateNodeFromTemplateJob(input *CreateNodeFromTemplateJobInput) (*CreateNodeFromTemplateJobOutput, error) {
	req, out := c.CreateNodeFromTemplateJobRequest(input)
	return out, req.Send()
}

// CreateNodeFromTemplateJobWithContext is the same as CreateNodeFromTemplateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNodeFromTemplateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) CreateNodeFromTemplateJobWithContext(ctx aws.Context, input *CreateNodeFromTemplateJobInput, opts ...request.Option) (*CreateNodeFromTemplateJobOutput, error) {
	req, out := c.CreateNodeFromTemplateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePackage = "CreatePackage"

// CreatePackageRequest generates a "aws/request.Request" representing the
// client's request for the CreatePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePackage for more information on using the CreatePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePackageRequest method.
//    req, resp := client.CreatePackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackage
func (c *Panorama) CreatePackageRequest(input *CreatePackageInput) (req *request.Request, output *CreatePackageOutput) {
	op := &request.Operation{
		Name:       opCreatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/packages",
	}

	if input == nil {
		input = &CreatePackageInput{}
	}

	output = &CreatePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePackage API operation for AWS Panorama.
//
// Creates a package and storage location in an Amazon S3 access point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation CreatePackage for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackage
func (c *Panorama) CreatePackage(input *CreatePackageInput) (*CreatePackageOutput, error) {
	req, out := c.CreatePackageRequest(input)
	return out, req.Send()
}

// CreatePackageWithContext is the same as CreatePackage with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) CreatePackageWithContext(ctx aws.Context, input *CreatePackageInput, opts ...request.Option) (*CreatePackageOutput, error) {
	req, out := c.CreatePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePackageImportJob = "CreatePackageImportJob"

// CreatePackageImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreatePackageImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePackageImportJob for more information on using the CreatePackageImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePackageImportJobRequest method.
//    req, resp := client.CreatePackageImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackageImportJob
func (c *Panorama) CreatePackageImportJobRequest(input *CreatePackageImportJobInput) (req *request.Request, output *CreatePackageImportJobOutput) {
	op := &request.Operation{
		Name:       opCreatePackageImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/packages/import-jobs",
	}

	if input == nil {
		input = &CreatePackageImportJobInput{}
	}

	output = &CreatePackageImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePackageImportJob API operation for AWS Panorama.
//
// Imports a node package.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation CreatePackageImportJob for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/CreatePackageImportJob
func (c *Panorama) CreatePackageImportJob(input *CreatePackageImportJobInput) (*CreatePackageImportJobOutput, error) {
	req, out := c.CreatePackageImportJobRequest(input)
	return out, req.Send()
}

// CreatePackageImportJobWithContext is the same as CreatePackageImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePackageImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) CreatePackageImportJobWithContext(ctx aws.Context, input *CreatePackageImportJobInput, opts ...request.Option) (*CreatePackageImportJobOutput, error) {
	req, out := c.CreatePackageImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDevice = "DeleteDevice"

// DeleteDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDevice for more information on using the DeleteDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeviceRequest method.
//    req, resp := client.DeleteDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeleteDevice
func (c *Panorama) DeleteDeviceRequest(input *DeleteDeviceInput) (req *request.Request, output *DeleteDeviceOutput) {
	op := &request.Operation{
		Name:       opDeleteDevice,
		HTTPMethod: "DELETE",
		HTTPPath:   "/devices/{DeviceId}",
	}

	if input == nil {
		input = &DeleteDeviceInput{}
	}

	output = &DeleteDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDevice API operation for AWS Panorama.
//
// Deletes a device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DeleteDevice for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeleteDevice
func (c *Panorama) DeleteDevice(input *DeleteDeviceInput) (*DeleteDeviceOutput, error) {
	req, out := c.DeleteDeviceRequest(input)
	return out, req.Send()
}

// DeleteDeviceWithContext is the same as DeleteDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DeleteDeviceWithContext(ctx aws.Context, input *DeleteDeviceInput, opts ...request.Option) (*DeleteDeviceOutput, error) {
	req, out := c.DeleteDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePackage = "DeletePackage"

// DeletePackageRequest generates a "aws/request.Request" representing the
// client's request for the DeletePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePackage for more information on using the DeletePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePackageRequest method.
//    req, resp := client.DeletePackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeletePackage
func (c *Panorama) DeletePackageRequest(input *DeletePackageInput) (req *request.Request, output *DeletePackageOutput) {
	op := &request.Operation{
		Name:       opDeletePackage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/packages/{PackageId}",
	}

	if input == nil {
		input = &DeletePackageInput{}
	}

	output = &DeletePackageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePackage API operation for AWS Panorama.
//
// Deletes a package.
//
// To delete a package, you need permission to call s3:DeleteObject in addition
// to permissions for the AWS Panorama API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DeletePackage for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeletePackage
func (c *Panorama) DeletePackage(input *DeletePackageInput) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	return out, req.Send()
}

// DeletePackageWithContext is the same as DeletePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DeletePackageWithContext(ctx aws.Context, input *DeletePackageInput, opts ...request.Option) (*DeletePackageOutput, error) {
	req, out := c.DeletePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterPackageVersion = "DeregisterPackageVersion"

// DeregisterPackageVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterPackageVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterPackageVersion for more information on using the DeregisterPackageVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterPackageVersionRequest method.
//    req, resp := client.DeregisterPackageVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeregisterPackageVersion
func (c *Panorama) DeregisterPackageVersionRequest(input *DeregisterPackageVersionInput) (req *request.Request, output *DeregisterPackageVersionOutput) {
	op := &request.Operation{
		Name:       opDeregisterPackageVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/packages/{PackageId}/versions/{PackageVersion}/patch/{PatchVersion}",
	}

	if input == nil {
		input = &DeregisterPackageVersionInput{}
	}

	output = &DeregisterPackageVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterPackageVersion API operation for AWS Panorama.
//
// Deregisters a package version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DeregisterPackageVersion for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DeregisterPackageVersion
func (c *Panorama) DeregisterPackageVersion(input *DeregisterPackageVersionInput) (*DeregisterPackageVersionOutput, error) {
	req, out := c.DeregisterPackageVersionRequest(input)
	return out, req.Send()
}

// DeregisterPackageVersionWithContext is the same as DeregisterPackageVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterPackageVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DeregisterPackageVersionWithContext(ctx aws.Context, input *DeregisterPackageVersionInput, opts ...request.Option) (*DeregisterPackageVersionOutput, error) {
	req, out := c.DeregisterPackageVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationInstance = "DescribeApplicationInstance"

// DescribeApplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationInstance for more information on using the DescribeApplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationInstanceRequest method.
//    req, resp := client.DescribeApplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstance
func (c *Panorama) DescribeApplicationInstanceRequest(input *DescribeApplicationInstanceInput) (req *request.Request, output *DescribeApplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/application-instances/{ApplicationInstanceId}",
	}

	if input == nil {
		input = &DescribeApplicationInstanceInput{}
	}

	output = &DescribeApplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationInstance API operation for AWS Panorama.
//
// Returns information about an application instance on a device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribeApplicationInstance for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstance
func (c *Panorama) DescribeApplicationInstance(input *DescribeApplicationInstanceInput) (*DescribeApplicationInstanceOutput, error) {
	req, out := c.DescribeApplicationInstanceRequest(input)
	return out, req.Send()
}

// DescribeApplicationInstanceWithContext is the same as DescribeApplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribeApplicationInstanceWithContext(ctx aws.Context, input *DescribeApplicationInstanceInput, opts ...request.Option) (*DescribeApplicationInstanceOutput, error) {
	req, out := c.DescribeApplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationInstanceDetails = "DescribeApplicationInstanceDetails"

// DescribeApplicationInstanceDetailsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationInstanceDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationInstanceDetails for more information on using the DescribeApplicationInstanceDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationInstanceDetailsRequest method.
//    req, resp := client.DescribeApplicationInstanceDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstanceDetails
func (c *Panorama) DescribeApplicationInstanceDetailsRequest(input *DescribeApplicationInstanceDetailsInput) (req *request.Request, output *DescribeApplicationInstanceDetailsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationInstanceDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/application-instances/{ApplicationInstanceId}/details",
	}

	if input == nil {
		input = &DescribeApplicationInstanceDetailsInput{}
	}

	output = &DescribeApplicationInstanceDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationInstanceDetails API operation for AWS Panorama.
//
// Returns information about an application instance's configuration manifest.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribeApplicationInstanceDetails for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeApplicationInstanceDetails
func (c *Panorama) DescribeApplicationInstanceDetails(input *DescribeApplicationInstanceDetailsInput) (*DescribeApplicationInstanceDetailsOutput, error) {
	req, out := c.DescribeApplicationInstanceDetailsRequest(input)
	return out, req.Send()
}

// DescribeApplicationInstanceDetailsWithContext is the same as DescribeApplicationInstanceDetails with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationInstanceDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribeApplicationInstanceDetailsWithContext(ctx aws.Context, input *DescribeApplicationInstanceDetailsInput, opts ...request.Option) (*DescribeApplicationInstanceDetailsOutput, error) {
	req, out := c.DescribeApplicationInstanceDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDevice = "DescribeDevice"

// DescribeDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDevice for more information on using the DescribeDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeviceRequest method.
//    req, resp := client.DescribeDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDevice
func (c *Panorama) DescribeDeviceRequest(input *DescribeDeviceInput) (req *request.Request, output *DescribeDeviceOutput) {
	op := &request.Operation{
		Name:       opDescribeDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/devices/{DeviceId}",
	}

	if input == nil {
		input = &DescribeDeviceInput{}
	}

	output = &DescribeDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDevice API operation for AWS Panorama.
//
// Returns information about a device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribeDevice for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDevice
func (c *Panorama) DescribeDevice(input *DescribeDeviceInput) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	return out, req.Send()
}

// DescribeDeviceWithContext is the same as DescribeDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribeDeviceWithContext(ctx aws.Context, input *DescribeDeviceInput, opts ...request.Option) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeviceJob = "DescribeDeviceJob"

// DescribeDeviceJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeviceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeviceJob for more information on using the DescribeDeviceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeviceJobRequest method.
//    req, resp := client.DescribeDeviceJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDeviceJob
func (c *Panorama) DescribeDeviceJobRequest(input *DescribeDeviceJobInput) (req *request.Request, output *DescribeDeviceJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDeviceJob,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs/{JobId}",
	}

	if input == nil {
		input = &DescribeDeviceJobInput{}
	}

	output = &DescribeDeviceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeviceJob API operation for AWS Panorama.
//
// Returns information about a device job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribeDeviceJob for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeDeviceJob
func (c *Panorama) DescribeDeviceJob(input *DescribeDeviceJobInput) (*DescribeDeviceJobOutput, error) {
	req, out := c.DescribeDeviceJobRequest(input)
	return out, req.Send()
}

// DescribeDeviceJobWithContext is the same as DescribeDeviceJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeviceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribeDeviceJobWithContext(ctx aws.Context, input *DescribeDeviceJobInput, opts ...request.Option) (*DescribeDeviceJobOutput, error) {
	req, out := c.DescribeDeviceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNode = "DescribeNode"

// DescribeNodeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNode for more information on using the DescribeNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNodeRequest method.
//    req, resp := client.DescribeNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNode
func (c *Panorama) DescribeNodeRequest(input *DescribeNodeInput) (req *request.Request, output *DescribeNodeOutput) {
	op := &request.Operation{
		Name:       opDescribeNode,
		HTTPMethod: "GET",
		HTTPPath:   "/nodes/{NodeId}",
	}

	if input == nil {
		input = &DescribeNodeInput{}
	}

	output = &DescribeNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNode API operation for AWS Panorama.
//
// Returns information about a node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribeNode for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNode
func (c *Panorama) DescribeNode(input *DescribeNodeInput) (*DescribeNodeOutput, error) {
	req, out := c.DescribeNodeRequest(input)
	return out, req.Send()
}

// DescribeNodeWithContext is the same as DescribeNode with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribeNodeWithContext(ctx aws.Context, input *DescribeNodeInput, opts ...request.Option) (*DescribeNodeOutput, error) {
	req, out := c.DescribeNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNodeFromTemplateJob = "DescribeNodeFromTemplateJob"

// DescribeNodeFromTemplateJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNodeFromTemplateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNodeFromTemplateJob for more information on using the DescribeNodeFromTemplateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNodeFromTemplateJobRequest method.
//    req, resp := client.DescribeNodeFromTemplateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNodeFromTemplateJob
func (c *Panorama) DescribeNodeFromTemplateJobRequest(input *DescribeNodeFromTemplateJobInput) (req *request.Request, output *DescribeNodeFromTemplateJobOutput) {
	op := &request.Operation{
		Name:       opDescribeNodeFromTemplateJob,
		HTTPMethod: "GET",
		HTTPPath:   "/packages/template-job/{JobId}",
	}

	if input == nil {
		input = &DescribeNodeFromTemplateJobInput{}
	}

	output = &DescribeNodeFromTemplateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNodeFromTemplateJob API operation for AWS Panorama.
//
// Returns information about a job to create a camera stream node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribeNodeFromTemplateJob for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribeNodeFromTemplateJob
func (c *Panorama) DescribeNodeFromTemplateJob(input *DescribeNodeFromTemplateJobInput) (*DescribeNodeFromTemplateJobOutput, error) {
	req, out := c.DescribeNodeFromTemplateJobRequest(input)
	return out, req.Send()
}

// DescribeNodeFromTemplateJobWithContext is the same as DescribeNodeFromTemplateJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNodeFromTemplateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribeNodeFromTemplateJobWithContext(ctx aws.Context, input *DescribeNodeFromTemplateJobInput, opts ...request.Option) (*DescribeNodeFromTemplateJobOutput, error) {
	req, out := c.DescribeNodeFromTemplateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePackage = "DescribePackage"

// DescribePackageRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackage for more information on using the DescribePackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePackageRequest method.
//    req, resp := client.DescribePackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackage
func (c *Panorama) DescribePackageRequest(input *DescribePackageInput) (req *request.Request, output *DescribePackageOutput) {
	op := &request.Operation{
		Name:       opDescribePackage,
		HTTPMethod: "GET",
		HTTPPath:   "/packages/metadata/{PackageId}",
	}

	if input == nil {
		input = &DescribePackageInput{}
	}

	output = &DescribePackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackage API operation for AWS Panorama.
//
// Returns information about a package.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribePackage for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackage
func (c *Panorama) DescribePackage(input *DescribePackageInput) (*DescribePackageOutput, error) {
	req, out := c.DescribePackageRequest(input)
	return out, req.Send()
}

// DescribePackageWithContext is the same as DescribePackage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribePackageWithContext(ctx aws.Context, input *DescribePackageInput, opts ...request.Option) (*DescribePackageOutput, error) {
	req, out := c.DescribePackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePackageImportJob = "DescribePackageImportJob"

// DescribePackageImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackageImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackageImportJob for more information on using the DescribePackageImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePackageImportJobRequest method.
//    req, resp := client.DescribePackageImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageImportJob
func (c *Panorama) DescribePackageImportJobRequest(input *DescribePackageImportJobInput) (req *request.Request, output *DescribePackageImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribePackageImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/packages/import-jobs/{JobId}",
	}

	if input == nil {
		input = &DescribePackageImportJobInput{}
	}

	output = &DescribePackageImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackageImportJob API operation for AWS Panorama.
//
// Returns information about a package import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribePackageImportJob for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageImportJob
func (c *Panorama) DescribePackageImportJob(input *DescribePackageImportJobInput) (*DescribePackageImportJobOutput, error) {
	req, out := c.DescribePackageImportJobRequest(input)
	return out, req.Send()
}

// DescribePackageImportJobWithContext is the same as DescribePackageImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackageImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribePackageImportJobWithContext(ctx aws.Context, input *DescribePackageImportJobInput, opts ...request.Option) (*DescribePackageImportJobOutput, error) {
	req, out := c.DescribePackageImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePackageVersion = "DescribePackageVersion"

// DescribePackageVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribePackageVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePackageVersion for more information on using the DescribePackageVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePackageVersionRequest method.
//    req, resp := client.DescribePackageVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageVersion
func (c *Panorama) DescribePackageVersionRequest(input *DescribePackageVersionInput) (req *request.Request, output *DescribePackageVersionOutput) {
	op := &request.Operation{
		Name:       opDescribePackageVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/packages/metadata/{PackageId}/versions/{PackageVersion}",
	}

	if input == nil {
		input = &DescribePackageVersionInput{}
	}

	output = &DescribePackageVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePackageVersion API operation for AWS Panorama.
//
// Returns information about a package version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation DescribePackageVersion for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/DescribePackageVersion
func (c *Panorama) DescribePackageVersion(input *DescribePackageVersionInput) (*DescribePackageVersionOutput, error) {
	req, out := c.DescribePackageVersionRequest(input)
	return out, req.Send()
}

// DescribePackageVersionWithContext is the same as DescribePackageVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePackageVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) DescribePackageVersionWithContext(ctx aws.Context, input *DescribePackageVersionInput, opts ...request.Option) (*DescribePackageVersionOutput, error) {
	req, out := c.DescribePackageVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplicationInstanceDependencies = "ListApplicationInstanceDependencies"

// ListApplicationInstanceDependenciesRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationInstanceDependencies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationInstanceDependencies for more information on using the ListApplicationInstanceDependencies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationInstanceDependenciesRequest method.
//    req, resp := client.ListApplicationInstanceDependenciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies
func (c *Panorama) ListApplicationInstanceDependenciesRequest(input *ListApplicationInstanceDependenciesInput) (req *request.Request, output *ListApplicationInstanceDependenciesOutput) {
	op := &request.Operation{
		Name:       opListApplicationInstanceDependencies,
		HTTPMethod: "GET",
		HTTPPath:   "/application-instances/{ApplicationInstanceId}/package-dependencies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationInstanceDependenciesInput{}
	}

	output = &ListApplicationInstanceDependenciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationInstanceDependencies API operation for AWS Panorama.
//
// Returns a list of application instance dependencies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListApplicationInstanceDependencies for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceDependencies
func (c *Panorama) ListApplicationInstanceDependencies(input *ListApplicationInstanceDependenciesInput) (*ListApplicationInstanceDependenciesOutput, error) {
	req, out := c.ListApplicationInstanceDependenciesRequest(input)
	return out, req.Send()
}

// ListApplicationInstanceDependenciesWithContext is the same as ListApplicationInstanceDependencies with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationInstanceDependencies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListApplicationInstanceDependenciesWithContext(ctx aws.Context, input *ListApplicationInstanceDependenciesInput, opts ...request.Option) (*ListApplicationInstanceDependenciesOutput, error) {
	req, out := c.ListApplicationInstanceDependenciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationInstanceDependenciesPages iterates over the pages of a ListApplicationInstanceDependencies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationInstanceDependencies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplicationInstanceDependencies operation.
//    pageNum := 0
//    err := client.ListApplicationInstanceDependenciesPages(params,
//        func(page *panorama.ListApplicationInstanceDependenciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListApplicationInstanceDependenciesPages(input *ListApplicationInstanceDependenciesInput, fn func(*ListApplicationInstanceDependenciesOutput, bool) bool) error {
	return c.ListApplicationInstanceDependenciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationInstanceDependenciesPagesWithContext same as ListApplicationInstanceDependenciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListApplicationInstanceDependenciesPagesWithContext(ctx aws.Context, input *ListApplicationInstanceDependenciesInput, fn func(*ListApplicationInstanceDependenciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationInstanceDependenciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationInstanceDependenciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationInstanceDependenciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationInstanceNodeInstances = "ListApplicationInstanceNodeInstances"

// ListApplicationInstanceNodeInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationInstanceNodeInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationInstanceNodeInstances for more information on using the ListApplicationInstanceNodeInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationInstanceNodeInstancesRequest method.
//    req, resp := client.ListApplicationInstanceNodeInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances
func (c *Panorama) ListApplicationInstanceNodeInstancesRequest(input *ListApplicationInstanceNodeInstancesInput) (req *request.Request, output *ListApplicationInstanceNodeInstancesOutput) {
	op := &request.Operation{
		Name:       opListApplicationInstanceNodeInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/application-instances/{ApplicationInstanceId}/node-instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationInstanceNodeInstancesInput{}
	}

	output = &ListApplicationInstanceNodeInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationInstanceNodeInstances API operation for AWS Panorama.
//
// Returns a list of application node instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListApplicationInstanceNodeInstances for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstanceNodeInstances
func (c *Panorama) ListApplicationInstanceNodeInstances(input *ListApplicationInstanceNodeInstancesInput) (*ListApplicationInstanceNodeInstancesOutput, error) {
	req, out := c.ListApplicationInstanceNodeInstancesRequest(input)
	return out, req.Send()
}

// ListApplicationInstanceNodeInstancesWithContext is the same as ListApplicationInstanceNodeInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationInstanceNodeInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListApplicationInstanceNodeInstancesWithContext(ctx aws.Context, input *ListApplicationInstanceNodeInstancesInput, opts ...request.Option) (*ListApplicationInstanceNodeInstancesOutput, error) {
	req, out := c.ListApplicationInstanceNodeInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationInstanceNodeInstancesPages iterates over the pages of a ListApplicationInstanceNodeInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationInstanceNodeInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplicationInstanceNodeInstances operation.
//    pageNum := 0
//    err := client.ListApplicationInstanceNodeInstancesPages(params,
//        func(page *panorama.ListApplicationInstanceNodeInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListApplicationInstanceNodeInstancesPages(input *ListApplicationInstanceNodeInstancesInput, fn func(*ListApplicationInstanceNodeInstancesOutput, bool) bool) error {
	return c.ListApplicationInstanceNodeInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationInstanceNodeInstancesPagesWithContext same as ListApplicationInstanceNodeInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListApplicationInstanceNodeInstancesPagesWithContext(ctx aws.Context, input *ListApplicationInstanceNodeInstancesInput, fn func(*ListApplicationInstanceNodeInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationInstanceNodeInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationInstanceNodeInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationInstanceNodeInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationInstances = "ListApplicationInstances"

// ListApplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationInstances for more information on using the ListApplicationInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationInstancesRequest method.
//    req, resp := client.ListApplicationInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances
func (c *Panorama) ListApplicationInstancesRequest(input *ListApplicationInstancesInput) (req *request.Request, output *ListApplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opListApplicationInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/application-instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationInstancesInput{}
	}

	output = &ListApplicationInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationInstances API operation for AWS Panorama.
//
// Returns a list of application instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListApplicationInstances for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListApplicationInstances
func (c *Panorama) ListApplicationInstances(input *ListApplicationInstancesInput) (*ListApplicationInstancesOutput, error) {
	req, out := c.ListApplicationInstancesRequest(input)
	return out, req.Send()
}

// ListApplicationInstancesWithContext is the same as ListApplicationInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListApplicationInstancesWithContext(ctx aws.Context, input *ListApplicationInstancesInput, opts ...request.Option) (*ListApplicationInstancesOutput, error) {
	req, out := c.ListApplicationInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationInstancesPages iterates over the pages of a ListApplicationInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplicationInstances operation.
//    pageNum := 0
//    err := client.ListApplicationInstancesPages(params,
//        func(page *panorama.ListApplicationInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListApplicationInstancesPages(input *ListApplicationInstancesInput, fn func(*ListApplicationInstancesOutput, bool) bool) error {
	return c.ListApplicationInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationInstancesPagesWithContext same as ListApplicationInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListApplicationInstancesPagesWithContext(ctx aws.Context, input *ListApplicationInstancesInput, fn func(*ListApplicationInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevicesRequest method.
//    req, resp := client.ListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices
func (c *Panorama) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/devices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for AWS Panorama.
//
// Returns a list of devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListDevices for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevices
func (c *Panorama) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicesPages iterates over the pages of a ListDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDevices operation.
//    pageNum := 0
//    err := client.ListDevicesPages(params,
//        func(page *panorama.ListDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListDevicesPages(input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool) error {
	return c.ListDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicesPagesWithContext same as ListDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListDevicesPagesWithContext(ctx aws.Context, input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDevicesJobs = "ListDevicesJobs"

// ListDevicesJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDevicesJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevicesJobs for more information on using the ListDevicesJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevicesJobsRequest method.
//    req, resp := client.ListDevicesJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs
func (c *Panorama) ListDevicesJobsRequest(input *ListDevicesJobsInput) (req *request.Request, output *ListDevicesJobsOutput) {
	op := &request.Operation{
		Name:       opListDevicesJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesJobsInput{}
	}

	output = &ListDevicesJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevicesJobs API operation for AWS Panorama.
//
// Returns a list of jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListDevicesJobs for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListDevicesJobs
func (c *Panorama) ListDevicesJobs(input *ListDevicesJobsInput) (*ListDevicesJobsOutput, error) {
	req, out := c.ListDevicesJobsRequest(input)
	return out, req.Send()
}

// ListDevicesJobsWithContext is the same as ListDevicesJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevicesJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListDevicesJobsWithContext(ctx aws.Context, input *ListDevicesJobsInput, opts ...request.Option) (*ListDevicesJobsOutput, error) {
	req, out := c.ListDevicesJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicesJobsPages iterates over the pages of a ListDevicesJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevicesJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDevicesJobs operation.
//    pageNum := 0
//    err := client.ListDevicesJobsPages(params,
//        func(page *panorama.ListDevicesJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListDevicesJobsPages(input *ListDevicesJobsInput, fn func(*ListDevicesJobsOutput, bool) bool) error {
	return c.ListDevicesJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicesJobsPagesWithContext same as ListDevicesJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListDevicesJobsPagesWithContext(ctx aws.Context, input *ListDevicesJobsInput, fn func(*ListDevicesJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicesJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicesJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicesJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodeFromTemplateJobs = "ListNodeFromTemplateJobs"

// ListNodeFromTemplateJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListNodeFromTemplateJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodeFromTemplateJobs for more information on using the ListNodeFromTemplateJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNodeFromTemplateJobsRequest method.
//    req, resp := client.ListNodeFromTemplateJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs
func (c *Panorama) ListNodeFromTemplateJobsRequest(input *ListNodeFromTemplateJobsInput) (req *request.Request, output *ListNodeFromTemplateJobsOutput) {
	op := &request.Operation{
		Name:       opListNodeFromTemplateJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/packages/template-job",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodeFromTemplateJobsInput{}
	}

	output = &ListNodeFromTemplateJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodeFromTemplateJobs API operation for AWS Panorama.
//
// Returns a list of camera stream node jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListNodeFromTemplateJobs for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodeFromTemplateJobs
func (c *Panorama) ListNodeFromTemplateJobs(input *ListNodeFromTemplateJobsInput) (*ListNodeFromTemplateJobsOutput, error) {
	req, out := c.ListNodeFromTemplateJobsRequest(input)
	return out, req.Send()
}

// ListNodeFromTemplateJobsWithContext is the same as ListNodeFromTemplateJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodeFromTemplateJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListNodeFromTemplateJobsWithContext(ctx aws.Context, input *ListNodeFromTemplateJobsInput, opts ...request.Option) (*ListNodeFromTemplateJobsOutput, error) {
	req, out := c.ListNodeFromTemplateJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodeFromTemplateJobsPages iterates over the pages of a ListNodeFromTemplateJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodeFromTemplateJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNodeFromTemplateJobs operation.
//    pageNum := 0
//    err := client.ListNodeFromTemplateJobsPages(params,
//        func(page *panorama.ListNodeFromTemplateJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListNodeFromTemplateJobsPages(input *ListNodeFromTemplateJobsInput, fn func(*ListNodeFromTemplateJobsOutput, bool) bool) error {
	return c.ListNodeFromTemplateJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodeFromTemplateJobsPagesWithContext same as ListNodeFromTemplateJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListNodeFromTemplateJobsPagesWithContext(ctx aws.Context, input *ListNodeFromTemplateJobsInput, fn func(*ListNodeFromTemplateJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodeFromTemplateJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodeFromTemplateJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodeFromTemplateJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodes = "ListNodes"

// ListNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodes for more information on using the ListNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNodesRequest method.
//    req, resp := client.ListNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes
func (c *Panorama) ListNodesRequest(input *ListNodesInput) (req *request.Request, output *ListNodesOutput) {
	op := &request.Operation{
		Name:       opListNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/nodes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodesInput{}
	}

	output = &ListNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodes API operation for AWS Panorama.
//
// Returns a list of nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListNodes for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListNodes
func (c *Panorama) ListNodes(input *ListNodesInput) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	return out, req.Send()
}

// ListNodesWithContext is the same as ListNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListNodesWithContext(ctx aws.Context, input *ListNodesInput, opts ...request.Option) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodesPages iterates over the pages of a ListNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNodes operation.
//    pageNum := 0
//    err := client.ListNodesPages(params,
//        func(page *panorama.ListNodesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListNodesPages(input *ListNodesInput, fn func(*ListNodesOutput, bool) bool) error {
	return c.ListNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodesPagesWithContext same as ListNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListNodesPagesWithContext(ctx aws.Context, input *ListNodesInput, fn func(*ListNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackageImportJobs = "ListPackageImportJobs"

// ListPackageImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListPackageImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackageImportJobs for more information on using the ListPackageImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPackageImportJobsRequest method.
//    req, resp := client.ListPackageImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs
func (c *Panorama) ListPackageImportJobsRequest(input *ListPackageImportJobsInput) (req *request.Request, output *ListPackageImportJobsOutput) {
	op := &request.Operation{
		Name:       opListPackageImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/packages/import-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackageImportJobsInput{}
	}

	output = &ListPackageImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackageImportJobs API operation for AWS Panorama.
//
// Returns a list of package import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListPackageImportJobs for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackageImportJobs
func (c *Panorama) ListPackageImportJobs(input *ListPackageImportJobsInput) (*ListPackageImportJobsOutput, error) {
	req, out := c.ListPackageImportJobsRequest(input)
	return out, req.Send()
}

// ListPackageImportJobsWithContext is the same as ListPackageImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackageImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListPackageImportJobsWithContext(ctx aws.Context, input *ListPackageImportJobsInput, opts ...request.Option) (*ListPackageImportJobsOutput, error) {
	req, out := c.ListPackageImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackageImportJobsPages iterates over the pages of a ListPackageImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackageImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPackageImportJobs operation.
//    pageNum := 0
//    err := client.ListPackageImportJobsPages(params,
//        func(page *panorama.ListPackageImportJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListPackageImportJobsPages(input *ListPackageImportJobsInput, fn func(*ListPackageImportJobsOutput, bool) bool) error {
	return c.ListPackageImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackageImportJobsPagesWithContext same as ListPackageImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListPackageImportJobsPagesWithContext(ctx aws.Context, input *ListPackageImportJobsInput, fn func(*ListPackageImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackageImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackageImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackageImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPackages = "ListPackages"

// ListPackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListPackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPackages for more information on using the ListPackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPackagesRequest method.
//    req, resp := client.ListPackagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages
func (c *Panorama) ListPackagesRequest(input *ListPackagesInput) (req *request.Request, output *ListPackagesOutput) {
	op := &request.Operation{
		Name:       opListPackages,
		HTTPMethod: "GET",
		HTTPPath:   "/packages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackagesInput{}
	}

	output = &ListPackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPackages API operation for AWS Panorama.
//
// Returns a list of packages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListPackages for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListPackages
func (c *Panorama) ListPackages(input *ListPackagesInput) (*ListPackagesOutput, error) {
	req, out := c.ListPackagesRequest(input)
	return out, req.Send()
}

// ListPackagesWithContext is the same as ListPackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListPackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListPackagesWithContext(ctx aws.Context, input *ListPackagesInput, opts ...request.Option) (*ListPackagesOutput, error) {
	req, out := c.ListPackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPackagesPages iterates over the pages of a ListPackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPackages operation.
//    pageNum := 0
//    err := client.ListPackagesPages(params,
//        func(page *panorama.ListPackagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Panorama) ListPackagesPages(input *ListPackagesInput, fn func(*ListPackagesOutput, bool) bool) error {
	return c.ListPackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPackagesPagesWithContext same as ListPackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListPackagesPagesWithContext(ctx aws.Context, input *ListPackagesInput, fn func(*ListPackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListTagsForResource
func (c *Panorama) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Panorama.
//
// Returns a list of tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ListTagsForResource
func (c *Panorama) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opProvisionDevice = "ProvisionDevice"

// ProvisionDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ProvisionDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ProvisionDevice for more information on using the ProvisionDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ProvisionDeviceRequest method.
//    req, resp := client.ProvisionDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ProvisionDevice
func (c *Panorama) ProvisionDeviceRequest(input *ProvisionDeviceInput) (req *request.Request, output *ProvisionDeviceOutput) {
	op := &request.Operation{
		Name:       opProvisionDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/devices",
	}

	if input == nil {
		input = &ProvisionDeviceInput{}
	}

	output = &ProvisionDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ProvisionDevice API operation for AWS Panorama.
//
// Creates a device and returns a configuration archive. The configuration archive
// is a ZIP file that contains a provisioning certificate that is valid for
// 5 minutes. Name the configuration archive certificates-omni_device-name.zip
// and transfer it to the device within 5 minutes. Use the included USB storage
// device and connect it to the USB 3.0 port next to the HDMI output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation ProvisionDevice for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ServiceQuotaExceededException
//   The request would cause a limit to be exceeded.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/ProvisionDevice
func (c *Panorama) ProvisionDevice(input *ProvisionDeviceInput) (*ProvisionDeviceOutput, error) {
	req, out := c.ProvisionDeviceRequest(input)
	return out, req.Send()
}

// ProvisionDeviceWithContext is the same as ProvisionDevice with the addition of
// the ability to pass a context and additional request options.
//
// See ProvisionDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) ProvisionDeviceWithContext(ctx aws.Context, input *ProvisionDeviceInput, opts ...request.Option) (*ProvisionDeviceOutput, error) {
	req, out := c.ProvisionDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterPackageVersion = "RegisterPackageVersion"

// RegisterPackageVersionRequest generates a "aws/request.Request" representing the
// client's request for the RegisterPackageVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterPackageVersion for more information on using the RegisterPackageVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterPackageVersionRequest method.
//    req, resp := client.RegisterPackageVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RegisterPackageVersion
func (c *Panorama) RegisterPackageVersionRequest(input *RegisterPackageVersionInput) (req *request.Request, output *RegisterPackageVersionOutput) {
	op := &request.Operation{
		Name:       opRegisterPackageVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/packages/{PackageId}/versions/{PackageVersion}/patch/{PatchVersion}",
	}

	if input == nil {
		input = &RegisterPackageVersionInput{}
	}

	output = &RegisterPackageVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterPackageVersion API operation for AWS Panorama.
//
// Registers a package version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation RegisterPackageVersion for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RegisterPackageVersion
func (c *Panorama) RegisterPackageVersion(input *RegisterPackageVersionInput) (*RegisterPackageVersionOutput, error) {
	req, out := c.RegisterPackageVersionRequest(input)
	return out, req.Send()
}

// RegisterPackageVersionWithContext is the same as RegisterPackageVersion with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterPackageVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) RegisterPackageVersionWithContext(ctx aws.Context, input *RegisterPackageVersionInput, opts ...request.Option) (*RegisterPackageVersionOutput, error) {
	req, out := c.RegisterPackageVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveApplicationInstance = "RemoveApplicationInstance"

// RemoveApplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveApplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveApplicationInstance for more information on using the RemoveApplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveApplicationInstanceRequest method.
//    req, resp := client.RemoveApplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RemoveApplicationInstance
func (c *Panorama) RemoveApplicationInstanceRequest(input *RemoveApplicationInstanceInput) (req *request.Request, output *RemoveApplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opRemoveApplicationInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/application-instances/{ApplicationInstanceId}",
	}

	if input == nil {
		input = &RemoveApplicationInstanceInput{}
	}

	output = &RemoveApplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveApplicationInstance API operation for AWS Panorama.
//
// Removes an application instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation RemoveApplicationInstance for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/RemoveApplicationInstance
func (c *Panorama) RemoveApplicationInstance(input *RemoveApplicationInstanceInput) (*RemoveApplicationInstanceOutput, error) {
	req, out := c.RemoveApplicationInstanceRequest(input)
	return out, req.Send()
}

// RemoveApplicationInstanceWithContext is the same as RemoveApplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveApplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) RemoveApplicationInstanceWithContext(ctx aws.Context, input *RemoveApplicationInstanceInput, opts ...request.Option) (*RemoveApplicationInstanceOutput, error) {
	req, out := c.RemoveApplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/TagResource
func (c *Panorama) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Panorama.
//
// Tags a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/TagResource
func (c *Panorama) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UntagResource
func (c *Panorama) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Panorama.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UntagResource
func (c *Panorama) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeviceMetadata = "UpdateDeviceMetadata"

// UpdateDeviceMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeviceMetadata for more information on using the UpdateDeviceMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceMetadataRequest method.
//    req, resp := client.UpdateDeviceMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UpdateDeviceMetadata
func (c *Panorama) UpdateDeviceMetadataRequest(input *UpdateDeviceMetadataInput) (req *request.Request, output *UpdateDeviceMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceMetadata,
		HTTPMethod: "PUT",
		HTTPPath:   "/devices/{DeviceId}",
	}

	if input == nil {
		input = &UpdateDeviceMetadataInput{}
	}

	output = &UpdateDeviceMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDeviceMetadata API operation for AWS Panorama.
//
// Updates a device's metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Panorama's
// API operation UpdateDeviceMetadata for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The target resource is in use.
//
//   * ValidationException
//   The request contains an invalid parameter value.
//
//   * AccessDeniedException
//   The requestor does not have permission to access the target action or resource.
//
//   * ResourceNotFoundException
//   The target resource was not found.
//
//   * InternalServerException
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/UpdateDeviceMetadata
func (c *Panorama) UpdateDeviceMetadata(input *UpdateDeviceMetadataInput) (*UpdateDeviceMetadataOutput, error) {
	req, out := c.UpdateDeviceMetadataRequest(input)
	return out, req.Send()
}

// UpdateDeviceMetadataWithContext is the same as UpdateDeviceMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeviceMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Panorama) UpdateDeviceMetadataWithContext(ctx aws.Context, input *UpdateDeviceMetadataInput, opts ...request.Option) (*UpdateDeviceMetadataOutput, error) {
	req, out := c.UpdateDeviceMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The requestor does not have permission to access the target action or resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about a beta appliance software update.
type AlternateSoftwareMetadata struct {
	_ struct{} `type:"structure"`

	// The appliance software version.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlternateSoftwareMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlternateSoftwareMetadata) GoString() string {
	return s.String()
}

// SetVersion sets the Version field's value.
func (s *AlternateSoftwareMetadata) SetVersion(v string) *AlternateSoftwareMetadata {
	s.Version = &v
	return s
}

// An application instance on a device.
type ApplicationInstance struct {
	_ struct{} `type:"structure"`

	// The application instance's ID.
	ApplicationInstanceId *string `min:"1" type:"string"`

	// The application instance's ARN.
	Arn *string `min:"1" type:"string"`

	// When the application instance was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The device's ID.
	DefaultRuntimeContextDevice *string `min:"1" type:"string"`

	// The device's name.
	DefaultRuntimeContextDeviceName *string `min:"1" type:"string"`

	// The application instance's description.
	Description *string `type:"string"`

	// The application instance's health status.
	HealthStatus *string `type:"string" enum:"ApplicationInstanceHealthStatus"`

	// The application instance's name.
	Name *string `min:"1" type:"string"`

	// The application instance's status.
	Status *string `type:"string" enum:"ApplicationInstanceStatus"`

	// The application instance's status description.
	StatusDescription *string `min:"1" type:"string"`

	// The application instance's tags.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationInstance) GoString() string {
	return s.String()
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *ApplicationInstance) SetApplicationInstanceId(v string) *ApplicationInstance {
	s.ApplicationInstanceId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ApplicationInstance) SetArn(v string) *ApplicationInstance {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ApplicationInstance) SetCreatedTime(v time.Time) *ApplicationInstance {
	s.CreatedTime = &v
	return s
}

// SetDefaultRuntimeContextDevice sets the DefaultRuntimeContextDevice field's value.
func (s *ApplicationInstance) SetDefaultRuntimeContextDevice(v string) *ApplicationInstance {
	s.DefaultRuntimeContextDevice = &v
	return s
}

// SetDefaultRuntimeContextDeviceName sets the DefaultRuntimeContextDeviceName field's value.
func (s *ApplicationInstance) SetDefaultRuntimeContextDeviceName(v string) *ApplicationInstance {
	s.DefaultRuntimeContextDeviceName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ApplicationInstance) SetDescription(v string) *ApplicationInstance {
	s.Description = &v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *ApplicationInstance) SetHealthStatus(v string) *ApplicationInstance {
	s.HealthStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationInstance) SetName(v string) *ApplicationInstance {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ApplicationInstance) SetStatus(v string) *ApplicationInstance {
	s.Status = &v
	return s
}

// SetStatusDescription sets the StatusDescription field's value.
func (s *ApplicationInstance) SetStatusDescription(v string) *ApplicationInstance {
	s.StatusDescription = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ApplicationInstance) SetTags(v map[string]*string) *ApplicationInstance {
	s.Tags = v
	return s
}

// The target resource is in use.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of attributes that led to the exception and their values.
	ErrorArguments []*ConflictExceptionErrorArgument `type:"list"`

	// A unique ID for the error.
	ErrorId *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The resource's ID.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The resource's type.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A conflict exception error argument.
type ConflictExceptionErrorArgument struct {
	_ struct{} `type:"structure"`

	// The error argument's name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The error argument's value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictExceptionErrorArgument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictExceptionErrorArgument) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ConflictExceptionErrorArgument) SetName(v string) *ConflictExceptionErrorArgument {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConflictExceptionErrorArgument) SetValue(v string) *ConflictExceptionErrorArgument {
	s.Value = &v
	return s
}

type CreateApplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of an application instance to replace with the new instance.
	ApplicationInstanceIdToReplace *string `min:"1" type:"string"`

	// A device's ID.
	//
	// DefaultRuntimeContextDevice is a required field
	DefaultRuntimeContextDevice *string `min:"1" type:"string" required:"true"`

	// A description for the application instance.
	Description *string `type:"string"`

	// Setting overrides for the application manifest.
	ManifestOverridesPayload *ManifestOverridesPayload `type:"structure"`

	// The application's manifest document.
	//
	// ManifestPayload is a required field
	ManifestPayload *ManifestPayload `type:"structure" required:"true"`

	// A name for the application instance.
	Name *string `min:"1" type:"string"`

	// The ARN of a runtime role for the application instance.
	RuntimeRoleArn *string `min:"1" type:"string"`

	// Tags for the application instance.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInstanceInput"}
	if s.ApplicationInstanceIdToReplace != nil && len(*s.ApplicationInstanceIdToReplace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationInstanceIdToReplace", 1))
	}
	if s.DefaultRuntimeContextDevice == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultRuntimeContextDevice"))
	}
	if s.DefaultRuntimeContextDevice != nil && len(*s.DefaultRuntimeContextDevice) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultRuntimeContextDevice", 1))
	}
	if s.ManifestPayload == nil {
		invalidParams.Add(request.NewErrParamRequired("ManifestPayload"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RuntimeRoleArn != nil && len(*s.RuntimeRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuntimeRoleArn", 1))
	}
	if s.ManifestPayload != nil {
		if err := s.ManifestPayload.Validate(); err != nil {
			invalidParams.AddNested("ManifestPayload", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationInstanceIdToReplace sets the ApplicationInstanceIdToReplace field's value.
func (s *CreateApplicationInstanceInput) SetApplicationInstanceIdToReplace(v string) *CreateApplicationInstanceInput {
	s.ApplicationInstanceIdToReplace = &v
	return s
}

// SetDefaultRuntimeContextDevice sets the DefaultRuntimeContextDevice field's value.
func (s *CreateApplicationInstanceInput) SetDefaultRuntimeContextDevice(v string) *CreateApplicationInstanceInput {
	s.DefaultRuntimeContextDevice = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInstanceInput) SetDescription(v string) *CreateApplicationInstanceInput {
	s.Description = &v
	return s
}

// SetManifestOverridesPayload sets the ManifestOverridesPayload field's value.
func (s *CreateApplicationInstanceInput) SetManifestOverridesPayload(v *ManifestOverridesPayload) *CreateApplicationInstanceInput {
	s.ManifestOverridesPayload = v
	return s
}

// SetManifestPayload sets the ManifestPayload field's value.
func (s *CreateApplicationInstanceInput) SetManifestPayload(v *ManifestPayload) *CreateApplicationInstanceInput {
	s.ManifestPayload = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInstanceInput) SetName(v string) *CreateApplicationInstanceInput {
	s.Name = &v
	return s
}

// SetRuntimeRoleArn sets the RuntimeRoleArn field's value.
func (s *CreateApplicationInstanceInput) SetRuntimeRoleArn(v string) *CreateApplicationInstanceInput {
	s.RuntimeRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInstanceInput) SetTags(v map[string]*string) *CreateApplicationInstanceInput {
	s.Tags = v
	return s
}

type CreateApplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The application instance's ID.
	//
	// ApplicationInstanceId is a required field
	ApplicationInstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *CreateApplicationInstanceOutput) SetApplicationInstanceId(v string) *CreateApplicationInstanceOutput {
	s.ApplicationInstanceId = &v
	return s
}

type CreateJobForDevicesInput struct {
	_ struct{} `type:"structure"`

	// IDs of target devices.
	//
	// DeviceIds is a required field
	DeviceIds []*string `min:"1" type:"list" required:"true"`

	// Configuration settings for the job.
	//
	// DeviceJobConfig is a required field
	DeviceJobConfig *DeviceJobConfig `type:"structure" required:"true"`

	// The type of job to run.
	//
	// JobType is a required field
	JobType *string `type:"string" required:"true" enum:"JobType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobForDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobForDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobForDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobForDevicesInput"}
	if s.DeviceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceIds"))
	}
	if s.DeviceIds != nil && len(s.DeviceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceIds", 1))
	}
	if s.DeviceJobConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceJobConfig"))
	}
	if s.JobType == nil {
		invalidParams.Add(request.NewErrParamRequired("JobType"))
	}
	if s.DeviceJobConfig != nil {
		if err := s.DeviceJobConfig.Validate(); err != nil {
			invalidParams.AddNested("DeviceJobConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceIds sets the DeviceIds field's value.
func (s *CreateJobForDevicesInput) SetDeviceIds(v []*string) *CreateJobForDevicesInput {
	s.DeviceIds = v
	return s
}

// SetDeviceJobConfig sets the DeviceJobConfig field's value.
func (s *CreateJobForDevicesInput) SetDeviceJobConfig(v *DeviceJobConfig) *CreateJobForDevicesInput {
	s.DeviceJobConfig = v
	return s
}

// SetJobType sets the JobType field's value.
func (s *CreateJobForDevicesInput) SetJobType(v string) *CreateJobForDevicesInput {
	s.JobType = &v
	return s
}

type CreateJobForDevicesOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs.
	//
	// Jobs is a required field
	Jobs []*Job `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobForDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobForDevicesOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *CreateJobForDevicesOutput) SetJobs(v []*Job) *CreateJobForDevicesOutput {
	s.Jobs = v
	return s
}

type CreateNodeFromTemplateJobInput struct {
	_ struct{} `type:"structure"`

	// Tags for the job.
	JobTags []*JobResourceTags `type:"list"`

	// A description for the node.
	NodeDescription *string `type:"string"`

	// A name for the node.
	//
	// NodeName is a required field
	NodeName *string `min:"1" type:"string" required:"true"`

	// An output package name for the node.
	//
	// OutputPackageName is a required field
	OutputPackageName *string `min:"1" type:"string" required:"true"`

	// An output package version for the node.
	//
	// OutputPackageVersion is a required field
	OutputPackageVersion *string `min:"1" type:"string" required:"true"`

	// Template parameters for the node.
	//
	// TemplateParameters is a required field
	TemplateParameters map[string]*string `type:"map" required:"true"`

	// The type of node.
	//
	// TemplateType is a required field
	TemplateType *string `type:"string" required:"true" enum:"TemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodeFromTemplateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodeFromTemplateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNodeFromTemplateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNodeFromTemplateJobInput"}
	if s.NodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeName"))
	}
	if s.NodeName != nil && len(*s.NodeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeName", 1))
	}
	if s.OutputPackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputPackageName"))
	}
	if s.OutputPackageName != nil && len(*s.OutputPackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputPackageName", 1))
	}
	if s.OutputPackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputPackageVersion"))
	}
	if s.OutputPackageVersion != nil && len(*s.OutputPackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputPackageVersion", 1))
	}
	if s.TemplateParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateParameters"))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}
	if s.JobTags != nil {
		for i, v := range s.JobTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "JobTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobTags sets the JobTags field's value.
func (s *CreateNodeFromTemplateJobInput) SetJobTags(v []*JobResourceTags) *CreateNodeFromTemplateJobInput {
	s.JobTags = v
	return s
}

// SetNodeDescription sets the NodeDescription field's value.
func (s *CreateNodeFromTemplateJobInput) SetNodeDescription(v string) *CreateNodeFromTemplateJobInput {
	s.NodeDescription = &v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *CreateNodeFromTemplateJobInput) SetNodeName(v string) *CreateNodeFromTemplateJobInput {
	s.NodeName = &v
	return s
}

// SetOutputPackageName sets the OutputPackageName field's value.
func (s *CreateNodeFromTemplateJobInput) SetOutputPackageName(v string) *CreateNodeFromTemplateJobInput {
	s.OutputPackageName = &v
	return s
}

// SetOutputPackageVersion sets the OutputPackageVersion field's value.
func (s *CreateNodeFromTemplateJobInput) SetOutputPackageVersion(v string) *CreateNodeFromTemplateJobInput {
	s.OutputPackageVersion = &v
	return s
}

// SetTemplateParameters sets the TemplateParameters field's value.
func (s *CreateNodeFromTemplateJobInput) SetTemplateParameters(v map[string]*string) *CreateNodeFromTemplateJobInput {
	s.TemplateParameters = v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *CreateNodeFromTemplateJobInput) SetTemplateType(v string) *CreateNodeFromTemplateJobInput {
	s.TemplateType = &v
	return s
}

type CreateNodeFromTemplateJobOutput struct {
	_ struct{} `type:"structure"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodeFromTemplateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodeFromTemplateJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateNodeFromTemplateJobOutput) SetJobId(v string) *CreateNodeFromTemplateJobOutput {
	s.JobId = &v
	return s
}

type CreatePackageImportJobInput struct {
	_ struct{} `type:"structure"`

	// A client token for the package import job.
	//
	// ClientToken is a required field
	ClientToken *string `min:"1" type:"string" required:"true"`

	// An input config for the package import job.
	//
	// InputConfig is a required field
	InputConfig *PackageImportJobInputConfig `type:"structure" required:"true"`

	// Tags for the package import job.
	JobTags []*JobResourceTags `type:"list"`

	// A job type for the package import job.
	//
	// JobType is a required field
	JobType *string `type:"string" required:"true" enum:"PackageImportJobType"`

	// An output config for the package import job.
	//
	// OutputConfig is a required field
	OutputConfig *PackageImportJobOutputConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePackageImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePackageImportJobInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.InputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfig"))
	}
	if s.JobType == nil {
		invalidParams.Add(request.NewErrParamRequired("JobType"))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.InputConfig != nil {
		if err := s.InputConfig.Validate(); err != nil {
			invalidParams.AddNested("InputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.JobTags != nil {
		for i, v := range s.JobTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "JobTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePackageImportJobInput) SetClientToken(v string) *CreatePackageImportJobInput {
	s.ClientToken = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *CreatePackageImportJobInput) SetInputConfig(v *PackageImportJobInputConfig) *CreatePackageImportJobInput {
	s.InputConfig = v
	return s
}

// SetJobTags sets the JobTags field's value.
func (s *CreatePackageImportJobInput) SetJobTags(v []*JobResourceTags) *CreatePackageImportJobInput {
	s.JobTags = v
	return s
}

// SetJobType sets the JobType field's value.
func (s *CreatePackageImportJobInput) SetJobType(v string) *CreatePackageImportJobInput {
	s.JobType = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *CreatePackageImportJobInput) SetOutputConfig(v *PackageImportJobOutputConfig) *CreatePackageImportJobInput {
	s.OutputConfig = v
	return s
}

type CreatePackageImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageImportJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreatePackageImportJobOutput) SetJobId(v string) *CreatePackageImportJobOutput {
	s.JobId = &v
	return s
}

type CreatePackageInput struct {
	_ struct{} `type:"structure"`

	// A name for the package.
	//
	// PackageName is a required field
	PackageName *string `min:"1" type:"string" required:"true"`

	// Tags for the package.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePackageInput"}
	if s.PackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageName sets the PackageName field's value.
func (s *CreatePackageInput) SetPackageName(v string) *CreatePackageInput {
	s.PackageName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePackageInput) SetTags(v map[string]*string) *CreatePackageInput {
	s.Tags = v
	return s
}

type CreatePackageOutput struct {
	_ struct{} `type:"structure"`

	// The package's ARN.
	Arn *string `min:"1" type:"string"`

	// The package's ID.
	PackageId *string `min:"1" type:"string"`

	// The package's storage location.
	//
	// StorageLocation is a required field
	StorageLocation *StorageLocation `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePackageOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePackageOutput) SetArn(v string) *CreatePackageOutput {
	s.Arn = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *CreatePackageOutput) SetPackageId(v string) *CreatePackageOutput {
	s.PackageId = &v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *CreatePackageOutput) SetStorageLocation(v *StorageLocation) *CreatePackageOutput {
	s.StorageLocation = v
	return s
}

type DeleteDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The device's ID.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeviceInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *DeleteDeviceInput) SetDeviceId(v string) *DeleteDeviceInput {
	s.DeviceId = &v
	return s
}

type DeleteDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device's ID.
	DeviceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeviceOutput) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *DeleteDeviceOutput) SetDeviceId(v string) *DeleteDeviceOutput {
	s.DeviceId = &v
	return s
}

type DeletePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Delete the package even if it has artifacts stored in its access point. Deletes
	// the package's artifacts from Amazon S3.
	ForceDelete *bool `location:"querystring" locationName:"ForceDelete" type:"boolean"`

	// The package's ID.
	//
	// PackageId is a required field
	PackageId *string `location:"uri" locationName:"PackageId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePackageInput"}
	if s.PackageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageId"))
	}
	if s.PackageId != nil && len(*s.PackageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeletePackageInput) SetForceDelete(v bool) *DeletePackageInput {
	s.ForceDelete = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *DeletePackageInput) SetPackageId(v string) *DeletePackageInput {
	s.PackageId = &v
	return s
}

type DeletePackageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePackageOutput) GoString() string {
	return s.String()
}

type DeregisterPackageVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An owner account.
	OwnerAccount *string `location:"querystring" locationName:"OwnerAccount" min:"1" type:"string"`

	// A package ID.
	//
	// PackageId is a required field
	PackageId *string `location:"uri" locationName:"PackageId" min:"1" type:"string" required:"true"`

	// A package version.
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"uri" locationName:"PackageVersion" min:"1" type:"string" required:"true"`

	// A patch version.
	//
	// PatchVersion is a required field
	PatchVersion *string `location:"uri" locationName:"PatchVersion" min:"1" type:"string" required:"true"`

	// If the version was marked latest, the new version to maker as latest.
	UpdatedLatestPatchVersion *string `location:"querystring" locationName:"UpdatedLatestPatchVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterPackageVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterPackageVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterPackageVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterPackageVersionInput"}
	if s.OwnerAccount != nil && len(*s.OwnerAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerAccount", 1))
	}
	if s.PackageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageId"))
	}
	if s.PackageId != nil && len(*s.PackageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageId", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.PatchVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PatchVersion"))
	}
	if s.PatchVersion != nil && len(*s.PatchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchVersion", 1))
	}
	if s.UpdatedLatestPatchVersion != nil && len(*s.UpdatedLatestPatchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdatedLatestPatchVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *DeregisterPackageVersionInput) SetOwnerAccount(v string) *DeregisterPackageVersionInput {
	s.OwnerAccount = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *DeregisterPackageVersionInput) SetPackageId(v string) *DeregisterPackageVersionInput {
	s.PackageId = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DeregisterPackageVersionInput) SetPackageVersion(v string) *DeregisterPackageVersionInput {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *DeregisterPackageVersionInput) SetPatchVersion(v string) *DeregisterPackageVersionInput {
	s.PatchVersion = &v
	return s
}

// SetUpdatedLatestPatchVersion sets the UpdatedLatestPatchVersion field's value.
func (s *DeregisterPackageVersionInput) SetUpdatedLatestPatchVersion(v string) *DeregisterPackageVersionInput {
	s.UpdatedLatestPatchVersion = &v
	return s
}

type DeregisterPackageVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterPackageVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterPackageVersionOutput) GoString() string {
	return s.String()
}

type DescribeApplicationInstanceDetailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application instance's ID.
	//
	// ApplicationInstanceId is a required field
	ApplicationInstanceId *string `location:"uri" locationName:"ApplicationInstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInstanceDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInstanceDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationInstanceDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationInstanceDetailsInput"}
	if s.ApplicationInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationInstanceId"))
	}
	if s.ApplicationInstanceId != nil && len(*s.ApplicationInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *DescribeApplicationInstanceDetailsInput) SetApplicationInstanceId(v string) *DescribeApplicationInstanceDetailsInput {
	s.ApplicationInstanceId = &v
	return s
}

type DescribeApplicationInstanceDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The application instance's ID.
	ApplicationInstanceId *string `min:"1" type:"string"`

	// The ID of the application instance that this instance replaced.
	ApplicationInstanceIdToReplace *string `min:"1" type:"string"`

	// When the application instance was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The application instance's default runtime context device.
	DefaultRuntimeContextDevice *string `min:"1" type:"string"`

	// The application instance's description.
	Description *string `type:"string"`

	// Parameter overrides for the configuration manifest.
	ManifestOverridesPayload *ManifestOverridesPayload `type:"structure"`

	// The application instance's configuration manifest.
	ManifestPayload *ManifestPayload `type:"structure"`

	// The application instance's name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInstanceDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInstanceDetailsOutput) GoString() string {
	return s.String()
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *DescribeApplicationInstanceDetailsOutput) SetApplicationInstanceId(v string) *DescribeApplicationInstanceDetailsOutput {
	s.ApplicationInstanceId = &v
	return s
}

// SetApplicationInstanceIdToReplace sets the ApplicationInstanceIdToReplace field's value.
func (s *DescribeApplicationInstanceDetailsOutput) SetApplicationInstanceIdToReplace(v string) *DescribeApplicationInstanceDetailsOutput {
	s.ApplicationInstanceIdToReplace = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeApplicationInstanceDetailsOutput) SetCreatedTime(v time.Time) *DescribeApplicationInstanceDetailsOutput {
	s.CreatedTime = &v
	return s
}

// SetDefaultRuntimeContextDevice sets the DefaultRuntimeContextDevice field's value.
func (s *DescribeApplicationInstanceDetailsOutput) SetDefaultRuntimeContextDevice(v string) *DescribeApplicationInstanceDetailsOutput {
	s.DefaultRuntimeContextDevice = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeApplicationInstanceDetailsOutput) SetDescription(v string) *DescribeApplicationInstanceDetailsOutput {
	s.Description = &v
	return s
}

// SetManifestOverridesPayload sets the ManifestOverridesPayload field's value.
func (s *DescribeApplicationInstanceDetailsOutput) SetManifestOverridesPayload(v *ManifestOverridesPayload) *DescribeApplicationInstanceDetailsOutput {
	s.ManifestOverridesPayload = v
	return s
}

// SetManifestPayload sets the ManifestPayload field's value.
func (s *DescribeApplicationInstanceDetailsOutput) SetManifestPayload(v *ManifestPayload) *DescribeApplicationInstanceDetailsOutput {
	s.ManifestPayload = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeApplicationInstanceDetailsOutput) SetName(v string) *DescribeApplicationInstanceDetailsOutput {
	s.Name = &v
	return s
}

type DescribeApplicationInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application instance's ID.
	//
	// ApplicationInstanceId is a required field
	ApplicationInstanceId *string `location:"uri" locationName:"ApplicationInstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationInstanceInput"}
	if s.ApplicationInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationInstanceId"))
	}
	if s.ApplicationInstanceId != nil && len(*s.ApplicationInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *DescribeApplicationInstanceInput) SetApplicationInstanceId(v string) *DescribeApplicationInstanceInput {
	s.ApplicationInstanceId = &v
	return s
}

type DescribeApplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The application instance's ID.
	ApplicationInstanceId *string `min:"1" type:"string"`

	// The ID of the application instance that this instance replaced.
	ApplicationInstanceIdToReplace *string `min:"1" type:"string"`

	// The application instance's ARN.
	Arn *string `min:"1" type:"string"`

	// When the application instance was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The device's ID.
	DefaultRuntimeContextDevice *string `min:"1" type:"string"`

	// The device's bane.
	DefaultRuntimeContextDeviceName *string `min:"1" type:"string"`

	// The application instance's description.
	Description *string `type:"string"`

	// The application instance's health status.
	HealthStatus *string `type:"string" enum:"ApplicationInstanceHealthStatus"`

	// The application instance was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The application instance's name.
	Name *string `min:"1" type:"string"`

	// The application instance's runtime role ARN.
	RuntimeRoleArn *string `min:"1" type:"string"`

	// The application instance's status.
	Status *string `type:"string" enum:"ApplicationInstanceStatus"`

	// The application instance's status description.
	StatusDescription *string `min:"1" type:"string"`

	// The application instance's tags.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *DescribeApplicationInstanceOutput) SetApplicationInstanceId(v string) *DescribeApplicationInstanceOutput {
	s.ApplicationInstanceId = &v
	return s
}

// SetApplicationInstanceIdToReplace sets the ApplicationInstanceIdToReplace field's value.
func (s *DescribeApplicationInstanceOutput) SetApplicationInstanceIdToReplace(v string) *DescribeApplicationInstanceOutput {
	s.ApplicationInstanceIdToReplace = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DescribeApplicationInstanceOutput) SetArn(v string) *DescribeApplicationInstanceOutput {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeApplicationInstanceOutput) SetCreatedTime(v time.Time) *DescribeApplicationInstanceOutput {
	s.CreatedTime = &v
	return s
}

// SetDefaultRuntimeContextDevice sets the DefaultRuntimeContextDevice field's value.
func (s *DescribeApplicationInstanceOutput) SetDefaultRuntimeContextDevice(v string) *DescribeApplicationInstanceOutput {
	s.DefaultRuntimeContextDevice = &v
	return s
}

// SetDefaultRuntimeContextDeviceName sets the DefaultRuntimeContextDeviceName field's value.
func (s *DescribeApplicationInstanceOutput) SetDefaultRuntimeContextDeviceName(v string) *DescribeApplicationInstanceOutput {
	s.DefaultRuntimeContextDeviceName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeApplicationInstanceOutput) SetDescription(v string) *DescribeApplicationInstanceOutput {
	s.Description = &v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *DescribeApplicationInstanceOutput) SetHealthStatus(v string) *DescribeApplicationInstanceOutput {
	s.HealthStatus = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DescribeApplicationInstanceOutput) SetLastUpdatedTime(v time.Time) *DescribeApplicationInstanceOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeApplicationInstanceOutput) SetName(v string) *DescribeApplicationInstanceOutput {
	s.Name = &v
	return s
}

// SetRuntimeRoleArn sets the RuntimeRoleArn field's value.
func (s *DescribeApplicationInstanceOutput) SetRuntimeRoleArn(v string) *DescribeApplicationInstanceOutput {
	s.RuntimeRoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeApplicationInstanceOutput) SetStatus(v string) *DescribeApplicationInstanceOutput {
	s.Status = &v
	return s
}

// SetStatusDescription sets the StatusDescription field's value.
func (s *DescribeApplicationInstanceOutput) SetStatusDescription(v string) *DescribeApplicationInstanceOutput {
	s.StatusDescription = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeApplicationInstanceOutput) SetTags(v map[string]*string) *DescribeApplicationInstanceOutput {
	s.Tags = v
	return s
}

type DescribeDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The device's ID.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeviceInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *DescribeDeviceInput) SetDeviceId(v string) *DescribeDeviceInput {
	s.DeviceId = &v
	return s
}

type DescribeDeviceJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeviceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeviceJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeDeviceJobInput) SetJobId(v string) *DescribeDeviceJobInput {
	s.JobId = &v
	return s
}

type DescribeDeviceJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The device's ARN.
	DeviceArn *string `min:"1" type:"string"`

	// The device's ID.
	DeviceId *string `min:"1" type:"string"`

	// The device's name.
	DeviceName *string `min:"1" type:"string"`

	// The device's type.
	DeviceType *string `type:"string" enum:"DeviceType"`

	// For an OTA job, the target version of the device software.
	ImageVersion *string `min:"1" type:"string"`

	// The job's ID.
	JobId *string `min:"1" type:"string"`

	// The job's status.
	Status *string `type:"string" enum:"UpdateProgress"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceJobOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeDeviceJobOutput) SetCreatedTime(v time.Time) *DescribeDeviceJobOutput {
	s.CreatedTime = &v
	return s
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DescribeDeviceJobOutput) SetDeviceArn(v string) *DescribeDeviceJobOutput {
	s.DeviceArn = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *DescribeDeviceJobOutput) SetDeviceId(v string) *DescribeDeviceJobOutput {
	s.DeviceId = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *DescribeDeviceJobOutput) SetDeviceName(v string) *DescribeDeviceJobOutput {
	s.DeviceName = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *DescribeDeviceJobOutput) SetDeviceType(v string) *DescribeDeviceJobOutput {
	s.DeviceType = &v
	return s
}

// SetImageVersion sets the ImageVersion field's value.
func (s *DescribeDeviceJobOutput) SetImageVersion(v string) *DescribeDeviceJobOutput {
	s.ImageVersion = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeDeviceJobOutput) SetJobId(v string) *DescribeDeviceJobOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDeviceJobOutput) SetStatus(v string) *DescribeDeviceJobOutput {
	s.Status = &v
	return s
}

type DescribeDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Beta software releases available for the device.
	AlternateSoftwares []*AlternateSoftwareMetadata `type:"list"`

	// The device's ARN.
	Arn *string `min:"1" type:"string"`

	// The device's maker.
	Brand *string `type:"string" enum:"DeviceBrand"`

	// When the device was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The device's networking status.
	CurrentNetworkingStatus *NetworkStatus `type:"structure"`

	// The device's current software version.
	CurrentSoftware *string `min:"1" type:"string"`

	// The device's description.
	Description *string `type:"string"`

	// The device's connection status.
	DeviceConnectionStatus *string `type:"string" enum:"DeviceConnectionStatus"`

	// The device's ID.
	DeviceId *string `min:"1" type:"string"`

	// The most recent beta software release.
	LatestAlternateSoftware *string `min:"1" type:"string"`

	// The latest software version available for the device.
	LatestSoftware *string `min:"1" type:"string"`

	// The device's lease expiration time.
	LeaseExpirationTime *time.Time `type:"timestamp"`

	// The device's name.
	Name *string `min:"1" type:"string"`

	// The device's networking configuration.
	NetworkingConfiguration *NetworkPayload `type:"structure"`

	// The device's provisioning status.
	ProvisioningStatus *string `type:"string" enum:"DeviceStatus"`

	// The device's serial number.
	SerialNumber *string `type:"string"`

	// The device's tags.
	Tags map[string]*string `type:"map"`

	// The device's type.
	Type *string `type:"string" enum:"DeviceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeviceOutput) GoString() string {
	return s.String()
}

// SetAlternateSoftwares sets the AlternateSoftwares field's value.
func (s *DescribeDeviceOutput) SetAlternateSoftwares(v []*AlternateSoftwareMetadata) *DescribeDeviceOutput {
	s.AlternateSoftwares = v
	return s
}

// SetArn sets the Arn field's value.
func (s *DescribeDeviceOutput) SetArn(v string) *DescribeDeviceOutput {
	s.Arn = &v
	return s
}

// SetBrand sets the Brand field's value.
func (s *DescribeDeviceOutput) SetBrand(v string) *DescribeDeviceOutput {
	s.Brand = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeDeviceOutput) SetCreatedTime(v time.Time) *DescribeDeviceOutput {
	s.CreatedTime = &v
	return s
}

// SetCurrentNetworkingStatus sets the CurrentNetworkingStatus field's value.
func (s *DescribeDeviceOutput) SetCurrentNetworkingStatus(v *NetworkStatus) *DescribeDeviceOutput {
	s.CurrentNetworkingStatus = v
	return s
}

// SetCurrentSoftware sets the CurrentSoftware field's value.
func (s *DescribeDeviceOutput) SetCurrentSoftware(v string) *DescribeDeviceOutput {
	s.CurrentSoftware = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeDeviceOutput) SetDescription(v string) *DescribeDeviceOutput {
	s.Description = &v
	return s
}

// SetDeviceConnectionStatus sets the DeviceConnectionStatus field's value.
func (s *DescribeDeviceOutput) SetDeviceConnectionStatus(v string) *DescribeDeviceOutput {
	s.DeviceConnectionStatus = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *DescribeDeviceOutput) SetDeviceId(v string) *DescribeDeviceOutput {
	s.DeviceId = &v
	return s
}

// SetLatestAlternateSoftware sets the LatestAlternateSoftware field's value.
func (s *DescribeDeviceOutput) SetLatestAlternateSoftware(v string) *DescribeDeviceOutput {
	s.LatestAlternateSoftware = &v
	return s
}

// SetLatestSoftware sets the LatestSoftware field's value.
func (s *DescribeDeviceOutput) SetLatestSoftware(v string) *DescribeDeviceOutput {
	s.LatestSoftware = &v
	return s
}

// SetLeaseExpirationTime sets the LeaseExpirationTime field's value.
func (s *DescribeDeviceOutput) SetLeaseExpirationTime(v time.Time) *DescribeDeviceOutput {
	s.LeaseExpirationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeDeviceOutput) SetName(v string) *DescribeDeviceOutput {
	s.Name = &v
	return s
}

// SetNetworkingConfiguration sets the NetworkingConfiguration field's value.
func (s *DescribeDeviceOutput) SetNetworkingConfiguration(v *NetworkPayload) *DescribeDeviceOutput {
	s.NetworkingConfiguration = v
	return s
}

// SetProvisioningStatus sets the ProvisioningStatus field's value.
func (s *DescribeDeviceOutput) SetProvisioningStatus(v string) *DescribeDeviceOutput {
	s.ProvisioningStatus = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *DescribeDeviceOutput) SetSerialNumber(v string) *DescribeDeviceOutput {
	s.SerialNumber = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeDeviceOutput) SetTags(v map[string]*string) *DescribeDeviceOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeDeviceOutput) SetType(v string) *DescribeDeviceOutput {
	s.Type = &v
	return s
}

type DescribeNodeFromTemplateJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodeFromTemplateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodeFromTemplateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNodeFromTemplateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNodeFromTemplateJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeNodeFromTemplateJobInput) SetJobId(v string) *DescribeNodeFromTemplateJobInput {
	s.JobId = &v
	return s
}

type DescribeNodeFromTemplateJobOutput struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The job's tags.
	JobTags []*JobResourceTags `type:"list"`

	// When the job was updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `type:"timestamp" required:"true"`

	// The node's description.
	NodeDescription *string `type:"string"`

	// The node's name.
	//
	// NodeName is a required field
	NodeName *string `min:"1" type:"string" required:"true"`

	// The job's output package name.
	//
	// OutputPackageName is a required field
	OutputPackageName *string `min:"1" type:"string" required:"true"`

	// The job's output package version.
	//
	// OutputPackageVersion is a required field
	OutputPackageVersion *string `min:"1" type:"string" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"NodeFromTemplateJobStatus"`

	// The job's status message.
	//
	// StatusMessage is a required field
	StatusMessage *string `type:"string" required:"true"`

	// The job's template parameters.
	//
	// TemplateParameters is a required field
	TemplateParameters map[string]*string `type:"map" required:"true"`

	// The job's template type.
	//
	// TemplateType is a required field
	TemplateType *string `type:"string" required:"true" enum:"TemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodeFromTemplateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodeFromTemplateJobOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetCreatedTime(v time.Time) *DescribeNodeFromTemplateJobOutput {
	s.CreatedTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetJobId(v string) *DescribeNodeFromTemplateJobOutput {
	s.JobId = &v
	return s
}

// SetJobTags sets the JobTags field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetJobTags(v []*JobResourceTags) *DescribeNodeFromTemplateJobOutput {
	s.JobTags = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetLastUpdatedTime(v time.Time) *DescribeNodeFromTemplateJobOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetNodeDescription sets the NodeDescription field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetNodeDescription(v string) *DescribeNodeFromTemplateJobOutput {
	s.NodeDescription = &v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetNodeName(v string) *DescribeNodeFromTemplateJobOutput {
	s.NodeName = &v
	return s
}

// SetOutputPackageName sets the OutputPackageName field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetOutputPackageName(v string) *DescribeNodeFromTemplateJobOutput {
	s.OutputPackageName = &v
	return s
}

// SetOutputPackageVersion sets the OutputPackageVersion field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetOutputPackageVersion(v string) *DescribeNodeFromTemplateJobOutput {
	s.OutputPackageVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetStatus(v string) *DescribeNodeFromTemplateJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetStatusMessage(v string) *DescribeNodeFromTemplateJobOutput {
	s.StatusMessage = &v
	return s
}

// SetTemplateParameters sets the TemplateParameters field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetTemplateParameters(v map[string]*string) *DescribeNodeFromTemplateJobOutput {
	s.TemplateParameters = v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *DescribeNodeFromTemplateJobOutput) SetTemplateType(v string) *DescribeNodeFromTemplateJobOutput {
	s.TemplateType = &v
	return s
}

type DescribeNodeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The node's ID.
	//
	// NodeId is a required field
	NodeId *string `location:"uri" locationName:"NodeId" min:"1" type:"string" required:"true"`

	// The account ID of the node's owner.
	OwnerAccount *string `location:"querystring" locationName:"OwnerAccount" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNodeInput"}
	if s.NodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeId"))
	}
	if s.NodeId != nil && len(*s.NodeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeId", 1))
	}
	if s.OwnerAccount != nil && len(*s.OwnerAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerAccount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodeId sets the NodeId field's value.
func (s *DescribeNodeInput) SetNodeId(v string) *DescribeNodeInput {
	s.NodeId = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *DescribeNodeInput) SetOwnerAccount(v string) *DescribeNodeInput {
	s.OwnerAccount = &v
	return s
}

type DescribeNodeOutput struct {
	_ struct{} `type:"structure"`

	// The node's asset name.
	AssetName *string `min:"1" type:"string"`

	// The node's category.
	//
	// Category is a required field
	Category *string `type:"string" required:"true" enum:"NodeCategory"`

	// When the node was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The node's description.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// When the node was updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `type:"timestamp" required:"true"`

	// The node's name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The node's ID.
	//
	// NodeId is a required field
	NodeId *string `min:"1" type:"string" required:"true"`

	// The node's interface.
	//
	// NodeInterface is a required field
	NodeInterface *NodeInterface `type:"structure" required:"true"`

	// The account ID of the node's owner.
	//
	// OwnerAccount is a required field
	OwnerAccount *string `min:"1" type:"string" required:"true"`

	// The node's ARN.
	PackageArn *string `min:"1" type:"string"`

	// The node's package ID.
	//
	// PackageId is a required field
	PackageId *string `min:"1" type:"string" required:"true"`

	// The node's package name.
	//
	// PackageName is a required field
	PackageName *string `min:"1" type:"string" required:"true"`

	// The node's package version.
	//
	// PackageVersion is a required field
	PackageVersion *string `min:"1" type:"string" required:"true"`

	// The node's patch version.
	//
	// PatchVersion is a required field
	PatchVersion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodeOutput) GoString() string {
	return s.String()
}

// SetAssetName sets the AssetName field's value.
func (s *DescribeNodeOutput) SetAssetName(v string) *DescribeNodeOutput {
	s.AssetName = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *DescribeNodeOutput) SetCategory(v string) *DescribeNodeOutput {
	s.Category = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeNodeOutput) SetCreatedTime(v time.Time) *DescribeNodeOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeNodeOutput) SetDescription(v string) *DescribeNodeOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DescribeNodeOutput) SetLastUpdatedTime(v time.Time) *DescribeNodeOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeNodeOutput) SetName(v string) *DescribeNodeOutput {
	s.Name = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *DescribeNodeOutput) SetNodeId(v string) *DescribeNodeOutput {
	s.NodeId = &v
	return s
}

// SetNodeInterface sets the NodeInterface field's value.
func (s *DescribeNodeOutput) SetNodeInterface(v *NodeInterface) *DescribeNodeOutput {
	s.NodeInterface = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *DescribeNodeOutput) SetOwnerAccount(v string) *DescribeNodeOutput {
	s.OwnerAccount = &v
	return s
}

// SetPackageArn sets the PackageArn field's value.
func (s *DescribeNodeOutput) SetPackageArn(v string) *DescribeNodeOutput {
	s.PackageArn = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *DescribeNodeOutput) SetPackageId(v string) *DescribeNodeOutput {
	s.PackageId = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *DescribeNodeOutput) SetPackageName(v string) *DescribeNodeOutput {
	s.PackageName = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DescribeNodeOutput) SetPackageVersion(v string) *DescribeNodeOutput {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *DescribeNodeOutput) SetPatchVersion(v string) *DescribeNodeOutput {
	s.PatchVersion = &v
	return s
}

type DescribePackageImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackageImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackageImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribePackageImportJobInput) SetJobId(v string) *DescribePackageImportJobInput {
	s.JobId = &v
	return s
}

type DescribePackageImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job's client token.
	ClientToken *string `min:"1" type:"string"`

	// When the job was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The job's input config.
	//
	// InputConfig is a required field
	InputConfig *PackageImportJobInputConfig `type:"structure" required:"true"`

	// The job's ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The job's tags.
	JobTags []*JobResourceTags `type:"list"`

	// The job's type.
	//
	// JobType is a required field
	JobType *string `type:"string" required:"true" enum:"PackageImportJobType"`

	// When the job was updated.
	//
	// LastUpdatedTime is a required field
	LastUpdatedTime *time.Time `type:"timestamp" required:"true"`

	// The job's output.
	//
	// Output is a required field
	Output *PackageImportJobOutput_ `type:"structure" required:"true"`

	// The job's output config.
	//
	// OutputConfig is a required field
	OutputConfig *PackageImportJobOutputConfig `type:"structure" required:"true"`

	// The job's status.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"PackageImportJobStatus"`

	// The job's status message.
	//
	// StatusMessage is a required field
	StatusMessage *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageImportJobOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DescribePackageImportJobOutput) SetClientToken(v string) *DescribePackageImportJobOutput {
	s.ClientToken = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribePackageImportJobOutput) SetCreatedTime(v time.Time) *DescribePackageImportJobOutput {
	s.CreatedTime = &v
	return s
}

// SetInputConfig sets the InputConfig field's value.
func (s *DescribePackageImportJobOutput) SetInputConfig(v *PackageImportJobInputConfig) *DescribePackageImportJobOutput {
	s.InputConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribePackageImportJobOutput) SetJobId(v string) *DescribePackageImportJobOutput {
	s.JobId = &v
	return s
}

// SetJobTags sets the JobTags field's value.
func (s *DescribePackageImportJobOutput) SetJobTags(v []*JobResourceTags) *DescribePackageImportJobOutput {
	s.JobTags = v
	return s
}

// SetJobType sets the JobType field's value.
func (s *DescribePackageImportJobOutput) SetJobType(v string) *DescribePackageImportJobOutput {
	s.JobType = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DescribePackageImportJobOutput) SetLastUpdatedTime(v time.Time) *DescribePackageImportJobOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *DescribePackageImportJobOutput) SetOutput(v *PackageImportJobOutput_) *DescribePackageImportJobOutput {
	s.Output = v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *DescribePackageImportJobOutput) SetOutputConfig(v *PackageImportJobOutputConfig) *DescribePackageImportJobOutput {
	s.OutputConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribePackageImportJobOutput) SetStatus(v string) *DescribePackageImportJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DescribePackageImportJobOutput) SetStatusMessage(v string) *DescribePackageImportJobOutput {
	s.StatusMessage = &v
	return s
}

type DescribePackageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The package's ID.
	//
	// PackageId is a required field
	PackageId *string `location:"uri" locationName:"PackageId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackageInput"}
	if s.PackageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageId"))
	}
	if s.PackageId != nil && len(*s.PackageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageId sets the PackageId field's value.
func (s *DescribePackageInput) SetPackageId(v string) *DescribePackageInput {
	s.PackageId = &v
	return s
}

type DescribePackageOutput struct {
	_ struct{} `type:"structure"`

	// The package's ARN.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// When the package was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The package's ID.
	//
	// PackageId is a required field
	PackageId *string `min:"1" type:"string" required:"true"`

	// The package's name.
	//
	// PackageName is a required field
	PackageName *string `min:"1" type:"string" required:"true"`

	// ARNs of accounts that have read access to the package.
	ReadAccessPrincipalArns []*string `type:"list"`

	// The package's storage location.
	//
	// StorageLocation is a required field
	StorageLocation *StorageLocation `type:"structure" required:"true"`

	// The package's tags.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`

	// ARNs of accounts that have write access to the package.
	WriteAccessPrincipalArns []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribePackageOutput) SetArn(v string) *DescribePackageOutput {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribePackageOutput) SetCreatedTime(v time.Time) *DescribePackageOutput {
	s.CreatedTime = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *DescribePackageOutput) SetPackageId(v string) *DescribePackageOutput {
	s.PackageId = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *DescribePackageOutput) SetPackageName(v string) *DescribePackageOutput {
	s.PackageName = &v
	return s
}

// SetReadAccessPrincipalArns sets the ReadAccessPrincipalArns field's value.
func (s *DescribePackageOutput) SetReadAccessPrincipalArns(v []*string) *DescribePackageOutput {
	s.ReadAccessPrincipalArns = v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *DescribePackageOutput) SetStorageLocation(v *StorageLocation) *DescribePackageOutput {
	s.StorageLocation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribePackageOutput) SetTags(v map[string]*string) *DescribePackageOutput {
	s.Tags = v
	return s
}

// SetWriteAccessPrincipalArns sets the WriteAccessPrincipalArns field's value.
func (s *DescribePackageOutput) SetWriteAccessPrincipalArns(v []*string) *DescribePackageOutput {
	s.WriteAccessPrincipalArns = v
	return s
}

type DescribePackageVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The version's owner account.
	OwnerAccount *string `location:"querystring" locationName:"OwnerAccount" min:"1" type:"string"`

	// The version's ID.
	//
	// PackageId is a required field
	PackageId *string `location:"uri" locationName:"PackageId" min:"1" type:"string" required:"true"`

	// The version's version.
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"uri" locationName:"PackageVersion" min:"1" type:"string" required:"true"`

	// The version's patch version.
	PatchVersion *string `location:"querystring" locationName:"PatchVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePackageVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePackageVersionInput"}
	if s.OwnerAccount != nil && len(*s.OwnerAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerAccount", 1))
	}
	if s.PackageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageId"))
	}
	if s.PackageId != nil && len(*s.PackageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageId", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.PatchVersion != nil && len(*s.PatchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *DescribePackageVersionInput) SetOwnerAccount(v string) *DescribePackageVersionInput {
	s.OwnerAccount = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *DescribePackageVersionInput) SetPackageId(v string) *DescribePackageVersionInput {
	s.PackageId = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DescribePackageVersionInput) SetPackageVersion(v string) *DescribePackageVersionInput {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *DescribePackageVersionInput) SetPatchVersion(v string) *DescribePackageVersionInput {
	s.PatchVersion = &v
	return s
}

type DescribePackageVersionOutput struct {
	_ struct{} `type:"structure"`

	// Whether the version is the latest available.
	//
	// IsLatestPatch is a required field
	IsLatestPatch *bool `type:"boolean" required:"true"`

	// The account ID of the version's owner.
	OwnerAccount *string `min:"1" type:"string"`

	// The ARN of the package.
	PackageArn *string `min:"1" type:"string"`

	// The version's ID.
	//
	// PackageId is a required field
	PackageId *string `min:"1" type:"string" required:"true"`

	// The version's name.
	//
	// PackageName is a required field
	PackageName *string `min:"1" type:"string" required:"true"`

	// The version's version.
	//
	// PackageVersion is a required field
	PackageVersion *string `min:"1" type:"string" required:"true"`

	// The version's patch version.
	//
	// PatchVersion is a required field
	PatchVersion *string `min:"1" type:"string" required:"true"`

	// The version's registered time.
	RegisteredTime *time.Time `type:"timestamp"`

	// The version's status.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"PackageVersionStatus"`

	// The version's status description.
	StatusDescription *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePackageVersionOutput) GoString() string {
	return s.String()
}

// SetIsLatestPatch sets the IsLatestPatch field's value.
func (s *DescribePackageVersionOutput) SetIsLatestPatch(v bool) *DescribePackageVersionOutput {
	s.IsLatestPatch = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *DescribePackageVersionOutput) SetOwnerAccount(v string) *DescribePackageVersionOutput {
	s.OwnerAccount = &v
	return s
}

// SetPackageArn sets the PackageArn field's value.
func (s *DescribePackageVersionOutput) SetPackageArn(v string) *DescribePackageVersionOutput {
	s.PackageArn = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *DescribePackageVersionOutput) SetPackageId(v string) *DescribePackageVersionOutput {
	s.PackageId = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *DescribePackageVersionOutput) SetPackageName(v string) *DescribePackageVersionOutput {
	s.PackageName = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *DescribePackageVersionOutput) SetPackageVersion(v string) *DescribePackageVersionOutput {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *DescribePackageVersionOutput) SetPatchVersion(v string) *DescribePackageVersionOutput {
	s.PatchVersion = &v
	return s
}

// SetRegisteredTime sets the RegisteredTime field's value.
func (s *DescribePackageVersionOutput) SetRegisteredTime(v time.Time) *DescribePackageVersionOutput {
	s.RegisteredTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribePackageVersionOutput) SetStatus(v string) *DescribePackageVersionOutput {
	s.Status = &v
	return s
}

// SetStatusDescription sets the StatusDescription field's value.
func (s *DescribePackageVersionOutput) SetStatusDescription(v string) *DescribePackageVersionOutput {
	s.StatusDescription = &v
	return s
}

// A device.
type Device struct {
	_ struct{} `type:"structure"`

	// The device's maker.
	Brand *string `type:"string" enum:"DeviceBrand"`

	// When the device was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The device's ID.
	DeviceId *string `min:"1" type:"string"`

	// When the device was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The device's lease expiration time.
	LeaseExpirationTime *time.Time `type:"timestamp"`

	// The device's name.
	Name *string `min:"1" type:"string"`

	// The device's provisioning status.
	ProvisioningStatus *string `type:"string" enum:"DeviceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Device) GoString() string {
	return s.String()
}

// SetBrand sets the Brand field's value.
func (s *Device) SetBrand(v string) *Device {
	s.Brand = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Device) SetCreatedTime(v time.Time) *Device {
	s.CreatedTime = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *Device) SetDeviceId(v string) *Device {
	s.DeviceId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Device) SetLastUpdatedTime(v time.Time) *Device {
	s.LastUpdatedTime = &v
	return s
}

// SetLeaseExpirationTime sets the LeaseExpirationTime field's value.
func (s *Device) SetLeaseExpirationTime(v time.Time) *Device {
	s.LeaseExpirationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Device) SetName(v string) *Device {
	s.Name = &v
	return s
}

// SetProvisioningStatus sets the ProvisioningStatus field's value.
func (s *Device) SetProvisioningStatus(v string) *Device {
	s.ProvisioningStatus = &v
	return s
}

// A job that runs on a device.
type DeviceJob struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the target device.
	DeviceId *string `min:"1" type:"string"`

	// The name of the target device
	DeviceName *string `min:"1" type:"string"`

	// The job's ID.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceJob) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DeviceJob) SetCreatedTime(v time.Time) *DeviceJob {
	s.CreatedTime = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *DeviceJob) SetDeviceId(v string) *DeviceJob {
	s.DeviceId = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *DeviceJob) SetDeviceName(v string) *DeviceJob {
	s.DeviceName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeviceJob) SetJobId(v string) *DeviceJob {
	s.JobId = &v
	return s
}

// A job's configuration.
type DeviceJobConfig struct {
	_ struct{} `type:"structure"`

	// A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.
	OTAJobConfig *OTAJobConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceJobConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceJobConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceJobConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeviceJobConfig"}
	if s.OTAJobConfig != nil {
		if err := s.OTAJobConfig.Validate(); err != nil {
			invalidParams.AddNested("OTAJobConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOTAJobConfig sets the OTAJobConfig field's value.
func (s *DeviceJobConfig) SetOTAJobConfig(v *OTAJobConfig) *DeviceJobConfig {
	s.OTAJobConfig = v
	return s
}

// A device's network configuration.
type EthernetPayload struct {
	_ struct{} `type:"structure"`

	// How the device gets an IP address.
	//
	// ConnectionType is a required field
	ConnectionType *string `type:"string" required:"true" enum:"ConnectionType"`

	// Network configuration for a static IP connection.
	StaticIpConnectionInfo *StaticIpConnectionInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EthernetPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EthernetPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EthernetPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EthernetPayload"}
	if s.ConnectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionType"))
	}
	if s.StaticIpConnectionInfo != nil {
		if err := s.StaticIpConnectionInfo.Validate(); err != nil {
			invalidParams.AddNested("StaticIpConnectionInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionType sets the ConnectionType field's value.
func (s *EthernetPayload) SetConnectionType(v string) *EthernetPayload {
	s.ConnectionType = &v
	return s
}

// SetStaticIpConnectionInfo sets the StaticIpConnectionInfo field's value.
func (s *EthernetPayload) SetStaticIpConnectionInfo(v *StaticIpConnectionInfo) *EthernetPayload {
	s.StaticIpConnectionInfo = v
	return s
}

// A device's Ethernet status.
type EthernetStatus struct {
	_ struct{} `type:"structure"`

	// The device's connection status.
	ConnectionStatus *string `type:"string" enum:"NetworkConnectionStatus"`

	// The device's physical address.
	HwAddress *string `min:"1" type:"string"`

	// The device's IP address.
	IpAddress *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EthernetStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EthernetStatus) GoString() string {
	return s.String()
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *EthernetStatus) SetConnectionStatus(v string) *EthernetStatus {
	s.ConnectionStatus = &v
	return s
}

// SetHwAddress sets the HwAddress field's value.
func (s *EthernetStatus) SetHwAddress(v string) *EthernetStatus {
	s.HwAddress = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *EthernetStatus) SetIpAddress(v string) *EthernetStatus {
	s.IpAddress = &v
	return s
}

// An internal error occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The number of seconds a client should wait before retrying the call.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A job for a device.
type Job struct {
	_ struct{} `type:"structure"`

	// The target device's ID.
	DeviceId *string `min:"1" type:"string"`

	// The job's ID.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *Job) SetDeviceId(v string) *Job {
	s.DeviceId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *Job) SetJobId(v string) *Job {
	s.JobId = &v
	return s
}

// Tags for a job.
type JobResourceTags struct {
	_ struct{} `type:"structure"`

	// The job's type.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"JobResourceType"`

	// The job's tags.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobResourceTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobResourceTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobResourceTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobResourceTags"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceType sets the ResourceType field's value.
func (s *JobResourceTags) SetResourceType(v string) *JobResourceTags {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *JobResourceTags) SetTags(v map[string]*string) *JobResourceTags {
	s.Tags = v
	return s
}

type ListApplicationInstanceDependenciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application instance's ID.
	//
	// ApplicationInstanceId is a required field
	ApplicationInstanceId *string `location:"uri" locationName:"ApplicationInstanceId" min:"1" type:"string" required:"true"`

	// The maximum number of application instance dependencies to return in one
	// page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstanceDependenciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstanceDependenciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationInstanceDependenciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationInstanceDependenciesInput"}
	if s.ApplicationInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationInstanceId"))
	}
	if s.ApplicationInstanceId != nil && len(*s.ApplicationInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationInstanceId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *ListApplicationInstanceDependenciesInput) SetApplicationInstanceId(v string) *ListApplicationInstanceDependenciesInput {
	s.ApplicationInstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationInstanceDependenciesInput) SetMaxResults(v int64) *ListApplicationInstanceDependenciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationInstanceDependenciesInput) SetNextToken(v string) *ListApplicationInstanceDependenciesInput {
	s.NextToken = &v
	return s
}

type ListApplicationInstanceDependenciesOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`

	// A list of package objects.
	PackageObjects []*PackageObject `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstanceDependenciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstanceDependenciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationInstanceDependenciesOutput) SetNextToken(v string) *ListApplicationInstanceDependenciesOutput {
	s.NextToken = &v
	return s
}

// SetPackageObjects sets the PackageObjects field's value.
func (s *ListApplicationInstanceDependenciesOutput) SetPackageObjects(v []*PackageObject) *ListApplicationInstanceDependenciesOutput {
	s.PackageObjects = v
	return s
}

type ListApplicationInstanceNodeInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The node instances' application instance ID.
	//
	// ApplicationInstanceId is a required field
	ApplicationInstanceId *string `location:"uri" locationName:"ApplicationInstanceId" min:"1" type:"string" required:"true"`

	// The maximum number of node instances to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstanceNodeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstanceNodeInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationInstanceNodeInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationInstanceNodeInstancesInput"}
	if s.ApplicationInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationInstanceId"))
	}
	if s.ApplicationInstanceId != nil && len(*s.ApplicationInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationInstanceId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *ListApplicationInstanceNodeInstancesInput) SetApplicationInstanceId(v string) *ListApplicationInstanceNodeInstancesInput {
	s.ApplicationInstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationInstanceNodeInstancesInput) SetMaxResults(v int64) *ListApplicationInstanceNodeInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationInstanceNodeInstancesInput) SetNextToken(v string) *ListApplicationInstanceNodeInstancesInput {
	s.NextToken = &v
	return s
}

type ListApplicationInstanceNodeInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`

	// A list of node instances.
	NodeInstances []*NodeInstance `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstanceNodeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstanceNodeInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationInstanceNodeInstancesOutput) SetNextToken(v string) *ListApplicationInstanceNodeInstancesOutput {
	s.NextToken = &v
	return s
}

// SetNodeInstances sets the NodeInstances field's value.
func (s *ListApplicationInstanceNodeInstancesOutput) SetNodeInstances(v []*NodeInstance) *ListApplicationInstanceNodeInstancesOutput {
	s.NodeInstances = v
	return s
}

type ListApplicationInstancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The application instances' device ID.
	DeviceId *string `location:"querystring" locationName:"deviceId" min:"1" type:"string"`

	// The maximum number of application instances to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// Only include instances with a specific status.
	StatusFilter *string `location:"querystring" locationName:"statusFilter" type:"string" enum:"StatusFilter"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationInstancesInput"}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *ListApplicationInstancesInput) SetDeviceId(v string) *ListApplicationInstancesInput {
	s.DeviceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationInstancesInput) SetMaxResults(v int64) *ListApplicationInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationInstancesInput) SetNextToken(v string) *ListApplicationInstancesInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListApplicationInstancesInput) SetStatusFilter(v string) *ListApplicationInstancesInput {
	s.StatusFilter = &v
	return s
}

type ListApplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of application instances.
	ApplicationInstances []*ApplicationInstance `type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationInstancesOutput) GoString() string {
	return s.String()
}

// SetApplicationInstances sets the ApplicationInstances field's value.
func (s *ListApplicationInstancesOutput) SetApplicationInstances(v []*ApplicationInstance) *ListApplicationInstancesOutput {
	s.ApplicationInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationInstancesOutput) SetNextToken(v string) *ListApplicationInstancesOutput {
	s.NextToken = &v
	return s
}

type ListDevicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of devices to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDevicesInput) SetMaxResults(v int64) *ListDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesInput) SetNextToken(v string) *ListDevicesInput {
	s.NextToken = &v
	return s
}

type ListDevicesJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Filter results by the job's target device ID.
	DeviceId *string `location:"querystring" locationName:"DeviceId" min:"1" type:"string"`

	// The maximum number of device jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesJobsInput"}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *ListDevicesJobsInput) SetDeviceId(v string) *ListDevicesJobsInput {
	s.DeviceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDevicesJobsInput) SetMaxResults(v int64) *ListDevicesJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesJobsInput) SetNextToken(v string) *ListDevicesJobsInput {
	s.NextToken = &v
	return s
}

type ListDevicesJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs.
	DeviceJobs []*DeviceJob `type:"list"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesJobsOutput) GoString() string {
	return s.String()
}

// SetDeviceJobs sets the DeviceJobs field's value.
func (s *ListDevicesJobsOutput) SetDeviceJobs(v []*DeviceJob) *ListDevicesJobsOutput {
	s.DeviceJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesJobsOutput) SetNextToken(v string) *ListDevicesJobsOutput {
	s.NextToken = &v
	return s
}

type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// A list of devices.
	//
	// Devices is a required field
	Devices []*Device `type:"list" required:"true"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*Device) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesOutput) SetNextToken(v string) *ListDevicesOutput {
	s.NextToken = &v
	return s
}

type ListNodeFromTemplateJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of node from template jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodeFromTemplateJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodeFromTemplateJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodeFromTemplateJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodeFromTemplateJobsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodeFromTemplateJobsInput) SetMaxResults(v int64) *ListNodeFromTemplateJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodeFromTemplateJobsInput) SetNextToken(v string) *ListNodeFromTemplateJobsInput {
	s.NextToken = &v
	return s
}

type ListNodeFromTemplateJobsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`

	// A list of jobs.
	//
	// NodeFromTemplateJobs is a required field
	NodeFromTemplateJobs []*NodeFromTemplateJob `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodeFromTemplateJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodeFromTemplateJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodeFromTemplateJobsOutput) SetNextToken(v string) *ListNodeFromTemplateJobsOutput {
	s.NextToken = &v
	return s
}

// SetNodeFromTemplateJobs sets the NodeFromTemplateJobs field's value.
func (s *ListNodeFromTemplateJobsOutput) SetNodeFromTemplateJobs(v []*NodeFromTemplateJob) *ListNodeFromTemplateJobsOutput {
	s.NodeFromTemplateJobs = v
	return s
}

type ListNodesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Search for nodes by category.
	Category *string `location:"querystring" locationName:"category" type:"string" enum:"NodeCategory"`

	// The maximum number of nodes to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// Search for nodes by the account ID of the nodes' owner.
	OwnerAccount *string `location:"querystring" locationName:"ownerAccount" min:"1" type:"string"`

	// Search for nodes by name.
	PackageName *string `location:"querystring" locationName:"packageName" min:"1" type:"string"`

	// Search for nodes by version.
	PackageVersion *string `location:"querystring" locationName:"packageVersion" min:"1" type:"string"`

	// Search for nodes by patch version.
	PatchVersion *string `location:"querystring" locationName:"patchVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OwnerAccount != nil && len(*s.OwnerAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerAccount", 1))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageName", 1))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.PatchVersion != nil && len(*s.PatchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *ListNodesInput) SetCategory(v string) *ListNodesInput {
	s.Category = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodesInput) SetMaxResults(v int64) *ListNodesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesInput) SetNextToken(v string) *ListNodesInput {
	s.NextToken = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *ListNodesInput) SetOwnerAccount(v string) *ListNodesInput {
	s.OwnerAccount = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *ListNodesInput) SetPackageName(v string) *ListNodesInput {
	s.PackageName = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *ListNodesInput) SetPackageVersion(v string) *ListNodesInput {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *ListNodesInput) SetPatchVersion(v string) *ListNodesInput {
	s.PatchVersion = &v
	return s
}

type ListNodesOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`

	// A list of nodes.
	Nodes []*Node `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesOutput) SetNextToken(v string) *ListNodesOutput {
	s.NextToken = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *ListNodesOutput) SetNodes(v []*Node) *ListNodesOutput {
	s.Nodes = v
	return s
}

type ListPackageImportJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of package import jobs to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackageImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackageImportJobsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackageImportJobsInput) SetMaxResults(v int64) *ListPackageImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackageImportJobsInput) SetNextToken(v string) *ListPackageImportJobsInput {
	s.NextToken = &v
	return s
}

type ListPackageImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`

	// A list of package import jobs.
	//
	// PackageImportJobs is a required field
	PackageImportJobs []*PackageImportJob `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackageImportJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackageImportJobsOutput) SetNextToken(v string) *ListPackageImportJobsOutput {
	s.NextToken = &v
	return s
}

// SetPackageImportJobs sets the PackageImportJobs field's value.
func (s *ListPackageImportJobsOutput) SetPackageImportJobs(v []*PackageImportJob) *ListPackageImportJobsOutput {
	s.PackageImportJobs = v
	return s
}

type ListPackagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of packages to return in one page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Specify the pagination token from a previous request to retrieve the next
	// page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPackagesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPackagesInput) SetMaxResults(v int64) *ListPackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesInput) SetNextToken(v string) *ListPackagesInput {
	s.NextToken = &v
	return s
}

type ListPackagesOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that's included if more results are available.
	NextToken *string `min:"1" type:"string"`

	// A list of packages.
	Packages []*PackageListItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPackagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPackagesOutput) SetNextToken(v string) *ListPackagesOutput {
	s.NextToken = &v
	return s
}

// SetPackages sets the Packages field's value.
func (s *ListPackagesOutput) SetPackages(v []*PackageListItem) *ListPackagesOutput {
	s.Packages = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource's ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Parameter overrides for an application instance. This is a JSON document
// that has a single key (PayloadData) where the value is an escaped string
// representation of the overrides document.
type ManifestOverridesPayload struct {
	_ struct{} `type:"structure"`

	// The overrides document.
	PayloadData *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManifestOverridesPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManifestOverridesPayload) GoString() string {
	return s.String()
}

// SetPayloadData sets the PayloadData field's value.
func (s *ManifestOverridesPayload) SetPayloadData(v string) *ManifestOverridesPayload {
	s.PayloadData = &v
	return s
}

// A application verion's manifest file. This is a JSON document that has a
// single key (PayloadData) where the value is an escaped string representation
// of the application manifest (graph.json). This file is located in the graphs
// folder in your application source.
type ManifestPayload struct {
	_ struct{} `type:"structure"`

	// The application manifest.
	PayloadData *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManifestPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManifestPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManifestPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManifestPayload"}
	if s.PayloadData != nil && len(*s.PayloadData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PayloadData", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayloadData sets the PayloadData field's value.
func (s *ManifestPayload) SetPayloadData(v string) *ManifestPayload {
	s.PayloadData = &v
	return s
}

// The network configuration for a device.
type NetworkPayload struct {
	_ struct{} `type:"structure"`

	// Settings for Ethernet port 0.
	Ethernet0 *EthernetPayload `type:"structure"`

	// Settings for Ethernet port 1.
	Ethernet1 *EthernetPayload `type:"structure"`

	// Network time protocol (NTP) server settings.
	Ntp *NtpPayload `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkPayload"}
	if s.Ethernet0 != nil {
		if err := s.Ethernet0.Validate(); err != nil {
			invalidParams.AddNested("Ethernet0", err.(request.ErrInvalidParams))
		}
	}
	if s.Ethernet1 != nil {
		if err := s.Ethernet1.Validate(); err != nil {
			invalidParams.AddNested("Ethernet1", err.(request.ErrInvalidParams))
		}
	}
	if s.Ntp != nil {
		if err := s.Ntp.Validate(); err != nil {
			invalidParams.AddNested("Ntp", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEthernet0 sets the Ethernet0 field's value.
func (s *NetworkPayload) SetEthernet0(v *EthernetPayload) *NetworkPayload {
	s.Ethernet0 = v
	return s
}

// SetEthernet1 sets the Ethernet1 field's value.
func (s *NetworkPayload) SetEthernet1(v *EthernetPayload) *NetworkPayload {
	s.Ethernet1 = v
	return s
}

// SetNtp sets the Ntp field's value.
func (s *NetworkPayload) SetNtp(v *NtpPayload) *NetworkPayload {
	s.Ntp = v
	return s
}

// The network status of a device.
type NetworkStatus struct {
	_ struct{} `type:"structure"`

	// The status of Ethernet port 0.
	Ethernet0Status *EthernetStatus `type:"structure"`

	// The status of Ethernet port 1.
	Ethernet1Status *EthernetStatus `type:"structure"`

	// When the network status changed.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Details about a network time protocol (NTP) server connection.
	NtpStatus *NtpStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkStatus) GoString() string {
	return s.String()
}

// SetEthernet0Status sets the Ethernet0Status field's value.
func (s *NetworkStatus) SetEthernet0Status(v *EthernetStatus) *NetworkStatus {
	s.Ethernet0Status = v
	return s
}

// SetEthernet1Status sets the Ethernet1Status field's value.
func (s *NetworkStatus) SetEthernet1Status(v *EthernetStatus) *NetworkStatus {
	s.Ethernet1Status = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *NetworkStatus) SetLastUpdatedTime(v time.Time) *NetworkStatus {
	s.LastUpdatedTime = &v
	return s
}

// SetNtpStatus sets the NtpStatus field's value.
func (s *NetworkStatus) SetNtpStatus(v *NtpStatus) *NetworkStatus {
	s.NtpStatus = v
	return s
}

// An application node that represents a camera stream, a model, code, or output.
type Node struct {
	_ struct{} `type:"structure"`

	// The node's category.
	//
	// Category is a required field
	Category *string `type:"string" required:"true" enum:"NodeCategory"`

	// When the node was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The node's description.
	Description *string `type:"string"`

	// The node's name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The node's ID.
	//
	// NodeId is a required field
	NodeId *string `min:"1" type:"string" required:"true"`

	// The account ID of the node's owner.
	OwnerAccount *string `min:"1" type:"string"`

	// The node's ARN.
	PackageArn *string `min:"1" type:"string"`

	// The node's package ID.
	//
	// PackageId is a required field
	PackageId *string `min:"1" type:"string" required:"true"`

	// The node's package name.
	//
	// PackageName is a required field
	PackageName *string `min:"1" type:"string" required:"true"`

	// The node's package version.
	//
	// PackageVersion is a required field
	PackageVersion *string `min:"1" type:"string" required:"true"`

	// The node's patch version.
	//
	// PatchVersion is a required field
	PatchVersion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Node) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Node) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *Node) SetCategory(v string) *Node {
	s.Category = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Node) SetCreatedTime(v time.Time) *Node {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Node) SetDescription(v string) *Node {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Node) SetName(v string) *Node {
	s.Name = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *Node) SetNodeId(v string) *Node {
	s.NodeId = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Node) SetOwnerAccount(v string) *Node {
	s.OwnerAccount = &v
	return s
}

// SetPackageArn sets the PackageArn field's value.
func (s *Node) SetPackageArn(v string) *Node {
	s.PackageArn = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *Node) SetPackageId(v string) *Node {
	s.PackageId = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *Node) SetPackageName(v string) *Node {
	s.PackageName = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *Node) SetPackageVersion(v string) *Node {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *Node) SetPatchVersion(v string) *Node {
	s.PatchVersion = &v
	return s
}

// A job to create a camera stream node.
type NodeFromTemplateJob struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The job's ID.
	JobId *string `min:"1" type:"string"`

	// The node's name.
	NodeName *string `min:"1" type:"string"`

	// The job's status.
	Status *string `type:"string" enum:"NodeFromTemplateJobStatus"`

	// The job's status message.
	StatusMessage *string `type:"string"`

	// The job's template type.
	TemplateType *string `type:"string" enum:"TemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeFromTemplateJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeFromTemplateJob) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *NodeFromTemplateJob) SetCreatedTime(v time.Time) *NodeFromTemplateJob {
	s.CreatedTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *NodeFromTemplateJob) SetJobId(v string) *NodeFromTemplateJob {
	s.JobId = &v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *NodeFromTemplateJob) SetNodeName(v string) *NodeFromTemplateJob {
	s.NodeName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NodeFromTemplateJob) SetStatus(v string) *NodeFromTemplateJob {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *NodeFromTemplateJob) SetStatusMessage(v string) *NodeFromTemplateJob {
	s.StatusMessage = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *NodeFromTemplateJob) SetTemplateType(v string) *NodeFromTemplateJob {
	s.TemplateType = &v
	return s
}

// A node input port.
type NodeInputPort struct {
	_ struct{} `type:"structure"`

	// The input port's default value.
	DefaultValue *string `min:"1" type:"string"`

	// The input port's description.
	Description *string `type:"string"`

	// The input port's max connections.
	MaxConnections *int64 `type:"integer"`

	// The input port's name.
	Name *string `min:"1" type:"string"`

	// The input port's type.
	Type *string `type:"string" enum:"PortType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeInputPort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeInputPort) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *NodeInputPort) SetDefaultValue(v string) *NodeInputPort {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NodeInputPort) SetDescription(v string) *NodeInputPort {
	s.Description = &v
	return s
}

// SetMaxConnections sets the MaxConnections field's value.
func (s *NodeInputPort) SetMaxConnections(v int64) *NodeInputPort {
	s.MaxConnections = &v
	return s
}

// SetName sets the Name field's value.
func (s *NodeInputPort) SetName(v string) *NodeInputPort {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *NodeInputPort) SetType(v string) *NodeInputPort {
	s.Type = &v
	return s
}

// A node instance.
type NodeInstance struct {
	_ struct{} `type:"structure"`

	// The instance's current status.
	//
	// CurrentStatus is a required field
	CurrentStatus *string `type:"string" required:"true" enum:"NodeInstanceStatus"`

	// The node's ID.
	NodeId *string `min:"1" type:"string"`

	// The instance's ID.
	//
	// NodeInstanceId is a required field
	NodeInstanceId *string `min:"1" type:"string" required:"true"`

	// The instance's name.
	NodeName *string `min:"1" type:"string"`

	// The instance's package name.
	PackageName *string `min:"1" type:"string"`

	// The instance's package patch version.
	PackagePatchVersion *string `min:"1" type:"string"`

	// The instance's package version.
	PackageVersion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeInstance) GoString() string {
	return s.String()
}

// SetCurrentStatus sets the CurrentStatus field's value.
func (s *NodeInstance) SetCurrentStatus(v string) *NodeInstance {
	s.CurrentStatus = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *NodeInstance) SetNodeId(v string) *NodeInstance {
	s.NodeId = &v
	return s
}

// SetNodeInstanceId sets the NodeInstanceId field's value.
func (s *NodeInstance) SetNodeInstanceId(v string) *NodeInstance {
	s.NodeInstanceId = &v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *NodeInstance) SetNodeName(v string) *NodeInstance {
	s.NodeName = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *NodeInstance) SetPackageName(v string) *NodeInstance {
	s.PackageName = &v
	return s
}

// SetPackagePatchVersion sets the PackagePatchVersion field's value.
func (s *NodeInstance) SetPackagePatchVersion(v string) *NodeInstance {
	s.PackagePatchVersion = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *NodeInstance) SetPackageVersion(v string) *NodeInstance {
	s.PackageVersion = &v
	return s
}

// A node interface.
type NodeInterface struct {
	_ struct{} `type:"structure"`

	// The node interface's inputs.
	//
	// Inputs is a required field
	Inputs []*NodeInputPort `type:"list" required:"true"`

	// The node interface's outputs.
	//
	// Outputs is a required field
	Outputs []*NodeOutputPort `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeInterface) GoString() string {
	return s.String()
}

// SetInputs sets the Inputs field's value.
func (s *NodeInterface) SetInputs(v []*NodeInputPort) *NodeInterface {
	s.Inputs = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *NodeInterface) SetOutputs(v []*NodeOutputPort) *NodeInterface {
	s.Outputs = v
	return s
}

// A node output port.
type NodeOutputPort struct {
	_ struct{} `type:"structure"`

	// The output port's description.
	Description *string `type:"string"`

	// The output port's name.
	Name *string `min:"1" type:"string"`

	// The output port's type.
	Type *string `type:"string" enum:"PortType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeOutputPort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeOutputPort) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *NodeOutputPort) SetDescription(v string) *NodeOutputPort {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *NodeOutputPort) SetName(v string) *NodeOutputPort {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *NodeOutputPort) SetType(v string) *NodeOutputPort {
	s.Type = &v
	return s
}

// Network time protocol (NTP) server settings. Use this option to connect to
// local NTP servers instead of pool.ntp.org.
type NtpPayload struct {
	_ struct{} `type:"structure"`

	// NTP servers to use, in order of preference.
	//
	// NtpServers is a required field
	NtpServers []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NtpPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NtpPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NtpPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NtpPayload"}
	if s.NtpServers == nil {
		invalidParams.Add(request.NewErrParamRequired("NtpServers"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNtpServers sets the NtpServers field's value.
func (s *NtpPayload) SetNtpServers(v []*string) *NtpPayload {
	s.NtpServers = v
	return s
}

// Details about an NTP server connection.
type NtpStatus struct {
	_ struct{} `type:"structure"`

	// The connection's status.
	ConnectionStatus *string `type:"string" enum:"NetworkConnectionStatus"`

	// The IP address of the server.
	IpAddress *string `min:"1" type:"string"`

	// The domain name of the server.
	NtpServerName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NtpStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NtpStatus) GoString() string {
	return s.String()
}

// SetConnectionStatus sets the ConnectionStatus field's value.
func (s *NtpStatus) SetConnectionStatus(v string) *NtpStatus {
	s.ConnectionStatus = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *NtpStatus) SetIpAddress(v string) *NtpStatus {
	s.IpAddress = &v
	return s
}

// SetNtpServerName sets the NtpServerName field's value.
func (s *NtpStatus) SetNtpServerName(v string) *NtpStatus {
	s.NtpServerName = &v
	return s
}

// An over-the-air update (OTA) job configuration.
type OTAJobConfig struct {
	_ struct{} `type:"structure"`

	// The target version of the device software.
	//
	// ImageVersion is a required field
	ImageVersion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OTAJobConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OTAJobConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OTAJobConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OTAJobConfig"}
	if s.ImageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageVersion"))
	}
	if s.ImageVersion != nil && len(*s.ImageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageVersion sets the ImageVersion field's value.
func (s *OTAJobConfig) SetImageVersion(v string) *OTAJobConfig {
	s.ImageVersion = &v
	return s
}

// The location of an output object in Amazon S3.
type OutPutS3Location struct {
	_ struct{} `type:"structure"`

	// The object's bucket.
	//
	// BucketName is a required field
	BucketName *string `min:"1" type:"string" required:"true"`

	// The object's key.
	//
	// ObjectKey is a required field
	ObjectKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutPutS3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutPutS3Location) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *OutPutS3Location) SetBucketName(v string) *OutPutS3Location {
	s.BucketName = &v
	return s
}

// SetObjectKey sets the ObjectKey field's value.
func (s *OutPutS3Location) SetObjectKey(v string) *OutPutS3Location {
	s.ObjectKey = &v
	return s
}

// A job to import a package version.
type PackageImportJob struct {
	_ struct{} `type:"structure"`

	// When the job was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The job's ID.
	JobId *string `min:"1" type:"string"`

	// The job's type.
	JobType *string `type:"string" enum:"PackageImportJobType"`

	// When the job was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The job's status.
	Status *string `type:"string" enum:"PackageImportJobStatus"`

	// The job's status message.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageImportJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageImportJob) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *PackageImportJob) SetCreatedTime(v time.Time) *PackageImportJob {
	s.CreatedTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PackageImportJob) SetJobId(v string) *PackageImportJob {
	s.JobId = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *PackageImportJob) SetJobType(v string) *PackageImportJob {
	s.JobType = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *PackageImportJob) SetLastUpdatedTime(v time.Time) *PackageImportJob {
	s.LastUpdatedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PackageImportJob) SetStatus(v string) *PackageImportJob {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *PackageImportJob) SetStatusMessage(v string) *PackageImportJob {
	s.StatusMessage = &v
	return s
}

// A configuration for a package import job.
type PackageImportJobInputConfig struct {
	_ struct{} `type:"structure"`

	// The package version's input configuration.
	PackageVersionInputConfig *PackageVersionInputConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageImportJobInputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageImportJobInputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageImportJobInputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageImportJobInputConfig"}
	if s.PackageVersionInputConfig != nil {
		if err := s.PackageVersionInputConfig.Validate(); err != nil {
			invalidParams.AddNested("PackageVersionInputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageVersionInputConfig sets the PackageVersionInputConfig field's value.
func (s *PackageImportJobInputConfig) SetPackageVersionInputConfig(v *PackageVersionInputConfig) *PackageImportJobInputConfig {
	s.PackageVersionInputConfig = v
	return s
}

// An output configuration for a package import job.
type PackageImportJobOutputConfig struct {
	_ struct{} `type:"structure"`

	// The package version's output configuration.
	PackageVersionOutputConfig *PackageVersionOutputConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageImportJobOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageImportJobOutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageImportJobOutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageImportJobOutputConfig"}
	if s.PackageVersionOutputConfig != nil {
		if err := s.PackageVersionOutputConfig.Validate(); err != nil {
			invalidParams.AddNested("PackageVersionOutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPackageVersionOutputConfig sets the PackageVersionOutputConfig field's value.
func (s *PackageImportJobOutputConfig) SetPackageVersionOutputConfig(v *PackageVersionOutputConfig) *PackageImportJobOutputConfig {
	s.PackageVersionOutputConfig = v
	return s
}

// Results of a package import job.
type PackageImportJobOutput_ struct {
	_ struct{} `type:"structure"`

	// The package's output location.
	//
	// OutputS3Location is a required field
	OutputS3Location *OutPutS3Location `type:"structure" required:"true"`

	// The package's ID.
	//
	// PackageId is a required field
	PackageId *string `min:"1" type:"string" required:"true"`

	// The package's version.
	//
	// PackageVersion is a required field
	PackageVersion *string `min:"1" type:"string" required:"true"`

	// The package's patch version.
	//
	// PatchVersion is a required field
	PatchVersion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageImportJobOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageImportJobOutput_) GoString() string {
	return s.String()
}

// SetOutputS3Location sets the OutputS3Location field's value.
func (s *PackageImportJobOutput_) SetOutputS3Location(v *OutPutS3Location) *PackageImportJobOutput_ {
	s.OutputS3Location = v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *PackageImportJobOutput_) SetPackageId(v string) *PackageImportJobOutput_ {
	s.PackageId = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *PackageImportJobOutput_) SetPackageVersion(v string) *PackageImportJobOutput_ {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *PackageImportJobOutput_) SetPatchVersion(v string) *PackageImportJobOutput_ {
	s.PatchVersion = &v
	return s
}

// A package summary.
type PackageListItem struct {
	_ struct{} `type:"structure"`

	// The package's ARN.
	Arn *string `min:"1" type:"string"`

	// When the package was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The package's ID.
	PackageId *string `min:"1" type:"string"`

	// The package's name.
	PackageName *string `min:"1" type:"string"`

	// The package's tags.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageListItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PackageListItem) SetArn(v string) *PackageListItem {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *PackageListItem) SetCreatedTime(v time.Time) *PackageListItem {
	s.CreatedTime = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *PackageListItem) SetPackageId(v string) *PackageListItem {
	s.PackageId = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *PackageListItem) SetPackageName(v string) *PackageListItem {
	s.PackageName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PackageListItem) SetTags(v map[string]*string) *PackageListItem {
	s.Tags = v
	return s
}

// A package object.
type PackageObject struct {
	_ struct{} `type:"structure"`

	// The object's name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The object's package version.
	//
	// PackageVersion is a required field
	PackageVersion *string `min:"1" type:"string" required:"true"`

	// The object's patch version.
	//
	// PatchVersion is a required field
	PatchVersion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageObject) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *PackageObject) SetName(v string) *PackageObject {
	s.Name = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *PackageObject) SetPackageVersion(v string) *PackageObject {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *PackageObject) SetPatchVersion(v string) *PackageObject {
	s.PatchVersion = &v
	return s
}

// A package version input configuration.
type PackageVersionInputConfig struct {
	_ struct{} `type:"structure"`

	// A location in Amazon S3.
	//
	// S3Location is a required field
	S3Location *S3Location `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionInputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionInputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageVersionInputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageVersionInputConfig"}
	if s.S3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Location"))
	}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *PackageVersionInputConfig) SetS3Location(v *S3Location) *PackageVersionInputConfig {
	s.S3Location = v
	return s
}

// A package version output configuration.
type PackageVersionOutputConfig struct {
	_ struct{} `type:"structure"`

	// Indicates that the version is recommended for all users.
	MarkLatest *bool `type:"boolean"`

	// The output's package name.
	//
	// PackageName is a required field
	PackageName *string `min:"1" type:"string" required:"true"`

	// The output's package version.
	//
	// PackageVersion is a required field
	PackageVersion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PackageVersionOutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PackageVersionOutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PackageVersionOutputConfig"}
	if s.PackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageName", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarkLatest sets the MarkLatest field's value.
func (s *PackageVersionOutputConfig) SetMarkLatest(v bool) *PackageVersionOutputConfig {
	s.MarkLatest = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *PackageVersionOutputConfig) SetPackageName(v string) *PackageVersionOutputConfig {
	s.PackageName = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *PackageVersionOutputConfig) SetPackageVersion(v string) *PackageVersionOutputConfig {
	s.PackageVersion = &v
	return s
}

type ProvisionDeviceInput struct {
	_ struct{} `type:"structure"`

	// A description for the device.
	Description *string `type:"string"`

	// A name for the device.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A networking configuration for the device.
	NetworkingConfiguration *NetworkPayload `type:"structure"`

	// Tags for the device.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionDeviceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NetworkingConfiguration != nil {
		if err := s.NetworkingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ProvisionDeviceInput) SetDescription(v string) *ProvisionDeviceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProvisionDeviceInput) SetName(v string) *ProvisionDeviceInput {
	s.Name = &v
	return s
}

// SetNetworkingConfiguration sets the NetworkingConfiguration field's value.
func (s *ProvisionDeviceInput) SetNetworkingConfiguration(v *NetworkPayload) *ProvisionDeviceInput {
	s.NetworkingConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ProvisionDeviceInput) SetTags(v map[string]*string) *ProvisionDeviceInput {
	s.Tags = v
	return s
}

type ProvisionDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device's ARN.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The device's configuration bundle.
	// Certificates is automatically base64 encoded/decoded by the SDK.
	Certificates []byte `type:"blob"`

	// The device's ID.
	DeviceId *string `min:"1" type:"string"`

	// The device's IoT thing name.
	IotThingName *string `min:"1" type:"string"`

	// The device's status.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"DeviceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionDeviceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ProvisionDeviceOutput) SetArn(v string) *ProvisionDeviceOutput {
	s.Arn = &v
	return s
}

// SetCertificates sets the Certificates field's value.
func (s *ProvisionDeviceOutput) SetCertificates(v []byte) *ProvisionDeviceOutput {
	s.Certificates = v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *ProvisionDeviceOutput) SetDeviceId(v string) *ProvisionDeviceOutput {
	s.DeviceId = &v
	return s
}

// SetIotThingName sets the IotThingName field's value.
func (s *ProvisionDeviceOutput) SetIotThingName(v string) *ProvisionDeviceOutput {
	s.IotThingName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProvisionDeviceOutput) SetStatus(v string) *ProvisionDeviceOutput {
	s.Status = &v
	return s
}

type RegisterPackageVersionInput struct {
	_ struct{} `type:"structure"`

	// Whether to mark the new version as the latest version.
	MarkLatest *bool `type:"boolean"`

	// An owner account.
	OwnerAccount *string `min:"1" type:"string"`

	// A package ID.
	//
	// PackageId is a required field
	PackageId *string `location:"uri" locationName:"PackageId" min:"1" type:"string" required:"true"`

	// A package version.
	//
	// PackageVersion is a required field
	PackageVersion *string `location:"uri" locationName:"PackageVersion" min:"1" type:"string" required:"true"`

	// A patch version.
	//
	// PatchVersion is a required field
	PatchVersion *string `location:"uri" locationName:"PatchVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterPackageVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterPackageVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterPackageVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterPackageVersionInput"}
	if s.OwnerAccount != nil && len(*s.OwnerAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerAccount", 1))
	}
	if s.PackageId == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageId"))
	}
	if s.PackageId != nil && len(*s.PackageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageId", 1))
	}
	if s.PackageVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageVersion"))
	}
	if s.PackageVersion != nil && len(*s.PackageVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageVersion", 1))
	}
	if s.PatchVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PatchVersion"))
	}
	if s.PatchVersion != nil && len(*s.PatchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarkLatest sets the MarkLatest field's value.
func (s *RegisterPackageVersionInput) SetMarkLatest(v bool) *RegisterPackageVersionInput {
	s.MarkLatest = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *RegisterPackageVersionInput) SetOwnerAccount(v string) *RegisterPackageVersionInput {
	s.OwnerAccount = &v
	return s
}

// SetPackageId sets the PackageId field's value.
func (s *RegisterPackageVersionInput) SetPackageId(v string) *RegisterPackageVersionInput {
	s.PackageId = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *RegisterPackageVersionInput) SetPackageVersion(v string) *RegisterPackageVersionInput {
	s.PackageVersion = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *RegisterPackageVersionInput) SetPatchVersion(v string) *RegisterPackageVersionInput {
	s.PatchVersion = &v
	return s
}

type RegisterPackageVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterPackageVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterPackageVersionOutput) GoString() string {
	return s.String()
}

type RemoveApplicationInstanceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An application instance ID.
	//
	// ApplicationInstanceId is a required field
	ApplicationInstanceId *string `location:"uri" locationName:"ApplicationInstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveApplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveApplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveApplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveApplicationInstanceInput"}
	if s.ApplicationInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationInstanceId"))
	}
	if s.ApplicationInstanceId != nil && len(*s.ApplicationInstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationInstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationInstanceId sets the ApplicationInstanceId field's value.
func (s *RemoveApplicationInstanceInput) SetApplicationInstanceId(v string) *RemoveApplicationInstanceInput {
	s.ApplicationInstanceId = &v
	return s
}

type RemoveApplicationInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveApplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveApplicationInstanceOutput) GoString() string {
	return s.String()
}

// The target resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The resource's ID.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The resource's type.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A location in Amazon S3.
type S3Location struct {
	_ struct{} `type:"structure"`

	// A bucket name.
	//
	// BucketName is a required field
	BucketName *string `min:"1" type:"string" required:"true"`

	// An object key.
	//
	// ObjectKey is a required field
	ObjectKey *string `min:"1" type:"string" required:"true"`

	// The bucket's Region.
	Region *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 1))
	}
	if s.ObjectKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectKey"))
	}
	if s.ObjectKey != nil && len(*s.ObjectKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectKey", 1))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Location) SetBucketName(v string) *S3Location {
	s.BucketName = &v
	return s
}

// SetObjectKey sets the ObjectKey field's value.
func (s *S3Location) SetObjectKey(v string) *S3Location {
	s.ObjectKey = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *S3Location) SetRegion(v string) *S3Location {
	s.Region = &v
	return s
}

// The request would cause a limit to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the limit.
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// The target resource's ID.
	ResourceId *string `type:"string"`

	// The target resource's type.
	ResourceType *string `type:"string"`

	// The name of the service.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A static IP configuration.
type StaticIpConnectionInfo struct {
	_ struct{} `type:"structure"`

	// The connection's default gateway.
	//
	// DefaultGateway is a required field
	DefaultGateway *string `min:"1" type:"string" required:"true"`

	// The connection's DNS address.
	//
	// Dns is a required field
	Dns []*string `type:"list" required:"true"`

	// The connection's IP address.
	//
	// IpAddress is a required field
	IpAddress *string `min:"1" type:"string" required:"true"`

	// The connection's DNS mask.
	//
	// Mask is a required field
	Mask *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticIpConnectionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticIpConnectionInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticIpConnectionInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StaticIpConnectionInfo"}
	if s.DefaultGateway == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultGateway"))
	}
	if s.DefaultGateway != nil && len(*s.DefaultGateway) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultGateway", 1))
	}
	if s.Dns == nil {
		invalidParams.Add(request.NewErrParamRequired("Dns"))
	}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.IpAddress != nil && len(*s.IpAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpAddress", 1))
	}
	if s.Mask == nil {
		invalidParams.Add(request.NewErrParamRequired("Mask"))
	}
	if s.Mask != nil && len(*s.Mask) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Mask", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultGateway sets the DefaultGateway field's value.
func (s *StaticIpConnectionInfo) SetDefaultGateway(v string) *StaticIpConnectionInfo {
	s.DefaultGateway = &v
	return s
}

// SetDns sets the Dns field's value.
func (s *StaticIpConnectionInfo) SetDns(v []*string) *StaticIpConnectionInfo {
	s.Dns = v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *StaticIpConnectionInfo) SetIpAddress(v string) *StaticIpConnectionInfo {
	s.IpAddress = &v
	return s
}

// SetMask sets the Mask field's value.
func (s *StaticIpConnectionInfo) SetMask(v string) *StaticIpConnectionInfo {
	s.Mask = &v
	return s
}

// A storage location.
type StorageLocation struct {
	_ struct{} `type:"structure"`

	// The location's binary prefix.
	//
	// BinaryPrefixLocation is a required field
	BinaryPrefixLocation *string `type:"string" required:"true"`

	// The location's bucket.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The location's generated prefix.
	//
	// GeneratedPrefixLocation is a required field
	GeneratedPrefixLocation *string `type:"string" required:"true"`

	// The location's manifest prefix.
	//
	// ManifestPrefixLocation is a required field
	ManifestPrefixLocation *string `type:"string" required:"true"`

	// The location's repo prefix.
	//
	// RepoPrefixLocation is a required field
	RepoPrefixLocation *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageLocation) GoString() string {
	return s.String()
}

// SetBinaryPrefixLocation sets the BinaryPrefixLocation field's value.
func (s *StorageLocation) SetBinaryPrefixLocation(v string) *StorageLocation {
	s.BinaryPrefixLocation = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *StorageLocation) SetBucket(v string) *StorageLocation {
	s.Bucket = &v
	return s
}

// SetGeneratedPrefixLocation sets the GeneratedPrefixLocation field's value.
func (s *StorageLocation) SetGeneratedPrefixLocation(v string) *StorageLocation {
	s.GeneratedPrefixLocation = &v
	return s
}

// SetManifestPrefixLocation sets the ManifestPrefixLocation field's value.
func (s *StorageLocation) SetManifestPrefixLocation(v string) *StorageLocation {
	s.ManifestPrefixLocation = &v
	return s
}

// SetRepoPrefixLocation sets the RepoPrefixLocation field's value.
func (s *StorageLocation) SetRepoPrefixLocation(v string) *StorageLocation {
	s.RepoPrefixLocation = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// Tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource's ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// Tag keys to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDeviceMetadataInput struct {
	_ struct{} `type:"structure"`

	// A description for the device.
	Description *string `type:"string"`

	// The device's ID.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceMetadataInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDeviceMetadataInput) SetDescription(v string) *UpdateDeviceMetadataInput {
	s.Description = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *UpdateDeviceMetadataInput) SetDeviceId(v string) *UpdateDeviceMetadataInput {
	s.DeviceId = &v
	return s
}

type UpdateDeviceMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The device's ID.
	DeviceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeviceMetadataOutput) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *UpdateDeviceMetadataOutput) SetDeviceId(v string) *UpdateDeviceMetadataOutput {
	s.DeviceId = &v
	return s
}

// The request contains an invalid parameter value.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of attributes that led to the exception and their values.
	ErrorArguments []*ValidationExceptionErrorArgument `type:"list"`

	// A unique ID for the error.
	ErrorId *string `type:"string"`

	// A list of request parameters that failed validation.
	Fields []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason that validation failed.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A validation exception error argument.
type ValidationExceptionErrorArgument struct {
	_ struct{} `type:"structure"`

	// The argument's name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The argument's value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionErrorArgument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionErrorArgument) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ValidationExceptionErrorArgument) SetName(v string) *ValidationExceptionErrorArgument {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ValidationExceptionErrorArgument) SetValue(v string) *ValidationExceptionErrorArgument {
	s.Value = &v
	return s
}

// A validation exception field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The field's message.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The field's name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// ApplicationInstanceHealthStatusRunning is a ApplicationInstanceHealthStatus enum value
	ApplicationInstanceHealthStatusRunning = "RUNNING"

	// ApplicationInstanceHealthStatusError is a ApplicationInstanceHealthStatus enum value
	ApplicationInstanceHealthStatusError = "ERROR"

	// ApplicationInstanceHealthStatusNotAvailable is a ApplicationInstanceHealthStatus enum value
	ApplicationInstanceHealthStatusNotAvailable = "NOT_AVAILABLE"
)

// ApplicationInstanceHealthStatus_Values returns all elements of the ApplicationInstanceHealthStatus enum
func ApplicationInstanceHealthStatus_Values() []string {
	return []string{
		ApplicationInstanceHealthStatusRunning,
		ApplicationInstanceHealthStatusError,
		ApplicationInstanceHealthStatusNotAvailable,
	}
}

const (
	// ApplicationInstanceStatusDeploymentPending is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusDeploymentPending = "DEPLOYMENT_PENDING"

	// ApplicationInstanceStatusDeploymentRequested is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusDeploymentRequested = "DEPLOYMENT_REQUESTED"

	// ApplicationInstanceStatusDeploymentInProgress is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusDeploymentInProgress = "DEPLOYMENT_IN_PROGRESS"

	// ApplicationInstanceStatusDeploymentError is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusDeploymentError = "DEPLOYMENT_ERROR"

	// ApplicationInstanceStatusDeploymentSucceeded is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusDeploymentSucceeded = "DEPLOYMENT_SUCCEEDED"

	// ApplicationInstanceStatusRemovalPending is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusRemovalPending = "REMOVAL_PENDING"

	// ApplicationInstanceStatusRemovalRequested is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusRemovalRequested = "REMOVAL_REQUESTED"

	// ApplicationInstanceStatusRemovalInProgress is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusRemovalInProgress = "REMOVAL_IN_PROGRESS"

	// ApplicationInstanceStatusRemovalFailed is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusRemovalFailed = "REMOVAL_FAILED"

	// ApplicationInstanceStatusRemovalSucceeded is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusRemovalSucceeded = "REMOVAL_SUCCEEDED"

	// ApplicationInstanceStatusDeploymentFailed is a ApplicationInstanceStatus enum value
	ApplicationInstanceStatusDeploymentFailed = "DEPLOYMENT_FAILED"
)

// ApplicationInstanceStatus_Values returns all elements of the ApplicationInstanceStatus enum
func ApplicationInstanceStatus_Values() []string {
	return []string{
		ApplicationInstanceStatusDeploymentPending,
		ApplicationInstanceStatusDeploymentRequested,
		ApplicationInstanceStatusDeploymentInProgress,
		ApplicationInstanceStatusDeploymentError,
		ApplicationInstanceStatusDeploymentSucceeded,
		ApplicationInstanceStatusRemovalPending,
		ApplicationInstanceStatusRemovalRequested,
		ApplicationInstanceStatusRemovalInProgress,
		ApplicationInstanceStatusRemovalFailed,
		ApplicationInstanceStatusRemovalSucceeded,
		ApplicationInstanceStatusDeploymentFailed,
	}
}

const (
	// ConnectionTypeStaticIp is a ConnectionType enum value
	ConnectionTypeStaticIp = "STATIC_IP"

	// ConnectionTypeDhcp is a ConnectionType enum value
	ConnectionTypeDhcp = "DHCP"
)

// ConnectionType_Values returns all elements of the ConnectionType enum
func ConnectionType_Values() []string {
	return []string{
		ConnectionTypeStaticIp,
		ConnectionTypeDhcp,
	}
}

const (
	// DeviceBrandAwsPanorama is a DeviceBrand enum value
	DeviceBrandAwsPanorama = "AWS_PANORAMA"

	// DeviceBrandLenovo is a DeviceBrand enum value
	DeviceBrandLenovo = "LENOVO"
)

// DeviceBrand_Values returns all elements of the DeviceBrand enum
func DeviceBrand_Values() []string {
	return []string{
		DeviceBrandAwsPanorama,
		DeviceBrandLenovo,
	}
}

const (
	// DeviceConnectionStatusOnline is a DeviceConnectionStatus enum value
	DeviceConnectionStatusOnline = "ONLINE"

	// DeviceConnectionStatusOffline is a DeviceConnectionStatus enum value
	DeviceConnectionStatusOffline = "OFFLINE"

	// DeviceConnectionStatusAwaitingCredentials is a DeviceConnectionStatus enum value
	DeviceConnectionStatusAwaitingCredentials = "AWAITING_CREDENTIALS"

	// DeviceConnectionStatusNotAvailable is a DeviceConnectionStatus enum value
	DeviceConnectionStatusNotAvailable = "NOT_AVAILABLE"

	// DeviceConnectionStatusError is a DeviceConnectionStatus enum value
	DeviceConnectionStatusError = "ERROR"
)

// DeviceConnectionStatus_Values returns all elements of the DeviceConnectionStatus enum
func DeviceConnectionStatus_Values() []string {
	return []string{
		DeviceConnectionStatusOnline,
		DeviceConnectionStatusOffline,
		DeviceConnectionStatusAwaitingCredentials,
		DeviceConnectionStatusNotAvailable,
		DeviceConnectionStatusError,
	}
}

const (
	// DeviceStatusAwaitingProvisioning is a DeviceStatus enum value
	DeviceStatusAwaitingProvisioning = "AWAITING_PROVISIONING"

	// DeviceStatusPending is a DeviceStatus enum value
	DeviceStatusPending = "PENDING"

	// DeviceStatusSucceeded is a DeviceStatus enum value
	DeviceStatusSucceeded = "SUCCEEDED"

	// DeviceStatusFailed is a DeviceStatus enum value
	DeviceStatusFailed = "FAILED"

	// DeviceStatusError is a DeviceStatus enum value
	DeviceStatusError = "ERROR"

	// DeviceStatusDeleting is a DeviceStatus enum value
	DeviceStatusDeleting = "DELETING"
)

// DeviceStatus_Values returns all elements of the DeviceStatus enum
func DeviceStatus_Values() []string {
	return []string{
		DeviceStatusAwaitingProvisioning,
		DeviceStatusPending,
		DeviceStatusSucceeded,
		DeviceStatusFailed,
		DeviceStatusError,
		DeviceStatusDeleting,
	}
}

const (
	// DeviceTypePanoramaApplianceDeveloperKit is a DeviceType enum value
	DeviceTypePanoramaApplianceDeveloperKit = "PANORAMA_APPLIANCE_DEVELOPER_KIT"

	// DeviceTypePanoramaAppliance is a DeviceType enum value
	DeviceTypePanoramaAppliance = "PANORAMA_APPLIANCE"
)

// DeviceType_Values returns all elements of the DeviceType enum
func DeviceType_Values() []string {
	return []string{
		DeviceTypePanoramaApplianceDeveloperKit,
		DeviceTypePanoramaAppliance,
	}
}

const (
	// JobResourceTypePackage is a JobResourceType enum value
	JobResourceTypePackage = "PACKAGE"
)

// JobResourceType_Values returns all elements of the JobResourceType enum
func JobResourceType_Values() []string {
	return []string{
		JobResourceTypePackage,
	}
}

const (
	// JobTypeOta is a JobType enum value
	JobTypeOta = "OTA"
)

// JobType_Values returns all elements of the JobType enum
func JobType_Values() []string {
	return []string{
		JobTypeOta,
	}
}

const (
	// NetworkConnectionStatusConnected is a NetworkConnectionStatus enum value
	NetworkConnectionStatusConnected = "CONNECTED"

	// NetworkConnectionStatusNotConnected is a NetworkConnectionStatus enum value
	NetworkConnectionStatusNotConnected = "NOT_CONNECTED"

	// NetworkConnectionStatusConnecting is a NetworkConnectionStatus enum value
	NetworkConnectionStatusConnecting = "CONNECTING"
)

// NetworkConnectionStatus_Values returns all elements of the NetworkConnectionStatus enum
func NetworkConnectionStatus_Values() []string {
	return []string{
		NetworkConnectionStatusConnected,
		NetworkConnectionStatusNotConnected,
		NetworkConnectionStatusConnecting,
	}
}

const (
	// NodeCategoryBusinessLogic is a NodeCategory enum value
	NodeCategoryBusinessLogic = "BUSINESS_LOGIC"

	// NodeCategoryMlModel is a NodeCategory enum value
	NodeCategoryMlModel = "ML_MODEL"

	// NodeCategoryMediaSource is a NodeCategory enum value
	NodeCategoryMediaSource = "MEDIA_SOURCE"

	// NodeCategoryMediaSink is a NodeCategory enum value
	NodeCategoryMediaSink = "MEDIA_SINK"
)

// NodeCategory_Values returns all elements of the NodeCategory enum
func NodeCategory_Values() []string {
	return []string{
		NodeCategoryBusinessLogic,
		NodeCategoryMlModel,
		NodeCategoryMediaSource,
		NodeCategoryMediaSink,
	}
}

const (
	// NodeFromTemplateJobStatusPending is a NodeFromTemplateJobStatus enum value
	NodeFromTemplateJobStatusPending = "PENDING"

	// NodeFromTemplateJobStatusSucceeded is a NodeFromTemplateJobStatus enum value
	NodeFromTemplateJobStatusSucceeded = "SUCCEEDED"

	// NodeFromTemplateJobStatusFailed is a NodeFromTemplateJobStatus enum value
	NodeFromTemplateJobStatusFailed = "FAILED"
)

// NodeFromTemplateJobStatus_Values returns all elements of the NodeFromTemplateJobStatus enum
func NodeFromTemplateJobStatus_Values() []string {
	return []string{
		NodeFromTemplateJobStatusPending,
		NodeFromTemplateJobStatusSucceeded,
		NodeFromTemplateJobStatusFailed,
	}
}

const (
	// NodeInstanceStatusRunning is a NodeInstanceStatus enum value
	NodeInstanceStatusRunning = "RUNNING"

	// NodeInstanceStatusError is a NodeInstanceStatus enum value
	NodeInstanceStatusError = "ERROR"

	// NodeInstanceStatusNotAvailable is a NodeInstanceStatus enum value
	NodeInstanceStatusNotAvailable = "NOT_AVAILABLE"
)

// NodeInstanceStatus_Values returns all elements of the NodeInstanceStatus enum
func NodeInstanceStatus_Values() []string {
	return []string{
		NodeInstanceStatusRunning,
		NodeInstanceStatusError,
		NodeInstanceStatusNotAvailable,
	}
}

const (
	// PackageImportJobStatusPending is a PackageImportJobStatus enum value
	PackageImportJobStatusPending = "PENDING"

	// PackageImportJobStatusSucceeded is a PackageImportJobStatus enum value
	PackageImportJobStatusSucceeded = "SUCCEEDED"

	// PackageImportJobStatusFailed is a PackageImportJobStatus enum value
	PackageImportJobStatusFailed = "FAILED"
)

// PackageImportJobStatus_Values returns all elements of the PackageImportJobStatus enum
func PackageImportJobStatus_Values() []string {
	return []string{
		PackageImportJobStatusPending,
		PackageImportJobStatusSucceeded,
		PackageImportJobStatusFailed,
	}
}

const (
	// PackageImportJobTypeNodePackageVersion is a PackageImportJobType enum value
	PackageImportJobTypeNodePackageVersion = "NODE_PACKAGE_VERSION"

	// PackageImportJobTypeMarketplaceNodePackageVersion is a PackageImportJobType enum value
	PackageImportJobTypeMarketplaceNodePackageVersion = "MARKETPLACE_NODE_PACKAGE_VERSION"
)

// PackageImportJobType_Values returns all elements of the PackageImportJobType enum
func PackageImportJobType_Values() []string {
	return []string{
		PackageImportJobTypeNodePackageVersion,
		PackageImportJobTypeMarketplaceNodePackageVersion,
	}
}

const (
	// PackageVersionStatusRegisterPending is a PackageVersionStatus enum value
	PackageVersionStatusRegisterPending = "REGISTER_PENDING"

	// PackageVersionStatusRegisterCompleted is a PackageVersionStatus enum value
	PackageVersionStatusRegisterCompleted = "REGISTER_COMPLETED"

	// PackageVersionStatusFailed is a PackageVersionStatus enum value
	PackageVersionStatusFailed = "FAILED"

	// PackageVersionStatusDeleting is a PackageVersionStatus enum value
	PackageVersionStatusDeleting = "DELETING"
)

// PackageVersionStatus_Values returns all elements of the PackageVersionStatus enum
func PackageVersionStatus_Values() []string {
	return []string{
		PackageVersionStatusRegisterPending,
		PackageVersionStatusRegisterCompleted,
		PackageVersionStatusFailed,
		PackageVersionStatusDeleting,
	}
}

const (
	// PortTypeBoolean is a PortType enum value
	PortTypeBoolean = "BOOLEAN"

	// PortTypeString is a PortType enum value
	PortTypeString = "STRING"

	// PortTypeInt32 is a PortType enum value
	PortTypeInt32 = "INT32"

	// PortTypeFloat32 is a PortType enum value
	PortTypeFloat32 = "FLOAT32"

	// PortTypeMedia is a PortType enum value
	PortTypeMedia = "MEDIA"
)

// PortType_Values returns all elements of the PortType enum
func PortType_Values() []string {
	return []string{
		PortTypeBoolean,
		PortTypeString,
		PortTypeInt32,
		PortTypeFloat32,
		PortTypeMedia,
	}
}

const (
	// StatusFilterDeploymentSucceeded is a StatusFilter enum value
	StatusFilterDeploymentSucceeded = "DEPLOYMENT_SUCCEEDED"

	// StatusFilterDeploymentError is a StatusFilter enum value
	StatusFilterDeploymentError = "DEPLOYMENT_ERROR"

	// StatusFilterRemovalSucceeded is a StatusFilter enum value
	StatusFilterRemovalSucceeded = "REMOVAL_SUCCEEDED"

	// StatusFilterRemovalFailed is a StatusFilter enum value
	StatusFilterRemovalFailed = "REMOVAL_FAILED"

	// StatusFilterProcessingDeployment is a StatusFilter enum value
	StatusFilterProcessingDeployment = "PROCESSING_DEPLOYMENT"

	// StatusFilterProcessingRemoval is a StatusFilter enum value
	StatusFilterProcessingRemoval = "PROCESSING_REMOVAL"

	// StatusFilterDeploymentFailed is a StatusFilter enum value
	StatusFilterDeploymentFailed = "DEPLOYMENT_FAILED"
)

// StatusFilter_Values returns all elements of the StatusFilter enum
func StatusFilter_Values() []string {
	return []string{
		StatusFilterDeploymentSucceeded,
		StatusFilterDeploymentError,
		StatusFilterRemovalSucceeded,
		StatusFilterRemovalFailed,
		StatusFilterProcessingDeployment,
		StatusFilterProcessingRemoval,
		StatusFilterDeploymentFailed,
	}
}

const (
	// TemplateTypeRtspCameraStream is a TemplateType enum value
	TemplateTypeRtspCameraStream = "RTSP_CAMERA_STREAM"
)

// TemplateType_Values returns all elements of the TemplateType enum
func TemplateType_Values() []string {
	return []string{
		TemplateTypeRtspCameraStream,
	}
}

const (
	// UpdateProgressPending is a UpdateProgress enum value
	UpdateProgressPending = "PENDING"

	// UpdateProgressInProgress is a UpdateProgress enum value
	UpdateProgressInProgress = "IN_PROGRESS"

	// UpdateProgressVerifying is a UpdateProgress enum value
	UpdateProgressVerifying = "VERIFYING"

	// UpdateProgressRebooting is a UpdateProgress enum value
	UpdateProgressRebooting = "REBOOTING"

	// UpdateProgressDownloading is a UpdateProgress enum value
	UpdateProgressDownloading = "DOWNLOADING"

	// UpdateProgressCompleted is a UpdateProgress enum value
	UpdateProgressCompleted = "COMPLETED"

	// UpdateProgressFailed is a UpdateProgress enum value
	UpdateProgressFailed = "FAILED"
)

// UpdateProgress_Values returns all elements of the UpdateProgress enum
func UpdateProgress_Values() []string {
	return []string{
		UpdateProgressPending,
		UpdateProgressInProgress,
		UpdateProgressVerifying,
		UpdateProgressRebooting,
		UpdateProgressDownloading,
		UpdateProgressCompleted,
		UpdateProgressFailed,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
