// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ivschat provides the client and types for making API
// requests to Amazon Interactive Video Service Chat.
//
// Introduction
//
// The Amazon IVS Chat control-plane API enables you to create and manage Amazon
// IVS Chat resources. You also need to integrate with the Amazon IVS Chat Messaging
// API (https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/chat-messaging-api.html),
// to enable users to interact with chat rooms in real time.
//
// The API is an AWS regional service. For a list of supported regions and Amazon
// IVS Chat HTTPS service endpoints, see the Amazon IVS Chat information on
// the Amazon IVS page (https://docs.aws.amazon.com/general/latest/gr/ivs.html)
// in the AWS General Reference.
//
// Notes on terminology:
//
//    * You create service applications using the Amazon IVS Chat API. We refer
//    to these as applications.
//
//    * You create front-end client applications (browser and Android/iOS apps)
//    using the Amazon IVS Chat Messaging API. We refer to these as clients.
//
//    <p> <b>Resources</b> </p> <p>The following resource is part of Amazon
//    IVS Chat:</p> <ul> <li> <p> <b>Room</b> — The central Amazon IVS Chat
//    resource through which clients connect to and exchange chat messages.
//    See the Room endpoints for more information.</p> </li> </ul> <p> <b>API
//    Access Security</b> </p> <p>Your Amazon IVS Chat applications (service
//    applications and clients) must be authenticated and authorized to access
//    Amazon IVS Chat resources. Note the differences between these concepts:</p>
//    <ul> <li> <p> <i>Authentication</i> is about verifying identity. Requests
//    to the Amazon IVS Chat API must be signed to verify your identity.</p>
//    </li> <li> <p> <i>Authorization</i> is about granting permissions. Your
//    IAM roles need to have permissions for Amazon IVS Chat API requests.</p>
//    </li> </ul> <p>Users (viewers) connect to a room using secure access tokens
//    that you create using the <a>CreateChatToken</a> endpoint through the
//    AWS SDK. You call CreateChatToken for every user’s chat session, passing
//    identity and authorization information about the user.</p> <p> <b>Signing
//    API Requests</b> </p> <p>HTTP API requests must be signed with an AWS
//    SigV4 signature using your AWS security credentials. The AWS Command Line
//    Interface (CLI) and the AWS SDKs take care of signing the underlying API
//    calls for you. However, if your application calls the Amazon IVS Chat
//    HTTP API directly, it’s your responsibility to sign the requests.</p>
//    <p>You generate a signature using valid AWS credentials for an IAM role
//    that has permission to perform the requested action. For example, DeleteMessage
//    requests must be made using an IAM role that has the <code>ivschat:DeleteMessage</code>
//    permission.</p> <p>For more information:</p> <ul> <li> <p>Authentication
//    and generating signatures — See <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating
//    Requests (Amazon Web Services Signature Version 4)</a> in the <i>Amazon
//    Web Services General Reference</i>.</p> </li> <li> <p>Managing Amazon
//    IVS permissions — See <a href="https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html">Identity
//    and Access Management</a> on the Security page of the <i>Amazon IVS User
//    Guide</i>.</p> </li> </ul> <p> <b>Messaging Endpoints</b> </p> <ul> <li>
//    <p> <a>DeleteMessage</a> — Sends an event to a specific room which directs
//    clients to delete a specific message; that is, unrender it from view and
//    delete it from the client’s chat history. This event’s <code>EventName</code>
//    is <code>aws:DELETE_MESSAGE</code>. This replicates the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html">
//    DeleteMessage</a> WebSocket operation in the Amazon IVS Chat Messaging
//    API.</p> </li> <li> <p> <a>DisconnectUser</a> — Disconnects all connections
//    using a specified user ID from a room. This replicates the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html">
//    DisconnectUser</a> WebSocket operation in the Amazon IVS Chat Messaging
//    API.</p> </li> <li> <p> <a>SendEvent</a> — Sends an event to a room.
//    Use this within your application’s business logic to send events to
//    clients of a room; e.g., to notify clients to change the way the chat
//    UI is rendered.</p> </li> </ul> <p> <b>Chat Token Endpoint</b> </p> <ul>
//    <li> <p> <a>CreateChatToken</a> — Creates an encrypted token that is
//    used to establish an individual WebSocket connection to a room. The token
//    is valid for one minute, and a connection (session) established with the
//    token is valid for the specified duration.</p> </li> </ul> <p> <b>Room
//    Endpoints</b> </p> <ul> <li> <p> <a>CreateRoom</a> — Creates a room
//    that allows clients to connect and pass messages.</p> </li> <li> <p> <a>DeleteRoom</a>
//    — Deletes the specified room.</p> </li> <li> <p> <a>GetRoom</a> —
//    Gets the specified room.</p> </li> <li> <p> <a>ListRooms</a> — Gets
//    summary information about all your rooms in the AWS region where the API
//    request is processed. </p> </li> <li> <p> <a>UpdateRoom</a> — Updates
//    a room’s configuration.</p> </li> </ul> <p> <b>Tags Endpoints</b> </p>
//    <ul> <li> <p> <a>ListTagsForResource</a> — Gets information about AWS
//    tags for the specified ARN.</p> </li> <li> <p> <a>TagResource</a> —
//    Adds or updates tags for the AWS resource with the specified ARN.</p>
//    </li> <li> <p> <a>UntagResource</a> — Removes tags from the resource
//    with the specified ARN.</p> </li> </ul> <p>All the above are HTTP operations.
//    There is a separate <i>messaging</i> API for managing Chat resources;
//    see the <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/chat-messaging-api.html">
//    Amazon IVS Chat Messaging API Reference</a>.</p>
//
// See https://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14 for more information on this service.
//
// See ivschat package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/ivschat/
//
// Using the Client
//
// To contact Amazon Interactive Video Service Chat with the SDK use the New function to create
// a new service client. With that client you can make API requests to the service.
// These clients are safe to use concurrently.
//
// See the SDK's documentation for more information on how to use the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws.Config documentation for more information on configuring SDK clients.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the Amazon Interactive Video Service Chat client Ivschat for more
// information on creating client for this service.
// https://docs.aws.amazon.com/sdk-for-go/api/service/ivschat/#New
package ivschat
