// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetAggregateResourceConfig = "BatchGetAggregateResourceConfig"

// BatchGetAggregateResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetAggregateResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetAggregateResourceConfig for more information on using the BatchGetAggregateResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetAggregateResourceConfigRequest method.
//    req, resp := client.BatchGetAggregateResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig
func (c *ConfigService) BatchGetAggregateResourceConfigRequest(input *BatchGetAggregateResourceConfigInput) (req *request.Request, output *BatchGetAggregateResourceConfigOutput) {
	op := &request.Operation{
		Name:       opBatchGetAggregateResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetAggregateResourceConfigInput{}
	}

	output = &BatchGetAggregateResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetAggregateResourceConfig API operation for AWS Config.
//
// Returns the current configuration items for resources that are present in
// your Config aggregator. The operation also returns a list of resources that
// are not processed in the current request. If there are no unprocessed resources,
// the operation returns an empty unprocessedResourceIdentifiers list.
//
//    * The API does not return results for deleted resources.
//
//    * The API does not return tags and relationships.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation BatchGetAggregateResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig
func (c *ConfigService) BatchGetAggregateResourceConfig(input *BatchGetAggregateResourceConfigInput) (*BatchGetAggregateResourceConfigOutput, error) {
	req, out := c.BatchGetAggregateResourceConfigRequest(input)
	return out, req.Send()
}

// BatchGetAggregateResourceConfigWithContext is the same as BatchGetAggregateResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetAggregateResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) BatchGetAggregateResourceConfigWithContext(ctx aws.Context, input *BatchGetAggregateResourceConfigInput, opts ...request.Option) (*BatchGetAggregateResourceConfigOutput, error) {
	req, out := c.BatchGetAggregateResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetResourceConfig = "BatchGetResourceConfig"

// BatchGetResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetResourceConfig for more information on using the BatchGetResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetResourceConfigRequest method.
//    req, resp := client.BatchGetResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig
func (c *ConfigService) BatchGetResourceConfigRequest(input *BatchGetResourceConfigInput) (req *request.Request, output *BatchGetResourceConfigOutput) {
	op := &request.Operation{
		Name:       opBatchGetResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetResourceConfigInput{}
	}

	output = &BatchGetResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetResourceConfig API operation for AWS Config.
//
// Returns the BaseConfigurationItem for one or more requested resources. The
// operation also returns a list of resources that are not processed in the
// current request. If there are no unprocessed resources, the operation returns
// an empty unprocessedResourceKeys list.
//
//    * The API does not return results for deleted resources.
//
//    * The API does not return any tags for the requested resources. This information
//    is filtered out of the supplementaryConfiguration section of the API response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation BatchGetResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig
func (c *ConfigService) BatchGetResourceConfig(input *BatchGetResourceConfigInput) (*BatchGetResourceConfigOutput, error) {
	req, out := c.BatchGetResourceConfigRequest(input)
	return out, req.Send()
}

// BatchGetResourceConfigWithContext is the same as BatchGetResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) BatchGetResourceConfigWithContext(ctx aws.Context, input *BatchGetResourceConfigInput, opts ...request.Option) (*BatchGetResourceConfigOutput, error) {
	req, out := c.BatchGetResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAggregationAuthorization = "DeleteAggregationAuthorization"

// DeleteAggregationAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAggregationAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAggregationAuthorization for more information on using the DeleteAggregationAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAggregationAuthorizationRequest method.
//    req, resp := client.DeleteAggregationAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization
func (c *ConfigService) DeleteAggregationAuthorizationRequest(input *DeleteAggregationAuthorizationInput) (req *request.Request, output *DeleteAggregationAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteAggregationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAggregationAuthorizationInput{}
	}

	output = &DeleteAggregationAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAggregationAuthorization API operation for AWS Config.
//
// Deletes the authorization granted to the specified configuration aggregator
// account in a specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteAggregationAuthorization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization
func (c *ConfigService) DeleteAggregationAuthorization(input *DeleteAggregationAuthorizationInput) (*DeleteAggregationAuthorizationOutput, error) {
	req, out := c.DeleteAggregationAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteAggregationAuthorizationWithContext is the same as DeleteAggregationAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAggregationAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteAggregationAuthorizationWithContext(ctx aws.Context, input *DeleteAggregationAuthorizationInput, opts ...request.Option) (*DeleteAggregationAuthorizationOutput, error) {
	req, out := c.DeleteAggregationAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigRule = "DeleteConfigRule"

// DeleteConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigRule for more information on using the DeleteConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigRuleRequest method.
//    req, resp := client.DeleteConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule
func (c *ConfigService) DeleteConfigRuleRequest(input *DeleteConfigRuleInput) (req *request.Request, output *DeleteConfigRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigRuleInput{}
	}

	output = &DeleteConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigRule API operation for AWS Config.
//
// Deletes the specified Config rule and all of its evaluation results.
//
// Config sets the state of a rule to DELETING until the deletion is complete.
// You cannot update a rule while it is in this state. If you make a PutConfigRule
// or DeleteConfigRule request for the rule, you will receive a ResourceInUseException.
//
// You can check the state of a rule by using the DescribeConfigRules request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigRule for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule
func (c *ConfigService) DeleteConfigRule(input *DeleteConfigRuleInput) (*DeleteConfigRuleOutput, error) {
	req, out := c.DeleteConfigRuleRequest(input)
	return out, req.Send()
}

// DeleteConfigRuleWithContext is the same as DeleteConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigRuleWithContext(ctx aws.Context, input *DeleteConfigRuleInput, opts ...request.Option) (*DeleteConfigRuleOutput, error) {
	req, out := c.DeleteConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationAggregator = "DeleteConfigurationAggregator"

// DeleteConfigurationAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationAggregator for more information on using the DeleteConfigurationAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationAggregatorRequest method.
//    req, resp := client.DeleteConfigurationAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator
func (c *ConfigService) DeleteConfigurationAggregatorRequest(input *DeleteConfigurationAggregatorInput) (req *request.Request, output *DeleteConfigurationAggregatorOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationAggregator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationAggregatorInput{}
	}

	output = &DeleteConfigurationAggregatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationAggregator API operation for AWS Config.
//
// Deletes the specified configuration aggregator and the aggregated data associated
// with the aggregator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigurationAggregator for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator
func (c *ConfigService) DeleteConfigurationAggregator(input *DeleteConfigurationAggregatorInput) (*DeleteConfigurationAggregatorOutput, error) {
	req, out := c.DeleteConfigurationAggregatorRequest(input)
	return out, req.Send()
}

// DeleteConfigurationAggregatorWithContext is the same as DeleteConfigurationAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigurationAggregatorWithContext(ctx aws.Context, input *DeleteConfigurationAggregatorInput, opts ...request.Option) (*DeleteConfigurationAggregatorOutput, error) {
	req, out := c.DeleteConfigurationAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationRecorder = "DeleteConfigurationRecorder"

// DeleteConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationRecorder for more information on using the DeleteConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationRecorderRequest method.
//    req, resp := client.DeleteConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder
func (c *ConfigService) DeleteConfigurationRecorderRequest(input *DeleteConfigurationRecorderInput) (req *request.Request, output *DeleteConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationRecorderInput{}
	}

	output = &DeleteConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationRecorder API operation for AWS Config.
//
// Deletes the configuration recorder.
//
// After the configuration recorder is deleted, Config will not record resource
// configuration changes until you create a new configuration recorder.
//
// This action does not delete the configuration information that was previously
// recorded. You will be able to access the previously recorded information
// by using the GetResourceConfigHistory action, but you will not be able to
// access this information in the Config console until you create a new configuration
// recorder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigurationRecorder for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder
func (c *ConfigService) DeleteConfigurationRecorder(input *DeleteConfigurationRecorderInput) (*DeleteConfigurationRecorderOutput, error) {
	req, out := c.DeleteConfigurationRecorderRequest(input)
	return out, req.Send()
}

// DeleteConfigurationRecorderWithContext is the same as DeleteConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigurationRecorderWithContext(ctx aws.Context, input *DeleteConfigurationRecorderInput, opts ...request.Option) (*DeleteConfigurationRecorderOutput, error) {
	req, out := c.DeleteConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConformancePack = "DeleteConformancePack"

// DeleteConformancePackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConformancePack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConformancePack for more information on using the DeleteConformancePack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConformancePackRequest method.
//    req, resp := client.DeleteConformancePackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack
func (c *ConfigService) DeleteConformancePackRequest(input *DeleteConformancePackInput) (req *request.Request, output *DeleteConformancePackOutput) {
	op := &request.Operation{
		Name:       opDeleteConformancePack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConformancePackInput{}
	}

	output = &DeleteConformancePackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConformancePack API operation for AWS Config.
//
// Deletes the specified conformance pack and all the Config rules, remediation
// actions, and all evaluation results within that conformance pack.
//
// Config sets the conformance pack to DELETE_IN_PROGRESS until the deletion
// is complete. You cannot update a conformance pack while it is in this state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConformancePack for usage and error information.
//
// Returned Error Types:
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack
func (c *ConfigService) DeleteConformancePack(input *DeleteConformancePackInput) (*DeleteConformancePackOutput, error) {
	req, out := c.DeleteConformancePackRequest(input)
	return out, req.Send()
}

// DeleteConformancePackWithContext is the same as DeleteConformancePack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConformancePack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConformancePackWithContext(ctx aws.Context, input *DeleteConformancePackInput, opts ...request.Option) (*DeleteConformancePackOutput, error) {
	req, out := c.DeleteConformancePackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeliveryChannel = "DeleteDeliveryChannel"

// DeleteDeliveryChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeliveryChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeliveryChannel for more information on using the DeleteDeliveryChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeliveryChannelRequest method.
//    req, resp := client.DeleteDeliveryChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel
func (c *ConfigService) DeleteDeliveryChannelRequest(input *DeleteDeliveryChannelInput) (req *request.Request, output *DeleteDeliveryChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteDeliveryChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeliveryChannelInput{}
	}

	output = &DeleteDeliveryChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeliveryChannel API operation for AWS Config.
//
// Deletes the delivery channel.
//
// Before you can delete the delivery channel, you must stop the configuration
// recorder by using the StopConfigurationRecorder action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteDeliveryChannel for usage and error information.
//
// Returned Error Types:
//   * NoSuchDeliveryChannelException
//   You have specified a delivery channel that does not exist.
//
//   * LastDeliveryChannelDeleteFailedException
//   You cannot delete the delivery channel you specified because the configuration
//   recorder is running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel
func (c *ConfigService) DeleteDeliveryChannel(input *DeleteDeliveryChannelInput) (*DeleteDeliveryChannelOutput, error) {
	req, out := c.DeleteDeliveryChannelRequest(input)
	return out, req.Send()
}

// DeleteDeliveryChannelWithContext is the same as DeleteDeliveryChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeliveryChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteDeliveryChannelWithContext(ctx aws.Context, input *DeleteDeliveryChannelInput, opts ...request.Option) (*DeleteDeliveryChannelOutput, error) {
	req, out := c.DeleteDeliveryChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEvaluationResults = "DeleteEvaluationResults"

// DeleteEvaluationResultsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEvaluationResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEvaluationResults for more information on using the DeleteEvaluationResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEvaluationResultsRequest method.
//    req, resp := client.DeleteEvaluationResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults
func (c *ConfigService) DeleteEvaluationResultsRequest(input *DeleteEvaluationResultsInput) (req *request.Request, output *DeleteEvaluationResultsOutput) {
	op := &request.Operation{
		Name:       opDeleteEvaluationResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEvaluationResultsInput{}
	}

	output = &DeleteEvaluationResultsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEvaluationResults API operation for AWS Config.
//
// Deletes the evaluation results for the specified Config rule. You can specify
// one Config rule per request. After you delete the evaluation results, you
// can call the StartConfigRulesEvaluation API to start evaluating your Amazon
// Web Services resources against the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteEvaluationResults for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults
func (c *ConfigService) DeleteEvaluationResults(input *DeleteEvaluationResultsInput) (*DeleteEvaluationResultsOutput, error) {
	req, out := c.DeleteEvaluationResultsRequest(input)
	return out, req.Send()
}

// DeleteEvaluationResultsWithContext is the same as DeleteEvaluationResults with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEvaluationResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteEvaluationResultsWithContext(ctx aws.Context, input *DeleteEvaluationResultsInput, opts ...request.Option) (*DeleteEvaluationResultsOutput, error) {
	req, out := c.DeleteEvaluationResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganizationConfigRule = "DeleteOrganizationConfigRule"

// DeleteOrganizationConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganizationConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOrganizationConfigRule for more information on using the DeleteOrganizationConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOrganizationConfigRuleRequest method.
//    req, resp := client.DeleteOrganizationConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule
func (c *ConfigService) DeleteOrganizationConfigRuleRequest(input *DeleteOrganizationConfigRuleInput) (req *request.Request, output *DeleteOrganizationConfigRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganizationConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationConfigRuleInput{}
	}

	output = &DeleteOrganizationConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOrganizationConfigRule API operation for AWS Config.
//
// Deletes the specified organization Config rule and all of its evaluation
// results from all member accounts in that organization.
//
// Only a master account and a delegated administrator account can delete an
// organization Config rule. When calling this API with a delegated administrator,
// you must ensure Organizations ListDelegatedAdministrator permissions are
// added.
//
// Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion
// is complete. You cannot update a rule while it is in this state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteOrganizationConfigRule for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an organization
//   Config Custom Policy rule, that the rule name is correct, and that valid
//   Amazon Resouce Names (ARNs) are used before trying again.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule
func (c *ConfigService) DeleteOrganizationConfigRule(input *DeleteOrganizationConfigRuleInput) (*DeleteOrganizationConfigRuleOutput, error) {
	req, out := c.DeleteOrganizationConfigRuleRequest(input)
	return out, req.Send()
}

// DeleteOrganizationConfigRuleWithContext is the same as DeleteOrganizationConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganizationConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteOrganizationConfigRuleWithContext(ctx aws.Context, input *DeleteOrganizationConfigRuleInput, opts ...request.Option) (*DeleteOrganizationConfigRuleOutput, error) {
	req, out := c.DeleteOrganizationConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganizationConformancePack = "DeleteOrganizationConformancePack"

// DeleteOrganizationConformancePackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganizationConformancePack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOrganizationConformancePack for more information on using the DeleteOrganizationConformancePack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOrganizationConformancePackRequest method.
//    req, resp := client.DeleteOrganizationConformancePackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack
func (c *ConfigService) DeleteOrganizationConformancePackRequest(input *DeleteOrganizationConformancePackInput) (req *request.Request, output *DeleteOrganizationConformancePackOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganizationConformancePack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationConformancePackInput{}
	}

	output = &DeleteOrganizationConformancePackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOrganizationConformancePack API operation for AWS Config.
//
// Deletes the specified organization conformance pack and all of the Config
// rules and remediation actions from all member accounts in that organization.
//
// Only a master account or a delegated administrator account can delete an
// organization conformance pack. When calling this API with a delegated administrator,
// you must ensure Organizations ListDelegatedAdministrator permissions are
// added.
//
// Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the
// deletion is complete. You cannot update a conformance pack while it is in
// this state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteOrganizationConformancePack for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConformancePackException
//   Config organization conformance pack that you passed in the filter does not
//   exist.
//
//   For DeleteOrganizationConformancePack, you tried to delete an organization
//   conformance pack that does not exist.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack
func (c *ConfigService) DeleteOrganizationConformancePack(input *DeleteOrganizationConformancePackInput) (*DeleteOrganizationConformancePackOutput, error) {
	req, out := c.DeleteOrganizationConformancePackRequest(input)
	return out, req.Send()
}

// DeleteOrganizationConformancePackWithContext is the same as DeleteOrganizationConformancePack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganizationConformancePack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteOrganizationConformancePackWithContext(ctx aws.Context, input *DeleteOrganizationConformancePackInput, opts ...request.Option) (*DeleteOrganizationConformancePackOutput, error) {
	req, out := c.DeleteOrganizationConformancePackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePendingAggregationRequest = "DeletePendingAggregationRequest"

// DeletePendingAggregationRequestRequest generates a "aws/request.Request" representing the
// client's request for the DeletePendingAggregationRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePendingAggregationRequest for more information on using the DeletePendingAggregationRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePendingAggregationRequestRequest method.
//    req, resp := client.DeletePendingAggregationRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest
func (c *ConfigService) DeletePendingAggregationRequestRequest(input *DeletePendingAggregationRequestInput) (req *request.Request, output *DeletePendingAggregationRequestOutput) {
	op := &request.Operation{
		Name:       opDeletePendingAggregationRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePendingAggregationRequestInput{}
	}

	output = &DeletePendingAggregationRequestOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePendingAggregationRequest API operation for AWS Config.
//
// Deletes pending authorization requests for a specified aggregator account
// in a specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeletePendingAggregationRequest for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest
func (c *ConfigService) DeletePendingAggregationRequest(input *DeletePendingAggregationRequestInput) (*DeletePendingAggregationRequestOutput, error) {
	req, out := c.DeletePendingAggregationRequestRequest(input)
	return out, req.Send()
}

// DeletePendingAggregationRequestWithContext is the same as DeletePendingAggregationRequest with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePendingAggregationRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeletePendingAggregationRequestWithContext(ctx aws.Context, input *DeletePendingAggregationRequestInput, opts ...request.Option) (*DeletePendingAggregationRequestOutput, error) {
	req, out := c.DeletePendingAggregationRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRemediationConfiguration = "DeleteRemediationConfiguration"

// DeleteRemediationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRemediationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRemediationConfiguration for more information on using the DeleteRemediationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRemediationConfigurationRequest method.
//    req, resp := client.DeleteRemediationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration
func (c *ConfigService) DeleteRemediationConfigurationRequest(input *DeleteRemediationConfigurationInput) (req *request.Request, output *DeleteRemediationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteRemediationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRemediationConfigurationInput{}
	}

	output = &DeleteRemediationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRemediationConfiguration API operation for AWS Config.
//
// Deletes the remediation configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteRemediationConfiguration for usage and error information.
//
// Returned Error Types:
//   * NoSuchRemediationConfigurationException
//   You specified an Config rule without a remediation configuration.
//
//   * RemediationInProgressException
//   Remediation action is in progress. You can either cancel execution in Amazon
//   Web Services Systems Manager or wait and try again later.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration
func (c *ConfigService) DeleteRemediationConfiguration(input *DeleteRemediationConfigurationInput) (*DeleteRemediationConfigurationOutput, error) {
	req, out := c.DeleteRemediationConfigurationRequest(input)
	return out, req.Send()
}

// DeleteRemediationConfigurationWithContext is the same as DeleteRemediationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRemediationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteRemediationConfigurationWithContext(ctx aws.Context, input *DeleteRemediationConfigurationInput, opts ...request.Option) (*DeleteRemediationConfigurationOutput, error) {
	req, out := c.DeleteRemediationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRemediationExceptions = "DeleteRemediationExceptions"

// DeleteRemediationExceptionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRemediationExceptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRemediationExceptions for more information on using the DeleteRemediationExceptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRemediationExceptionsRequest method.
//    req, resp := client.DeleteRemediationExceptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions
func (c *ConfigService) DeleteRemediationExceptionsRequest(input *DeleteRemediationExceptionsInput) (req *request.Request, output *DeleteRemediationExceptionsOutput) {
	op := &request.Operation{
		Name:       opDeleteRemediationExceptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRemediationExceptionsInput{}
	}

	output = &DeleteRemediationExceptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRemediationExceptions API operation for AWS Config.
//
// Deletes one or more remediation exceptions mentioned in the resource keys.
//
// Config generates a remediation exception when a problem occurs executing
// a remediation action to a specific resource. Remediation exceptions blocks
// auto-remediation until the exception is cleared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteRemediationExceptions for usage and error information.
//
// Returned Error Types:
//   * NoSuchRemediationExceptionException
//   You tried to delete a remediation exception that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions
func (c *ConfigService) DeleteRemediationExceptions(input *DeleteRemediationExceptionsInput) (*DeleteRemediationExceptionsOutput, error) {
	req, out := c.DeleteRemediationExceptionsRequest(input)
	return out, req.Send()
}

// DeleteRemediationExceptionsWithContext is the same as DeleteRemediationExceptions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRemediationExceptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteRemediationExceptionsWithContext(ctx aws.Context, input *DeleteRemediationExceptionsInput, opts ...request.Option) (*DeleteRemediationExceptionsOutput, error) {
	req, out := c.DeleteRemediationExceptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceConfig = "DeleteResourceConfig"

// DeleteResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceConfig for more information on using the DeleteResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceConfigRequest method.
//    req, resp := client.DeleteResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig
func (c *ConfigService) DeleteResourceConfigRequest(input *DeleteResourceConfigInput) (req *request.Request, output *DeleteResourceConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceConfigInput{}
	}

	output = &DeleteResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceConfig API operation for AWS Config.
//
// Records the configuration state for a custom resource that has been deleted.
// This API records a new ConfigurationItem with a ResourceDeleted status. You
// can retrieve the ConfigurationItems recorded for this resource in your Config
// History.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * NoRunningConfigurationRecorderException
//   There is no configuration recorder running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig
func (c *ConfigService) DeleteResourceConfig(input *DeleteResourceConfigInput) (*DeleteResourceConfigOutput, error) {
	req, out := c.DeleteResourceConfigRequest(input)
	return out, req.Send()
}

// DeleteResourceConfigWithContext is the same as DeleteResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteResourceConfigWithContext(ctx aws.Context, input *DeleteResourceConfigInput, opts ...request.Option) (*DeleteResourceConfigOutput, error) {
	req, out := c.DeleteResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRetentionConfiguration = "DeleteRetentionConfiguration"

// DeleteRetentionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRetentionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRetentionConfiguration for more information on using the DeleteRetentionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRetentionConfigurationRequest method.
//    req, resp := client.DeleteRetentionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration
func (c *ConfigService) DeleteRetentionConfigurationRequest(input *DeleteRetentionConfigurationInput) (req *request.Request, output *DeleteRetentionConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteRetentionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRetentionConfigurationInput{}
	}

	output = &DeleteRetentionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRetentionConfiguration API operation for AWS Config.
//
// Deletes the retention configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteRetentionConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchRetentionConfigurationException
//   You have specified a retention configuration that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration
func (c *ConfigService) DeleteRetentionConfiguration(input *DeleteRetentionConfigurationInput) (*DeleteRetentionConfigurationOutput, error) {
	req, out := c.DeleteRetentionConfigurationRequest(input)
	return out, req.Send()
}

// DeleteRetentionConfigurationWithContext is the same as DeleteRetentionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRetentionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteRetentionConfigurationWithContext(ctx aws.Context, input *DeleteRetentionConfigurationInput, opts ...request.Option) (*DeleteRetentionConfigurationOutput, error) {
	req, out := c.DeleteRetentionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStoredQuery = "DeleteStoredQuery"

// DeleteStoredQueryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStoredQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStoredQuery for more information on using the DeleteStoredQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStoredQueryRequest method.
//    req, resp := client.DeleteStoredQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery
func (c *ConfigService) DeleteStoredQueryRequest(input *DeleteStoredQueryInput) (req *request.Request, output *DeleteStoredQueryOutput) {
	op := &request.Operation{
		Name:       opDeleteStoredQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStoredQueryInput{}
	}

	output = &DeleteStoredQueryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStoredQuery API operation for AWS Config.
//
// Deletes the stored query for a single Amazon Web Services account and a single
// Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteStoredQuery for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery
func (c *ConfigService) DeleteStoredQuery(input *DeleteStoredQueryInput) (*DeleteStoredQueryOutput, error) {
	req, out := c.DeleteStoredQueryRequest(input)
	return out, req.Send()
}

// DeleteStoredQueryWithContext is the same as DeleteStoredQuery with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStoredQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteStoredQueryWithContext(ctx aws.Context, input *DeleteStoredQueryInput, opts ...request.Option) (*DeleteStoredQueryOutput, error) {
	req, out := c.DeleteStoredQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeliverConfigSnapshot = "DeliverConfigSnapshot"

// DeliverConfigSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeliverConfigSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeliverConfigSnapshot for more information on using the DeliverConfigSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeliverConfigSnapshotRequest method.
//    req, resp := client.DeliverConfigSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot
func (c *ConfigService) DeliverConfigSnapshotRequest(input *DeliverConfigSnapshotInput) (req *request.Request, output *DeliverConfigSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeliverConfigSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeliverConfigSnapshotInput{}
	}

	output = &DeliverConfigSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeliverConfigSnapshot API operation for AWS Config.
//
// Schedules delivery of a configuration snapshot to the Amazon S3 bucket in
// the specified delivery channel. After the delivery has started, Config sends
// the following notifications using an Amazon SNS topic that you have specified.
//
//    * Notification of the start of the delivery.
//
//    * Notification of the completion of the delivery, if the delivery was
//    successfully completed.
//
//    * Notification of delivery failure, if the delivery failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeliverConfigSnapshot for usage and error information.
//
// Returned Error Types:
//   * NoSuchDeliveryChannelException
//   You have specified a delivery channel that does not exist.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * NoRunningConfigurationRecorderException
//   There is no configuration recorder running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot
func (c *ConfigService) DeliverConfigSnapshot(input *DeliverConfigSnapshotInput) (*DeliverConfigSnapshotOutput, error) {
	req, out := c.DeliverConfigSnapshotRequest(input)
	return out, req.Send()
}

// DeliverConfigSnapshotWithContext is the same as DeliverConfigSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeliverConfigSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeliverConfigSnapshotWithContext(ctx aws.Context, input *DeliverConfigSnapshotInput, opts ...request.Option) (*DeliverConfigSnapshotOutput, error) {
	req, out := c.DeliverConfigSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAggregateComplianceByConfigRules = "DescribeAggregateComplianceByConfigRules"

// DescribeAggregateComplianceByConfigRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregateComplianceByConfigRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregateComplianceByConfigRules for more information on using the DescribeAggregateComplianceByConfigRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregateComplianceByConfigRulesRequest method.
//    req, resp := client.DescribeAggregateComplianceByConfigRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules
func (c *ConfigService) DescribeAggregateComplianceByConfigRulesRequest(input *DescribeAggregateComplianceByConfigRulesInput) (req *request.Request, output *DescribeAggregateComplianceByConfigRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregateComplianceByConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAggregateComplianceByConfigRulesInput{}
	}

	output = &DescribeAggregateComplianceByConfigRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregateComplianceByConfigRules API operation for AWS Config.
//
// Returns a list of compliant and noncompliant rules with the number of resources
// for compliant and noncompliant rules. Does not display rules that do not
// have compliance results.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeAggregateComplianceByConfigRules for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules
func (c *ConfigService) DescribeAggregateComplianceByConfigRules(input *DescribeAggregateComplianceByConfigRulesInput) (*DescribeAggregateComplianceByConfigRulesOutput, error) {
	req, out := c.DescribeAggregateComplianceByConfigRulesRequest(input)
	return out, req.Send()
}

// DescribeAggregateComplianceByConfigRulesWithContext is the same as DescribeAggregateComplianceByConfigRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregateComplianceByConfigRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregateComplianceByConfigRulesWithContext(ctx aws.Context, input *DescribeAggregateComplianceByConfigRulesInput, opts ...request.Option) (*DescribeAggregateComplianceByConfigRulesOutput, error) {
	req, out := c.DescribeAggregateComplianceByConfigRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAggregateComplianceByConfigRulesPages iterates over the pages of a DescribeAggregateComplianceByConfigRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAggregateComplianceByConfigRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAggregateComplianceByConfigRules operation.
//    pageNum := 0
//    err := client.DescribeAggregateComplianceByConfigRulesPages(params,
//        func(page *configservice.DescribeAggregateComplianceByConfigRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeAggregateComplianceByConfigRulesPages(input *DescribeAggregateComplianceByConfigRulesInput, fn func(*DescribeAggregateComplianceByConfigRulesOutput, bool) bool) error {
	return c.DescribeAggregateComplianceByConfigRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAggregateComplianceByConfigRulesPagesWithContext same as DescribeAggregateComplianceByConfigRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregateComplianceByConfigRulesPagesWithContext(ctx aws.Context, input *DescribeAggregateComplianceByConfigRulesInput, fn func(*DescribeAggregateComplianceByConfigRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAggregateComplianceByConfigRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAggregateComplianceByConfigRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAggregateComplianceByConfigRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAggregateComplianceByConformancePacks = "DescribeAggregateComplianceByConformancePacks"

// DescribeAggregateComplianceByConformancePacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregateComplianceByConformancePacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregateComplianceByConformancePacks for more information on using the DescribeAggregateComplianceByConformancePacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregateComplianceByConformancePacksRequest method.
//    req, resp := client.DescribeAggregateComplianceByConformancePacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks
func (c *ConfigService) DescribeAggregateComplianceByConformancePacksRequest(input *DescribeAggregateComplianceByConformancePacksInput) (req *request.Request, output *DescribeAggregateComplianceByConformancePacksOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregateComplianceByConformancePacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAggregateComplianceByConformancePacksInput{}
	}

	output = &DescribeAggregateComplianceByConformancePacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregateComplianceByConformancePacks API operation for AWS Config.
//
// Returns a list of the conformance packs and their associated compliance status
// with the count of compliant and noncompliant Config rules within each conformance
// pack. Also returns the total rule count which includes compliant rules, noncompliant
// rules, and rules that cannot be evaluated due to insufficient data.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeAggregateComplianceByConformancePacks for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks
func (c *ConfigService) DescribeAggregateComplianceByConformancePacks(input *DescribeAggregateComplianceByConformancePacksInput) (*DescribeAggregateComplianceByConformancePacksOutput, error) {
	req, out := c.DescribeAggregateComplianceByConformancePacksRequest(input)
	return out, req.Send()
}

// DescribeAggregateComplianceByConformancePacksWithContext is the same as DescribeAggregateComplianceByConformancePacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregateComplianceByConformancePacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregateComplianceByConformancePacksWithContext(ctx aws.Context, input *DescribeAggregateComplianceByConformancePacksInput, opts ...request.Option) (*DescribeAggregateComplianceByConformancePacksOutput, error) {
	req, out := c.DescribeAggregateComplianceByConformancePacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAggregateComplianceByConformancePacksPages iterates over the pages of a DescribeAggregateComplianceByConformancePacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAggregateComplianceByConformancePacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAggregateComplianceByConformancePacks operation.
//    pageNum := 0
//    err := client.DescribeAggregateComplianceByConformancePacksPages(params,
//        func(page *configservice.DescribeAggregateComplianceByConformancePacksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeAggregateComplianceByConformancePacksPages(input *DescribeAggregateComplianceByConformancePacksInput, fn func(*DescribeAggregateComplianceByConformancePacksOutput, bool) bool) error {
	return c.DescribeAggregateComplianceByConformancePacksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAggregateComplianceByConformancePacksPagesWithContext same as DescribeAggregateComplianceByConformancePacksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregateComplianceByConformancePacksPagesWithContext(ctx aws.Context, input *DescribeAggregateComplianceByConformancePacksInput, fn func(*DescribeAggregateComplianceByConformancePacksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAggregateComplianceByConformancePacksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAggregateComplianceByConformancePacksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAggregateComplianceByConformancePacksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAggregationAuthorizations = "DescribeAggregationAuthorizations"

// DescribeAggregationAuthorizationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregationAuthorizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregationAuthorizations for more information on using the DescribeAggregationAuthorizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregationAuthorizationsRequest method.
//    req, resp := client.DescribeAggregationAuthorizationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations
func (c *ConfigService) DescribeAggregationAuthorizationsRequest(input *DescribeAggregationAuthorizationsInput) (req *request.Request, output *DescribeAggregationAuthorizationsOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregationAuthorizations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAggregationAuthorizationsInput{}
	}

	output = &DescribeAggregationAuthorizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregationAuthorizations API operation for AWS Config.
//
// Returns a list of authorizations granted to various aggregator accounts and
// regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeAggregationAuthorizations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations
func (c *ConfigService) DescribeAggregationAuthorizations(input *DescribeAggregationAuthorizationsInput) (*DescribeAggregationAuthorizationsOutput, error) {
	req, out := c.DescribeAggregationAuthorizationsRequest(input)
	return out, req.Send()
}

// DescribeAggregationAuthorizationsWithContext is the same as DescribeAggregationAuthorizations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregationAuthorizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregationAuthorizationsWithContext(ctx aws.Context, input *DescribeAggregationAuthorizationsInput, opts ...request.Option) (*DescribeAggregationAuthorizationsOutput, error) {
	req, out := c.DescribeAggregationAuthorizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAggregationAuthorizationsPages iterates over the pages of a DescribeAggregationAuthorizations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAggregationAuthorizations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAggregationAuthorizations operation.
//    pageNum := 0
//    err := client.DescribeAggregationAuthorizationsPages(params,
//        func(page *configservice.DescribeAggregationAuthorizationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeAggregationAuthorizationsPages(input *DescribeAggregationAuthorizationsInput, fn func(*DescribeAggregationAuthorizationsOutput, bool) bool) error {
	return c.DescribeAggregationAuthorizationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAggregationAuthorizationsPagesWithContext same as DescribeAggregationAuthorizationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregationAuthorizationsPagesWithContext(ctx aws.Context, input *DescribeAggregationAuthorizationsInput, fn func(*DescribeAggregationAuthorizationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAggregationAuthorizationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAggregationAuthorizationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAggregationAuthorizationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeComplianceByConfigRule = "DescribeComplianceByConfigRule"

// DescribeComplianceByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComplianceByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComplianceByConfigRule for more information on using the DescribeComplianceByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComplianceByConfigRuleRequest method.
//    req, resp := client.DescribeComplianceByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule
func (c *ConfigService) DescribeComplianceByConfigRuleRequest(input *DescribeComplianceByConfigRuleInput) (req *request.Request, output *DescribeComplianceByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeComplianceByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeComplianceByConfigRuleInput{}
	}

	output = &DescribeComplianceByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComplianceByConfigRule API operation for AWS Config.
//
// Indicates whether the specified Config rules are compliant. If a rule is
// noncompliant, this action returns the number of Amazon Web Services resources
// that do not comply with the rule.
//
// A rule is compliant if all of the evaluated resources comply with it. It
// is noncompliant if any of these resources do not comply.
//
// If Config has no current evaluation results for the rule, it returns INSUFFICIENT_DATA.
// This result might indicate one of the following conditions:
//
//    * Config has never invoked an evaluation for the rule. To check whether
//    it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime
//    and LastFailedInvocationTime.
//
//    * The rule's Lambda function is failing to send evaluation results to
//    Config. Verify that the role you assigned to your configuration recorder
//    includes the config:PutEvaluations permission. If the rule is a custom
//    rule, verify that the Lambda execution role includes the config:PutEvaluations
//    permission.
//
//    * The rule's Lambda function has returned NOT_APPLICABLE for all evaluation
//    results. This can occur if the resources were deleted or removed from
//    the rule's scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeComplianceByConfigRule for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule
func (c *ConfigService) DescribeComplianceByConfigRule(input *DescribeComplianceByConfigRuleInput) (*DescribeComplianceByConfigRuleOutput, error) {
	req, out := c.DescribeComplianceByConfigRuleRequest(input)
	return out, req.Send()
}

// DescribeComplianceByConfigRuleWithContext is the same as DescribeComplianceByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComplianceByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeComplianceByConfigRuleWithContext(ctx aws.Context, input *DescribeComplianceByConfigRuleInput, opts ...request.Option) (*DescribeComplianceByConfigRuleOutput, error) {
	req, out := c.DescribeComplianceByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeComplianceByConfigRulePages iterates over the pages of a DescribeComplianceByConfigRule operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeComplianceByConfigRule method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeComplianceByConfigRule operation.
//    pageNum := 0
//    err := client.DescribeComplianceByConfigRulePages(params,
//        func(page *configservice.DescribeComplianceByConfigRuleOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeComplianceByConfigRulePages(input *DescribeComplianceByConfigRuleInput, fn func(*DescribeComplianceByConfigRuleOutput, bool) bool) error {
	return c.DescribeComplianceByConfigRulePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeComplianceByConfigRulePagesWithContext same as DescribeComplianceByConfigRulePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeComplianceByConfigRulePagesWithContext(ctx aws.Context, input *DescribeComplianceByConfigRuleInput, fn func(*DescribeComplianceByConfigRuleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeComplianceByConfigRuleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeComplianceByConfigRuleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeComplianceByConfigRuleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeComplianceByResource = "DescribeComplianceByResource"

// DescribeComplianceByResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComplianceByResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComplianceByResource for more information on using the DescribeComplianceByResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComplianceByResourceRequest method.
//    req, resp := client.DescribeComplianceByResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource
func (c *ConfigService) DescribeComplianceByResourceRequest(input *DescribeComplianceByResourceInput) (req *request.Request, output *DescribeComplianceByResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeComplianceByResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeComplianceByResourceInput{}
	}

	output = &DescribeComplianceByResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComplianceByResource API operation for AWS Config.
//
// Indicates whether the specified Amazon Web Services resources are compliant.
// If a resource is noncompliant, this action returns the number of Config rules
// that the resource does not comply with.
//
// A resource is compliant if it complies with all the Config rules that evaluate
// it. It is noncompliant if it does not comply with one or more of these rules.
//
// If Config has no current evaluation results for the resource, it returns
// INSUFFICIENT_DATA. This result might indicate one of the following conditions
// about the rules that evaluate the resource:
//
//    * Config has never invoked an evaluation for the rule. To check whether
//    it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime
//    and LastFailedInvocationTime.
//
//    * The rule's Lambda function is failing to send evaluation results to
//    Config. Verify that the role that you assigned to your configuration recorder
//    includes the config:PutEvaluations permission. If the rule is a custom
//    rule, verify that the Lambda execution role includes the config:PutEvaluations
//    permission.
//
//    * The rule's Lambda function has returned NOT_APPLICABLE for all evaluation
//    results. This can occur if the resources were deleted or removed from
//    the rule's scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeComplianceByResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource
func (c *ConfigService) DescribeComplianceByResource(input *DescribeComplianceByResourceInput) (*DescribeComplianceByResourceOutput, error) {
	req, out := c.DescribeComplianceByResourceRequest(input)
	return out, req.Send()
}

// DescribeComplianceByResourceWithContext is the same as DescribeComplianceByResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComplianceByResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeComplianceByResourceWithContext(ctx aws.Context, input *DescribeComplianceByResourceInput, opts ...request.Option) (*DescribeComplianceByResourceOutput, error) {
	req, out := c.DescribeComplianceByResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeComplianceByResourcePages iterates over the pages of a DescribeComplianceByResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeComplianceByResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeComplianceByResource operation.
//    pageNum := 0
//    err := client.DescribeComplianceByResourcePages(params,
//        func(page *configservice.DescribeComplianceByResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeComplianceByResourcePages(input *DescribeComplianceByResourceInput, fn func(*DescribeComplianceByResourceOutput, bool) bool) error {
	return c.DescribeComplianceByResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeComplianceByResourcePagesWithContext same as DescribeComplianceByResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeComplianceByResourcePagesWithContext(ctx aws.Context, input *DescribeComplianceByResourceInput, fn func(*DescribeComplianceByResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeComplianceByResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeComplianceByResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeComplianceByResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConfigRuleEvaluationStatus = "DescribeConfigRuleEvaluationStatus"

// DescribeConfigRuleEvaluationStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigRuleEvaluationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigRuleEvaluationStatus for more information on using the DescribeConfigRuleEvaluationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigRuleEvaluationStatusRequest method.
//    req, resp := client.DescribeConfigRuleEvaluationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus
func (c *ConfigService) DescribeConfigRuleEvaluationStatusRequest(input *DescribeConfigRuleEvaluationStatusInput) (req *request.Request, output *DescribeConfigRuleEvaluationStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigRuleEvaluationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConfigRuleEvaluationStatusInput{}
	}

	output = &DescribeConfigRuleEvaluationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigRuleEvaluationStatus API operation for AWS Config.
//
// Returns status information for each of your Config managed rules. The status
// includes information such as the last time Config invoked the rule, the last
// time Config failed to invoke the rule, and the related error for the last
// failure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigRuleEvaluationStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus
func (c *ConfigService) DescribeConfigRuleEvaluationStatus(input *DescribeConfigRuleEvaluationStatusInput) (*DescribeConfigRuleEvaluationStatusOutput, error) {
	req, out := c.DescribeConfigRuleEvaluationStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigRuleEvaluationStatusWithContext is the same as DescribeConfigRuleEvaluationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigRuleEvaluationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigRuleEvaluationStatusWithContext(ctx aws.Context, input *DescribeConfigRuleEvaluationStatusInput, opts ...request.Option) (*DescribeConfigRuleEvaluationStatusOutput, error) {
	req, out := c.DescribeConfigRuleEvaluationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConfigRuleEvaluationStatusPages iterates over the pages of a DescribeConfigRuleEvaluationStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConfigRuleEvaluationStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConfigRuleEvaluationStatus operation.
//    pageNum := 0
//    err := client.DescribeConfigRuleEvaluationStatusPages(params,
//        func(page *configservice.DescribeConfigRuleEvaluationStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeConfigRuleEvaluationStatusPages(input *DescribeConfigRuleEvaluationStatusInput, fn func(*DescribeConfigRuleEvaluationStatusOutput, bool) bool) error {
	return c.DescribeConfigRuleEvaluationStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConfigRuleEvaluationStatusPagesWithContext same as DescribeConfigRuleEvaluationStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigRuleEvaluationStatusPagesWithContext(ctx aws.Context, input *DescribeConfigRuleEvaluationStatusInput, fn func(*DescribeConfigRuleEvaluationStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConfigRuleEvaluationStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConfigRuleEvaluationStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConfigRuleEvaluationStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConfigRules = "DescribeConfigRules"

// DescribeConfigRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigRules for more information on using the DescribeConfigRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigRulesRequest method.
//    req, resp := client.DescribeConfigRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules
func (c *ConfigService) DescribeConfigRulesRequest(input *DescribeConfigRulesInput) (req *request.Request, output *DescribeConfigRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConfigRulesInput{}
	}

	output = &DescribeConfigRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigRules API operation for AWS Config.
//
// Returns details about your Config rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigRules for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules
func (c *ConfigService) DescribeConfigRules(input *DescribeConfigRulesInput) (*DescribeConfigRulesOutput, error) {
	req, out := c.DescribeConfigRulesRequest(input)
	return out, req.Send()
}

// DescribeConfigRulesWithContext is the same as DescribeConfigRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigRulesWithContext(ctx aws.Context, input *DescribeConfigRulesInput, opts ...request.Option) (*DescribeConfigRulesOutput, error) {
	req, out := c.DescribeConfigRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConfigRulesPages iterates over the pages of a DescribeConfigRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConfigRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConfigRules operation.
//    pageNum := 0
//    err := client.DescribeConfigRulesPages(params,
//        func(page *configservice.DescribeConfigRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeConfigRulesPages(input *DescribeConfigRulesInput, fn func(*DescribeConfigRulesOutput, bool) bool) error {
	return c.DescribeConfigRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConfigRulesPagesWithContext same as DescribeConfigRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigRulesPagesWithContext(ctx aws.Context, input *DescribeConfigRulesInput, fn func(*DescribeConfigRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConfigRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConfigRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConfigRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConfigurationAggregatorSourcesStatus = "DescribeConfigurationAggregatorSourcesStatus"

// DescribeConfigurationAggregatorSourcesStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationAggregatorSourcesStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationAggregatorSourcesStatus for more information on using the DescribeConfigurationAggregatorSourcesStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationAggregatorSourcesStatusRequest method.
//    req, resp := client.DescribeConfigurationAggregatorSourcesStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatusRequest(input *DescribeConfigurationAggregatorSourcesStatusInput) (req *request.Request, output *DescribeConfigurationAggregatorSourcesStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationAggregatorSourcesStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConfigurationAggregatorSourcesStatusInput{}
	}

	output = &DescribeConfigurationAggregatorSourcesStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationAggregatorSourcesStatus API operation for AWS Config.
//
// Returns status information for sources within an aggregator. The status includes
// information about the last time Config verified authorization between the
// source account and an aggregator account. In case of a failure, the status
// contains the related error code or message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationAggregatorSourcesStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatus(input *DescribeConfigurationAggregatorSourcesStatusInput) (*DescribeConfigurationAggregatorSourcesStatusOutput, error) {
	req, out := c.DescribeConfigurationAggregatorSourcesStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigurationAggregatorSourcesStatusWithContext is the same as DescribeConfigurationAggregatorSourcesStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationAggregatorSourcesStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatusWithContext(ctx aws.Context, input *DescribeConfigurationAggregatorSourcesStatusInput, opts ...request.Option) (*DescribeConfigurationAggregatorSourcesStatusOutput, error) {
	req, out := c.DescribeConfigurationAggregatorSourcesStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConfigurationAggregatorSourcesStatusPages iterates over the pages of a DescribeConfigurationAggregatorSourcesStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConfigurationAggregatorSourcesStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConfigurationAggregatorSourcesStatus operation.
//    pageNum := 0
//    err := client.DescribeConfigurationAggregatorSourcesStatusPages(params,
//        func(page *configservice.DescribeConfigurationAggregatorSourcesStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatusPages(input *DescribeConfigurationAggregatorSourcesStatusInput, fn func(*DescribeConfigurationAggregatorSourcesStatusOutput, bool) bool) error {
	return c.DescribeConfigurationAggregatorSourcesStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConfigurationAggregatorSourcesStatusPagesWithContext same as DescribeConfigurationAggregatorSourcesStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatusPagesWithContext(ctx aws.Context, input *DescribeConfigurationAggregatorSourcesStatusInput, fn func(*DescribeConfigurationAggregatorSourcesStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConfigurationAggregatorSourcesStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConfigurationAggregatorSourcesStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConfigurationAggregatorSourcesStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConfigurationAggregators = "DescribeConfigurationAggregators"

// DescribeConfigurationAggregatorsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationAggregators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationAggregators for more information on using the DescribeConfigurationAggregators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationAggregatorsRequest method.
//    req, resp := client.DescribeConfigurationAggregatorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators
func (c *ConfigService) DescribeConfigurationAggregatorsRequest(input *DescribeConfigurationAggregatorsInput) (req *request.Request, output *DescribeConfigurationAggregatorsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationAggregators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConfigurationAggregatorsInput{}
	}

	output = &DescribeConfigurationAggregatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationAggregators API operation for AWS Config.
//
// Returns the details of one or more configuration aggregators. If the configuration
// aggregator is not specified, this action returns the details for all the
// configuration aggregators associated with the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationAggregators for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators
func (c *ConfigService) DescribeConfigurationAggregators(input *DescribeConfigurationAggregatorsInput) (*DescribeConfigurationAggregatorsOutput, error) {
	req, out := c.DescribeConfigurationAggregatorsRequest(input)
	return out, req.Send()
}

// DescribeConfigurationAggregatorsWithContext is the same as DescribeConfigurationAggregators with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationAggregators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationAggregatorsWithContext(ctx aws.Context, input *DescribeConfigurationAggregatorsInput, opts ...request.Option) (*DescribeConfigurationAggregatorsOutput, error) {
	req, out := c.DescribeConfigurationAggregatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConfigurationAggregatorsPages iterates over the pages of a DescribeConfigurationAggregators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConfigurationAggregators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConfigurationAggregators operation.
//    pageNum := 0
//    err := client.DescribeConfigurationAggregatorsPages(params,
//        func(page *configservice.DescribeConfigurationAggregatorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeConfigurationAggregatorsPages(input *DescribeConfigurationAggregatorsInput, fn func(*DescribeConfigurationAggregatorsOutput, bool) bool) error {
	return c.DescribeConfigurationAggregatorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConfigurationAggregatorsPagesWithContext same as DescribeConfigurationAggregatorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationAggregatorsPagesWithContext(ctx aws.Context, input *DescribeConfigurationAggregatorsInput, fn func(*DescribeConfigurationAggregatorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConfigurationAggregatorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConfigurationAggregatorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConfigurationAggregatorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConfigurationRecorderStatus = "DescribeConfigurationRecorderStatus"

// DescribeConfigurationRecorderStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRecorderStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRecorderStatus for more information on using the DescribeConfigurationRecorderStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRecorderStatusRequest method.
//    req, resp := client.DescribeConfigurationRecorderStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus
func (c *ConfigService) DescribeConfigurationRecorderStatusRequest(input *DescribeConfigurationRecorderStatusInput) (req *request.Request, output *DescribeConfigurationRecorderStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRecorderStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationRecorderStatusInput{}
	}

	output = &DescribeConfigurationRecorderStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRecorderStatus API operation for AWS Config.
//
// Returns the current status of the specified configuration recorder. If a
// configuration recorder is not specified, this action returns the status of
// all configuration recorders associated with the account.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationRecorderStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus
func (c *ConfigService) DescribeConfigurationRecorderStatus(input *DescribeConfigurationRecorderStatusInput) (*DescribeConfigurationRecorderStatusOutput, error) {
	req, out := c.DescribeConfigurationRecorderStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRecorderStatusWithContext is the same as DescribeConfigurationRecorderStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRecorderStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationRecorderStatusWithContext(ctx aws.Context, input *DescribeConfigurationRecorderStatusInput, opts ...request.Option) (*DescribeConfigurationRecorderStatusOutput, error) {
	req, out := c.DescribeConfigurationRecorderStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationRecorders = "DescribeConfigurationRecorders"

// DescribeConfigurationRecordersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRecorders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRecorders for more information on using the DescribeConfigurationRecorders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRecordersRequest method.
//    req, resp := client.DescribeConfigurationRecordersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders
func (c *ConfigService) DescribeConfigurationRecordersRequest(input *DescribeConfigurationRecordersInput) (req *request.Request, output *DescribeConfigurationRecordersOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRecorders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationRecordersInput{}
	}

	output = &DescribeConfigurationRecordersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRecorders API operation for AWS Config.
//
// Returns the details for the specified configuration recorders. If the configuration
// recorder is not specified, this action returns the details for all configuration
// recorders associated with the account.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationRecorders for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders
func (c *ConfigService) DescribeConfigurationRecorders(input *DescribeConfigurationRecordersInput) (*DescribeConfigurationRecordersOutput, error) {
	req, out := c.DescribeConfigurationRecordersRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRecordersWithContext is the same as DescribeConfigurationRecorders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRecorders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationRecordersWithContext(ctx aws.Context, input *DescribeConfigurationRecordersInput, opts ...request.Option) (*DescribeConfigurationRecordersOutput, error) {
	req, out := c.DescribeConfigurationRecordersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConformancePackCompliance = "DescribeConformancePackCompliance"

// DescribeConformancePackComplianceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConformancePackCompliance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConformancePackCompliance for more information on using the DescribeConformancePackCompliance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConformancePackComplianceRequest method.
//    req, resp := client.DescribeConformancePackComplianceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance
func (c *ConfigService) DescribeConformancePackComplianceRequest(input *DescribeConformancePackComplianceInput) (req *request.Request, output *DescribeConformancePackComplianceOutput) {
	op := &request.Operation{
		Name:       opDescribeConformancePackCompliance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConformancePackComplianceInput{}
	}

	output = &DescribeConformancePackComplianceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConformancePackCompliance API operation for AWS Config.
//
// Returns compliance details for each rule in that conformance pack.
//
// You must provide exact rule names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConformancePackCompliance for usage and error information.
//
// Returned Error Types:
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchConfigRuleInConformancePackException
//   Config rule that you passed in the filter does not exist.
//
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance
func (c *ConfigService) DescribeConformancePackCompliance(input *DescribeConformancePackComplianceInput) (*DescribeConformancePackComplianceOutput, error) {
	req, out := c.DescribeConformancePackComplianceRequest(input)
	return out, req.Send()
}

// DescribeConformancePackComplianceWithContext is the same as DescribeConformancePackCompliance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConformancePackCompliance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePackComplianceWithContext(ctx aws.Context, input *DescribeConformancePackComplianceInput, opts ...request.Option) (*DescribeConformancePackComplianceOutput, error) {
	req, out := c.DescribeConformancePackComplianceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConformancePackCompliancePages iterates over the pages of a DescribeConformancePackCompliance operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConformancePackCompliance method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConformancePackCompliance operation.
//    pageNum := 0
//    err := client.DescribeConformancePackCompliancePages(params,
//        func(page *configservice.DescribeConformancePackComplianceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeConformancePackCompliancePages(input *DescribeConformancePackComplianceInput, fn func(*DescribeConformancePackComplianceOutput, bool) bool) error {
	return c.DescribeConformancePackCompliancePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConformancePackCompliancePagesWithContext same as DescribeConformancePackCompliancePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePackCompliancePagesWithContext(ctx aws.Context, input *DescribeConformancePackComplianceInput, fn func(*DescribeConformancePackComplianceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConformancePackComplianceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConformancePackComplianceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConformancePackComplianceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConformancePackStatus = "DescribeConformancePackStatus"

// DescribeConformancePackStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConformancePackStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConformancePackStatus for more information on using the DescribeConformancePackStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConformancePackStatusRequest method.
//    req, resp := client.DescribeConformancePackStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus
func (c *ConfigService) DescribeConformancePackStatusRequest(input *DescribeConformancePackStatusInput) (req *request.Request, output *DescribeConformancePackStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConformancePackStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConformancePackStatusInput{}
	}

	output = &DescribeConformancePackStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConformancePackStatus API operation for AWS Config.
//
// Provides one or more conformance packs deployment status.
//
// If there are no conformance packs then you will see an empty result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConformancePackStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus
func (c *ConfigService) DescribeConformancePackStatus(input *DescribeConformancePackStatusInput) (*DescribeConformancePackStatusOutput, error) {
	req, out := c.DescribeConformancePackStatusRequest(input)
	return out, req.Send()
}

// DescribeConformancePackStatusWithContext is the same as DescribeConformancePackStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConformancePackStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePackStatusWithContext(ctx aws.Context, input *DescribeConformancePackStatusInput, opts ...request.Option) (*DescribeConformancePackStatusOutput, error) {
	req, out := c.DescribeConformancePackStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConformancePackStatusPages iterates over the pages of a DescribeConformancePackStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConformancePackStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConformancePackStatus operation.
//    pageNum := 0
//    err := client.DescribeConformancePackStatusPages(params,
//        func(page *configservice.DescribeConformancePackStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeConformancePackStatusPages(input *DescribeConformancePackStatusInput, fn func(*DescribeConformancePackStatusOutput, bool) bool) error {
	return c.DescribeConformancePackStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConformancePackStatusPagesWithContext same as DescribeConformancePackStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePackStatusPagesWithContext(ctx aws.Context, input *DescribeConformancePackStatusInput, fn func(*DescribeConformancePackStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConformancePackStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConformancePackStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConformancePackStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConformancePacks = "DescribeConformancePacks"

// DescribeConformancePacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConformancePacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConformancePacks for more information on using the DescribeConformancePacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConformancePacksRequest method.
//    req, resp := client.DescribeConformancePacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks
func (c *ConfigService) DescribeConformancePacksRequest(input *DescribeConformancePacksInput) (req *request.Request, output *DescribeConformancePacksOutput) {
	op := &request.Operation{
		Name:       opDescribeConformancePacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConformancePacksInput{}
	}

	output = &DescribeConformancePacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConformancePacks API operation for AWS Config.
//
// Returns a list of one or more conformance packs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConformancePacks for usage and error information.
//
// Returned Error Types:
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks
func (c *ConfigService) DescribeConformancePacks(input *DescribeConformancePacksInput) (*DescribeConformancePacksOutput, error) {
	req, out := c.DescribeConformancePacksRequest(input)
	return out, req.Send()
}

// DescribeConformancePacksWithContext is the same as DescribeConformancePacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConformancePacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePacksWithContext(ctx aws.Context, input *DescribeConformancePacksInput, opts ...request.Option) (*DescribeConformancePacksOutput, error) {
	req, out := c.DescribeConformancePacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConformancePacksPages iterates over the pages of a DescribeConformancePacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConformancePacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConformancePacks operation.
//    pageNum := 0
//    err := client.DescribeConformancePacksPages(params,
//        func(page *configservice.DescribeConformancePacksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeConformancePacksPages(input *DescribeConformancePacksInput, fn func(*DescribeConformancePacksOutput, bool) bool) error {
	return c.DescribeConformancePacksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConformancePacksPagesWithContext same as DescribeConformancePacksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConformancePacksPagesWithContext(ctx aws.Context, input *DescribeConformancePacksInput, fn func(*DescribeConformancePacksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConformancePacksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConformancePacksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConformancePacksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDeliveryChannelStatus = "DescribeDeliveryChannelStatus"

// DescribeDeliveryChannelStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryChannelStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeliveryChannelStatus for more information on using the DescribeDeliveryChannelStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeliveryChannelStatusRequest method.
//    req, resp := client.DescribeDeliveryChannelStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus
func (c *ConfigService) DescribeDeliveryChannelStatusRequest(input *DescribeDeliveryChannelStatusInput) (req *request.Request, output *DescribeDeliveryChannelStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryChannelStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryChannelStatusInput{}
	}

	output = &DescribeDeliveryChannelStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeliveryChannelStatus API operation for AWS Config.
//
// Returns the current status of the specified delivery channel. If a delivery
// channel is not specified, this action returns the current status of all delivery
// channels associated with the account.
//
// Currently, you can specify only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeDeliveryChannelStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchDeliveryChannelException
//   You have specified a delivery channel that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus
func (c *ConfigService) DescribeDeliveryChannelStatus(input *DescribeDeliveryChannelStatusInput) (*DescribeDeliveryChannelStatusOutput, error) {
	req, out := c.DescribeDeliveryChannelStatusRequest(input)
	return out, req.Send()
}

// DescribeDeliveryChannelStatusWithContext is the same as DescribeDeliveryChannelStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeliveryChannelStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeDeliveryChannelStatusWithContext(ctx aws.Context, input *DescribeDeliveryChannelStatusInput, opts ...request.Option) (*DescribeDeliveryChannelStatusOutput, error) {
	req, out := c.DescribeDeliveryChannelStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeliveryChannels = "DescribeDeliveryChannels"

// DescribeDeliveryChannelsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeliveryChannels for more information on using the DescribeDeliveryChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeliveryChannelsRequest method.
//    req, resp := client.DescribeDeliveryChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels
func (c *ConfigService) DescribeDeliveryChannelsRequest(input *DescribeDeliveryChannelsInput) (req *request.Request, output *DescribeDeliveryChannelsOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryChannelsInput{}
	}

	output = &DescribeDeliveryChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeliveryChannels API operation for AWS Config.
//
// Returns details about the specified delivery channel. If a delivery channel
// is not specified, this action returns the details of all delivery channels
// associated with the account.
//
// Currently, you can specify only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeDeliveryChannels for usage and error information.
//
// Returned Error Types:
//   * NoSuchDeliveryChannelException
//   You have specified a delivery channel that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels
func (c *ConfigService) DescribeDeliveryChannels(input *DescribeDeliveryChannelsInput) (*DescribeDeliveryChannelsOutput, error) {
	req, out := c.DescribeDeliveryChannelsRequest(input)
	return out, req.Send()
}

// DescribeDeliveryChannelsWithContext is the same as DescribeDeliveryChannels with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeliveryChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeDeliveryChannelsWithContext(ctx aws.Context, input *DescribeDeliveryChannelsInput, opts ...request.Option) (*DescribeDeliveryChannelsOutput, error) {
	req, out := c.DescribeDeliveryChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfigRuleStatuses = "DescribeOrganizationConfigRuleStatuses"

// DescribeOrganizationConfigRuleStatusesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfigRuleStatuses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfigRuleStatuses for more information on using the DescribeOrganizationConfigRuleStatuses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConfigRuleStatusesRequest method.
//    req, resp := client.DescribeOrganizationConfigRuleStatusesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses
func (c *ConfigService) DescribeOrganizationConfigRuleStatusesRequest(input *DescribeOrganizationConfigRuleStatusesInput) (req *request.Request, output *DescribeOrganizationConfigRuleStatusesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfigRuleStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrganizationConfigRuleStatusesInput{}
	}

	output = &DescribeOrganizationConfigRuleStatusesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfigRuleStatuses API operation for AWS Config.
//
// Provides organization Config rule deployment status for an organization.
//
// The status is not considered successful until organization Config rule is
// successfully deployed in all the member accounts with an exception of excluded
// accounts.
//
// When you specify the limit and the next token, you receive a paginated response.
// Limit and next token are not applicable if you specify organization Config
// rule names. It is only applicable, when you request all the organization
// Config rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeOrganizationConfigRuleStatuses for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an organization
//   Config Custom Policy rule, that the rule name is correct, and that valid
//   Amazon Resouce Names (ARNs) are used before trying again.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses
func (c *ConfigService) DescribeOrganizationConfigRuleStatuses(input *DescribeOrganizationConfigRuleStatusesInput) (*DescribeOrganizationConfigRuleStatusesOutput, error) {
	req, out := c.DescribeOrganizationConfigRuleStatusesRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigRuleStatusesWithContext is the same as DescribeOrganizationConfigRuleStatuses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfigRuleStatuses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConfigRuleStatusesWithContext(ctx aws.Context, input *DescribeOrganizationConfigRuleStatusesInput, opts ...request.Option) (*DescribeOrganizationConfigRuleStatusesOutput, error) {
	req, out := c.DescribeOrganizationConfigRuleStatusesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrganizationConfigRuleStatusesPages iterates over the pages of a DescribeOrganizationConfigRuleStatuses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrganizationConfigRuleStatuses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrganizationConfigRuleStatuses operation.
//    pageNum := 0
//    err := client.DescribeOrganizationConfigRuleStatusesPages(params,
//        func(page *configservice.DescribeOrganizationConfigRuleStatusesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeOrganizationConfigRuleStatusesPages(input *DescribeOrganizationConfigRuleStatusesInput, fn func(*DescribeOrganizationConfigRuleStatusesOutput, bool) bool) error {
	return c.DescribeOrganizationConfigRuleStatusesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrganizationConfigRuleStatusesPagesWithContext same as DescribeOrganizationConfigRuleStatusesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConfigRuleStatusesPagesWithContext(ctx aws.Context, input *DescribeOrganizationConfigRuleStatusesInput, fn func(*DescribeOrganizationConfigRuleStatusesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrganizationConfigRuleStatusesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrganizationConfigRuleStatusesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrganizationConfigRuleStatusesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOrganizationConfigRules = "DescribeOrganizationConfigRules"

// DescribeOrganizationConfigRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfigRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfigRules for more information on using the DescribeOrganizationConfigRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConfigRulesRequest method.
//    req, resp := client.DescribeOrganizationConfigRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules
func (c *ConfigService) DescribeOrganizationConfigRulesRequest(input *DescribeOrganizationConfigRulesInput) (req *request.Request, output *DescribeOrganizationConfigRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrganizationConfigRulesInput{}
	}

	output = &DescribeOrganizationConfigRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfigRules API operation for AWS Config.
//
// Returns a list of organization Config rules.
//
// When you specify the limit and the next token, you receive a paginated response.
// Limit and next token are not applicable if you specify organization Config
// rule names. It is only applicable, when you request all the organization
// Config rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeOrganizationConfigRules for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an organization
//   Config Custom Policy rule, that the rule name is correct, and that valid
//   Amazon Resouce Names (ARNs) are used before trying again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules
func (c *ConfigService) DescribeOrganizationConfigRules(input *DescribeOrganizationConfigRulesInput) (*DescribeOrganizationConfigRulesOutput, error) {
	req, out := c.DescribeOrganizationConfigRulesRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigRulesWithContext is the same as DescribeOrganizationConfigRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfigRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConfigRulesWithContext(ctx aws.Context, input *DescribeOrganizationConfigRulesInput, opts ...request.Option) (*DescribeOrganizationConfigRulesOutput, error) {
	req, out := c.DescribeOrganizationConfigRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrganizationConfigRulesPages iterates over the pages of a DescribeOrganizationConfigRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrganizationConfigRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrganizationConfigRules operation.
//    pageNum := 0
//    err := client.DescribeOrganizationConfigRulesPages(params,
//        func(page *configservice.DescribeOrganizationConfigRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeOrganizationConfigRulesPages(input *DescribeOrganizationConfigRulesInput, fn func(*DescribeOrganizationConfigRulesOutput, bool) bool) error {
	return c.DescribeOrganizationConfigRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrganizationConfigRulesPagesWithContext same as DescribeOrganizationConfigRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConfigRulesPagesWithContext(ctx aws.Context, input *DescribeOrganizationConfigRulesInput, fn func(*DescribeOrganizationConfigRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrganizationConfigRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrganizationConfigRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrganizationConfigRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOrganizationConformancePackStatuses = "DescribeOrganizationConformancePackStatuses"

// DescribeOrganizationConformancePackStatusesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConformancePackStatuses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConformancePackStatuses for more information on using the DescribeOrganizationConformancePackStatuses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConformancePackStatusesRequest method.
//    req, resp := client.DescribeOrganizationConformancePackStatusesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses
func (c *ConfigService) DescribeOrganizationConformancePackStatusesRequest(input *DescribeOrganizationConformancePackStatusesInput) (req *request.Request, output *DescribeOrganizationConformancePackStatusesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConformancePackStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrganizationConformancePackStatusesInput{}
	}

	output = &DescribeOrganizationConformancePackStatusesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConformancePackStatuses API operation for AWS Config.
//
// Provides organization conformance pack deployment status for an organization.
//
// The status is not considered successful until organization conformance pack
// is successfully deployed in all the member accounts with an exception of
// excluded accounts.
//
// When you specify the limit and the next token, you receive a paginated response.
// Limit and next token are not applicable if you specify organization conformance
// pack names. They are only applicable, when you request all the organization
// conformance packs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeOrganizationConformancePackStatuses for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConformancePackException
//   Config organization conformance pack that you passed in the filter does not
//   exist.
//
//   For DeleteOrganizationConformancePack, you tried to delete an organization
//   conformance pack that does not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses
func (c *ConfigService) DescribeOrganizationConformancePackStatuses(input *DescribeOrganizationConformancePackStatusesInput) (*DescribeOrganizationConformancePackStatusesOutput, error) {
	req, out := c.DescribeOrganizationConformancePackStatusesRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConformancePackStatusesWithContext is the same as DescribeOrganizationConformancePackStatuses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConformancePackStatuses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConformancePackStatusesWithContext(ctx aws.Context, input *DescribeOrganizationConformancePackStatusesInput, opts ...request.Option) (*DescribeOrganizationConformancePackStatusesOutput, error) {
	req, out := c.DescribeOrganizationConformancePackStatusesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrganizationConformancePackStatusesPages iterates over the pages of a DescribeOrganizationConformancePackStatuses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrganizationConformancePackStatuses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrganizationConformancePackStatuses operation.
//    pageNum := 0
//    err := client.DescribeOrganizationConformancePackStatusesPages(params,
//        func(page *configservice.DescribeOrganizationConformancePackStatusesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeOrganizationConformancePackStatusesPages(input *DescribeOrganizationConformancePackStatusesInput, fn func(*DescribeOrganizationConformancePackStatusesOutput, bool) bool) error {
	return c.DescribeOrganizationConformancePackStatusesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrganizationConformancePackStatusesPagesWithContext same as DescribeOrganizationConformancePackStatusesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConformancePackStatusesPagesWithContext(ctx aws.Context, input *DescribeOrganizationConformancePackStatusesInput, fn func(*DescribeOrganizationConformancePackStatusesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrganizationConformancePackStatusesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrganizationConformancePackStatusesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrganizationConformancePackStatusesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOrganizationConformancePacks = "DescribeOrganizationConformancePacks"

// DescribeOrganizationConformancePacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConformancePacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConformancePacks for more information on using the DescribeOrganizationConformancePacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConformancePacksRequest method.
//    req, resp := client.DescribeOrganizationConformancePacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks
func (c *ConfigService) DescribeOrganizationConformancePacksRequest(input *DescribeOrganizationConformancePacksInput) (req *request.Request, output *DescribeOrganizationConformancePacksOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConformancePacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrganizationConformancePacksInput{}
	}

	output = &DescribeOrganizationConformancePacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConformancePacks API operation for AWS Config.
//
// Returns a list of organization conformance packs.
//
// When you specify the limit and the next token, you receive a paginated response.
//
// Limit and next token are not applicable if you specify organization conformance
// packs names. They are only applicable, when you request all the organization
// conformance packs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeOrganizationConformancePacks for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConformancePackException
//   Config organization conformance pack that you passed in the filter does not
//   exist.
//
//   For DeleteOrganizationConformancePack, you tried to delete an organization
//   conformance pack that does not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks
func (c *ConfigService) DescribeOrganizationConformancePacks(input *DescribeOrganizationConformancePacksInput) (*DescribeOrganizationConformancePacksOutput, error) {
	req, out := c.DescribeOrganizationConformancePacksRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConformancePacksWithContext is the same as DescribeOrganizationConformancePacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConformancePacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConformancePacksWithContext(ctx aws.Context, input *DescribeOrganizationConformancePacksInput, opts ...request.Option) (*DescribeOrganizationConformancePacksOutput, error) {
	req, out := c.DescribeOrganizationConformancePacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrganizationConformancePacksPages iterates over the pages of a DescribeOrganizationConformancePacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrganizationConformancePacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrganizationConformancePacks operation.
//    pageNum := 0
//    err := client.DescribeOrganizationConformancePacksPages(params,
//        func(page *configservice.DescribeOrganizationConformancePacksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeOrganizationConformancePacksPages(input *DescribeOrganizationConformancePacksInput, fn func(*DescribeOrganizationConformancePacksOutput, bool) bool) error {
	return c.DescribeOrganizationConformancePacksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrganizationConformancePacksPagesWithContext same as DescribeOrganizationConformancePacksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeOrganizationConformancePacksPagesWithContext(ctx aws.Context, input *DescribeOrganizationConformancePacksInput, fn func(*DescribeOrganizationConformancePacksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrganizationConformancePacksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrganizationConformancePacksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrganizationConformancePacksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePendingAggregationRequests = "DescribePendingAggregationRequests"

// DescribePendingAggregationRequestsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingAggregationRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingAggregationRequests for more information on using the DescribePendingAggregationRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePendingAggregationRequestsRequest method.
//    req, resp := client.DescribePendingAggregationRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests
func (c *ConfigService) DescribePendingAggregationRequestsRequest(input *DescribePendingAggregationRequestsInput) (req *request.Request, output *DescribePendingAggregationRequestsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingAggregationRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePendingAggregationRequestsInput{}
	}

	output = &DescribePendingAggregationRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingAggregationRequests API operation for AWS Config.
//
// Returns a list of all pending aggregation requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribePendingAggregationRequests for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests
func (c *ConfigService) DescribePendingAggregationRequests(input *DescribePendingAggregationRequestsInput) (*DescribePendingAggregationRequestsOutput, error) {
	req, out := c.DescribePendingAggregationRequestsRequest(input)
	return out, req.Send()
}

// DescribePendingAggregationRequestsWithContext is the same as DescribePendingAggregationRequests with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingAggregationRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribePendingAggregationRequestsWithContext(ctx aws.Context, input *DescribePendingAggregationRequestsInput, opts ...request.Option) (*DescribePendingAggregationRequestsOutput, error) {
	req, out := c.DescribePendingAggregationRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePendingAggregationRequestsPages iterates over the pages of a DescribePendingAggregationRequests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePendingAggregationRequests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePendingAggregationRequests operation.
//    pageNum := 0
//    err := client.DescribePendingAggregationRequestsPages(params,
//        func(page *configservice.DescribePendingAggregationRequestsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribePendingAggregationRequestsPages(input *DescribePendingAggregationRequestsInput, fn func(*DescribePendingAggregationRequestsOutput, bool) bool) error {
	return c.DescribePendingAggregationRequestsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePendingAggregationRequestsPagesWithContext same as DescribePendingAggregationRequestsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribePendingAggregationRequestsPagesWithContext(ctx aws.Context, input *DescribePendingAggregationRequestsInput, fn func(*DescribePendingAggregationRequestsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePendingAggregationRequestsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePendingAggregationRequestsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePendingAggregationRequestsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRemediationConfigurations = "DescribeRemediationConfigurations"

// DescribeRemediationConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRemediationConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRemediationConfigurations for more information on using the DescribeRemediationConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRemediationConfigurationsRequest method.
//    req, resp := client.DescribeRemediationConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations
func (c *ConfigService) DescribeRemediationConfigurationsRequest(input *DescribeRemediationConfigurationsInput) (req *request.Request, output *DescribeRemediationConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeRemediationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRemediationConfigurationsInput{}
	}

	output = &DescribeRemediationConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRemediationConfigurations API operation for AWS Config.
//
// Returns the details of one or more remediation configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRemediationConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations
func (c *ConfigService) DescribeRemediationConfigurations(input *DescribeRemediationConfigurationsInput) (*DescribeRemediationConfigurationsOutput, error) {
	req, out := c.DescribeRemediationConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeRemediationConfigurationsWithContext is the same as DescribeRemediationConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRemediationConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationConfigurationsWithContext(ctx aws.Context, input *DescribeRemediationConfigurationsInput, opts ...request.Option) (*DescribeRemediationConfigurationsOutput, error) {
	req, out := c.DescribeRemediationConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRemediationExceptions = "DescribeRemediationExceptions"

// DescribeRemediationExceptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRemediationExceptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRemediationExceptions for more information on using the DescribeRemediationExceptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRemediationExceptionsRequest method.
//    req, resp := client.DescribeRemediationExceptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions
func (c *ConfigService) DescribeRemediationExceptionsRequest(input *DescribeRemediationExceptionsInput) (req *request.Request, output *DescribeRemediationExceptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeRemediationExceptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRemediationExceptionsInput{}
	}

	output = &DescribeRemediationExceptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRemediationExceptions API operation for AWS Config.
//
// Returns the details of one or more remediation exceptions. A detailed view
// of a remediation exception for a set of resources that includes an explanation
// of an exception and the time when the exception will be deleted. When you
// specify the limit and the next token, you receive a paginated response.
//
// Config generates a remediation exception when a problem occurs executing
// a remediation action to a specific resource. Remediation exceptions blocks
// auto-remediation until the exception is cleared.
//
// When you specify the limit and the next token, you receive a paginated response.
//
// Limit and next token are not applicable if you request resources in batch.
// It is only applicable, when you request all resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRemediationExceptions for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions
func (c *ConfigService) DescribeRemediationExceptions(input *DescribeRemediationExceptionsInput) (*DescribeRemediationExceptionsOutput, error) {
	req, out := c.DescribeRemediationExceptionsRequest(input)
	return out, req.Send()
}

// DescribeRemediationExceptionsWithContext is the same as DescribeRemediationExceptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRemediationExceptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationExceptionsWithContext(ctx aws.Context, input *DescribeRemediationExceptionsInput, opts ...request.Option) (*DescribeRemediationExceptionsOutput, error) {
	req, out := c.DescribeRemediationExceptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRemediationExceptionsPages iterates over the pages of a DescribeRemediationExceptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRemediationExceptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeRemediationExceptions operation.
//    pageNum := 0
//    err := client.DescribeRemediationExceptionsPages(params,
//        func(page *configservice.DescribeRemediationExceptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeRemediationExceptionsPages(input *DescribeRemediationExceptionsInput, fn func(*DescribeRemediationExceptionsOutput, bool) bool) error {
	return c.DescribeRemediationExceptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRemediationExceptionsPagesWithContext same as DescribeRemediationExceptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationExceptionsPagesWithContext(ctx aws.Context, input *DescribeRemediationExceptionsInput, fn func(*DescribeRemediationExceptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRemediationExceptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRemediationExceptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRemediationExceptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRemediationExecutionStatus = "DescribeRemediationExecutionStatus"

// DescribeRemediationExecutionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRemediationExecutionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRemediationExecutionStatus for more information on using the DescribeRemediationExecutionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRemediationExecutionStatusRequest method.
//    req, resp := client.DescribeRemediationExecutionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus
func (c *ConfigService) DescribeRemediationExecutionStatusRequest(input *DescribeRemediationExecutionStatusInput) (req *request.Request, output *DescribeRemediationExecutionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeRemediationExecutionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRemediationExecutionStatusInput{}
	}

	output = &DescribeRemediationExecutionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRemediationExecutionStatus API operation for AWS Config.
//
// Provides a detailed view of a Remediation Execution for a set of resources
// including state, timestamps for when steps for the remediation execution
// occur, and any error messages for steps that have failed. When you specify
// the limit and the next token, you receive a paginated response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRemediationExecutionStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchRemediationConfigurationException
//   You specified an Config rule without a remediation configuration.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus
func (c *ConfigService) DescribeRemediationExecutionStatus(input *DescribeRemediationExecutionStatusInput) (*DescribeRemediationExecutionStatusOutput, error) {
	req, out := c.DescribeRemediationExecutionStatusRequest(input)
	return out, req.Send()
}

// DescribeRemediationExecutionStatusWithContext is the same as DescribeRemediationExecutionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRemediationExecutionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationExecutionStatusWithContext(ctx aws.Context, input *DescribeRemediationExecutionStatusInput, opts ...request.Option) (*DescribeRemediationExecutionStatusOutput, error) {
	req, out := c.DescribeRemediationExecutionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRemediationExecutionStatusPages iterates over the pages of a DescribeRemediationExecutionStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRemediationExecutionStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeRemediationExecutionStatus operation.
//    pageNum := 0
//    err := client.DescribeRemediationExecutionStatusPages(params,
//        func(page *configservice.DescribeRemediationExecutionStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeRemediationExecutionStatusPages(input *DescribeRemediationExecutionStatusInput, fn func(*DescribeRemediationExecutionStatusOutput, bool) bool) error {
	return c.DescribeRemediationExecutionStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRemediationExecutionStatusPagesWithContext same as DescribeRemediationExecutionStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRemediationExecutionStatusPagesWithContext(ctx aws.Context, input *DescribeRemediationExecutionStatusInput, fn func(*DescribeRemediationExecutionStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRemediationExecutionStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRemediationExecutionStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRemediationExecutionStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRetentionConfigurations = "DescribeRetentionConfigurations"

// DescribeRetentionConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRetentionConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRetentionConfigurations for more information on using the DescribeRetentionConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRetentionConfigurationsRequest method.
//    req, resp := client.DescribeRetentionConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations
func (c *ConfigService) DescribeRetentionConfigurationsRequest(input *DescribeRetentionConfigurationsInput) (req *request.Request, output *DescribeRetentionConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeRetentionConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRetentionConfigurationsInput{}
	}

	output = &DescribeRetentionConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRetentionConfigurations API operation for AWS Config.
//
// Returns the details of one or more retention configurations. If the retention
// configuration name is not specified, this action returns the details for
// all the retention configurations for that account.
//
// Currently, Config supports only one retention configuration per region in
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRetentionConfigurations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * NoSuchRetentionConfigurationException
//   You have specified a retention configuration that does not exist.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations
func (c *ConfigService) DescribeRetentionConfigurations(input *DescribeRetentionConfigurationsInput) (*DescribeRetentionConfigurationsOutput, error) {
	req, out := c.DescribeRetentionConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeRetentionConfigurationsWithContext is the same as DescribeRetentionConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRetentionConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRetentionConfigurationsWithContext(ctx aws.Context, input *DescribeRetentionConfigurationsInput, opts ...request.Option) (*DescribeRetentionConfigurationsOutput, error) {
	req, out := c.DescribeRetentionConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRetentionConfigurationsPages iterates over the pages of a DescribeRetentionConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRetentionConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeRetentionConfigurations operation.
//    pageNum := 0
//    err := client.DescribeRetentionConfigurationsPages(params,
//        func(page *configservice.DescribeRetentionConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) DescribeRetentionConfigurationsPages(input *DescribeRetentionConfigurationsInput, fn func(*DescribeRetentionConfigurationsOutput, bool) bool) error {
	return c.DescribeRetentionConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRetentionConfigurationsPagesWithContext same as DescribeRetentionConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRetentionConfigurationsPagesWithContext(ctx aws.Context, input *DescribeRetentionConfigurationsInput, fn func(*DescribeRetentionConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRetentionConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRetentionConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRetentionConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAggregateComplianceDetailsByConfigRule = "GetAggregateComplianceDetailsByConfigRule"

// GetAggregateComplianceDetailsByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateComplianceDetailsByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateComplianceDetailsByConfigRule for more information on using the GetAggregateComplianceDetailsByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateComplianceDetailsByConfigRuleRequest method.
//    req, resp := client.GetAggregateComplianceDetailsByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRuleRequest(input *GetAggregateComplianceDetailsByConfigRuleInput) (req *request.Request, output *GetAggregateComplianceDetailsByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetAggregateComplianceDetailsByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAggregateComplianceDetailsByConfigRuleInput{}
	}

	output = &GetAggregateComplianceDetailsByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateComplianceDetailsByConfigRule API operation for AWS Config.
//
// Returns the evaluation results for the specified Config rule for a specific
// resource in a rule. The results indicate which Amazon Web Services resources
// were evaluated by the rule, when each resource was last evaluated, and whether
// each resource complies with the rule.
//
// The results can return an empty result page. But if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateComplianceDetailsByConfigRule for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRule(input *GetAggregateComplianceDetailsByConfigRuleInput) (*GetAggregateComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetAggregateComplianceDetailsByConfigRuleRequest(input)
	return out, req.Send()
}

// GetAggregateComplianceDetailsByConfigRuleWithContext is the same as GetAggregateComplianceDetailsByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateComplianceDetailsByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRuleWithContext(ctx aws.Context, input *GetAggregateComplianceDetailsByConfigRuleInput, opts ...request.Option) (*GetAggregateComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetAggregateComplianceDetailsByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAggregateComplianceDetailsByConfigRulePages iterates over the pages of a GetAggregateComplianceDetailsByConfigRule operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAggregateComplianceDetailsByConfigRule method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAggregateComplianceDetailsByConfigRule operation.
//    pageNum := 0
//    err := client.GetAggregateComplianceDetailsByConfigRulePages(params,
//        func(page *configservice.GetAggregateComplianceDetailsByConfigRuleOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRulePages(input *GetAggregateComplianceDetailsByConfigRuleInput, fn func(*GetAggregateComplianceDetailsByConfigRuleOutput, bool) bool) error {
	return c.GetAggregateComplianceDetailsByConfigRulePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAggregateComplianceDetailsByConfigRulePagesWithContext same as GetAggregateComplianceDetailsByConfigRulePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRulePagesWithContext(ctx aws.Context, input *GetAggregateComplianceDetailsByConfigRuleInput, fn func(*GetAggregateComplianceDetailsByConfigRuleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAggregateComplianceDetailsByConfigRuleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAggregateComplianceDetailsByConfigRuleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAggregateComplianceDetailsByConfigRuleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAggregateConfigRuleComplianceSummary = "GetAggregateConfigRuleComplianceSummary"

// GetAggregateConfigRuleComplianceSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateConfigRuleComplianceSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateConfigRuleComplianceSummary for more information on using the GetAggregateConfigRuleComplianceSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateConfigRuleComplianceSummaryRequest method.
//    req, resp := client.GetAggregateConfigRuleComplianceSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary
func (c *ConfigService) GetAggregateConfigRuleComplianceSummaryRequest(input *GetAggregateConfigRuleComplianceSummaryInput) (req *request.Request, output *GetAggregateConfigRuleComplianceSummaryOutput) {
	op := &request.Operation{
		Name:       opGetAggregateConfigRuleComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAggregateConfigRuleComplianceSummaryInput{}
	}

	output = &GetAggregateConfigRuleComplianceSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateConfigRuleComplianceSummary API operation for AWS Config.
//
// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateConfigRuleComplianceSummary for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary
func (c *ConfigService) GetAggregateConfigRuleComplianceSummary(input *GetAggregateConfigRuleComplianceSummaryInput) (*GetAggregateConfigRuleComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConfigRuleComplianceSummaryRequest(input)
	return out, req.Send()
}

// GetAggregateConfigRuleComplianceSummaryWithContext is the same as GetAggregateConfigRuleComplianceSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateConfigRuleComplianceSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateConfigRuleComplianceSummaryWithContext(ctx aws.Context, input *GetAggregateConfigRuleComplianceSummaryInput, opts ...request.Option) (*GetAggregateConfigRuleComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConfigRuleComplianceSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAggregateConfigRuleComplianceSummaryPages iterates over the pages of a GetAggregateConfigRuleComplianceSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAggregateConfigRuleComplianceSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAggregateConfigRuleComplianceSummary operation.
//    pageNum := 0
//    err := client.GetAggregateConfigRuleComplianceSummaryPages(params,
//        func(page *configservice.GetAggregateConfigRuleComplianceSummaryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetAggregateConfigRuleComplianceSummaryPages(input *GetAggregateConfigRuleComplianceSummaryInput, fn func(*GetAggregateConfigRuleComplianceSummaryOutput, bool) bool) error {
	return c.GetAggregateConfigRuleComplianceSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAggregateConfigRuleComplianceSummaryPagesWithContext same as GetAggregateConfigRuleComplianceSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateConfigRuleComplianceSummaryPagesWithContext(ctx aws.Context, input *GetAggregateConfigRuleComplianceSummaryInput, fn func(*GetAggregateConfigRuleComplianceSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAggregateConfigRuleComplianceSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAggregateConfigRuleComplianceSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAggregateConfigRuleComplianceSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAggregateConformancePackComplianceSummary = "GetAggregateConformancePackComplianceSummary"

// GetAggregateConformancePackComplianceSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateConformancePackComplianceSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateConformancePackComplianceSummary for more information on using the GetAggregateConformancePackComplianceSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateConformancePackComplianceSummaryRequest method.
//    req, resp := client.GetAggregateConformancePackComplianceSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary
func (c *ConfigService) GetAggregateConformancePackComplianceSummaryRequest(input *GetAggregateConformancePackComplianceSummaryInput) (req *request.Request, output *GetAggregateConformancePackComplianceSummaryOutput) {
	op := &request.Operation{
		Name:       opGetAggregateConformancePackComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAggregateConformancePackComplianceSummaryInput{}
	}

	output = &GetAggregateConformancePackComplianceSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateConformancePackComplianceSummary API operation for AWS Config.
//
// Returns the count of compliant and noncompliant conformance packs across
// all Amazon Web Services accounts and Amazon Web Services Regions in an aggregator.
// You can filter based on Amazon Web Services account ID or Amazon Web Services
// Region.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateConformancePackComplianceSummary for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary
func (c *ConfigService) GetAggregateConformancePackComplianceSummary(input *GetAggregateConformancePackComplianceSummaryInput) (*GetAggregateConformancePackComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConformancePackComplianceSummaryRequest(input)
	return out, req.Send()
}

// GetAggregateConformancePackComplianceSummaryWithContext is the same as GetAggregateConformancePackComplianceSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateConformancePackComplianceSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateConformancePackComplianceSummaryWithContext(ctx aws.Context, input *GetAggregateConformancePackComplianceSummaryInput, opts ...request.Option) (*GetAggregateConformancePackComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConformancePackComplianceSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAggregateConformancePackComplianceSummaryPages iterates over the pages of a GetAggregateConformancePackComplianceSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAggregateConformancePackComplianceSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAggregateConformancePackComplianceSummary operation.
//    pageNum := 0
//    err := client.GetAggregateConformancePackComplianceSummaryPages(params,
//        func(page *configservice.GetAggregateConformancePackComplianceSummaryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetAggregateConformancePackComplianceSummaryPages(input *GetAggregateConformancePackComplianceSummaryInput, fn func(*GetAggregateConformancePackComplianceSummaryOutput, bool) bool) error {
	return c.GetAggregateConformancePackComplianceSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAggregateConformancePackComplianceSummaryPagesWithContext same as GetAggregateConformancePackComplianceSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateConformancePackComplianceSummaryPagesWithContext(ctx aws.Context, input *GetAggregateConformancePackComplianceSummaryInput, fn func(*GetAggregateConformancePackComplianceSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAggregateConformancePackComplianceSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAggregateConformancePackComplianceSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAggregateConformancePackComplianceSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAggregateDiscoveredResourceCounts = "GetAggregateDiscoveredResourceCounts"

// GetAggregateDiscoveredResourceCountsRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateDiscoveredResourceCounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateDiscoveredResourceCounts for more information on using the GetAggregateDiscoveredResourceCounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateDiscoveredResourceCountsRequest method.
//    req, resp := client.GetAggregateDiscoveredResourceCountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts
func (c *ConfigService) GetAggregateDiscoveredResourceCountsRequest(input *GetAggregateDiscoveredResourceCountsInput) (req *request.Request, output *GetAggregateDiscoveredResourceCountsOutput) {
	op := &request.Operation{
		Name:       opGetAggregateDiscoveredResourceCounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAggregateDiscoveredResourceCountsInput{}
	}

	output = &GetAggregateDiscoveredResourceCountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateDiscoveredResourceCounts API operation for AWS Config.
//
// Returns the resource counts across accounts and regions that are present
// in your Config aggregator. You can request the resource counts by providing
// filters and GroupByKey.
//
// For example, if the input contains accountID 12345678910 and region us-east-1
// in filters, the API returns the count of resources in account ID 12345678910
// and region us-east-1. If the input contains ACCOUNT_ID as a GroupByKey, the
// API returns resource counts for all source accounts that are present in your
// aggregator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateDiscoveredResourceCounts for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts
func (c *ConfigService) GetAggregateDiscoveredResourceCounts(input *GetAggregateDiscoveredResourceCountsInput) (*GetAggregateDiscoveredResourceCountsOutput, error) {
	req, out := c.GetAggregateDiscoveredResourceCountsRequest(input)
	return out, req.Send()
}

// GetAggregateDiscoveredResourceCountsWithContext is the same as GetAggregateDiscoveredResourceCounts with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateDiscoveredResourceCounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateDiscoveredResourceCountsWithContext(ctx aws.Context, input *GetAggregateDiscoveredResourceCountsInput, opts ...request.Option) (*GetAggregateDiscoveredResourceCountsOutput, error) {
	req, out := c.GetAggregateDiscoveredResourceCountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetAggregateDiscoveredResourceCountsPages iterates over the pages of a GetAggregateDiscoveredResourceCounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAggregateDiscoveredResourceCounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAggregateDiscoveredResourceCounts operation.
//    pageNum := 0
//    err := client.GetAggregateDiscoveredResourceCountsPages(params,
//        func(page *configservice.GetAggregateDiscoveredResourceCountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetAggregateDiscoveredResourceCountsPages(input *GetAggregateDiscoveredResourceCountsInput, fn func(*GetAggregateDiscoveredResourceCountsOutput, bool) bool) error {
	return c.GetAggregateDiscoveredResourceCountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetAggregateDiscoveredResourceCountsPagesWithContext same as GetAggregateDiscoveredResourceCountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateDiscoveredResourceCountsPagesWithContext(ctx aws.Context, input *GetAggregateDiscoveredResourceCountsInput, fn func(*GetAggregateDiscoveredResourceCountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetAggregateDiscoveredResourceCountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetAggregateDiscoveredResourceCountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetAggregateDiscoveredResourceCountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAggregateResourceConfig = "GetAggregateResourceConfig"

// GetAggregateResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateResourceConfig for more information on using the GetAggregateResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateResourceConfigRequest method.
//    req, resp := client.GetAggregateResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig
func (c *ConfigService) GetAggregateResourceConfigRequest(input *GetAggregateResourceConfigInput) (req *request.Request, output *GetAggregateResourceConfigOutput) {
	op := &request.Operation{
		Name:       opGetAggregateResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateResourceConfigInput{}
	}

	output = &GetAggregateResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateResourceConfig API operation for AWS Config.
//
// Returns configuration item that is aggregated for your specific resource
// in a specific source account and region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
//   * OversizedConfigurationItemException
//   The configuration item size is outside the allowable range.
//
//   * ResourceNotDiscoveredException
//   You have specified a resource that is either unknown or has not been discovered.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig
func (c *ConfigService) GetAggregateResourceConfig(input *GetAggregateResourceConfigInput) (*GetAggregateResourceConfigOutput, error) {
	req, out := c.GetAggregateResourceConfigRequest(input)
	return out, req.Send()
}

// GetAggregateResourceConfigWithContext is the same as GetAggregateResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateResourceConfigWithContext(ctx aws.Context, input *GetAggregateResourceConfigInput, opts ...request.Option) (*GetAggregateResourceConfigOutput, error) {
	req, out := c.GetAggregateResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceDetailsByConfigRule = "GetComplianceDetailsByConfigRule"

// GetComplianceDetailsByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceDetailsByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceDetailsByConfigRule for more information on using the GetComplianceDetailsByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceDetailsByConfigRuleRequest method.
//    req, resp := client.GetComplianceDetailsByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule
func (c *ConfigService) GetComplianceDetailsByConfigRuleRequest(input *GetComplianceDetailsByConfigRuleInput) (req *request.Request, output *GetComplianceDetailsByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetComplianceDetailsByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetComplianceDetailsByConfigRuleInput{}
	}

	output = &GetComplianceDetailsByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceDetailsByConfigRule API operation for AWS Config.
//
// Returns the evaluation results for the specified Config rule. The results
// indicate which Amazon Web Services resources were evaluated by the rule,
// when each resource was last evaluated, and whether each resource complies
// with the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceDetailsByConfigRule for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule
func (c *ConfigService) GetComplianceDetailsByConfigRule(input *GetComplianceDetailsByConfigRuleInput) (*GetComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetComplianceDetailsByConfigRuleRequest(input)
	return out, req.Send()
}

// GetComplianceDetailsByConfigRuleWithContext is the same as GetComplianceDetailsByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceDetailsByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceDetailsByConfigRuleWithContext(ctx aws.Context, input *GetComplianceDetailsByConfigRuleInput, opts ...request.Option) (*GetComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetComplianceDetailsByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetComplianceDetailsByConfigRulePages iterates over the pages of a GetComplianceDetailsByConfigRule operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetComplianceDetailsByConfigRule method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetComplianceDetailsByConfigRule operation.
//    pageNum := 0
//    err := client.GetComplianceDetailsByConfigRulePages(params,
//        func(page *configservice.GetComplianceDetailsByConfigRuleOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetComplianceDetailsByConfigRulePages(input *GetComplianceDetailsByConfigRuleInput, fn func(*GetComplianceDetailsByConfigRuleOutput, bool) bool) error {
	return c.GetComplianceDetailsByConfigRulePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetComplianceDetailsByConfigRulePagesWithContext same as GetComplianceDetailsByConfigRulePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceDetailsByConfigRulePagesWithContext(ctx aws.Context, input *GetComplianceDetailsByConfigRuleInput, fn func(*GetComplianceDetailsByConfigRuleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetComplianceDetailsByConfigRuleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetComplianceDetailsByConfigRuleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetComplianceDetailsByConfigRuleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetComplianceDetailsByResource = "GetComplianceDetailsByResource"

// GetComplianceDetailsByResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceDetailsByResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceDetailsByResource for more information on using the GetComplianceDetailsByResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceDetailsByResourceRequest method.
//    req, resp := client.GetComplianceDetailsByResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource
func (c *ConfigService) GetComplianceDetailsByResourceRequest(input *GetComplianceDetailsByResourceInput) (req *request.Request, output *GetComplianceDetailsByResourceOutput) {
	op := &request.Operation{
		Name:       opGetComplianceDetailsByResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetComplianceDetailsByResourceInput{}
	}

	output = &GetComplianceDetailsByResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceDetailsByResource API operation for AWS Config.
//
// Returns the evaluation results for the specified Amazon Web Services resource.
// The results indicate which Config rules were used to evaluate the resource,
// when each rule was last used, and whether the resource complies with each
// rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceDetailsByResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource
func (c *ConfigService) GetComplianceDetailsByResource(input *GetComplianceDetailsByResourceInput) (*GetComplianceDetailsByResourceOutput, error) {
	req, out := c.GetComplianceDetailsByResourceRequest(input)
	return out, req.Send()
}

// GetComplianceDetailsByResourceWithContext is the same as GetComplianceDetailsByResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceDetailsByResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceDetailsByResourceWithContext(ctx aws.Context, input *GetComplianceDetailsByResourceInput, opts ...request.Option) (*GetComplianceDetailsByResourceOutput, error) {
	req, out := c.GetComplianceDetailsByResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetComplianceDetailsByResourcePages iterates over the pages of a GetComplianceDetailsByResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetComplianceDetailsByResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetComplianceDetailsByResource operation.
//    pageNum := 0
//    err := client.GetComplianceDetailsByResourcePages(params,
//        func(page *configservice.GetComplianceDetailsByResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetComplianceDetailsByResourcePages(input *GetComplianceDetailsByResourceInput, fn func(*GetComplianceDetailsByResourceOutput, bool) bool) error {
	return c.GetComplianceDetailsByResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetComplianceDetailsByResourcePagesWithContext same as GetComplianceDetailsByResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceDetailsByResourcePagesWithContext(ctx aws.Context, input *GetComplianceDetailsByResourceInput, fn func(*GetComplianceDetailsByResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetComplianceDetailsByResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetComplianceDetailsByResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetComplianceDetailsByResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetComplianceSummaryByConfigRule = "GetComplianceSummaryByConfigRule"

// GetComplianceSummaryByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceSummaryByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceSummaryByConfigRule for more information on using the GetComplianceSummaryByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceSummaryByConfigRuleRequest method.
//    req, resp := client.GetComplianceSummaryByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule
func (c *ConfigService) GetComplianceSummaryByConfigRuleRequest(input *GetComplianceSummaryByConfigRuleInput) (req *request.Request, output *GetComplianceSummaryByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetComplianceSummaryByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceSummaryByConfigRuleInput{}
	}

	output = &GetComplianceSummaryByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceSummaryByConfigRule API operation for AWS Config.
//
// Returns the number of Config rules that are compliant and noncompliant, up
// to a maximum of 25 for each.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceSummaryByConfigRule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule
func (c *ConfigService) GetComplianceSummaryByConfigRule(input *GetComplianceSummaryByConfigRuleInput) (*GetComplianceSummaryByConfigRuleOutput, error) {
	req, out := c.GetComplianceSummaryByConfigRuleRequest(input)
	return out, req.Send()
}

// GetComplianceSummaryByConfigRuleWithContext is the same as GetComplianceSummaryByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceSummaryByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceSummaryByConfigRuleWithContext(ctx aws.Context, input *GetComplianceSummaryByConfigRuleInput, opts ...request.Option) (*GetComplianceSummaryByConfigRuleOutput, error) {
	req, out := c.GetComplianceSummaryByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceSummaryByResourceType = "GetComplianceSummaryByResourceType"

// GetComplianceSummaryByResourceTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceSummaryByResourceType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceSummaryByResourceType for more information on using the GetComplianceSummaryByResourceType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceSummaryByResourceTypeRequest method.
//    req, resp := client.GetComplianceSummaryByResourceTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType
func (c *ConfigService) GetComplianceSummaryByResourceTypeRequest(input *GetComplianceSummaryByResourceTypeInput) (req *request.Request, output *GetComplianceSummaryByResourceTypeOutput) {
	op := &request.Operation{
		Name:       opGetComplianceSummaryByResourceType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceSummaryByResourceTypeInput{}
	}

	output = &GetComplianceSummaryByResourceTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceSummaryByResourceType API operation for AWS Config.
//
// Returns the number of resources that are compliant and the number that are
// noncompliant. You can specify one or more resource types to get these numbers
// for each resource type. The maximum number returned is 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceSummaryByResourceType for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType
func (c *ConfigService) GetComplianceSummaryByResourceType(input *GetComplianceSummaryByResourceTypeInput) (*GetComplianceSummaryByResourceTypeOutput, error) {
	req, out := c.GetComplianceSummaryByResourceTypeRequest(input)
	return out, req.Send()
}

// GetComplianceSummaryByResourceTypeWithContext is the same as GetComplianceSummaryByResourceType with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceSummaryByResourceType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceSummaryByResourceTypeWithContext(ctx aws.Context, input *GetComplianceSummaryByResourceTypeInput, opts ...request.Option) (*GetComplianceSummaryByResourceTypeOutput, error) {
	req, out := c.GetComplianceSummaryByResourceTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConformancePackComplianceDetails = "GetConformancePackComplianceDetails"

// GetConformancePackComplianceDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetConformancePackComplianceDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConformancePackComplianceDetails for more information on using the GetConformancePackComplianceDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConformancePackComplianceDetailsRequest method.
//    req, resp := client.GetConformancePackComplianceDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails
func (c *ConfigService) GetConformancePackComplianceDetailsRequest(input *GetConformancePackComplianceDetailsInput) (req *request.Request, output *GetConformancePackComplianceDetailsOutput) {
	op := &request.Operation{
		Name:       opGetConformancePackComplianceDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetConformancePackComplianceDetailsInput{}
	}

	output = &GetConformancePackComplianceDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConformancePackComplianceDetails API operation for AWS Config.
//
// Returns compliance details of a conformance pack for all Amazon Web Services
// resources that are monitered by conformance pack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetConformancePackComplianceDetails for usage and error information.
//
// Returned Error Types:
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
//   * NoSuchConfigRuleInConformancePackException
//   Config rule that you passed in the filter does not exist.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails
func (c *ConfigService) GetConformancePackComplianceDetails(input *GetConformancePackComplianceDetailsInput) (*GetConformancePackComplianceDetailsOutput, error) {
	req, out := c.GetConformancePackComplianceDetailsRequest(input)
	return out, req.Send()
}

// GetConformancePackComplianceDetailsWithContext is the same as GetConformancePackComplianceDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetConformancePackComplianceDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetConformancePackComplianceDetailsWithContext(ctx aws.Context, input *GetConformancePackComplianceDetailsInput, opts ...request.Option) (*GetConformancePackComplianceDetailsOutput, error) {
	req, out := c.GetConformancePackComplianceDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetConformancePackComplianceDetailsPages iterates over the pages of a GetConformancePackComplianceDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetConformancePackComplianceDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetConformancePackComplianceDetails operation.
//    pageNum := 0
//    err := client.GetConformancePackComplianceDetailsPages(params,
//        func(page *configservice.GetConformancePackComplianceDetailsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetConformancePackComplianceDetailsPages(input *GetConformancePackComplianceDetailsInput, fn func(*GetConformancePackComplianceDetailsOutput, bool) bool) error {
	return c.GetConformancePackComplianceDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetConformancePackComplianceDetailsPagesWithContext same as GetConformancePackComplianceDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetConformancePackComplianceDetailsPagesWithContext(ctx aws.Context, input *GetConformancePackComplianceDetailsInput, fn func(*GetConformancePackComplianceDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetConformancePackComplianceDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetConformancePackComplianceDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetConformancePackComplianceDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetConformancePackComplianceSummary = "GetConformancePackComplianceSummary"

// GetConformancePackComplianceSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetConformancePackComplianceSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConformancePackComplianceSummary for more information on using the GetConformancePackComplianceSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConformancePackComplianceSummaryRequest method.
//    req, resp := client.GetConformancePackComplianceSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary
func (c *ConfigService) GetConformancePackComplianceSummaryRequest(input *GetConformancePackComplianceSummaryInput) (req *request.Request, output *GetConformancePackComplianceSummaryOutput) {
	op := &request.Operation{
		Name:       opGetConformancePackComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetConformancePackComplianceSummaryInput{}
	}

	output = &GetConformancePackComplianceSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConformancePackComplianceSummary API operation for AWS Config.
//
// Returns compliance details for the conformance pack based on the cumulative
// compliance results of all the rules in that conformance pack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetConformancePackComplianceSummary for usage and error information.
//
// Returned Error Types:
//   * NoSuchConformancePackException
//   You specified one or more conformance packs that do not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary
func (c *ConfigService) GetConformancePackComplianceSummary(input *GetConformancePackComplianceSummaryInput) (*GetConformancePackComplianceSummaryOutput, error) {
	req, out := c.GetConformancePackComplianceSummaryRequest(input)
	return out, req.Send()
}

// GetConformancePackComplianceSummaryWithContext is the same as GetConformancePackComplianceSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetConformancePackComplianceSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetConformancePackComplianceSummaryWithContext(ctx aws.Context, input *GetConformancePackComplianceSummaryInput, opts ...request.Option) (*GetConformancePackComplianceSummaryOutput, error) {
	req, out := c.GetConformancePackComplianceSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetConformancePackComplianceSummaryPages iterates over the pages of a GetConformancePackComplianceSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetConformancePackComplianceSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetConformancePackComplianceSummary operation.
//    pageNum := 0
//    err := client.GetConformancePackComplianceSummaryPages(params,
//        func(page *configservice.GetConformancePackComplianceSummaryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetConformancePackComplianceSummaryPages(input *GetConformancePackComplianceSummaryInput, fn func(*GetConformancePackComplianceSummaryOutput, bool) bool) error {
	return c.GetConformancePackComplianceSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetConformancePackComplianceSummaryPagesWithContext same as GetConformancePackComplianceSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetConformancePackComplianceSummaryPagesWithContext(ctx aws.Context, input *GetConformancePackComplianceSummaryInput, fn func(*GetConformancePackComplianceSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetConformancePackComplianceSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetConformancePackComplianceSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetConformancePackComplianceSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetCustomRulePolicy = "GetCustomRulePolicy"

// GetCustomRulePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetCustomRulePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCustomRulePolicy for more information on using the GetCustomRulePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCustomRulePolicyRequest method.
//    req, resp := client.GetCustomRulePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetCustomRulePolicy
func (c *ConfigService) GetCustomRulePolicyRequest(input *GetCustomRulePolicyInput) (req *request.Request, output *GetCustomRulePolicyOutput) {
	op := &request.Operation{
		Name:       opGetCustomRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCustomRulePolicyInput{}
	}

	output = &GetCustomRulePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCustomRulePolicy API operation for AWS Config.
//
// Returns the policy definition containing the logic for your Config Custom
// Policy rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetCustomRulePolicy for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetCustomRulePolicy
func (c *ConfigService) GetCustomRulePolicy(input *GetCustomRulePolicyInput) (*GetCustomRulePolicyOutput, error) {
	req, out := c.GetCustomRulePolicyRequest(input)
	return out, req.Send()
}

// GetCustomRulePolicyWithContext is the same as GetCustomRulePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetCustomRulePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetCustomRulePolicyWithContext(ctx aws.Context, input *GetCustomRulePolicyInput, opts ...request.Option) (*GetCustomRulePolicyOutput, error) {
	req, out := c.GetCustomRulePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiscoveredResourceCounts = "GetDiscoveredResourceCounts"

// GetDiscoveredResourceCountsRequest generates a "aws/request.Request" representing the
// client's request for the GetDiscoveredResourceCounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiscoveredResourceCounts for more information on using the GetDiscoveredResourceCounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiscoveredResourceCountsRequest method.
//    req, resp := client.GetDiscoveredResourceCountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts
func (c *ConfigService) GetDiscoveredResourceCountsRequest(input *GetDiscoveredResourceCountsInput) (req *request.Request, output *GetDiscoveredResourceCountsOutput) {
	op := &request.Operation{
		Name:       opGetDiscoveredResourceCounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDiscoveredResourceCountsInput{}
	}

	output = &GetDiscoveredResourceCountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiscoveredResourceCounts API operation for AWS Config.
//
// Returns the resource types, the number of each resource type, and the total
// number of resources that Config is recording in this region for your Amazon
// Web Services account.
//
// Example
//
// Config is recording three resource types in the US East (Ohio) Region for
// your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets.
//
// You make a call to the GetDiscoveredResourceCounts action and specify that
// you want all resource types.
//
// Config returns the following:
//
//    * The resource types (EC2 instances, IAM users, and S3 buckets).
//
//    * The number of each resource type (25, 20, and 15).
//
//    * The total number of all resources (60).
//
// The response is paginated. By default, Config lists 100 ResourceCount objects
// on each page. You can customize this number with the limit parameter. The
// response includes a nextToken string. To get the next page of results, run
// the request again and specify the string for the nextToken parameter.
//
// If you make a call to the GetDiscoveredResourceCounts action, you might not
// immediately receive resource counts in the following situations:
//
//    * You are a new Config customer.
//
//    * You just enabled resource recording.
//
// It might take a few minutes for Config to record and count your resources.
// Wait a few minutes and then retry the GetDiscoveredResourceCounts action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetDiscoveredResourceCounts for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts
func (c *ConfigService) GetDiscoveredResourceCounts(input *GetDiscoveredResourceCountsInput) (*GetDiscoveredResourceCountsOutput, error) {
	req, out := c.GetDiscoveredResourceCountsRequest(input)
	return out, req.Send()
}

// GetDiscoveredResourceCountsWithContext is the same as GetDiscoveredResourceCounts with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiscoveredResourceCounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetDiscoveredResourceCountsWithContext(ctx aws.Context, input *GetDiscoveredResourceCountsInput, opts ...request.Option) (*GetDiscoveredResourceCountsOutput, error) {
	req, out := c.GetDiscoveredResourceCountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDiscoveredResourceCountsPages iterates over the pages of a GetDiscoveredResourceCounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDiscoveredResourceCounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDiscoveredResourceCounts operation.
//    pageNum := 0
//    err := client.GetDiscoveredResourceCountsPages(params,
//        func(page *configservice.GetDiscoveredResourceCountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetDiscoveredResourceCountsPages(input *GetDiscoveredResourceCountsInput, fn func(*GetDiscoveredResourceCountsOutput, bool) bool) error {
	return c.GetDiscoveredResourceCountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDiscoveredResourceCountsPagesWithContext same as GetDiscoveredResourceCountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetDiscoveredResourceCountsPagesWithContext(ctx aws.Context, input *GetDiscoveredResourceCountsInput, fn func(*GetDiscoveredResourceCountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDiscoveredResourceCountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDiscoveredResourceCountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDiscoveredResourceCountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetOrganizationConfigRuleDetailedStatus = "GetOrganizationConfigRuleDetailedStatus"

// GetOrganizationConfigRuleDetailedStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetOrganizationConfigRuleDetailedStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOrganizationConfigRuleDetailedStatus for more information on using the GetOrganizationConfigRuleDetailedStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOrganizationConfigRuleDetailedStatusRequest method.
//    req, resp := client.GetOrganizationConfigRuleDetailedStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus
func (c *ConfigService) GetOrganizationConfigRuleDetailedStatusRequest(input *GetOrganizationConfigRuleDetailedStatusInput) (req *request.Request, output *GetOrganizationConfigRuleDetailedStatusOutput) {
	op := &request.Operation{
		Name:       opGetOrganizationConfigRuleDetailedStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetOrganizationConfigRuleDetailedStatusInput{}
	}

	output = &GetOrganizationConfigRuleDetailedStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOrganizationConfigRuleDetailedStatus API operation for AWS Config.
//
// Returns detailed status for each member account within an organization for
// a given organization Config rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetOrganizationConfigRuleDetailedStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an organization
//   Config Custom Policy rule, that the rule name is correct, and that valid
//   Amazon Resouce Names (ARNs) are used before trying again.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus
func (c *ConfigService) GetOrganizationConfigRuleDetailedStatus(input *GetOrganizationConfigRuleDetailedStatusInput) (*GetOrganizationConfigRuleDetailedStatusOutput, error) {
	req, out := c.GetOrganizationConfigRuleDetailedStatusRequest(input)
	return out, req.Send()
}

// GetOrganizationConfigRuleDetailedStatusWithContext is the same as GetOrganizationConfigRuleDetailedStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetOrganizationConfigRuleDetailedStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetOrganizationConfigRuleDetailedStatusWithContext(ctx aws.Context, input *GetOrganizationConfigRuleDetailedStatusInput, opts ...request.Option) (*GetOrganizationConfigRuleDetailedStatusOutput, error) {
	req, out := c.GetOrganizationConfigRuleDetailedStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetOrganizationConfigRuleDetailedStatusPages iterates over the pages of a GetOrganizationConfigRuleDetailedStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetOrganizationConfigRuleDetailedStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetOrganizationConfigRuleDetailedStatus operation.
//    pageNum := 0
//    err := client.GetOrganizationConfigRuleDetailedStatusPages(params,
//        func(page *configservice.GetOrganizationConfigRuleDetailedStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetOrganizationConfigRuleDetailedStatusPages(input *GetOrganizationConfigRuleDetailedStatusInput, fn func(*GetOrganizationConfigRuleDetailedStatusOutput, bool) bool) error {
	return c.GetOrganizationConfigRuleDetailedStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetOrganizationConfigRuleDetailedStatusPagesWithContext same as GetOrganizationConfigRuleDetailedStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetOrganizationConfigRuleDetailedStatusPagesWithContext(ctx aws.Context, input *GetOrganizationConfigRuleDetailedStatusInput, fn func(*GetOrganizationConfigRuleDetailedStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetOrganizationConfigRuleDetailedStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetOrganizationConfigRuleDetailedStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetOrganizationConfigRuleDetailedStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetOrganizationConformancePackDetailedStatus = "GetOrganizationConformancePackDetailedStatus"

// GetOrganizationConformancePackDetailedStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetOrganizationConformancePackDetailedStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOrganizationConformancePackDetailedStatus for more information on using the GetOrganizationConformancePackDetailedStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOrganizationConformancePackDetailedStatusRequest method.
//    req, resp := client.GetOrganizationConformancePackDetailedStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus
func (c *ConfigService) GetOrganizationConformancePackDetailedStatusRequest(input *GetOrganizationConformancePackDetailedStatusInput) (req *request.Request, output *GetOrganizationConformancePackDetailedStatusOutput) {
	op := &request.Operation{
		Name:       opGetOrganizationConformancePackDetailedStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetOrganizationConformancePackDetailedStatusInput{}
	}

	output = &GetOrganizationConformancePackDetailedStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOrganizationConformancePackDetailedStatus API operation for AWS Config.
//
// Returns detailed status for each member account within an organization for
// a given organization conformance pack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetOrganizationConformancePackDetailedStatus for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConformancePackException
//   Config organization conformance pack that you passed in the filter does not
//   exist.
//
//   For DeleteOrganizationConformancePack, you tried to delete an organization
//   conformance pack that does not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus
func (c *ConfigService) GetOrganizationConformancePackDetailedStatus(input *GetOrganizationConformancePackDetailedStatusInput) (*GetOrganizationConformancePackDetailedStatusOutput, error) {
	req, out := c.GetOrganizationConformancePackDetailedStatusRequest(input)
	return out, req.Send()
}

// GetOrganizationConformancePackDetailedStatusWithContext is the same as GetOrganizationConformancePackDetailedStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetOrganizationConformancePackDetailedStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetOrganizationConformancePackDetailedStatusWithContext(ctx aws.Context, input *GetOrganizationConformancePackDetailedStatusInput, opts ...request.Option) (*GetOrganizationConformancePackDetailedStatusOutput, error) {
	req, out := c.GetOrganizationConformancePackDetailedStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetOrganizationConformancePackDetailedStatusPages iterates over the pages of a GetOrganizationConformancePackDetailedStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetOrganizationConformancePackDetailedStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetOrganizationConformancePackDetailedStatus operation.
//    pageNum := 0
//    err := client.GetOrganizationConformancePackDetailedStatusPages(params,
//        func(page *configservice.GetOrganizationConformancePackDetailedStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetOrganizationConformancePackDetailedStatusPages(input *GetOrganizationConformancePackDetailedStatusInput, fn func(*GetOrganizationConformancePackDetailedStatusOutput, bool) bool) error {
	return c.GetOrganizationConformancePackDetailedStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetOrganizationConformancePackDetailedStatusPagesWithContext same as GetOrganizationConformancePackDetailedStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetOrganizationConformancePackDetailedStatusPagesWithContext(ctx aws.Context, input *GetOrganizationConformancePackDetailedStatusInput, fn func(*GetOrganizationConformancePackDetailedStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetOrganizationConformancePackDetailedStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetOrganizationConformancePackDetailedStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetOrganizationConformancePackDetailedStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetOrganizationCustomRulePolicy = "GetOrganizationCustomRulePolicy"

// GetOrganizationCustomRulePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetOrganizationCustomRulePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOrganizationCustomRulePolicy for more information on using the GetOrganizationCustomRulePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOrganizationCustomRulePolicyRequest method.
//    req, resp := client.GetOrganizationCustomRulePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationCustomRulePolicy
func (c *ConfigService) GetOrganizationCustomRulePolicyRequest(input *GetOrganizationCustomRulePolicyInput) (req *request.Request, output *GetOrganizationCustomRulePolicyOutput) {
	op := &request.Operation{
		Name:       opGetOrganizationCustomRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOrganizationCustomRulePolicyInput{}
	}

	output = &GetOrganizationCustomRulePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOrganizationCustomRulePolicy API operation for AWS Config.
//
// Returns the policy definition containing the logic for your organization
// Config Custom Policy rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetOrganizationCustomRulePolicy for usage and error information.
//
// Returned Error Types:
//   * NoSuchOrganizationConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an organization
//   Config Custom Policy rule, that the rule name is correct, and that valid
//   Amazon Resouce Names (ARNs) are used before trying again.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationCustomRulePolicy
func (c *ConfigService) GetOrganizationCustomRulePolicy(input *GetOrganizationCustomRulePolicyInput) (*GetOrganizationCustomRulePolicyOutput, error) {
	req, out := c.GetOrganizationCustomRulePolicyRequest(input)
	return out, req.Send()
}

// GetOrganizationCustomRulePolicyWithContext is the same as GetOrganizationCustomRulePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetOrganizationCustomRulePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetOrganizationCustomRulePolicyWithContext(ctx aws.Context, input *GetOrganizationCustomRulePolicyInput, opts ...request.Option) (*GetOrganizationCustomRulePolicyOutput, error) {
	req, out := c.GetOrganizationCustomRulePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceConfigHistory = "GetResourceConfigHistory"

// GetResourceConfigHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceConfigHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceConfigHistory for more information on using the GetResourceConfigHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceConfigHistoryRequest method.
//    req, resp := client.GetResourceConfigHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory
func (c *ConfigService) GetResourceConfigHistoryRequest(input *GetResourceConfigHistoryInput) (req *request.Request, output *GetResourceConfigHistoryOutput) {
	op := &request.Operation{
		Name:       opGetResourceConfigHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceConfigHistoryInput{}
	}

	output = &GetResourceConfigHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceConfigHistory API operation for AWS Config.
//
// Returns a list of ConfigurationItems for the specified resource. The list
// contains details about each state of the resource during the specified time
// interval. If you specified a retention period to retain your ConfigurationItems
// between a minimum of 30 days and a maximum of 7 years (2557 days), Config
// returns the ConfigurationItems for the specified retention period.
//
// The response is paginated. By default, Config returns a limit of 10 configuration
// items per page. You can customize this number with the limit parameter. The
// response includes a nextToken string. To get the next page of results, run
// the request again and specify the string for the nextToken parameter.
//
// Each call to the API is limited to span a duration of seven days. It is likely
// that the number of records returned is smaller than the specified limit.
// In such cases, you can make another call, using the nextToken.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetResourceConfigHistory for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidTimeRangeException
//   The specified time range is not valid. The earlier time is not chronologically
//   before the later time.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * ResourceNotDiscoveredException
//   You have specified a resource that is either unknown or has not been discovered.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory
func (c *ConfigService) GetResourceConfigHistory(input *GetResourceConfigHistoryInput) (*GetResourceConfigHistoryOutput, error) {
	req, out := c.GetResourceConfigHistoryRequest(input)
	return out, req.Send()
}

// GetResourceConfigHistoryWithContext is the same as GetResourceConfigHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceConfigHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetResourceConfigHistoryWithContext(ctx aws.Context, input *GetResourceConfigHistoryInput, opts ...request.Option) (*GetResourceConfigHistoryOutput, error) {
	req, out := c.GetResourceConfigHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceConfigHistoryPages iterates over the pages of a GetResourceConfigHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceConfigHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourceConfigHistory operation.
//    pageNum := 0
//    err := client.GetResourceConfigHistoryPages(params,
//        func(page *configservice.GetResourceConfigHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetResourceConfigHistoryPages(input *GetResourceConfigHistoryInput, fn func(*GetResourceConfigHistoryOutput, bool) bool) error {
	return c.GetResourceConfigHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceConfigHistoryPagesWithContext same as GetResourceConfigHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetResourceConfigHistoryPagesWithContext(ctx aws.Context, input *GetResourceConfigHistoryInput, fn func(*GetResourceConfigHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceConfigHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceConfigHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceConfigHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetStoredQuery = "GetStoredQuery"

// GetStoredQueryRequest generates a "aws/request.Request" representing the
// client's request for the GetStoredQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStoredQuery for more information on using the GetStoredQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStoredQueryRequest method.
//    req, resp := client.GetStoredQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery
func (c *ConfigService) GetStoredQueryRequest(input *GetStoredQueryInput) (req *request.Request, output *GetStoredQueryOutput) {
	op := &request.Operation{
		Name:       opGetStoredQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStoredQueryInput{}
	}

	output = &GetStoredQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStoredQuery API operation for AWS Config.
//
// Returns the details of a specific stored query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetStoredQuery for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery
func (c *ConfigService) GetStoredQuery(input *GetStoredQueryInput) (*GetStoredQueryOutput, error) {
	req, out := c.GetStoredQueryRequest(input)
	return out, req.Send()
}

// GetStoredQueryWithContext is the same as GetStoredQuery with the addition of
// the ability to pass a context and additional request options.
//
// See GetStoredQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetStoredQueryWithContext(ctx aws.Context, input *GetStoredQueryInput, opts ...request.Option) (*GetStoredQueryOutput, error) {
	req, out := c.GetStoredQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAggregateDiscoveredResources = "ListAggregateDiscoveredResources"

// ListAggregateDiscoveredResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListAggregateDiscoveredResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAggregateDiscoveredResources for more information on using the ListAggregateDiscoveredResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAggregateDiscoveredResourcesRequest method.
//    req, resp := client.ListAggregateDiscoveredResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources
func (c *ConfigService) ListAggregateDiscoveredResourcesRequest(input *ListAggregateDiscoveredResourcesInput) (req *request.Request, output *ListAggregateDiscoveredResourcesOutput) {
	op := &request.Operation{
		Name:       opListAggregateDiscoveredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAggregateDiscoveredResourcesInput{}
	}

	output = &ListAggregateDiscoveredResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAggregateDiscoveredResources API operation for AWS Config.
//
// Accepts a resource type and returns a list of resource identifiers that are
// aggregated for a specific resource type across accounts and regions. A resource
// identifier includes the resource type, ID, (if available) the custom resource
// name, source account, and source region. You can narrow the results to include
// only resources that have specific resource IDs, or a resource name, or source
// account ID, or source region.
//
// For example, if the input consists of accountID 12345678910 and the region
// is us-east-1 for resource type AWS::EC2::Instance then the API returns all
// the EC2 instance identifiers of accountID 12345678910 and region us-east-1.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListAggregateDiscoveredResources for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources
func (c *ConfigService) ListAggregateDiscoveredResources(input *ListAggregateDiscoveredResourcesInput) (*ListAggregateDiscoveredResourcesOutput, error) {
	req, out := c.ListAggregateDiscoveredResourcesRequest(input)
	return out, req.Send()
}

// ListAggregateDiscoveredResourcesWithContext is the same as ListAggregateDiscoveredResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListAggregateDiscoveredResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListAggregateDiscoveredResourcesWithContext(ctx aws.Context, input *ListAggregateDiscoveredResourcesInput, opts ...request.Option) (*ListAggregateDiscoveredResourcesOutput, error) {
	req, out := c.ListAggregateDiscoveredResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAggregateDiscoveredResourcesPages iterates over the pages of a ListAggregateDiscoveredResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAggregateDiscoveredResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAggregateDiscoveredResources operation.
//    pageNum := 0
//    err := client.ListAggregateDiscoveredResourcesPages(params,
//        func(page *configservice.ListAggregateDiscoveredResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) ListAggregateDiscoveredResourcesPages(input *ListAggregateDiscoveredResourcesInput, fn func(*ListAggregateDiscoveredResourcesOutput, bool) bool) error {
	return c.ListAggregateDiscoveredResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAggregateDiscoveredResourcesPagesWithContext same as ListAggregateDiscoveredResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListAggregateDiscoveredResourcesPagesWithContext(ctx aws.Context, input *ListAggregateDiscoveredResourcesInput, fn func(*ListAggregateDiscoveredResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAggregateDiscoveredResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAggregateDiscoveredResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAggregateDiscoveredResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDiscoveredResources = "ListDiscoveredResources"

// ListDiscoveredResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDiscoveredResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDiscoveredResources for more information on using the ListDiscoveredResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDiscoveredResourcesRequest method.
//    req, resp := client.ListDiscoveredResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources
func (c *ConfigService) ListDiscoveredResourcesRequest(input *ListDiscoveredResourcesInput) (req *request.Request, output *ListDiscoveredResourcesOutput) {
	op := &request.Operation{
		Name:       opListDiscoveredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDiscoveredResourcesInput{}
	}

	output = &ListDiscoveredResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDiscoveredResources API operation for AWS Config.
//
// Accepts a resource type and returns a list of resource identifiers for the
// resources of that type. A resource identifier includes the resource type,
// ID, and (if available) the custom resource name. The results consist of resources
// that Config has discovered, including those that Config is not currently
// recording. You can narrow the results to include only resources that have
// specific resource IDs or a resource name.
//
// You can specify either resource IDs or a resource name, but not both, in
// the same request.
//
// The response is paginated. By default, Config lists 100 resource identifiers
// on each page. You can customize this number with the limit parameter. The
// response includes a nextToken string. To get the next page of results, run
// the request again and specify the string for the nextToken parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListDiscoveredResources for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources
func (c *ConfigService) ListDiscoveredResources(input *ListDiscoveredResourcesInput) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	return out, req.Send()
}

// ListDiscoveredResourcesWithContext is the same as ListDiscoveredResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDiscoveredResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListDiscoveredResourcesWithContext(ctx aws.Context, input *ListDiscoveredResourcesInput, opts ...request.Option) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDiscoveredResourcesPages iterates over the pages of a ListDiscoveredResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDiscoveredResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDiscoveredResources operation.
//    pageNum := 0
//    err := client.ListDiscoveredResourcesPages(params,
//        func(page *configservice.ListDiscoveredResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) ListDiscoveredResourcesPages(input *ListDiscoveredResourcesInput, fn func(*ListDiscoveredResourcesOutput, bool) bool) error {
	return c.ListDiscoveredResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDiscoveredResourcesPagesWithContext same as ListDiscoveredResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListDiscoveredResourcesPagesWithContext(ctx aws.Context, input *ListDiscoveredResourcesInput, fn func(*ListDiscoveredResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDiscoveredResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDiscoveredResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDiscoveredResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStoredQueries = "ListStoredQueries"

// ListStoredQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListStoredQueries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStoredQueries for more information on using the ListStoredQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStoredQueriesRequest method.
//    req, resp := client.ListStoredQueriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries
func (c *ConfigService) ListStoredQueriesRequest(input *ListStoredQueriesInput) (req *request.Request, output *ListStoredQueriesOutput) {
	op := &request.Operation{
		Name:       opListStoredQueries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStoredQueriesInput{}
	}

	output = &ListStoredQueriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStoredQueries API operation for AWS Config.
//
// Lists the stored queries for a single Amazon Web Services account and a single
// Amazon Web Services Region. The default is 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListStoredQueries for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries
func (c *ConfigService) ListStoredQueries(input *ListStoredQueriesInput) (*ListStoredQueriesOutput, error) {
	req, out := c.ListStoredQueriesRequest(input)
	return out, req.Send()
}

// ListStoredQueriesWithContext is the same as ListStoredQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListStoredQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListStoredQueriesWithContext(ctx aws.Context, input *ListStoredQueriesInput, opts ...request.Option) (*ListStoredQueriesOutput, error) {
	req, out := c.ListStoredQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStoredQueriesPages iterates over the pages of a ListStoredQueries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStoredQueries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStoredQueries operation.
//    pageNum := 0
//    err := client.ListStoredQueriesPages(params,
//        func(page *configservice.ListStoredQueriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) ListStoredQueriesPages(input *ListStoredQueriesInput, fn func(*ListStoredQueriesOutput, bool) bool) error {
	return c.ListStoredQueriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStoredQueriesPagesWithContext same as ListStoredQueriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListStoredQueriesPagesWithContext(ctx aws.Context, input *ListStoredQueriesInput, fn func(*ListStoredQueriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStoredQueriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStoredQueriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStoredQueriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource
func (c *ConfigService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Config.
//
// List the tags for Config resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource
func (c *ConfigService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *configservice.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAggregationAuthorization = "PutAggregationAuthorization"

// PutAggregationAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the PutAggregationAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAggregationAuthorization for more information on using the PutAggregationAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAggregationAuthorizationRequest method.
//    req, resp := client.PutAggregationAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization
func (c *ConfigService) PutAggregationAuthorizationRequest(input *PutAggregationAuthorizationInput) (req *request.Request, output *PutAggregationAuthorizationOutput) {
	op := &request.Operation{
		Name:       opPutAggregationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAggregationAuthorizationInput{}
	}

	output = &PutAggregationAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAggregationAuthorization API operation for AWS Config.
//
// Authorizes the aggregator account and region to collect data from the source
// account and region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutAggregationAuthorization for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization
func (c *ConfigService) PutAggregationAuthorization(input *PutAggregationAuthorizationInput) (*PutAggregationAuthorizationOutput, error) {
	req, out := c.PutAggregationAuthorizationRequest(input)
	return out, req.Send()
}

// PutAggregationAuthorizationWithContext is the same as PutAggregationAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See PutAggregationAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutAggregationAuthorizationWithContext(ctx aws.Context, input *PutAggregationAuthorizationInput, opts ...request.Option) (*PutAggregationAuthorizationOutput, error) {
	req, out := c.PutAggregationAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigRule = "PutConfigRule"

// PutConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigRule for more information on using the PutConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigRuleRequest method.
//    req, resp := client.PutConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule
func (c *ConfigService) PutConfigRuleRequest(input *PutConfigRuleInput) (req *request.Request, output *PutConfigRuleOutput) {
	op := &request.Operation{
		Name:       opPutConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigRuleInput{}
	}

	output = &PutConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigRule API operation for AWS Config.
//
// Adds or updates an Config rule for evaluating whether your Amazon Web Services
// resources comply with your desired configurations.
//
// You can use this action for Config custom rules and Config managed rules.
// A Config custom rule is a rule that you develop and maintain. An Config managed
// rule is a customizable, predefined rule that Config provides.
//
// If you are adding a new Config custom rule, you must first create the Lambda
// function that the rule invokes to evaluate your resources. When you use the
// PutConfigRule action to add the rule to Config, you must specify the Amazon
// Resource Name (ARN) that Lambda assigns to the function. Specify the ARN
// for the SourceIdentifier key. This key is part of the Source object, which
// is part of the ConfigRule object.
//
// If you are adding an Config managed rule, specify the rule's identifier for
// the SourceIdentifier key. To reference Config managed rule identifiers, see
// About Config managed rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
//
// For any new rule that you add, specify the ConfigRuleName in the ConfigRule
// object. Do not specify the ConfigRuleArn or the ConfigRuleId. These values
// are generated by Config for new rules.
//
// If you are updating a rule that you added previously, you can specify the
// rule by ConfigRuleName, ConfigRuleId, or ConfigRuleArn in the ConfigRule
// data type that you use in this request.
//
// The maximum number of rules that Config supports is 150.
//
// For information about requesting a rule limit increase, see Config Limits
// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
// in the Amazon Web Services General Reference Guide.
//
// For more information about developing and using Config rules, see Evaluating
// Amazon Web Services resource Configurations with Config (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the Config Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigRule for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * MaxNumberOfConfigRulesExceededException
//   Failed to add the Config rule because the account already contains the maximum
//   number of 150 rules. Consider deleting any deactivated rules before you add
//   new rules.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule
func (c *ConfigService) PutConfigRule(input *PutConfigRuleInput) (*PutConfigRuleOutput, error) {
	req, out := c.PutConfigRuleRequest(input)
	return out, req.Send()
}

// PutConfigRuleWithContext is the same as PutConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigRuleWithContext(ctx aws.Context, input *PutConfigRuleInput, opts ...request.Option) (*PutConfigRuleOutput, error) {
	req, out := c.PutConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationAggregator = "PutConfigurationAggregator"

// PutConfigurationAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationAggregator for more information on using the PutConfigurationAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationAggregatorRequest method.
//    req, resp := client.PutConfigurationAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator
func (c *ConfigService) PutConfigurationAggregatorRequest(input *PutConfigurationAggregatorInput) (req *request.Request, output *PutConfigurationAggregatorOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationAggregator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigurationAggregatorInput{}
	}

	output = &PutConfigurationAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutConfigurationAggregator API operation for AWS Config.
//
// Creates and updates the configuration aggregator with the selected source
// accounts and regions. The source account can be individual account(s) or
// an organization.
//
// accountIds that are passed will be replaced with existing accounts. If you
// want to add additional accounts into the aggregator, call DescribeConfigurationAggregators
// to get the previous accounts and then append new ones.
//
// Config should be enabled in source accounts and regions you want to aggregate.
//
// If your source type is an organization, you must be signed in to the management
// account or a registered delegated administrator and all the features must
// be enabled in your organization. If the caller is a management account, Config
// calls EnableAwsServiceAccess API to enable integration between Config and
// Organizations. If the caller is a registered delegated administrator, Config
// calls ListDelegatedAdministrators API to verify whether the caller is a valid
// delegated administrator.
//
// To register a delegated administrator, see Register a Delegated Administrator
// (https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli)
// in the Config developer guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigurationAggregator for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * LimitExceededException
//   For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
//   is in progress or if you call the StartConfigRulesEvaluation API more than
//   once per minute.
//
//   For PutConfigurationAggregator API, this exception is thrown if the number
//   of accounts and aggregators exceeds the limit.
//
//   * InvalidRoleException
//   You have provided a null or empty role ARN.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
//   * NoAvailableOrganizationException
//   Organization is no longer available.
//
//   * OrganizationAllFeaturesNotEnabledException
//   Config resource cannot be created because your organization does not have
//   all features enabled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator
func (c *ConfigService) PutConfigurationAggregator(input *PutConfigurationAggregatorInput) (*PutConfigurationAggregatorOutput, error) {
	req, out := c.PutConfigurationAggregatorRequest(input)
	return out, req.Send()
}

// PutConfigurationAggregatorWithContext is the same as PutConfigurationAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigurationAggregatorWithContext(ctx aws.Context, input *PutConfigurationAggregatorInput, opts ...request.Option) (*PutConfigurationAggregatorOutput, error) {
	req, out := c.PutConfigurationAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationRecorder = "PutConfigurationRecorder"

// PutConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationRecorder for more information on using the PutConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationRecorderRequest method.
//    req, resp := client.PutConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder
func (c *ConfigService) PutConfigurationRecorderRequest(input *PutConfigurationRecorderInput) (req *request.Request, output *PutConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigurationRecorderInput{}
	}

	output = &PutConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationRecorder API operation for AWS Config.
//
// Creates a new configuration recorder to record the selected resource configurations.
//
// You can use this action to change the role roleARN or the recordingGroup
// of an existing recorder. To change the role, call the action on the existing
// configuration recorder and specify a role.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// If ConfigurationRecorder does not have the recordingGroup parameter specified,
// the default is to record all supported resource types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigurationRecorder for usage and error information.
//
// Returned Error Types:
//   * MaxNumberOfConfigurationRecordersExceededException
//   You have reached the limit of the number of recorders you can create.
//
//   * InvalidConfigurationRecorderNameException
//   You have provided a configuration recorder name that is not valid.
//
//   * InvalidRoleException
//   You have provided a null or empty role ARN.
//
//   * InvalidRecordingGroupException
//   Config throws an exception if the recording group does not contain a valid
//   list of resource types. Invalid values might also be incorrectly formatted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder
func (c *ConfigService) PutConfigurationRecorder(input *PutConfigurationRecorderInput) (*PutConfigurationRecorderOutput, error) {
	req, out := c.PutConfigurationRecorderRequest(input)
	return out, req.Send()
}

// PutConfigurationRecorderWithContext is the same as PutConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigurationRecorderWithContext(ctx aws.Context, input *PutConfigurationRecorderInput, opts ...request.Option) (*PutConfigurationRecorderOutput, error) {
	req, out := c.PutConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConformancePack = "PutConformancePack"

// PutConformancePackRequest generates a "aws/request.Request" representing the
// client's request for the PutConformancePack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConformancePack for more information on using the PutConformancePack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConformancePackRequest method.
//    req, resp := client.PutConformancePackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack
func (c *ConfigService) PutConformancePackRequest(input *PutConformancePackInput) (req *request.Request, output *PutConformancePackOutput) {
	op := &request.Operation{
		Name:       opPutConformancePack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConformancePackInput{}
	}

	output = &PutConformancePackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutConformancePack API operation for AWS Config.
//
// Creates or updates a conformance pack. A conformance pack is a collection
// of Config rules that can be easily deployed in an account and a region and
// across Amazon Web Services Organization.
//
// This API creates a service linked role AWSServiceRoleForConfigConforms in
// your account. The service linked role is created only when the role does
// not exist in your account.
//
// You must specify either the TemplateS3Uri or the TemplateBody parameter,
// but not both. If you provide both Config uses the TemplateS3Uri parameter
// and ignores the TemplateBody parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConformancePack for usage and error information.
//
// Returned Error Types:
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * ConformancePackTemplateValidationException
//   You have specified a template that is not valid or supported.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * MaxNumberOfConformancePacksExceededException
//   You have reached the limit (6) of the number of conformance packs in an account
//   (6 conformance pack with 25 Config rules per pack).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack
func (c *ConfigService) PutConformancePack(input *PutConformancePackInput) (*PutConformancePackOutput, error) {
	req, out := c.PutConformancePackRequest(input)
	return out, req.Send()
}

// PutConformancePackWithContext is the same as PutConformancePack with the addition of
// the ability to pass a context and additional request options.
//
// See PutConformancePack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConformancePackWithContext(ctx aws.Context, input *PutConformancePackInput, opts ...request.Option) (*PutConformancePackOutput, error) {
	req, out := c.PutConformancePackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDeliveryChannel = "PutDeliveryChannel"

// PutDeliveryChannelRequest generates a "aws/request.Request" representing the
// client's request for the PutDeliveryChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDeliveryChannel for more information on using the PutDeliveryChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDeliveryChannelRequest method.
//    req, resp := client.PutDeliveryChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel
func (c *ConfigService) PutDeliveryChannelRequest(input *PutDeliveryChannelInput) (req *request.Request, output *PutDeliveryChannelOutput) {
	op := &request.Operation{
		Name:       opPutDeliveryChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDeliveryChannelInput{}
	}

	output = &PutDeliveryChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDeliveryChannel API operation for AWS Config.
//
// Creates a delivery channel object to deliver configuration information to
// an Amazon S3 bucket and Amazon SNS topic.
//
// Before you can create a delivery channel, you must create a configuration
// recorder.
//
// You can use this action to change the Amazon S3 bucket or an Amazon SNS topic
// of the existing delivery channel. To change the Amazon S3 bucket or an Amazon
// SNS topic, call this action and specify the changed values for the S3 bucket
// and the SNS topic. If you specify a different value for either the S3 bucket
// or the SNS topic, this action will keep the existing value for the parameter
// that is not changed.
//
// You can have only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutDeliveryChannel for usage and error information.
//
// Returned Error Types:
//   * MaxNumberOfDeliveryChannelsExceededException
//   You have reached the limit of the number of delivery channels you can create.
//
//   * NoAvailableConfigurationRecorderException
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * InvalidDeliveryChannelNameException
//   The specified delivery channel name is not valid.
//
//   * NoSuchBucketException
//   The specified Amazon S3 bucket does not exist.
//
//   * InvalidS3KeyPrefixException
//   The specified Amazon S3 key prefix is not valid.
//
//   * InvalidS3KmsKeyArnException
//   The specified Amazon KMS Key ARN is not valid.
//
//   * InvalidSNSTopicARNException
//   The specified Amazon SNS topic does not exist.
//
//   * InsufficientDeliveryPolicyException
//   Your Amazon S3 bucket policy does not permit Config to write to it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel
func (c *ConfigService) PutDeliveryChannel(input *PutDeliveryChannelInput) (*PutDeliveryChannelOutput, error) {
	req, out := c.PutDeliveryChannelRequest(input)
	return out, req.Send()
}

// PutDeliveryChannelWithContext is the same as PutDeliveryChannel with the addition of
// the ability to pass a context and additional request options.
//
// See PutDeliveryChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutDeliveryChannelWithContext(ctx aws.Context, input *PutDeliveryChannelInput, opts ...request.Option) (*PutDeliveryChannelOutput, error) {
	req, out := c.PutDeliveryChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEvaluations = "PutEvaluations"

// PutEvaluationsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvaluations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEvaluations for more information on using the PutEvaluations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEvaluationsRequest method.
//    req, resp := client.PutEvaluationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations
func (c *ConfigService) PutEvaluationsRequest(input *PutEvaluationsInput) (req *request.Request, output *PutEvaluationsOutput) {
	op := &request.Operation{
		Name:       opPutEvaluations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEvaluationsInput{}
	}

	output = &PutEvaluationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvaluations API operation for AWS Config.
//
// Used by an Lambda function to deliver evaluation results to Config. This
// action is required in every Lambda function that is invoked by an Config
// rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutEvaluations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InvalidResultTokenException
//   The specified ResultToken is invalid.
//
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations
func (c *ConfigService) PutEvaluations(input *PutEvaluationsInput) (*PutEvaluationsOutput, error) {
	req, out := c.PutEvaluationsRequest(input)
	return out, req.Send()
}

// PutEvaluationsWithContext is the same as PutEvaluations with the addition of
// the ability to pass a context and additional request options.
//
// See PutEvaluations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutEvaluationsWithContext(ctx aws.Context, input *PutEvaluationsInput, opts ...request.Option) (*PutEvaluationsOutput, error) {
	req, out := c.PutEvaluationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutExternalEvaluation = "PutExternalEvaluation"

// PutExternalEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the PutExternalEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutExternalEvaluation for more information on using the PutExternalEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutExternalEvaluationRequest method.
//    req, resp := client.PutExternalEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutExternalEvaluation
func (c *ConfigService) PutExternalEvaluationRequest(input *PutExternalEvaluationInput) (req *request.Request, output *PutExternalEvaluationOutput) {
	op := &request.Operation{
		Name:       opPutExternalEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutExternalEvaluationInput{}
	}

	output = &PutExternalEvaluationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutExternalEvaluation API operation for AWS Config.
//
// Add or updates the evaluations for process checks. This API checks if the
// rule is a process check when the name of the Config rule is provided.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutExternalEvaluation for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutExternalEvaluation
func (c *ConfigService) PutExternalEvaluation(input *PutExternalEvaluationInput) (*PutExternalEvaluationOutput, error) {
	req, out := c.PutExternalEvaluationRequest(input)
	return out, req.Send()
}

// PutExternalEvaluationWithContext is the same as PutExternalEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See PutExternalEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutExternalEvaluationWithContext(ctx aws.Context, input *PutExternalEvaluationInput, opts ...request.Option) (*PutExternalEvaluationOutput, error) {
	req, out := c.PutExternalEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOrganizationConfigRule = "PutOrganizationConfigRule"

// PutOrganizationConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutOrganizationConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOrganizationConfigRule for more information on using the PutOrganizationConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutOrganizationConfigRuleRequest method.
//    req, resp := client.PutOrganizationConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule
func (c *ConfigService) PutOrganizationConfigRuleRequest(input *PutOrganizationConfigRuleInput) (req *request.Request, output *PutOrganizationConfigRuleOutput) {
	op := &request.Operation{
		Name:       opPutOrganizationConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOrganizationConfigRuleInput{}
	}

	output = &PutOrganizationConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutOrganizationConfigRule API operation for AWS Config.
//
// Adds or updates organization Config rule for your entire organization evaluating
// whether your Amazon Web Services resources comply with your desired configurations.
//
// Only a master account and a delegated administrator can create or update
// an organization Config rule. When calling this API with a delegated administrator,
// you must ensure Organizations ListDelegatedAdministrator permissions are
// added.
//
// This API enables organization service access through the EnableAWSServiceAccess
// action and creates a service linked role AWSServiceRoleForConfigMultiAccountSetup
// in the master or delegated administrator account of your organization. The
// service linked role is created only when the role does not exist in the caller
// account. Config verifies the existence of role with GetRole action.
//
// To use this API with delegated administrator, register a delegated administrator
// by calling Amazon Web Services Organization register-delegated-administrator
// for config-multiaccountsetup.amazonaws.com.
//
// You can use this action to create both Config custom rules and Config managed
// rules. If you are adding a new Config custom rule, you must first create
// Lambda function in the master account or a delegated administrator that the
// rule invokes to evaluate your resources. You also need to create an IAM role
// in the managed-account that can be assumed by the Lambda function. When you
// use the PutOrganizationConfigRule action to add the rule to Config, you must
// specify the Amazon Resource Name (ARN) that Lambda assigns to the function.
// If you are adding an Config managed rule, specify the rule's identifier for
// the RuleIdentifier key.
//
// The maximum number of organization Config rules that Config supports is 150
// and 3 delegated administrator per organization.
//
// Prerequisite: Ensure you call EnableAllFeatures API to enable all features
// in an organization.
//
// Specify either OrganizationCustomRuleMetadata or OrganizationManagedRuleMetadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutOrganizationConfigRule for usage and error information.
//
// Returned Error Types:
//   * MaxNumberOfOrganizationConfigRulesExceededException
//   You have reached the limit of the number of organization Config rules you
//   can create.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
//   * NoAvailableOrganizationException
//   Organization is no longer available.
//
//   * OrganizationAllFeaturesNotEnabledException
//   Config resource cannot be created because your organization does not have
//   all features enabled.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule
func (c *ConfigService) PutOrganizationConfigRule(input *PutOrganizationConfigRuleInput) (*PutOrganizationConfigRuleOutput, error) {
	req, out := c.PutOrganizationConfigRuleRequest(input)
	return out, req.Send()
}

// PutOrganizationConfigRuleWithContext is the same as PutOrganizationConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutOrganizationConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutOrganizationConfigRuleWithContext(ctx aws.Context, input *PutOrganizationConfigRuleInput, opts ...request.Option) (*PutOrganizationConfigRuleOutput, error) {
	req, out := c.PutOrganizationConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOrganizationConformancePack = "PutOrganizationConformancePack"

// PutOrganizationConformancePackRequest generates a "aws/request.Request" representing the
// client's request for the PutOrganizationConformancePack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOrganizationConformancePack for more information on using the PutOrganizationConformancePack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutOrganizationConformancePackRequest method.
//    req, resp := client.PutOrganizationConformancePackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConformancePack
func (c *ConfigService) PutOrganizationConformancePackRequest(input *PutOrganizationConformancePackInput) (req *request.Request, output *PutOrganizationConformancePackOutput) {
	op := &request.Operation{
		Name:       opPutOrganizationConformancePack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOrganizationConformancePackInput{}
	}

	output = &PutOrganizationConformancePackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutOrganizationConformancePack API operation for AWS Config.
//
// Deploys conformance packs across member accounts in an Amazon Web Services
// Organization.
//
// Only a master account and a delegated administrator can call this API. When
// calling this API with a delegated administrator, you must ensure Organizations
// ListDelegatedAdministrator permissions are added.
//
// This API enables organization service access for config-multiaccountsetup.amazonaws.com
// through the EnableAWSServiceAccess action and creates a service linked role
// AWSServiceRoleForConfigMultiAccountSetup in the master or delegated administrator
// account of your organization. The service linked role is created only when
// the role does not exist in the caller account. To use this API with delegated
// administrator, register a delegated administrator by calling Amazon Web Services
// Organization register-delegate-admin for config-multiaccountsetup.amazonaws.com.
//
// Prerequisite: Ensure you call EnableAllFeatures API to enable all features
// in an organization.
//
// You must specify either the TemplateS3Uri or the TemplateBody parameter,
// but not both. If you provide both Config uses the TemplateS3Uri parameter
// and ignores the TemplateBody parameter.
//
// Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS
// until the conformance pack is created or updated. You cannot update a conformance
// pack while it is in this state.
//
// You can create 50 conformance packs with 25 Config rules in each pack and
// 3 delegated administrator per organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutOrganizationConformancePack for usage and error information.
//
// Returned Error Types:
//   * MaxNumberOfOrganizationConformancePacksExceededException
//   You have reached the limit (6) of the number of organization conformance
//   packs in an account (6 conformance pack with 25 Config rules per pack per
//   account).
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * OrganizationAccessDeniedException
//   For PutConfigurationAggregator API, you can see this exception for the following
//   reasons:
//
//      * No permission to call EnableAWSServiceAccess API
//
//      * The configuration aggregator cannot be updated because your Amazon Web
//      Services Organization management account or the delegated administrator
//      role changed. Delete this aggregator and create a new one with the current
//      Amazon Web Services Organization.
//
//      * The configuration aggregator is associated with a previous Amazon Web
//      Services Organization and Config cannot aggregate data with current Amazon
//      Web Services Organization. Delete this aggregator and create a new one
//      with the current Amazon Web Services Organization.
//
//      * You are not a registered delegated administrator for Config with permissions
//      to call ListDelegatedAdministrators API. Ensure that the management account
//      registers delagated administrator for Config service principle name before
//      the delegated administrator creates an aggregator.
//
//   For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
//   throws an exception if APIs are called from member accounts. All APIs must
//   be called from organization master account.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * OrganizationConformancePackTemplateValidationException
//   You have specified a template that is not valid or supported.
//
//   * OrganizationAllFeaturesNotEnabledException
//   Config resource cannot be created because your organization does not have
//   all features enabled.
//
//   * NoAvailableOrganizationException
//   Organization is no longer available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConformancePack
func (c *ConfigService) PutOrganizationConformancePack(input *PutOrganizationConformancePackInput) (*PutOrganizationConformancePackOutput, error) {
	req, out := c.PutOrganizationConformancePackRequest(input)
	return out, req.Send()
}

// PutOrganizationConformancePackWithContext is the same as PutOrganizationConformancePack with the addition of
// the ability to pass a context and additional request options.
//
// See PutOrganizationConformancePack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutOrganizationConformancePackWithContext(ctx aws.Context, input *PutOrganizationConformancePackInput, opts ...request.Option) (*PutOrganizationConformancePackOutput, error) {
	req, out := c.PutOrganizationConformancePackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRemediationConfigurations = "PutRemediationConfigurations"

// PutRemediationConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the PutRemediationConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRemediationConfigurations for more information on using the PutRemediationConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRemediationConfigurationsRequest method.
//    req, resp := client.PutRemediationConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations
func (c *ConfigService) PutRemediationConfigurationsRequest(input *PutRemediationConfigurationsInput) (req *request.Request, output *PutRemediationConfigurationsOutput) {
	op := &request.Operation{
		Name:       opPutRemediationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRemediationConfigurationsInput{}
	}

	output = &PutRemediationConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRemediationConfigurations API operation for AWS Config.
//
// Adds or updates the remediation configuration with a specific Config rule
// with the selected target or action. The API creates the RemediationConfiguration
// object for the Config rule. The Config rule must already exist for you to
// add a remediation configuration. The target (SSM document) must exist and
// have permissions to use the target.
//
// If you make backward incompatible changes to the SSM document, you must call
// this again to ensure the remediations can run.
//
// This API does not support adding remediation configurations for service-linked
// Config Rules such as Organization Config rules, the rules deployed by conformance
// packs, and rules deployed by Amazon Web Services Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutRemediationConfigurations for usage and error information.
//
// Returned Error Types:
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations
func (c *ConfigService) PutRemediationConfigurations(input *PutRemediationConfigurationsInput) (*PutRemediationConfigurationsOutput, error) {
	req, out := c.PutRemediationConfigurationsRequest(input)
	return out, req.Send()
}

// PutRemediationConfigurationsWithContext is the same as PutRemediationConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See PutRemediationConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutRemediationConfigurationsWithContext(ctx aws.Context, input *PutRemediationConfigurationsInput, opts ...request.Option) (*PutRemediationConfigurationsOutput, error) {
	req, out := c.PutRemediationConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRemediationExceptions = "PutRemediationExceptions"

// PutRemediationExceptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutRemediationExceptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRemediationExceptions for more information on using the PutRemediationExceptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRemediationExceptionsRequest method.
//    req, resp := client.PutRemediationExceptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationExceptions
func (c *ConfigService) PutRemediationExceptionsRequest(input *PutRemediationExceptionsInput) (req *request.Request, output *PutRemediationExceptionsOutput) {
	op := &request.Operation{
		Name:       opPutRemediationExceptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRemediationExceptionsInput{}
	}

	output = &PutRemediationExceptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRemediationExceptions API operation for AWS Config.
//
// A remediation exception is when a specific resource is no longer considered
// for auto-remediation. This API adds a new exception or updates an existing
// exception for a specific resource with a specific Config rule.
//
// Config generates a remediation exception when a problem occurs executing
// a remediation action to a specific resource. Remediation exceptions blocks
// auto-remediation until the exception is cleared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutRemediationExceptions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationExceptions
func (c *ConfigService) PutRemediationExceptions(input *PutRemediationExceptionsInput) (*PutRemediationExceptionsOutput, error) {
	req, out := c.PutRemediationExceptionsRequest(input)
	return out, req.Send()
}

// PutRemediationExceptionsWithContext is the same as PutRemediationExceptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutRemediationExceptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutRemediationExceptionsWithContext(ctx aws.Context, input *PutRemediationExceptionsInput, opts ...request.Option) (*PutRemediationExceptionsOutput, error) {
	req, out := c.PutRemediationExceptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourceConfig = "PutResourceConfig"

// PutResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the PutResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourceConfig for more information on using the PutResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResourceConfigRequest method.
//    req, resp := client.PutResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutResourceConfig
func (c *ConfigService) PutResourceConfigRequest(input *PutResourceConfigInput) (req *request.Request, output *PutResourceConfigOutput) {
	op := &request.Operation{
		Name:       opPutResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourceConfigInput{}
	}

	output = &PutResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutResourceConfig API operation for AWS Config.
//
// Records the configuration state for the resource provided in the request.
// The configuration state of a resource is represented in Config as Configuration
// Items. Once this API records the configuration item, you can retrieve the
// list of configuration items for the custom resource type using existing Config
// APIs.
//
// The custom resource type must be registered with CloudFormation. This API
// accepts the configuration item registered with CloudFormation.
//
// When you call this API, Config only stores configuration state of the resource
// provided in the request. This API does not change or remediate the configuration
// of the resource.
//
// Write-only schema properites are not recorded as part of the published configuration
// item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutResourceConfig for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * NoRunningConfigurationRecorderException
//   There is no configuration recorder running.
//
//   * MaxActiveResourcesExceededException
//   You have reached the limit (100,000) of active custom resource types in your
//   account. Delete unused resources using DeleteResourceConfig.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutResourceConfig
func (c *ConfigService) PutResourceConfig(input *PutResourceConfigInput) (*PutResourceConfigOutput, error) {
	req, out := c.PutResourceConfigRequest(input)
	return out, req.Send()
}

// PutResourceConfigWithContext is the same as PutResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutResourceConfigWithContext(ctx aws.Context, input *PutResourceConfigInput, opts ...request.Option) (*PutResourceConfigOutput, error) {
	req, out := c.PutResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRetentionConfiguration = "PutRetentionConfiguration"

// PutRetentionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutRetentionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRetentionConfiguration for more information on using the PutRetentionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRetentionConfigurationRequest method.
//    req, resp := client.PutRetentionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration
func (c *ConfigService) PutRetentionConfigurationRequest(input *PutRetentionConfigurationInput) (req *request.Request, output *PutRetentionConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutRetentionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRetentionConfigurationInput{}
	}

	output = &PutRetentionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRetentionConfiguration API operation for AWS Config.
//
// Creates and updates the retention configuration with details about retention
// period (number of days) that Config stores your historical information. The
// API creates the RetentionConfiguration object and names the object as default.
// When you have a RetentionConfiguration object named default, calling the
// API modifies the default object.
//
// Currently, Config supports only one retention configuration per region in
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutRetentionConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * MaxNumberOfRetentionConfigurationsExceededException
//   Failed to add the retention configuration because a retention configuration
//   with that name already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration
func (c *ConfigService) PutRetentionConfiguration(input *PutRetentionConfigurationInput) (*PutRetentionConfigurationOutput, error) {
	req, out := c.PutRetentionConfigurationRequest(input)
	return out, req.Send()
}

// PutRetentionConfigurationWithContext is the same as PutRetentionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutRetentionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutRetentionConfigurationWithContext(ctx aws.Context, input *PutRetentionConfigurationInput, opts ...request.Option) (*PutRetentionConfigurationOutput, error) {
	req, out := c.PutRetentionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutStoredQuery = "PutStoredQuery"

// PutStoredQueryRequest generates a "aws/request.Request" representing the
// client's request for the PutStoredQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutStoredQuery for more information on using the PutStoredQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutStoredQueryRequest method.
//    req, resp := client.PutStoredQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutStoredQuery
func (c *ConfigService) PutStoredQueryRequest(input *PutStoredQueryInput) (req *request.Request, output *PutStoredQueryOutput) {
	op := &request.Operation{
		Name:       opPutStoredQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutStoredQueryInput{}
	}

	output = &PutStoredQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutStoredQuery API operation for AWS Config.
//
// Saves a new query or updates an existing saved query. The QueryName must
// be unique for a single Amazon Web Services account and a single Amazon Web
// Services Region. You can create upto 300 queries in a single Amazon Web Services
// account and a single Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutStoredQuery for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * TooManyTagsException
//   You have reached the limit of the number of tags you can use. You have more
//   than 50 tags.
//
//   * ResourceConcurrentModificationException
//   Two users are trying to modify the same query at the same time. Wait for
//   a moment and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutStoredQuery
func (c *ConfigService) PutStoredQuery(input *PutStoredQueryInput) (*PutStoredQueryOutput, error) {
	req, out := c.PutStoredQueryRequest(input)
	return out, req.Send()
}

// PutStoredQueryWithContext is the same as PutStoredQuery with the addition of
// the ability to pass a context and additional request options.
//
// See PutStoredQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutStoredQueryWithContext(ctx aws.Context, input *PutStoredQueryInput, opts ...request.Option) (*PutStoredQueryOutput, error) {
	req, out := c.PutStoredQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSelectAggregateResourceConfig = "SelectAggregateResourceConfig"

// SelectAggregateResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the SelectAggregateResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SelectAggregateResourceConfig for more information on using the SelectAggregateResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SelectAggregateResourceConfigRequest method.
//    req, resp := client.SelectAggregateResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig
func (c *ConfigService) SelectAggregateResourceConfigRequest(input *SelectAggregateResourceConfigInput) (req *request.Request, output *SelectAggregateResourceConfigOutput) {
	op := &request.Operation{
		Name:       opSelectAggregateResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SelectAggregateResourceConfigInput{}
	}

	output = &SelectAggregateResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SelectAggregateResourceConfig API operation for AWS Config.
//
// Accepts a structured query language (SQL) SELECT command and an aggregator
// to query configuration state of Amazon Web Services resources across multiple
// accounts and regions, performs the corresponding search, and returns resource
// configurations matching the properties.
//
// For more information about query components, see the Query Components (https://docs.aws.amazon.com/config/latest/developerguide/query-components.html)
// section in the Config Developer Guide.
//
// If you run an aggregation query (i.e., using GROUP BY or using aggregate
// functions such as COUNT; e.g., SELECT resourceId, COUNT(*) WHERE resourceType
// = 'AWS::IAM::Role' GROUP BY resourceId) and do not specify the MaxResults
// or the Limit query parameters, the default page size is set to 500.
//
// If you run a non-aggregation query (i.e., not using GROUP BY or aggregate
// function; e.g., SELECT * WHERE resourceType = 'AWS::IAM::Role') and do not
// specify the MaxResults or the Limit query parameters, the default page size
// is set to 25.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation SelectAggregateResourceConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidExpressionException
//   The syntax of the query is incorrect.
//
//   * NoSuchConfigurationAggregatorException
//   You have specified a configuration aggregator that does not exist.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig
func (c *ConfigService) SelectAggregateResourceConfig(input *SelectAggregateResourceConfigInput) (*SelectAggregateResourceConfigOutput, error) {
	req, out := c.SelectAggregateResourceConfigRequest(input)
	return out, req.Send()
}

// SelectAggregateResourceConfigWithContext is the same as SelectAggregateResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See SelectAggregateResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) SelectAggregateResourceConfigWithContext(ctx aws.Context, input *SelectAggregateResourceConfigInput, opts ...request.Option) (*SelectAggregateResourceConfigOutput, error) {
	req, out := c.SelectAggregateResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SelectAggregateResourceConfigPages iterates over the pages of a SelectAggregateResourceConfig operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SelectAggregateResourceConfig method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SelectAggregateResourceConfig operation.
//    pageNum := 0
//    err := client.SelectAggregateResourceConfigPages(params,
//        func(page *configservice.SelectAggregateResourceConfigOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) SelectAggregateResourceConfigPages(input *SelectAggregateResourceConfigInput, fn func(*SelectAggregateResourceConfigOutput, bool) bool) error {
	return c.SelectAggregateResourceConfigPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SelectAggregateResourceConfigPagesWithContext same as SelectAggregateResourceConfigPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) SelectAggregateResourceConfigPagesWithContext(ctx aws.Context, input *SelectAggregateResourceConfigInput, fn func(*SelectAggregateResourceConfigOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SelectAggregateResourceConfigInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SelectAggregateResourceConfigRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SelectAggregateResourceConfigOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSelectResourceConfig = "SelectResourceConfig"

// SelectResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the SelectResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SelectResourceConfig for more information on using the SelectResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SelectResourceConfigRequest method.
//    req, resp := client.SelectResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig
func (c *ConfigService) SelectResourceConfigRequest(input *SelectResourceConfigInput) (req *request.Request, output *SelectResourceConfigOutput) {
	op := &request.Operation{
		Name:       opSelectResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SelectResourceConfigInput{}
	}

	output = &SelectResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SelectResourceConfig API operation for AWS Config.
//
// Accepts a structured query language (SQL) SELECT command, performs the corresponding
// search, and returns resource configurations matching the properties.
//
// For more information about query components, see the Query Components (https://docs.aws.amazon.com/config/latest/developerguide/query-components.html)
// section in the Config Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation SelectResourceConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidExpressionException
//   The syntax of the query is incorrect.
//
//   * InvalidLimitException
//   The specified limit is outside the allowable range.
//
//   * InvalidNextTokenException
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig
func (c *ConfigService) SelectResourceConfig(input *SelectResourceConfigInput) (*SelectResourceConfigOutput, error) {
	req, out := c.SelectResourceConfigRequest(input)
	return out, req.Send()
}

// SelectResourceConfigWithContext is the same as SelectResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See SelectResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) SelectResourceConfigWithContext(ctx aws.Context, input *SelectResourceConfigInput, opts ...request.Option) (*SelectResourceConfigOutput, error) {
	req, out := c.SelectResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SelectResourceConfigPages iterates over the pages of a SelectResourceConfig operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SelectResourceConfig method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SelectResourceConfig operation.
//    pageNum := 0
//    err := client.SelectResourceConfigPages(params,
//        func(page *configservice.SelectResourceConfigOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) SelectResourceConfigPages(input *SelectResourceConfigInput, fn func(*SelectResourceConfigOutput, bool) bool) error {
	return c.SelectResourceConfigPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SelectResourceConfigPagesWithContext same as SelectResourceConfigPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) SelectResourceConfigPagesWithContext(ctx aws.Context, input *SelectResourceConfigInput, fn func(*SelectResourceConfigOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SelectResourceConfigInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SelectResourceConfigRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SelectResourceConfigOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartConfigRulesEvaluation = "StartConfigRulesEvaluation"

// StartConfigRulesEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the StartConfigRulesEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartConfigRulesEvaluation for more information on using the StartConfigRulesEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartConfigRulesEvaluationRequest method.
//    req, resp := client.StartConfigRulesEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation
func (c *ConfigService) StartConfigRulesEvaluationRequest(input *StartConfigRulesEvaluationInput) (req *request.Request, output *StartConfigRulesEvaluationOutput) {
	op := &request.Operation{
		Name:       opStartConfigRulesEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartConfigRulesEvaluationInput{}
	}

	output = &StartConfigRulesEvaluationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartConfigRulesEvaluation API operation for AWS Config.
//
// Runs an on-demand evaluation for the specified Config rules against the last
// known configuration state of the resources. Use StartConfigRulesEvaluation
// when you want to test that a rule you updated is working as expected. StartConfigRulesEvaluation
// does not re-record the latest configuration state for your resources. It
// re-runs an evaluation against the last known state of your resources.
//
// You can specify up to 25 Config rules per request.
//
// An existing StartConfigRulesEvaluation call for the specified rules must
// complete before you can call the API again. If you chose to have Config stream
// to an Amazon SNS topic, you will receive a ConfigRuleEvaluationStarted notification
// when the evaluation starts.
//
// You don't need to call the StartConfigRulesEvaluation API to run an evaluation
// for a new rule. When you create a rule, Config evaluates your resources against
// the rule automatically.
//
// The StartConfigRulesEvaluation API is useful if you want to run on-demand
// evaluations, such as the following example:
//
// You have a custom rule that evaluates your IAM resources every 24 hours.
//
// You update your Lambda function to add additional conditions to your rule.
//
// Instead of waiting for the next periodic evaluation, you call the StartConfigRulesEvaluation
// API.
//
// Config invokes your Lambda function and evaluates your IAM resources.
//
// Your custom rule will still run periodic evaluations every 24 hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StartConfigRulesEvaluation for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigRuleException
//   The Config rule in the request is not valid. Verify that the rule is an Config
//   Custom Policy rule, that the rule name is correct, and that valid Amazon
//   Resouce Names (ARNs) are used before trying again.
//
//   * LimitExceededException
//   For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
//   is in progress or if you call the StartConfigRulesEvaluation API more than
//   once per minute.
//
//   For PutConfigurationAggregator API, this exception is thrown if the number
//   of accounts and aggregators exceeds the limit.
//
//   * ResourceInUseException
//   You see this exception in the following cases:
//
//      * For DeleteConfigRule, Config is deleting this rule. Try your request
//      again later.
//
//      * For DeleteConfigRule, the rule is deleting your evaluation results.
//      Try your request again later.
//
//      * For DeleteConfigRule, a remediation action is associated with the rule
//      and Config cannot delete this rule. Delete the remediation action associated
//      with the rule before deleting the rule and try your request again later.
//
//      * For PutConfigOrganizationRule, organization Config rule deletion is
//      in progress. Try your request again later.
//
//      * For DeleteOrganizationConfigRule, organization Config rule creation
//      is in progress. Try your request again later.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack creation, update, and deletion is in progress. Try your request again
//      later.
//
//      * For DeleteConformancePack, a conformance pack creation, update, and
//      deletion is in progress. Try your request again later.
//
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation
func (c *ConfigService) StartConfigRulesEvaluation(input *StartConfigRulesEvaluationInput) (*StartConfigRulesEvaluationOutput, error) {
	req, out := c.StartConfigRulesEvaluationRequest(input)
	return out, req.Send()
}

// StartConfigRulesEvaluationWithContext is the same as StartConfigRulesEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See StartConfigRulesEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StartConfigRulesEvaluationWithContext(ctx aws.Context, input *StartConfigRulesEvaluationInput, opts ...request.Option) (*StartConfigRulesEvaluationOutput, error) {
	req, out := c.StartConfigRulesEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartConfigurationRecorder = "StartConfigurationRecorder"

// StartConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the StartConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartConfigurationRecorder for more information on using the StartConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartConfigurationRecorderRequest method.
//    req, resp := client.StartConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder
func (c *ConfigService) StartConfigurationRecorderRequest(input *StartConfigurationRecorderInput) (req *request.Request, output *StartConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opStartConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartConfigurationRecorderInput{}
	}

	output = &StartConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartConfigurationRecorder API operation for AWS Config.
//
// Starts recording configurations of the Amazon Web Services resources you
// have selected to record in your Amazon Web Services account.
//
// You must have created at least one delivery channel to successfully start
// the configuration recorder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StartConfigurationRecorder for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
//   * NoAvailableDeliveryChannelException
//   There is no delivery channel available to record configurations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder
func (c *ConfigService) StartConfigurationRecorder(input *StartConfigurationRecorderInput) (*StartConfigurationRecorderOutput, error) {
	req, out := c.StartConfigurationRecorderRequest(input)
	return out, req.Send()
}

// StartConfigurationRecorderWithContext is the same as StartConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See StartConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StartConfigurationRecorderWithContext(ctx aws.Context, input *StartConfigurationRecorderInput, opts ...request.Option) (*StartConfigurationRecorderOutput, error) {
	req, out := c.StartConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRemediationExecution = "StartRemediationExecution"

// StartRemediationExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartRemediationExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRemediationExecution for more information on using the StartRemediationExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartRemediationExecutionRequest method.
//    req, resp := client.StartRemediationExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartRemediationExecution
func (c *ConfigService) StartRemediationExecutionRequest(input *StartRemediationExecutionInput) (req *request.Request, output *StartRemediationExecutionOutput) {
	op := &request.Operation{
		Name:       opStartRemediationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartRemediationExecutionInput{}
	}

	output = &StartRemediationExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRemediationExecution API operation for AWS Config.
//
// Runs an on-demand remediation for the specified Config rules against the
// last known remediation configuration. It runs an execution against the current
// state of your resources. Remediation execution is asynchronous.
//
// You can specify up to 100 resource keys per request. An existing StartRemediationExecution
// call for the specified resource keys must complete before you can call the
// API again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StartRemediationExecution for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * InsufficientPermissionsException
//   Indicates one of the following errors:
//
//      * For PutConfigRule, the rule cannot be created because the IAM role assigned
//      to Config lacks permissions to perform the config:Put* action.
//
//      * For PutConfigRule, the Lambda function cannot be invoked. Check the
//      function ARN, and check the function's permissions.
//
//      * For PutOrganizationConfigRule, organization Config rule cannot be created
//      because you do not have permissions to call IAM GetRole action or create
//      a service linked role.
//
//      * For PutConformancePack and PutOrganizationConformancePack, a conformance
//      pack cannot be created because you do not have permissions: To call IAM
//      GetRole action or create a service linked role. To read Amazon S3 bucket.
//
//   * NoSuchRemediationConfigurationException
//   You specified an Config rule without a remediation configuration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartRemediationExecution
func (c *ConfigService) StartRemediationExecution(input *StartRemediationExecutionInput) (*StartRemediationExecutionOutput, error) {
	req, out := c.StartRemediationExecutionRequest(input)
	return out, req.Send()
}

// StartRemediationExecutionWithContext is the same as StartRemediationExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartRemediationExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StartRemediationExecutionWithContext(ctx aws.Context, input *StartRemediationExecutionInput, opts ...request.Option) (*StartRemediationExecutionOutput, error) {
	req, out := c.StartRemediationExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopConfigurationRecorder = "StopConfigurationRecorder"

// StopConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the StopConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopConfigurationRecorder for more information on using the StopConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopConfigurationRecorderRequest method.
//    req, resp := client.StopConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder
func (c *ConfigService) StopConfigurationRecorderRequest(input *StopConfigurationRecorderInput) (req *request.Request, output *StopConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opStopConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopConfigurationRecorderInput{}
	}

	output = &StopConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopConfigurationRecorder API operation for AWS Config.
//
// Stops recording configurations of the Amazon Web Services resources you have
// selected to record in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StopConfigurationRecorder for usage and error information.
//
// Returned Error Types:
//   * NoSuchConfigurationRecorderException
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder
func (c *ConfigService) StopConfigurationRecorder(input *StopConfigurationRecorderInput) (*StopConfigurationRecorderOutput, error) {
	req, out := c.StopConfigurationRecorderRequest(input)
	return out, req.Send()
}

// StopConfigurationRecorderWithContext is the same as StopConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See StopConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StopConfigurationRecorderWithContext(ctx aws.Context, input *StopConfigurationRecorderInput, opts ...request.Option) (*StopConfigurationRecorderOutput, error) {
	req, out := c.StopConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/TagResource
func (c *ConfigService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Config.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource are not specified in the request parameters,
// they are not changed. When a resource is deleted, the tags associated with
// that resource are deleted as well.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
//   * TooManyTagsException
//   You have reached the limit of the number of tags you can use. You have more
//   than 50 tags.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/TagResource
func (c *ConfigService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/UntagResource
func (c *ConfigService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Config.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The requested action is not valid.
//
//   For PutStoredQuery, you will see this exception if there are missing required
//   fields or if the input value fails the validation, or if you are trying to
//   create more than 300 queries.
//
//   For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this
//   exception if there are missing required fields or if the input value fails
//   the validation.
//
//   * ResourceNotFoundException
//   You have specified a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/UntagResource
func (c *ConfigService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A collection of accounts and regions.
type AccountAggregationSource struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account being aggregated.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// If true, aggregate existing Config regions and future regions.
	AllAwsRegions *bool `type:"boolean"`

	// The source regions being aggregated.
	AwsRegions []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAggregationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAggregationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountAggregationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountAggregationSource"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.AwsRegions != nil && len(s.AwsRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *AccountAggregationSource) SetAccountIds(v []*string) *AccountAggregationSource {
	s.AccountIds = v
	return s
}

// SetAllAwsRegions sets the AllAwsRegions field's value.
func (s *AccountAggregationSource) SetAllAwsRegions(v bool) *AccountAggregationSource {
	s.AllAwsRegions = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *AccountAggregationSource) SetAwsRegions(v []*string) *AccountAggregationSource {
	s.AwsRegions = v
	return s
}

// Indicates whether an Config rule is compliant based on account ID, region,
// compliance, and rule name.
//
// A rule is compliant if all of the resources that the rule evaluated comply
// with it. It is noncompliant if any of these resources do not comply.
type AggregateComplianceByConfigRule struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// Indicates whether an Amazon Web Services resource or Config rule is compliant
	// and provides the number of contributors that affect the compliance.
	Compliance *Compliance `type:"structure"`

	// The name of the Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateComplianceByConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateComplianceByConfigRule) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateComplianceByConfigRule) SetAccountId(v string) *AggregateComplianceByConfigRule {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateComplianceByConfigRule) SetAwsRegion(v string) *AggregateComplianceByConfigRule {
	s.AwsRegion = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AggregateComplianceByConfigRule) SetCompliance(v *Compliance) *AggregateComplianceByConfigRule {
	s.Compliance = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *AggregateComplianceByConfigRule) SetConfigRuleName(v string) *AggregateComplianceByConfigRule {
	s.ConfigRuleName = &v
	return s
}

// Provides aggregate compliance of the conformance pack. Indicates whether
// a conformance pack is compliant based on the name of the conformance pack,
// account ID, and region.
//
// A conformance pack is compliant if all of the rules in a conformance packs
// are compliant. It is noncompliant if any of the rules are not compliant.
// The compliance status of a conformance pack is INSUFFICIENT_DATA only if
// all rules within a conformance pack cannot be evaluated due to insufficient
// data. If some of the rules in a conformance pack are compliant but the compliance
// status of other rules in that same conformance pack is INSUFFICIENT_DATA,
// the conformance pack shows compliant.
type AggregateComplianceByConformancePack struct {
	_ struct{} `type:"structure"`

	// The 12-digit Amazon Web Services account ID of the source account.
	AccountId *string `type:"string"`

	// The source Amazon Web Services Region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The compliance status of the conformance pack.
	Compliance *AggregateConformancePackCompliance `type:"structure"`

	// The name of the conformance pack.
	ConformancePackName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateComplianceByConformancePack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateComplianceByConformancePack) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateComplianceByConformancePack) SetAccountId(v string) *AggregateComplianceByConformancePack {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateComplianceByConformancePack) SetAwsRegion(v string) *AggregateComplianceByConformancePack {
	s.AwsRegion = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AggregateComplianceByConformancePack) SetCompliance(v *AggregateConformancePackCompliance) *AggregateComplianceByConformancePack {
	s.Compliance = v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *AggregateComplianceByConformancePack) SetConformancePackName(v string) *AggregateComplianceByConformancePack {
	s.ConformancePackName = &v
	return s
}

// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
type AggregateComplianceCount struct {
	_ struct{} `type:"structure"`

	// The number of compliant and noncompliant Config rules.
	ComplianceSummary *ComplianceSummary `type:"structure"`

	// The 12-digit account ID or region based on the GroupByKey value.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateComplianceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateComplianceCount) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *AggregateComplianceCount) SetComplianceSummary(v *ComplianceSummary) *AggregateComplianceCount {
	s.ComplianceSummary = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AggregateComplianceCount) SetGroupName(v string) *AggregateComplianceCount {
	s.GroupName = &v
	return s
}

// Provides the number of compliant and noncompliant rules within a conformance
// pack. Also provides the compliance status of the conformance pack and the
// total rule count which includes compliant rules, noncompliant rules, and
// rules that cannot be evaluated due to insufficient data.
//
// A conformance pack is compliant if all of the rules in a conformance packs
// are compliant. It is noncompliant if any of the rules are not compliant.
// The compliance status of a conformance pack is INSUFFICIENT_DATA only if
// all rules within a conformance pack cannot be evaluated due to insufficient
// data. If some of the rules in a conformance pack are compliant but the compliance
// status of other rules in that same conformance pack is INSUFFICIENT_DATA,
// the conformance pack shows compliant.
type AggregateConformancePackCompliance struct {
	_ struct{} `type:"structure"`

	// The compliance status of the conformance pack.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// The number of compliant Config Rules.
	CompliantRuleCount *int64 `type:"integer"`

	// The number of noncompliant Config Rules.
	NonCompliantRuleCount *int64 `type:"integer"`

	// Total number of compliant rules, noncompliant rules, and the rules that do
	// not have any applicable resources to evaluate upon resulting in insufficient
	// data.
	TotalRuleCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackCompliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackCompliance) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AggregateConformancePackCompliance) SetComplianceType(v string) *AggregateConformancePackCompliance {
	s.ComplianceType = &v
	return s
}

// SetCompliantRuleCount sets the CompliantRuleCount field's value.
func (s *AggregateConformancePackCompliance) SetCompliantRuleCount(v int64) *AggregateConformancePackCompliance {
	s.CompliantRuleCount = &v
	return s
}

// SetNonCompliantRuleCount sets the NonCompliantRuleCount field's value.
func (s *AggregateConformancePackCompliance) SetNonCompliantRuleCount(v int64) *AggregateConformancePackCompliance {
	s.NonCompliantRuleCount = &v
	return s
}

// SetTotalRuleCount sets the TotalRuleCount field's value.
func (s *AggregateConformancePackCompliance) SetTotalRuleCount(v int64) *AggregateConformancePackCompliance {
	s.TotalRuleCount = &v
	return s
}

// The number of conformance packs that are compliant and noncompliant.
type AggregateConformancePackComplianceCount struct {
	_ struct{} `type:"structure"`

	// Number of compliant conformance packs.
	CompliantConformancePackCount *int64 `type:"integer"`

	// Number of noncompliant conformance packs.
	NonCompliantConformancePackCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackComplianceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackComplianceCount) GoString() string {
	return s.String()
}

// SetCompliantConformancePackCount sets the CompliantConformancePackCount field's value.
func (s *AggregateConformancePackComplianceCount) SetCompliantConformancePackCount(v int64) *AggregateConformancePackComplianceCount {
	s.CompliantConformancePackCount = &v
	return s
}

// SetNonCompliantConformancePackCount sets the NonCompliantConformancePackCount field's value.
func (s *AggregateConformancePackComplianceCount) SetNonCompliantConformancePackCount(v int64) *AggregateConformancePackComplianceCount {
	s.NonCompliantConformancePackCount = &v
	return s
}

// Filters the conformance packs based on an account ID, region, compliance
// type, and the name of the conformance pack.
type AggregateConformancePackComplianceFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit Amazon Web Services account ID of the source account.
	AccountId *string `type:"string"`

	// The source Amazon Web Services Region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The compliance status of the conformance pack.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// The name of the conformance pack.
	ConformancePackName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackComplianceFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackComplianceFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregateConformancePackComplianceFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregateConformancePackComplianceFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateConformancePackComplianceFilters) SetAccountId(v string) *AggregateConformancePackComplianceFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateConformancePackComplianceFilters) SetAwsRegion(v string) *AggregateConformancePackComplianceFilters {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AggregateConformancePackComplianceFilters) SetComplianceType(v string) *AggregateConformancePackComplianceFilters {
	s.ComplianceType = &v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *AggregateConformancePackComplianceFilters) SetConformancePackName(v string) *AggregateConformancePackComplianceFilters {
	s.ConformancePackName = &v
	return s
}

// Provides a summary of compliance based on either account ID or region.
type AggregateConformancePackComplianceSummary struct {
	_ struct{} `type:"structure"`

	// Returns an AggregateConformancePackComplianceCount object.
	ComplianceSummary *AggregateConformancePackComplianceCount `type:"structure"`

	// Groups the result based on Amazon Web Services account ID or Amazon Web Services
	// Region.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackComplianceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackComplianceSummary) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *AggregateConformancePackComplianceSummary) SetComplianceSummary(v *AggregateConformancePackComplianceCount) *AggregateConformancePackComplianceSummary {
	s.ComplianceSummary = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AggregateConformancePackComplianceSummary) SetGroupName(v string) *AggregateConformancePackComplianceSummary {
	s.GroupName = &v
	return s
}

// Filters the results based on account ID and region.
type AggregateConformancePackComplianceSummaryFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit Amazon Web Services account ID of the source account.
	AccountId *string `type:"string"`

	// The source Amazon Web Services Region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackComplianceSummaryFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateConformancePackComplianceSummaryFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregateConformancePackComplianceSummaryFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregateConformancePackComplianceSummaryFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateConformancePackComplianceSummaryFilters) SetAccountId(v string) *AggregateConformancePackComplianceSummaryFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateConformancePackComplianceSummaryFilters) SetAwsRegion(v string) *AggregateConformancePackComplianceSummaryFilters {
	s.AwsRegion = &v
	return s
}

// The details of an Config evaluation for an account ID and region in an aggregator.
// Provides the Amazon Web Services resource that was evaluated, the compliance
// of the resource, related time stamps, and supplementary information.
type AggregateEvaluationResult struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// Supplementary information about how the agrregate evaluation determined the
	// compliance.
	Annotation *string `min:"1" type:"string"`

	// The source region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The resource compliance status.
	//
	// For the AggregationEvaluationResult data type, Config supports only the COMPLIANT
	// and NON_COMPLIANT. Config does not support the NOT_APPLICABLE and INSUFFICIENT_DATA
	// value.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The time when the Config rule evaluated the Amazon Web Services resource.
	ConfigRuleInvokedTime *time.Time `type:"timestamp"`

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure"`

	// The time when Config recorded the aggregate evaluation result.
	ResultRecordedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateEvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateEvaluationResult) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateEvaluationResult) SetAccountId(v string) *AggregateEvaluationResult {
	s.AccountId = &v
	return s
}

// SetAnnotation sets the Annotation field's value.
func (s *AggregateEvaluationResult) SetAnnotation(v string) *AggregateEvaluationResult {
	s.Annotation = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateEvaluationResult) SetAwsRegion(v string) *AggregateEvaluationResult {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AggregateEvaluationResult) SetComplianceType(v string) *AggregateEvaluationResult {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleInvokedTime sets the ConfigRuleInvokedTime field's value.
func (s *AggregateEvaluationResult) SetConfigRuleInvokedTime(v time.Time) *AggregateEvaluationResult {
	s.ConfigRuleInvokedTime = &v
	return s
}

// SetEvaluationResultIdentifier sets the EvaluationResultIdentifier field's value.
func (s *AggregateEvaluationResult) SetEvaluationResultIdentifier(v *EvaluationResultIdentifier) *AggregateEvaluationResult {
	s.EvaluationResultIdentifier = v
	return s
}

// SetResultRecordedTime sets the ResultRecordedTime field's value.
func (s *AggregateEvaluationResult) SetResultRecordedTime(v time.Time) *AggregateEvaluationResult {
	s.ResultRecordedTime = &v
	return s
}

// The details that identify a resource that is collected by Config aggregator,
// including the resource type, ID, (if available) the custom resource name,
// the source account, and source region.
type AggregateResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services resource.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The name of the Amazon Web Services resource.
	ResourceName *string `type:"string"`

	// The type of the Amazon Web Services resource.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`

	// The 12-digit account ID of the source account.
	//
	// SourceAccountId is a required field
	SourceAccountId *string `type:"string" required:"true"`

	// The source region where data is aggregated.
	//
	// SourceRegion is a required field
	SourceRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregateResourceIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregateResourceIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregateResourceIdentifier"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.SourceAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceAccountId"))
	}
	if s.SourceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRegion"))
	}
	if s.SourceRegion != nil && len(*s.SourceRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AggregateResourceIdentifier) SetResourceId(v string) *AggregateResourceIdentifier {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *AggregateResourceIdentifier) SetResourceName(v string) *AggregateResourceIdentifier {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AggregateResourceIdentifier) SetResourceType(v string) *AggregateResourceIdentifier {
	s.ResourceType = &v
	return s
}

// SetSourceAccountId sets the SourceAccountId field's value.
func (s *AggregateResourceIdentifier) SetSourceAccountId(v string) *AggregateResourceIdentifier {
	s.SourceAccountId = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *AggregateResourceIdentifier) SetSourceRegion(v string) *AggregateResourceIdentifier {
	s.SourceRegion = &v
	return s
}

// The current sync status between the source and the aggregator account.
type AggregatedSourceStatus struct {
	_ struct{} `type:"structure"`

	// The region authorized to collect aggregated data.
	AwsRegion *string `min:"1" type:"string"`

	// The error code that Config returned when the source account aggregation last
	// failed.
	LastErrorCode *string `type:"string"`

	// The message indicating that the source account aggregation failed due to
	// an error.
	LastErrorMessage *string `type:"string"`

	// Filters the last updated status type.
	//
	//    * Valid value FAILED indicates errors while moving data.
	//
	//    * Valid value SUCCEEDED indicates the data was successfully moved.
	//
	//    * Valid value OUTDATED indicates the data is not the most recent.
	LastUpdateStatus *string `type:"string" enum:"AggregatedSourceStatusType"`

	// The time of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The source account ID or an organization.
	SourceId *string `type:"string"`

	// The source account or an organization.
	SourceType *string `type:"string" enum:"AggregatedSourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedSourceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedSourceStatus) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregatedSourceStatus) SetAwsRegion(v string) *AggregatedSourceStatus {
	s.AwsRegion = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *AggregatedSourceStatus) SetLastErrorCode(v string) *AggregatedSourceStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *AggregatedSourceStatus) SetLastErrorMessage(v string) *AggregatedSourceStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastUpdateStatus sets the LastUpdateStatus field's value.
func (s *AggregatedSourceStatus) SetLastUpdateStatus(v string) *AggregatedSourceStatus {
	s.LastUpdateStatus = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *AggregatedSourceStatus) SetLastUpdateTime(v time.Time) *AggregatedSourceStatus {
	s.LastUpdateTime = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *AggregatedSourceStatus) SetSourceId(v string) *AggregatedSourceStatus {
	s.SourceId = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *AggregatedSourceStatus) SetSourceType(v string) *AggregatedSourceStatus {
	s.SourceType = &v
	return s
}

// An object that represents the authorizations granted to aggregator accounts
// and regions.
type AggregationAuthorization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the aggregation object.
	AggregationAuthorizationArn *string `type:"string"`

	// The 12-digit account ID of the account authorized to aggregate data.
	AuthorizedAccountId *string `type:"string"`

	// The region authorized to collect aggregated data.
	AuthorizedAwsRegion *string `min:"1" type:"string"`

	// The time stamp when the aggregation authorization was created.
	CreationTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationAuthorization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregationAuthorization) GoString() string {
	return s.String()
}

// SetAggregationAuthorizationArn sets the AggregationAuthorizationArn field's value.
func (s *AggregationAuthorization) SetAggregationAuthorizationArn(v string) *AggregationAuthorization {
	s.AggregationAuthorizationArn = &v
	return s
}

// SetAuthorizedAccountId sets the AuthorizedAccountId field's value.
func (s *AggregationAuthorization) SetAuthorizedAccountId(v string) *AggregationAuthorization {
	s.AuthorizedAccountId = &v
	return s
}

// SetAuthorizedAwsRegion sets the AuthorizedAwsRegion field's value.
func (s *AggregationAuthorization) SetAuthorizedAwsRegion(v string) *AggregationAuthorization {
	s.AuthorizedAwsRegion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AggregationAuthorization) SetCreationTime(v time.Time) *AggregationAuthorization {
	s.CreationTime = &v
	return s
}

// The detailed configuration of a specified resource.
type BaseConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The 12-digit Amazon Web Services account ID associated with the resource.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with the resource.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The region where the resource resides.
	AwsRegion *string `locationName:"awsRegion" min:"1" type:"string"`

	// The description of the resource configuration.
	Configuration *string `locationName:"configuration" type:"string"`

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time `locationName:"configurationItemCaptureTime" type:"timestamp"`

	// The configuration item status. The valid values are:
	//
	//    * OK – The resource configuration has been updated
	//
	//    * ResourceDiscovered – The resource was newly discovered
	//
	//    * ResourceNotRecorded – The resource was discovered but its configuration
	//    was not recorded since the recorder excludes the recording of resources
	//    of this type
	//
	//    * ResourceDeleted – The resource was deleted
	//
	//    * ResourceDeletedNotRecorded – The resource was deleted but its configuration
	//    was not recorded since the recorder excludes the recording of resources
	//    of this type
	//
	// The CIs do not incur any cost.
	ConfigurationItemStatus *string `locationName:"configurationItemStatus" type:"string" enum:"ConfigurationItemStatus"`

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string `locationName:"configurationStateId" type:"string"`

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time `locationName:"resourceCreationTime" type:"timestamp"`

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of Amazon Web Services resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// Configuration attributes that Config returns for certain resource types to
	// supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]*string `locationName:"supplementaryConfiguration" type:"map"`

	// The version number of the resource configuration.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaseConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaseConfigurationItem) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *BaseConfigurationItem) SetAccountId(v string) *BaseConfigurationItem {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *BaseConfigurationItem) SetArn(v string) *BaseConfigurationItem {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *BaseConfigurationItem) SetAvailabilityZone(v string) *BaseConfigurationItem {
	s.AvailabilityZone = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *BaseConfigurationItem) SetAwsRegion(v string) *BaseConfigurationItem {
	s.AwsRegion = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *BaseConfigurationItem) SetConfiguration(v string) *BaseConfigurationItem {
	s.Configuration = &v
	return s
}

// SetConfigurationItemCaptureTime sets the ConfigurationItemCaptureTime field's value.
func (s *BaseConfigurationItem) SetConfigurationItemCaptureTime(v time.Time) *BaseConfigurationItem {
	s.ConfigurationItemCaptureTime = &v
	return s
}

// SetConfigurationItemStatus sets the ConfigurationItemStatus field's value.
func (s *BaseConfigurationItem) SetConfigurationItemStatus(v string) *BaseConfigurationItem {
	s.ConfigurationItemStatus = &v
	return s
}

// SetConfigurationStateId sets the ConfigurationStateId field's value.
func (s *BaseConfigurationItem) SetConfigurationStateId(v string) *BaseConfigurationItem {
	s.ConfigurationStateId = &v
	return s
}

// SetResourceCreationTime sets the ResourceCreationTime field's value.
func (s *BaseConfigurationItem) SetResourceCreationTime(v time.Time) *BaseConfigurationItem {
	s.ResourceCreationTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *BaseConfigurationItem) SetResourceId(v string) *BaseConfigurationItem {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *BaseConfigurationItem) SetResourceName(v string) *BaseConfigurationItem {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *BaseConfigurationItem) SetResourceType(v string) *BaseConfigurationItem {
	s.ResourceType = &v
	return s
}

// SetSupplementaryConfiguration sets the SupplementaryConfiguration field's value.
func (s *BaseConfigurationItem) SetSupplementaryConfiguration(v map[string]*string) *BaseConfigurationItem {
	s.SupplementaryConfiguration = v
	return s
}

// SetVersion sets the Version field's value.
func (s *BaseConfigurationItem) SetVersion(v string) *BaseConfigurationItem {
	s.Version = &v
	return s
}

type BatchGetAggregateResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// A list of aggregate ResourceIdentifiers objects.
	//
	// ResourceIdentifiers is a required field
	ResourceIdentifiers []*AggregateResourceIdentifier `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAggregateResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAggregateResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetAggregateResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetAggregateResourceConfigInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.ResourceIdentifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifiers"))
	}
	if s.ResourceIdentifiers != nil && len(s.ResourceIdentifiers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifiers", 1))
	}
	if s.ResourceIdentifiers != nil {
		for i, v := range s.ResourceIdentifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceIdentifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *BatchGetAggregateResourceConfigInput) SetConfigurationAggregatorName(v string) *BatchGetAggregateResourceConfigInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *BatchGetAggregateResourceConfigInput) SetResourceIdentifiers(v []*AggregateResourceIdentifier) *BatchGetAggregateResourceConfigInput {
	s.ResourceIdentifiers = v
	return s
}

type BatchGetAggregateResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the current configuration of one or more resources.
	BaseConfigurationItems []*BaseConfigurationItem `type:"list"`

	// A list of resource identifiers that were not processed with current scope.
	// The list is empty if all the resources are processed.
	UnprocessedResourceIdentifiers []*AggregateResourceIdentifier `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAggregateResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetAggregateResourceConfigOutput) GoString() string {
	return s.String()
}

// SetBaseConfigurationItems sets the BaseConfigurationItems field's value.
func (s *BatchGetAggregateResourceConfigOutput) SetBaseConfigurationItems(v []*BaseConfigurationItem) *BatchGetAggregateResourceConfigOutput {
	s.BaseConfigurationItems = v
	return s
}

// SetUnprocessedResourceIdentifiers sets the UnprocessedResourceIdentifiers field's value.
func (s *BatchGetAggregateResourceConfigOutput) SetUnprocessedResourceIdentifiers(v []*AggregateResourceIdentifier) *BatchGetAggregateResourceConfigOutput {
	s.UnprocessedResourceIdentifiers = v
	return s
}

type BatchGetResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// A list of resource keys to be processed with the current request. Each element
	// in the list consists of the resource type and resource ID.
	//
	// ResourceKeys is a required field
	ResourceKeys []*ResourceKey `locationName:"resourceKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetResourceConfigInput"}
	if s.ResourceKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceKeys"))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *BatchGetResourceConfigInput) SetResourceKeys(v []*ResourceKey) *BatchGetResourceConfigInput {
	s.ResourceKeys = v
	return s
}

type BatchGetResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the current configuration of one or more resources.
	BaseConfigurationItems []*BaseConfigurationItem `locationName:"baseConfigurationItems" type:"list"`

	// A list of resource keys that were not processed with the current response.
	// The unprocessesResourceKeys value is in the same form as ResourceKeys, so
	// the value can be directly provided to a subsequent BatchGetResourceConfig
	// operation. If there are no unprocessed resource keys, the response contains
	// an empty unprocessedResourceKeys list.
	UnprocessedResourceKeys []*ResourceKey `locationName:"unprocessedResourceKeys" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetResourceConfigOutput) GoString() string {
	return s.String()
}

// SetBaseConfigurationItems sets the BaseConfigurationItems field's value.
func (s *BatchGetResourceConfigOutput) SetBaseConfigurationItems(v []*BaseConfigurationItem) *BatchGetResourceConfigOutput {
	s.BaseConfigurationItems = v
	return s
}

// SetUnprocessedResourceKeys sets the UnprocessedResourceKeys field's value.
func (s *BatchGetResourceConfigOutput) SetUnprocessedResourceKeys(v []*ResourceKey) *BatchGetResourceConfigOutput {
	s.UnprocessedResourceKeys = v
	return s
}

// Indicates whether an Amazon Web Services resource or Config rule is compliant
// and provides the number of contributors that affect the compliance.
type Compliance struct {
	_ struct{} `type:"structure"`

	// The number of Amazon Web Services resources or Config rules that cause a
	// result of NON_COMPLIANT, up to a maximum number.
	ComplianceContributorCount *ComplianceContributorCount `type:"structure"`

	// Indicates whether an Amazon Web Services resource or Config rule is compliant.
	//
	// A resource is compliant if it complies with all of the Config rules that
	// evaluate it. A resource is noncompliant if it does not comply with one or
	// more of these rules.
	//
	// A rule is compliant if all of the resources that the rule evaluates comply
	// with it. A rule is noncompliant if any of these resources do not comply.
	//
	// Config returns the INSUFFICIENT_DATA value when no evaluation results are
	// available for the Amazon Web Services resource or Config rule.
	//
	// For the Compliance data type, Config supports only COMPLIANT, NON_COMPLIANT,
	// and INSUFFICIENT_DATA values. Config does not support the NOT_APPLICABLE
	// value for the Compliance data type.
	ComplianceType *string `type:"string" enum:"ComplianceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Compliance) GoString() string {
	return s.String()
}

// SetComplianceContributorCount sets the ComplianceContributorCount field's value.
func (s *Compliance) SetComplianceContributorCount(v *ComplianceContributorCount) *Compliance {
	s.ComplianceContributorCount = v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *Compliance) SetComplianceType(v string) *Compliance {
	s.ComplianceType = &v
	return s
}

// Indicates whether an Config rule is compliant. A rule is compliant if all
// of the resources that the rule evaluated comply with it. A rule is noncompliant
// if any of these resources do not comply.
type ComplianceByConfigRule struct {
	_ struct{} `type:"structure"`

	// Indicates whether the Config rule is compliant.
	Compliance *Compliance `type:"structure"`

	// The name of the Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceByConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceByConfigRule) GoString() string {
	return s.String()
}

// SetCompliance sets the Compliance field's value.
func (s *ComplianceByConfigRule) SetCompliance(v *Compliance) *ComplianceByConfigRule {
	s.Compliance = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ComplianceByConfigRule) SetConfigRuleName(v string) *ComplianceByConfigRule {
	s.ConfigRuleName = &v
	return s
}

// Indicates whether an Amazon Web Services resource that is evaluated according
// to one or more Config rules is compliant. A resource is compliant if it complies
// with all of the rules that evaluate it. A resource is noncompliant if it
// does not comply with one or more of these rules.
type ComplianceByResource struct {
	_ struct{} `type:"structure"`

	// Indicates whether the Amazon Web Services resource complies with all of the
	// Config rules that evaluated it.
	Compliance *Compliance `type:"structure"`

	// The ID of the Amazon Web Services resource that was evaluated.
	ResourceId *string `min:"1" type:"string"`

	// The type of the Amazon Web Services resource that was evaluated.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceByResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceByResource) GoString() string {
	return s.String()
}

// SetCompliance sets the Compliance field's value.
func (s *ComplianceByResource) SetCompliance(v *Compliance) *ComplianceByResource {
	s.Compliance = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ComplianceByResource) SetResourceId(v string) *ComplianceByResource {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceByResource) SetResourceType(v string) *ComplianceByResource {
	s.ResourceType = &v
	return s
}

// The number of Amazon Web Services resources or Config rules responsible for
// the current compliance of the item, up to a maximum number.
type ComplianceContributorCount struct {
	_ struct{} `type:"structure"`

	// Indicates whether the maximum count is reached.
	CapExceeded *bool `type:"boolean"`

	// The number of Amazon Web Services resources or Config rules responsible for
	// the current compliance of the item.
	CappedCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceContributorCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceContributorCount) GoString() string {
	return s.String()
}

// SetCapExceeded sets the CapExceeded field's value.
func (s *ComplianceContributorCount) SetCapExceeded(v bool) *ComplianceContributorCount {
	s.CapExceeded = &v
	return s
}

// SetCappedCount sets the CappedCount field's value.
func (s *ComplianceContributorCount) SetCappedCount(v int64) *ComplianceContributorCount {
	s.CappedCount = &v
	return s
}

// The number of Config rules or Amazon Web Services resources that are compliant
// and noncompliant.
type ComplianceSummary struct {
	_ struct{} `type:"structure"`

	// The time that Config created the compliance summary.
	ComplianceSummaryTimestamp *time.Time `type:"timestamp"`

	// The number of Config rules or Amazon Web Services resources that are compliant,
	// up to a maximum of 25 for rules and 100 for resources.
	CompliantResourceCount *ComplianceContributorCount `type:"structure"`

	// The number of Config rules or Amazon Web Services resources that are noncompliant,
	// up to a maximum of 25 for rules and 100 for resources.
	NonCompliantResourceCount *ComplianceContributorCount `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceSummary) GoString() string {
	return s.String()
}

// SetComplianceSummaryTimestamp sets the ComplianceSummaryTimestamp field's value.
func (s *ComplianceSummary) SetComplianceSummaryTimestamp(v time.Time) *ComplianceSummary {
	s.ComplianceSummaryTimestamp = &v
	return s
}

// SetCompliantResourceCount sets the CompliantResourceCount field's value.
func (s *ComplianceSummary) SetCompliantResourceCount(v *ComplianceContributorCount) *ComplianceSummary {
	s.CompliantResourceCount = v
	return s
}

// SetNonCompliantResourceCount sets the NonCompliantResourceCount field's value.
func (s *ComplianceSummary) SetNonCompliantResourceCount(v *ComplianceContributorCount) *ComplianceSummary {
	s.NonCompliantResourceCount = v
	return s
}

// The number of Amazon Web Services resources of a specific type that are compliant
// or noncompliant, up to a maximum of 100 for each.
type ComplianceSummaryByResourceType struct {
	_ struct{} `type:"structure"`

	// The number of Amazon Web Services resources that are compliant or noncompliant,
	// up to a maximum of 100 for each.
	ComplianceSummary *ComplianceSummary `type:"structure"`

	// The type of Amazon Web Services resource.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceSummaryByResourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComplianceSummaryByResourceType) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *ComplianceSummaryByResourceType) SetComplianceSummary(v *ComplianceSummary) *ComplianceSummaryByResourceType {
	s.ComplianceSummary = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceSummaryByResourceType) SetResourceType(v string) *ComplianceSummaryByResourceType {
	s.ResourceType = &v
	return s
}

// Provides status of the delivery of the snapshot or the configuration history
// to the specified Amazon S3 bucket. Also provides the status of notifications
// about the Amazon S3 delivery to the specified Amazon SNS topic.
type ConfigExportDeliveryInfo struct {
	_ struct{} `type:"structure"`

	// The time of the last attempted delivery.
	LastAttemptTime *time.Time `locationName:"lastAttemptTime" type:"timestamp"`

	// The error code from the last attempted delivery.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The error message from the last attempted delivery.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// Status of the last attempted delivery.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"DeliveryStatus"`

	// The time of the last successful delivery.
	LastSuccessfulTime *time.Time `locationName:"lastSuccessfulTime" type:"timestamp"`

	// The time that the next delivery occurs.
	NextDeliveryTime *time.Time `locationName:"nextDeliveryTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigExportDeliveryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigExportDeliveryInfo) GoString() string {
	return s.String()
}

// SetLastAttemptTime sets the LastAttemptTime field's value.
func (s *ConfigExportDeliveryInfo) SetLastAttemptTime(v time.Time) *ConfigExportDeliveryInfo {
	s.LastAttemptTime = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigExportDeliveryInfo) SetLastErrorCode(v string) *ConfigExportDeliveryInfo {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigExportDeliveryInfo) SetLastErrorMessage(v string) *ConfigExportDeliveryInfo {
	s.LastErrorMessage = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigExportDeliveryInfo) SetLastStatus(v string) *ConfigExportDeliveryInfo {
	s.LastStatus = &v
	return s
}

// SetLastSuccessfulTime sets the LastSuccessfulTime field's value.
func (s *ConfigExportDeliveryInfo) SetLastSuccessfulTime(v time.Time) *ConfigExportDeliveryInfo {
	s.LastSuccessfulTime = &v
	return s
}

// SetNextDeliveryTime sets the NextDeliveryTime field's value.
func (s *ConfigExportDeliveryInfo) SetNextDeliveryTime(v time.Time) *ConfigExportDeliveryInfo {
	s.NextDeliveryTime = &v
	return s
}

// An Config rule represents an Lambda function that you create for a custom
// rule or a predefined function for an Config managed rule. The function evaluates
// configuration items to assess whether your Amazon Web Services resources
// comply with your desired configurations. This function can run when Config
// detects a configuration change to an Amazon Web Services resource and at
// a periodic frequency that you choose (for example, every 24 hours).
//
// You can use the Amazon Web Services CLI and Amazon Web Services SDKs if you
// want to create a rule that triggers evaluations for your resources when Config
// delivers the configuration snapshot. For more information, see ConfigSnapshotDeliveryProperties.
//
// For more information about developing and using Config rules, see Evaluating
// Amazon Web Services resource Configurations with Config (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the Config Developer Guide.
type ConfigRule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Config rule.
	ConfigRuleArn *string `min:"1" type:"string"`

	// The ID of the Config rule.
	ConfigRuleId *string `min:"1" type:"string"`

	// The name that you assign to the Config rule. The name is required if you
	// are adding a new rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// Indicates whether the Config rule is active or is currently being deleted
	// by Config. It can also indicate the evaluation status for the Config rule.
	//
	// Config sets the state of the rule to EVALUATING temporarily after you use
	// the StartConfigRulesEvaluation request to evaluate your resources against
	// the Config rule.
	//
	// Config sets the state of the rule to DELETING_RESULTS temporarily after you
	// use the DeleteEvaluationResults request to delete the current evaluation
	// results for the Config rule.
	//
	// Config temporarily sets the state of a rule to DELETING after you use the
	// DeleteConfigRule request to delete the rule. After Config deletes the rule,
	// the rule and all of its evaluations are erased and are no longer available.
	ConfigRuleState *string `type:"string" enum:"ConfigRuleState"`

	// Service principal name of the service that created the rule.
	//
	// The field is populated only if the service linked rule is created by a service.
	// The field is empty if you create your own rule.
	CreatedBy *string `min:"1" type:"string"`

	// The description that you provide for the Config rule.
	Description *string `type:"string"`

	// A string, in JSON format, that is passed to the Config rule Lambda function.
	InputParameters *string `min:"1" type:"string"`

	// The maximum frequency with which Config runs evaluations for a rule. You
	// can specify a value for MaximumExecutionFrequency when:
	//
	//    * You are using an Config managed rule that is triggered at a periodic
	//    frequency.
	//
	//    * Your custom rule is triggered when Config delivers the configuration
	//    snapshot. For more information, see ConfigSnapshotDeliveryProperties.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	MaximumExecutionFrequency *string `type:"string" enum:"MaximumExecutionFrequency"`

	// Defines which resources can trigger an evaluation for the rule. The scope
	// can include one or more resource types, a combination of one resource type
	// and one resource ID, or a combination of a tag key and value. Specify a scope
	// to constrain the resources that can trigger an evaluation for the rule. If
	// you do not specify a scope, evaluations are triggered when any resource in
	// the recording group changes.
	//
	// The scope can be empty.
	Scope *Scope `type:"structure"`

	// Provides the rule owner (Amazon Web Services or customer), the rule identifier,
	// and the notifications that cause the function to evaluate your Amazon Web
	// Services resources.
	//
	// Source is a required field
	Source *Source `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRule"}
	if s.ConfigRuleArn != nil && len(*s.ConfigRuleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleArn", 1))
	}
	if s.ConfigRuleId != nil && len(*s.ConfigRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleId", 1))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.CreatedBy != nil && len(*s.CreatedBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatedBy", 1))
	}
	if s.InputParameters != nil && len(*s.InputParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputParameters", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Scope != nil {
		if err := s.Scope.Validate(); err != nil {
			invalidParams.AddNested("Scope", err.(request.ErrInvalidParams))
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleArn sets the ConfigRuleArn field's value.
func (s *ConfigRule) SetConfigRuleArn(v string) *ConfigRule {
	s.ConfigRuleArn = &v
	return s
}

// SetConfigRuleId sets the ConfigRuleId field's value.
func (s *ConfigRule) SetConfigRuleId(v string) *ConfigRule {
	s.ConfigRuleId = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRule) SetConfigRuleName(v string) *ConfigRule {
	s.ConfigRuleName = &v
	return s
}

// SetConfigRuleState sets the ConfigRuleState field's value.
func (s *ConfigRule) SetConfigRuleState(v string) *ConfigRule {
	s.ConfigRuleState = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ConfigRule) SetCreatedBy(v string) *ConfigRule {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfigRule) SetDescription(v string) *ConfigRule {
	s.Description = &v
	return s
}

// SetInputParameters sets the InputParameters field's value.
func (s *ConfigRule) SetInputParameters(v string) *ConfigRule {
	s.InputParameters = &v
	return s
}

// SetMaximumExecutionFrequency sets the MaximumExecutionFrequency field's value.
func (s *ConfigRule) SetMaximumExecutionFrequency(v string) *ConfigRule {
	s.MaximumExecutionFrequency = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ConfigRule) SetScope(v *Scope) *ConfigRule {
	s.Scope = v
	return s
}

// SetSource sets the Source field's value.
func (s *ConfigRule) SetSource(v *Source) *ConfigRule {
	s.Source = v
	return s
}

// Filters the compliance results based on account ID, region, compliance type,
// and rule name.
type ConfigRuleComplianceFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The rule compliance status.
	//
	// For the ConfigRuleComplianceFilters data type, Config supports only COMPLIANT
	// and NON_COMPLIANT. Config does not support the NOT_APPLICABLE and the INSUFFICIENT_DATA
	// values.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The name of the Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRuleComplianceFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRuleComplianceFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRuleComplianceFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRuleComplianceFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigRuleComplianceFilters) SetAccountId(v string) *ConfigRuleComplianceFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigRuleComplianceFilters) SetAwsRegion(v string) *ConfigRuleComplianceFilters {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConfigRuleComplianceFilters) SetComplianceType(v string) *ConfigRuleComplianceFilters {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRuleComplianceFilters) SetConfigRuleName(v string) *ConfigRuleComplianceFilters {
	s.ConfigRuleName = &v
	return s
}

// Filters the results based on the account IDs and regions.
type ConfigRuleComplianceSummaryFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRuleComplianceSummaryFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRuleComplianceSummaryFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRuleComplianceSummaryFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRuleComplianceSummaryFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigRuleComplianceSummaryFilters) SetAccountId(v string) *ConfigRuleComplianceSummaryFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigRuleComplianceSummaryFilters) SetAwsRegion(v string) *ConfigRuleComplianceSummaryFilters {
	s.AwsRegion = &v
	return s
}

// Status information for your Config Managed rules and Config Custom Policy
// rules. The status includes information such as the last time the rule ran,
// the last time it failed, and the related error for the last failure.
//
// This action does not return status information about Config Custom Lambda
// rules.
type ConfigRuleEvaluationStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Config rule.
	ConfigRuleArn *string `type:"string"`

	// The ID of the Config rule.
	ConfigRuleId *string `type:"string"`

	// The name of the Config rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// The time that you first activated the Config rule.
	FirstActivatedTime *time.Time `type:"timestamp"`

	// Indicates whether Config has evaluated your resources against the rule at
	// least once.
	//
	//    * true - Config has evaluated your Amazon Web Services resources against
	//    the rule at least once.
	//
	//    * false - Config has not finished evaluating your Amazon Web Services
	//    resources against the rule at least once.
	FirstEvaluationStarted *bool `type:"boolean"`

	// The time that you last turned off the Config rule.
	LastDeactivatedTime *time.Time `type:"timestamp"`

	// The status of the last attempted delivery of a debug log for your Config
	// Custom Policy rules. Either Successful or Failed.
	LastDebugLogDeliveryStatus *string `type:"string"`

	// The reason Config was not able to deliver a debug log. This is for the last
	// failed attempt to retrieve a debug log for your Config Custom Policy rules.
	LastDebugLogDeliveryStatusReason *string `type:"string"`

	// The time Config last attempted to deliver a debug log for your Config Custom
	// Policy rules.
	LastDebugLogDeliveryTime *time.Time `type:"timestamp"`

	// The error code that Config returned when the rule last failed.
	LastErrorCode *string `type:"string"`

	// The error message that Config returned when the rule last failed.
	LastErrorMessage *string `type:"string"`

	// The time that Config last failed to evaluate your Amazon Web Services resources
	// against the rule.
	LastFailedEvaluationTime *time.Time `type:"timestamp"`

	// The time that Config last failed to invoke the Config rule to evaluate your
	// Amazon Web Services resources.
	LastFailedInvocationTime *time.Time `type:"timestamp"`

	// The time that Config last successfully evaluated your Amazon Web Services
	// resources against the rule.
	LastSuccessfulEvaluationTime *time.Time `type:"timestamp"`

	// The time that Config last successfully invoked the Config rule to evaluate
	// your Amazon Web Services resources.
	LastSuccessfulInvocationTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRuleEvaluationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigRuleEvaluationStatus) GoString() string {
	return s.String()
}

// SetConfigRuleArn sets the ConfigRuleArn field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleArn(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleArn = &v
	return s
}

// SetConfigRuleId sets the ConfigRuleId field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleId(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleId = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleName(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleName = &v
	return s
}

// SetFirstActivatedTime sets the FirstActivatedTime field's value.
func (s *ConfigRuleEvaluationStatus) SetFirstActivatedTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.FirstActivatedTime = &v
	return s
}

// SetFirstEvaluationStarted sets the FirstEvaluationStarted field's value.
func (s *ConfigRuleEvaluationStatus) SetFirstEvaluationStarted(v bool) *ConfigRuleEvaluationStatus {
	s.FirstEvaluationStarted = &v
	return s
}

// SetLastDeactivatedTime sets the LastDeactivatedTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastDeactivatedTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastDeactivatedTime = &v
	return s
}

// SetLastDebugLogDeliveryStatus sets the LastDebugLogDeliveryStatus field's value.
func (s *ConfigRuleEvaluationStatus) SetLastDebugLogDeliveryStatus(v string) *ConfigRuleEvaluationStatus {
	s.LastDebugLogDeliveryStatus = &v
	return s
}

// SetLastDebugLogDeliveryStatusReason sets the LastDebugLogDeliveryStatusReason field's value.
func (s *ConfigRuleEvaluationStatus) SetLastDebugLogDeliveryStatusReason(v string) *ConfigRuleEvaluationStatus {
	s.LastDebugLogDeliveryStatusReason = &v
	return s
}

// SetLastDebugLogDeliveryTime sets the LastDebugLogDeliveryTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastDebugLogDeliveryTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastDebugLogDeliveryTime = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigRuleEvaluationStatus) SetLastErrorCode(v string) *ConfigRuleEvaluationStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigRuleEvaluationStatus) SetLastErrorMessage(v string) *ConfigRuleEvaluationStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastFailedEvaluationTime sets the LastFailedEvaluationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastFailedEvaluationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastFailedEvaluationTime = &v
	return s
}

// SetLastFailedInvocationTime sets the LastFailedInvocationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastFailedInvocationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastFailedInvocationTime = &v
	return s
}

// SetLastSuccessfulEvaluationTime sets the LastSuccessfulEvaluationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastSuccessfulEvaluationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastSuccessfulEvaluationTime = &v
	return s
}

// SetLastSuccessfulInvocationTime sets the LastSuccessfulInvocationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastSuccessfulInvocationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastSuccessfulInvocationTime = &v
	return s
}

// Provides options for how often Config delivers configuration snapshots to
// the Amazon S3 bucket in your delivery channel.
//
// The frequency for a rule that triggers evaluations for your resources when
// Config delivers the configuration snapshot is set by one of two values, depending
// on which is less frequent:
//
//    * The value for the deliveryFrequency parameter within the delivery channel
//    configuration, which sets how often Config delivers configuration snapshots.
//    This value also sets how often Config invokes evaluations for Config rules.
//
//    * The value for the MaximumExecutionFrequency parameter, which sets the
//    maximum frequency with which Config invokes evaluations for the rule.
//    For more information, see ConfigRule.
//
// If the deliveryFrequency value is less frequent than the MaximumExecutionFrequency
// value for a rule, Config invokes the rule only as often as the deliveryFrequency
// value.
//
// For example, you want your rule to run evaluations when Config delivers the
// configuration snapshot.
//
// You specify the MaximumExecutionFrequency value for Six_Hours.
//
// You then specify the delivery channel deliveryFrequency value for TwentyFour_Hours.
//
// Because the value for deliveryFrequency is less frequent than MaximumExecutionFrequency,
// Config invokes evaluations for the rule every 24 hours.
//
// You should set the MaximumExecutionFrequency value to be at least as frequent
// as the deliveryFrequency value. You can view the deliveryFrequency value
// by using the DescribeDeliveryChannnels action.
//
// To update the deliveryFrequency with which Config delivers your configuration
// snapshots, use the PutDeliveryChannel action.
type ConfigSnapshotDeliveryProperties struct {
	_ struct{} `type:"structure"`

	// The frequency with which Config delivers configuration snapshots.
	DeliveryFrequency *string `locationName:"deliveryFrequency" type:"string" enum:"MaximumExecutionFrequency"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigSnapshotDeliveryProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigSnapshotDeliveryProperties) GoString() string {
	return s.String()
}

// SetDeliveryFrequency sets the DeliveryFrequency field's value.
func (s *ConfigSnapshotDeliveryProperties) SetDeliveryFrequency(v string) *ConfigSnapshotDeliveryProperties {
	s.DeliveryFrequency = &v
	return s
}

// A list that contains the status of the delivery of the configuration stream
// notification to the Amazon SNS topic.
type ConfigStreamDeliveryInfo struct {
	_ struct{} `type:"structure"`

	// The error code from the last attempted delivery.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The error message from the last attempted delivery.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// Status of the last attempted delivery.
	//
	// Note Providing an SNS topic on a DeliveryChannel (https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html)
	// for Config is optional. If the SNS delivery is turned off, the last status
	// will be Not_Applicable.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"DeliveryStatus"`

	// The time from the last status change.
	LastStatusChangeTime *time.Time `locationName:"lastStatusChangeTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigStreamDeliveryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigStreamDeliveryInfo) GoString() string {
	return s.String()
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigStreamDeliveryInfo) SetLastErrorCode(v string) *ConfigStreamDeliveryInfo {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigStreamDeliveryInfo) SetLastErrorMessage(v string) *ConfigStreamDeliveryInfo {
	s.LastErrorMessage = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigStreamDeliveryInfo) SetLastStatus(v string) *ConfigStreamDeliveryInfo {
	s.LastStatus = &v
	return s
}

// SetLastStatusChangeTime sets the LastStatusChangeTime field's value.
func (s *ConfigStreamDeliveryInfo) SetLastStatusChangeTime(v time.Time) *ConfigStreamDeliveryInfo {
	s.LastStatusChangeTime = &v
	return s
}

// The details about the configuration aggregator, including information about
// source accounts, regions, and metadata of the aggregator.
type ConfigurationAggregator struct {
	_ struct{} `type:"structure"`

	// Provides a list of source accounts and regions to be aggregated.
	AccountAggregationSources []*AccountAggregationSource `type:"list"`

	// The Amazon Resource Name (ARN) of the aggregator.
	ConfigurationAggregatorArn *string `type:"string"`

	// The name of the aggregator.
	ConfigurationAggregatorName *string `min:"1" type:"string"`

	// Amazon Web Services service that created the configuration aggregator.
	CreatedBy *string `min:"1" type:"string"`

	// The time stamp when the configuration aggregator was created.
	CreationTime *time.Time `type:"timestamp"`

	// The time of the last update.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Provides an organization and list of regions to be aggregated.
	OrganizationAggregationSource *OrganizationAggregationSource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationAggregator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationAggregator) GoString() string {
	return s.String()
}

// SetAccountAggregationSources sets the AccountAggregationSources field's value.
func (s *ConfigurationAggregator) SetAccountAggregationSources(v []*AccountAggregationSource) *ConfigurationAggregator {
	s.AccountAggregationSources = v
	return s
}

// SetConfigurationAggregatorArn sets the ConfigurationAggregatorArn field's value.
func (s *ConfigurationAggregator) SetConfigurationAggregatorArn(v string) *ConfigurationAggregator {
	s.ConfigurationAggregatorArn = &v
	return s
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *ConfigurationAggregator) SetConfigurationAggregatorName(v string) *ConfigurationAggregator {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ConfigurationAggregator) SetCreatedBy(v string) *ConfigurationAggregator {
	s.CreatedBy = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ConfigurationAggregator) SetCreationTime(v time.Time) *ConfigurationAggregator {
	s.CreationTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ConfigurationAggregator) SetLastUpdatedTime(v time.Time) *ConfigurationAggregator {
	s.LastUpdatedTime = &v
	return s
}

// SetOrganizationAggregationSource sets the OrganizationAggregationSource field's value.
func (s *ConfigurationAggregator) SetOrganizationAggregationSource(v *OrganizationAggregationSource) *ConfigurationAggregator {
	s.OrganizationAggregationSource = v
	return s
}

// A list that contains detailed configurations of a specified resource.
type ConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The 12-digit Amazon Web Services account ID associated with the resource.
	AccountId *string `locationName:"accountId" type:"string"`

	// Amazon Resource Name (ARN) associated with the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with the resource.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The region where the resource resides.
	AwsRegion *string `locationName:"awsRegion" min:"1" type:"string"`

	// The description of the resource configuration.
	Configuration *string `locationName:"configuration" type:"string"`

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time `locationName:"configurationItemCaptureTime" type:"timestamp"`

	// Unique MD5 hash that represents the configuration item's state.
	//
	// You can use MD5 hash to compare the states of two or more configuration items
	// that are associated with the same resource.
	ConfigurationItemMD5Hash *string `locationName:"configurationItemMD5Hash" type:"string"`

	// The configuration item status. The valid values are:
	//
	//    * OK – The resource configuration has been updated
	//
	//    * ResourceDiscovered – The resource was newly discovered
	//
	//    * ResourceNotRecorded – The resource was discovered but its configuration
	//    was not recorded since the recorder excludes the recording of resources
	//    of this type
	//
	//    * ResourceDeleted – The resource was deleted
	//
	//    * ResourceDeletedNotRecorded – The resource was deleted but its configuration
	//    was not recorded since the recorder excludes the recording of resources
	//    of this type
	//
	// The CIs do not incur any cost.
	ConfigurationItemStatus *string `locationName:"configurationItemStatus" type:"string" enum:"ConfigurationItemStatus"`

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string `locationName:"configurationStateId" type:"string"`

	// A list of CloudTrail event IDs.
	//
	// A populated field indicates that the current configuration was initiated
	// by the events recorded in the CloudTrail log. For more information about
	// CloudTrail, see What Is CloudTrail (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html).
	//
	// An empty field indicates that the current configuration was not initiated
	// by any event. As of Version 1.3, the relatedEvents field is empty. You can
	// access the LookupEvents API (https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html)
	// in the CloudTrail API Reference to retrieve the events for the resource.
	RelatedEvents []*string `locationName:"relatedEvents" type:"list"`

	// A list of related Amazon Web Services resources.
	Relationships []*Relationship `locationName:"relationships" type:"list"`

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time `locationName:"resourceCreationTime" type:"timestamp"`

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of Amazon Web Services resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// Configuration attributes that Config returns for certain resource types to
	// supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]*string `locationName:"supplementaryConfiguration" type:"map"`

	// A mapping of key value tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version number of the resource configuration.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationItem) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigurationItem) SetAccountId(v string) *ConfigurationItem {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ConfigurationItem) SetArn(v string) *ConfigurationItem {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ConfigurationItem) SetAvailabilityZone(v string) *ConfigurationItem {
	s.AvailabilityZone = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigurationItem) SetAwsRegion(v string) *ConfigurationItem {
	s.AwsRegion = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *ConfigurationItem) SetConfiguration(v string) *ConfigurationItem {
	s.Configuration = &v
	return s
}

// SetConfigurationItemCaptureTime sets the ConfigurationItemCaptureTime field's value.
func (s *ConfigurationItem) SetConfigurationItemCaptureTime(v time.Time) *ConfigurationItem {
	s.ConfigurationItemCaptureTime = &v
	return s
}

// SetConfigurationItemMD5Hash sets the ConfigurationItemMD5Hash field's value.
func (s *ConfigurationItem) SetConfigurationItemMD5Hash(v string) *ConfigurationItem {
	s.ConfigurationItemMD5Hash = &v
	return s
}

// SetConfigurationItemStatus sets the ConfigurationItemStatus field's value.
func (s *ConfigurationItem) SetConfigurationItemStatus(v string) *ConfigurationItem {
	s.ConfigurationItemStatus = &v
	return s
}

// SetConfigurationStateId sets the ConfigurationStateId field's value.
func (s *ConfigurationItem) SetConfigurationStateId(v string) *ConfigurationItem {
	s.ConfigurationStateId = &v
	return s
}

// SetRelatedEvents sets the RelatedEvents field's value.
func (s *ConfigurationItem) SetRelatedEvents(v []*string) *ConfigurationItem {
	s.RelatedEvents = v
	return s
}

// SetRelationships sets the Relationships field's value.
func (s *ConfigurationItem) SetRelationships(v []*Relationship) *ConfigurationItem {
	s.Relationships = v
	return s
}

// SetResourceCreationTime sets the ResourceCreationTime field's value.
func (s *ConfigurationItem) SetResourceCreationTime(v time.Time) *ConfigurationItem {
	s.ResourceCreationTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ConfigurationItem) SetResourceId(v string) *ConfigurationItem {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ConfigurationItem) SetResourceName(v string) *ConfigurationItem {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ConfigurationItem) SetResourceType(v string) *ConfigurationItem {
	s.ResourceType = &v
	return s
}

// SetSupplementaryConfiguration sets the SupplementaryConfiguration field's value.
func (s *ConfigurationItem) SetSupplementaryConfiguration(v map[string]*string) *ConfigurationItem {
	s.SupplementaryConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ConfigurationItem) SetTags(v map[string]*string) *ConfigurationItem {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ConfigurationItem) SetVersion(v string) *ConfigurationItem {
	s.Version = &v
	return s
}

// An object that represents the recording of configuration changes of an Amazon
// Web Services resource.
type ConfigurationRecorder struct {
	_ struct{} `type:"structure"`

	// The name of the recorder. By default, Config automatically assigns the name
	// "default" when creating the configuration recorder. You cannot change the
	// assigned name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Specifies the types of Amazon Web Services resources for which Config records
	// configuration changes.
	RecordingGroup *RecordingGroup `locationName:"recordingGroup" type:"structure"`

	// Amazon Resource Name (ARN) of the IAM role used to describe the Amazon Web
	// Services resources associated with the account.
	RoleARN *string `locationName:"roleARN" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationRecorder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationRecorder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationRecorder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationRecorder"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ConfigurationRecorder) SetName(v string) *ConfigurationRecorder {
	s.Name = &v
	return s
}

// SetRecordingGroup sets the RecordingGroup field's value.
func (s *ConfigurationRecorder) SetRecordingGroup(v *RecordingGroup) *ConfigurationRecorder {
	s.RecordingGroup = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ConfigurationRecorder) SetRoleARN(v string) *ConfigurationRecorder {
	s.RoleARN = &v
	return s
}

// The current status of the configuration recorder.
type ConfigurationRecorderStatus struct {
	_ struct{} `type:"structure"`

	// The error code indicating that the recording failed.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The message indicating that the recording failed due to an error.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// The time the recorder was last started.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp"`

	// The last (previous) status of the recorder.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"RecorderStatus"`

	// The time when the status was last changed.
	LastStatusChangeTime *time.Time `locationName:"lastStatusChangeTime" type:"timestamp"`

	// The time the recorder was last stopped.
	LastStopTime *time.Time `locationName:"lastStopTime" type:"timestamp"`

	// The name of the configuration recorder.
	Name *string `locationName:"name" type:"string"`

	// Specifies whether or not the recorder is currently recording.
	Recording *bool `locationName:"recording" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationRecorderStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationRecorderStatus) GoString() string {
	return s.String()
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigurationRecorderStatus) SetLastErrorCode(v string) *ConfigurationRecorderStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigurationRecorderStatus) SetLastErrorMessage(v string) *ConfigurationRecorderStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastStartTime sets the LastStartTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStartTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStartTime = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigurationRecorderStatus) SetLastStatus(v string) *ConfigurationRecorderStatus {
	s.LastStatus = &v
	return s
}

// SetLastStatusChangeTime sets the LastStatusChangeTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStatusChangeTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStatusChangeTime = &v
	return s
}

// SetLastStopTime sets the LastStopTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStopTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStopTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfigurationRecorderStatus) SetName(v string) *ConfigurationRecorderStatus {
	s.Name = &v
	return s
}

// SetRecording sets the Recording field's value.
func (s *ConfigurationRecorderStatus) SetRecording(v bool) *ConfigurationRecorderStatus {
	s.Recording = &v
	return s
}

// Filters the conformance pack by compliance types and Config rule names.
type ConformancePackComplianceFilters struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT and NON_COMPLIANT. INSUFFICIENT_DATA is
	// not supported.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// Filters the results by Config rule names.
	ConfigRuleNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackComplianceFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackComplianceFilters) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConformancePackComplianceFilters) SetComplianceType(v string) *ConformancePackComplianceFilters {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *ConformancePackComplianceFilters) SetConfigRuleNames(v []*string) *ConformancePackComplianceFilters {
	s.ConfigRuleNames = v
	return s
}

// Summary includes the name and status of the conformance pack.
type ConformancePackComplianceSummary struct {
	_ struct{} `type:"structure"`

	// The status of the conformance pack. The allowed values are COMPLIANT, NON_COMPLIANT
	// and INSUFFICIENT_DATA.
	//
	// ConformancePackComplianceStatus is a required field
	ConformancePackComplianceStatus *string `type:"string" required:"true" enum:"ConformancePackComplianceType"`

	// The name of the conformance pack name.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackComplianceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackComplianceSummary) GoString() string {
	return s.String()
}

// SetConformancePackComplianceStatus sets the ConformancePackComplianceStatus field's value.
func (s *ConformancePackComplianceSummary) SetConformancePackComplianceStatus(v string) *ConformancePackComplianceSummary {
	s.ConformancePackComplianceStatus = &v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *ConformancePackComplianceSummary) SetConformancePackName(v string) *ConformancePackComplianceSummary {
	s.ConformancePackName = &v
	return s
}

// Returns details of a conformance pack. A conformance pack is a collection
// of Config rules and remediation actions that can be easily deployed in an
// account and a region.
type ConformancePackDetail struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the conformance pack.
	//
	// ConformancePackArn is a required field
	ConformancePackArn *string `min:"1" type:"string" required:"true"`

	// ID of the conformance pack.
	//
	// ConformancePackId is a required field
	ConformancePackId *string `min:"1" type:"string" required:"true"`

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []*ConformancePackInputParameter `type:"list"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Amazon Web Services service that created the conformance pack.
	CreatedBy *string `min:"1" type:"string"`

	// The name of the Amazon S3 bucket where Config stores conformance pack templates.
	//
	// This field is optional.
	DeliveryS3Bucket *string `type:"string"`

	// The prefix for the Amazon S3 bucket.
	//
	// This field is optional.
	DeliveryS3KeyPrefix *string `type:"string"`

	// Last time when conformation pack update was requested.
	LastUpdateRequestedTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackDetail) GoString() string {
	return s.String()
}

// SetConformancePackArn sets the ConformancePackArn field's value.
func (s *ConformancePackDetail) SetConformancePackArn(v string) *ConformancePackDetail {
	s.ConformancePackArn = &v
	return s
}

// SetConformancePackId sets the ConformancePackId field's value.
func (s *ConformancePackDetail) SetConformancePackId(v string) *ConformancePackDetail {
	s.ConformancePackId = &v
	return s
}

// SetConformancePackInputParameters sets the ConformancePackInputParameters field's value.
func (s *ConformancePackDetail) SetConformancePackInputParameters(v []*ConformancePackInputParameter) *ConformancePackDetail {
	s.ConformancePackInputParameters = v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *ConformancePackDetail) SetConformancePackName(v string) *ConformancePackDetail {
	s.ConformancePackName = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ConformancePackDetail) SetCreatedBy(v string) *ConformancePackDetail {
	s.CreatedBy = &v
	return s
}

// SetDeliveryS3Bucket sets the DeliveryS3Bucket field's value.
func (s *ConformancePackDetail) SetDeliveryS3Bucket(v string) *ConformancePackDetail {
	s.DeliveryS3Bucket = &v
	return s
}

// SetDeliveryS3KeyPrefix sets the DeliveryS3KeyPrefix field's value.
func (s *ConformancePackDetail) SetDeliveryS3KeyPrefix(v string) *ConformancePackDetail {
	s.DeliveryS3KeyPrefix = &v
	return s
}

// SetLastUpdateRequestedTime sets the LastUpdateRequestedTime field's value.
func (s *ConformancePackDetail) SetLastUpdateRequestedTime(v time.Time) *ConformancePackDetail {
	s.LastUpdateRequestedTime = &v
	return s
}

// Filters a conformance pack by Config rule names, compliance types, Amazon
// Web Services resource types, and resource IDs.
type ConformancePackEvaluationFilters struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT and NON_COMPLIANT. INSUFFICIENT_DATA is
	// not supported.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// Filters the results by Config rule names.
	ConfigRuleNames []*string `type:"list"`

	// Filters the results by resource IDs.
	//
	// This is valid only when you provide resource type. If there is no resource
	// type, you will see an error.
	ResourceIds []*string `type:"list"`

	// Filters the results by the resource type (for example, "AWS::EC2::Instance").
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackEvaluationFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackEvaluationFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConformancePackEvaluationFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConformancePackEvaluationFilters"}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConformancePackEvaluationFilters) SetComplianceType(v string) *ConformancePackEvaluationFilters {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *ConformancePackEvaluationFilters) SetConfigRuleNames(v []*string) *ConformancePackEvaluationFilters {
	s.ConfigRuleNames = v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ConformancePackEvaluationFilters) SetResourceIds(v []*string) *ConformancePackEvaluationFilters {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ConformancePackEvaluationFilters) SetResourceType(v string) *ConformancePackEvaluationFilters {
	s.ResourceType = &v
	return s
}

// The details of a conformance pack evaluation. Provides Config rule and Amazon
// Web Services resource type that was evaluated, the compliance of the conformance
// pack, related time stamps, and supplementary information.
type ConformancePackEvaluationResult struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `type:"string"`

	// The compliance type. The allowed values are COMPLIANT and NON_COMPLIANT.
	// INSUFFICIENT_DATA is not supported.
	//
	// ComplianceType is a required field
	ComplianceType *string `type:"string" required:"true" enum:"ConformancePackComplianceType"`

	// The time when Config rule evaluated Amazon Web Services resource.
	//
	// ConfigRuleInvokedTime is a required field
	ConfigRuleInvokedTime *time.Time `type:"timestamp" required:"true"`

	// Uniquely identifies an evaluation result.
	//
	// EvaluationResultIdentifier is a required field
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure" required:"true"`

	// The time when Config recorded the evaluation result.
	//
	// ResultRecordedTime is a required field
	ResultRecordedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackEvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackEvaluationResult) GoString() string {
	return s.String()
}

// SetAnnotation sets the Annotation field's value.
func (s *ConformancePackEvaluationResult) SetAnnotation(v string) *ConformancePackEvaluationResult {
	s.Annotation = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConformancePackEvaluationResult) SetComplianceType(v string) *ConformancePackEvaluationResult {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleInvokedTime sets the ConfigRuleInvokedTime field's value.
func (s *ConformancePackEvaluationResult) SetConfigRuleInvokedTime(v time.Time) *ConformancePackEvaluationResult {
	s.ConfigRuleInvokedTime = &v
	return s
}

// SetEvaluationResultIdentifier sets the EvaluationResultIdentifier field's value.
func (s *ConformancePackEvaluationResult) SetEvaluationResultIdentifier(v *EvaluationResultIdentifier) *ConformancePackEvaluationResult {
	s.EvaluationResultIdentifier = v
	return s
}

// SetResultRecordedTime sets the ResultRecordedTime field's value.
func (s *ConformancePackEvaluationResult) SetResultRecordedTime(v time.Time) *ConformancePackEvaluationResult {
	s.ResultRecordedTime = &v
	return s
}

// Input parameters in the form of key-value pairs for the conformance pack,
// both of which you define. Keys can have a maximum character length of 255
// characters, and values can have a maximum length of 4096 characters.
type ConformancePackInputParameter struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair.
	//
	// ParameterName is a required field
	ParameterName *string `type:"string" required:"true"`

	// Another part of the key-value pair.
	//
	// ParameterValue is a required field
	ParameterValue *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackInputParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackInputParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConformancePackInputParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConformancePackInputParameter"}
	if s.ParameterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterName"))
	}
	if s.ParameterValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterName sets the ParameterName field's value.
func (s *ConformancePackInputParameter) SetParameterName(v string) *ConformancePackInputParameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ConformancePackInputParameter) SetParameterValue(v string) *ConformancePackInputParameter {
	s.ParameterValue = &v
	return s
}

// Compliance information of one or more Config rules within a conformance pack.
// You can filter using Config rule names and compliance types.
type ConformancePackRuleCompliance struct {
	_ struct{} `type:"structure"`

	// Compliance of the Config rule.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and INSUFFICIENT_DATA.
	ComplianceType *string `type:"string" enum:"ConformancePackComplianceType"`

	// Name of the Config rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// Controls for the conformance pack. A control is a process to prevent or detect
	// problems while meeting objectives. A control can align with a specific compliance
	// regime or map to internal controls defined by an organization.
	Controls []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackRuleCompliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackRuleCompliance) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConformancePackRuleCompliance) SetComplianceType(v string) *ConformancePackRuleCompliance {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConformancePackRuleCompliance) SetConfigRuleName(v string) *ConformancePackRuleCompliance {
	s.ConfigRuleName = &v
	return s
}

// SetControls sets the Controls field's value.
func (s *ConformancePackRuleCompliance) SetControls(v []*string) *ConformancePackRuleCompliance {
	s.Controls = v
	return s
}

// Status details of a conformance pack.
type ConformancePackStatusDetail struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of comformance pack.
	//
	// ConformancePackArn is a required field
	ConformancePackArn *string `min:"1" type:"string" required:"true"`

	// ID of the conformance pack.
	//
	// ConformancePackId is a required field
	ConformancePackId *string `min:"1" type:"string" required:"true"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Indicates deployment status of conformance pack.
	//
	// Config sets the state of the conformance pack to:
	//
	//    * CREATE_IN_PROGRESS when a conformance pack creation is in progress for
	//    an account.
	//
	//    * CREATE_COMPLETE when a conformance pack has been successfully created
	//    in your account.
	//
	//    * CREATE_FAILED when a conformance pack creation failed in your account.
	//
	//    * DELETE_IN_PROGRESS when a conformance pack deletion is in progress.
	//
	//    * DELETE_FAILED when a conformance pack deletion failed in your account.
	//
	// ConformancePackState is a required field
	ConformancePackState *string `type:"string" required:"true" enum:"ConformancePackState"`

	// The reason of conformance pack creation failure.
	ConformancePackStatusReason *string `type:"string"`

	// Last time when conformation pack creation and update was successful.
	LastUpdateCompletedTime *time.Time `type:"timestamp"`

	// Last time when conformation pack creation and update was requested.
	//
	// LastUpdateRequestedTime is a required field
	LastUpdateRequestedTime *time.Time `type:"timestamp" required:"true"`

	// Amazon Resource Name (ARN) of CloudFormation stack.
	//
	// StackArn is a required field
	StackArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackStatusDetail) GoString() string {
	return s.String()
}

// SetConformancePackArn sets the ConformancePackArn field's value.
func (s *ConformancePackStatusDetail) SetConformancePackArn(v string) *ConformancePackStatusDetail {
	s.ConformancePackArn = &v
	return s
}

// SetConformancePackId sets the ConformancePackId field's value.
func (s *ConformancePackStatusDetail) SetConformancePackId(v string) *ConformancePackStatusDetail {
	s.ConformancePackId = &v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *ConformancePackStatusDetail) SetConformancePackName(v string) *ConformancePackStatusDetail {
	s.ConformancePackName = &v
	return s
}

// SetConformancePackState sets the ConformancePackState field's value.
func (s *ConformancePackStatusDetail) SetConformancePackState(v string) *ConformancePackStatusDetail {
	s.ConformancePackState = &v
	return s
}

// SetConformancePackStatusReason sets the ConformancePackStatusReason field's value.
func (s *ConformancePackStatusDetail) SetConformancePackStatusReason(v string) *ConformancePackStatusDetail {
	s.ConformancePackStatusReason = &v
	return s
}

// SetLastUpdateCompletedTime sets the LastUpdateCompletedTime field's value.
func (s *ConformancePackStatusDetail) SetLastUpdateCompletedTime(v time.Time) *ConformancePackStatusDetail {
	s.LastUpdateCompletedTime = &v
	return s
}

// SetLastUpdateRequestedTime sets the LastUpdateRequestedTime field's value.
func (s *ConformancePackStatusDetail) SetLastUpdateRequestedTime(v time.Time) *ConformancePackStatusDetail {
	s.LastUpdateRequestedTime = &v
	return s
}

// SetStackArn sets the StackArn field's value.
func (s *ConformancePackStatusDetail) SetStackArn(v string) *ConformancePackStatusDetail {
	s.StackArn = &v
	return s
}

// You have specified a template that is not valid or supported.
type ConformancePackTemplateValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackTemplateValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConformancePackTemplateValidationException) GoString() string {
	return s.String()
}

func newErrorConformancePackTemplateValidationException(v protocol.ResponseMetadata) error {
	return &ConformancePackTemplateValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConformancePackTemplateValidationException) Code() string {
	return "ConformancePackTemplateValidationException"
}

// Message returns the exception's message.
func (s *ConformancePackTemplateValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConformancePackTemplateValidationException) OrigErr() error {
	return nil
}

func (s *ConformancePackTemplateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConformancePackTemplateValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConformancePackTemplateValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides the runtime system, policy definition, and whether debug logging
// enabled. You can specify the following CustomPolicyDetails parameter values
// only for Config Custom Policy rules.
type CustomPolicyDetails struct {
	_ struct{} `type:"structure"`

	// The boolean expression for enabling debug logging for your Config Custom
	// Policy rule. The default value is false.
	EnableDebugLogDelivery *bool `type:"boolean"`

	// The runtime system for your Config Custom Policy rule. Guard is a policy-as-code
	// language that allows you to write policies that are enforced by Config Custom
	// Policy rules. For more information about Guard, see the Guard GitHub Repository
	// (https://github.com/aws-cloudformation/cloudformation-guard).
	//
	// PolicyRuntime is a required field
	PolicyRuntime *string `min:"1" type:"string" required:"true"`

	// The policy definition containing the logic for your Config Custom Policy
	// rule.
	//
	// PolicyText is a required field
	PolicyText *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPolicyDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomPolicyDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomPolicyDetails"}
	if s.PolicyRuntime == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyRuntime"))
	}
	if s.PolicyRuntime != nil && len(*s.PolicyRuntime) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyRuntime", 1))
	}
	if s.PolicyText == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyText"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableDebugLogDelivery sets the EnableDebugLogDelivery field's value.
func (s *CustomPolicyDetails) SetEnableDebugLogDelivery(v bool) *CustomPolicyDetails {
	s.EnableDebugLogDelivery = &v
	return s
}

// SetPolicyRuntime sets the PolicyRuntime field's value.
func (s *CustomPolicyDetails) SetPolicyRuntime(v string) *CustomPolicyDetails {
	s.PolicyRuntime = &v
	return s
}

// SetPolicyText sets the PolicyText field's value.
func (s *CustomPolicyDetails) SetPolicyText(v string) *CustomPolicyDetails {
	s.PolicyText = &v
	return s
}

type DeleteAggregationAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account authorized to aggregate data.
	//
	// AuthorizedAccountId is a required field
	AuthorizedAccountId *string `type:"string" required:"true"`

	// The region authorized to collect aggregated data.
	//
	// AuthorizedAwsRegion is a required field
	AuthorizedAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAggregationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAggregationAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAggregationAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAggregationAuthorizationInput"}
	if s.AuthorizedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAccountId"))
	}
	if s.AuthorizedAwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAwsRegion"))
	}
	if s.AuthorizedAwsRegion != nil && len(*s.AuthorizedAwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedAccountId sets the AuthorizedAccountId field's value.
func (s *DeleteAggregationAuthorizationInput) SetAuthorizedAccountId(v string) *DeleteAggregationAuthorizationInput {
	s.AuthorizedAccountId = &v
	return s
}

// SetAuthorizedAwsRegion sets the AuthorizedAwsRegion field's value.
func (s *DeleteAggregationAuthorizationInput) SetAuthorizedAwsRegion(v string) *DeleteAggregationAuthorizationInput {
	s.AuthorizedAwsRegion = &v
	return s
}

type DeleteAggregationAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAggregationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAggregationAuthorizationOutput) GoString() string {
	return s.String()
}

type DeleteConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the Config rule that you want to delete.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigRuleInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteConfigRuleInput) SetConfigRuleName(v string) *DeleteConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

type DeleteConfigRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigRuleOutput) GoString() string {
	return s.String()
}

type DeleteConfigurationAggregatorInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationAggregatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationAggregatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationAggregatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationAggregatorInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DeleteConfigurationAggregatorInput) SetConfigurationAggregatorName(v string) *DeleteConfigurationAggregatorInput {
	s.ConfigurationAggregatorName = &v
	return s
}

type DeleteConfigurationAggregatorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationAggregatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationAggregatorOutput) GoString() string {
	return s.String()
}

// The request object for the DeleteConfigurationRecorder action.
type DeleteConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration recorder to be deleted. You can retrieve the
	// name of your configuration recorder by using the DescribeConfigurationRecorders
	// action.
	//
	// ConfigurationRecorderName is a required field
	ConfigurationRecorderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationRecorderInput"}
	if s.ConfigurationRecorderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorderName"))
	}
	if s.ConfigurationRecorderName != nil && len(*s.ConfigurationRecorderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationRecorderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorderName sets the ConfigurationRecorderName field's value.
func (s *DeleteConfigurationRecorderInput) SetConfigurationRecorderName(v string) *DeleteConfigurationRecorderInput {
	s.ConfigurationRecorderName = &v
	return s
}

type DeleteConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfigurationRecorderOutput) GoString() string {
	return s.String()
}

type DeleteConformancePackInput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack you want to delete.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConformancePackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConformancePackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConformancePackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConformancePackInput"}
	if s.ConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *DeleteConformancePackInput) SetConformancePackName(v string) *DeleteConformancePackInput {
	s.ConformancePackName = &v
	return s
}

type DeleteConformancePackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConformancePackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConformancePackOutput) GoString() string {
	return s.String()
}

// The input for the DeleteDeliveryChannel action. The action accepts the following
// data, in JSON format.
type DeleteDeliveryChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery channel to delete.
	//
	// DeliveryChannelName is a required field
	DeliveryChannelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeliveryChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeliveryChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeliveryChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeliveryChannelInput"}
	if s.DeliveryChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryChannelName"))
	}
	if s.DeliveryChannelName != nil && len(*s.DeliveryChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryChannelName sets the DeliveryChannelName field's value.
func (s *DeleteDeliveryChannelInput) SetDeliveryChannelName(v string) *DeleteDeliveryChannelInput {
	s.DeliveryChannelName = &v
	return s
}

type DeleteDeliveryChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeliveryChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeliveryChannelOutput) GoString() string {
	return s.String()
}

type DeleteEvaluationResultsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Config rule for which you want to delete the evaluation results.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEvaluationResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEvaluationResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEvaluationResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEvaluationResultsInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteEvaluationResultsInput) SetConfigRuleName(v string) *DeleteEvaluationResultsInput {
	s.ConfigRuleName = &v
	return s
}

// The output when you delete the evaluation results for the specified Config
// rule.
type DeleteEvaluationResultsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEvaluationResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEvaluationResultsOutput) GoString() string {
	return s.String()
}

type DeleteOrganizationConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of organization Config rule that you want to delete.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOrganizationConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOrganizationConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOrganizationConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOrganizationConfigRuleInput"}
	if s.OrganizationConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConfigRuleName"))
	}
	if s.OrganizationConfigRuleName != nil && len(*s.OrganizationConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *DeleteOrganizationConfigRuleInput) SetOrganizationConfigRuleName(v string) *DeleteOrganizationConfigRuleInput {
	s.OrganizationConfigRuleName = &v
	return s
}

type DeleteOrganizationConfigRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOrganizationConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOrganizationConfigRuleOutput) GoString() string {
	return s.String()
}

type DeleteOrganizationConformancePackInput struct {
	_ struct{} `type:"structure"`

	// The name of organization conformance pack that you want to delete.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOrganizationConformancePackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOrganizationConformancePackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOrganizationConformancePackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOrganizationConformancePackInput"}
	if s.OrganizationConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConformancePackName"))
	}
	if s.OrganizationConformancePackName != nil && len(*s.OrganizationConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *DeleteOrganizationConformancePackInput) SetOrganizationConformancePackName(v string) *DeleteOrganizationConformancePackInput {
	s.OrganizationConformancePackName = &v
	return s
}

type DeleteOrganizationConformancePackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOrganizationConformancePackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOrganizationConformancePackOutput) GoString() string {
	return s.String()
}

type DeletePendingAggregationRequestInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account requesting to aggregate data.
	//
	// RequesterAccountId is a required field
	RequesterAccountId *string `type:"string" required:"true"`

	// The region requesting to aggregate data.
	//
	// RequesterAwsRegion is a required field
	RequesterAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePendingAggregationRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePendingAggregationRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePendingAggregationRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePendingAggregationRequestInput"}
	if s.RequesterAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequesterAccountId"))
	}
	if s.RequesterAwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("RequesterAwsRegion"))
	}
	if s.RequesterAwsRegion != nil && len(*s.RequesterAwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequesterAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequesterAccountId sets the RequesterAccountId field's value.
func (s *DeletePendingAggregationRequestInput) SetRequesterAccountId(v string) *DeletePendingAggregationRequestInput {
	s.RequesterAccountId = &v
	return s
}

// SetRequesterAwsRegion sets the RequesterAwsRegion field's value.
func (s *DeletePendingAggregationRequestInput) SetRequesterAwsRegion(v string) *DeletePendingAggregationRequestInput {
	s.RequesterAwsRegion = &v
	return s
}

type DeletePendingAggregationRequestOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePendingAggregationRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePendingAggregationRequestOutput) GoString() string {
	return s.String()
}

type DeleteRemediationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Config rule for which you want to delete remediation configuration.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The type of a resource.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemediationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemediationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRemediationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRemediationConfigurationInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteRemediationConfigurationInput) SetConfigRuleName(v string) *DeleteRemediationConfigurationInput {
	s.ConfigRuleName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DeleteRemediationConfigurationInput) SetResourceType(v string) *DeleteRemediationConfigurationInput {
	s.ResourceType = &v
	return s
}

type DeleteRemediationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemediationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemediationConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteRemediationExceptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Config rule for which you want to delete remediation exception
	// configuration.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An exception list of resource exception keys to be processed with the current
	// request. Config adds exception for each resource key. For example, Config
	// adds 3 exceptions for 3 resource keys.
	//
	// ResourceKeys is a required field
	ResourceKeys []*RemediationExceptionResourceKey `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemediationExceptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemediationExceptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRemediationExceptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRemediationExceptionsInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ResourceKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceKeys"))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteRemediationExceptionsInput) SetConfigRuleName(v string) *DeleteRemediationExceptionsInput {
	s.ConfigRuleName = &v
	return s
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *DeleteRemediationExceptionsInput) SetResourceKeys(v []*RemediationExceptionResourceKey) *DeleteRemediationExceptionsInput {
	s.ResourceKeys = v
	return s
}

type DeleteRemediationExceptionsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of failed delete remediation exceptions batch objects. Each
	// object in the batch consists of a list of failed items and failure messages.
	FailedBatches []*FailedDeleteRemediationExceptionsBatch `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemediationExceptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRemediationExceptionsOutput) GoString() string {
	return s.String()
}

// SetFailedBatches sets the FailedBatches field's value.
func (s *DeleteRemediationExceptionsOutput) SetFailedBatches(v []*FailedDeleteRemediationExceptionsBatch) *DeleteRemediationExceptionsOutput {
	s.FailedBatches = v
	return s
}

type DeleteResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceConfigInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteResourceConfigInput) SetResourceId(v string) *DeleteResourceConfigInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DeleteResourceConfigInput) SetResourceType(v string) *DeleteResourceConfigInput {
	s.ResourceType = &v
	return s
}

type DeleteResourceConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceConfigOutput) GoString() string {
	return s.String()
}

type DeleteRetentionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the retention configuration to delete.
	//
	// RetentionConfigurationName is a required field
	RetentionConfigurationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRetentionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRetentionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRetentionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRetentionConfigurationInput"}
	if s.RetentionConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionConfigurationName"))
	}
	if s.RetentionConfigurationName != nil && len(*s.RetentionConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RetentionConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionConfigurationName sets the RetentionConfigurationName field's value.
func (s *DeleteRetentionConfigurationInput) SetRetentionConfigurationName(v string) *DeleteRetentionConfigurationInput {
	s.RetentionConfigurationName = &v
	return s
}

type DeleteRetentionConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRetentionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRetentionConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteStoredQueryInput struct {
	_ struct{} `type:"structure"`

	// The name of the query that you want to delete.
	//
	// QueryName is a required field
	QueryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStoredQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStoredQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStoredQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStoredQueryInput"}
	if s.QueryName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryName"))
	}
	if s.QueryName != nil && len(*s.QueryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryName sets the QueryName field's value.
func (s *DeleteStoredQueryInput) SetQueryName(v string) *DeleteStoredQueryInput {
	s.QueryName = &v
	return s
}

type DeleteStoredQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStoredQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStoredQueryOutput) GoString() string {
	return s.String()
}

// The input for the DeliverConfigSnapshot action.
type DeliverConfigSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery channel through which the snapshot is delivered.
	//
	// DeliveryChannelName is a required field
	DeliveryChannelName *string `locationName:"deliveryChannelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliverConfigSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliverConfigSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliverConfigSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeliverConfigSnapshotInput"}
	if s.DeliveryChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryChannelName"))
	}
	if s.DeliveryChannelName != nil && len(*s.DeliveryChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryChannelName sets the DeliveryChannelName field's value.
func (s *DeliverConfigSnapshotInput) SetDeliveryChannelName(v string) *DeliverConfigSnapshotInput {
	s.DeliveryChannelName = &v
	return s
}

// The output for the DeliverConfigSnapshot action, in JSON format.
type DeliverConfigSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the snapshot that is being created.
	ConfigSnapshotId *string `locationName:"configSnapshotId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliverConfigSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliverConfigSnapshotOutput) GoString() string {
	return s.String()
}

// SetConfigSnapshotId sets the ConfigSnapshotId field's value.
func (s *DeliverConfigSnapshotOutput) SetConfigSnapshotId(v string) *DeliverConfigSnapshotOutput {
	s.ConfigSnapshotId = &v
	return s
}

// The channel through which Config delivers notifications and updated configuration
// states.
type DeliveryChannel struct {
	_ struct{} `type:"structure"`

	// The options for how often Config delivers configuration snapshots to the
	// Amazon S3 bucket.
	ConfigSnapshotDeliveryProperties *ConfigSnapshotDeliveryProperties `locationName:"configSnapshotDeliveryProperties" type:"structure"`

	// The name of the delivery channel. By default, Config assigns the name "default"
	// when creating the delivery channel. To change the delivery channel name,
	// you must use the DeleteDeliveryChannel action to delete your current delivery
	// channel, and then you must use the PutDeliveryChannel command to create a
	// delivery channel that has the desired name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The name of the Amazon S3 bucket to which Config delivers configuration snapshots
	// and configuration history files.
	//
	// If you specify a bucket that belongs to another Amazon Web Services account,
	// that bucket must have policies that grant access permissions to Config. For
	// more information, see Permissions for the Amazon S3 Bucket (https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html)
	// in the Config Developer Guide.
	S3BucketName *string `locationName:"s3BucketName" type:"string"`

	// The prefix for the specified Amazon S3 bucket.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS ) KMS key
	// (KMS key) used to encrypt objects delivered by Config. Must belong to the
	// same Region as the destination S3 bucket.
	S3KmsKeyArn *string `locationName:"s3KmsKeyArn" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which Config sends
	// notifications about configuration changes.
	//
	// If you choose a topic from another account, the topic must have policies
	// that grant access permissions to Config. For more information, see Permissions
	// for the Amazon SNS Topic (https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html)
	// in the Config Developer Guide.
	SnsTopicARN *string `locationName:"snsTopicARN" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliveryChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeliveryChannel"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigSnapshotDeliveryProperties sets the ConfigSnapshotDeliveryProperties field's value.
func (s *DeliveryChannel) SetConfigSnapshotDeliveryProperties(v *ConfigSnapshotDeliveryProperties) *DeliveryChannel {
	s.ConfigSnapshotDeliveryProperties = v
	return s
}

// SetName sets the Name field's value.
func (s *DeliveryChannel) SetName(v string) *DeliveryChannel {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *DeliveryChannel) SetS3BucketName(v string) *DeliveryChannel {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *DeliveryChannel) SetS3KeyPrefix(v string) *DeliveryChannel {
	s.S3KeyPrefix = &v
	return s
}

// SetS3KmsKeyArn sets the S3KmsKeyArn field's value.
func (s *DeliveryChannel) SetS3KmsKeyArn(v string) *DeliveryChannel {
	s.S3KmsKeyArn = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *DeliveryChannel) SetSnsTopicARN(v string) *DeliveryChannel {
	s.SnsTopicARN = &v
	return s
}

// The status of a specified delivery channel.
//
// Valid values: Success | Failure
type DeliveryChannelStatus struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of the delivery of the configuration history
	// to the specified Amazon S3 bucket.
	ConfigHistoryDeliveryInfo *ConfigExportDeliveryInfo `locationName:"configHistoryDeliveryInfo" type:"structure"`

	// A list containing the status of the delivery of the snapshot to the specified
	// Amazon S3 bucket.
	ConfigSnapshotDeliveryInfo *ConfigExportDeliveryInfo `locationName:"configSnapshotDeliveryInfo" type:"structure"`

	// A list containing the status of the delivery of the configuration stream
	// notification to the specified Amazon SNS topic.
	ConfigStreamDeliveryInfo *ConfigStreamDeliveryInfo `locationName:"configStreamDeliveryInfo" type:"structure"`

	// The name of the delivery channel.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryChannelStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryChannelStatus) GoString() string {
	return s.String()
}

// SetConfigHistoryDeliveryInfo sets the ConfigHistoryDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigHistoryDeliveryInfo(v *ConfigExportDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigHistoryDeliveryInfo = v
	return s
}

// SetConfigSnapshotDeliveryInfo sets the ConfigSnapshotDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigSnapshotDeliveryInfo(v *ConfigExportDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigSnapshotDeliveryInfo = v
	return s
}

// SetConfigStreamDeliveryInfo sets the ConfigStreamDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigStreamDeliveryInfo(v *ConfigStreamDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigStreamDeliveryInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *DeliveryChannelStatus) SetName(v string) *DeliveryChannelStatus {
	s.Name = &v
	return s
}

type DescribeAggregateComplianceByConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results by ConfigRuleComplianceFilters object.
	Filters *ConfigRuleComplianceFilters `type:"structure"`

	// The maximum number of evaluation results returned on each page. The default
	// is maximum. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregateComplianceByConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregateComplianceByConfigRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAggregateComplianceByConfigRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAggregateComplianceByConfigRulesInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetConfigurationAggregatorName(v string) *DescribeAggregateComplianceByConfigRulesInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetFilters(v *ConfigRuleComplianceFilters) *DescribeAggregateComplianceByConfigRulesInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetLimit(v int64) *DescribeAggregateComplianceByConfigRulesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetNextToken(v string) *DescribeAggregateComplianceByConfigRulesInput {
	s.NextToken = &v
	return s
}

type DescribeAggregateComplianceByConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateComplianceByConfigRule object.
	AggregateComplianceByConfigRules []*AggregateComplianceByConfigRule `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregateComplianceByConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregateComplianceByConfigRulesOutput) GoString() string {
	return s.String()
}

// SetAggregateComplianceByConfigRules sets the AggregateComplianceByConfigRules field's value.
func (s *DescribeAggregateComplianceByConfigRulesOutput) SetAggregateComplianceByConfigRules(v []*AggregateComplianceByConfigRule) *DescribeAggregateComplianceByConfigRulesOutput {
	s.AggregateComplianceByConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConfigRulesOutput) SetNextToken(v string) *DescribeAggregateComplianceByConfigRulesOutput {
	s.NextToken = &v
	return s
}

type DescribeAggregateComplianceByConformancePacksInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the result by AggregateConformancePackComplianceFilters object.
	Filters *AggregateConformancePackComplianceFilters `type:"structure"`

	// The maximum number of conformance packs compliance details returned on each
	// page. The default is maximum. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregateComplianceByConformancePacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregateComplianceByConformancePacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAggregateComplianceByConformancePacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAggregateComplianceByConformancePacksInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DescribeAggregateComplianceByConformancePacksInput) SetConfigurationAggregatorName(v string) *DescribeAggregateComplianceByConformancePacksInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAggregateComplianceByConformancePacksInput) SetFilters(v *AggregateConformancePackComplianceFilters) *DescribeAggregateComplianceByConformancePacksInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeAggregateComplianceByConformancePacksInput) SetLimit(v int64) *DescribeAggregateComplianceByConformancePacksInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConformancePacksInput) SetNextToken(v string) *DescribeAggregateComplianceByConformancePacksInput {
	s.NextToken = &v
	return s
}

type DescribeAggregateComplianceByConformancePacksOutput struct {
	_ struct{} `type:"structure"`

	// Returns the AggregateComplianceByConformancePack object.
	AggregateComplianceByConformancePacks []*AggregateComplianceByConformancePack `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregateComplianceByConformancePacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregateComplianceByConformancePacksOutput) GoString() string {
	return s.String()
}

// SetAggregateComplianceByConformancePacks sets the AggregateComplianceByConformancePacks field's value.
func (s *DescribeAggregateComplianceByConformancePacksOutput) SetAggregateComplianceByConformancePacks(v []*AggregateComplianceByConformancePack) *DescribeAggregateComplianceByConformancePacksOutput {
	s.AggregateComplianceByConformancePacks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConformancePacksOutput) SetNextToken(v string) *DescribeAggregateComplianceByConformancePacksOutput {
	s.NextToken = &v
	return s
}

type DescribeAggregationAuthorizationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of AggregationAuthorizations returned on each page. The
	// default is maximum. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregationAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregationAuthorizationsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeAggregationAuthorizationsInput) SetLimit(v int64) *DescribeAggregationAuthorizationsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregationAuthorizationsInput) SetNextToken(v string) *DescribeAggregationAuthorizationsInput {
	s.NextToken = &v
	return s
}

type DescribeAggregationAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of authorizations granted to various aggregator accounts and
	// regions.
	AggregationAuthorizations []*AggregationAuthorization `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregationAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAggregationAuthorizationsOutput) GoString() string {
	return s.String()
}

// SetAggregationAuthorizations sets the AggregationAuthorizations field's value.
func (s *DescribeAggregationAuthorizationsOutput) SetAggregationAuthorizations(v []*AggregationAuthorization) *DescribeAggregationAuthorizationsOutput {
	s.AggregationAuthorizations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregationAuthorizationsOutput) SetNextToken(v string) *DescribeAggregationAuthorizationsOutput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT and NON_COMPLIANT.
	ComplianceTypes []*string `type:"list" enum:"ComplianceType"`

	// Specify one or more Config rule names to filter the results by rule.
	ConfigRuleNames []*string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComplianceByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComplianceByConfigRuleInput) GoString() string {
	return s.String()
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *DescribeComplianceByConfigRuleInput) SetComplianceTypes(v []*string) *DescribeComplianceByConfigRuleInput {
	s.ComplianceTypes = v
	return s
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeComplianceByConfigRuleInput) SetConfigRuleNames(v []*string) *DescribeComplianceByConfigRuleInput {
	s.ConfigRuleNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByConfigRuleInput) SetNextToken(v string) *DescribeComplianceByConfigRuleInput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether each of the specified Config rules is compliant.
	ComplianceByConfigRules []*ComplianceByConfigRule `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComplianceByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComplianceByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetComplianceByConfigRules sets the ComplianceByConfigRules field's value.
func (s *DescribeComplianceByConfigRuleOutput) SetComplianceByConfigRules(v []*ComplianceByConfigRule) *DescribeComplianceByConfigRuleOutput {
	s.ComplianceByConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByConfigRuleOutput) SetNextToken(v string) *DescribeComplianceByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByResourceInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and INSUFFICIENT_DATA.
	ComplianceTypes []*string `type:"list" enum:"ComplianceType"`

	// The maximum number of evaluation results returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, Config
	// uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The ID of the Amazon Web Services resource for which you want compliance
	// information. You can specify only one resource ID. If you specify a resource
	// ID, you must also specify a type for ResourceType.
	ResourceId *string `min:"1" type:"string"`

	// The types of Amazon Web Services resources for which you want compliance
	// information (for example, AWS::EC2::Instance). For this action, you can specify
	// that the resource type is an Amazon Web Services account by specifying AWS::::Account.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComplianceByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComplianceByResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComplianceByResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComplianceByResourceInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *DescribeComplianceByResourceInput) SetComplianceTypes(v []*string) *DescribeComplianceByResourceInput {
	s.ComplianceTypes = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeComplianceByResourceInput) SetLimit(v int64) *DescribeComplianceByResourceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByResourceInput) SetNextToken(v string) *DescribeComplianceByResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeComplianceByResourceInput) SetResourceId(v string) *DescribeComplianceByResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeComplianceByResourceInput) SetResourceType(v string) *DescribeComplianceByResourceInput {
	s.ResourceType = &v
	return s
}

type DescribeComplianceByResourceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified Amazon Web Services resource complies with
	// all of the Config rules that evaluate it.
	ComplianceByResources []*ComplianceByResource `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComplianceByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComplianceByResourceOutput) GoString() string {
	return s.String()
}

// SetComplianceByResources sets the ComplianceByResources field's value.
func (s *DescribeComplianceByResourceOutput) SetComplianceByResources(v []*ComplianceByResource) *DescribeComplianceByResourceOutput {
	s.ComplianceByResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByResourceOutput) SetNextToken(v string) *DescribeComplianceByResourceOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigRuleEvaluationStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the Config managed rules for which you want status information.
	// If you do not specify any names, Config returns status information for all
	// Config managed rules that you use.
	ConfigRuleNames []*string `type:"list"`

	// The number of rule evaluation results that you want returned.
	//
	// This parameter is required if the rule limit for your account is more than
	// the default of 150 rules.
	//
	// For information about requesting a rule limit increase, see Config Limits
	// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
	// in the Amazon Web Services General Reference Guide.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigRuleEvaluationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigRuleEvaluationStatusInput) GoString() string {
	return s.String()
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetConfigRuleNames(v []*string) *DescribeConfigRuleEvaluationStatusInput {
	s.ConfigRuleNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetLimit(v int64) *DescribeConfigRuleEvaluationStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetNextToken(v string) *DescribeConfigRuleEvaluationStatusInput {
	s.NextToken = &v
	return s
}

type DescribeConfigRuleEvaluationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Status information about your Config managed rules.
	ConfigRulesEvaluationStatus []*ConfigRuleEvaluationStatus `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigRuleEvaluationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigRuleEvaluationStatusOutput) GoString() string {
	return s.String()
}

// SetConfigRulesEvaluationStatus sets the ConfigRulesEvaluationStatus field's value.
func (s *DescribeConfigRuleEvaluationStatusOutput) SetConfigRulesEvaluationStatus(v []*ConfigRuleEvaluationStatus) *DescribeConfigRuleEvaluationStatusOutput {
	s.ConfigRulesEvaluationStatus = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRuleEvaluationStatusOutput) SetNextToken(v string) *DescribeConfigRuleEvaluationStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The names of the Config rules for which you want details. If you do not specify
	// any names, Config returns details for all your rules.
	ConfigRuleNames []*string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigRulesInput) GoString() string {
	return s.String()
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeConfigRulesInput) SetConfigRuleNames(v []*string) *DescribeConfigRulesInput {
	s.ConfigRuleNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRulesInput) SetNextToken(v string) *DescribeConfigRulesInput {
	s.NextToken = &v
	return s
}

type DescribeConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// The details about your Config rules.
	ConfigRules []*ConfigRule `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigRulesOutput) GoString() string {
	return s.String()
}

// SetConfigRules sets the ConfigRules field's value.
func (s *DescribeConfigRulesOutput) SetConfigRules(v []*ConfigRule) *DescribeConfigRulesOutput {
	s.ConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRulesOutput) SetNextToken(v string) *DescribeConfigRulesOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorSourcesStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// The maximum number of AggregatorSourceStatus returned on each page. The default
	// is maximum. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Filters the status type.
	//
	//    * Valid value FAILED indicates errors while moving data.
	//
	//    * Valid value SUCCEEDED indicates the data was successfully moved.
	//
	//    * Valid value OUTDATED indicates the data is not the most recent.
	UpdateStatus []*string `min:"1" type:"list" enum:"AggregatedSourceStatusType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationAggregatorSourcesStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationAggregatorSourcesStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationAggregatorSourcesStatusInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.UpdateStatus != nil && len(s.UpdateStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateStatus", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetConfigurationAggregatorName(v string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetLimit(v int64) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetNextToken(v string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.NextToken = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetUpdateStatus(v []*string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.UpdateStatus = v
	return s
}

type DescribeConfigurationAggregatorSourcesStatusOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregatedSourceStatus object.
	AggregatedSourceStatusList []*AggregatedSourceStatus `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationAggregatorSourcesStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationAggregatorSourcesStatusOutput) GoString() string {
	return s.String()
}

// SetAggregatedSourceStatusList sets the AggregatedSourceStatusList field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusOutput) SetAggregatedSourceStatusList(v []*AggregatedSourceStatus) *DescribeConfigurationAggregatorSourcesStatusOutput {
	s.AggregatedSourceStatusList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusOutput) SetNextToken(v string) *DescribeConfigurationAggregatorSourcesStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregators.
	ConfigurationAggregatorNames []*string `type:"list"`

	// The maximum number of configuration aggregators returned on each page. The
	// default is maximum. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationAggregatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationAggregatorsInput) GoString() string {
	return s.String()
}

// SetConfigurationAggregatorNames sets the ConfigurationAggregatorNames field's value.
func (s *DescribeConfigurationAggregatorsInput) SetConfigurationAggregatorNames(v []*string) *DescribeConfigurationAggregatorsInput {
	s.ConfigurationAggregatorNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigurationAggregatorsInput) SetLimit(v int64) *DescribeConfigurationAggregatorsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorsInput) SetNextToken(v string) *DescribeConfigurationAggregatorsInput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a ConfigurationAggregators object.
	ConfigurationAggregators []*ConfigurationAggregator `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationAggregatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationAggregatorsOutput) GoString() string {
	return s.String()
}

// SetConfigurationAggregators sets the ConfigurationAggregators field's value.
func (s *DescribeConfigurationAggregatorsOutput) SetConfigurationAggregators(v []*ConfigurationAggregator) *DescribeConfigurationAggregatorsOutput {
	s.ConfigurationAggregators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorsOutput) SetNextToken(v string) *DescribeConfigurationAggregatorsOutput {
	s.NextToken = &v
	return s
}

// The input for the DescribeConfigurationRecorderStatus action.
type DescribeConfigurationRecorderStatusInput struct {
	_ struct{} `type:"structure"`

	// The name(s) of the configuration recorder. If the name is not specified,
	// the action returns the current status of all the configuration recorders
	// associated with the account.
	ConfigurationRecorderNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRecorderStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRecorderStatusInput) GoString() string {
	return s.String()
}

// SetConfigurationRecorderNames sets the ConfigurationRecorderNames field's value.
func (s *DescribeConfigurationRecorderStatusInput) SetConfigurationRecorderNames(v []*string) *DescribeConfigurationRecorderStatusInput {
	s.ConfigurationRecorderNames = v
	return s
}

// The output for the DescribeConfigurationRecorderStatus action, in JSON format.
type DescribeConfigurationRecorderStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains status of the specified recorders.
	ConfigurationRecordersStatus []*ConfigurationRecorderStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRecorderStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRecorderStatusOutput) GoString() string {
	return s.String()
}

// SetConfigurationRecordersStatus sets the ConfigurationRecordersStatus field's value.
func (s *DescribeConfigurationRecorderStatusOutput) SetConfigurationRecordersStatus(v []*ConfigurationRecorderStatus) *DescribeConfigurationRecorderStatusOutput {
	s.ConfigurationRecordersStatus = v
	return s
}

// The input for the DescribeConfigurationRecorders action.
type DescribeConfigurationRecordersInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration recorder names.
	ConfigurationRecorderNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRecordersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRecordersInput) GoString() string {
	return s.String()
}

// SetConfigurationRecorderNames sets the ConfigurationRecorderNames field's value.
func (s *DescribeConfigurationRecordersInput) SetConfigurationRecorderNames(v []*string) *DescribeConfigurationRecordersInput {
	s.ConfigurationRecorderNames = v
	return s
}

// The output for the DescribeConfigurationRecorders action.
type DescribeConfigurationRecordersOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the descriptions of the specified configuration recorders.
	ConfigurationRecorders []*ConfigurationRecorder `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRecordersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConfigurationRecordersOutput) GoString() string {
	return s.String()
}

// SetConfigurationRecorders sets the ConfigurationRecorders field's value.
func (s *DescribeConfigurationRecordersOutput) SetConfigurationRecorders(v []*ConfigurationRecorder) *DescribeConfigurationRecordersOutput {
	s.ConfigurationRecorders = v
	return s
}

type DescribeConformancePackComplianceInput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// A ConformancePackComplianceFilters object.
	Filters *ConformancePackComplianceFilters `type:"structure"`

	// The maximum number of Config rules within a conformance pack are returned
	// on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePackComplianceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePackComplianceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConformancePackComplianceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConformancePackComplianceInput"}
	if s.ConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *DescribeConformancePackComplianceInput) SetConformancePackName(v string) *DescribeConformancePackComplianceInput {
	s.ConformancePackName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeConformancePackComplianceInput) SetFilters(v *ConformancePackComplianceFilters) *DescribeConformancePackComplianceInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConformancePackComplianceInput) SetLimit(v int64) *DescribeConformancePackComplianceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePackComplianceInput) SetNextToken(v string) *DescribeConformancePackComplianceInput {
	s.NextToken = &v
	return s
}

type DescribeConformancePackComplianceOutput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Returns a list of ConformancePackRuleCompliance objects.
	//
	// ConformancePackRuleComplianceList is a required field
	ConformancePackRuleComplianceList []*ConformancePackRuleCompliance `type:"list" required:"true"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePackComplianceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePackComplianceOutput) GoString() string {
	return s.String()
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *DescribeConformancePackComplianceOutput) SetConformancePackName(v string) *DescribeConformancePackComplianceOutput {
	s.ConformancePackName = &v
	return s
}

// SetConformancePackRuleComplianceList sets the ConformancePackRuleComplianceList field's value.
func (s *DescribeConformancePackComplianceOutput) SetConformancePackRuleComplianceList(v []*ConformancePackRuleCompliance) *DescribeConformancePackComplianceOutput {
	s.ConformancePackRuleComplianceList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePackComplianceOutput) SetNextToken(v string) *DescribeConformancePackComplianceOutput {
	s.NextToken = &v
	return s
}

type DescribeConformancePackStatusInput struct {
	_ struct{} `type:"structure"`

	// Comma-separated list of conformance pack names.
	ConformancePackNames []*string `type:"list"`

	// The maximum number of conformance packs status returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePackStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePackStatusInput) GoString() string {
	return s.String()
}

// SetConformancePackNames sets the ConformancePackNames field's value.
func (s *DescribeConformancePackStatusInput) SetConformancePackNames(v []*string) *DescribeConformancePackStatusInput {
	s.ConformancePackNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConformancePackStatusInput) SetLimit(v int64) *DescribeConformancePackStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePackStatusInput) SetNextToken(v string) *DescribeConformancePackStatusInput {
	s.NextToken = &v
	return s
}

type DescribeConformancePackStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackStatusDetail objects.
	ConformancePackStatusDetails []*ConformancePackStatusDetail `type:"list"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePackStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePackStatusOutput) GoString() string {
	return s.String()
}

// SetConformancePackStatusDetails sets the ConformancePackStatusDetails field's value.
func (s *DescribeConformancePackStatusOutput) SetConformancePackStatusDetails(v []*ConformancePackStatusDetail) *DescribeConformancePackStatusOutput {
	s.ConformancePackStatusDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePackStatusOutput) SetNextToken(v string) *DescribeConformancePackStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeConformancePacksInput struct {
	_ struct{} `type:"structure"`

	// Comma-separated list of conformance pack names for which you want details.
	// If you do not specify any names, Config returns details for all your conformance
	// packs.
	ConformancePackNames []*string `type:"list"`

	// The maximum number of conformance packs returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePacksInput) GoString() string {
	return s.String()
}

// SetConformancePackNames sets the ConformancePackNames field's value.
func (s *DescribeConformancePacksInput) SetConformancePackNames(v []*string) *DescribeConformancePacksInput {
	s.ConformancePackNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConformancePacksInput) SetLimit(v int64) *DescribeConformancePacksInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePacksInput) SetNextToken(v string) *DescribeConformancePacksInput {
	s.NextToken = &v
	return s
}

type DescribeConformancePacksOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of ConformancePackDetail objects.
	ConformancePackDetails []*ConformancePackDetail `type:"list"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConformancePacksOutput) GoString() string {
	return s.String()
}

// SetConformancePackDetails sets the ConformancePackDetails field's value.
func (s *DescribeConformancePacksOutput) SetConformancePackDetails(v []*ConformancePackDetail) *DescribeConformancePacksOutput {
	s.ConformancePackDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConformancePacksOutput) SetNextToken(v string) *DescribeConformancePacksOutput {
	s.NextToken = &v
	return s
}

// The input for the DeliveryChannelStatus action.
type DescribeDeliveryChannelStatusInput struct {
	_ struct{} `type:"structure"`

	// A list of delivery channel names.
	DeliveryChannelNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryChannelStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryChannelStatusInput) GoString() string {
	return s.String()
}

// SetDeliveryChannelNames sets the DeliveryChannelNames field's value.
func (s *DescribeDeliveryChannelStatusInput) SetDeliveryChannelNames(v []*string) *DescribeDeliveryChannelStatusInput {
	s.DeliveryChannelNames = v
	return s
}

// The output for the DescribeDeliveryChannelStatus action.
type DescribeDeliveryChannelStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of a specified delivery channel.
	DeliveryChannelsStatus []*DeliveryChannelStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryChannelStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryChannelStatusOutput) GoString() string {
	return s.String()
}

// SetDeliveryChannelsStatus sets the DeliveryChannelsStatus field's value.
func (s *DescribeDeliveryChannelStatusOutput) SetDeliveryChannelsStatus(v []*DeliveryChannelStatus) *DescribeDeliveryChannelStatusOutput {
	s.DeliveryChannelsStatus = v
	return s
}

// The input for the DescribeDeliveryChannels action.
type DescribeDeliveryChannelsInput struct {
	_ struct{} `type:"structure"`

	// A list of delivery channel names.
	DeliveryChannelNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryChannelsInput) GoString() string {
	return s.String()
}

// SetDeliveryChannelNames sets the DeliveryChannelNames field's value.
func (s *DescribeDeliveryChannelsInput) SetDeliveryChannelNames(v []*string) *DescribeDeliveryChannelsInput {
	s.DeliveryChannelNames = v
	return s
}

// The output for the DescribeDeliveryChannels action.
type DescribeDeliveryChannelsOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the descriptions of the specified delivery channel.
	DeliveryChannels []*DeliveryChannel `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryChannelsOutput) GoString() string {
	return s.String()
}

// SetDeliveryChannels sets the DeliveryChannels field's value.
func (s *DescribeDeliveryChannelsOutput) SetDeliveryChannels(v []*DeliveryChannel) *DescribeDeliveryChannelsOutput {
	s.DeliveryChannels = v
	return s
}

type DescribeOrganizationConfigRuleStatusesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of OrganizationConfigRuleStatuses returned on each page.
	// If you do no specify a number, Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The names of organization Config rules for which you want status details.
	// If you do not specify any names, Config returns details for all your organization
	// Config rules.
	OrganizationConfigRuleNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigRuleStatusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigRuleStatusesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeOrganizationConfigRuleStatusesInput) SetLimit(v int64) *DescribeOrganizationConfigRuleStatusesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConfigRuleStatusesInput) SetNextToken(v string) *DescribeOrganizationConfigRuleStatusesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleNames sets the OrganizationConfigRuleNames field's value.
func (s *DescribeOrganizationConfigRuleStatusesInput) SetOrganizationConfigRuleNames(v []*string) *DescribeOrganizationConfigRuleStatusesInput {
	s.OrganizationConfigRuleNames = v
	return s
}

type DescribeOrganizationConfigRuleStatusesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of OrganizationConfigRuleStatus objects.
	OrganizationConfigRuleStatuses []*OrganizationConfigRuleStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigRuleStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigRuleStatusesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConfigRuleStatusesOutput) SetNextToken(v string) *DescribeOrganizationConfigRuleStatusesOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleStatuses sets the OrganizationConfigRuleStatuses field's value.
func (s *DescribeOrganizationConfigRuleStatusesOutput) SetOrganizationConfigRuleStatuses(v []*OrganizationConfigRuleStatus) *DescribeOrganizationConfigRuleStatusesOutput {
	s.OrganizationConfigRuleStatuses = v
	return s
}

type DescribeOrganizationConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of organization Config rules returned on each page. If
	// you do no specify a number, Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The names of organization Config rules for which you want details. If you
	// do not specify any names, Config returns details for all your organization
	// Config rules.
	OrganizationConfigRuleNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigRulesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeOrganizationConfigRulesInput) SetLimit(v int64) *DescribeOrganizationConfigRulesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConfigRulesInput) SetNextToken(v string) *DescribeOrganizationConfigRulesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleNames sets the OrganizationConfigRuleNames field's value.
func (s *DescribeOrganizationConfigRulesInput) SetOrganizationConfigRuleNames(v []*string) *DescribeOrganizationConfigRulesInput {
	s.OrganizationConfigRuleNames = v
	return s
}

type DescribeOrganizationConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of OrganizationConfigRule objects.
	OrganizationConfigRules []*OrganizationConfigRule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConfigRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConfigRulesOutput) SetNextToken(v string) *DescribeOrganizationConfigRulesOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRules sets the OrganizationConfigRules field's value.
func (s *DescribeOrganizationConfigRulesOutput) SetOrganizationConfigRules(v []*OrganizationConfigRule) *DescribeOrganizationConfigRulesOutput {
	s.OrganizationConfigRules = v
	return s
}

type DescribeOrganizationConformancePackStatusesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of OrganizationConformancePackStatuses returned on each
	// page. If you do no specify a number, Config uses the default. The default
	// is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The names of organization conformance packs for which you want status details.
	// If you do not specify any names, Config returns details for all your organization
	// conformance packs.
	OrganizationConformancePackNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConformancePackStatusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConformancePackStatusesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeOrganizationConformancePackStatusesInput) SetLimit(v int64) *DescribeOrganizationConformancePackStatusesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConformancePackStatusesInput) SetNextToken(v string) *DescribeOrganizationConformancePackStatusesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackNames sets the OrganizationConformancePackNames field's value.
func (s *DescribeOrganizationConformancePackStatusesInput) SetOrganizationConformancePackNames(v []*string) *DescribeOrganizationConformancePackStatusesInput {
	s.OrganizationConformancePackNames = v
	return s
}

type DescribeOrganizationConformancePackStatusesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of OrganizationConformancePackStatus objects.
	OrganizationConformancePackStatuses []*OrganizationConformancePackStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConformancePackStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConformancePackStatusesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConformancePackStatusesOutput) SetNextToken(v string) *DescribeOrganizationConformancePackStatusesOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackStatuses sets the OrganizationConformancePackStatuses field's value.
func (s *DescribeOrganizationConformancePackStatusesOutput) SetOrganizationConformancePackStatuses(v []*OrganizationConformancePackStatus) *DescribeOrganizationConformancePackStatusesOutput {
	s.OrganizationConformancePackStatuses = v
	return s
}

type DescribeOrganizationConformancePacksInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of organization config packs returned on each page. If
	// you do no specify a number, Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The name that you assign to an organization conformance pack.
	OrganizationConformancePackNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConformancePacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConformancePacksInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeOrganizationConformancePacksInput) SetLimit(v int64) *DescribeOrganizationConformancePacksInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConformancePacksInput) SetNextToken(v string) *DescribeOrganizationConformancePacksInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackNames sets the OrganizationConformancePackNames field's value.
func (s *DescribeOrganizationConformancePacksInput) SetOrganizationConformancePackNames(v []*string) *DescribeOrganizationConformancePacksInput {
	s.OrganizationConformancePackNames = v
	return s
}

type DescribeOrganizationConformancePacksOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of OrganizationConformancePacks objects.
	OrganizationConformancePacks []*OrganizationConformancePack `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConformancePacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOrganizationConformancePacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeOrganizationConformancePacksOutput) SetNextToken(v string) *DescribeOrganizationConformancePacksOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePacks sets the OrganizationConformancePacks field's value.
func (s *DescribeOrganizationConformancePacksOutput) SetOrganizationConformancePacks(v []*OrganizationConformancePack) *DescribeOrganizationConformancePacksOutput {
	s.OrganizationConformancePacks = v
	return s
}

type DescribePendingAggregationRequestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of evaluation results returned on each page. The default
	// is maximum. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePendingAggregationRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePendingAggregationRequestsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribePendingAggregationRequestsInput) SetLimit(v int64) *DescribePendingAggregationRequestsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePendingAggregationRequestsInput) SetNextToken(v string) *DescribePendingAggregationRequestsInput {
	s.NextToken = &v
	return s
}

type DescribePendingAggregationRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a PendingAggregationRequests object.
	PendingAggregationRequests []*PendingAggregationRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePendingAggregationRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePendingAggregationRequestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePendingAggregationRequestsOutput) SetNextToken(v string) *DescribePendingAggregationRequestsOutput {
	s.NextToken = &v
	return s
}

// SetPendingAggregationRequests sets the PendingAggregationRequests field's value.
func (s *DescribePendingAggregationRequestsOutput) SetPendingAggregationRequests(v []*PendingAggregationRequest) *DescribePendingAggregationRequestsOutput {
	s.PendingAggregationRequests = v
	return s
}

type DescribeRemediationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// A list of Config rule names of remediation configurations for which you want
	// details.
	//
	// ConfigRuleNames is a required field
	ConfigRuleNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRemediationConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRemediationConfigurationsInput"}
	if s.ConfigRuleNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeRemediationConfigurationsInput) SetConfigRuleNames(v []*string) *DescribeRemediationConfigurationsInput {
	s.ConfigRuleNames = v
	return s
}

type DescribeRemediationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a remediation configuration object.
	RemediationConfigurations []*RemediationConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationConfigurationsOutput) GoString() string {
	return s.String()
}

// SetRemediationConfigurations sets the RemediationConfigurations field's value.
func (s *DescribeRemediationConfigurationsOutput) SetRemediationConfigurations(v []*RemediationConfiguration) *DescribeRemediationConfigurationsOutput {
	s.RemediationConfigurations = v
	return s
}

type DescribeRemediationExceptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Config rule.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The maximum number of RemediationExceptionResourceKey returned on each page.
	// The default is 25. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`

	// An exception list of resource exception keys to be processed with the current
	// request. Config adds exception for each resource key. For example, Config
	// adds 3 exceptions for 3 resource keys.
	ResourceKeys []*RemediationExceptionResourceKey `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationExceptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationExceptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRemediationExceptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRemediationExceptionsInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DescribeRemediationExceptionsInput) SetConfigRuleName(v string) *DescribeRemediationExceptionsInput {
	s.ConfigRuleName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeRemediationExceptionsInput) SetLimit(v int64) *DescribeRemediationExceptionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRemediationExceptionsInput) SetNextToken(v string) *DescribeRemediationExceptionsInput {
	s.NextToken = &v
	return s
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *DescribeRemediationExceptionsInput) SetResourceKeys(v []*RemediationExceptionResourceKey) *DescribeRemediationExceptionsInput {
	s.ResourceKeys = v
	return s
}

type DescribeRemediationExceptionsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of remediation exception objects.
	RemediationExceptions []*RemediationException `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationExceptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationExceptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRemediationExceptionsOutput) SetNextToken(v string) *DescribeRemediationExceptionsOutput {
	s.NextToken = &v
	return s
}

// SetRemediationExceptions sets the RemediationExceptions field's value.
func (s *DescribeRemediationExceptionsOutput) SetRemediationExceptions(v []*RemediationException) *DescribeRemediationExceptionsOutput {
	s.RemediationExceptions = v
	return s
}

type DescribeRemediationExecutionStatusInput struct {
	_ struct{} `type:"structure"`

	// A list of Config rule names.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The maximum number of RemediationExecutionStatuses returned on each page.
	// The default is maximum. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of resource keys to be processed with the current request. Each element
	// in the list consists of the resource type and resource ID.
	ResourceKeys []*ResourceKey `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationExecutionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationExecutionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRemediationExecutionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRemediationExecutionStatusInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DescribeRemediationExecutionStatusInput) SetConfigRuleName(v string) *DescribeRemediationExecutionStatusInput {
	s.ConfigRuleName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeRemediationExecutionStatusInput) SetLimit(v int64) *DescribeRemediationExecutionStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRemediationExecutionStatusInput) SetNextToken(v string) *DescribeRemediationExecutionStatusInput {
	s.NextToken = &v
	return s
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *DescribeRemediationExecutionStatusInput) SetResourceKeys(v []*ResourceKey) *DescribeRemediationExecutionStatusInput {
	s.ResourceKeys = v
	return s
}

type DescribeRemediationExecutionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of remediation execution statuses objects.
	RemediationExecutionStatuses []*RemediationExecutionStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationExecutionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRemediationExecutionStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRemediationExecutionStatusOutput) SetNextToken(v string) *DescribeRemediationExecutionStatusOutput {
	s.NextToken = &v
	return s
}

// SetRemediationExecutionStatuses sets the RemediationExecutionStatuses field's value.
func (s *DescribeRemediationExecutionStatusOutput) SetRemediationExecutionStatuses(v []*RemediationExecutionStatus) *DescribeRemediationExecutionStatusOutput {
	s.RemediationExecutionStatuses = v
	return s
}

type DescribeRetentionConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of names of retention configurations for which you want details. If
	// you do not specify a name, Config returns details for all the retention configurations
	// for that account.
	//
	// Currently, Config supports only one retention configuration per region in
	// your account.
	RetentionConfigurationNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRetentionConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRetentionConfigurationsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRetentionConfigurationsInput) SetNextToken(v string) *DescribeRetentionConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetRetentionConfigurationNames sets the RetentionConfigurationNames field's value.
func (s *DescribeRetentionConfigurationsInput) SetRetentionConfigurationNames(v []*string) *DescribeRetentionConfigurationsInput {
	s.RetentionConfigurationNames = v
	return s
}

type DescribeRetentionConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a retention configuration object.
	RetentionConfigurations []*RetentionConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRetentionConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRetentionConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRetentionConfigurationsOutput) SetNextToken(v string) *DescribeRetentionConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetRetentionConfigurations sets the RetentionConfigurations field's value.
func (s *DescribeRetentionConfigurationsOutput) SetRetentionConfigurations(v []*RetentionConfiguration) *DescribeRetentionConfigurationsOutput {
	s.RetentionConfigurations = v
	return s
}

// Identifies an Amazon Web Services resource and indicates whether it complies
// with the Config rule that it was evaluated against.
type Evaluation struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `min:"1" type:"string"`

	// The ID of the Amazon Web Services resource that was evaluated.
	//
	// ComplianceResourceId is a required field
	ComplianceResourceId *string `min:"1" type:"string" required:"true"`

	// The type of Amazon Web Services resource that was evaluated.
	//
	// ComplianceResourceType is a required field
	ComplianceResourceType *string `min:"1" type:"string" required:"true"`

	// Indicates whether the Amazon Web Services resource complies with the Config
	// rule that it was evaluated against.
	//
	// For the Evaluation data type, Config supports only the COMPLIANT, NON_COMPLIANT,
	// and NOT_APPLICABLE values. Config does not support the INSUFFICIENT_DATA
	// value for this data type.
	//
	// Similarly, Config does not accept INSUFFICIENT_DATA as the value for ComplianceType
	// from a PutEvaluations request. For example, an Lambda function for a custom
	// Config rule cannot pass an INSUFFICIENT_DATA value to Config.
	//
	// ComplianceType is a required field
	ComplianceType *string `type:"string" required:"true" enum:"ComplianceType"`

	// The time of the event in Config that triggered the evaluation. For event-based
	// evaluations, the time indicates when Config created the configuration item
	// that triggered the evaluation. For periodic evaluations, the time indicates
	// when Config triggered the evaluation at the frequency that you specified
	// (for example, every 24 hours).
	//
	// OrderingTimestamp is a required field
	OrderingTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Evaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Evaluation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Evaluation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Evaluation"}
	if s.Annotation != nil && len(*s.Annotation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Annotation", 1))
	}
	if s.ComplianceResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceId"))
	}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceId", 1))
	}
	if s.ComplianceResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceType"))
	}
	if s.ComplianceResourceType != nil && len(*s.ComplianceResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceType", 1))
	}
	if s.ComplianceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceType"))
	}
	if s.OrderingTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderingTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotation sets the Annotation field's value.
func (s *Evaluation) SetAnnotation(v string) *Evaluation {
	s.Annotation = &v
	return s
}

// SetComplianceResourceId sets the ComplianceResourceId field's value.
func (s *Evaluation) SetComplianceResourceId(v string) *Evaluation {
	s.ComplianceResourceId = &v
	return s
}

// SetComplianceResourceType sets the ComplianceResourceType field's value.
func (s *Evaluation) SetComplianceResourceType(v string) *Evaluation {
	s.ComplianceResourceType = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *Evaluation) SetComplianceType(v string) *Evaluation {
	s.ComplianceType = &v
	return s
}

// SetOrderingTimestamp sets the OrderingTimestamp field's value.
func (s *Evaluation) SetOrderingTimestamp(v time.Time) *Evaluation {
	s.OrderingTimestamp = &v
	return s
}

// The details of an Config evaluation. Provides the Amazon Web Services resource
// that was evaluated, the compliance of the resource, related time stamps,
// and supplementary information.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `min:"1" type:"string"`

	// Indicates whether the Amazon Web Services resource complies with the Config
	// rule that evaluated it.
	//
	// For the EvaluationResult data type, Config supports only the COMPLIANT, NON_COMPLIANT,
	// and NOT_APPLICABLE values. Config does not support the INSUFFICIENT_DATA
	// value for the EvaluationResult data type.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The time when the Config rule evaluated the Amazon Web Services resource.
	ConfigRuleInvokedTime *time.Time `type:"timestamp"`

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure"`

	// The time when Config recorded the evaluation result.
	ResultRecordedTime *time.Time `type:"timestamp"`

	// An encrypted token that associates an evaluation with an Config rule. The
	// token identifies the rule, the Amazon Web Services resource being evaluated,
	// and the event that triggered the evaluation.
	ResultToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetAnnotation sets the Annotation field's value.
func (s *EvaluationResult) SetAnnotation(v string) *EvaluationResult {
	s.Annotation = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *EvaluationResult) SetComplianceType(v string) *EvaluationResult {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleInvokedTime sets the ConfigRuleInvokedTime field's value.
func (s *EvaluationResult) SetConfigRuleInvokedTime(v time.Time) *EvaluationResult {
	s.ConfigRuleInvokedTime = &v
	return s
}

// SetEvaluationResultIdentifier sets the EvaluationResultIdentifier field's value.
func (s *EvaluationResult) SetEvaluationResultIdentifier(v *EvaluationResultIdentifier) *EvaluationResult {
	s.EvaluationResultIdentifier = v
	return s
}

// SetResultRecordedTime sets the ResultRecordedTime field's value.
func (s *EvaluationResult) SetResultRecordedTime(v time.Time) *EvaluationResult {
	s.ResultRecordedTime = &v
	return s
}

// SetResultToken sets the ResultToken field's value.
func (s *EvaluationResult) SetResultToken(v string) *EvaluationResult {
	s.ResultToken = &v
	return s
}

// Uniquely identifies an evaluation result.
type EvaluationResultIdentifier struct {
	_ struct{} `type:"structure"`

	// Identifies an Config rule used to evaluate an Amazon Web Services resource,
	// and provides the type and ID of the evaluated resource.
	EvaluationResultQualifier *EvaluationResultQualifier `type:"structure"`

	// The time of the event that triggered the evaluation of your Amazon Web Services
	// resources. The time can indicate when Config delivered a configuration item
	// change notification, or it can indicate when Config delivered the configuration
	// snapshot, depending on which event triggered the evaluation.
	OrderingTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResultIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResultIdentifier) GoString() string {
	return s.String()
}

// SetEvaluationResultQualifier sets the EvaluationResultQualifier field's value.
func (s *EvaluationResultIdentifier) SetEvaluationResultQualifier(v *EvaluationResultQualifier) *EvaluationResultIdentifier {
	s.EvaluationResultQualifier = v
	return s
}

// SetOrderingTimestamp sets the OrderingTimestamp field's value.
func (s *EvaluationResultIdentifier) SetOrderingTimestamp(v time.Time) *EvaluationResultIdentifier {
	s.OrderingTimestamp = &v
	return s
}

// Identifies an Config rule that evaluated an Amazon Web Services resource,
// and provides the type and ID of the resource that the rule evaluated.
type EvaluationResultQualifier struct {
	_ struct{} `type:"structure"`

	// The name of the Config rule that was used in the evaluation.
	ConfigRuleName *string `min:"1" type:"string"`

	// The ID of the evaluated Amazon Web Services resource.
	ResourceId *string `min:"1" type:"string"`

	// The type of Amazon Web Services resource that was evaluated.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResultQualifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResultQualifier) GoString() string {
	return s.String()
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *EvaluationResultQualifier) SetConfigRuleName(v string) *EvaluationResultQualifier {
	s.ConfigRuleName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *EvaluationResultQualifier) SetResourceId(v string) *EvaluationResultQualifier {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *EvaluationResultQualifier) SetResourceType(v string) *EvaluationResultQualifier {
	s.ResourceType = &v
	return s
}

// The controls that Config uses for executing remediations.
type ExecutionControls struct {
	_ struct{} `type:"structure"`

	// A SsmControls object.
	SsmControls *SsmControls `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionControls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionControls) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutionControls) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutionControls"}
	if s.SsmControls != nil {
		if err := s.SsmControls.Validate(); err != nil {
			invalidParams.AddNested("SsmControls", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSsmControls sets the SsmControls field's value.
func (s *ExecutionControls) SetSsmControls(v *SsmControls) *ExecutionControls {
	s.SsmControls = v
	return s
}

// Identifies an Amazon Web Services resource and indicates whether it complies
// with the Config rule that it was evaluated against.
type ExternalEvaluation struct {
	_ struct{} `type:"structure"`

	// Supplementary information about the reason of compliance. For example, this
	// task was completed on a specific date.
	Annotation *string `min:"1" type:"string"`

	// The evaluated compliance resource ID. Config accepts only Amazon Web Services
	// account ID.
	//
	// ComplianceResourceId is a required field
	ComplianceResourceId *string `min:"1" type:"string" required:"true"`

	// The evaluated compliance resource type. Config accepts AWS::::Account resource
	// type.
	//
	// ComplianceResourceType is a required field
	ComplianceResourceType *string `min:"1" type:"string" required:"true"`

	// The compliance of the Amazon Web Services resource. The valid values are
	// COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE.
	//
	// ComplianceType is a required field
	ComplianceType *string `type:"string" required:"true" enum:"ComplianceType"`

	// The time when the compliance was recorded.
	//
	// OrderingTimestamp is a required field
	OrderingTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalEvaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalEvaluation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalEvaluation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalEvaluation"}
	if s.Annotation != nil && len(*s.Annotation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Annotation", 1))
	}
	if s.ComplianceResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceId"))
	}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceId", 1))
	}
	if s.ComplianceResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceType"))
	}
	if s.ComplianceResourceType != nil && len(*s.ComplianceResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceType", 1))
	}
	if s.ComplianceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceType"))
	}
	if s.OrderingTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderingTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotation sets the Annotation field's value.
func (s *ExternalEvaluation) SetAnnotation(v string) *ExternalEvaluation {
	s.Annotation = &v
	return s
}

// SetComplianceResourceId sets the ComplianceResourceId field's value.
func (s *ExternalEvaluation) SetComplianceResourceId(v string) *ExternalEvaluation {
	s.ComplianceResourceId = &v
	return s
}

// SetComplianceResourceType sets the ComplianceResourceType field's value.
func (s *ExternalEvaluation) SetComplianceResourceType(v string) *ExternalEvaluation {
	s.ComplianceResourceType = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ExternalEvaluation) SetComplianceType(v string) *ExternalEvaluation {
	s.ComplianceType = &v
	return s
}

// SetOrderingTimestamp sets the OrderingTimestamp field's value.
func (s *ExternalEvaluation) SetOrderingTimestamp(v time.Time) *ExternalEvaluation {
	s.OrderingTimestamp = &v
	return s
}

// List of each of the failed delete remediation exceptions with specific reasons.
type FailedDeleteRemediationExceptionsBatch struct {
	_ struct{} `type:"structure"`

	// Returns remediation exception resource key object of the failed items.
	FailedItems []*RemediationExceptionResourceKey `min:"1" type:"list"`

	// Returns a failure message for delete remediation exception. For example,
	// Config creates an exception due to an internal error.
	FailureMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedDeleteRemediationExceptionsBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedDeleteRemediationExceptionsBatch) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *FailedDeleteRemediationExceptionsBatch) SetFailedItems(v []*RemediationExceptionResourceKey) *FailedDeleteRemediationExceptionsBatch {
	s.FailedItems = v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *FailedDeleteRemediationExceptionsBatch) SetFailureMessage(v string) *FailedDeleteRemediationExceptionsBatch {
	s.FailureMessage = &v
	return s
}

// List of each of the failed remediations with specific reasons.
type FailedRemediationBatch struct {
	_ struct{} `type:"structure"`

	// Returns remediation configurations of the failed items.
	FailedItems []*RemediationConfiguration `type:"list"`

	// Returns a failure message. For example, the resource is already compliant.
	FailureMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedRemediationBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedRemediationBatch) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *FailedRemediationBatch) SetFailedItems(v []*RemediationConfiguration) *FailedRemediationBatch {
	s.FailedItems = v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *FailedRemediationBatch) SetFailureMessage(v string) *FailedRemediationBatch {
	s.FailureMessage = &v
	return s
}

// List of each of the failed remediation exceptions with specific reasons.
type FailedRemediationExceptionBatch struct {
	_ struct{} `type:"structure"`

	// Returns remediation exception resource key object of the failed items.
	FailedItems []*RemediationException `type:"list"`

	// Returns a failure message. For example, the auto-remediation has failed.
	FailureMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedRemediationExceptionBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedRemediationExceptionBatch) GoString() string {
	return s.String()
}

// SetFailedItems sets the FailedItems field's value.
func (s *FailedRemediationExceptionBatch) SetFailedItems(v []*RemediationException) *FailedRemediationExceptionBatch {
	s.FailedItems = v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *FailedRemediationExceptionBatch) SetFailureMessage(v string) *FailedRemediationExceptionBatch {
	s.FailureMessage = &v
	return s
}

// Details about the fields such as name of the field.
type FieldInfo struct {
	_ struct{} `type:"structure"`

	// Name of the field.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldInfo) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FieldInfo) SetName(v string) *FieldInfo {
	s.Name = &v
	return s
}

type GetAggregateComplianceDetailsByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The source region from where the data is aggregated.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// The resource compliance status.
	//
	// For the GetAggregateComplianceDetailsByConfigRuleRequest data type, Config
	// supports only the COMPLIANT and NON_COMPLIANT. Config does not support the
	// NOT_APPLICABLE and INSUFFICIENT_DATA values.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The name of the Config rule for which you want compliance information.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// The maximum number of evaluation results returned on each page. The default
	// is 50. You cannot specify a number greater than 100. If you specify 0, Config
	// uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateComplianceDetailsByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateComplianceDetailsByConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateComplianceDetailsByConfigRuleInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetAccountId(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetAwsRegion(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetComplianceType(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetConfigRuleName(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetConfigurationAggregatorName(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetLimit(v int64) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetNextToken(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.NextToken = &v
	return s
}

type GetAggregateComplianceDetailsByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregateEvaluationResults object.
	AggregateEvaluationResults []*AggregateEvaluationResult `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateComplianceDetailsByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateComplianceDetailsByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetAggregateEvaluationResults sets the AggregateEvaluationResults field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleOutput) SetAggregateEvaluationResults(v []*AggregateEvaluationResult) *GetAggregateComplianceDetailsByConfigRuleOutput {
	s.AggregateEvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleOutput) SetNextToken(v string) *GetAggregateComplianceDetailsByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type GetAggregateConfigRuleComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ConfigRuleComplianceSummaryFilters object.
	Filters *ConfigRuleComplianceSummaryFilters `type:"structure"`

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey *string `type:"string" enum:"ConfigRuleComplianceSummaryGroupKey"`

	// The maximum number of evaluation results returned on each page. The default
	// is 1000. You cannot specify a number greater than 1000. If you specify 0,
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateConfigRuleComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateConfigRuleComplianceSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateConfigRuleComplianceSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateConfigRuleComplianceSummaryInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetConfigurationAggregatorName(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetFilters(v *ConfigRuleComplianceSummaryFilters) *GetAggregateConfigRuleComplianceSummaryInput {
	s.Filters = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetGroupByKey(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.GroupByKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetLimit(v int64) *GetAggregateConfigRuleComplianceSummaryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetNextToken(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.NextToken = &v
	return s
}

type GetAggregateConfigRuleComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateComplianceCounts object.
	AggregateComplianceCounts []*AggregateComplianceCount `type:"list"`

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey *string `min:"1" type:"string"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateConfigRuleComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateConfigRuleComplianceSummaryOutput) GoString() string {
	return s.String()
}

// SetAggregateComplianceCounts sets the AggregateComplianceCounts field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetAggregateComplianceCounts(v []*AggregateComplianceCount) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.AggregateComplianceCounts = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetGroupByKey(v string) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.GroupByKey = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetNextToken(v string) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.NextToken = &v
	return s
}

type GetAggregateConformancePackComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the AggregateConformancePackComplianceSummaryFilters
	// object.
	Filters *AggregateConformancePackComplianceSummaryFilters `type:"structure"`

	// Groups the result based on Amazon Web Services account ID or Amazon Web Services
	// Region.
	GroupByKey *string `type:"string" enum:"AggregateConformancePackComplianceSummaryGroupKey"`

	// The maximum number of results returned on each page. The default is maximum.
	// If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateConformancePackComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateConformancePackComplianceSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateConformancePackComplianceSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateConformancePackComplianceSummaryInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetConfigurationAggregatorName(v string) *GetAggregateConformancePackComplianceSummaryInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetFilters(v *AggregateConformancePackComplianceSummaryFilters) *GetAggregateConformancePackComplianceSummaryInput {
	s.Filters = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetGroupByKey(v string) *GetAggregateConformancePackComplianceSummaryInput {
	s.GroupByKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetLimit(v int64) *GetAggregateConformancePackComplianceSummaryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConformancePackComplianceSummaryInput) SetNextToken(v string) *GetAggregateConformancePackComplianceSummaryInput {
	s.NextToken = &v
	return s
}

type GetAggregateConformancePackComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateConformancePackComplianceSummary object.
	AggregateConformancePackComplianceSummaries []*AggregateConformancePackComplianceSummary `type:"list"`

	// Groups the result based on Amazon Web Services account ID or Amazon Web Services
	// Region.
	GroupByKey *string `min:"1" type:"string"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateConformancePackComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateConformancePackComplianceSummaryOutput) GoString() string {
	return s.String()
}

// SetAggregateConformancePackComplianceSummaries sets the AggregateConformancePackComplianceSummaries field's value.
func (s *GetAggregateConformancePackComplianceSummaryOutput) SetAggregateConformancePackComplianceSummaries(v []*AggregateConformancePackComplianceSummary) *GetAggregateConformancePackComplianceSummaryOutput {
	s.AggregateConformancePackComplianceSummaries = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConformancePackComplianceSummaryOutput) SetGroupByKey(v string) *GetAggregateConformancePackComplianceSummaryOutput {
	s.GroupByKey = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConformancePackComplianceSummaryOutput) SetNextToken(v string) *GetAggregateConformancePackComplianceSummaryOutput {
	s.NextToken = &v
	return s
}

type GetAggregateDiscoveredResourceCountsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ResourceCountFilters object.
	Filters *ResourceCountFilters `type:"structure"`

	// The key to group the resource counts.
	GroupByKey *string `type:"string" enum:"ResourceCountGroupKey"`

	// The maximum number of GroupedResourceCount objects returned on each page.
	// The default is 1000. You cannot specify a number greater than 1000. If you
	// specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateDiscoveredResourceCountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateDiscoveredResourceCountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateDiscoveredResourceCountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateDiscoveredResourceCountsInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetConfigurationAggregatorName(v string) *GetAggregateDiscoveredResourceCountsInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetFilters(v *ResourceCountFilters) *GetAggregateDiscoveredResourceCountsInput {
	s.Filters = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetGroupByKey(v string) *GetAggregateDiscoveredResourceCountsInput {
	s.GroupByKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetLimit(v int64) *GetAggregateDiscoveredResourceCountsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateDiscoveredResourceCountsInput) SetNextToken(v string) *GetAggregateDiscoveredResourceCountsInput {
	s.NextToken = &v
	return s
}

type GetAggregateDiscoveredResourceCountsOutput struct {
	_ struct{} `type:"structure"`

	// The key passed into the request object. If GroupByKey is not provided, the
	// result will be empty.
	GroupByKey *string `min:"1" type:"string"`

	// Returns a list of GroupedResourceCount objects.
	GroupedResourceCounts []*GroupedResourceCount `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The total number of resources that are present in an aggregator with the
	// filters that you provide.
	//
	// TotalDiscoveredResources is a required field
	TotalDiscoveredResources *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateDiscoveredResourceCountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateDiscoveredResourceCountsOutput) GoString() string {
	return s.String()
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateDiscoveredResourceCountsOutput) SetGroupByKey(v string) *GetAggregateDiscoveredResourceCountsOutput {
	s.GroupByKey = &v
	return s
}

// SetGroupedResourceCounts sets the GroupedResourceCounts field's value.
func (s *GetAggregateDiscoveredResourceCountsOutput) SetGroupedResourceCounts(v []*GroupedResourceCount) *GetAggregateDiscoveredResourceCountsOutput {
	s.GroupedResourceCounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateDiscoveredResourceCountsOutput) SetNextToken(v string) *GetAggregateDiscoveredResourceCountsOutput {
	s.NextToken = &v
	return s
}

// SetTotalDiscoveredResources sets the TotalDiscoveredResources field's value.
func (s *GetAggregateDiscoveredResourceCountsOutput) SetTotalDiscoveredResources(v int64) *GetAggregateDiscoveredResourceCountsOutput {
	s.TotalDiscoveredResources = &v
	return s
}

type GetAggregateResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// An object that identifies aggregate resource.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *AggregateResourceIdentifier `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateResourceConfigInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}
	if s.ResourceIdentifier != nil {
		if err := s.ResourceIdentifier.Validate(); err != nil {
			invalidParams.AddNested("ResourceIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateResourceConfigInput) SetConfigurationAggregatorName(v string) *GetAggregateResourceConfigInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *GetAggregateResourceConfigInput) SetResourceIdentifier(v *AggregateResourceIdentifier) *GetAggregateResourceConfigInput {
	s.ResourceIdentifier = v
	return s
}

type GetAggregateResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// Returns a ConfigurationItem object.
	ConfigurationItem *ConfigurationItem `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAggregateResourceConfigOutput) GoString() string {
	return s.String()
}

// SetConfigurationItem sets the ConfigurationItem field's value.
func (s *GetAggregateResourceConfigOutput) SetConfigurationItem(v *ConfigurationItem) *GetAggregateResourceConfigOutput {
	s.ConfigurationItem = v
	return s
}

type GetComplianceDetailsByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE.
	ComplianceTypes []*string `type:"list" enum:"ComplianceType"`

	// The name of the Config rule for which you want compliance information.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The maximum number of evaluation results returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, Config
	// uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailsByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailsByConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailsByConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceDetailsByConfigRuleInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetComplianceTypes(v []*string) *GetComplianceDetailsByConfigRuleInput {
	s.ComplianceTypes = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetConfigRuleName(v string) *GetComplianceDetailsByConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetLimit(v int64) *GetComplianceDetailsByConfigRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetNextToken(v string) *GetComplianceDetailsByConfigRuleInput {
	s.NextToken = &v
	return s
}

type GetComplianceDetailsByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the Amazon Web Services resource complies with the specified
	// Config rule.
	EvaluationResults []*EvaluationResult `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailsByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailsByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *GetComplianceDetailsByConfigRuleOutput) SetEvaluationResults(v []*EvaluationResult) *GetComplianceDetailsByConfigRuleOutput {
	s.EvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByConfigRuleOutput) SetNextToken(v string) *GetComplianceDetailsByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type GetComplianceDetailsByResourceInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE.
	ComplianceTypes []*string `type:"list" enum:"ComplianceType"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The ID of the Amazon Web Services resource for which you want compliance
	// information.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the Amazon Web Services resource for which you want compliance
	// information.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailsByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailsByResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailsByResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceDetailsByResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *GetComplianceDetailsByResourceInput) SetComplianceTypes(v []*string) *GetComplianceDetailsByResourceInput {
	s.ComplianceTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByResourceInput) SetNextToken(v string) *GetComplianceDetailsByResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetComplianceDetailsByResourceInput) SetResourceId(v string) *GetComplianceDetailsByResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetComplianceDetailsByResourceInput) SetResourceType(v string) *GetComplianceDetailsByResourceInput {
	s.ResourceType = &v
	return s
}

type GetComplianceDetailsByResourceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified Amazon Web Services resource complies each
	// Config rule.
	EvaluationResults []*EvaluationResult `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailsByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceDetailsByResourceOutput) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *GetComplianceDetailsByResourceOutput) SetEvaluationResults(v []*EvaluationResult) *GetComplianceDetailsByResourceOutput {
	s.EvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByResourceOutput) SetNextToken(v string) *GetComplianceDetailsByResourceOutput {
	s.NextToken = &v
	return s
}

type GetComplianceSummaryByConfigRuleInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceSummaryByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceSummaryByConfigRuleInput) GoString() string {
	return s.String()
}

type GetComplianceSummaryByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// The number of Config rules that are compliant and the number that are noncompliant,
	// up to a maximum of 25 for each.
	ComplianceSummary *ComplianceSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceSummaryByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceSummaryByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *GetComplianceSummaryByConfigRuleOutput) SetComplianceSummary(v *ComplianceSummary) *GetComplianceSummaryByConfigRuleOutput {
	s.ComplianceSummary = v
	return s
}

type GetComplianceSummaryByResourceTypeInput struct {
	_ struct{} `type:"structure"`

	// Specify one or more resource types to get the number of resources that are
	// compliant and the number that are noncompliant for each resource type.
	//
	// For this request, you can specify an Amazon Web Services resource type such
	// as AWS::EC2::Instance. You can specify that the resource type is an Amazon
	// Web Services account by specifying AWS::::Account.
	ResourceTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceSummaryByResourceTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceSummaryByResourceTypeInput) GoString() string {
	return s.String()
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetComplianceSummaryByResourceTypeInput) SetResourceTypes(v []*string) *GetComplianceSummaryByResourceTypeInput {
	s.ResourceTypes = v
	return s
}

type GetComplianceSummaryByResourceTypeOutput struct {
	_ struct{} `type:"structure"`

	// The number of resources that are compliant and the number that are noncompliant.
	// If one or more resource types were provided with the request, the numbers
	// are returned for each resource type. The maximum number returned is 100.
	ComplianceSummariesByResourceType []*ComplianceSummaryByResourceType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceSummaryByResourceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComplianceSummaryByResourceTypeOutput) GoString() string {
	return s.String()
}

// SetComplianceSummariesByResourceType sets the ComplianceSummariesByResourceType field's value.
func (s *GetComplianceSummaryByResourceTypeOutput) SetComplianceSummariesByResourceType(v []*ComplianceSummaryByResourceType) *GetComplianceSummaryByResourceTypeOutput {
	s.ComplianceSummariesByResourceType = v
	return s
}

type GetConformancePackComplianceDetailsInput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// A ConformancePackEvaluationFilters object.
	Filters *ConformancePackEvaluationFilters `type:"structure"`

	// The maximum number of evaluation results returned on each page. If you do
	// no specify a number, Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConformancePackComplianceDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConformancePackComplianceDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConformancePackComplianceDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConformancePackComplianceDetailsInput"}
	if s.ConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *GetConformancePackComplianceDetailsInput) SetConformancePackName(v string) *GetConformancePackComplianceDetailsInput {
	s.ConformancePackName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetConformancePackComplianceDetailsInput) SetFilters(v *ConformancePackEvaluationFilters) *GetConformancePackComplianceDetailsInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetConformancePackComplianceDetailsInput) SetLimit(v int64) *GetConformancePackComplianceDetailsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConformancePackComplianceDetailsInput) SetNextToken(v string) *GetConformancePackComplianceDetailsInput {
	s.NextToken = &v
	return s
}

type GetConformancePackComplianceDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Returns a list of ConformancePackEvaluationResult objects.
	ConformancePackRuleEvaluationResults []*ConformancePackEvaluationResult `type:"list"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConformancePackComplianceDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConformancePackComplianceDetailsOutput) GoString() string {
	return s.String()
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *GetConformancePackComplianceDetailsOutput) SetConformancePackName(v string) *GetConformancePackComplianceDetailsOutput {
	s.ConformancePackName = &v
	return s
}

// SetConformancePackRuleEvaluationResults sets the ConformancePackRuleEvaluationResults field's value.
func (s *GetConformancePackComplianceDetailsOutput) SetConformancePackRuleEvaluationResults(v []*ConformancePackEvaluationResult) *GetConformancePackComplianceDetailsOutput {
	s.ConformancePackRuleEvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConformancePackComplianceDetailsOutput) SetNextToken(v string) *GetConformancePackComplianceDetailsOutput {
	s.NextToken = &v
	return s
}

type GetConformancePackComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// Names of conformance packs.
	//
	// ConformancePackNames is a required field
	ConformancePackNames []*string `min:"1" type:"list" required:"true"`

	// The maximum number of conformance packs returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConformancePackComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConformancePackComplianceSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConformancePackComplianceSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConformancePackComplianceSummaryInput"}
	if s.ConformancePackNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ConformancePackNames"))
	}
	if s.ConformancePackNames != nil && len(s.ConformancePackNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConformancePackNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConformancePackNames sets the ConformancePackNames field's value.
func (s *GetConformancePackComplianceSummaryInput) SetConformancePackNames(v []*string) *GetConformancePackComplianceSummaryInput {
	s.ConformancePackNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetConformancePackComplianceSummaryInput) SetLimit(v int64) *GetConformancePackComplianceSummaryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConformancePackComplianceSummaryInput) SetNextToken(v string) *GetConformancePackComplianceSummaryInput {
	s.NextToken = &v
	return s
}

type GetConformancePackComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackComplianceSummary objects.
	ConformancePackComplianceSummaryList []*ConformancePackComplianceSummary `min:"1" type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConformancePackComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConformancePackComplianceSummaryOutput) GoString() string {
	return s.String()
}

// SetConformancePackComplianceSummaryList sets the ConformancePackComplianceSummaryList field's value.
func (s *GetConformancePackComplianceSummaryOutput) SetConformancePackComplianceSummaryList(v []*ConformancePackComplianceSummary) *GetConformancePackComplianceSummaryOutput {
	s.ConformancePackComplianceSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConformancePackComplianceSummaryOutput) SetNextToken(v string) *GetConformancePackComplianceSummaryOutput {
	s.NextToken = &v
	return s
}

type GetCustomRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of your Config Custom Policy rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomRulePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomRulePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCustomRulePolicyInput"}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *GetCustomRulePolicyInput) SetConfigRuleName(v string) *GetCustomRulePolicyInput {
	s.ConfigRuleName = &v
	return s
}

type GetCustomRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy definition containing the logic for your Config Custom Policy
	// rule.
	PolicyText *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomRulePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyText sets the PolicyText field's value.
func (s *GetCustomRulePolicyOutput) SetPolicyText(v string) *GetCustomRulePolicyOutput {
	s.PolicyText = &v
	return s
}

type GetDiscoveredResourceCountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of ResourceCount objects returned on each page. The default
	// is 100. You cannot specify a number greater than 100. If you specify 0, Config
	// uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The comma-separated list that specifies the resource types that you want
	// Config to return (for example, "AWS::EC2::Instance", "AWS::IAM::User").
	//
	// If a value for resourceTypes is not specified, Config returns all resource
	// types that Config is recording in the region for your account.
	//
	// If the configuration recorder is turned off, Config returns an empty list
	// of ResourceCount objects. If the configuration recorder is not recording
	// a specific resource type (for example, S3 buckets), that resource type is
	// not returned in the list of ResourceCount objects.
	ResourceTypes []*string `locationName:"resourceTypes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDiscoveredResourceCountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDiscoveredResourceCountsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GetDiscoveredResourceCountsInput) SetLimit(v int64) *GetDiscoveredResourceCountsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDiscoveredResourceCountsInput) SetNextToken(v string) *GetDiscoveredResourceCountsInput {
	s.NextToken = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetDiscoveredResourceCountsInput) SetResourceTypes(v []*string) *GetDiscoveredResourceCountsInput {
	s.ResourceTypes = v
	return s
}

type GetDiscoveredResourceCountsOutput struct {
	_ struct{} `type:"structure"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of ResourceCount objects. Each object is listed in descending order
	// by the number of resources.
	ResourceCounts []*ResourceCount `locationName:"resourceCounts" type:"list"`

	// The total number of resources that Config is recording in the region for
	// your account. If you specify resource types in the request, Config returns
	// only the total number of resources for those resource types.
	//
	// Example
	//
	// Config is recording three resource types in the US East (Ohio) Region for
	// your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for a total
	// of 60 resources.
	//
	// You make a call to the GetDiscoveredResourceCounts action and specify the
	// resource type, "AWS::EC2::Instances", in the request.
	//
	// Config returns 25 for totalDiscoveredResources.
	TotalDiscoveredResources *int64 `locationName:"totalDiscoveredResources" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDiscoveredResourceCountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDiscoveredResourceCountsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetDiscoveredResourceCountsOutput) SetNextToken(v string) *GetDiscoveredResourceCountsOutput {
	s.NextToken = &v
	return s
}

// SetResourceCounts sets the ResourceCounts field's value.
func (s *GetDiscoveredResourceCountsOutput) SetResourceCounts(v []*ResourceCount) *GetDiscoveredResourceCountsOutput {
	s.ResourceCounts = v
	return s
}

// SetTotalDiscoveredResources sets the TotalDiscoveredResources field's value.
func (s *GetDiscoveredResourceCountsOutput) SetTotalDiscoveredResources(v int64) *GetDiscoveredResourceCountsOutput {
	s.TotalDiscoveredResources = &v
	return s
}

type GetOrganizationConfigRuleDetailedStatusInput struct {
	_ struct{} `type:"structure"`

	// A StatusDetailFilters object.
	Filters *StatusDetailFilters `type:"structure"`

	// The maximum number of OrganizationConfigRuleDetailedStatus returned on each
	// page. If you do not specify a number, Config uses the default. The default
	// is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The name of your organization Config rule for which you want status details
	// for member accounts.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationConfigRuleDetailedStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationConfigRuleDetailedStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOrganizationConfigRuleDetailedStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOrganizationConfigRuleDetailedStatusInput"}
	if s.OrganizationConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConfigRuleName"))
	}
	if s.OrganizationConfigRuleName != nil && len(*s.OrganizationConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetOrganizationConfigRuleDetailedStatusInput) SetFilters(v *StatusDetailFilters) *GetOrganizationConfigRuleDetailedStatusInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetOrganizationConfigRuleDetailedStatusInput) SetLimit(v int64) *GetOrganizationConfigRuleDetailedStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOrganizationConfigRuleDetailedStatusInput) SetNextToken(v string) *GetOrganizationConfigRuleDetailedStatusInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *GetOrganizationConfigRuleDetailedStatusInput) SetOrganizationConfigRuleName(v string) *GetOrganizationConfigRuleDetailedStatusInput {
	s.OrganizationConfigRuleName = &v
	return s
}

type GetOrganizationConfigRuleDetailedStatusOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of MemberAccountStatus objects.
	OrganizationConfigRuleDetailedStatus []*MemberAccountStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationConfigRuleDetailedStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationConfigRuleDetailedStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetOrganizationConfigRuleDetailedStatusOutput) SetNextToken(v string) *GetOrganizationConfigRuleDetailedStatusOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConfigRuleDetailedStatus sets the OrganizationConfigRuleDetailedStatus field's value.
func (s *GetOrganizationConfigRuleDetailedStatusOutput) SetOrganizationConfigRuleDetailedStatus(v []*MemberAccountStatus) *GetOrganizationConfigRuleDetailedStatusOutput {
	s.OrganizationConfigRuleDetailedStatus = v
	return s
}

type GetOrganizationConformancePackDetailedStatusInput struct {
	_ struct{} `type:"structure"`

	// An OrganizationResourceDetailedStatusFilters object.
	Filters *OrganizationResourceDetailedStatusFilters `type:"structure"`

	// The maximum number of OrganizationConformancePackDetailedStatuses returned
	// on each page. If you do not specify a number, Config uses the default. The
	// default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The name of organization conformance pack for which you want status details
	// for member accounts.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationConformancePackDetailedStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationConformancePackDetailedStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOrganizationConformancePackDetailedStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOrganizationConformancePackDetailedStatusInput"}
	if s.OrganizationConformancePackName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConformancePackName"))
	}
	if s.OrganizationConformancePackName != nil && len(*s.OrganizationConformancePackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConformancePackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetOrganizationConformancePackDetailedStatusInput) SetFilters(v *OrganizationResourceDetailedStatusFilters) *GetOrganizationConformancePackDetailedStatusInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetOrganizationConformancePackDetailedStatusInput) SetLimit(v int64) *GetOrganizationConformancePackDetailedStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOrganizationConformancePackDetailedStatusInput) SetNextToken(v string) *GetOrganizationConformancePackDetailedStatusInput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *GetOrganizationConformancePackDetailedStatusInput) SetOrganizationConformancePackName(v string) *GetOrganizationConformancePackDetailedStatusInput {
	s.OrganizationConformancePackName = &v
	return s
}

type GetOrganizationConformancePackDetailedStatusOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of OrganizationConformancePackDetailedStatus objects.
	OrganizationConformancePackDetailedStatuses []*OrganizationConformancePackDetailedStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationConformancePackDetailedStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationConformancePackDetailedStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetOrganizationConformancePackDetailedStatusOutput) SetNextToken(v string) *GetOrganizationConformancePackDetailedStatusOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationConformancePackDetailedStatuses sets the OrganizationConformancePackDetailedStatuses field's value.
func (s *GetOrganizationConformancePackDetailedStatusOutput) SetOrganizationConformancePackDetailedStatuses(v []*OrganizationConformancePackDetailedStatus) *GetOrganizationConformancePackDetailedStatusOutput {
	s.OrganizationConformancePackDetailedStatuses = v
	return s
}

type GetOrganizationCustomRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of your organization Config Custom Policy rule.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationCustomRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationCustomRulePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOrganizationCustomRulePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOrganizationCustomRulePolicyInput"}
	if s.OrganizationConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationConfigRuleName"))
	}
	if s.OrganizationConfigRuleName != nil && len(*s.OrganizationConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *GetOrganizationCustomRulePolicyInput) SetOrganizationConfigRuleName(v string) *GetOrganizationCustomRulePolicyInput {
	s.OrganizationConfigRuleName = &v
	return s
}

type GetOrganizationCustomRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy definition containing the logic for your organization Config Custom
	// Policy rule.
	PolicyText *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationCustomRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOrganizationCustomRulePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyText sets the PolicyText field's value.
func (s *GetOrganizationCustomRulePolicyOutput) SetPolicyText(v string) *GetOrganizationCustomRulePolicyOutput {
	s.PolicyText = &v
	return s
}

// The input for the GetResourceConfigHistory action.
type GetResourceConfigHistoryInput struct {
	_ struct{} `type:"structure"`

	// The chronological order for configuration items listed. By default, the results
	// are listed in reverse chronological order.
	ChronologicalOrder *string `locationName:"chronologicalOrder" type:"string" enum:"ChronologicalOrder"`

	// The time stamp that indicates an earlier time. If not specified, the action
	// returns paginated results that contain configuration items that start when
	// the first configuration item was recorded.
	EarlierTime *time.Time `locationName:"earlierTime" type:"timestamp"`

	// The time stamp that indicates a later time. If not specified, current time
	// is taken.
	LaterTime *time.Time `locationName:"laterTime" type:"timestamp"`

	// The maximum number of configuration items returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, Config
	// uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceConfigHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceConfigHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceConfigHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceConfigHistoryInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChronologicalOrder sets the ChronologicalOrder field's value.
func (s *GetResourceConfigHistoryInput) SetChronologicalOrder(v string) *GetResourceConfigHistoryInput {
	s.ChronologicalOrder = &v
	return s
}

// SetEarlierTime sets the EarlierTime field's value.
func (s *GetResourceConfigHistoryInput) SetEarlierTime(v time.Time) *GetResourceConfigHistoryInput {
	s.EarlierTime = &v
	return s
}

// SetLaterTime sets the LaterTime field's value.
func (s *GetResourceConfigHistoryInput) SetLaterTime(v time.Time) *GetResourceConfigHistoryInput {
	s.LaterTime = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetResourceConfigHistoryInput) SetLimit(v int64) *GetResourceConfigHistoryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceConfigHistoryInput) SetNextToken(v string) *GetResourceConfigHistoryInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetResourceConfigHistoryInput) SetResourceId(v string) *GetResourceConfigHistoryInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetResourceConfigHistoryInput) SetResourceType(v string) *GetResourceConfigHistoryInput {
	s.ResourceType = &v
	return s
}

// The output for the GetResourceConfigHistory action.
type GetResourceConfigHistoryOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the configuration history of one or more resources.
	ConfigurationItems []*ConfigurationItem `locationName:"configurationItems" type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceConfigHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceConfigHistoryOutput) GoString() string {
	return s.String()
}

// SetConfigurationItems sets the ConfigurationItems field's value.
func (s *GetResourceConfigHistoryOutput) SetConfigurationItems(v []*ConfigurationItem) *GetResourceConfigHistoryOutput {
	s.ConfigurationItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceConfigHistoryOutput) SetNextToken(v string) *GetResourceConfigHistoryOutput {
	s.NextToken = &v
	return s
}

type GetStoredQueryInput struct {
	_ struct{} `type:"structure"`

	// The name of the query.
	//
	// QueryName is a required field
	QueryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStoredQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStoredQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStoredQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStoredQueryInput"}
	if s.QueryName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryName"))
	}
	if s.QueryName != nil && len(*s.QueryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryName sets the QueryName field's value.
func (s *GetStoredQueryInput) SetQueryName(v string) *GetStoredQueryInput {
	s.QueryName = &v
	return s
}

type GetStoredQueryOutput struct {
	_ struct{} `type:"structure"`

	// Returns a StoredQuery object.
	StoredQuery *StoredQuery `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStoredQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStoredQueryOutput) GoString() string {
	return s.String()
}

// SetStoredQuery sets the StoredQuery field's value.
func (s *GetStoredQueryOutput) SetStoredQuery(v *StoredQuery) *GetStoredQueryOutput {
	s.StoredQuery = v
	return s
}

// The count of resources that are grouped by the group name.
type GroupedResourceCount struct {
	_ struct{} `type:"structure"`

	// The name of the group that can be region, account ID, or resource type. For
	// example, region1, region2 if the region was chosen as GroupByKey.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The number of resources in the group.
	//
	// ResourceCount is a required field
	ResourceCount *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupedResourceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupedResourceCount) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *GroupedResourceCount) SetGroupName(v string) *GroupedResourceCount {
	s.GroupName = &v
	return s
}

// SetResourceCount sets the ResourceCount field's value.
func (s *GroupedResourceCount) SetResourceCount(v int64) *GroupedResourceCount {
	s.ResourceCount = &v
	return s
}

// Your Amazon S3 bucket policy does not permit Config to write to it.
type InsufficientDeliveryPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientDeliveryPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientDeliveryPolicyException) GoString() string {
	return s.String()
}

func newErrorInsufficientDeliveryPolicyException(v protocol.ResponseMetadata) error {
	return &InsufficientDeliveryPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientDeliveryPolicyException) Code() string {
	return "InsufficientDeliveryPolicyException"
}

// Message returns the exception's message.
func (s *InsufficientDeliveryPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientDeliveryPolicyException) OrigErr() error {
	return nil
}

func (s *InsufficientDeliveryPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientDeliveryPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientDeliveryPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates one of the following errors:
//
//    * For PutConfigRule, the rule cannot be created because the IAM role assigned
//    to Config lacks permissions to perform the config:Put* action.
//
//    * For PutConfigRule, the Lambda function cannot be invoked. Check the
//    function ARN, and check the function's permissions.
//
//    * For PutOrganizationConfigRule, organization Config rule cannot be created
//    because you do not have permissions to call IAM GetRole action or create
//    a service linked role.
//
//    * For PutConformancePack and PutOrganizationConformancePack, a conformance
//    pack cannot be created because you do not have permissions: To call IAM
//    GetRole action or create a service linked role. To read Amazon S3 bucket.
type InsufficientPermissionsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientPermissionsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientPermissionsException) GoString() string {
	return s.String()
}

func newErrorInsufficientPermissionsException(v protocol.ResponseMetadata) error {
	return &InsufficientPermissionsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientPermissionsException) Code() string {
	return "InsufficientPermissionsException"
}

// Message returns the exception's message.
func (s *InsufficientPermissionsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientPermissionsException) OrigErr() error {
	return nil
}

func (s *InsufficientPermissionsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientPermissionsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientPermissionsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have provided a configuration recorder name that is not valid.
type InvalidConfigurationRecorderNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidConfigurationRecorderNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidConfigurationRecorderNameException) GoString() string {
	return s.String()
}

func newErrorInvalidConfigurationRecorderNameException(v protocol.ResponseMetadata) error {
	return &InvalidConfigurationRecorderNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidConfigurationRecorderNameException) Code() string {
	return "InvalidConfigurationRecorderNameException"
}

// Message returns the exception's message.
func (s *InvalidConfigurationRecorderNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidConfigurationRecorderNameException) OrigErr() error {
	return nil
}

func (s *InvalidConfigurationRecorderNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidConfigurationRecorderNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidConfigurationRecorderNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified delivery channel name is not valid.
type InvalidDeliveryChannelNameException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidDeliveryChannelNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidDeliveryChannelNameException) GoString() string {
	return s.String()
}

func newErrorInvalidDeliveryChannelNameException(v protocol.ResponseMetadata) error {
	return &InvalidDeliveryChannelNameException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidDeliveryChannelNameException) Code() string {
	return "InvalidDeliveryChannelNameException"
}

// Message returns the exception's message.
func (s *InvalidDeliveryChannelNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidDeliveryChannelNameException) OrigErr() error {
	return nil
}

func (s *InvalidDeliveryChannelNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidDeliveryChannelNameException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidDeliveryChannelNameException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The syntax of the query is incorrect.
type InvalidExpressionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidExpressionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidExpressionException) GoString() string {
	return s.String()
}

func newErrorInvalidExpressionException(v protocol.ResponseMetadata) error {
	return &InvalidExpressionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidExpressionException) Code() string {
	return "InvalidExpressionException"
}

// Message returns the exception's message.
func (s *InvalidExpressionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidExpressionException) OrigErr() error {
	return nil
}

func (s *InvalidExpressionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidExpressionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidExpressionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified limit is outside the allowable range.
type InvalidLimitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLimitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLimitException) GoString() string {
	return s.String()
}

func newErrorInvalidLimitException(v protocol.ResponseMetadata) error {
	return &InvalidLimitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLimitException) Code() string {
	return "InvalidLimitException"
}

// Message returns the exception's message.
func (s *InvalidLimitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLimitException) OrigErr() error {
	return nil
}

func (s *InvalidLimitException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLimitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLimitException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified next token is invalid. Specify the nextToken string that was
// returned in the previous response to get the next page of results.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more of the specified parameters are invalid. Verify that your parameters
// are valid and try again.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Config throws an exception if the recording group does not contain a valid
// list of resource types. Invalid values might also be incorrectly formatted.
type InvalidRecordingGroupException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRecordingGroupException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRecordingGroupException) GoString() string {
	return s.String()
}

func newErrorInvalidRecordingGroupException(v protocol.ResponseMetadata) error {
	return &InvalidRecordingGroupException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRecordingGroupException) Code() string {
	return "InvalidRecordingGroupException"
}

// Message returns the exception's message.
func (s *InvalidRecordingGroupException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRecordingGroupException) OrigErr() error {
	return nil
}

func (s *InvalidRecordingGroupException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRecordingGroupException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRecordingGroupException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified ResultToken is invalid.
type InvalidResultTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResultTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResultTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidResultTokenException(v protocol.ResponseMetadata) error {
	return &InvalidResultTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResultTokenException) Code() string {
	return "InvalidResultTokenException"
}

// Message returns the exception's message.
func (s *InvalidResultTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResultTokenException) OrigErr() error {
	return nil
}

func (s *InvalidResultTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResultTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResultTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have provided a null or empty role ARN.
type InvalidRoleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRoleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRoleException) GoString() string {
	return s.String()
}

func newErrorInvalidRoleException(v protocol.ResponseMetadata) error {
	return &InvalidRoleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRoleException) Code() string {
	return "InvalidRoleException"
}

// Message returns the exception's message.
func (s *InvalidRoleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRoleException) OrigErr() error {
	return nil
}

func (s *InvalidRoleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRoleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRoleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Amazon S3 key prefix is not valid.
type InvalidS3KeyPrefixException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3KeyPrefixException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3KeyPrefixException) GoString() string {
	return s.String()
}

func newErrorInvalidS3KeyPrefixException(v protocol.ResponseMetadata) error {
	return &InvalidS3KeyPrefixException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3KeyPrefixException) Code() string {
	return "InvalidS3KeyPrefixException"
}

// Message returns the exception's message.
func (s *InvalidS3KeyPrefixException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3KeyPrefixException) OrigErr() error {
	return nil
}

func (s *InvalidS3KeyPrefixException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3KeyPrefixException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3KeyPrefixException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Amazon KMS Key ARN is not valid.
type InvalidS3KmsKeyArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3KmsKeyArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3KmsKeyArnException) GoString() string {
	return s.String()
}

func newErrorInvalidS3KmsKeyArnException(v protocol.ResponseMetadata) error {
	return &InvalidS3KmsKeyArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3KmsKeyArnException) Code() string {
	return "InvalidS3KmsKeyArnException"
}

// Message returns the exception's message.
func (s *InvalidS3KmsKeyArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3KmsKeyArnException) OrigErr() error {
	return nil
}

func (s *InvalidS3KmsKeyArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3KmsKeyArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3KmsKeyArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Amazon SNS topic does not exist.
type InvalidSNSTopicARNException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSNSTopicARNException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSNSTopicARNException) GoString() string {
	return s.String()
}

func newErrorInvalidSNSTopicARNException(v protocol.ResponseMetadata) error {
	return &InvalidSNSTopicARNException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSNSTopicARNException) Code() string {
	return "InvalidSNSTopicARNException"
}

// Message returns the exception's message.
func (s *InvalidSNSTopicARNException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSNSTopicARNException) OrigErr() error {
	return nil
}

func (s *InvalidSNSTopicARNException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSNSTopicARNException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSNSTopicARNException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified time range is not valid. The earlier time is not chronologically
// before the later time.
type InvalidTimeRangeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTimeRangeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTimeRangeException) GoString() string {
	return s.String()
}

func newErrorInvalidTimeRangeException(v protocol.ResponseMetadata) error {
	return &InvalidTimeRangeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTimeRangeException) Code() string {
	return "InvalidTimeRangeException"
}

// Message returns the exception's message.
func (s *InvalidTimeRangeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTimeRangeException) OrigErr() error {
	return nil
}

func (s *InvalidTimeRangeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTimeRangeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTimeRangeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You cannot delete the delivery channel you specified because the configuration
// recorder is running.
type LastDeliveryChannelDeleteFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LastDeliveryChannelDeleteFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LastDeliveryChannelDeleteFailedException) GoString() string {
	return s.String()
}

func newErrorLastDeliveryChannelDeleteFailedException(v protocol.ResponseMetadata) error {
	return &LastDeliveryChannelDeleteFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LastDeliveryChannelDeleteFailedException) Code() string {
	return "LastDeliveryChannelDeleteFailedException"
}

// Message returns the exception's message.
func (s *LastDeliveryChannelDeleteFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LastDeliveryChannelDeleteFailedException) OrigErr() error {
	return nil
}

func (s *LastDeliveryChannelDeleteFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LastDeliveryChannelDeleteFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LastDeliveryChannelDeleteFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
// is in progress or if you call the StartConfigRulesEvaluation API more than
// once per minute.
//
// For PutConfigurationAggregator API, this exception is thrown if the number
// of accounts and aggregators exceeds the limit.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAggregateDiscoveredResourcesInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ResourceFilters object.
	Filters *ResourceFilters `type:"structure"`

	// The maximum number of resource identifiers returned on each page. You cannot
	// specify a number greater than 100. If you specify 0, Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The type of resources that you want Config to list in the response.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAggregateDiscoveredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAggregateDiscoveredResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAggregateDiscoveredResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAggregateDiscoveredResourcesInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetConfigurationAggregatorName(v string) *ListAggregateDiscoveredResourcesInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetFilters(v *ResourceFilters) *ListAggregateDiscoveredResourcesInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetLimit(v int64) *ListAggregateDiscoveredResourcesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetNextToken(v string) *ListAggregateDiscoveredResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListAggregateDiscoveredResourcesInput) SetResourceType(v string) *ListAggregateDiscoveredResourcesInput {
	s.ResourceType = &v
	return s
}

type ListAggregateDiscoveredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a list of ResourceIdentifiers objects.
	ResourceIdentifiers []*AggregateResourceIdentifier `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAggregateDiscoveredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAggregateDiscoveredResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAggregateDiscoveredResourcesOutput) SetNextToken(v string) *ListAggregateDiscoveredResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *ListAggregateDiscoveredResourcesOutput) SetResourceIdentifiers(v []*AggregateResourceIdentifier) *ListAggregateDiscoveredResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

type ListDiscoveredResourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether Config includes deleted resources in the results. By default,
	// deleted resources are not included.
	IncludeDeletedResources *bool `locationName:"includeDeletedResources" type:"boolean"`

	// The maximum number of resource identifiers returned on each page. The default
	// is 100. You cannot specify a number greater than 100. If you specify 0, Config
	// uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The IDs of only those resources that you want Config to list in the response.
	// If you do not specify this parameter, Config lists all resources of the specified
	// type that it has discovered.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`

	// The custom name of only those resources that you want Config to list in the
	// response. If you do not specify this parameter, Config lists all resources
	// of the specified type that it has discovered.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of resources that you want Config to list in the response.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveredResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDiscoveredResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDiscoveredResourcesInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeDeletedResources sets the IncludeDeletedResources field's value.
func (s *ListDiscoveredResourcesInput) SetIncludeDeletedResources(v bool) *ListDiscoveredResourcesInput {
	s.IncludeDeletedResources = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListDiscoveredResourcesInput) SetLimit(v int64) *ListDiscoveredResourcesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesInput) SetNextToken(v string) *ListDiscoveredResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ListDiscoveredResourcesInput) SetResourceIds(v []*string) *ListDiscoveredResourcesInput {
	s.ResourceIds = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ListDiscoveredResourcesInput) SetResourceName(v string) *ListDiscoveredResourcesInput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListDiscoveredResourcesInput) SetResourceType(v string) *ListDiscoveredResourcesInput {
	s.ResourceType = &v
	return s
}

type ListDiscoveredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The details that identify a resource that is discovered by Config, including
	// the resource type, ID, and (if available) the custom resource name.
	ResourceIdentifiers []*ResourceIdentifier `locationName:"resourceIdentifiers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDiscoveredResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesOutput) SetNextToken(v string) *ListDiscoveredResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *ListDiscoveredResourcesOutput) SetResourceIdentifiers(v []*ResourceIdentifier) *ListDiscoveredResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

type ListStoredQueriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call.
	MaxResults *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStoredQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStoredQueriesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStoredQueriesInput) SetMaxResults(v int64) *ListStoredQueriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStoredQueriesInput) SetNextToken(v string) *ListStoredQueriesInput {
	s.NextToken = &v
	return s
}

type ListStoredQueriesOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `type:"string"`

	// A list of StoredQueryMetadata objects.
	StoredQueryMetadata []*StoredQueryMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStoredQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStoredQueriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStoredQueriesOutput) SetNextToken(v string) *ListStoredQueriesOutput {
	s.NextToken = &v
	return s
}

// SetStoredQueryMetadata sets the StoredQueryMetadata field's value.
func (s *ListStoredQueriesOutput) SetStoredQueryMetadata(v []*StoredQueryMetadata) *ListStoredQueriesOutput {
	s.StoredQueryMetadata = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags returned on each page. The limit maximum is 50.
	// You cannot specify a number greater than 50. If you specify 0, Config uses
	// the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) that identifies the resource for which to
	// list the tags. Currently, the supported resources are ConfigRule, ConfigurationAggregator
	// and AggregatorAuthorization.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The tags for the resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// You have reached the limit (100,000) of active custom resource types in your
// account. Delete unused resources using DeleteResourceConfig.
type MaxActiveResourcesExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxActiveResourcesExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxActiveResourcesExceededException) GoString() string {
	return s.String()
}

func newErrorMaxActiveResourcesExceededException(v protocol.ResponseMetadata) error {
	return &MaxActiveResourcesExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxActiveResourcesExceededException) Code() string {
	return "MaxActiveResourcesExceededException"
}

// Message returns the exception's message.
func (s *MaxActiveResourcesExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxActiveResourcesExceededException) OrigErr() error {
	return nil
}

func (s *MaxActiveResourcesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxActiveResourcesExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxActiveResourcesExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Failed to add the Config rule because the account already contains the maximum
// number of 150 rules. Consider deleting any deactivated rules before you add
// new rules.
type MaxNumberOfConfigRulesExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfConfigRulesExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfConfigRulesExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfConfigRulesExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfConfigRulesExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfConfigRulesExceededException) Code() string {
	return "MaxNumberOfConfigRulesExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfConfigRulesExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfConfigRulesExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfConfigRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfConfigRulesExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfConfigRulesExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit of the number of recorders you can create.
type MaxNumberOfConfigurationRecordersExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfConfigurationRecordersExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfConfigurationRecordersExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfConfigurationRecordersExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfConfigurationRecordersExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfConfigurationRecordersExceededException) Code() string {
	return "MaxNumberOfConfigurationRecordersExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfConfigurationRecordersExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfConfigurationRecordersExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfConfigurationRecordersExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfConfigurationRecordersExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfConfigurationRecordersExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit (6) of the number of conformance packs in an account
// (6 conformance pack with 25 Config rules per pack).
type MaxNumberOfConformancePacksExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfConformancePacksExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfConformancePacksExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfConformancePacksExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfConformancePacksExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfConformancePacksExceededException) Code() string {
	return "MaxNumberOfConformancePacksExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfConformancePacksExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfConformancePacksExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfConformancePacksExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfConformancePacksExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfConformancePacksExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit of the number of delivery channels you can create.
type MaxNumberOfDeliveryChannelsExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfDeliveryChannelsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfDeliveryChannelsExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfDeliveryChannelsExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfDeliveryChannelsExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfDeliveryChannelsExceededException) Code() string {
	return "MaxNumberOfDeliveryChannelsExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfDeliveryChannelsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfDeliveryChannelsExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfDeliveryChannelsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfDeliveryChannelsExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfDeliveryChannelsExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit of the number of organization Config rules you
// can create.
type MaxNumberOfOrganizationConfigRulesExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfOrganizationConfigRulesExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfOrganizationConfigRulesExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfOrganizationConfigRulesExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfOrganizationConfigRulesExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) Code() string {
	return "MaxNumberOfOrganizationConfigRulesExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfOrganizationConfigRulesExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfOrganizationConfigRulesExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have reached the limit (6) of the number of organization conformance
// packs in an account (6 conformance pack with 25 Config rules per pack per
// account).
type MaxNumberOfOrganizationConformancePacksExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfOrganizationConformancePacksExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfOrganizationConformancePacksExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfOrganizationConformancePacksExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfOrganizationConformancePacksExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) Code() string {
	return "MaxNumberOfOrganizationConformancePacksExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfOrganizationConformancePacksExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfOrganizationConformancePacksExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Failed to add the retention configuration because a retention configuration
// with that name already exists.
type MaxNumberOfRetentionConfigurationsExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfRetentionConfigurationsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MaxNumberOfRetentionConfigurationsExceededException) GoString() string {
	return s.String()
}

func newErrorMaxNumberOfRetentionConfigurationsExceededException(v protocol.ResponseMetadata) error {
	return &MaxNumberOfRetentionConfigurationsExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxNumberOfRetentionConfigurationsExceededException) Code() string {
	return "MaxNumberOfRetentionConfigurationsExceededException"
}

// Message returns the exception's message.
func (s *MaxNumberOfRetentionConfigurationsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxNumberOfRetentionConfigurationsExceededException) OrigErr() error {
	return nil
}

func (s *MaxNumberOfRetentionConfigurationsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxNumberOfRetentionConfigurationsExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxNumberOfRetentionConfigurationsExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Organization Config rule creation or deletion status in each member account.
// This includes the name of the rule, the status, error code and error message
// when the rule creation or deletion failed.
type MemberAccountStatus struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of a member account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The name of Config rule deployed in the member account.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An error code that is returned when Config rule creation or deletion failed
	// in the member account.
	ErrorCode *string `type:"string"`

	// An error message indicating that Config rule account creation or deletion
	// has failed due to an error in the member account.
	ErrorMessage *string `type:"string"`

	// The timestamp of the last status update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// Indicates deployment status for Config rule in the member account. When master
	// account calls PutOrganizationConfigRule action for the first time, Config
	// rule status is created in the member account. When master account calls PutOrganizationConfigRule
	// action for the second time, Config rule status is updated in the member account.
	// Config rule status is deleted when the master account deletes OrganizationConfigRule
	// and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// Config sets the state of the rule to:
	//
	//    * CREATE_SUCCESSFUL when Config rule has been created in the member account.
	//
	//    * CREATE_IN_PROGRESS when Config rule is being created in the member account.
	//
	//    * CREATE_FAILED when Config rule creation has failed in the member account.
	//
	//    * DELETE_FAILED when Config rule deletion has failed in the member account.
	//
	//    * DELETE_IN_PROGRESS when Config rule is being deleted in the member account.
	//
	//    * DELETE_SUCCESSFUL when Config rule has been deleted in the member account.
	//
	//    * UPDATE_SUCCESSFUL when Config rule has been updated in the member account.
	//
	//    * UPDATE_IN_PROGRESS when Config rule is being updated in the member account.
	//
	//    * UPDATE_FAILED when Config rule deletion has failed in the member account.
	//
	// MemberAccountRuleStatus is a required field
	MemberAccountRuleStatus *string `type:"string" required:"true" enum:"MemberAccountRuleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberAccountStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberAccountStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MemberAccountStatus) SetAccountId(v string) *MemberAccountStatus {
	s.AccountId = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *MemberAccountStatus) SetConfigRuleName(v string) *MemberAccountStatus {
	s.ConfigRuleName = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *MemberAccountStatus) SetErrorCode(v string) *MemberAccountStatus {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *MemberAccountStatus) SetErrorMessage(v string) *MemberAccountStatus {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *MemberAccountStatus) SetLastUpdateTime(v time.Time) *MemberAccountStatus {
	s.LastUpdateTime = &v
	return s
}

// SetMemberAccountRuleStatus sets the MemberAccountRuleStatus field's value.
func (s *MemberAccountStatus) SetMemberAccountRuleStatus(v string) *MemberAccountStatus {
	s.MemberAccountRuleStatus = &v
	return s
}

// There are no configuration recorders available to provide the role needed
// to describe your resources. Create a configuration recorder.
type NoAvailableConfigurationRecorderException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAvailableConfigurationRecorderException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAvailableConfigurationRecorderException) GoString() string {
	return s.String()
}

func newErrorNoAvailableConfigurationRecorderException(v protocol.ResponseMetadata) error {
	return &NoAvailableConfigurationRecorderException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoAvailableConfigurationRecorderException) Code() string {
	return "NoAvailableConfigurationRecorderException"
}

// Message returns the exception's message.
func (s *NoAvailableConfigurationRecorderException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoAvailableConfigurationRecorderException) OrigErr() error {
	return nil
}

func (s *NoAvailableConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoAvailableConfigurationRecorderException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoAvailableConfigurationRecorderException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There is no delivery channel available to record configurations.
type NoAvailableDeliveryChannelException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAvailableDeliveryChannelException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAvailableDeliveryChannelException) GoString() string {
	return s.String()
}

func newErrorNoAvailableDeliveryChannelException(v protocol.ResponseMetadata) error {
	return &NoAvailableDeliveryChannelException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoAvailableDeliveryChannelException) Code() string {
	return "NoAvailableDeliveryChannelException"
}

// Message returns the exception's message.
func (s *NoAvailableDeliveryChannelException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoAvailableDeliveryChannelException) OrigErr() error {
	return nil
}

func (s *NoAvailableDeliveryChannelException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoAvailableDeliveryChannelException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoAvailableDeliveryChannelException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Organization is no longer available.
type NoAvailableOrganizationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAvailableOrganizationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAvailableOrganizationException) GoString() string {
	return s.String()
}

func newErrorNoAvailableOrganizationException(v protocol.ResponseMetadata) error {
	return &NoAvailableOrganizationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoAvailableOrganizationException) Code() string {
	return "NoAvailableOrganizationException"
}

// Message returns the exception's message.
func (s *NoAvailableOrganizationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoAvailableOrganizationException) OrigErr() error {
	return nil
}

func (s *NoAvailableOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoAvailableOrganizationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoAvailableOrganizationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There is no configuration recorder running.
type NoRunningConfigurationRecorderException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoRunningConfigurationRecorderException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoRunningConfigurationRecorderException) GoString() string {
	return s.String()
}

func newErrorNoRunningConfigurationRecorderException(v protocol.ResponseMetadata) error {
	return &NoRunningConfigurationRecorderException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoRunningConfigurationRecorderException) Code() string {
	return "NoRunningConfigurationRecorderException"
}

// Message returns the exception's message.
func (s *NoRunningConfigurationRecorderException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoRunningConfigurationRecorderException) OrigErr() error {
	return nil
}

func (s *NoRunningConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoRunningConfigurationRecorderException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoRunningConfigurationRecorderException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Amazon S3 bucket does not exist.
type NoSuchBucketException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchBucketException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchBucketException) GoString() string {
	return s.String()
}

func newErrorNoSuchBucketException(v protocol.ResponseMetadata) error {
	return &NoSuchBucketException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchBucketException) Code() string {
	return "NoSuchBucketException"
}

// Message returns the exception's message.
func (s *NoSuchBucketException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchBucketException) OrigErr() error {
	return nil
}

func (s *NoSuchBucketException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchBucketException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchBucketException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Config rule in the request is not valid. Verify that the rule is an Config
// Custom Policy rule, that the rule name is correct, and that valid Amazon
// Resouce Names (ARNs) are used before trying again.
type NoSuchConfigRuleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConfigRuleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConfigRuleException) GoString() string {
	return s.String()
}

func newErrorNoSuchConfigRuleException(v protocol.ResponseMetadata) error {
	return &NoSuchConfigRuleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConfigRuleException) Code() string {
	return "NoSuchConfigRuleException"
}

// Message returns the exception's message.
func (s *NoSuchConfigRuleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConfigRuleException) OrigErr() error {
	return nil
}

func (s *NoSuchConfigRuleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConfigRuleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConfigRuleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Config rule that you passed in the filter does not exist.
type NoSuchConfigRuleInConformancePackException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConfigRuleInConformancePackException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConfigRuleInConformancePackException) GoString() string {
	return s.String()
}

func newErrorNoSuchConfigRuleInConformancePackException(v protocol.ResponseMetadata) error {
	return &NoSuchConfigRuleInConformancePackException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConfigRuleInConformancePackException) Code() string {
	return "NoSuchConfigRuleInConformancePackException"
}

// Message returns the exception's message.
func (s *NoSuchConfigRuleInConformancePackException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConfigRuleInConformancePackException) OrigErr() error {
	return nil
}

func (s *NoSuchConfigRuleInConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConfigRuleInConformancePackException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConfigRuleInConformancePackException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a configuration aggregator that does not exist.
type NoSuchConfigurationAggregatorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConfigurationAggregatorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConfigurationAggregatorException) GoString() string {
	return s.String()
}

func newErrorNoSuchConfigurationAggregatorException(v protocol.ResponseMetadata) error {
	return &NoSuchConfigurationAggregatorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConfigurationAggregatorException) Code() string {
	return "NoSuchConfigurationAggregatorException"
}

// Message returns the exception's message.
func (s *NoSuchConfigurationAggregatorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConfigurationAggregatorException) OrigErr() error {
	return nil
}

func (s *NoSuchConfigurationAggregatorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConfigurationAggregatorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConfigurationAggregatorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a configuration recorder that does not exist.
type NoSuchConfigurationRecorderException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConfigurationRecorderException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConfigurationRecorderException) GoString() string {
	return s.String()
}

func newErrorNoSuchConfigurationRecorderException(v protocol.ResponseMetadata) error {
	return &NoSuchConfigurationRecorderException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConfigurationRecorderException) Code() string {
	return "NoSuchConfigurationRecorderException"
}

// Message returns the exception's message.
func (s *NoSuchConfigurationRecorderException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConfigurationRecorderException) OrigErr() error {
	return nil
}

func (s *NoSuchConfigurationRecorderException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConfigurationRecorderException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConfigurationRecorderException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You specified one or more conformance packs that do not exist.
type NoSuchConformancePackException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConformancePackException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchConformancePackException) GoString() string {
	return s.String()
}

func newErrorNoSuchConformancePackException(v protocol.ResponseMetadata) error {
	return &NoSuchConformancePackException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchConformancePackException) Code() string {
	return "NoSuchConformancePackException"
}

// Message returns the exception's message.
func (s *NoSuchConformancePackException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchConformancePackException) OrigErr() error {
	return nil
}

func (s *NoSuchConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchConformancePackException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchConformancePackException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a delivery channel that does not exist.
type NoSuchDeliveryChannelException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchDeliveryChannelException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchDeliveryChannelException) GoString() string {
	return s.String()
}

func newErrorNoSuchDeliveryChannelException(v protocol.ResponseMetadata) error {
	return &NoSuchDeliveryChannelException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchDeliveryChannelException) Code() string {
	return "NoSuchDeliveryChannelException"
}

// Message returns the exception's message.
func (s *NoSuchDeliveryChannelException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchDeliveryChannelException) OrigErr() error {
	return nil
}

func (s *NoSuchDeliveryChannelException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchDeliveryChannelException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchDeliveryChannelException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Config rule in the request is not valid. Verify that the rule is an organization
// Config Custom Policy rule, that the rule name is correct, and that valid
// Amazon Resouce Names (ARNs) are used before trying again.
type NoSuchOrganizationConfigRuleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchOrganizationConfigRuleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchOrganizationConfigRuleException) GoString() string {
	return s.String()
}

func newErrorNoSuchOrganizationConfigRuleException(v protocol.ResponseMetadata) error {
	return &NoSuchOrganizationConfigRuleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchOrganizationConfigRuleException) Code() string {
	return "NoSuchOrganizationConfigRuleException"
}

// Message returns the exception's message.
func (s *NoSuchOrganizationConfigRuleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchOrganizationConfigRuleException) OrigErr() error {
	return nil
}

func (s *NoSuchOrganizationConfigRuleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchOrganizationConfigRuleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchOrganizationConfigRuleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Config organization conformance pack that you passed in the filter does not
// exist.
//
// For DeleteOrganizationConformancePack, you tried to delete an organization
// conformance pack that does not exist.
type NoSuchOrganizationConformancePackException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchOrganizationConformancePackException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchOrganizationConformancePackException) GoString() string {
	return s.String()
}

func newErrorNoSuchOrganizationConformancePackException(v protocol.ResponseMetadata) error {
	return &NoSuchOrganizationConformancePackException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchOrganizationConformancePackException) Code() string {
	return "NoSuchOrganizationConformancePackException"
}

// Message returns the exception's message.
func (s *NoSuchOrganizationConformancePackException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchOrganizationConformancePackException) OrigErr() error {
	return nil
}

func (s *NoSuchOrganizationConformancePackException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchOrganizationConformancePackException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchOrganizationConformancePackException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You specified an Config rule without a remediation configuration.
type NoSuchRemediationConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchRemediationConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchRemediationConfigurationException) GoString() string {
	return s.String()
}

func newErrorNoSuchRemediationConfigurationException(v protocol.ResponseMetadata) error {
	return &NoSuchRemediationConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchRemediationConfigurationException) Code() string {
	return "NoSuchRemediationConfigurationException"
}

// Message returns the exception's message.
func (s *NoSuchRemediationConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchRemediationConfigurationException) OrigErr() error {
	return nil
}

func (s *NoSuchRemediationConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchRemediationConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchRemediationConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You tried to delete a remediation exception that does not exist.
type NoSuchRemediationExceptionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchRemediationExceptionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchRemediationExceptionException) GoString() string {
	return s.String()
}

func newErrorNoSuchRemediationExceptionException(v protocol.ResponseMetadata) error {
	return &NoSuchRemediationExceptionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchRemediationExceptionException) Code() string {
	return "NoSuchRemediationExceptionException"
}

// Message returns the exception's message.
func (s *NoSuchRemediationExceptionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchRemediationExceptionException) OrigErr() error {
	return nil
}

func (s *NoSuchRemediationExceptionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchRemediationExceptionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchRemediationExceptionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified a retention configuration that does not exist.
type NoSuchRetentionConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchRetentionConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoSuchRetentionConfigurationException) GoString() string {
	return s.String()
}

func newErrorNoSuchRetentionConfigurationException(v protocol.ResponseMetadata) error {
	return &NoSuchRetentionConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoSuchRetentionConfigurationException) Code() string {
	return "NoSuchRetentionConfigurationException"
}

// Message returns the exception's message.
func (s *NoSuchRetentionConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoSuchRetentionConfigurationException) OrigErr() error {
	return nil
}

func (s *NoSuchRetentionConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoSuchRetentionConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoSuchRetentionConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// For PutConfigurationAggregator API, you can see this exception for the following
// reasons:
//
//    * No permission to call EnableAWSServiceAccess API
//
//    * The configuration aggregator cannot be updated because your Amazon Web
//    Services Organization management account or the delegated administrator
//    role changed. Delete this aggregator and create a new one with the current
//    Amazon Web Services Organization.
//
//    * The configuration aggregator is associated with a previous Amazon Web
//    Services Organization and Config cannot aggregate data with current Amazon
//    Web Services Organization. Delete this aggregator and create a new one
//    with the current Amazon Web Services Organization.
//
//    * You are not a registered delegated administrator for Config with permissions
//    to call ListDelegatedAdministrators API. Ensure that the management account
//    registers delagated administrator for Config service principle name before
//    the delegated administrator creates an aggregator.
//
// For all OrganizationConfigRule and OrganizationConformancePack APIs, Config
// throws an exception if APIs are called from member accounts. All APIs must
// be called from organization master account.
type OrganizationAccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationAccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationAccessDeniedException) GoString() string {
	return s.String()
}

func newErrorOrganizationAccessDeniedException(v protocol.ResponseMetadata) error {
	return &OrganizationAccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationAccessDeniedException) Code() string {
	return "OrganizationAccessDeniedException"
}

// Message returns the exception's message.
func (s *OrganizationAccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationAccessDeniedException) OrigErr() error {
	return nil
}

func (s *OrganizationAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationAccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationAccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This object contains regions to set up the aggregator and an IAM role to
// retrieve organization details.
type OrganizationAggregationSource struct {
	_ struct{} `type:"structure"`

	// If true, aggregate existing Config regions and future regions.
	AllAwsRegions *bool `type:"boolean"`

	// The source regions being aggregated.
	AwsRegions []*string `min:"1" type:"list"`

	// ARN of the IAM role used to retrieve Amazon Web Services Organization details
	// associated with the aggregator account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationAggregationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationAggregationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationAggregationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrganizationAggregationSource"}
	if s.AwsRegions != nil && len(s.AwsRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegions", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllAwsRegions sets the AllAwsRegions field's value.
func (s *OrganizationAggregationSource) SetAllAwsRegions(v bool) *OrganizationAggregationSource {
	s.AllAwsRegions = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *OrganizationAggregationSource) SetAwsRegions(v []*string) *OrganizationAggregationSource {
	s.AwsRegions = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *OrganizationAggregationSource) SetRoleArn(v string) *OrganizationAggregationSource {
	s.RoleArn = &v
	return s
}

// Config resource cannot be created because your organization does not have
// all features enabled.
type OrganizationAllFeaturesNotEnabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationAllFeaturesNotEnabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationAllFeaturesNotEnabledException) GoString() string {
	return s.String()
}

func newErrorOrganizationAllFeaturesNotEnabledException(v protocol.ResponseMetadata) error {
	return &OrganizationAllFeaturesNotEnabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationAllFeaturesNotEnabledException) Code() string {
	return "OrganizationAllFeaturesNotEnabledException"
}

// Message returns the exception's message.
func (s *OrganizationAllFeaturesNotEnabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationAllFeaturesNotEnabledException) OrigErr() error {
	return nil
}

func (s *OrganizationAllFeaturesNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationAllFeaturesNotEnabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationAllFeaturesNotEnabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An organization Config rule that has information about Config rules that
// Config creates in member accounts.
type OrganizationConfigRule struct {
	_ struct{} `type:"structure"`

	// A comma-separated list of accounts excluded from organization Config rule.
	ExcludedAccounts []*string `type:"list"`

	// The timestamp of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// Amazon Resource Name (ARN) of organization Config rule.
	//
	// OrganizationConfigRuleArn is a required field
	OrganizationConfigRuleArn *string `min:"1" type:"string" required:"true"`

	// The name that you assign to organization Config rule.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An object that specifies metadata for your organization's Config Custom Policy
	// rule. The metadata includes the runtime system in use, which accounts have
	// debug logging enabled, and other custom rule metadata, such as resource type,
	// resource ID of Amazon Web Services resource, and organization trigger types
	// that initiate Config to evaluate Amazon Web Services resources against a
	// rule.
	OrganizationCustomPolicyRuleMetadata *OrganizationCustomPolicyRuleMetadataNoPolicy `type:"structure"`

	// An OrganizationCustomRuleMetadata object.
	OrganizationCustomRuleMetadata *OrganizationCustomRuleMetadata `type:"structure"`

	// An OrganizationManagedRuleMetadata object.
	OrganizationManagedRuleMetadata *OrganizationManagedRuleMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConfigRule) GoString() string {
	return s.String()
}

// SetExcludedAccounts sets the ExcludedAccounts field's value.
func (s *OrganizationConfigRule) SetExcludedAccounts(v []*string) *OrganizationConfigRule {
	s.ExcludedAccounts = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConfigRule) SetLastUpdateTime(v time.Time) *OrganizationConfigRule {
	s.LastUpdateTime = &v
	return s
}

// SetOrganizationConfigRuleArn sets the OrganizationConfigRuleArn field's value.
func (s *OrganizationConfigRule) SetOrganizationConfigRuleArn(v string) *OrganizationConfigRule {
	s.OrganizationConfigRuleArn = &v
	return s
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *OrganizationConfigRule) SetOrganizationConfigRuleName(v string) *OrganizationConfigRule {
	s.OrganizationConfigRuleName = &v
	return s
}

// SetOrganizationCustomPolicyRuleMetadata sets the OrganizationCustomPolicyRuleMetadata field's value.
func (s *OrganizationConfigRule) SetOrganizationCustomPolicyRuleMetadata(v *OrganizationCustomPolicyRuleMetadataNoPolicy) *OrganizationConfigRule {
	s.OrganizationCustomPolicyRuleMetadata = v
	return s
}

// SetOrganizationCustomRuleMetadata sets the OrganizationCustomRuleMetadata field's value.
func (s *OrganizationConfigRule) SetOrganizationCustomRuleMetadata(v *OrganizationCustomRuleMetadata) *OrganizationConfigRule {
	s.OrganizationCustomRuleMetadata = v
	return s
}

// SetOrganizationManagedRuleMetadata sets the OrganizationManagedRuleMetadata field's value.
func (s *OrganizationConfigRule) SetOrganizationManagedRuleMetadata(v *OrganizationManagedRuleMetadata) *OrganizationConfigRule {
	s.OrganizationManagedRuleMetadata = v
	return s
}

// Returns the status for an organization Config rule in an organization.
type OrganizationConfigRuleStatus struct {
	_ struct{} `type:"structure"`

	// An error code that is returned when organization Config rule creation or
	// deletion has failed.
	ErrorCode *string `type:"string"`

	// An error message indicating that organization Config rule creation or deletion
	// failed due to an error.
	ErrorMessage *string `type:"string"`

	// The timestamp of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The name that you assign to organization Config rule.
	//
	// OrganizationConfigRuleName is a required field
	OrganizationConfigRuleName *string `min:"1" type:"string" required:"true"`

	// Indicates deployment status of an organization Config rule. When master account
	// calls PutOrganizationConfigRule action for the first time, Config rule status
	// is created in all the member accounts. When master account calls PutOrganizationConfigRule
	// action for the second time, Config rule status is updated in all the member
	// accounts. Additionally, Config rule status is updated when one or more member
	// accounts join or leave an organization. Config rule status is deleted when
	// the master account deletes OrganizationConfigRule in all the member accounts
	// and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// Config sets the state of the rule to:
	//
	//    * CREATE_SUCCESSFUL when an organization Config rule has been successfully
	//    created in all the member accounts.
	//
	//    * CREATE_IN_PROGRESS when an organization Config rule creation is in progress.
	//
	//    * CREATE_FAILED when an organization Config rule creation failed in one
	//    or more member accounts within that organization.
	//
	//    * DELETE_FAILED when an organization Config rule deletion failed in one
	//    or more member accounts within that organization.
	//
	//    * DELETE_IN_PROGRESS when an organization Config rule deletion is in progress.
	//
	//    * DELETE_SUCCESSFUL when an organization Config rule has been successfully
	//    deleted from all the member accounts.
	//
	//    * UPDATE_SUCCESSFUL when an organization Config rule has been successfully
	//    updated in all the member accounts.
	//
	//    * UPDATE_IN_PROGRESS when an organization Config rule update is in progress.
	//
	//    * UPDATE_FAILED when an organization Config rule update failed in one
	//    or more member accounts within that organization.
	//
	// OrganizationRuleStatus is a required field
	OrganizationRuleStatus *string `type:"string" required:"true" enum:"OrganizationRuleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConfigRuleStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConfigRuleStatus) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *OrganizationConfigRuleStatus) SetErrorCode(v string) *OrganizationConfigRuleStatus {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *OrganizationConfigRuleStatus) SetErrorMessage(v string) *OrganizationConfigRuleStatus {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConfigRuleStatus) SetLastUpdateTime(v time.Time) *OrganizationConfigRuleStatus {
	s.LastUpdateTime = &v
	return s
}

// SetOrganizationConfigRuleName sets the OrganizationConfigRuleName field's value.
func (s *OrganizationConfigRuleStatus) SetOrganizationConfigRuleName(v string) *OrganizationConfigRuleStatus {
	s.OrganizationConfigRuleName = &v
	return s
}

// SetOrganizationRuleStatus sets the OrganizationRuleStatus field's value.
func (s *OrganizationConfigRuleStatus) SetOrganizationRuleStatus(v string) *OrganizationConfigRuleStatus {
	s.OrganizationRuleStatus = &v
	return s
}

// An organization conformance pack that has information about conformance packs
// that Config creates in member accounts.
type OrganizationConformancePack struct {
	_ struct{} `type:"structure"`

	// A list of ConformancePackInputParameter objects.
	ConformancePackInputParameters []*ConformancePackInputParameter `type:"list"`

	// The name of the Amazon S3 bucket where Config stores conformance pack templates.
	//
	// This field is optional.
	DeliveryS3Bucket *string `type:"string"`

	// Any folder structure you want to add to an Amazon S3 bucket.
	//
	// This field is optional.
	DeliveryS3KeyPrefix *string `type:"string"`

	// A comma-separated list of accounts excluded from organization conformance
	// pack.
	ExcludedAccounts []*string `type:"list"`

	// Last time when organization conformation pack was updated.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `type:"timestamp" required:"true"`

	// Amazon Resource Name (ARN) of organization conformance pack.
	//
	// OrganizationConformancePackArn is a required field
	OrganizationConformancePackArn *string `min:"1" type:"string" required:"true"`

	// The name you assign to an organization conformance pack.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConformancePack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConformancePack) GoString() string {
	return s.String()
}

// SetConformancePackInputParameters sets the ConformancePackInputParameters field's value.
func (s *OrganizationConformancePack) SetConformancePackInputParameters(v []*ConformancePackInputParameter) *OrganizationConformancePack {
	s.ConformancePackInputParameters = v
	return s
}

// SetDeliveryS3Bucket sets the DeliveryS3Bucket field's value.
func (s *OrganizationConformancePack) SetDeliveryS3Bucket(v string) *OrganizationConformancePack {
	s.DeliveryS3Bucket = &v
	return s
}

// SetDeliveryS3KeyPrefix sets the DeliveryS3KeyPrefix field's value.
func (s *OrganizationConformancePack) SetDeliveryS3KeyPrefix(v string) *OrganizationConformancePack {
	s.DeliveryS3KeyPrefix = &v
	return s
}

// SetExcludedAccounts sets the ExcludedAccounts field's value.
func (s *OrganizationConformancePack) SetExcludedAccounts(v []*string) *OrganizationConformancePack {
	s.ExcludedAccounts = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConformancePack) SetLastUpdateTime(v time.Time) *OrganizationConformancePack {
	s.LastUpdateTime = &v
	return s
}

// SetOrganizationConformancePackArn sets the OrganizationConformancePackArn field's value.
func (s *OrganizationConformancePack) SetOrganizationConformancePackArn(v string) *OrganizationConformancePack {
	s.OrganizationConformancePackArn = &v
	return s
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *OrganizationConformancePack) SetOrganizationConformancePackName(v string) *OrganizationConformancePack {
	s.OrganizationConformancePackName = &v
	return s
}

// Organization conformance pack creation or deletion status in each member
// account. This includes the name of the conformance pack, the status, error
// code and error message when the conformance pack creation or deletion failed.
type OrganizationConformancePackDetailedStatus struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of a member account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The name of conformance pack deployed in the member account.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// An error code that is returned when conformance pack creation or deletion
	// failed in the member account.
	ErrorCode *string `type:"string"`

	// An error message indicating that conformance pack account creation or deletion
	// has failed due to an error in the member account.
	ErrorMessage *string `type:"string"`

	// The timestamp of the last status update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// Indicates deployment status for conformance pack in a member account. When
	// master account calls PutOrganizationConformancePack action for the first
	// time, conformance pack status is created in the member account. When master
	// account calls PutOrganizationConformancePack action for the second time,
	// conformance pack status is updated in the member account. Conformance pack
	// status is deleted when the master account deletes OrganizationConformancePack
	// and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// Config sets the state of the conformance pack to:
	//
	//    * CREATE_SUCCESSFUL when conformance pack has been created in the member
	//    account.
	//
	//    * CREATE_IN_PROGRESS when conformance pack is being created in the member
	//    account.
	//
	//    * CREATE_FAILED when conformance pack creation has failed in the member
	//    account.
	//
	//    * DELETE_FAILED when conformance pack deletion has failed in the member
	//    account.
	//
	//    * DELETE_IN_PROGRESS when conformance pack is being deleted in the member
	//    account.
	//
	//    * DELETE_SUCCESSFUL when conformance pack has been deleted in the member
	//    account.
	//
	//    * UPDATE_SUCCESSFUL when conformance pack has been updated in the member
	//    account.
	//
	//    * UPDATE_IN_PROGRESS when conformance pack is being updated in the member
	//    account.
	//
	//    * UPDATE_FAILED when conformance pack deletion has failed in the member
	//    account.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"OrganizationResourceDetailedStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConformancePackDetailedStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConformancePackDetailedStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *OrganizationConformancePackDetailedStatus) SetAccountId(v string) *OrganizationConformancePackDetailedStatus {
	s.AccountId = &v
	return s
}

// SetConformancePackName sets the ConformancePackName field's value.
func (s *OrganizationConformancePackDetailedStatus) SetConformancePackName(v string) *OrganizationConformancePackDetailedStatus {
	s.ConformancePackName = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *OrganizationConformancePackDetailedStatus) SetErrorCode(v string) *OrganizationConformancePackDetailedStatus {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *OrganizationConformancePackDetailedStatus) SetErrorMessage(v string) *OrganizationConformancePackDetailedStatus {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConformancePackDetailedStatus) SetLastUpdateTime(v time.Time) *OrganizationConformancePackDetailedStatus {
	s.LastUpdateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrganizationConformancePackDetailedStatus) SetStatus(v string) *OrganizationConformancePackDetailedStatus {
	s.Status = &v
	return s
}

// Returns the status for an organization conformance pack in an organization.
type OrganizationConformancePackStatus struct {
	_ struct{} `type:"structure"`

	// An error code that is returned when organization conformance pack creation
	// or deletion has failed in a member account.
	ErrorCode *string `type:"string"`

	// An error message indicating that organization conformance pack creation or
	// deletion failed due to an error.
	ErrorMessage *string `type:"string"`

	// The timestamp of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The name that you assign to organization conformance pack.
	//
	// OrganizationConformancePackName is a required field
	OrganizationConformancePackName *string `min:"1" type:"string" required:"true"`

	// Indicates deployment status of an organization conformance pack. When master
	// account calls PutOrganizationConformancePack for the first time, conformance
	// pack status is created in all the member accounts. When master account calls
	// PutOrganizationConformancePack for the second time, conformance pack status
	// is updated in all the member accounts. Additionally, conformance pack status
	// is updated when one or more member accounts join or leave an organization.
	// Conformance pack status is deleted when the master account deletes OrganizationConformancePack
	// in all the member accounts and disables service access for config-multiaccountsetup.amazonaws.com.
	//
	// Config sets the state of the conformance pack to:
	//
	//    * CREATE_SUCCESSFUL when an organization conformance pack has been successfully
	//    created in all the member accounts.
	//
	//    * CREATE_IN_PROGRESS when an organization conformance pack creation is
	//    in progress.
	//
	//    * CREATE_FAILED when an organization conformance pack creation failed
	//    in one or more member accounts within that organization.
	//
	//    * DELETE_FAILED when an organization conformance pack deletion failed
	//    in one or more member accounts within that organization.
	//
	//    * DELETE_IN_PROGRESS when an organization conformance pack deletion is
	//    in progress.
	//
	//    * DELETE_SUCCESSFUL when an organization conformance pack has been successfully
	//    deleted from all the member accounts.
	//
	//    * UPDATE_SUCCESSFUL when an organization conformance pack has been successfully
	//    updated in all the member accounts.
	//
	//    * UPDATE_IN_PROGRESS when an organization conformance pack update is in
	//    progress.
	//
	//    * UPDATE_FAILED when an organization conformance pack update failed in
	//    one or more member accounts within that organization.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"OrganizationResourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConformancePackStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConformancePackStatus) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *OrganizationConformancePackStatus) SetErrorCode(v string) *OrganizationConformancePackStatus {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *OrganizationConformancePackStatus) SetErrorMessage(v string) *OrganizationConformancePackStatus {
	s.ErrorMessage = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *OrganizationConformancePackStatus) SetLastUpdateTime(v time.Time) *OrganizationConformancePackStatus {
	s.LastUpdateTime = &v
	return s
}

// SetOrganizationConformancePackName sets the OrganizationConformancePackName field's value.
func (s *OrganizationConformancePackStatus) SetOrganizationConformancePackName(v string) *OrganizationConformancePackStatus {
	s.OrganizationConformancePackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrganizationConformancePackStatus) SetStatus(v string) *OrganizationConformancePackStatus {
	s.Status = &v
	return s
}

// You have specified a template that is not valid or supported.
type OrganizationConformancePackTemplateValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConformancePackTemplateValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrganizationConformancePackTemplateValidationException) GoString() string {
	return s.String()
}

func newErrorOrganizationConformancePackTemplateValidationException(v protocol.ResponseMetadata) error {
	return &OrganizationConformancePackTemplateValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationConformancePackTemplateValidationException) Code() string {
	return "OrganizationConformancePackTemplateValidationException"
}

// Message returns the exception's message.
func (s *OrganizationConformancePackTemplateValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationConformancePackTemplateValidationException) OrigErr() error {
	return nil
}

func (s *OrganizationConformancePackTemplateValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationConformancePackTemplateValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationConformancePackTemplateValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that specifies metadata for your organization's Config Custom Policy
// rule. The metadata includes the runtime system in use, which accounts have
// debug logging enabled, and other custom rule metadata, such as resource type,
// resource ID of Amazon Web Services resource, and organization trigger types
// that initiate Config to evaluate Amazon Web Services resources against a
// rule.
type OrganizationCustomPolicyRuleMetadata struct {
	_ struct{} `type:"structure"`

	// A list of accounts that you can enable debug logging for your organization
	// Config Custom Policy rule. List is null when debug logging is enabled for
	// all accounts.
	DebugLogDeliveryAccounts []*string `type:"list"`

	// The description that you provide for your organization Config Custom Policy
	// rule.
	Description *string `type:"string"`

	// A string, in JSON format, that is passed to your organization Config Custom
	// Policy rule.
	InputParameters *string `min:"1" type:"string"`

	// The maximum frequency with which Config runs evaluations for a rule. Your
	// Config Custom Policy rule is triggered when Config delivers the configuration
	// snapshot. For more information, see ConfigSnapshotDeliveryProperties.
	MaximumExecutionFrequency *string `type:"string" enum:"MaximumExecutionFrequency"`

	// The type of notification that initiates Config to run an evaluation for a
	// rule. For Config Custom Policy rules, Config supports change-initiated notification
	// types:
	//
	//    * ConfigurationItemChangeNotification - Initiates an evaluation when Config
	//    delivers a configuration item as a result of a resource change.
	//
	//    * OversizedConfigurationItemChangeNotification - Initiates an evaluation
	//    when Config delivers an oversized configuration item. Config may generate
	//    this notification type when a resource changes and the notification exceeds
	//    the maximum size allowed by Amazon SNS.
	OrganizationConfigRuleTriggerTypes []*string `type:"list" enum:"OrganizationConfigRuleTriggerTypeNoSN"`

	// The runtime system for your organization Config Custom Policy rules. Guard
	// is a policy-as-code language that allows you to write policies that are enforced
	// by Config Custom Policy rules. For more informat