// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package protoniface provides an interface to enable mocking the AWS Proton service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package protoniface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/proton"
)

// ProtonAPI provides an interface to enable mocking the
// proton.Proton service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Proton.
//	func myFunc(svc protoniface.ProtonAPI) bool {
//	    // Make svc.AcceptEnvironmentAccountConnection request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := proton.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockProtonClient struct {
//	    protoniface.ProtonAPI
//	}
//	func (m *mockProtonClient) AcceptEnvironmentAccountConnection(input *proton.AcceptEnvironmentAccountConnectionInput) (*proton.AcceptEnvironmentAccountConnectionOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockProtonClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ProtonAPI interface {
	AcceptEnvironmentAccountConnection(*proton.AcceptEnvironmentAccountConnectionInput) (*proton.AcceptEnvironmentAccountConnectionOutput, error)
	AcceptEnvironmentAccountConnectionWithContext(aws.Context, *proton.AcceptEnvironmentAccountConnectionInput, ...request.Option) (*proton.AcceptEnvironmentAccountConnectionOutput, error)
	AcceptEnvironmentAccountConnectionRequest(*proton.AcceptEnvironmentAccountConnectionInput) (*request.Request, *proton.AcceptEnvironmentAccountConnectionOutput)

	CancelComponentDeployment(*proton.CancelComponentDeploymentInput) (*proton.CancelComponentDeploymentOutput, error)
	CancelComponentDeploymentWithContext(aws.Context, *proton.CancelComponentDeploymentInput, ...request.Option) (*proton.CancelComponentDeploymentOutput, error)
	CancelComponentDeploymentRequest(*proton.CancelComponentDeploymentInput) (*request.Request, *proton.CancelComponentDeploymentOutput)

	CancelEnvironmentDeployment(*proton.CancelEnvironmentDeploymentInput) (*proton.CancelEnvironmentDeploymentOutput, error)
	CancelEnvironmentDeploymentWithContext(aws.Context, *proton.CancelEnvironmentDeploymentInput, ...request.Option) (*proton.CancelEnvironmentDeploymentOutput, error)
	CancelEnvironmentDeploymentRequest(*proton.CancelEnvironmentDeploymentInput) (*request.Request, *proton.CancelEnvironmentDeploymentOutput)

	CancelServiceInstanceDeployment(*proton.CancelServiceInstanceDeploymentInput) (*proton.CancelServiceInstanceDeploymentOutput, error)
	CancelServiceInstanceDeploymentWithContext(aws.Context, *proton.CancelServiceInstanceDeploymentInput, ...request.Option) (*proton.CancelServiceInstanceDeploymentOutput, error)
	CancelServiceInstanceDeploymentRequest(*proton.CancelServiceInstanceDeploymentInput) (*request.Request, *proton.CancelServiceInstanceDeploymentOutput)

	CancelServicePipelineDeployment(*proton.CancelServicePipelineDeploymentInput) (*proton.CancelServicePipelineDeploymentOutput, error)
	CancelServicePipelineDeploymentWithContext(aws.Context, *proton.CancelServicePipelineDeploymentInput, ...request.Option) (*proton.CancelServicePipelineDeploymentOutput, error)
	CancelServicePipelineDeploymentRequest(*proton.CancelServicePipelineDeploymentInput) (*request.Request, *proton.CancelServicePipelineDeploymentOutput)

	CreateComponent(*proton.CreateComponentInput) (*proton.CreateComponentOutput, error)
	CreateComponentWithContext(aws.Context, *proton.CreateComponentInput, ...request.Option) (*proton.CreateComponentOutput, error)
	CreateComponentRequest(*proton.CreateComponentInput) (*request.Request, *proton.CreateComponentOutput)

	CreateEnvironment(*proton.CreateEnvironmentInput) (*proton.CreateEnvironmentOutput, error)
	CreateEnvironmentWithContext(aws.Context, *proton.CreateEnvironmentInput, ...request.Option) (*proton.CreateEnvironmentOutput, error)
	CreateEnvironmentRequest(*proton.CreateEnvironmentInput) (*request.Request, *proton.CreateEnvironmentOutput)

	CreateEnvironmentAccountConnection(*proton.CreateEnvironmentAccountConnectionInput) (*proton.CreateEnvironmentAccountConnectionOutput, error)
	CreateEnvironmentAccountConnectionWithContext(aws.Context, *proton.CreateEnvironmentAccountConnectionInput, ...request.Option) (*proton.CreateEnvironmentAccountConnectionOutput, error)
	CreateEnvironmentAccountConnectionRequest(*proton.CreateEnvironmentAccountConnectionInput) (*request.Request, *proton.CreateEnvironmentAccountConnectionOutput)

	CreateEnvironmentTemplate(*proton.CreateEnvironmentTemplateInput) (*proton.CreateEnvironmentTemplateOutput, error)
	CreateEnvironmentTemplateWithContext(aws.Context, *proton.CreateEnvironmentTemplateInput, ...request.Option) (*proton.CreateEnvironmentTemplateOutput, error)
	CreateEnvironmentTemplateRequest(*proton.CreateEnvironmentTemplateInput) (*request.Request, *proton.CreateEnvironmentTemplateOutput)

	CreateEnvironmentTemplateVersion(*proton.CreateEnvironmentTemplateVersionInput) (*proton.CreateEnvironmentTemplateVersionOutput, error)
	CreateEnvironmentTemplateVersionWithContext(aws.Context, *proton.CreateEnvironmentTemplateVersionInput, ...request.Option) (*proton.CreateEnvironmentTemplateVersionOutput, error)
	CreateEnvironmentTemplateVersionRequest(*proton.CreateEnvironmentTemplateVersionInput) (*request.Request, *proton.CreateEnvironmentTemplateVersionOutput)

	CreateRepository(*proton.CreateRepositoryInput) (*proton.CreateRepositoryOutput, error)
	CreateRepositoryWithContext(aws.Context, *proton.CreateRepositoryInput, ...request.Option) (*proton.CreateRepositoryOutput, error)
	CreateRepositoryRequest(*proton.CreateRepositoryInput) (*request.Request, *proton.CreateRepositoryOutput)

	CreateService(*proton.CreateServiceInput) (*proton.CreateServiceOutput, error)
	CreateServiceWithContext(aws.Context, *proton.CreateServiceInput, ...request.Option) (*proton.CreateServiceOutput, error)
	CreateServiceRequest(*proton.CreateServiceInput) (*request.Request, *proton.CreateServiceOutput)

	CreateServiceTemplate(*proton.CreateServiceTemplateInput) (*proton.CreateServiceTemplateOutput, error)
	CreateServiceTemplateWithContext(aws.Context, *proton.CreateServiceTemplateInput, ...request.Option) (*proton.CreateServiceTemplateOutput, error)
	CreateServiceTemplateRequest(*proton.CreateServiceTemplateInput) (*request.Request, *proton.CreateServiceTemplateOutput)

	CreateServiceTemplateVersion(*proton.CreateServiceTemplateVersionInput) (*proton.CreateServiceTemplateVersionOutput, error)
	CreateServiceTemplateVersionWithContext(aws.Context, *proton.CreateServiceTemplateVersionInput, ...request.Option) (*proton.CreateServiceTemplateVersionOutput, error)
	CreateServiceTemplateVersionRequest(*proton.CreateServiceTemplateVersionInput) (*request.Request, *proton.CreateServiceTemplateVersionOutput)

	CreateTemplateSyncConfig(*proton.CreateTemplateSyncConfigInput) (*proton.CreateTemplateSyncConfigOutput, error)
	CreateTemplateSyncConfigWithContext(aws.Context, *proton.CreateTemplateSyncConfigInput, ...request.Option) (*proton.CreateTemplateSyncConfigOutput, error)
	CreateTemplateSyncConfigRequest(*proton.CreateTemplateSyncConfigInput) (*request.Request, *proton.CreateTemplateSyncConfigOutput)

	DeleteComponent(*proton.DeleteComponentInput) (*proton.DeleteComponentOutput, error)
	DeleteComponentWithContext(aws.Context, *proton.DeleteComponentInput, ...request.Option) (*proton.DeleteComponentOutput, error)
	DeleteComponentRequest(*proton.DeleteComponentInput) (*request.Request, *proton.DeleteComponentOutput)

	DeleteEnvironment(*proton.DeleteEnvironmentInput) (*proton.DeleteEnvironmentOutput, error)
	DeleteEnvironmentWithContext(aws.Context, *proton.DeleteEnvironmentInput, ...request.Option) (*proton.DeleteEnvironmentOutput, error)
	DeleteEnvironmentRequest(*proton.DeleteEnvironmentInput) (*request.Request, *proton.DeleteEnvironmentOutput)

	DeleteEnvironmentAccountConnection(*proton.DeleteEnvironmentAccountConnectionInput) (*proton.DeleteEnvironmentAccountConnectionOutput, error)
	DeleteEnvironmentAccountConnectionWithContext(aws.Context, *proton.DeleteEnvironmentAccountConnectionInput, ...request.Option) (*proton.DeleteEnvironmentAccountConnectionOutput, error)
	DeleteEnvironmentAccountConnectionRequest(*proton.DeleteEnvironmentAccountConnectionInput) (*request.Request, *proton.DeleteEnvironmentAccountConnectionOutput)

	DeleteEnvironmentTemplate(*proton.DeleteEnvironmentTemplateInput) (*proton.DeleteEnvironmentTemplateOutput, error)
	DeleteEnvironmentTemplateWithContext(aws.Context, *proton.DeleteEnvironmentTemplateInput, ...request.Option) (*proton.DeleteEnvironmentTemplateOutput, error)
	DeleteEnvironmentTemplateRequest(*proton.DeleteEnvironmentTemplateInput) (*request.Request, *proton.DeleteEnvironmentTemplateOutput)

	DeleteEnvironmentTemplateVersion(*proton.DeleteEnvironmentTemplateVersionInput) (*proton.DeleteEnvironmentTemplateVersionOutput, error)
	DeleteEnvironmentTemplateVersionWithContext(aws.Context, *proton.DeleteEnvironmentTemplateVersionInput, ...request.Option) (*proton.DeleteEnvironmentTemplateVersionOutput, error)
	DeleteEnvironmentTemplateVersionRequest(*proton.DeleteEnvironmentTemplateVersionInput) (*request.Request, *proton.DeleteEnvironmentTemplateVersionOutput)

	DeleteRepository(*proton.DeleteRepositoryInput) (*proton.DeleteRepositoryOutput, error)
	DeleteRepositoryWithContext(aws.Context, *proton.DeleteRepositoryInput, ...request.Option) (*proton.DeleteRepositoryOutput, error)
	DeleteRepositoryRequest(*proton.DeleteRepositoryInput) (*request.Request, *proton.DeleteRepositoryOutput)

	DeleteService(*proton.DeleteServiceInput) (*proton.DeleteServiceOutput, error)
	DeleteServiceWithContext(aws.Context, *proton.DeleteServiceInput, ...request.Option) (*proton.DeleteServiceOutput, error)
	DeleteServiceRequest(*proton.DeleteServiceInput) (*request.Request, *proton.DeleteServiceOutput)

	DeleteServiceTemplate(*proton.DeleteServiceTemplateInput) (*proton.DeleteServiceTemplateOutput, error)
	DeleteServiceTemplateWithContext(aws.Context, *proton.DeleteServiceTemplateInput, ...request.Option) (*proton.DeleteServiceTemplateOutput, error)
	DeleteServiceTemplateRequest(*proton.DeleteServiceTemplateInput) (*request.Request, *proton.DeleteServiceTemplateOutput)

	DeleteServiceTemplateVersion(*proton.DeleteServiceTemplateVersionInput) (*proton.DeleteServiceTemplateVersionOutput, error)
	DeleteServiceTemplateVersionWithContext(aws.Context, *proton.DeleteServiceTemplateVersionInput, ...request.Option) (*proton.DeleteServiceTemplateVersionOutput, error)
	DeleteServiceTemplateVersionRequest(*proton.DeleteServiceTemplateVersionInput) (*request.Request, *proton.DeleteServiceTemplateVersionOutput)

	DeleteTemplateSyncConfig(*proton.DeleteTemplateSyncConfigInput) (*proton.DeleteTemplateSyncConfigOutput, error)
	DeleteTemplateSyncConfigWithContext(aws.Context, *proton.DeleteTemplateSyncConfigInput, ...request.Option) (*proton.DeleteTemplateSyncConfigOutput, error)
	DeleteTemplateSyncConfigRequest(*proton.DeleteTemplateSyncConfigInput) (*request.Request, *proton.DeleteTemplateSyncConfigOutput)

	GetAccountSettings(*proton.GetAccountSettingsInput) (*proton.GetAccountSettingsOutput, error)
	GetAccountSettingsWithContext(aws.Context, *proton.GetAccountSettingsInput, ...request.Option) (*proton.GetAccountSettingsOutput, error)
	GetAccountSettingsRequest(*proton.GetAccountSettingsInput) (*request.Request, *proton.GetAccountSettingsOutput)

	GetComponent(*proton.GetComponentInput) (*proton.GetComponentOutput, error)
	GetComponentWithContext(aws.Context, *proton.GetComponentInput, ...request.Option) (*proton.GetComponentOutput, error)
	GetComponentRequest(*proton.GetComponentInput) (*request.Request, *proton.GetComponentOutput)

	GetEnvironment(*proton.GetEnvironmentInput) (*proton.GetEnvironmentOutput, error)
	GetEnvironmentWithContext(aws.Context, *proton.GetEnvironmentInput, ...request.Option) (*proton.GetEnvironmentOutput, error)
	GetEnvironmentRequest(*proton.GetEnvironmentInput) (*request.Request, *proton.GetEnvironmentOutput)

	GetEnvironmentAccountConnection(*proton.GetEnvironmentAccountConnectionInput) (*proton.GetEnvironmentAccountConnectionOutput, error)
	GetEnvironmentAccountConnectionWithContext(aws.Context, *proton.GetEnvironmentAccountConnectionInput, ...request.Option) (*proton.GetEnvironmentAccountConnectionOutput, error)
	GetEnvironmentAccountConnectionRequest(*proton.GetEnvironmentAccountConnectionInput) (*request.Request, *proton.GetEnvironmentAccountConnectionOutput)

	GetEnvironmentTemplate(*proton.GetEnvironmentTemplateInput) (*proton.GetEnvironmentTemplateOutput, error)
	GetEnvironmentTemplateWithContext(aws.Context, *proton.GetEnvironmentTemplateInput, ...request.Option) (*proton.GetEnvironmentTemplateOutput, error)
	GetEnvironmentTemplateRequest(*proton.GetEnvironmentTemplateInput) (*request.Request, *proton.GetEnvironmentTemplateOutput)

	GetEnvironmentTemplateVersion(*proton.GetEnvironmentTemplateVersionInput) (*proton.GetEnvironmentTemplateVersionOutput, error)
	GetEnvironmentTemplateVersionWithContext(aws.Context, *proton.GetEnvironmentTemplateVersionInput, ...request.Option) (*proton.GetEnvironmentTemplateVersionOutput, error)
	GetEnvironmentTemplateVersionRequest(*proton.GetEnvironmentTemplateVersionInput) (*request.Request, *proton.GetEnvironmentTemplateVersionOutput)

	GetRepository(*proton.GetRepositoryInput) (*proton.GetRepositoryOutput, error)
	GetRepositoryWithContext(aws.Context, *proton.GetRepositoryInput, ...request.Option) (*proton.GetRepositoryOutput, error)
	GetRepositoryRequest(*proton.GetRepositoryInput) (*request.Request, *proton.GetRepositoryOutput)

	GetRepositorySyncStatus(*proton.GetRepositorySyncStatusInput) (*proton.GetRepositorySyncStatusOutput, error)
	GetRepositorySyncStatusWithContext(aws.Context, *proton.GetRepositorySyncStatusInput, ...request.Option) (*proton.GetRepositorySyncStatusOutput, error)
	GetRepositorySyncStatusRequest(*proton.GetRepositorySyncStatusInput) (*request.Request, *proton.GetRepositorySyncStatusOutput)

	GetResourcesSummary(*proton.GetResourcesSummaryInput) (*proton.GetResourcesSummaryOutput, error)
	GetResourcesSummaryWithContext(aws.Context, *proton.GetResourcesSummaryInput, ...request.Option) (*proton.GetResourcesSummaryOutput, error)
	GetResourcesSummaryRequest(*proton.GetResourcesSummaryInput) (*request.Request, *proton.GetResourcesSummaryOutput)

	GetService(*proton.GetServiceInput) (*proton.GetServiceOutput, error)
	GetServiceWithContext(aws.Context, *proton.GetServiceInput, ...request.Option) (*proton.GetServiceOutput, error)
	GetServiceRequest(*proton.GetServiceInput) (*request.Request, *proton.GetServiceOutput)

	GetServiceInstance(*proton.GetServiceInstanceInput) (*proton.GetServiceInstanceOutput, error)
	GetServiceInstanceWithContext(aws.Context, *proton.GetServiceInstanceInput, ...request.Option) (*proton.GetServiceInstanceOutput, error)
	GetServiceInstanceRequest(*proton.GetServiceInstanceInput) (*request.Request, *proton.GetServiceInstanceOutput)

	GetServiceTemplate(*proton.GetServiceTemplateInput) (*proton.GetServiceTemplateOutput, error)
	GetServiceTemplateWithContext(aws.Context, *proton.GetServiceTemplateInput, ...request.Option) (*proton.GetServiceTemplateOutput, error)
	GetServiceTemplateRequest(*proton.GetServiceTemplateInput) (*request.Request, *proton.GetServiceTemplateOutput)

	GetServiceTemplateVersion(*proton.GetServiceTemplateVersionInput) (*proton.GetServiceTemplateVersionOutput, error)
	GetServiceTemplateVersionWithContext(aws.Context, *proton.GetServiceTemplateVersionInput, ...request.Option) (*proton.GetServiceTemplateVersionOutput, error)
	GetServiceTemplateVersionRequest(*proton.GetServiceTemplateVersionInput) (*request.Request, *proton.GetServiceTemplateVersionOutput)

	GetTemplateSyncConfig(*proton.GetTemplateSyncConfigInput) (*proton.GetTemplateSyncConfigOutput, error)
	GetTemplateSyncConfigWithContext(aws.Context, *proton.GetTemplateSyncConfigInput, ...request.Option) (*proton.GetTemplateSyncConfigOutput, error)
	GetTemplateSyncConfigRequest(*proton.GetTemplateSyncConfigInput) (*request.Request, *proton.GetTemplateSyncConfigOutput)

	GetTemplateSyncStatus(*proton.GetTemplateSyncStatusInput) (*proton.GetTemplateSyncStatusOutput, error)
	GetTemplateSyncStatusWithContext(aws.Context, *proton.GetTemplateSyncStatusInput, ...request.Option) (*proton.GetTemplateSyncStatusOutput, error)
	GetTemplateSyncStatusRequest(*proton.GetTemplateSyncStatusInput) (*request.Request, *proton.GetTemplateSyncStatusOutput)

	ListComponentOutputs(*proton.ListComponentOutputsInput) (*proton.ListComponentOutputsOutput, error)
	ListComponentOutputsWithContext(aws.Context, *proton.ListComponentOutputsInput, ...request.Option) (*proton.ListComponentOutputsOutput, error)
	ListComponentOutputsRequest(*proton.ListComponentOutputsInput) (*request.Request, *proton.ListComponentOutputsOutput)

	ListComponentOutputsPages(*proton.ListComponentOutputsInput, func(*proton.ListComponentOutputsOutput, bool) bool) error
	ListComponentOutputsPagesWithContext(aws.Context, *proton.ListComponentOutputsInput, func(*proton.ListComponentOutputsOutput, bool) bool, ...request.Option) error

	ListComponentProvisionedResources(*proton.ListComponentProvisionedResourcesInput) (*proton.ListComponentProvisionedResourcesOutput, error)
	ListComponentProvisionedResourcesWithContext(aws.Context, *proton.ListComponentProvisionedResourcesInput, ...request.Option) (*proton.ListComponentProvisionedResourcesOutput, error)
	ListComponentProvisionedResourcesRequest(*proton.ListComponentProvisionedResourcesInput) (*request.Request, *proton.ListComponentProvisionedResourcesOutput)

	ListComponentProvisionedResourcesPages(*proton.ListComponentProvisionedResourcesInput, func(*proton.ListComponentProvisionedResourcesOutput, bool) bool) error
	ListComponentProvisionedResourcesPagesWithContext(aws.Context, *proton.ListComponentProvisionedResourcesInput, func(*proton.ListComponentProvisionedResourcesOutput, bool) bool, ...request.Option) error

	ListComponents(*proton.ListComponentsInput) (*proton.ListComponentsOutput, error)
	ListComponentsWithContext(aws.Context, *proton.ListComponentsInput, ...request.Option) (*proton.ListComponentsOutput, error)
	ListComponentsRequest(*proton.ListComponentsInput) (*request.Request, *proton.ListComponentsOutput)

	ListComponentsPages(*proton.ListComponentsInput, func(*proton.ListComponentsOutput, bool) bool) error
	ListComponentsPagesWithContext(aws.Context, *proton.ListComponentsInput, func(*proton.ListComponentsOutput, bool) bool, ...request.Option) error

	ListEnvironmentAccountConnections(*proton.ListEnvironmentAccountConnectionsInput) (*proton.ListEnvironmentAccountConnectionsOutput, error)
	ListEnvironmentAccountConnectionsWithContext(aws.Context, *proton.ListEnvironmentAccountConnectionsInput, ...request.Option) (*proton.ListEnvironmentAccountConnectionsOutput, error)
	ListEnvironmentAccountConnectionsRequest(*proton.ListEnvironmentAccountConnectionsInput) (*request.Request, *proton.ListEnvironmentAccountConnectionsOutput)

	ListEnvironmentAccountConnectionsPages(*proton.ListEnvironmentAccountConnectionsInput, func(*proton.ListEnvironmentAccountConnectionsOutput, bool) bool) error
	ListEnvironmentAccountConnectionsPagesWithContext(aws.Context, *proton.ListEnvironmentAccountConnectionsInput, func(*proton.ListEnvironmentAccountConnectionsOutput, bool) bool, ...request.Option) error

	ListEnvironmentOutputs(*proton.ListEnvironmentOutputsInput) (*proton.ListEnvironmentOutputsOutput, error)
	ListEnvironmentOutputsWithContext(aws.Context, *proton.ListEnvironmentOutputsInput, ...request.Option) (*proton.ListEnvironmentOutputsOutput, error)
	ListEnvironmentOutputsRequest(*proton.ListEnvironmentOutputsInput) (*request.Request, *proton.ListEnvironmentOutputsOutput)

	ListEnvironmentOutputsPages(*proton.ListEnvironmentOutputsInput, func(*proton.ListEnvironmentOutputsOutput, bool) bool) error
	ListEnvironmentOutputsPagesWithContext(aws.Context, *proton.ListEnvironmentOutputsInput, func(*proton.ListEnvironmentOutputsOutput, bool) bool, ...request.Option) error

	ListEnvironmentProvisionedResources(*proton.ListEnvironmentProvisionedResourcesInput) (*proton.ListEnvironmentProvisionedResourcesOutput, error)
	ListEnvironmentProvisionedResourcesWithContext(aws.Context, *proton.ListEnvironmentProvisionedResourcesInput, ...request.Option) (*proton.ListEnvironmentProvisionedResourcesOutput, error)
	ListEnvironmentProvisionedResourcesRequest(*proton.ListEnvironmentProvisionedResourcesInput) (*request.Request, *proton.ListEnvironmentProvisionedResourcesOutput)

	ListEnvironmentProvisionedResourcesPages(*proton.ListEnvironmentProvisionedResourcesInput, func(*proton.ListEnvironmentProvisionedResourcesOutput, bool) bool) error
	ListEnvironmentProvisionedResourcesPagesWithContext(aws.Context, *proton.ListEnvironmentProvisionedResourcesInput, func(*proton.ListEnvironmentProvisionedResourcesOutput, bool) bool, ...request.Option) error

	ListEnvironmentTemplateVersions(*proton.ListEnvironmentTemplateVersionsInput) (*proton.ListEnvironmentTemplateVersionsOutput, error)
	ListEnvironmentTemplateVersionsWithContext(aws.Context, *proton.ListEnvironmentTemplateVersionsInput, ...request.Option) (*proton.ListEnvironmentTemplateVersionsOutput, error)
	ListEnvironmentTemplateVersionsRequest(*proton.ListEnvironmentTemplateVersionsInput) (*request.Request, *proton.ListEnvironmentTemplateVersionsOutput)

	ListEnvironmentTemplateVersionsPages(*proton.ListEnvironmentTemplateVersionsInput, func(*proton.ListEnvironmentTemplateVersionsOutput, bool) bool) error
	ListEnvironmentTemplateVersionsPagesWithContext(aws.Context, *proton.ListEnvironmentTemplateVersionsInput, func(*proton.ListEnvironmentTemplateVersionsOutput, bool) bool, ...request.Option) error

	ListEnvironmentTemplates(*proton.ListEnvironmentTemplatesInput) (*proton.ListEnvironmentTemplatesOutput, error)
	ListEnvironmentTemplatesWithContext(aws.Context, *proton.ListEnvironmentTemplatesInput, ...request.Option) (*proton.ListEnvironmentTemplatesOutput, error)
	ListEnvironmentTemplatesRequest(*proton.ListEnvironmentTemplatesInput) (*request.Request, *proton.ListEnvironmentTemplatesOutput)

	ListEnvironmentTemplatesPages(*proton.ListEnvironmentTemplatesInput, func(*proton.ListEnvironmentTemplatesOutput, bool) bool) error
	ListEnvironmentTemplatesPagesWithContext(aws.Context, *proton.ListEnvironmentTemplatesInput, func(*proton.ListEnvironmentTemplatesOutput, bool) bool, ...request.Option) error

	ListEnvironments(*proton.ListEnvironmentsInput) (*proton.ListEnvironmentsOutput, error)
	ListEnvironmentsWithContext(aws.Context, *proton.ListEnvironmentsInput, ...request.Option) (*proton.ListEnvironmentsOutput, error)
	ListEnvironmentsRequest(*proton.ListEnvironmentsInput) (*request.Request, *proton.ListEnvironmentsOutput)

	ListEnvironmentsPages(*proton.ListEnvironmentsInput, func(*proton.ListEnvironmentsOutput, bool) bool) error
	ListEnvironmentsPagesWithContext(aws.Context, *proton.ListEnvironmentsInput, func(*proton.ListEnvironmentsOutput, bool) bool, ...request.Option) error

	ListRepositories(*proton.ListRepositoriesInput) (*proton.ListRepositoriesOutput, error)
	ListRepositoriesWithContext(aws.Context, *proton.ListRepositoriesInput, ...request.Option) (*proton.ListRepositoriesOutput, error)
	ListRepositoriesRequest(*proton.ListRepositoriesInput) (*request.Request, *proton.ListRepositoriesOutput)

	ListRepositoriesPages(*proton.ListRepositoriesInput, func(*proton.ListRepositoriesOutput, bool) bool) error
	ListRepositoriesPagesWithContext(aws.Context, *proton.ListRepositoriesInput, func(*proton.ListRepositoriesOutput, bool) bool, ...request.Option) error

	ListRepositorySyncDefinitions(*proton.ListRepositorySyncDefinitionsInput) (*proton.ListRepositorySyncDefinitionsOutput, error)
	ListRepositorySyncDefinitionsWithContext(aws.Context, *proton.ListRepositorySyncDefinitionsInput, ...request.Option) (*proton.ListRepositorySyncDefinitionsOutput, error)
	ListRepositorySyncDefinitionsRequest(*proton.ListRepositorySyncDefinitionsInput) (*request.Request, *proton.ListRepositorySyncDefinitionsOutput)

	ListRepositorySyncDefinitionsPages(*proton.ListRepositorySyncDefinitionsInput, func(*proton.ListRepositorySyncDefinitionsOutput, bool) bool) error
	ListRepositorySyncDefinitionsPagesWithContext(aws.Context, *proton.ListRepositorySyncDefinitionsInput, func(*proton.ListRepositorySyncDefinitionsOutput, bool) bool, ...request.Option) error

	ListServiceInstanceOutputs(*proton.ListServiceInstanceOutputsInput) (*proton.ListServiceInstanceOutputsOutput, error)
	ListServiceInstanceOutputsWithContext(aws.Context, *proton.ListServiceInstanceOutputsInput, ...request.Option) (*proton.ListServiceInstanceOutputsOutput, error)
	ListServiceInstanceOutputsRequest(*proton.ListServiceInstanceOutputsInput) (*request.Request, *proton.ListServiceInstanceOutputsOutput)

	ListServiceInstanceOutputsPages(*proton.ListServiceInstanceOutputsInput, func(*proton.ListServiceInstanceOutputsOutput, bool) bool) error
	ListServiceInstanceOutputsPagesWithContext(aws.Context, *proton.ListServiceInstanceOutputsInput, func(*proton.ListServiceInstanceOutputsOutput, bool) bool, ...request.Option) error

	ListServiceInstanceProvisionedResources(*proton.ListServiceInstanceProvisionedResourcesInput) (*proton.ListServiceInstanceProvisionedResourcesOutput, error)
	ListServiceInstanceProvisionedResourcesWithContext(aws.Context, *proton.ListServiceInstanceProvisionedResourcesInput, ...request.Option) (*proton.ListServiceInstanceProvisionedResourcesOutput, error)
	ListServiceInstanceProvisionedResourcesRequest(*proton.ListServiceInstanceProvisionedResourcesInput) (*request.Request, *proton.ListServiceInstanceProvisionedResourcesOutput)

	ListServiceInstanceProvisionedResourcesPages(*proton.ListServiceInstanceProvisionedResourcesInput, func(*proton.ListServiceInstanceProvisionedResourcesOutput, bool) bool) error
	ListServiceInstanceProvisionedResourcesPagesWithContext(aws.Context, *proton.ListServiceInstanceProvisionedResourcesInput, func(*proton.ListServiceInstanceProvisionedResourcesOutput, bool) bool, ...request.Option) error

	ListServiceInstances(*proton.ListServiceInstancesInput) (*proton.ListServiceInstancesOutput, error)
	ListServiceInstancesWithContext(aws.Context, *proton.ListServiceInstancesInput, ...request.Option) (*proton.ListServiceInstancesOutput, error)
	ListServiceInstancesRequest(*proton.ListServiceInstancesInput) (*request.Request, *proton.ListServiceInstancesOutput)

	ListServiceInstancesPages(*proton.ListServiceInstancesInput, func(*proton.ListServiceInstancesOutput, bool) bool) error
	ListServiceInstancesPagesWithContext(aws.Context, *proton.ListServiceInstancesInput, func(*proton.ListServiceInstancesOutput, bool) bool, ...request.Option) error

	ListServicePipelineOutputs(*proton.ListServicePipelineOutputsInput) (*proton.ListServicePipelineOutputsOutput, error)
	ListServicePipelineOutputsWithContext(aws.Context, *proton.ListServicePipelineOutputsInput, ...request.Option) (*proton.ListServicePipelineOutputsOutput, error)
	ListServicePipelineOutputsRequest(*proton.ListServicePipelineOutputsInput) (*request.Request, *proton.ListServicePipelineOutputsOutput)

	ListServicePipelineOutputsPages(*proton.ListServicePipelineOutputsInput, func(*proton.ListServicePipelineOutputsOutput, bool) bool) error
	ListServicePipelineOutputsPagesWithContext(aws.Context, *proton.ListServicePipelineOutputsInput, func(*proton.ListServicePipelineOutputsOutput, bool) bool, ...request.Option) error

	ListServicePipelineProvisionedResources(*proton.ListServicePipelineProvisionedResourcesInput) (*proton.ListServicePipelineProvisionedResourcesOutput, error)
	ListServicePipelineProvisionedResourcesWithContext(aws.Context, *proton.ListServicePipelineProvisionedResourcesInput, ...request.Option) (*proton.ListServicePipelineProvisionedResourcesOutput, error)
	ListServicePipelineProvisionedResourcesRequest(*proton.ListServicePipelineProvisionedResourcesInput) (*request.Request, *proton.ListServicePipelineProvisionedResourcesOutput)

	ListServicePipelineProvisionedResourcesPages(*proton.ListServicePipelineProvisionedResourcesInput, func(*proton.ListServicePipelineProvisionedResourcesOutput, bool) bool) error
	ListServicePipelineProvisionedResourcesPagesWithContext(aws.Context, *proton.ListServicePipelineProvisionedResourcesInput, func(*proton.ListServicePipelineProvisionedResourcesOutput, bool) bool, ...request.Option) error

	ListServiceTemplateVersions(*proton.ListServiceTemplateVersionsInput) (*proton.ListServiceTemplateVersionsOutput, error)
	ListServiceTemplateVersionsWithContext(aws.Context, *proton.ListServiceTemplateVersionsInput, ...request.Option) (*proton.ListServiceTemplateVersionsOutput, error)
	ListServiceTemplateVersionsRequest(*proton.ListServiceTemplateVersionsInput) (*request.Request, *proton.ListServiceTemplateVersionsOutput)

	ListServiceTemplateVersionsPages(*proton.ListServiceTemplateVersionsInput, func(*proton.ListServiceTemplateVersionsOutput, bool) bool) error
	ListServiceTemplateVersionsPagesWithContext(aws.Context, *proton.ListServiceTemplateVersionsInput, func(*proton.ListServiceTemplateVersionsOutput, bool) bool, ...request.Option) error

	ListServiceTemplates(*proton.ListServiceTemplatesInput) (*proton.ListServiceTemplatesOutput, error)
	ListServiceTemplatesWithContext(aws.Context, *proton.ListServiceTemplatesInput, ...request.Option) (*proton.ListServiceTemplatesOutput, error)
	ListServiceTemplatesRequest(*proton.ListServiceTemplatesInput) (*request.Request, *proton.ListServiceTemplatesOutput)

	ListServiceTemplatesPages(*proton.ListServiceTemplatesInput, func(*proton.ListServiceTemplatesOutput, bool) bool) error
	ListServiceTemplatesPagesWithContext(aws.Context, *proton.ListServiceTemplatesInput, func(*proton.ListServiceTemplatesOutput, bool) bool, ...request.Option) error

	ListServices(*proton.ListServicesInput) (*proton.ListServicesOutput, error)
	ListServicesWithContext(aws.Context, *proton.ListServicesInput, ...request.Option) (*proton.ListServicesOutput, error)
	ListServicesRequest(*proton.ListServicesInput) (*request.Request, *proton.ListServicesOutput)

	ListServicesPages(*proton.ListServicesInput, func(*proton.ListServicesOutput, bool) bool) error
	ListServicesPagesWithContext(aws.Context, *proton.ListServicesInput, func(*proton.ListServicesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*proton.ListTagsForResourceInput) (*proton.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *proton.ListTagsForResourceInput, ...request.Option) (*proton.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*proton.ListTagsForResourceInput) (*request.Request, *proton.ListTagsForResourceOutput)

	ListTagsForResourcePages(*proton.ListTagsForResourceInput, func(*proton.ListTagsForResourceOutput, bool) bool) error
	ListTagsForResourcePagesWithContext(aws.Context, *proton.ListTagsForResourceInput, func(*proton.ListTagsForResourceOutput, bool) bool, ...request.Option) error

	NotifyResourceDeploymentStatusChange(*proton.NotifyResourceDeploymentStatusChangeInput) (*proton.NotifyResourceDeploymentStatusChangeOutput, error)
	NotifyResourceDeploymentStatusChangeWithContext(aws.Context, *proton.NotifyResourceDeploymentStatusChangeInput, ...request.Option) (*proton.NotifyResourceDeploymentStatusChangeOutput, error)
	NotifyResourceDeploymentStatusChangeRequest(*proton.NotifyResourceDeploymentStatusChangeInput) (*request.Request, *proton.NotifyResourceDeploymentStatusChangeOutput)

	RejectEnvironmentAccountConnection(*proton.RejectEnvironmentAccountConnectionInput) (*proton.RejectEnvironmentAccountConnectionOutput, error)
	RejectEnvironmentAccountConnectionWithContext(aws.Context, *proton.RejectEnvironmentAccountConnectionInput, ...request.Option) (*proton.RejectEnvironmentAccountConnectionOutput, error)
	RejectEnvironmentAccountConnectionRequest(*proton.RejectEnvironmentAccountConnectionInput) (*request.Request, *proton.RejectEnvironmentAccountConnectionOutput)

	TagResource(*proton.TagResourceInput) (*proton.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *proton.TagResourceInput, ...request.Option) (*proton.TagResourceOutput, error)
	TagResourceRequest(*proton.TagResourceInput) (*request.Request, *proton.TagResourceOutput)

	UntagResource(*proton.UntagResourceInput) (*proton.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *proton.UntagResourceInput, ...request.Option) (*proton.UntagResourceOutput, error)
	UntagResourceRequest(*proton.UntagResourceInput) (*request.Request, *proton.UntagResourceOutput)

	UpdateAccountSettings(*proton.UpdateAccountSettingsInput) (*proton.UpdateAccountSettingsOutput, error)
	UpdateAccountSettingsWithContext(aws.Context, *proton.UpdateAccountSettingsInput, ...request.Option) (*proton.UpdateAccountSettingsOutput, error)
	UpdateAccountSettingsRequest(*proton.UpdateAccountSettingsInput) (*request.Request, *proton.UpdateAccountSettingsOutput)

	UpdateComponent(*proton.UpdateComponentInput) (*proton.UpdateComponentOutput, error)
	UpdateComponentWithContext(aws.Context, *proton.UpdateComponentInput, ...request.Option) (*proton.UpdateComponentOutput, error)
	UpdateComponentRequest(*proton.UpdateComponentInput) (*request.Request, *proton.UpdateComponentOutput)

	UpdateEnvironment(*proton.UpdateEnvironmentInput) (*proton.UpdateEnvironmentOutput, error)
	UpdateEnvironmentWithContext(aws.Context, *proton.UpdateEnvironmentInput, ...request.Option) (*proton.UpdateEnvironmentOutput, error)
	UpdateEnvironmentRequest(*proton.UpdateEnvironmentInput) (*request.Request, *proton.UpdateEnvironmentOutput)

	UpdateEnvironmentAccountConnection(*proton.UpdateEnvironmentAccountConnectionInput) (*proton.UpdateEnvironmentAccountConnectionOutput, error)
	UpdateEnvironmentAccountConnectionWithContext(aws.Context, *proton.UpdateEnvironmentAccountConnectionInput, ...request.Option) (*proton.UpdateEnvironmentAccountConnectionOutput, error)
	UpdateEnvironmentAccountConnectionRequest(*proton.UpdateEnvironmentAccountConnectionInput) (*request.Request, *proton.UpdateEnvironmentAccountConnectionOutput)

	UpdateEnvironmentTemplate(*proton.UpdateEnvironmentTemplateInput) (*proton.UpdateEnvironmentTemplateOutput, error)
	UpdateEnvironmentTemplateWithContext(aws.Context, *proton.UpdateEnvironmentTemplateInput, ...request.Option) (*proton.UpdateEnvironmentTemplateOutput, error)
	UpdateEnvironmentTemplateRequest(*proton.UpdateEnvironmentTemplateInput) (*request.Request, *proton.UpdateEnvironmentTemplateOutput)

	UpdateEnvironmentTemplateVersion(*proton.UpdateEnvironmentTemplateVersionInput) (*proton.UpdateEnvironmentTemplateVersionOutput, error)
	UpdateEnvironmentTemplateVersionWithContext(aws.Context, *proton.UpdateEnvironmentTemplateVersionInput, ...request.Option) (*proton.UpdateEnvironmentTemplateVersionOutput, error)
	UpdateEnvironmentTemplateVersionRequest(*proton.UpdateEnvironmentTemplateVersionInput) (*request.Request, *proton.UpdateEnvironmentTemplateVersionOutput)

	UpdateService(*proton.UpdateServiceInput) (*proton.UpdateServiceOutput, error)
	UpdateServiceWithContext(aws.Context, *proton.UpdateServiceInput, ...request.Option) (*proton.UpdateServiceOutput, error)
	UpdateServiceRequest(*proton.UpdateServiceInput) (*request.Request, *proton.UpdateServiceOutput)

	UpdateServiceInstance(*proton.UpdateServiceInstanceInput) (*proton.UpdateServiceInstanceOutput, error)
	UpdateServiceInstanceWithContext(aws.Context, *proton.UpdateServiceInstanceInput, ...request.Option) (*proton.UpdateServiceInstanceOutput, error)
	UpdateServiceInstanceRequest(*proton.UpdateServiceInstanceInput) (*request.Request, *proton.UpdateServiceInstanceOutput)

	UpdateServicePipeline(*proton.UpdateServicePipelineInput) (*proton.UpdateServicePipelineOutput, error)
	UpdateServicePipelineWithContext(aws.Context, *proton.UpdateServicePipelineInput, ...request.Option) (*proton.UpdateServicePipelineOutput, error)
	UpdateServicePipelineRequest(*proton.UpdateServicePipelineInput) (*request.Request, *proton.UpdateServicePipelineOutput)

	UpdateServiceTemplate(*proton.UpdateServiceTemplateInput) (*proton.UpdateServiceTemplateOutput, error)
	UpdateServiceTemplateWithContext(aws.Context, *proton.UpdateServiceTemplateInput, ...request.Option) (*proton.UpdateServiceTemplateOutput, error)
	UpdateServiceTemplateRequest(*proton.UpdateServiceTemplateInput) (*request.Request, *proton.UpdateServiceTemplateOutput)

	UpdateServiceTemplateVersion(*proton.UpdateServiceTemplateVersionInput) (*proton.UpdateServiceTemplateVersionOutput, error)
	UpdateServiceTemplateVersionWithContext(aws.Context, *proton.UpdateServiceTemplateVersionInput, ...request.Option) (*proton.UpdateServiceTemplateVersionOutput, error)
	UpdateServiceTemplateVersionRequest(*proton.UpdateServiceTemplateVersionInput) (*request.Request, *proton.UpdateServiceTemplateVersionOutput)

	UpdateTemplateSyncConfig(*proton.UpdateTemplateSyncConfigInput) (*proton.UpdateTemplateSyncConfigOutput, error)
	UpdateTemplateSyncConfigWithContext(aws.Context, *proton.UpdateTemplateSyncConfigInput, ...request.Option) (*proton.UpdateTemplateSyncConfigOutput, error)
	UpdateTemplateSyncConfigRequest(*proton.UpdateTemplateSyncConfigInput) (*request.Request, *proton.UpdateTemplateSyncConfigOutput)

	WaitUntilComponentDeleted(*proton.GetComponentInput) error
	WaitUntilComponentDeletedWithContext(aws.Context, *proton.GetComponentInput, ...request.WaiterOption) error

	WaitUntilComponentDeployed(*proton.GetComponentInput) error
	WaitUntilComponentDeployedWithContext(aws.Context, *proton.GetComponentInput, ...request.WaiterOption) error

	WaitUntilEnvironmentDeployed(*proton.GetEnvironmentInput) error
	WaitUntilEnvironmentDeployedWithContext(aws.Context, *proton.GetEnvironmentInput, ...request.WaiterOption) error

	WaitUntilEnvironmentTemplateVersionRegistered(*proton.GetEnvironmentTemplateVersionInput) error
	WaitUntilEnvironmentTemplateVersionRegisteredWithContext(aws.Context, *proton.GetEnvironmentTemplateVersionInput, ...request.WaiterOption) error

	WaitUntilServiceCreated(*proton.GetServiceInput) error
	WaitUntilServiceCreatedWithContext(aws.Context, *proton.GetServiceInput, ...request.WaiterOption) error

	WaitUntilServiceDeleted(*proton.GetServiceInput) error
	WaitUntilServiceDeletedWithContext(aws.Context, *proton.GetServiceInput, ...request.WaiterOption) error

	WaitUntilServiceInstanceDeployed(*proton.GetServiceInstanceInput) error
	WaitUntilServiceInstanceDeployedWithContext(aws.Context, *proton.GetServiceInstanceInput, ...request.WaiterOption) error

	WaitUntilServicePipelineDeployed(*proton.GetServiceInput) error
	WaitUntilServicePipelineDeployedWithContext(aws.Context, *proton.GetServiceInput, ...request.WaiterOption) error

	WaitUntilServiceTemplateVersionRegistered(*proton.GetServiceTemplateVersionInput) error
	WaitUntilServiceTemplateVersionRegisteredWithContext(aws.Context, *proton.GetServiceTemplateVersionInput, ...request.WaiterOption) error

	WaitUntilServiceUpdated(*proton.GetServiceInput) error
	WaitUntilServiceUpdatedWithContext(aws.Context, *proton.GetServiceInput, ...request.WaiterOption) error
}

var _ ProtonAPI = (*proton.Proton)(nil)
