// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package glueiface provides an interface to enable mocking the AWS Glue service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package glueiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/glue"
)

// GlueAPI provides an interface to enable mocking the
// glue.Glue service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Glue.
//	func myFunc(svc glueiface.GlueAPI) bool {
//	    // Make svc.BatchCreatePartition request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := glue.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockGlueClient struct {
//	    glueiface.GlueAPI
//	}
//	func (m *mockGlueClient) BatchCreatePartition(input *glue.BatchCreatePartitionInput) (*glue.BatchCreatePartitionOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockGlueClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type GlueAPI interface {
	BatchCreatePartition(*glue.BatchCreatePartitionInput) (*glue.BatchCreatePartitionOutput, error)
	BatchCreatePartitionWithContext(aws.Context, *glue.BatchCreatePartitionInput, ...request.Option) (*glue.BatchCreatePartitionOutput, error)
	BatchCreatePartitionRequest(*glue.BatchCreatePartitionInput) (*request.Request, *glue.BatchCreatePartitionOutput)

	BatchDeleteConnection(*glue.BatchDeleteConnectionInput) (*glue.BatchDeleteConnectionOutput, error)
	BatchDeleteConnectionWithContext(aws.Context, *glue.BatchDeleteConnectionInput, ...request.Option) (*glue.BatchDeleteConnectionOutput, error)
	BatchDeleteConnectionRequest(*glue.BatchDeleteConnectionInput) (*request.Request, *glue.BatchDeleteConnectionOutput)

	BatchDeletePartition(*glue.BatchDeletePartitionInput) (*glue.BatchDeletePartitionOutput, error)
	BatchDeletePartitionWithContext(aws.Context, *glue.BatchDeletePartitionInput, ...request.Option) (*glue.BatchDeletePartitionOutput, error)
	BatchDeletePartitionRequest(*glue.BatchDeletePartitionInput) (*request.Request, *glue.BatchDeletePartitionOutput)

	BatchDeleteTable(*glue.BatchDeleteTableInput) (*glue.BatchDeleteTableOutput, error)
	BatchDeleteTableWithContext(aws.Context, *glue.BatchDeleteTableInput, ...request.Option) (*glue.BatchDeleteTableOutput, error)
	BatchDeleteTableRequest(*glue.BatchDeleteTableInput) (*request.Request, *glue.BatchDeleteTableOutput)

	BatchDeleteTableVersion(*glue.BatchDeleteTableVersionInput) (*glue.BatchDeleteTableVersionOutput, error)
	BatchDeleteTableVersionWithContext(aws.Context, *glue.BatchDeleteTableVersionInput, ...request.Option) (*glue.BatchDeleteTableVersionOutput, error)
	BatchDeleteTableVersionRequest(*glue.BatchDeleteTableVersionInput) (*request.Request, *glue.BatchDeleteTableVersionOutput)

	BatchGetBlueprints(*glue.BatchGetBlueprintsInput) (*glue.BatchGetBlueprintsOutput, error)
	BatchGetBlueprintsWithContext(aws.Context, *glue.BatchGetBlueprintsInput, ...request.Option) (*glue.BatchGetBlueprintsOutput, error)
	BatchGetBlueprintsRequest(*glue.BatchGetBlueprintsInput) (*request.Request, *glue.BatchGetBlueprintsOutput)

	BatchGetCrawlers(*glue.BatchGetCrawlersInput) (*glue.BatchGetCrawlersOutput, error)
	BatchGetCrawlersWithContext(aws.Context, *glue.BatchGetCrawlersInput, ...request.Option) (*glue.BatchGetCrawlersOutput, error)
	BatchGetCrawlersRequest(*glue.BatchGetCrawlersInput) (*request.Request, *glue.BatchGetCrawlersOutput)

	BatchGetCustomEntityTypes(*glue.BatchGetCustomEntityTypesInput) (*glue.BatchGetCustomEntityTypesOutput, error)
	BatchGetCustomEntityTypesWithContext(aws.Context, *glue.BatchGetCustomEntityTypesInput, ...request.Option) (*glue.BatchGetCustomEntityTypesOutput, error)
	BatchGetCustomEntityTypesRequest(*glue.BatchGetCustomEntityTypesInput) (*request.Request, *glue.BatchGetCustomEntityTypesOutput)

	BatchGetDataQualityResult(*glue.BatchGetDataQualityResultInput) (*glue.BatchGetDataQualityResultOutput, error)
	BatchGetDataQualityResultWithContext(aws.Context, *glue.BatchGetDataQualityResultInput, ...request.Option) (*glue.BatchGetDataQualityResultOutput, error)
	BatchGetDataQualityResultRequest(*glue.BatchGetDataQualityResultInput) (*request.Request, *glue.BatchGetDataQualityResultOutput)

	BatchGetDevEndpoints(*glue.BatchGetDevEndpointsInput) (*glue.BatchGetDevEndpointsOutput, error)
	BatchGetDevEndpointsWithContext(aws.Context, *glue.BatchGetDevEndpointsInput, ...request.Option) (*glue.BatchGetDevEndpointsOutput, error)
	BatchGetDevEndpointsRequest(*glue.BatchGetDevEndpointsInput) (*request.Request, *glue.BatchGetDevEndpointsOutput)

	BatchGetJobs(*glue.BatchGetJobsInput) (*glue.BatchGetJobsOutput, error)
	BatchGetJobsWithContext(aws.Context, *glue.BatchGetJobsInput, ...request.Option) (*glue.BatchGetJobsOutput, error)
	BatchGetJobsRequest(*glue.BatchGetJobsInput) (*request.Request, *glue.BatchGetJobsOutput)

	BatchGetPartition(*glue.BatchGetPartitionInput) (*glue.BatchGetPartitionOutput, error)
	BatchGetPartitionWithContext(aws.Context, *glue.BatchGetPartitionInput, ...request.Option) (*glue.BatchGetPartitionOutput, error)
	BatchGetPartitionRequest(*glue.BatchGetPartitionInput) (*request.Request, *glue.BatchGetPartitionOutput)

	BatchGetTriggers(*glue.BatchGetTriggersInput) (*glue.BatchGetTriggersOutput, error)
	BatchGetTriggersWithContext(aws.Context, *glue.BatchGetTriggersInput, ...request.Option) (*glue.BatchGetTriggersOutput, error)
	BatchGetTriggersRequest(*glue.BatchGetTriggersInput) (*request.Request, *glue.BatchGetTriggersOutput)

	BatchGetWorkflows(*glue.BatchGetWorkflowsInput) (*glue.BatchGetWorkflowsOutput, error)
	BatchGetWorkflowsWithContext(aws.Context, *glue.BatchGetWorkflowsInput, ...request.Option) (*glue.BatchGetWorkflowsOutput, error)
	BatchGetWorkflowsRequest(*glue.BatchGetWorkflowsInput) (*request.Request, *glue.BatchGetWorkflowsOutput)

	BatchStopJobRun(*glue.BatchStopJobRunInput) (*glue.BatchStopJobRunOutput, error)
	BatchStopJobRunWithContext(aws.Context, *glue.BatchStopJobRunInput, ...request.Option) (*glue.BatchStopJobRunOutput, error)
	BatchStopJobRunRequest(*glue.BatchStopJobRunInput) (*request.Request, *glue.BatchStopJobRunOutput)

	BatchUpdatePartition(*glue.BatchUpdatePartitionInput) (*glue.BatchUpdatePartitionOutput, error)
	BatchUpdatePartitionWithContext(aws.Context, *glue.BatchUpdatePartitionInput, ...request.Option) (*glue.BatchUpdatePartitionOutput, error)
	BatchUpdatePartitionRequest(*glue.BatchUpdatePartitionInput) (*request.Request, *glue.BatchUpdatePartitionOutput)

	CancelDataQualityRuleRecommendationRun(*glue.CancelDataQualityRuleRecommendationRunInput) (*glue.CancelDataQualityRuleRecommendationRunOutput, error)
	CancelDataQualityRuleRecommendationRunWithContext(aws.Context, *glue.CancelDataQualityRuleRecommendationRunInput, ...request.Option) (*glue.CancelDataQualityRuleRecommendationRunOutput, error)
	CancelDataQualityRuleRecommendationRunRequest(*glue.CancelDataQualityRuleRecommendationRunInput) (*request.Request, *glue.CancelDataQualityRuleRecommendationRunOutput)

	CancelDataQualityRulesetEvaluationRun(*glue.CancelDataQualityRulesetEvaluationRunInput) (*glue.CancelDataQualityRulesetEvaluationRunOutput, error)
	CancelDataQualityRulesetEvaluationRunWithContext(aws.Context, *glue.CancelDataQualityRulesetEvaluationRunInput, ...request.Option) (*glue.CancelDataQualityRulesetEvaluationRunOutput, error)
	CancelDataQualityRulesetEvaluationRunRequest(*glue.CancelDataQualityRulesetEvaluationRunInput) (*request.Request, *glue.CancelDataQualityRulesetEvaluationRunOutput)

	CancelMLTaskRun(*glue.CancelMLTaskRunInput) (*glue.CancelMLTaskRunOutput, error)
	CancelMLTaskRunWithContext(aws.Context, *glue.CancelMLTaskRunInput, ...request.Option) (*glue.CancelMLTaskRunOutput, error)
	CancelMLTaskRunRequest(*glue.CancelMLTaskRunInput) (*request.Request, *glue.CancelMLTaskRunOutput)

	CancelStatement(*glue.CancelStatementInput) (*glue.CancelStatementOutput, error)
	CancelStatementWithContext(aws.Context, *glue.CancelStatementInput, ...request.Option) (*glue.CancelStatementOutput, error)
	CancelStatementRequest(*glue.CancelStatementInput) (*request.Request, *glue.CancelStatementOutput)

	CheckSchemaVersionValidity(*glue.CheckSchemaVersionValidityInput) (*glue.CheckSchemaVersionValidityOutput, error)
	CheckSchemaVersionValidityWithContext(aws.Context, *glue.CheckSchemaVersionValidityInput, ...request.Option) (*glue.CheckSchemaVersionValidityOutput, error)
	CheckSchemaVersionValidityRequest(*glue.CheckSchemaVersionValidityInput) (*request.Request, *glue.CheckSchemaVersionValidityOutput)

	CreateBlueprint(*glue.CreateBlueprintInput) (*glue.CreateBlueprintOutput, error)
	CreateBlueprintWithContext(aws.Context, *glue.CreateBlueprintInput, ...request.Option) (*glue.CreateBlueprintOutput, error)
	CreateBlueprintRequest(*glue.CreateBlueprintInput) (*request.Request, *glue.CreateBlueprintOutput)

	CreateClassifier(*glue.CreateClassifierInput) (*glue.CreateClassifierOutput, error)
	CreateClassifierWithContext(aws.Context, *glue.CreateClassifierInput, ...request.Option) (*glue.CreateClassifierOutput, error)
	CreateClassifierRequest(*glue.CreateClassifierInput) (*request.Request, *glue.CreateClassifierOutput)

	CreateConnection(*glue.CreateConnectionInput) (*glue.CreateConnectionOutput, error)
	CreateConnectionWithContext(aws.Context, *glue.CreateConnectionInput, ...request.Option) (*glue.CreateConnectionOutput, error)
	CreateConnectionRequest(*glue.CreateConnectionInput) (*request.Request, *glue.CreateConnectionOutput)

	CreateCrawler(*glue.CreateCrawlerInput) (*glue.CreateCrawlerOutput, error)
	CreateCrawlerWithContext(aws.Context, *glue.CreateCrawlerInput, ...request.Option) (*glue.CreateCrawlerOutput, error)
	CreateCrawlerRequest(*glue.CreateCrawlerInput) (*request.Request, *glue.CreateCrawlerOutput)

	CreateCustomEntityType(*glue.CreateCustomEntityTypeInput) (*glue.CreateCustomEntityTypeOutput, error)
	CreateCustomEntityTypeWithContext(aws.Context, *glue.CreateCustomEntityTypeInput, ...request.Option) (*glue.CreateCustomEntityTypeOutput, error)
	CreateCustomEntityTypeRequest(*glue.CreateCustomEntityTypeInput) (*request.Request, *glue.CreateCustomEntityTypeOutput)

	CreateDataQualityRuleset(*glue.CreateDataQualityRulesetInput) (*glue.CreateDataQualityRulesetOutput, error)
	CreateDataQualityRulesetWithContext(aws.Context, *glue.CreateDataQualityRulesetInput, ...request.Option) (*glue.CreateDataQualityRulesetOutput, error)
	CreateDataQualityRulesetRequest(*glue.CreateDataQualityRulesetInput) (*request.Request, *glue.CreateDataQualityRulesetOutput)

	CreateDatabase(*glue.CreateDatabaseInput) (*glue.CreateDatabaseOutput, error)
	CreateDatabaseWithContext(aws.Context, *glue.CreateDatabaseInput, ...request.Option) (*glue.CreateDatabaseOutput, error)
	CreateDatabaseRequest(*glue.CreateDatabaseInput) (*request.Request, *glue.CreateDatabaseOutput)

	CreateDevEndpoint(*glue.CreateDevEndpointInput) (*glue.CreateDevEndpointOutput, error)
	CreateDevEndpointWithContext(aws.Context, *glue.CreateDevEndpointInput, ...request.Option) (*glue.CreateDevEndpointOutput, error)
	CreateDevEndpointRequest(*glue.CreateDevEndpointInput) (*request.Request, *glue.CreateDevEndpointOutput)

	CreateJob(*glue.CreateJobInput) (*glue.CreateJobOutput, error)
	CreateJobWithContext(aws.Context, *glue.CreateJobInput, ...request.Option) (*glue.CreateJobOutput, error)
	CreateJobRequest(*glue.CreateJobInput) (*request.Request, *glue.CreateJobOutput)

	CreateMLTransform(*glue.CreateMLTransformInput) (*glue.CreateMLTransformOutput, error)
	CreateMLTransformWithContext(aws.Context, *glue.CreateMLTransformInput, ...request.Option) (*glue.CreateMLTransformOutput, error)
	CreateMLTransformRequest(*glue.CreateMLTransformInput) (*request.Request, *glue.CreateMLTransformOutput)

	CreatePartition(*glue.CreatePartitionInput) (*glue.CreatePartitionOutput, error)
	CreatePartitionWithContext(aws.Context, *glue.CreatePartitionInput, ...request.Option) (*glue.CreatePartitionOutput, error)
	CreatePartitionRequest(*glue.CreatePartitionInput) (*request.Request, *glue.CreatePartitionOutput)

	CreatePartitionIndex(*glue.CreatePartitionIndexInput) (*glue.CreatePartitionIndexOutput, error)
	CreatePartitionIndexWithContext(aws.Context, *glue.CreatePartitionIndexInput, ...request.Option) (*glue.CreatePartitionIndexOutput, error)
	CreatePartitionIndexRequest(*glue.CreatePartitionIndexInput) (*request.Request, *glue.CreatePartitionIndexOutput)

	CreateRegistry(*glue.CreateRegistryInput) (*glue.CreateRegistryOutput, error)
	CreateRegistryWithContext(aws.Context, *glue.CreateRegistryInput, ...request.Option) (*glue.CreateRegistryOutput, error)
	CreateRegistryRequest(*glue.CreateRegistryInput) (*request.Request, *glue.CreateRegistryOutput)

	CreateSchema(*glue.CreateSchemaInput) (*glue.CreateSchemaOutput, error)
	CreateSchemaWithContext(aws.Context, *glue.CreateSchemaInput, ...request.Option) (*glue.CreateSchemaOutput, error)
	CreateSchemaRequest(*glue.CreateSchemaInput) (*request.Request, *glue.CreateSchemaOutput)

	CreateScript(*glue.CreateScriptInput) (*glue.CreateScriptOutput, error)
	CreateScriptWithContext(aws.Context, *glue.CreateScriptInput, ...request.Option) (*glue.CreateScriptOutput, error)
	CreateScriptRequest(*glue.CreateScriptInput) (*request.Request, *glue.CreateScriptOutput)

	CreateSecurityConfiguration(*glue.CreateSecurityConfigurationInput) (*glue.CreateSecurityConfigurationOutput, error)
	CreateSecurityConfigurationWithContext(aws.Context, *glue.CreateSecurityConfigurationInput, ...request.Option) (*glue.CreateSecurityConfigurationOutput, error)
	CreateSecurityConfigurationRequest(*glue.CreateSecurityConfigurationInput) (*request.Request, *glue.CreateSecurityConfigurationOutput)

	CreateSession(*glue.CreateSessionInput) (*glue.CreateSessionOutput, error)
	CreateSessionWithContext(aws.Context, *glue.CreateSessionInput, ...request.Option) (*glue.CreateSessionOutput, error)
	CreateSessionRequest(*glue.CreateSessionInput) (*request.Request, *glue.CreateSessionOutput)

	CreateTable(*glue.CreateTableInput) (*glue.CreateTableOutput, error)
	CreateTableWithContext(aws.Context, *glue.CreateTableInput, ...request.Option) (*glue.CreateTableOutput, error)
	CreateTableRequest(*glue.CreateTableInput) (*request.Request, *glue.CreateTableOutput)

	CreateTrigger(*glue.CreateTriggerInput) (*glue.CreateTriggerOutput, error)
	CreateTriggerWithContext(aws.Context, *glue.CreateTriggerInput, ...request.Option) (*glue.CreateTriggerOutput, error)
	CreateTriggerRequest(*glue.CreateTriggerInput) (*request.Request, *glue.CreateTriggerOutput)

	CreateUserDefinedFunction(*glue.CreateUserDefinedFunctionInput) (*glue.CreateUserDefinedFunctionOutput, error)
	CreateUserDefinedFunctionWithContext(aws.Context, *glue.CreateUserDefinedFunctionInput, ...request.Option) (*glue.CreateUserDefinedFunctionOutput, error)
	CreateUserDefinedFunctionRequest(*glue.CreateUserDefinedFunctionInput) (*request.Request, *glue.CreateUserDefinedFunctionOutput)

	CreateWorkflow(*glue.CreateWorkflowInput) (*glue.CreateWorkflowOutput, error)
	CreateWorkflowWithContext(aws.Context, *glue.CreateWorkflowInput, ...request.Option) (*glue.CreateWorkflowOutput, error)
	CreateWorkflowRequest(*glue.CreateWorkflowInput) (*request.Request, *glue.CreateWorkflowOutput)

	DeleteBlueprint(*glue.DeleteBlueprintInput) (*glue.DeleteBlueprintOutput, error)
	DeleteBlueprintWithContext(aws.Context, *glue.DeleteBlueprintInput, ...request.Option) (*glue.DeleteBlueprintOutput, error)
	DeleteBlueprintRequest(*glue.DeleteBlueprintInput) (*request.Request, *glue.DeleteBlueprintOutput)

	DeleteClassifier(*glue.DeleteClassifierInput) (*glue.DeleteClassifierOutput, error)
	DeleteClassifierWithContext(aws.Context, *glue.DeleteClassifierInput, ...request.Option) (*glue.DeleteClassifierOutput, error)
	DeleteClassifierRequest(*glue.DeleteClassifierInput) (*request.Request, *glue.DeleteClassifierOutput)

	DeleteColumnStatisticsForPartition(*glue.DeleteColumnStatisticsForPartitionInput) (*glue.DeleteColumnStatisticsForPartitionOutput, error)
	DeleteColumnStatisticsForPartitionWithContext(aws.Context, *glue.DeleteColumnStatisticsForPartitionInput, ...request.Option) (*glue.DeleteColumnStatisticsForPartitionOutput, error)
	DeleteColumnStatisticsForPartitionRequest(*glue.DeleteColumnStatisticsForPartitionInput) (*request.Request, *glue.DeleteColumnStatisticsForPartitionOutput)

	DeleteColumnStatisticsForTable(*glue.DeleteColumnStatisticsForTableInput) (*glue.DeleteColumnStatisticsForTableOutput, error)
	DeleteColumnStatisticsForTableWithContext(aws.Context, *glue.DeleteColumnStatisticsForTableInput, ...request.Option) (*glue.DeleteColumnStatisticsForTableOutput, error)
	DeleteColumnStatisticsForTableRequest(*glue.DeleteColumnStatisticsForTableInput) (*request.Request, *glue.DeleteColumnStatisticsForTableOutput)

	DeleteConnection(*glue.DeleteConnectionInput) (*glue.DeleteConnectionOutput, error)
	DeleteConnectionWithContext(aws.Context, *glue.DeleteConnectionInput, ...request.Option) (*glue.DeleteConnectionOutput, error)
	DeleteConnectionRequest(*glue.DeleteConnectionInput) (*request.Request, *glue.DeleteConnectionOutput)

	DeleteCrawler(*glue.DeleteCrawlerInput) (*glue.DeleteCrawlerOutput, error)
	DeleteCrawlerWithContext(aws.Context, *glue.DeleteCrawlerInput, ...request.Option) (*glue.DeleteCrawlerOutput, error)
	DeleteCrawlerRequest(*glue.DeleteCrawlerInput) (*request.Request, *glue.DeleteCrawlerOutput)

	DeleteCustomEntityType(*glue.DeleteCustomEntityTypeInput) (*glue.DeleteCustomEntityTypeOutput, error)
	DeleteCustomEntityTypeWithContext(aws.Context, *glue.DeleteCustomEntityTypeInput, ...request.Option) (*glue.DeleteCustomEntityTypeOutput, error)
	DeleteCustomEntityTypeRequest(*glue.DeleteCustomEntityTypeInput) (*request.Request, *glue.DeleteCustomEntityTypeOutput)

	DeleteDataQualityRuleset(*glue.DeleteDataQualityRulesetInput) (*glue.DeleteDataQualityRulesetOutput, error)
	DeleteDataQualityRulesetWithContext(aws.Context, *glue.DeleteDataQualityRulesetInput, ...request.Option) (*glue.DeleteDataQualityRulesetOutput, error)
	DeleteDataQualityRulesetRequest(*glue.DeleteDataQualityRulesetInput) (*request.Request, *glue.DeleteDataQualityRulesetOutput)

	DeleteDatabase(*glue.DeleteDatabaseInput) (*glue.DeleteDatabaseOutput, error)
	DeleteDatabaseWithContext(aws.Context, *glue.DeleteDatabaseInput, ...request.Option) (*glue.DeleteDatabaseOutput, error)
	DeleteDatabaseRequest(*glue.DeleteDatabaseInput) (*request.Request, *glue.DeleteDatabaseOutput)

	DeleteDevEndpoint(*glue.DeleteDevEndpointInput) (*glue.DeleteDevEndpointOutput, error)
	DeleteDevEndpointWithContext(aws.Context, *glue.DeleteDevEndpointInput, ...request.Option) (*glue.DeleteDevEndpointOutput, error)
	DeleteDevEndpointRequest(*glue.DeleteDevEndpointInput) (*request.Request, *glue.DeleteDevEndpointOutput)

	DeleteJob(*glue.DeleteJobInput) (*glue.DeleteJobOutput, error)
	DeleteJobWithContext(aws.Context, *glue.DeleteJobInput, ...request.Option) (*glue.DeleteJobOutput, error)
	DeleteJobRequest(*glue.DeleteJobInput) (*request.Request, *glue.DeleteJobOutput)

	DeleteMLTransform(*glue.DeleteMLTransformInput) (*glue.DeleteMLTransformOutput, error)
	DeleteMLTransformWithContext(aws.Context, *glue.DeleteMLTransformInput, ...request.Option) (*glue.DeleteMLTransformOutput, error)
	DeleteMLTransformRequest(*glue.DeleteMLTransformInput) (*request.Request, *glue.DeleteMLTransformOutput)

	DeletePartition(*glue.DeletePartitionInput) (*glue.DeletePartitionOutput, error)
	DeletePartitionWithContext(aws.Context, *glue.DeletePartitionInput, ...request.Option) (*glue.DeletePartitionOutput, error)
	DeletePartitionRequest(*glue.DeletePartitionInput) (*request.Request, *glue.DeletePartitionOutput)

	DeletePartitionIndex(*glue.DeletePartitionIndexInput) (*glue.DeletePartitionIndexOutput, error)
	DeletePartitionIndexWithContext(aws.Context, *glue.DeletePartitionIndexInput, ...request.Option) (*glue.DeletePartitionIndexOutput, error)
	DeletePartitionIndexRequest(*glue.DeletePartitionIndexInput) (*request.Request, *glue.DeletePartitionIndexOutput)

	DeleteRegistry(*glue.DeleteRegistryInput) (*glue.DeleteRegistryOutput, error)
	DeleteRegistryWithContext(aws.Context, *glue.DeleteRegistryInput, ...request.Option) (*glue.DeleteRegistryOutput, error)
	DeleteRegistryRequest(*glue.DeleteRegistryInput) (*request.Request, *glue.DeleteRegistryOutput)

	DeleteResourcePolicy(*glue.DeleteResourcePolicyInput) (*glue.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyWithContext(aws.Context, *glue.DeleteResourcePolicyInput, ...request.Option) (*glue.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyRequest(*glue.DeleteResourcePolicyInput) (*request.Request, *glue.DeleteResourcePolicyOutput)

	DeleteSchema(*glue.DeleteSchemaInput) (*glue.DeleteSchemaOutput, error)
	DeleteSchemaWithContext(aws.Context, *glue.DeleteSchemaInput, ...request.Option) (*glue.DeleteSchemaOutput, error)
	DeleteSchemaRequest(*glue.DeleteSchemaInput) (*request.Request, *glue.DeleteSchemaOutput)

	DeleteSchemaVersions(*glue.DeleteSchemaVersionsInput) (*glue.DeleteSchemaVersionsOutput, error)
	DeleteSchemaVersionsWithContext(aws.Context, *glue.DeleteSchemaVersionsInput, ...request.Option) (*glue.DeleteSchemaVersionsOutput, error)
	DeleteSchemaVersionsRequest(*glue.DeleteSchemaVersionsInput) (*request.Request, *glue.DeleteSchemaVersionsOutput)

	DeleteSecurityConfiguration(*glue.DeleteSecurityConfigurationInput) (*glue.DeleteSecurityConfigurationOutput, error)
	DeleteSecurityConfigurationWithContext(aws.Context, *glue.DeleteSecurityConfigurationInput, ...request.Option) (*glue.DeleteSecurityConfigurationOutput, error)
	DeleteSecurityConfigurationRequest(*glue.DeleteSecurityConfigurationInput) (*request.Request, *glue.DeleteSecurityConfigurationOutput)

	DeleteSession(*glue.DeleteSessionInput) (*glue.DeleteSessionOutput, error)
	DeleteSessionWithContext(aws.Context, *glue.DeleteSessionInput, ...request.Option) (*glue.DeleteSessionOutput, error)
	DeleteSessionRequest(*glue.DeleteSessionInput) (*request.Request, *glue.DeleteSessionOutput)

	DeleteTable(*glue.DeleteTableInput) (*glue.DeleteTableOutput, error)
	DeleteTableWithContext(aws.Context, *glue.DeleteTableInput, ...request.Option) (*glue.DeleteTableOutput, error)
	DeleteTableRequest(*glue.DeleteTableInput) (*request.Request, *glue.DeleteTableOutput)

	DeleteTableVersion(*glue.DeleteTableVersionInput) (*glue.DeleteTableVersionOutput, error)
	DeleteTableVersionWithContext(aws.Context, *glue.DeleteTableVersionInput, ...request.Option) (*glue.DeleteTableVersionOutput, error)
	DeleteTableVersionRequest(*glue.DeleteTableVersionInput) (*request.Request, *glue.DeleteTableVersionOutput)

	DeleteTrigger(*glue.DeleteTriggerInput) (*glue.DeleteTriggerOutput, error)
	DeleteTriggerWithContext(aws.Context, *glue.DeleteTriggerInput, ...request.Option) (*glue.DeleteTriggerOutput, error)
	DeleteTriggerRequest(*glue.DeleteTriggerInput) (*request.Request, *glue.DeleteTriggerOutput)

	DeleteUserDefinedFunction(*glue.DeleteUserDefinedFunctionInput) (*glue.DeleteUserDefinedFunctionOutput, error)
	DeleteUserDefinedFunctionWithContext(aws.Context, *glue.DeleteUserDefinedFunctionInput, ...request.Option) (*glue.DeleteUserDefinedFunctionOutput, error)
	DeleteUserDefinedFunctionRequest(*glue.DeleteUserDefinedFunctionInput) (*request.Request, *glue.DeleteUserDefinedFunctionOutput)

	DeleteWorkflow(*glue.DeleteWorkflowInput) (*glue.DeleteWorkflowOutput, error)
	DeleteWorkflowWithContext(aws.Context, *glue.DeleteWorkflowInput, ...request.Option) (*glue.DeleteWorkflowOutput, error)
	DeleteWorkflowRequest(*glue.DeleteWorkflowInput) (*request.Request, *glue.DeleteWorkflowOutput)

	GetBlueprint(*glue.GetBlueprintInput) (*glue.GetBlueprintOutput, error)
	GetBlueprintWithContext(aws.Context, *glue.GetBlueprintInput, ...request.Option) (*glue.GetBlueprintOutput, error)
	GetBlueprintRequest(*glue.GetBlueprintInput) (*request.Request, *glue.GetBlueprintOutput)

	GetBlueprintRun(*glue.GetBlueprintRunInput) (*glue.GetBlueprintRunOutput, error)
	GetBlueprintRunWithContext(aws.Context, *glue.GetBlueprintRunInput, ...request.Option) (*glue.GetBlueprintRunOutput, error)
	GetBlueprintRunRequest(*glue.GetBlueprintRunInput) (*request.Request, *glue.GetBlueprintRunOutput)

	GetBlueprintRuns(*glue.GetBlueprintRunsInput) (*glue.GetBlueprintRunsOutput, error)
	GetBlueprintRunsWithContext(aws.Context, *glue.GetBlueprintRunsInput, ...request.Option) (*glue.GetBlueprintRunsOutput, error)
	GetBlueprintRunsRequest(*glue.GetBlueprintRunsInput) (*request.Request, *glue.GetBlueprintRunsOutput)

	GetBlueprintRunsPages(*glue.GetBlueprintRunsInput, func(*glue.GetBlueprintRunsOutput, bool) bool) error
	GetBlueprintRunsPagesWithContext(aws.Context, *glue.GetBlueprintRunsInput, func(*glue.GetBlueprintRunsOutput, bool) bool, ...request.Option) error

	GetCatalogImportStatus(*glue.GetCatalogImportStatusInput) (*glue.GetCatalogImportStatusOutput, error)
	GetCatalogImportStatusWithContext(aws.Context, *glue.GetCatalogImportStatusInput, ...request.Option) (*glue.GetCatalogImportStatusOutput, error)
	GetCatalogImportStatusRequest(*glue.GetCatalogImportStatusInput) (*request.Request, *glue.GetCatalogImportStatusOutput)

	GetClassifier(*glue.GetClassifierInput) (*glue.GetClassifierOutput, error)
	GetClassifierWithContext(aws.Context, *glue.GetClassifierInput, ...request.Option) (*glue.GetClassifierOutput, error)
	GetClassifierRequest(*glue.GetClassifierInput) (*request.Request, *glue.GetClassifierOutput)

	GetClassifiers(*glue.GetClassifiersInput) (*glue.GetClassifiersOutput, error)
	GetClassifiersWithContext(aws.Context, *glue.GetClassifiersInput, ...request.Option) (*glue.GetClassifiersOutput, error)
	GetClassifiersRequest(*glue.GetClassifiersInput) (*request.Request, *glue.GetClassifiersOutput)

	GetClassifiersPages(*glue.GetClassifiersInput, func(*glue.GetClassifiersOutput, bool) bool) error
	GetClassifiersPagesWithContext(aws.Context, *glue.GetClassifiersInput, func(*glue.GetClassifiersOutput, bool) bool, ...request.Option) error

	GetColumnStatisticsForPartition(*glue.GetColumnStatisticsForPartitionInput) (*glue.GetColumnStatisticsForPartitionOutput, error)
	GetColumnStatisticsForPartitionWithContext(aws.Context, *glue.GetColumnStatisticsForPartitionInput, ...request.Option) (*glue.GetColumnStatisticsForPartitionOutput, error)
	GetColumnStatisticsForPartitionRequest(*glue.GetColumnStatisticsForPartitionInput) (*request.Request, *glue.GetColumnStatisticsForPartitionOutput)

	GetColumnStatisticsForTable(*glue.GetColumnStatisticsForTableInput) (*glue.GetColumnStatisticsForTableOutput, error)
	GetColumnStatisticsForTableWithContext(aws.Context, *glue.GetColumnStatisticsForTableInput, ...request.Option) (*glue.GetColumnStatisticsForTableOutput, error)
	GetColumnStatisticsForTableRequest(*glue.GetColumnStatisticsForTableInput) (*request.Request, *glue.GetColumnStatisticsForTableOutput)

	GetConnection(*glue.GetConnectionInput) (*glue.GetConnectionOutput, error)
	GetConnectionWithContext(aws.Context, *glue.GetConnectionInput, ...request.Option) (*glue.GetConnectionOutput, error)
	GetConnectionRequest(*glue.GetConnectionInput) (*request.Request, *glue.GetConnectionOutput)

	GetConnections(*glue.GetConnectionsInput) (*glue.GetConnectionsOutput, error)
	GetConnectionsWithContext(aws.Context, *glue.GetConnectionsInput, ...request.Option) (*glue.GetConnectionsOutput, error)
	GetConnectionsRequest(*glue.GetConnectionsInput) (*request.Request, *glue.GetConnectionsOutput)

	GetConnectionsPages(*glue.GetConnectionsInput, func(*glue.GetConnectionsOutput, bool) bool) error
	GetConnectionsPagesWithContext(aws.Context, *glue.GetConnectionsInput, func(*glue.GetConnectionsOutput, bool) bool, ...request.Option) error

	GetCrawler(*glue.GetCrawlerInput) (*glue.GetCrawlerOutput, error)
	GetCrawlerWithContext(aws.Context, *glue.GetCrawlerInput, ...request.Option) (*glue.GetCrawlerOutput, error)
	GetCrawlerRequest(*glue.GetCrawlerInput) (*request.Request, *glue.GetCrawlerOutput)

	GetCrawlerMetrics(*glue.GetCrawlerMetricsInput) (*glue.GetCrawlerMetricsOutput, error)
	GetCrawlerMetricsWithContext(aws.Context, *glue.GetCrawlerMetricsInput, ...request.Option) (*glue.GetCrawlerMetricsOutput, error)
	GetCrawlerMetricsRequest(*glue.GetCrawlerMetricsInput) (*request.Request, *glue.GetCrawlerMetricsOutput)

	GetCrawlerMetricsPages(*glue.GetCrawlerMetricsInput, func(*glue.GetCrawlerMetricsOutput, bool) bool) error
	GetCrawlerMetricsPagesWithContext(aws.Context, *glue.GetCrawlerMetricsInput, func(*glue.GetCrawlerMetricsOutput, bool) bool, ...request.Option) error

	GetCrawlers(*glue.GetCrawlersInput) (*glue.GetCrawlersOutput, error)
	GetCrawlersWithContext(aws.Context, *glue.GetCrawlersInput, ...request.Option) (*glue.GetCrawlersOutput, error)
	GetCrawlersRequest(*glue.GetCrawlersInput) (*request.Request, *glue.GetCrawlersOutput)

	GetCrawlersPages(*glue.GetCrawlersInput, func(*glue.GetCrawlersOutput, bool) bool) error
	GetCrawlersPagesWithContext(aws.Context, *glue.GetCrawlersInput, func(*glue.GetCrawlersOutput, bool) bool, ...request.Option) error

	GetCustomEntityType(*glue.GetCustomEntityTypeInput) (*glue.GetCustomEntityTypeOutput, error)
	GetCustomEntityTypeWithContext(aws.Context, *glue.GetCustomEntityTypeInput, ...request.Option) (*glue.GetCustomEntityTypeOutput, error)
	GetCustomEntityTypeRequest(*glue.GetCustomEntityTypeInput) (*request.Request, *glue.GetCustomEntityTypeOutput)

	GetDataCatalogEncryptionSettings(*glue.GetDataCatalogEncryptionSettingsInput) (*glue.GetDataCatalogEncryptionSettingsOutput, error)
	GetDataCatalogEncryptionSettingsWithContext(aws.Context, *glue.GetDataCatalogEncryptionSettingsInput, ...request.Option) (*glue.GetDataCatalogEncryptionSettingsOutput, error)
	GetDataCatalogEncryptionSettingsRequest(*glue.GetDataCatalogEncryptionSettingsInput) (*request.Request, *glue.GetDataCatalogEncryptionSettingsOutput)

	GetDataQualityResult(*glue.GetDataQualityResultInput) (*glue.GetDataQualityResultOutput, error)
	GetDataQualityResultWithContext(aws.Context, *glue.GetDataQualityResultInput, ...request.Option) (*glue.GetDataQualityResultOutput, error)
	GetDataQualityResultRequest(*glue.GetDataQualityResultInput) (*request.Request, *glue.GetDataQualityResultOutput)

	GetDataQualityRuleRecommendationRun(*glue.GetDataQualityRuleRecommendationRunInput) (*glue.GetDataQualityRuleRecommendationRunOutput, error)
	GetDataQualityRuleRecommendationRunWithContext(aws.Context, *glue.GetDataQualityRuleRecommendationRunInput, ...request.Option) (*glue.GetDataQualityRuleRecommendationRunOutput, error)
	GetDataQualityRuleRecommendationRunRequest(*glue.GetDataQualityRuleRecommendationRunInput) (*request.Request, *glue.GetDataQualityRuleRecommendationRunOutput)

	GetDataQualityRuleset(*glue.GetDataQualityRulesetInput) (*glue.GetDataQualityRulesetOutput, error)
	GetDataQualityRulesetWithContext(aws.Context, *glue.GetDataQualityRulesetInput, ...request.Option) (*glue.GetDataQualityRulesetOutput, error)
	GetDataQualityRulesetRequest(*glue.GetDataQualityRulesetInput) (*request.Request, *glue.GetDataQualityRulesetOutput)

	GetDataQualityRulesetEvaluationRun(*glue.GetDataQualityRulesetEvaluationRunInput) (*glue.GetDataQualityRulesetEvaluationRunOutput, error)
	GetDataQualityRulesetEvaluationRunWithContext(aws.Context, *glue.GetDataQualityRulesetEvaluationRunInput, ...request.Option) (*glue.GetDataQualityRulesetEvaluationRunOutput, error)
	GetDataQualityRulesetEvaluationRunRequest(*glue.GetDataQualityRulesetEvaluationRunInput) (*request.Request, *glue.GetDataQualityRulesetEvaluationRunOutput)

	GetDatabase(*glue.GetDatabaseInput) (*glue.GetDatabaseOutput, error)
	GetDatabaseWithContext(aws.Context, *glue.GetDatabaseInput, ...request.Option) (*glue.GetDatabaseOutput, error)
	GetDatabaseRequest(*glue.GetDatabaseInput) (*request.Request, *glue.GetDatabaseOutput)

	GetDatabases(*glue.GetDatabasesInput) (*glue.GetDatabasesOutput, error)
	GetDatabasesWithContext(aws.Context, *glue.GetDatabasesInput, ...request.Option) (*glue.GetDatabasesOutput, error)
	GetDatabasesRequest(*glue.GetDatabasesInput) (*request.Request, *glue.GetDatabasesOutput)

	GetDatabasesPages(*glue.GetDatabasesInput, func(*glue.GetDatabasesOutput, bool) bool) error
	GetDatabasesPagesWithContext(aws.Context, *glue.GetDatabasesInput, func(*glue.GetDatabasesOutput, bool) bool, ...request.Option) error

	GetDataflowGraph(*glue.GetDataflowGraphInput) (*glue.GetDataflowGraphOutput, error)
	GetDataflowGraphWithContext(aws.Context, *glue.GetDataflowGraphInput, ...request.Option) (*glue.GetDataflowGraphOutput, error)
	GetDataflowGraphRequest(*glue.GetDataflowGraphInput) (*request.Request, *glue.GetDataflowGraphOutput)

	GetDevEndpoint(*glue.GetDevEndpointInput) (*glue.GetDevEndpointOutput, error)
	GetDevEndpointWithContext(aws.Context, *glue.GetDevEndpointInput, ...request.Option) (*glue.GetDevEndpointOutput, error)
	GetDevEndpointRequest(*glue.GetDevEndpointInput) (*request.Request, *glue.GetDevEndpointOutput)

	GetDevEndpoints(*glue.GetDevEndpointsInput) (*glue.GetDevEndpointsOutput, error)
	GetDevEndpointsWithContext(aws.Context, *glue.GetDevEndpointsInput, ...request.Option) (*glue.GetDevEndpointsOutput, error)
	GetDevEndpointsRequest(*glue.GetDevEndpointsInput) (*request.Request, *glue.GetDevEndpointsOutput)

	GetDevEndpointsPages(*glue.GetDevEndpointsInput, func(*glue.GetDevEndpointsOutput, bool) bool) error
	GetDevEndpointsPagesWithContext(aws.Context, *glue.GetDevEndpointsInput, func(*glue.GetDevEndpointsOutput, bool) bool, ...request.Option) error

	GetJob(*glue.GetJobInput) (*glue.GetJobOutput, error)
	GetJobWithContext(aws.Context, *glue.GetJobInput, ...request.Option) (*glue.GetJobOutput, error)
	GetJobRequest(*glue.GetJobInput) (*request.Request, *glue.GetJobOutput)

	GetJobBookmark(*glue.GetJobBookmarkInput) (*glue.GetJobBookmarkOutput, error)
	GetJobBookmarkWithContext(aws.Context, *glue.GetJobBookmarkInput, ...request.Option) (*glue.GetJobBookmarkOutput, error)
	GetJobBookmarkRequest(*glue.GetJobBookmarkInput) (*request.Request, *glue.GetJobBookmarkOutput)

	GetJobRun(*glue.GetJobRunInput) (*glue.GetJobRunOutput, error)
	GetJobRunWithContext(aws.Context, *glue.GetJobRunInput, ...request.Option) (*glue.GetJobRunOutput, error)
	GetJobRunRequest(*glue.GetJobRunInput) (*request.Request, *glue.GetJobRunOutput)

	GetJobRuns(*glue.GetJobRunsInput) (*glue.GetJobRunsOutput, error)
	GetJobRunsWithContext(aws.Context, *glue.GetJobRunsInput, ...request.Option) (*glue.GetJobRunsOutput, error)
	GetJobRunsRequest(*glue.GetJobRunsInput) (*request.Request, *glue.GetJobRunsOutput)

	GetJobRunsPages(*glue.GetJobRunsInput, func(*glue.GetJobRunsOutput, bool) bool) error
	GetJobRunsPagesWithContext(aws.Context, *glue.GetJobRunsInput, func(*glue.GetJobRunsOutput, bool) bool, ...request.Option) error

	GetJobs(*glue.GetJobsInput) (*glue.GetJobsOutput, error)
	GetJobsWithContext(aws.Context, *glue.GetJobsInput, ...request.Option) (*glue.GetJobsOutput, error)
	GetJobsRequest(*glue.GetJobsInput) (*request.Request, *glue.GetJobsOutput)

	GetJobsPages(*glue.GetJobsInput, func(*glue.GetJobsOutput, bool) bool) error
	GetJobsPagesWithContext(aws.Context, *glue.GetJobsInput, func(*glue.GetJobsOutput, bool) bool, ...request.Option) error

	GetMLTaskRun(*glue.GetMLTaskRunInput) (*glue.GetMLTaskRunOutput, error)
	GetMLTaskRunWithContext(aws.Context, *glue.GetMLTaskRunInput, ...request.Option) (*glue.GetMLTaskRunOutput, error)
	GetMLTaskRunRequest(*glue.GetMLTaskRunInput) (*request.Request, *glue.GetMLTaskRunOutput)

	GetMLTaskRuns(*glue.GetMLTaskRunsInput) (*glue.GetMLTaskRunsOutput, error)
	GetMLTaskRunsWithContext(aws.Context, *glue.GetMLTaskRunsInput, ...request.Option) (*glue.GetMLTaskRunsOutput, error)
	GetMLTaskRunsRequest(*glue.GetMLTaskRunsInput) (*request.Request, *glue.GetMLTaskRunsOutput)

	GetMLTaskRunsPages(*glue.GetMLTaskRunsInput, func(*glue.GetMLTaskRunsOutput, bool) bool) error
	GetMLTaskRunsPagesWithContext(aws.Context, *glue.GetMLTaskRunsInput, func(*glue.GetMLTaskRunsOutput, bool) bool, ...request.Option) error

	GetMLTransform(*glue.GetMLTransformInput) (*glue.GetMLTransformOutput, error)
	GetMLTransformWithContext(aws.Context, *glue.GetMLTransformInput, ...request.Option) (*glue.GetMLTransformOutput, error)
	GetMLTransformRequest(*glue.GetMLTransformInput) (*request.Request, *glue.GetMLTransformOutput)

	GetMLTransforms(*glue.GetMLTransformsInput) (*glue.GetMLTransformsOutput, error)
	GetMLTransformsWithContext(aws.Context, *glue.GetMLTransformsInput, ...request.Option) (*glue.GetMLTransformsOutput, error)
	GetMLTransformsRequest(*glue.GetMLTransformsInput) (*request.Request, *glue.GetMLTransformsOutput)

	GetMLTransformsPages(*glue.GetMLTransformsInput, func(*glue.GetMLTransformsOutput, bool) bool) error
	GetMLTransformsPagesWithContext(aws.Context, *glue.GetMLTransformsInput, func(*glue.GetMLTransformsOutput, bool) bool, ...request.Option) error

	GetMapping(*glue.GetMappingInput) (*glue.GetMappingOutput, error)
	GetMappingWithContext(aws.Context, *glue.GetMappingInput, ...request.Option) (*glue.GetMappingOutput, error)
	GetMappingRequest(*glue.GetMappingInput) (*request.Request, *glue.GetMappingOutput)

	GetPartition(*glue.GetPartitionInput) (*glue.GetPartitionOutput, error)
	GetPartitionWithContext(aws.Context, *glue.GetPartitionInput, ...request.Option) (*glue.GetPartitionOutput, error)
	GetPartitionRequest(*glue.GetPartitionInput) (*request.Request, *glue.GetPartitionOutput)

	GetPartitionIndexes(*glue.GetPartitionIndexesInput) (*glue.GetPartitionIndexesOutput, error)
	GetPartitionIndexesWithContext(aws.Context, *glue.GetPartitionIndexesInput, ...request.Option) (*glue.GetPartitionIndexesOutput, error)
	GetPartitionIndexesRequest(*glue.GetPartitionIndexesInput) (*request.Request, *glue.GetPartitionIndexesOutput)

	GetPartitionIndexesPages(*glue.GetPartitionIndexesInput, func(*glue.GetPartitionIndexesOutput, bool) bool) error
	GetPartitionIndexesPagesWithContext(aws.Context, *glue.GetPartitionIndexesInput, func(*glue.GetPartitionIndexesOutput, bool) bool, ...request.Option) error

	GetPartitions(*glue.GetPartitionsInput) (*glue.GetPartitionsOutput, error)
	GetPartitionsWithContext(aws.Context, *glue.GetPartitionsInput, ...request.Option) (*glue.GetPartitionsOutput, error)
	GetPartitionsRequest(*glue.GetPartitionsInput) (*request.Request, *glue.GetPartitionsOutput)

	GetPartitionsPages(*glue.GetPartitionsInput, func(*glue.GetPartitionsOutput, bool) bool) error
	GetPartitionsPagesWithContext(aws.Context, *glue.GetPartitionsInput, func(*glue.GetPartitionsOutput, bool) bool, ...request.Option) error

	GetPlan(*glue.GetPlanInput) (*glue.GetPlanOutput, error)
	GetPlanWithContext(aws.Context, *glue.GetPlanInput, ...request.Option) (*glue.GetPlanOutput, error)
	GetPlanRequest(*glue.GetPlanInput) (*request.Request, *glue.GetPlanOutput)

	GetRegistry(*glue.GetRegistryInput) (*glue.GetRegistryOutput, error)
	GetRegistryWithContext(aws.Context, *glue.GetRegistryInput, ...request.Option) (*glue.GetRegistryOutput, error)
	GetRegistryRequest(*glue.GetRegistryInput) (*request.Request, *glue.GetRegistryOutput)

	GetResourcePolicies(*glue.GetResourcePoliciesInput) (*glue.GetResourcePoliciesOutput, error)
	GetResourcePoliciesWithContext(aws.Context, *glue.GetResourcePoliciesInput, ...request.Option) (*glue.GetResourcePoliciesOutput, error)
	GetResourcePoliciesRequest(*glue.GetResourcePoliciesInput) (*request.Request, *glue.GetResourcePoliciesOutput)

	GetResourcePoliciesPages(*glue.GetResourcePoliciesInput, func(*glue.GetResourcePoliciesOutput, bool) bool) error
	GetResourcePoliciesPagesWithContext(aws.Context, *glue.GetResourcePoliciesInput, func(*glue.GetResourcePoliciesOutput, bool) bool, ...request.Option) error

	GetResourcePolicy(*glue.GetResourcePolicyInput) (*glue.GetResourcePolicyOutput, error)
	GetResourcePolicyWithContext(aws.Context, *glue.GetResourcePolicyInput, ...request.Option) (*glue.GetResourcePolicyOutput, error)
	GetResourcePolicyRequest(*glue.GetResourcePolicyInput) (*request.Request, *glue.GetResourcePolicyOutput)

	GetSchema(*glue.GetSchemaInput) (*glue.GetSchemaOutput, error)
	GetSchemaWithContext(aws.Context, *glue.GetSchemaInput, ...request.Option) (*glue.GetSchemaOutput, error)
	GetSchemaRequest(*glue.GetSchemaInput) (*request.Request, *glue.GetSchemaOutput)

	GetSchemaByDefinition(*glue.GetSchemaByDefinitionInput) (*glue.GetSchemaByDefinitionOutput, error)
	GetSchemaByDefinitionWithContext(aws.Context, *glue.GetSchemaByDefinitionInput, ...request.Option) (*glue.GetSchemaByDefinitionOutput, error)
	GetSchemaByDefinitionRequest(*glue.GetSchemaByDefinitionInput) (*request.Request, *glue.GetSchemaByDefinitionOutput)

	GetSchemaVersion(*glue.GetSchemaVersionInput) (*glue.GetSchemaVersionOutput, error)
	GetSchemaVersionWithContext(aws.Context, *glue.GetSchemaVersionInput, ...request.Option) (*glue.GetSchemaVersionOutput, error)
	GetSchemaVersionRequest(*glue.GetSchemaVersionInput) (*request.Request, *glue.GetSchemaVersionOutput)

	GetSchemaVersionsDiff(*glue.GetSchemaVersionsDiffInput) (*glue.GetSchemaVersionsDiffOutput, error)
	GetSchemaVersionsDiffWithContext(aws.Context, *glue.GetSchemaVersionsDiffInput, ...request.Option) (*glue.GetSchemaVersionsDiffOutput, error)
	GetSchemaVersionsDiffRequest(*glue.GetSchemaVersionsDiffInput) (*request.Request, *glue.GetSchemaVersionsDiffOutput)

	GetSecurityConfiguration(*glue.GetSecurityConfigurationInput) (*glue.GetSecurityConfigurationOutput, error)
	GetSecurityConfigurationWithContext(aws.Context, *glue.GetSecurityConfigurationInput, ...request.Option) (*glue.GetSecurityConfigurationOutput, error)
	GetSecurityConfigurationRequest(*glue.GetSecurityConfigurationInput) (*request.Request, *glue.GetSecurityConfigurationOutput)

	GetSecurityConfigurations(*glue.GetSecurityConfigurationsInput) (*glue.GetSecurityConfigurationsOutput, error)
	GetSecurityConfigurationsWithContext(aws.Context, *glue.GetSecurityConfigurationsInput, ...request.Option) (*glue.GetSecurityConfigurationsOutput, error)
	GetSecurityConfigurationsRequest(*glue.GetSecurityConfigurationsInput) (*request.Request, *glue.GetSecurityConfigurationsOutput)

	GetSecurityConfigurationsPages(*glue.GetSecurityConfigurationsInput, func(*glue.GetSecurityConfigurationsOutput, bool) bool) error
	GetSecurityConfigurationsPagesWithContext(aws.Context, *glue.GetSecurityConfigurationsInput, func(*glue.GetSecurityConfigurationsOutput, bool) bool, ...request.Option) error

	GetSession(*glue.GetSessionInput) (*glue.GetSessionOutput, error)
	GetSessionWithContext(aws.Context, *glue.GetSessionInput, ...request.Option) (*glue.GetSessionOutput, error)
	GetSessionRequest(*glue.GetSessionInput) (*request.Request, *glue.GetSessionOutput)

	GetStatement(*glue.GetStatementInput) (*glue.GetStatementOutput, error)
	GetStatementWithContext(aws.Context, *glue.GetStatementInput, ...request.Option) (*glue.GetStatementOutput, error)
	GetStatementRequest(*glue.GetStatementInput) (*request.Request, *glue.GetStatementOutput)

	GetTable(*glue.GetTableInput) (*glue.GetTableOutput, error)
	GetTableWithContext(aws.Context, *glue.GetTableInput, ...request.Option) (*glue.GetTableOutput, error)
	GetTableRequest(*glue.GetTableInput) (*request.Request, *glue.GetTableOutput)

	GetTableVersion(*glue.GetTableVersionInput) (*glue.GetTableVersionOutput, error)
	GetTableVersionWithContext(aws.Context, *glue.GetTableVersionInput, ...request.Option) (*glue.GetTableVersionOutput, error)
	GetTableVersionRequest(*glue.GetTableVersionInput) (*request.Request, *glue.GetTableVersionOutput)

	GetTableVersions(*glue.GetTableVersionsInput) (*glue.GetTableVersionsOutput, error)
	GetTableVersionsWithContext(aws.Context, *glue.GetTableVersionsInput, ...request.Option) (*glue.GetTableVersionsOutput, error)
	GetTableVersionsRequest(*glue.GetTableVersionsInput) (*request.Request, *glue.GetTableVersionsOutput)

	GetTableVersionsPages(*glue.GetTableVersionsInput, func(*glue.GetTableVersionsOutput, bool) bool) error
	GetTableVersionsPagesWithContext(aws.Context, *glue.GetTableVersionsInput, func(*glue.GetTableVersionsOutput, bool) bool, ...request.Option) error

	GetTables(*glue.GetTablesInput) (*glue.GetTablesOutput, error)
	GetTablesWithContext(aws.Context, *glue.GetTablesInput, ...request.Option) (*glue.GetTablesOutput, error)
	GetTablesRequest(*glue.GetTablesInput) (*request.Request, *glue.GetTablesOutput)

	GetTablesPages(*glue.GetTablesInput, func(*glue.GetTablesOutput, bool) bool) error
	GetTablesPagesWithContext(aws.Context, *glue.GetTablesInput, func(*glue.GetTablesOutput, bool) bool, ...request.Option) error

	GetTags(*glue.GetTagsInput) (*glue.GetTagsOutput, error)
	GetTagsWithContext(aws.Context, *glue.GetTagsInput, ...request.Option) (*glue.GetTagsOutput, error)
	GetTagsRequest(*glue.GetTagsInput) (*request.Request, *glue.GetTagsOutput)

	GetTrigger(*glue.GetTriggerInput) (*glue.GetTriggerOutput, error)
	GetTriggerWithContext(aws.Context, *glue.GetTriggerInput, ...request.Option) (*glue.GetTriggerOutput, error)
	GetTriggerRequest(*glue.GetTriggerInput) (*request.Request, *glue.GetTriggerOutput)

	GetTriggers(*glue.GetTriggersInput) (*glue.GetTriggersOutput, error)
	GetTriggersWithContext(aws.Context, *glue.GetTriggersInput, ...request.Option) (*glue.GetTriggersOutput, error)
	GetTriggersRequest(*glue.GetTriggersInput) (*request.Request, *glue.GetTriggersOutput)

	GetTriggersPages(*glue.GetTriggersInput, func(*glue.GetTriggersOutput, bool) bool) error
	GetTriggersPagesWithContext(aws.Context, *glue.GetTriggersInput, func(*glue.GetTriggersOutput, bool) bool, ...request.Option) error

	GetUnfilteredPartitionMetadata(*glue.GetUnfilteredPartitionMetadataInput) (*glue.GetUnfilteredPartitionMetadataOutput, error)
	GetUnfilteredPartitionMetadataWithContext(aws.Context, *glue.GetUnfilteredPartitionMetadataInput, ...request.Option) (*glue.GetUnfilteredPartitionMetadataOutput, error)
	GetUnfilteredPartitionMetadataRequest(*glue.GetUnfilteredPartitionMetadataInput) (*request.Request, *glue.GetUnfilteredPartitionMetadataOutput)

	GetUnfilteredPartitionsMetadata(*glue.GetUnfilteredPartitionsMetadataInput) (*glue.GetUnfilteredPartitionsMetadataOutput, error)
	GetUnfilteredPartitionsMetadataWithContext(aws.Context, *glue.GetUnfilteredPartitionsMetadataInput, ...request.Option) (*glue.GetUnfilteredPartitionsMetadataOutput, error)
	GetUnfilteredPartitionsMetadataRequest(*glue.GetUnfilteredPartitionsMetadataInput) (*request.Request, *glue.GetUnfilteredPartitionsMetadataOutput)

	GetUnfilteredPartitionsMetadataPages(*glue.GetUnfilteredPartitionsMetadataInput, func(*glue.GetUnfilteredPartitionsMetadataOutput, bool) bool) error
	GetUnfilteredPartitionsMetadataPagesWithContext(aws.Context, *glue.GetUnfilteredPartitionsMetadataInput, func(*glue.GetUnfilteredPartitionsMetadataOutput, bool) bool, ...request.Option) error

	GetUnfilteredTableMetadata(*glue.GetUnfilteredTableMetadataInput) (*glue.GetUnfilteredTableMetadataOutput, error)
	GetUnfilteredTableMetadataWithContext(aws.Context, *glue.GetUnfilteredTableMetadataInput, ...request.Option) (*glue.GetUnfilteredTableMetadataOutput, error)
	GetUnfilteredTableMetadataRequest(*glue.GetUnfilteredTableMetadataInput) (*request.Request, *glue.GetUnfilteredTableMetadataOutput)

	GetUserDefinedFunction(*glue.GetUserDefinedFunctionInput) (*glue.GetUserDefinedFunctionOutput, error)
	GetUserDefinedFunctionWithContext(aws.Context, *glue.GetUserDefinedFunctionInput, ...request.Option) (*glue.GetUserDefinedFunctionOutput, error)
	GetUserDefinedFunctionRequest(*glue.GetUserDefinedFunctionInput) (*request.Request, *glue.GetUserDefinedFunctionOutput)

	GetUserDefinedFunctions(*glue.GetUserDefinedFunctionsInput) (*glue.GetUserDefinedFunctionsOutput, error)
	GetUserDefinedFunctionsWithContext(aws.Context, *glue.GetUserDefinedFunctionsInput, ...request.Option) (*glue.GetUserDefinedFunctionsOutput, error)
	GetUserDefinedFunctionsRequest(*glue.GetUserDefinedFunctionsInput) (*request.Request, *glue.GetUserDefinedFunctionsOutput)

	GetUserDefinedFunctionsPages(*glue.GetUserDefinedFunctionsInput, func(*glue.GetUserDefinedFunctionsOutput, bool) bool) error
	GetUserDefinedFunctionsPagesWithContext(aws.Context, *glue.GetUserDefinedFunctionsInput, func(*glue.GetUserDefinedFunctionsOutput, bool) bool, ...request.Option) error

	GetWorkflow(*glue.GetWorkflowInput) (*glue.GetWorkflowOutput, error)
	GetWorkflowWithContext(aws.Context, *glue.GetWorkflowInput, ...request.Option) (*glue.GetWorkflowOutput, error)
	GetWorkflowRequest(*glue.GetWorkflowInput) (*request.Request, *glue.GetWorkflowOutput)

	GetWorkflowRun(*glue.GetWorkflowRunInput) (*glue.GetWorkflowRunOutput, error)
	GetWorkflowRunWithContext(aws.Context, *glue.GetWorkflowRunInput, ...request.Option) (*glue.GetWorkflowRunOutput, error)
	GetWorkflowRunRequest(*glue.GetWorkflowRunInput) (*request.Request, *glue.GetWorkflowRunOutput)

	GetWorkflowRunProperties(*glue.GetWorkflowRunPropertiesInput) (*glue.GetWorkflowRunPropertiesOutput, error)
	GetWorkflowRunPropertiesWithContext(aws.Context, *glue.GetWorkflowRunPropertiesInput, ...request.Option) (*glue.GetWorkflowRunPropertiesOutput, error)
	GetWorkflowRunPropertiesRequest(*glue.GetWorkflowRunPropertiesInput) (*request.Request, *glue.GetWorkflowRunPropertiesOutput)

	GetWorkflowRuns(*glue.GetWorkflowRunsInput) (*glue.GetWorkflowRunsOutput, error)
	GetWorkflowRunsWithContext(aws.Context, *glue.GetWorkflowRunsInput, ...request.Option) (*glue.GetWorkflowRunsOutput, error)
	GetWorkflowRunsRequest(*glue.GetWorkflowRunsInput) (*request.Request, *glue.GetWorkflowRunsOutput)

	GetWorkflowRunsPages(*glue.GetWorkflowRunsInput, func(*glue.GetWorkflowRunsOutput, bool) bool) error
	GetWorkflowRunsPagesWithContext(aws.Context, *glue.GetWorkflowRunsInput, func(*glue.GetWorkflowRunsOutput, bool) bool, ...request.Option) error

	ImportCatalogToGlue(*glue.ImportCatalogToGlueInput) (*glue.ImportCatalogToGlueOutput, error)
	ImportCatalogToGlueWithContext(aws.Context, *glue.ImportCatalogToGlueInput, ...request.Option) (*glue.ImportCatalogToGlueOutput, error)
	ImportCatalogToGlueRequest(*glue.ImportCatalogToGlueInput) (*request.Request, *glue.ImportCatalogToGlueOutput)

	ListBlueprints(*glue.ListBlueprintsInput) (*glue.ListBlueprintsOutput, error)
	ListBlueprintsWithContext(aws.Context, *glue.ListBlueprintsInput, ...request.Option) (*glue.ListBlueprintsOutput, error)
	ListBlueprintsRequest(*glue.ListBlueprintsInput) (*request.Request, *glue.ListBlueprintsOutput)

	ListBlueprintsPages(*glue.ListBlueprintsInput, func(*glue.ListBlueprintsOutput, bool) bool) error
	ListBlueprintsPagesWithContext(aws.Context, *glue.ListBlueprintsInput, func(*glue.ListBlueprintsOutput, bool) bool, ...request.Option) error

	ListCrawlers(*glue.ListCrawlersInput) (*glue.ListCrawlersOutput, error)
	ListCrawlersWithContext(aws.Context, *glue.ListCrawlersInput, ...request.Option) (*glue.ListCrawlersOutput, error)
	ListCrawlersRequest(*glue.ListCrawlersInput) (*request.Request, *glue.ListCrawlersOutput)

	ListCrawlersPages(*glue.ListCrawlersInput, func(*glue.ListCrawlersOutput, bool) bool) error
	ListCrawlersPagesWithContext(aws.Context, *glue.ListCrawlersInput, func(*glue.ListCrawlersOutput, bool) bool, ...request.Option) error

	ListCrawls(*glue.ListCrawlsInput) (*glue.ListCrawlsOutput, error)
	ListCrawlsWithContext(aws.Context, *glue.ListCrawlsInput, ...request.Option) (*glue.ListCrawlsOutput, error)
	ListCrawlsRequest(*glue.ListCrawlsInput) (*request.Request, *glue.ListCrawlsOutput)

	ListCustomEntityTypes(*glue.ListCustomEntityTypesInput) (*glue.ListCustomEntityTypesOutput, error)
	ListCustomEntityTypesWithContext(aws.Context, *glue.ListCustomEntityTypesInput, ...request.Option) (*glue.ListCustomEntityTypesOutput, error)
	ListCustomEntityTypesRequest(*glue.ListCustomEntityTypesInput) (*request.Request, *glue.ListCustomEntityTypesOutput)

	ListCustomEntityTypesPages(*glue.ListCustomEntityTypesInput, func(*glue.ListCustomEntityTypesOutput, bool) bool) error
	ListCustomEntityTypesPagesWithContext(aws.Context, *glue.ListCustomEntityTypesInput, func(*glue.ListCustomEntityTypesOutput, bool) bool, ...request.Option) error

	ListDataQualityResults(*glue.ListDataQualityResultsInput) (*glue.ListDataQualityResultsOutput, error)
	ListDataQualityResultsWithContext(aws.Context, *glue.ListDataQualityResultsInput, ...request.Option) (*glue.ListDataQualityResultsOutput, error)
	ListDataQualityResultsRequest(*glue.ListDataQualityResultsInput) (*request.Request, *glue.ListDataQualityResultsOutput)

	ListDataQualityResultsPages(*glue.ListDataQualityResultsInput, func(*glue.ListDataQualityResultsOutput, bool) bool) error
	ListDataQualityResultsPagesWithContext(aws.Context, *glue.ListDataQualityResultsInput, func(*glue.ListDataQualityResultsOutput, bool) bool, ...request.Option) error

	ListDataQualityRuleRecommendationRuns(*glue.ListDataQualityRuleRecommendationRunsInput) (*glue.ListDataQualityRuleRecommendationRunsOutput, error)
	ListDataQualityRuleRecommendationRunsWithContext(aws.Context, *glue.ListDataQualityRuleRecommendationRunsInput, ...request.Option) (*glue.ListDataQualityRuleRecommendationRunsOutput, error)
	ListDataQualityRuleRecommendationRunsRequest(*glue.ListDataQualityRuleRecommendationRunsInput) (*request.Request, *glue.ListDataQualityRuleRecommendationRunsOutput)

	ListDataQualityRuleRecommendationRunsPages(*glue.ListDataQualityRuleRecommendationRunsInput, func(*glue.ListDataQualityRuleRecommendationRunsOutput, bool) bool) error
	ListDataQualityRuleRecommendationRunsPagesWithContext(aws.Context, *glue.ListDataQualityRuleRecommendationRunsInput, func(*glue.ListDataQualityRuleRecommendationRunsOutput, bool) bool, ...request.Option) error

	ListDataQualityRulesetEvaluationRuns(*glue.ListDataQualityRulesetEvaluationRunsInput) (*glue.ListDataQualityRulesetEvaluationRunsOutput, error)
	ListDataQualityRulesetEvaluationRunsWithContext(aws.Context, *glue.ListDataQualityRulesetEvaluationRunsInput, ...request.Option) (*glue.ListDataQualityRulesetEvaluationRunsOutput, error)
	ListDataQualityRulesetEvaluationRunsRequest(*glue.ListDataQualityRulesetEvaluationRunsInput) (*request.Request, *glue.ListDataQualityRulesetEvaluationRunsOutput)

	ListDataQualityRulesetEvaluationRunsPages(*glue.ListDataQualityRulesetEvaluationRunsInput, func(*glue.ListDataQualityRulesetEvaluationRunsOutput, bool) bool) error
	ListDataQualityRulesetEvaluationRunsPagesWithContext(aws.Context, *glue.ListDataQualityRulesetEvaluationRunsInput, func(*glue.ListDataQualityRulesetEvaluationRunsOutput, bool) bool, ...request.Option) error

	ListDataQualityRulesets(*glue.ListDataQualityRulesetsInput) (*glue.ListDataQualityRulesetsOutput, error)
	ListDataQualityRulesetsWithContext(aws.Context, *glue.ListDataQualityRulesetsInput, ...request.Option) (*glue.ListDataQualityRulesetsOutput, error)
	ListDataQualityRulesetsRequest(*glue.ListDataQualityRulesetsInput) (*request.Request, *glue.ListDataQualityRulesetsOutput)

	ListDataQualityRulesetsPages(*glue.ListDataQualityRulesetsInput, func(*glue.ListDataQualityRulesetsOutput, bool) bool) error
	ListDataQualityRulesetsPagesWithContext(aws.Context, *glue.ListDataQualityRulesetsInput, func(*glue.ListDataQualityRulesetsOutput, bool) bool, ...request.Option) error

	ListDevEndpoints(*glue.ListDevEndpointsInput) (*glue.ListDevEndpointsOutput, error)
	ListDevEndpointsWithContext(aws.Context, *glue.ListDevEndpointsInput, ...request.Option) (*glue.ListDevEndpointsOutput, error)
	ListDevEndpointsRequest(*glue.ListDevEndpointsInput) (*request.Request, *glue.ListDevEndpointsOutput)

	ListDevEndpointsPages(*glue.ListDevEndpointsInput, func(*glue.ListDevEndpointsOutput, bool) bool) error
	ListDevEndpointsPagesWithContext(aws.Context, *glue.ListDevEndpointsInput, func(*glue.ListDevEndpointsOutput, bool) bool, ...request.Option) error

	ListJobs(*glue.ListJobsInput) (*glue.ListJobsOutput, error)
	ListJobsWithContext(aws.Context, *glue.ListJobsInput, ...request.Option) (*glue.ListJobsOutput, error)
	ListJobsRequest(*glue.ListJobsInput) (*request.Request, *glue.ListJobsOutput)

	ListJobsPages(*glue.ListJobsInput, func(*glue.ListJobsOutput, bool) bool) error
	ListJobsPagesWithContext(aws.Context, *glue.ListJobsInput, func(*glue.ListJobsOutput, bool) bool, ...request.Option) error

	ListMLTransforms(*glue.ListMLTransformsInput) (*glue.ListMLTransformsOutput, error)
	ListMLTransformsWithContext(aws.Context, *glue.ListMLTransformsInput, ...request.Option) (*glue.ListMLTransformsOutput, error)
	ListMLTransformsRequest(*glue.ListMLTransformsInput) (*request.Request, *glue.ListMLTransformsOutput)

	ListMLTransformsPages(*glue.ListMLTransformsInput, func(*glue.ListMLTransformsOutput, bool) bool) error
	ListMLTransformsPagesWithContext(aws.Context, *glue.ListMLTransformsInput, func(*glue.ListMLTransformsOutput, bool) bool, ...request.Option) error

	ListRegistries(*glue.ListRegistriesInput) (*glue.ListRegistriesOutput, error)
	ListRegistriesWithContext(aws.Context, *glue.ListRegistriesInput, ...request.Option) (*glue.ListRegistriesOutput, error)
	ListRegistriesRequest(*glue.ListRegistriesInput) (*request.Request, *glue.ListRegistriesOutput)

	ListRegistriesPages(*glue.ListRegistriesInput, func(*glue.ListRegistriesOutput, bool) bool) error
	ListRegistriesPagesWithContext(aws.Context, *glue.ListRegistriesInput, func(*glue.ListRegistriesOutput, bool) bool, ...request.Option) error

	ListSchemaVersions(*glue.ListSchemaVersionsInput) (*glue.ListSchemaVersionsOutput, error)
	ListSchemaVersionsWithContext(aws.Context, *glue.ListSchemaVersionsInput, ...request.Option) (*glue.ListSchemaVersionsOutput, error)
	ListSchemaVersionsRequest(*glue.ListSchemaVersionsInput) (*request.Request, *glue.ListSchemaVersionsOutput)

	ListSchemaVersionsPages(*glue.ListSchemaVersionsInput, func(*glue.ListSchemaVersionsOutput, bool) bool) error
	ListSchemaVersionsPagesWithContext(aws.Context, *glue.ListSchemaVersionsInput, func(*glue.ListSchemaVersionsOutput, bool) bool, ...request.Option) error

	ListSchemas(*glue.ListSchemasInput) (*glue.ListSchemasOutput, error)
	ListSchemasWithContext(aws.Context, *glue.ListSchemasInput, ...request.Option) (*glue.ListSchemasOutput, error)
	ListSchemasRequest(*glue.ListSchemasInput) (*request.Request, *glue.ListSchemasOutput)

	ListSchemasPages(*glue.ListSchemasInput, func(*glue.ListSchemasOutput, bool) bool) error
	ListSchemasPagesWithContext(aws.Context, *glue.ListSchemasInput, func(*glue.ListSchemasOutput, bool) bool, ...request.Option) error

	ListSessions(*glue.ListSessionsInput) (*glue.ListSessionsOutput, error)
	ListSessionsWithContext(aws.Context, *glue.ListSessionsInput, ...request.Option) (*glue.ListSessionsOutput, error)
	ListSessionsRequest(*glue.ListSessionsInput) (*request.Request, *glue.ListSessionsOutput)

	ListSessionsPages(*glue.ListSessionsInput, func(*glue.ListSessionsOutput, bool) bool) error
	ListSessionsPagesWithContext(aws.Context, *glue.ListSessionsInput, func(*glue.ListSessionsOutput, bool) bool, ...request.Option) error

	ListStatements(*glue.ListStatementsInput) (*glue.ListStatementsOutput, error)
	ListStatementsWithContext(aws.Context, *glue.ListStatementsInput, ...request.Option) (*glue.ListStatementsOutput, error)
	ListStatementsRequest(*glue.ListStatementsInput) (*request.Request, *glue.ListStatementsOutput)

	ListTriggers(*glue.ListTriggersInput) (*glue.ListTriggersOutput, error)
	ListTriggersWithContext(aws.Context, *glue.ListTriggersInput, ...request.Option) (*glue.ListTriggersOutput, error)
	ListTriggersRequest(*glue.ListTriggersInput) (*request.Request, *glue.ListTriggersOutput)

	ListTriggersPages(*glue.ListTriggersInput, func(*glue.ListTriggersOutput, bool) bool) error
	ListTriggersPagesWithContext(aws.Context, *glue.ListTriggersInput, func(*glue.ListTriggersOutput, bool) bool, ...request.Option) error

	ListWorkflows(*glue.ListWorkflowsInput) (*glue.ListWorkflowsOutput, error)
	ListWorkflowsWithContext(aws.Context, *glue.ListWorkflowsInput, ...request.Option) (*glue.ListWorkflowsOutput, error)
	ListWorkflowsRequest(*glue.ListWorkflowsInput) (*request.Request, *glue.ListWorkflowsOutput)

	ListWorkflowsPages(*glue.ListWorkflowsInput, func(*glue.ListWorkflowsOutput, bool) bool) error
	ListWorkflowsPagesWithContext(aws.Context, *glue.ListWorkflowsInput, func(*glue.ListWorkflowsOutput, bool) bool, ...request.Option) error

	PutDataCatalogEncryptionSettings(*glue.PutDataCatalogEncryptionSettingsInput) (*glue.PutDataCatalogEncryptionSettingsOutput, error)
	PutDataCatalogEncryptionSettingsWithContext(aws.Context, *glue.PutDataCatalogEncryptionSettingsInput, ...request.Option) (*glue.PutDataCatalogEncryptionSettingsOutput, error)
	PutDataCatalogEncryptionSettingsRequest(*glue.PutDataCatalogEncryptionSettingsInput) (*request.Request, *glue.PutDataCatalogEncryptionSettingsOutput)

	PutResourcePolicy(*glue.PutResourcePolicyInput) (*glue.PutResourcePolicyOutput, error)
	PutResourcePolicyWithContext(aws.Context, *glue.PutResourcePolicyInput, ...request.Option) (*glue.PutResourcePolicyOutput, error)
	PutResourcePolicyRequest(*glue.PutResourcePolicyInput) (*request.Request, *glue.PutResourcePolicyOutput)

	PutSchemaVersionMetadata(*glue.PutSchemaVersionMetadataInput) (*glue.PutSchemaVersionMetadataOutput, error)
	PutSchemaVersionMetadataWithContext(aws.Context, *glue.PutSchemaVersionMetadataInput, ...request.Option) (*glue.PutSchemaVersionMetadataOutput, error)
	PutSchemaVersionMetadataRequest(*glue.PutSchemaVersionMetadataInput) (*request.Request, *glue.PutSchemaVersionMetadataOutput)

	PutWorkflowRunProperties(*glue.PutWorkflowRunPropertiesInput) (*glue.PutWorkflowRunPropertiesOutput, error)
	PutWorkflowRunPropertiesWithContext(aws.Context, *glue.PutWorkflowRunPropertiesInput, ...request.Option) (*glue.PutWorkflowRunPropertiesOutput, error)
	PutWorkflowRunPropertiesRequest(*glue.PutWorkflowRunPropertiesInput) (*request.Request, *glue.PutWorkflowRunPropertiesOutput)

	QuerySchemaVersionMetadata(*glue.QuerySchemaVersionMetadataInput) (*glue.QuerySchemaVersionMetadataOutput, error)
	QuerySchemaVersionMetadataWithContext(aws.Context, *glue.QuerySchemaVersionMetadataInput, ...request.Option) (*glue.QuerySchemaVersionMetadataOutput, error)
	QuerySchemaVersionMetadataRequest(*glue.QuerySchemaVersionMetadataInput) (*request.Request, *glue.QuerySchemaVersionMetadataOutput)

	RegisterSchemaVersion(*glue.RegisterSchemaVersionInput) (*glue.RegisterSchemaVersionOutput, error)
	RegisterSchemaVersionWithContext(aws.Context, *glue.RegisterSchemaVersionInput, ...request.Option) (*glue.RegisterSchemaVersionOutput, error)
	RegisterSchemaVersionRequest(*glue.RegisterSchemaVersionInput) (*request.Request, *glue.RegisterSchemaVersionOutput)

	RemoveSchemaVersionMetadata(*glue.RemoveSchemaVersionMetadataInput) (*glue.RemoveSchemaVersionMetadataOutput, error)
	RemoveSchemaVersionMetadataWithContext(aws.Context, *glue.RemoveSchemaVersionMetadataInput, ...request.Option) (*glue.RemoveSchemaVersionMetadataOutput, error)
	RemoveSchemaVersionMetadataRequest(*glue.RemoveSchemaVersionMetadataInput) (*request.Request, *glue.RemoveSchemaVersionMetadataOutput)

	ResetJobBookmark(*glue.ResetJobBookmarkInput) (*glue.ResetJobBookmarkOutput, error)
	ResetJobBookmarkWithContext(aws.Context, *glue.ResetJobBookmarkInput, ...request.Option) (*glue.ResetJobBookmarkOutput, error)
	ResetJobBookmarkRequest(*glue.ResetJobBookmarkInput) (*request.Request, *glue.ResetJobBookmarkOutput)

	ResumeWorkflowRun(*glue.ResumeWorkflowRunInput) (*glue.ResumeWorkflowRunOutput, error)
	ResumeWorkflowRunWithContext(aws.Context, *glue.ResumeWorkflowRunInput, ...request.Option) (*glue.ResumeWorkflowRunOutput, error)
	ResumeWorkflowRunRequest(*glue.ResumeWorkflowRunInput) (*request.Request, *glue.ResumeWorkflowRunOutput)

	RunStatement(*glue.RunStatementInput) (*glue.RunStatementOutput, error)
	RunStatementWithContext(aws.Context, *glue.RunStatementInput, ...request.Option) (*glue.RunStatementOutput, error)
	RunStatementRequest(*glue.RunStatementInput) (*request.Request, *glue.RunStatementOutput)

	SearchTables(*glue.SearchTablesInput) (*glue.SearchTablesOutput, error)
	SearchTablesWithContext(aws.Context, *glue.SearchTablesInput, ...request.Option) (*glue.SearchTablesOutput, error)
	SearchTablesRequest(*glue.SearchTablesInput) (*request.Request, *glue.SearchTablesOutput)

	SearchTablesPages(*glue.SearchTablesInput, func(*glue.SearchTablesOutput, bool) bool) error
	SearchTablesPagesWithContext(aws.Context, *glue.SearchTablesInput, func(*glue.SearchTablesOutput, bool) bool, ...request.Option) error

	StartBlueprintRun(*glue.StartBlueprintRunInput) (*glue.StartBlueprintRunOutput, error)
	StartBlueprintRunWithContext(aws.Context, *glue.StartBlueprintRunInput, ...request.Option) (*glue.StartBlueprintRunOutput, error)
	StartBlueprintRunRequest(*glue.StartBlueprintRunInput) (*request.Request, *glue.StartBlueprintRunOutput)

	StartCrawler(*glue.StartCrawlerInput) (*glue.StartCrawlerOutput, error)
	StartCrawlerWithContext(aws.Context, *glue.StartCrawlerInput, ...request.Option) (*glue.StartCrawlerOutput, error)
	StartCrawlerRequest(*glue.StartCrawlerInput) (*request.Request, *glue.StartCrawlerOutput)

	StartCrawlerSchedule(*glue.StartCrawlerScheduleInput) (*glue.StartCrawlerScheduleOutput, error)
	StartCrawlerScheduleWithContext(aws.Context, *glue.StartCrawlerScheduleInput, ...request.Option) (*glue.StartCrawlerScheduleOutput, error)
	StartCrawlerScheduleRequest(*glue.StartCrawlerScheduleInput) (*request.Request, *glue.StartCrawlerScheduleOutput)

	StartDataQualityRuleRecommendationRun(*glue.StartDataQualityRuleRecommendationRunInput) (*glue.StartDataQualityRuleRecommendationRunOutput, error)
	StartDataQualityRuleRecommendationRunWithContext(aws.Context, *glue.StartDataQualityRuleRecommendationRunInput, ...request.Option) (*glue.StartDataQualityRuleRecommendationRunOutput, error)
	StartDataQualityRuleRecommendationRunRequest(*glue.StartDataQualityRuleRecommendationRunInput) (*request.Request, *glue.StartDataQualityRuleRecommendationRunOutput)

	StartDataQualityRulesetEvaluationRun(*glue.StartDataQualityRulesetEvaluationRunInput) (*glue.StartDataQualityRulesetEvaluationRunOutput, error)
	StartDataQualityRulesetEvaluationRunWithContext(aws.Context, *glue.StartDataQualityRulesetEvaluationRunInput, ...request.Option) (*glue.StartDataQualityRulesetEvaluationRunOutput, error)
	StartDataQualityRulesetEvaluationRunRequest(*glue.StartDataQualityRulesetEvaluationRunInput) (*request.Request, *glue.StartDataQualityRulesetEvaluationRunOutput)

	StartExportLabelsTaskRun(*glue.StartExportLabelsTaskRunInput) (*glue.StartExportLabelsTaskRunOutput, error)
	StartExportLabelsTaskRunWithContext(aws.Context, *glue.StartExportLabelsTaskRunInput, ...request.Option) (*glue.StartExportLabelsTaskRunOutput, error)
	StartExportLabelsTaskRunRequest(*glue.StartExportLabelsTaskRunInput) (*request.Request, *glue.StartExportLabelsTaskRunOutput)

	StartImportLabelsTaskRun(*glue.StartImportLabelsTaskRunInput) (*glue.StartImportLabelsTaskRunOutput, error)
	StartImportLabelsTaskRunWithContext(aws.Context, *glue.StartImportLabelsTaskRunInput, ...request.Option) (*glue.StartImportLabelsTaskRunOutput, error)
	StartImportLabelsTaskRunRequest(*glue.StartImportLabelsTaskRunInput) (*request.Request, *glue.StartImportLabelsTaskRunOutput)

	StartJobRun(*glue.StartJobRunInput) (*glue.StartJobRunOutput, error)
	StartJobRunWithContext(aws.Context, *glue.StartJobRunInput, ...request.Option) (*glue.StartJobRunOutput, error)
	StartJobRunRequest(*glue.StartJobRunInput) (*request.Request, *glue.StartJobRunOutput)

	StartMLEvaluationTaskRun(*glue.StartMLEvaluationTaskRunInput) (*glue.StartMLEvaluationTaskRunOutput, error)
	StartMLEvaluationTaskRunWithContext(aws.Context, *glue.StartMLEvaluationTaskRunInput, ...request.Option) (*glue.StartMLEvaluationTaskRunOutput, error)
	StartMLEvaluationTaskRunRequest(*glue.StartMLEvaluationTaskRunInput) (*request.Request, *glue.StartMLEvaluationTaskRunOutput)

	StartMLLabelingSetGenerationTaskRun(*glue.StartMLLabelingSetGenerationTaskRunInput) (*glue.StartMLLabelingSetGenerationTaskRunOutput, error)
	StartMLLabelingSetGenerationTaskRunWithContext(aws.Context, *glue.StartMLLabelingSetGenerationTaskRunInput, ...request.Option) (*glue.StartMLLabelingSetGenerationTaskRunOutput, error)
	StartMLLabelingSetGenerationTaskRunRequest(*glue.StartMLLabelingSetGenerationTaskRunInput) (*request.Request, *glue.StartMLLabelingSetGenerationTaskRunOutput)

	StartTrigger(*glue.StartTriggerInput) (*glue.StartTriggerOutput, error)
	StartTriggerWithContext(aws.Context, *glue.StartTriggerInput, ...request.Option) (*glue.StartTriggerOutput, error)
	StartTriggerRequest(*glue.StartTriggerInput) (*request.Request, *glue.StartTriggerOutput)

	StartWorkflowRun(*glue.StartWorkflowRunInput) (*glue.StartWorkflowRunOutput, error)
	StartWorkflowRunWithContext(aws.Context, *glue.StartWorkflowRunInput, ...request.Option) (*glue.StartWorkflowRunOutput, error)
	StartWorkflowRunRequest(*glue.StartWorkflowRunInput) (*request.Request, *glue.StartWorkflowRunOutput)

	StopCrawler(*glue.StopCrawlerInput) (*glue.StopCrawlerOutput, error)
	StopCrawlerWithContext(aws.Context, *glue.StopCrawlerInput, ...request.Option) (*glue.StopCrawlerOutput, error)
	StopCrawlerRequest(*glue.StopCrawlerInput) (*request.Request, *glue.StopCrawlerOutput)

	StopCrawlerSchedule(*glue.StopCrawlerScheduleInput) (*glue.StopCrawlerScheduleOutput, error)
	StopCrawlerScheduleWithContext(aws.Context, *glue.StopCrawlerScheduleInput, ...request.Option) (*glue.StopCrawlerScheduleOutput, error)
	StopCrawlerScheduleRequest(*glue.StopCrawlerScheduleInput) (*request.Request, *glue.StopCrawlerScheduleOutput)

	StopSession(*glue.StopSessionInput) (*glue.StopSessionOutput, error)
	StopSessionWithContext(aws.Context, *glue.StopSessionInput, ...request.Option) (*glue.StopSessionOutput, error)
	StopSessionRequest(*glue.StopSessionInput) (*request.Request, *glue.StopSessionOutput)

	StopTrigger(*glue.StopTriggerInput) (*glue.StopTriggerOutput, error)
	StopTriggerWithContext(aws.Context, *glue.StopTriggerInput, ...request.Option) (*glue.StopTriggerOutput, error)
	StopTriggerRequest(*glue.StopTriggerInput) (*request.Request, *glue.StopTriggerOutput)

	StopWorkflowRun(*glue.StopWorkflowRunInput) (*glue.StopWorkflowRunOutput, error)
	StopWorkflowRunWithContext(aws.Context, *glue.StopWorkflowRunInput, ...request.Option) (*glue.StopWorkflowRunOutput, error)
	StopWorkflowRunRequest(*glue.StopWorkflowRunInput) (*request.Request, *glue.StopWorkflowRunOutput)

	TagResource(*glue.TagResourceInput) (*glue.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *glue.TagResourceInput, ...request.Option) (*glue.TagResourceOutput, error)
	TagResourceRequest(*glue.TagResourceInput) (*request.Request, *glue.TagResourceOutput)

	UntagResource(*glue.UntagResourceInput) (*glue.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *glue.UntagResourceInput, ...request.Option) (*glue.UntagResourceOutput, error)
	UntagResourceRequest(*glue.UntagResourceInput) (*request.Request, *glue.UntagResourceOutput)

	UpdateBlueprint(*glue.UpdateBlueprintInput) (*glue.UpdateBlueprintOutput, error)
	UpdateBlueprintWithContext(aws.Context, *glue.UpdateBlueprintInput, ...request.Option) (*glue.UpdateBlueprintOutput, error)
	UpdateBlueprintRequest(*glue.UpdateBlueprintInput) (*request.Request, *glue.UpdateBlueprintOutput)

	UpdateClassifier(*glue.UpdateClassifierInput) (*glue.UpdateClassifierOutput, error)
	UpdateClassifierWithContext(aws.Context, *glue.UpdateClassifierInput, ...request.Option) (*glue.UpdateClassifierOutput, error)
	UpdateClassifierRequest(*glue.UpdateClassifierInput) (*request.Request, *glue.UpdateClassifierOutput)

	UpdateColumnStatisticsForPartition(*glue.UpdateColumnStatisticsForPartitionInput) (*glue.UpdateColumnStatisticsForPartitionOutput, error)
	UpdateColumnStatisticsForPartitionWithContext(aws.Context, *glue.UpdateColumnStatisticsForPartitionInput, ...request.Option) (*glue.UpdateColumnStatisticsForPartitionOutput, error)
	UpdateColumnStatisticsForPartitionRequest(*glue.UpdateColumnStatisticsForPartitionInput) (*request.Request, *glue.UpdateColumnStatisticsForPartitionOutput)

	UpdateColumnStatisticsForTable(*glue.UpdateColumnStatisticsForTableInput) (*glue.UpdateColumnStatisticsForTableOutput, error)
	UpdateColumnStatisticsForTableWithContext(aws.Context, *glue.UpdateColumnStatisticsForTableInput, ...request.Option) (*glue.UpdateColumnStatisticsForTableOutput, error)
	UpdateColumnStatisticsForTableRequest(*glue.UpdateColumnStatisticsForTableInput) (*request.Request, *glue.UpdateColumnStatisticsForTableOutput)

	UpdateConnection(*glue.UpdateConnectionInput) (*glue.UpdateConnectionOutput, error)
	UpdateConnectionWithContext(aws.Context, *glue.UpdateConnectionInput, ...request.Option) (*glue.UpdateConnectionOutput, error)
	UpdateConnectionRequest(*glue.UpdateConnectionInput) (*request.Request, *glue.UpdateConnectionOutput)

	UpdateCrawler(*glue.UpdateCrawlerInput) (*glue.UpdateCrawlerOutput, error)
	UpdateCrawlerWithContext(aws.Context, *glue.UpdateCrawlerInput, ...request.Option) (*glue.UpdateCrawlerOutput, error)
	UpdateCrawlerRequest(*glue.UpdateCrawlerInput) (*request.Request, *glue.UpdateCrawlerOutput)

	UpdateCrawlerSchedule(*glue.UpdateCrawlerScheduleInput) (*glue.UpdateCrawlerScheduleOutput, error)
	UpdateCrawlerScheduleWithContext(aws.Context, *glue.UpdateCrawlerScheduleInput, ...request.Option) (*glue.UpdateCrawlerScheduleOutput, error)
	UpdateCrawlerScheduleRequest(*glue.UpdateCrawlerScheduleInput) (*request.Request, *glue.UpdateCrawlerScheduleOutput)

	UpdateDataQualityRuleset(*glue.UpdateDataQualityRulesetInput) (*glue.UpdateDataQualityRulesetOutput, error)
	UpdateDataQualityRulesetWithContext(aws.Context, *glue.UpdateDataQualityRulesetInput, ...request.Option) (*glue.UpdateDataQualityRulesetOutput, error)
	UpdateDataQualityRulesetRequest(*glue.UpdateDataQualityRulesetInput) (*request.Request, *glue.UpdateDataQualityRulesetOutput)

	UpdateDatabase(*glue.UpdateDatabaseInput) (*glue.UpdateDatabaseOutput, error)
	UpdateDatabaseWithContext(aws.Context, *glue.UpdateDatabaseInput, ...request.Option) (*glue.UpdateDatabaseOutput, error)
	UpdateDatabaseRequest(*glue.UpdateDatabaseInput) (*request.Request, *glue.UpdateDatabaseOutput)

	UpdateDevEndpoint(*glue.UpdateDevEndpointInput) (*glue.UpdateDevEndpointOutput, error)
	UpdateDevEndpointWithContext(aws.Context, *glue.UpdateDevEndpointInput, ...request.Option) (*glue.UpdateDevEndpointOutput, error)
	UpdateDevEndpointRequest(*glue.UpdateDevEndpointInput) (*request.Request, *glue.UpdateDevEndpointOutput)

	UpdateJob(*glue.UpdateJobInput) (*glue.UpdateJobOutput, error)
	UpdateJobWithContext(aws.Context, *glue.UpdateJobInput, ...request.Option) (*glue.UpdateJobOutput, error)
	UpdateJobRequest(*glue.UpdateJobInput) (*request.Request, *glue.UpdateJobOutput)

	UpdateJobFromSourceControl(*glue.UpdateJobFromSourceControlInput) (*glue.UpdateJobFromSourceControlOutput, error)
	UpdateJobFromSourceControlWithContext(aws.Context, *glue.UpdateJobFromSourceControlInput, ...request.Option) (*glue.UpdateJobFromSourceControlOutput, error)
	UpdateJobFromSourceControlRequest(*glue.UpdateJobFromSourceControlInput) (*request.Request, *glue.UpdateJobFromSourceControlOutput)

	UpdateMLTransform(*glue.UpdateMLTransformInput) (*glue.UpdateMLTransformOutput, error)
	UpdateMLTransformWithContext(aws.Context, *glue.UpdateMLTransformInput, ...request.Option) (*glue.UpdateMLTransformOutput, error)
	UpdateMLTransformRequest(*glue.UpdateMLTransformInput) (*request.Request, *glue.UpdateMLTransformOutput)

	UpdatePartition(*glue.UpdatePartitionInput) (*glue.UpdatePartitionOutput, error)
	UpdatePartitionWithContext(aws.Context, *glue.UpdatePartitionInput, ...request.Option) (*glue.UpdatePartitionOutput, error)
	UpdatePartitionRequest(*glue.UpdatePartitionInput) (*request.Request, *glue.UpdatePartitionOutput)

	UpdateRegistry(*glue.UpdateRegistryInput) (*glue.UpdateRegistryOutput, error)
	UpdateRegistryWithContext(aws.Context, *glue.UpdateRegistryInput, ...request.Option) (*glue.UpdateRegistryOutput, error)
	UpdateRegistryRequest(*glue.UpdateRegistryInput) (*request.Request, *glue.UpdateRegistryOutput)

	UpdateSchema(*glue.UpdateSchemaInput) (*glue.UpdateSchemaOutput, error)
	UpdateSchemaWithContext(aws.Context, *glue.UpdateSchemaInput, ...request.Option) (*glue.UpdateSchemaOutput, error)
	UpdateSchemaRequest(*glue.UpdateSchemaInput) (*request.Request, *glue.UpdateSchemaOutput)

	UpdateSourceControlFromJob(*glue.UpdateSourceControlFromJobInput) (*glue.UpdateSourceControlFromJobOutput, error)
	UpdateSourceControlFromJobWithContext(aws.Context, *glue.UpdateSourceControlFromJobInput, ...request.Option) (*glue.UpdateSourceControlFromJobOutput, error)
	UpdateSourceControlFromJobRequest(*glue.UpdateSourceControlFromJobInput) (*request.Request, *glue.UpdateSourceControlFromJobOutput)

	UpdateTable(*glue.UpdateTableInput) (*glue.UpdateTableOutput, error)
	UpdateTableWithContext(aws.Context, *glue.UpdateTableInput, ...request.Option) (*glue.UpdateTableOutput, error)
	UpdateTableRequest(*glue.UpdateTableInput) (*request.Request, *glue.UpdateTableOutput)

	UpdateTrigger(*glue.UpdateTriggerInput) (*glue.UpdateTriggerOutput, error)
	UpdateTriggerWithContext(aws.Context, *glue.UpdateTriggerInput, ...request.Option) (*glue.UpdateTriggerOutput, error)
	UpdateTriggerRequest(*glue.UpdateTriggerInput) (*request.Request, *glue.UpdateTriggerOutput)

	UpdateUserDefinedFunction(*glue.UpdateUserDefinedFunctionInput) (*glue.UpdateUserDefinedFunctionOutput, error)
	UpdateUserDefinedFunctionWithContext(aws.Context, *glue.UpdateUserDefinedFunctionInput, ...request.Option) (*glue.UpdateUserDefinedFunctionOutput, error)
	UpdateUserDefinedFunctionRequest(*glue.UpdateUserDefinedFunctionInput) (*request.Request, *glue.UpdateUserDefinedFunctionOutput)

	UpdateWorkflow(*glue.UpdateWorkflowInput) (*glue.UpdateWorkflowOutput, error)
	UpdateWorkflowWithContext(aws.Context, *glue.UpdateWorkflowInput, ...request.Option) (*glue.UpdateWorkflowOutput, error)
	UpdateWorkflowRequest(*glue.UpdateWorkflowInput) (*request.Request, *glue.UpdateWorkflowOutput)
}

var _ GlueAPI = (*glue.Glue)(nil)
