// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelImageCreation = "CancelImageCreation"

// CancelImageCreationRequest generates a "aws/request.Request" representing the
// client's request for the CancelImageCreation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelImageCreation for more information on using the CancelImageCreation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelImageCreationRequest method.
//	req, resp := client.CancelImageCreationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation
func (c *Imagebuilder) CancelImageCreationRequest(input *CancelImageCreationInput) (req *request.Request, output *CancelImageCreationOutput) {
	op := &request.Operation{
		Name:       opCancelImageCreation,
		HTTPMethod: "PUT",
		HTTPPath:   "/CancelImageCreation",
	}

	if input == nil {
		input = &CancelImageCreationInput{}
	}

	output = &CancelImageCreationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelImageCreation API operation for EC2 Image Builder.
//
// CancelImageCreation cancels the creation of Image. This operation can only
// be used on images in a non-terminal state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation CancelImageCreation for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation
func (c *Imagebuilder) CancelImageCreation(input *CancelImageCreationInput) (*CancelImageCreationOutput, error) {
	req, out := c.CancelImageCreationRequest(input)
	return out, req.Send()
}

// CancelImageCreationWithContext is the same as CancelImageCreation with the addition of
// the ability to pass a context and additional request options.
//
// See CancelImageCreation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) CancelImageCreationWithContext(ctx aws.Context, input *CancelImageCreationInput, opts ...request.Option) (*CancelImageCreationOutput, error) {
	req, out := c.CancelImageCreationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComponent = "CreateComponent"

// CreateComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComponent for more information on using the CreateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateComponentRequest method.
//	req, resp := client.CreateComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent
func (c *Imagebuilder) CreateComponentRequest(input *CreateComponentInput) (req *request.Request, output *CreateComponentOutput) {
	op := &request.Operation{
		Name:       opCreateComponent,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateComponent",
	}

	if input == nil {
		input = &CreateComponentInput{}
	}

	output = &CreateComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateComponent API operation for EC2 Image Builder.
//
// Creates a new component that can be used to build, validate, test, and assess
// your image. The component is based on a YAML document that you specify using
// exactly one of the following methods:
//
//   - Inline, using the data property in the request body.
//
//   - A URL that points to a YAML document file stored in Amazon S3, using
//     the uri property in the request body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation CreateComponent for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - InvalidVersionNumberException
//     Your version number is out of bounds or does not follow the required syntax.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - InvalidParameterCombinationException
//     You have specified two or more mutually exclusive parameters. Review the
//     error message for details.
//
//   - ServiceQuotaExceededException
//     You have exceeded the number of permitted resources or operations for this
//     service. For service quotas, see EC2 Image Builder endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent
func (c *Imagebuilder) CreateComponent(input *CreateComponentInput) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	return out, req.Send()
}

// CreateComponentWithContext is the same as CreateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) CreateComponentWithContext(ctx aws.Context, input *CreateComponentInput, opts ...request.Option) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContainerRecipe = "CreateContainerRecipe"

// CreateContainerRecipeRequest generates a "aws/request.Request" representing the
// client's request for the CreateContainerRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContainerRecipe for more information on using the CreateContainerRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateContainerRecipeRequest method.
//	req, resp := client.CreateContainerRecipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe
func (c *Imagebuilder) CreateContainerRecipeRequest(input *CreateContainerRecipeInput) (req *request.Request, output *CreateContainerRecipeOutput) {
	op := &request.Operation{
		Name:       opCreateContainerRecipe,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateContainerRecipe",
	}

	if input == nil {
		input = &CreateContainerRecipeInput{}
	}

	output = &CreateContainerRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContainerRecipe API operation for EC2 Image Builder.
//
// Creates a new container recipe. Container recipes define how images are configured,
// tested, and assessed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation CreateContainerRecipe for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - InvalidVersionNumberException
//     Your version number is out of bounds or does not follow the required syntax.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - ResourceAlreadyExistsException
//     The resource that you are trying to create already exists.
//
//   - ServiceQuotaExceededException
//     You have exceeded the number of permitted resources or operations for this
//     service. For service quotas, see EC2 Image Builder endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe
func (c *Imagebuilder) CreateContainerRecipe(input *CreateContainerRecipeInput) (*CreateContainerRecipeOutput, error) {
	req, out := c.CreateContainerRecipeRequest(input)
	return out, req.Send()
}

// CreateContainerRecipeWithContext is the same as CreateContainerRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContainerRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) CreateContainerRecipeWithContext(ctx aws.Context, input *CreateContainerRecipeInput, opts ...request.Option) (*CreateContainerRecipeOutput, error) {
	req, out := c.CreateContainerRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDistributionConfiguration = "CreateDistributionConfiguration"

// CreateDistributionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDistributionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDistributionConfiguration for more information on using the CreateDistributionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDistributionConfigurationRequest method.
//	req, resp := client.CreateDistributionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration
func (c *Imagebuilder) CreateDistributionConfigurationRequest(input *CreateDistributionConfigurationInput) (req *request.Request, output *CreateDistributionConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateDistributionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateDistributionConfiguration",
	}

	if input == nil {
		input = &CreateDistributionConfigurationInput{}
	}

	output = &CreateDistributionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDistributionConfiguration API operation for EC2 Image Builder.
//
// Creates a new distribution configuration. Distribution configurations define
// and configure the outputs of your pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation CreateDistributionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - ResourceAlreadyExistsException
//     The resource that you are trying to create already exists.
//
//   - InvalidParameterCombinationException
//     You have specified two or more mutually exclusive parameters. Review the
//     error message for details.
//
//   - ServiceQuotaExceededException
//     You have exceeded the number of permitted resources or operations for this
//     service. For service quotas, see EC2 Image Builder endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration
func (c *Imagebuilder) CreateDistributionConfiguration(input *CreateDistributionConfigurationInput) (*CreateDistributionConfigurationOutput, error) {
	req, out := c.CreateDistributionConfigurationRequest(input)
	return out, req.Send()
}

// CreateDistributionConfigurationWithContext is the same as CreateDistributionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDistributionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) CreateDistributionConfigurationWithContext(ctx aws.Context, input *CreateDistributionConfigurationInput, opts ...request.Option) (*CreateDistributionConfigurationOutput, error) {
	req, out := c.CreateDistributionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImage = "CreateImage"

// CreateImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImage for more information on using the CreateImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateImageRequest method.
//	req, resp := client.CreateImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage
func (c *Imagebuilder) CreateImageRequest(input *CreateImageInput) (req *request.Request, output *CreateImageOutput) {
	op := &request.Operation{
		Name:       opCreateImage,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateImage",
	}

	if input == nil {
		input = &CreateImageInput{}
	}

	output = &CreateImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImage API operation for EC2 Image Builder.
//
// Creates a new image. This request will create a new image along with all
// of the configured output resources defined in the distribution configuration.
// You must specify exactly one recipe for your image, using either a ContainerRecipeArn
// or an ImageRecipeArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation CreateImage for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - ServiceQuotaExceededException
//     You have exceeded the number of permitted resources or operations for this
//     service. For service quotas, see EC2 Image Builder endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage
func (c *Imagebuilder) CreateImage(input *CreateImageInput) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	return out, req.Send()
}

// CreateImageWithContext is the same as CreateImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) CreateImageWithContext(ctx aws.Context, input *CreateImageInput, opts ...request.Option) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImagePipeline = "CreateImagePipeline"

// CreateImagePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreateImagePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImagePipeline for more information on using the CreateImagePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateImagePipelineRequest method.
//	req, resp := client.CreateImagePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline
func (c *Imagebuilder) CreateImagePipelineRequest(input *CreateImagePipelineInput) (req *request.Request, output *CreateImagePipelineOutput) {
	op := &request.Operation{
		Name:       opCreateImagePipeline,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateImagePipeline",
	}

	if input == nil {
		input = &CreateImagePipelineInput{}
	}

	output = &CreateImagePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImagePipeline API operation for EC2 Image Builder.
//
// Creates a new image pipeline. Image pipelines enable you to automate the
// creation and distribution of images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation CreateImagePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - ResourceAlreadyExistsException
//     The resource that you are trying to create already exists.
//
//   - ServiceQuotaExceededException
//     You have exceeded the number of permitted resources or operations for this
//     service. For service quotas, see EC2 Image Builder endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline
func (c *Imagebuilder) CreateImagePipeline(input *CreateImagePipelineInput) (*CreateImagePipelineOutput, error) {
	req, out := c.CreateImagePipelineRequest(input)
	return out, req.Send()
}

// CreateImagePipelineWithContext is the same as CreateImagePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImagePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) CreateImagePipelineWithContext(ctx aws.Context, input *CreateImagePipelineInput, opts ...request.Option) (*CreateImagePipelineOutput, error) {
	req, out := c.CreateImagePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImageRecipe = "CreateImageRecipe"

// CreateImageRecipeRequest generates a "aws/request.Request" representing the
// client's request for the CreateImageRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImageRecipe for more information on using the CreateImageRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateImageRecipeRequest method.
//	req, resp := client.CreateImageRecipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe
func (c *Imagebuilder) CreateImageRecipeRequest(input *CreateImageRecipeInput) (req *request.Request, output *CreateImageRecipeOutput) {
	op := &request.Operation{
		Name:       opCreateImageRecipe,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateImageRecipe",
	}

	if input == nil {
		input = &CreateImageRecipeInput{}
	}

	output = &CreateImageRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImageRecipe API operation for EC2 Image Builder.
//
// Creates a new image recipe. Image recipes define how images are configured,
// tested, and assessed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation CreateImageRecipe for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - InvalidVersionNumberException
//     Your version number is out of bounds or does not follow the required syntax.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - ResourceAlreadyExistsException
//     The resource that you are trying to create already exists.
//
//   - ServiceQuotaExceededException
//     You have exceeded the number of permitted resources or operations for this
//     service. For service quotas, see EC2 Image Builder endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe
func (c *Imagebuilder) CreateImageRecipe(input *CreateImageRecipeInput) (*CreateImageRecipeOutput, error) {
	req, out := c.CreateImageRecipeRequest(input)
	return out, req.Send()
}

// CreateImageRecipeWithContext is the same as CreateImageRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImageRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) CreateImageRecipeWithContext(ctx aws.Context, input *CreateImageRecipeInput, opts ...request.Option) (*CreateImageRecipeOutput, error) {
	req, out := c.CreateImageRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInfrastructureConfiguration = "CreateInfrastructureConfiguration"

// CreateInfrastructureConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateInfrastructureConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInfrastructureConfiguration for more information on using the CreateInfrastructureConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInfrastructureConfigurationRequest method.
//	req, resp := client.CreateInfrastructureConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration
func (c *Imagebuilder) CreateInfrastructureConfigurationRequest(input *CreateInfrastructureConfigurationInput) (req *request.Request, output *CreateInfrastructureConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateInfrastructureConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateInfrastructureConfiguration",
	}

	if input == nil {
		input = &CreateInfrastructureConfigurationInput{}
	}

	output = &CreateInfrastructureConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInfrastructureConfiguration API operation for EC2 Image Builder.
//
// Creates a new infrastructure configuration. An infrastructure configuration
// defines the environment in which your image will be built and tested.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation CreateInfrastructureConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - ResourceAlreadyExistsException
//     The resource that you are trying to create already exists.
//
//   - ServiceQuotaExceededException
//     You have exceeded the number of permitted resources or operations for this
//     service. For service quotas, see EC2 Image Builder endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration
func (c *Imagebuilder) CreateInfrastructureConfiguration(input *CreateInfrastructureConfigurationInput) (*CreateInfrastructureConfigurationOutput, error) {
	req, out := c.CreateInfrastructureConfigurationRequest(input)
	return out, req.Send()
}

// CreateInfrastructureConfigurationWithContext is the same as CreateInfrastructureConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInfrastructureConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) CreateInfrastructureConfigurationWithContext(ctx aws.Context, input *CreateInfrastructureConfigurationInput, opts ...request.Option) (*CreateInfrastructureConfigurationOutput, error) {
	req, out := c.CreateInfrastructureConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComponent = "DeleteComponent"

// DeleteComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComponent for more information on using the DeleteComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteComponentRequest method.
//	req, resp := client.DeleteComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent
func (c *Imagebuilder) DeleteComponentRequest(input *DeleteComponentInput) (req *request.Request, output *DeleteComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteComponent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteComponent",
	}

	if input == nil {
		input = &DeleteComponentInput{}
	}

	output = &DeleteComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteComponent API operation for EC2 Image Builder.
//
// Deletes a component build version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation DeleteComponent for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceDependencyException
//     You have attempted to mutate or delete a resource with a dependency that
//     prohibits this action. See the error message for more details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent
func (c *Imagebuilder) DeleteComponent(input *DeleteComponentInput) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	return out, req.Send()
}

// DeleteComponentWithContext is the same as DeleteComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) DeleteComponentWithContext(ctx aws.Context, input *DeleteComponentInput, opts ...request.Option) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContainerRecipe = "DeleteContainerRecipe"

// DeleteContainerRecipeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContainerRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContainerRecipe for more information on using the DeleteContainerRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteContainerRecipeRequest method.
//	req, resp := client.DeleteContainerRecipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe
func (c *Imagebuilder) DeleteContainerRecipeRequest(input *DeleteContainerRecipeInput) (req *request.Request, output *DeleteContainerRecipeOutput) {
	op := &request.Operation{
		Name:       opDeleteContainerRecipe,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteContainerRecipe",
	}

	if input == nil {
		input = &DeleteContainerRecipeInput{}
	}

	output = &DeleteContainerRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteContainerRecipe API operation for EC2 Image Builder.
//
// Deletes a container recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation DeleteContainerRecipe for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceDependencyException
//     You have attempted to mutate or delete a resource with a dependency that
//     prohibits this action. See the error message for more details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe
func (c *Imagebuilder) DeleteContainerRecipe(input *DeleteContainerRecipeInput) (*DeleteContainerRecipeOutput, error) {
	req, out := c.DeleteContainerRecipeRequest(input)
	return out, req.Send()
}

// DeleteContainerRecipeWithContext is the same as DeleteContainerRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContainerRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) DeleteContainerRecipeWithContext(ctx aws.Context, input *DeleteContainerRecipeInput, opts ...request.Option) (*DeleteContainerRecipeOutput, error) {
	req, out := c.DeleteContainerRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDistributionConfiguration = "DeleteDistributionConfiguration"

// DeleteDistributionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDistributionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDistributionConfiguration for more information on using the DeleteDistributionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDistributionConfigurationRequest method.
//	req, resp := client.DeleteDistributionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration
func (c *Imagebuilder) DeleteDistributionConfigurationRequest(input *DeleteDistributionConfigurationInput) (req *request.Request, output *DeleteDistributionConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteDistributionConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteDistributionConfiguration",
	}

	if input == nil {
		input = &DeleteDistributionConfigurationInput{}
	}

	output = &DeleteDistributionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDistributionConfiguration API operation for EC2 Image Builder.
//
// Deletes a distribution configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation DeleteDistributionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceDependencyException
//     You have attempted to mutate or delete a resource with a dependency that
//     prohibits this action. See the error message for more details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration
func (c *Imagebuilder) DeleteDistributionConfiguration(input *DeleteDistributionConfigurationInput) (*DeleteDistributionConfigurationOutput, error) {
	req, out := c.DeleteDistributionConfigurationRequest(input)
	return out, req.Send()
}

// DeleteDistributionConfigurationWithContext is the same as DeleteDistributionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDistributionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) DeleteDistributionConfigurationWithContext(ctx aws.Context, input *DeleteDistributionConfigurationInput, opts ...request.Option) (*DeleteDistributionConfigurationOutput, error) {
	req, out := c.DeleteDistributionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImage = "DeleteImage"

// DeleteImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImage for more information on using the DeleteImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteImageRequest method.
//	req, resp := client.DeleteImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage
func (c *Imagebuilder) DeleteImageRequest(input *DeleteImageInput) (req *request.Request, output *DeleteImageOutput) {
	op := &request.Operation{
		Name:       opDeleteImage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteImage",
	}

	if input == nil {
		input = &DeleteImageInput{}
	}

	output = &DeleteImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImage API operation for EC2 Image Builder.
//
// Deletes an Image Builder image resource. This does not delete any EC2 AMIs
// or ECR container images that are created during the image build process.
// You must clean those up separately, using the appropriate Amazon EC2 or Amazon
// ECR console actions, or API or CLI commands.
//
//   - To deregister an EC2 Linux AMI, see Deregister your Linux AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html)
//     in the Amazon EC2 User Guide .
//
//   - To deregister an EC2 Windows AMI, see Deregister your Windows AMI (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html)
//     in the Amazon EC2 Windows Guide .
//
//   - To delete a container image from Amazon ECR, see Deleting an image (https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html)
//     in the Amazon ECR User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation DeleteImage for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceDependencyException
//     You have attempted to mutate or delete a resource with a dependency that
//     prohibits this action. See the error message for more details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage
func (c *Imagebuilder) DeleteImage(input *DeleteImageInput) (*DeleteImageOutput, error) {
	req, out := c.DeleteImageRequest(input)
	return out, req.Send()
}

// DeleteImageWithContext is the same as DeleteImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) DeleteImageWithContext(ctx aws.Context, input *DeleteImageInput, opts ...request.Option) (*DeleteImageOutput, error) {
	req, out := c.DeleteImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImagePipeline = "DeleteImagePipeline"

// DeleteImagePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImagePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImagePipeline for more information on using the DeleteImagePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteImagePipelineRequest method.
//	req, resp := client.DeleteImagePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline
func (c *Imagebuilder) DeleteImagePipelineRequest(input *DeleteImagePipelineInput) (req *request.Request, output *DeleteImagePipelineOutput) {
	op := &request.Operation{
		Name:       opDeleteImagePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteImagePipeline",
	}

	if input == nil {
		input = &DeleteImagePipelineInput{}
	}

	output = &DeleteImagePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImagePipeline API operation for EC2 Image Builder.
//
// Deletes an image pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation DeleteImagePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceDependencyException
//     You have attempted to mutate or delete a resource with a dependency that
//     prohibits this action. See the error message for more details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline
func (c *Imagebuilder) DeleteImagePipeline(input *DeleteImagePipelineInput) (*DeleteImagePipelineOutput, error) {
	req, out := c.DeleteImagePipelineRequest(input)
	return out, req.Send()
}

// DeleteImagePipelineWithContext is the same as DeleteImagePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImagePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) DeleteImagePipelineWithContext(ctx aws.Context, input *DeleteImagePipelineInput, opts ...request.Option) (*DeleteImagePipelineOutput, error) {
	req, out := c.DeleteImagePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImageRecipe = "DeleteImageRecipe"

// DeleteImageRecipeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImageRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImageRecipe for more information on using the DeleteImageRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteImageRecipeRequest method.
//	req, resp := client.DeleteImageRecipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe
func (c *Imagebuilder) DeleteImageRecipeRequest(input *DeleteImageRecipeInput) (req *request.Request, output *DeleteImageRecipeOutput) {
	op := &request.Operation{
		Name:       opDeleteImageRecipe,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteImageRecipe",
	}

	if input == nil {
		input = &DeleteImageRecipeInput{}
	}

	output = &DeleteImageRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImageRecipe API operation for EC2 Image Builder.
//
// Deletes an image recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation DeleteImageRecipe for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceDependencyException
//     You have attempted to mutate or delete a resource with a dependency that
//     prohibits this action. See the error message for more details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe
func (c *Imagebuilder) DeleteImageRecipe(input *DeleteImageRecipeInput) (*DeleteImageRecipeOutput, error) {
	req, out := c.DeleteImageRecipeRequest(input)
	return out, req.Send()
}

// DeleteImageRecipeWithContext is the same as DeleteImageRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImageRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) DeleteImageRecipeWithContext(ctx aws.Context, input *DeleteImageRecipeInput, opts ...request.Option) (*DeleteImageRecipeOutput, error) {
	req, out := c.DeleteImageRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInfrastructureConfiguration = "DeleteInfrastructureConfiguration"

// DeleteInfrastructureConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInfrastructureConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInfrastructureConfiguration for more information on using the DeleteInfrastructureConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInfrastructureConfigurationRequest method.
//	req, resp := client.DeleteInfrastructureConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration
func (c *Imagebuilder) DeleteInfrastructureConfigurationRequest(input *DeleteInfrastructureConfigurationInput) (req *request.Request, output *DeleteInfrastructureConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteInfrastructureConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteInfrastructureConfiguration",
	}

	if input == nil {
		input = &DeleteInfrastructureConfigurationInput{}
	}

	output = &DeleteInfrastructureConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInfrastructureConfiguration API operation for EC2 Image Builder.
//
// Deletes an infrastructure configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation DeleteInfrastructureConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceDependencyException
//     You have attempted to mutate or delete a resource with a dependency that
//     prohibits this action. See the error message for more details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration
func (c *Imagebuilder) DeleteInfrastructureConfiguration(input *DeleteInfrastructureConfigurationInput) (*DeleteInfrastructureConfigurationOutput, error) {
	req, out := c.DeleteInfrastructureConfigurationRequest(input)
	return out, req.Send()
}

// DeleteInfrastructureConfigurationWithContext is the same as DeleteInfrastructureConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInfrastructureConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) DeleteInfrastructureConfigurationWithContext(ctx aws.Context, input *DeleteInfrastructureConfigurationInput, opts ...request.Option) (*DeleteInfrastructureConfigurationOutput, error) {
	req, out := c.DeleteInfrastructureConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComponent = "GetComponent"

// GetComponentRequest generates a "aws/request.Request" representing the
// client's request for the GetComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComponent for more information on using the GetComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetComponentRequest method.
//	req, resp := client.GetComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent
func (c *Imagebuilder) GetComponentRequest(input *GetComponentInput) (req *request.Request, output *GetComponentOutput) {
	op := &request.Operation{
		Name:       opGetComponent,
		HTTPMethod: "GET",
		HTTPPath:   "/GetComponent",
	}

	if input == nil {
		input = &GetComponentInput{}
	}

	output = &GetComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComponent API operation for EC2 Image Builder.
//
// Gets a component object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetComponent for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent
func (c *Imagebuilder) GetComponent(input *GetComponentInput) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	return out, req.Send()
}

// GetComponentWithContext is the same as GetComponent with the addition of
// the ability to pass a context and additional request options.
//
// See GetComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetComponentWithContext(ctx aws.Context, input *GetComponentInput, opts ...request.Option) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComponentPolicy = "GetComponentPolicy"

// GetComponentPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetComponentPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComponentPolicy for more information on using the GetComponentPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetComponentPolicyRequest method.
//	req, resp := client.GetComponentPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy
func (c *Imagebuilder) GetComponentPolicyRequest(input *GetComponentPolicyInput) (req *request.Request, output *GetComponentPolicyOutput) {
	op := &request.Operation{
		Name:       opGetComponentPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/GetComponentPolicy",
	}

	if input == nil {
		input = &GetComponentPolicyInput{}
	}

	output = &GetComponentPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComponentPolicy API operation for EC2 Image Builder.
//
// Gets a component policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetComponentPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy
func (c *Imagebuilder) GetComponentPolicy(input *GetComponentPolicyInput) (*GetComponentPolicyOutput, error) {
	req, out := c.GetComponentPolicyRequest(input)
	return out, req.Send()
}

// GetComponentPolicyWithContext is the same as GetComponentPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetComponentPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetComponentPolicyWithContext(ctx aws.Context, input *GetComponentPolicyInput, opts ...request.Option) (*GetComponentPolicyOutput, error) {
	req, out := c.GetComponentPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerRecipe = "GetContainerRecipe"

// GetContainerRecipeRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerRecipe for more information on using the GetContainerRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContainerRecipeRequest method.
//	req, resp := client.GetContainerRecipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe
func (c *Imagebuilder) GetContainerRecipeRequest(input *GetContainerRecipeInput) (req *request.Request, output *GetContainerRecipeOutput) {
	op := &request.Operation{
		Name:       opGetContainerRecipe,
		HTTPMethod: "GET",
		HTTPPath:   "/GetContainerRecipe",
	}

	if input == nil {
		input = &GetContainerRecipeInput{}
	}

	output = &GetContainerRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerRecipe API operation for EC2 Image Builder.
//
// Retrieves a container recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetContainerRecipe for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe
func (c *Imagebuilder) GetContainerRecipe(input *GetContainerRecipeInput) (*GetContainerRecipeOutput, error) {
	req, out := c.GetContainerRecipeRequest(input)
	return out, req.Send()
}

// GetContainerRecipeWithContext is the same as GetContainerRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetContainerRecipeWithContext(ctx aws.Context, input *GetContainerRecipeInput, opts ...request.Option) (*GetContainerRecipeOutput, error) {
	req, out := c.GetContainerRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerRecipePolicy = "GetContainerRecipePolicy"

// GetContainerRecipePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerRecipePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerRecipePolicy for more information on using the GetContainerRecipePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContainerRecipePolicyRequest method.
//	req, resp := client.GetContainerRecipePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy
func (c *Imagebuilder) GetContainerRecipePolicyRequest(input *GetContainerRecipePolicyInput) (req *request.Request, output *GetContainerRecipePolicyOutput) {
	op := &request.Operation{
		Name:       opGetContainerRecipePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/GetContainerRecipePolicy",
	}

	if input == nil {
		input = &GetContainerRecipePolicyInput{}
	}

	output = &GetContainerRecipePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerRecipePolicy API operation for EC2 Image Builder.
//
// Retrieves the policy for a container recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetContainerRecipePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy
func (c *Imagebuilder) GetContainerRecipePolicy(input *GetContainerRecipePolicyInput) (*GetContainerRecipePolicyOutput, error) {
	req, out := c.GetContainerRecipePolicyRequest(input)
	return out, req.Send()
}

// GetContainerRecipePolicyWithContext is the same as GetContainerRecipePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerRecipePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetContainerRecipePolicyWithContext(ctx aws.Context, input *GetContainerRecipePolicyInput, opts ...request.Option) (*GetContainerRecipePolicyOutput, error) {
	req, out := c.GetContainerRecipePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistributionConfiguration = "GetDistributionConfiguration"

// GetDistributionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetDistributionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistributionConfiguration for more information on using the GetDistributionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDistributionConfigurationRequest method.
//	req, resp := client.GetDistributionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration
func (c *Imagebuilder) GetDistributionConfigurationRequest(input *GetDistributionConfigurationInput) (req *request.Request, output *GetDistributionConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetDistributionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/GetDistributionConfiguration",
	}

	if input == nil {
		input = &GetDistributionConfigurationInput{}
	}

	output = &GetDistributionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistributionConfiguration API operation for EC2 Image Builder.
//
// Gets a distribution configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetDistributionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration
func (c *Imagebuilder) GetDistributionConfiguration(input *GetDistributionConfigurationInput) (*GetDistributionConfigurationOutput, error) {
	req, out := c.GetDistributionConfigurationRequest(input)
	return out, req.Send()
}

// GetDistributionConfigurationWithContext is the same as GetDistributionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistributionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetDistributionConfigurationWithContext(ctx aws.Context, input *GetDistributionConfigurationInput, opts ...request.Option) (*GetDistributionConfigurationOutput, error) {
	req, out := c.GetDistributionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImage = "GetImage"

// GetImageRequest generates a "aws/request.Request" representing the
// client's request for the GetImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImage for more information on using the GetImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImageRequest method.
//	req, resp := client.GetImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage
func (c *Imagebuilder) GetImageRequest(input *GetImageInput) (req *request.Request, output *GetImageOutput) {
	op := &request.Operation{
		Name:       opGetImage,
		HTTPMethod: "GET",
		HTTPPath:   "/GetImage",
	}

	if input == nil {
		input = &GetImageInput{}
	}

	output = &GetImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImage API operation for EC2 Image Builder.
//
// Gets an image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetImage for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage
func (c *Imagebuilder) GetImage(input *GetImageInput) (*GetImageOutput, error) {
	req, out := c.GetImageRequest(input)
	return out, req.Send()
}

// GetImageWithContext is the same as GetImage with the addition of
// the ability to pass a context and additional request options.
//
// See GetImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetImageWithContext(ctx aws.Context, input *GetImageInput, opts ...request.Option) (*GetImageOutput, error) {
	req, out := c.GetImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImagePipeline = "GetImagePipeline"

// GetImagePipelineRequest generates a "aws/request.Request" representing the
// client's request for the GetImagePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImagePipeline for more information on using the GetImagePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImagePipelineRequest method.
//	req, resp := client.GetImagePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline
func (c *Imagebuilder) GetImagePipelineRequest(input *GetImagePipelineInput) (req *request.Request, output *GetImagePipelineOutput) {
	op := &request.Operation{
		Name:       opGetImagePipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/GetImagePipeline",
	}

	if input == nil {
		input = &GetImagePipelineInput{}
	}

	output = &GetImagePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImagePipeline API operation for EC2 Image Builder.
//
// Gets an image pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetImagePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline
func (c *Imagebuilder) GetImagePipeline(input *GetImagePipelineInput) (*GetImagePipelineOutput, error) {
	req, out := c.GetImagePipelineRequest(input)
	return out, req.Send()
}

// GetImagePipelineWithContext is the same as GetImagePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See GetImagePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetImagePipelineWithContext(ctx aws.Context, input *GetImagePipelineInput, opts ...request.Option) (*GetImagePipelineOutput, error) {
	req, out := c.GetImagePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImagePolicy = "GetImagePolicy"

// GetImagePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetImagePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImagePolicy for more information on using the GetImagePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImagePolicyRequest method.
//	req, resp := client.GetImagePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy
func (c *Imagebuilder) GetImagePolicyRequest(input *GetImagePolicyInput) (req *request.Request, output *GetImagePolicyOutput) {
	op := &request.Operation{
		Name:       opGetImagePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/GetImagePolicy",
	}

	if input == nil {
		input = &GetImagePolicyInput{}
	}

	output = &GetImagePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImagePolicy API operation for EC2 Image Builder.
//
// Gets an image policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetImagePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy
func (c *Imagebuilder) GetImagePolicy(input *GetImagePolicyInput) (*GetImagePolicyOutput, error) {
	req, out := c.GetImagePolicyRequest(input)
	return out, req.Send()
}

// GetImagePolicyWithContext is the same as GetImagePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetImagePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetImagePolicyWithContext(ctx aws.Context, input *GetImagePolicyInput, opts ...request.Option) (*GetImagePolicyOutput, error) {
	req, out := c.GetImagePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImageRecipe = "GetImageRecipe"

// GetImageRecipeRequest generates a "aws/request.Request" representing the
// client's request for the GetImageRecipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImageRecipe for more information on using the GetImageRecipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImageRecipeRequest method.
//	req, resp := client.GetImageRecipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe
func (c *Imagebuilder) GetImageRecipeRequest(input *GetImageRecipeInput) (req *request.Request, output *GetImageRecipeOutput) {
	op := &request.Operation{
		Name:       opGetImageRecipe,
		HTTPMethod: "GET",
		HTTPPath:   "/GetImageRecipe",
	}

	if input == nil {
		input = &GetImageRecipeInput{}
	}

	output = &GetImageRecipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImageRecipe API operation for EC2 Image Builder.
//
// Gets an image recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetImageRecipe for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe
func (c *Imagebuilder) GetImageRecipe(input *GetImageRecipeInput) (*GetImageRecipeOutput, error) {
	req, out := c.GetImageRecipeRequest(input)
	return out, req.Send()
}

// GetImageRecipeWithContext is the same as GetImageRecipe with the addition of
// the ability to pass a context and additional request options.
//
// See GetImageRecipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetImageRecipeWithContext(ctx aws.Context, input *GetImageRecipeInput, opts ...request.Option) (*GetImageRecipeOutput, error) {
	req, out := c.GetImageRecipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImageRecipePolicy = "GetImageRecipePolicy"

// GetImageRecipePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetImageRecipePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImageRecipePolicy for more information on using the GetImageRecipePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImageRecipePolicyRequest method.
//	req, resp := client.GetImageRecipePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy
func (c *Imagebuilder) GetImageRecipePolicyRequest(input *GetImageRecipePolicyInput) (req *request.Request, output *GetImageRecipePolicyOutput) {
	op := &request.Operation{
		Name:       opGetImageRecipePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/GetImageRecipePolicy",
	}

	if input == nil {
		input = &GetImageRecipePolicyInput{}
	}

	output = &GetImageRecipePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImageRecipePolicy API operation for EC2 Image Builder.
//
// Gets an image recipe policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetImageRecipePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy
func (c *Imagebuilder) GetImageRecipePolicy(input *GetImageRecipePolicyInput) (*GetImageRecipePolicyOutput, error) {
	req, out := c.GetImageRecipePolicyRequest(input)
	return out, req.Send()
}

// GetImageRecipePolicyWithContext is the same as GetImageRecipePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetImageRecipePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetImageRecipePolicyWithContext(ctx aws.Context, input *GetImageRecipePolicyInput, opts ...request.Option) (*GetImageRecipePolicyOutput, error) {
	req, out := c.GetImageRecipePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInfrastructureConfiguration = "GetInfrastructureConfiguration"

// GetInfrastructureConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetInfrastructureConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInfrastructureConfiguration for more information on using the GetInfrastructureConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInfrastructureConfigurationRequest method.
//	req, resp := client.GetInfrastructureConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration
func (c *Imagebuilder) GetInfrastructureConfigurationRequest(input *GetInfrastructureConfigurationInput) (req *request.Request, output *GetInfrastructureConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetInfrastructureConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/GetInfrastructureConfiguration",
	}

	if input == nil {
		input = &GetInfrastructureConfigurationInput{}
	}

	output = &GetInfrastructureConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInfrastructureConfiguration API operation for EC2 Image Builder.
//
// Gets an infrastructure configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation GetInfrastructureConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration
func (c *Imagebuilder) GetInfrastructureConfiguration(input *GetInfrastructureConfigurationInput) (*GetInfrastructureConfigurationOutput, error) {
	req, out := c.GetInfrastructureConfigurationRequest(input)
	return out, req.Send()
}

// GetInfrastructureConfigurationWithContext is the same as GetInfrastructureConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetInfrastructureConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) GetInfrastructureConfigurationWithContext(ctx aws.Context, input *GetInfrastructureConfigurationInput, opts ...request.Option) (*GetInfrastructureConfigurationOutput, error) {
	req, out := c.GetInfrastructureConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportComponent = "ImportComponent"

// ImportComponentRequest generates a "aws/request.Request" representing the
// client's request for the ImportComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportComponent for more information on using the ImportComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportComponentRequest method.
//	req, resp := client.ImportComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent
func (c *Imagebuilder) ImportComponentRequest(input *ImportComponentInput) (req *request.Request, output *ImportComponentOutput) {
	op := &request.Operation{
		Name:       opImportComponent,
		HTTPMethod: "PUT",
		HTTPPath:   "/ImportComponent",
	}

	if input == nil {
		input = &ImportComponentInput{}
	}

	output = &ImportComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportComponent API operation for EC2 Image Builder.
//
// Imports a component and transforms its data into a component document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ImportComponent for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - InvalidVersionNumberException
//     Your version number is out of bounds or does not follow the required syntax.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - InvalidParameterCombinationException
//     You have specified two or more mutually exclusive parameters. Review the
//     error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent
func (c *Imagebuilder) ImportComponent(input *ImportComponentInput) (*ImportComponentOutput, error) {
	req, out := c.ImportComponentRequest(input)
	return out, req.Send()
}

// ImportComponentWithContext is the same as ImportComponent with the addition of
// the ability to pass a context and additional request options.
//
// See ImportComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ImportComponentWithContext(ctx aws.Context, input *ImportComponentInput, opts ...request.Option) (*ImportComponentOutput, error) {
	req, out := c.ImportComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportVmImage = "ImportVmImage"

// ImportVmImageRequest generates a "aws/request.Request" representing the
// client's request for the ImportVmImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportVmImage for more information on using the ImportVmImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportVmImageRequest method.
//	req, resp := client.ImportVmImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportVmImage
func (c *Imagebuilder) ImportVmImageRequest(input *ImportVmImageInput) (req *request.Request, output *ImportVmImageOutput) {
	op := &request.Operation{
		Name:       opImportVmImage,
		HTTPMethod: "PUT",
		HTTPPath:   "/ImportVmImage",
	}

	if input == nil {
		input = &ImportVmImageInput{}
	}

	output = &ImportVmImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportVmImage API operation for EC2 Image Builder.
//
// When you export your virtual machine (VM) from its virtualization environment,
// that process creates a set of one or more disk container files that act as
// snapshots of your VM’s environment, settings, and data. The Amazon EC2
// API ImportImage (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html)
// action uses those files to import your VM and create an AMI. To import using
// the CLI command, see import-image (https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html)
//
// You can reference the task ID from the VM import to pull in the AMI that
// the import created as the base image for your Image Builder recipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ImportVmImage for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportVmImage
func (c *Imagebuilder) ImportVmImage(input *ImportVmImageInput) (*ImportVmImageOutput, error) {
	req, out := c.ImportVmImageRequest(input)
	return out, req.Send()
}

// ImportVmImageWithContext is the same as ImportVmImage with the addition of
// the ability to pass a context and additional request options.
//
// See ImportVmImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ImportVmImageWithContext(ctx aws.Context, input *ImportVmImageInput, opts ...request.Option) (*ImportVmImageOutput, error) {
	req, out := c.ImportVmImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListComponentBuildVersions = "ListComponentBuildVersions"

// ListComponentBuildVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponentBuildVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponentBuildVersions for more information on using the ListComponentBuildVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComponentBuildVersionsRequest method.
//	req, resp := client.ListComponentBuildVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions
func (c *Imagebuilder) ListComponentBuildVersionsRequest(input *ListComponentBuildVersionsInput) (req *request.Request, output *ListComponentBuildVersionsOutput) {
	op := &request.Operation{
		Name:       opListComponentBuildVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListComponentBuildVersions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentBuildVersionsInput{}
	}

	output = &ListComponentBuildVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponentBuildVersions API operation for EC2 Image Builder.
//
// Returns the list of component build versions for the specified semantic version.
//
// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
// can assign values for the first three, and can filter on all of them.
//
// Filtering: With semantic versioning, you have the flexibility to use wildcards
// (x) to specify the most recent versions or nodes when selecting the base
// image or components for your recipe. When you use a wildcard in any node,
// all nodes to the right of the first wildcard must also be wildcards.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListComponentBuildVersions for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions
func (c *Imagebuilder) ListComponentBuildVersions(input *ListComponentBuildVersionsInput) (*ListComponentBuildVersionsOutput, error) {
	req, out := c.ListComponentBuildVersionsRequest(input)
	return out, req.Send()
}

// ListComponentBuildVersionsWithContext is the same as ListComponentBuildVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponentBuildVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListComponentBuildVersionsWithContext(ctx aws.Context, input *ListComponentBuildVersionsInput, opts ...request.Option) (*ListComponentBuildVersionsOutput, error) {
	req, out := c.ListComponentBuildVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentBuildVersionsPages iterates over the pages of a ListComponentBuildVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponentBuildVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComponentBuildVersions operation.
//	pageNum := 0
//	err := client.ListComponentBuildVersionsPages(params,
//	    func(page *imagebuilder.ListComponentBuildVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListComponentBuildVersionsPages(input *ListComponentBuildVersionsInput, fn func(*ListComponentBuildVersionsOutput, bool) bool) error {
	return c.ListComponentBuildVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentBuildVersionsPagesWithContext same as ListComponentBuildVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListComponentBuildVersionsPagesWithContext(ctx aws.Context, input *ListComponentBuildVersionsInput, fn func(*ListComponentBuildVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentBuildVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentBuildVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentBuildVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComponents = "ListComponents"

// ListComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponents for more information on using the ListComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComponentsRequest method.
//	req, resp := client.ListComponentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents
func (c *Imagebuilder) ListComponentsRequest(input *ListComponentsInput) (req *request.Request, output *ListComponentsOutput) {
	op := &request.Operation{
		Name:       opListComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/ListComponents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	output = &ListComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponents API operation for EC2 Image Builder.
//
// Returns the list of components that can be filtered by name, or by using
// the listed filters to streamline results. Newly created components can take
// up to two minutes to appear in the ListComponents API Results.
//
// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
// can assign values for the first three, and can filter on all of them.
//
// Filtering: With semantic versioning, you have the flexibility to use wildcards
// (x) to specify the most recent versions or nodes when selecting the base
// image or components for your recipe. When you use a wildcard in any node,
// all nodes to the right of the first wildcard must also be wildcards.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListComponents for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents
func (c *Imagebuilder) ListComponents(input *ListComponentsInput) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	return out, req.Send()
}

// ListComponentsWithContext is the same as ListComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListComponentsWithContext(ctx aws.Context, input *ListComponentsInput, opts ...request.Option) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentsPages iterates over the pages of a ListComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComponents operation.
//	pageNum := 0
//	err := client.ListComponentsPages(params,
//	    func(page *imagebuilder.ListComponentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListComponentsPages(input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool) error {
	return c.ListComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentsPagesWithContext same as ListComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListComponentsPagesWithContext(ctx aws.Context, input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContainerRecipes = "ListContainerRecipes"

// ListContainerRecipesRequest generates a "aws/request.Request" representing the
// client's request for the ListContainerRecipes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContainerRecipes for more information on using the ListContainerRecipes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContainerRecipesRequest method.
//	req, resp := client.ListContainerRecipesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes
func (c *Imagebuilder) ListContainerRecipesRequest(input *ListContainerRecipesInput) (req *request.Request, output *ListContainerRecipesOutput) {
	op := &request.Operation{
		Name:       opListContainerRecipes,
		HTTPMethod: "POST",
		HTTPPath:   "/ListContainerRecipes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContainerRecipesInput{}
	}

	output = &ListContainerRecipesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContainerRecipes API operation for EC2 Image Builder.
//
// Returns a list of container recipes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListContainerRecipes for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes
func (c *Imagebuilder) ListContainerRecipes(input *ListContainerRecipesInput) (*ListContainerRecipesOutput, error) {
	req, out := c.ListContainerRecipesRequest(input)
	return out, req.Send()
}

// ListContainerRecipesWithContext is the same as ListContainerRecipes with the addition of
// the ability to pass a context and additional request options.
//
// See ListContainerRecipes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListContainerRecipesWithContext(ctx aws.Context, input *ListContainerRecipesInput, opts ...request.Option) (*ListContainerRecipesOutput, error) {
	req, out := c.ListContainerRecipesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContainerRecipesPages iterates over the pages of a ListContainerRecipes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContainerRecipes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContainerRecipes operation.
//	pageNum := 0
//	err := client.ListContainerRecipesPages(params,
//	    func(page *imagebuilder.ListContainerRecipesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListContainerRecipesPages(input *ListContainerRecipesInput, fn func(*ListContainerRecipesOutput, bool) bool) error {
	return c.ListContainerRecipesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContainerRecipesPagesWithContext same as ListContainerRecipesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListContainerRecipesPagesWithContext(ctx aws.Context, input *ListContainerRecipesInput, fn func(*ListContainerRecipesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContainerRecipesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContainerRecipesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContainerRecipesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDistributionConfigurations = "ListDistributionConfigurations"

// ListDistributionConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributionConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributionConfigurations for more information on using the ListDistributionConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDistributionConfigurationsRequest method.
//	req, resp := client.ListDistributionConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations
func (c *Imagebuilder) ListDistributionConfigurationsRequest(input *ListDistributionConfigurationsInput) (req *request.Request, output *ListDistributionConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListDistributionConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/ListDistributionConfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDistributionConfigurationsInput{}
	}

	output = &ListDistributionConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributionConfigurations API operation for EC2 Image Builder.
//
// Returns a list of distribution configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListDistributionConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations
func (c *Imagebuilder) ListDistributionConfigurations(input *ListDistributionConfigurationsInput) (*ListDistributionConfigurationsOutput, error) {
	req, out := c.ListDistributionConfigurationsRequest(input)
	return out, req.Send()
}

// ListDistributionConfigurationsWithContext is the same as ListDistributionConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributionConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListDistributionConfigurationsWithContext(ctx aws.Context, input *ListDistributionConfigurationsInput, opts ...request.Option) (*ListDistributionConfigurationsOutput, error) {
	req, out := c.ListDistributionConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDistributionConfigurationsPages iterates over the pages of a ListDistributionConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDistributionConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDistributionConfigurations operation.
//	pageNum := 0
//	err := client.ListDistributionConfigurationsPages(params,
//	    func(page *imagebuilder.ListDistributionConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListDistributionConfigurationsPages(input *ListDistributionConfigurationsInput, fn func(*ListDistributionConfigurationsOutput, bool) bool) error {
	return c.ListDistributionConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDistributionConfigurationsPagesWithContext same as ListDistributionConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListDistributionConfigurationsPagesWithContext(ctx aws.Context, input *ListDistributionConfigurationsInput, fn func(*ListDistributionConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDistributionConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDistributionConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDistributionConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImageBuildVersions = "ListImageBuildVersions"

// ListImageBuildVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListImageBuildVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImageBuildVersions for more information on using the ListImageBuildVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImageBuildVersionsRequest method.
//	req, resp := client.ListImageBuildVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions
func (c *Imagebuilder) ListImageBuildVersionsRequest(input *ListImageBuildVersionsInput) (req *request.Request, output *ListImageBuildVersionsOutput) {
	op := &request.Operation{
		Name:       opListImageBuildVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListImageBuildVersions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImageBuildVersionsInput{}
	}

	output = &ListImageBuildVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImageBuildVersions API operation for EC2 Image Builder.
//
// Returns a list of image build versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListImageBuildVersions for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions
func (c *Imagebuilder) ListImageBuildVersions(input *ListImageBuildVersionsInput) (*ListImageBuildVersionsOutput, error) {
	req, out := c.ListImageBuildVersionsRequest(input)
	return out, req.Send()
}

// ListImageBuildVersionsWithContext is the same as ListImageBuildVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListImageBuildVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImageBuildVersionsWithContext(ctx aws.Context, input *ListImageBuildVersionsInput, opts ...request.Option) (*ListImageBuildVersionsOutput, error) {
	req, out := c.ListImageBuildVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImageBuildVersionsPages iterates over the pages of a ListImageBuildVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImageBuildVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImageBuildVersions operation.
//	pageNum := 0
//	err := client.ListImageBuildVersionsPages(params,
//	    func(page *imagebuilder.ListImageBuildVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListImageBuildVersionsPages(input *ListImageBuildVersionsInput, fn func(*ListImageBuildVersionsOutput, bool) bool) error {
	return c.ListImageBuildVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImageBuildVersionsPagesWithContext same as ListImageBuildVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImageBuildVersionsPagesWithContext(ctx aws.Context, input *ListImageBuildVersionsInput, fn func(*ListImageBuildVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImageBuildVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImageBuildVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImageBuildVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImagePackages = "ListImagePackages"

// ListImagePackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListImagePackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImagePackages for more information on using the ListImagePackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImagePackagesRequest method.
//	req, resp := client.ListImagePackagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages
func (c *Imagebuilder) ListImagePackagesRequest(input *ListImagePackagesInput) (req *request.Request, output *ListImagePackagesOutput) {
	op := &request.Operation{
		Name:       opListImagePackages,
		HTTPMethod: "POST",
		HTTPPath:   "/ListImagePackages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImagePackagesInput{}
	}

	output = &ListImagePackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImagePackages API operation for EC2 Image Builder.
//
// List the Packages that are associated with an Image Build Version, as determined
// by Amazon Web Services Systems Manager Inventory at build time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListImagePackages for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages
func (c *Imagebuilder) ListImagePackages(input *ListImagePackagesInput) (*ListImagePackagesOutput, error) {
	req, out := c.ListImagePackagesRequest(input)
	return out, req.Send()
}

// ListImagePackagesWithContext is the same as ListImagePackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListImagePackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImagePackagesWithContext(ctx aws.Context, input *ListImagePackagesInput, opts ...request.Option) (*ListImagePackagesOutput, error) {
	req, out := c.ListImagePackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImagePackagesPages iterates over the pages of a ListImagePackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImagePackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImagePackages operation.
//	pageNum := 0
//	err := client.ListImagePackagesPages(params,
//	    func(page *imagebuilder.ListImagePackagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListImagePackagesPages(input *ListImagePackagesInput, fn func(*ListImagePackagesOutput, bool) bool) error {
	return c.ListImagePackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImagePackagesPagesWithContext same as ListImagePackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImagePackagesPagesWithContext(ctx aws.Context, input *ListImagePackagesInput, fn func(*ListImagePackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImagePackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImagePackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImagePackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImagePipelineImages = "ListImagePipelineImages"

// ListImagePipelineImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListImagePipelineImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImagePipelineImages for more information on using the ListImagePipelineImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImagePipelineImagesRequest method.
//	req, resp := client.ListImagePipelineImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages
func (c *Imagebuilder) ListImagePipelineImagesRequest(input *ListImagePipelineImagesInput) (req *request.Request, output *ListImagePipelineImagesOutput) {
	op := &request.Operation{
		Name:       opListImagePipelineImages,
		HTTPMethod: "POST",
		HTTPPath:   "/ListImagePipelineImages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImagePipelineImagesInput{}
	}

	output = &ListImagePipelineImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImagePipelineImages API operation for EC2 Image Builder.
//
// Returns a list of images created by the specified pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListImagePipelineImages for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages
func (c *Imagebuilder) ListImagePipelineImages(input *ListImagePipelineImagesInput) (*ListImagePipelineImagesOutput, error) {
	req, out := c.ListImagePipelineImagesRequest(input)
	return out, req.Send()
}

// ListImagePipelineImagesWithContext is the same as ListImagePipelineImages with the addition of
// the ability to pass a context and additional request options.
//
// See ListImagePipelineImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImagePipelineImagesWithContext(ctx aws.Context, input *ListImagePipelineImagesInput, opts ...request.Option) (*ListImagePipelineImagesOutput, error) {
	req, out := c.ListImagePipelineImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImagePipelineImagesPages iterates over the pages of a ListImagePipelineImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImagePipelineImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImagePipelineImages operation.
//	pageNum := 0
//	err := client.ListImagePipelineImagesPages(params,
//	    func(page *imagebuilder.ListImagePipelineImagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListImagePipelineImagesPages(input *ListImagePipelineImagesInput, fn func(*ListImagePipelineImagesOutput, bool) bool) error {
	return c.ListImagePipelineImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImagePipelineImagesPagesWithContext same as ListImagePipelineImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImagePipelineImagesPagesWithContext(ctx aws.Context, input *ListImagePipelineImagesInput, fn func(*ListImagePipelineImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImagePipelineImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImagePipelineImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImagePipelineImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImagePipelines = "ListImagePipelines"

// ListImagePipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListImagePipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImagePipelines for more information on using the ListImagePipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImagePipelinesRequest method.
//	req, resp := client.ListImagePipelinesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines
func (c *Imagebuilder) ListImagePipelinesRequest(input *ListImagePipelinesInput) (req *request.Request, output *ListImagePipelinesOutput) {
	op := &request.Operation{
		Name:       opListImagePipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/ListImagePipelines",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImagePipelinesInput{}
	}

	output = &ListImagePipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImagePipelines API operation for EC2 Image Builder.
//
// Returns a list of image pipelines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListImagePipelines for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines
func (c *Imagebuilder) ListImagePipelines(input *ListImagePipelinesInput) (*ListImagePipelinesOutput, error) {
	req, out := c.ListImagePipelinesRequest(input)
	return out, req.Send()
}

// ListImagePipelinesWithContext is the same as ListImagePipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListImagePipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImagePipelinesWithContext(ctx aws.Context, input *ListImagePipelinesInput, opts ...request.Option) (*ListImagePipelinesOutput, error) {
	req, out := c.ListImagePipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImagePipelinesPages iterates over the pages of a ListImagePipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImagePipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImagePipelines operation.
//	pageNum := 0
//	err := client.ListImagePipelinesPages(params,
//	    func(page *imagebuilder.ListImagePipelinesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListImagePipelinesPages(input *ListImagePipelinesInput, fn func(*ListImagePipelinesOutput, bool) bool) error {
	return c.ListImagePipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImagePipelinesPagesWithContext same as ListImagePipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImagePipelinesPagesWithContext(ctx aws.Context, input *ListImagePipelinesInput, fn func(*ListImagePipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImagePipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImagePipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImagePipelinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImageRecipes = "ListImageRecipes"

// ListImageRecipesRequest generates a "aws/request.Request" representing the
// client's request for the ListImageRecipes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImageRecipes for more information on using the ListImageRecipes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImageRecipesRequest method.
//	req, resp := client.ListImageRecipesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes
func (c *Imagebuilder) ListImageRecipesRequest(input *ListImageRecipesInput) (req *request.Request, output *ListImageRecipesOutput) {
	op := &request.Operation{
		Name:       opListImageRecipes,
		HTTPMethod: "POST",
		HTTPPath:   "/ListImageRecipes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImageRecipesInput{}
	}

	output = &ListImageRecipesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImageRecipes API operation for EC2 Image Builder.
//
// Returns a list of image recipes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListImageRecipes for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes
func (c *Imagebuilder) ListImageRecipes(input *ListImageRecipesInput) (*ListImageRecipesOutput, error) {
	req, out := c.ListImageRecipesRequest(input)
	return out, req.Send()
}

// ListImageRecipesWithContext is the same as ListImageRecipes with the addition of
// the ability to pass a context and additional request options.
//
// See ListImageRecipes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImageRecipesWithContext(ctx aws.Context, input *ListImageRecipesInput, opts ...request.Option) (*ListImageRecipesOutput, error) {
	req, out := c.ListImageRecipesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImageRecipesPages iterates over the pages of a ListImageRecipes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImageRecipes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImageRecipes operation.
//	pageNum := 0
//	err := client.ListImageRecipesPages(params,
//	    func(page *imagebuilder.ListImageRecipesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListImageRecipesPages(input *ListImageRecipesInput, fn func(*ListImageRecipesOutput, bool) bool) error {
	return c.ListImageRecipesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImageRecipesPagesWithContext same as ListImageRecipesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImageRecipesPagesWithContext(ctx aws.Context, input *ListImageRecipesInput, fn func(*ListImageRecipesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImageRecipesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImageRecipesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImageRecipesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImages = "ListImages"

// ListImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImages for more information on using the ListImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImagesRequest method.
//	req, resp := client.ListImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages
func (c *Imagebuilder) ListImagesRequest(input *ListImagesInput) (req *request.Request, output *ListImagesOutput) {
	op := &request.Operation{
		Name:       opListImages,
		HTTPMethod: "POST",
		HTTPPath:   "/ListImages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImagesInput{}
	}

	output = &ListImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImages API operation for EC2 Image Builder.
//
// Returns the list of images that you have access to. Newly created images
// can take up to two minutes to appear in the ListImages API Results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListImages for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages
func (c *Imagebuilder) ListImages(input *ListImagesInput) (*ListImagesOutput, error) {
	req, out := c.ListImagesRequest(input)
	return out, req.Send()
}

// ListImagesWithContext is the same as ListImages with the addition of
// the ability to pass a context and additional request options.
//
// See ListImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImagesWithContext(ctx aws.Context, input *ListImagesInput, opts ...request.Option) (*ListImagesOutput, error) {
	req, out := c.ListImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImagesPages iterates over the pages of a ListImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImages operation.
//	pageNum := 0
//	err := client.ListImagesPages(params,
//	    func(page *imagebuilder.ListImagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListImagesPages(input *ListImagesInput, fn func(*ListImagesOutput, bool) bool) error {
	return c.ListImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImagesPagesWithContext same as ListImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListImagesPagesWithContext(ctx aws.Context, input *ListImagesInput, fn func(*ListImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInfrastructureConfigurations = "ListInfrastructureConfigurations"

// ListInfrastructureConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInfrastructureConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInfrastructureConfigurations for more information on using the ListInfrastructureConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInfrastructureConfigurationsRequest method.
//	req, resp := client.ListInfrastructureConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations
func (c *Imagebuilder) ListInfrastructureConfigurationsRequest(input *ListInfrastructureConfigurationsInput) (req *request.Request, output *ListInfrastructureConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListInfrastructureConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/ListInfrastructureConfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInfrastructureConfigurationsInput{}
	}

	output = &ListInfrastructureConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInfrastructureConfigurations API operation for EC2 Image Builder.
//
// Returns a list of infrastructure configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListInfrastructureConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidPaginationTokenException
//     You have provided an invalid pagination token in your request.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations
func (c *Imagebuilder) ListInfrastructureConfigurations(input *ListInfrastructureConfigurationsInput) (*ListInfrastructureConfigurationsOutput, error) {
	req, out := c.ListInfrastructureConfigurationsRequest(input)
	return out, req.Send()
}

// ListInfrastructureConfigurationsWithContext is the same as ListInfrastructureConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInfrastructureConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListInfrastructureConfigurationsWithContext(ctx aws.Context, input *ListInfrastructureConfigurationsInput, opts ...request.Option) (*ListInfrastructureConfigurationsOutput, error) {
	req, out := c.ListInfrastructureConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInfrastructureConfigurationsPages iterates over the pages of a ListInfrastructureConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInfrastructureConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInfrastructureConfigurations operation.
//	pageNum := 0
//	err := client.ListInfrastructureConfigurationsPages(params,
//	    func(page *imagebuilder.ListInfrastructureConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Imagebuilder) ListInfrastructureConfigurationsPages(input *ListInfrastructureConfigurationsInput, fn func(*ListInfrastructureConfigurationsOutput, bool) bool) error {
	return c.ListInfrastructureConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInfrastructureConfigurationsPagesWithContext same as ListInfrastructureConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListInfrastructureConfigurationsPagesWithContext(ctx aws.Context, input *ListInfrastructureConfigurationsInput, fn func(*ListInfrastructureConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInfrastructureConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInfrastructureConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInfrastructureConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource
func (c *Imagebuilder) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for EC2 Image Builder.
//
// Returns the list of tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource
func (c *Imagebuilder) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutComponentPolicy = "PutComponentPolicy"

// PutComponentPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutComponentPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutComponentPolicy for more information on using the PutComponentPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutComponentPolicyRequest method.
//	req, resp := client.PutComponentPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy
func (c *Imagebuilder) PutComponentPolicyRequest(input *PutComponentPolicyInput) (req *request.Request, output *PutComponentPolicyOutput) {
	op := &request.Operation{
		Name:       opPutComponentPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/PutComponentPolicy",
	}

	if input == nil {
		input = &PutComponentPolicyInput{}
	}

	output = &PutComponentPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutComponentPolicy API operation for EC2 Image Builder.
//
// Applies a policy to a component. We recommend that you call the RAM API CreateResourceShare
// (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html)
// to share resources. If you call the Image Builder API PutComponentPolicy,
// you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html)
// in order for the resource to be visible to all principals with whom the resource
// is shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation PutComponentPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidParameterValueException
//     The value that you provided for the specified parameter is invalid.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy
func (c *Imagebuilder) PutComponentPolicy(input *PutComponentPolicyInput) (*PutComponentPolicyOutput, error) {
	req, out := c.PutComponentPolicyRequest(input)
	return out, req.Send()
}

// PutComponentPolicyWithContext is the same as PutComponentPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutComponentPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) PutComponentPolicyWithContext(ctx aws.Context, input *PutComponentPolicyInput, opts ...request.Option) (*PutComponentPolicyOutput, error) {
	req, out := c.PutComponentPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutContainerRecipePolicy = "PutContainerRecipePolicy"

// PutContainerRecipePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutContainerRecipePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutContainerRecipePolicy for more information on using the PutContainerRecipePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutContainerRecipePolicyRequest method.
//	req, resp := client.PutContainerRecipePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy
func (c *Imagebuilder) PutContainerRecipePolicyRequest(input *PutContainerRecipePolicyInput) (req *request.Request, output *PutContainerRecipePolicyOutput) {
	op := &request.Operation{
		Name:       opPutContainerRecipePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/PutContainerRecipePolicy",
	}

	if input == nil {
		input = &PutContainerRecipePolicyInput{}
	}

	output = &PutContainerRecipePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutContainerRecipePolicy API operation for EC2 Image Builder.
//
// Applies a policy to a container image. We recommend that you call the RAM
// API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html)
// to share resources. If you call the Image Builder API PutContainerImagePolicy,
// you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html)
// in order for the resource to be visible to all principals with whom the resource
// is shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation PutContainerRecipePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidParameterValueException
//     The value that you provided for the specified parameter is invalid.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy
func (c *Imagebuilder) PutContainerRecipePolicy(input *PutContainerRecipePolicyInput) (*PutContainerRecipePolicyOutput, error) {
	req, out := c.PutContainerRecipePolicyRequest(input)
	return out, req.Send()
}

// PutContainerRecipePolicyWithContext is the same as PutContainerRecipePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutContainerRecipePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) PutContainerRecipePolicyWithContext(ctx aws.Context, input *PutContainerRecipePolicyInput, opts ...request.Option) (*PutContainerRecipePolicyOutput, error) {
	req, out := c.PutContainerRecipePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutImagePolicy = "PutImagePolicy"

// PutImagePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutImagePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutImagePolicy for more information on using the PutImagePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutImagePolicyRequest method.
//	req, resp := client.PutImagePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy
func (c *Imagebuilder) PutImagePolicyRequest(input *PutImagePolicyInput) (req *request.Request, output *PutImagePolicyOutput) {
	op := &request.Operation{
		Name:       opPutImagePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/PutImagePolicy",
	}

	if input == nil {
		input = &PutImagePolicyInput{}
	}

	output = &PutImagePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutImagePolicy API operation for EC2 Image Builder.
//
// Applies a policy to an image. We recommend that you call the RAM API CreateResourceShare
// (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html)
// to share resources. If you call the Image Builder API PutImagePolicy, you
// must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html)
// in order for the resource to be visible to all principals with whom the resource
// is shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation PutImagePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidParameterValueException
//     The value that you provided for the specified parameter is invalid.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy
func (c *Imagebuilder) PutImagePolicy(input *PutImagePolicyInput) (*PutImagePolicyOutput, error) {
	req, out := c.PutImagePolicyRequest(input)
	return out, req.Send()
}

// PutImagePolicyWithContext is the same as PutImagePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutImagePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) PutImagePolicyWithContext(ctx aws.Context, input *PutImagePolicyInput, opts ...request.Option) (*PutImagePolicyOutput, error) {
	req, out := c.PutImagePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutImageRecipePolicy = "PutImageRecipePolicy"

// PutImageRecipePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutImageRecipePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutImageRecipePolicy for more information on using the PutImageRecipePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutImageRecipePolicyRequest method.
//	req, resp := client.PutImageRecipePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy
func (c *Imagebuilder) PutImageRecipePolicyRequest(input *PutImageRecipePolicyInput) (req *request.Request, output *PutImageRecipePolicyOutput) {
	op := &request.Operation{
		Name:       opPutImageRecipePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/PutImageRecipePolicy",
	}

	if input == nil {
		input = &PutImageRecipePolicyInput{}
	}

	output = &PutImageRecipePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutImageRecipePolicy API operation for EC2 Image Builder.
//
// Applies a policy to an image recipe. We recommend that you call the RAM API
// CreateResourceShare (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html)
// to share resources. If you call the Image Builder API PutImageRecipePolicy,
// you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html)
// in order for the resource to be visible to all principals with whom the resource
// is shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation PutImageRecipePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - InvalidParameterValueException
//     The value that you provided for the specified parameter is invalid.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy
func (c *Imagebuilder) PutImageRecipePolicy(input *PutImageRecipePolicyInput) (*PutImageRecipePolicyOutput, error) {
	req, out := c.PutImageRecipePolicyRequest(input)
	return out, req.Send()
}

// PutImageRecipePolicyWithContext is the same as PutImageRecipePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutImageRecipePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) PutImageRecipePolicyWithContext(ctx aws.Context, input *PutImageRecipePolicyInput, opts ...request.Option) (*PutImageRecipePolicyOutput, error) {
	req, out := c.PutImageRecipePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImagePipelineExecution = "StartImagePipelineExecution"

// StartImagePipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartImagePipelineExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImagePipelineExecution for more information on using the StartImagePipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartImagePipelineExecutionRequest method.
//	req, resp := client.StartImagePipelineExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution
func (c *Imagebuilder) StartImagePipelineExecutionRequest(input *StartImagePipelineExecutionInput) (req *request.Request, output *StartImagePipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opStartImagePipelineExecution,
		HTTPMethod: "PUT",
		HTTPPath:   "/StartImagePipelineExecution",
	}

	if input == nil {
		input = &StartImagePipelineExecutionInput{}
	}

	output = &StartImagePipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImagePipelineExecution API operation for EC2 Image Builder.
//
// Manually triggers a pipeline to create an image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation StartImagePipelineExecution for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution
func (c *Imagebuilder) StartImagePipelineExecution(input *StartImagePipelineExecutionInput) (*StartImagePipelineExecutionOutput, error) {
	req, out := c.StartImagePipelineExecutionRequest(input)
	return out, req.Send()
}

// StartImagePipelineExecutionWithContext is the same as StartImagePipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartImagePipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) StartImagePipelineExecutionWithContext(ctx aws.Context, input *StartImagePipelineExecutionInput, opts ...request.Option) (*StartImagePipelineExecutionOutput, error) {
	req, out := c.StartImagePipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource
func (c *Imagebuilder) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for EC2 Image Builder.
//
// Adds a tag to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource
func (c *Imagebuilder) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource
func (c *Imagebuilder) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for EC2 Image Builder.
//
// Removes a tag from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ResourceNotFoundException
//     At least one of the resources referenced by your request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource
func (c *Imagebuilder) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDistributionConfiguration = "UpdateDistributionConfiguration"

// UpdateDistributionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDistributionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDistributionConfiguration for more information on using the UpdateDistributionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDistributionConfigurationRequest method.
//	req, resp := client.UpdateDistributionConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration
func (c *Imagebuilder) UpdateDistributionConfigurationRequest(input *UpdateDistributionConfigurationInput) (req *request.Request, output *UpdateDistributionConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateDistributionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/UpdateDistributionConfiguration",
	}

	if input == nil {
		input = &UpdateDistributionConfigurationInput{}
	}

	output = &UpdateDistributionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDistributionConfiguration API operation for EC2 Image Builder.
//
// Updates a new distribution configuration. Distribution configurations define
// and configure the outputs of your pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation UpdateDistributionConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
//   - InvalidParameterCombinationException
//     You have specified two or more mutually exclusive parameters. Review the
//     error message for details.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration
func (c *Imagebuilder) UpdateDistributionConfiguration(input *UpdateDistributionConfigurationInput) (*UpdateDistributionConfigurationOutput, error) {
	req, out := c.UpdateDistributionConfigurationRequest(input)
	return out, req.Send()
}

// UpdateDistributionConfigurationWithContext is the same as UpdateDistributionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDistributionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) UpdateDistributionConfigurationWithContext(ctx aws.Context, input *UpdateDistributionConfigurationInput, opts ...request.Option) (*UpdateDistributionConfigurationOutput, error) {
	req, out := c.UpdateDistributionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateImagePipeline = "UpdateImagePipeline"

// UpdateImagePipelineRequest generates a "aws/request.Request" representing the
// client's request for the UpdateImagePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateImagePipeline for more information on using the UpdateImagePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateImagePipelineRequest method.
//	req, resp := client.UpdateImagePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline
func (c *Imagebuilder) UpdateImagePipelineRequest(input *UpdateImagePipelineInput) (req *request.Request, output *UpdateImagePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdateImagePipeline,
		HTTPMethod: "PUT",
		HTTPPath:   "/UpdateImagePipeline",
	}

	if input == nil {
		input = &UpdateImagePipelineInput{}
	}

	output = &UpdateImagePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateImagePipeline API operation for EC2 Image Builder.
//
// Updates an image pipeline. Image pipelines enable you to automate the creation
// and distribution of images.
//
// UpdateImagePipeline does not support selective updates for the pipeline.
// You must specify all of the required properties in the update request, not
// just the properties that have changed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation UpdateImagePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline
func (c *Imagebuilder) UpdateImagePipeline(input *UpdateImagePipelineInput) (*UpdateImagePipelineOutput, error) {
	req, out := c.UpdateImagePipelineRequest(input)
	return out, req.Send()
}

// UpdateImagePipelineWithContext is the same as UpdateImagePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateImagePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) UpdateImagePipelineWithContext(ctx aws.Context, input *UpdateImagePipelineInput, opts ...request.Option) (*UpdateImagePipelineOutput, error) {
	req, out := c.UpdateImagePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInfrastructureConfiguration = "UpdateInfrastructureConfiguration"

// UpdateInfrastructureConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInfrastructureConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInfrastructureConfiguration for more information on using the UpdateInfrastructureConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInfrastructureConfigurationRequest method.
//	req, resp := client.UpdateInfrastructureConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration
func (c *Imagebuilder) UpdateInfrastructureConfigurationRequest(input *UpdateInfrastructureConfigurationInput) (req *request.Request, output *UpdateInfrastructureConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateInfrastructureConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/UpdateInfrastructureConfiguration",
	}

	if input == nil {
		input = &UpdateInfrastructureConfigurationInput{}
	}

	output = &UpdateInfrastructureConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInfrastructureConfiguration API operation for EC2 Image Builder.
//
// Updates a new infrastructure configuration. An infrastructure configuration
// defines the environment in which your image will be built and tested.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for EC2 Image Builder's
// API operation UpdateInfrastructureConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceException
//     This exception is thrown when the service encounters an unrecoverable exception.
//
//   - ClientException
//     These errors are usually caused by a client action, such as using an action
//     or resource on behalf of a user that doesn't have permissions to use the
//     action or resource, or specifying an invalid resource identifier.
//
//   - ServiceUnavailableException
//     The service is unable to process your request at this time.
//
//   - InvalidRequestException
//     You have made a request for an action that is not supported by the service.
//
//   - IdempotentParameterMismatchException
//     You have specified a client token for an operation using parameter values
//     that differ from a previous request that used the same client token.
//
//   - ForbiddenException
//     You are not authorized to perform the requested operation.
//
//   - CallRateLimitExceededException
//     You have exceeded the permitted request rate for the specific operation.
//
//   - ResourceInUseException
//     The resource that you are trying to operate on is currently in use. Review
//     the message details and retry later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration
func (c *Imagebuilder) UpdateInfrastructureConfiguration(input *UpdateInfrastructureConfigurationInput) (*UpdateInfrastructureConfigurationOutput, error) {
	req, out := c.UpdateInfrastructureConfigurationRequest(input)
	return out, req.Send()
}

// UpdateInfrastructureConfigurationWithContext is the same as UpdateInfrastructureConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInfrastructureConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Imagebuilder) UpdateInfrastructureConfigurationWithContext(ctx aws.Context, input *UpdateInfrastructureConfigurationInput, opts ...request.Option) (*UpdateInfrastructureConfigurationOutput, error) {
	req, out := c.UpdateInfrastructureConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// In addition to your infrastructure configuration, these settings provide
// an extra layer of control over your build instances. You can also specify
// commands to run on launch for all of your build instances.
//
// Image Builder does not automatically install the Systems Manager agent on
// Windows instances. If your base image includes the Systems Manager agent,
// then the AMI that you create will also include the agent. For Linux instances,
// if the base image does not already include the Systems Manager agent, Image
// Builder installs it. For Linux instances where Image Builder installs the
// Systems Manager agent, you can choose whether to keep it for the AMI that
// you create.
type AdditionalInstanceConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains settings for the Systems Manager agent on your build instance.
	SystemsManagerAgent *SystemsManagerAgent `locationName:"systemsManagerAgent" type:"structure"`

	// Use this property to provide commands or a command script to run when you
	// launch your build instance.
	//
	// The userDataOverride property replaces any commands that Image Builder might
	// have added to ensure that Systems Manager is installed on your Linux build
	// instance. If you override the user data, make sure that you add commands
	// to install Systems Manager, if it is not pre-installed on your base image.
	//
	// The user data is always base 64 encoded. For example, the following commands
	// are encoded as IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$:
	//
	// #!/bin/bash
	//
	// mkdir -p /var/bb/
	//
	// touch /var
	UserDataOverride *string `locationName:"userDataOverride" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalInstanceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalInstanceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdditionalInstanceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdditionalInstanceConfiguration"}
	if s.UserDataOverride != nil && len(*s.UserDataOverride) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserDataOverride", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSystemsManagerAgent sets the SystemsManagerAgent field's value.
func (s *AdditionalInstanceConfiguration) SetSystemsManagerAgent(v *SystemsManagerAgent) *AdditionalInstanceConfiguration {
	s.SystemsManagerAgent = v
	return s
}

// SetUserDataOverride sets the UserDataOverride field's value.
func (s *AdditionalInstanceConfiguration) SetUserDataOverride(v string) *AdditionalInstanceConfiguration {
	s.UserDataOverride = &v
	return s
}

// Details of an Amazon EC2 AMI.
type Ami struct {
	_ struct{} `type:"structure"`

	// The account ID of the owner of the AMI.
	AccountId *string `locationName:"accountId" min:"1" type:"string"`

	// The description of the Amazon EC2 AMI. Minimum and maximum length are in
	// characters.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The AMI ID of the Amazon EC2 AMI.
	Image *string `locationName:"image" min:"1" type:"string"`

	// The name of the Amazon EC2 AMI.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Web Services Region of the Amazon EC2 AMI.
	Region *string `locationName:"region" min:"1" type:"string"`

	// Image state shows the image status and the reason for that status.
	State *ImageState `locationName:"state" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ami) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ami) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Ami) SetAccountId(v string) *Ami {
	s.AccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Ami) SetDescription(v string) *Ami {
	s.Description = &v
	return s
}

// SetImage sets the Image field's value.
func (s *Ami) SetImage(v string) *Ami {
	s.Image = &v
	return s
}

// SetName sets the Name field's value.
func (s *Ami) SetName(v string) *Ami {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Ami) SetRegion(v string) *Ami {
	s.Region = &v
	return s
}

// SetState sets the State field's value.
func (s *Ami) SetState(v *ImageState) *Ami {
	s.State = v
	return s
}

// Define and configure the output AMIs of the pipeline.
type AmiDistributionConfiguration struct {
	_ struct{} `type:"structure"`

	// The tags to apply to AMIs distributed to this Region.
	AmiTags map[string]*string `locationName:"amiTags" min:"1" type:"map"`

	// The description of the AMI distribution configuration. Minimum and maximum
	// length are in characters.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The KMS key identifier used to encrypt the distributed image.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// Launch permissions can be used to configure which Amazon Web Services accounts
	// can use the AMI to launch instances.
	LaunchPermission *LaunchPermissionConfiguration `locationName:"launchPermission" type:"structure"`

	// The name of the output AMI.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ID of an account to which you want to distribute an image.
	TargetAccountIds []*string `locationName:"targetAccountIds" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiDistributionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmiDistributionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiDistributionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmiDistributionConfiguration"}
	if s.AmiTags != nil && len(s.AmiTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AmiTags", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TargetAccountIds != nil && len(s.TargetAccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAccountIds", 1))
	}
	if s.LaunchPermission != nil {
		if err := s.LaunchPermission.Validate(); err != nil {
			invalidParams.AddNested("LaunchPermission", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmiTags sets the AmiTags field's value.
func (s *AmiDistributionConfiguration) SetAmiTags(v map[string]*string) *AmiDistributionConfiguration {
	s.AmiTags = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AmiDistributionConfiguration) SetDescription(v string) *AmiDistributionConfiguration {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AmiDistributionConfiguration) SetKmsKeyId(v string) *AmiDistributionConfiguration {
	s.KmsKeyId = &v
	return s
}

// SetLaunchPermission sets the LaunchPermission field's value.
func (s *AmiDistributionConfiguration) SetLaunchPermission(v *LaunchPermissionConfiguration) *AmiDistributionConfiguration {
	s.LaunchPermission = v
	return s
}

// SetName sets the Name field's value.
func (s *AmiDistributionConfiguration) SetName(v string) *AmiDistributionConfiguration {
	s.Name = &v
	return s
}

// SetTargetAccountIds sets the TargetAccountIds field's value.
func (s *AmiDistributionConfiguration) SetTargetAccountIds(v []*string) *AmiDistributionConfiguration {
	s.TargetAccountIds = v
	return s
}

// You have exceeded the permitted request rate for the specific operation.
type CallRateLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallRateLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallRateLimitExceededException) GoString() string {
	return s.String()
}

func newErrorCallRateLimitExceededException(v protocol.ResponseMetadata) error {
	return &CallRateLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CallRateLimitExceededException) Code() string {
	return "CallRateLimitExceededException"
}

// Message returns the exception's message.
func (s *CallRateLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CallRateLimitExceededException) OrigErr() error {
	return nil
}

func (s *CallRateLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CallRateLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CallRateLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelImageCreationInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// in the Amazon EC2 API Reference.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the image whose creation you want to cancel.
	//
	// ImageBuildVersionArn is a required field
	ImageBuildVersionArn *string `locationName:"imageBuildVersionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelImageCreationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelImageCreationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelImageCreationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelImageCreationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ImageBuildVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageBuildVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CancelImageCreationInput) SetClientToken(v string) *CancelImageCreationInput {
	s.ClientToken = &v
	return s
}

// SetImageBuildVersionArn sets the ImageBuildVersionArn field's value.
func (s *CancelImageCreationInput) SetImageBuildVersionArn(v string) *CancelImageCreationInput {
	s.ImageBuildVersionArn = &v
	return s
}

type CancelImageCreationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token that was used for this request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the image whose creation has been cancelled.
	ImageBuildVersionArn *string `locationName:"imageBuildVersionArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelImageCreationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelImageCreationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CancelImageCreationOutput) SetClientToken(v string) *CancelImageCreationOutput {
	s.ClientToken = &v
	return s
}

// SetImageBuildVersionArn sets the ImageBuildVersionArn field's value.
func (s *CancelImageCreationOutput) SetImageBuildVersionArn(v string) *CancelImageCreationOutput {
	s.ImageBuildVersionArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CancelImageCreationOutput) SetRequestId(v string) *CancelImageCreationOutput {
	s.RequestId = &v
	return s
}

// These errors are usually caused by a client action, such as using an action
// or resource on behalf of a user that doesn't have permissions to use the
// action or resource, or specifying an invalid resource identifier.
type ClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) GoString() string {
	return s.String()
}

func newErrorClientException(v protocol.ResponseMetadata) error {
	return &ClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientException) Code() string {
	return "ClientException"
}

// Message returns the exception's message.
func (s *ClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientException) OrigErr() error {
	return nil
}

func (s *ClientException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A detailed view of a component.
type Component struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	Arn *string `locationName:"arn" type:"string"`

	// The change description of the component.
	ChangeDescription *string `locationName:"changeDescription" min:"1" type:"string"`

	// Component data contains the YAML document content for the component.
	Data *string `locationName:"data" type:"string"`

	// The date that Image Builder created the component.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the component.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The encryption status of the component.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The KMS key identifier used to encrypt the component.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the component.
	Name *string `locationName:"name" type:"string"`

	// Indicates whether component source is hidden from view in the console, and
	// from component detail results for API, CLI, or SDK operations.
	Obfuscate *bool `locationName:"obfuscate" type:"boolean"`

	// The owner of the component.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// Contains parameter details for each of the parameters that the component
	// document defined for the component.
	Parameters []*ComponentParameterDetail `locationName:"parameters" type:"list"`

	// The operating system platform of the component.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// Contains the name of the publisher if this is a third-party component. Otherwise,
	// this property is empty.
	Publisher *string `locationName:"publisher" min:"1" type:"string"`

	// Describes the current status of the component. This is used for components
	// that are no longer active.
	State *ComponentState `locationName:"state" type:"structure"`

	// The operating system (OS) version supported by the component. If the OS information
	// is available, Image Builder performs a prefix match against the base image
	// OS version during image recipe creation.
	SupportedOsVersions []*string `locationName:"supportedOsVersions" min:"1" type:"list"`

	// The tags that apply to the component.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The component type specifies whether Image Builder uses the component to
	// build the image or only to test it.
	Type *string `locationName:"type" type:"string" enum:"ComponentType"`

	// The version of the component.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Component) SetArn(v string) *Component {
	s.Arn = &v
	return s
}

// SetChangeDescription sets the ChangeDescription field's value.
func (s *Component) SetChangeDescription(v string) *Component {
	s.ChangeDescription = &v
	return s
}

// SetData sets the Data field's value.
func (s *Component) SetData(v string) *Component {
	s.Data = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *Component) SetDateCreated(v string) *Component {
	s.DateCreated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Component) SetDescription(v string) *Component {
	s.Description = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *Component) SetEncrypted(v bool) *Component {
	s.Encrypted = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Component) SetKmsKeyId(v string) *Component {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Component) SetName(v string) *Component {
	s.Name = &v
	return s
}

// SetObfuscate sets the Obfuscate field's value.
func (s *Component) SetObfuscate(v bool) *Component {
	s.Obfuscate = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Component) SetOwner(v string) *Component {
	s.Owner = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Component) SetParameters(v []*ComponentParameterDetail) *Component {
	s.Parameters = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Component) SetPlatform(v string) *Component {
	s.Platform = &v
	return s
}

// SetPublisher sets the Publisher field's value.
func (s *Component) SetPublisher(v string) *Component {
	s.Publisher = &v
	return s
}

// SetState sets the State field's value.
func (s *Component) SetState(v *ComponentState) *Component {
	s.State = v
	return s
}

// SetSupportedOsVersions sets the SupportedOsVersions field's value.
func (s *Component) SetSupportedOsVersions(v []*string) *Component {
	s.SupportedOsVersions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Component) SetTags(v map[string]*string) *Component {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Component) SetType(v string) *Component {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Component) SetVersion(v string) *Component {
	s.Version = &v
	return s
}

// Configuration details of the component.
type ComponentConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	//
	// ComponentArn is a required field
	ComponentArn *string `locationName:"componentArn" type:"string" required:"true"`

	// A group of parameter settings that Image Builder uses to configure the component
	// for a specific recipe.
	Parameters []*ComponentParameter `locationName:"parameters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentConfiguration"}
	if s.ComponentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentArn"))
	}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentArn sets the ComponentArn field's value.
func (s *ComponentConfiguration) SetComponentArn(v string) *ComponentConfiguration {
	s.ComponentArn = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ComponentConfiguration) SetParameters(v []*ComponentParameter) *ComponentConfiguration {
	s.Parameters = v
	return s
}

// Contains a key/value pair that sets the named component parameter.
type ComponentParameter struct {
	_ struct{} `type:"structure"`

	// The name of the component parameter to set.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Sets the value for the named component parameter.
	//
	// Value is a required field
	Value []*string `locationName:"value" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ComponentParameter) SetName(v string) *ComponentParameter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ComponentParameter) SetValue(v []*string) *ComponentParameter {
	s.Value = v
	return s
}

// Defines a parameter that is used to provide configuration details for the
// component.
type ComponentParameterDetail struct {
	_ struct{} `type:"structure"`

	// The default value of this parameter if no input is provided.
	DefaultValue []*string `locationName:"defaultValue" type:"list"`

	// Describes this parameter.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of this input parameter.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The type of input this parameter provides. The currently supported value
	// is "string".
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentParameterDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentParameterDetail) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ComponentParameterDetail) SetDefaultValue(v []*string) *ComponentParameterDetail {
	s.DefaultValue = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ComponentParameterDetail) SetDescription(v string) *ComponentParameterDetail {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ComponentParameterDetail) SetName(v string) *ComponentParameterDetail {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ComponentParameterDetail) SetType(v string) *ComponentParameterDetail {
	s.Type = &v
	return s
}

// A group of fields that describe the current status of components that are
// no longer active.
type ComponentState struct {
	_ struct{} `type:"structure"`

	// Describes how or why the component changed state.
	Reason *string `locationName:"reason" min:"1" type:"string"`

	// The current state of the component.
	Status *string `locationName:"status" type:"string" enum:"ComponentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentState) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *ComponentState) SetReason(v string) *ComponentState {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ComponentState) SetStatus(v string) *ComponentState {
	s.Status = &v
	return s
}

// A high-level summary of a component.
type ComponentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	Arn *string `locationName:"arn" type:"string"`

	// The change description for the current version of the component.
	ChangeDescription *string `locationName:"changeDescription" min:"1" type:"string"`

	// The original creation date of the component.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the component.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the component.
	Name *string `locationName:"name" type:"string"`

	// Indicates whether component source is hidden from view in the console, and
	// from component detail results for API, CLI, or SDK operations.
	Obfuscate *bool `locationName:"obfuscate" type:"boolean"`

	// The owner of the component.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The operating system platform of the component.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// Contains the name of the publisher if this is a third-party component. Otherwise,
	// this property is empty.
	Publisher *string `locationName:"publisher" min:"1" type:"string"`

	// Describes the current status of the component.
	State *ComponentState `locationName:"state" type:"structure"`

	// The operating system (OS) version that the component supports. If the OS
	// information is available, Image Builder performs a prefix match against the
	// base image OS version during image recipe creation.
	SupportedOsVersions []*string `locationName:"supportedOsVersions" min:"1" type:"list"`

	// The tags that apply to the component.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The component type specifies whether Image Builder uses the component to
	// build the image or only to test it.
	Type *string `locationName:"type" type:"string" enum:"ComponentType"`

	// The version of the component.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ComponentSummary) SetArn(v string) *ComponentSummary {
	s.Arn = &v
	return s
}

// SetChangeDescription sets the ChangeDescription field's value.
func (s *ComponentSummary) SetChangeDescription(v string) *ComponentSummary {
	s.ChangeDescription = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ComponentSummary) SetDateCreated(v string) *ComponentSummary {
	s.DateCreated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ComponentSummary) SetDescription(v string) *ComponentSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ComponentSummary) SetName(v string) *ComponentSummary {
	s.Name = &v
	return s
}

// SetObfuscate sets the Obfuscate field's value.
func (s *ComponentSummary) SetObfuscate(v bool) *ComponentSummary {
	s.Obfuscate = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ComponentSummary) SetOwner(v string) *ComponentSummary {
	s.Owner = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ComponentSummary) SetPlatform(v string) *ComponentSummary {
	s.Platform = &v
	return s
}

// SetPublisher sets the Publisher field's value.
func (s *ComponentSummary) SetPublisher(v string) *ComponentSummary {
	s.Publisher = &v
	return s
}

// SetState sets the State field's value.
func (s *ComponentSummary) SetState(v *ComponentState) *ComponentSummary {
	s.State = v
	return s
}

// SetSupportedOsVersions sets the SupportedOsVersions field's value.
func (s *ComponentSummary) SetSupportedOsVersions(v []*string) *ComponentSummary {
	s.SupportedOsVersions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ComponentSummary) SetTags(v map[string]*string) *ComponentSummary {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ComponentSummary) SetType(v string) *ComponentSummary {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ComponentSummary) SetVersion(v string) *ComponentSummary {
	s.Version = &v
	return s
}

// The defining characteristics of a specific version of an Amazon Web Services
// TOE component.
type ComponentVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	//
	// Semantic versioning is included in each object's Amazon Resource Name (ARN),
	// at the level that applies to that object as follows:
	//
	// Versionless ARNs and Name ARNs do not include specific values in any of the
	// nodes. The nodes are either left off entirely, or they are specified as wildcards,
	// for example: x.x.x.
	//
	// Version ARNs have only the first three nodes: <major>.<minor>.<patch>
	//
	// Build version ARNs have all four nodes, and point to a specific build for
	// a specific version of an object.
	Arn *string `locationName:"arn" type:"string"`

	// The date that the component was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the component.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the component.
	Name *string `locationName:"name" type:"string"`

	// The owner of the component.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The platform of the component.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// he operating system (OS) version supported by the component. If the OS information
	// is available, a prefix match is performed against the base image OS version
	// during image recipe creation.
	SupportedOsVersions []*string `locationName:"supportedOsVersions" min:"1" type:"list"`

	// The type of the component denotes whether the component is used to build
	// the image or only to test it.
	Type *string `locationName:"type" type:"string" enum:"ComponentType"`

	// The semantic version of the component.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth
	// node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose
	// a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base
	// image or components for your recipe. When you use a wildcard in any node,
	// all nodes to the right of the first wildcard must also be wildcards.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentVersion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ComponentVersion) SetArn(v string) *ComponentVersion {
	s.Arn = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ComponentVersion) SetDateCreated(v string) *ComponentVersion {
	s.DateCreated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ComponentVersion) SetDescription(v string) *ComponentVersion {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ComponentVersion) SetName(v string) *ComponentVersion {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ComponentVersion) SetOwner(v string) *ComponentVersion {
	s.Owner = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ComponentVersion) SetPlatform(v string) *ComponentVersion {
	s.Platform = &v
	return s
}

// SetSupportedOsVersions sets the SupportedOsVersions field's value.
func (s *ComponentVersion) SetSupportedOsVersions(v []*string) *ComponentVersion {
	s.SupportedOsVersions = v
	return s
}

// SetType sets the Type field's value.
func (s *ComponentVersion) SetType(v string) *ComponentVersion {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ComponentVersion) SetVersion(v string) *ComponentVersion {
	s.Version = &v
	return s
}

// A container encapsulates the runtime environment for an application.
type Container struct {
	_ struct{} `type:"structure"`

	// A list of URIs for containers created in the context Region.
	ImageUris []*string `locationName:"imageUris" type:"list"`

	// Containers and container images are Region-specific. This is the Region context
	// for the container.
	Region *string `locationName:"region" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Container) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Container) GoString() string {
	return s.String()
}

// SetImageUris sets the ImageUris field's value.
func (s *Container) SetImageUris(v []*string) *Container {
	s.ImageUris = v
	return s
}

// SetRegion sets the Region field's value.
func (s *Container) SetRegion(v string) *Container {
	s.Region = &v
	return s
}

// Container distribution settings for encryption, licensing, and sharing in
// a specific Region.
type ContainerDistributionConfiguration struct {
	_ struct{} `type:"structure"`

	// Tags that are attached to the container distribution configuration.
	ContainerTags []*string `locationName:"containerTags" type:"list"`

	// The description of the container distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The destination repository for the container distribution configuration.
	//
	// TargetRepository is a required field
	TargetRepository *TargetContainerRepository `locationName:"targetRepository" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerDistributionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerDistributionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDistributionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerDistributionConfiguration"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.TargetRepository == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetRepository"))
	}
	if s.TargetRepository != nil {
		if err := s.TargetRepository.Validate(); err != nil {
			invalidParams.AddNested("TargetRepository", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerTags sets the ContainerTags field's value.
func (s *ContainerDistributionConfiguration) SetContainerTags(v []*string) *ContainerDistributionConfiguration {
	s.ContainerTags = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ContainerDistributionConfiguration) SetDescription(v string) *ContainerDistributionConfiguration {
	s.Description = &v
	return s
}

// SetTargetRepository sets the TargetRepository field's value.
func (s *ContainerDistributionConfiguration) SetTargetRepository(v *TargetContainerRepository) *ContainerDistributionConfiguration {
	s.TargetRepository = v
	return s
}

// A container recipe.
type ContainerRecipe struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container recipe.
	//
	// Semantic versioning is included in each object's Amazon Resource Name (ARN),
	// at the level that applies to that object as follows:
	//
	// Versionless ARNs and Name ARNs do not include specific values in any of the
	// nodes. The nodes are either left off entirely, or they are specified as wildcards,
	// for example: x.x.x.
	//
	// Version ARNs have only the first three nodes: <major>.<minor>.<patch>
	//
	// Build version ARNs have all four nodes, and point to a specific build for
	// a specific version of an object.
	Arn *string `locationName:"arn" type:"string"`

	// Build and test components that are included in the container recipe. Recipes
	// require a minimum of one build component, and can have a maximum of 20 build
	// and test components in any combination.
	Components []*ComponentConfiguration `locationName:"components" min:"1" type:"list"`

	// Specifies the type of container, such as Docker.
	ContainerType *string `locationName:"containerType" type:"string" enum:"ContainerType"`

	// The date when this container recipe was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the container recipe.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Dockerfiles are text documents that are used to build Docker containers,
	// and ensure that they contain all of the elements required by the application
	// running inside. The template data consists of contextual variables where
	// Image Builder places build information or scripts, based on your container
	// image recipe.
	DockerfileTemplateData *string `locationName:"dockerfileTemplateData" type:"string"`

	// A flag that indicates if the target container is encrypted.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// A group of options that can be used to configure an instance for building
	// and testing container images.
	InstanceConfiguration *InstanceConfiguration `locationName:"instanceConfiguration" type:"structure"`

	// Identifies which KMS key is used to encrypt the container image for distribution
	// to the target Region.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the container recipe.
	Name *string `locationName:"name" type:"string"`

	// The owner of the container recipe.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The base image for the container recipe.
	ParentImage *string `locationName:"parentImage" min:"1" type:"string"`

	// The system platform for the container, such as Windows or Linux.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// Tags that are attached to the container recipe.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The destination repository for the container image.
	TargetRepository *TargetContainerRepository `locationName:"targetRepository" type:"structure"`

	// The semantic version of the container recipe.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth
	// node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose
	// a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base
	// image or components for your recipe. When you use a wildcard in any node,
	// all nodes to the right of the first wildcard must also be wildcards.
	Version *string `locationName:"version" type:"string"`

	// The working directory for use during build and test workflows.
	WorkingDirectory *string `locationName:"workingDirectory" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerRecipe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerRecipe) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContainerRecipe) SetArn(v string) *ContainerRecipe {
	s.Arn = &v
	return s
}

// SetComponents sets the Components field's value.
func (s *ContainerRecipe) SetComponents(v []*ComponentConfiguration) *ContainerRecipe {
	s.Components = v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *ContainerRecipe) SetContainerType(v string) *ContainerRecipe {
	s.ContainerType = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ContainerRecipe) SetDateCreated(v string) *ContainerRecipe {
	s.DateCreated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ContainerRecipe) SetDescription(v string) *ContainerRecipe {
	s.Description = &v
	return s
}

// SetDockerfileTemplateData sets the DockerfileTemplateData field's value.
func (s *ContainerRecipe) SetDockerfileTemplateData(v string) *ContainerRecipe {
	s.DockerfileTemplateData = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *ContainerRecipe) SetEncrypted(v bool) *ContainerRecipe {
	s.Encrypted = &v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *ContainerRecipe) SetInstanceConfiguration(v *InstanceConfiguration) *ContainerRecipe {
	s.InstanceConfiguration = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ContainerRecipe) SetKmsKeyId(v string) *ContainerRecipe {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerRecipe) SetName(v string) *ContainerRecipe {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ContainerRecipe) SetOwner(v string) *ContainerRecipe {
	s.Owner = &v
	return s
}

// SetParentImage sets the ParentImage field's value.
func (s *ContainerRecipe) SetParentImage(v string) *ContainerRecipe {
	s.ParentImage = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ContainerRecipe) SetPlatform(v string) *ContainerRecipe {
	s.Platform = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContainerRecipe) SetTags(v map[string]*string) *ContainerRecipe {
	s.Tags = v
	return s
}

// SetTargetRepository sets the TargetRepository field's value.
func (s *ContainerRecipe) SetTargetRepository(v *TargetContainerRepository) *ContainerRecipe {
	s.TargetRepository = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ContainerRecipe) SetVersion(v string) *ContainerRecipe {
	s.Version = &v
	return s
}

// SetWorkingDirectory sets the WorkingDirectory field's value.
func (s *ContainerRecipe) SetWorkingDirectory(v string) *ContainerRecipe {
	s.WorkingDirectory = &v
	return s
}

// A summary of a container recipe
type ContainerRecipeSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container recipe.
	Arn *string `locationName:"arn" type:"string"`

	// Specifies the type of container, such as "Docker".
	ContainerType *string `locationName:"containerType" type:"string" enum:"ContainerType"`

	// The date when this container recipe was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The name of the container recipe.
	Name *string `locationName:"name" type:"string"`

	// The owner of the container recipe.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The base image for the container recipe.
	ParentImage *string `locationName:"parentImage" min:"1" type:"string"`

	// The system platform for the container, such as Windows or Linux.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// Tags that are attached to the container recipe.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerRecipeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainerRecipeSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContainerRecipeSummary) SetArn(v string) *ContainerRecipeSummary {
	s.Arn = &v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *ContainerRecipeSummary) SetContainerType(v string) *ContainerRecipeSummary {
	s.ContainerType = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ContainerRecipeSummary) SetDateCreated(v string) *ContainerRecipeSummary {
	s.DateCreated = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerRecipeSummary) SetName(v string) *ContainerRecipeSummary {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ContainerRecipeSummary) SetOwner(v string) *ContainerRecipeSummary {
	s.Owner = &v
	return s
}

// SetParentImage sets the ParentImage field's value.
func (s *ContainerRecipeSummary) SetParentImage(v string) *ContainerRecipeSummary {
	s.ParentImage = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ContainerRecipeSummary) SetPlatform(v string) *ContainerRecipeSummary {
	s.Platform = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContainerRecipeSummary) SetTags(v map[string]*string) *ContainerRecipeSummary {
	s.Tags = v
	return s
}

type CreateComponentInput struct {
	_ struct{} `type:"structure"`

	// The change description of the component. Describes what change has been made
	// in this version, or what makes this version different from other versions
	// of this component.
	ChangeDescription *string `locationName:"changeDescription" min:"1" type:"string"`

	// The idempotency token of the component.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Component data contains inline YAML document content for the component. Alternatively,
	// you can specify the uri of a YAML document file stored in Amazon S3. However,
	// you cannot specify both properties.
	Data *string `locationName:"data" min:"1" type:"string"`

	// Describes the contents of the component.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the KMS key that is used to encrypt this component.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the component.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The operating system platform of the component.
	//
	// Platform is a required field
	Platform *string `locationName:"platform" type:"string" required:"true" enum:"Platform"`

	// The semantic version of the component. This version follows the semantic
	// version syntax.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth
	// node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose
	// a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// The operating system (OS) version supported by the component. If the OS information
	// is available, a prefix match is performed against the base image OS version
	// during image recipe creation.
	SupportedOsVersions []*string `locationName:"supportedOsVersions" min:"1" type:"list"`

	// The tags that apply to the component.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The uri of a YAML component document file. This must be an S3 URL (s3://bucket/key),
	// and the requester must have permission to access the S3 bucket it points
	// to. If you use Amazon S3, you can specify component content up to your service
	// quota.
	//
	// Alternatively, you can specify the YAML document inline, using the component
	// data property. You cannot specify both properties.
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComponentInput"}
	if s.ChangeDescription != nil && len(*s.ChangeDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeDescription", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Data != nil && len(*s.Data) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Data", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}
	if s.SemanticVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SemanticVersion"))
	}
	if s.SupportedOsVersions != nil && len(s.SupportedOsVersions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupportedOsVersions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeDescription sets the ChangeDescription field's value.
func (s *CreateComponentInput) SetChangeDescription(v string) *CreateComponentInput {
	s.ChangeDescription = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateComponentInput) SetClientToken(v string) *CreateComponentInput {
	s.ClientToken = &v
	return s
}

// SetData sets the Data field's value.
func (s *CreateComponentInput) SetData(v string) *CreateComponentInput {
	s.Data = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateComponentInput) SetDescription(v string) *CreateComponentInput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateComponentInput) SetKmsKeyId(v string) *CreateComponentInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateComponentInput) SetName(v string) *CreateComponentInput {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *CreateComponentInput) SetPlatform(v string) *CreateComponentInput {
	s.Platform = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateComponentInput) SetSemanticVersion(v string) *CreateComponentInput {
	s.SemanticVersion = &v
	return s
}

// SetSupportedOsVersions sets the SupportedOsVersions field's value.
func (s *CreateComponentInput) SetSupportedOsVersions(v []*string) *CreateComponentInput {
	s.SupportedOsVersions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateComponentInput) SetTags(v map[string]*string) *CreateComponentInput {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *CreateComponentInput) SetUri(v string) *CreateComponentInput {
	s.Uri = &v
	return s
}

type CreateComponentOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the component that was created by this
	// request.
	ComponentBuildVersionArn *string `locationName:"componentBuildVersionArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateComponentOutput) SetClientToken(v string) *CreateComponentOutput {
	s.ClientToken = &v
	return s
}

// SetComponentBuildVersionArn sets the ComponentBuildVersionArn field's value.
func (s *CreateComponentOutput) SetComponentBuildVersionArn(v string) *CreateComponentOutput {
	s.ComponentBuildVersionArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateComponentOutput) SetRequestId(v string) *CreateComponentOutput {
	s.RequestId = &v
	return s
}

type CreateContainerRecipeInput struct {
	_ struct{} `type:"structure"`

	// The client token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Components for build and test that are included in the container recipe.
	// Recipes require a minimum of one build component, and can have a maximum
	// of 20 build and test components in any combination.
	//
	// Components is a required field
	Components []*ComponentConfiguration `locationName:"components" min:"1" type:"list" required:"true"`

	// The type of container to create.
	//
	// ContainerType is a required field
	ContainerType *string `locationName:"containerType" type:"string" required:"true" enum:"ContainerType"`

	// The description of the container recipe.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Dockerfile template used to build your image as an inline data blob.
	DockerfileTemplateData *string `locationName:"dockerfileTemplateData" min:"1" type:"string"`

	// The Amazon S3 URI for the Dockerfile that will be used to build your container
	// image.
	DockerfileTemplateUri *string `locationName:"dockerfileTemplateUri" type:"string"`

	// Specifies the operating system version for the base image.
	ImageOsVersionOverride *string `locationName:"imageOsVersionOverride" min:"1" type:"string"`

	// A group of options that can be used to configure an instance for building
	// and testing container images.
	InstanceConfiguration *InstanceConfiguration `locationName:"instanceConfiguration" type:"structure"`

	// Identifies which KMS key is used to encrypt the container image.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the container recipe.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The base image for the container recipe.
	//
	// ParentImage is a required field
	ParentImage *string `locationName:"parentImage" min:"1" type:"string" required:"true"`

	// Specifies the operating system platform when you use a custom base image.
	PlatformOverride *string `locationName:"platformOverride" type:"string" enum:"Platform"`

	// The semantic version of the container recipe. This version follows the semantic
	// version syntax.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth
	// node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose
	// a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// Tags that are attached to the container recipe.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The destination repository for the container image.
	//
	// TargetRepository is a required field
	TargetRepository *TargetContainerRepository `locationName:"targetRepository" type:"structure" required:"true"`

	// The working directory for use during build and test workflows.
	WorkingDirectory *string `locationName:"workingDirectory" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContainerRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContainerRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContainerRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContainerRecipeInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Components == nil {
		invalidParams.Add(request.NewErrParamRequired("Components"))
	}
	if s.Components != nil && len(s.Components) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Components", 1))
	}
	if s.ContainerType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerType"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DockerfileTemplateData != nil && len(*s.DockerfileTemplateData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DockerfileTemplateData", 1))
	}
	if s.ImageOsVersionOverride != nil && len(*s.ImageOsVersionOverride) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageOsVersionOverride", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ParentImage == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentImage"))
	}
	if s.ParentImage != nil && len(*s.ParentImage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentImage", 1))
	}
	if s.SemanticVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SemanticVersion"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TargetRepository == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetRepository"))
	}
	if s.WorkingDirectory != nil && len(*s.WorkingDirectory) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkingDirectory", 1))
	}
	if s.Components != nil {
		for i, v := range s.Components {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Components", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InstanceConfiguration != nil {
		if err := s.InstanceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InstanceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetRepository != nil {
		if err := s.TargetRepository.Validate(); err != nil {
			invalidParams.AddNested("TargetRepository", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateContainerRecipeInput) SetClientToken(v string) *CreateContainerRecipeInput {
	s.ClientToken = &v
	return s
}

// SetComponents sets the Components field's value.
func (s *CreateContainerRecipeInput) SetComponents(v []*ComponentConfiguration) *CreateContainerRecipeInput {
	s.Components = v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *CreateContainerRecipeInput) SetContainerType(v string) *CreateContainerRecipeInput {
	s.ContainerType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateContainerRecipeInput) SetDescription(v string) *CreateContainerRecipeInput {
	s.Description = &v
	return s
}

// SetDockerfileTemplateData sets the DockerfileTemplateData field's value.
func (s *CreateContainerRecipeInput) SetDockerfileTemplateData(v string) *CreateContainerRecipeInput {
	s.DockerfileTemplateData = &v
	return s
}

// SetDockerfileTemplateUri sets the DockerfileTemplateUri field's value.
func (s *CreateContainerRecipeInput) SetDockerfileTemplateUri(v string) *CreateContainerRecipeInput {
	s.DockerfileTemplateUri = &v
	return s
}

// SetImageOsVersionOverride sets the ImageOsVersionOverride field's value.
func (s *CreateContainerRecipeInput) SetImageOsVersionOverride(v string) *CreateContainerRecipeInput {
	s.ImageOsVersionOverride = &v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *CreateContainerRecipeInput) SetInstanceConfiguration(v *InstanceConfiguration) *CreateContainerRecipeInput {
	s.InstanceConfiguration = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateContainerRecipeInput) SetKmsKeyId(v string) *CreateContainerRecipeInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateContainerRecipeInput) SetName(v string) *CreateContainerRecipeInput {
	s.Name = &v
	return s
}

// SetParentImage sets the ParentImage field's value.
func (s *CreateContainerRecipeInput) SetParentImage(v string) *CreateContainerRecipeInput {
	s.ParentImage = &v
	return s
}

// SetPlatformOverride sets the PlatformOverride field's value.
func (s *CreateContainerRecipeInput) SetPlatformOverride(v string) *CreateContainerRecipeInput {
	s.PlatformOverride = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateContainerRecipeInput) SetSemanticVersion(v string) *CreateContainerRecipeInput {
	s.SemanticVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContainerRecipeInput) SetTags(v map[string]*string) *CreateContainerRecipeInput {
	s.Tags = v
	return s
}

// SetTargetRepository sets the TargetRepository field's value.
func (s *CreateContainerRecipeInput) SetTargetRepository(v *TargetContainerRepository) *CreateContainerRecipeInput {
	s.TargetRepository = v
	return s
}

// SetWorkingDirectory sets the WorkingDirectory field's value.
func (s *CreateContainerRecipeInput) SetWorkingDirectory(v string) *CreateContainerRecipeInput {
	s.WorkingDirectory = &v
	return s
}

type CreateContainerRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The client token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// Returns the Amazon Resource Name (ARN) of the container recipe that the request
	// created.
	ContainerRecipeArn *string `locationName:"containerRecipeArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContainerRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContainerRecipeOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateContainerRecipeOutput) SetClientToken(v string) *CreateContainerRecipeOutput {
	s.ClientToken = &v
	return s
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *CreateContainerRecipeOutput) SetContainerRecipeArn(v string) *CreateContainerRecipeOutput {
	s.ContainerRecipeArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateContainerRecipeOutput) SetRequestId(v string) *CreateContainerRecipeOutput {
	s.RequestId = &v
	return s
}

type CreateDistributionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token of the distribution configuration.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The distributions of the distribution configuration.
	//
	// Distributions is a required field
	Distributions []*Distribution `locationName:"distributions" type:"list" required:"true"`

	// The name of the distribution configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The tags of the distribution configuration.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDistributionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDistributionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDistributionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDistributionConfigurationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Distributions == nil {
		invalidParams.Add(request.NewErrParamRequired("Distributions"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Distributions != nil {
		for i, v := range s.Distributions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Distributions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDistributionConfigurationInput) SetClientToken(v string) *CreateDistributionConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDistributionConfigurationInput) SetDescription(v string) *CreateDistributionConfigurationInput {
	s.Description = &v
	return s
}

// SetDistributions sets the Distributions field's value.
func (s *CreateDistributionConfigurationInput) SetDistributions(v []*Distribution) *CreateDistributionConfigurationInput {
	s.Distributions = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDistributionConfigurationInput) SetName(v string) *CreateDistributionConfigurationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDistributionConfigurationInput) SetTags(v map[string]*string) *CreateDistributionConfigurationInput {
	s.Tags = v
	return s
}

type CreateDistributionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration that was
	// created by this request.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDistributionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDistributionConfigurationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDistributionConfigurationOutput) SetClientToken(v string) *CreateDistributionConfigurationOutput {
	s.ClientToken = &v
	return s
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *CreateDistributionConfigurationOutput) SetDistributionConfigurationArn(v string) *CreateDistributionConfigurationOutput {
	s.DistributionConfigurationArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDistributionConfigurationOutput) SetRequestId(v string) *CreateDistributionConfigurationOutput {
	s.RequestId = &v
	return s
}

type CreateImageInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the container recipe that defines how images
	// are configured and tested.
	ContainerRecipeArn *string `locationName:"containerRecipeArn" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration that defines
	// and configures the outputs of your pipeline.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// Collects additional information about the image being created, including
	// the operating system (OS) version and package list. This information is used
	// to enhance the overall experience of using EC2 Image Builder. Enabled by
	// default.
	EnhancedImageMetadataEnabled *bool `locationName:"enhancedImageMetadataEnabled" type:"boolean"`

	// The Amazon Resource Name (ARN) of the image recipe that defines how images
	// are configured, tested, and assessed.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The image tests configuration of the image.
	ImageTestsConfiguration *ImageTestsConfiguration `locationName:"imageTestsConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that defines
	// the environment in which your image will be built and tested.
	//
	// InfrastructureConfigurationArn is a required field
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string" required:"true"`

	// The tags of the image.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImageInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.InfrastructureConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InfrastructureConfigurationArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ImageTestsConfiguration != nil {
		if err := s.ImageTestsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ImageTestsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateImageInput) SetClientToken(v string) *CreateImageInput {
	s.ClientToken = &v
	return s
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *CreateImageInput) SetContainerRecipeArn(v string) *CreateImageInput {
	s.ContainerRecipeArn = &v
	return s
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *CreateImageInput) SetDistributionConfigurationArn(v string) *CreateImageInput {
	s.DistributionConfigurationArn = &v
	return s
}

// SetEnhancedImageMetadataEnabled sets the EnhancedImageMetadataEnabled field's value.
func (s *CreateImageInput) SetEnhancedImageMetadataEnabled(v bool) *CreateImageInput {
	s.EnhancedImageMetadataEnabled = &v
	return s
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *CreateImageInput) SetImageRecipeArn(v string) *CreateImageInput {
	s.ImageRecipeArn = &v
	return s
}

// SetImageTestsConfiguration sets the ImageTestsConfiguration field's value.
func (s *CreateImageInput) SetImageTestsConfiguration(v *ImageTestsConfiguration) *CreateImageInput {
	s.ImageTestsConfiguration = v
	return s
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *CreateImageInput) SetInfrastructureConfigurationArn(v string) *CreateImageInput {
	s.InfrastructureConfigurationArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateImageInput) SetTags(v map[string]*string) *CreateImageInput {
	s.Tags = v
	return s
}

type CreateImageOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the image that was created by this request.
	ImageBuildVersionArn *string `locationName:"imageBuildVersionArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImageOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateImageOutput) SetClientToken(v string) *CreateImageOutput {
	s.ClientToken = &v
	return s
}

// SetImageBuildVersionArn sets the ImageBuildVersionArn field's value.
func (s *CreateImageOutput) SetImageBuildVersionArn(v string) *CreateImageOutput {
	s.ImageBuildVersionArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateImageOutput) SetRequestId(v string) *CreateImageOutput {
	s.RequestId = &v
	return s
}

type CreateImagePipelineInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the container recipe that is used to configure
	// images created by this container pipeline.
	ContainerRecipeArn *string `locationName:"containerRecipeArn" type:"string"`

	// The description of the image pipeline.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration that will
	// be used to configure and distribute images created by this image pipeline.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// Collects additional information about the image being created, including
	// the operating system (OS) version and package list. This information is used
	// to enhance the overall experience of using EC2 Image Builder. Enabled by
	// default.
	EnhancedImageMetadataEnabled *bool `locationName:"enhancedImageMetadataEnabled" type:"boolean"`

	// The Amazon Resource Name (ARN) of the image recipe that will be used to configure
	// images created by this image pipeline.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The image test configuration of the image pipeline.
	ImageTestsConfiguration *ImageTestsConfiguration `locationName:"imageTestsConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that will
	// be used to build images created by this image pipeline.
	//
	// InfrastructureConfigurationArn is a required field
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string" required:"true"`

	// The name of the image pipeline.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The schedule of the image pipeline.
	Schedule *Schedule `locationName:"schedule" type:"structure"`

	// The status of the image pipeline.
	Status *string `locationName:"status" type:"string" enum:"PipelineStatus"`

	// The tags of the image pipeline.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImagePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImagePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImagePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImagePipelineInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InfrastructureConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InfrastructureConfigurationArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ImageTestsConfiguration != nil {
		if err := s.ImageTestsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ImageTestsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateImagePipelineInput) SetClientToken(v string) *CreateImagePipelineInput {
	s.ClientToken = &v
	return s
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *CreateImagePipelineInput) SetContainerRecipeArn(v string) *CreateImagePipelineInput {
	s.ContainerRecipeArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateImagePipelineInput) SetDescription(v string) *CreateImagePipelineInput {
	s.Description = &v
	return s
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *CreateImagePipelineInput) SetDistributionConfigurationArn(v string) *CreateImagePipelineInput {
	s.DistributionConfigurationArn = &v
	return s
}

// SetEnhancedImageMetadataEnabled sets the EnhancedImageMetadataEnabled field's value.
func (s *CreateImagePipelineInput) SetEnhancedImageMetadataEnabled(v bool) *CreateImagePipelineInput {
	s.EnhancedImageMetadataEnabled = &v
	return s
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *CreateImagePipelineInput) SetImageRecipeArn(v string) *CreateImagePipelineInput {
	s.ImageRecipeArn = &v
	return s
}

// SetImageTestsConfiguration sets the ImageTestsConfiguration field's value.
func (s *CreateImagePipelineInput) SetImageTestsConfiguration(v *ImageTestsConfiguration) *CreateImagePipelineInput {
	s.ImageTestsConfiguration = v
	return s
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *CreateImagePipelineInput) SetInfrastructureConfigurationArn(v string) *CreateImagePipelineInput {
	s.InfrastructureConfigurationArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateImagePipelineInput) SetName(v string) *CreateImagePipelineInput {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateImagePipelineInput) SetSchedule(v *Schedule) *CreateImagePipelineInput {
	s.Schedule = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateImagePipelineInput) SetStatus(v string) *CreateImagePipelineInput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateImagePipelineInput) SetTags(v map[string]*string) *CreateImagePipelineInput {
	s.Tags = v
	return s
}

type CreateImagePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the image pipeline that was created by
	// this request.
	ImagePipelineArn *string `locationName:"imagePipelineArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImagePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImagePipelineOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateImagePipelineOutput) SetClientToken(v string) *CreateImagePipelineOutput {
	s.ClientToken = &v
	return s
}

// SetImagePipelineArn sets the ImagePipelineArn field's value.
func (s *CreateImagePipelineOutput) SetImagePipelineArn(v string) *CreateImagePipelineOutput {
	s.ImagePipelineArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateImagePipelineOutput) SetRequestId(v string) *CreateImagePipelineOutput {
	s.RequestId = &v
	return s
}

type CreateImageRecipeInput struct {
	_ struct{} `type:"structure"`

	// Specify additional settings and launch scripts for your build instances.
	AdditionalInstanceConfiguration *AdditionalInstanceConfiguration `locationName:"additionalInstanceConfiguration" type:"structure"`

	// The block device mappings of the image recipe.
	BlockDeviceMappings []*InstanceBlockDeviceMapping `locationName:"blockDeviceMappings" type:"list"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The components included in the image recipe.
	//
	// Components is a required field
	Components []*ComponentConfiguration `locationName:"components" min:"1" type:"list" required:"true"`

	// The description of the image recipe.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the image recipe.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The base image of the image recipe. The value of the string can be the ARN
	// of the base image or an AMI ID. The format for the ARN follows this example:
	// arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x.
	// You can provide the specific version that you want to use, or you can use
	// a wildcard in all of the fields. If you enter an AMI ID for the string value,
	// you must have access to the AMI, and the AMI must be in the same Region in
	// which you are using Image Builder.
	//
	// ParentImage is a required field
	ParentImage *string `locationName:"parentImage" min:"1" type:"string" required:"true"`

	// The semantic version of the image recipe. This version follows the semantic
	// version syntax.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth
	// node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose
	// a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// The tags of the image recipe.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The working directory used during build and test workflows.
	WorkingDirectory *string `locationName:"workingDirectory" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImageRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImageRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImageRecipeInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Components == nil {
		invalidParams.Add(request.NewErrParamRequired("Components"))
	}
	if s.Components != nil && len(s.Components) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Components", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ParentImage == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentImage"))
	}
	if s.ParentImage != nil && len(*s.ParentImage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentImage", 1))
	}
	if s.SemanticVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SemanticVersion"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.WorkingDirectory != nil && len(*s.WorkingDirectory) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkingDirectory", 1))
	}
	if s.AdditionalInstanceConfiguration != nil {
		if err := s.AdditionalInstanceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AdditionalInstanceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.BlockDeviceMappings != nil {
		for i, v := range s.BlockDeviceMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BlockDeviceMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Components != nil {
		for i, v := range s.Components {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Components", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInstanceConfiguration sets the AdditionalInstanceConfiguration field's value.
func (s *CreateImageRecipeInput) SetAdditionalInstanceConfiguration(v *AdditionalInstanceConfiguration) *CreateImageRecipeInput {
	s.AdditionalInstanceConfiguration = v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *CreateImageRecipeInput) SetBlockDeviceMappings(v []*InstanceBlockDeviceMapping) *CreateImageRecipeInput {
	s.BlockDeviceMappings = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateImageRecipeInput) SetClientToken(v string) *CreateImageRecipeInput {
	s.ClientToken = &v
	return s
}

// SetComponents sets the Components field's value.
func (s *CreateImageRecipeInput) SetComponents(v []*ComponentConfiguration) *CreateImageRecipeInput {
	s.Components = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateImageRecipeInput) SetDescription(v string) *CreateImageRecipeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateImageRecipeInput) SetName(v string) *CreateImageRecipeInput {
	s.Name = &v
	return s
}

// SetParentImage sets the ParentImage field's value.
func (s *CreateImageRecipeInput) SetParentImage(v string) *CreateImageRecipeInput {
	s.ParentImage = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *CreateImageRecipeInput) SetSemanticVersion(v string) *CreateImageRecipeInput {
	s.SemanticVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateImageRecipeInput) SetTags(v map[string]*string) *CreateImageRecipeInput {
	s.Tags = v
	return s
}

// SetWorkingDirectory sets the WorkingDirectory field's value.
func (s *CreateImageRecipeInput) SetWorkingDirectory(v string) *CreateImageRecipeInput {
	s.WorkingDirectory = &v
	return s
}

type CreateImageRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the image recipe that was created by this
	// request.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImageRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateImageRecipeOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateImageRecipeOutput) SetClientToken(v string) *CreateImageRecipeOutput {
	s.ClientToken = &v
	return s
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *CreateImageRecipeOutput) SetImageRecipeArn(v string) *CreateImageRecipeOutput {
	s.ImageRecipeArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateImageRecipeOutput) SetRequestId(v string) *CreateImageRecipeOutput {
	s.RequestId = &v
	return s
}

type CreateInfrastructureConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the infrastructure configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The instance metadata options that you can set for the HTTP requests that
	// pipeline builds use to launch EC2 build and test instances.
	InstanceMetadataOptions *InstanceMetadataOptions `locationName:"instanceMetadataOptions" type:"structure"`

	// The instance profile to associate with the instance used to customize your
	// Amazon EC2 AMI.
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `locationName:"instanceProfileName" min:"1" type:"string" required:"true"`

	// The instance types of the infrastructure configuration. You can specify one
	// or more instance types to use for this build. The service will pick one of
	// these instance types based on availability.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The key pair of the infrastructure configuration. You can use this to log
	// on to and debug the instance used to create your image.
	KeyPair *string `locationName:"keyPair" min:"1" type:"string"`

	// The logging configuration of the infrastructure configuration.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the infrastructure configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The tags attached to the resource created by Image Builder.
	ResourceTags map[string]*string `locationName:"resourceTags" min:"1" type:"map"`

	// The security group IDs to associate with the instance used to customize your
	// Amazon EC2 AMI.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The Amazon Resource Name (ARN) for the SNS topic to which we send image build
	// event notifications.
	//
	// EC2 Image Builder is unable to send notifications to SNS topics that are
	// encrypted using keys from other accounts. The key that is used to encrypt
	// the SNS topic must reside in the account that the Image Builder service runs
	// under.
	SnsTopicArn *string `locationName:"snsTopicArn" type:"string"`

	// The subnet ID in which to place the instance used to customize your Amazon
	// EC2 AMI.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`

	// The tags of the infrastructure configuration.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The terminate instance on failure setting of the infrastructure configuration.
	// Set to false if you want Image Builder to retain the instance used to configure
	// your AMI if the build or test phase of your workflow fails.
	TerminateInstanceOnFailure *bool `locationName:"terminateInstanceOnFailure" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInfrastructureConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInfrastructureConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInfrastructureConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInfrastructureConfigurationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceProfileName", 1))
	}
	if s.KeyPair != nil && len(*s.KeyPair) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyPair", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ResourceTags != nil && len(s.ResourceTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTags", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.InstanceMetadataOptions != nil {
		if err := s.InstanceMetadataOptions.Validate(); err != nil {
			invalidParams.AddNested("InstanceMetadataOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateInfrastructureConfigurationInput) SetClientToken(v string) *CreateInfrastructureConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateInfrastructureConfigurationInput) SetDescription(v string) *CreateInfrastructureConfigurationInput {
	s.Description = &v
	return s
}

// SetInstanceMetadataOptions sets the InstanceMetadataOptions field's value.
func (s *CreateInfrastructureConfigurationInput) SetInstanceMetadataOptions(v *InstanceMetadataOptions) *CreateInfrastructureConfigurationInput {
	s.InstanceMetadataOptions = v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *CreateInfrastructureConfigurationInput) SetInstanceProfileName(v string) *CreateInfrastructureConfigurationInput {
	s.InstanceProfileName = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *CreateInfrastructureConfigurationInput) SetInstanceTypes(v []*string) *CreateInfrastructureConfigurationInput {
	s.InstanceTypes = v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateInfrastructureConfigurationInput) SetKeyPair(v string) *CreateInfrastructureConfigurationInput {
	s.KeyPair = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *CreateInfrastructureConfigurationInput) SetLogging(v *Logging) *CreateInfrastructureConfigurationInput {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInfrastructureConfigurationInput) SetName(v string) *CreateInfrastructureConfigurationInput {
	s.Name = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateInfrastructureConfigurationInput) SetResourceTags(v map[string]*string) *CreateInfrastructureConfigurationInput {
	s.ResourceTags = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateInfrastructureConfigurationInput) SetSecurityGroupIds(v []*string) *CreateInfrastructureConfigurationInput {
	s.SecurityGroupIds = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateInfrastructureConfigurationInput) SetSnsTopicArn(v string) *CreateInfrastructureConfigurationInput {
	s.SnsTopicArn = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateInfrastructureConfigurationInput) SetSubnetId(v string) *CreateInfrastructureConfigurationInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInfrastructureConfigurationInput) SetTags(v map[string]*string) *CreateInfrastructureConfigurationInput {
	s.Tags = v
	return s
}

// SetTerminateInstanceOnFailure sets the TerminateInstanceOnFailure field's value.
func (s *CreateInfrastructureConfigurationInput) SetTerminateInstanceOnFailure(v bool) *CreateInfrastructureConfigurationInput {
	s.TerminateInstanceOnFailure = &v
	return s
}

type CreateInfrastructureConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that was
	// created by this request.
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInfrastructureConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInfrastructureConfigurationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateInfrastructureConfigurationOutput) SetClientToken(v string) *CreateInfrastructureConfigurationOutput {
	s.ClientToken = &v
	return s
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *CreateInfrastructureConfigurationOutput) SetInfrastructureConfigurationArn(v string) *CreateInfrastructureConfigurationOutput {
	s.InfrastructureConfigurationArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateInfrastructureConfigurationOutput) SetRequestId(v string) *CreateInfrastructureConfigurationOutput {
	s.RequestId = &v
	return s
}

type DeleteComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the component build version to delete.
	//
	// ComponentBuildVersionArn is a required field
	ComponentBuildVersionArn *string `location:"querystring" locationName:"componentBuildVersionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComponentInput"}
	if s.ComponentBuildVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentBuildVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentBuildVersionArn sets the ComponentBuildVersionArn field's value.
func (s *DeleteComponentInput) SetComponentBuildVersionArn(v string) *DeleteComponentInput {
	s.ComponentBuildVersionArn = &v
	return s
}

type DeleteComponentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component build version that was deleted.
	ComponentBuildVersionArn *string `locationName:"componentBuildVersionArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentOutput) GoString() string {
	return s.String()
}

// SetComponentBuildVersionArn sets the ComponentBuildVersionArn field's value.
func (s *DeleteComponentOutput) SetComponentBuildVersionArn(v string) *DeleteComponentOutput {
	s.ComponentBuildVersionArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteComponentOutput) SetRequestId(v string) *DeleteComponentOutput {
	s.RequestId = &v
	return s
}

type DeleteContainerRecipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the container recipe to delete.
	//
	// ContainerRecipeArn is a required field
	ContainerRecipeArn *string `location:"querystring" locationName:"containerRecipeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContainerRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContainerRecipeInput"}
	if s.ContainerRecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerRecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *DeleteContainerRecipeInput) SetContainerRecipeArn(v string) *DeleteContainerRecipeInput {
	s.ContainerRecipeArn = &v
	return s
}

type DeleteContainerRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container recipe that was deleted.
	ContainerRecipeArn *string `locationName:"containerRecipeArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContainerRecipeOutput) GoString() string {
	return s.String()
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *DeleteContainerRecipeOutput) SetContainerRecipeArn(v string) *DeleteContainerRecipeOutput {
	s.ContainerRecipeArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteContainerRecipeOutput) SetRequestId(v string) *DeleteContainerRecipeOutput {
	s.RequestId = &v
	return s
}

type DeleteDistributionConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the distribution configuration to delete.
	//
	// DistributionConfigurationArn is a required field
	DistributionConfigurationArn *string `location:"querystring" locationName:"distributionConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDistributionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDistributionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDistributionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDistributionConfigurationInput"}
	if s.DistributionConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *DeleteDistributionConfigurationInput) SetDistributionConfigurationArn(v string) *DeleteDistributionConfigurationInput {
	s.DistributionConfigurationArn = &v
	return s
}

type DeleteDistributionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the distribution configuration that was
	// deleted.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDistributionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDistributionConfigurationOutput) GoString() string {
	return s.String()
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *DeleteDistributionConfigurationOutput) SetDistributionConfigurationArn(v string) *DeleteDistributionConfigurationOutput {
	s.DistributionConfigurationArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteDistributionConfigurationOutput) SetRequestId(v string) *DeleteDistributionConfigurationOutput {
	s.RequestId = &v
	return s
}

type DeleteImageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Image Builder image resource to delete.
	//
	// ImageBuildVersionArn is a required field
	ImageBuildVersionArn *string `location:"querystring" locationName:"imageBuildVersionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImageInput"}
	if s.ImageBuildVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageBuildVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageBuildVersionArn sets the ImageBuildVersionArn field's value.
func (s *DeleteImageInput) SetImageBuildVersionArn(v string) *DeleteImageInput {
	s.ImageBuildVersionArn = &v
	return s
}

type DeleteImageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Image Builder image resource that was
	// deleted.
	ImageBuildVersionArn *string `locationName:"imageBuildVersionArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageOutput) GoString() string {
	return s.String()
}

// SetImageBuildVersionArn sets the ImageBuildVersionArn field's value.
func (s *DeleteImageOutput) SetImageBuildVersionArn(v string) *DeleteImageOutput {
	s.ImageBuildVersionArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteImageOutput) SetRequestId(v string) *DeleteImageOutput {
	s.RequestId = &v
	return s
}

type DeleteImagePipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the image pipeline to delete.
	//
	// ImagePipelineArn is a required field
	ImagePipelineArn *string `location:"querystring" locationName:"imagePipelineArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImagePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImagePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImagePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImagePipelineInput"}
	if s.ImagePipelineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImagePipelineArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImagePipelineArn sets the ImagePipelineArn field's value.
func (s *DeleteImagePipelineInput) SetImagePipelineArn(v string) *DeleteImagePipelineInput {
	s.ImagePipelineArn = &v
	return s
}

type DeleteImagePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image pipeline that was deleted.
	ImagePipelineArn *string `locationName:"imagePipelineArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImagePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImagePipelineOutput) GoString() string {
	return s.String()
}

// SetImagePipelineArn sets the ImagePipelineArn field's value.
func (s *DeleteImagePipelineOutput) SetImagePipelineArn(v string) *DeleteImagePipelineOutput {
	s.ImagePipelineArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteImagePipelineOutput) SetRequestId(v string) *DeleteImagePipelineOutput {
	s.RequestId = &v
	return s
}

type DeleteImageRecipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the image recipe to delete.
	//
	// ImageRecipeArn is a required field
	ImageRecipeArn *string `location:"querystring" locationName:"imageRecipeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImageRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImageRecipeInput"}
	if s.ImageRecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageRecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *DeleteImageRecipeInput) SetImageRecipeArn(v string) *DeleteImageRecipeInput {
	s.ImageRecipeArn = &v
	return s
}

type DeleteImageRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe that was deleted.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageRecipeOutput) GoString() string {
	return s.String()
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *DeleteImageRecipeOutput) SetImageRecipeArn(v string) *DeleteImageRecipeOutput {
	s.ImageRecipeArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteImageRecipeOutput) SetRequestId(v string) *DeleteImageRecipeOutput {
	s.RequestId = &v
	return s
}

type DeleteInfrastructureConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration to delete.
	//
	// InfrastructureConfigurationArn is a required field
	InfrastructureConfigurationArn *string `location:"querystring" locationName:"infrastructureConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInfrastructureConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInfrastructureConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInfrastructureConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInfrastructureConfigurationInput"}
	if s.InfrastructureConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InfrastructureConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *DeleteInfrastructureConfigurationInput) SetInfrastructureConfigurationArn(v string) *DeleteInfrastructureConfigurationInput {
	s.InfrastructureConfigurationArn = &v
	return s
}

type DeleteInfrastructureConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that was
	// deleted.
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInfrastructureConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInfrastructureConfigurationOutput) GoString() string {
	return s.String()
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *DeleteInfrastructureConfigurationOutput) SetInfrastructureConfigurationArn(v string) *DeleteInfrastructureConfigurationOutput {
	s.InfrastructureConfigurationArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteInfrastructureConfigurationOutput) SetRequestId(v string) *DeleteInfrastructureConfigurationOutput {
	s.RequestId = &v
	return s
}

// Defines the settings for a specific Region.
type Distribution struct {
	_ struct{} `type:"structure"`

	// The specific AMI settings; for example, launch permissions or AMI tags.
	AmiDistributionConfiguration *AmiDistributionConfiguration `locationName:"amiDistributionConfiguration" type:"structure"`

	// Container distribution settings for encryption, licensing, and sharing in
	// a specific Region.
	ContainerDistributionConfiguration *ContainerDistributionConfiguration `locationName:"containerDistributionConfiguration" type:"structure"`

	// The Windows faster-launching configurations to use for AMI distribution.
	FastLaunchConfigurations []*FastLaunchConfiguration `locationName:"fastLaunchConfigurations" min:"1" type:"list"`

	// A group of launchTemplateConfiguration settings that apply to image distribution
	// for specified accounts.
	LaunchTemplateConfigurations []*LaunchTemplateConfiguration `locationName:"launchTemplateConfigurations" min:"1" type:"list"`

	// The License Manager Configuration to associate with the AMI in the specified
	// Region.
	LicenseConfigurationArns []*string `locationName:"licenseConfigurationArns" min:"1" type:"list"`

	// The target Region.
	//
	// Region is a required field
	Region *string `locationName:"region" min:"1" type:"string" required:"true"`

	// Configure export settings to deliver disk images created from your image
	// build, using a file format that is compatible with your VMs in that Region.
	S3ExportConfiguration *S3ExportConfiguration `locationName:"s3ExportConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Distribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Distribution) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Distribution) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Distribution"}
	if s.FastLaunchConfigurations != nil && len(s.FastLaunchConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FastLaunchConfigurations", 1))
	}
	if s.LaunchTemplateConfigurations != nil && len(s.LaunchTemplateConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchTemplateConfigurations", 1))
	}
	if s.LicenseConfigurationArns != nil && len(s.LicenseConfigurationArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseConfigurationArns", 1))
	}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}
	if s.AmiDistributionConfiguration != nil {
		if err := s.AmiDistributionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AmiDistributionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ContainerDistributionConfiguration != nil {
		if err := s.ContainerDistributionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ContainerDistributionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.FastLaunchConfigurations != nil {
		for i, v := range s.FastLaunchConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FastLaunchConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LaunchTemplateConfigurations != nil {
		for i, v := range s.LaunchTemplateConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LaunchTemplateConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.S3ExportConfiguration != nil {
		if err := s.S3ExportConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3ExportConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmiDistributionConfiguration sets the AmiDistributionConfiguration field's value.
func (s *Distribution) SetAmiDistributionConfiguration(v *AmiDistributionConfiguration) *Distribution {
	s.AmiDistributionConfiguration = v
	return s
}

// SetContainerDistributionConfiguration sets the ContainerDistributionConfiguration field's value.
func (s *Distribution) SetContainerDistributionConfiguration(v *ContainerDistributionConfiguration) *Distribution {
	s.ContainerDistributionConfiguration = v
	return s
}

// SetFastLaunchConfigurations sets the FastLaunchConfigurations field's value.
func (s *Distribution) SetFastLaunchConfigurations(v []*FastLaunchConfiguration) *Distribution {
	s.FastLaunchConfigurations = v
	return s
}

// SetLaunchTemplateConfigurations sets the LaunchTemplateConfigurations field's value.
func (s *Distribution) SetLaunchTemplateConfigurations(v []*LaunchTemplateConfiguration) *Distribution {
	s.LaunchTemplateConfigurations = v
	return s
}

// SetLicenseConfigurationArns sets the LicenseConfigurationArns field's value.
func (s *Distribution) SetLicenseConfigurationArns(v []*string) *Distribution {
	s.LicenseConfigurationArns = v
	return s
}

// SetRegion sets the Region field's value.
func (s *Distribution) SetRegion(v string) *Distribution {
	s.Region = &v
	return s
}

// SetS3ExportConfiguration sets the S3ExportConfiguration field's value.
func (s *Distribution) SetS3ExportConfiguration(v *S3ExportConfiguration) *Distribution {
	s.S3ExportConfiguration = v
	return s
}

// A distribution configuration.
type DistributionConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the distribution configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which this distribution configuration was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which this distribution configuration was last updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The distribution objects that apply Region-specific settings for the deployment
	// of the image to targeted Regions.
	Distributions []*Distribution `locationName:"distributions" type:"list"`

	// The name of the distribution configuration.
	Name *string `locationName:"name" type:"string"`

	// The tags of the distribution configuration.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The maximum duration in minutes for this distribution configuration.
	//
	// TimeoutMinutes is a required field
	TimeoutMinutes *int64 `locationName:"timeoutMinutes" min:"30" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributionConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DistributionConfiguration) SetArn(v string) *DistributionConfiguration {
	s.Arn = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *DistributionConfiguration) SetDateCreated(v string) *DistributionConfiguration {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *DistributionConfiguration) SetDateUpdated(v string) *DistributionConfiguration {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DistributionConfiguration) SetDescription(v string) *DistributionConfiguration {
	s.Description = &v
	return s
}

// SetDistributions sets the Distributions field's value.
func (s *DistributionConfiguration) SetDistributions(v []*Distribution) *DistributionConfiguration {
	s.Distributions = v
	return s
}

// SetName sets the Name field's value.
func (s *DistributionConfiguration) SetName(v string) *DistributionConfiguration {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DistributionConfiguration) SetTags(v map[string]*string) *DistributionConfiguration {
	s.Tags = v
	return s
}

// SetTimeoutMinutes sets the TimeoutMinutes field's value.
func (s *DistributionConfiguration) SetTimeoutMinutes(v int64) *DistributionConfiguration {
	s.TimeoutMinutes = &v
	return s
}

// A high-level overview of a distribution configuration.
type DistributionConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the distribution configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which the distribution configuration was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which the distribution configuration was updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the distribution configuration.
	Name *string `locationName:"name" type:"string"`

	// A list of Regions where the container image is distributed to.
	Regions []*string `locationName:"regions" type:"list"`

	// The tags associated with the distribution configuration.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributionConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributionConfigurationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DistributionConfigurationSummary) SetArn(v string) *DistributionConfigurationSummary {
	s.Arn = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *DistributionConfigurationSummary) SetDateCreated(v string) *DistributionConfigurationSummary {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *DistributionConfigurationSummary) SetDateUpdated(v string) *DistributionConfigurationSummary {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DistributionConfigurationSummary) SetDescription(v string) *DistributionConfigurationSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *DistributionConfigurationSummary) SetName(v string) *DistributionConfigurationSummary {
	s.Name = &v
	return s
}

// SetRegions sets the Regions field's value.
func (s *DistributionConfigurationSummary) SetRegions(v []*string) *DistributionConfigurationSummary {
	s.Regions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DistributionConfigurationSummary) SetTags(v map[string]*string) *DistributionConfigurationSummary {
	s.Tags = v
	return s
}

// Amazon EBS-specific block device mapping specifications.
type EbsInstanceBlockDeviceSpecification struct {
	_ struct{} `type:"structure"`

	// Use to configure delete on termination of the associated device.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// Use to configure device encryption.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// Use to configure device IOPS.
	Iops *int64 `locationName:"iops" min:"100" type:"integer"`

	// Use to configure the KMS key to use when encrypting the device.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The snapshot that defines the device contents.
	SnapshotId *string `locationName:"snapshotId" min:"1" type:"string"`

	// For GP3 volumes only – The throughput in MiB/s that the volume supports.
	Throughput *int64 `locationName:"throughput" min:"125" type:"integer"`

	// Use to override the device's volume size.
	VolumeSize *int64 `locationName:"volumeSize" min:"1" type:"integer"`

	// Use to override the device's volume type.
	VolumeType *string `locationName:"volumeType" type:"string" enum:"EbsVolumeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbsInstanceBlockDeviceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbsInstanceBlockDeviceSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EbsInstanceBlockDeviceSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EbsInstanceBlockDeviceSpecification"}
	if s.Iops != nil && *s.Iops < 100 {
		invalidParams.Add(request.NewErrParamMinValue("Iops", 100))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 1))
	}
	if s.Throughput != nil && *s.Throughput < 125 {
		invalidParams.Add(request.NewErrParamMinValue("Throughput", 125))
	}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *EbsInstanceBlockDeviceSpecification) SetDeleteOnTermination(v bool) *EbsInstanceBlockDeviceSpecification {
	s.DeleteOnTermination = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *EbsInstanceBlockDeviceSpecification) SetEncrypted(v bool) *EbsInstanceBlockDeviceSpecification {
	s.Encrypted = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *EbsInstanceBlockDeviceSpecification) SetIops(v int64) *EbsInstanceBlockDeviceSpecification {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *EbsInstanceBlockDeviceSpecification) SetKmsKeyId(v string) *EbsInstanceBlockDeviceSpecification {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *EbsInstanceBlockDeviceSpecification) SetSnapshotId(v string) *EbsInstanceBlockDeviceSpecification {
	s.SnapshotId = &v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *EbsInstanceBlockDeviceSpecification) SetThroughput(v int64) *EbsInstanceBlockDeviceSpecification {
	s.Throughput = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EbsInstanceBlockDeviceSpecification) SetVolumeSize(v int64) *EbsInstanceBlockDeviceSpecification {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *EbsInstanceBlockDeviceSpecification) SetVolumeType(v string) *EbsInstanceBlockDeviceSpecification {
	s.VolumeType = &v
	return s
}

// Define and configure faster launching for output Windows AMIs.
type FastLaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// The owner account ID for the fast-launch enabled Windows AMI.
	AccountId *string `locationName:"accountId" type:"string"`

	// A Boolean that represents the current state of faster launching for the Windows
	// AMI. Set to true to start using Windows faster launching, or false to stop
	// using it.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The launch template that the fast-launch enabled Windows AMI uses when it
	// launches Windows instances to create pre-provisioned snapshots.
	LaunchTemplate *FastLaunchLaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The maximum number of parallel instances that are launched for creating resources.
	MaxParallelLaunches *int64 `locationName:"maxParallelLaunches" min:"1" type:"integer"`

	// Configuration settings for managing the number of snapshots that are created
	// from pre-provisioned instances for the Windows AMI when faster launching
	// is enabled.
	SnapshotConfiguration *FastLaunchSnapshotConfiguration `locationName:"snapshotConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastLaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastLaunchConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FastLaunchConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FastLaunchConfiguration"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.MaxParallelLaunches != nil && *s.MaxParallelLaunches < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxParallelLaunches", 1))
	}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(request.ErrInvalidParams))
		}
	}
	if s.SnapshotConfiguration != nil {
		if err := s.SnapshotConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SnapshotConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *FastLaunchConfiguration) SetAccountId(v string) *FastLaunchConfiguration {
	s.AccountId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *FastLaunchConfiguration) SetEnabled(v bool) *FastLaunchConfiguration {
	s.Enabled = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *FastLaunchConfiguration) SetLaunchTemplate(v *FastLaunchLaunchTemplateSpecification) *FastLaunchConfiguration {
	s.LaunchTemplate = v
	return s
}

// SetMaxParallelLaunches sets the MaxParallelLaunches field's value.
func (s *FastLaunchConfiguration) SetMaxParallelLaunches(v int64) *FastLaunchConfiguration {
	s.MaxParallelLaunches = &v
	return s
}

// SetSnapshotConfiguration sets the SnapshotConfiguration field's value.
func (s *FastLaunchConfiguration) SetSnapshotConfiguration(v *FastLaunchSnapshotConfiguration) *FastLaunchConfiguration {
	s.SnapshotConfiguration = v
	return s
}

// Identifies the launch template that the associated Windows AMI uses for launching
// an instance when faster launching is enabled.
//
// You can specify either the launchTemplateName or the launchTemplateId, but
// not both.
type FastLaunchLaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template to use for faster launching for a Windows AMI.
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string"`

	// The name of the launch template to use for faster launching for a Windows
	// AMI.
	LaunchTemplateName *string `locationName:"launchTemplateName" min:"1" type:"string"`

	// The version of the launch template to use for faster launching for a Windows
	// AMI.
	LaunchTemplateVersion *string `locationName:"launchTemplateVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastLaunchLaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastLaunchLaunchTemplateSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FastLaunchLaunchTemplateSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FastLaunchLaunchTemplateSpecification"}
	if s.LaunchTemplateName != nil && len(*s.LaunchTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchTemplateName", 1))
	}
	if s.LaunchTemplateVersion != nil && len(*s.LaunchTemplateVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchTemplateVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *FastLaunchLaunchTemplateSpecification) SetLaunchTemplateId(v string) *FastLaunchLaunchTemplateSpecification {
	s.LaunchTemplateId = &v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *FastLaunchLaunchTemplateSpecification) SetLaunchTemplateName(v string) *FastLaunchLaunchTemplateSpecification {
	s.LaunchTemplateName = &v
	return s
}

// SetLaunchTemplateVersion sets the LaunchTemplateVersion field's value.
func (s *FastLaunchLaunchTemplateSpecification) SetLaunchTemplateVersion(v string) *FastLaunchLaunchTemplateSpecification {
	s.LaunchTemplateVersion = &v
	return s
}

// Configuration settings for creating and managing pre-provisioned snapshots
// for a fast-launch enabled Windows AMI.
type FastLaunchSnapshotConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of pre-provisioned snapshots to keep on hand for a fast-launch
	// enabled Windows AMI.
	TargetResourceCount *int64 `locationName:"targetResourceCount" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastLaunchSnapshotConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FastLaunchSnapshotConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FastLaunchSnapshotConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FastLaunchSnapshotConfiguration"}
	if s.TargetResourceCount != nil && *s.TargetResourceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TargetResourceCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetResourceCount sets the TargetResourceCount field's value.
func (s *FastLaunchSnapshotConfiguration) SetTargetResourceCount(v int64) *FastLaunchSnapshotConfiguration {
	s.TargetResourceCount = &v
	return s
}

// A filter name and value pair that is used to return a more specific list
// of results from a list operation. Filters can be used to match a set of resources
// by specific criteria, such as tags, attributes, or IDs.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	Name *string `locationName:"name" type:"string"`

	// The filter values. Filter values are case-sensitive.
	Values []*string `locationName:"values" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// You are not authorized to perform the requested operation.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetComponentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the component that you want to retrieve.
	// Regex requires "/\d+$" suffix.
	//
	// ComponentBuildVersionArn is a required field
	ComponentBuildVersionArn *string `location:"querystring" locationName:"componentBuildVersionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComponentInput"}
	if s.ComponentBuildVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentBuildVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentBuildVersionArn sets the ComponentBuildVersionArn field's value.
func (s *GetComponentInput) SetComponentBuildVersionArn(v string) *GetComponentInput {
	s.ComponentBuildVersionArn = &v
	return s
}

type GetComponentOutput struct {
	_ struct{} `type:"structure"`

	// The component object associated with the specified ARN.
	Component *Component `locationName:"component" type:"structure"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *GetComponentOutput) SetComponent(v *Component) *GetComponentOutput {
	s.Component = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetComponentOutput) SetRequestId(v string) *GetComponentOutput {
	s.RequestId = &v
	return s
}

type GetComponentPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the component whose policy you want to
	// retrieve.
	//
	// ComponentArn is a required field
	ComponentArn *string `location:"querystring" locationName:"componentArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComponentPolicyInput"}
	if s.ComponentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentArn sets the ComponentArn field's value.
func (s *GetComponentPolicyInput) SetComponentArn(v string) *GetComponentPolicyInput {
	s.ComponentArn = &v
	return s
}

type GetComponentPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The component policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetComponentPolicyOutput) SetPolicy(v string) *GetComponentPolicyOutput {
	s.Policy = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetComponentPolicyOutput) SetRequestId(v string) *GetComponentPolicyOutput {
	s.RequestId = &v
	return s
}

type GetContainerRecipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the container recipe to retrieve.
	//
	// ContainerRecipeArn is a required field
	ContainerRecipeArn *string `location:"querystring" locationName:"containerRecipeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContainerRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContainerRecipeInput"}
	if s.ContainerRecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerRecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *GetContainerRecipeInput) SetContainerRecipeArn(v string) *GetContainerRecipeInput {
	s.ContainerRecipeArn = &v
	return s
}

type GetContainerRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The container recipe object that is returned.
	ContainerRecipe *ContainerRecipe `locationName:"containerRecipe" type:"structure"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerRecipeOutput) GoString() string {
	return s.String()
}

// SetContainerRecipe sets the ContainerRecipe field's value.
func (s *GetContainerRecipeOutput) SetContainerRecipe(v *ContainerRecipe) *GetContainerRecipeOutput {
	s.ContainerRecipe = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetContainerRecipeOutput) SetRequestId(v string) *GetContainerRecipeOutput {
	s.RequestId = &v
	return s
}

type GetContainerRecipePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the container recipe for the policy being
	// requested.
	//
	// ContainerRecipeArn is a required field
	ContainerRecipeArn *string `location:"querystring" locationName:"containerRecipeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerRecipePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerRecipePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContainerRecipePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContainerRecipePolicyInput"}
	if s.ContainerRecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerRecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *GetContainerRecipePolicyInput) SetContainerRecipeArn(v string) *GetContainerRecipePolicyInput {
	s.ContainerRecipeArn = &v
	return s
}

type GetContainerRecipePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The container recipe policy object that is returned.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerRecipePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContainerRecipePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetContainerRecipePolicyOutput) SetPolicy(v string) *GetContainerRecipePolicyOutput {
	s.Policy = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetContainerRecipePolicyOutput) SetRequestId(v string) *GetContainerRecipePolicyOutput {
	s.RequestId = &v
	return s
}

type GetDistributionConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the distribution configuration that you
	// want to retrieve.
	//
	// DistributionConfigurationArn is a required field
	DistributionConfigurationArn *string `location:"querystring" locationName:"distributionConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDistributionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDistributionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDistributionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDistributionConfigurationInput"}
	if s.DistributionConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *GetDistributionConfigurationInput) SetDistributionConfigurationArn(v string) *GetDistributionConfigurationInput {
	s.DistributionConfigurationArn = &v
	return s
}

type GetDistributionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The distribution configuration object.
	DistributionConfiguration *DistributionConfiguration `locationName:"distributionConfiguration" type:"structure"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDistributionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDistributionConfigurationOutput) GoString() string {
	return s.String()
}

// SetDistributionConfiguration sets the DistributionConfiguration field's value.
func (s *GetDistributionConfigurationOutput) SetDistributionConfiguration(v *DistributionConfiguration) *GetDistributionConfigurationOutput {
	s.DistributionConfiguration = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetDistributionConfigurationOutput) SetRequestId(v string) *GetDistributionConfigurationOutput {
	s.RequestId = &v
	return s
}

type GetImageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the image that you want to retrieve.
	//
	// ImageBuildVersionArn is a required field
	ImageBuildVersionArn *string `location:"querystring" locationName:"imageBuildVersionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImageInput"}
	if s.ImageBuildVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageBuildVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageBuildVersionArn sets the ImageBuildVersionArn field's value.
func (s *GetImageInput) SetImageBuildVersionArn(v string) *GetImageInput {
	s.ImageBuildVersionArn = &v
	return s
}

type GetImageOutput struct {
	_ struct{} `type:"structure"`

	// The image object.
	Image *Image `locationName:"image" type:"structure"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageOutput) GoString() string {
	return s.String()
}

// SetImage sets the Image field's value.
func (s *GetImageOutput) SetImage(v *Image) *GetImageOutput {
	s.Image = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetImageOutput) SetRequestId(v string) *GetImageOutput {
	s.RequestId = &v
	return s
}

type GetImagePipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.
	//
	// ImagePipelineArn is a required field
	ImagePipelineArn *string `location:"querystring" locationName:"imagePipelineArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImagePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImagePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImagePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImagePipelineInput"}
	if s.ImagePipelineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImagePipelineArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImagePipelineArn sets the ImagePipelineArn field's value.
func (s *GetImagePipelineInput) SetImagePipelineArn(v string) *GetImagePipelineInput {
	s.ImagePipelineArn = &v
	return s
}

type GetImagePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The image pipeline object.
	ImagePipeline *ImagePipeline `locationName:"imagePipeline" type:"structure"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImagePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImagePipelineOutput) GoString() string {
	return s.String()
}

// SetImagePipeline sets the ImagePipeline field's value.
func (s *GetImagePipelineOutput) SetImagePipeline(v *ImagePipeline) *GetImagePipelineOutput {
	s.ImagePipeline = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetImagePipelineOutput) SetRequestId(v string) *GetImagePipelineOutput {
	s.RequestId = &v
	return s
}

type GetImagePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.
	//
	// ImageArn is a required field
	ImageArn *string `location:"querystring" locationName:"imageArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImagePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImagePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImagePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImagePolicyInput"}
	if s.ImageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageArn sets the ImageArn field's value.
func (s *GetImagePolicyInput) SetImageArn(v string) *GetImagePolicyInput {
	s.ImageArn = &v
	return s
}

type GetImagePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The image policy object.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImagePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImagePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetImagePolicyOutput) SetPolicy(v string) *GetImagePolicyOutput {
	s.Policy = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetImagePolicyOutput) SetRequestId(v string) *GetImagePolicyOutput {
	s.RequestId = &v
	return s
}

type GetImageRecipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.
	//
	// ImageRecipeArn is a required field
	ImageRecipeArn *string `location:"querystring" locationName:"imageRecipeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageRecipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImageRecipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImageRecipeInput"}
	if s.ImageRecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageRecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *GetImageRecipeInput) SetImageRecipeArn(v string) *GetImageRecipeInput {
	s.ImageRecipeArn = &v
	return s
}

type GetImageRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The image recipe object.
	ImageRecipe *ImageRecipe `locationName:"imageRecipe" type:"structure"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageRecipeOutput) GoString() string {
	return s.String()
}

// SetImageRecipe sets the ImageRecipe field's value.
func (s *GetImageRecipeOutput) SetImageRecipe(v *ImageRecipe) *GetImageRecipeOutput {
	s.ImageRecipe = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetImageRecipeOutput) SetRequestId(v string) *GetImageRecipeOutput {
	s.RequestId = &v
	return s
}

type GetImageRecipePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the image recipe whose policy you want
	// to retrieve.
	//
	// ImageRecipeArn is a required field
	ImageRecipeArn *string `location:"querystring" locationName:"imageRecipeArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageRecipePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageRecipePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImageRecipePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImageRecipePolicyInput"}
	if s.ImageRecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageRecipeArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *GetImageRecipePolicyInput) SetImageRecipeArn(v string) *GetImageRecipePolicyInput {
	s.ImageRecipeArn = &v
	return s
}

type GetImageRecipePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The image recipe policy object.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageRecipePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageRecipePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetImageRecipePolicyOutput) SetPolicy(v string) *GetImageRecipePolicyOutput {
	s.Policy = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetImageRecipePolicyOutput) SetRequestId(v string) *GetImageRecipePolicyOutput {
	s.RequestId = &v
	return s
}

// GetInfrastructureConfiguration request object.
type GetInfrastructureConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that you
	// want to retrieve.
	//
	// InfrastructureConfigurationArn is a required field
	InfrastructureConfigurationArn *string `location:"querystring" locationName:"infrastructureConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInfrastructureConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInfrastructureConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInfrastructureConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInfrastructureConfigurationInput"}
	if s.InfrastructureConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InfrastructureConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *GetInfrastructureConfigurationInput) SetInfrastructureConfigurationArn(v string) *GetInfrastructureConfigurationInput {
	s.InfrastructureConfigurationArn = &v
	return s
}

// GetInfrastructureConfiguration response object.
type GetInfrastructureConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The infrastructure configuration object.
	InfrastructureConfiguration *InfrastructureConfiguration `locationName:"infrastructureConfiguration" type:"structure"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInfrastructureConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInfrastructureConfigurationOutput) GoString() string {
	return s.String()
}

// SetInfrastructureConfiguration sets the InfrastructureConfiguration field's value.
func (s *GetInfrastructureConfigurationOutput) SetInfrastructureConfiguration(v *InfrastructureConfiguration) *GetInfrastructureConfigurationOutput {
	s.InfrastructureConfiguration = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetInfrastructureConfigurationOutput) SetRequestId(v string) *GetInfrastructureConfigurationOutput {
	s.RequestId = &v
	return s
}

// You have specified a client token for an operation using parameter values
// that differ from a previous request that used the same client token.
type IdempotentParameterMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) GoString() string {
	return s.String()
}

func newErrorIdempotentParameterMismatchException(v protocol.ResponseMetadata) error {
	return &IdempotentParameterMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IdempotentParameterMismatchException) Code() string {
	return "IdempotentParameterMismatchException"
}

// Message returns the exception's message.
func (s *IdempotentParameterMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IdempotentParameterMismatchException) OrigErr() error {
	return nil
}

func (s *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IdempotentParameterMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IdempotentParameterMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Image Builder image. You must specify exactly one recipe for the image
// – either a container recipe (containerRecipe), which creates a container
// image, or an image recipe (imageRecipe), which creates an AMI.
type Image struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image.
	//
	// Semantic versioning is included in each object's Amazon Resource Name (ARN),
	// at the level that applies to that object as follows:
	//
	// Versionless ARNs and Name ARNs do not include specific values in any of the
	// nodes. The nodes are either left off entirely, or they are specified as wildcards,
	// for example: x.x.x.
	//
	// Version ARNs have only the first three nodes: <major>.<minor>.<patch>
	//
	// Build version ARNs have all four nodes, and point to a specific build for
	// a specific version of an object.
	Arn *string `locationName:"arn" type:"string"`

	// Indicates the type of build that created this image. The build can be initiated
	// in the following ways:
	//
	//    * USER_INITIATED – A manual pipeline build request.
	//
	//    * SCHEDULED – A pipeline build initiated by a cron expression in the
	//    Image Builder pipeline, or from EventBridge.
	//
	//    * IMPORT – A VM import created the image to use as the base image for
	//    the recipe.
	BuildType *string `locationName:"buildType" type:"string" enum:"BuildType"`

	// For container images, this is the container recipe that Image Builder used
	// to create the image. For images that distribute an AMI, this is empty.
	ContainerRecipe *ContainerRecipe `locationName:"containerRecipe" type:"structure"`

	// The date on which Image Builder created this image.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The distribution configuration that Image Builder used to create this image.
	DistributionConfiguration *DistributionConfiguration `locationName:"distributionConfiguration" type:"structure"`

	// Indicates whether Image Builder collects additional information about the
	// image, such as the operating system (OS) version and package list.
	EnhancedImageMetadataEnabled *bool `locationName:"enhancedImageMetadataEnabled" type:"boolean"`

	// For images that distribute an AMI, this is the image recipe that Image Builder
	// used to create the image. For container images, this is empty.
	ImageRecipe *ImageRecipe `locationName:"imageRecipe" type:"structure"`

	// The origin of the base image that Image Builder used to build this image.
	ImageSource *string `locationName:"imageSource" type:"string" enum:"ImageSource"`

	// The image tests that ran when that Image Builder created this image.
	ImageTestsConfiguration *ImageTestsConfiguration `locationName:"imageTestsConfiguration" type:"structure"`

	// The infrastructure that Image Builder used to create this image.
	InfrastructureConfiguration *InfrastructureConfiguration `locationName:"infrastructureConfiguration" type:"structure"`

	// The name of the image.
	Name *string `locationName:"name" type:"string"`

	// The operating system version for instances that launch from this image. For
	// example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string `locationName:"osVersion" min:"1" type:"string"`

	// The output resources that Image Builder produces for this image.
	OutputResources *OutputResources `locationName:"outputResources" type:"structure"`

	// The image operating system platform, such as Linux or Windows.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// The Amazon Resource Name (ARN) of the image pipeline that created this image.
	SourcePipelineArn *string `locationName:"sourcePipelineArn" type:"string"`

	// The name of the image pipeline that created this image.
	SourcePipelineName *string `locationName:"sourcePipelineName" type:"string"`

	// The state of the image.
	State *ImageState `locationName:"state" type:"structure"`

	// The tags that apply to this image.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// Specifies whether this image produces an AMI or a container image.
	Type *string `locationName:"type" type:"string" enum:"ImageType"`

	// The semantic version of the image.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth
	// node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose
	// a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base
	// image or components for your recipe. When you use a wildcard in any node,
	// all nodes to the right of the first wildcard must also be wildcards.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Image) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Image) SetArn(v string) *Image {
	s.Arn = &v
	return s
}

// SetBuildType sets the BuildType field's value.
func (s *Image) SetBuildType(v string) *Image {
	s.BuildType = &v
	return s
}

// SetContainerRecipe sets the ContainerRecipe field's value.
func (s *Image) SetContainerRecipe(v *ContainerRecipe) *Image {
	s.ContainerRecipe = v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *Image) SetDateCreated(v string) *Image {
	s.DateCreated = &v
	return s
}

// SetDistributionConfiguration sets the DistributionConfiguration field's value.
func (s *Image) SetDistributionConfiguration(v *DistributionConfiguration) *Image {
	s.DistributionConfiguration = v
	return s
}

// SetEnhancedImageMetadataEnabled sets the EnhancedImageMetadataEnabled field's value.
func (s *Image) SetEnhancedImageMetadataEnabled(v bool) *Image {
	s.EnhancedImageMetadataEnabled = &v
	return s
}

// SetImageRecipe sets the ImageRecipe field's value.
func (s *Image) SetImageRecipe(v *ImageRecipe) *Image {
	s.ImageRecipe = v
	return s
}

// SetImageSource sets the ImageSource field's value.
func (s *Image) SetImageSource(v string) *Image {
	s.ImageSource = &v
	return s
}

// SetImageTestsConfiguration sets the ImageTestsConfiguration field's value.
func (s *Image) SetImageTestsConfiguration(v *ImageTestsConfiguration) *Image {
	s.ImageTestsConfiguration = v
	return s
}

// SetInfrastructureConfiguration sets the InfrastructureConfiguration field's value.
func (s *Image) SetInfrastructureConfiguration(v *InfrastructureConfiguration) *Image {
	s.InfrastructureConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *Image) SetName(v string) *Image {
	s.Name = &v
	return s
}

// SetOsVersion sets the OsVersion field's value.
func (s *Image) SetOsVersion(v string) *Image {
	s.OsVersion = &v
	return s
}

// SetOutputResources sets the OutputResources field's value.
func (s *Image) SetOutputResources(v *OutputResources) *Image {
	s.OutputResources = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Image) SetPlatform(v string) *Image {
	s.Platform = &v
	return s
}

// SetSourcePipelineArn sets the SourcePipelineArn field's value.
func (s *Image) SetSourcePipelineArn(v string) *Image {
	s.SourcePipelineArn = &v
	return s
}

// SetSourcePipelineName sets the SourcePipelineName field's value.
func (s *Image) SetSourcePipelineName(v string) *Image {
	s.SourcePipelineName = &v
	return s
}

// SetState sets the State field's value.
func (s *Image) SetState(v *ImageState) *Image {
	s.State = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Image) SetTags(v map[string]*string) *Image {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Image) SetType(v string) *Image {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Image) SetVersion(v string) *Image {
	s.Version = &v
	return s
}

// Represents a package installed on an Image Builder image.
type ImagePackage struct {
	_ struct{} `type:"structure"`

	// The name of the package as reported to the operating system package manager.
	PackageName *string `locationName:"packageName" min:"1" type:"string"`

	// The version of the package as reported to the operating system package manager.
	PackageVersion *string `locationName:"packageVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImagePackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImagePackage) GoString() string {
	return s.String()
}

// SetPackageName sets the PackageName field's value.
func (s *ImagePackage) SetPackageName(v string) *ImagePackage {
	s.PackageName = &v
	return s
}

// SetPackageVersion sets the PackageVersion field's value.
func (s *ImagePackage) SetPackageVersion(v string) *ImagePackage {
	s.PackageVersion = &v
	return s
}

// Details of an image pipeline.
type ImagePipeline struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image pipeline.
	Arn *string `locationName:"arn" type:"string"`

	// The Amazon Resource Name (ARN) of the container recipe that is used for this
	// pipeline.
	ContainerRecipeArn *string `locationName:"containerRecipeArn" type:"string"`

	// The date on which this image pipeline was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// This is no longer supported, and does not return a value.
	DateLastRun *string `locationName:"dateLastRun" type:"string"`

	// This is no longer supported, and does not return a value.
	DateNextRun *string `locationName:"dateNextRun" type:"string"`

	// The date on which this image pipeline was last updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the image pipeline.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration associated
	// with this image pipeline.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// Collects additional information about the image being created, including
	// the operating system (OS) version and package list. This information is used
	// to enhance the overall experience of using EC2 Image Builder. Enabled by
	// default.
	EnhancedImageMetadataEnabled *bool `locationName:"enhancedImageMetadataEnabled" type:"boolean"`

	// The Amazon Resource Name (ARN) of the image recipe associated with this image
	// pipeline.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The image tests configuration of the image pipeline.
	ImageTestsConfiguration *ImageTestsConfiguration `locationName:"imageTestsConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration associated
	// with this image pipeline.
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string"`

	// The name of the image pipeline.
	Name *string `locationName:"name" type:"string"`

	// The platform of the image pipeline.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// The schedule of the image pipeline.
	Schedule *Schedule `locationName:"schedule" type:"structure"`

	// The status of the image pipeline.
	Status *string `locationName:"status" type:"string" enum:"PipelineStatus"`

	// The tags of this image pipeline.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImagePipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImagePipeline) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ImagePipeline) SetArn(v string) *ImagePipeline {
	s.Arn = &v
	return s
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *ImagePipeline) SetContainerRecipeArn(v string) *ImagePipeline {
	s.ContainerRecipeArn = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ImagePipeline) SetDateCreated(v string) *ImagePipeline {
	s.DateCreated = &v
	return s
}

// SetDateLastRun sets the DateLastRun field's value.
func (s *ImagePipeline) SetDateLastRun(v string) *ImagePipeline {
	s.DateLastRun = &v
	return s
}

// SetDateNextRun sets the DateNextRun field's value.
func (s *ImagePipeline) SetDateNextRun(v string) *ImagePipeline {
	s.DateNextRun = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *ImagePipeline) SetDateUpdated(v string) *ImagePipeline {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ImagePipeline) SetDescription(v string) *ImagePipeline {
	s.Description = &v
	return s
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *ImagePipeline) SetDistributionConfigurationArn(v string) *ImagePipeline {
	s.DistributionConfigurationArn = &v
	return s
}

// SetEnhancedImageMetadataEnabled sets the EnhancedImageMetadataEnabled field's value.
func (s *ImagePipeline) SetEnhancedImageMetadataEnabled(v bool) *ImagePipeline {
	s.EnhancedImageMetadataEnabled = &v
	return s
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *ImagePipeline) SetImageRecipeArn(v string) *ImagePipeline {
	s.ImageRecipeArn = &v
	return s
}

// SetImageTestsConfiguration sets the ImageTestsConfiguration field's value.
func (s *ImagePipeline) SetImageTestsConfiguration(v *ImageTestsConfiguration) *ImagePipeline {
	s.ImageTestsConfiguration = v
	return s
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *ImagePipeline) SetInfrastructureConfigurationArn(v string) *ImagePipeline {
	s.InfrastructureConfigurationArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImagePipeline) SetName(v string) *ImagePipeline {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImagePipeline) SetPlatform(v string) *ImagePipeline {
	s.Platform = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *ImagePipeline) SetSchedule(v *Schedule) *ImagePipeline {
	s.Schedule = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImagePipeline) SetStatus(v string) *ImagePipeline {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImagePipeline) SetTags(v map[string]*string) *ImagePipeline {
	s.Tags = v
	return s
}

// An image recipe.
type ImageRecipe struct {
	_ struct{} `type:"structure"`

	// Before you create a new AMI, Image Builder launches temporary Amazon EC2
	// instances to build and test your image configuration. Instance configuration
	// adds a layer of control over those instances. You can define settings and
	// add scripts to run when an instance is launched from your AMI.
	AdditionalInstanceConfiguration *AdditionalInstanceConfiguration `locationName:"additionalInstanceConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe.
	Arn *string `locationName:"arn" type:"string"`

	// The block device mappings to apply when creating images from this recipe.
	BlockDeviceMappings []*InstanceBlockDeviceMapping `locationName:"blockDeviceMappings" type:"list"`

	// The components that are included in the image recipe. Recipes require a minimum
	// of one build component, and can have a maximum of 20 build and test components
	// in any combination.
	Components []*ComponentConfiguration `locationName:"components" min:"1" type:"list"`

	// The date on which this image recipe was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the image recipe.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the image recipe.
	Name *string `locationName:"name" type:"string"`

	// The owner of the image recipe.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The base image of the image recipe.
	ParentImage *string `locationName:"parentImage" min:"1" type:"string"`

	// The platform of the image recipe.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// The tags of the image recipe.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// Specifies which type of image is created by the recipe - an AMI or a container
	// image.
	Type *string `locationName:"type" type:"string" enum:"ImageType"`

	// The version of the image recipe.
	Version *string `locationName:"version" type:"string"`

	// The working directory to be used during build and test workflows.
	WorkingDirectory *string `locationName:"workingDirectory" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageRecipe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageRecipe) GoString() string {
	return s.String()
}

// SetAdditionalInstanceConfiguration sets the AdditionalInstanceConfiguration field's value.
func (s *ImageRecipe) SetAdditionalInstanceConfiguration(v *AdditionalInstanceConfiguration) *ImageRecipe {
	s.AdditionalInstanceConfiguration = v
	return s
}

// SetArn sets the Arn field's value.
func (s *ImageRecipe) SetArn(v string) *ImageRecipe {
	s.Arn = &v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *ImageRecipe) SetBlockDeviceMappings(v []*InstanceBlockDeviceMapping) *ImageRecipe {
	s.BlockDeviceMappings = v
	return s
}

// SetComponents sets the Components field's value.
func (s *ImageRecipe) SetComponents(v []*ComponentConfiguration) *ImageRecipe {
	s.Components = v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ImageRecipe) SetDateCreated(v string) *ImageRecipe {
	s.DateCreated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ImageRecipe) SetDescription(v string) *ImageRecipe {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImageRecipe) SetName(v string) *ImageRecipe {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ImageRecipe) SetOwner(v string) *ImageRecipe {
	s.Owner = &v
	return s
}

// SetParentImage sets the ParentImage field's value.
func (s *ImageRecipe) SetParentImage(v string) *ImageRecipe {
	s.ParentImage = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImageRecipe) SetPlatform(v string) *ImageRecipe {
	s.Platform = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImageRecipe) SetTags(v map[string]*string) *ImageRecipe {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageRecipe) SetType(v string) *ImageRecipe {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ImageRecipe) SetVersion(v string) *ImageRecipe {
	s.Version = &v
	return s
}

// SetWorkingDirectory sets the WorkingDirectory field's value.
func (s *ImageRecipe) SetWorkingDirectory(v string) *ImageRecipe {
	s.WorkingDirectory = &v
	return s
}

// A summary of an image recipe.
type ImageRecipeSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which this image recipe was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The name of the image recipe.
	Name *string `locationName:"name" type:"string"`

	// The owner of the image recipe.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The base image of the image recipe.
	ParentImage *string `locationName:"parentImage" min:"1" type:"string"`

	// The platform of the image recipe.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// The tags of the image recipe.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageRecipeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageRecipeSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ImageRecipeSummary) SetArn(v string) *ImageRecipeSummary {
	s.Arn = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ImageRecipeSummary) SetDateCreated(v string) *ImageRecipeSummary {
	s.DateCreated = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImageRecipeSummary) SetName(v string) *ImageRecipeSummary {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ImageRecipeSummary) SetOwner(v string) *ImageRecipeSummary {
	s.Owner = &v
	return s
}

// SetParentImage sets the ParentImage field's value.
func (s *ImageRecipeSummary) SetParentImage(v string) *ImageRecipeSummary {
	s.ParentImage = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImageRecipeSummary) SetPlatform(v string) *ImageRecipeSummary {
	s.Platform = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImageRecipeSummary) SetTags(v map[string]*string) *ImageRecipeSummary {
	s.Tags = v
	return s
}

// Image state shows the image status and the reason for that status.
type ImageState struct {
	_ struct{} `type:"structure"`

	// The reason for the image's status.
	Reason *string `locationName:"reason" min:"1" type:"string"`

	// The status of the image.
	Status *string `locationName:"status" type:"string" enum:"ImageStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageState) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *ImageState) SetReason(v string) *ImageState {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImageState) SetStatus(v string) *ImageState {
	s.Status = &v
	return s
}

// An image summary.
type ImageSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image.
	Arn *string `locationName:"arn" type:"string"`

	// Indicates the type of build that created this image. The build can be initiated
	// in the following ways:
	//
	//    * USER_INITIATED – A manual pipeline build request.
	//
	//    * SCHEDULED – A pipeline build initiated by a cron expression in the
	//    Image Builder pipeline, or from EventBridge.
	//
	//    * IMPORT – A VM import created the image to use as the base image for
	//    the recipe.
	BuildType *string `locationName:"buildType" type:"string" enum:"BuildType"`

	// The date on which Image Builder created this image.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The origin of the base image that Image Builder used to build this image.
	ImageSource *string `locationName:"imageSource" type:"string" enum:"ImageSource"`

	// The name of the image.
	Name *string `locationName:"name" type:"string"`

	// The operating system version of the instances that launch from this image.
	// For example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string `locationName:"osVersion" min:"1" type:"string"`

	// The output resources that Image Builder produced when it created this image.
	OutputResources *OutputResources `locationName:"outputResources" type:"structure"`

	// The owner of the image.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The image operating system platform, such as Linux or Windows.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// The state of the image.
	State *ImageState `locationName:"state" type:"structure"`

	// The tags that apply to this image.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// Specifies whether this image produces an AMI or a container image.
	Type *string `locationName:"type" type:"string" enum:"ImageType"`

	// The version of the image.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ImageSummary) SetArn(v string) *ImageSummary {
	s.Arn = &v
	return s
}

// SetBuildType sets the BuildType field's value.
func (s *ImageSummary) SetBuildType(v string) *ImageSummary {
	s.BuildType = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ImageSummary) SetDateCreated(v string) *ImageSummary {
	s.DateCreated = &v
	return s
}

// SetImageSource sets the ImageSource field's value.
func (s *ImageSummary) SetImageSource(v string) *ImageSummary {
	s.ImageSource = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImageSummary) SetName(v string) *ImageSummary {
	s.Name = &v
	return s
}

// SetOsVersion sets the OsVersion field's value.
func (s *ImageSummary) SetOsVersion(v string) *ImageSummary {
	s.OsVersion = &v
	return s
}

// SetOutputResources sets the OutputResources field's value.
func (s *ImageSummary) SetOutputResources(v *OutputResources) *ImageSummary {
	s.OutputResources = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ImageSummary) SetOwner(v string) *ImageSummary {
	s.Owner = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImageSummary) SetPlatform(v string) *ImageSummary {
	s.Platform = &v
	return s
}

// SetState sets the State field's value.
func (s *ImageSummary) SetState(v *ImageState) *ImageSummary {
	s.State = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImageSummary) SetTags(v map[string]*string) *ImageSummary {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageSummary) SetType(v string) *ImageSummary {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ImageSummary) SetVersion(v string) *ImageSummary {
	s.Version = &v
	return s
}

// Configure image tests for your pipeline build. Tests run after building the
// image, to verify that the AMI or container image is valid before distributing
// it.
type ImageTestsConfiguration struct {
	_ struct{} `type:"structure"`

	// Determines if tests should run after building the image. Image Builder defaults
	// to enable tests to run following the image build, before image distribution.
	ImageTestsEnabled *bool `locationName:"imageTestsEnabled" type:"boolean"`

	// The maximum time in minutes that tests are permitted to run.
	//
	// The timeoutMinutes attribute is not currently active. This value is ignored.
	TimeoutMinutes *int64 `locationName:"timeoutMinutes" min:"60" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageTestsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageTestsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageTestsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageTestsConfiguration"}
	if s.TimeoutMinutes != nil && *s.TimeoutMinutes < 60 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutMinutes", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageTestsEnabled sets the ImageTestsEnabled field's value.
func (s *ImageTestsConfiguration) SetImageTestsEnabled(v bool) *ImageTestsConfiguration {
	s.ImageTestsEnabled = &v
	return s
}

// SetTimeoutMinutes sets the TimeoutMinutes field's value.
func (s *ImageTestsConfiguration) SetTimeoutMinutes(v int64) *ImageTestsConfiguration {
	s.TimeoutMinutes = &v
	return s
}

// The defining characteristics of a specific version of an Image Builder image.
type ImageVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a specific version of an Image Builder
	// image.
	//
	// Semantic versioning is included in each object's Amazon Resource Name (ARN),
	// at the level that applies to that object as follows:
	//
	// Versionless ARNs and Name ARNs do not include specific values in any of the
	// nodes. The nodes are either left off entirely, or they are specified as wildcards,
	// for example: x.x.x.
	//
	// Version ARNs have only the first three nodes: <major>.<minor>.<patch>
	//
	// Build version ARNs have all four nodes, and point to a specific build for
	// a specific version of an object.
	Arn *string `locationName:"arn" type:"string"`

	// Indicates the type of build that created this image. The build can be initiated
	// in the following ways:
	//
	//    * USER_INITIATED – A manual pipeline build request.
	//
	//    * SCHEDULED – A pipeline build initiated by a cron expression in the
	//    Image Builder pipeline, or from EventBridge.
	//
	//    * IMPORT – A VM import created the image to use as the base image for
	//    the recipe.
	BuildType *string `locationName:"buildType" type:"string" enum:"BuildType"`

	// The date on which this specific version of the Image Builder image was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The origin of the base image that Image Builder used to build this image.
	ImageSource *string `locationName:"imageSource" type:"string" enum:"ImageSource"`

	// The name of this specific version of an Image Builder image.
	Name *string `locationName:"name" type:"string"`

	// The operating system version of the Amazon EC2 build instance. For example,
	// Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string `locationName:"osVersion" min:"1" type:"string"`

	// The owner of the image version.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The operating system platform of the image version, for example "Windows"
	// or "Linux".
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`

	// Specifies whether this image produces an AMI or a container image.
	Type *string `locationName:"type" type:"string" enum:"ImageType"`

	// Details for a specific version of an Image Builder image. This version follows
	// the semantic version syntax.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth
	// node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose
	// a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base
	// image or components for your recipe. When you use a wildcard in any node,
	// all nodes to the right of the first wildcard must also be wildcards.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageVersion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ImageVersion) SetArn(v string) *ImageVersion {
	s.Arn = &v
	return s
}

// SetBuildType sets the BuildType field's value.
func (s *ImageVersion) SetBuildType(v string) *ImageVersion {
	s.BuildType = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *ImageVersion) SetDateCreated(v string) *ImageVersion {
	s.DateCreated = &v
	return s
}

// SetImageSource sets the ImageSource field's value.
func (s *ImageVersion) SetImageSource(v string) *ImageVersion {
	s.ImageSource = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImageVersion) SetName(v string) *ImageVersion {
	s.Name = &v
	return s
}

// SetOsVersion sets the OsVersion field's value.
func (s *ImageVersion) SetOsVersion(v string) *ImageVersion {
	s.OsVersion = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ImageVersion) SetOwner(v string) *ImageVersion {
	s.Owner = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImageVersion) SetPlatform(v string) *ImageVersion {
	s.Platform = &v
	return s
}

// SetType sets the Type field's value.
func (s *ImageVersion) SetType(v string) *ImageVersion {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ImageVersion) SetVersion(v string) *ImageVersion {
	s.Version = &v
	return s
}

type ImportComponentInput struct {
	_ struct{} `type:"structure"`

	// The change description of the component. Describes what change has been made
	// in this version, or what makes this version different from other versions
	// of this component.
	ChangeDescription *string `locationName:"changeDescription" min:"1" type:"string"`

	// The idempotency token of the component.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The data of the component. Used to specify the data inline. Either data or
	// uri can be used to specify the data within the component.
	Data *string `locationName:"data" min:"1" type:"string"`

	// The description of the component. Describes the contents of the component.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The format of the resource that you want to import as a component.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"ComponentFormat"`

	// The ID of the KMS key that should be used to encrypt this component.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the component.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The platform of the component.
	//
	// Platform is a required field
	Platform *string `locationName:"platform" type:"string" required:"true" enum:"Platform"`

	// The semantic version of the component. This version follows the semantic
	// version syntax.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base
	// image or components for your recipe. When you use a wildcard in any node,
	// all nodes to the right of the first wildcard must also be wildcards.
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// The tags of the component.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The type of the component denotes whether the component is used to build
	// the image, or only to test it.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ComponentType"`

	// The uri of the component. Must be an Amazon S3 URL and the requester must
	// have permission to access the Amazon S3 bucket. If you use Amazon S3, you
	// can specify component content up to your service quota. Either data or uri
	// can be used to specify the data within the component.
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportComponentInput"}
	if s.ChangeDescription != nil && len(*s.ChangeDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeDescription", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Data != nil && len(*s.Data) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Data", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}
	if s.SemanticVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SemanticVersion"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeDescription sets the ChangeDescription field's value.
func (s *ImportComponentInput) SetChangeDescription(v string) *ImportComponentInput {
	s.ChangeDescription = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ImportComponentInput) SetClientToken(v string) *ImportComponentInput {
	s.ClientToken = &v
	return s
}

// SetData sets the Data field's value.
func (s *ImportComponentInput) SetData(v string) *ImportComponentInput {
	s.Data = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ImportComponentInput) SetDescription(v string) *ImportComponentInput {
	s.Description = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportComponentInput) SetFormat(v string) *ImportComponentInput {
	s.Format = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ImportComponentInput) SetKmsKeyId(v string) *ImportComponentInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportComponentInput) SetName(v string) *ImportComponentInput {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImportComponentInput) SetPlatform(v string) *ImportComponentInput {
	s.Platform = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *ImportComponentInput) SetSemanticVersion(v string) *ImportComponentInput {
	s.SemanticVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportComponentInput) SetTags(v map[string]*string) *ImportComponentInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ImportComponentInput) SetType(v string) *ImportComponentInput {
	s.Type = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *ImportComponentInput) SetUri(v string) *ImportComponentInput {
	s.Uri = &v
	return s
}

type ImportComponentOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the imported component.
	ComponentBuildVersionArn *string `locationName:"componentBuildVersionArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportComponentOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *ImportComponentOutput) SetClientToken(v string) *ImportComponentOutput {
	s.ClientToken = &v
	return s
}

// SetComponentBuildVersionArn sets the ComponentBuildVersionArn field's value.
func (s *ImportComponentOutput) SetComponentBuildVersionArn(v string) *ImportComponentOutput {
	s.ComponentBuildVersionArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ImportComponentOutput) SetRequestId(v string) *ImportComponentOutput {
	s.RequestId = &v
	return s
}

type ImportVmImageInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// in the Amazon EC2 API Reference.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description for the base image that is created by the import process.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the base image that is created by the import process.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The operating system version for the imported VM.
	OsVersion *string `locationName:"osVersion" min:"1" type:"string"`

	// The operating system platform for the imported VM.
	//
	// Platform is a required field
	Platform *string `locationName:"platform" type:"string" required:"true" enum:"Platform"`

	// The semantic version to attach to the base image that was created during
	// the import process. This version follows the semantic version syntax.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth
	// node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose
	// a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// Tags that are attached to the import resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The importTaskId (API) or ImportTaskId (CLI) from the Amazon EC2 VM import
	// process. Image Builder retrieves information from the import process to pull
	// in the AMI that is created from the VM source as the base image for your
	// recipe.
	//
	// VmImportTaskId is a required field
	VmImportTaskId *string `locationName:"vmImportTaskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportVmImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportVmImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportVmImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportVmImageInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OsVersion != nil && len(*s.OsVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OsVersion", 1))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}
	if s.SemanticVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SemanticVersion"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VmImportTaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("VmImportTaskId"))
	}
	if s.VmImportTaskId != nil && len(*s.VmImportTaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VmImportTaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ImportVmImageInput) SetClientToken(v string) *ImportVmImageInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ImportVmImageInput) SetDescription(v string) *ImportVmImageInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportVmImageInput) SetName(v string) *ImportVmImageInput {
	s.Name = &v
	return s
}

// SetOsVersion sets the OsVersion field's value.
func (s *ImportVmImageInput) SetOsVersion(v string) *ImportVmImageInput {
	s.OsVersion = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImportVmImageInput) SetPlatform(v string) *ImportVmImageInput {
	s.Platform = &v
	return s
}

// SetSemanticVersion sets the SemanticVersion field's value.
func (s *ImportVmImageInput) SetSemanticVersion(v string) *ImportVmImageInput {
	s.SemanticVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportVmImageInput) SetTags(v map[string]*string) *ImportVmImageInput {
	s.Tags = v
	return s
}

// SetVmImportTaskId sets the VmImportTaskId field's value.
func (s *ImportVmImageInput) SetVmImportTaskId(v string) *ImportVmImageInput {
	s.VmImportTaskId = &v
	return s
}

type ImportVmImageOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token that was used for this request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the AMI that was created during the VM
	// import process. This AMI is used as the base image for the recipe that imported
	// the VM.
	ImageArn *string `locationName:"imageArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportVmImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportVmImageOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *ImportVmImageOutput) SetClientToken(v string) *ImportVmImageOutput {
	s.ClientToken = &v
	return s
}

// SetImageArn sets the ImageArn field's value.
func (s *ImportVmImageOutput) SetImageArn(v string) *ImportVmImageOutput {
	s.ImageArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ImportVmImageOutput) SetRequestId(v string) *ImportVmImageOutput {
	s.RequestId = &v
	return s
}

// Details of the infrastructure configuration.
type InfrastructureConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which the infrastructure configuration was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which the infrastructure configuration was last updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the infrastructure configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The instance metadata option settings for the infrastructure configuration.
	InstanceMetadataOptions *InstanceMetadataOptions `locationName:"instanceMetadataOptions" type:"structure"`

	// The instance profile of the infrastructure configuration.
	InstanceProfileName *string `locationName:"instanceProfileName" min:"1" type:"string"`

	// The instance types of the infrastructure configuration.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The Amazon EC2 key pair of the infrastructure configuration.
	KeyPair *string `locationName:"keyPair" min:"1" type:"string"`

	// The logging configuration of the infrastructure configuration.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the infrastructure configuration.
	Name *string `locationName:"name" type:"string"`

	// The tags attached to the resource created by Image Builder.
	ResourceTags map[string]*string `locationName:"resourceTags" min:"1" type:"map"`

	// The security group IDs of the infrastructure configuration.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The Amazon Resource Name (ARN) for the SNS topic to which we send image build
	// event notifications.
	//
	// EC2 Image Builder is unable to send notifications to SNS topics that are
	// encrypted using keys from other accounts. The key that is used to encrypt
	// the SNS topic must reside in the account that the Image Builder service runs
	// under.
	SnsTopicArn *string `locationName:"snsTopicArn" min:"1" type:"string"`

	// The subnet ID of the infrastructure configuration.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`

	// The tags of the infrastructure configuration.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The terminate instance on failure configuration of the infrastructure configuration.
	TerminateInstanceOnFailure *bool `locationName:"terminateInstanceOnFailure" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InfrastructureConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InfrastructureConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InfrastructureConfiguration) SetArn(v string) *InfrastructureConfiguration {
	s.Arn = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *InfrastructureConfiguration) SetDateCreated(v string) *InfrastructureConfiguration {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *InfrastructureConfiguration) SetDateUpdated(v string) *InfrastructureConfiguration {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *InfrastructureConfiguration) SetDescription(v string) *InfrastructureConfiguration {
	s.Description = &v
	return s
}

// SetInstanceMetadataOptions sets the InstanceMetadataOptions field's value.
func (s *InfrastructureConfiguration) SetInstanceMetadataOptions(v *InstanceMetadataOptions) *InfrastructureConfiguration {
	s.InstanceMetadataOptions = v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *InfrastructureConfiguration) SetInstanceProfileName(v string) *InfrastructureConfiguration {
	s.InstanceProfileName = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *InfrastructureConfiguration) SetInstanceTypes(v []*string) *InfrastructureConfiguration {
	s.InstanceTypes = v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *InfrastructureConfiguration) SetKeyPair(v string) *InfrastructureConfiguration {
	s.KeyPair = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *InfrastructureConfiguration) SetLogging(v *Logging) *InfrastructureConfiguration {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *InfrastructureConfiguration) SetName(v string) *InfrastructureConfiguration {
	s.Name = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *InfrastructureConfiguration) SetResourceTags(v map[string]*string) *InfrastructureConfiguration {
	s.ResourceTags = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *InfrastructureConfiguration) SetSecurityGroupIds(v []*string) *InfrastructureConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *InfrastructureConfiguration) SetSnsTopicArn(v string) *InfrastructureConfiguration {
	s.SnsTopicArn = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *InfrastructureConfiguration) SetSubnetId(v string) *InfrastructureConfiguration {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InfrastructureConfiguration) SetTags(v map[string]*string) *InfrastructureConfiguration {
	s.Tags = v
	return s
}

// SetTerminateInstanceOnFailure sets the TerminateInstanceOnFailure field's value.
func (s *InfrastructureConfiguration) SetTerminateInstanceOnFailure(v bool) *InfrastructureConfiguration {
	s.TerminateInstanceOnFailure = &v
	return s
}

// The infrastructure used when building Amazon EC2 AMIs.
type InfrastructureConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which the infrastructure configuration was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which the infrastructure configuration was last updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the infrastructure configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The instance profile of the infrastructure configuration.
	InstanceProfileName *string `locationName:"instanceProfileName" min:"1" type:"string"`

	// The instance types of the infrastructure configuration.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The name of the infrastructure configuration.
	Name *string `locationName:"name" type:"string"`

	// The tags attached to the image created by Image Builder.
	ResourceTags map[string]*string `locationName:"resourceTags" min:"1" type:"map"`

	// The tags of the infrastructure configuration.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InfrastructureConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InfrastructureConfigurationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InfrastructureConfigurationSummary) SetArn(v string) *InfrastructureConfigurationSummary {
	s.Arn = &v
	return s
}

// SetDateCreated sets the DateCreated field's value.
func (s *InfrastructureConfigurationSummary) SetDateCreated(v string) *InfrastructureConfigurationSummary {
	s.DateCreated = &v
	return s
}

// SetDateUpdated sets the DateUpdated field's value.
func (s *InfrastructureConfigurationSummary) SetDateUpdated(v string) *InfrastructureConfigurationSummary {
	s.DateUpdated = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *InfrastructureConfigurationSummary) SetDescription(v string) *InfrastructureConfigurationSummary {
	s.Description = &v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *InfrastructureConfigurationSummary) SetInstanceProfileName(v string) *InfrastructureConfigurationSummary {
	s.InstanceProfileName = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *InfrastructureConfigurationSummary) SetInstanceTypes(v []*string) *InfrastructureConfigurationSummary {
	s.InstanceTypes = v
	return s
}

// SetName sets the Name field's value.
func (s *InfrastructureConfigurationSummary) SetName(v string) *InfrastructureConfigurationSummary {
	s.Name = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *InfrastructureConfigurationSummary) SetResourceTags(v map[string]*string) *InfrastructureConfigurationSummary {
	s.ResourceTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *InfrastructureConfigurationSummary) SetTags(v map[string]*string) *InfrastructureConfigurationSummary {
	s.Tags = v
	return s
}

// Defines block device mappings for the instance used to configure your image.
type InstanceBlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device to which these mappings apply.
	DeviceName *string `locationName:"deviceName" min:"1" type:"string"`

	// Use to manage Amazon EBS-specific configuration for this mapping.
	Ebs *EbsInstanceBlockDeviceSpecification `locationName:"ebs" type:"structure"`

	// Use to remove a mapping from the base image.
	NoDevice *string `locationName:"noDevice" type:"string"`

	// Use to manage instance ephemeral devices.
	VirtualName *string `locationName:"virtualName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceBlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceBlockDeviceMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceBlockDeviceMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceBlockDeviceMapping"}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}
	if s.VirtualName != nil && len(*s.VirtualName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualName", 1))
	}
	if s.Ebs != nil {
		if err := s.Ebs.Validate(); err != nil {
			invalidParams.AddNested("Ebs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceName sets the DeviceName field's value.
func (s *InstanceBlockDeviceMapping) SetDeviceName(v string) *InstanceBlockDeviceMapping {
	s.DeviceName = &v
	return s
}

// SetEbs sets the Ebs field's value.
func (s *InstanceBlockDeviceMapping) SetEbs(v *EbsInstanceBlockDeviceSpecification) *InstanceBlockDeviceMapping {
	s.Ebs = v
	return s
}

// SetNoDevice sets the NoDevice field's value.
func (s *InstanceBlockDeviceMapping) SetNoDevice(v string) *InstanceBlockDeviceMapping {
	s.NoDevice = &v
	return s
}

// SetVirtualName sets the VirtualName field's value.
func (s *InstanceBlockDeviceMapping) SetVirtualName(v string) *InstanceBlockDeviceMapping {
	s.VirtualName = &v
	return s
}

// Defines a custom base AMI and block device mapping configurations of an instance
// used for building and testing container images.
type InstanceConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the block devices to attach for building an instance from this Image
	// Builder AMI.
	BlockDeviceMappings []*InstanceBlockDeviceMapping `locationName:"blockDeviceMappings" type:"list"`

	// The AMI ID to use as the base image for a container build and test instance.
	// If not specified, Image Builder will use the appropriate ECS-optimized AMI
	// as a base image.
	Image *string `locationName:"image" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceConfiguration"}
	if s.Image != nil && len(*s.Image) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Image", 1))
	}
	if s.BlockDeviceMappings != nil {
		for i, v := range s.BlockDeviceMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BlockDeviceMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *InstanceConfiguration) SetBlockDeviceMappings(v []*InstanceBlockDeviceMapping) *InstanceConfiguration {
	s.BlockDeviceMappings = v
	return s
}

// SetImage sets the Image field's value.
func (s *InstanceConfiguration) SetImage(v string) *InstanceConfiguration {
	s.Image = &v
	return s
}

// The instance metadata options that apply to the HTTP requests that pipeline
// builds use to launch EC2 build and test instances. For more information about
// instance metadata options, see Configure the instance metadata options (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html)
// in the Amazon EC2 User Guide for Linux instances, or Configure the instance
// metadata options (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html)
// in the Amazon EC2 Windows Guide for Windows instances.
type InstanceMetadataOptions struct {
	_ struct{} `type:"structure"`

	// Limit the number of hops that an instance metadata request can traverse to
	// reach its destination. The default is one hop. However, if HTTP tokens are
	// required, container image builds need a minimum of two hops.
	HttpPutResponseHopLimit *int64 `locationName:"httpPutResponseHopLimit" min:"1" type:"integer"`

	// Indicates whether a signed token header is required for instance metadata
	// retrieval requests. The values affect the response as follows:
	//
	//    * required – When you retrieve the IAM role credentials, version 2.0
	//    credentials are returned in all cases.
	//
	//    * optional – You can include a signed token header in your request to
	//    retrieve instance metadata, or you can leave it out. If you include it,
	//    version 2.0 credentials are returned for the IAM role. Otherwise, version
	//    1.0 credentials are returned.
	//
	// The default setting is optional.
	HttpTokens *string `locationName:"httpTokens" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceMetadataOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceMetadataOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceMetadataOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceMetadataOptions"}
	if s.HttpPutResponseHopLimit != nil && *s.HttpPutResponseHopLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HttpPutResponseHopLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpPutResponseHopLimit sets the HttpPutResponseHopLimit field's value.
func (s *InstanceMetadataOptions) SetHttpPutResponseHopLimit(v int64) *InstanceMetadataOptions {
	s.HttpPutResponseHopLimit = &v
	return s
}

// SetHttpTokens sets the HttpTokens field's value.
func (s *InstanceMetadataOptions) SetHttpTokens(v string) *InstanceMetadataOptions {
	s.HttpTokens = &v
	return s
}

// You have provided an invalid pagination token in your request.
type InvalidPaginationTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidPaginationTokenException(v protocol.ResponseMetadata) error {
	return &InvalidPaginationTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPaginationTokenException) Code() string {
	return "InvalidPaginationTokenException"
}

// Message returns the exception's message.
func (s *InvalidPaginationTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPaginationTokenException) OrigErr() error {
	return nil
}

func (s *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPaginationTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPaginationTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have specified two or more mutually exclusive parameters. Review the
// error message for details.
type InvalidParameterCombinationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterCombinationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterCombinationException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterCombinationException(v protocol.ResponseMetadata) error {
	return &InvalidParameterCombinationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterCombinationException) Code() string {
	return "InvalidParameterCombinationException"
}

// Message returns the exception's message.
func (s *InvalidParameterCombinationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterCombinationException) OrigErr() error {
	return nil
}

func (s *InvalidParameterCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterCombinationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterCombinationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified parameter is invalid. Review the available parameters for the
// API request.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The value that you provided for the specified parameter is invalid.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have made a request for an action that is not supported by the service.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your version number is out of bounds or does not follow the required syntax.
type InvalidVersionNumberException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidVersionNumberException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidVersionNumberException) GoString() string {
	return s.String()
}

func newErrorInvalidVersionNumberException(v protocol.ResponseMetadata) error {
	return &InvalidVersionNumberException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidVersionNumberException) Code() string {
	return "InvalidVersionNumberException"
}

// Message returns the exception's message.
func (s *InvalidVersionNumberException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidVersionNumberException) OrigErr() error {
	return nil
}

func (s *InvalidVersionNumberException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidVersionNumberException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidVersionNumberException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the configuration for a launch permission. The launch permission
// modification request is sent to the Amazon EC2 ModifyImageAttribute (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html)
// API on behalf of the user for each Region they have selected to distribute
// the AMI. To make an AMI public, set the launch permission authorized accounts
// to all. See the examples for making an AMI public at Amazon EC2 ModifyImageAttribute
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html).
type LaunchPermissionConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN for an Amazon Web Services Organization that you want to share your
	// AMI with. For more information, see What is Organizations? (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html).
	OrganizationArns []*string `locationName:"organizationArns" min:"1" type:"list"`

	// The ARN for an Organizations organizational unit (OU) that you want to share
	// your AMI with. For more information about key concepts for Organizations,
	// see Organizations terminology and concepts (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html).
	OrganizationalUnitArns []*string `locationName:"organizationalUnitArns" min:"1" type:"list"`

	// The name of the group.
	UserGroups []*string `locationName:"userGroups" type:"list"`

	// The Amazon Web Services account ID.
	UserIds []*string `locationName:"userIds" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchPermissionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchPermissionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchPermissionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchPermissionConfiguration"}
	if s.OrganizationArns != nil && len(s.OrganizationArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationArns", 1))
	}
	if s.OrganizationalUnitArns != nil && len(s.OrganizationalUnitArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationalUnitArns", 1))
	}
	if s.UserIds != nil && len(s.UserIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationArns sets the OrganizationArns field's value.
func (s *LaunchPermissionConfiguration) SetOrganizationArns(v []*string) *LaunchPermissionConfiguration {
	s.OrganizationArns = v
	return s
}

// SetOrganizationalUnitArns sets the OrganizationalUnitArns field's value.
func (s *LaunchPermissionConfiguration) SetOrganizationalUnitArns(v []*string) *LaunchPermissionConfiguration {
	s.OrganizationalUnitArns = v
	return s
}

// SetUserGroups sets the UserGroups field's value.
func (s *LaunchPermissionConfiguration) SetUserGroups(v []*string) *LaunchPermissionConfiguration {
	s.UserGroups = v
	return s
}

// SetUserIds sets the UserIds field's value.
func (s *LaunchPermissionConfiguration) SetUserIds(v []*string) *LaunchPermissionConfiguration {
	s.UserIds = v
	return s
}

// Identifies an Amazon EC2 launch template to use for a specific account.
type LaunchTemplateConfiguration struct {
	_ struct{} `type:"structure"`

	// The account ID that this configuration applies to.
	AccountId *string `locationName:"accountId" type:"string"`

	// Identifies the Amazon EC2 launch template to use.
	//
	// LaunchTemplateId is a required field
	LaunchTemplateId *string `locationName:"launchTemplateId" type:"string" required:"true"`

	// Set the specified Amazon EC2 launch template as the default launch template
	// for the specified account.
	SetDefaultVersion *bool `locationName:"setDefaultVersion" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchTemplateConfiguration"}
	if s.LaunchTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchTemplateId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *LaunchTemplateConfiguration) SetAccountId(v string) *LaunchTemplateConfiguration {
	s.AccountId = &v
	return s
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *LaunchTemplateConfiguration) SetLaunchTemplateId(v string) *LaunchTemplateConfiguration {
	s.LaunchTemplateId = &v
	return s
}

// SetSetDefaultVersion sets the SetDefaultVersion field's value.
func (s *LaunchTemplateConfiguration) SetSetDefaultVersion(v bool) *LaunchTemplateConfiguration {
	s.SetDefaultVersion = &v
	return s
}

type ListComponentBuildVersionsInput struct {
	_ struct{} `type:"structure"`

	// The component version Amazon Resource Name (ARN) whose versions you want
	// to list.
	//
	// ComponentVersionArn is a required field
	ComponentVersionArn *string `locationName:"componentVersionArn" type:"string" required:"true"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentBuildVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentBuildVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentBuildVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentBuildVersionsInput"}
	if s.ComponentVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentVersionArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentVersionArn sets the ComponentVersionArn field's value.
func (s *ListComponentBuildVersionsInput) SetComponentVersionArn(v string) *ListComponentBuildVersionsInput {
	s.ComponentVersionArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentBuildVersionsInput) SetMaxResults(v int64) *ListComponentBuildVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentBuildVersionsInput) SetNextToken(v string) *ListComponentBuildVersionsInput {
	s.NextToken = &v
	return s
}

type ListComponentBuildVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of component summaries for the specified semantic version.
	ComponentSummaryList []*ComponentSummary `locationName:"componentSummaryList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentBuildVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentBuildVersionsOutput) GoString() string {
	return s.String()
}

// SetComponentSummaryList sets the ComponentSummaryList field's value.
func (s *ListComponentBuildVersionsOutput) SetComponentSummaryList(v []*ComponentSummary) *ListComponentBuildVersionsOutput {
	s.ComponentSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentBuildVersionsOutput) SetNextToken(v string) *ListComponentBuildVersionsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListComponentBuildVersionsOutput) SetRequestId(v string) *ListComponentBuildVersionsOutput {
	s.RequestId = &v
	return s
}

type ListComponentsInput struct {
	_ struct{} `type:"structure"`

	// Returns the list of components for the specified name.
	ByName *bool `locationName:"byName" type:"boolean"`

	// Use the following filters to streamline results:
	//
	//    * description
	//
	//    * name
	//
	//    * platform
	//
	//    * supportedOsVersion
	//
	//    * type
	//
	//    * version
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Filters results based on the type of owner for the component. By default,
	// this request returns a list of components that your account owns. To see
	// results for other types of owners, you can specify components that Amazon
	// manages, third party components, or components that other accounts have shared
	// with you.
	Owner *string `locationName:"owner" type:"string" enum:"Ownership"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByName sets the ByName field's value.
func (s *ListComponentsInput) SetByName(v bool) *ListComponentsInput {
	s.ByName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListComponentsInput) SetFilters(v []*Filter) *ListComponentsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentsInput) SetMaxResults(v int64) *ListComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsInput) SetNextToken(v string) *ListComponentsInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListComponentsInput) SetOwner(v string) *ListComponentsInput {
	s.Owner = &v
	return s
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of component semantic versions.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	ComponentVersionList []*ComponentVersion `locationName:"componentVersionList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) GoString() string {
	return s.String()
}

// SetComponentVersionList sets the ComponentVersionList field's value.
func (s *ListComponentsOutput) SetComponentVersionList(v []*ComponentVersion) *ListComponentsOutput {
	s.ComponentVersionList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsOutput) SetNextToken(v string) *ListComponentsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListComponentsOutput) SetRequestId(v string) *ListComponentsOutput {
	s.RequestId = &v
	return s
}

type ListContainerRecipesInput struct {
	_ struct{} `type:"structure"`

	// Use the following filters to streamline results:
	//
	//    * containerType
	//
	//    * name
	//
	//    * parentImage
	//
	//    * platform
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The maximum number of results to return in the list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Provides a token for pagination, which determines where to begin the next
	// set of results when the current set reaches the maximum for one request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Returns container recipes belonging to the specified owner, that have been
	// shared with you. You can omit this field to return container recipes belonging
	// to your account.
	Owner *string `locationName:"owner" type:"string" enum:"Ownership"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainerRecipesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainerRecipesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContainerRecipesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContainerRecipesInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListContainerRecipesInput) SetFilters(v []*Filter) *ListContainerRecipesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContainerRecipesInput) SetMaxResults(v int64) *ListContainerRecipesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContainerRecipesInput) SetNextToken(v string) *ListContainerRecipesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListContainerRecipesInput) SetOwner(v string) *ListContainerRecipesInput {
	s.Owner = &v
	return s
}

type ListContainerRecipesOutput struct {
	_ struct{} `type:"structure"`

	// The list of container recipes returned for the request.
	ContainerRecipeSummaryList []*ContainerRecipeSummary `locationName:"containerRecipeSummaryList" type:"list"`

	// The next token field is used for paginated responses. When this is not empty,
	// there are additional container recipes that the service has not included
	// in this response. Use this token with the next request to retrieve additional
	// list items.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainerRecipesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContainerRecipesOutput) GoString() string {
	return s.String()
}

// SetContainerRecipeSummaryList sets the ContainerRecipeSummaryList field's value.
func (s *ListContainerRecipesOutput) SetContainerRecipeSummaryList(v []*ContainerRecipeSummary) *ListContainerRecipesOutput {
	s.ContainerRecipeSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContainerRecipesOutput) SetNextToken(v string) *ListContainerRecipesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListContainerRecipesOutput) SetRequestId(v string) *ListContainerRecipesOutput {
	s.RequestId = &v
	return s
}

type ListDistributionConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// You can filter on name to streamline results.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDistributionConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDistributionConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDistributionConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDistributionConfigurationsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListDistributionConfigurationsInput) SetFilters(v []*Filter) *ListDistributionConfigurationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDistributionConfigurationsInput) SetMaxResults(v int64) *ListDistributionConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDistributionConfigurationsInput) SetNextToken(v string) *ListDistributionConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListDistributionConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of distributions.
	DistributionConfigurationSummaryList []*DistributionConfigurationSummary `locationName:"distributionConfigurationSummaryList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDistributionConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDistributionConfigurationsOutput) GoString() string {
	return s.String()
}

// SetDistributionConfigurationSummaryList sets the DistributionConfigurationSummaryList field's value.
func (s *ListDistributionConfigurationsOutput) SetDistributionConfigurationSummaryList(v []*DistributionConfigurationSummary) *ListDistributionConfigurationsOutput {
	s.DistributionConfigurationSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDistributionConfigurationsOutput) SetNextToken(v string) *ListDistributionConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListDistributionConfigurationsOutput) SetRequestId(v string) *ListDistributionConfigurationsOutput {
	s.RequestId = &v
	return s
}

type ListImageBuildVersionsInput struct {
	_ struct{} `type:"structure"`

	// Use the following filters to streamline results:
	//
	//    * name
	//
	//    * osVersion
	//
	//    * platform
	//
	//    * type
	//
	//    * version
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the image whose build versions you want
	// to retrieve.
	//
	// ImageVersionArn is a required field
	ImageVersionArn *string `locationName:"imageVersionArn" type:"string" required:"true"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageBuildVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageBuildVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImageBuildVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImageBuildVersionsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.ImageVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageVersionArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListImageBuildVersionsInput) SetFilters(v []*Filter) *ListImageBuildVersionsInput {
	s.Filters = v
	return s
}

// SetImageVersionArn sets the ImageVersionArn field's value.
func (s *ListImageBuildVersionsInput) SetImageVersionArn(v string) *ListImageBuildVersionsInput {
	s.ImageVersionArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImageBuildVersionsInput) SetMaxResults(v int64) *ListImageBuildVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImageBuildVersionsInput) SetNextToken(v string) *ListImageBuildVersionsInput {
	s.NextToken = &v
	return s
}

type ListImageBuildVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of image build versions.
	ImageSummaryList []*ImageSummary `locationName:"imageSummaryList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageBuildVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageBuildVersionsOutput) GoString() string {
	return s.String()
}

// SetImageSummaryList sets the ImageSummaryList field's value.
func (s *ListImageBuildVersionsOutput) SetImageSummaryList(v []*ImageSummary) *ListImageBuildVersionsOutput {
	s.ImageSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImageBuildVersionsOutput) SetNextToken(v string) *ListImageBuildVersionsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListImageBuildVersionsOutput) SetRequestId(v string) *ListImageBuildVersionsOutput {
	s.RequestId = &v
	return s
}

type ListImagePackagesInput struct {
	_ struct{} `type:"structure"`

	// Filter results for the ListImagePackages request by the Image Build Version
	// ARN
	//
	// ImageBuildVersionArn is a required field
	ImageBuildVersionArn *string `locationName:"imageBuildVersionArn" type:"string" required:"true"`

	// The maxiumum number of results to return from the ListImagePackages request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePackagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImagePackagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImagePackagesInput"}
	if s.ImageBuildVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageBuildVersionArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageBuildVersionArn sets the ImageBuildVersionArn field's value.
func (s *ListImagePackagesInput) SetImageBuildVersionArn(v string) *ListImagePackagesInput {
	s.ImageBuildVersionArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImagePackagesInput) SetMaxResults(v int64) *ListImagePackagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagePackagesInput) SetNextToken(v string) *ListImagePackagesInput {
	s.NextToken = &v
	return s
}

type ListImagePackagesOutput struct {
	_ struct{} `type:"structure"`

	// The list of Image Packages returned in the response.
	ImagePackageList []*ImagePackage `locationName:"imagePackageList" type:"list"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePackagesOutput) GoString() string {
	return s.String()
}

// SetImagePackageList sets the ImagePackageList field's value.
func (s *ListImagePackagesOutput) SetImagePackageList(v []*ImagePackage) *ListImagePackagesOutput {
	s.ImagePackageList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagePackagesOutput) SetNextToken(v string) *ListImagePackagesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListImagePackagesOutput) SetRequestId(v string) *ListImagePackagesOutput {
	s.RequestId = &v
	return s
}

type ListImagePipelineImagesInput struct {
	_ struct{} `type:"structure"`

	// Use the following filters to streamline results:
	//
	//    * name
	//
	//    * version
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the image pipeline whose images you want
	// to view.
	//
	// ImagePipelineArn is a required field
	ImagePipelineArn *string `locationName:"imagePipelineArn" type:"string" required:"true"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePipelineImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePipelineImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImagePipelineImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImagePipelineImagesInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.ImagePipelineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImagePipelineArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListImagePipelineImagesInput) SetFilters(v []*Filter) *ListImagePipelineImagesInput {
	s.Filters = v
	return s
}

// SetImagePipelineArn sets the ImagePipelineArn field's value.
func (s *ListImagePipelineImagesInput) SetImagePipelineArn(v string) *ListImagePipelineImagesInput {
	s.ImagePipelineArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImagePipelineImagesInput) SetMaxResults(v int64) *ListImagePipelineImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagePipelineImagesInput) SetNextToken(v string) *ListImagePipelineImagesInput {
	s.NextToken = &v
	return s
}

type ListImagePipelineImagesOutput struct {
	_ struct{} `type:"structure"`

	// The list of images built by this pipeline.
	ImageSummaryList []*ImageSummary `locationName:"imageSummaryList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePipelineImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePipelineImagesOutput) GoString() string {
	return s.String()
}

// SetImageSummaryList sets the ImageSummaryList field's value.
func (s *ListImagePipelineImagesOutput) SetImageSummaryList(v []*ImageSummary) *ListImagePipelineImagesOutput {
	s.ImageSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagePipelineImagesOutput) SetNextToken(v string) *ListImagePipelineImagesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListImagePipelineImagesOutput) SetRequestId(v string) *ListImagePipelineImagesOutput {
	s.RequestId = &v
	return s
}

type ListImagePipelinesInput struct {
	_ struct{} `type:"structure"`

	// Use the following filters to streamline results:
	//
	//    * description
	//
	//    * distributionConfigurationArn
	//
	//    * imageRecipeArn
	//
	//    * infrastructureConfigurationArn
	//
	//    * name
	//
	//    * status
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImagePipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImagePipelinesInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListImagePipelinesInput) SetFilters(v []*Filter) *ListImagePipelinesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImagePipelinesInput) SetMaxResults(v int64) *ListImagePipelinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagePipelinesInput) SetNextToken(v string) *ListImagePipelinesInput {
	s.NextToken = &v
	return s
}

type ListImagePipelinesOutput struct {
	_ struct{} `type:"structure"`

	// The list of image pipelines.
	ImagePipelineList []*ImagePipeline `locationName:"imagePipelineList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagePipelinesOutput) GoString() string {
	return s.String()
}

// SetImagePipelineList sets the ImagePipelineList field's value.
func (s *ListImagePipelinesOutput) SetImagePipelineList(v []*ImagePipeline) *ListImagePipelinesOutput {
	s.ImagePipelineList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagePipelinesOutput) SetNextToken(v string) *ListImagePipelinesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListImagePipelinesOutput) SetRequestId(v string) *ListImagePipelinesOutput {
	s.RequestId = &v
	return s
}

type ListImageRecipesInput struct {
	_ struct{} `type:"structure"`

	// Use the following filters to streamline results:
	//
	//    * name
	//
	//    * parentImage
	//
	//    * platform
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The owner defines which image recipes you want to list. By default, this
	// request will only show image recipes owned by your account. You can use this
	// field to specify if you want to view image recipes owned by yourself, by
	// Amazon, or those image recipes that have been shared with you by other customers.
	Owner *string `locationName:"owner" type:"string" enum:"Ownership"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageRecipesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageRecipesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImageRecipesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImageRecipesInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListImageRecipesInput) SetFilters(v []*Filter) *ListImageRecipesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImageRecipesInput) SetMaxResults(v int64) *ListImageRecipesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImageRecipesInput) SetNextToken(v string) *ListImageRecipesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListImageRecipesInput) SetOwner(v string) *ListImageRecipesInput {
	s.Owner = &v
	return s
}

type ListImageRecipesOutput struct {
	_ struct{} `type:"structure"`

	// The list of image pipelines.
	ImageRecipeSummaryList []*ImageRecipeSummary `locationName:"imageRecipeSummaryList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageRecipesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageRecipesOutput) GoString() string {
	return s.String()
}

// SetImageRecipeSummaryList sets the ImageRecipeSummaryList field's value.
func (s *ListImageRecipesOutput) SetImageRecipeSummaryList(v []*ImageRecipeSummary) *ListImageRecipesOutput {
	s.ImageRecipeSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImageRecipesOutput) SetNextToken(v string) *ListImageRecipesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListImageRecipesOutput) SetRequestId(v string) *ListImageRecipesOutput {
	s.RequestId = &v
	return s
}

type ListImagesInput struct {
	_ struct{} `type:"structure"`

	// Requests a list of images with a specific recipe name.
	ByName *bool `locationName:"byName" type:"boolean"`

	// Use the following filters to streamline results:
	//
	//    * name
	//
	//    * osVersion
	//
	//    * platform
	//
	//    * type
	//
	//    * version
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// Includes deprecated images in the response list.
	IncludeDeprecated *bool `locationName:"includeDeprecated" type:"boolean"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The owner defines which images you want to list. By default, this request
	// will only show images owned by your account. You can use this field to specify
	// if you want to view images owned by yourself, by Amazon, or those images
	// that have been shared with you by other customers.
	Owner *string `locationName:"owner" type:"string" enum:"Ownership"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImagesInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByName sets the ByName field's value.
func (s *ListImagesInput) SetByName(v bool) *ListImagesInput {
	s.ByName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListImagesInput) SetFilters(v []*Filter) *ListImagesInput {
	s.Filters = v
	return s
}

// SetIncludeDeprecated sets the IncludeDeprecated field's value.
func (s *ListImagesInput) SetIncludeDeprecated(v bool) *ListImagesInput {
	s.IncludeDeprecated = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImagesInput) SetMaxResults(v int64) *ListImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagesInput) SetNextToken(v string) *ListImagesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListImagesInput) SetOwner(v string) *ListImagesInput {
	s.Owner = &v
	return s
}

type ListImagesOutput struct {
	_ struct{} `type:"structure"`

	// The list of image semantic versions.
	//
	// The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You
	// can assign values for the first three, and can filter on all of them.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base
	// image or components for your recipe. When you use a wildcard in any node,
	// all nodes to the right of the first wildcard must also be wildcards.
	ImageVersionList []*ImageVersion `locationName:"imageVersionList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImagesOutput) GoString() string {
	return s.String()
}

// SetImageVersionList sets the ImageVersionList field's value.
func (s *ListImagesOutput) SetImageVersionList(v []*ImageVersion) *ListImagesOutput {
	s.ImageVersionList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagesOutput) SetNextToken(v string) *ListImagesOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListImagesOutput) SetRequestId(v string) *ListImagesOutput {
	s.RequestId = &v
	return s
}

type ListInfrastructureConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// You can filter on name to streamline results.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInfrastructureConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInfrastructureConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInfrastructureConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInfrastructureConfigurationsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListInfrastructureConfigurationsInput) SetFilters(v []*Filter) *ListInfrastructureConfigurationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInfrastructureConfigurationsInput) SetMaxResults(v int64) *ListInfrastructureConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInfrastructureConfigurationsInput) SetNextToken(v string) *ListInfrastructureConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListInfrastructureConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of infrastructure configurations.
	InfrastructureConfigurationSummaryList []*InfrastructureConfigurationSummary `locationName:"infrastructureConfigurationSummaryList" type:"list"`

	// The next token used for paginated responses. When this is not empty, there
	// are additional elements that the service has not included in this request.
	// Use this token with the next request to retrieve additional objects.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInfrastructureConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInfrastructureConfigurationsOutput) GoString() string {
	return s.String()
}

// SetInfrastructureConfigurationSummaryList sets the InfrastructureConfigurationSummaryList field's value.
func (s *ListInfrastructureConfigurationsOutput) SetInfrastructureConfigurationSummaryList(v []*InfrastructureConfigurationSummary) *ListInfrastructureConfigurationsOutput {
	s.InfrastructureConfigurationSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInfrastructureConfigurationsOutput) SetNextToken(v string) *ListInfrastructureConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *ListInfrastructureConfigurationsOutput) SetRequestId(v string) *ListInfrastructureConfigurationsOutput {
	s.RequestId = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the specified resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Logging configuration defines where Image Builder uploads your logs.
type Logging struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 logging configuration.
	S3Logs *S3Logs `locationName:"s3Logs" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Logging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Logging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Logging"}
	if s.S3Logs != nil {
		if err := s.S3Logs.Validate(); err != nil {
			invalidParams.AddNested("S3Logs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Logs sets the S3Logs field's value.
func (s *Logging) SetS3Logs(v *S3Logs) *Logging {
	s.S3Logs = v
	return s
}

// The resources produced by this image.
type OutputResources struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 AMIs created by this image.
	Amis []*Ami `locationName:"amis" type:"list"`

	// Container images that the pipeline has generated and stored in the output
	// repository.
	Containers []*Container `locationName:"containers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputResources) GoString() string {
	return s.String()
}

// SetAmis sets the Amis field's value.
func (s *OutputResources) SetAmis(v []*Ami) *OutputResources {
	s.Amis = v
	return s
}

// SetContainers sets the Containers field's value.
func (s *OutputResources) SetContainers(v []*Container) *OutputResources {
	s.Containers = v
	return s
}

type PutComponentPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component that this policy should be
	// applied to.
	//
	// ComponentArn is a required field
	ComponentArn *string `locationName:"componentArn" type:"string" required:"true"`

	// The policy to apply.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutComponentPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutComponentPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutComponentPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutComponentPolicyInput"}
	if s.ComponentArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentArn"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentArn sets the ComponentArn field's value.
func (s *PutComponentPolicyInput) SetComponentArn(v string) *PutComponentPolicyInput {
	s.ComponentArn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutComponentPolicyInput) SetPolicy(v string) *PutComponentPolicyInput {
	s.Policy = &v
	return s
}

type PutComponentPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component that this policy was applied
	// to.
	ComponentArn *string `locationName:"componentArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutComponentPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutComponentPolicyOutput) GoString() string {
	return s.String()
}

// SetComponentArn sets the ComponentArn field's value.
func (s *PutComponentPolicyOutput) SetComponentArn(v string) *PutComponentPolicyOutput {
	s.ComponentArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PutComponentPolicyOutput) SetRequestId(v string) *PutComponentPolicyOutput {
	s.RequestId = &v
	return s
}

type PutContainerRecipePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container recipe that this policy should
	// be applied to.
	//
	// ContainerRecipeArn is a required field
	ContainerRecipeArn *string `locationName:"containerRecipeArn" type:"string" required:"true"`

	// The policy to apply to the container recipe.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContainerRecipePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContainerRecipePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutContainerRecipePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutContainerRecipePolicyInput"}
	if s.ContainerRecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerRecipeArn"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *PutContainerRecipePolicyInput) SetContainerRecipeArn(v string) *PutContainerRecipePolicyInput {
	s.ContainerRecipeArn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutContainerRecipePolicyInput) SetPolicy(v string) *PutContainerRecipePolicyInput {
	s.Policy = &v
	return s
}

type PutContainerRecipePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container recipe that this policy was
	// applied to.
	ContainerRecipeArn *string `locationName:"containerRecipeArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContainerRecipePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutContainerRecipePolicyOutput) GoString() string {
	return s.String()
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *PutContainerRecipePolicyOutput) SetContainerRecipeArn(v string) *PutContainerRecipePolicyOutput {
	s.ContainerRecipeArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PutContainerRecipePolicyOutput) SetRequestId(v string) *PutContainerRecipePolicyOutput {
	s.RequestId = &v
	return s
}

type PutImagePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image that this policy should be applied
	// to.
	//
	// ImageArn is a required field
	ImageArn *string `locationName:"imageArn" type:"string" required:"true"`

	// The policy to apply.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImagePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImagePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutImagePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutImagePolicyInput"}
	if s.ImageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageArn"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageArn sets the ImageArn field's value.
func (s *PutImagePolicyInput) SetImageArn(v string) *PutImagePolicyInput {
	s.ImageArn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutImagePolicyInput) SetPolicy(v string) *PutImagePolicyInput {
	s.Policy = &v
	return s
}

type PutImagePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image that this policy was applied
	// to.
	ImageArn *string `locationName:"imageArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImagePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImagePolicyOutput) GoString() string {
	return s.String()
}

// SetImageArn sets the ImageArn field's value.
func (s *PutImagePolicyOutput) SetImageArn(v string) *PutImagePolicyOutput {
	s.ImageArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PutImagePolicyOutput) SetRequestId(v string) *PutImagePolicyOutput {
	s.RequestId = &v
	return s
}

type PutImageRecipePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe that this policy should
	// be applied to.
	//
	// ImageRecipeArn is a required field
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string" required:"true"`

	// The policy to apply.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImageRecipePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImageRecipePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutImageRecipePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutImageRecipePolicyInput"}
	if s.ImageRecipeArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageRecipeArn"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *PutImageRecipePolicyInput) SetImageRecipeArn(v string) *PutImageRecipePolicyInput {
	s.ImageRecipeArn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutImageRecipePolicyInput) SetPolicy(v string) *PutImageRecipePolicyInput {
	s.Policy = &v
	return s
}

type PutImageRecipePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe that this policy was applied
	// to.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImageRecipePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImageRecipePolicyOutput) GoString() string {
	return s.String()
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *PutImageRecipePolicyOutput) SetImageRecipeArn(v string) *PutImageRecipePolicyOutput {
	s.ImageRecipeArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PutImageRecipePolicyOutput) SetRequestId(v string) *PutImageRecipePolicyOutput {
	s.RequestId = &v
	return s
}

// The resource that you are trying to create already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have attempted to mutate or delete a resource with a dependency that
// prohibits this action. See the error message for more details.
type ResourceDependencyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDependencyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceDependencyException) GoString() string {
	return s.String()
}

func newErrorResourceDependencyException(v protocol.ResponseMetadata) error {
	return &ResourceDependencyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceDependencyException) Code() string {
	return "ResourceDependencyException"
}

// Message returns the exception's message.
func (s *ResourceDependencyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceDependencyException) OrigErr() error {
	return nil
}

func (s *ResourceDependencyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceDependencyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceDependencyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource that you are trying to operate on is currently in use. Review
// the message details and retry later.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// At least one of the resources referenced by your request does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Properties that configure export from your build instance to a compatible
// file format for your VM.
type S3ExportConfiguration struct {
	_ struct{} `type:"structure"`

	// Export the updated image to one of the following supported disk image formats:
	//
	//    * Virtual Hard Disk (VHD) – Compatible with Citrix Xen and Microsoft
	//    Hyper-V virtualization products.
	//
	//    * Stream-optimized ESX Virtual Machine Disk (VMDK) – Compatible with
	//    VMware ESX and VMware vSphere versions 4, 5, and 6.
	//
	//    * Raw – Raw format.
	//
	// DiskImageFormat is a required field
	DiskImageFormat *string `locationName:"diskImageFormat" type:"string" required:"true" enum:"DiskImageFormat"`

	// The name of the role that grants VM Import/Export permission to export images
	// to your S3 bucket.
	//
	// RoleName is a required field
	RoleName *string `locationName:"roleName" min:"1" type:"string" required:"true"`

	// The S3 bucket in which to store the output disk images for your VM.
	//
	// S3Bucket is a required field
	S3Bucket *string `locationName:"s3Bucket" min:"1" type:"string" required:"true"`

	// The Amazon S3 path for the bucket where the output disk images for your VM
	// are stored.
	S3Prefix *string `locationName:"s3Prefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ExportConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ExportConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ExportConfiguration"}
	if s.DiskImageFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskImageFormat"))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 1))
	}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskImageFormat sets the DiskImageFormat field's value.
func (s *S3ExportConfiguration) SetDiskImageFormat(v string) *S3ExportConfiguration {
	s.DiskImageFormat = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *S3ExportConfiguration) SetRoleName(v string) *S3ExportConfiguration {
	s.RoleName = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *S3ExportConfiguration) SetS3Bucket(v string) *S3ExportConfiguration {
	s.S3Bucket = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *S3ExportConfiguration) SetS3Prefix(v string) *S3ExportConfiguration {
	s.S3Prefix = &v
	return s
}

// Amazon S3 logging configuration.
type S3Logs struct {
	_ struct{} `type:"structure"`

	// The S3 bucket in which to store the logs.
	S3BucketName *string `locationName:"s3BucketName" min:"1" type:"string"`

	// The Amazon S3 path to the bucket where the logs are stored.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Logs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Logs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Logs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Logs"}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 1))
	}
	if s.S3KeyPrefix != nil && len(*s.S3KeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3KeyPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *S3Logs) SetS3BucketName(v string) *S3Logs {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *S3Logs) SetS3KeyPrefix(v string) *S3Logs {
	s.S3KeyPrefix = &v
	return s
}

// A schedule configures how often and when a pipeline will automatically create
// a new image.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The condition configures when the pipeline should trigger a new image build.
	// When the pipelineExecutionStartCondition is set to EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE,
	// and you use semantic version filters on the base image or components in your
	// image recipe, EC2 Image Builder will build a new image only when there are
	// new versions of the image or components in your recipe that match the semantic
	// version filter. When it is set to EXPRESSION_MATCH_ONLY, it will build a
	// new image every time the CRON expression matches the current time. For semantic
	// version syntax, see CreateComponent (https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html)
	// in the EC2 Image Builder API Reference.
	PipelineExecutionStartCondition *string `locationName:"pipelineExecutionStartCondition" type:"string" enum:"PipelineExecutionStartCondition"`

	// The cron expression determines how often EC2 Image Builder evaluates your
	// pipelineExecutionStartCondition.
	//
	// For information on how to format a cron expression in Image Builder, see
	// Use cron expressions in EC2 Image Builder (https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html).
	ScheduleExpression *string `locationName:"scheduleExpression" min:"1" type:"string"`

	// The timezone that applies to the scheduling expression. For example, "Etc/UTC",
	// "America/Los_Angeles" in the IANA timezone format (https://www.joda.org/joda-time/timezones.html).
	// If not specified this defaults to UTC.
	Timezone *string `locationName:"timezone" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Schedule"}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}
	if s.Timezone != nil && len(*s.Timezone) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Timezone", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineExecutionStartCondition sets the PipelineExecutionStartCondition field's value.
func (s *Schedule) SetPipelineExecutionStartCondition(v string) *Schedule {
	s.PipelineExecutionStartCondition = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Schedule) SetScheduleExpression(v string) *Schedule {
	s.ScheduleExpression = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *Schedule) SetTimezone(v string) *Schedule {
	s.Timezone = &v
	return s
}

// This exception is thrown when the service encounters an unrecoverable exception.
type ServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceException) GoString() string {
	return s.String()
}

func newErrorServiceException(v protocol.ResponseMetadata) error {
	return &ServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceException) Code() string {
	return "ServiceException"
}

// Message returns the exception's message.
func (s *ServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceException) OrigErr() error {
	return nil
}

func (s *ServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have exceeded the number of permitted resources or operations for this
// service. For service quotas, see EC2 Image Builder endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder).
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is unable to process your request at this time.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartImagePipelineExecutionInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the image pipeline that you want to manually
	// invoke.
	//
	// ImagePipelineArn is a required field
	ImagePipelineArn *string `locationName:"imagePipelineArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartImagePipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartImagePipelineExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImagePipelineExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartImagePipelineExecutionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ImagePipelineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImagePipelineArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartImagePipelineExecutionInput) SetClientToken(v string) *StartImagePipelineExecutionInput {
	s.ClientToken = &v
	return s
}

// SetImagePipelineArn sets the ImagePipelineArn field's value.
func (s *StartImagePipelineExecutionInput) SetImagePipelineArn(v string) *StartImagePipelineExecutionInput {
	s.ImagePipelineArn = &v
	return s
}

type StartImagePipelineExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the image that was created by this request.
	ImageBuildVersionArn *string `locationName:"imageBuildVersionArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartImagePipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartImagePipelineExecutionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *StartImagePipelineExecutionOutput) SetClientToken(v string) *StartImagePipelineExecutionOutput {
	s.ClientToken = &v
	return s
}

// SetImageBuildVersionArn sets the ImageBuildVersionArn field's value.
func (s *StartImagePipelineExecutionOutput) SetImageBuildVersionArn(v string) *StartImagePipelineExecutionOutput {
	s.ImageBuildVersionArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *StartImagePipelineExecutionOutput) SetRequestId(v string) *StartImagePipelineExecutionOutput {
	s.RequestId = &v
	return s
}

// Contains settings for the Systems Manager agent on your build instance.
type SystemsManagerAgent struct {
	_ struct{} `type:"structure"`

	// Controls whether the Systems Manager agent is removed from your final build
	// image, prior to creating the new AMI. If this is set to true, then the agent
	// is removed from the final image. If it's set to false, then the agent is
	// left in, so that it is included in the new AMI. The default value is false.
	UninstallAfterBuild *bool `locationName:"uninstallAfterBuild" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SystemsManagerAgent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SystemsManagerAgent) GoString() string {
	return s.String()
}

// SetUninstallAfterBuild sets the UninstallAfterBuild field's value.
func (s *SystemsManagerAgent) SetUninstallAfterBuild(v bool) *SystemsManagerAgent {
	s.UninstallAfterBuild = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to apply to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The container repository where the output container image is stored.
type TargetContainerRepository struct {
	_ struct{} `type:"structure"`

	// The name of the container repository where the output container image is
	// stored. This name is prefixed by the repository location.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// Specifies the service in which this image was registered.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true" enum:"ContainerRepositoryService"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetContainerRepository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetContainerRepository) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetContainerRepository) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetContainerRepository"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *TargetContainerRepository) SetRepositoryName(v string) *TargetContainerRepository {
	s.RepositoryName = &v
	return s
}

// SetService sets the Service field's value.
func (s *TargetContainerRepository) SetService(v string) *TargetContainerRepository {
	s.Service = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource that you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDistributionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token of the distribution configuration.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration that you
	// want to update.
	//
	// DistributionConfigurationArn is a required field
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string" required:"true"`

	// The distributions of the distribution configuration.
	//
	// Distributions is a required field
	Distributions []*Distribution `locationName:"distributions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDistributionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDistributionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDistributionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDistributionConfigurationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DistributionConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfigurationArn"))
	}
	if s.Distributions == nil {
		invalidParams.Add(request.NewErrParamRequired("Distributions"))
	}
	if s.Distributions != nil {
		for i, v := range s.Distributions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Distributions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateDistributionConfigurationInput) SetClientToken(v string) *UpdateDistributionConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDistributionConfigurationInput) SetDescription(v string) *UpdateDistributionConfigurationInput {
	s.Description = &v
	return s
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *UpdateDistributionConfigurationInput) SetDistributionConfigurationArn(v string) *UpdateDistributionConfigurationInput {
	s.DistributionConfigurationArn = &v
	return s
}

// SetDistributions sets the Distributions field's value.
func (s *UpdateDistributionConfigurationInput) SetDistributions(v []*Distribution) *UpdateDistributionConfigurationInput {
	s.Distributions = v
	return s
}

type UpdateDistributionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration that was
	// updated by this request.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDistributionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDistributionConfigurationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateDistributionConfigurationOutput) SetClientToken(v string) *UpdateDistributionConfigurationOutput {
	s.ClientToken = &v
	return s
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *UpdateDistributionConfigurationOutput) SetDistributionConfigurationArn(v string) *UpdateDistributionConfigurationOutput {
	s.DistributionConfigurationArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateDistributionConfigurationOutput) SetRequestId(v string) *UpdateDistributionConfigurationOutput {
	s.RequestId = &v
	return s
}

type UpdateImagePipelineInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the container pipeline to update.
	ContainerRecipeArn *string `locationName:"containerRecipeArn" type:"string"`

	// The description of the image pipeline.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration that will
	// be used to configure and distribute images updated by this image pipeline.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// Collects additional information about the image being created, including
	// the operating system (OS) version and package list. This information is used
	// to enhance the overall experience of using EC2 Image Builder. Enabled by
	// default.
	EnhancedImageMetadataEnabled *bool `locationName:"enhancedImageMetadataEnabled" type:"boolean"`

	// The Amazon Resource Name (ARN) of the image pipeline that you want to update.
	//
	// ImagePipelineArn is a required field
	ImagePipelineArn *string `locationName:"imagePipelineArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the image recipe that will be used to configure
	// images updated by this image pipeline.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The image test configuration of the image pipeline.
	ImageTestsConfiguration *ImageTestsConfiguration `locationName:"imageTestsConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that will
	// be used to build images updated by this image pipeline.
	//
	// InfrastructureConfigurationArn is a required field
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string" required:"true"`

	// The schedule of the image pipeline.
	Schedule *Schedule `locationName:"schedule" type:"structure"`

	// The status of the image pipeline.
	Status *string `locationName:"status" type:"string" enum:"PipelineStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateImagePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateImagePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateImagePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateImagePipelineInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ImagePipelineArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ImagePipelineArn"))
	}
	if s.InfrastructureConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InfrastructureConfigurationArn"))
	}
	if s.ImageTestsConfiguration != nil {
		if err := s.ImageTestsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ImageTestsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateImagePipelineInput) SetClientToken(v string) *UpdateImagePipelineInput {
	s.ClientToken = &v
	return s
}

// SetContainerRecipeArn sets the ContainerRecipeArn field's value.
func (s *UpdateImagePipelineInput) SetContainerRecipeArn(v string) *UpdateImagePipelineInput {
	s.ContainerRecipeArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateImagePipelineInput) SetDescription(v string) *UpdateImagePipelineInput {
	s.Description = &v
	return s
}

// SetDistributionConfigurationArn sets the DistributionConfigurationArn field's value.
func (s *UpdateImagePipelineInput) SetDistributionConfigurationArn(v string) *UpdateImagePipelineInput {
	s.DistributionConfigurationArn = &v
	return s
}

// SetEnhancedImageMetadataEnabled sets the EnhancedImageMetadataEnabled field's value.
func (s *UpdateImagePipelineInput) SetEnhancedImageMetadataEnabled(v bool) *UpdateImagePipelineInput {
	s.EnhancedImageMetadataEnabled = &v
	return s
}

// SetImagePipelineArn sets the ImagePipelineArn field's value.
func (s *UpdateImagePipelineInput) SetImagePipelineArn(v string) *UpdateImagePipelineInput {
	s.ImagePipelineArn = &v
	return s
}

// SetImageRecipeArn sets the ImageRecipeArn field's value.
func (s *UpdateImagePipelineInput) SetImageRecipeArn(v string) *UpdateImagePipelineInput {
	s.ImageRecipeArn = &v
	return s
}

// SetImageTestsConfiguration sets the ImageTestsConfiguration field's value.
func (s *UpdateImagePipelineInput) SetImageTestsConfiguration(v *ImageTestsConfiguration) *UpdateImagePipelineInput {
	s.ImageTestsConfiguration = v
	return s
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *UpdateImagePipelineInput) SetInfrastructureConfigurationArn(v string) *UpdateImagePipelineInput {
	s.InfrastructureConfigurationArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateImagePipelineInput) SetSchedule(v *Schedule) *UpdateImagePipelineInput {
	s.Schedule = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateImagePipelineInput) SetStatus(v string) *UpdateImagePipelineInput {
	s.Status = &v
	return s
}

type UpdateImagePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the image pipeline that was updated by
	// this request.
	ImagePipelineArn *string `locationName:"imagePipelineArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateImagePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateImagePipelineOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateImagePipelineOutput) SetClientToken(v string) *UpdateImagePipelineOutput {
	s.ClientToken = &v
	return s
}

// SetImagePipelineArn sets the ImagePipelineArn field's value.
func (s *UpdateImagePipelineOutput) SetImagePipelineArn(v string) *UpdateImagePipelineOutput {
	s.ImagePipelineArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateImagePipelineOutput) SetRequestId(v string) *UpdateImagePipelineOutput {
	s.RequestId = &v
	return s
}

type UpdateInfrastructureConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the infrastructure configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that you
	// want to update.
	//
	// InfrastructureConfigurationArn is a required field
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string" required:"true"`

	// The instance metadata options that you can set for the HTTP requests that
	// pipeline builds use to launch EC2 build and test instances. For more information
	// about instance metadata options, see one of the following links:
	//
	//    * Configure the instance metadata options (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html)
	//    in the Amazon EC2 User Guide for Linux instances.
	//
	//    * Configure the instance metadata options (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html)
	//    in the Amazon EC2 Windows Guide for Windows instances.
	InstanceMetadataOptions *InstanceMetadataOptions `locationName:"instanceMetadataOptions" type:"structure"`

	// The instance profile to associate with the instance used to customize your
	// Amazon EC2 AMI.
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `locationName:"instanceProfileName" min:"1" type:"string" required:"true"`

	// The instance types of the infrastructure configuration. You can specify one
	// or more instance types to use for this build. The service will pick one of
	// these instance types based on availability.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The key pair of the infrastructure configuration. You can use this to log
	// on to and debug the instance used to create your image.
	KeyPair *string `locationName:"keyPair" min:"1" type:"string"`

	// The logging configuration of the infrastructure configuration.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The tags attached to the resource created by Image Builder.
	ResourceTags map[string]*string `locationName:"resourceTags" min:"1" type:"map"`

	// The security group IDs to associate with the instance used to customize your
	// Amazon EC2 AMI.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The Amazon Resource Name (ARN) for the SNS topic to which we send image build
	// event notifications.
	//
	// EC2 Image Builder is unable to send notifications to SNS topics that are
	// encrypted using keys from other accounts. The key that is used to encrypt
	// the SNS topic must reside in the account that the Image Builder service runs
	// under.
	SnsTopicArn *string `locationName:"snsTopicArn" type:"string"`

	// The subnet ID to place the instance used to customize your Amazon EC2 AMI
	// in.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`

	// The terminate instance on failure setting of the infrastructure configuration.
	// Set to false if you want Image Builder to retain the instance used to configure
	// your AMI if the build or test phase of your workflow fails.
	TerminateInstanceOnFailure *bool `locationName:"terminateInstanceOnFailure" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInfrastructureConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInfrastructureConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInfrastructureConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInfrastructureConfigurationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InfrastructureConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InfrastructureConfigurationArn"))
	}
	if s.InstanceProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceProfileName", 1))
	}
	if s.KeyPair != nil && len(*s.KeyPair) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyPair", 1))
	}
	if s.ResourceTags != nil && len(s.ResourceTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTags", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}
	if s.InstanceMetadataOptions != nil {
		if err := s.InstanceMetadataOptions.Validate(); err != nil {
			invalidParams.AddNested("InstanceMetadataOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateInfrastructureConfigurationInput) SetClientToken(v string) *UpdateInfrastructureConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateInfrastructureConfigurationInput) SetDescription(v string) *UpdateInfrastructureConfigurationInput {
	s.Description = &v
	return s
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *UpdateInfrastructureConfigurationInput) SetInfrastructureConfigurationArn(v string) *UpdateInfrastructureConfigurationInput {
	s.InfrastructureConfigurationArn = &v
	return s
}

// SetInstanceMetadataOptions sets the InstanceMetadataOptions field's value.
func (s *UpdateInfrastructureConfigurationInput) SetInstanceMetadataOptions(v *InstanceMetadataOptions) *UpdateInfrastructureConfigurationInput {
	s.InstanceMetadataOptions = v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *UpdateInfrastructureConfigurationInput) SetInstanceProfileName(v string) *UpdateInfrastructureConfigurationInput {
	s.InstanceProfileName = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *UpdateInfrastructureConfigurationInput) SetInstanceTypes(v []*string) *UpdateInfrastructureConfigurationInput {
	s.InstanceTypes = v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *UpdateInfrastructureConfigurationInput) SetKeyPair(v string) *UpdateInfrastructureConfigurationInput {
	s.KeyPair = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *UpdateInfrastructureConfigurationInput) SetLogging(v *Logging) *UpdateInfrastructureConfigurationInput {
	s.Logging = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *UpdateInfrastructureConfigurationInput) SetResourceTags(v map[string]*string) *UpdateInfrastructureConfigurationInput {
	s.ResourceTags = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateInfrastructureConfigurationInput) SetSecurityGroupIds(v []*string) *UpdateInfrastructureConfigurationInput {
	s.SecurityGroupIds = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *UpdateInfrastructureConfigurationInput) SetSnsTopicArn(v string) *UpdateInfrastructureConfigurationInput {
	s.SnsTopicArn = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *UpdateInfrastructureConfigurationInput) SetSubnetId(v string) *UpdateInfrastructureConfigurationInput {
	s.SubnetId = &v
	return s
}

// SetTerminateInstanceOnFailure sets the TerminateInstanceOnFailure field's value.
func (s *UpdateInfrastructureConfigurationInput) SetTerminateInstanceOnFailure(v bool) *UpdateInfrastructureConfigurationInput {
	s.TerminateInstanceOnFailure = &v
	return s
}

type UpdateInfrastructureConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration that was
	// updated by this request.
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInfrastructureConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInfrastructureConfigurationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateInfrastructureConfigurationOutput) SetClientToken(v string) *UpdateInfrastructureConfigurationOutput {
	s.ClientToken = &v
	return s
}

// SetInfrastructureConfigurationArn sets the InfrastructureConfigurationArn field's value.
func (s *UpdateInfrastructureConfigurationOutput) SetInfrastructureConfigurationArn(v string) *UpdateInfrastructureConfigurationOutput {
	s.InfrastructureConfigurationArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateInfrastructureConfigurationOutput) SetRequestId(v string) *UpdateInfrastructureConfigurationOutput {
	s.RequestId = &v
	return s
}

const (
	// BuildTypeUserInitiated is a BuildType enum value
	BuildTypeUserInitiated = "USER_INITIATED"

	// BuildTypeScheduled is a BuildType enum value
	BuildTypeScheduled = "SCHEDULED"

	// BuildTypeImport is a BuildType enum value
	BuildTypeImport = "IMPORT"
)

// BuildType_Values returns all elements of the BuildType enum
func BuildType_Values() []string {
	return []string{
		BuildTypeUserInitiated,
		BuildTypeScheduled,
		BuildTypeImport,
	}
}

const (
	// ComponentFormatShell is a ComponentFormat enum value
	ComponentFormatShell = "SHELL"
)

// ComponentFormat_Values returns all elements of the ComponentFormat enum
func ComponentFormat_Values() []string {
	return []string{
		ComponentFormatShell,
	}
}

const (
	// ComponentStatusDeprecated is a ComponentStatus enum value
	ComponentStatusDeprecated = "DEPRECATED"
)

// ComponentStatus_Values returns all elements of the ComponentStatus enum
func ComponentStatus_Values() []string {
	return []string{
		ComponentStatusDeprecated,
	}
}

const (
	// ComponentTypeBuild is a ComponentType enum value
	ComponentTypeBuild = "BUILD"

	// ComponentTypeTest is a ComponentType enum value
	ComponentTypeTest = "TEST"
)

// ComponentType_Values returns all elements of the ComponentType enum
func ComponentType_Values() []string {
	return []string{
		ComponentTypeBuild,
		ComponentTypeTest,
	}
}

const (
	// ContainerRepositoryServiceEcr is a ContainerRepositoryService enum value
	ContainerRepositoryServiceEcr = "ECR"
)

// ContainerRepositoryService_Values returns all elements of the ContainerRepositoryService enum
func ContainerRepositoryService_Values() []string {
	return []string{
		ContainerRepositoryServiceEcr,
	}
}

const (
	// ContainerTypeDocker is a ContainerType enum value
	ContainerTypeDocker = "DOCKER"
)

// ContainerType_Values returns all elements of the ContainerType enum
func ContainerType_Values() []string {
	return []string{
		ContainerTypeDocker,
	}
}

const (
	// DiskImageFormatVmdk is a DiskImageFormat enum value
	DiskImageFormatVmdk = "VMDK"

	// DiskImageFormatRaw is a DiskImageFormat enum value
	DiskImageFormatRaw = "RAW"

	// DiskImageFormatVhd is a DiskImageFormat enum value
	DiskImageFormatVhd = "VHD"
)

// DiskImageFormat_Values returns all elements of the DiskImageFormat enum
func DiskImageFormat_Values() []string {
	return []string{
		DiskImageFormatVmdk,
		DiskImageFormatRaw,
		DiskImageFormatVhd,
	}
}

const (
	// EbsVolumeTypeStandard is a EbsVolumeType enum value
	EbsVolumeTypeStandard = "standard"

	// EbsVolumeTypeIo1 is a EbsVolumeType enum value
	EbsVolumeTypeIo1 = "io1"

	// EbsVolumeTypeIo2 is a EbsVolumeType enum value
	EbsVolumeTypeIo2 = "io2"

	// EbsVolumeTypeGp2 is a EbsVolumeType enum value
	EbsVolumeTypeGp2 = "gp2"

	// EbsVolumeTypeGp3 is a EbsVolumeType enum value
	EbsVolumeTypeGp3 = "gp3"

	// EbsVolumeTypeSc1 is a EbsVolumeType enum value
	EbsVolumeTypeSc1 = "sc1"

	// EbsVolumeTypeSt1 is a EbsVolumeType enum value
	EbsVolumeTypeSt1 = "st1"
)

// EbsVolumeType_Values returns all elements of the EbsVolumeType enum
func EbsVolumeType_Values() []string {
	return []string{
		EbsVolumeTypeStandard,
		EbsVolumeTypeIo1,
		EbsVolumeTypeIo2,
		EbsVolumeTypeGp2,
		EbsVolumeTypeGp3,
		EbsVolumeTypeSc1,
		EbsVolumeTypeSt1,
	}
}

const (
	// ImageSourceAmazonManaged is a ImageSource enum value
	ImageSourceAmazonManaged = "AMAZON_MANAGED"

	// ImageSourceAwsMarketplace is a ImageSource enum value
	ImageSourceAwsMarketplace = "AWS_MARKETPLACE"

	// ImageSourceImported is a ImageSource enum value
	ImageSourceImported = "IMPORTED"

	// ImageSourceCustom is a ImageSource enum value
	ImageSourceCustom = "CUSTOM"
)

// ImageSource_Values returns all elements of the ImageSource enum
func ImageSource_Values() []string {
	return []string{
		ImageSourceAmazonManaged,
		ImageSourceAwsMarketplace,
		ImageSourceImported,
		ImageSourceCustom,
	}
}

const (
	// ImageStatusPending is a ImageStatus enum value
	ImageStatusPending = "PENDING"

	// ImageStatusCreating is a ImageStatus enum value
	ImageStatusCreating = "CREATING"

	// ImageStatusBuilding is a ImageStatus enum value
	ImageStatusBuilding = "BUILDING"

	// ImageStatusTesting is a ImageStatus enum value
	ImageStatusTesting = "TESTING"

	// ImageStatusDistributing is a ImageStatus enum value
	ImageStatusDistributing = "DISTRIBUTING"

	// ImageStatusIntegrating is a ImageStatus enum value
	ImageStatusIntegrating = "INTEGRATING"

	// ImageStatusAvailable is a ImageStatus enum value
	ImageStatusAvailable = "AVAILABLE"

	// ImageStatusCancelled is a ImageStatus enum value
	ImageStatusCancelled = "CANCELLED"

	// ImageStatusFailed is a ImageStatus enum value
	ImageStatusFailed = "FAILED"

	// ImageStatusDeprecated is a ImageStatus enum value
	ImageStatusDeprecated = "DEPRECATED"

	// ImageStatusDeleted is a ImageStatus enum value
	ImageStatusDeleted = "DELETED"
)

// ImageStatus_Values returns all elements of the ImageStatus enum
func ImageStatus_Values() []string {
	return []string{
		ImageStatusPending,
		ImageStatusCreating,
		ImageStatusBuilding,
		ImageStatusTesting,
		ImageStatusDistributing,
		ImageStatusIntegrating,
		ImageStatusAvailable,
		ImageStatusCancelled,
		ImageStatusFailed,
		ImageStatusDeprecated,
		ImageStatusDeleted,
	}
}

const (
	// ImageTypeAmi is a ImageType enum value
	ImageTypeAmi = "AMI"

	// ImageTypeDocker is a ImageType enum value
	ImageTypeDocker = "DOCKER"
)

// ImageType_Values returns all elements of the ImageType enum
func ImageType_Values() []string {
	return []string{
		ImageTypeAmi,
		ImageTypeDocker,
	}
}

const (
	// OwnershipSelf is a Ownership enum value
	OwnershipSelf = "Self"

	// OwnershipShared is a Ownership enum value
	OwnershipShared = "Shared"

	// OwnershipAmazon is a Ownership enum value
	OwnershipAmazon = "Amazon"

	// OwnershipThirdParty is a Ownership enum value
	OwnershipThirdParty = "ThirdParty"
)

// Ownership_Values returns all elements of the Ownership enum
func Ownership_Values() []string {
	return []string{
		OwnershipSelf,
		OwnershipShared,
		OwnershipAmazon,
		OwnershipThirdParty,
	}
}

const (
	// PipelineExecutionStartConditionExpressionMatchOnly is a PipelineExecutionStartCondition enum value
	PipelineExecutionStartConditionExpressionMatchOnly = "EXPRESSION_MATCH_ONLY"

	// PipelineExecutionStartConditionExpressionMatchAndDependencyUpdatesAvailable is a PipelineExecutionStartCondition enum value
	PipelineExecutionStartConditionExpressionMatchAndDependencyUpdatesAvailable = "EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE"
)

// PipelineExecutionStartCondition_Values returns all elements of the PipelineExecutionStartCondition enum
func PipelineExecutionStartCondition_Values() []string {
	return []string{
		PipelineExecutionStartConditionExpressionMatchOnly,
		PipelineExecutionStartConditionExpressionMatchAndDependencyUpdatesAvailable,
	}
}

const (
	// PipelineStatusDisabled is a PipelineStatus enum value
	PipelineStatusDisabled = "DISABLED"

	// PipelineStatusEnabled is a PipelineStatus enum value
	PipelineStatusEnabled = "ENABLED"
)

// PipelineStatus_Values returns all elements of the PipelineStatus enum
func PipelineStatus_Values() []string {
	return []string{
		PipelineStatusDisabled,
		PipelineStatusEnabled,
	}
}

const (
	// PlatformWindows is a Platform enum value
	PlatformWindows = "Windows"

	// PlatformLinux is a Platform enum value
	PlatformLinux = "Linux"
)

// Platform_Values returns all elements of the Platform enum
func Platform_Values() []string {
	return []string{
		PlatformWindows,
		PlatformLinux,
	}
}
