// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iottwinmaker

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchPutPropertyValues = "BatchPutPropertyValues"

// BatchPutPropertyValuesRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutPropertyValues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutPropertyValues for more information on using the BatchPutPropertyValues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchPutPropertyValuesRequest method.
//	req, resp := client.BatchPutPropertyValuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/BatchPutPropertyValues
func (c *IoTTwinMaker) BatchPutPropertyValuesRequest(input *BatchPutPropertyValuesInput) (req *request.Request, output *BatchPutPropertyValuesOutput) {
	op := &request.Operation{
		Name:       opBatchPutPropertyValues,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/entity-properties",
	}

	if input == nil {
		input = &BatchPutPropertyValuesInput{}
	}

	output = &BatchPutPropertyValuesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchPutPropertyValues API operation for AWS IoT TwinMaker.
//
// Sets values for multiple time series properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation BatchPutPropertyValues for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/BatchPutPropertyValues
func (c *IoTTwinMaker) BatchPutPropertyValues(input *BatchPutPropertyValuesInput) (*BatchPutPropertyValuesOutput, error) {
	req, out := c.BatchPutPropertyValuesRequest(input)
	return out, req.Send()
}

// BatchPutPropertyValuesWithContext is the same as BatchPutPropertyValues with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutPropertyValues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) BatchPutPropertyValuesWithContext(ctx aws.Context, input *BatchPutPropertyValuesInput, opts ...request.Option) (*BatchPutPropertyValuesOutput, error) {
	req, out := c.BatchPutPropertyValuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComponentType = "CreateComponentType"

// CreateComponentTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateComponentType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComponentType for more information on using the CreateComponentType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateComponentTypeRequest method.
//	req, resp := client.CreateComponentTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateComponentType
func (c *IoTTwinMaker) CreateComponentTypeRequest(input *CreateComponentTypeInput) (req *request.Request, output *CreateComponentTypeOutput) {
	op := &request.Operation{
		Name:       opCreateComponentType,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/component-types/{componentTypeId}",
	}

	if input == nil {
		input = &CreateComponentTypeInput{}
	}

	output = &CreateComponentTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateComponentType API operation for AWS IoT TwinMaker.
//
// Creates a component type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation CreateComponentType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ConflictException
//     A conflict occurred.
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateComponentType
func (c *IoTTwinMaker) CreateComponentType(input *CreateComponentTypeInput) (*CreateComponentTypeOutput, error) {
	req, out := c.CreateComponentTypeRequest(input)
	return out, req.Send()
}

// CreateComponentTypeWithContext is the same as CreateComponentType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComponentType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) CreateComponentTypeWithContext(ctx aws.Context, input *CreateComponentTypeInput, opts ...request.Option) (*CreateComponentTypeOutput, error) {
	req, out := c.CreateComponentTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEntity = "CreateEntity"

// CreateEntityRequest generates a "aws/request.Request" representing the
// client's request for the CreateEntity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEntity for more information on using the CreateEntity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEntityRequest method.
//	req, resp := client.CreateEntityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateEntity
func (c *IoTTwinMaker) CreateEntityRequest(input *CreateEntityInput) (req *request.Request, output *CreateEntityOutput) {
	op := &request.Operation{
		Name:       opCreateEntity,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/entities",
	}

	if input == nil {
		input = &CreateEntityInput{}
	}

	output = &CreateEntityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateEntity API operation for AWS IoT TwinMaker.
//
// Creates an entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation CreateEntity for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ConflictException
//     A conflict occurred.
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateEntity
func (c *IoTTwinMaker) CreateEntity(input *CreateEntityInput) (*CreateEntityOutput, error) {
	req, out := c.CreateEntityRequest(input)
	return out, req.Send()
}

// CreateEntityWithContext is the same as CreateEntity with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEntity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) CreateEntityWithContext(ctx aws.Context, input *CreateEntityInput, opts ...request.Option) (*CreateEntityOutput, error) {
	req, out := c.CreateEntityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScene = "CreateScene"

// CreateSceneRequest generates a "aws/request.Request" representing the
// client's request for the CreateScene operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScene for more information on using the CreateScene
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSceneRequest method.
//	req, resp := client.CreateSceneRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateScene
func (c *IoTTwinMaker) CreateSceneRequest(input *CreateSceneInput) (req *request.Request, output *CreateSceneOutput) {
	op := &request.Operation{
		Name:       opCreateScene,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/scenes",
	}

	if input == nil {
		input = &CreateSceneInput{}
	}

	output = &CreateSceneOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateScene API operation for AWS IoT TwinMaker.
//
// Creates a scene.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation CreateScene for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ConflictException
//     A conflict occurred.
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateScene
func (c *IoTTwinMaker) CreateScene(input *CreateSceneInput) (*CreateSceneOutput, error) {
	req, out := c.CreateSceneRequest(input)
	return out, req.Send()
}

// CreateSceneWithContext is the same as CreateScene with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScene for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) CreateSceneWithContext(ctx aws.Context, input *CreateSceneInput, opts ...request.Option) (*CreateSceneOutput, error) {
	req, out := c.CreateSceneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSyncJob = "CreateSyncJob"

// CreateSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSyncJob for more information on using the CreateSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSyncJobRequest method.
//	req, resp := client.CreateSyncJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateSyncJob
func (c *IoTTwinMaker) CreateSyncJobRequest(input *CreateSyncJobInput) (req *request.Request, output *CreateSyncJobOutput) {
	op := &request.Operation{
		Name:       opCreateSyncJob,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/sync-jobs/{syncSource}",
	}

	if input == nil {
		input = &CreateSyncJobInput{}
	}

	output = &CreateSyncJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateSyncJob API operation for AWS IoT TwinMaker.
//
// This action creates a SyncJob.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation CreateSyncJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ConflictException
//     A conflict occurred.
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateSyncJob
func (c *IoTTwinMaker) CreateSyncJob(input *CreateSyncJobInput) (*CreateSyncJobOutput, error) {
	req, out := c.CreateSyncJobRequest(input)
	return out, req.Send()
}

// CreateSyncJobWithContext is the same as CreateSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) CreateSyncJobWithContext(ctx aws.Context, input *CreateSyncJobInput, opts ...request.Option) (*CreateSyncJobOutput, error) {
	req, out := c.CreateSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspace = "CreateWorkspace"

// CreateWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspace for more information on using the CreateWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkspaceRequest method.
//	req, resp := client.CreateWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateWorkspace
func (c *IoTTwinMaker) CreateWorkspaceRequest(input *CreateWorkspaceInput) (req *request.Request, output *CreateWorkspaceOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &CreateWorkspaceInput{}
	}

	output = &CreateWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateWorkspace API operation for AWS IoT TwinMaker.
//
// Creates a workplace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation CreateWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ConflictException
//     A conflict occurred.
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateWorkspace
func (c *IoTTwinMaker) CreateWorkspace(input *CreateWorkspaceInput) (*CreateWorkspaceOutput, error) {
	req, out := c.CreateWorkspaceRequest(input)
	return out, req.Send()
}

// CreateWorkspaceWithContext is the same as CreateWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) CreateWorkspaceWithContext(ctx aws.Context, input *CreateWorkspaceInput, opts ...request.Option) (*CreateWorkspaceOutput, error) {
	req, out := c.CreateWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComponentType = "DeleteComponentType"

// DeleteComponentTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComponentType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComponentType for more information on using the DeleteComponentType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteComponentTypeRequest method.
//	req, resp := client.DeleteComponentTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteComponentType
func (c *IoTTwinMaker) DeleteComponentTypeRequest(input *DeleteComponentTypeInput) (req *request.Request, output *DeleteComponentTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteComponentType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/component-types/{componentTypeId}",
	}

	if input == nil {
		input = &DeleteComponentTypeInput{}
	}

	output = &DeleteComponentTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteComponentType API operation for AWS IoT TwinMaker.
//
// Deletes a component type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation DeleteComponentType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteComponentType
func (c *IoTTwinMaker) DeleteComponentType(input *DeleteComponentTypeInput) (*DeleteComponentTypeOutput, error) {
	req, out := c.DeleteComponentTypeRequest(input)
	return out, req.Send()
}

// DeleteComponentTypeWithContext is the same as DeleteComponentType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComponentType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) DeleteComponentTypeWithContext(ctx aws.Context, input *DeleteComponentTypeInput, opts ...request.Option) (*DeleteComponentTypeOutput, error) {
	req, out := c.DeleteComponentTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEntity = "DeleteEntity"

// DeleteEntityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEntity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEntity for more information on using the DeleteEntity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEntityRequest method.
//	req, resp := client.DeleteEntityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteEntity
func (c *IoTTwinMaker) DeleteEntityRequest(input *DeleteEntityInput) (req *request.Request, output *DeleteEntityOutput) {
	op := &request.Operation{
		Name:       opDeleteEntity,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/entities/{entityId}",
	}

	if input == nil {
		input = &DeleteEntityInput{}
	}

	output = &DeleteEntityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteEntity API operation for AWS IoT TwinMaker.
//
// Deletes an entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation DeleteEntity for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteEntity
func (c *IoTTwinMaker) DeleteEntity(input *DeleteEntityInput) (*DeleteEntityOutput, error) {
	req, out := c.DeleteEntityRequest(input)
	return out, req.Send()
}

// DeleteEntityWithContext is the same as DeleteEntity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEntity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) DeleteEntityWithContext(ctx aws.Context, input *DeleteEntityInput, opts ...request.Option) (*DeleteEntityOutput, error) {
	req, out := c.DeleteEntityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScene = "DeleteScene"

// DeleteSceneRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScene operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScene for more information on using the DeleteScene
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSceneRequest method.
//	req, resp := client.DeleteSceneRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteScene
func (c *IoTTwinMaker) DeleteSceneRequest(input *DeleteSceneInput) (req *request.Request, output *DeleteSceneOutput) {
	op := &request.Operation{
		Name:       opDeleteScene,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/scenes/{sceneId}",
	}

	if input == nil {
		input = &DeleteSceneInput{}
	}

	output = &DeleteSceneOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteScene API operation for AWS IoT TwinMaker.
//
// Deletes a scene.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation DeleteScene for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteScene
func (c *IoTTwinMaker) DeleteScene(input *DeleteSceneInput) (*DeleteSceneOutput, error) {
	req, out := c.DeleteSceneRequest(input)
	return out, req.Send()
}

// DeleteSceneWithContext is the same as DeleteScene with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScene for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) DeleteSceneWithContext(ctx aws.Context, input *DeleteSceneInput, opts ...request.Option) (*DeleteSceneOutput, error) {
	req, out := c.DeleteSceneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSyncJob = "DeleteSyncJob"

// DeleteSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSyncJob for more information on using the DeleteSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSyncJobRequest method.
//	req, resp := client.DeleteSyncJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteSyncJob
func (c *IoTTwinMaker) DeleteSyncJobRequest(input *DeleteSyncJobInput) (req *request.Request, output *DeleteSyncJobOutput) {
	op := &request.Operation{
		Name:       opDeleteSyncJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}/sync-jobs/{syncSource}",
	}

	if input == nil {
		input = &DeleteSyncJobInput{}
	}

	output = &DeleteSyncJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteSyncJob API operation for AWS IoT TwinMaker.
//
// Delete the SyncJob.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation DeleteSyncJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteSyncJob
func (c *IoTTwinMaker) DeleteSyncJob(input *DeleteSyncJobInput) (*DeleteSyncJobOutput, error) {
	req, out := c.DeleteSyncJobRequest(input)
	return out, req.Send()
}

// DeleteSyncJobWithContext is the same as DeleteSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) DeleteSyncJobWithContext(ctx aws.Context, input *DeleteSyncJobInput, opts ...request.Option) (*DeleteSyncJobOutput, error) {
	req, out := c.DeleteSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspace = "DeleteWorkspace"

// DeleteWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspace for more information on using the DeleteWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkspaceRequest method.
//	req, resp := client.DeleteWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteWorkspace
func (c *IoTTwinMaker) DeleteWorkspaceRequest(input *DeleteWorkspaceInput) (req *request.Request, output *DeleteWorkspaceOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &DeleteWorkspaceInput{}
	}

	output = &DeleteWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteWorkspace API operation for AWS IoT TwinMaker.
//
// Deletes a workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation DeleteWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteWorkspace
func (c *IoTTwinMaker) DeleteWorkspace(input *DeleteWorkspaceInput) (*DeleteWorkspaceOutput, error) {
	req, out := c.DeleteWorkspaceRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceWithContext is the same as DeleteWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) DeleteWorkspaceWithContext(ctx aws.Context, input *DeleteWorkspaceInput, opts ...request.Option) (*DeleteWorkspaceOutput, error) {
	req, out := c.DeleteWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteQuery = "ExecuteQuery"

// ExecuteQueryRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteQuery for more information on using the ExecuteQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteQueryRequest method.
//	req, resp := client.ExecuteQueryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery
func (c *IoTTwinMaker) ExecuteQueryRequest(input *ExecuteQueryInput) (req *request.Request, output *ExecuteQueryOutput) {
	op := &request.Operation{
		Name:       opExecuteQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/queries/execution",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ExecuteQueryInput{}
	}

	output = &ExecuteQueryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ExecuteQuery API operation for AWS IoT TwinMaker.
//
// Run queries to access information from your knowledge graph of entities within
// individual workspaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation ExecuteQuery for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - QueryTimeoutException
//     The query timeout exception.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery
func (c *IoTTwinMaker) ExecuteQuery(input *ExecuteQueryInput) (*ExecuteQueryOutput, error) {
	req, out := c.ExecuteQueryRequest(input)
	return out, req.Send()
}

// ExecuteQueryWithContext is the same as ExecuteQuery with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ExecuteQueryWithContext(ctx aws.Context, input *ExecuteQueryInput, opts ...request.Option) (*ExecuteQueryOutput, error) {
	req, out := c.ExecuteQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ExecuteQueryPages iterates over the pages of a ExecuteQuery operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ExecuteQuery method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ExecuteQuery operation.
//	pageNum := 0
//	err := client.ExecuteQueryPages(params,
//	    func(page *iottwinmaker.ExecuteQueryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) ExecuteQueryPages(input *ExecuteQueryInput, fn func(*ExecuteQueryOutput, bool) bool) error {
	return c.ExecuteQueryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ExecuteQueryPagesWithContext same as ExecuteQueryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ExecuteQueryPagesWithContext(ctx aws.Context, input *ExecuteQueryInput, fn func(*ExecuteQueryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ExecuteQueryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ExecuteQueryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ExecuteQueryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetComponentType = "GetComponentType"

// GetComponentTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetComponentType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComponentType for more information on using the GetComponentType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetComponentTypeRequest method.
//	req, resp := client.GetComponentTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetComponentType
func (c *IoTTwinMaker) GetComponentTypeRequest(input *GetComponentTypeInput) (req *request.Request, output *GetComponentTypeOutput) {
	op := &request.Operation{
		Name:       opGetComponentType,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/component-types/{componentTypeId}",
	}

	if input == nil {
		input = &GetComponentTypeInput{}
	}

	output = &GetComponentTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetComponentType API operation for AWS IoT TwinMaker.
//
// Retrieves information about a component type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation GetComponentType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetComponentType
func (c *IoTTwinMaker) GetComponentType(input *GetComponentTypeInput) (*GetComponentTypeOutput, error) {
	req, out := c.GetComponentTypeRequest(input)
	return out, req.Send()
}

// GetComponentTypeWithContext is the same as GetComponentType with the addition of
// the ability to pass a context and additional request options.
//
// See GetComponentType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetComponentTypeWithContext(ctx aws.Context, input *GetComponentTypeInput, opts ...request.Option) (*GetComponentTypeOutput, error) {
	req, out := c.GetComponentTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEntity = "GetEntity"

// GetEntityRequest generates a "aws/request.Request" representing the
// client's request for the GetEntity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEntity for more information on using the GetEntity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEntityRequest method.
//	req, resp := client.GetEntityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetEntity
func (c *IoTTwinMaker) GetEntityRequest(input *GetEntityInput) (req *request.Request, output *GetEntityOutput) {
	op := &request.Operation{
		Name:       opGetEntity,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/entities/{entityId}",
	}

	if input == nil {
		input = &GetEntityInput{}
	}

	output = &GetEntityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetEntity API operation for AWS IoT TwinMaker.
//
// Retrieves information about an entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation GetEntity for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetEntity
func (c *IoTTwinMaker) GetEntity(input *GetEntityInput) (*GetEntityOutput, error) {
	req, out := c.GetEntityRequest(input)
	return out, req.Send()
}

// GetEntityWithContext is the same as GetEntity with the addition of
// the ability to pass a context and additional request options.
//
// See GetEntity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetEntityWithContext(ctx aws.Context, input *GetEntityInput, opts ...request.Option) (*GetEntityOutput, error) {
	req, out := c.GetEntityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPricingPlan = "GetPricingPlan"

// GetPricingPlanRequest generates a "aws/request.Request" representing the
// client's request for the GetPricingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPricingPlan for more information on using the GetPricingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPricingPlanRequest method.
//	req, resp := client.GetPricingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPricingPlan
func (c *IoTTwinMaker) GetPricingPlanRequest(input *GetPricingPlanInput) (req *request.Request, output *GetPricingPlanOutput) {
	op := &request.Operation{
		Name:       opGetPricingPlan,
		HTTPMethod: "GET",
		HTTPPath:   "/pricingplan",
	}

	if input == nil {
		input = &GetPricingPlanInput{}
	}

	output = &GetPricingPlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetPricingPlan API operation for AWS IoT TwinMaker.
//
// Gets the pricing plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation GetPricingPlan for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPricingPlan
func (c *IoTTwinMaker) GetPricingPlan(input *GetPricingPlanInput) (*GetPricingPlanOutput, error) {
	req, out := c.GetPricingPlanRequest(input)
	return out, req.Send()
}

// GetPricingPlanWithContext is the same as GetPricingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See GetPricingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetPricingPlanWithContext(ctx aws.Context, input *GetPricingPlanInput, opts ...request.Option) (*GetPricingPlanOutput, error) {
	req, out := c.GetPricingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPropertyValue = "GetPropertyValue"

// GetPropertyValueRequest generates a "aws/request.Request" representing the
// client's request for the GetPropertyValue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPropertyValue for more information on using the GetPropertyValue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPropertyValueRequest method.
//	req, resp := client.GetPropertyValueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue
func (c *IoTTwinMaker) GetPropertyValueRequest(input *GetPropertyValueInput) (req *request.Request, output *GetPropertyValueOutput) {
	op := &request.Operation{
		Name:       opGetPropertyValue,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/entity-properties/value",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPropertyValueInput{}
	}

	output = &GetPropertyValueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetPropertyValue API operation for AWS IoT TwinMaker.
//
// Gets the property values for a component, component type, entity, or workspace.
//
// You must specify a value for either componentName, componentTypeId, entityId,
// or workspaceId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation GetPropertyValue for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - ConnectorFailureException
//     The connector failed.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ConnectorTimeoutException
//     The connector timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue
func (c *IoTTwinMaker) GetPropertyValue(input *GetPropertyValueInput) (*GetPropertyValueOutput, error) {
	req, out := c.GetPropertyValueRequest(input)
	return out, req.Send()
}

// GetPropertyValueWithContext is the same as GetPropertyValue with the addition of
// the ability to pass a context and additional request options.
//
// See GetPropertyValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetPropertyValueWithContext(ctx aws.Context, input *GetPropertyValueInput, opts ...request.Option) (*GetPropertyValueOutput, error) {
	req, out := c.GetPropertyValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPropertyValuePages iterates over the pages of a GetPropertyValue operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPropertyValue method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetPropertyValue operation.
//	pageNum := 0
//	err := client.GetPropertyValuePages(params,
//	    func(page *iottwinmaker.GetPropertyValueOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) GetPropertyValuePages(input *GetPropertyValueInput, fn func(*GetPropertyValueOutput, bool) bool) error {
	return c.GetPropertyValuePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPropertyValuePagesWithContext same as GetPropertyValuePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetPropertyValuePagesWithContext(ctx aws.Context, input *GetPropertyValueInput, fn func(*GetPropertyValueOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPropertyValueInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPropertyValueRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetPropertyValueOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetPropertyValueHistory = "GetPropertyValueHistory"

// GetPropertyValueHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetPropertyValueHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPropertyValueHistory for more information on using the GetPropertyValueHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPropertyValueHistoryRequest method.
//	req, resp := client.GetPropertyValueHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory
func (c *IoTTwinMaker) GetPropertyValueHistoryRequest(input *GetPropertyValueHistoryInput) (req *request.Request, output *GetPropertyValueHistoryOutput) {
	op := &request.Operation{
		Name:       opGetPropertyValueHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/entity-properties/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPropertyValueHistoryInput{}
	}

	output = &GetPropertyValueHistoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetPropertyValueHistory API operation for AWS IoT TwinMaker.
//
// Retrieves information about the history of a time series property value for
// a component, component type, entity, or workspace.
//
// You must specify a value for workspaceId. For entity-specific queries, specify
// values for componentName and entityId. For cross-entity quries, specify a
// value for componentTypeId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation GetPropertyValueHistory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - ConnectorFailureException
//     The connector failed.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ConnectorTimeoutException
//     The connector timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory
func (c *IoTTwinMaker) GetPropertyValueHistory(input *GetPropertyValueHistoryInput) (*GetPropertyValueHistoryOutput, error) {
	req, out := c.GetPropertyValueHistoryRequest(input)
	return out, req.Send()
}

// GetPropertyValueHistoryWithContext is the same as GetPropertyValueHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetPropertyValueHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetPropertyValueHistoryWithContext(ctx aws.Context, input *GetPropertyValueHistoryInput, opts ...request.Option) (*GetPropertyValueHistoryOutput, error) {
	req, out := c.GetPropertyValueHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPropertyValueHistoryPages iterates over the pages of a GetPropertyValueHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPropertyValueHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetPropertyValueHistory operation.
//	pageNum := 0
//	err := client.GetPropertyValueHistoryPages(params,
//	    func(page *iottwinmaker.GetPropertyValueHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) GetPropertyValueHistoryPages(input *GetPropertyValueHistoryInput, fn func(*GetPropertyValueHistoryOutput, bool) bool) error {
	return c.GetPropertyValueHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPropertyValueHistoryPagesWithContext same as GetPropertyValueHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetPropertyValueHistoryPagesWithContext(ctx aws.Context, input *GetPropertyValueHistoryInput, fn func(*GetPropertyValueHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPropertyValueHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPropertyValueHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetPropertyValueHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetScene = "GetScene"

// GetSceneRequest generates a "aws/request.Request" representing the
// client's request for the GetScene operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetScene for more information on using the GetScene
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSceneRequest method.
//	req, resp := client.GetSceneRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetScene
func (c *IoTTwinMaker) GetSceneRequest(input *GetSceneInput) (req *request.Request, output *GetSceneOutput) {
	op := &request.Operation{
		Name:       opGetScene,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}/scenes/{sceneId}",
	}

	if input == nil {
		input = &GetSceneInput{}
	}

	output = &GetSceneOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetScene API operation for AWS IoT TwinMaker.
//
// Retrieves information about a scene.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation GetScene for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetScene
func (c *IoTTwinMaker) GetScene(input *GetSceneInput) (*GetSceneOutput, error) {
	req, out := c.GetSceneRequest(input)
	return out, req.Send()
}

// GetSceneWithContext is the same as GetScene with the addition of
// the ability to pass a context and additional request options.
//
// See GetScene for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetSceneWithContext(ctx aws.Context, input *GetSceneInput, opts ...request.Option) (*GetSceneOutput, error) {
	req, out := c.GetSceneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSyncJob = "GetSyncJob"

// GetSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the GetSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSyncJob for more information on using the GetSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSyncJobRequest method.
//	req, resp := client.GetSyncJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetSyncJob
func (c *IoTTwinMaker) GetSyncJobRequest(input *GetSyncJobInput) (req *request.Request, output *GetSyncJobOutput) {
	op := &request.Operation{
		Name:       opGetSyncJob,
		HTTPMethod: "GET",
		HTTPPath:   "/sync-jobs/{syncSource}",
	}

	if input == nil {
		input = &GetSyncJobInput{}
	}

	output = &GetSyncJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetSyncJob API operation for AWS IoT TwinMaker.
//
// Gets the SyncJob.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation GetSyncJob for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetSyncJob
func (c *IoTTwinMaker) GetSyncJob(input *GetSyncJobInput) (*GetSyncJobOutput, error) {
	req, out := c.GetSyncJobRequest(input)
	return out, req.Send()
}

// GetSyncJobWithContext is the same as GetSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetSyncJobWithContext(ctx aws.Context, input *GetSyncJobInput, opts ...request.Option) (*GetSyncJobOutput, error) {
	req, out := c.GetSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkspace = "GetWorkspace"

// GetWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkspace for more information on using the GetWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkspaceRequest method.
//	req, resp := client.GetWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetWorkspace
func (c *IoTTwinMaker) GetWorkspaceRequest(input *GetWorkspaceInput) (req *request.Request, output *GetWorkspaceOutput) {
	op := &request.Operation{
		Name:       opGetWorkspace,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &GetWorkspaceInput{}
	}

	output = &GetWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetWorkspace API operation for AWS IoT TwinMaker.
//
// Retrieves information about a workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation GetWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetWorkspace
func (c *IoTTwinMaker) GetWorkspace(input *GetWorkspaceInput) (*GetWorkspaceOutput, error) {
	req, out := c.GetWorkspaceRequest(input)
	return out, req.Send()
}

// GetWorkspaceWithContext is the same as GetWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) GetWorkspaceWithContext(ctx aws.Context, input *GetWorkspaceInput, opts ...request.Option) (*GetWorkspaceOutput, error) {
	req, out := c.GetWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListComponentTypes = "ListComponentTypes"

// ListComponentTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListComponentTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponentTypes for more information on using the ListComponentTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComponentTypesRequest method.
//	req, resp := client.ListComponentTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes
func (c *IoTTwinMaker) ListComponentTypesRequest(input *ListComponentTypesInput) (req *request.Request, output *ListComponentTypesOutput) {
	op := &request.Operation{
		Name:       opListComponentTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/component-types-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentTypesInput{}
	}

	output = &ListComponentTypesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListComponentTypes API operation for AWS IoT TwinMaker.
//
// Lists all component types in a workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation ListComponentTypes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes
func (c *IoTTwinMaker) ListComponentTypes(input *ListComponentTypesInput) (*ListComponentTypesOutput, error) {
	req, out := c.ListComponentTypesRequest(input)
	return out, req.Send()
}

// ListComponentTypesWithContext is the same as ListComponentTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponentTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListComponentTypesWithContext(ctx aws.Context, input *ListComponentTypesInput, opts ...request.Option) (*ListComponentTypesOutput, error) {
	req, out := c.ListComponentTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentTypesPages iterates over the pages of a ListComponentTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponentTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComponentTypes operation.
//	pageNum := 0
//	err := client.ListComponentTypesPages(params,
//	    func(page *iottwinmaker.ListComponentTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) ListComponentTypesPages(input *ListComponentTypesInput, fn func(*ListComponentTypesOutput, bool) bool) error {
	return c.ListComponentTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentTypesPagesWithContext same as ListComponentTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListComponentTypesPagesWithContext(ctx aws.Context, input *ListComponentTypesInput, fn func(*ListComponentTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEntities = "ListEntities"

// ListEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntities for more information on using the ListEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEntitiesRequest method.
//	req, resp := client.ListEntitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities
func (c *IoTTwinMaker) ListEntitiesRequest(input *ListEntitiesInput) (req *request.Request, output *ListEntitiesOutput) {
	op := &request.Operation{
		Name:       opListEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/entities-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitiesInput{}
	}

	output = &ListEntitiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListEntities API operation for AWS IoT TwinMaker.
//
// Lists all entities in a workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation ListEntities for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities
func (c *IoTTwinMaker) ListEntities(input *ListEntitiesInput) (*ListEntitiesOutput, error) {
	req, out := c.ListEntitiesRequest(input)
	return out, req.Send()
}

// ListEntitiesWithContext is the same as ListEntities with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListEntitiesWithContext(ctx aws.Context, input *ListEntitiesInput, opts ...request.Option) (*ListEntitiesOutput, error) {
	req, out := c.ListEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntitiesPages iterates over the pages of a ListEntities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEntities operation.
//	pageNum := 0
//	err := client.ListEntitiesPages(params,
//	    func(page *iottwinmaker.ListEntitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) ListEntitiesPages(input *ListEntitiesInput, fn func(*ListEntitiesOutput, bool) bool) error {
	return c.ListEntitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntitiesPagesWithContext same as ListEntitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListEntitiesPagesWithContext(ctx aws.Context, input *ListEntitiesInput, fn func(*ListEntitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListScenes = "ListScenes"

// ListScenesRequest generates a "aws/request.Request" representing the
// client's request for the ListScenes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScenes for more information on using the ListScenes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListScenesRequest method.
//	req, resp := client.ListScenesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes
func (c *IoTTwinMaker) ListScenesRequest(input *ListScenesInput) (req *request.Request, output *ListScenesOutput) {
	op := &request.Operation{
		Name:       opListScenes,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/scenes-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListScenesInput{}
	}

	output = &ListScenesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListScenes API operation for AWS IoT TwinMaker.
//
// Lists all scenes in a workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation ListScenes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes
func (c *IoTTwinMaker) ListScenes(input *ListScenesInput) (*ListScenesOutput, error) {
	req, out := c.ListScenesRequest(input)
	return out, req.Send()
}

// ListScenesWithContext is the same as ListScenes with the addition of
// the ability to pass a context and additional request options.
//
// See ListScenes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListScenesWithContext(ctx aws.Context, input *ListScenesInput, opts ...request.Option) (*ListScenesOutput, error) {
	req, out := c.ListScenesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListScenesPages iterates over the pages of a ListScenes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListScenes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListScenes operation.
//	pageNum := 0
//	err := client.ListScenesPages(params,
//	    func(page *iottwinmaker.ListScenesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) ListScenesPages(input *ListScenesInput, fn func(*ListScenesOutput, bool) bool) error {
	return c.ListScenesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListScenesPagesWithContext same as ListScenesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListScenesPagesWithContext(ctx aws.Context, input *ListScenesInput, fn func(*ListScenesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListScenesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListScenesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListScenesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSyncJobs = "ListSyncJobs"

// ListSyncJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSyncJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSyncJobs for more information on using the ListSyncJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSyncJobsRequest method.
//	req, resp := client.ListSyncJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs
func (c *IoTTwinMaker) ListSyncJobsRequest(input *ListSyncJobsInput) (req *request.Request, output *ListSyncJobsOutput) {
	op := &request.Operation{
		Name:       opListSyncJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/sync-jobs-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSyncJobsInput{}
	}

	output = &ListSyncJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListSyncJobs API operation for AWS IoT TwinMaker.
//
// List all SyncJobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation ListSyncJobs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs
func (c *IoTTwinMaker) ListSyncJobs(input *ListSyncJobsInput) (*ListSyncJobsOutput, error) {
	req, out := c.ListSyncJobsRequest(input)
	return out, req.Send()
}

// ListSyncJobsWithContext is the same as ListSyncJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSyncJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListSyncJobsWithContext(ctx aws.Context, input *ListSyncJobsInput, opts ...request.Option) (*ListSyncJobsOutput, error) {
	req, out := c.ListSyncJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSyncJobsPages iterates over the pages of a ListSyncJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSyncJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSyncJobs operation.
//	pageNum := 0
//	err := client.ListSyncJobsPages(params,
//	    func(page *iottwinmaker.ListSyncJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) ListSyncJobsPages(input *ListSyncJobsInput, fn func(*ListSyncJobsOutput, bool) bool) error {
	return c.ListSyncJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSyncJobsPagesWithContext same as ListSyncJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListSyncJobsPagesWithContext(ctx aws.Context, input *ListSyncJobsInput, fn func(*ListSyncJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSyncJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSyncJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSyncJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSyncResources = "ListSyncResources"

// ListSyncResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListSyncResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSyncResources for more information on using the ListSyncResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSyncResourcesRequest method.
//	req, resp := client.ListSyncResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources
func (c *IoTTwinMaker) ListSyncResourcesRequest(input *ListSyncResourcesInput) (req *request.Request, output *ListSyncResourcesOutput) {
	op := &request.Operation{
		Name:       opListSyncResources,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/sync-jobs/{syncSource}/resources-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSyncResourcesInput{}
	}

	output = &ListSyncResourcesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListSyncResources API operation for AWS IoT TwinMaker.
//
// Lists the sync resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation ListSyncResources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources
func (c *IoTTwinMaker) ListSyncResources(input *ListSyncResourcesInput) (*ListSyncResourcesOutput, error) {
	req, out := c.ListSyncResourcesRequest(input)
	return out, req.Send()
}

// ListSyncResourcesWithContext is the same as ListSyncResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListSyncResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListSyncResourcesWithContext(ctx aws.Context, input *ListSyncResourcesInput, opts ...request.Option) (*ListSyncResourcesOutput, error) {
	req, out := c.ListSyncResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSyncResourcesPages iterates over the pages of a ListSyncResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSyncResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSyncResources operation.
//	pageNum := 0
//	err := client.ListSyncResourcesPages(params,
//	    func(page *iottwinmaker.ListSyncResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) ListSyncResourcesPages(input *ListSyncResourcesInput, fn func(*ListSyncResourcesOutput, bool) bool) error {
	return c.ListSyncResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSyncResourcesPagesWithContext same as ListSyncResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListSyncResourcesPagesWithContext(ctx aws.Context, input *ListSyncResourcesInput, fn func(*ListSyncResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSyncResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSyncResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSyncResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListTagsForResource
func (c *IoTTwinMaker) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags-list",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTagsForResource API operation for AWS IoT TwinMaker.
//
// Lists all tags associated with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListTagsForResource
func (c *IoTTwinMaker) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkspaces = "ListWorkspaces"

// ListWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkspaces for more information on using the ListWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkspacesRequest method.
//	req, resp := client.ListWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces
func (c *IoTTwinMaker) ListWorkspacesRequest(input *ListWorkspacesInput) (req *request.Request, output *ListWorkspacesOutput) {
	op := &request.Operation{
		Name:       opListWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkspacesInput{}
	}

	output = &ListWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListWorkspaces API operation for AWS IoT TwinMaker.
//
// Retrieves information about workspaces in the current account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation ListWorkspaces for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces
func (c *IoTTwinMaker) ListWorkspaces(input *ListWorkspacesInput) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	return out, req.Send()
}

// ListWorkspacesWithContext is the same as ListWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListWorkspacesWithContext(ctx aws.Context, input *ListWorkspacesInput, opts ...request.Option) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkspacesPages iterates over the pages of a ListWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkspaces operation.
//	pageNum := 0
//	err := client.ListWorkspacesPages(params,
//	    func(page *iottwinmaker.ListWorkspacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTTwinMaker) ListWorkspacesPages(input *ListWorkspacesInput, fn func(*ListWorkspacesOutput, bool) bool) error {
	return c.ListWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkspacesPagesWithContext same as ListWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) ListWorkspacesPagesWithContext(ctx aws.Context, input *ListWorkspacesInput, fn func(*ListWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkspacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/TagResource
func (c *IoTTwinMaker) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// TagResource API operation for AWS IoT TwinMaker.
//
// Adds tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - TooManyTagsException
//     The number of tags exceeds the limit.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/TagResource
func (c *IoTTwinMaker) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UntagResource
func (c *IoTTwinMaker) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UntagResource API operation for AWS IoT TwinMaker.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UntagResource
func (c *IoTTwinMaker) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComponentType = "UpdateComponentType"

// UpdateComponentTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComponentType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComponentType for more information on using the UpdateComponentType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateComponentTypeRequest method.
//	req, resp := client.UpdateComponentTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateComponentType
func (c *IoTTwinMaker) UpdateComponentTypeRequest(input *UpdateComponentTypeInput) (req *request.Request, output *UpdateComponentTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateComponentType,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}/component-types/{componentTypeId}",
	}

	if input == nil {
		input = &UpdateComponentTypeInput{}
	}

	output = &UpdateComponentTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateComponentType API operation for AWS IoT TwinMaker.
//
// Updates information in a component type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation UpdateComponentType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateComponentType
func (c *IoTTwinMaker) UpdateComponentType(input *UpdateComponentTypeInput) (*UpdateComponentTypeOutput, error) {
	req, out := c.UpdateComponentTypeRequest(input)
	return out, req.Send()
}

// UpdateComponentTypeWithContext is the same as UpdateComponentType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComponentType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) UpdateComponentTypeWithContext(ctx aws.Context, input *UpdateComponentTypeInput, opts ...request.Option) (*UpdateComponentTypeOutput, error) {
	req, out := c.UpdateComponentTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEntity = "UpdateEntity"

// UpdateEntityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEntity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEntity for more information on using the UpdateEntity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEntityRequest method.
//	req, resp := client.UpdateEntityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateEntity
func (c *IoTTwinMaker) UpdateEntityRequest(input *UpdateEntityInput) (req *request.Request, output *UpdateEntityOutput) {
	op := &request.Operation{
		Name:       opUpdateEntity,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}/entities/{entityId}",
	}

	if input == nil {
		input = &UpdateEntityInput{}
	}

	output = &UpdateEntityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateEntity API operation for AWS IoT TwinMaker.
//
// Updates an entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation UpdateEntity for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ConflictException
//     A conflict occurred.
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateEntity
func (c *IoTTwinMaker) UpdateEntity(input *UpdateEntityInput) (*UpdateEntityOutput, error) {
	req, out := c.UpdateEntityRequest(input)
	return out, req.Send()
}

// UpdateEntityWithContext is the same as UpdateEntity with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEntity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) UpdateEntityWithContext(ctx aws.Context, input *UpdateEntityInput, opts ...request.Option) (*UpdateEntityOutput, error) {
	req, out := c.UpdateEntityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePricingPlan = "UpdatePricingPlan"

// UpdatePricingPlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePricingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePricingPlan for more information on using the UpdatePricingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePricingPlanRequest method.
//	req, resp := client.UpdatePricingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdatePricingPlan
func (c *IoTTwinMaker) UpdatePricingPlanRequest(input *UpdatePricingPlanInput) (req *request.Request, output *UpdatePricingPlanOutput) {
	op := &request.Operation{
		Name:       opUpdatePricingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/pricingplan",
	}

	if input == nil {
		input = &UpdatePricingPlanInput{}
	}

	output = &UpdatePricingPlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdatePricingPlan API operation for AWS IoT TwinMaker.
//
// Update the pricing plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation UpdatePricingPlan for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdatePricingPlan
func (c *IoTTwinMaker) UpdatePricingPlan(input *UpdatePricingPlanInput) (*UpdatePricingPlanOutput, error) {
	req, out := c.UpdatePricingPlanRequest(input)
	return out, req.Send()
}

// UpdatePricingPlanWithContext is the same as UpdatePricingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePricingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) UpdatePricingPlanWithContext(ctx aws.Context, input *UpdatePricingPlanInput, opts ...request.Option) (*UpdatePricingPlanOutput, error) {
	req, out := c.UpdatePricingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScene = "UpdateScene"

// UpdateSceneRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScene operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScene for more information on using the UpdateScene
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSceneRequest method.
//	req, resp := client.UpdateSceneRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateScene
func (c *IoTTwinMaker) UpdateSceneRequest(input *UpdateSceneInput) (req *request.Request, output *UpdateSceneOutput) {
	op := &request.Operation{
		Name:       opUpdateScene,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}/scenes/{sceneId}",
	}

	if input == nil {
		input = &UpdateSceneInput{}
	}

	output = &UpdateSceneOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateScene API operation for AWS IoT TwinMaker.
//
// Updates a scene.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation UpdateScene for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateScene
func (c *IoTTwinMaker) UpdateScene(input *UpdateSceneInput) (*UpdateSceneOutput, error) {
	req, out := c.UpdateSceneRequest(input)
	return out, req.Send()
}

// UpdateSceneWithContext is the same as UpdateScene with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScene for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) UpdateSceneWithContext(ctx aws.Context, input *UpdateSceneInput, opts ...request.Option) (*UpdateSceneOutput, error) {
	req, out := c.UpdateSceneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspace = "UpdateWorkspace"

// UpdateWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspace for more information on using the UpdateWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkspaceRequest method.
//	req, resp := client.UpdateWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateWorkspace
func (c *IoTTwinMaker) UpdateWorkspaceRequest(input *UpdateWorkspaceInput) (req *request.Request, output *UpdateWorkspaceOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspace,
		HTTPMethod: "PUT",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &UpdateWorkspaceInput{}
	}

	output = &UpdateWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateWorkspace API operation for AWS IoT TwinMaker.
//
// Updates a workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT TwinMaker's
// API operation UpdateWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An unexpected error has occurred.
//
//   - AccessDeniedException
//     Access is denied.
//
//   - ResourceNotFoundException
//     The resource wasn't found.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - ValidationException
//     Failed
//
//   - ServiceQuotaExceededException
//     The service quota was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateWorkspace
func (c *IoTTwinMaker) UpdateWorkspace(input *UpdateWorkspaceInput) (*UpdateWorkspaceOutput, error) {
	req, out := c.UpdateWorkspaceRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceWithContext is the same as UpdateWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTTwinMaker) UpdateWorkspaceWithContext(ctx aws.Context, input *UpdateWorkspaceInput, opts ...request.Option) (*UpdateWorkspaceOutput, error) {
	req, out := c.UpdateWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access is denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An error returned by the BatchPutProperty action.
type BatchPutPropertyError struct {
	_ struct{} `type:"structure"`

	// An object that contains information about errors returned by the BatchPutProperty
	// action.
	//
	// Entry is a required field
	Entry *PropertyValueEntry `locationName:"entry" type:"structure" required:"true"`

	// The error code.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" min:"1" type:"string" required:"true"`

	// The error message.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutPropertyError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutPropertyError) GoString() string {
	return s.String()
}

// SetEntry sets the Entry field's value.
func (s *BatchPutPropertyError) SetEntry(v *PropertyValueEntry) *BatchPutPropertyError {
	s.Entry = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchPutPropertyError) SetErrorCode(v string) *BatchPutPropertyError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchPutPropertyError) SetErrorMessage(v string) *BatchPutPropertyError {
	s.ErrorMessage = &v
	return s
}

// An object that contains information about errors returned by the BatchPutProperty
// action.
type BatchPutPropertyErrorEntry struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain information about errors returned by the BatchPutProperty
	// action.
	//
	// Errors is a required field
	Errors []*BatchPutPropertyError `locationName:"errors" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutPropertyErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutPropertyErrorEntry) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchPutPropertyErrorEntry) SetErrors(v []*BatchPutPropertyError) *BatchPutPropertyErrorEntry {
	s.Errors = v
	return s
}

type BatchPutPropertyValuesInput struct {
	_ struct{} `type:"structure"`

	// An object that maps strings to the property value entries to set. Each string
	// in the mapping must be unique to this object.
	//
	// Entries is a required field
	Entries []*PropertyValueEntry `locationName:"entries" min:"1" type:"list" required:"true"`

	// The ID of the workspace that contains the properties to set.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutPropertyValuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutPropertyValuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutPropertyValuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutPropertyValuesInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *BatchPutPropertyValuesInput) SetEntries(v []*PropertyValueEntry) *BatchPutPropertyValuesInput {
	s.Entries = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *BatchPutPropertyValuesInput) SetWorkspaceId(v string) *BatchPutPropertyValuesInput {
	s.WorkspaceId = &v
	return s
}

type BatchPutPropertyValuesOutput struct {
	_ struct{} `type:"structure"`

	// Entries that caused errors in the batch put operation.
	//
	// ErrorEntries is a required field
	ErrorEntries []*BatchPutPropertyErrorEntry `locationName:"errorEntries" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutPropertyValuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutPropertyValuesOutput) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *BatchPutPropertyValuesOutput) SetErrorEntries(v []*BatchPutPropertyErrorEntry) *BatchPutPropertyValuesOutput {
	s.ErrorEntries = v
	return s
}

// Information about pricing bundle.
type BundleInformation struct {
	_ struct{} `type:"structure"`

	// The bundle names.
	//
	// BundleNames is a required field
	BundleNames []*string `locationName:"bundleNames" min:"1" type:"list" required:"true"`

	// The pricing tier.
	PricingTier *string `locationName:"pricingTier" type:"string" enum:"PricingTier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BundleInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BundleInformation) GoString() string {
	return s.String()
}

// SetBundleNames sets the BundleNames field's value.
func (s *BundleInformation) SetBundleNames(v []*string) *BundleInformation {
	s.BundleNames = v
	return s
}

// SetPricingTier sets the PricingTier field's value.
func (s *BundleInformation) SetPricingTier(v string) *BundleInformation {
	s.PricingTier = &v
	return s
}

// A description of the column in the query results.
type ColumnDescription struct {
	_ struct{} `type:"structure"`

	// The name of the column description.
	Name *string `locationName:"name" type:"string"`

	// The type of the column description.
	Type *string `locationName:"type" type:"string" enum:"ColumnType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnDescription) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ColumnDescription) SetName(v string) *ColumnDescription {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnDescription) SetType(v string) *ColumnDescription {
	s.Type = &v
	return s
}

type ComponentPropertyGroupRequest struct {
	_ struct{} `type:"structure"`

	// The group type.
	GroupType *string `locationName:"groupType" type:"string" enum:"GroupType"`

	// The property names.
	PropertyNames []*string `locationName:"propertyNames" type:"list"`

	// The update type.
	UpdateType *string `locationName:"updateType" type:"string" enum:"PropertyGroupUpdateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentPropertyGroupRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentPropertyGroupRequest) GoString() string {
	return s.String()
}

// SetGroupType sets the GroupType field's value.
func (s *ComponentPropertyGroupRequest) SetGroupType(v string) *ComponentPropertyGroupRequest {
	s.GroupType = &v
	return s
}

// SetPropertyNames sets the PropertyNames field's value.
func (s *ComponentPropertyGroupRequest) SetPropertyNames(v []*string) *ComponentPropertyGroupRequest {
	s.PropertyNames = v
	return s
}

// SetUpdateType sets the UpdateType field's value.
func (s *ComponentPropertyGroupRequest) SetUpdateType(v string) *ComponentPropertyGroupRequest {
	s.UpdateType = &v
	return s
}

// The component property group response.
type ComponentPropertyGroupResponse struct {
	_ struct{} `type:"structure"`

	// The group type.
	//
	// GroupType is a required field
	GroupType *string `locationName:"groupType" type:"string" required:"true" enum:"GroupType"`

	// A Boolean value that specifies whether the property group is inherited from
	// a parent entity
	//
	// IsInherited is a required field
	IsInherited *bool `locationName:"isInherited" type:"boolean" required:"true"`

	// The names of properties
	//
	// PropertyNames is a required field
	PropertyNames []*string `locationName:"propertyNames" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentPropertyGroupResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentPropertyGroupResponse) GoString() string {
	return s.String()
}

// SetGroupType sets the GroupType field's value.
func (s *ComponentPropertyGroupResponse) SetGroupType(v string) *ComponentPropertyGroupResponse {
	s.GroupType = &v
	return s
}

// SetIsInherited sets the IsInherited field's value.
func (s *ComponentPropertyGroupResponse) SetIsInherited(v bool) *ComponentPropertyGroupResponse {
	s.IsInherited = &v
	return s
}

// SetPropertyNames sets the PropertyNames field's value.
func (s *ComponentPropertyGroupResponse) SetPropertyNames(v []*string) *ComponentPropertyGroupResponse {
	s.PropertyNames = v
	return s
}

// An object that sets information about a component type create or update request.
type ComponentRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the component type.
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string"`

	// The description of the component request.
	Description *string `locationName:"description" type:"string"`

	// An object that maps strings to the properties to set in the component type.
	// Each string in the mapping must be unique to this object.
	Properties map[string]*PropertyRequest `locationName:"properties" type:"map"`

	// The property groups.
	PropertyGroups map[string]*ComponentPropertyGroupRequest `locationName:"propertyGroups" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentRequest"}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.Properties != nil {
		for i, v := range s.Properties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Properties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *ComponentRequest) SetComponentTypeId(v string) *ComponentRequest {
	s.ComponentTypeId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ComponentRequest) SetDescription(v string) *ComponentRequest {
	s.Description = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *ComponentRequest) SetProperties(v map[string]*PropertyRequest) *ComponentRequest {
	s.Properties = v
	return s
}

// SetPropertyGroups sets the PropertyGroups field's value.
func (s *ComponentRequest) SetPropertyGroups(v map[string]*ComponentPropertyGroupRequest) *ComponentRequest {
	s.PropertyGroups = v
	return s
}

// An object that returns information about a component type create or update
// request.
type ComponentResponse struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The ID of the component type.
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string"`

	// The name of the property definition set in the request.
	DefinedIn *string `locationName:"definedIn" min:"1" type:"string"`

	// The description of the component type.
	Description *string `locationName:"description" type:"string"`

	// An object that maps strings to the properties to set in the component type.
	// Each string in the mapping must be unique to this object.
	Properties map[string]*PropertyResponse `locationName:"properties" type:"map"`

	// The property groups.
	PropertyGroups map[string]*ComponentPropertyGroupResponse `locationName:"propertyGroups" type:"map"`

	// The status of the component type.
	Status *Status `locationName:"status" type:"structure"`

	// The syncSource of the sync job, if this entity was created by a sync job.
	SyncSource *string `locationName:"syncSource" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentResponse) GoString() string {
	return s.String()
}

// SetComponentName sets the ComponentName field's value.
func (s *ComponentResponse) SetComponentName(v string) *ComponentResponse {
	s.ComponentName = &v
	return s
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *ComponentResponse) SetComponentTypeId(v string) *ComponentResponse {
	s.ComponentTypeId = &v
	return s
}

// SetDefinedIn sets the DefinedIn field's value.
func (s *ComponentResponse) SetDefinedIn(v string) *ComponentResponse {
	s.DefinedIn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ComponentResponse) SetDescription(v string) *ComponentResponse {
	s.Description = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *ComponentResponse) SetProperties(v map[string]*PropertyResponse) *ComponentResponse {
	s.Properties = v
	return s
}

// SetPropertyGroups sets the PropertyGroups field's value.
func (s *ComponentResponse) SetPropertyGroups(v map[string]*ComponentPropertyGroupResponse) *ComponentResponse {
	s.PropertyGroups = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ComponentResponse) SetStatus(v *Status) *ComponentResponse {
	s.Status = v
	return s
}

// SetSyncSource sets the SyncSource field's value.
func (s *ComponentResponse) SetSyncSource(v string) *ComponentResponse {
	s.SyncSource = &v
	return s
}

// An object that contains information about a component type.
type ComponentTypeSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the component type.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The ID of the component type.
	//
	// ComponentTypeId is a required field
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string" required:"true"`

	// The component type name.
	ComponentTypeName *string `locationName:"componentTypeName" type:"string"`

	// The date and time when the component type was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The description of the component type.
	Description *string `locationName:"description" type:"string"`

	// The current status of the component type.
	Status *Status `locationName:"status" type:"structure"`

	// The date and time when the component type was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentTypeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentTypeSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ComponentTypeSummary) SetArn(v string) *ComponentTypeSummary {
	s.Arn = &v
	return s
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *ComponentTypeSummary) SetComponentTypeId(v string) *ComponentTypeSummary {
	s.ComponentTypeId = &v
	return s
}

// SetComponentTypeName sets the ComponentTypeName field's value.
func (s *ComponentTypeSummary) SetComponentTypeName(v string) *ComponentTypeSummary {
	s.ComponentTypeName = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *ComponentTypeSummary) SetCreationDateTime(v time.Time) *ComponentTypeSummary {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ComponentTypeSummary) SetDescription(v string) *ComponentTypeSummary {
	s.Description = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ComponentTypeSummary) SetStatus(v *Status) *ComponentTypeSummary {
	s.Status = v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *ComponentTypeSummary) SetUpdateDateTime(v time.Time) *ComponentTypeSummary {
	s.UpdateDateTime = &v
	return s
}

// The component update request.
type ComponentUpdateRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the component type.
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string"`

	// The description of the component type.
	Description *string `locationName:"description" type:"string"`

	// The property group updates.
	PropertyGroupUpdates map[string]*ComponentPropertyGroupRequest `locationName:"propertyGroupUpdates" type:"map"`

	// An object that maps strings to the properties to set in the component type
	// update. Each string in the mapping must be unique to this object.
	PropertyUpdates map[string]*PropertyRequest `locationName:"propertyUpdates" type:"map"`

	// The update type of the component update request.
	UpdateType *string `locationName:"updateType" type:"string" enum:"ComponentUpdateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentUpdateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentUpdateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentUpdateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComponentUpdateRequest"}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.PropertyUpdates != nil {
		for i, v := range s.PropertyUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *ComponentUpdateRequest) SetComponentTypeId(v string) *ComponentUpdateRequest {
	s.ComponentTypeId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ComponentUpdateRequest) SetDescription(v string) *ComponentUpdateRequest {
	s.Description = &v
	return s
}

// SetPropertyGroupUpdates sets the PropertyGroupUpdates field's value.
func (s *ComponentUpdateRequest) SetPropertyGroupUpdates(v map[string]*ComponentPropertyGroupRequest) *ComponentUpdateRequest {
	s.PropertyGroupUpdates = v
	return s
}

// SetPropertyUpdates sets the PropertyUpdates field's value.
func (s *ComponentUpdateRequest) SetPropertyUpdates(v map[string]*PropertyRequest) *ComponentUpdateRequest {
	s.PropertyUpdates = v
	return s
}

// SetUpdateType sets the UpdateType field's value.
func (s *ComponentUpdateRequest) SetUpdateType(v string) *ComponentUpdateRequest {
	s.UpdateType = &v
	return s
}

// A conflict occurred.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The connector failed.
type ConnectorFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorFailureException) GoString() string {
	return s.String()
}

func newErrorConnectorFailureException(v protocol.ResponseMetadata) error {
	return &ConnectorFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConnectorFailureException) Code() string {
	return "ConnectorFailureException"
}

// Message returns the exception's message.
func (s *ConnectorFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConnectorFailureException) OrigErr() error {
	return nil
}

func (s *ConnectorFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConnectorFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConnectorFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The connector timed out.
type ConnectorTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorTimeoutException) GoString() string {
	return s.String()
}

func newErrorConnectorTimeoutException(v protocol.ResponseMetadata) error {
	return &ConnectorTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConnectorTimeoutException) Code() string {
	return "ConnectorTimeoutException"
}

// Message returns the exception's message.
func (s *ConnectorTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConnectorTimeoutException) OrigErr() error {
	return nil
}

func (s *ConnectorTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConnectorTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConnectorTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateComponentTypeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the component type.
	//
	// ComponentTypeId is a required field
	ComponentTypeId *string `location:"uri" locationName:"componentTypeId" min:"1" type:"string" required:"true"`

	// A friendly name for the component type.
	ComponentTypeName *string `locationName:"componentTypeName" type:"string"`

	// The description of the component type.
	Description *string `locationName:"description" type:"string"`

	// Specifies the parent component type to extend.
	ExtendsFrom []*string `locationName:"extendsFrom" type:"list"`

	// An object that maps strings to the functions in the component type. Each
	// string in the mapping must be unique to this object.
	Functions map[string]*FunctionRequest `locationName:"functions" type:"map"`

	// A Boolean value that specifies whether an entity can have more than one component
	// of this type.
	IsSingleton *bool `locationName:"isSingleton" type:"boolean"`

	// An object that maps strings to the property definitions in the component
	// type. Each string in the mapping must be unique to this object.
	PropertyDefinitions map[string]*PropertyDefinitionRequest `locationName:"propertyDefinitions" type:"map"`

	PropertyGroups map[string]*PropertyGroupRequest `locationName:"propertyGroups" type:"map"`

	// Metadata that you can use to manage the component type.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the workspace that contains the component type.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComponentTypeInput"}
	if s.ComponentTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentTypeId"))
	}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.Functions != nil {
		for i, v := range s.Functions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Functions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PropertyDefinitions != nil {
		for i, v := range s.PropertyDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *CreateComponentTypeInput) SetComponentTypeId(v string) *CreateComponentTypeInput {
	s.ComponentTypeId = &v
	return s
}

// SetComponentTypeName sets the ComponentTypeName field's value.
func (s *CreateComponentTypeInput) SetComponentTypeName(v string) *CreateComponentTypeInput {
	s.ComponentTypeName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateComponentTypeInput) SetDescription(v string) *CreateComponentTypeInput {
	s.Description = &v
	return s
}

// SetExtendsFrom sets the ExtendsFrom field's value.
func (s *CreateComponentTypeInput) SetExtendsFrom(v []*string) *CreateComponentTypeInput {
	s.ExtendsFrom = v
	return s
}

// SetFunctions sets the Functions field's value.
func (s *CreateComponentTypeInput) SetFunctions(v map[string]*FunctionRequest) *CreateComponentTypeInput {
	s.Functions = v
	return s
}

// SetIsSingleton sets the IsSingleton field's value.
func (s *CreateComponentTypeInput) SetIsSingleton(v bool) *CreateComponentTypeInput {
	s.IsSingleton = &v
	return s
}

// SetPropertyDefinitions sets the PropertyDefinitions field's value.
func (s *CreateComponentTypeInput) SetPropertyDefinitions(v map[string]*PropertyDefinitionRequest) *CreateComponentTypeInput {
	s.PropertyDefinitions = v
	return s
}

// SetPropertyGroups sets the PropertyGroups field's value.
func (s *CreateComponentTypeInput) SetPropertyGroups(v map[string]*PropertyGroupRequest) *CreateComponentTypeInput {
	s.PropertyGroups = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateComponentTypeInput) SetTags(v map[string]*string) *CreateComponentTypeInput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateComponentTypeInput) SetWorkspaceId(v string) *CreateComponentTypeInput {
	s.WorkspaceId = &v
	return s
}

type CreateComponentTypeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the component type.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time when the entity was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The current state of the component type.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"State"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentTypeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateComponentTypeOutput) SetArn(v string) *CreateComponentTypeOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateComponentTypeOutput) SetCreationDateTime(v time.Time) *CreateComponentTypeOutput {
	s.CreationDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateComponentTypeOutput) SetState(v string) *CreateComponentTypeOutput {
	s.State = &v
	return s
}

type CreateEntityInput struct {
	_ struct{} `type:"structure"`

	// An object that maps strings to the components in the entity. Each string
	// in the mapping must be unique to this object.
	Components map[string]*ComponentRequest `locationName:"components" type:"map"`

	// The description of the entity.
	Description *string `locationName:"description" type:"string"`

	// The ID of the entity.
	EntityId *string `locationName:"entityId" min:"1" type:"string"`

	// The name of the entity.
	//
	// EntityName is a required field
	EntityName *string `locationName:"entityName" min:"1" type:"string" required:"true"`

	// The ID of the entity's parent entity.
	ParentEntityId *string `locationName:"parentEntityId" min:"1" type:"string"`

	// Metadata that you can use to manage the entity.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the workspace that contains the entity.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEntityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEntityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEntityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEntityInput"}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.EntityName == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityName"))
	}
	if s.EntityName != nil && len(*s.EntityName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityName", 1))
	}
	if s.ParentEntityId != nil && len(*s.ParentEntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentEntityId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.Components != nil {
		for i, v := range s.Components {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Components", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponents sets the Components field's value.
func (s *CreateEntityInput) SetComponents(v map[string]*ComponentRequest) *CreateEntityInput {
	s.Components = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEntityInput) SetDescription(v string) *CreateEntityInput {
	s.Description = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *CreateEntityInput) SetEntityId(v string) *CreateEntityInput {
	s.EntityId = &v
	return s
}

// SetEntityName sets the EntityName field's value.
func (s *CreateEntityInput) SetEntityName(v string) *CreateEntityInput {
	s.EntityName = &v
	return s
}

// SetParentEntityId sets the ParentEntityId field's value.
func (s *CreateEntityInput) SetParentEntityId(v string) *CreateEntityInput {
	s.ParentEntityId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEntityInput) SetTags(v map[string]*string) *CreateEntityInput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateEntityInput) SetWorkspaceId(v string) *CreateEntityInput {
	s.WorkspaceId = &v
	return s
}

type CreateEntityOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the entity.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time when the entity was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The ID of the entity.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true"`

	// The current state of the entity.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"State"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEntityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEntityOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateEntityOutput) SetArn(v string) *CreateEntityOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateEntityOutput) SetCreationDateTime(v time.Time) *CreateEntityOutput {
	s.CreationDateTime = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *CreateEntityOutput) SetEntityId(v string) *CreateEntityOutput {
	s.EntityId = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateEntityOutput) SetState(v string) *CreateEntityOutput {
	s.State = &v
	return s
}

type CreateSceneInput struct {
	_ struct{} `type:"structure"`

	// A list of capabilities that the scene uses to render itself.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// The relative path that specifies the location of the content definition file.
	//
	// ContentLocation is a required field
	ContentLocation *string `locationName:"contentLocation" type:"string" required:"true"`

	// The description for this scene.
	Description *string `locationName:"description" type:"string"`

	// The ID of the scene.
	//
	// SceneId is a required field
	SceneId *string `locationName:"sceneId" min:"1" type:"string" required:"true"`

	// Metadata that you can use to manage the scene.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the workspace that contains the scene.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSceneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSceneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSceneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSceneInput"}
	if s.ContentLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentLocation"))
	}
	if s.SceneId == nil {
		invalidParams.Add(request.NewErrParamRequired("SceneId"))
	}
	if s.SceneId != nil && len(*s.SceneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SceneId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateSceneInput) SetCapabilities(v []*string) *CreateSceneInput {
	s.Capabilities = v
	return s
}

// SetContentLocation sets the ContentLocation field's value.
func (s *CreateSceneInput) SetContentLocation(v string) *CreateSceneInput {
	s.ContentLocation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSceneInput) SetDescription(v string) *CreateSceneInput {
	s.Description = &v
	return s
}

// SetSceneId sets the SceneId field's value.
func (s *CreateSceneInput) SetSceneId(v string) *CreateSceneInput {
	s.SceneId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSceneInput) SetTags(v map[string]*string) *CreateSceneInput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateSceneInput) SetWorkspaceId(v string) *CreateSceneInput {
	s.WorkspaceId = &v
	return s
}

type CreateSceneOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the scene.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time when the scene was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSceneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSceneOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSceneOutput) SetArn(v string) *CreateSceneOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateSceneOutput) SetCreationDateTime(v time.Time) *CreateSceneOutput {
	s.CreationDateTime = &v
	return s
}

type CreateSyncJobInput struct {
	_ struct{} `type:"structure"`

	// The SyncJob IAM role. This IAM role is used by the sync job to read from
	// the syncSource, and create, update or delete the corresponding resources.
	//
	// SyncRole is a required field
	SyncRole *string `locationName:"syncRole" min:"20" type:"string" required:"true"`

	// The sync source.
	//
	// Currently the only supported syncSoucre is SITEWISE .
	//
	// SyncSource is a required field
	SyncSource *string `location:"uri" locationName:"syncSource" type:"string" required:"true"`

	// The SyncJob tags.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The workspace Id.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSyncJobInput"}
	if s.SyncRole == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncRole"))
	}
	if s.SyncRole != nil && len(*s.SyncRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SyncRole", 20))
	}
	if s.SyncSource == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncSource"))
	}
	if s.SyncSource != nil && len(*s.SyncSource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SyncSource", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSyncRole sets the SyncRole field's value.
func (s *CreateSyncJobInput) SetSyncRole(v string) *CreateSyncJobInput {
	s.SyncRole = &v
	return s
}

// SetSyncSource sets the SyncSource field's value.
func (s *CreateSyncJobInput) SetSyncSource(v string) *CreateSyncJobInput {
	s.SyncSource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSyncJobInput) SetTags(v map[string]*string) *CreateSyncJobInput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateSyncJobInput) SetWorkspaceId(v string) *CreateSyncJobInput {
	s.WorkspaceId = &v
	return s
}

type CreateSyncJobOutput struct {
	_ struct{} `type:"structure"`

	// The SyncJob ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time for the SyncJob creation.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The SyncJob response state.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"SyncJobState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSyncJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSyncJobOutput) SetArn(v string) *CreateSyncJobOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateSyncJobOutput) SetCreationDateTime(v time.Time) *CreateSyncJobOutput {
	s.CreationDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateSyncJobOutput) SetState(v string) *CreateSyncJobOutput {
	s.State = &v
	return s
}

type CreateWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// The description of the workspace.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the execution role associated with the workspace.
	//
	// Role is a required field
	Role *string `locationName:"role" min:"20" type:"string" required:"true"`

	// The ARN of the S3 bucket where resources associated with the workspace are
	// stored.
	//
	// S3Location is a required field
	S3Location *string `locationName:"s3Location" type:"string" required:"true"`

	// Metadata that you can use to manage the workspace
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspaceInput"}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.S3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Location"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateWorkspaceInput) SetDescription(v string) *CreateWorkspaceInput {
	s.Description = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateWorkspaceInput) SetRole(v string) *CreateWorkspaceInput {
	s.Role = &v
	return s
}

// SetS3Location sets the S3Location field's value.
func (s *CreateWorkspaceInput) SetS3Location(v string) *CreateWorkspaceInput {
	s.S3Location = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceInput) SetTags(v map[string]*string) *CreateWorkspaceInput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateWorkspaceInput) SetWorkspaceId(v string) *CreateWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type CreateWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the workspace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time when the workspace was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorkspaceOutput) SetArn(v string) *CreateWorkspaceOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateWorkspaceOutput) SetCreationDateTime(v time.Time) *CreateWorkspaceOutput {
	s.CreationDateTime = &v
	return s
}

// The data connector.
type DataConnector struct {
	_ struct{} `type:"structure"`

	// A Boolean value that specifies whether the data connector is native to IoT
	// TwinMaker.
	IsNative *bool `locationName:"isNative" type:"boolean"`

	// The Lambda function associated with this data connector.
	Lambda *LambdaFunction `locationName:"lambda" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataConnector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataConnector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataConnector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataConnector"}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsNative sets the IsNative field's value.
func (s *DataConnector) SetIsNative(v bool) *DataConnector {
	s.IsNative = &v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *DataConnector) SetLambda(v *LambdaFunction) *DataConnector {
	s.Lambda = v
	return s
}

// An object that specifies the data type of a property.
type DataType struct {
	_ struct{} `type:"structure"`

	// The allowed values for this data type.
	AllowedValues []*DataValue `locationName:"allowedValues" type:"list"`

	// The nested type in the data type.
	NestedType *DataType `locationName:"nestedType" type:"structure"`

	// A relationship that associates a component with another component.
	Relationship *Relationship `locationName:"relationship" type:"structure"`

	// The underlying type of the data type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"Type"`

	// The unit of measure used in this data type.
	UnitOfMeasure *string `locationName:"unitOfMeasure" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataType"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.UnitOfMeasure != nil && len(*s.UnitOfMeasure) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UnitOfMeasure", 1))
	}
	if s.AllowedValues != nil {
		for i, v := range s.AllowedValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AllowedValues", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NestedType != nil {
		if err := s.NestedType.Validate(); err != nil {
			invalidParams.AddNested("NestedType", err.(request.ErrInvalidParams))
		}
	}
	if s.Relationship != nil {
		if err := s.Relationship.Validate(); err != nil {
			invalidParams.AddNested("Relationship", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *DataType) SetAllowedValues(v []*DataValue) *DataType {
	s.AllowedValues = v
	return s
}

// SetNestedType sets the NestedType field's value.
func (s *DataType) SetNestedType(v *DataType) *DataType {
	s.NestedType = v
	return s
}

// SetRelationship sets the Relationship field's value.
func (s *DataType) SetRelationship(v *Relationship) *DataType {
	s.Relationship = v
	return s
}

// SetType sets the Type field's value.
func (s *DataType) SetType(v string) *DataType {
	s.Type = &v
	return s
}

// SetUnitOfMeasure sets the UnitOfMeasure field's value.
func (s *DataType) SetUnitOfMeasure(v string) *DataType {
	s.UnitOfMeasure = &v
	return s
}

// An object that specifies a value for a property.
type DataValue struct {
	_ struct{} `type:"structure"`

	// A Boolean value.
	BooleanValue *bool `locationName:"booleanValue" type:"boolean"`

	// A double value.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// An expression that produces the value.
	Expression *string `locationName:"expression" min:"1" type:"string"`

	// An integer value.
	IntegerValue *int64 `locationName:"integerValue" type:"integer"`

	// A list of multiple values.
	ListValue []*DataValue `locationName:"listValue" type:"list"`

	// A long value.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// An object that maps strings to multiple DataValue objects.
	MapValue map[string]*DataValue `locationName:"mapValue" type:"map"`

	// A value that relates a component to another component.
	RelationshipValue *RelationshipValue `locationName:"relationshipValue" type:"structure"`

	// A string value.
	StringValue *string `locationName:"stringValue" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataValue"}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.StringValue != nil && len(*s.StringValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StringValue", 1))
	}
	if s.ListValue != nil {
		for i, v := range s.ListValue {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ListValue", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MapValue != nil {
		for i, v := range s.MapValue {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MapValue", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RelationshipValue != nil {
		if err := s.RelationshipValue.Validate(); err != nil {
			invalidParams.AddNested("RelationshipValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *DataValue) SetBooleanValue(v bool) *DataValue {
	s.BooleanValue = &v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *DataValue) SetDoubleValue(v float64) *DataValue {
	s.DoubleValue = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *DataValue) SetExpression(v string) *DataValue {
	s.Expression = &v
	return s
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *DataValue) SetIntegerValue(v int64) *DataValue {
	s.IntegerValue = &v
	return s
}

// SetListValue sets the ListValue field's value.
func (s *DataValue) SetListValue(v []*DataValue) *DataValue {
	s.ListValue = v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *DataValue) SetLongValue(v int64) *DataValue {
	s.LongValue = &v
	return s
}

// SetMapValue sets the MapValue field's value.
func (s *DataValue) SetMapValue(v map[string]*DataValue) *DataValue {
	s.MapValue = v
	return s
}

// SetRelationshipValue sets the RelationshipValue field's value.
func (s *DataValue) SetRelationshipValue(v *RelationshipValue) *DataValue {
	s.RelationshipValue = v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *DataValue) SetStringValue(v string) *DataValue {
	s.StringValue = &v
	return s
}

type DeleteComponentTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the component type to delete.
	//
	// ComponentTypeId is a required field
	ComponentTypeId *string `location:"uri" locationName:"componentTypeId" min:"1" type:"string" required:"true"`

	// The ID of the workspace that contains the component type.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComponentTypeInput"}
	if s.ComponentTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentTypeId"))
	}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *DeleteComponentTypeInput) SetComponentTypeId(v string) *DeleteComponentTypeInput {
	s.ComponentTypeId = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteComponentTypeInput) SetWorkspaceId(v string) *DeleteComponentTypeInput {
	s.WorkspaceId = &v
	return s
}

type DeleteComponentTypeOutput struct {
	_ struct{} `type:"structure"`

	// The current state of the component type to be deleted.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"State"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentTypeOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *DeleteComponentTypeOutput) SetState(v string) *DeleteComponentTypeOutput {
	s.State = &v
	return s
}

type DeleteEntityInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the entity to delete.
	//
	// EntityId is a required field
	EntityId *string `location:"uri" locationName:"entityId" min:"1" type:"string" required:"true"`

	// A Boolean value that specifies whether the operation deletes child entities.
	IsRecursive *bool `location:"querystring" locationName:"isRecursive" type:"boolean"`

	// The ID of the workspace that contains the entity to delete.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEntityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEntityInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *DeleteEntityInput) SetEntityId(v string) *DeleteEntityInput {
	s.EntityId = &v
	return s
}

// SetIsRecursive sets the IsRecursive field's value.
func (s *DeleteEntityInput) SetIsRecursive(v bool) *DeleteEntityInput {
	s.IsRecursive = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteEntityInput) SetWorkspaceId(v string) *DeleteEntityInput {
	s.WorkspaceId = &v
	return s
}

type DeleteEntityOutput struct {
	_ struct{} `type:"structure"`

	// The current state of the deleted entity.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"State"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *DeleteEntityOutput) SetState(v string) *DeleteEntityOutput {
	s.State = &v
	return s
}

type DeleteSceneInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the scene to delete.
	//
	// SceneId is a required field
	SceneId *string `location:"uri" locationName:"sceneId" min:"1" type:"string" required:"true"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSceneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSceneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSceneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSceneInput"}
	if s.SceneId == nil {
		invalidParams.Add(request.NewErrParamRequired("SceneId"))
	}
	if s.SceneId != nil && len(*s.SceneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SceneId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSceneId sets the SceneId field's value.
func (s *DeleteSceneInput) SetSceneId(v string) *DeleteSceneInput {
	s.SceneId = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteSceneInput) SetWorkspaceId(v string) *DeleteSceneInput {
	s.WorkspaceId = &v
	return s
}

type DeleteSceneOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSceneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSceneOutput) GoString() string {
	return s.String()
}

type DeleteSyncJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The sync source.
	//
	// Currently the only supported syncSoucre is SITEWISE .
	//
	// SyncSource is a required field
	SyncSource *string `location:"uri" locationName:"syncSource" type:"string" required:"true"`

	// The workspace Id.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSyncJobInput"}
	if s.SyncSource == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncSource"))
	}
	if s.SyncSource != nil && len(*s.SyncSource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SyncSource", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSyncSource sets the SyncSource field's value.
func (s *DeleteSyncJobInput) SetSyncSource(v string) *DeleteSyncJobInput {
	s.SyncSource = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteSyncJobInput) SetWorkspaceId(v string) *DeleteSyncJobInput {
	s.WorkspaceId = &v
	return s
}

type DeleteSyncJobOutput struct {
	_ struct{} `type:"structure"`

	// The SyncJob response state.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"SyncJobState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSyncJobOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *DeleteSyncJobOutput) SetState(v string) *DeleteSyncJobOutput {
	s.State = &v
	return s
}

type DeleteWorkspaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace to delete.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkspaceInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteWorkspaceInput) SetWorkspaceId(v string) *DeleteWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type DeleteWorkspaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceOutput) GoString() string {
	return s.String()
}

// An object that uniquely identifies an entity property.
type EntityPropertyReference struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The ID of the entity.
	EntityId *string `locationName:"entityId" min:"1" type:"string"`

	// A mapping of external IDs to property names. External IDs uniquely identify
	// properties from external data stores.
	ExternalIdProperty map[string]*string `locationName:"externalIdProperty" type:"map"`

	// The name of the property.
	//
	// PropertyName is a required field
	PropertyName *string `locationName:"propertyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityPropertyReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityPropertyReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityPropertyReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityPropertyReference"}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.PropertyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyName"))
	}
	if s.PropertyName != nil && len(*s.PropertyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *EntityPropertyReference) SetComponentName(v string) *EntityPropertyReference {
	s.ComponentName = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *EntityPropertyReference) SetEntityId(v string) *EntityPropertyReference {
	s.EntityId = &v
	return s
}

// SetExternalIdProperty sets the ExternalIdProperty field's value.
func (s *EntityPropertyReference) SetExternalIdProperty(v map[string]*string) *EntityPropertyReference {
	s.ExternalIdProperty = v
	return s
}

// SetPropertyName sets the PropertyName field's value.
func (s *EntityPropertyReference) SetPropertyName(v string) *EntityPropertyReference {
	s.PropertyName = &v
	return s
}

// An object that contains information about an entity.
type EntitySummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the entity.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time when the entity was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The description of the entity.
	Description *string `locationName:"description" type:"string"`

	// The ID of the entity.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true"`

	// The name of the entity.
	//
	// EntityName is a required field
	EntityName *string `locationName:"entityName" min:"1" type:"string" required:"true"`

	// A Boolean value that specifies whether the entity has child entities or not.
	HasChildEntities *bool `locationName:"hasChildEntities" type:"boolean"`

	// The ID of the parent entity.
	ParentEntityId *string `locationName:"parentEntityId" min:"1" type:"string"`

	// The current status of the entity.
	//
	// Status is a required field
	Status *Status `locationName:"status" type:"structure" required:"true"`

	// The last date and time when the entity was updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitySummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EntitySummary) SetArn(v string) *EntitySummary {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *EntitySummary) SetCreationDateTime(v time.Time) *EntitySummary {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EntitySummary) SetDescription(v string) *EntitySummary {
	s.Description = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *EntitySummary) SetEntityId(v string) *EntitySummary {
	s.EntityId = &v
	return s
}

// SetEntityName sets the EntityName field's value.
func (s *EntitySummary) SetEntityName(v string) *EntitySummary {
	s.EntityName = &v
	return s
}

// SetHasChildEntities sets the HasChildEntities field's value.
func (s *EntitySummary) SetHasChildEntities(v bool) *EntitySummary {
	s.HasChildEntities = &v
	return s
}

// SetParentEntityId sets the ParentEntityId field's value.
func (s *EntitySummary) SetParentEntityId(v string) *EntitySummary {
	s.ParentEntityId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EntitySummary) SetStatus(v *Status) *EntitySummary {
	s.Status = v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *EntitySummary) SetUpdateDateTime(v time.Time) *EntitySummary {
	s.UpdateDateTime = &v
	return s
}

// The error details.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string" enum:"ErrorCode"`

	// The error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ErrorDetails) SetCode(v string) *ErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorDetails) SetMessage(v string) *ErrorDetails {
	s.Message = &v
	return s
}

type ExecuteQueryInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time. The default is 25.
	//
	// Valid Range: Minimum value of 1. Maximum value of 250.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The query statement.
	//
	// QueryStatement is a required field
	QueryStatement *string `locationName:"queryStatement" min:"1" type:"string" required:"true"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteQueryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueryStatement == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryStatement"))
	}
	if s.QueryStatement != nil && len(*s.QueryStatement) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryStatement", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ExecuteQueryInput) SetMaxResults(v int64) *ExecuteQueryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExecuteQueryInput) SetNextToken(v string) *ExecuteQueryInput {
	s.NextToken = &v
	return s
}

// SetQueryStatement sets the QueryStatement field's value.
func (s *ExecuteQueryInput) SetQueryStatement(v string) *ExecuteQueryInput {
	s.QueryStatement = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ExecuteQueryInput) SetWorkspaceId(v string) *ExecuteQueryInput {
	s.WorkspaceId = &v
	return s
}

type ExecuteQueryOutput struct {
	_ struct{} `type:"structure"`

	// A list of ColumnDescription objects.
	ColumnDescriptions []*ColumnDescription `locationName:"columnDescriptions" type:"list"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Represents a single row in the query results.
	Rows []*Row `locationName:"rows" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteQueryOutput) GoString() string {
	return s.String()
}

// SetColumnDescriptions sets the ColumnDescriptions field's value.
func (s *ExecuteQueryOutput) SetColumnDescriptions(v []*ColumnDescription) *ExecuteQueryOutput {
	s.ColumnDescriptions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExecuteQueryOutput) SetNextToken(v string) *ExecuteQueryOutput {
	s.NextToken = &v
	return s
}

// SetRows sets the Rows field's value.
func (s *ExecuteQueryOutput) SetRows(v []*Row) *ExecuteQueryOutput {
	s.Rows = v
	return s
}

// The function request body.
type FunctionRequest struct {
	_ struct{} `type:"structure"`

	// The data connector.
	ImplementedBy *DataConnector `locationName:"implementedBy" type:"structure"`

	// The required properties of the function.
	RequiredProperties []*string `locationName:"requiredProperties" type:"list"`

	// The scope of the function.
	Scope *string `locationName:"scope" type:"string" enum:"Scope"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionRequest"}
	if s.ImplementedBy != nil {
		if err := s.ImplementedBy.Validate(); err != nil {
			invalidParams.AddNested("ImplementedBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImplementedBy sets the ImplementedBy field's value.
func (s *FunctionRequest) SetImplementedBy(v *DataConnector) *FunctionRequest {
	s.ImplementedBy = v
	return s
}

// SetRequiredProperties sets the RequiredProperties field's value.
func (s *FunctionRequest) SetRequiredProperties(v []*string) *FunctionRequest {
	s.RequiredProperties = v
	return s
}

// SetScope sets the Scope field's value.
func (s *FunctionRequest) SetScope(v string) *FunctionRequest {
	s.Scope = &v
	return s
}

// The function response.
type FunctionResponse struct {
	_ struct{} `type:"structure"`

	// The data connector.
	ImplementedBy *DataConnector `locationName:"implementedBy" type:"structure"`

	// Indicates whether this function is inherited.
	IsInherited *bool `locationName:"isInherited" type:"boolean"`

	// The required properties of the function.
	RequiredProperties []*string `locationName:"requiredProperties" type:"list"`

	// The scope of the function.
	Scope *string `locationName:"scope" type:"string" enum:"Scope"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionResponse) GoString() string {
	return s.String()
}

// SetImplementedBy sets the ImplementedBy field's value.
func (s *FunctionResponse) SetImplementedBy(v *DataConnector) *FunctionResponse {
	s.ImplementedBy = v
	return s
}

// SetIsInherited sets the IsInherited field's value.
func (s *FunctionResponse) SetIsInherited(v bool) *FunctionResponse {
	s.IsInherited = &v
	return s
}

// SetRequiredProperties sets the RequiredProperties field's value.
func (s *FunctionResponse) SetRequiredProperties(v []*string) *FunctionResponse {
	s.RequiredProperties = v
	return s
}

// SetScope sets the Scope field's value.
func (s *FunctionResponse) SetScope(v string) *FunctionResponse {
	s.Scope = &v
	return s
}

type GetComponentTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the component type.
	//
	// ComponentTypeId is a required field
	ComponentTypeId *string `location:"uri" locationName:"componentTypeId" min:"1" type:"string" required:"true"`

	// The ID of the workspace that contains the component type.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComponentTypeInput"}
	if s.ComponentTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentTypeId"))
	}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *GetComponentTypeInput) SetComponentTypeId(v string) *GetComponentTypeInput {
	s.ComponentTypeId = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetComponentTypeInput) SetWorkspaceId(v string) *GetComponentTypeInput {
	s.WorkspaceId = &v
	return s
}

type GetComponentTypeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the component type.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The ID of the component type.
	//
	// ComponentTypeId is a required field
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string" required:"true"`

	// The component type name.
	ComponentTypeName *string `locationName:"componentTypeName" type:"string"`

	// The date and time when the component type was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The description of the component type.
	Description *string `locationName:"description" type:"string"`

	// The name of the parent component type that this component type extends.
	ExtendsFrom []*string `locationName:"extendsFrom" type:"list"`

	// An object that maps strings to the functions in the component type. Each
	// string in the mapping must be unique to this object.
	Functions map[string]*FunctionResponse `locationName:"functions" type:"map"`

	// A Boolean value that specifies whether the component type is abstract.
	IsAbstract *bool `locationName:"isAbstract" type:"boolean"`

	// A Boolean value that specifies whether the component type has a schema initializer
	// and that the schema initializer has run.
	IsSchemaInitialized *bool `locationName:"isSchemaInitialized" type:"boolean"`

	// A Boolean value that specifies whether an entity can have more than one component
	// of this type.
	IsSingleton *bool `locationName:"isSingleton" type:"boolean"`

	// An object that maps strings to the property definitions in the component
	// type. Each string in the mapping must be unique to this object.
	PropertyDefinitions map[string]*PropertyDefinitionResponse `locationName:"propertyDefinitions" type:"map"`

	// The maximum number of results to return at one time. The default is 25.
	//
	// Valid Range: Minimum value of 1. Maximum value of 250.
	PropertyGroups map[string]*PropertyGroupResponse `locationName:"propertyGroups" type:"map"`

	// The current status of the component type.
	Status *Status `locationName:"status" type:"structure"`

	// The syncSource of the sync job, if this entity was created by a sync job.
	SyncSource *string `locationName:"syncSource" type:"string"`

	// The date and time when the component was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`

	// The ID of the workspace that contains the component type.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentTypeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetComponentTypeOutput) SetArn(v string) *GetComponentTypeOutput {
	s.Arn = &v
	return s
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *GetComponentTypeOutput) SetComponentTypeId(v string) *GetComponentTypeOutput {
	s.ComponentTypeId = &v
	return s
}

// SetComponentTypeName sets the ComponentTypeName field's value.
func (s *GetComponentTypeOutput) SetComponentTypeName(v string) *GetComponentTypeOutput {
	s.ComponentTypeName = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *GetComponentTypeOutput) SetCreationDateTime(v time.Time) *GetComponentTypeOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetComponentTypeOutput) SetDescription(v string) *GetComponentTypeOutput {
	s.Description = &v
	return s
}

// SetExtendsFrom sets the ExtendsFrom field's value.
func (s *GetComponentTypeOutput) SetExtendsFrom(v []*string) *GetComponentTypeOutput {
	s.ExtendsFrom = v
	return s
}

// SetFunctions sets the Functions field's value.
func (s *GetComponentTypeOutput) SetFunctions(v map[string]*FunctionResponse) *GetComponentTypeOutput {
	s.Functions = v
	return s
}

// SetIsAbstract sets the IsAbstract field's value.
func (s *GetComponentTypeOutput) SetIsAbstract(v bool) *GetComponentTypeOutput {
	s.IsAbstract = &v
	return s
}

// SetIsSchemaInitialized sets the IsSchemaInitialized field's value.
func (s *GetComponentTypeOutput) SetIsSchemaInitialized(v bool) *GetComponentTypeOutput {
	s.IsSchemaInitialized = &v
	return s
}

// SetIsSingleton sets the IsSingleton field's value.
func (s *GetComponentTypeOutput) SetIsSingleton(v bool) *GetComponentTypeOutput {
	s.IsSingleton = &v
	return s
}

// SetPropertyDefinitions sets the PropertyDefinitions field's value.
func (s *GetComponentTypeOutput) SetPropertyDefinitions(v map[string]*PropertyDefinitionResponse) *GetComponentTypeOutput {
	s.PropertyDefinitions = v
	return s
}

// SetPropertyGroups sets the PropertyGroups field's value.
func (s *GetComponentTypeOutput) SetPropertyGroups(v map[string]*PropertyGroupResponse) *GetComponentTypeOutput {
	s.PropertyGroups = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetComponentTypeOutput) SetStatus(v *Status) *GetComponentTypeOutput {
	s.Status = v
	return s
}

// SetSyncSource sets the SyncSource field's value.
func (s *GetComponentTypeOutput) SetSyncSource(v string) *GetComponentTypeOutput {
	s.SyncSource = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *GetComponentTypeOutput) SetUpdateDateTime(v time.Time) *GetComponentTypeOutput {
	s.UpdateDateTime = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetComponentTypeOutput) SetWorkspaceId(v string) *GetComponentTypeOutput {
	s.WorkspaceId = &v
	return s
}

type GetEntityInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the entity.
	//
	// EntityId is a required field
	EntityId *string `location:"uri" locationName:"entityId" min:"1" type:"string" required:"true"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEntityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEntityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEntityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEntityInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *GetEntityInput) SetEntityId(v string) *GetEntityInput {
	s.EntityId = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetEntityInput) SetWorkspaceId(v string) *GetEntityInput {
	s.WorkspaceId = &v
	return s
}

type GetEntityOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the entity.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// An object that maps strings to the components in the entity. Each string
	// in the mapping must be unique to this object.
	Components map[string]*ComponentResponse `locationName:"components" type:"map"`

	// The date and time when the entity was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The description of the entity.
	Description *string `locationName:"description" type:"string"`

	// The ID of the entity.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true"`

	// The name of the entity.
	//
	// EntityName is a required field
	EntityName *string `locationName:"entityName" min:"1" type:"string" required:"true"`

	// A Boolean value that specifies whether the entity has associated child entities.
	//
	// HasChildEntities is a required field
	HasChildEntities *bool `locationName:"hasChildEntities" type:"boolean" required:"true"`

	// The ID of the parent entity for this entity.
	//
	// ParentEntityId is a required field
	ParentEntityId *string `locationName:"parentEntityId" min:"1" type:"string" required:"true"`

	// The current status of the entity.
	//
	// Status is a required field
	Status *Status `locationName:"status" type:"structure" required:"true"`

	// The syncSource of the sync job, if this entity was created by a sync job.
	SyncSource *string `locationName:"syncSource" type:"string"`

	// The date and time when the entity was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEntityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEntityOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetEntityOutput) SetArn(v string) *GetEntityOutput {
	s.Arn = &v
	return s
}

// SetComponents sets the Components field's value.
func (s *GetEntityOutput) SetComponents(v map[string]*ComponentResponse) *GetEntityOutput {
	s.Components = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *GetEntityOutput) SetCreationDateTime(v time.Time) *GetEntityOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetEntityOutput) SetDescription(v string) *GetEntityOutput {
	s.Description = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *GetEntityOutput) SetEntityId(v string) *GetEntityOutput {
	s.EntityId = &v
	return s
}

// SetEntityName sets the EntityName field's value.
func (s *GetEntityOutput) SetEntityName(v string) *GetEntityOutput {
	s.EntityName = &v
	return s
}

// SetHasChildEntities sets the HasChildEntities field's value.
func (s *GetEntityOutput) SetHasChildEntities(v bool) *GetEntityOutput {
	s.HasChildEntities = &v
	return s
}

// SetParentEntityId sets the ParentEntityId field's value.
func (s *GetEntityOutput) SetParentEntityId(v string) *GetEntityOutput {
	s.ParentEntityId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetEntityOutput) SetStatus(v *Status) *GetEntityOutput {
	s.Status = v
	return s
}

// SetSyncSource sets the SyncSource field's value.
func (s *GetEntityOutput) SetSyncSource(v string) *GetEntityOutput {
	s.SyncSource = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *GetEntityOutput) SetUpdateDateTime(v time.Time) *GetEntityOutput {
	s.UpdateDateTime = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetEntityOutput) SetWorkspaceId(v string) *GetEntityOutput {
	s.WorkspaceId = &v
	return s
}

type GetPricingPlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPricingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPricingPlanInput) GoString() string {
	return s.String()
}

type GetPricingPlanOutput struct {
	_ struct{} `type:"structure"`

	// The chosen pricing plan for the current billing cycle.
	//
	// CurrentPricingPlan is a required field
	CurrentPricingPlan *PricingPlan `locationName:"currentPricingPlan" type:"structure" required:"true"`

	// The pending pricing plan.
	PendingPricingPlan *PricingPlan `locationName:"pendingPricingPlan" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPricingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPricingPlanOutput) GoString() string {
	return s.String()
}

// SetCurrentPricingPlan sets the CurrentPricingPlan field's value.
func (s *GetPricingPlanOutput) SetCurrentPricingPlan(v *PricingPlan) *GetPricingPlanOutput {
	s.CurrentPricingPlan = v
	return s
}

// SetPendingPricingPlan sets the PendingPricingPlan field's value.
func (s *GetPricingPlanOutput) SetPendingPricingPlan(v *PricingPlan) *GetPricingPlanOutput {
	s.PendingPricingPlan = v
	return s
}

type GetPropertyValueHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The ID of the component type.
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string"`

	// The date and time of the latest property value to return.
	//
	// Deprecated: This field is deprecated and will throw an error in the future. Use endTime instead.
	EndDateTime *time.Time `locationName:"endDateTime" deprecated:"true" type:"timestamp"`

	// The ISO8601 DateTime of the latest property value to return.
	//
	// For more information about the ISO8601 DateTime format, see the data type
	// PropertyValue (https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_PropertyValue.html).
	EndTime *string `locationName:"endTime" min:"20" type:"string"`

	// The ID of the entity.
	EntityId *string `locationName:"entityId" min:"1" type:"string"`

	// An object that specifies the interpolation type and the interval over which
	// to interpolate data.
	Interpolation *InterpolationParameters `locationName:"interpolation" type:"structure"`

	// The maximum number of results to return at one time. The default is 25.
	//
	// Valid Range: Minimum value of 1. Maximum value of 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The time direction to use in the result order.
	OrderByTime *string `locationName:"orderByTime" type:"string" enum:"OrderByTime"`

	// A list of objects that filter the property value history request.
	PropertyFilters []*PropertyFilter `locationName:"propertyFilters" min:"1" type:"list"`

	// A list of properties whose value histories the request retrieves.
	//
	// SelectedProperties is a required field
	SelectedProperties []*string `locationName:"selectedProperties" min:"1" type:"list" required:"true"`

	// The date and time of the earliest property value to return.
	//
	// Deprecated: This field is deprecated and will throw an error in the future. Use startTime instead.
	StartDateTime *time.Time `locationName:"startDateTime" deprecated:"true" type:"timestamp"`

	// The ISO8601 DateTime of the earliest property value to return.
	//
	// For more information about the ISO8601 DateTime format, see the data type
	// PropertyValue (https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_PropertyValue.html).
	StartTime *string `locationName:"startTime" min:"20" type:"string"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertyValueHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertyValueHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPropertyValueHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPropertyValueHistoryInput"}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.EndTime != nil && len(*s.EndTime) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EndTime", 20))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.PropertyFilters != nil && len(s.PropertyFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyFilters", 1))
	}
	if s.SelectedProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectedProperties"))
	}
	if s.SelectedProperties != nil && len(s.SelectedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SelectedProperties", 1))
	}
	if s.StartTime != nil && len(*s.StartTime) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("StartTime", 20))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.PropertyFilters != nil {
		for i, v := range s.PropertyFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *GetPropertyValueHistoryInput) SetComponentName(v string) *GetPropertyValueHistoryInput {
	s.ComponentName = &v
	return s
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *GetPropertyValueHistoryInput) SetComponentTypeId(v string) *GetPropertyValueHistoryInput {
	s.ComponentTypeId = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *GetPropertyValueHistoryInput) SetEndDateTime(v time.Time) *GetPropertyValueHistoryInput {
	s.EndDateTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetPropertyValueHistoryInput) SetEndTime(v string) *GetPropertyValueHistoryInput {
	s.EndTime = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *GetPropertyValueHistoryInput) SetEntityId(v string) *GetPropertyValueHistoryInput {
	s.EntityId = &v
	return s
}

// SetInterpolation sets the Interpolation field's value.
func (s *GetPropertyValueHistoryInput) SetInterpolation(v *InterpolationParameters) *GetPropertyValueHistoryInput {
	s.Interpolation = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetPropertyValueHistoryInput) SetMaxResults(v int64) *GetPropertyValueHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetPropertyValueHistoryInput) SetNextToken(v string) *GetPropertyValueHistoryInput {
	s.NextToken = &v
	return s
}

// SetOrderByTime sets the OrderByTime field's value.
func (s *GetPropertyValueHistoryInput) SetOrderByTime(v string) *GetPropertyValueHistoryInput {
	s.OrderByTime = &v
	return s
}

// SetPropertyFilters sets the PropertyFilters field's value.
func (s *GetPropertyValueHistoryInput) SetPropertyFilters(v []*PropertyFilter) *GetPropertyValueHistoryInput {
	s.PropertyFilters = v
	return s
}

// SetSelectedProperties sets the SelectedProperties field's value.
func (s *GetPropertyValueHistoryInput) SetSelectedProperties(v []*string) *GetPropertyValueHistoryInput {
	s.SelectedProperties = v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *GetPropertyValueHistoryInput) SetStartDateTime(v time.Time) *GetPropertyValueHistoryInput {
	s.StartDateTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetPropertyValueHistoryInput) SetStartTime(v string) *GetPropertyValueHistoryInput {
	s.StartTime = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetPropertyValueHistoryInput) SetWorkspaceId(v string) *GetPropertyValueHistoryInput {
	s.WorkspaceId = &v
	return s
}

type GetPropertyValueHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An object that maps strings to the property definitions in the component
	// type. Each string in the mapping must be unique to this object.
	//
	// PropertyValues is a required field
	PropertyValues []*PropertyValueHistory `locationName:"propertyValues" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertyValueHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertyValueHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetPropertyValueHistoryOutput) SetNextToken(v string) *GetPropertyValueHistoryOutput {
	s.NextToken = &v
	return s
}

// SetPropertyValues sets the PropertyValues field's value.
func (s *GetPropertyValueHistoryOutput) SetPropertyValues(v []*PropertyValueHistory) *GetPropertyValueHistoryOutput {
	s.PropertyValues = v
	return s
}

type GetPropertyValueInput struct {
	_ struct{} `type:"structure"`

	// The name of the component whose property values the operation returns.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The ID of the component type whose property values the operation returns.
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string"`

	// The ID of the entity whose property values the operation returns.
	EntityId *string `locationName:"entityId" min:"1" type:"string"`

	// The maximum number of results to return at one time. The default is 25.
	//
	// Valid Range: Minimum value of 1. Maximum value of 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The property group name.
	PropertyGroupName *string `locationName:"propertyGroupName" min:"1" type:"string"`

	// The properties whose values the operation returns.
	//
	// SelectedProperties is a required field
	SelectedProperties []*string `locationName:"selectedProperties" min:"1" type:"list" required:"true"`

	// The tabular conditions.
	TabularConditions *TabularConditions `locationName:"tabularConditions" type:"structure"`

	// The ID of the workspace whose values the operation returns.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertyValueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertyValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPropertyValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPropertyValueInput"}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.PropertyGroupName != nil && len(*s.PropertyGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyGroupName", 1))
	}
	if s.SelectedProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectedProperties"))
	}
	if s.SelectedProperties != nil && len(s.SelectedProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SelectedProperties", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.TabularConditions != nil {
		if err := s.TabularConditions.Validate(); err != nil {
			invalidParams.AddNested("TabularConditions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *GetPropertyValueInput) SetComponentName(v string) *GetPropertyValueInput {
	s.ComponentName = &v
	return s
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *GetPropertyValueInput) SetComponentTypeId(v string) *GetPropertyValueInput {
	s.ComponentTypeId = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *GetPropertyValueInput) SetEntityId(v string) *GetPropertyValueInput {
	s.EntityId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetPropertyValueInput) SetMaxResults(v int64) *GetPropertyValueInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetPropertyValueInput) SetNextToken(v string) *GetPropertyValueInput {
	s.NextToken = &v
	return s
}

// SetPropertyGroupName sets the PropertyGroupName field's value.
func (s *GetPropertyValueInput) SetPropertyGroupName(v string) *GetPropertyValueInput {
	s.PropertyGroupName = &v
	return s
}

// SetSelectedProperties sets the SelectedProperties field's value.
func (s *GetPropertyValueInput) SetSelectedProperties(v []*string) *GetPropertyValueInput {
	s.SelectedProperties = v
	return s
}

// SetTabularConditions sets the TabularConditions field's value.
func (s *GetPropertyValueInput) SetTabularConditions(v *TabularConditions) *GetPropertyValueInput {
	s.TabularConditions = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetPropertyValueInput) SetWorkspaceId(v string) *GetPropertyValueInput {
	s.WorkspaceId = &v
	return s
}

type GetPropertyValueOutput struct {
	_ struct{} `type:"structure"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An object that maps strings to the properties and latest property values
	// in the response. Each string in the mapping must be unique to this object.
	PropertyValues map[string]*PropertyLatestValue `locationName:"propertyValues" type:"map"`

	// A table of property values.
	TabularPropertyValues [][]map[string]*DataValue `locationName:"tabularPropertyValues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertyValueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPropertyValueOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetPropertyValueOutput) SetNextToken(v string) *GetPropertyValueOutput {
	s.NextToken = &v
	return s
}

// SetPropertyValues sets the PropertyValues field's value.
func (s *GetPropertyValueOutput) SetPropertyValues(v map[string]*PropertyLatestValue) *GetPropertyValueOutput {
	s.PropertyValues = v
	return s
}

// SetTabularPropertyValues sets the TabularPropertyValues field's value.
func (s *GetPropertyValueOutput) SetTabularPropertyValues(v [][]map[string]*DataValue) *GetPropertyValueOutput {
	s.TabularPropertyValues = v
	return s
}

type GetSceneInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the scene.
	//
	// SceneId is a required field
	SceneId *string `location:"uri" locationName:"sceneId" min:"1" type:"string" required:"true"`

	// The ID of the workspace that contains the scene.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSceneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSceneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSceneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSceneInput"}
	if s.SceneId == nil {
		invalidParams.Add(request.NewErrParamRequired("SceneId"))
	}
	if s.SceneId != nil && len(*s.SceneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SceneId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSceneId sets the SceneId field's value.
func (s *GetSceneInput) SetSceneId(v string) *GetSceneInput {
	s.SceneId = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetSceneInput) SetWorkspaceId(v string) *GetSceneInput {
	s.WorkspaceId = &v
	return s
}

type GetSceneOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the scene.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// A list of capabilities that the scene uses to render.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// The relative path that specifies the location of the content definition file.
	//
	// ContentLocation is a required field
	ContentLocation *string `locationName:"contentLocation" type:"string" required:"true"`

	// The date and time when the scene was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The description of the scene.
	Description *string `locationName:"description" type:"string"`

	// The ID of the scene.
	//
	// SceneId is a required field
	SceneId *string `locationName:"sceneId" min:"1" type:"string" required:"true"`

	// The date and time when the scene was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`

	// The ID of the workspace that contains the scene.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSceneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSceneOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSceneOutput) SetArn(v string) *GetSceneOutput {
	s.Arn = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *GetSceneOutput) SetCapabilities(v []*string) *GetSceneOutput {
	s.Capabilities = v
	return s
}

// SetContentLocation sets the ContentLocation field's value.
func (s *GetSceneOutput) SetContentLocation(v string) *GetSceneOutput {
	s.ContentLocation = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *GetSceneOutput) SetCreationDateTime(v time.Time) *GetSceneOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSceneOutput) SetDescription(v string) *GetSceneOutput {
	s.Description = &v
	return s
}

// SetSceneId sets the SceneId field's value.
func (s *GetSceneOutput) SetSceneId(v string) *GetSceneOutput {
	s.SceneId = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *GetSceneOutput) SetUpdateDateTime(v time.Time) *GetSceneOutput {
	s.UpdateDateTime = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetSceneOutput) SetWorkspaceId(v string) *GetSceneOutput {
	s.WorkspaceId = &v
	return s
}

type GetSyncJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The sync soucre.
	//
	// Currently the only supported syncSoucre is SITEWISE .
	//
	// SyncSource is a required field
	SyncSource *string `location:"uri" locationName:"syncSource" type:"string" required:"true"`

	// The workspace Id.
	WorkspaceId *string `location:"querystring" locationName:"workspace" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSyncJobInput"}
	if s.SyncSource == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncSource"))
	}
	if s.SyncSource != nil && len(*s.SyncSource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SyncSource", 1))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSyncSource sets the SyncSource field's value.
func (s *GetSyncJobInput) SetSyncSource(v string) *GetSyncJobInput {
	s.SyncSource = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetSyncJobInput) SetWorkspaceId(v string) *GetSyncJobInput {
	s.WorkspaceId = &v
	return s
}

type GetSyncJobOutput struct {
	_ struct{} `type:"structure"`

	// The sync job ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The creation date and time.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The SyncJob response status.
	//
	// Status is a required field
	Status *SyncJobStatus `locationName:"status" type:"structure" required:"true"`

	// The sync IAM role.
	//
	// SyncRole is a required field
	SyncRole *string `locationName:"syncRole" min:"20" type:"string" required:"true"`

	// The sync soucre.
	//
	// Currently the only supported syncSoucre is SITEWISE .
	//
	// SyncSource is a required field
	SyncSource *string `locationName:"syncSource" type:"string" required:"true"`

	// The update date and time.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`

	// The ID of the workspace that contains the sync job.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSyncJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSyncJobOutput) SetArn(v string) *GetSyncJobOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *GetSyncJobOutput) SetCreationDateTime(v time.Time) *GetSyncJobOutput {
	s.CreationDateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSyncJobOutput) SetStatus(v *SyncJobStatus) *GetSyncJobOutput {
	s.Status = v
	return s
}

// SetSyncRole sets the SyncRole field's value.
func (s *GetSyncJobOutput) SetSyncRole(v string) *GetSyncJobOutput {
	s.SyncRole = &v
	return s
}

// SetSyncSource sets the SyncSource field's value.
func (s *GetSyncJobOutput) SetSyncSource(v string) *GetSyncJobOutput {
	s.SyncSource = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *GetSyncJobOutput) SetUpdateDateTime(v time.Time) *GetSyncJobOutput {
	s.UpdateDateTime = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetSyncJobOutput) SetWorkspaceId(v string) *GetSyncJobOutput {
	s.WorkspaceId = &v
	return s
}

type GetWorkspaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkspaceInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetWorkspaceInput) SetWorkspaceId(v string) *GetWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type GetWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the workspace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time when the workspace was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The description of the workspace.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the execution role associated with the workspace.
	//
	// Role is a required field
	Role *string `locationName:"role" min:"20" type:"string" required:"true"`

	// The ARN of the S3 bucket where resources associated with the workspace are
	// stored.
	//
	// S3Location is a required field
	S3Location *string `locationName:"s3Location" type:"string" required:"true"`

	// The date and time when the workspace was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkspaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetWorkspaceOutput) SetArn(v string) *GetWorkspaceOutput {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *GetWorkspaceOutput) SetCreationDateTime(v time.Time) *GetWorkspaceOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetWorkspaceOutput) SetDescription(v string) *GetWorkspaceOutput {
	s.Description = &v
	return s
}

// SetRole sets the Role field's value.
func (s *GetWorkspaceOutput) SetRole(v string) *GetWorkspaceOutput {
	s.Role = &v
	return s
}

// SetS3Location sets the S3Location field's value.
func (s *GetWorkspaceOutput) SetS3Location(v string) *GetWorkspaceOutput {
	s.S3Location = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *GetWorkspaceOutput) SetUpdateDateTime(v time.Time) *GetWorkspaceOutput {
	s.UpdateDateTime = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *GetWorkspaceOutput) SetWorkspaceId(v string) *GetWorkspaceOutput {
	s.WorkspaceId = &v
	return s
}

// An unexpected error has occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that specifies how to interpolate data in a list.
type InterpolationParameters struct {
	_ struct{} `type:"structure"`

	// The interpolation type.
	InterpolationType *string `locationName:"interpolationType" type:"string" enum:"InterpolationType"`

	// The interpolation time interval in seconds.
	IntervalInSeconds *int64 `locationName:"intervalInSeconds" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterpolationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterpolationParameters) GoString() string {
	return s.String()
}

// SetInterpolationType sets the InterpolationType field's value.
func (s *InterpolationParameters) SetInterpolationType(v string) *InterpolationParameters {
	s.InterpolationType = &v
	return s
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *InterpolationParameters) SetIntervalInSeconds(v int64) *InterpolationParameters {
	s.IntervalInSeconds = &v
	return s
}

// The Lambda function.
type LambdaFunction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunction"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *LambdaFunction) SetArn(v string) *LambdaFunction {
	s.Arn = &v
	return s
}

// An object that filters items in a list of component types.
//
// Only one object is accepted as a valid input.
type ListComponentTypesFilter struct {
	_ struct{} `type:"structure"`

	// The component type that the component types in the list extend.
	ExtendsFrom *string `locationName:"extendsFrom" min:"1" type:"string"`

	// A Boolean value that specifies whether the component types in the list are
	// abstract.
	IsAbstract *bool `locationName:"isAbstract" type:"boolean"`

	// The namespace to which the component types in the list belong.
	Namespace *string `locationName:"namespace" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentTypesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentTypesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentTypesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentTypesFilter"}
	if s.ExtendsFrom != nil && len(*s.ExtendsFrom) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtendsFrom", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtendsFrom sets the ExtendsFrom field's value.
func (s *ListComponentTypesFilter) SetExtendsFrom(v string) *ListComponentTypesFilter {
	s.ExtendsFrom = &v
	return s
}

// SetIsAbstract sets the IsAbstract field's value.
func (s *ListComponentTypesFilter) SetIsAbstract(v bool) *ListComponentTypesFilter {
	s.IsAbstract = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListComponentTypesFilter) SetNamespace(v string) *ListComponentTypesFilter {
	s.Namespace = &v
	return s
}

type ListComponentTypesInput struct {
	_ struct{} `type:"structure"`

	// A list of objects that filter the request.
	Filters []*ListComponentTypesFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return at one time. The default is 25.
	//
	// Valid Range: Minimum value of 1. Maximum value of 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentTypesInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListComponentTypesInput) SetFilters(v []*ListComponentTypesFilter) *ListComponentTypesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentTypesInput) SetMaxResults(v int64) *ListComponentTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentTypesInput) SetNextToken(v string) *ListComponentTypesInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListComponentTypesInput) SetWorkspaceId(v string) *ListComponentTypesInput {
	s.WorkspaceId = &v
	return s
}

type ListComponentTypesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain information about the component types.
	//
	// ComponentTypeSummaries is a required field
	ComponentTypeSummaries []*ComponentTypeSummary `locationName:"componentTypeSummaries" type:"list" required:"true"`

	// Specifies the maximum number of results to display.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentTypesOutput) GoString() string {
	return s.String()
}

// SetComponentTypeSummaries sets the ComponentTypeSummaries field's value.
func (s *ListComponentTypesOutput) SetComponentTypeSummaries(v []*ComponentTypeSummary) *ListComponentTypesOutput {
	s.ComponentTypeSummaries = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentTypesOutput) SetMaxResults(v int64) *ListComponentTypesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentTypesOutput) SetNextToken(v string) *ListComponentTypesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListComponentTypesOutput) SetWorkspaceId(v string) *ListComponentTypesOutput {
	s.WorkspaceId = &v
	return s
}

// An object that filters items in a list of entities.
type ListEntitiesFilter struct {
	_ struct{} `type:"structure"`

	// The ID of the component type in the entities in the list.
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string"`

	// The external-Id property of a component. The external-Id property is the
	// primary key of an external storage system.
	ExternalId *string `locationName:"externalId" min:"1" type:"string"`

	// The parent of the entities in the list.
	ParentEntityId *string `locationName:"parentEntityId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesFilter"}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.ExternalId != nil && len(*s.ExternalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalId", 1))
	}
	if s.ParentEntityId != nil && len(*s.ParentEntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentEntityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *ListEntitiesFilter) SetComponentTypeId(v string) *ListEntitiesFilter {
	s.ComponentTypeId = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ListEntitiesFilter) SetExternalId(v string) *ListEntitiesFilter {
	s.ExternalId = &v
	return s
}

// SetParentEntityId sets the ParentEntityId field's value.
func (s *ListEntitiesFilter) SetParentEntityId(v string) *ListEntitiesFilter {
	s.ParentEntityId = &v
	return s
}

type ListEntitiesInput struct {
	_ struct{} `type:"structure"`

	// A list of objects that filter the request.
	//
	// Only one object is accepted as a valid input.
	Filters []*ListEntitiesFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return at one time. The default is 25.
	//
	// Valid Range: Minimum value of 1. Maximum value of 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListEntitiesInput) SetFilters(v []*ListEntitiesFilter) *ListEntitiesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitiesInput) SetMaxResults(v int64) *ListEntitiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesInput) SetNextToken(v string) *ListEntitiesInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListEntitiesInput) SetWorkspaceId(v string) *ListEntitiesInput {
	s.WorkspaceId = &v
	return s
}

type ListEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain information about the entities.
	EntitySummaries []*EntitySummary `locationName:"entitySummaries" type:"list"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntitySummaries sets the EntitySummaries field's value.
func (s *ListEntitiesOutput) SetEntitySummaries(v []*EntitySummary) *ListEntitiesOutput {
	s.EntitySummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesOutput) SetNextToken(v string) *ListEntitiesOutput {
	s.NextToken = &v
	return s
}

type ListScenesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of results to display.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the workspace that contains the scenes.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScenesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScenesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScenesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListScenesInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListScenesInput) SetMaxResults(v int64) *ListScenesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListScenesInput) SetNextToken(v string) *ListScenesInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListScenesInput) SetWorkspaceId(v string) *ListScenesInput {
	s.WorkspaceId = &v
	return s
}

type ListScenesOutput struct {
	_ struct{} `type:"structure"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of objects that contain information about the scenes.
	SceneSummaries []*SceneSummary `locationName:"sceneSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScenesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScenesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListScenesOutput) SetNextToken(v string) *ListScenesOutput {
	s.NextToken = &v
	return s
}

// SetSceneSummaries sets the SceneSummaries field's value.
func (s *ListScenesOutput) SetSceneSummaries(v []*SceneSummary) *ListScenesOutput {
	s.SceneSummaries = v
	return s
}

type ListSyncJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time. The default is 50.
	//
	// Valid Range: Minimum value of 0. Maximum value of 200.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the workspace that contains the sync job.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSyncJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSyncJobsInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSyncJobsInput) SetMaxResults(v int64) *ListSyncJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSyncJobsInput) SetNextToken(v string) *ListSyncJobsInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListSyncJobsInput) SetWorkspaceId(v string) *ListSyncJobsInput {
	s.WorkspaceId = &v
	return s
}

type ListSyncJobsOutput struct {
	_ struct{} `type:"structure"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The listed SyncJob summaries.
	SyncJobSummaries []*SyncJobSummary `locationName:"syncJobSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSyncJobsOutput) SetNextToken(v string) *ListSyncJobsOutput {
	s.NextToken = &v
	return s
}

// SetSyncJobSummaries sets the SyncJobSummaries field's value.
func (s *ListSyncJobsOutput) SetSyncJobSummaries(v []*SyncJobSummary) *ListSyncJobsOutput {
	s.SyncJobSummaries = v
	return s
}

type ListSyncResourcesInput struct {
	_ struct{} `type:"structure"`

	// A list of objects that filter the request.
	Filters []*SyncResourceFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return at one time. The default is 50.
	//
	// Valid Range: Minimum value of 0. Maximum value of 200.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The sync soucre.
	//
	// Currently the only supported syncSoucre is SITEWISE .
	//
	// SyncSource is a required field
	SyncSource *string `location:"uri" locationName:"syncSource" type:"string" required:"true"`

	// The ID of the workspace that contains the sync job.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSyncResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSyncResourcesInput"}
	if s.SyncSource == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncSource"))
	}
	if s.SyncSource != nil && len(*s.SyncSource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SyncSource", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListSyncResourcesInput) SetFilters(v []*SyncResourceFilter) *ListSyncResourcesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSyncResourcesInput) SetMaxResults(v int64) *ListSyncResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSyncResourcesInput) SetNextToken(v string) *ListSyncResourcesInput {
	s.NextToken = &v
	return s
}

// SetSyncSource sets the SyncSource field's value.
func (s *ListSyncResourcesInput) SetSyncSource(v string) *ListSyncResourcesInput {
	s.SyncSource = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ListSyncResourcesInput) SetWorkspaceId(v string) *ListSyncResourcesInput {
	s.WorkspaceId = &v
	return s
}

type ListSyncResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The sync resources.
	SyncResources []*SyncResourceSummary `locationName:"syncResources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSyncResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSyncResourcesOutput) SetNextToken(v string) *ListSyncResourcesOutput {
	s.NextToken = &v
	return s
}

// SetSyncResources sets the SyncResources field's value.
func (s *ListSyncResourcesOutput) SetSyncResources(v []*SyncResourceSummary) *ListSyncResourcesOutput {
	s.SyncResources = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time. The default is 25.
	//
	// Valid Range: Minimum value of 1. Maximum value of 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Metadata that you can use to manage a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time. The default is 25.
	//
	// Valid Range: Minimum value of 1. Maximum value of 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkspacesInput) SetMaxResults(v int64) *ListWorkspacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkspacesInput) SetNextToken(v string) *ListWorkspacesInput {
	s.NextToken = &v
	return s
}

type ListWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// The string that specifies the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of objects that contain information about the workspaces.
	WorkspaceSummaries []*WorkspaceSummary `locationName:"workspaceSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkspacesOutput) SetNextToken(v string) *ListWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaceSummaries sets the WorkspaceSummaries field's value.
func (s *ListWorkspacesOutput) SetWorkspaceSummaries(v []*WorkspaceSummary) *ListWorkspacesOutput {
	s.WorkspaceSummaries = v
	return s
}

// Filter criteria that orders the return output. It can be sorted in ascending
// or descending order.
type OrderBy struct {
	_ struct{} `type:"structure"`

	// The set order that filters results.
	Order *string `locationName:"order" type:"string" enum:"Order"`

	// The property name.
	//
	// PropertyName is a required field
	PropertyName *string `locationName:"propertyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrderBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrderBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrderBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrderBy"}
	if s.PropertyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyName"))
	}
	if s.PropertyName != nil && len(*s.PropertyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrder sets the Order field's value.
func (s *OrderBy) SetOrder(v string) *OrderBy {
	s.Order = &v
	return s
}

// SetPropertyName sets the PropertyName field's value.
func (s *OrderBy) SetPropertyName(v string) *OrderBy {
	s.PropertyName = &v
	return s
}

// The parent entity update request.
type ParentEntityUpdateRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the parent entity.
	ParentEntityId *string `locationName:"parentEntityId" min:"1" type:"string"`

	// The type of the update.
	//
	// UpdateType is a required field
	UpdateType *string `locationName:"updateType" type:"string" required:"true" enum:"ParentEntityUpdateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParentEntityUpdateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParentEntityUpdateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParentEntityUpdateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParentEntityUpdateRequest"}
	if s.ParentEntityId != nil && len(*s.ParentEntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentEntityId", 1))
	}
	if s.UpdateType == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParentEntityId sets the ParentEntityId field's value.
func (s *ParentEntityUpdateRequest) SetParentEntityId(v string) *ParentEntityUpdateRequest {
	s.ParentEntityId = &v
	return s
}

// SetUpdateType sets the UpdateType field's value.
func (s *ParentEntityUpdateRequest) SetUpdateType(v string) *ParentEntityUpdateRequest {
	s.UpdateType = &v
	return s
}

// The pricing plan.
type PricingPlan struct {
	_ struct{} `type:"structure"`

	// The billable entity count.
	BillableEntityCount *int64 `locationName:"billableEntityCount" type:"long"`

	// The pricing plan's bundle information.
	BundleInformation *BundleInformation `locationName:"bundleInformation" type:"structure"`

	// The effective date and time of the pricing plan.
	//
	// EffectiveDateTime is a required field
	EffectiveDateTime *time.Time `locationName:"effectiveDateTime" type:"timestamp" required:"true"`

	// The pricing mode.
	//
	// PricingMode is a required field
	PricingMode *string `locationName:"pricingMode" type:"string" required:"true" enum:"PricingMode"`

	// The set date and time for updating a pricing plan.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`

	// The update reason, for changing a pricing plan.
	//
	// UpdateReason is a required field
	UpdateReason *string `locationName:"updateReason" type:"string" required:"true" enum:"UpdateReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PricingPlan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PricingPlan) GoString() string {
	return s.String()
}

// SetBillableEntityCount sets the BillableEntityCount field's value.
func (s *PricingPlan) SetBillableEntityCount(v int64) *PricingPlan {
	s.BillableEntityCount = &v
	return s
}

// SetBundleInformation sets the BundleInformation field's value.
func (s *PricingPlan) SetBundleInformation(v *BundleInformation) *PricingPlan {
	s.BundleInformation = v
	return s
}

// SetEffectiveDateTime sets the EffectiveDateTime field's value.
func (s *PricingPlan) SetEffectiveDateTime(v time.Time) *PricingPlan {
	s.EffectiveDateTime = &v
	return s
}

// SetPricingMode sets the PricingMode field's value.
func (s *PricingPlan) SetPricingMode(v string) *PricingPlan {
	s.PricingMode = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *PricingPlan) SetUpdateDateTime(v time.Time) *PricingPlan {
	s.UpdateDateTime = &v
	return s
}

// SetUpdateReason sets the UpdateReason field's value.
func (s *PricingPlan) SetUpdateReason(v string) *PricingPlan {
	s.UpdateReason = &v
	return s
}

// An object that sets information about a property.
type PropertyDefinitionRequest struct {
	_ struct{} `type:"structure"`

	// A mapping that specifies configuration information about the property. Use
	// this field to specify information that you read from and write to an external
	// source.
	Configuration map[string]*string `locationName:"configuration" type:"map"`

	// An object that contains information about the data type.
	DataType *DataType `locationName:"dataType" type:"structure"`

	// An object that contains the default value.
	DefaultValue *DataValue `locationName:"defaultValue" type:"structure"`

	// A friendly name for the property.
	DisplayName *string `locationName:"displayName" type:"string"`

	// A Boolean value that specifies whether the property ID comes from an external
	// data store.
	IsExternalId *bool `locationName:"isExternalId" type:"boolean"`

	// A Boolean value that specifies whether the property is required.
	IsRequiredInEntity *bool `locationName:"isRequiredInEntity" type:"boolean"`

	// A Boolean value that specifies whether the property is stored externally.
	IsStoredExternally *bool `locationName:"isStoredExternally" type:"boolean"`

	// A Boolean value that specifies whether the property consists of time series
	// data.
	IsTimeSeries *bool `locationName:"isTimeSeries" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyDefinitionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyDefinitionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyDefinitionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyDefinitionRequest"}
	if s.DataType != nil {
		if err := s.DataType.Validate(); err != nil {
			invalidParams.AddNested("DataType", err.(request.ErrInvalidParams))
		}
	}
	if s.DefaultValue != nil {
		if err := s.DefaultValue.Validate(); err != nil {
			invalidParams.AddNested("DefaultValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *PropertyDefinitionRequest) SetConfiguration(v map[string]*string) *PropertyDefinitionRequest {
	s.Configuration = v
	return s
}

// SetDataType sets the DataType field's value.
func (s *PropertyDefinitionRequest) SetDataType(v *DataType) *PropertyDefinitionRequest {
	s.DataType = v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *PropertyDefinitionRequest) SetDefaultValue(v *DataValue) *PropertyDefinitionRequest {
	s.DefaultValue = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *PropertyDefinitionRequest) SetDisplayName(v string) *PropertyDefinitionRequest {
	s.DisplayName = &v
	return s
}

// SetIsExternalId sets the IsExternalId field's value.
func (s *PropertyDefinitionRequest) SetIsExternalId(v bool) *PropertyDefinitionRequest {
	s.IsExternalId = &v
	return s
}

// SetIsRequiredInEntity sets the IsRequiredInEntity field's value.
func (s *PropertyDefinitionRequest) SetIsRequiredInEntity(v bool) *PropertyDefinitionRequest {
	s.IsRequiredInEntity = &v
	return s
}

// SetIsStoredExternally sets the IsStoredExternally field's value.
func (s *PropertyDefinitionRequest) SetIsStoredExternally(v bool) *PropertyDefinitionRequest {
	s.IsStoredExternally = &v
	return s
}

// SetIsTimeSeries sets the IsTimeSeries field's value.
func (s *PropertyDefinitionRequest) SetIsTimeSeries(v bool) *PropertyDefinitionRequest {
	s.IsTimeSeries = &v
	return s
}

// An object that contains response data from a property definition request.
type PropertyDefinitionResponse struct {
	_ struct{} `type:"structure"`

	// A mapping that specifies configuration information about the property.
	Configuration map[string]*string `locationName:"configuration" type:"map"`

	// An object that contains information about the data type.
	//
	// DataType is a required field
	DataType *DataType `locationName:"dataType" type:"structure" required:"true"`

	// An object that contains the default value.
	DefaultValue *DataValue `locationName:"defaultValue" type:"structure"`

	// A friendly name for the property.
	DisplayName *string `locationName:"displayName" type:"string"`

	// A Boolean value that specifies whether the property ID comes from an external
	// data store.
	//
	// IsExternalId is a required field
	IsExternalId *bool `locationName:"isExternalId" type:"boolean" required:"true"`

	// A Boolean value that specifies whether the property definition can be updated.
	//
	// IsFinal is a required field
	IsFinal *bool `locationName:"isFinal" type:"boolean" required:"true"`

	// A Boolean value that specifies whether the property definition is imported
	// from an external data store.
	//
	// IsImported is a required field
	IsImported *bool `locationName:"isImported" type:"boolean" required:"true"`

	// A Boolean value that specifies whether the property definition is inherited
	// from a parent entity.
	//
	// IsInherited is a required field
	IsInherited *bool `locationName:"isInherited" type:"boolean" required:"true"`

	// A Boolean value that specifies whether the property is required in an entity.
	//
	// IsRequiredInEntity is a required field
	IsRequiredInEntity *bool `locationName:"isRequiredInEntity" type:"boolean" required:"true"`

	// A Boolean value that specifies whether the property is stored externally.
	//
	// IsStoredExternally is a required field
	IsStoredExternally *bool `locationName:"isStoredExternally" type:"boolean" required:"true"`

	// A Boolean value that specifies whether the property consists of time series
	// data.
	//
	// IsTimeSeries is a required field
	IsTimeSeries *bool `locationName:"isTimeSeries" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyDefinitionResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyDefinitionResponse) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *PropertyDefinitionResponse) SetConfiguration(v map[string]*string) *PropertyDefinitionResponse {
	s.Configuration = v
	return s
}

// SetDataType sets the DataType field's value.
func (s *PropertyDefinitionResponse) SetDataType(v *DataType) *PropertyDefinitionResponse {
	s.DataType = v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *PropertyDefinitionResponse) SetDefaultValue(v *DataValue) *PropertyDefinitionResponse {
	s.DefaultValue = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *PropertyDefinitionResponse) SetDisplayName(v string) *PropertyDefinitionResponse {
	s.DisplayName = &v
	return s
}

// SetIsExternalId sets the IsExternalId field's value.
func (s *PropertyDefinitionResponse) SetIsExternalId(v bool) *PropertyDefinitionResponse {
	s.IsExternalId = &v
	return s
}

// SetIsFinal sets the IsFinal field's value.
func (s *PropertyDefinitionResponse) SetIsFinal(v bool) *PropertyDefinitionResponse {
	s.IsFinal = &v
	return s
}

// SetIsImported sets the IsImported field's value.
func (s *PropertyDefinitionResponse) SetIsImported(v bool) *PropertyDefinitionResponse {
	s.IsImported = &v
	return s
}

// SetIsInherited sets the IsInherited field's value.
func (s *PropertyDefinitionResponse) SetIsInherited(v bool) *PropertyDefinitionResponse {
	s.IsInherited = &v
	return s
}

// SetIsRequiredInEntity sets the IsRequiredInEntity field's value.
func (s *PropertyDefinitionResponse) SetIsRequiredInEntity(v bool) *PropertyDefinitionResponse {
	s.IsRequiredInEntity = &v
	return s
}

// SetIsStoredExternally sets the IsStoredExternally field's value.
func (s *PropertyDefinitionResponse) SetIsStoredExternally(v bool) *PropertyDefinitionResponse {
	s.IsStoredExternally = &v
	return s
}

// SetIsTimeSeries sets the IsTimeSeries field's value.
func (s *PropertyDefinitionResponse) SetIsTimeSeries(v bool) *PropertyDefinitionResponse {
	s.IsTimeSeries = &v
	return s
}

// An object that filters items returned by a property request.
type PropertyFilter struct {
	_ struct{} `type:"structure"`

	// The operator associated with this property filter.
	Operator *string `locationName:"operator" min:"1" type:"string"`

	// The property name associated with this property filter.
	PropertyName *string `locationName:"propertyName" min:"1" type:"string"`

	// The value associated with this property filter.
	Value *DataValue `locationName:"value" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyFilter"}
	if s.Operator != nil && len(*s.Operator) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Operator", 1))
	}
	if s.PropertyName != nil && len(*s.PropertyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyName", 1))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperator sets the Operator field's value.
func (s *PropertyFilter) SetOperator(v string) *PropertyFilter {
	s.Operator = &v
	return s
}

// SetPropertyName sets the PropertyName field's value.
func (s *PropertyFilter) SetPropertyName(v string) *PropertyFilter {
	s.PropertyName = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PropertyFilter) SetValue(v *DataValue) *PropertyFilter {
	s.Value = v
	return s
}

type PropertyGroupRequest struct {
	_ struct{} `type:"structure"`

	// The group type.
	GroupType *string `locationName:"groupType" type:"string" enum:"GroupType"`

	// The names of properties.
	PropertyNames []*string `locationName:"propertyNames" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyGroupRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyGroupRequest) GoString() string {
	return s.String()
}

// SetGroupType sets the GroupType field's value.
func (s *PropertyGroupRequest) SetGroupType(v string) *PropertyGroupRequest {
	s.GroupType = &v
	return s
}

// SetPropertyNames sets the PropertyNames field's value.
func (s *PropertyGroupRequest) SetPropertyNames(v []*string) *PropertyGroupRequest {
	s.PropertyNames = v
	return s
}

// The property group response
type PropertyGroupResponse struct {
	_ struct{} `type:"structure"`

	// The group types.
	//
	// GroupType is a required field
	GroupType *string `locationName:"groupType" type:"string" required:"true" enum:"GroupType"`

	// A Boolean value that specifies whether the property group is inherited from
	// a parent entity
	//
	// IsInherited is a required field
	IsInherited *bool `locationName:"isInherited" type:"boolean" required:"true"`

	// The names of properties.
	//
	// PropertyNames is a required field
	PropertyNames []*string `locationName:"propertyNames" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyGroupResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyGroupResponse) GoString() string {
	return s.String()
}

// SetGroupType sets the GroupType field's value.
func (s *PropertyGroupResponse) SetGroupType(v string) *PropertyGroupResponse {
	s.GroupType = &v
	return s
}

// SetIsInherited sets the IsInherited field's value.
func (s *PropertyGroupResponse) SetIsInherited(v bool) *PropertyGroupResponse {
	s.IsInherited = &v
	return s
}

// SetPropertyNames sets the PropertyNames field's value.
func (s *PropertyGroupResponse) SetPropertyNames(v []*string) *PropertyGroupResponse {
	s.PropertyNames = v
	return s
}

// The latest value of the property.
type PropertyLatestValue struct {
	_ struct{} `type:"structure"`

	// An object that specifies information about a property.>
	//
	// PropertyReference is a required field
	PropertyReference *EntityPropertyReference `locationName:"propertyReference" type:"structure" required:"true"`

	// The value of the property.
	PropertyValue *DataValue `locationName:"propertyValue" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyLatestValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyLatestValue) GoString() string {
	return s.String()
}

// SetPropertyReference sets the PropertyReference field's value.
func (s *PropertyLatestValue) SetPropertyReference(v *EntityPropertyReference) *PropertyLatestValue {
	s.PropertyReference = v
	return s
}

// SetPropertyValue sets the PropertyValue field's value.
func (s *PropertyLatestValue) SetPropertyValue(v *DataValue) *PropertyLatestValue {
	s.PropertyValue = v
	return s
}

// An object that sets information about a property.
type PropertyRequest struct {
	_ struct{} `type:"structure"`

	// An object that specifies information about a property.
	Definition *PropertyDefinitionRequest `locationName:"definition" type:"structure"`

	// The update type of the update property request.
	UpdateType *string `locationName:"updateType" type:"string" enum:"PropertyUpdateType"`

	// The value of the property.
	Value *DataValue `locationName:"value" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyRequest"}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *PropertyRequest) SetDefinition(v *PropertyDefinitionRequest) *PropertyRequest {
	s.Definition = v
	return s
}

// SetUpdateType sets the UpdateType field's value.
func (s *PropertyRequest) SetUpdateType(v string) *PropertyRequest {
	s.UpdateType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PropertyRequest) SetValue(v *DataValue) *PropertyRequest {
	s.Value = v
	return s
}

// An object that contains information about a property response.
type PropertyResponse struct {
	_ struct{} `type:"structure"`

	// An object that specifies information about a property.
	Definition *PropertyDefinitionResponse `locationName:"definition" type:"structure"`

	// The value of the property.
	Value *DataValue `locationName:"value" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyResponse) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *PropertyResponse) SetDefinition(v *PropertyDefinitionResponse) *PropertyResponse {
	s.Definition = v
	return s
}

// SetValue sets the Value field's value.
func (s *PropertyResponse) SetValue(v *DataValue) *PropertyResponse {
	s.Value = v
	return s
}

// An object that contains information about a value for a time series property.
type PropertyValue struct {
	_ struct{} `type:"structure"`

	// ISO8601 DateTime of a value for a time series property.
	//
	// The time for when the property value was recorded in ISO 8601 format: YYYY-MM-DDThh:mm:ss[.SSSSSSSSS][Z/±HH:mm].
	//
	//    * [YYYY]: year
	//
	//    * [MM]: month
	//
	//    * [DD]: day
	//
	//    * [hh]: hour
	//
	//    * [mm]: minute
	//
	//    * [ss]: seconds
	//
	//    * [.SSSSSSSSS]: additional precision, where precedence is maintained.
	//    For example: [.573123] is equal to 573123000 nanoseconds.
	//
	//    * Z: default timezone UTC
	//
	//    * ± HH:mm: time zone offset in Hours and Minutes.
	//
	// Required sub-fields: YYYY-MM-DDThh:mm:ss and [Z/±HH:mm]
	Time *string `locationName:"time" min:"20" type:"string"`

	// The timestamp of a value for a time series property.
	//
	// Deprecated: This field is deprecated and will throw an error in the future. Use time instead.
	Timestamp *time.Time `locationName:"timestamp" deprecated:"true" type:"timestamp"`

	// An object that specifies a value for a time series property.
	//
	// Value is a required field
	Value *DataValue `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyValue"}
	if s.Time != nil && len(*s.Time) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Time", 20))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTime sets the Time field's value.
func (s *PropertyValue) SetTime(v string) *PropertyValue {
	s.Time = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *PropertyValue) SetTimestamp(v time.Time) *PropertyValue {
	s.Timestamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PropertyValue) SetValue(v *DataValue) *PropertyValue {
	s.Value = v
	return s
}

// An object that specifies information about time series property values. This
// object is used and consumed by the BatchPutPropertyValues (https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_BatchPutPropertyValues.html)
// action.
type PropertyValueEntry struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the entity that has the property.
	//
	// EntityPropertyReference is a required field
	EntityPropertyReference *EntityPropertyReference `locationName:"entityPropertyReference" type:"structure" required:"true"`

	// A list of objects that specify time series property values.
	PropertyValues []*PropertyValue `locationName:"propertyValues" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyValueEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyValueEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyValueEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyValueEntry"}
	if s.EntityPropertyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityPropertyReference"))
	}
	if s.PropertyValues != nil && len(s.PropertyValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyValues", 1))
	}
	if s.EntityPropertyReference != nil {
		if err := s.EntityPropertyReference.Validate(); err != nil {
			invalidParams.AddNested("EntityPropertyReference", err.(request.ErrInvalidParams))
		}
	}
	if s.PropertyValues != nil {
		for i, v := range s.PropertyValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityPropertyReference sets the EntityPropertyReference field's value.
func (s *PropertyValueEntry) SetEntityPropertyReference(v *EntityPropertyReference) *PropertyValueEntry {
	s.EntityPropertyReference = v
	return s
}

// SetPropertyValues sets the PropertyValues field's value.
func (s *PropertyValueEntry) SetPropertyValues(v []*PropertyValue) *PropertyValueEntry {
	s.PropertyValues = v
	return s
}

// The history of values for a time series property.
type PropertyValueHistory struct {
	_ struct{} `type:"structure"`

	// An object that uniquely identifies an entity property.
	//
	// EntityPropertyReference is a required field
	EntityPropertyReference *EntityPropertyReference `locationName:"entityPropertyReference" type:"structure" required:"true"`

	// A list of objects that contain information about the values in the history
	// of a time series property.
	Values []*PropertyValue `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyValueHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyValueHistory) GoString() string {
	return s.String()
}

// SetEntityPropertyReference sets the EntityPropertyReference field's value.
func (s *PropertyValueHistory) SetEntityPropertyReference(v *EntityPropertyReference) *PropertyValueHistory {
	s.EntityPropertyReference = v
	return s
}

// SetValues sets the Values field's value.
func (s *PropertyValueHistory) SetValues(v []*PropertyValue) *PropertyValueHistory {
	s.Values = v
	return s
}

// The query timeout exception.
type QueryTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryTimeoutException) GoString() string {
	return s.String()
}

func newErrorQueryTimeoutException(v protocol.ResponseMetadata) error {
	return &QueryTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *QueryTimeoutException) Code() string {
	return "QueryTimeoutException"
}

// Message returns the exception's message.
func (s *QueryTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QueryTimeoutException) OrigErr() error {
	return nil
}

func (s *QueryTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QueryTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QueryTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that specifies a relationship with another component type.
type Relationship struct {
	_ struct{} `type:"structure"`

	// The type of the relationship.
	RelationshipType *string `locationName:"relationshipType" min:"1" type:"string"`

	// The ID of the target component type associated with this relationship.
	TargetComponentTypeId *string `locationName:"targetComponentTypeId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Relationship) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Relationship) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Relationship) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Relationship"}
	if s.RelationshipType != nil && len(*s.RelationshipType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelationshipType", 1))
	}
	if s.TargetComponentTypeId != nil && len(*s.TargetComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetComponentTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationshipType sets the RelationshipType field's value.
func (s *Relationship) SetRelationshipType(v string) *Relationship {
	s.RelationshipType = &v
	return s
}

// SetTargetComponentTypeId sets the TargetComponentTypeId field's value.
func (s *Relationship) SetTargetComponentTypeId(v string) *Relationship {
	s.TargetComponentTypeId = &v
	return s
}

// A value that associates a component and an entity.
type RelationshipValue struct {
	_ struct{} `type:"structure"`

	// The name of the target component associated with the relationship value.
	TargetComponentName *string `locationName:"targetComponentName" min:"1" type:"string"`

	// The ID of the target entity associated with this relationship value.
	TargetEntityId *string `locationName:"targetEntityId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelationshipValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelationshipValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelationshipValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelationshipValue"}
	if s.TargetComponentName != nil && len(*s.TargetComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetComponentName", 1))
	}
	if s.TargetEntityId != nil && len(*s.TargetEntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetEntityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetComponentName sets the TargetComponentName field's value.
func (s *RelationshipValue) SetTargetComponentName(v string) *RelationshipValue {
	s.TargetComponentName = &v
	return s
}

// SetTargetEntityId sets the TargetEntityId field's value.
func (s *RelationshipValue) SetTargetEntityId(v string) *RelationshipValue {
	s.TargetEntityId = &v
	return s
}

// The resource wasn't found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a single row in the query results.
type Row struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Row) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Row) GoString() string {
	return s.String()
}

// An object that contains information about a scene.
type SceneSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the scene.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The relative path that specifies the location of the content definition file.
	//
	// ContentLocation is a required field
	ContentLocation *string `locationName:"contentLocation" type:"string" required:"true"`

	// The date and time when the scene was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The scene description.
	Description *string `locationName:"description" type:"string"`

	// The ID of the scene.
	//
	// SceneId is a required field
	SceneId *string `locationName:"sceneId" min:"1" type:"string" required:"true"`

	// The date and time when the scene was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SceneSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SceneSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SceneSummary) SetArn(v string) *SceneSummary {
	s.Arn = &v
	return s
}

// SetContentLocation sets the ContentLocation field's value.
func (s *SceneSummary) SetContentLocation(v string) *SceneSummary {
	s.ContentLocation = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SceneSummary) SetCreationDateTime(v time.Time) *SceneSummary {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SceneSummary) SetDescription(v string) *SceneSummary {
	s.Description = &v
	return s
}

// SetSceneId sets the SceneId field's value.
func (s *SceneSummary) SetSceneId(v string) *SceneSummary {
	s.SceneId = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *SceneSummary) SetUpdateDateTime(v time.Time) *SceneSummary {
	s.UpdateDateTime = &v
	return s
}

// The service quota was exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the status of an entity, component, component type,
// or workspace.
type Status struct {
	_ struct{} `type:"structure"`

	// The error message.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The current state of the entity, component, component type, or workspace.
	State *string `locationName:"state" type:"string" enum:"State"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Status) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Status) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *Status) SetError(v *ErrorDetails) *Status {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *Status) SetState(v string) *Status {
	s.State = &v
	return s
}

// The SyncJob status.
type SyncJobStatus struct {
	_ struct{} `type:"structure"`

	// The SyncJob error.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The SyncJob status state.
	State *string `locationName:"state" type:"string" enum:"SyncJobState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncJobStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncJobStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *SyncJobStatus) SetError(v *ErrorDetails) *SyncJobStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *SyncJobStatus) SetState(v string) *SyncJobStatus {
	s.State = &v
	return s
}

// The SyncJob summary.
type SyncJobSummary struct {
	_ struct{} `type:"structure"`

	// The SyncJob summary ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// The creation date and time.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The SyncJob summaries status.
	Status *SyncJobStatus `locationName:"status" type:"structure"`

	// The sync source.
	SyncSource *string `locationName:"syncSource" type:"string"`

	// The update date and time.
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp"`

	// The ID of the workspace that contains the sync job.
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncJobSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SyncJobSummary) SetArn(v string) *SyncJobSummary {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SyncJobSummary) SetCreationDateTime(v time.Time) *SyncJobSummary {
	s.CreationDateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SyncJobSummary) SetStatus(v *SyncJobStatus) *SyncJobSummary {
	s.Status = v
	return s
}

// SetSyncSource sets the SyncSource field's value.
func (s *SyncJobSummary) SetSyncSource(v string) *SyncJobSummary {
	s.SyncSource = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *SyncJobSummary) SetUpdateDateTime(v time.Time) *SyncJobSummary {
	s.UpdateDateTime = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *SyncJobSummary) SetWorkspaceId(v string) *SyncJobSummary {
	s.WorkspaceId = &v
	return s
}

// The sync resource filter.
type SyncResourceFilter struct {
	_ struct{} `type:"structure"`

	// The external Id.
	ExternalId *string `locationName:"externalId" min:"1" type:"string"`

	// The sync resource filter resource Id.
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The sync resource filter resoucre type
	ResourceType *string `locationName:"resourceType" type:"string" enum:"SyncResourceType"`

	// The sync resource filter's state.
	State *string `locationName:"state" type:"string" enum:"SyncResourceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SyncResourceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SyncResourceFilter"}
	if s.ExternalId != nil && len(*s.ExternalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalId", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalId sets the ExternalId field's value.
func (s *SyncResourceFilter) SetExternalId(v string) *SyncResourceFilter {
	s.ExternalId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *SyncResourceFilter) SetResourceId(v string) *SyncResourceFilter {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *SyncResourceFilter) SetResourceType(v string) *SyncResourceFilter {
	s.ResourceType = &v
	return s
}

// SetState sets the State field's value.
func (s *SyncResourceFilter) SetState(v string) *SyncResourceFilter {
	s.State = &v
	return s
}

// The sync resource status.
type SyncResourceStatus struct {
	_ struct{} `type:"structure"`

	// The status error.
	Error *ErrorDetails `locationName:"error" type:"structure"`

	// The sync resource status state.
	State *string `locationName:"state" type:"string" enum:"SyncResourceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceStatus) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *SyncResourceStatus) SetError(v *ErrorDetails) *SyncResourceStatus {
	s.Error = v
	return s
}

// SetState sets the State field's value.
func (s *SyncResourceStatus) SetState(v string) *SyncResourceStatus {
	s.State = &v
	return s
}

// The sync resource summary.
type SyncResourceSummary struct {
	_ struct{} `type:"structure"`

	// The external Id.
	ExternalId *string `locationName:"externalId" min:"1" type:"string"`

	// The resource Id.
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"SyncResourceType"`

	// The sync resource summary status.
	Status *SyncResourceStatus `locationName:"status" type:"structure"`

	// The update date and time.
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceSummary) GoString() string {
	return s.String()
}

// SetExternalId sets the ExternalId field's value.
func (s *SyncResourceSummary) SetExternalId(v string) *SyncResourceSummary {
	s.ExternalId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *SyncResourceSummary) SetResourceId(v string) *SyncResourceSummary {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *SyncResourceSummary) SetResourceType(v string) *SyncResourceSummary {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SyncResourceSummary) SetStatus(v *SyncResourceStatus) *SyncResourceSummary {
	s.Status = v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *SyncResourceSummary) SetUpdateDateTime(v time.Time) *SyncResourceSummary {
	s.UpdateDateTime = &v
	return s
}

// The tabular conditions.
type TabularConditions struct {
	_ struct{} `type:"structure"`

	// Filter criteria that orders the output. It can be sorted in ascending or
	// descending order.
	OrderBy []*OrderBy `locationName:"orderBy" min:"1" type:"list"`

	// You can filter the request using various logical operators and a key-value
	// format. For example:
	//
	// {"key": "serverType", "value": "webServer"}
	PropertyFilters []*PropertyFilter `locationName:"propertyFilters" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TabularConditions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TabularConditions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TabularConditions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TabularConditions"}
	if s.OrderBy != nil && len(s.OrderBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrderBy", 1))
	}
	if s.PropertyFilters != nil && len(s.PropertyFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyFilters", 1))
	}
	if s.OrderBy != nil {
		for i, v := range s.OrderBy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrderBy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PropertyFilters != nil {
		for i, v := range s.PropertyFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrderBy sets the OrderBy field's value.
func (s *TabularConditions) SetOrderBy(v []*OrderBy) *TabularConditions {
	s.OrderBy = v
	return s
}

// SetPropertyFilters sets the PropertyFilters field's value.
func (s *TabularConditions) SetPropertyFilters(v []*PropertyFilter) *TabularConditions {
	s.PropertyFilters = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"20" type:"string" required:"true"`

	// Metadata to add to this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The rate exceeds the limit.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The number of tags exceeds the limit.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"querystring" locationName:"resourceARN" min:"20" type:"string" required:"true"`

	// A list of tag key names to remove from the resource. You don't specify the
	// value. Both the key and its associated value are removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateComponentTypeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the component type.
	//
	// ComponentTypeId is a required field
	ComponentTypeId *string `location:"uri" locationName:"componentTypeId" min:"1" type:"string" required:"true"`

	// The component type name.
	ComponentTypeName *string `locationName:"componentTypeName" type:"string"`

	// The description of the component type.
	Description *string `locationName:"description" type:"string"`

	// Specifies the component type that this component type extends.
	ExtendsFrom []*string `locationName:"extendsFrom" type:"list"`

	// An object that maps strings to the functions in the component type. Each
	// string in the mapping must be unique to this object.
	Functions map[string]*FunctionRequest `locationName:"functions" type:"map"`

	// A Boolean value that specifies whether an entity can have more than one component
	// of this type.
	IsSingleton *bool `locationName:"isSingleton" type:"boolean"`

	// An object that maps strings to the property definitions in the component
	// type. Each string in the mapping must be unique to this object.
	PropertyDefinitions map[string]*PropertyDefinitionRequest `locationName:"propertyDefinitions" type:"map"`

	// The property groups
	PropertyGroups map[string]*PropertyGroupRequest `locationName:"propertyGroups" type:"map"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComponentTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComponentTypeInput"}
	if s.ComponentTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentTypeId"))
	}
	if s.ComponentTypeId != nil && len(*s.ComponentTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentTypeId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.Functions != nil {
		for i, v := range s.Functions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Functions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PropertyDefinitions != nil {
		for i, v := range s.PropertyDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *UpdateComponentTypeInput) SetComponentTypeId(v string) *UpdateComponentTypeInput {
	s.ComponentTypeId = &v
	return s
}

// SetComponentTypeName sets the ComponentTypeName field's value.
func (s *UpdateComponentTypeInput) SetComponentTypeName(v string) *UpdateComponentTypeInput {
	s.ComponentTypeName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateComponentTypeInput) SetDescription(v string) *UpdateComponentTypeInput {
	s.Description = &v
	return s
}

// SetExtendsFrom sets the ExtendsFrom field's value.
func (s *UpdateComponentTypeInput) SetExtendsFrom(v []*string) *UpdateComponentTypeInput {
	s.ExtendsFrom = v
	return s
}

// SetFunctions sets the Functions field's value.
func (s *UpdateComponentTypeInput) SetFunctions(v map[string]*FunctionRequest) *UpdateComponentTypeInput {
	s.Functions = v
	return s
}

// SetIsSingleton sets the IsSingleton field's value.
func (s *UpdateComponentTypeInput) SetIsSingleton(v bool) *UpdateComponentTypeInput {
	s.IsSingleton = &v
	return s
}

// SetPropertyDefinitions sets the PropertyDefinitions field's value.
func (s *UpdateComponentTypeInput) SetPropertyDefinitions(v map[string]*PropertyDefinitionRequest) *UpdateComponentTypeInput {
	s.PropertyDefinitions = v
	return s
}

// SetPropertyGroups sets the PropertyGroups field's value.
func (s *UpdateComponentTypeInput) SetPropertyGroups(v map[string]*PropertyGroupRequest) *UpdateComponentTypeInput {
	s.PropertyGroups = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateComponentTypeInput) SetWorkspaceId(v string) *UpdateComponentTypeInput {
	s.WorkspaceId = &v
	return s
}

type UpdateComponentTypeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the component type.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The ID of the component type.
	//
	// ComponentTypeId is a required field
	ComponentTypeId *string `locationName:"componentTypeId" min:"1" type:"string" required:"true"`

	// The current state of the component type.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"State"`

	// The ID of the workspace that contains the component type.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentTypeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateComponentTypeOutput) SetArn(v string) *UpdateComponentTypeOutput {
	s.Arn = &v
	return s
}

// SetComponentTypeId sets the ComponentTypeId field's value.
func (s *UpdateComponentTypeOutput) SetComponentTypeId(v string) *UpdateComponentTypeOutput {
	s.ComponentTypeId = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateComponentTypeOutput) SetState(v string) *UpdateComponentTypeOutput {
	s.State = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateComponentTypeOutput) SetWorkspaceId(v string) *UpdateComponentTypeOutput {
	s.WorkspaceId = &v
	return s
}

type UpdateEntityInput struct {
	_ struct{} `type:"structure"`

	// An object that maps strings to the component updates in the request. Each
	// string in the mapping must be unique to this object.
	ComponentUpdates map[string]*ComponentUpdateRequest `locationName:"componentUpdates" type:"map"`

	// The description of the entity.
	Description *string `locationName:"description" type:"string"`

	// The ID of the entity.
	//
	// EntityId is a required field
	EntityId *string `location:"uri" locationName:"entityId" min:"1" type:"string" required:"true"`

	// The name of the entity.
	EntityName *string `locationName:"entityName" min:"1" type:"string"`

	// An object that describes the update request for a parent entity.
	ParentEntityUpdate *ParentEntityUpdateRequest `locationName:"parentEntityUpdate" type:"structure"`

	// The ID of the workspace that contains the entity.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEntityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEntityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEntityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEntityInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.EntityName != nil && len(*s.EntityName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityName", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}
	if s.ComponentUpdates != nil {
		for i, v := range s.ComponentUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComponentUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ParentEntityUpdate != nil {
		if err := s.ParentEntityUpdate.Validate(); err != nil {
			invalidParams.AddNested("ParentEntityUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentUpdates sets the ComponentUpdates field's value.
func (s *UpdateEntityInput) SetComponentUpdates(v map[string]*ComponentUpdateRequest) *UpdateEntityInput {
	s.ComponentUpdates = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateEntityInput) SetDescription(v string) *UpdateEntityInput {
	s.Description = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *UpdateEntityInput) SetEntityId(v string) *UpdateEntityInput {
	s.EntityId = &v
	return s
}

// SetEntityName sets the EntityName field's value.
func (s *UpdateEntityInput) SetEntityName(v string) *UpdateEntityInput {
	s.EntityName = &v
	return s
}

// SetParentEntityUpdate sets the ParentEntityUpdate field's value.
func (s *UpdateEntityInput) SetParentEntityUpdate(v *ParentEntityUpdateRequest) *UpdateEntityInput {
	s.ParentEntityUpdate = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateEntityInput) SetWorkspaceId(v string) *UpdateEntityInput {
	s.WorkspaceId = &v
	return s
}

type UpdateEntityOutput struct {
	_ struct{} `type:"structure"`

	// The current state of the entity update.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"State"`

	// The date and time when the entity was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEntityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEntityOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *UpdateEntityOutput) SetState(v string) *UpdateEntityOutput {
	s.State = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *UpdateEntityOutput) SetUpdateDateTime(v time.Time) *UpdateEntityOutput {
	s.UpdateDateTime = &v
	return s
}

type UpdatePricingPlanInput struct {
	_ struct{} `type:"structure"`

	// The bundle names.
	BundleNames []*string `locationName:"bundleNames" min:"1" type:"list"`

	// The pricing mode.
	//
	// PricingMode is a required field
	PricingMode *string `locationName:"pricingMode" type:"string" required:"true" enum:"PricingMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePricingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePricingPlanInput"}
	if s.BundleNames != nil && len(s.BundleNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleNames", 1))
	}
	if s.PricingMode == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleNames sets the BundleNames field's value.
func (s *UpdatePricingPlanInput) SetBundleNames(v []*string) *UpdatePricingPlanInput {
	s.BundleNames = v
	return s
}

// SetPricingMode sets the PricingMode field's value.
func (s *UpdatePricingPlanInput) SetPricingMode(v string) *UpdatePricingPlanInput {
	s.PricingMode = &v
	return s
}

type UpdatePricingPlanOutput struct {
	_ struct{} `type:"structure"`

	// Update the current pricing plan.
	//
	// CurrentPricingPlan is a required field
	CurrentPricingPlan *PricingPlan `locationName:"currentPricingPlan" type:"structure" required:"true"`

	// Update the pending pricing plan.
	PendingPricingPlan *PricingPlan `locationName:"pendingPricingPlan" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingPlanOutput) GoString() string {
	return s.String()
}

// SetCurrentPricingPlan sets the CurrentPricingPlan field's value.
func (s *UpdatePricingPlanOutput) SetCurrentPricingPlan(v *PricingPlan) *UpdatePricingPlanOutput {
	s.CurrentPricingPlan = v
	return s
}

// SetPendingPricingPlan sets the PendingPricingPlan field's value.
func (s *UpdatePricingPlanOutput) SetPendingPricingPlan(v *PricingPlan) *UpdatePricingPlanOutput {
	s.PendingPricingPlan = v
	return s
}

type UpdateSceneInput struct {
	_ struct{} `type:"structure"`

	// A list of capabilities that the scene uses to render.
	Capabilities []*string `locationName:"capabilities" type:"list"`

	// The relative path that specifies the location of the content definition file.
	ContentLocation *string `locationName:"contentLocation" type:"string"`

	// The description of this scene.
	Description *string `locationName:"description" type:"string"`

	// The ID of the scene.
	//
	// SceneId is a required field
	SceneId *string `location:"uri" locationName:"sceneId" min:"1" type:"string" required:"true"`

	// The ID of the workspace that contains the scene.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSceneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSceneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSceneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSceneInput"}
	if s.SceneId == nil {
		invalidParams.Add(request.NewErrParamRequired("SceneId"))
	}
	if s.SceneId != nil && len(*s.SceneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SceneId", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *UpdateSceneInput) SetCapabilities(v []*string) *UpdateSceneInput {
	s.Capabilities = v
	return s
}

// SetContentLocation sets the ContentLocation field's value.
func (s *UpdateSceneInput) SetContentLocation(v string) *UpdateSceneInput {
	s.ContentLocation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateSceneInput) SetDescription(v string) *UpdateSceneInput {
	s.Description = &v
	return s
}

// SetSceneId sets the SceneId field's value.
func (s *UpdateSceneInput) SetSceneId(v string) *UpdateSceneInput {
	s.SceneId = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateSceneInput) SetWorkspaceId(v string) *UpdateSceneInput {
	s.WorkspaceId = &v
	return s
}

type UpdateSceneOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when the scene was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSceneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSceneOutput) GoString() string {
	return s.String()
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *UpdateSceneOutput) SetUpdateDateTime(v time.Time) *UpdateSceneOutput {
	s.UpdateDateTime = &v
	return s
}

type UpdateWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// The description of the workspace.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the execution role associated with the workspace.
	Role *string `locationName:"role" min:"20" type:"string"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspaceInput"}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkspaceInput) SetDescription(v string) *UpdateWorkspaceInput {
	s.Description = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateWorkspaceInput) SetRole(v string) *UpdateWorkspaceInput {
	s.Role = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateWorkspaceInput) SetWorkspaceId(v string) *UpdateWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type UpdateWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The date and time of the current update.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceOutput) GoString() string {
	return s.String()
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *UpdateWorkspaceOutput) SetUpdateDateTime(v time.Time) *UpdateWorkspaceOutput {
	s.UpdateDateTime = &v
	return s
}

// Failed
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains information about a workspace.
type WorkspaceSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the workspace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"20" type:"string" required:"true"`

	// The date and time when the workspace was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp" required:"true"`

	// The description of the workspace.
	Description *string `locationName:"description" type:"string"`

	// The date and time when the workspace was last updated.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `locationName:"updateDateTime" type:"timestamp" required:"true"`

	// The ID of the workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *WorkspaceSummary) SetArn(v string) *WorkspaceSummary {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *WorkspaceSummary) SetCreationDateTime(v time.Time) *WorkspaceSummary {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceSummary) SetDescription(v string) *WorkspaceSummary {
	s.Description = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *WorkspaceSummary) SetUpdateDateTime(v time.Time) *WorkspaceSummary {
	s.UpdateDateTime = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceSummary) SetWorkspaceId(v string) *WorkspaceSummary {
	s.WorkspaceId = &v
	return s
}

const (
	// ColumnTypeNode is a ColumnType enum value
	ColumnTypeNode = "NODE"

	// ColumnTypeEdge is a ColumnType enum value
	ColumnTypeEdge = "EDGE"

	// ColumnTypeValue is a ColumnType enum value
	ColumnTypeValue = "VALUE"
)

// ColumnType_Values returns all elements of the ColumnType enum
func ColumnType_Values() []string {
	return []string{
		ColumnTypeNode,
		ColumnTypeEdge,
		ColumnTypeValue,
	}
}

const (
	// ComponentUpdateTypeCreate is a ComponentUpdateType enum value
	ComponentUpdateTypeCreate = "CREATE"

	// ComponentUpdateTypeUpdate is a ComponentUpdateType enum value
	ComponentUpdateTypeUpdate = "UPDATE"

	// ComponentUpdateTypeDelete is a ComponentUpdateType enum value
	ComponentUpdateTypeDelete = "DELETE"
)

// ComponentUpdateType_Values returns all elements of the ComponentUpdateType enum
func ComponentUpdateType_Values() []string {
	return []string{
		ComponentUpdateTypeCreate,
		ComponentUpdateTypeUpdate,
		ComponentUpdateTypeDelete,
	}
}

const (
	// ErrorCodeValidationError is a ErrorCode enum value
	ErrorCodeValidationError = "VALIDATION_ERROR"

	// ErrorCodeInternalFailure is a ErrorCode enum value
	ErrorCodeInternalFailure = "INTERNAL_FAILURE"

	// ErrorCodeSyncInitializingError is a ErrorCode enum value
	ErrorCodeSyncInitializingError = "SYNC_INITIALIZING_ERROR"

	// ErrorCodeSyncCreatingError is a ErrorCode enum value
	ErrorCodeSyncCreatingError = "SYNC_CREATING_ERROR"

	// ErrorCodeSyncProcessingError is a ErrorCode enum value
	ErrorCodeSyncProcessingError = "SYNC_PROCESSING_ERROR"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeValidationError,
		ErrorCodeInternalFailure,
		ErrorCodeSyncInitializingError,
		ErrorCodeSyncCreatingError,
		ErrorCodeSyncProcessingError,
	}
}

const (
	// GroupTypeTabular is a GroupType enum value
	GroupTypeTabular = "TABULAR"
)

// GroupType_Values returns all elements of the GroupType enum
func GroupType_Values() []string {
	return []string{
		GroupTypeTabular,
	}
}

const (
	// InterpolationTypeLinear is a InterpolationType enum value
	InterpolationTypeLinear = "LINEAR"
)

// InterpolationType_Values returns all elements of the InterpolationType enum
func InterpolationType_Values() []string {
	return []string{
		InterpolationTypeLinear,
	}
}

const (
	// OrderAscending is a Order enum value
	OrderAscending = "ASCENDING"

	// OrderDescending is a Order enum value
	OrderDescending = "DESCENDING"
)

// Order_Values returns all elements of the Order enum
func Order_Values() []string {
	return []string{
		OrderAscending,
		OrderDescending,
	}
}

const (
	// OrderByTimeAscending is a OrderByTime enum value
	OrderByTimeAscending = "ASCENDING"

	// OrderByTimeDescending is a OrderByTime enum value
	OrderByTimeDescending = "DESCENDING"
)

// OrderByTime_Values returns all elements of the OrderByTime enum
func OrderByTime_Values() []string {
	return []string{
		OrderByTimeAscending,
		OrderByTimeDescending,
	}
}

const (
	// ParentEntityUpdateTypeUpdate is a ParentEntityUpdateType enum value
	ParentEntityUpdateTypeUpdate = "UPDATE"

	// ParentEntityUpdateTypeDelete is a ParentEntityUpdateType enum value
	ParentEntityUpdateTypeDelete = "DELETE"
)

// ParentEntityUpdateType_Values returns all elements of the ParentEntityUpdateType enum
func ParentEntityUpdateType_Values() []string {
	return []string{
		ParentEntityUpdateTypeUpdate,
		ParentEntityUpdateTypeDelete,
	}
}

const (
	// PricingModeBasic is a PricingMode enum value
	PricingModeBasic = "BASIC"

	// PricingModeStandard is a PricingMode enum value
	PricingModeStandard = "STANDARD"

	// PricingModeTieredBundle is a PricingMode enum value
	PricingModeTieredBundle = "TIERED_BUNDLE"
)

// PricingMode_Values returns all elements of the PricingMode enum
func PricingMode_Values() []string {
	return []string{
		PricingModeBasic,
		PricingModeStandard,
		PricingModeTieredBundle,
	}
}

const (
	// PricingTierTier1 is a PricingTier enum value
	PricingTierTier1 = "TIER_1"

	// PricingTierTier2 is a PricingTier enum value
	PricingTierTier2 = "TIER_2"

	// PricingTierTier3 is a PricingTier enum value
	PricingTierTier3 = "TIER_3"

	// PricingTierTier4 is a PricingTier enum value
	PricingTierTier4 = "TIER_4"
)

// PricingTier_Values returns all elements of the PricingTier enum
func PricingTier_Values() []string {
	return []string{
		PricingTierTier1,
		PricingTierTier2,
		PricingTierTier3,
		PricingTierTier4,
	}
}

const (
	// PropertyGroupUpdateTypeUpdate is a PropertyGroupUpdateType enum value
	PropertyGroupUpdateTypeUpdate = "UPDATE"

	// PropertyGroupUpdateTypeDelete is a PropertyGroupUpdateType enum value
	PropertyGroupUpdateTypeDelete = "DELETE"

	// PropertyGroupUpdateTypeCreate is a PropertyGroupUpdateType enum value
	PropertyGroupUpdateTypeCreate = "CREATE"
)

// PropertyGroupUpdateType_Values returns all elements of the PropertyGroupUpdateType enum
func PropertyGroupUpdateType_Values() []string {
	return []string{
		PropertyGroupUpdateTypeUpdate,
		PropertyGroupUpdateTypeDelete,
		PropertyGroupUpdateTypeCreate,
	}
}

const (
	// PropertyUpdateTypeUpdate is a PropertyUpdateType enum value
	PropertyUpdateTypeUpdate = "UPDATE"

	// PropertyUpdateTypeDelete is a PropertyUpdateType enum value
	PropertyUpdateTypeDelete = "DELETE"

	// PropertyUpdateTypeCreate is a PropertyUpdateType enum value
	PropertyUpdateTypeCreate = "CREATE"
)

// PropertyUpdateType_Values returns all elements of the PropertyUpdateType enum
func PropertyUpdateType_Values() []string {
	return []string{
		PropertyUpdateTypeUpdate,
		PropertyUpdateTypeDelete,
		PropertyUpdateTypeCreate,
	}
}

const (
	// ScopeEntity is a Scope enum value
	ScopeEntity = "ENTITY"

	// ScopeWorkspace is a Scope enum value
	ScopeWorkspace = "WORKSPACE"
)

// Scope_Values returns all elements of the Scope enum
func Scope_Values() []string {
	return []string{
		ScopeEntity,
		ScopeWorkspace,
	}
}

const (
	// StateCreating is a State enum value
	StateCreating = "CREATING"

	// StateUpdating is a State enum value
	StateUpdating = "UPDATING"

	// StateDeleting is a State enum value
	StateDeleting = "DELETING"

	// StateActive is a State enum value
	StateActive = "ACTIVE"

	// StateError is a State enum value
	StateError = "ERROR"
)

// State_Values returns all elements of the State enum
func State_Values() []string {
	return []string{
		StateCreating,
		StateUpdating,
		StateDeleting,
		StateActive,
		StateError,
	}
}

const (
	// SyncJobStateCreating is a SyncJobState enum value
	SyncJobStateCreating = "CREATING"

	// SyncJobStateInitializing is a SyncJobState enum value
	SyncJobStateInitializing = "INITIALIZING"

	// SyncJobStateActive is a SyncJobState enum value
	SyncJobStateActive = "ACTIVE"

	// SyncJobStateDeleting is a SyncJobState enum value
	SyncJobStateDeleting = "DELETING"

	// SyncJobStateError is a SyncJobState enum value
	SyncJobStateError = "ERROR"
)

// SyncJobState_Values returns all elements of the SyncJobState enum
func SyncJobState_Values() []string {
	return []string{
		SyncJobStateCreating,
		SyncJobStateInitializing,
		SyncJobStateActive,
		SyncJobStateDeleting,
		SyncJobStateError,
	}
}

const (
	// SyncResourceStateInitializing is a SyncResourceState enum value
	SyncResourceStateInitializing = "INITIALIZING"

	// SyncResourceStateProcessing is a SyncResourceState enum value
	SyncResourceStateProcessing = "PROCESSING"

	// SyncResourceStateDeleted is a SyncResourceState enum value
	SyncResourceStateDeleted = "DELETED"

	// SyncResourceStateInSync is a SyncResourceState enum value
	SyncResourceStateInSync = "IN_SYNC"

	// SyncResourceStateError is a SyncResourceState enum value
	SyncResourceStateError = "ERROR"
)

// SyncResourceState_Values returns all elements of the SyncResourceState enum
func SyncResourceState_Values() []string {
	return []string{
		SyncResourceStateInitializing,
		SyncResourceStateProcessing,
		SyncResourceStateDeleted,
		SyncResourceStateInSync,
		SyncResourceStateError,
	}
}

const (
	// SyncResourceTypeEntity is a SyncResourceType enum value
	SyncResourceTypeEntity = "ENTITY"

	// SyncResourceTypeComponentType is a SyncResourceType enum value
	SyncResourceTypeComponentType = "COMPONENT_TYPE"
)

// SyncResourceType_Values returns all elements of the SyncResourceType enum
func SyncResourceType_Values() []string {
	return []string{
		SyncResourceTypeEntity,
		SyncResourceTypeComponentType,
	}
}

const (
	// TypeRelationship is a Type enum value
	TypeRelationship = "RELATIONSHIP"

	// TypeString is a Type enum value
	TypeString = "STRING"

	// TypeLong is a Type enum value
	TypeLong = "LONG"

	// TypeBoolean is a Type enum value
	TypeBoolean = "BOOLEAN"

	// TypeInteger is a Type enum value
	TypeInteger = "INTEGER"

	// TypeDouble is a Type enum value
	TypeDouble = "DOUBLE"

	// TypeList is a Type enum value
	TypeList = "LIST"

	// TypeMap is a Type enum value
	TypeMap = "MAP"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeRelationship,
		TypeString,
		TypeLong,
		TypeBoolean,
		TypeInteger,
		TypeDouble,
		TypeList,
		TypeMap,
	}
}

const (
	// UpdateReasonDefault is a UpdateReason enum value
	UpdateReasonDefault = "DEFAULT"

	// UpdateReasonPricingTierUpdate is a UpdateReason enum value
	UpdateReasonPricingTierUpdate = "PRICING_TIER_UPDATE"

	// UpdateReasonEntityCountUpdate is a UpdateReason enum value
	UpdateReasonEntityCountUpdate = "ENTITY_COUNT_UPDATE"

	// UpdateReasonPricingModeUpdate is a UpdateReason enum value
	UpdateReasonPricingModeUpdate = "PRICING_MODE_UPDATE"

	// UpdateReasonOverwritten is a UpdateReason enum value
	UpdateReasonOverwritten = "OVERWRITTEN"
)

// UpdateReason_Values returns all elements of the UpdateReason enum
func UpdateReason_Values() []string {
	return []string{
		UpdateReasonDefault,
		UpdateReasonPricingTierUpdate,
		UpdateReasonEntityCountUpdate,
		UpdateReasonPricingModeUpdate,
		UpdateReasonOverwritten,
	}
}
