// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecrpublic

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchCheckLayerAvailability = "BatchCheckLayerAvailability"

// BatchCheckLayerAvailabilityRequest generates a "aws/request.Request" representing the
// client's request for the BatchCheckLayerAvailability operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCheckLayerAvailability for more information on using the BatchCheckLayerAvailability
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCheckLayerAvailabilityRequest method.
//	req, resp := client.BatchCheckLayerAvailabilityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchCheckLayerAvailability
func (c *ECRPublic) BatchCheckLayerAvailabilityRequest(input *BatchCheckLayerAvailabilityInput) (req *request.Request, output *BatchCheckLayerAvailabilityOutput) {
	op := &request.Operation{
		Name:       opBatchCheckLayerAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCheckLayerAvailabilityInput{}
	}

	output = &BatchCheckLayerAvailabilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCheckLayerAvailability API operation for Amazon Elastic Container Registry Public.
//
// Checks the availability of one or more image layers that are within a repository
// in a public registry. When an image is pushed to a repository, each image
// layer is checked to verify if it has been uploaded before. If it has been
// uploaded, then the image layer is skipped.
//
// This operation is used by the Amazon ECR proxy and is not generally used
// by customers for pulling and pushing images. In most cases, you should use
// the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation BatchCheckLayerAvailability for usage and error information.
//
// Returned Error Types:
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - RegistryNotFoundException
//     The registry doesn't exist.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchCheckLayerAvailability
func (c *ECRPublic) BatchCheckLayerAvailability(input *BatchCheckLayerAvailabilityInput) (*BatchCheckLayerAvailabilityOutput, error) {
	req, out := c.BatchCheckLayerAvailabilityRequest(input)
	return out, req.Send()
}

// BatchCheckLayerAvailabilityWithContext is the same as BatchCheckLayerAvailability with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCheckLayerAvailability for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) BatchCheckLayerAvailabilityWithContext(ctx aws.Context, input *BatchCheckLayerAvailabilityInput, opts ...request.Option) (*BatchCheckLayerAvailabilityOutput, error) {
	req, out := c.BatchCheckLayerAvailabilityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteImage = "BatchDeleteImage"

// BatchDeleteImageRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteImage for more information on using the BatchDeleteImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteImageRequest method.
//	req, resp := client.BatchDeleteImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchDeleteImage
func (c *ECRPublic) BatchDeleteImageRequest(input *BatchDeleteImageInput) (req *request.Request, output *BatchDeleteImageOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteImageInput{}
	}

	output = &BatchDeleteImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteImage API operation for Amazon Elastic Container Registry Public.
//
// Deletes a list of specified images that are within a repository in a public
// registry. Images are specified with either an imageTag or imageDigest.
//
// You can remove a tag from an image by specifying the image's tag in your
// request. When you remove the last tag from an image, the image is deleted
// from your repository.
//
// You can completely delete an image (and all of its tags) by specifying the
// digest of the image in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation BatchDeleteImage for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/BatchDeleteImage
func (c *ECRPublic) BatchDeleteImage(input *BatchDeleteImageInput) (*BatchDeleteImageOutput, error) {
	req, out := c.BatchDeleteImageRequest(input)
	return out, req.Send()
}

// BatchDeleteImageWithContext is the same as BatchDeleteImage with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) BatchDeleteImageWithContext(ctx aws.Context, input *BatchDeleteImageInput, opts ...request.Option) (*BatchDeleteImageOutput, error) {
	req, out := c.BatchDeleteImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteLayerUpload = "CompleteLayerUpload"

// CompleteLayerUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteLayerUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteLayerUpload for more information on using the CompleteLayerUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CompleteLayerUploadRequest method.
//	req, resp := client.CompleteLayerUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CompleteLayerUpload
func (c *ECRPublic) CompleteLayerUploadRequest(input *CompleteLayerUploadInput) (req *request.Request, output *CompleteLayerUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteLayerUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteLayerUploadInput{}
	}

	output = &CompleteLayerUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CompleteLayerUpload API operation for Amazon Elastic Container Registry Public.
//
// Informs Amazon ECR that the image layer upload is complete for a specified
// public registry, repository name, and upload ID. You can optionally provide
// a sha256 digest of the image layer for data validation purposes.
//
// When an image is pushed, the CompleteLayerUpload API is called once for each
// new image layer to verify that the upload is complete.
//
// This operation is used by the Amazon ECR proxy and is not generally used
// by customers for pulling and pushing images. In most cases, you should use
// the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation CompleteLayerUpload for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UploadNotFoundException
//     The upload can't be found, or the specified upload ID isn't valid for this
//     repository.
//
//   - InvalidLayerException
//     The layer digest calculation performed by Amazon ECR when the image layer
//     doesn't match the digest specified.
//
//   - LayerPartTooSmallException
//     Layer parts must be at least 5 MiB in size.
//
//   - LayerAlreadyExistsException
//     The image layer already exists in the associated repository.
//
//   - EmptyUploadException
//     The specified layer upload doesn't contain any layer parts.
//
//   - RegistryNotFoundException
//     The registry doesn't exist.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CompleteLayerUpload
func (c *ECRPublic) CompleteLayerUpload(input *CompleteLayerUploadInput) (*CompleteLayerUploadOutput, error) {
	req, out := c.CompleteLayerUploadRequest(input)
	return out, req.Send()
}

// CompleteLayerUploadWithContext is the same as CompleteLayerUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteLayerUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) CompleteLayerUploadWithContext(ctx aws.Context, input *CompleteLayerUploadInput, opts ...request.Option) (*CompleteLayerUploadOutput, error) {
	req, out := c.CompleteLayerUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRepository for more information on using the CreateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRepositoryRequest method.
//	req, resp := client.CreateRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CreateRepository
func (c *ECRPublic) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	output = &CreateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRepository API operation for Amazon Elastic Container Registry Public.
//
// Creates a repository in a public registry. For more information, see Amazon
// ECR repositories (https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html)
// in the Amazon Elastic Container Registry User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation CreateRepository for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidTagParameterException
//     An invalid parameter has been specified. Tag keys can have a maximum character
//     length of 128 characters, and tag values can have a maximum length of 256
//     characters.
//
//   - TooManyTagsException
//     The list of tags on the repository is over the limit. The maximum number
//     of tags that can be applied to a repository is 50.
//
//   - RepositoryAlreadyExistsException
//     The specified repository already exists in the specified registry.
//
//   - LimitExceededException
//     The operation didn't succeed because it would have exceeded a service limit
//     for your account. For more information, see Amazon ECR Service Quotas (https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html)
//     in the Amazon Elastic Container Registry User Guide.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/CreateRepository
func (c *ECRPublic) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	return out, req.Send()
}

// CreateRepositoryWithContext is the same as CreateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) CreateRepositoryWithContext(ctx aws.Context, input *CreateRepositoryInput, opts ...request.Option) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRepository = "DeleteRepository"

// DeleteRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRepository for more information on using the DeleteRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRepositoryRequest method.
//	req, resp := client.DeleteRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepository
func (c *ECRPublic) DeleteRepositoryRequest(input *DeleteRepositoryInput) (req *request.Request, output *DeleteRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryInput{}
	}

	output = &DeleteRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepository API operation for Amazon Elastic Container Registry Public.
//
// Deletes a repository in a public registry. If the repository contains images,
// you must either manually delete all images in the repository or use the force
// option. This option deletes all images on your behalf before deleting the
// repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation DeleteRepository for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - RepositoryNotEmptyException
//     The specified repository contains images. To delete a repository that contains
//     images, you must force the deletion with the force parameter.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepository
func (c *ECRPublic) DeleteRepository(input *DeleteRepositoryInput) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	return out, req.Send()
}

// DeleteRepositoryWithContext is the same as DeleteRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DeleteRepositoryWithContext(ctx aws.Context, input *DeleteRepositoryInput, opts ...request.Option) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRepositoryPolicy = "DeleteRepositoryPolicy"

// DeleteRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepositoryPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRepositoryPolicy for more information on using the DeleteRepositoryPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRepositoryPolicyRequest method.
//	req, resp := client.DeleteRepositoryPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepositoryPolicy
func (c *ECRPublic) DeleteRepositoryPolicyRequest(input *DeleteRepositoryPolicyInput) (req *request.Request, output *DeleteRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryPolicyInput{}
	}

	output = &DeleteRepositoryPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepositoryPolicy API operation for Amazon Elastic Container Registry Public.
//
// Deletes the repository policy that's associated with the specified repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation DeleteRepositoryPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - RepositoryPolicyNotFoundException
//     The specified repository and registry combination doesn't have an associated
//     repository policy.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DeleteRepositoryPolicy
func (c *ECRPublic) DeleteRepositoryPolicy(input *DeleteRepositoryPolicyInput) (*DeleteRepositoryPolicyOutput, error) {
	req, out := c.DeleteRepositoryPolicyRequest(input)
	return out, req.Send()
}

// DeleteRepositoryPolicyWithContext is the same as DeleteRepositoryPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRepositoryPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DeleteRepositoryPolicyWithContext(ctx aws.Context, input *DeleteRepositoryPolicyInput, opts ...request.Option) (*DeleteRepositoryPolicyOutput, error) {
	req, out := c.DeleteRepositoryPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImageTags = "DescribeImageTags"

// DescribeImageTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImageTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImageTags for more information on using the DescribeImageTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImageTagsRequest method.
//	req, resp := client.DescribeImageTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags
func (c *ECRPublic) DescribeImageTagsRequest(input *DescribeImageTagsInput) (req *request.Request, output *DescribeImageTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeImageTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImageTagsInput{}
	}

	output = &DescribeImageTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImageTags API operation for Amazon Elastic Container Registry Public.
//
// Returns the image tag details for a repository in a public registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation DescribeImageTags for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImageTags
func (c *ECRPublic) DescribeImageTags(input *DescribeImageTagsInput) (*DescribeImageTagsOutput, error) {
	req, out := c.DescribeImageTagsRequest(input)
	return out, req.Send()
}

// DescribeImageTagsWithContext is the same as DescribeImageTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImageTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DescribeImageTagsWithContext(ctx aws.Context, input *DescribeImageTagsInput, opts ...request.Option) (*DescribeImageTagsOutput, error) {
	req, out := c.DescribeImageTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImageTagsPages iterates over the pages of a DescribeImageTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImageTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeImageTags operation.
//	pageNum := 0
//	err := client.DescribeImageTagsPages(params,
//	    func(page *ecrpublic.DescribeImageTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECRPublic) DescribeImageTagsPages(input *DescribeImageTagsInput, fn func(*DescribeImageTagsOutput, bool) bool) error {
	return c.DescribeImageTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImageTagsPagesWithContext same as DescribeImageTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DescribeImageTagsPagesWithContext(ctx aws.Context, input *DescribeImageTagsInput, fn func(*DescribeImageTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImageTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImageTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImageTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImages for more information on using the DescribeImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImagesRequest method.
//	req, resp := client.DescribeImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages
func (c *ECRPublic) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	output = &DescribeImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImages API operation for Amazon Elastic Container Registry Public.
//
// Returns metadata that's related to the images in a repository in a public
// registry.
//
// Beginning with Docker version 1.9, the Docker client compresses image layers
// before pushing them to a V2 Docker registry. The output of the docker images
// command shows the uncompressed image size. Therefore, it might return a larger
// image size than the image sizes that are returned by DescribeImages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation DescribeImages for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - ImageNotFoundException
//     The image requested doesn't exist in the specified repository.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeImages
func (c *ECRPublic) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	return out, req.Send()
}

// DescribeImagesWithContext is the same as DescribeImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DescribeImagesWithContext(ctx aws.Context, input *DescribeImagesInput, opts ...request.Option) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImagesPages iterates over the pages of a DescribeImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeImages operation.
//	pageNum := 0
//	err := client.DescribeImagesPages(params,
//	    func(page *ecrpublic.DescribeImagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECRPublic) DescribeImagesPages(input *DescribeImagesInput, fn func(*DescribeImagesOutput, bool) bool) error {
	return c.DescribeImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImagesPagesWithContext same as DescribeImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DescribeImagesPagesWithContext(ctx aws.Context, input *DescribeImagesInput, fn func(*DescribeImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRegistries = "DescribeRegistries"

// DescribeRegistriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRegistries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRegistries for more information on using the DescribeRegistries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRegistriesRequest method.
//	req, resp := client.DescribeRegistriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries
func (c *ECRPublic) DescribeRegistriesRequest(input *DescribeRegistriesInput) (req *request.Request, output *DescribeRegistriesOutput) {
	op := &request.Operation{
		Name:       opDescribeRegistries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRegistriesInput{}
	}

	output = &DescribeRegistriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRegistries API operation for Amazon Elastic Container Registry Public.
//
// Returns details for a public registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation DescribeRegistries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRegistries
func (c *ECRPublic) DescribeRegistries(input *DescribeRegistriesInput) (*DescribeRegistriesOutput, error) {
	req, out := c.DescribeRegistriesRequest(input)
	return out, req.Send()
}

// DescribeRegistriesWithContext is the same as DescribeRegistries with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRegistries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DescribeRegistriesWithContext(ctx aws.Context, input *DescribeRegistriesInput, opts ...request.Option) (*DescribeRegistriesOutput, error) {
	req, out := c.DescribeRegistriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRegistriesPages iterates over the pages of a DescribeRegistries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRegistries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeRegistries operation.
//	pageNum := 0
//	err := client.DescribeRegistriesPages(params,
//	    func(page *ecrpublic.DescribeRegistriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECRPublic) DescribeRegistriesPages(input *DescribeRegistriesInput, fn func(*DescribeRegistriesOutput, bool) bool) error {
	return c.DescribeRegistriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRegistriesPagesWithContext same as DescribeRegistriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DescribeRegistriesPagesWithContext(ctx aws.Context, input *DescribeRegistriesInput, fn func(*DescribeRegistriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRegistriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRegistriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRegistriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRepositories = "DescribeRepositories"

// DescribeRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRepositories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRepositories for more information on using the DescribeRepositories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRepositoriesRequest method.
//	req, resp := client.DescribeRepositoriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories
func (c *ECRPublic) DescribeRepositoriesRequest(input *DescribeRepositoriesInput) (req *request.Request, output *DescribeRepositoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRepositoriesInput{}
	}

	output = &DescribeRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRepositories API operation for Amazon Elastic Container Registry Public.
//
// Describes repositories that are in a public registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation DescribeRepositories for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/DescribeRepositories
func (c *ECRPublic) DescribeRepositories(input *DescribeRepositoriesInput) (*DescribeRepositoriesOutput, error) {
	req, out := c.DescribeRepositoriesRequest(input)
	return out, req.Send()
}

// DescribeRepositoriesWithContext is the same as DescribeRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DescribeRepositoriesWithContext(ctx aws.Context, input *DescribeRepositoriesInput, opts ...request.Option) (*DescribeRepositoriesOutput, error) {
	req, out := c.DescribeRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRepositoriesPages iterates over the pages of a DescribeRepositories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRepositories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeRepositories operation.
//	pageNum := 0
//	err := client.DescribeRepositoriesPages(params,
//	    func(page *ecrpublic.DescribeRepositoriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ECRPublic) DescribeRepositoriesPages(input *DescribeRepositoriesInput, fn func(*DescribeRepositoriesOutput, bool) bool) error {
	return c.DescribeRepositoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRepositoriesPagesWithContext same as DescribeRepositoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) DescribeRepositoriesPagesWithContext(ctx aws.Context, input *DescribeRepositoriesInput, fn func(*DescribeRepositoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRepositoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRepositoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRepositoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAuthorizationToken = "GetAuthorizationToken"

// GetAuthorizationTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthorizationToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAuthorizationToken for more information on using the GetAuthorizationToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAuthorizationTokenRequest method.
//	req, resp := client.GetAuthorizationTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetAuthorizationToken
func (c *ECRPublic) GetAuthorizationTokenRequest(input *GetAuthorizationTokenInput) (req *request.Request, output *GetAuthorizationTokenOutput) {
	op := &request.Operation{
		Name:       opGetAuthorizationToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAuthorizationTokenInput{}
	}

	output = &GetAuthorizationTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAuthorizationToken API operation for Amazon Elastic Container Registry Public.
//
// Retrieves an authorization token. An authorization token represents your
// IAM authentication credentials. You can use it to access any Amazon ECR registry
// that your IAM principal has access to. The authorization token is valid for
// 12 hours. This API requires the ecr-public:GetAuthorizationToken and sts:GetServiceBearerToken
// permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation GetAuthorizationToken for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetAuthorizationToken
func (c *ECRPublic) GetAuthorizationToken(input *GetAuthorizationTokenInput) (*GetAuthorizationTokenOutput, error) {
	req, out := c.GetAuthorizationTokenRequest(input)
	return out, req.Send()
}

// GetAuthorizationTokenWithContext is the same as GetAuthorizationToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetAuthorizationToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) GetAuthorizationTokenWithContext(ctx aws.Context, input *GetAuthorizationTokenInput, opts ...request.Option) (*GetAuthorizationTokenOutput, error) {
	req, out := c.GetAuthorizationTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegistryCatalogData = "GetRegistryCatalogData"

// GetRegistryCatalogDataRequest generates a "aws/request.Request" representing the
// client's request for the GetRegistryCatalogData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegistryCatalogData for more information on using the GetRegistryCatalogData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRegistryCatalogDataRequest method.
//	req, resp := client.GetRegistryCatalogDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRegistryCatalogData
func (c *ECRPublic) GetRegistryCatalogDataRequest(input *GetRegistryCatalogDataInput) (req *request.Request, output *GetRegistryCatalogDataOutput) {
	op := &request.Operation{
		Name:       opGetRegistryCatalogData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegistryCatalogDataInput{}
	}

	output = &GetRegistryCatalogDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegistryCatalogData API operation for Amazon Elastic Container Registry Public.
//
// Retrieves catalog metadata for a public registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation GetRegistryCatalogData for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRegistryCatalogData
func (c *ECRPublic) GetRegistryCatalogData(input *GetRegistryCatalogDataInput) (*GetRegistryCatalogDataOutput, error) {
	req, out := c.GetRegistryCatalogDataRequest(input)
	return out, req.Send()
}

// GetRegistryCatalogDataWithContext is the same as GetRegistryCatalogData with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegistryCatalogData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) GetRegistryCatalogDataWithContext(ctx aws.Context, input *GetRegistryCatalogDataInput, opts ...request.Option) (*GetRegistryCatalogDataOutput, error) {
	req, out := c.GetRegistryCatalogDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositoryCatalogData = "GetRepositoryCatalogData"

// GetRepositoryCatalogDataRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryCatalogData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepositoryCatalogData for more information on using the GetRepositoryCatalogData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRepositoryCatalogDataRequest method.
//	req, resp := client.GetRepositoryCatalogDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryCatalogData
func (c *ECRPublic) GetRepositoryCatalogDataRequest(input *GetRepositoryCatalogDataInput) (req *request.Request, output *GetRepositoryCatalogDataOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryCatalogData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryCatalogDataInput{}
	}

	output = &GetRepositoryCatalogDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositoryCatalogData API operation for Amazon Elastic Container Registry Public.
//
// Retrieve catalog metadata for a repository in a public registry. This metadata
// is displayed publicly in the Amazon ECR Public Gallery.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation GetRepositoryCatalogData for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryCatalogDataNotFoundException
//     The repository catalog data doesn't exist.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryCatalogData
func (c *ECRPublic) GetRepositoryCatalogData(input *GetRepositoryCatalogDataInput) (*GetRepositoryCatalogDataOutput, error) {
	req, out := c.GetRepositoryCatalogDataRequest(input)
	return out, req.Send()
}

// GetRepositoryCatalogDataWithContext is the same as GetRepositoryCatalogData with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositoryCatalogData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) GetRepositoryCatalogDataWithContext(ctx aws.Context, input *GetRepositoryCatalogDataInput, opts ...request.Option) (*GetRepositoryCatalogDataOutput, error) {
	req, out := c.GetRepositoryCatalogDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositoryPolicy = "GetRepositoryPolicy"

// GetRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepositoryPolicy for more information on using the GetRepositoryPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRepositoryPolicyRequest method.
//	req, resp := client.GetRepositoryPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryPolicy
func (c *ECRPublic) GetRepositoryPolicyRequest(input *GetRepositoryPolicyInput) (req *request.Request, output *GetRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryPolicyInput{}
	}

	output = &GetRepositoryPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositoryPolicy API operation for Amazon Elastic Container Registry Public.
//
// Retrieves the repository policy for the specified repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation GetRepositoryPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - RepositoryPolicyNotFoundException
//     The specified repository and registry combination doesn't have an associated
//     repository policy.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/GetRepositoryPolicy
func (c *ECRPublic) GetRepositoryPolicy(input *GetRepositoryPolicyInput) (*GetRepositoryPolicyOutput, error) {
	req, out := c.GetRepositoryPolicyRequest(input)
	return out, req.Send()
}

// GetRepositoryPolicyWithContext is the same as GetRepositoryPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositoryPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) GetRepositoryPolicyWithContext(ctx aws.Context, input *GetRepositoryPolicyInput, opts ...request.Option) (*GetRepositoryPolicyOutput, error) {
	req, out := c.GetRepositoryPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitiateLayerUpload = "InitiateLayerUpload"

// InitiateLayerUploadRequest generates a "aws/request.Request" representing the
// client's request for the InitiateLayerUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitiateLayerUpload for more information on using the InitiateLayerUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InitiateLayerUploadRequest method.
//	req, resp := client.InitiateLayerUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/InitiateLayerUpload
func (c *ECRPublic) InitiateLayerUploadRequest(input *InitiateLayerUploadInput) (req *request.Request, output *InitiateLayerUploadOutput) {
	op := &request.Operation{
		Name:       opInitiateLayerUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InitiateLayerUploadInput{}
	}

	output = &InitiateLayerUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitiateLayerUpload API operation for Amazon Elastic Container Registry Public.
//
// Notifies Amazon ECR that you intend to upload an image layer.
//
// When an image is pushed, the InitiateLayerUpload API is called once for each
// image layer that hasn't already been uploaded. Whether an image layer uploads
// is determined by the BatchCheckLayerAvailability API action.
//
// This operation is used by the Amazon ECR proxy and is not generally used
// by customers for pulling and pushing images. In most cases, you should use
// the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation InitiateLayerUpload for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - RegistryNotFoundException
//     The registry doesn't exist.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/InitiateLayerUpload
func (c *ECRPublic) InitiateLayerUpload(input *InitiateLayerUploadInput) (*InitiateLayerUploadOutput, error) {
	req, out := c.InitiateLayerUploadRequest(input)
	return out, req.Send()
}

// InitiateLayerUploadWithContext is the same as InitiateLayerUpload with the addition of
// the ability to pass a context and additional request options.
//
// See InitiateLayerUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) InitiateLayerUploadWithContext(ctx aws.Context, input *InitiateLayerUploadInput, opts ...request.Option) (*InitiateLayerUploadOutput, error) {
	req, out := c.InitiateLayerUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/ListTagsForResource
func (c *ECRPublic) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Elastic Container Registry Public.
//
// List the tags for an Amazon ECR Public resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/ListTagsForResource
func (c *ECRPublic) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutImage = "PutImage"

// PutImageRequest generates a "aws/request.Request" representing the
// client's request for the PutImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutImage for more information on using the PutImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutImageRequest method.
//	req, resp := client.PutImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutImage
func (c *ECRPublic) PutImageRequest(input *PutImageInput) (req *request.Request, output *PutImageOutput) {
	op := &request.Operation{
		Name:       opPutImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutImageInput{}
	}

	output = &PutImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutImage API operation for Amazon Elastic Container Registry Public.
//
// Creates or updates the image manifest and tags that are associated with an
// image.
//
// When an image is pushed and all new image layers have been uploaded, the
// PutImage API is called once to create or update the image manifest and the
// tags that are associated with the image.
//
// This operation is used by the Amazon ECR proxy and is not generally used
// by customers for pulling and pushing images. In most cases, you should use
// the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation PutImage for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - ImageAlreadyExistsException
//     The specified image has already been pushed, and there were no changes to
//     the manifest or image tag after the last push.
//
//   - LayersNotFoundException
//     The specified layers can't be found, or the specified layer isn't valid for
//     this repository.
//
//   - ReferencedImagesNotFoundException
//     The manifest list is referencing an image that doesn't exist.
//
//   - LimitExceededException
//     The operation didn't succeed because it would have exceeded a service limit
//     for your account. For more information, see Amazon ECR Service Quotas (https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html)
//     in the Amazon Elastic Container Registry User Guide.
//
//   - ImageTagAlreadyExistsException
//     The specified image is tagged with a tag that already exists. The repository
//     is configured for tag immutability.
//
//   - ImageDigestDoesNotMatchException
//     The specified image digest doesn't match the digest that Amazon ECR calculated
//     for the image.
//
//   - RegistryNotFoundException
//     The registry doesn't exist.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutImage
func (c *ECRPublic) PutImage(input *PutImageInput) (*PutImageOutput, error) {
	req, out := c.PutImageRequest(input)
	return out, req.Send()
}

// PutImageWithContext is the same as PutImage with the addition of
// the ability to pass a context and additional request options.
//
// See PutImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) PutImageWithContext(ctx aws.Context, input *PutImageInput, opts ...request.Option) (*PutImageOutput, error) {
	req, out := c.PutImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRegistryCatalogData = "PutRegistryCatalogData"

// PutRegistryCatalogDataRequest generates a "aws/request.Request" representing the
// client's request for the PutRegistryCatalogData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRegistryCatalogData for more information on using the PutRegistryCatalogData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRegistryCatalogDataRequest method.
//	req, resp := client.PutRegistryCatalogDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRegistryCatalogData
func (c *ECRPublic) PutRegistryCatalogDataRequest(input *PutRegistryCatalogDataInput) (req *request.Request, output *PutRegistryCatalogDataOutput) {
	op := &request.Operation{
		Name:       opPutRegistryCatalogData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRegistryCatalogDataInput{}
	}

	output = &PutRegistryCatalogDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRegistryCatalogData API operation for Amazon Elastic Container Registry Public.
//
// Create or update the catalog data for a public registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation PutRegistryCatalogData for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRegistryCatalogData
func (c *ECRPublic) PutRegistryCatalogData(input *PutRegistryCatalogDataInput) (*PutRegistryCatalogDataOutput, error) {
	req, out := c.PutRegistryCatalogDataRequest(input)
	return out, req.Send()
}

// PutRegistryCatalogDataWithContext is the same as PutRegistryCatalogData with the addition of
// the ability to pass a context and additional request options.
//
// See PutRegistryCatalogData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) PutRegistryCatalogDataWithContext(ctx aws.Context, input *PutRegistryCatalogDataInput, opts ...request.Option) (*PutRegistryCatalogDataOutput, error) {
	req, out := c.PutRegistryCatalogDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRepositoryCatalogData = "PutRepositoryCatalogData"

// PutRepositoryCatalogDataRequest generates a "aws/request.Request" representing the
// client's request for the PutRepositoryCatalogData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRepositoryCatalogData for more information on using the PutRepositoryCatalogData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRepositoryCatalogDataRequest method.
//	req, resp := client.PutRepositoryCatalogDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRepositoryCatalogData
func (c *ECRPublic) PutRepositoryCatalogDataRequest(input *PutRepositoryCatalogDataInput) (req *request.Request, output *PutRepositoryCatalogDataOutput) {
	op := &request.Operation{
		Name:       opPutRepositoryCatalogData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRepositoryCatalogDataInput{}
	}

	output = &PutRepositoryCatalogDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRepositoryCatalogData API operation for Amazon Elastic Container Registry Public.
//
// Creates or updates the catalog data for a repository in a public registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation PutRepositoryCatalogData for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/PutRepositoryCatalogData
func (c *ECRPublic) PutRepositoryCatalogData(input *PutRepositoryCatalogDataInput) (*PutRepositoryCatalogDataOutput, error) {
	req, out := c.PutRepositoryCatalogDataRequest(input)
	return out, req.Send()
}

// PutRepositoryCatalogDataWithContext is the same as PutRepositoryCatalogData with the addition of
// the ability to pass a context and additional request options.
//
// See PutRepositoryCatalogData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) PutRepositoryCatalogDataWithContext(ctx aws.Context, input *PutRepositoryCatalogDataInput, opts ...request.Option) (*PutRepositoryCatalogDataOutput, error) {
	req, out := c.PutRepositoryCatalogDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetRepositoryPolicy = "SetRepositoryPolicy"

// SetRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SetRepositoryPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetRepositoryPolicy for more information on using the SetRepositoryPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetRepositoryPolicyRequest method.
//	req, resp := client.SetRepositoryPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/SetRepositoryPolicy
func (c *ECRPublic) SetRepositoryPolicyRequest(input *SetRepositoryPolicyInput) (req *request.Request, output *SetRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opSetRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRepositoryPolicyInput{}
	}

	output = &SetRepositoryPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetRepositoryPolicy API operation for Amazon Elastic Container Registry Public.
//
// Applies a repository policy to the specified public repository to control
// access permissions. For more information, see Amazon ECR Repository Policies
// (https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html)
// in the Amazon Elastic Container Registry User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation SetRepositoryPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/SetRepositoryPolicy
func (c *ECRPublic) SetRepositoryPolicy(input *SetRepositoryPolicyInput) (*SetRepositoryPolicyOutput, error) {
	req, out := c.SetRepositoryPolicyRequest(input)
	return out, req.Send()
}

// SetRepositoryPolicyWithContext is the same as SetRepositoryPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See SetRepositoryPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) SetRepositoryPolicyWithContext(ctx aws.Context, input *SetRepositoryPolicyInput, opts ...request.Option) (*SetRepositoryPolicyOutput, error) {
	req, out := c.SetRepositoryPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/TagResource
func (c *ECRPublic) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Elastic Container Registry Public.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource aren't specified in the request parameters,
// they aren't changed. When a resource is deleted, the tags associated with
// that resource are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidTagParameterException
//     An invalid parameter has been specified. Tag keys can have a maximum character
//     length of 128 characters, and tag values can have a maximum length of 256
//     characters.
//
//   - TooManyTagsException
//     The list of tags on the repository is over the limit. The maximum number
//     of tags that can be applied to a repository is 50.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/TagResource
func (c *ECRPublic) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UntagResource
func (c *ECRPublic) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Elastic Container Registry Public.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidTagParameterException
//     An invalid parameter has been specified. Tag keys can have a maximum character
//     length of 128 characters, and tag values can have a maximum length of 256
//     characters.
//
//   - TooManyTagsException
//     The list of tags on the repository is over the limit. The maximum number
//     of tags that can be applied to a repository is 50.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UntagResource
func (c *ECRPublic) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadLayerPart = "UploadLayerPart"

// UploadLayerPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadLayerPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadLayerPart for more information on using the UploadLayerPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UploadLayerPartRequest method.
//	req, resp := client.UploadLayerPartRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UploadLayerPart
func (c *ECRPublic) UploadLayerPartRequest(input *UploadLayerPartInput) (req *request.Request, output *UploadLayerPartOutput) {
	op := &request.Operation{
		Name:       opUploadLayerPart,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadLayerPartInput{}
	}

	output = &UploadLayerPartOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadLayerPart API operation for Amazon Elastic Container Registry Public.
//
// Uploads an image layer part to Amazon ECR.
//
// When an image is pushed, each new image layer is uploaded in parts. The maximum
// size of each image layer part can be 20971520 bytes (about 20MB). The UploadLayerPart
// API is called once for each new image layer part.
//
// This operation is used by the Amazon ECR proxy and is not generally used
// by customers for pulling and pushing images. In most cases, you should use
// the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Container Registry Public's
// API operation UploadLayerPart for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidLayerPartException
//     The layer part size isn't valid, or the first byte specified isn't consecutive
//     to the last byte of a previous layer part upload.
//
//   - RepositoryNotFoundException
//     The specified repository can't be found. Check the spelling of the specified
//     repository and ensure that you're performing operations on the correct registry.
//
//   - UploadNotFoundException
//     The upload can't be found, or the specified upload ID isn't valid for this
//     repository.
//
//   - LimitExceededException
//     The operation didn't succeed because it would have exceeded a service limit
//     for your account. For more information, see Amazon ECR Service Quotas (https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html)
//     in the Amazon Elastic Container Registry User Guide.
//
//   - RegistryNotFoundException
//     The registry doesn't exist.
//
//   - UnsupportedCommandException
//     The action isn't supported in this Region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ecr-public-2020-10-30/UploadLayerPart
func (c *ECRPublic) UploadLayerPart(input *UploadLayerPartInput) (*UploadLayerPartOutput, error) {
	req, out := c.UploadLayerPartRequest(input)
	return out, req.Send()
}

// UploadLayerPartWithContext is the same as UploadLayerPart with the addition of
// the ability to pass a context and additional request options.
//
// See UploadLayerPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECRPublic) UploadLayerPartWithContext(ctx aws.Context, input *UploadLayerPartInput, opts ...request.Option) (*UploadLayerPartOutput, error) {
	req, out := c.UploadLayerPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An authorization token data object that corresponds to a public registry.
type AuthorizationData struct {
	_ struct{} `type:"structure"`

	// A base64-encoded string that contains authorization data for a public Amazon
	// ECR registry. When the string is decoded, it's presented in the format user:password
	// for public registry authentication using docker login.
	AuthorizationToken *string `locationName:"authorizationToken" type:"string"`

	// The Unix time in seconds and milliseconds when the authorization token expires.
	// Authorization tokens are valid for 12 hours.
	ExpiresAt *time.Time `locationName:"expiresAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizationData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizationData) GoString() string {
	return s.String()
}

// SetAuthorizationToken sets the AuthorizationToken field's value.
func (s *AuthorizationData) SetAuthorizationToken(v string) *AuthorizationData {
	s.AuthorizationToken = &v
	return s
}

// SetExpiresAt sets the ExpiresAt field's value.
func (s *AuthorizationData) SetExpiresAt(v time.Time) *AuthorizationData {
	s.ExpiresAt = &v
	return s
}

type BatchCheckLayerAvailabilityInput struct {
	_ struct{} `type:"structure"`

	// The digests of the image layers to check.
	//
	// LayerDigests is a required field
	LayerDigests []*string `locationName:"layerDigests" min:"1" type:"list" required:"true"`

	// The Amazon Web Services account ID, or registry alias, associated with the
	// public registry that contains the image layers to check. If you do not specify
	// a registry, the default public registry is assumed.
	RegistryId *string `locationName:"registryId" min:"2" type:"string"`

	// The name of the repository that's associated with the image layers to check.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCheckLayerAvailabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCheckLayerAvailabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCheckLayerAvailabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCheckLayerAvailabilityInput"}
	if s.LayerDigests == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerDigests"))
	}
	if s.LayerDigests != nil && len(s.LayerDigests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerDigests", 1))
	}
	if s.RegistryId != nil && len(*s.RegistryId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryId", 2))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerDigests sets the LayerDigests field's value.
func (s *BatchCheckLayerAvailabilityInput) SetLayerDigests(v []*string) *BatchCheckLayerAvailabilityInput {
	s.LayerDigests = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *BatchCheckLayerAvailabilityInput) SetRegistryId(v string) *BatchCheckLayerAvailabilityInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *BatchCheckLayerAvailabilityInput) SetRepositoryName(v string) *BatchCheckLayerAvailabilityInput {
	s.RepositoryName = &v
	return s
}

type BatchCheckLayerAvailabilityOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*LayerFailure `locationName:"failures" type:"list"`

	// A list of image layer objects that correspond to the image layer references
	// in the request.
	Layers []*Layer `locationName:"layers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCheckLayerAvailabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCheckLayerAvailabilityOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchCheckLayerAvailabilityOutput) SetFailures(v []*LayerFailure) *BatchCheckLayerAvailabilityOutput {
	s.Failures = v
	return s
}

// SetLayers sets the Layers field's value.
func (s *BatchCheckLayerAvailabilityOutput) SetLayers(v []*Layer) *BatchCheckLayerAvailabilityOutput {
	s.Layers = v
	return s
}

type BatchDeleteImageInput struct {
	_ struct{} `type:"structure"`

	// A list of image ID references that correspond to images to delete. The format
	// of the imageIds reference is imageTag=tag or imageDigest=digest.
	//
	// ImageIds is a required field
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list" required:"true"`

	// The Amazon Web Services account ID that's associated with the registry that
	// contains the image to delete. If you do not specify a registry, the default
	// public registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository in a public registry that contains the image to delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteImageInput"}
	if s.ImageIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageIds"))
	}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.ImageIds != nil {
		for i, v := range s.ImageIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ImageIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageIds sets the ImageIds field's value.
func (s *BatchDeleteImageInput) SetImageIds(v []*ImageIdentifier) *BatchDeleteImageInput {
	s.ImageIds = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *BatchDeleteImageInput) SetRegistryId(v string) *BatchDeleteImageInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *BatchDeleteImageInput) SetRepositoryName(v string) *BatchDeleteImageInput {
	s.RepositoryName = &v
	return s
}

type BatchDeleteImageOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*ImageFailure `locationName:"failures" type:"list"`

	// The image IDs of the deleted images.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteImageOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchDeleteImageOutput) SetFailures(v []*ImageFailure) *BatchDeleteImageOutput {
	s.Failures = v
	return s
}

// SetImageIds sets the ImageIds field's value.
func (s *BatchDeleteImageOutput) SetImageIds(v []*ImageIdentifier) *BatchDeleteImageOutput {
	s.ImageIds = v
	return s
}

type CompleteLayerUploadInput struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image layer.
	//
	// LayerDigests is a required field
	LayerDigests []*string `locationName:"layerDigests" min:"1" type:"list" required:"true"`

	// The Amazon Web Services account ID, or registry alias, associated with the
	// registry where layers are uploaded. If you do not specify a registry, the
	// default public registry is assumed.
	RegistryId *string `locationName:"registryId" min:"2" type:"string"`

	// The name of the repository in a public registry to associate with the image
	// layer.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`

	// The upload ID from a previous InitiateLayerUpload operation to associate
	// with the image layer.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteLayerUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteLayerUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteLayerUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteLayerUploadInput"}
	if s.LayerDigests == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerDigests"))
	}
	if s.LayerDigests != nil && len(s.LayerDigests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerDigests", 1))
	}
	if s.RegistryId != nil && len(*s.RegistryId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryId", 2))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerDigests sets the LayerDigests field's value.
func (s *CompleteLayerUploadInput) SetLayerDigests(v []*string) *CompleteLayerUploadInput {
	s.LayerDigests = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *CompleteLayerUploadInput) SetRegistryId(v string) *CompleteLayerUploadInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CompleteLayerUploadInput) SetRepositoryName(v string) *CompleteLayerUploadInput {
	s.RepositoryName = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteLayerUploadInput) SetUploadId(v string) *CompleteLayerUploadInput {
	s.UploadId = &v
	return s
}

type CompleteLayerUploadOutput struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image layer.
	LayerDigest *string `locationName:"layerDigest" type:"string"`

	// The public registry ID that's associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name that's associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The upload ID that's associated with the layer.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteLayerUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteLayerUploadOutput) GoString() string {
	return s.String()
}

// SetLayerDigest sets the LayerDigest field's value.
func (s *CompleteLayerUploadOutput) SetLayerDigest(v string) *CompleteLayerUploadOutput {
	s.LayerDigest = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *CompleteLayerUploadOutput) SetRegistryId(v string) *CompleteLayerUploadOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CompleteLayerUploadOutput) SetRepositoryName(v string) *CompleteLayerUploadOutput {
	s.RepositoryName = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteLayerUploadOutput) SetUploadId(v string) *CompleteLayerUploadOutput {
	s.UploadId = &v
	return s
}

type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The details about the repository that are publicly visible in the Amazon
	// ECR Public Gallery.
	CatalogData *RepositoryCatalogDataInput `locationName:"catalogData" type:"structure"`

	// The name to use for the repository. This appears publicly in the Amazon ECR
	// Public Gallery. The repository name can be specified on its own (for example
	// nginx-web-app) or prepended with a namespace to group the repository into
	// a category (for example project-a/nginx-web-app).
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`

	// The metadata that you apply to each repository to help categorize and organize
	// your repositories. Each tag consists of a key and an optional value. You
	// define both of them. Tag keys can have a maximum character length of 128
	// characters, and tag values can have a maximum length of 256 characters.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogData sets the CatalogData field's value.
func (s *CreateRepositoryInput) SetCatalogData(v *RepositoryCatalogDataInput) *CreateRepositoryInput {
	s.CatalogData = v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateRepositoryInput) SetRepositoryName(v string) *CreateRepositoryInput {
	s.RepositoryName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRepositoryInput) SetTags(v []*Tag) *CreateRepositoryInput {
	s.Tags = v
	return s
}

type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The catalog data for a repository. This data is publicly visible in the Amazon
	// ECR Public Gallery.
	CatalogData *RepositoryCatalogData `locationName:"catalogData" type:"structure"`

	// The repository that was created.
	Repository *Repository `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}

// SetCatalogData sets the CatalogData field's value.
func (s *CreateRepositoryOutput) SetCatalogData(v *RepositoryCatalogData) *CreateRepositoryOutput {
	s.CatalogData = v
	return s
}

// SetRepository sets the Repository field's value.
func (s *CreateRepositoryOutput) SetRepository(v *Repository) *CreateRepositoryOutput {
	s.Repository = v
	return s
}

type DeleteRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The force option can be used to delete a repository that contains images.
	// If the force option is not used, the repository must be empty prior to deletion.
	Force *bool `locationName:"force" type:"boolean"`

	// The Amazon Web Services account ID that's associated with the public registry
	// that contains the repository to delete. If you do not specify a registry,
	// the default public registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeleteRepositoryInput) SetForce(v bool) *DeleteRepositoryInput {
	s.Force = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DeleteRepositoryInput) SetRegistryId(v string) *DeleteRepositoryInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteRepositoryInput) SetRepositoryName(v string) *DeleteRepositoryInput {
	s.RepositoryName = &v
	return s
}

type DeleteRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The repository that was deleted.
	Repository *Repository `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *DeleteRepositoryOutput) SetRepository(v *Repository) *DeleteRepositoryOutput {
	s.Repository = v
	return s
}

type DeleteRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID that's associated with the public registry
	// that contains the repository policy to delete. If you do not specify a registry,
	// the default public registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that's associated with the repository policy to
	// delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryPolicyInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryId sets the RegistryId field's value.
func (s *DeleteRepositoryPolicyInput) SetRegistryId(v string) *DeleteRepositoryPolicyInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteRepositoryPolicyInput) SetRepositoryName(v string) *DeleteRepositoryPolicyInput {
	s.RepositoryName = &v
	return s
}

type DeleteRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy that was deleted from the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID that's associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name that's associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyText sets the PolicyText field's value.
func (s *DeleteRepositoryPolicyOutput) SetPolicyText(v string) *DeleteRepositoryPolicyOutput {
	s.PolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DeleteRepositoryPolicyOutput) SetRegistryId(v string) *DeleteRepositoryPolicyOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteRepositoryPolicyOutput) SetRepositoryName(v string) *DeleteRepositoryPolicyOutput {
	s.RepositoryName = &v
	return s
}

type DescribeImageTagsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repository results that's returned by DescribeImageTags
	// in paginated output. When this parameter is used, DescribeImageTags only
	// returns maxResults results in a single page along with a nextToken response
	// element. You can see the remaining results of the initial request by sending
	// another DescribeImageTags request with the returned nextToken value. This
	// value can be between 1 and 1000. If this parameter isn't used, then DescribeImageTags
	// returns up to 100 results and a nextToken value, if applicable. If you specify
	// images with imageIds, you can't use this option.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value that's returned from a previous paginated DescribeImageTags
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. If there are no more results to return, this
	// value is null. If you specify images with imageIds, you can't use this option.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Web Services account ID that's associated with the public registry
	// that contains the repository where images are described. If you do not specify
	// a registry, the default public registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that contains the image tag details to describe.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImageTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImageTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImageTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImageTagsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImageTagsInput) SetMaxResults(v int64) *DescribeImageTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImageTagsInput) SetNextToken(v string) *DescribeImageTagsInput {
	s.NextToken = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DescribeImageTagsInput) SetRegistryId(v string) *DescribeImageTagsInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DescribeImageTagsInput) SetRepositoryName(v string) *DescribeImageTagsInput {
	s.RepositoryName = &v
	return s
}

type DescribeImageTagsOutput struct {
	_ struct{} `type:"structure"`

	// The image tag details for the images in the requested repository.
	ImageTagDetails []*ImageTagDetail `locationName:"imageTagDetails" type:"list"`

	// The nextToken value to include in a future DescribeImageTags request. When
	// the results of a DescribeImageTags request exceed maxResults, you can use
	// this value to retrieve the next page of results. If there are no more results
	// to return, this value is null.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImageTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImageTagsOutput) GoString() string {
	return s.String()
}

// SetImageTagDetails sets the ImageTagDetails field's value.
func (s *DescribeImageTagsOutput) SetImageTagDetails(v []*ImageTagDetail) *DescribeImageTagsOutput {
	s.ImageTagDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImageTagsOutput) SetNextToken(v string) *DescribeImageTagsOutput {
	s.NextToken = &v
	return s
}

type DescribeImagesInput struct {
	_ struct{} `type:"structure"`

	// The list of image IDs for the requested repository.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list"`

	// The maximum number of repository results that's returned by DescribeImages
	// in paginated output. When this parameter is used, DescribeImages only returns
	// maxResults results in a single page along with a nextToken response element.
	// You can see the remaining results of the initial request by sending another
	// DescribeImages request with the returned nextToken value. This value can
	// be between 1 and 1000. If this parameter isn't used, then DescribeImages
	// returns up to 100 results and a nextToken value, if applicable. If you specify
	// images with imageIds, you can't use this option.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value that's returned from a previous paginated DescribeImages
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. If there are no more results to return, this
	// value is null. If you specify images with imageIds, you can't use this option.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Web Services account ID that's associated with the public registry
	// that contains the repository where images are described. If you do not specify
	// a registry, the default public registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository that contains the images to describe.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImagesInput"}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.ImageIds != nil {
		for i, v := range s.ImageIds {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ImageIds", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageIds sets the ImageIds field's value.
func (s *DescribeImagesInput) SetImageIds(v []*ImageIdentifier) *DescribeImagesInput {
	s.ImageIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImagesInput) SetMaxResults(v int64) *DescribeImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImagesInput) SetNextToken(v string) *DescribeImagesInput {
	s.NextToken = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DescribeImagesInput) SetRegistryId(v string) *DescribeImagesInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DescribeImagesInput) SetRepositoryName(v string) *DescribeImagesInput {
	s.RepositoryName = &v
	return s
}

type DescribeImagesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ImageDetail objects that contain data about the image.
	ImageDetails []*ImageDetail `locationName:"imageDetails" type:"list"`

	// The nextToken value to include in a future DescribeImages request. When the
	// results of a DescribeImages request exceed maxResults, you can use this value
	// to retrieve the next page of results. If there are no more results to return,
	// this value is null.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImagesOutput) GoString() string {
	return s.String()
}

// SetImageDetails sets the ImageDetails field's value.
func (s *DescribeImagesOutput) SetImageDetails(v []*ImageDetail) *DescribeImagesOutput {
	s.ImageDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImagesOutput) SetNextToken(v string) *DescribeImagesOutput {
	s.NextToken = &v
	return s
}

type DescribeRegistriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repository results that's returned by DescribeRegistries
	// in paginated output. When this parameter is used, DescribeRegistries only
	// returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another DescribeRegistries request with the returned nextToken value. This
	// value can be between 1 and 1000. If this parameter isn't used, then DescribeRegistries
	// returns up to 100 results and a nextToken value, if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value that's returned from a previous paginated DescribeRegistries
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. If there are no more results to return, this
	// value is null.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegistriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegistriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRegistriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRegistriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeRegistriesInput) SetMaxResults(v int64) *DescribeRegistriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRegistriesInput) SetNextToken(v string) *DescribeRegistriesInput {
	s.NextToken = &v
	return s
}

type DescribeRegistriesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future DescribeRepositories request.
	// If the results of a DescribeRepositories request exceed maxResults, you can
	// use this value to retrieve the next page of results. If there are no more
	// results, this value is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An object that contains the details for a public registry.
	//
	// Registries is a required field
	Registries []*Registry `locationName:"registries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegistriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegistriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRegistriesOutput) SetNextToken(v string) *DescribeRegistriesOutput {
	s.NextToken = &v
	return s
}

// SetRegistries sets the Registries field's value.
func (s *DescribeRegistriesOutput) SetRegistries(v []*Registry) *DescribeRegistriesOutput {
	s.Registries = v
	return s
}

type DescribeRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repository results that's returned by DescribeRepositories
	// in paginated output. When this parameter is used, DescribeRepositories only
	// returns maxResults results in a single page along with a nextToken response
	// element. You can see the remaining results of the initial request by sending
	// another DescribeRepositories request with the returned nextToken value. This
	// value can be between 1 and 1000. If this parameter isn't used, then DescribeRepositories
	// returns up to 100 results and a nextToken value, if applicable. If you specify
	// repositories with repositoryNames, you can't use this option.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value that's returned from a previous paginated DescribeRepositories
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. If there are no more results to return, this
	// value is null. If you specify repositories with repositoryNames, you can't
	// use this option.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Web Services account ID that's associated with the registry that
	// contains the repositories to be described. If you do not specify a registry,
	// the default public registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// A list of repositories to describe. If this parameter is omitted, then all
	// repositories in a registry are described.
	RepositoryNames []*string `locationName:"repositoryNames" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRepositoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRepositoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRepositoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RepositoryNames != nil && len(s.RepositoryNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeRepositoriesInput) SetMaxResults(v int64) *DescribeRepositoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRepositoriesInput) SetNextToken(v string) *DescribeRepositoriesInput {
	s.NextToken = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DescribeRepositoriesInput) SetRegistryId(v string) *DescribeRepositoriesInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryNames sets the RepositoryNames field's value.
func (s *DescribeRepositoriesInput) SetRepositoryNames(v []*string) *DescribeRepositoriesInput {
	s.RepositoryNames = v
	return s
}

type DescribeRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future DescribeRepositories request.
	// When the results of a DescribeRepositories request exceed maxResults, this
	// value can be used to retrieve the next page of results. If there are no more
	// results to return, this value is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of repository objects corresponding to valid repositories.
	Repositories []*Repository `locationName:"repositories" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRepositoriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRepositoriesOutput) SetNextToken(v string) *DescribeRepositoriesOutput {
	s.NextToken = &v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *DescribeRepositoriesOutput) SetRepositories(v []*Repository) *DescribeRepositoriesOutput {
	s.Repositories = v
	return s
}

// The specified layer upload doesn't contain any layer parts.
type EmptyUploadException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmptyUploadException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmptyUploadException) GoString() string {
	return s.String()
}

func newErrorEmptyUploadException(v protocol.ResponseMetadata) error {
	return &EmptyUploadException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EmptyUploadException) Code() string {
	return "EmptyUploadException"
}

// Message returns the exception's message.
func (s *EmptyUploadException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EmptyUploadException) OrigErr() error {
	return nil
}

func (s *EmptyUploadException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EmptyUploadException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EmptyUploadException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetAuthorizationTokenInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizationTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizationTokenInput) GoString() string {
	return s.String()
}

type GetAuthorizationTokenOutput struct {
	_ struct{} `type:"structure"`

	// An authorization token data object that corresponds to a public registry.
	AuthorizationData *AuthorizationData `locationName:"authorizationData" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizationTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizationTokenOutput) GoString() string {
	return s.String()
}

// SetAuthorizationData sets the AuthorizationData field's value.
func (s *GetAuthorizationTokenOutput) SetAuthorizationData(v *AuthorizationData) *GetAuthorizationTokenOutput {
	s.AuthorizationData = v
	return s
}

type GetRegistryCatalogDataInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRegistryCatalogDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRegistryCatalogDataInput) GoString() string {
	return s.String()
}

type GetRegistryCatalogDataOutput struct {
	_ struct{} `type:"structure"`

	// The catalog metadata for the public registry.
	//
	// RegistryCatalogData is a required field
	RegistryCatalogData *RegistryCatalogData `locationName:"registryCatalogData" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRegistryCatalogDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRegistryCatalogDataOutput) GoString() string {
	return s.String()
}

// SetRegistryCatalogData sets the RegistryCatalogData field's value.
func (s *GetRegistryCatalogDataOutput) SetRegistryCatalogData(v *RegistryCatalogData) *GetRegistryCatalogDataOutput {
	s.RegistryCatalogData = v
	return s
}

type GetRepositoryCatalogDataInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID that's associated with the registry that
	// contains the repositories to be described. If you do not specify a registry,
	// the default public registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to retrieve the catalog metadata for.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryCatalogDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryCatalogDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryCatalogDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryCatalogDataInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryId sets the RegistryId field's value.
func (s *GetRepositoryCatalogDataInput) SetRegistryId(v string) *GetRepositoryCatalogDataInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryCatalogDataInput) SetRepositoryName(v string) *GetRepositoryCatalogDataInput {
	s.RepositoryName = &v
	return s
}

type GetRepositoryCatalogDataOutput struct {
	_ struct{} `type:"structure"`

	// The catalog metadata for the repository.
	CatalogData *RepositoryCatalogData `locationName:"catalogData" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryCatalogDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryCatalogDataOutput) GoString() string {
	return s.String()
}

// SetCatalogData sets the CatalogData field's value.
func (s *GetRepositoryCatalogDataOutput) SetCatalogData(v *RepositoryCatalogData) *GetRepositoryCatalogDataOutput {
	s.CatalogData = v
	return s
}

type GetRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID that's associated with the public registry
	// that contains the repository. If you do not specify a registry, the default
	// public registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository with the policy to retrieve.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryPolicyInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryId sets the RegistryId field's value.
func (s *GetRepositoryPolicyInput) SetRegistryId(v string) *GetRepositoryPolicyInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryPolicyInput) SetRepositoryName(v string) *GetRepositoryPolicyInput {
	s.RepositoryName = &v
	return s
}

type GetRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The repository policy text that's associated with the repository. The policy
	// text will be in JSON format.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID that's associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name that's associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyText sets the PolicyText field's value.
func (s *GetRepositoryPolicyOutput) SetPolicyText(v string) *GetRepositoryPolicyOutput {
	s.PolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *GetRepositoryPolicyOutput) SetRegistryId(v string) *GetRepositoryPolicyOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryPolicyOutput) SetRepositoryName(v string) *GetRepositoryPolicyOutput {
	s.RepositoryName = &v
	return s
}

// An object that represents an Amazon ECR image.
type Image struct {
	_ struct{} `type:"structure"`

	// An object that contains the image tag and image digest associated with an
	// image.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`

	// The image manifest that's associated with the image.
	ImageManifest *string `locationName:"imageManifest" min:"1" type:"string"`

	// The manifest media type of the image.
	ImageManifestMediaType *string `locationName:"imageManifestMediaType" type:"string"`

	// The Amazon Web Services account ID that's associated with the registry containing
	// the image.
	RegistryId *string `locationName:"registryId" min:"2" type:"string"`

	// The name of the repository that's associated with the image.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Image) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *Image) SetImageId(v *ImageIdentifier) *Image {
	s.ImageId = v
	return s
}

// SetImageManifest sets the ImageManifest field's value.
func (s *Image) SetImageManifest(v string) *Image {
	s.ImageManifest = &v
	return s
}

// SetImageManifestMediaType sets the ImageManifestMediaType field's value.
func (s *Image) SetImageManifestMediaType(v string) *Image {
	s.ImageManifestMediaType = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *Image) SetRegistryId(v string) *Image {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *Image) SetRepositoryName(v string) *Image {
	s.RepositoryName = &v
	return s
}

// The specified image has already been pushed, and there were no changes to
// the manifest or image tag after the last push.
type ImageAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorImageAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ImageAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ImageAlreadyExistsException) Code() string {
	return "ImageAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ImageAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ImageAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ImageAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ImageAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ImageAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that describes an image that's returned by a DescribeImages operation.
type ImageDetail struct {
	_ struct{} `type:"structure"`

	// The artifact media type of the image.
	ArtifactMediaType *string `locationName:"artifactMediaType" type:"string"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The media type of the image manifest.
	ImageManifestMediaType *string `locationName:"imageManifestMediaType" type:"string"`

	// The date and time, expressed in standard JavaScript date format, that the
	// current image was pushed to the repository at.
	ImagePushedAt *time.Time `locationName:"imagePushedAt" type:"timestamp"`

	// The size, in bytes, of the image in the repository.
	//
	// If the image is a manifest list, this is the max size of all manifests in
	// the list.
	//
	// Beginning with Docker version 1.9, the Docker client compresses image layers
	// before pushing them to a V2 Docker registry. The output of the docker images
	// command shows the uncompressed image size, so it might return a larger image
	// size than the image sizes that are returned by DescribeImages.
	ImageSizeInBytes *int64 `locationName:"imageSizeInBytes" type:"long"`

	// The list of tags that's associated with this image.
	ImageTags []*string `locationName:"imageTags" type:"list"`

	// The Amazon Web Services account ID that's associated with the public registry
	// where this image belongs.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository where this image belongs.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageDetail) GoString() string {
	return s.String()
}

// SetArtifactMediaType sets the ArtifactMediaType field's value.
func (s *ImageDetail) SetArtifactMediaType(v string) *ImageDetail {
	s.ArtifactMediaType = &v
	return s
}

// SetImageDigest sets the ImageDigest field's value.
func (s *ImageDetail) SetImageDigest(v string) *ImageDetail {
	s.ImageDigest = &v
	return s
}

// SetImageManifestMediaType sets the ImageManifestMediaType field's value.
func (s *ImageDetail) SetImageManifestMediaType(v string) *ImageDetail {
	s.ImageManifestMediaType = &v
	return s
}

// SetImagePushedAt sets the ImagePushedAt field's value.
func (s *ImageDetail) SetImagePushedAt(v time.Time) *ImageDetail {
	s.ImagePushedAt = &v
	return s
}

// SetImageSizeInBytes sets the ImageSizeInBytes field's value.
func (s *ImageDetail) SetImageSizeInBytes(v int64) *ImageDetail {
	s.ImageSizeInBytes = &v
	return s
}

// SetImageTags sets the ImageTags field's value.
func (s *ImageDetail) SetImageTags(v []*string) *ImageDetail {
	s.ImageTags = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *ImageDetail) SetRegistryId(v string) *ImageDetail {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *ImageDetail) SetRepositoryName(v string) *ImageDetail {
	s.RepositoryName = &v
	return s
}

// The specified image digest doesn't match the digest that Amazon ECR calculated
// for the image.
type ImageDigestDoesNotMatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageDigestDoesNotMatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageDigestDoesNotMatchException) GoString() string {
	return s.String()
}

func newErrorImageDigestDoesNotMatchException(v protocol.ResponseMetadata) error {
	return &ImageDigestDoesNotMatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ImageDigestDoesNotMatchException) Code() string {
	return "ImageDigestDoesNotMatchException"
}

// Message returns the exception's message.
func (s *ImageDigestDoesNotMatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ImageDigestDoesNotMatchException) OrigErr() error {
	return nil
}

func (s *ImageDigestDoesNotMatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ImageDigestDoesNotMatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ImageDigestDoesNotMatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents an Amazon ECR image failure.
type ImageFailure struct {
	_ struct{} `type:"structure"`

	// The code that's associated with the failure.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"ImageFailureCode"`

	// The reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The image ID that's associated with the failure.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *ImageFailure) SetFailureCode(v string) *ImageFailure {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *ImageFailure) SetFailureReason(v string) *ImageFailure {
	s.FailureReason = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *ImageFailure) SetImageId(v *ImageIdentifier) *ImageFailure {
	s.ImageId = v
	return s
}

// An object with identifying information for an Amazon ECR image.
type ImageIdentifier struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The tag that's used for the image.
	ImageTag *string `locationName:"imageTag" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageIdentifier"}
	if s.ImageTag != nil && len(*s.ImageTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageTag", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageDigest sets the ImageDigest field's value.
func (s *ImageIdentifier) SetImageDigest(v string) *ImageIdentifier {
	s.ImageDigest = &v
	return s
}

// SetImageTag sets the ImageTag field's value.
func (s *ImageIdentifier) SetImageTag(v string) *ImageIdentifier {
	s.ImageTag = &v
	return s
}

// The image requested doesn't exist in the specified repository.
type ImageNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageNotFoundException) GoString() string {
	return s.String()
}

func newErrorImageNotFoundException(v protocol.ResponseMetadata) error {
	return &ImageNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ImageNotFoundException) Code() string {
	return "ImageNotFoundException"
}

// Message returns the exception's message.
func (s *ImageNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ImageNotFoundException) OrigErr() error {
	return nil
}

func (s *ImageNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ImageNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ImageNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified image is tagged with a tag that already exists. The repository
// is configured for tag immutability.
type ImageTagAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageTagAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageTagAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorImageTagAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ImageTagAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ImageTagAlreadyExistsException) Code() string {
	return "ImageTagAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ImageTagAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ImageTagAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ImageTagAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ImageTagAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ImageTagAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the image tag details for an image.
type ImageTagDetail struct {
	_ struct{} `type:"structure"`

	// The time stamp that indicates when the image tag was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// An object that describes the details of an image.
	ImageDetail *ReferencedImageDetail `locationName:"imageDetail" type:"structure"`

	// The tag that's associated with the image.
	ImageTag *string `locationName:"imageTag" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageTagDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageTagDetail) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ImageTagDetail) SetCreatedAt(v time.Time) *ImageTagDetail {
	s.CreatedAt = &v
	return s
}

// SetImageDetail sets the ImageDetail field's value.
func (s *ImageTagDetail) SetImageDetail(v *ReferencedImageDetail) *ImageTagDetail {
	s.ImageDetail = v
	return s
}

// SetImageTag sets the ImageTag field's value.
func (s *ImageTagDetail) SetImageTag(v string) *ImageTagDetail {
	s.ImageTag = &v
	return s
}

type InitiateLayerUploadInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID, or registry alias, that's associated
	// with the registry to which you intend to upload layers. If you do not specify
	// a registry, the default public registry is assumed.
	RegistryId *string `locationName:"registryId" min:"2" type:"string"`

	// The name of the repository that you want to upload layers to.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitiateLayerUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitiateLayerUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateLayerUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateLayerUploadInput"}
	if s.RegistryId != nil && len(*s.RegistryId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryId", 2))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryId sets the RegistryId field's value.
func (s *InitiateLayerUploadInput) SetRegistryId(v string) *InitiateLayerUploadInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *InitiateLayerUploadInput) SetRepositoryName(v string) *InitiateLayerUploadInput {
	s.RepositoryName = &v
	return s
}

type InitiateLayerUploadOutput struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, that Amazon ECR expects future layer part uploads to
	// be.
	PartSize *int64 `locationName:"partSize" type:"long"`

	// The upload ID for the layer upload. This parameter is passed to further UploadLayerPart
	// and CompleteLayerUpload operations.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitiateLayerUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitiateLayerUploadOutput) GoString() string {
	return s.String()
}

// SetPartSize sets the PartSize field's value.
func (s *InitiateLayerUploadOutput) SetPartSize(v int64) *InitiateLayerUploadOutput {
	s.PartSize = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *InitiateLayerUploadOutput) SetUploadId(v string) *InitiateLayerUploadOutput {
	s.UploadId = &v
	return s
}

// The layer digest calculation performed by Amazon ECR when the image layer
// doesn't match the digest specified.
type InvalidLayerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLayerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLayerException) GoString() string {
	return s.String()
}

func newErrorInvalidLayerException(v protocol.ResponseMetadata) error {
	return &InvalidLayerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLayerException) Code() string {
	return "InvalidLayerException"
}

// Message returns the exception's message.
func (s *InvalidLayerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLayerException) OrigErr() error {
	return nil
}

func (s *InvalidLayerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLayerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLayerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The layer part size isn't valid, or the first byte specified isn't consecutive
// to the last byte of a previous layer part upload.
type InvalidLayerPartException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The position of the last byte of the layer part.
	LastValidByteReceived *int64 `locationName:"lastValidByteReceived" type:"long"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon Web Services account ID that's associated with the layer part.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The upload ID that's associated with the layer part.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLayerPartException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidLayerPartException) GoString() string {
	return s.String()
}

func newErrorInvalidLayerPartException(v protocol.ResponseMetadata) error {
	return &InvalidLayerPartException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLayerPartException) Code() string {
	return "InvalidLayerPartException"
}

// Message returns the exception's message.
func (s *InvalidLayerPartException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLayerPartException) OrigErr() error {
	return nil
}

func (s *InvalidLayerPartException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLayerPartException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLayerPartException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified parameter is invalid. Review the available parameters for the
// API request.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An invalid parameter has been specified. Tag keys can have a maximum character
// length of 128 characters, and tag values can have a maximum length of 256
// characters.
type InvalidTagParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidTagParameterException(v protocol.ResponseMetadata) error {
	return &InvalidTagParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTagParameterException) Code() string {
	return "InvalidTagParameterException"
}

// Message returns the exception's message.
func (s *InvalidTagParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTagParameterException) OrigErr() error {
	return nil
}

func (s *InvalidTagParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTagParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTagParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents an Amazon ECR image layer.
type Layer struct {
	_ struct{} `type:"structure"`

	// The availability status of the image layer.
	LayerAvailability *string `locationName:"layerAvailability" type:"string" enum:"LayerAvailability"`

	// The sha256 digest of the image layer.
	LayerDigest *string `locationName:"layerDigest" type:"string"`

	// The size, in bytes, of the image layer.
	LayerSize *int64 `locationName:"layerSize" type:"long"`

	// The media type of the layer, such as application/vnd.docker.image.rootfs.diff.tar.gzip
	// or application/vnd.oci.image.layer.v1.tar+gzip.
	MediaType *string `locationName:"mediaType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Layer) GoString() string {
	return s.String()
}

// SetLayerAvailability sets the LayerAvailability field's value.
func (s *Layer) SetLayerAvailability(v string) *Layer {
	s.LayerAvailability = &v
	return s
}

// SetLayerDigest sets the LayerDigest field's value.
func (s *Layer) SetLayerDigest(v string) *Layer {
	s.LayerDigest = &v
	return s
}

// SetLayerSize sets the LayerSize field's value.
func (s *Layer) SetLayerSize(v int64) *Layer {
	s.LayerSize = &v
	return s
}

// SetMediaType sets the MediaType field's value.
func (s *Layer) SetMediaType(v string) *Layer {
	s.MediaType = &v
	return s
}

// The image layer already exists in the associated repository.
type LayerAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayerAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayerAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorLayerAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &LayerAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LayerAlreadyExistsException) Code() string {
	return "LayerAlreadyExistsException"
}

// Message returns the exception's message.
func (s *LayerAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LayerAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *LayerAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LayerAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LayerAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents an Amazon ECR image layer failure.
type LayerFailure struct {
	_ struct{} `type:"structure"`

	// The failure code that's associated with the failure.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"LayerFailureCode"`

	// The reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The layer digest that's associated with the failure.
	LayerDigest *string `locationName:"layerDigest" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayerFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayerFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *LayerFailure) SetFailureCode(v string) *LayerFailure {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *LayerFailure) SetFailureReason(v string) *LayerFailure {
	s.FailureReason = &v
	return s
}

// SetLayerDigest sets the LayerDigest field's value.
func (s *LayerFailure) SetLayerDigest(v string) *LayerFailure {
	s.LayerDigest = &v
	return s
}

// Layer parts must be at least 5 MiB in size.
type LayerPartTooSmallException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayerPartTooSmallException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayerPartTooSmallException) GoString() string {
	return s.String()
}

func newErrorLayerPartTooSmallException(v protocol.ResponseMetadata) error {
	return &LayerPartTooSmallException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LayerPartTooSmallException) Code() string {
	return "LayerPartTooSmallException"
}

// Message returns the exception's message.
func (s *LayerPartTooSmallException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LayerPartTooSmallException) OrigErr() error {
	return nil
}

func (s *LayerPartTooSmallException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LayerPartTooSmallException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LayerPartTooSmallException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified layers can't be found, or the specified layer isn't valid for
// this repository.
type LayersNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayersNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayersNotFoundException) GoString() string {
	return s.String()
}

func newErrorLayersNotFoundException(v protocol.ResponseMetadata) error {
	return &LayersNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LayersNotFoundException) Code() string {
	return "LayersNotFoundException"
}

// Message returns the exception's message.
func (s *LayersNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LayersNotFoundException) OrigErr() error {
	return nil
}

func (s *LayersNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LayersNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LayersNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation didn't succeed because it would have exceeded a service limit
// for your account. For more information, see Amazon ECR Service Quotas (https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html)
// in the Amazon Elastic Container Registry User Guide.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the resource to list the tags
	// for. Currently, the supported resource is an Amazon ECR Public repository.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type PutImageInput struct {
	_ struct{} `type:"structure"`

	// The image digest of the image manifest that corresponds to the image.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The image manifest that corresponds to the image to be uploaded.
	//
	// ImageManifest is a required field
	ImageManifest *string `locationName:"imageManifest" min:"1" type:"string" required:"true"`

	// The media type of the image manifest. If you push an image manifest that
	// doesn't contain the mediaType field, you must specify the imageManifestMediaType
	// in the request.
	ImageManifestMediaType *string `locationName:"imageManifestMediaType" type:"string"`

	// The tag to associate with the image. This parameter is required for images
	// that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative
	// (OCI) formats.
	ImageTag *string `locationName:"imageTag" min:"1" type:"string"`

	// The Amazon Web Services account ID, or registry alias, that's associated
	// with the public registry that contains the repository where the image is
	// put. If you do not specify a registry, the default public registry is assumed.
	RegistryId *string `locationName:"registryId" min:"2" type:"string"`

	// The name of the repository where the image is put.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutImageInput"}
	if s.ImageManifest == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageManifest"))
	}
	if s.ImageManifest != nil && len(*s.ImageManifest) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageManifest", 1))
	}
	if s.ImageTag != nil && len(*s.ImageTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageTag", 1))
	}
	if s.RegistryId != nil && len(*s.RegistryId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryId", 2))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageDigest sets the ImageDigest field's value.
func (s *PutImageInput) SetImageDigest(v string) *PutImageInput {
	s.ImageDigest = &v
	return s
}

// SetImageManifest sets the ImageManifest field's value.
func (s *PutImageInput) SetImageManifest(v string) *PutImageInput {
	s.ImageManifest = &v
	return s
}

// SetImageManifestMediaType sets the ImageManifestMediaType field's value.
func (s *PutImageInput) SetImageManifestMediaType(v string) *PutImageInput {
	s.ImageManifestMediaType = &v
	return s
}

// SetImageTag sets the ImageTag field's value.
func (s *PutImageInput) SetImageTag(v string) *PutImageInput {
	s.ImageTag = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *PutImageInput) SetRegistryId(v string) *PutImageInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PutImageInput) SetRepositoryName(v string) *PutImageInput {
	s.RepositoryName = &v
	return s
}

type PutImageOutput struct {
	_ struct{} `type:"structure"`

	// Details of the image uploaded.
	Image *Image `locationName:"image" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutImageOutput) GoString() string {
	return s.String()
}

// SetImage sets the Image field's value.
func (s *PutImageOutput) SetImage(v *Image) *PutImageOutput {
	s.Image = v
	return s
}

type PutRegistryCatalogDataInput struct {
	_ struct{} `type:"structure"`

	// The display name for a public registry. The display name is shown as the
	// repository author in the Amazon ECR Public Gallery.
	//
	// The registry display name is only publicly visible in the Amazon ECR Public
	// Gallery for verified accounts.
	DisplayName *string `locationName:"displayName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRegistryCatalogDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRegistryCatalogDataInput) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *PutRegistryCatalogDataInput) SetDisplayName(v string) *PutRegistryCatalogDataInput {
	s.DisplayName = &v
	return s
}

type PutRegistryCatalogDataOutput struct {
	_ struct{} `type:"structure"`

	// The catalog data for the public registry.
	//
	// RegistryCatalogData is a required field
	RegistryCatalogData *RegistryCatalogData `locationName:"registryCatalogData" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRegistryCatalogDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRegistryCatalogDataOutput) GoString() string {
	return s.String()
}

// SetRegistryCatalogData sets the RegistryCatalogData field's value.
func (s *PutRegistryCatalogDataOutput) SetRegistryCatalogData(v *RegistryCatalogData) *PutRegistryCatalogDataOutput {
	s.RegistryCatalogData = v
	return s
}

type PutRepositoryCatalogDataInput struct {
	_ struct{} `type:"structure"`

	// An object containing the catalog data for a repository. This data is publicly
	// visible in the Amazon ECR Public Gallery.
	//
	// CatalogData is a required field
	CatalogData *RepositoryCatalogDataInput `locationName:"catalogData" type:"structure" required:"true"`

	// The Amazon Web Services account ID that's associated with the public registry
	// the repository is in. If you do not specify a registry, the default public
	// registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to create or update the catalog data for.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRepositoryCatalogDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRepositoryCatalogDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRepositoryCatalogDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRepositoryCatalogDataInput"}
	if s.CatalogData == nil {
		invalidParams.Add(request.NewErrParamRequired("CatalogData"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogData sets the CatalogData field's value.
func (s *PutRepositoryCatalogDataInput) SetCatalogData(v *RepositoryCatalogDataInput) *PutRepositoryCatalogDataInput {
	s.CatalogData = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *PutRepositoryCatalogDataInput) SetRegistryId(v string) *PutRepositoryCatalogDataInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PutRepositoryCatalogDataInput) SetRepositoryName(v string) *PutRepositoryCatalogDataInput {
	s.RepositoryName = &v
	return s
}

type PutRepositoryCatalogDataOutput struct {
	_ struct{} `type:"structure"`

	// The catalog data for the repository.
	CatalogData *RepositoryCatalogData `locationName:"catalogData" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRepositoryCatalogDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRepositoryCatalogDataOutput) GoString() string {
	return s.String()
}

// SetCatalogData sets the CatalogData field's value.
func (s *PutRepositoryCatalogDataOutput) SetCatalogData(v *RepositoryCatalogData) *PutRepositoryCatalogDataOutput {
	s.CatalogData = v
	return s
}

// An object that describes the image tag details that are returned by a DescribeImageTags
// action.
type ReferencedImageDetail struct {
	_ struct{} `type:"structure"`

	// The artifact media type of the image.
	ArtifactMediaType *string `locationName:"artifactMediaType" type:"string"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The media type of the image manifest.
	ImageManifestMediaType *string `locationName:"imageManifestMediaType" type:"string"`

	// The date and time, expressed in standard JavaScript date format, which the
	// current image tag was pushed to the repository at.
	ImagePushedAt *time.Time `locationName:"imagePushedAt" type:"timestamp"`

	// The size, in bytes, of the image in the repository.
	//
	// If the image is a manifest list, this is the max size of all manifests in
	// the list.
	//
	// Beginning with Docker version 1.9, the Docker client compresses image layers
	// before pushing them to a V2 Docker registry. The output of the docker images
	// command shows the uncompressed image size, so it might return a larger image
	// size than the image sizes that are returned by DescribeImages.
	ImageSizeInBytes *int64 `locationName:"imageSizeInBytes" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferencedImageDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferencedImageDetail) GoString() string {
	return s.String()
}

// SetArtifactMediaType sets the ArtifactMediaType field's value.
func (s *ReferencedImageDetail) SetArtifactMediaType(v string) *ReferencedImageDetail {
	s.ArtifactMediaType = &v
	return s
}

// SetImageDigest sets the ImageDigest field's value.
func (s *ReferencedImageDetail) SetImageDigest(v string) *ReferencedImageDetail {
	s.ImageDigest = &v
	return s
}

// SetImageManifestMediaType sets the ImageManifestMediaType field's value.
func (s *ReferencedImageDetail) SetImageManifestMediaType(v string) *ReferencedImageDetail {
	s.ImageManifestMediaType = &v
	return s
}

// SetImagePushedAt sets the ImagePushedAt field's value.
func (s *ReferencedImageDetail) SetImagePushedAt(v time.Time) *ReferencedImageDetail {
	s.ImagePushedAt = &v
	return s
}

// SetImageSizeInBytes sets the ImageSizeInBytes field's value.
func (s *ReferencedImageDetail) SetImageSizeInBytes(v int64) *ReferencedImageDetail {
	s.ImageSizeInBytes = &v
	return s
}

// The manifest list is referencing an image that doesn't exist.
type ReferencedImagesNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferencedImagesNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferencedImagesNotFoundException) GoString() string {
	return s.String()
}

func newErrorReferencedImagesNotFoundException(v protocol.ResponseMetadata) error {
	return &ReferencedImagesNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReferencedImagesNotFoundException) Code() string {
	return "ReferencedImagesNotFoundException"
}

// Message returns the exception's message.
func (s *ReferencedImagesNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReferencedImagesNotFoundException) OrigErr() error {
	return nil
}

func (s *ReferencedImagesNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReferencedImagesNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReferencedImagesNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of a public registry.
type Registry struct {
	_ struct{} `type:"structure"`

	// An array of objects that represents the aliases for a public registry.
	//
	// Aliases is a required field
	Aliases []*RegistryAlias `locationName:"aliases" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the public registry.
	//
	// RegistryArn is a required field
	RegistryArn *string `locationName:"registryArn" min:"1" type:"string" required:"true"`

	// The Amazon Web Services account ID that's associated with the registry. If
	// you do not specify a registry, the default public registry is assumed.
	//
	// RegistryId is a required field
	RegistryId *string `locationName:"registryId" type:"string" required:"true"`

	// The URI of a public registry. The URI contains a universal prefix and the
	// registry alias.
	//
	// RegistryUri is a required field
	RegistryUri *string `locationName:"registryUri" type:"string" required:"true"`

	// Indicates whether the account is a verified Amazon Web Services Marketplace
	// vendor. If an account is verified, each public repository receives a verified
	// account badge on the Amazon ECR Public Gallery.
	//
	// Verified is a required field
	Verified *bool `locationName:"verified" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Registry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Registry) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *Registry) SetAliases(v []*RegistryAlias) *Registry {
	s.Aliases = v
	return s
}

// SetRegistryArn sets the RegistryArn field's value.
func (s *Registry) SetRegistryArn(v string) *Registry {
	s.RegistryArn = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *Registry) SetRegistryId(v string) *Registry {
	s.RegistryId = &v
	return s
}

// SetRegistryUri sets the RegistryUri field's value.
func (s *Registry) SetRegistryUri(v string) *Registry {
	s.RegistryUri = &v
	return s
}

// SetVerified sets the Verified field's value.
func (s *Registry) SetVerified(v bool) *Registry {
	s.Verified = &v
	return s
}

// An object representing the aliases for a public registry. A public registry
// is given an alias when it's created. However, a custom alias can be set using
// the Amazon ECR console. For more information, see Registries (https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html)
// in the Amazon Elastic Container Registry User Guide.
type RegistryAlias struct {
	_ struct{} `type:"structure"`

	// Indicates whether the registry alias is the default alias for the registry.
	// When the first public repository is created, your public registry is assigned
	// a default registry alias.
	//
	// DefaultRegistryAlias is a required field
	DefaultRegistryAlias *bool `locationName:"defaultRegistryAlias" type:"boolean" required:"true"`

	// The name of the registry alias.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"2" type:"string" required:"true"`

	// Indicates whether the registry alias is the primary alias for the registry.
	// If true, the alias is the primary registry alias and is displayed in both
	// the repository URL and the image URI used in the docker pull commands on
	// the Amazon ECR Public Gallery.
	//
	// A registry alias that isn't the primary registry alias can be used in the
	// repository URI in a docker pull command.
	//
	// PrimaryRegistryAlias is a required field
	PrimaryRegistryAlias *bool `locationName:"primaryRegistryAlias" type:"boolean" required:"true"`

	// The status of the registry alias.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RegistryAliasStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistryAlias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistryAlias) GoString() string {
	return s.String()
}

// SetDefaultRegistryAlias sets the DefaultRegistryAlias field's value.
func (s *RegistryAlias) SetDefaultRegistryAlias(v bool) *RegistryAlias {
	s.DefaultRegistryAlias = &v
	return s
}

// SetName sets the Name field's value.
func (s *RegistryAlias) SetName(v string) *RegistryAlias {
	s.Name = &v
	return s
}

// SetPrimaryRegistryAlias sets the PrimaryRegistryAlias field's value.
func (s *RegistryAlias) SetPrimaryRegistryAlias(v bool) *RegistryAlias {
	s.PrimaryRegistryAlias = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RegistryAlias) SetStatus(v string) *RegistryAlias {
	s.Status = &v
	return s
}

// The metadata for a public registry.
type RegistryCatalogData struct {
	_ struct{} `type:"structure"`

	// The display name for a public registry. This appears on the Amazon ECR Public
	// Gallery.
	//
	// Only accounts that have the verified account badge can have a registry display
	// name.
	DisplayName *string `locationName:"displayName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistryCatalogData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistryCatalogData) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *RegistryCatalogData) SetDisplayName(v string) *RegistryCatalogData {
	s.DisplayName = &v
	return s
}

// The registry doesn't exist.
type RegistryNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistryNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistryNotFoundException) GoString() string {
	return s.String()
}

func newErrorRegistryNotFoundException(v protocol.ResponseMetadata) error {
	return &RegistryNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RegistryNotFoundException) Code() string {
	return "RegistryNotFoundException"
}

// Message returns the exception's message.
func (s *RegistryNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RegistryNotFoundException) OrigErr() error {
	return nil
}

func (s *RegistryNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RegistryNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RegistryNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing a repository.
type Repository struct {
	_ struct{} `type:"structure"`

	// The date and time, in JavaScript date format, when the repository was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Web Services account ID that's associated with the public registry
	// that contains the repository.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the repository. The ARN contains
	// the arn:aws:ecr namespace, followed by the region of the repository, Amazon
	// Web Services account ID of the repository owner, repository namespace, and
	// repository name. For example, arn:aws:ecr:region:012345678910:repository/test.
	RepositoryArn *string `locationName:"repositoryArn" min:"1" type:"string"`

	// The name of the repository.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The URI for the repository. You can use this URI for container image push
	// and pull operations.
	RepositoryUri *string `locationName:"repositoryUri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Repository) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Repository) SetCreatedAt(v time.Time) *Repository {
	s.CreatedAt = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *Repository) SetRegistryId(v string) *Repository {
	s.RegistryId = &v
	return s
}

// SetRepositoryArn sets the RepositoryArn field's value.
func (s *Repository) SetRepositoryArn(v string) *Repository {
	s.RepositoryArn = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *Repository) SetRepositoryName(v string) *Repository {
	s.RepositoryName = &v
	return s
}

// SetRepositoryUri sets the RepositoryUri field's value.
func (s *Repository) SetRepositoryUri(v string) *Repository {
	s.RepositoryUri = &v
	return s
}

// The specified repository already exists in the specified registry.
type RepositoryAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorRepositoryAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &RepositoryAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RepositoryAlreadyExistsException) Code() string {
	return "RepositoryAlreadyExistsException"
}

// Message returns the exception's message.
func (s *RepositoryAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RepositoryAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *RepositoryAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RepositoryAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RepositoryAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The catalog data for a repository. This data is publicly visible in the Amazon
// ECR Public Gallery.
type RepositoryCatalogData struct {
	_ struct{} `type:"structure"`

	// The longform description of the contents of the repository. This text appears
	// in the repository details on the Amazon ECR Public Gallery.
	AboutText *string `locationName:"aboutText" type:"string"`

	// The architecture tags that are associated with the repository.
	//
	// Only supported operating system tags appear publicly in the Amazon ECR Public
	// Gallery. For more information, see RepositoryCatalogDataInput.
	Architectures []*string `locationName:"architectures" type:"list"`

	// The short description of the repository.
	Description *string `locationName:"description" type:"string"`

	// The URL that contains the logo that's associated with the repository.
	LogoUrl *string `locationName:"logoUrl" type:"string"`

	// Indicates whether the repository is certified by Amazon Web Services Marketplace.
	MarketplaceCertified *bool `locationName:"marketplaceCertified" type:"boolean"`

	// The operating system tags that are associated with the repository.
	//
	// Only supported operating system tags appear publicly in the Amazon ECR Public
	// Gallery. For more information, see RepositoryCatalogDataInput.
	OperatingSystems []*string `locationName:"operatingSystems" type:"list"`

	// The longform usage details of the contents of the repository. The usage text
	// provides context for users of the repository.
	UsageText *string `locationName:"usageText" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCatalogData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCatalogData) GoString() string {
	return s.String()
}

// SetAboutText sets the AboutText field's value.
func (s *RepositoryCatalogData) SetAboutText(v string) *RepositoryCatalogData {
	s.AboutText = &v
	return s
}

// SetArchitectures sets the Architectures field's value.
func (s *RepositoryCatalogData) SetArchitectures(v []*string) *RepositoryCatalogData {
	s.Architectures = v
	return s
}

// SetDescription sets the Description field's value.
func (s *RepositoryCatalogData) SetDescription(v string) *RepositoryCatalogData {
	s.Description = &v
	return s
}

// SetLogoUrl sets the LogoUrl field's value.
func (s *RepositoryCatalogData) SetLogoUrl(v string) *RepositoryCatalogData {
	s.LogoUrl = &v
	return s
}

// SetMarketplaceCertified sets the MarketplaceCertified field's value.
func (s *RepositoryCatalogData) SetMarketplaceCertified(v bool) *RepositoryCatalogData {
	s.MarketplaceCertified = &v
	return s
}

// SetOperatingSystems sets the OperatingSystems field's value.
func (s *RepositoryCatalogData) SetOperatingSystems(v []*string) *RepositoryCatalogData {
	s.OperatingSystems = v
	return s
}

// SetUsageText sets the UsageText field's value.
func (s *RepositoryCatalogData) SetUsageText(v string) *RepositoryCatalogData {
	s.UsageText = &v
	return s
}

// An object that contains the catalog data for a repository. This data is publicly
// visible in the Amazon ECR Public Gallery.
type RepositoryCatalogDataInput struct {
	_ struct{} `type:"structure"`

	// A detailed description of the contents of the repository. It's publicly visible
	// in the Amazon ECR Public Gallery. The text must be in markdown format.
	AboutText *string `locationName:"aboutText" type:"string"`

	// The system architecture that the images in the repository are compatible
	// with. On the Amazon ECR Public Gallery, the following supported architectures
	// appear as badges on the repository and are used as search filters.
	//
	// If an unsupported tag is added to your repository catalog data, it's associated
	// with the repository and can be retrieved using the API but isn't discoverable
	// in the Amazon ECR Public Gallery.
	//
	//    * ARM
	//
	//    * ARM 64
	//
	//    * x86
	//
	//    * x86-64
	Architectures []*string `locationName:"architectures" type:"list"`

	// A short description of the contents of the repository. This text appears
	// in both the image details and also when searching for repositories on the
	// Amazon ECR Public Gallery.
	Description *string `locationName:"description" type:"string"`

	// The base64-encoded repository logo payload.
	//
	// The repository logo is only publicly visible in the Amazon ECR Public Gallery
	// for verified accounts.
	// LogoImageBlob is automatically base64 encoded/decoded by the SDK.
	LogoImageBlob []byte `locationName:"logoImageBlob" type:"blob"`

	// The operating systems that the images in the repository are compatible with.
	// On the Amazon ECR Public Gallery, the following supported operating systems
	// appear as badges on the repository and are used as search filters.
	//
	// If an unsupported tag is added to your repository catalog data, it's associated
	// with the repository and can be retrieved using the API but isn't discoverable
	// in the Amazon ECR Public Gallery.
	//
	//    * Linux
	//
	//    * Windows
	OperatingSystems []*string `locationName:"operatingSystems" type:"list"`

	// Detailed information about how to use the contents of the repository. It's
	// publicly visible in the Amazon ECR Public Gallery. The usage text provides
	// context, support information, and additional usage details for users of the
	// repository. The text must be in markdown format.
	UsageText *string `locationName:"usageText" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCatalogDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCatalogDataInput) GoString() string {
	return s.String()
}

// SetAboutText sets the AboutText field's value.
func (s *RepositoryCatalogDataInput) SetAboutText(v string) *RepositoryCatalogDataInput {
	s.AboutText = &v
	return s
}

// SetArchitectures sets the Architectures field's value.
func (s *RepositoryCatalogDataInput) SetArchitectures(v []*string) *RepositoryCatalogDataInput {
	s.Architectures = v
	return s
}

// SetDescription sets the Description field's value.
func (s *RepositoryCatalogDataInput) SetDescription(v string) *RepositoryCatalogDataInput {
	s.Description = &v
	return s
}

// SetLogoImageBlob sets the LogoImageBlob field's value.
func (s *RepositoryCatalogDataInput) SetLogoImageBlob(v []byte) *RepositoryCatalogDataInput {
	s.LogoImageBlob = v
	return s
}

// SetOperatingSystems sets the OperatingSystems field's value.
func (s *RepositoryCatalogDataInput) SetOperatingSystems(v []*string) *RepositoryCatalogDataInput {
	s.OperatingSystems = v
	return s
}

// SetUsageText sets the UsageText field's value.
func (s *RepositoryCatalogDataInput) SetUsageText(v string) *RepositoryCatalogDataInput {
	s.UsageText = &v
	return s
}

// The repository catalog data doesn't exist.
type RepositoryCatalogDataNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCatalogDataNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryCatalogDataNotFoundException) GoString() string {
	return s.String()
}

func newErrorRepositoryCatalogDataNotFoundException(v protocol.ResponseMetadata) error {
	return &RepositoryCatalogDataNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RepositoryCatalogDataNotFoundException) Code() string {
	return "RepositoryCatalogDataNotFoundException"
}

// Message returns the exception's message.
func (s *RepositoryCatalogDataNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RepositoryCatalogDataNotFoundException) OrigErr() error {
	return nil
}

func (s *RepositoryCatalogDataNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RepositoryCatalogDataNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RepositoryCatalogDataNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified repository contains images. To delete a repository that contains
// images, you must force the deletion with the force parameter.
type RepositoryNotEmptyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryNotEmptyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryNotEmptyException) GoString() string {
	return s.String()
}

func newErrorRepositoryNotEmptyException(v protocol.ResponseMetadata) error {
	return &RepositoryNotEmptyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RepositoryNotEmptyException) Code() string {
	return "RepositoryNotEmptyException"
}

// Message returns the exception's message.
func (s *RepositoryNotEmptyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RepositoryNotEmptyException) OrigErr() error {
	return nil
}

func (s *RepositoryNotEmptyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RepositoryNotEmptyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RepositoryNotEmptyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified repository can't be found. Check the spelling of the specified
// repository and ensure that you're performing operations on the correct registry.
type RepositoryNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryNotFoundException) GoString() string {
	return s.String()
}

func newErrorRepositoryNotFoundException(v protocol.ResponseMetadata) error {
	return &RepositoryNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RepositoryNotFoundException) Code() string {
	return "RepositoryNotFoundException"
}

// Message returns the exception's message.
func (s *RepositoryNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RepositoryNotFoundException) OrigErr() error {
	return nil
}

func (s *RepositoryNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RepositoryNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RepositoryNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified repository and registry combination doesn't have an associated
// repository policy.
type RepositoryPolicyNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryPolicyNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryPolicyNotFoundException) GoString() string {
	return s.String()
}

func newErrorRepositoryPolicyNotFoundException(v protocol.ResponseMetadata) error {
	return &RepositoryPolicyNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RepositoryPolicyNotFoundException) Code() string {
	return "RepositoryPolicyNotFoundException"
}

// Message returns the exception's message.
func (s *RepositoryPolicyNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RepositoryPolicyNotFoundException) OrigErr() error {
	return nil
}

func (s *RepositoryPolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RepositoryPolicyNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RepositoryPolicyNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// These errors are usually caused by a server-side issue.
type ServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) GoString() string {
	return s.String()
}

func newErrorServerException(v protocol.ResponseMetadata) error {
	return &ServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerException) Code() string {
	return "ServerException"
}

// Message returns the exception's message.
func (s *ServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerException) OrigErr() error {
	return nil
}

func (s *ServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SetRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// If the policy that you want to set on a repository policy would prevent you
	// from setting another policy in the future, you must force the SetRepositoryPolicy
	// operation. This prevents accidental repository lockouts.
	Force *bool `locationName:"force" type:"boolean"`

	// The JSON repository policy text to apply to the repository. For more information,
	// see Amazon ECR Repository Policies (https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html)
	// in the Amazon Elastic Container Registry User Guide.
	//
	// PolicyText is a required field
	PolicyText *string `locationName:"policyText" type:"string" required:"true"`

	// The Amazon Web Services account ID that's associated with the registry that
	// contains the repository. If you do not specify a registry, the default public
	// registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to receive the policy.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetRepositoryPolicyInput"}
	if s.PolicyText == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyText"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *SetRepositoryPolicyInput) SetForce(v bool) *SetRepositoryPolicyInput {
	s.Force = &v
	return s
}

// SetPolicyText sets the PolicyText field's value.
func (s *SetRepositoryPolicyInput) SetPolicyText(v string) *SetRepositoryPolicyInput {
	s.PolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *SetRepositoryPolicyInput) SetRegistryId(v string) *SetRepositoryPolicyInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *SetRepositoryPolicyInput) SetRepositoryName(v string) *SetRepositoryPolicyInput {
	s.RepositoryName = &v
	return s
}

type SetRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy text that's applied to the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID that's associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name that's associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetRepositoryPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyText sets the PolicyText field's value.
func (s *SetRepositoryPolicyOutput) SetPolicyText(v string) *SetRepositoryPolicyOutput {
	s.PolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *SetRepositoryPolicyOutput) SetRegistryId(v string) *SetRepositoryPolicyOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *SetRepositoryPolicyOutput) SetRepositoryName(v string) *SetRepositoryPolicyOutput {
	s.RepositoryName = &v
	return s
}

// The metadata that you apply to a resource to help you categorize and organize
// them. Each tag consists of a key and an optional value. You define both.
// Tag keys can have a maximum character length of 128 characters, and tag values
// can have a maximum length of 256 characters.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string `min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to add tags to. Currently,
	// the supported resource is an Amazon ECR Public repository.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags to add to the resource. A tag is an array of key-value pairs. Tag
	// keys can have a maximum character length of 128 characters, and tag values
	// can have a maximum length of 256 characters.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The list of tags on the repository is over the limit. The maximum number
// of tags that can be applied to a repository is 50.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The action isn't supported in this Region.
type UnsupportedCommandException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedCommandException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedCommandException) GoString() string {
	return s.String()
}

func newErrorUnsupportedCommandException(v protocol.ResponseMetadata) error {
	return &UnsupportedCommandException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedCommandException) Code() string {
	return "UnsupportedCommandException"
}

// Message returns the exception's message.
func (s *UnsupportedCommandException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedCommandException) OrigErr() error {
	return nil
}

func (s *UnsupportedCommandException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedCommandException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedCommandException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to delete tags from. Currently,
	// the supported resource is an Amazon ECR Public repository.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UploadLayerPartInput struct {
	_ struct{} `type:"structure"`

	// The base64-encoded layer part payload.
	// LayerPartBlob is automatically base64 encoded/decoded by the SDK.
	//
	// LayerPartBlob is a required field
	LayerPartBlob []byte `locationName:"layerPartBlob" type:"blob" required:"true"`

	// The position of the first byte of the layer part witin the overall image
	// layer.
	//
	// PartFirstByte is a required field
	PartFirstByte *int64 `locationName:"partFirstByte" type:"long" required:"true"`

	// The position of the last byte of the layer part within the overall image
	// layer.
	//
	// PartLastByte is a required field
	PartLastByte *int64 `locationName:"partLastByte" type:"long" required:"true"`

	// The Amazon Web Services account ID, or registry alias, that's associated
	// with the registry that you're uploading layer parts to. If you do not specify
	// a registry, the default public registry is assumed.
	RegistryId *string `locationName:"registryId" min:"2" type:"string"`

	// The name of the repository that you're uploading layer parts to.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`

	// The upload ID from a previous InitiateLayerUpload operation to associate
	// with the layer part upload.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadLayerPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadLayerPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadLayerPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadLayerPartInput"}
	if s.LayerPartBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerPartBlob"))
	}
	if s.PartFirstByte == nil {
		invalidParams.Add(request.NewErrParamRequired("PartFirstByte"))
	}
	if s.PartLastByte == nil {
		invalidParams.Add(request.NewErrParamRequired("PartLastByte"))
	}
	if s.RegistryId != nil && len(*s.RegistryId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryId", 2))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerPartBlob sets the LayerPartBlob field's value.
func (s *UploadLayerPartInput) SetLayerPartBlob(v []byte) *UploadLayerPartInput {
	s.LayerPartBlob = v
	return s
}

// SetPartFirstByte sets the PartFirstByte field's value.
func (s *UploadLayerPartInput) SetPartFirstByte(v int64) *UploadLayerPartInput {
	s.PartFirstByte = &v
	return s
}

// SetPartLastByte sets the PartLastByte field's value.
func (s *UploadLayerPartInput) SetPartLastByte(v int64) *UploadLayerPartInput {
	s.PartLastByte = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *UploadLayerPartInput) SetRegistryId(v string) *UploadLayerPartInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UploadLayerPartInput) SetRepositoryName(v string) *UploadLayerPartInput {
	s.RepositoryName = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadLayerPartInput) SetUploadId(v string) *UploadLayerPartInput {
	s.UploadId = &v
	return s
}

type UploadLayerPartOutput struct {
	_ struct{} `type:"structure"`

	// The integer value of the last byte that's received in the request.
	LastByteReceived *int64 `locationName:"lastByteReceived" type:"long"`

	// The registry ID that's associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name that's associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The upload ID that's associated with the request.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadLayerPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadLayerPartOutput) GoString() string {
	return s.String()
}

// SetLastByteReceived sets the LastByteReceived field's value.
func (s *UploadLayerPartOutput) SetLastByteReceived(v int64) *UploadLayerPartOutput {
	s.LastByteReceived = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *UploadLayerPartOutput) SetRegistryId(v string) *UploadLayerPartOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UploadLayerPartOutput) SetRepositoryName(v string) *UploadLayerPartOutput {
	s.RepositoryName = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadLayerPartOutput) SetUploadId(v string) *UploadLayerPartOutput {
	s.UploadId = &v
	return s
}

// The upload can't be found, or the specified upload ID isn't valid for this
// repository.
type UploadNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UploadNotFoundException) GoString() string {
	return s.String()
}

func newErrorUploadNotFoundException(v protocol.ResponseMetadata) error {
	return &UploadNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UploadNotFoundException) Code() string {
	return "UploadNotFoundException"
}

// Message returns the exception's message.
func (s *UploadNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UploadNotFoundException) OrigErr() error {
	return nil
}

func (s *UploadNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UploadNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UploadNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ImageFailureCodeInvalidImageDigest is a ImageFailureCode enum value
	ImageFailureCodeInvalidImageDigest = "InvalidImageDigest"

	// ImageFailureCodeInvalidImageTag is a ImageFailureCode enum value
	ImageFailureCodeInvalidImageTag = "InvalidImageTag"

	// ImageFailureCodeImageTagDoesNotMatchDigest is a ImageFailureCode enum value
	ImageFailureCodeImageTagDoesNotMatchDigest = "ImageTagDoesNotMatchDigest"

	// ImageFailureCodeImageNotFound is a ImageFailureCode enum value
	ImageFailureCodeImageNotFound = "ImageNotFound"

	// ImageFailureCodeMissingDigestAndTag is a ImageFailureCode enum value
	ImageFailureCodeMissingDigestAndTag = "MissingDigestAndTag"

	// ImageFailureCodeImageReferencedByManifestList is a ImageFailureCode enum value
	ImageFailureCodeImageReferencedByManifestList = "ImageReferencedByManifestList"

	// ImageFailureCodeKmsError is a ImageFailureCode enum value
	ImageFailureCodeKmsError = "KmsError"
)

// ImageFailureCode_Values returns all elements of the ImageFailureCode enum
func ImageFailureCode_Values() []string {
	return []string{
		ImageFailureCodeInvalidImageDigest,
		ImageFailureCodeInvalidImageTag,
		ImageFailureCodeImageTagDoesNotMatchDigest,
		ImageFailureCodeImageNotFound,
		ImageFailureCodeMissingDigestAndTag,
		ImageFailureCodeImageReferencedByManifestList,
		ImageFailureCodeKmsError,
	}
}

const (
	// LayerAvailabilityAvailable is a LayerAvailability enum value
	LayerAvailabilityAvailable = "AVAILABLE"

	// LayerAvailabilityUnavailable is a LayerAvailability enum value
	LayerAvailabilityUnavailable = "UNAVAILABLE"
)

// LayerAvailability_Values returns all elements of the LayerAvailability enum
func LayerAvailability_Values() []string {
	return []string{
		LayerAvailabilityAvailable,
		LayerAvailabilityUnavailable,
	}
}

const (
	// LayerFailureCodeInvalidLayerDigest is a LayerFailureCode enum value
	LayerFailureCodeInvalidLayerDigest = "InvalidLayerDigest"

	// LayerFailureCodeMissingLayerDigest is a LayerFailureCode enum value
	LayerFailureCodeMissingLayerDigest = "MissingLayerDigest"
)

// LayerFailureCode_Values returns all elements of the LayerFailureCode enum
func LayerFailureCode_Values() []string {
	return []string{
		LayerFailureCodeInvalidLayerDigest,
		LayerFailureCodeMissingLayerDigest,
	}
}

const (
	// RegistryAliasStatusActive is a RegistryAliasStatus enum value
	RegistryAliasStatusActive = "ACTIVE"

	// RegistryAliasStatusPending is a RegistryAliasStatus enum value
	RegistryAliasStatusPending = "PENDING"

	// RegistryAliasStatusRejected is a RegistryAliasStatus enum value
	RegistryAliasStatusRejected = "REJECTED"
)

// RegistryAliasStatus_Values returns all elements of the RegistryAliasStatus enum
func RegistryAliasStatus_Values() []string {
	return []string{
		RegistryAliasStatusActive,
		RegistryAliasStatusPending,
		RegistryAliasStatusRejected,
	}
}
