// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package timestreamquery

import (
	"fmt"
	"net/url"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/crr"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCancelQuery = "CancelQuery"

// CancelQueryRequest generates a "aws/request.Request" representing the
// client's request for the CancelQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelQuery for more information on using the CancelQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelQueryRequest method.
//    req, resp := client.CancelQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/CancelQuery
func (c *TimestreamQuery) CancelQueryRequest(input *CancelQueryInput) (req *request.Request, output *CancelQueryOutput) {
	op := &request.Operation{
		Name:       opCancelQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelQueryInput{}
	}

	output = &CancelQueryOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CancelQuery API operation for Amazon Timestream Query.
//
// Cancels a query that has been issued. Cancellation is provided only if the
// query has not completed running before the cancellation request was issued.
// Because cancellation is an idempotent operation, subsequent cancellation
// requests will return a CancellationMessage, indicating that the query has
// already been canceled. See code sample (https://docs.aws.amazon.com/Timestream/latest/developerguide/code-samples.cancel-query.html)
// for details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation CancelQuery for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/CancelQuery
func (c *TimestreamQuery) CancelQuery(input *CancelQueryInput) (*CancelQueryOutput, error) {
	req, out := c.CancelQueryRequest(input)
	return out, req.Send()
}

// CancelQueryWithContext is the same as CancelQuery with the addition of
// the ability to pass a context and additional request options.
//
// See CancelQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) CancelQueryWithContext(ctx aws.Context, input *CancelQueryInput, opts ...request.Option) (*CancelQueryOutput, error) {
	req, out := c.CancelQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScheduledQuery = "CreateScheduledQuery"

// CreateScheduledQueryRequest generates a "aws/request.Request" representing the
// client's request for the CreateScheduledQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScheduledQuery for more information on using the CreateScheduledQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScheduledQueryRequest method.
//    req, resp := client.CreateScheduledQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/CreateScheduledQuery
func (c *TimestreamQuery) CreateScheduledQueryRequest(input *CreateScheduledQueryInput) (req *request.Request, output *CreateScheduledQueryOutput) {
	op := &request.Operation{
		Name:       opCreateScheduledQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScheduledQueryInput{}
	}

	output = &CreateScheduledQueryOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// CreateScheduledQuery API operation for Amazon Timestream Query.
//
// Create a scheduled query that will be run on your behalf at the configured
// schedule. Timestream assumes the execution role provided as part of the ScheduledQueryExecutionRoleArn
// parameter to run the query. You can use the NotificationConfiguration parameter
// to configure notification for your scheduled query operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation CreateScheduledQuery for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * ConflictException
//   Unable to poll results for a cancelled query.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ServiceQuotaExceededException
//   You have exceeded the service quota.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/CreateScheduledQuery
func (c *TimestreamQuery) CreateScheduledQuery(input *CreateScheduledQueryInput) (*CreateScheduledQueryOutput, error) {
	req, out := c.CreateScheduledQueryRequest(input)
	return out, req.Send()
}

// CreateScheduledQueryWithContext is the same as CreateScheduledQuery with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScheduledQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) CreateScheduledQueryWithContext(ctx aws.Context, input *CreateScheduledQueryInput, opts ...request.Option) (*CreateScheduledQueryOutput, error) {
	req, out := c.CreateScheduledQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduledQuery = "DeleteScheduledQuery"

// DeleteScheduledQueryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduledQuery for more information on using the DeleteScheduledQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScheduledQueryRequest method.
//    req, resp := client.DeleteScheduledQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DeleteScheduledQuery
func (c *TimestreamQuery) DeleteScheduledQueryRequest(input *DeleteScheduledQueryInput) (req *request.Request, output *DeleteScheduledQueryOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScheduledQueryInput{}
	}

	output = &DeleteScheduledQueryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DeleteScheduledQuery API operation for Amazon Timestream Query.
//
// Deletes a given scheduled query. This is an irreversible operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation DeleteScheduledQuery for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ResourceNotFoundException
//   The requested resource could not be found.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DeleteScheduledQuery
func (c *TimestreamQuery) DeleteScheduledQuery(input *DeleteScheduledQueryInput) (*DeleteScheduledQueryOutput, error) {
	req, out := c.DeleteScheduledQueryRequest(input)
	return out, req.Send()
}

// DeleteScheduledQueryWithContext is the same as DeleteScheduledQuery with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduledQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) DeleteScheduledQueryWithContext(ctx aws.Context, input *DeleteScheduledQueryInput, opts ...request.Option) (*DeleteScheduledQueryOutput, error) {
	req, out := c.DeleteScheduledQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoints for more information on using the DescribeEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointsRequest method.
//    req, resp := client.DescribeEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DescribeEndpoints
func (c *TimestreamQuery) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	output = &DescribeEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoints API operation for Amazon Timestream Query.
//
// DescribeEndpoints returns a list of available endpoints to make Timestream
// API calls against. This API is available through both Write and Query.
//
// Because the Timestream SDKs are designed to transparently work with the service’s
// architecture, including the management and mapping of the service endpoints,
// it is not recommended that you use this API unless:
//
//    * You are using VPC endpoints (Amazon Web Services PrivateLink) with Timestream
//    (https://docs.aws.amazon.com/Timestream/latest/developerguide/VPCEndpoints)
//
//    * Your application uses a programming language that does not yet have
//    SDK support
//
//    * You require better control over the client-side implementation
//
// For detailed information on how and when to use and implement DescribeEndpoints,
// see The Endpoint Discovery Pattern (https://docs.aws.amazon.com/Timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation DescribeEndpoints for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DescribeEndpoints
func (c *TimestreamQuery) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	return out, req.Send()
}

// DescribeEndpointsWithContext is the same as DescribeEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) DescribeEndpointsWithContext(ctx aws.Context, input *DescribeEndpointsInput, opts ...request.Option) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type discovererDescribeEndpoints struct {
	Client        *TimestreamQuery
	Required      bool
	EndpointCache *crr.EndpointCache
	Params        map[string]*string
	Key           string
	req           *request.Request
}

func (d *discovererDescribeEndpoints) Discover() (crr.Endpoint, error) {
	input := &DescribeEndpointsInput{}

	resp, err := d.Client.DescribeEndpoints(input)
	if err != nil {
		return crr.Endpoint{}, err
	}

	endpoint := crr.Endpoint{
		Key: d.Key,
	}

	for _, e := range resp.Endpoints {
		if e.Address == nil {
			continue
		}

		address := *e.Address

		var scheme string
		if idx := strings.Index(address, "://"); idx != -1 {
			scheme = address[:idx]
		}

		if len(scheme) == 0 {
			address = fmt.Sprintf("%s://%s", d.req.HTTPRequest.URL.Scheme, address)
		}

		cachedInMinutes := aws.Int64Value(e.CachePeriodInMinutes)
		u, err := url.Parse(address)
		if err != nil {
			continue
		}

		addr := crr.WeightedAddress{
			URL:     u,
			Expired: time.Now().Add(time.Duration(cachedInMinutes) * time.Minute),
		}

		endpoint.Add(addr)
	}

	d.EndpointCache.Add(endpoint)

	return endpoint, nil
}

func (d *discovererDescribeEndpoints) Handler(r *request.Request) {
	endpointKey := crr.BuildEndpointKey(d.Params)
	d.Key = endpointKey
	d.req = r

	endpoint, err := d.EndpointCache.Get(d, endpointKey, d.Required)
	if err != nil {
		r.Error = err
		return
	}

	if endpoint.URL != nil && len(endpoint.URL.String()) > 0 {
		r.HTTPRequest.URL = endpoint.URL
	}
}

const opDescribeScheduledQuery = "DescribeScheduledQuery"

// DescribeScheduledQueryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledQuery for more information on using the DescribeScheduledQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduledQueryRequest method.
//    req, resp := client.DescribeScheduledQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DescribeScheduledQuery
func (c *TimestreamQuery) DescribeScheduledQueryRequest(input *DescribeScheduledQueryInput) (req *request.Request, output *DescribeScheduledQueryOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScheduledQueryInput{}
	}

	output = &DescribeScheduledQueryOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// DescribeScheduledQuery API operation for Amazon Timestream Query.
//
// Provides detailed information about a scheduled query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation DescribeScheduledQuery for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ResourceNotFoundException
//   The requested resource could not be found.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/DescribeScheduledQuery
func (c *TimestreamQuery) DescribeScheduledQuery(input *DescribeScheduledQueryInput) (*DescribeScheduledQueryOutput, error) {
	req, out := c.DescribeScheduledQueryRequest(input)
	return out, req.Send()
}

// DescribeScheduledQueryWithContext is the same as DescribeScheduledQuery with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) DescribeScheduledQueryWithContext(ctx aws.Context, input *DescribeScheduledQueryInput, opts ...request.Option) (*DescribeScheduledQueryOutput, error) {
	req, out := c.DescribeScheduledQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteScheduledQuery = "ExecuteScheduledQuery"

// ExecuteScheduledQueryRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteScheduledQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteScheduledQuery for more information on using the ExecuteScheduledQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExecuteScheduledQueryRequest method.
//    req, resp := client.ExecuteScheduledQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/ExecuteScheduledQuery
func (c *TimestreamQuery) ExecuteScheduledQueryRequest(input *ExecuteScheduledQueryInput) (req *request.Request, output *ExecuteScheduledQueryOutput) {
	op := &request.Operation{
		Name:       opExecuteScheduledQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecuteScheduledQueryInput{}
	}

	output = &ExecuteScheduledQueryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ExecuteScheduledQuery API operation for Amazon Timestream Query.
//
// You can use this API to run a scheduled query manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation ExecuteScheduledQuery for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ResourceNotFoundException
//   The requested resource could not be found.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/ExecuteScheduledQuery
func (c *TimestreamQuery) ExecuteScheduledQuery(input *ExecuteScheduledQueryInput) (*ExecuteScheduledQueryOutput, error) {
	req, out := c.ExecuteScheduledQueryRequest(input)
	return out, req.Send()
}

// ExecuteScheduledQueryWithContext is the same as ExecuteScheduledQuery with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteScheduledQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) ExecuteScheduledQueryWithContext(ctx aws.Context, input *ExecuteScheduledQueryInput, opts ...request.Option) (*ExecuteScheduledQueryOutput, error) {
	req, out := c.ExecuteScheduledQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListScheduledQueries = "ListScheduledQueries"

// ListScheduledQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListScheduledQueries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScheduledQueries for more information on using the ListScheduledQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListScheduledQueriesRequest method.
//    req, resp := client.ListScheduledQueriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/ListScheduledQueries
func (c *TimestreamQuery) ListScheduledQueriesRequest(input *ListScheduledQueriesInput) (req *request.Request, output *ListScheduledQueriesOutput) {
	op := &request.Operation{
		Name:       opListScheduledQueries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListScheduledQueriesInput{}
	}

	output = &ListScheduledQueriesOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListScheduledQueries API operation for Amazon Timestream Query.
//
// Gets a list of all scheduled queries in the caller's Amazon account and Region.
// ListScheduledQueries is eventually consistent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation ListScheduledQueries for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/ListScheduledQueries
func (c *TimestreamQuery) ListScheduledQueries(input *ListScheduledQueriesInput) (*ListScheduledQueriesOutput, error) {
	req, out := c.ListScheduledQueriesRequest(input)
	return out, req.Send()
}

// ListScheduledQueriesWithContext is the same as ListScheduledQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListScheduledQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) ListScheduledQueriesWithContext(ctx aws.Context, input *ListScheduledQueriesInput, opts ...request.Option) (*ListScheduledQueriesOutput, error) {
	req, out := c.ListScheduledQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListScheduledQueriesPages iterates over the pages of a ListScheduledQueries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListScheduledQueries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListScheduledQueries operation.
//    pageNum := 0
//    err := client.ListScheduledQueriesPages(params,
//        func(page *timestreamquery.ListScheduledQueriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TimestreamQuery) ListScheduledQueriesPages(input *ListScheduledQueriesInput, fn func(*ListScheduledQueriesOutput, bool) bool) error {
	return c.ListScheduledQueriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListScheduledQueriesPagesWithContext same as ListScheduledQueriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) ListScheduledQueriesPagesWithContext(ctx aws.Context, input *ListScheduledQueriesInput, fn func(*ListScheduledQueriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListScheduledQueriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListScheduledQueriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListScheduledQueriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/ListTagsForResource
func (c *TimestreamQuery) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// ListTagsForResource API operation for Amazon Timestream Query.
//
// List all tags on a Timestream query resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The requested resource could not be found.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/ListTagsForResource
func (c *TimestreamQuery) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *timestreamquery.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TimestreamQuery) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPrepareQuery = "PrepareQuery"

// PrepareQueryRequest generates a "aws/request.Request" representing the
// client's request for the PrepareQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PrepareQuery for more information on using the PrepareQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PrepareQueryRequest method.
//    req, resp := client.PrepareQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/PrepareQuery
func (c *TimestreamQuery) PrepareQueryRequest(input *PrepareQueryInput) (req *request.Request, output *PrepareQueryOutput) {
	op := &request.Operation{
		Name:       opPrepareQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PrepareQueryInput{}
	}

	output = &PrepareQueryOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// PrepareQuery API operation for Amazon Timestream Query.
//
// A synchronous operation that allows you to submit a query with parameters
// to be stored by Timestream for later running. Timestream only supports using
// this operation with the PrepareQueryRequest$ValidateOnly set to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation PrepareQuery for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/PrepareQuery
func (c *TimestreamQuery) PrepareQuery(input *PrepareQueryInput) (*PrepareQueryOutput, error) {
	req, out := c.PrepareQueryRequest(input)
	return out, req.Send()
}

// PrepareQueryWithContext is the same as PrepareQuery with the addition of
// the ability to pass a context and additional request options.
//
// See PrepareQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) PrepareQueryWithContext(ctx aws.Context, input *PrepareQueryInput, opts ...request.Option) (*PrepareQueryOutput, error) {
	req, out := c.PrepareQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQuery = "Query"

// QueryRequest generates a "aws/request.Request" representing the
// client's request for the Query operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Query for more information on using the Query
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QueryRequest method.
//    req, resp := client.QueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/Query
func (c *TimestreamQuery) QueryRequest(input *QueryInput) (req *request.Request, output *QueryOutput) {
	op := &request.Operation{
		Name:       opQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRows",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &QueryInput{}
	}

	output = &QueryOutput{}
	req = c.newRequest(op, input, output)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// Query API operation for Amazon Timestream Query.
//
// Query is a synchronous operation that enables you to run a query against
// your Amazon Timestream data. Query will time out after 60 seconds. You must
// update the default timeout in the SDK to support a timeout of 60 seconds.
// See the code sample (https://docs.aws.amazon.com/Timestream/latest/developerguide/code-samples.run-query.html)
// for details.
//
// Your query request will fail in the following cases:
//
//    * If you submit a Query request with the same client token outside of
//    the 5-minute idempotency window.
//
//    * If you submit a Query request with the same client token, but change
//    other parameters, within the 5-minute idempotency window.
//
//    * If the size of the row (including the query metadata) exceeds 1 MB,
//    then the query will fail with the following error message: Query aborted
//    as max page response size has been exceeded by the output result row
//
//    * If the IAM principal of the query initiator and the result reader are
//    not the same and/or the query initiator and the result reader do not have
//    the same query string in the query requests, the query will fail with
//    an Invalid pagination token error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation Query for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * ConflictException
//   Unable to poll results for a cancelled query.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * QueryExecutionException
//   Timestream was unable to run the query successfully.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/Query
func (c *TimestreamQuery) Query(input *QueryInput) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	return out, req.Send()
}

// QueryWithContext is the same as Query with the addition of
// the ability to pass a context and additional request options.
//
// See Query for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) QueryWithContext(ctx aws.Context, input *QueryInput, opts ...request.Option) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// QueryPages iterates over the pages of a Query operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Query method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Query operation.
//    pageNum := 0
//    err := client.QueryPages(params,
//        func(page *timestreamquery.QueryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TimestreamQuery) QueryPages(input *QueryInput, fn func(*QueryOutput, bool) bool) error {
	return c.QueryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// QueryPagesWithContext same as QueryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) QueryPagesWithContext(ctx aws.Context, input *QueryInput, fn func(*QueryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *QueryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.QueryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*QueryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/TagResource
func (c *TimestreamQuery) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// TagResource API operation for Amazon Timestream Query.
//
// Associate a set of tags with a Timestream resource. You can then activate
// these user-defined tags so that they appear on the Billing and Cost Management
// console for cost allocation tracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The requested resource could not be found.
//
//   * ServiceQuotaExceededException
//   You have exceeded the service quota.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/TagResource
func (c *TimestreamQuery) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/UntagResource
func (c *TimestreamQuery) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UntagResource API operation for Amazon Timestream Query.
//
// Removes the association of tags from a Timestream query resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Invalid or malformed request.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ResourceNotFoundException
//   The requested resource could not be found.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/UntagResource
func (c *TimestreamQuery) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScheduledQuery = "UpdateScheduledQuery"

// UpdateScheduledQueryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScheduledQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScheduledQuery for more information on using the UpdateScheduledQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateScheduledQueryRequest method.
//    req, resp := client.UpdateScheduledQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/UpdateScheduledQuery
func (c *TimestreamQuery) UpdateScheduledQueryRequest(input *UpdateScheduledQueryInput) (req *request.Request, output *UpdateScheduledQueryOutput) {
	op := &request.Operation{
		Name:       opUpdateScheduledQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScheduledQueryInput{}
	}

	output = &UpdateScheduledQueryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	// if custom endpoint for the request is set to a non empty string,
	// we skip the endpoint discovery workflow.
	if req.Config.Endpoint == nil || *req.Config.Endpoint == "" {
		de := discovererDescribeEndpoints{
			Required:      true,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": aws.String(req.Operation.Name),
			},
			Client: c,
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(request.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}
	return
}

// UpdateScheduledQuery API operation for Amazon Timestream Query.
//
// Update a scheduled query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Timestream Query's
// API operation UpdateScheduledQuery for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform this action.
//
//   * InternalServerException
//   Timestream was unable to fully process this request because of an internal
//   server error.
//
//   * ResourceNotFoundException
//   The requested resource could not be found.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   Invalid or malformed request.
//
//   * InvalidEndpointException
//   The requested endpoint was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-query-2018-11-01/UpdateScheduledQuery
func (c *TimestreamQuery) UpdateScheduledQuery(input *UpdateScheduledQueryInput) (*UpdateScheduledQueryOutput, error) {
	req, out := c.UpdateScheduledQueryRequest(input)
	return out, req.Send()
}

// UpdateScheduledQueryWithContext is the same as UpdateScheduledQuery with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScheduledQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamQuery) UpdateScheduledQueryWithContext(ctx aws.Context, input *UpdateScheduledQueryInput, opts ...request.Option) (*UpdateScheduledQueryOutput, error) {
	req, out := c.UpdateScheduledQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You are not authorized to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelQueryInput struct {
	_ struct{} `type:"structure"`

	// The ID of the query that needs to be cancelled. QueryID is returned as part
	// of the query result.
	//
	// QueryId is a required field
	QueryId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelQueryInput"}
	if s.QueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryId sets the QueryId field's value.
func (s *CancelQueryInput) SetQueryId(v string) *CancelQueryInput {
	s.QueryId = &v
	return s
}

type CancelQueryOutput struct {
	_ struct{} `type:"structure"`

	// A CancellationMessage is returned when a CancelQuery request for the query
	// specified by QueryId has already been issued.
	CancellationMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelQueryOutput) GoString() string {
	return s.String()
}

// SetCancellationMessage sets the CancellationMessage field's value.
func (s *CancelQueryOutput) SetCancellationMessage(v string) *CancelQueryOutput {
	s.CancellationMessage = &v
	return s
}

// Contains the metadata for query results such as the column names, data types,
// and other attributes.
type ColumnInfo struct {
	_ struct{} `type:"structure"`

	// The name of the result set column. The name of the result set is available
	// for columns of all data types except for arrays.
	Name *string `type:"string"`

	// The data type of the result set column. The data type can be a scalar or
	// complex. Scalar data types are integers, strings, doubles, Booleans, and
	// others. Complex data types are types such as arrays, rows, and others.
	//
	// Type is a required field
	Type *Type `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnInfo) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ColumnInfo) SetName(v string) *ColumnInfo {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnInfo) SetType(v *Type) *ColumnInfo {
	s.Type = v
	return s
}

// Unable to poll results for a cancelled query.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateScheduledQueryInput struct {
	_ struct{} `type:"structure"`

	// Using a ClientToken makes the call to CreateScheduledQuery idempotent, in
	// other words, making the same request repeatedly will produce the same result.
	// Making multiple identical CreateScheduledQuery requests has the same effect
	// as making a single request.
	//
	//    * If CreateScheduledQuery is called without a ClientToken, the Query SDK
	//    generates a ClientToken on your behalf.
	//
	//    * After 8 hours, any request with the same ClientToken is treated as a
	//    new request.
	//
	// ClientToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateScheduledQueryInput's
	// String and GoString methods.
	ClientToken *string `min:"32" type:"string" idempotencyToken:"true" sensitive:"true"`

	// Configuration for error reporting. Error reports will be generated when a
	// problem is encountered when writing the query results.
	//
	// ErrorReportConfiguration is a required field
	ErrorReportConfiguration *ErrorReportConfiguration `type:"structure" required:"true"`

	// The Amazon KMS key used to encrypt the scheduled query resource, at-rest.
	// If the Amazon KMS key is not specified, the scheduled query resource will
	// be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key,
	// use the key ID, key ARN, alias name, or alias ARN. When using an alias name,
	// prefix the name with alias/
	//
	// If ErrorReportConfiguration uses SSE_KMS as encryption type, the same KmsKeyId
	// is used to encrypt the error report at rest.
	KmsKeyId *string `min:"1" type:"string"`

	// Name of the scheduled query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Notification configuration for the scheduled query. A notification is sent
	// by Timestream when a query run finishes, when the state is updated or when
	// you delete it.
	//
	// NotificationConfiguration is a required field
	NotificationConfiguration *NotificationConfiguration `type:"structure" required:"true"`

	// The query string to run. Parameter names can be specified in the query string
	// @ character followed by an identifier. The named Parameter @scheduled_runtime
	// is reserved and can be used in the query to get the time at which the query
	// is scheduled to run.
	//
	// The timestamp calculated according to the ScheduleConfiguration parameter,
	// will be the value of @scheduled_runtime paramater for each query run. For
	// example, consider an instance of a scheduled query executing on 2021-12-01
	// 00:00:00. For this instance, the @scheduled_runtime parameter is initialized
	// to the timestamp 2021-12-01 00:00:00 when invoking the query.
	//
	// QueryString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateScheduledQueryInput's
	// String and GoString methods.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The schedule configuration for the query.
	//
	// ScheduleConfiguration is a required field
	ScheduleConfiguration *ScheduleConfiguration `type:"structure" required:"true"`

	// The ARN for the IAM role that Timestream will assume when running the scheduled
	// query.
	//
	// ScheduledQueryExecutionRoleArn is a required field
	ScheduledQueryExecutionRoleArn *string `min:"1" type:"string" required:"true"`

	// A list of key-value pairs to label the scheduled query.
	Tags []*Tag `type:"list"`

	// Configuration used for writing the result of a query.
	TargetConfiguration *TargetConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduledQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduledQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduledQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScheduledQueryInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 32))
	}
	if s.ErrorReportConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ErrorReportConfiguration"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NotificationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationConfiguration"))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.ScheduleConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleConfiguration"))
	}
	if s.ScheduledQueryExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledQueryExecutionRoleArn"))
	}
	if s.ScheduledQueryExecutionRoleArn != nil && len(*s.ScheduledQueryExecutionRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledQueryExecutionRoleArn", 1))
	}
	if s.ErrorReportConfiguration != nil {
		if err := s.ErrorReportConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ErrorReportConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationConfiguration != nil {
		if err := s.NotificationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ScheduleConfiguration != nil {
		if err := s.ScheduleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ScheduleConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetConfiguration != nil {
		if err := s.TargetConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateScheduledQueryInput) SetClientToken(v string) *CreateScheduledQueryInput {
	s.ClientToken = &v
	return s
}

// SetErrorReportConfiguration sets the ErrorReportConfiguration field's value.
func (s *CreateScheduledQueryInput) SetErrorReportConfiguration(v *ErrorReportConfiguration) *CreateScheduledQueryInput {
	s.ErrorReportConfiguration = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateScheduledQueryInput) SetKmsKeyId(v string) *CreateScheduledQueryInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateScheduledQueryInput) SetName(v string) *CreateScheduledQueryInput {
	s.Name = &v
	return s
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *CreateScheduledQueryInput) SetNotificationConfiguration(v *NotificationConfiguration) *CreateScheduledQueryInput {
	s.NotificationConfiguration = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *CreateScheduledQueryInput) SetQueryString(v string) *CreateScheduledQueryInput {
	s.QueryString = &v
	return s
}

// SetScheduleConfiguration sets the ScheduleConfiguration field's value.
func (s *CreateScheduledQueryInput) SetScheduleConfiguration(v *ScheduleConfiguration) *CreateScheduledQueryInput {
	s.ScheduleConfiguration = v
	return s
}

// SetScheduledQueryExecutionRoleArn sets the ScheduledQueryExecutionRoleArn field's value.
func (s *CreateScheduledQueryInput) SetScheduledQueryExecutionRoleArn(v string) *CreateScheduledQueryInput {
	s.ScheduledQueryExecutionRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateScheduledQueryInput) SetTags(v []*Tag) *CreateScheduledQueryInput {
	s.Tags = v
	return s
}

// SetTargetConfiguration sets the TargetConfiguration field's value.
func (s *CreateScheduledQueryInput) SetTargetConfiguration(v *TargetConfiguration) *CreateScheduledQueryInput {
	s.TargetConfiguration = v
	return s
}

type CreateScheduledQueryOutput struct {
	_ struct{} `type:"structure"`

	// ARN for the created scheduled query.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduledQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduledQueryOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateScheduledQueryOutput) SetArn(v string) *CreateScheduledQueryOutput {
	s.Arn = &v
	return s
}

// Datum represents a single data point in a query result.
type Datum struct {
	_ struct{} `type:"structure"`

	// Indicates if the data point is an array.
	ArrayValue []*Datum `type:"list"`

	// Indicates if the data point is null.
	NullValue *bool `type:"boolean"`

	// Indicates if the data point is a row.
	RowValue *Row `type:"structure"`

	// Indicates if the data point is a scalar value such as integer, string, double,
	// or Boolean.
	ScalarValue *string `type:"string"`

	// Indicates if the data point is a timeseries data type.
	TimeSeriesValue []*TimeSeriesDataPoint `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Datum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Datum) GoString() string {
	return s.String()
}

// SetArrayValue sets the ArrayValue field's value.
func (s *Datum) SetArrayValue(v []*Datum) *Datum {
	s.ArrayValue = v
	return s
}

// SetNullValue sets the NullValue field's value.
func (s *Datum) SetNullValue(v bool) *Datum {
	s.NullValue = &v
	return s
}

// SetRowValue sets the RowValue field's value.
func (s *Datum) SetRowValue(v *Row) *Datum {
	s.RowValue = v
	return s
}

// SetScalarValue sets the ScalarValue field's value.
func (s *Datum) SetScalarValue(v string) *Datum {
	s.ScalarValue = &v
	return s
}

// SetTimeSeriesValue sets the TimeSeriesValue field's value.
func (s *Datum) SetTimeSeriesValue(v []*TimeSeriesDataPoint) *Datum {
	s.TimeSeriesValue = v
	return s
}

type DeleteScheduledQueryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the scheduled query.
	//
	// ScheduledQueryArn is a required field
	ScheduledQueryArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledQueryInput"}
	if s.ScheduledQueryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledQueryArn"))
	}
	if s.ScheduledQueryArn != nil && len(*s.ScheduledQueryArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledQueryArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledQueryArn sets the ScheduledQueryArn field's value.
func (s *DeleteScheduledQueryInput) SetScheduledQueryArn(v string) *DeleteScheduledQueryInput {
	s.ScheduledQueryArn = &v
	return s
}

type DeleteScheduledQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledQueryOutput) GoString() string {
	return s.String()
}

type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// An Endpoints object is returned when a DescribeEndpoints request is made.
	//
	// Endpoints is a required field
	Endpoints []*Endpoint `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeEndpointsOutput) SetEndpoints(v []*Endpoint) *DescribeEndpointsOutput {
	s.Endpoints = v
	return s
}

type DescribeScheduledQueryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the scheduled query.
	//
	// ScheduledQueryArn is a required field
	ScheduledQueryArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduledQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduledQueryInput"}
	if s.ScheduledQueryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledQueryArn"))
	}
	if s.ScheduledQueryArn != nil && len(*s.ScheduledQueryArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledQueryArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledQueryArn sets the ScheduledQueryArn field's value.
func (s *DescribeScheduledQueryInput) SetScheduledQueryArn(v string) *DescribeScheduledQueryInput {
	s.ScheduledQueryArn = &v
	return s
}

type DescribeScheduledQueryOutput struct {
	_ struct{} `type:"structure"`

	// The scheduled query.
	//
	// ScheduledQuery is a required field
	ScheduledQuery *ScheduledQueryDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledQueryOutput) GoString() string {
	return s.String()
}

// SetScheduledQuery sets the ScheduledQuery field's value.
func (s *DescribeScheduledQueryOutput) SetScheduledQuery(v *ScheduledQueryDescription) *DescribeScheduledQueryOutput {
	s.ScheduledQuery = v
	return s
}

// This type is used to map column(s) from the query result to a dimension in
// the destination table.
type DimensionMapping struct {
	_ struct{} `type:"structure"`

	// Type for the dimension.
	//
	// DimensionValueType is a required field
	DimensionValueType *string `type:"string" required:"true" enum:"DimensionValueType"`

	// Column name from query result.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionMapping"}
	if s.DimensionValueType == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionValueType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionValueType sets the DimensionValueType field's value.
func (s *DimensionMapping) SetDimensionValueType(v string) *DimensionMapping {
	s.DimensionValueType = &v
	return s
}

// SetName sets the Name field's value.
func (s *DimensionMapping) SetName(v string) *DimensionMapping {
	s.Name = &v
	return s
}

// Represents an available endpoint against which to make API calls against,
// as well as the TTL for that endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// An endpoint address.
	//
	// Address is a required field
	Address *string `type:"string" required:"true"`

	// The TTL for the endpoint, in minutes.
	//
	// CachePeriodInMinutes is a required field
	CachePeriodInMinutes *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetCachePeriodInMinutes sets the CachePeriodInMinutes field's value.
func (s *Endpoint) SetCachePeriodInMinutes(v int64) *Endpoint {
	s.CachePeriodInMinutes = &v
	return s
}

// Configuration required for error reporting.
type ErrorReportConfiguration struct {
	_ struct{} `type:"structure"`

	// The S3 configuration for the error reports.
	//
	// S3Configuration is a required field
	S3Configuration *S3Configuration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorReportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorReportConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorReportConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ErrorReportConfiguration"}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *ErrorReportConfiguration) SetS3Configuration(v *S3Configuration) *ErrorReportConfiguration {
	s.S3Configuration = v
	return s
}

// This contains the location of the error report for a single scheduled query
// call.
type ErrorReportLocation struct {
	_ struct{} `type:"structure"`

	// The S3 location where error reports are written.
	S3ReportLocation *S3ReportLocation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorReportLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorReportLocation) GoString() string {
	return s.String()
}

// SetS3ReportLocation sets the S3ReportLocation field's value.
func (s *ErrorReportLocation) SetS3ReportLocation(v *S3ReportLocation) *ErrorReportLocation {
	s.S3ReportLocation = v
	return s
}

type ExecuteScheduledQueryInput struct {
	_ struct{} `type:"structure"`

	// Not used.
	//
	// ClientToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ExecuteScheduledQueryInput's
	// String and GoString methods.
	ClientToken *string `min:"32" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The timestamp in UTC. Query will be run as if it was invoked at this timestamp.
	//
	// InvocationTime is a required field
	InvocationTime *time.Time `type:"timestamp" required:"true"`

	// ARN of the scheduled query.
	//
	// ScheduledQueryArn is a required field
	ScheduledQueryArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteScheduledQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteScheduledQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteScheduledQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteScheduledQueryInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 32))
	}
	if s.InvocationTime == nil {
		invalidParams.Add(request.NewErrParamRequired("InvocationTime"))
	}
	if s.ScheduledQueryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledQueryArn"))
	}
	if s.ScheduledQueryArn != nil && len(*s.ScheduledQueryArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledQueryArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ExecuteScheduledQueryInput) SetClientToken(v string) *ExecuteScheduledQueryInput {
	s.ClientToken = &v
	return s
}

// SetInvocationTime sets the InvocationTime field's value.
func (s *ExecuteScheduledQueryInput) SetInvocationTime(v time.Time) *ExecuteScheduledQueryInput {
	s.InvocationTime = &v
	return s
}

// SetScheduledQueryArn sets the ScheduledQueryArn field's value.
func (s *ExecuteScheduledQueryInput) SetScheduledQueryArn(v string) *ExecuteScheduledQueryInput {
	s.ScheduledQueryArn = &v
	return s
}

type ExecuteScheduledQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteScheduledQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteScheduledQueryOutput) GoString() string {
	return s.String()
}

// Statistics for a single scheduled query run.
type ExecutionStats struct {
	_ struct{} `type:"structure"`

	// Bytes metered for a single scheduled query run.
	BytesMetered *int64 `type:"long"`

	// Data writes metered for records ingested in a single scheduled query run.
	DataWrites *int64 `type:"long"`

	// Total time, measured in milliseconds, that was needed for the scheduled query
	// run to complete.
	ExecutionTimeInMillis *int64 `type:"long"`

	// Number of rows present in the output from running a query before ingestion
	// to destination data source.
	QueryResultRows *int64 `type:"long"`

	// The number of records ingested for a single scheduled query run.
	RecordsIngested *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionStats) GoString() string {
	return s.String()
}

// SetBytesMetered sets the BytesMetered field's value.
func (s *ExecutionStats) SetBytesMetered(v int64) *ExecutionStats {
	s.BytesMetered = &v
	return s
}

// SetDataWrites sets the DataWrites field's value.
func (s *ExecutionStats) SetDataWrites(v int64) *ExecutionStats {
	s.DataWrites = &v
	return s
}

// SetExecutionTimeInMillis sets the ExecutionTimeInMillis field's value.
func (s *ExecutionStats) SetExecutionTimeInMillis(v int64) *ExecutionStats {
	s.ExecutionTimeInMillis = &v
	return s
}

// SetQueryResultRows sets the QueryResultRows field's value.
func (s *ExecutionStats) SetQueryResultRows(v int64) *ExecutionStats {
	s.QueryResultRows = &v
	return s
}

// SetRecordsIngested sets the RecordsIngested field's value.
func (s *ExecutionStats) SetRecordsIngested(v int64) *ExecutionStats {
	s.RecordsIngested = &v
	return s
}

// Timestream was unable to fully process this request because of an internal
// server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested endpoint was not valid.
type InvalidEndpointException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEndpointException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEndpointException) GoString() string {
	return s.String()
}

func newErrorInvalidEndpointException(v protocol.ResponseMetadata) error {
	return &InvalidEndpointException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEndpointException) Code() string {
	return "InvalidEndpointException"
}

// Message returns the exception's message.
func (s *InvalidEndpointException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEndpointException) OrigErr() error {
	return nil
}

func (s *InvalidEndpointException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEndpointException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEndpointException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListScheduledQueriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the output. If the total number
	// of items available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as the argument
	// to the subsequent call to ListScheduledQueriesRequest.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token to resume pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledQueriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScheduledQueriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListScheduledQueriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListScheduledQueriesInput) SetMaxResults(v int64) *ListScheduledQueriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduledQueriesInput) SetNextToken(v string) *ListScheduledQueriesInput {
	s.NextToken = &v
	return s
}

type ListScheduledQueriesOutput struct {
	_ struct{} `type:"structure"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `type:"string"`

	// A list of scheduled queries.
	//
	// ScheduledQueries is a required field
	ScheduledQueries []*ScheduledQuery `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledQueriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduledQueriesOutput) SetNextToken(v string) *ListScheduledQueriesOutput {
	s.NextToken = &v
	return s
}

// SetScheduledQueries sets the ScheduledQueries field's value.
func (s *ListScheduledQueriesOutput) SetScheduledQueries(v []*ScheduledQuery) *ListScheduledQueriesOutput {
	s.ScheduledQueries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token to resume pagination.
	NextToken *string `type:"string"`

	// The Timestream resource with tags to be listed. This value is an Amazon Resource
	// Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token to resume pagination with a subsequent call to ListTagsForResourceResponse.
	NextToken *string `type:"string"`

	// The tags currently associated with the Timestream resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// MixedMeasureMappings are mappings that can be used to ingest data into a
// mixture of narrow and multi measures in the derived table.
type MixedMeasureMapping struct {
	_ struct{} `type:"structure"`

	// Refers to the value of measure_name in a result row. This field is required
	// if MeasureNameColumn is provided.
	MeasureName *string `type:"string"`

	// Type of the value that is to be read from sourceColumn. If the mapping is
	// for MULTI, use MeasureValueType.MULTI.
	//
	// MeasureValueType is a required field
	MeasureValueType *string `type:"string" required:"true" enum:"MeasureValueType"`

	// Required when measureValueType is MULTI. Attribute mappings for MULTI value
	// measures.
	MultiMeasureAttributeMappings []*MultiMeasureAttributeMapping `min:"1" type:"list"`

	// This field refers to the source column from which measure-value is to be
	// read for result materialization.
	SourceColumn *string `type:"string"`

	// Target measure name to be used. If not provided, the target measure name
	// by default would be measure-name if provided, or sourceColumn otherwise.
	TargetMeasureName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MixedMeasureMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MixedMeasureMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MixedMeasureMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MixedMeasureMapping"}
	if s.MeasureValueType == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureValueType"))
	}
	if s.MultiMeasureAttributeMappings != nil && len(s.MultiMeasureAttributeMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiMeasureAttributeMappings", 1))
	}
	if s.MultiMeasureAttributeMappings != nil {
		for i, v := range s.MultiMeasureAttributeMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MultiMeasureAttributeMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeasureName sets the MeasureName field's value.
func (s *MixedMeasureMapping) SetMeasureName(v string) *MixedMeasureMapping {
	s.MeasureName = &v
	return s
}

// SetMeasureValueType sets the MeasureValueType field's value.
func (s *MixedMeasureMapping) SetMeasureValueType(v string) *MixedMeasureMapping {
	s.MeasureValueType = &v
	return s
}

// SetMultiMeasureAttributeMappings sets the MultiMeasureAttributeMappings field's value.
func (s *MixedMeasureMapping) SetMultiMeasureAttributeMappings(v []*MultiMeasureAttributeMapping) *MixedMeasureMapping {
	s.MultiMeasureAttributeMappings = v
	return s
}

// SetSourceColumn sets the SourceColumn field's value.
func (s *MixedMeasureMapping) SetSourceColumn(v string) *MixedMeasureMapping {
	s.SourceColumn = &v
	return s
}

// SetTargetMeasureName sets the TargetMeasureName field's value.
func (s *MixedMeasureMapping) SetTargetMeasureName(v string) *MixedMeasureMapping {
	s.TargetMeasureName = &v
	return s
}

// Attribute mapping for MULTI value measures.
type MultiMeasureAttributeMapping struct {
	_ struct{} `type:"structure"`

	// Type of the attribute to be read from the source column.
	//
	// MeasureValueType is a required field
	MeasureValueType *string `type:"string" required:"true" enum:"ScalarMeasureValueType"`

	// Source column from where the attribute value is to be read.
	//
	// SourceColumn is a required field
	SourceColumn *string `type:"string" required:"true"`

	// Custom name to be used for attribute name in derived table. If not provided,
	// source column name would be used.
	TargetMultiMeasureAttributeName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureAttributeMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureAttributeMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiMeasureAttributeMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiMeasureAttributeMapping"}
	if s.MeasureValueType == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureValueType"))
	}
	if s.SourceColumn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceColumn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeasureValueType sets the MeasureValueType field's value.
func (s *MultiMeasureAttributeMapping) SetMeasureValueType(v string) *MultiMeasureAttributeMapping {
	s.MeasureValueType = &v
	return s
}

// SetSourceColumn sets the SourceColumn field's value.
func (s *MultiMeasureAttributeMapping) SetSourceColumn(v string) *MultiMeasureAttributeMapping {
	s.SourceColumn = &v
	return s
}

// SetTargetMultiMeasureAttributeName sets the TargetMultiMeasureAttributeName field's value.
func (s *MultiMeasureAttributeMapping) SetTargetMultiMeasureAttributeName(v string) *MultiMeasureAttributeMapping {
	s.TargetMultiMeasureAttributeName = &v
	return s
}

// Only one of MixedMeasureMappings or MultiMeasureMappings is to be provided.
// MultiMeasureMappings can be used to ingest data as multi measures in the
// derived table.
type MultiMeasureMappings struct {
	_ struct{} `type:"structure"`

	// Required. Attribute mappings to be used for mapping query results to ingest
	// data for multi-measure attributes.
	//
	// MultiMeasureAttributeMappings is a required field
	MultiMeasureAttributeMappings []*MultiMeasureAttributeMapping `min:"1" type:"list" required:"true"`

	// The name of the target multi-measure name in the derived table. This input
	// is required when measureNameColumn is not provided. If MeasureNameColumn
	// is provided, then value from that column will be used as multi-measure name.
	TargetMultiMeasureName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureMappings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureMappings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiMeasureMappings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiMeasureMappings"}
	if s.MultiMeasureAttributeMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiMeasureAttributeMappings"))
	}
	if s.MultiMeasureAttributeMappings != nil && len(s.MultiMeasureAttributeMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiMeasureAttributeMappings", 1))
	}
	if s.MultiMeasureAttributeMappings != nil {
		for i, v := range s.MultiMeasureAttributeMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MultiMeasureAttributeMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiMeasureAttributeMappings sets the MultiMeasureAttributeMappings field's value.
func (s *MultiMeasureMappings) SetMultiMeasureAttributeMappings(v []*MultiMeasureAttributeMapping) *MultiMeasureMappings {
	s.MultiMeasureAttributeMappings = v
	return s
}

// SetTargetMultiMeasureName sets the TargetMultiMeasureName field's value.
func (s *MultiMeasureMappings) SetTargetMultiMeasureName(v string) *MultiMeasureMappings {
	s.TargetMultiMeasureName = &v
	return s
}

// Notification configuration for a scheduled query. A notification is sent
// by Timestream when a scheduled query is created, its state is updated or
// when it is deleted.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// Details on SNS configuration.
	//
	// SnsConfiguration is a required field
	SnsConfiguration *SnsConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationConfiguration"}
	if s.SnsConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsConfiguration"))
	}
	if s.SnsConfiguration != nil {
		if err := s.SnsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SnsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnsConfiguration sets the SnsConfiguration field's value.
func (s *NotificationConfiguration) SetSnsConfiguration(v *SnsConfiguration) *NotificationConfiguration {
	s.SnsConfiguration = v
	return s
}

// Mapping for named parameters.
type ParameterMapping struct {
	_ struct{} `type:"structure"`

	// Parameter name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Contains the data type of a column in a query result set. The data type can
	// be scalar or complex. The supported scalar data types are integers, Boolean,
	// string, double, timestamp, date, time, and intervals. The supported complex
	// data types are arrays, rows, and timeseries.
	//
	// Type is a required field
	Type *Type `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterMapping) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ParameterMapping) SetName(v string) *ParameterMapping {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ParameterMapping) SetType(v *Type) *ParameterMapping {
	s.Type = v
	return s
}

type PrepareQueryInput struct {
	_ struct{} `type:"structure"`

	// The Timestream query string that you want to use as a prepared statement.
	// Parameter names can be specified in the query string @ character followed
	// by an identifier.
	//
	// QueryString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PrepareQueryInput's
	// String and GoString methods.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// By setting this value to true, Timestream will only validate that the query
	// string is a valid Timestream query, and not store the prepared query for
	// later use.
	ValidateOnly *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrepareQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrepareQueryInput"}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryString sets the QueryString field's value.
func (s *PrepareQueryInput) SetQueryString(v string) *PrepareQueryInput {
	s.QueryString = &v
	return s
}

// SetValidateOnly sets the ValidateOnly field's value.
func (s *PrepareQueryInput) SetValidateOnly(v bool) *PrepareQueryInput {
	s.ValidateOnly = &v
	return s
}

type PrepareQueryOutput struct {
	_ struct{} `type:"structure"`

	// A list of SELECT clause columns of the submitted query string.
	//
	// Columns is a required field
	Columns []*SelectColumn `type:"list" required:"true"`

	// A list of parameters used in the submitted query string.
	//
	// Parameters is a required field
	Parameters []*ParameterMapping `type:"list" required:"true"`

	// The query string that you want prepare.
	//
	// QueryString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PrepareQueryOutput's
	// String and GoString methods.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareQueryOutput) GoString() string {
	return s.String()
}

// SetColumns sets the Columns field's value.
func (s *PrepareQueryOutput) SetColumns(v []*SelectColumn) *PrepareQueryOutput {
	s.Columns = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PrepareQueryOutput) SetParameters(v []*ParameterMapping) *PrepareQueryOutput {
	s.Parameters = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *PrepareQueryOutput) SetQueryString(v string) *PrepareQueryOutput {
	s.QueryString = &v
	return s
}

// Timestream was unable to run the query successfully.
type QueryExecutionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryExecutionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryExecutionException) GoString() string {
	return s.String()
}

func newErrorQueryExecutionException(v protocol.ResponseMetadata) error {
	return &QueryExecutionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *QueryExecutionException) Code() string {
	return "QueryExecutionException"
}

// Message returns the exception's message.
func (s *QueryExecutionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *QueryExecutionException) OrigErr() error {
	return nil
}

func (s *QueryExecutionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *QueryExecutionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *QueryExecutionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type QueryInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive string of up to 64 ASCII characters specified when
	// a Query request is made. Providing a ClientToken makes the call to Query
	// idempotent. This means that running the same query repeatedly will produce
	// the same result. In other words, making multiple identical Query requests
	// has the same effect as making a single request. When using ClientToken in
	// a query, note the following:
	//
	//    * If the Query API is instantiated without a ClientToken, the Query SDK
	//    generates a ClientToken on your behalf.
	//
	//    * If the Query invocation only contains the ClientToken but does not include
	//    a NextToken, that invocation of Query is assumed to be a new query run.
	//
	//    * If the invocation contains NextToken, that particular invocation is
	//    assumed to be a subsequent invocation of a prior call to the Query API,
	//    and a result set is returned.
	//
	//    * After 4 hours, any request with the same ClientToken is treated as a
	//    new request.
	//
	// ClientToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by QueryInput's
	// String and GoString methods.
	ClientToken *string `min:"32" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The total number of rows to be returned in the Query output. The initial
	// run of Query with a MaxRows value specified will return the result set of
	// the query in two cases:
	//
	//    * The size of the result is less than 1MB.
	//
	//    * The number of rows in the result set is less than the value of maxRows.
	//
	// Otherwise, the initial invocation of Query only returns a NextToken, which
	// can then be used in subsequent calls to fetch the result set. To resume pagination,
	// provide the NextToken value in the subsequent command.
	//
	// If the row size is large (e.g. a row has many columns), Timestream may return
	// fewer rows to keep the response size from exceeding the 1 MB limit. If MaxRows
	// is not provided, Timestream will send the necessary number of rows to meet
	// the 1 MB limit.
	MaxRows *int64 `min:"1" type:"integer"`

	// A pagination token used to return a set of results. When the Query API is
	// invoked using NextToken, that particular invocation is assumed to be a subsequent
	// invocation of a prior call to Query, and a result set is returned. However,
	// if the Query invocation only contains the ClientToken, that invocation of
	// Query is assumed to be a new query run.
	//
	// Note the following when using NextToken in a query:
	//
	//    * A pagination token can be used for up to five Query invocations, OR
	//    for a duration of up to 1 hour – whichever comes first.
	//
	//    * Using the same NextToken will return the same set of records. To keep
	//    paginating through the result set, you must to use the most recent nextToken.
	//
	//    * Suppose a Query invocation returns two NextToken values, TokenA and
	//    TokenB. If TokenB is used in a subsequent Query invocation, then TokenA
	//    is invalidated and cannot be reused.
	//
	//    * To request a previous result set from a query after pagination has begun,
	//    you must re-invoke the Query API.
	//
	//    * The latest NextToken should be used to paginate until null is returned,
	//    at which point a new NextToken should be used.
	//
	//    * If the IAM principal of the query initiator and the result reader are
	//    not the same and/or the query initiator and the result reader do not have
	//    the same query string in the query requests, the query will fail with
	//    an Invalid pagination token error.
	NextToken *string `min:"1" type:"string"`

	// The query to be run by Timestream.
	//
	// QueryString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by QueryInput's
	// String and GoString methods.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 32))
	}
	if s.MaxRows != nil && *s.MaxRows < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRows", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *QueryInput) SetClientToken(v string) *QueryInput {
	s.ClientToken = &v
	return s
}

// SetMaxRows sets the MaxRows field's value.
func (s *QueryInput) SetMaxRows(v int64) *QueryInput {
	s.MaxRows = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *QueryInput) SetNextToken(v string) *QueryInput {
	s.NextToken = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *QueryInput) SetQueryString(v string) *QueryInput {
	s.QueryString = &v
	return s
}

type QueryOutput struct {
	_ struct{} `type:"structure"`

	// The column data types of the returned result set.
	//
	// ColumnInfo is a required field
	ColumnInfo []*ColumnInfo `type:"list" required:"true"`

	// A pagination token that can be used again on a Query call to get the next
	// set of results.
	NextToken *string `min:"1" type:"string"`

	// A unique ID for the given query.
	//
	// QueryId is a required field
	QueryId *string `min:"1" type:"string" required:"true"`

	// Information about the status of the query, including progress and bytes scanned.
	QueryStatus *QueryStatus `type:"structure"`

	// The result set rows returned by the query.
	//
	// Rows is a required field
	Rows []*Row `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryOutput) GoString() string {
	return s.String()
}

// SetColumnInfo sets the ColumnInfo field's value.
func (s *QueryOutput) SetColumnInfo(v []*ColumnInfo) *QueryOutput {
	s.ColumnInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *QueryOutput) SetNextToken(v string) *QueryOutput {
	s.NextToken = &v
	return s
}

// SetQueryId sets the QueryId field's value.
func (s *QueryOutput) SetQueryId(v string) *QueryOutput {
	s.QueryId = &v
	return s
}

// SetQueryStatus sets the QueryStatus field's value.
func (s *QueryOutput) SetQueryStatus(v *QueryStatus) *QueryOutput {
	s.QueryStatus = v
	return s
}

// SetRows sets the Rows field's value.
func (s *QueryOutput) SetRows(v []*Row) *QueryOutput {
	s.Rows = v
	return s
}

// Information about the status of the query, including progress and bytes scanned.
type QueryStatus struct {
	_ struct{} `type:"structure"`

	// The amount of data scanned by the query in bytes that you will be charged
	// for. This is a cumulative sum and represents the total amount of data that
	// you will be charged for since the query was started. The charge is applied
	// only once and is either applied when the query completes running or when
	// the query is cancelled.
	CumulativeBytesMetered *int64 `type:"long"`

	// The amount of data scanned by the query in bytes. This is a cumulative sum
	// and represents the total amount of bytes scanned since the query was started.
	CumulativeBytesScanned *int64 `type:"long"`

	// The progress of the query, expressed as a percentage.
	ProgressPercentage *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryStatus) GoString() string {
	return s.String()
}

// SetCumulativeBytesMetered sets the CumulativeBytesMetered field's value.
func (s *QueryStatus) SetCumulativeBytesMetered(v int64) *QueryStatus {
	s.CumulativeBytesMetered = &v
	return s
}

// SetCumulativeBytesScanned sets the CumulativeBytesScanned field's value.
func (s *QueryStatus) SetCumulativeBytesScanned(v int64) *QueryStatus {
	s.CumulativeBytesScanned = &v
	return s
}

// SetProgressPercentage sets the ProgressPercentage field's value.
func (s *QueryStatus) SetProgressPercentage(v float64) *QueryStatus {
	s.ProgressPercentage = &v
	return s
}

// The requested resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ARN of the scheduled query.
	ScheduledQueryArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a single row in the query results.
type Row struct {
	_ struct{} `type:"structure"`

	// List of data points in a single row of the result set.
	//
	// Data is a required field
	Data []*Datum `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Row) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Row) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Row) SetData(v []*Datum) *Row {
	s.Data = v
	return s
}

// Details on S3 location for error reports that result from running a query.
type S3Configuration struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket under which error reports will be created.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// Encryption at rest options for the error reports. If no encryption option
	// is specified, Timestream will choose SSE_S3 as default.
	EncryptionOption *string `type:"string" enum:"S3EncryptionOption"`

	// Prefix for the error report key. Timestream by default adds the following
	// prefix to the error report path.
	ObjectKeyPrefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Configuration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.ObjectKeyPrefix != nil && len(*s.ObjectKeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectKeyPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Configuration) SetBucketName(v string) *S3Configuration {
	s.BucketName = &v
	return s
}

// SetEncryptionOption sets the EncryptionOption field's value.
func (s *S3Configuration) SetEncryptionOption(v string) *S3Configuration {
	s.EncryptionOption = &v
	return s
}

// SetObjectKeyPrefix sets the ObjectKeyPrefix field's value.
func (s *S3Configuration) SetObjectKeyPrefix(v string) *S3Configuration {
	s.ObjectKeyPrefix = &v
	return s
}

// S3 report location for the scheduled query run.
type S3ReportLocation struct {
	_ struct{} `type:"structure"`

	// S3 bucket name.
	BucketName *string `min:"3" type:"string"`

	// S3 key.
	ObjectKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ReportLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ReportLocation) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *S3ReportLocation) SetBucketName(v string) *S3ReportLocation {
	s.BucketName = &v
	return s
}

// SetObjectKey sets the ObjectKey field's value.
func (s *S3ReportLocation) SetObjectKey(v string) *S3ReportLocation {
	s.ObjectKey = &v
	return s
}

// Configuration of the schedule of the query.
type ScheduleConfiguration struct {
	_ struct{} `type:"structure"`

	// An expression that denotes when to trigger the scheduled query run. This
	// can be a cron expression or a rate expression.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleConfiguration"}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *ScheduleConfiguration) SetScheduleExpression(v string) *ScheduleConfiguration {
	s.ScheduleExpression = &v
	return s
}

// Scheduled Query
type ScheduledQuery struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The creation time of the scheduled query.
	CreationTime *time.Time `type:"timestamp"`

	// Configuration for scheduled query error reporting.
	ErrorReportConfiguration *ErrorReportConfiguration `type:"structure"`

	// Status of the last scheduled query run.
	LastRunStatus *string `type:"string" enum:"ScheduledQueryRunStatus"`

	// The name of the scheduled query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The next time the scheduled query is to be run.
	NextInvocationTime *time.Time `type:"timestamp"`

	// The last time the scheduled query was run.
	PreviousInvocationTime *time.Time `type:"timestamp"`

	// State of scheduled query.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ScheduledQueryState"`

	// Target data source where final scheduled query result will be written.
	TargetDestination *TargetDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledQuery) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ScheduledQuery) SetArn(v string) *ScheduledQuery {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScheduledQuery) SetCreationTime(v time.Time) *ScheduledQuery {
	s.CreationTime = &v
	return s
}

// SetErrorReportConfiguration sets the ErrorReportConfiguration field's value.
func (s *ScheduledQuery) SetErrorReportConfiguration(v *ErrorReportConfiguration) *ScheduledQuery {
	s.ErrorReportConfiguration = v
	return s
}

// SetLastRunStatus sets the LastRunStatus field's value.
func (s *ScheduledQuery) SetLastRunStatus(v string) *ScheduledQuery {
	s.LastRunStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScheduledQuery) SetName(v string) *ScheduledQuery {
	s.Name = &v
	return s
}

// SetNextInvocationTime sets the NextInvocationTime field's value.
func (s *ScheduledQuery) SetNextInvocationTime(v time.Time) *ScheduledQuery {
	s.NextInvocationTime = &v
	return s
}

// SetPreviousInvocationTime sets the PreviousInvocationTime field's value.
func (s *ScheduledQuery) SetPreviousInvocationTime(v time.Time) *ScheduledQuery {
	s.PreviousInvocationTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ScheduledQuery) SetState(v string) *ScheduledQuery {
	s.State = &v
	return s
}

// SetTargetDestination sets the TargetDestination field's value.
func (s *ScheduledQuery) SetTargetDestination(v *TargetDestination) *ScheduledQuery {
	s.TargetDestination = v
	return s
}

// Structure that describes scheduled query.
type ScheduledQueryDescription struct {
	_ struct{} `type:"structure"`

	// Scheduled query ARN.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// Creation time of the scheduled query.
	CreationTime *time.Time `type:"timestamp"`

	// Error-reporting configuration for the scheduled query.
	ErrorReportConfiguration *ErrorReportConfiguration `type:"structure"`

	// A customer provided KMS key used to encrypt the scheduled query resource.
	KmsKeyId *string `min:"1" type:"string"`

	// Runtime summary for the last scheduled query run.
	LastRunSummary *ScheduledQueryRunSummary `type:"structure"`

	// Name of the scheduled query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The next time the scheduled query is scheduled to run.
	NextInvocationTime *time.Time `type:"timestamp"`

	// Notification configuration.
	//
	// NotificationConfiguration is a required field
	NotificationConfiguration *NotificationConfiguration `type:"structure" required:"true"`

	// Last time the query was run.
	PreviousInvocationTime *time.Time `type:"timestamp"`

	// The query to be run.
	//
	// QueryString is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ScheduledQueryDescription's
	// String and GoString methods.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Runtime summary for the last five failed scheduled query runs.
	RecentlyFailedRuns []*ScheduledQueryRunSummary `type:"list"`

	// Schedule configuration.
	//
	// ScheduleConfiguration is a required field
	ScheduleConfiguration *ScheduleConfiguration `type:"structure" required:"true"`

	// IAM role that Timestream uses to run the schedule query.
	ScheduledQueryExecutionRoleArn *string `min:"1" type:"string"`

	// State of the scheduled query.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ScheduledQueryState"`

	// Scheduled query target store configuration.
	TargetConfiguration *TargetConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledQueryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledQueryDescription) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ScheduledQueryDescription) SetArn(v string) *ScheduledQueryDescription {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScheduledQueryDescription) SetCreationTime(v time.Time) *ScheduledQueryDescription {
	s.CreationTime = &v
	return s
}

// SetErrorReportConfiguration sets the ErrorReportConfiguration field's value.
func (s *ScheduledQueryDescription) SetErrorReportConfiguration(v *ErrorReportConfiguration) *ScheduledQueryDescription {
	s.ErrorReportConfiguration = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ScheduledQueryDescription) SetKmsKeyId(v string) *ScheduledQueryDescription {
	s.KmsKeyId = &v
	return s
}

// SetLastRunSummary sets the LastRunSummary field's value.
func (s *ScheduledQueryDescription) SetLastRunSummary(v *ScheduledQueryRunSummary) *ScheduledQueryDescription {
	s.LastRunSummary = v
	return s
}

// SetName sets the Name field's value.
func (s *ScheduledQueryDescription) SetName(v string) *ScheduledQueryDescription {
	s.Name = &v
	return s
}

// SetNextInvocationTime sets the NextInvocationTime field's value.
func (s *ScheduledQueryDescription) SetNextInvocationTime(v time.Time) *ScheduledQueryDescription {
	s.NextInvocationTime = &v
	return s
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *ScheduledQueryDescription) SetNotificationConfiguration(v *NotificationConfiguration) *ScheduledQueryDescription {
	s.NotificationConfiguration = v
	return s
}

// SetPreviousInvocationTime sets the PreviousInvocationTime field's value.
func (s *ScheduledQueryDescription) SetPreviousInvocationTime(v time.Time) *ScheduledQueryDescription {
	s.PreviousInvocationTime = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *ScheduledQueryDescription) SetQueryString(v string) *ScheduledQueryDescription {
	s.QueryString = &v
	return s
}

// SetRecentlyFailedRuns sets the RecentlyFailedRuns field's value.
func (s *ScheduledQueryDescription) SetRecentlyFailedRuns(v []*ScheduledQueryRunSummary) *ScheduledQueryDescription {
	s.RecentlyFailedRuns = v
	return s
}

// SetScheduleConfiguration sets the ScheduleConfiguration field's value.
func (s *ScheduledQueryDescription) SetScheduleConfiguration(v *ScheduleConfiguration) *ScheduledQueryDescription {
	s.ScheduleConfiguration = v
	return s
}

// SetScheduledQueryExecutionRoleArn sets the ScheduledQueryExecutionRoleArn field's value.
func (s *ScheduledQueryDescription) SetScheduledQueryExecutionRoleArn(v string) *ScheduledQueryDescription {
	s.ScheduledQueryExecutionRoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *ScheduledQueryDescription) SetState(v string) *ScheduledQueryDescription {
	s.State = &v
	return s
}

// SetTargetConfiguration sets the TargetConfiguration field's value.
func (s *ScheduledQueryDescription) SetTargetConfiguration(v *TargetConfiguration) *ScheduledQueryDescription {
	s.TargetConfiguration = v
	return s
}

// Run summary for the scheduled query
type ScheduledQueryRunSummary struct {
	_ struct{} `type:"structure"`

	// S3 location for error report.
	ErrorReportLocation *ErrorReportLocation `type:"structure"`

	// Runtime statistics for a scheduled run.
	ExecutionStats *ExecutionStats `type:"structure"`

	// Error message for the scheduled query in case of failure. You might have
	// to look at the error report to get more detailed error reasons.
	FailureReason *string `type:"string"`

	// InvocationTime for this run. This is the time at which the query is scheduled
	// to run. Parameter @scheduled_runtime can be used in the query to get the
	// value.
	InvocationTime *time.Time `type:"timestamp"`

	// The status of a scheduled query run.
	RunStatus *string `type:"string" enum:"ScheduledQueryRunStatus"`

	// The actual time when the query was run.
	TriggerTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledQueryRunSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledQueryRunSummary) GoString() string {
	return s.String()
}

// SetErrorReportLocation sets the ErrorReportLocation field's value.
func (s *ScheduledQueryRunSummary) SetErrorReportLocation(v *ErrorReportLocation) *ScheduledQueryRunSummary {
	s.ErrorReportLocation = v
	return s
}

// SetExecutionStats sets the ExecutionStats field's value.
func (s *ScheduledQueryRunSummary) SetExecutionStats(v *ExecutionStats) *ScheduledQueryRunSummary {
	s.ExecutionStats = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *ScheduledQueryRunSummary) SetFailureReason(v string) *ScheduledQueryRunSummary {
	s.FailureReason = &v
	return s
}

// SetInvocationTime sets the InvocationTime field's value.
func (s *ScheduledQueryRunSummary) SetInvocationTime(v time.Time) *ScheduledQueryRunSummary {
	s.InvocationTime = &v
	return s
}

// SetRunStatus sets the RunStatus field's value.
func (s *ScheduledQueryRunSummary) SetRunStatus(v string) *ScheduledQueryRunSummary {
	s.RunStatus = &v
	return s
}

// SetTriggerTime sets the TriggerTime field's value.
func (s *ScheduledQueryRunSummary) SetTriggerTime(v time.Time) *ScheduledQueryRunSummary {
	s.TriggerTime = &v
	return s
}

// Details of the column that is returned by the query.
type SelectColumn struct {
	_ struct{} `type:"structure"`

	// True, if the column name was aliased by the query. False otherwise.
	Aliased *bool `type:"boolean"`

	// Database that has this column.
	DatabaseName *string `type:"string"`

	// Name of the column.
	Name *string `type:"string"`

	// Table within the database that has this column.
	TableName *string `type:"string"`

	// Contains the data type of a column in a query result set. The data type can
	// be scalar or complex. The supported scalar data types are integers, Boolean,
	// string, double, timestamp, date, time, and intervals. The supported complex
	// data types are arrays, rows, and timeseries.
	Type *Type `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectColumn) GoString() string {
	return s.String()
}

// SetAliased sets the Aliased field's value.
func (s *SelectColumn) SetAliased(v bool) *SelectColumn {
	s.Aliased = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *SelectColumn) SetDatabaseName(v string) *SelectColumn {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *SelectColumn) SetName(v string) *SelectColumn {
	s.Name = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *SelectColumn) SetTableName(v string) *SelectColumn {
	s.TableName = &v
	return s
}

// SetType sets the Type field's value.
func (s *SelectColumn) SetType(v *Type) *SelectColumn {
	s.Type = v
	return s
}

// You have exceeded the service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details on SNS that are required to send the notification.
type SnsConfiguration struct {
	_ struct{} `type:"structure"`

	// SNS topic ARN that the scheduled query status notifications will be sent
	// to.
	//
	// TopicArn is a required field
	TopicArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnsConfiguration"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}
	if s.TopicArn != nil && len(*s.TopicArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *SnsConfiguration) SetTopicArn(v string) *SnsConfiguration {
	s.TopicArn = &v
	return s
}

// A tag is a label that you assign to a Timestream database and/or table. Each
// tag consists of a key and an optional value, both of which you define. Tags
// enable you to categorize databases and/or tables, for example, by purpose,
// owner, or environment.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag. Tag keys are case sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag. Tag values are case sensitive and can be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the Timestream resource to which tags should be added. This value
	// is an Amazon Resource Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tags to be assigned to the Timestream resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Configuration used for writing the output of a query.
type TargetConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration needed to write data into the Timestream database and table.
	//
	// TimestreamConfiguration is a required field
	TimestreamConfiguration *TimestreamConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetConfiguration"}
	if s.TimestreamConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TimestreamConfiguration"))
	}
	if s.TimestreamConfiguration != nil {
		if err := s.TimestreamConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TimestreamConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTimestreamConfiguration sets the TimestreamConfiguration field's value.
func (s *TargetConfiguration) SetTimestreamConfiguration(v *TimestreamConfiguration) *TargetConfiguration {
	s.TimestreamConfiguration = v
	return s
}

// Destination details to write data for a target data source. Current supported
// data source is Timestream.
type TargetDestination struct {
	_ struct{} `type:"structure"`

	// Query result destination details for Timestream data source.
	TimestreamDestination *TimestreamDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetDestination) GoString() string {
	return s.String()
}

// SetTimestreamDestination sets the TimestreamDestination field's value.
func (s *TargetDestination) SetTimestreamDestination(v *TimestreamDestination) *TargetDestination {
	s.TimestreamDestination = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The timeseries data type represents the values of a measure over time. A
// time series is an array of rows of timestamps and measure values, with rows
// sorted in ascending order of time. A TimeSeriesDataPoint is a single data
// point in the time series. It represents a tuple of (time, measure value)
// in a time series.
type TimeSeriesDataPoint struct {
	_ struct{} `type:"structure"`

	// The timestamp when the measure value was collected.
	//
	// Time is a required field
	Time *string `type:"string" required:"true"`

	// The measure value for the data point.
	//
	// Value is a required field
	Value *Datum `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeriesDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeSeriesDataPoint) GoString() string {
	return s.String()
}

// SetTime sets the Time field's value.
func (s *TimeSeriesDataPoint) SetTime(v string) *TimeSeriesDataPoint {
	s.Time = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TimeSeriesDataPoint) SetValue(v *Datum) *TimeSeriesDataPoint {
	s.Value = v
	return s
}

// Configuration to write data into Timestream database and table. This configuration
// allows the user to map the query result select columns into the destination
// table columns.
type TimestreamConfiguration struct {
	_ struct{} `type:"structure"`

	// Name of Timestream database to which the query result will be written.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// This is to allow mapping column(s) from the query result to the dimension
	// in the destination table.
	//
	// DimensionMappings is a required field
	DimensionMappings []*DimensionMapping `type:"list" required:"true"`

	// Name of the measure column.
	MeasureNameColumn *string `type:"string"`

	// Specifies how to map measures to multi-measure records.
	MixedMeasureMappings []*MixedMeasureMapping `min:"1" type:"list"`

	// Multi-measure mappings.
	MultiMeasureMappings *MultiMeasureMappings `type:"structure"`

	// Name of Timestream table that the query result will be written to. The table
	// should be within the same database that is provided in Timestream configuration.
	//
	// TableName is a required field
	TableName *string `type:"string" required:"true"`

	// Column from query result that should be used as the time column in destination
	// table. Column type for this should be TIMESTAMP.
	//
	// TimeColumn is a required field
	TimeColumn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimestreamConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimestreamConfiguration"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DimensionMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionMappings"))
	}
	if s.MixedMeasureMappings != nil && len(s.MixedMeasureMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MixedMeasureMappings", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TimeColumn == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeColumn"))
	}
	if s.DimensionMappings != nil {
		for i, v := range s.DimensionMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MixedMeasureMappings != nil {
		for i, v := range s.MixedMeasureMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MixedMeasureMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MultiMeasureMappings != nil {
		if err := s.MultiMeasureMappings.Validate(); err != nil {
			invalidParams.AddNested("MultiMeasureMappings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *TimestreamConfiguration) SetDatabaseName(v string) *TimestreamConfiguration {
	s.DatabaseName = &v
	return s
}

// SetDimensionMappings sets the DimensionMappings field's value.
func (s *TimestreamConfiguration) SetDimensionMappings(v []*DimensionMapping) *TimestreamConfiguration {
	s.DimensionMappings = v
	return s
}

// SetMeasureNameColumn sets the MeasureNameColumn field's value.
func (s *TimestreamConfiguration) SetMeasureNameColumn(v string) *TimestreamConfiguration {
	s.MeasureNameColumn = &v
	return s
}

// SetMixedMeasureMappings sets the MixedMeasureMappings field's value.
func (s *TimestreamConfiguration) SetMixedMeasureMappings(v []*MixedMeasureMapping) *TimestreamConfiguration {
	s.MixedMeasureMappings = v
	return s
}

// SetMultiMeasureMappings sets the MultiMeasureMappings field's value.
func (s *TimestreamConfiguration) SetMultiMeasureMappings(v *MultiMeasureMappings) *TimestreamConfiguration {
	s.MultiMeasureMappings = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TimestreamConfiguration) SetTableName(v string) *TimestreamConfiguration {
	s.TableName = &v
	return s
}

// SetTimeColumn sets the TimeColumn field's value.
func (s *TimestreamConfiguration) SetTimeColumn(v string) *TimestreamConfiguration {
	s.TimeColumn = &v
	return s
}

// Destination for scheduled query.
type TimestreamDestination struct {
	_ struct{} `type:"structure"`

	// Timestream database name.
	DatabaseName *string `type:"string"`

	// Timestream table name.
	TableName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimestreamDestination) GoString() string {
	return s.String()
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *TimestreamDestination) SetDatabaseName(v string) *TimestreamDestination {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TimestreamDestination) SetTableName(v string) *TimestreamDestination {
	s.TableName = &v
	return s
}

// Contains the data type of a column in a query result set. The data type can
// be scalar or complex. The supported scalar data types are integers, Boolean,
// string, double, timestamp, date, time, and intervals. The supported complex
// data types are arrays, rows, and timeseries.
type Type struct {
	_ struct{} `type:"structure"`

	// Indicates if the column is an array.
	ArrayColumnInfo *ColumnInfo `type:"structure"`

	// Indicates if the column is a row.
	RowColumnInfo []*ColumnInfo `type:"list"`

	// Indicates if the column is of type string, integer, Boolean, double, timestamp,
	// date, time.
	ScalarType *string `type:"string" enum:"ScalarType"`

	// Indicates if the column is a timeseries data type.
	TimeSeriesMeasureValueColumnInfo *ColumnInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Type) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Type) GoString() string {
	return s.String()
}

// SetArrayColumnInfo sets the ArrayColumnInfo field's value.
func (s *Type) SetArrayColumnInfo(v *ColumnInfo) *Type {
	s.ArrayColumnInfo = v
	return s
}

// SetRowColumnInfo sets the RowColumnInfo field's value.
func (s *Type) SetRowColumnInfo(v []*ColumnInfo) *Type {
	s.RowColumnInfo = v
	return s
}

// SetScalarType sets the ScalarType field's value.
func (s *Type) SetScalarType(v string) *Type {
	s.ScalarType = &v
	return s
}

// SetTimeSeriesMeasureValueColumnInfo sets the TimeSeriesMeasureValueColumnInfo field's value.
func (s *Type) SetTimeSeriesMeasureValueColumnInfo(v *ColumnInfo) *Type {
	s.TimeSeriesMeasureValueColumnInfo = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Timestream resource that the tags will be removed from. This value is
	// an Amazon Resource Name (ARN).
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tags keys. Existing tags of the resource whose keys are members
	// of this list will be removed from the Timestream resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateScheduledQueryInput struct {
	_ struct{} `type:"structure"`

	// ARN of the scheuled query.
	//
	// ScheduledQueryArn is a required field
	ScheduledQueryArn *string `min:"1" type:"string" required:"true"`

	// State of the scheduled query.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ScheduledQueryState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScheduledQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateScheduledQueryInput"}
	if s.ScheduledQueryArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledQueryArn"))
	}
	if s.ScheduledQueryArn != nil && len(*s.ScheduledQueryArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledQueryArn", 1))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledQueryArn sets the ScheduledQueryArn field's value.
func (s *UpdateScheduledQueryInput) SetScheduledQueryArn(v string) *UpdateScheduledQueryInput {
	s.ScheduledQueryArn = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateScheduledQueryInput) SetState(v string) *UpdateScheduledQueryInput {
	s.State = &v
	return s
}

type UpdateScheduledQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledQueryOutput) GoString() string {
	return s.String()
}

// Invalid or malformed request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DimensionValueTypeVarchar is a DimensionValueType enum value
	DimensionValueTypeVarchar = "VARCHAR"
)

// DimensionValueType_Values returns all elements of the DimensionValueType enum
func DimensionValueType_Values() []string {
	return []string{
		DimensionValueTypeVarchar,
	}
}

const (
	// MeasureValueTypeBigint is a MeasureValueType enum value
	MeasureValueTypeBigint = "BIGINT"

	// MeasureValueTypeBoolean is a MeasureValueType enum value
	MeasureValueTypeBoolean = "BOOLEAN"

	// MeasureValueTypeDouble is a MeasureValueType enum value
	MeasureValueTypeDouble = "DOUBLE"

	// MeasureValueTypeVarchar is a MeasureValueType enum value
	MeasureValueTypeVarchar = "VARCHAR"

	// MeasureValueTypeMulti is a MeasureValueType enum value
	MeasureValueTypeMulti = "MULTI"
)

// MeasureValueType_Values returns all elements of the MeasureValueType enum
func MeasureValueType_Values() []string {
	return []string{
		MeasureValueTypeBigint,
		MeasureValueTypeBoolean,
		MeasureValueTypeDouble,
		MeasureValueTypeVarchar,
		MeasureValueTypeMulti,
	}
}

const (
	// S3EncryptionOptionSseS3 is a S3EncryptionOption enum value
	S3EncryptionOptionSseS3 = "SSE_S3"

	// S3EncryptionOptionSseKms is a S3EncryptionOption enum value
	S3EncryptionOptionSseKms = "SSE_KMS"
)

// S3EncryptionOption_Values returns all elements of the S3EncryptionOption enum
func S3EncryptionOption_Values() []string {
	return []string{
		S3EncryptionOptionSseS3,
		S3EncryptionOptionSseKms,
	}
}

const (
	// ScalarMeasureValueTypeBigint is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeBigint = "BIGINT"

	// ScalarMeasureValueTypeBoolean is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeBoolean = "BOOLEAN"

	// ScalarMeasureValueTypeDouble is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeDouble = "DOUBLE"

	// ScalarMeasureValueTypeVarchar is a ScalarMeasureValueType enum value
	ScalarMeasureValueTypeVarchar = "VARCHAR"
)

// ScalarMeasureValueType_Values returns all elements of the ScalarMeasureValueType enum
func ScalarMeasureValueType_Values() []string {
	return []string{
		ScalarMeasureValueTypeBigint,
		ScalarMeasureValueTypeBoolean,
		ScalarMeasureValueTypeDouble,
		ScalarMeasureValueTypeVarchar,
	}
}

const (
	// ScalarTypeVarchar is a ScalarType enum value
	ScalarTypeVarchar = "VARCHAR"

	// ScalarTypeBoolean is a ScalarType enum value
	ScalarTypeBoolean = "BOOLEAN"

	// ScalarTypeBigint is a ScalarType enum value
	ScalarTypeBigint = "BIGINT"

	// ScalarTypeDouble is a ScalarType enum value
	ScalarTypeDouble = "DOUBLE"

	// ScalarTypeTimestamp is a ScalarType enum value
	ScalarTypeTimestamp = "TIMESTAMP"

	// ScalarTypeDate is a ScalarType enum value
	ScalarTypeDate = "DATE"

	// ScalarTypeTime is a ScalarType enum value
	ScalarTypeTime = "TIME"

	// ScalarTypeIntervalDayToSecond is a ScalarType enum value
	ScalarTypeIntervalDayToSecond = "INTERVAL_DAY_TO_SECOND"

	// ScalarTypeIntervalYearToMonth is a ScalarType enum value
	ScalarTypeIntervalYearToMonth = "INTERVAL_YEAR_TO_MONTH"

	// ScalarTypeUnknown is a ScalarType enum value
	ScalarTypeUnknown = "UNKNOWN"

	// ScalarTypeInteger is a ScalarType enum value
	ScalarTypeInteger = "INTEGER"
)

// ScalarType_Values returns all elements of the ScalarType enum
func ScalarType_Values() []string {
	return []string{
		ScalarTypeVarchar,
		ScalarTypeBoolean,
		ScalarTypeBigint,
		ScalarTypeDouble,
		ScalarTypeTimestamp,
		ScalarTypeDate,
		ScalarTypeTime,
		ScalarTypeIntervalDayToSecond,
		ScalarTypeIntervalYearToMonth,
		ScalarTypeUnknown,
		ScalarTypeInteger,
	}
}

const (
	// ScheduledQueryRunStatusAutoTriggerSuccess is a ScheduledQueryRunStatus enum value
	ScheduledQueryRunStatusAutoTriggerSuccess = "AUTO_TRIGGER_SUCCESS"

	// ScheduledQueryRunStatusAutoTriggerFailure is a ScheduledQueryRunStatus enum value
	ScheduledQueryRunStatusAutoTriggerFailure = "AUTO_TRIGGER_FAILURE"

	// ScheduledQueryRunStatusManualTriggerSuccess is a ScheduledQueryRunStatus enum value
	ScheduledQueryRunStatusManualTriggerSuccess = "MANUAL_TRIGGER_SUCCESS"

	// ScheduledQueryRunStatusManualTriggerFailure is a ScheduledQueryRunStatus enum value
	ScheduledQueryRunStatusManualTriggerFailure = "MANUAL_TRIGGER_FAILURE"
)

// ScheduledQueryRunStatus_Values returns all elements of the ScheduledQueryRunStatus enum
func ScheduledQueryRunStatus_Values() []string {
	return []string{
		ScheduledQueryRunStatusAutoTriggerSuccess,
		ScheduledQueryRunStatusAutoTriggerFailure,
		ScheduledQueryRunStatusManualTriggerSuccess,
		ScheduledQueryRunStatusManualTriggerFailure,
	}
}

const (
	// ScheduledQueryStateEnabled is a ScheduledQueryState enum value
	ScheduledQueryStateEnabled = "ENABLED"

	// ScheduledQueryStateDisabled is a ScheduledQueryState enum value
	ScheduledQueryStateDisabled = "DISABLED"
)

// ScheduledQueryState_Values returns all elements of the ScheduledQueryState enum
func ScheduledQueryState_Values() []string {
	return []string{
		ScheduledQueryStateEnabled,
		ScheduledQueryStateDisabled,
	}
}
