// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAttachInstances = "AttachInstances"

// AttachInstancesRequest generates a "aws/request.Request" representing the
// client's request for the AttachInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachInstances for more information on using the AttachInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachInstancesRequest method.
//    req, resp := client.AttachInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances
func (c *AutoScaling) AttachInstancesRequest(input *AttachInstancesInput) (req *request.Request, output *AttachInstancesOutput) {
	op := &request.Operation{
		Name:       opAttachInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInstancesInput{}
	}

	output = &AttachInstancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachInstances API operation for Auto Scaling.
//
// Attaches one or more EC2 instances to the specified Auto Scaling group.
//
// When you attach instances, Amazon EC2 Auto Scaling increases the desired
// capacity of the group by the number of instances being attached. If the number
// of instances being attached plus the desired capacity of the group exceeds
// the maximum size of the group, the operation fails.
//
// If there is a Classic Load Balancer attached to your Auto Scaling group,
// the instances are also registered with the load balancer. If there are target
// groups attached to your Auto Scaling group, the instances are also registered
// with the target groups.
//
// For more information, see Attach EC2 instances to your Auto Scaling group
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation AttachInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances
func (c *AutoScaling) AttachInstances(input *AttachInstancesInput) (*AttachInstancesOutput, error) {
	req, out := c.AttachInstancesRequest(input)
	return out, req.Send()
}

// AttachInstancesWithContext is the same as AttachInstances with the addition of
// the ability to pass a context and additional request options.
//
// See AttachInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) AttachInstancesWithContext(ctx aws.Context, input *AttachInstancesInput, opts ...request.Option) (*AttachInstancesOutput, error) {
	req, out := c.AttachInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachLoadBalancerTargetGroups = "AttachLoadBalancerTargetGroups"

// AttachLoadBalancerTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the AttachLoadBalancerTargetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachLoadBalancerTargetGroups for more information on using the AttachLoadBalancerTargetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachLoadBalancerTargetGroupsRequest method.
//    req, resp := client.AttachLoadBalancerTargetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancerTargetGroups
func (c *AutoScaling) AttachLoadBalancerTargetGroupsRequest(input *AttachLoadBalancerTargetGroupsInput) (req *request.Request, output *AttachLoadBalancerTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opAttachLoadBalancerTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancerTargetGroupsInput{}
	}

	output = &AttachLoadBalancerTargetGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachLoadBalancerTargetGroups API operation for Auto Scaling.
//
// Attaches one or more target groups to the specified Auto Scaling group.
//
// This operation is used with the following load balancer types:
//
//    * Application Load Balancer - Operates at the application layer (layer
//    7) and supports HTTP and HTTPS.
//
//    * Network Load Balancer - Operates at the transport layer (layer 4) and
//    supports TCP, TLS, and UDP.
//
//    * Gateway Load Balancer - Operates at the network layer (layer 3).
//
// To describe the target groups for an Auto Scaling group, call the DescribeLoadBalancerTargetGroups
// API. To detach the target group from the Auto Scaling group, call the DetachLoadBalancerTargetGroups
// API.
//
// This operation is additive and does not detach existing target groups or
// Classic Load Balancers from the Auto Scaling group.
//
// For more information, see Elastic Load Balancing and Amazon EC2 Auto Scaling
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation AttachLoadBalancerTargetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancerTargetGroups
func (c *AutoScaling) AttachLoadBalancerTargetGroups(input *AttachLoadBalancerTargetGroupsInput) (*AttachLoadBalancerTargetGroupsOutput, error) {
	req, out := c.AttachLoadBalancerTargetGroupsRequest(input)
	return out, req.Send()
}

// AttachLoadBalancerTargetGroupsWithContext is the same as AttachLoadBalancerTargetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See AttachLoadBalancerTargetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) AttachLoadBalancerTargetGroupsWithContext(ctx aws.Context, input *AttachLoadBalancerTargetGroupsInput, opts ...request.Option) (*AttachLoadBalancerTargetGroupsOutput, error) {
	req, out := c.AttachLoadBalancerTargetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachLoadBalancers = "AttachLoadBalancers"

// AttachLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the AttachLoadBalancers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachLoadBalancers for more information on using the AttachLoadBalancers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachLoadBalancersRequest method.
//    req, resp := client.AttachLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancers
func (c *AutoScaling) AttachLoadBalancersRequest(input *AttachLoadBalancersInput) (req *request.Request, output *AttachLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opAttachLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancersInput{}
	}

	output = &AttachLoadBalancersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachLoadBalancers API operation for Auto Scaling.
//
//
// To attach an Application Load Balancer, Network Load Balancer, or Gateway
// Load Balancer, use the AttachLoadBalancerTargetGroups API operation instead.
//
// Attaches one or more Classic Load Balancers to the specified Auto Scaling
// group. Amazon EC2 Auto Scaling registers the running instances with these
// Classic Load Balancers.
//
// To describe the load balancers for an Auto Scaling group, call the DescribeLoadBalancers
// API. To detach the load balancer from the Auto Scaling group, call the DetachLoadBalancers
// API.
//
// This operation is additive and does not detach existing Classic Load Balancers
// or target groups from the Auto Scaling group.
//
// For more information, see Elastic Load Balancing and Amazon EC2 Auto Scaling
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation AttachLoadBalancers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancers
func (c *AutoScaling) AttachLoadBalancers(input *AttachLoadBalancersInput) (*AttachLoadBalancersOutput, error) {
	req, out := c.AttachLoadBalancersRequest(input)
	return out, req.Send()
}

// AttachLoadBalancersWithContext is the same as AttachLoadBalancers with the addition of
// the ability to pass a context and additional request options.
//
// See AttachLoadBalancers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) AttachLoadBalancersWithContext(ctx aws.Context, input *AttachLoadBalancersInput, opts ...request.Option) (*AttachLoadBalancersOutput, error) {
	req, out := c.AttachLoadBalancersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteScheduledAction = "BatchDeleteScheduledAction"

// BatchDeleteScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteScheduledAction for more information on using the BatchDeleteScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteScheduledActionRequest method.
//    req, resp := client.BatchDeleteScheduledActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchDeleteScheduledAction
func (c *AutoScaling) BatchDeleteScheduledActionRequest(input *BatchDeleteScheduledActionInput) (req *request.Request, output *BatchDeleteScheduledActionOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteScheduledActionInput{}
	}

	output = &BatchDeleteScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteScheduledAction API operation for Auto Scaling.
//
// Deletes one or more scheduled actions for the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation BatchDeleteScheduledAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchDeleteScheduledAction
func (c *AutoScaling) BatchDeleteScheduledAction(input *BatchDeleteScheduledActionInput) (*BatchDeleteScheduledActionOutput, error) {
	req, out := c.BatchDeleteScheduledActionRequest(input)
	return out, req.Send()
}

// BatchDeleteScheduledActionWithContext is the same as BatchDeleteScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) BatchDeleteScheduledActionWithContext(ctx aws.Context, input *BatchDeleteScheduledActionInput, opts ...request.Option) (*BatchDeleteScheduledActionOutput, error) {
	req, out := c.BatchDeleteScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutScheduledUpdateGroupAction = "BatchPutScheduledUpdateGroupAction"

// BatchPutScheduledUpdateGroupActionRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutScheduledUpdateGroupAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutScheduledUpdateGroupAction for more information on using the BatchPutScheduledUpdateGroupAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutScheduledUpdateGroupActionRequest method.
//    req, resp := client.BatchPutScheduledUpdateGroupActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchPutScheduledUpdateGroupAction
func (c *AutoScaling) BatchPutScheduledUpdateGroupActionRequest(input *BatchPutScheduledUpdateGroupActionInput) (req *request.Request, output *BatchPutScheduledUpdateGroupActionOutput) {
	op := &request.Operation{
		Name:       opBatchPutScheduledUpdateGroupAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchPutScheduledUpdateGroupActionInput{}
	}

	output = &BatchPutScheduledUpdateGroupActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutScheduledUpdateGroupAction API operation for Auto Scaling.
//
// Creates or updates one or more scheduled scaling actions for an Auto Scaling
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation BatchPutScheduledUpdateGroupAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsFault "AlreadyExists"
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchPutScheduledUpdateGroupAction
func (c *AutoScaling) BatchPutScheduledUpdateGroupAction(input *BatchPutScheduledUpdateGroupActionInput) (*BatchPutScheduledUpdateGroupActionOutput, error) {
	req, out := c.BatchPutScheduledUpdateGroupActionRequest(input)
	return out, req.Send()
}

// BatchPutScheduledUpdateGroupActionWithContext is the same as BatchPutScheduledUpdateGroupAction with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutScheduledUpdateGroupAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) BatchPutScheduledUpdateGroupActionWithContext(ctx aws.Context, input *BatchPutScheduledUpdateGroupActionInput, opts ...request.Option) (*BatchPutScheduledUpdateGroupActionOutput, error) {
	req, out := c.BatchPutScheduledUpdateGroupActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelInstanceRefresh = "CancelInstanceRefresh"

// CancelInstanceRefreshRequest generates a "aws/request.Request" representing the
// client's request for the CancelInstanceRefresh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelInstanceRefresh for more information on using the CancelInstanceRefresh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelInstanceRefreshRequest method.
//    req, resp := client.CancelInstanceRefreshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CancelInstanceRefresh
func (c *AutoScaling) CancelInstanceRefreshRequest(input *CancelInstanceRefreshInput) (req *request.Request, output *CancelInstanceRefreshOutput) {
	op := &request.Operation{
		Name:       opCancelInstanceRefresh,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelInstanceRefreshInput{}
	}

	output = &CancelInstanceRefreshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelInstanceRefresh API operation for Auto Scaling.
//
// Cancels an instance refresh operation in progress. Cancellation does not
// roll back any replacements that have already been completed, but it prevents
// new replacements from being started.
//
// This operation is part of the instance refresh feature (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
// in Amazon EC2 Auto Scaling, which helps you update instances in your Auto
// Scaling group after you make configuration changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CancelInstanceRefresh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeActiveInstanceRefreshNotFoundFault "ActiveInstanceRefreshNotFound"
//   The request failed because an active instance refresh for the specified Auto
//   Scaling group was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CancelInstanceRefresh
func (c *AutoScaling) CancelInstanceRefresh(input *CancelInstanceRefreshInput) (*CancelInstanceRefreshOutput, error) {
	req, out := c.CancelInstanceRefreshRequest(input)
	return out, req.Send()
}

// CancelInstanceRefreshWithContext is the same as CancelInstanceRefresh with the addition of
// the ability to pass a context and additional request options.
//
// See CancelInstanceRefresh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) CancelInstanceRefreshWithContext(ctx aws.Context, input *CancelInstanceRefreshInput, opts ...request.Option) (*CancelInstanceRefreshOutput, error) {
	req, out := c.CancelInstanceRefreshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteLifecycleAction = "CompleteLifecycleAction"

// CompleteLifecycleActionRequest generates a "aws/request.Request" representing the
// client's request for the CompleteLifecycleAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteLifecycleAction for more information on using the CompleteLifecycleAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CompleteLifecycleActionRequest method.
//    req, resp := client.CompleteLifecycleActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction
func (c *AutoScaling) CompleteLifecycleActionRequest(input *CompleteLifecycleActionInput) (req *request.Request, output *CompleteLifecycleActionOutput) {
	op := &request.Operation{
		Name:       opCompleteLifecycleAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteLifecycleActionInput{}
	}

	output = &CompleteLifecycleActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CompleteLifecycleAction API operation for Auto Scaling.
//
// Completes the lifecycle action for the specified token or instance with the
// specified result.
//
// This step is a part of the procedure for adding a lifecycle hook to an Auto
// Scaling group:
//
// (Optional) Create a Lambda function and a rule that allows Amazon EventBridge
// to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates
// instances.
//
// (Optional) Create a notification target and an IAM role. The target can be
// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon
// EC2 Auto Scaling to publish lifecycle notifications to the target.
//
// Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
// If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state.
//
// If you finish before the timeout period ends, send a callback by using the
// CompleteLifecycleAction API call.
//
// For more information, see Amazon EC2 Auto Scaling lifecycle hooks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CompleteLifecycleAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction
func (c *AutoScaling) CompleteLifecycleAction(input *CompleteLifecycleActionInput) (*CompleteLifecycleActionOutput, error) {
	req, out := c.CompleteLifecycleActionRequest(input)
	return out, req.Send()
}

// CompleteLifecycleActionWithContext is the same as CompleteLifecycleAction with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteLifecycleAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) CompleteLifecycleActionWithContext(ctx aws.Context, input *CompleteLifecycleActionInput, opts ...request.Option) (*CompleteLifecycleActionOutput, error) {
	req, out := c.CompleteLifecycleActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAutoScalingGroup = "CreateAutoScalingGroup"

// CreateAutoScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateAutoScalingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAutoScalingGroup for more information on using the CreateAutoScalingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAutoScalingGroupRequest method.
//    req, resp := client.CreateAutoScalingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup
func (c *AutoScaling) CreateAutoScalingGroupRequest(input *CreateAutoScalingGroupInput) (req *request.Request, output *CreateAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoScalingGroupInput{}
	}

	output = &CreateAutoScalingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateAutoScalingGroup API operation for Auto Scaling.
//
// We strongly recommend using a launch template when calling this operation
// to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.
//
// Creates an Auto Scaling group with the specified name and attributes.
//
// If you exceed your maximum limit of Auto Scaling groups, the call fails.
// To query this limit, call the DescribeAccountLimits API. For information
// about updating this limit, see Amazon EC2 Auto Scaling service quotas (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// For introductory exercises for creating an Auto Scaling group, see Getting
// started with Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/GettingStartedTutorial.html)
// and Tutorial: Set up a scaled and load-balanced application (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-register-lbs-with-asg.html)
// in the Amazon EC2 Auto Scaling User Guide. For more information, see Auto
// Scaling groups (https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Every Auto Scaling group has three size parameters (DesiredCapacity, MaxSize,
// and MinSize). Usually, you set these sizes based on a specific number of
// instances. However, if you configure a mixed instances policy that defines
// weights for the instance types, you must specify these sizes with the same
// units that you use for weighting instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CreateAutoScalingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsFault "AlreadyExists"
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup
func (c *AutoScaling) CreateAutoScalingGroup(input *CreateAutoScalingGroupInput) (*CreateAutoScalingGroupOutput, error) {
	req, out := c.CreateAutoScalingGroupRequest(input)
	return out, req.Send()
}

// CreateAutoScalingGroupWithContext is the same as CreateAutoScalingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAutoScalingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) CreateAutoScalingGroupWithContext(ctx aws.Context, input *CreateAutoScalingGroupInput, opts ...request.Option) (*CreateAutoScalingGroupOutput, error) {
	req, out := c.CreateAutoScalingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLaunchConfiguration = "CreateLaunchConfiguration"

// CreateLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLaunchConfiguration for more information on using the CreateLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLaunchConfigurationRequest method.
//    req, resp := client.CreateLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateLaunchConfiguration
func (c *AutoScaling) CreateLaunchConfigurationRequest(input *CreateLaunchConfigurationInput) (req *request.Request, output *CreateLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLaunchConfigurationInput{}
	}

	output = &CreateLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateLaunchConfiguration API operation for Auto Scaling.
//
// Creates a launch configuration.
//
// If you exceed your maximum limit of launch configurations, the call fails.
// To query this limit, call the DescribeAccountLimits API. For information
// about updating this limit, see Amazon EC2 Auto Scaling service quotas (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// For more information, see Launch configurations (https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CreateLaunchConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsFault "AlreadyExists"
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateLaunchConfiguration
func (c *AutoScaling) CreateLaunchConfiguration(input *CreateLaunchConfigurationInput) (*CreateLaunchConfigurationOutput, error) {
	req, out := c.CreateLaunchConfigurationRequest(input)
	return out, req.Send()
}

// CreateLaunchConfigurationWithContext is the same as CreateLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) CreateLaunchConfigurationWithContext(ctx aws.Context, input *CreateLaunchConfigurationInput, opts ...request.Option) (*CreateLaunchConfigurationOutput, error) {
	req, out := c.CreateLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOrUpdateTags = "CreateOrUpdateTags"

// CreateOrUpdateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateOrUpdateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOrUpdateTags for more information on using the CreateOrUpdateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOrUpdateTagsRequest method.
//    req, resp := client.CreateOrUpdateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateOrUpdateTags
func (c *AutoScaling) CreateOrUpdateTagsRequest(input *CreateOrUpdateTagsInput) (req *request.Request, output *CreateOrUpdateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateOrUpdateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOrUpdateTagsInput{}
	}

	output = &CreateOrUpdateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateOrUpdateTags API operation for Auto Scaling.
//
// Creates or updates tags for the specified Auto Scaling group.
//
// When you specify a tag with a key that already exists, the operation overwrites
// the previous tag definition, and you do not get an error message.
//
// For more information, see Tagging Auto Scaling groups and instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CreateOrUpdateTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeAlreadyExistsFault "AlreadyExists"
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeResourceInUseFault "ResourceInUse"
//   The operation can't be performed because the resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateOrUpdateTags
func (c *AutoScaling) CreateOrUpdateTags(input *CreateOrUpdateTagsInput) (*CreateOrUpdateTagsOutput, error) {
	req, out := c.CreateOrUpdateTagsRequest(input)
	return out, req.Send()
}

// CreateOrUpdateTagsWithContext is the same as CreateOrUpdateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOrUpdateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) CreateOrUpdateTagsWithContext(ctx aws.Context, input *CreateOrUpdateTagsInput, opts ...request.Option) (*CreateOrUpdateTagsOutput, error) {
	req, out := c.CreateOrUpdateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAutoScalingGroup = "DeleteAutoScalingGroup"

// DeleteAutoScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAutoScalingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAutoScalingGroup for more information on using the DeleteAutoScalingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAutoScalingGroupRequest method.
//    req, resp := client.DeleteAutoScalingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup
func (c *AutoScaling) DeleteAutoScalingGroupRequest(input *DeleteAutoScalingGroupInput) (req *request.Request, output *DeleteAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutoScalingGroupInput{}
	}

	output = &DeleteAutoScalingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAutoScalingGroup API operation for Auto Scaling.
//
// Deletes the specified Auto Scaling group.
//
// If the group has instances or scaling activities in progress, you must specify
// the option to force the deletion in order for it to succeed.
//
// If the group has policies, deleting the group deletes the policies, the underlying
// alarm actions, and any alarm that no longer has an associated action.
//
// To remove instances from the Auto Scaling group before deleting it, call
// the DetachInstances API with the list of instances and the option to decrement
// the desired capacity. This ensures that Amazon EC2 Auto Scaling does not
// launch replacement instances.
//
// To terminate all instances before deleting the Auto Scaling group, call the
// UpdateAutoScalingGroup API and set the minimum size and desired capacity
// of the Auto Scaling group to zero.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteAutoScalingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScalingActivityInProgressFault "ScalingActivityInProgress"
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ErrCodeResourceInUseFault "ResourceInUse"
//   The operation can't be performed because the resource is in use.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup
func (c *AutoScaling) DeleteAutoScalingGroup(input *DeleteAutoScalingGroupInput) (*DeleteAutoScalingGroupOutput, error) {
	req, out := c.DeleteAutoScalingGroupRequest(input)
	return out, req.Send()
}

// DeleteAutoScalingGroupWithContext is the same as DeleteAutoScalingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAutoScalingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DeleteAutoScalingGroupWithContext(ctx aws.Context, input *DeleteAutoScalingGroupInput, opts ...request.Option) (*DeleteAutoScalingGroupOutput, error) {
	req, out := c.DeleteAutoScalingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchConfiguration = "DeleteLaunchConfiguration"

// DeleteLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchConfiguration for more information on using the DeleteLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLaunchConfigurationRequest method.
//    req, resp := client.DeleteLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration
func (c *AutoScaling) DeleteLaunchConfigurationRequest(input *DeleteLaunchConfigurationInput) (req *request.Request, output *DeleteLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLaunchConfigurationInput{}
	}

	output = &DeleteLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLaunchConfiguration API operation for Auto Scaling.
//
// Deletes the specified launch configuration.
//
// The launch configuration must not be attached to an Auto Scaling group. When
// this call completes, the launch configuration is no longer available for
// use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteLaunchConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseFault "ResourceInUse"
//   The operation can't be performed because the resource is in use.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration
func (c *AutoScaling) DeleteLaunchConfiguration(input *DeleteLaunchConfigurationInput) (*DeleteLaunchConfigurationOutput, error) {
	req, out := c.DeleteLaunchConfigurationRequest(input)
	return out, req.Send()
}

// DeleteLaunchConfigurationWithContext is the same as DeleteLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DeleteLaunchConfigurationWithContext(ctx aws.Context, input *DeleteLaunchConfigurationInput, opts ...request.Option) (*DeleteLaunchConfigurationOutput, error) {
	req, out := c.DeleteLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLifecycleHook = "DeleteLifecycleHook"

// DeleteLifecycleHookRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLifecycleHook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLifecycleHook for more information on using the DeleteLifecycleHook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLifecycleHookRequest method.
//    req, resp := client.DeleteLifecycleHookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook
func (c *AutoScaling) DeleteLifecycleHookRequest(input *DeleteLifecycleHookInput) (req *request.Request, output *DeleteLifecycleHookOutput) {
	op := &request.Operation{
		Name:       opDeleteLifecycleHook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLifecycleHookInput{}
	}

	output = &DeleteLifecycleHookOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLifecycleHook API operation for Auto Scaling.
//
// Deletes the specified lifecycle hook.
//
// If there are any outstanding lifecycle actions, they are completed first
// (ABANDON for launching instances, CONTINUE for terminating instances).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteLifecycleHook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook
func (c *AutoScaling) DeleteLifecycleHook(input *DeleteLifecycleHookInput) (*DeleteLifecycleHookOutput, error) {
	req, out := c.DeleteLifecycleHookRequest(input)
	return out, req.Send()
}

// DeleteLifecycleHookWithContext is the same as DeleteLifecycleHook with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLifecycleHook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DeleteLifecycleHookWithContext(ctx aws.Context, input *DeleteLifecycleHookInput, opts ...request.Option) (*DeleteLifecycleHookOutput, error) {
	req, out := c.DeleteLifecycleHookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotificationConfiguration = "DeleteNotificationConfiguration"

// DeleteNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotificationConfiguration for more information on using the DeleteNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotificationConfigurationRequest method.
//    req, resp := client.DeleteNotificationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration
func (c *AutoScaling) DeleteNotificationConfigurationRequest(input *DeleteNotificationConfigurationInput) (req *request.Request, output *DeleteNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotificationConfigurationInput{}
	}

	output = &DeleteNotificationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotificationConfiguration API operation for Auto Scaling.
//
// Deletes the specified notification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteNotificationConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration
func (c *AutoScaling) DeleteNotificationConfiguration(input *DeleteNotificationConfigurationInput) (*DeleteNotificationConfigurationOutput, error) {
	req, out := c.DeleteNotificationConfigurationRequest(input)
	return out, req.Send()
}

// DeleteNotificationConfigurationWithContext is the same as DeleteNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DeleteNotificationConfigurationWithContext(ctx aws.Context, input *DeleteNotificationConfigurationInput, opts ...request.Option) (*DeleteNotificationConfigurationOutput, error) {
	req, out := c.DeleteNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicy for more information on using the DeletePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy
func (c *AutoScaling) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for Auto Scaling.
//
// Deletes the specified scaling policy.
//
// Deleting either a step scaling policy or a simple scaling policy deletes
// the underlying alarm action, but does not delete the alarm, even if it no
// longer has an associated action.
//
// For more information, see Deleting a scaling policy (https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy
func (c *AutoScaling) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduledAction = "DeleteScheduledAction"

// DeleteScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduledAction for more information on using the DeleteScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScheduledActionRequest method.
//    req, resp := client.DeleteScheduledActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteScheduledAction
func (c *AutoScaling) DeleteScheduledActionRequest(input *DeleteScheduledActionInput) (req *request.Request, output *DeleteScheduledActionOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScheduledActionInput{}
	}

	output = &DeleteScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScheduledAction API operation for Auto Scaling.
//
// Deletes the specified scheduled action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteScheduledAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteScheduledAction
func (c *AutoScaling) DeleteScheduledAction(input *DeleteScheduledActionInput) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	return out, req.Send()
}

// DeleteScheduledActionWithContext is the same as DeleteScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DeleteScheduledActionWithContext(ctx aws.Context, input *DeleteScheduledActionInput, opts ...request.Option) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteTags
func (c *AutoScaling) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Auto Scaling.
//
// Deletes the specified tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeResourceInUseFault "ResourceInUse"
//   The operation can't be performed because the resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteTags
func (c *AutoScaling) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWarmPool = "DeleteWarmPool"

// DeleteWarmPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWarmPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWarmPool for more information on using the DeleteWarmPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWarmPoolRequest method.
//    req, resp := client.DeleteWarmPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteWarmPool
func (c *AutoScaling) DeleteWarmPoolRequest(input *DeleteWarmPoolInput) (req *request.Request, output *DeleteWarmPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteWarmPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWarmPoolInput{}
	}

	output = &DeleteWarmPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWarmPool API operation for Auto Scaling.
//
// Deletes the warm pool for the specified Auto Scaling group.
//
// For more information, see Warm pools for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteWarmPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeScalingActivityInProgressFault "ScalingActivityInProgress"
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ErrCodeResourceInUseFault "ResourceInUse"
//   The operation can't be performed because the resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteWarmPool
func (c *AutoScaling) DeleteWarmPool(input *DeleteWarmPoolInput) (*DeleteWarmPoolOutput, error) {
	req, out := c.DeleteWarmPoolRequest(input)
	return out, req.Send()
}

// DeleteWarmPoolWithContext is the same as DeleteWarmPool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWarmPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DeleteWarmPoolWithContext(ctx aws.Context, input *DeleteWarmPoolInput, opts ...request.Option) (*DeleteWarmPoolOutput, error) {
	req, out := c.DeleteWarmPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountLimits for more information on using the DescribeAccountLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountLimitsRequest method.
//    req, resp := client.DescribeAccountLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits
func (c *AutoScaling) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *request.Request, output *DescribeAccountLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	output = &DescribeAccountLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountLimits API operation for Auto Scaling.
//
// Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
//
// When you establish an Amazon Web Services account, the account has initial
// quotas on the maximum number of Auto Scaling groups and launch configurations
// that you can create in a given Region. For more information, see Amazon EC2
// Auto Scaling service quotas (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAccountLimits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits
func (c *AutoScaling) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	return out, req.Send()
}

// DescribeAccountLimitsWithContext is the same as DescribeAccountLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeAccountLimitsWithContext(ctx aws.Context, input *DescribeAccountLimitsInput, opts ...request.Option) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAdjustmentTypes = "DescribeAdjustmentTypes"

// DescribeAdjustmentTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAdjustmentTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAdjustmentTypes for more information on using the DescribeAdjustmentTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAdjustmentTypesRequest method.
//    req, resp := client.DescribeAdjustmentTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes
func (c *AutoScaling) DescribeAdjustmentTypesRequest(input *DescribeAdjustmentTypesInput) (req *request.Request, output *DescribeAdjustmentTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeAdjustmentTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAdjustmentTypesInput{}
	}

	output = &DescribeAdjustmentTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAdjustmentTypes API operation for Auto Scaling.
//
// Describes the available adjustment types for step scaling and simple scaling
// policies.
//
// The following adjustment types are supported:
//
//    * ChangeInCapacity
//
//    * ExactCapacity
//
//    * PercentChangeInCapacity
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAdjustmentTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes
func (c *AutoScaling) DescribeAdjustmentTypes(input *DescribeAdjustmentTypesInput) (*DescribeAdjustmentTypesOutput, error) {
	req, out := c.DescribeAdjustmentTypesRequest(input)
	return out, req.Send()
}

// DescribeAdjustmentTypesWithContext is the same as DescribeAdjustmentTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAdjustmentTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeAdjustmentTypesWithContext(ctx aws.Context, input *DescribeAdjustmentTypesInput, opts ...request.Option) (*DescribeAdjustmentTypesOutput, error) {
	req, out := c.DescribeAdjustmentTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutoScalingGroups = "DescribeAutoScalingGroups"

// DescribeAutoScalingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoScalingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutoScalingGroups for more information on using the DescribeAutoScalingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAutoScalingGroupsRequest method.
//    req, resp := client.DescribeAutoScalingGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups
func (c *AutoScaling) DescribeAutoScalingGroupsRequest(input *DescribeAutoScalingGroupsInput) (req *request.Request, output *DescribeAutoScalingGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAutoScalingGroupsInput{}
	}

	output = &DescribeAutoScalingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutoScalingGroups API operation for Auto Scaling.
//
// Gets information about the Auto Scaling groups in the account and Region.
//
// If you specify Auto Scaling group names, the output includes information
// for only the specified Auto Scaling groups. If you specify filters, the output
// includes information for only those Auto Scaling groups that meet the filter
// criteria. If you do not specify group names or filters, the output includes
// information for all Auto Scaling groups.
//
// This operation also returns information about instances in Auto Scaling groups.
// To retrieve information about the instances in a warm pool, you must call
// the DescribeWarmPool API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAutoScalingGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups
func (c *AutoScaling) DescribeAutoScalingGroups(input *DescribeAutoScalingGroupsInput) (*DescribeAutoScalingGroupsOutput, error) {
	req, out := c.DescribeAutoScalingGroupsRequest(input)
	return out, req.Send()
}

// DescribeAutoScalingGroupsWithContext is the same as DescribeAutoScalingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutoScalingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeAutoScalingGroupsWithContext(ctx aws.Context, input *DescribeAutoScalingGroupsInput, opts ...request.Option) (*DescribeAutoScalingGroupsOutput, error) {
	req, out := c.DescribeAutoScalingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAutoScalingGroupsPages iterates over the pages of a DescribeAutoScalingGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAutoScalingGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAutoScalingGroups operation.
//    pageNum := 0
//    err := client.DescribeAutoScalingGroupsPages(params,
//        func(page *autoscaling.DescribeAutoScalingGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeAutoScalingGroupsPages(input *DescribeAutoScalingGroupsInput, fn func(*DescribeAutoScalingGroupsOutput, bool) bool) error {
	return c.DescribeAutoScalingGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAutoScalingGroupsPagesWithContext same as DescribeAutoScalingGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeAutoScalingGroupsPagesWithContext(ctx aws.Context, input *DescribeAutoScalingGroupsInput, fn func(*DescribeAutoScalingGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAutoScalingGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAutoScalingGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAutoScalingGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAutoScalingInstances = "DescribeAutoScalingInstances"

// DescribeAutoScalingInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoScalingInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutoScalingInstances for more information on using the DescribeAutoScalingInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAutoScalingInstancesRequest method.
//    req, resp := client.DescribeAutoScalingInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances
func (c *AutoScaling) DescribeAutoScalingInstancesRequest(input *DescribeAutoScalingInstancesInput) (req *request.Request, output *DescribeAutoScalingInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAutoScalingInstancesInput{}
	}

	output = &DescribeAutoScalingInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutoScalingInstances API operation for Auto Scaling.
//
// Gets information about the Auto Scaling instances in the account and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAutoScalingInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances
func (c *AutoScaling) DescribeAutoScalingInstances(input *DescribeAutoScalingInstancesInput) (*DescribeAutoScalingInstancesOutput, error) {
	req, out := c.DescribeAutoScalingInstancesRequest(input)
	return out, req.Send()
}

// DescribeAutoScalingInstancesWithContext is the same as DescribeAutoScalingInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutoScalingInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeAutoScalingInstancesWithContext(ctx aws.Context, input *DescribeAutoScalingInstancesInput, opts ...request.Option) (*DescribeAutoScalingInstancesOutput, error) {
	req, out := c.DescribeAutoScalingInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAutoScalingInstancesPages iterates over the pages of a DescribeAutoScalingInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAutoScalingInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAutoScalingInstances operation.
//    pageNum := 0
//    err := client.DescribeAutoScalingInstancesPages(params,
//        func(page *autoscaling.DescribeAutoScalingInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeAutoScalingInstancesPages(input *DescribeAutoScalingInstancesInput, fn func(*DescribeAutoScalingInstancesOutput, bool) bool) error {
	return c.DescribeAutoScalingInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAutoScalingInstancesPagesWithContext same as DescribeAutoScalingInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeAutoScalingInstancesPagesWithContext(ctx aws.Context, input *DescribeAutoScalingInstancesInput, fn func(*DescribeAutoScalingInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAutoScalingInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAutoScalingInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAutoScalingInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAutoScalingNotificationTypes = "DescribeAutoScalingNotificationTypes"

// DescribeAutoScalingNotificationTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoScalingNotificationTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutoScalingNotificationTypes for more information on using the DescribeAutoScalingNotificationTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAutoScalingNotificationTypesRequest method.
//    req, resp := client.DescribeAutoScalingNotificationTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes
func (c *AutoScaling) DescribeAutoScalingNotificationTypesRequest(input *DescribeAutoScalingNotificationTypesInput) (req *request.Request, output *DescribeAutoScalingNotificationTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingNotificationTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutoScalingNotificationTypesInput{}
	}

	output = &DescribeAutoScalingNotificationTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutoScalingNotificationTypes API operation for Auto Scaling.
//
// Describes the notification types that are supported by Amazon EC2 Auto Scaling.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAutoScalingNotificationTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes
func (c *AutoScaling) DescribeAutoScalingNotificationTypes(input *DescribeAutoScalingNotificationTypesInput) (*DescribeAutoScalingNotificationTypesOutput, error) {
	req, out := c.DescribeAutoScalingNotificationTypesRequest(input)
	return out, req.Send()
}

// DescribeAutoScalingNotificationTypesWithContext is the same as DescribeAutoScalingNotificationTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutoScalingNotificationTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeAutoScalingNotificationTypesWithContext(ctx aws.Context, input *DescribeAutoScalingNotificationTypesInput, opts ...request.Option) (*DescribeAutoScalingNotificationTypesOutput, error) {
	req, out := c.DescribeAutoScalingNotificationTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceRefreshes = "DescribeInstanceRefreshes"

// DescribeInstanceRefreshesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceRefreshes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceRefreshes for more information on using the DescribeInstanceRefreshes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceRefreshesRequest method.
//    req, resp := client.DescribeInstanceRefreshesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes
func (c *AutoScaling) DescribeInstanceRefreshesRequest(input *DescribeInstanceRefreshesInput) (req *request.Request, output *DescribeInstanceRefreshesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceRefreshes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceRefreshesInput{}
	}

	output = &DescribeInstanceRefreshesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceRefreshes API operation for Auto Scaling.
//
// Gets information about the instance refreshes for the specified Auto Scaling
// group.
//
// This operation is part of the instance refresh feature (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
// in Amazon EC2 Auto Scaling, which helps you update instances in your Auto
// Scaling group after you make configuration changes.
//
// To help you determine the status of an instance refresh, this operation returns
// information about the instance refreshes you previously initiated, including
// their status, end time, the percentage of the instance refresh that is complete,
// and the number of instances remaining to update before the instance refresh
// is complete.
//
// The following are the possible statuses:
//
//    * Pending - The request was created, but the operation has not started.
//
//    * InProgress - The operation is in progress.
//
//    * Successful - The operation completed successfully.
//
//    * Failed - The operation failed to complete. You can troubleshoot using
//    the status reason and the scaling activities.
//
//    * Cancelling - An ongoing operation is being cancelled. Cancellation does
//    not roll back any replacements that have already been completed, but it
//    prevents new replacements from being started.
//
//    * Cancelled - The operation is cancelled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeInstanceRefreshes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes
func (c *AutoScaling) DescribeInstanceRefreshes(input *DescribeInstanceRefreshesInput) (*DescribeInstanceRefreshesOutput, error) {
	req, out := c.DescribeInstanceRefreshesRequest(input)
	return out, req.Send()
}

// DescribeInstanceRefreshesWithContext is the same as DescribeInstanceRefreshes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceRefreshes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeInstanceRefreshesWithContext(ctx aws.Context, input *DescribeInstanceRefreshesInput, opts ...request.Option) (*DescribeInstanceRefreshesOutput, error) {
	req, out := c.DescribeInstanceRefreshesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLaunchConfigurations = "DescribeLaunchConfigurations"

// DescribeLaunchConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLaunchConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLaunchConfigurations for more information on using the DescribeLaunchConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLaunchConfigurationsRequest method.
//    req, resp := client.DescribeLaunchConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations
func (c *AutoScaling) DescribeLaunchConfigurationsRequest(input *DescribeLaunchConfigurationsInput) (req *request.Request, output *DescribeLaunchConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLaunchConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLaunchConfigurationsInput{}
	}

	output = &DescribeLaunchConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLaunchConfigurations API operation for Auto Scaling.
//
// Gets information about the launch configurations in the account and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLaunchConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations
func (c *AutoScaling) DescribeLaunchConfigurations(input *DescribeLaunchConfigurationsInput) (*DescribeLaunchConfigurationsOutput, error) {
	req, out := c.DescribeLaunchConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeLaunchConfigurationsWithContext is the same as DescribeLaunchConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLaunchConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeLaunchConfigurationsWithContext(ctx aws.Context, input *DescribeLaunchConfigurationsInput, opts ...request.Option) (*DescribeLaunchConfigurationsOutput, error) {
	req, out := c.DescribeLaunchConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeLaunchConfigurationsPages iterates over the pages of a DescribeLaunchConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLaunchConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLaunchConfigurations operation.
//    pageNum := 0
//    err := client.DescribeLaunchConfigurationsPages(params,
//        func(page *autoscaling.DescribeLaunchConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeLaunchConfigurationsPages(input *DescribeLaunchConfigurationsInput, fn func(*DescribeLaunchConfigurationsOutput, bool) bool) error {
	return c.DescribeLaunchConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeLaunchConfigurationsPagesWithContext same as DescribeLaunchConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeLaunchConfigurationsPagesWithContext(ctx aws.Context, input *DescribeLaunchConfigurationsInput, fn func(*DescribeLaunchConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeLaunchConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeLaunchConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeLaunchConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLifecycleHookTypes = "DescribeLifecycleHookTypes"

// DescribeLifecycleHookTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLifecycleHookTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLifecycleHookTypes for more information on using the DescribeLifecycleHookTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLifecycleHookTypesRequest method.
//    req, resp := client.DescribeLifecycleHookTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes
func (c *AutoScaling) DescribeLifecycleHookTypesRequest(input *DescribeLifecycleHookTypesInput) (req *request.Request, output *DescribeLifecycleHookTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeLifecycleHookTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLifecycleHookTypesInput{}
	}

	output = &DescribeLifecycleHookTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLifecycleHookTypes API operation for Auto Scaling.
//
// Describes the available types of lifecycle hooks.
//
// The following hook types are supported:
//
//    * autoscaling:EC2_INSTANCE_LAUNCHING
//
//    * autoscaling:EC2_INSTANCE_TERMINATING
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLifecycleHookTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes
func (c *AutoScaling) DescribeLifecycleHookTypes(input *DescribeLifecycleHookTypesInput) (*DescribeLifecycleHookTypesOutput, error) {
	req, out := c.DescribeLifecycleHookTypesRequest(input)
	return out, req.Send()
}

// DescribeLifecycleHookTypesWithContext is the same as DescribeLifecycleHookTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLifecycleHookTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeLifecycleHookTypesWithContext(ctx aws.Context, input *DescribeLifecycleHookTypesInput, opts ...request.Option) (*DescribeLifecycleHookTypesOutput, error) {
	req, out := c.DescribeLifecycleHookTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLifecycleHooks = "DescribeLifecycleHooks"

// DescribeLifecycleHooksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLifecycleHooks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLifecycleHooks for more information on using the DescribeLifecycleHooks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLifecycleHooksRequest method.
//    req, resp := client.DescribeLifecycleHooksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHooks
func (c *AutoScaling) DescribeLifecycleHooksRequest(input *DescribeLifecycleHooksInput) (req *request.Request, output *DescribeLifecycleHooksOutput) {
	op := &request.Operation{
		Name:       opDescribeLifecycleHooks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLifecycleHooksInput{}
	}

	output = &DescribeLifecycleHooksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLifecycleHooks API operation for Auto Scaling.
//
// Gets information about the lifecycle hooks for the specified Auto Scaling
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLifecycleHooks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHooks
func (c *AutoScaling) DescribeLifecycleHooks(input *DescribeLifecycleHooksInput) (*DescribeLifecycleHooksOutput, error) {
	req, out := c.DescribeLifecycleHooksRequest(input)
	return out, req.Send()
}

// DescribeLifecycleHooksWithContext is the same as DescribeLifecycleHooks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLifecycleHooks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeLifecycleHooksWithContext(ctx aws.Context, input *DescribeLifecycleHooksInput, opts ...request.Option) (*DescribeLifecycleHooksOutput, error) {
	req, out := c.DescribeLifecycleHooksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoadBalancerTargetGroups = "DescribeLoadBalancerTargetGroups"

// DescribeLoadBalancerTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoadBalancerTargetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoadBalancerTargetGroups for more information on using the DescribeLoadBalancerTargetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoadBalancerTargetGroupsRequest method.
//    req, resp := client.DescribeLoadBalancerTargetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups
func (c *AutoScaling) DescribeLoadBalancerTargetGroupsRequest(input *DescribeLoadBalancerTargetGroupsInput) (req *request.Request, output *DescribeLoadBalancerTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancerTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancerTargetGroupsInput{}
	}

	output = &DescribeLoadBalancerTargetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoadBalancerTargetGroups API operation for Auto Scaling.
//
// Gets information about the load balancer target groups for the specified
// Auto Scaling group.
//
// To determine the availability of registered instances, use the State element
// in the response. When you attach a target group to an Auto Scaling group,
// the initial State value is Adding. The state transitions to Added after all
// Auto Scaling instances are registered with the target group. If Elastic Load
// Balancing health checks are enabled for the Auto Scaling group, the state
// transitions to InService after at least one Auto Scaling instance passes
// the health check. When the target group is in the InService state, Amazon
// EC2 Auto Scaling can terminate and replace any instances that are reported
// as unhealthy. If no registered instances pass the health checks, the target
// group doesn't enter the InService state.
//
// Target groups also have an InService state if you attach them in the CreateAutoScalingGroup
// API call. If your target group state is InService, but it is not working
// properly, check the scaling activities by calling DescribeScalingActivities
// and take any corrective actions necessary.
//
// For help with failed health checks, see Troubleshooting Amazon EC2 Auto Scaling:
// Health checks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html)
// in the Amazon EC2 Auto Scaling User Guide. For more information, see Elastic
// Load Balancing and Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLoadBalancerTargetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups
func (c *AutoScaling) DescribeLoadBalancerTargetGroups(input *DescribeLoadBalancerTargetGroupsInput) (*DescribeLoadBalancerTargetGroupsOutput, error) {
	req, out := c.DescribeLoadBalancerTargetGroupsRequest(input)
	return out, req.Send()
}

// DescribeLoadBalancerTargetGroupsWithContext is the same as DescribeLoadBalancerTargetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoadBalancerTargetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeLoadBalancerTargetGroupsWithContext(ctx aws.Context, input *DescribeLoadBalancerTargetGroupsInput, opts ...request.Option) (*DescribeLoadBalancerTargetGroupsOutput, error) {
	req, out := c.DescribeLoadBalancerTargetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoadBalancers = "DescribeLoadBalancers"

// DescribeLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoadBalancers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoadBalancers for more information on using the DescribeLoadBalancers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoadBalancersRequest method.
//    req, resp := client.DescribeLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers
func (c *AutoScaling) DescribeLoadBalancersRequest(input *DescribeLoadBalancersInput) (req *request.Request, output *DescribeLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancersInput{}
	}

	output = &DescribeLoadBalancersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoadBalancers API operation for Auto Scaling.
//
// Gets information about the load balancers for the specified Auto Scaling
// group.
//
// This operation describes only Classic Load Balancers. If you have Application
// Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the
// DescribeLoadBalancerTargetGroups API instead.
//
// To determine the availability of registered instances, use the State element
// in the response. When you attach a load balancer to an Auto Scaling group,
// the initial State value is Adding. The state transitions to Added after all
// Auto Scaling instances are registered with the load balancer. If Elastic
// Load Balancing health checks are enabled for the Auto Scaling group, the
// state transitions to InService after at least one Auto Scaling instance passes
// the health check. When the load balancer is in the InService state, Amazon
// EC2 Auto Scaling can terminate and replace any instances that are reported
// as unhealthy. If no registered instances pass the health checks, the load
// balancer doesn't enter the InService state.
//
// Load balancers also have an InService state if you attach them in the CreateAutoScalingGroup
// API call. If your load balancer state is InService, but it is not working
// properly, check the scaling activities by calling DescribeScalingActivities
// and take any corrective actions necessary.
//
// For help with failed health checks, see Troubleshooting Amazon EC2 Auto Scaling:
// Health checks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html)
// in the Amazon EC2 Auto Scaling User Guide. For more information, see Elastic
// Load Balancing and Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLoadBalancers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers
func (c *AutoScaling) DescribeLoadBalancers(input *DescribeLoadBalancersInput) (*DescribeLoadBalancersOutput, error) {
	req, out := c.DescribeLoadBalancersRequest(input)
	return out, req.Send()
}

// DescribeLoadBalancersWithContext is the same as DescribeLoadBalancers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoadBalancers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeLoadBalancersWithContext(ctx aws.Context, input *DescribeLoadBalancersInput, opts ...request.Option) (*DescribeLoadBalancersOutput, error) {
	req, out := c.DescribeLoadBalancersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMetricCollectionTypes = "DescribeMetricCollectionTypes"

// DescribeMetricCollectionTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetricCollectionTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMetricCollectionTypes for more information on using the DescribeMetricCollectionTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMetricCollectionTypesRequest method.
//    req, resp := client.DescribeMetricCollectionTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes
func (c *AutoScaling) DescribeMetricCollectionTypesRequest(input *DescribeMetricCollectionTypesInput) (req *request.Request, output *DescribeMetricCollectionTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeMetricCollectionTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMetricCollectionTypesInput{}
	}

	output = &DescribeMetricCollectionTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMetricCollectionTypes API operation for Auto Scaling.
//
// Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
//
// The GroupStandbyInstances metric is not returned by default. You must explicitly
// request this metric when calling the EnableMetricsCollection API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeMetricCollectionTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes
func (c *AutoScaling) DescribeMetricCollectionTypes(input *DescribeMetricCollectionTypesInput) (*DescribeMetricCollectionTypesOutput, error) {
	req, out := c.DescribeMetricCollectionTypesRequest(input)
	return out, req.Send()
}

// DescribeMetricCollectionTypesWithContext is the same as DescribeMetricCollectionTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMetricCollectionTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeMetricCollectionTypesWithContext(ctx aws.Context, input *DescribeMetricCollectionTypesInput, opts ...request.Option) (*DescribeMetricCollectionTypesOutput, error) {
	req, out := c.DescribeMetricCollectionTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotificationConfigurations = "DescribeNotificationConfigurations"

// DescribeNotificationConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotificationConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotificationConfigurations for more information on using the DescribeNotificationConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotificationConfigurationsRequest method.
//    req, resp := client.DescribeNotificationConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations
func (c *AutoScaling) DescribeNotificationConfigurationsRequest(input *DescribeNotificationConfigurationsInput) (req *request.Request, output *DescribeNotificationConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeNotificationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNotificationConfigurationsInput{}
	}

	output = &DescribeNotificationConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotificationConfigurations API operation for Auto Scaling.
//
// Gets information about the Amazon SNS notifications that are configured for
// one or more Auto Scaling groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeNotificationConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations
func (c *AutoScaling) DescribeNotificationConfigurations(input *DescribeNotificationConfigurationsInput) (*DescribeNotificationConfigurationsOutput, error) {
	req, out := c.DescribeNotificationConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeNotificationConfigurationsWithContext is the same as DescribeNotificationConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotificationConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeNotificationConfigurationsWithContext(ctx aws.Context, input *DescribeNotificationConfigurationsInput, opts ...request.Option) (*DescribeNotificationConfigurationsOutput, error) {
	req, out := c.DescribeNotificationConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNotificationConfigurationsPages iterates over the pages of a DescribeNotificationConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNotificationConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNotificationConfigurations operation.
//    pageNum := 0
//    err := client.DescribeNotificationConfigurationsPages(params,
//        func(page *autoscaling.DescribeNotificationConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeNotificationConfigurationsPages(input *DescribeNotificationConfigurationsInput, fn func(*DescribeNotificationConfigurationsOutput, bool) bool) error {
	return c.DescribeNotificationConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNotificationConfigurationsPagesWithContext same as DescribeNotificationConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeNotificationConfigurationsPagesWithContext(ctx aws.Context, input *DescribeNotificationConfigurationsInput, fn func(*DescribeNotificationConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNotificationConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNotificationConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNotificationConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePolicies = "DescribePolicies"

// DescribePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePolicies for more information on using the DescribePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePoliciesRequest method.
//    req, resp := client.DescribePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies
func (c *AutoScaling) DescribePoliciesRequest(input *DescribePoliciesInput) (req *request.Request, output *DescribePoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePoliciesInput{}
	}

	output = &DescribePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePolicies API operation for Auto Scaling.
//
// Gets information about the scaling policies in the account and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribePolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies
func (c *AutoScaling) DescribePolicies(input *DescribePoliciesInput) (*DescribePoliciesOutput, error) {
	req, out := c.DescribePoliciesRequest(input)
	return out, req.Send()
}

// DescribePoliciesWithContext is the same as DescribePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribePoliciesWithContext(ctx aws.Context, input *DescribePoliciesInput, opts ...request.Option) (*DescribePoliciesOutput, error) {
	req, out := c.DescribePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePoliciesPages iterates over the pages of a DescribePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePolicies operation.
//    pageNum := 0
//    err := client.DescribePoliciesPages(params,
//        func(page *autoscaling.DescribePoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribePoliciesPages(input *DescribePoliciesInput, fn func(*DescribePoliciesOutput, bool) bool) error {
	return c.DescribePoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePoliciesPagesWithContext same as DescribePoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribePoliciesPagesWithContext(ctx aws.Context, input *DescribePoliciesInput, fn func(*DescribePoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeScalingActivities = "DescribeScalingActivities"

// DescribeScalingActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingActivities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingActivities for more information on using the DescribeScalingActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingActivitiesRequest method.
//    req, resp := client.DescribeScalingActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities
func (c *AutoScaling) DescribeScalingActivitiesRequest(input *DescribeScalingActivitiesInput) (req *request.Request, output *DescribeScalingActivitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingActivitiesInput{}
	}

	output = &DescribeScalingActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingActivities API operation for Auto Scaling.
//
// Gets information about the scaling activities in the account and Region.
//
// When scaling events occur, you see a record of the scaling activity in the
// scaling activities. For more information, see Verifying a scaling activity
// for an Auto Scaling group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// If the scaling event succeeds, the value of the StatusCode element in the
// response is Successful. If an attempt to launch instances failed, the StatusCode
// value is Failed or Cancelled and the StatusMessage element in the response
// indicates the cause of the failure. For help interpreting the StatusMessage,
// see Troubleshooting Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeScalingActivities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities
func (c *AutoScaling) DescribeScalingActivities(input *DescribeScalingActivitiesInput) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	return out, req.Send()
}

// DescribeScalingActivitiesWithContext is the same as DescribeScalingActivities with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeScalingActivitiesWithContext(ctx aws.Context, input *DescribeScalingActivitiesInput, opts ...request.Option) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScalingActivitiesPages iterates over the pages of a DescribeScalingActivities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingActivities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScalingActivities operation.
//    pageNum := 0
//    err := client.DescribeScalingActivitiesPages(params,
//        func(page *autoscaling.DescribeScalingActivitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeScalingActivitiesPages(input *DescribeScalingActivitiesInput, fn func(*DescribeScalingActivitiesOutput, bool) bool) error {
	return c.DescribeScalingActivitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScalingActivitiesPagesWithContext same as DescribeScalingActivitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeScalingActivitiesPagesWithContext(ctx aws.Context, input *DescribeScalingActivitiesInput, fn func(*DescribeScalingActivitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScalingActivitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScalingActivitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScalingActivitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeScalingProcessTypes = "DescribeScalingProcessTypes"

// DescribeScalingProcessTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingProcessTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingProcessTypes for more information on using the DescribeScalingProcessTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingProcessTypesRequest method.
//    req, resp := client.DescribeScalingProcessTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes
func (c *AutoScaling) DescribeScalingProcessTypesRequest(input *DescribeScalingProcessTypesInput) (req *request.Request, output *DescribeScalingProcessTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingProcessTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingProcessTypesInput{}
	}

	output = &DescribeScalingProcessTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingProcessTypes API operation for Auto Scaling.
//
// Describes the scaling process types for use with the ResumeProcesses and
// SuspendProcesses APIs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeScalingProcessTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes
func (c *AutoScaling) DescribeScalingProcessTypes(input *DescribeScalingProcessTypesInput) (*DescribeScalingProcessTypesOutput, error) {
	req, out := c.DescribeScalingProcessTypesRequest(input)
	return out, req.Send()
}

// DescribeScalingProcessTypesWithContext is the same as DescribeScalingProcessTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingProcessTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeScalingProcessTypesWithContext(ctx aws.Context, input *DescribeScalingProcessTypesInput, opts ...request.Option) (*DescribeScalingProcessTypesOutput, error) {
	req, out := c.DescribeScalingProcessTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScheduledActions = "DescribeScheduledActions"

// DescribeScheduledActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledActions for more information on using the DescribeScheduledActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduledActionsRequest method.
//    req, resp := client.DescribeScheduledActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions
func (c *AutoScaling) DescribeScheduledActionsRequest(input *DescribeScheduledActionsInput) (req *request.Request, output *DescribeScheduledActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduledActionsInput{}
	}

	output = &DescribeScheduledActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledActions API operation for Auto Scaling.
//
// Gets information about the scheduled actions that haven't run or that have
// not reached their end time.
//
// To describe the scaling activities for scheduled actions that have already
// run, call the DescribeScalingActivities API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeScheduledActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions
func (c *AutoScaling) DescribeScheduledActions(input *DescribeScheduledActionsInput) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	return out, req.Send()
}

// DescribeScheduledActionsWithContext is the same as DescribeScheduledActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeScheduledActionsWithContext(ctx aws.Context, input *DescribeScheduledActionsInput, opts ...request.Option) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScheduledActionsPages iterates over the pages of a DescribeScheduledActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScheduledActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScheduledActions operation.
//    pageNum := 0
//    err := client.DescribeScheduledActionsPages(params,
//        func(page *autoscaling.DescribeScheduledActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeScheduledActionsPages(input *DescribeScheduledActionsInput, fn func(*DescribeScheduledActionsOutput, bool) bool) error {
	return c.DescribeScheduledActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScheduledActionsPagesWithContext same as DescribeScheduledActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeScheduledActionsPagesWithContext(ctx aws.Context, input *DescribeScheduledActionsInput, fn func(*DescribeScheduledActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScheduledActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScheduledActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScheduledActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags
func (c *AutoScaling) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Auto Scaling.
//
// Describes the specified tags.
//
// You can use filters to limit the results. For example, you can query for
// the tags for a specific Auto Scaling group. You can specify multiple values
// for a filter. A tag must match at least one of the specified values for it
// to be included in the results.
//
// You can also specify multiple filters. The result includes information for
// a particular tag only if it matches all the filters. If there's no match,
// no special message is returned.
//
// For more information, see Tagging Auto Scaling groups and instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags
func (c *AutoScaling) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTagsPages iterates over the pages of a DescribeTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTags operation.
//    pageNum := 0
//    err := client.DescribeTagsPages(params,
//        func(page *autoscaling.DescribeTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeTagsPages(input *DescribeTagsInput, fn func(*DescribeTagsOutput, bool) bool) error {
	return c.DescribeTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTagsPagesWithContext same as DescribeTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeTagsPagesWithContext(ctx aws.Context, input *DescribeTagsInput, fn func(*DescribeTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeTerminationPolicyTypes = "DescribeTerminationPolicyTypes"

// DescribeTerminationPolicyTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTerminationPolicyTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTerminationPolicyTypes for more information on using the DescribeTerminationPolicyTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTerminationPolicyTypesRequest method.
//    req, resp := client.DescribeTerminationPolicyTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes
func (c *AutoScaling) DescribeTerminationPolicyTypesRequest(input *DescribeTerminationPolicyTypesInput) (req *request.Request, output *DescribeTerminationPolicyTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeTerminationPolicyTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTerminationPolicyTypesInput{}
	}

	output = &DescribeTerminationPolicyTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTerminationPolicyTypes API operation for Auto Scaling.
//
// Describes the termination policies supported by Amazon EC2 Auto Scaling.
//
// For more information, see Controlling which Auto Scaling instances terminate
// during scale in (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeTerminationPolicyTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes
func (c *AutoScaling) DescribeTerminationPolicyTypes(input *DescribeTerminationPolicyTypesInput) (*DescribeTerminationPolicyTypesOutput, error) {
	req, out := c.DescribeTerminationPolicyTypesRequest(input)
	return out, req.Send()
}

// DescribeTerminationPolicyTypesWithContext is the same as DescribeTerminationPolicyTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTerminationPolicyTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeTerminationPolicyTypesWithContext(ctx aws.Context, input *DescribeTerminationPolicyTypesInput, opts ...request.Option) (*DescribeTerminationPolicyTypesOutput, error) {
	req, out := c.DescribeTerminationPolicyTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWarmPool = "DescribeWarmPool"

// DescribeWarmPoolRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWarmPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWarmPool for more information on using the DescribeWarmPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWarmPoolRequest method.
//    req, resp := client.DescribeWarmPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool
func (c *AutoScaling) DescribeWarmPoolRequest(input *DescribeWarmPoolInput) (req *request.Request, output *DescribeWarmPoolOutput) {
	op := &request.Operation{
		Name:       opDescribeWarmPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWarmPoolInput{}
	}

	output = &DescribeWarmPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWarmPool API operation for Auto Scaling.
//
// Gets information about a warm pool and its instances.
//
// For more information, see Warm pools for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeWarmPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The NextToken value is not valid.
//
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeWarmPool
func (c *AutoScaling) DescribeWarmPool(input *DescribeWarmPoolInput) (*DescribeWarmPoolOutput, error) {
	req, out := c.DescribeWarmPoolRequest(input)
	return out, req.Send()
}

// DescribeWarmPoolWithContext is the same as DescribeWarmPool with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWarmPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DescribeWarmPoolWithContext(ctx aws.Context, input *DescribeWarmPoolInput, opts ...request.Option) (*DescribeWarmPoolOutput, error) {
	req, out := c.DescribeWarmPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachInstances = "DetachInstances"

// DetachInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DetachInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachInstances for more information on using the DetachInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachInstancesRequest method.
//    req, resp := client.DetachInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances
func (c *AutoScaling) DetachInstancesRequest(input *DetachInstancesInput) (req *request.Request, output *DetachInstancesOutput) {
	op := &request.Operation{
		Name:       opDetachInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInstancesInput{}
	}

	output = &DetachInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachInstances API operation for Auto Scaling.
//
// Removes one or more instances from the specified Auto Scaling group.
//
// After the instances are detached, you can manage them independent of the
// Auto Scaling group.
//
// If you do not specify the option to decrement the desired capacity, Amazon
// EC2 Auto Scaling launches instances to replace the ones that are detached.
//
// If there is a Classic Load Balancer attached to the Auto Scaling group, the
// instances are deregistered from the load balancer. If there are target groups
// attached to the Auto Scaling group, the instances are deregistered from the
// target groups.
//
// For more information, see Detach EC2 instances from your Auto Scaling group
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DetachInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances
func (c *AutoScaling) DetachInstances(input *DetachInstancesInput) (*DetachInstancesOutput, error) {
	req, out := c.DetachInstancesRequest(input)
	return out, req.Send()
}

// DetachInstancesWithContext is the same as DetachInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DetachInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DetachInstancesWithContext(ctx aws.Context, input *DetachInstancesInput, opts ...request.Option) (*DetachInstancesOutput, error) {
	req, out := c.DetachInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachLoadBalancerTargetGroups = "DetachLoadBalancerTargetGroups"

// DetachLoadBalancerTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DetachLoadBalancerTargetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachLoadBalancerTargetGroups for more information on using the DetachLoadBalancerTargetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachLoadBalancerTargetGroupsRequest method.
//    req, resp := client.DetachLoadBalancerTargetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups
func (c *AutoScaling) DetachLoadBalancerTargetGroupsRequest(input *DetachLoadBalancerTargetGroupsInput) (req *request.Request, output *DetachLoadBalancerTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opDetachLoadBalancerTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachLoadBalancerTargetGroupsInput{}
	}

	output = &DetachLoadBalancerTargetGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachLoadBalancerTargetGroups API operation for Auto Scaling.
//
// Detaches one or more target groups from the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DetachLoadBalancerTargetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups
func (c *AutoScaling) DetachLoadBalancerTargetGroups(input *DetachLoadBalancerTargetGroupsInput) (*DetachLoadBalancerTargetGroupsOutput, error) {
	req, out := c.DetachLoadBalancerTargetGroupsRequest(input)
	return out, req.Send()
}

// DetachLoadBalancerTargetGroupsWithContext is the same as DetachLoadBalancerTargetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DetachLoadBalancerTargetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DetachLoadBalancerTargetGroupsWithContext(ctx aws.Context, input *DetachLoadBalancerTargetGroupsInput, opts ...request.Option) (*DetachLoadBalancerTargetGroupsOutput, error) {
	req, out := c.DetachLoadBalancerTargetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachLoadBalancers = "DetachLoadBalancers"

// DetachLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the DetachLoadBalancers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachLoadBalancers for more information on using the DetachLoadBalancers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachLoadBalancersRequest method.
//    req, resp := client.DetachLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers
func (c *AutoScaling) DetachLoadBalancersRequest(input *DetachLoadBalancersInput) (req *request.Request, output *DetachLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDetachLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachLoadBalancersInput{}
	}

	output = &DetachLoadBalancersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachLoadBalancers API operation for Auto Scaling.
//
// Detaches one or more Classic Load Balancers from the specified Auto Scaling
// group.
//
// This operation detaches only Classic Load Balancers. If you have Application
// Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the
// DetachLoadBalancerTargetGroups API instead.
//
// When you detach a load balancer, it enters the Removing state while deregistering
// the instances in the group. When all instances are deregistered, then you
// can no longer describe the load balancer using the DescribeLoadBalancers
// API call. The instances remain running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DetachLoadBalancers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers
func (c *AutoScaling) DetachLoadBalancers(input *DetachLoadBalancersInput) (*DetachLoadBalancersOutput, error) {
	req, out := c.DetachLoadBalancersRequest(input)
	return out, req.Send()
}

// DetachLoadBalancersWithContext is the same as DetachLoadBalancers with the addition of
// the ability to pass a context and additional request options.
//
// See DetachLoadBalancers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DetachLoadBalancersWithContext(ctx aws.Context, input *DetachLoadBalancersInput, opts ...request.Option) (*DetachLoadBalancersOutput, error) {
	req, out := c.DetachLoadBalancersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableMetricsCollection = "DisableMetricsCollection"

// DisableMetricsCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DisableMetricsCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableMetricsCollection for more information on using the DisableMetricsCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableMetricsCollectionRequest method.
//    req, resp := client.DisableMetricsCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection
func (c *AutoScaling) DisableMetricsCollectionRequest(input *DisableMetricsCollectionInput) (req *request.Request, output *DisableMetricsCollectionOutput) {
	op := &request.Operation{
		Name:       opDisableMetricsCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableMetricsCollectionInput{}
	}

	output = &DisableMetricsCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableMetricsCollection API operation for Auto Scaling.
//
// Disables group metrics for the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DisableMetricsCollection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection
func (c *AutoScaling) DisableMetricsCollection(input *DisableMetricsCollectionInput) (*DisableMetricsCollectionOutput, error) {
	req, out := c.DisableMetricsCollectionRequest(input)
	return out, req.Send()
}

// DisableMetricsCollectionWithContext is the same as DisableMetricsCollection with the addition of
// the ability to pass a context and additional request options.
//
// See DisableMetricsCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) DisableMetricsCollectionWithContext(ctx aws.Context, input *DisableMetricsCollectionInput, opts ...request.Option) (*DisableMetricsCollectionOutput, error) {
	req, out := c.DisableMetricsCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableMetricsCollection = "EnableMetricsCollection"

// EnableMetricsCollectionRequest generates a "aws/request.Request" representing the
// client's request for the EnableMetricsCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableMetricsCollection for more information on using the EnableMetricsCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableMetricsCollectionRequest method.
//    req, resp := client.EnableMetricsCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection
func (c *AutoScaling) EnableMetricsCollectionRequest(input *EnableMetricsCollectionInput) (req *request.Request, output *EnableMetricsCollectionOutput) {
	op := &request.Operation{
		Name:       opEnableMetricsCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableMetricsCollectionInput{}
	}

	output = &EnableMetricsCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableMetricsCollection API operation for Auto Scaling.
//
// Enables group metrics for the specified Auto Scaling group. For more information,
// see Monitoring CloudWatch metrics for your Auto Scaling groups and instances
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation EnableMetricsCollection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection
func (c *AutoScaling) EnableMetricsCollection(input *EnableMetricsCollectionInput) (*EnableMetricsCollectionOutput, error) {
	req, out := c.EnableMetricsCollectionRequest(input)
	return out, req.Send()
}

// EnableMetricsCollectionWithContext is the same as EnableMetricsCollection with the addition of
// the ability to pass a context and additional request options.
//
// See EnableMetricsCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) EnableMetricsCollectionWithContext(ctx aws.Context, input *EnableMetricsCollectionInput, opts ...request.Option) (*EnableMetricsCollectionOutput, error) {
	req, out := c.EnableMetricsCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnterStandby = "EnterStandby"

// EnterStandbyRequest generates a "aws/request.Request" representing the
// client's request for the EnterStandby operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnterStandby for more information on using the EnterStandby
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnterStandbyRequest method.
//    req, resp := client.EnterStandbyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby
func (c *AutoScaling) EnterStandbyRequest(input *EnterStandbyInput) (req *request.Request, output *EnterStandbyOutput) {
	op := &request.Operation{
		Name:       opEnterStandby,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnterStandbyInput{}
	}

	output = &EnterStandbyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnterStandby API operation for Auto Scaling.
//
// Moves the specified instances into the standby state.
//
// If you choose to decrement the desired capacity of the Auto Scaling group,
// the instances can enter standby as long as the desired capacity of the Auto
// Scaling group after the instances are placed into standby is equal to or
// greater than the minimum capacity of the group.
//
// If you choose not to decrement the desired capacity of the Auto Scaling group,
// the Auto Scaling group launches new instances to replace the instances on
// standby.
//
// For more information, see Temporarily removing instances from your Auto Scaling
// group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation EnterStandby for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby
func (c *AutoScaling) EnterStandby(input *EnterStandbyInput) (*EnterStandbyOutput, error) {
	req, out := c.EnterStandbyRequest(input)
	return out, req.Send()
}

// EnterStandbyWithContext is the same as EnterStandby with the addition of
// the ability to pass a context and additional request options.
//
// See EnterStandby for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) EnterStandbyWithContext(ctx aws.Context, input *EnterStandbyInput, opts ...request.Option) (*EnterStandbyOutput, error) {
	req, out := c.EnterStandbyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecutePolicy = "ExecutePolicy"

// ExecutePolicyRequest generates a "aws/request.Request" representing the
// client's request for the ExecutePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecutePolicy for more information on using the ExecutePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExecutePolicyRequest method.
//    req, resp := client.ExecutePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExecutePolicy
func (c *AutoScaling) ExecutePolicyRequest(input *ExecutePolicyInput) (req *request.Request, output *ExecutePolicyOutput) {
	op := &request.Operation{
		Name:       opExecutePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecutePolicyInput{}
	}

	output = &ExecutePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ExecutePolicy API operation for Auto Scaling.
//
// Executes the specified policy. This can be useful for testing the design
// of your scaling policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation ExecutePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScalingActivityInProgressFault "ScalingActivityInProgress"
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExecutePolicy
func (c *AutoScaling) ExecutePolicy(input *ExecutePolicyInput) (*ExecutePolicyOutput, error) {
	req, out := c.ExecutePolicyRequest(input)
	return out, req.Send()
}

// ExecutePolicyWithContext is the same as ExecutePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ExecutePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) ExecutePolicyWithContext(ctx aws.Context, input *ExecutePolicyInput, opts ...request.Option) (*ExecutePolicyOutput, error) {
	req, out := c.ExecutePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExitStandby = "ExitStandby"

// ExitStandbyRequest generates a "aws/request.Request" representing the
// client's request for the ExitStandby operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExitStandby for more information on using the ExitStandby
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExitStandbyRequest method.
//    req, resp := client.ExitStandbyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby
func (c *AutoScaling) ExitStandbyRequest(input *ExitStandbyInput) (req *request.Request, output *ExitStandbyOutput) {
	op := &request.Operation{
		Name:       opExitStandby,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExitStandbyInput{}
	}

	output = &ExitStandbyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExitStandby API operation for Auto Scaling.
//
// Moves the specified instances out of the standby state.
//
// After you put the instances back in service, the desired capacity is incremented.
//
// For more information, see Temporarily removing instances from your Auto Scaling
// group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation ExitStandby for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby
func (c *AutoScaling) ExitStandby(input *ExitStandbyInput) (*ExitStandbyOutput, error) {
	req, out := c.ExitStandbyRequest(input)
	return out, req.Send()
}

// ExitStandbyWithContext is the same as ExitStandby with the addition of
// the ability to pass a context and additional request options.
//
// See ExitStandby for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) ExitStandbyWithContext(ctx aws.Context, input *ExitStandbyInput, opts ...request.Option) (*ExitStandbyOutput, error) {
	req, out := c.ExitStandbyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPredictiveScalingForecast = "GetPredictiveScalingForecast"

// GetPredictiveScalingForecastRequest generates a "aws/request.Request" representing the
// client's request for the GetPredictiveScalingForecast operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPredictiveScalingForecast for more information on using the GetPredictiveScalingForecast
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPredictiveScalingForecastRequest method.
//    req, resp := client.GetPredictiveScalingForecastRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/GetPredictiveScalingForecast
func (c *AutoScaling) GetPredictiveScalingForecastRequest(input *GetPredictiveScalingForecastInput) (req *request.Request, output *GetPredictiveScalingForecastOutput) {
	op := &request.Operation{
		Name:       opGetPredictiveScalingForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPredictiveScalingForecastInput{}
	}

	output = &GetPredictiveScalingForecastOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPredictiveScalingForecast API operation for Auto Scaling.
//
// Retrieves the forecast data for a predictive scaling policy.
//
// Load forecasts are predictions of the hourly load values using historical
// load data from CloudWatch and an analysis of historical trends. Capacity
// forecasts are represented as predicted values for the minimum capacity that
// is needed on an hourly basis, based on the hourly load forecast.
//
// A minimum of 24 hours of data is required to create the initial forecasts.
// However, having a full 14 days of historical data results in more accurate
// forecasts.
//
// For more information, see Predictive scaling for Amazon EC2 Auto Scaling
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation GetPredictiveScalingForecast for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/GetPredictiveScalingForecast
func (c *AutoScaling) GetPredictiveScalingForecast(input *GetPredictiveScalingForecastInput) (*GetPredictiveScalingForecastOutput, error) {
	req, out := c.GetPredictiveScalingForecastRequest(input)
	return out, req.Send()
}

// GetPredictiveScalingForecastWithContext is the same as GetPredictiveScalingForecast with the addition of
// the ability to pass a context and additional request options.
//
// See GetPredictiveScalingForecast for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) GetPredictiveScalingForecastWithContext(ctx aws.Context, input *GetPredictiveScalingForecastInput, opts ...request.Option) (*GetPredictiveScalingForecastOutput, error) {
	req, out := c.GetPredictiveScalingForecastRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLifecycleHook = "PutLifecycleHook"

// PutLifecycleHookRequest generates a "aws/request.Request" representing the
// client's request for the PutLifecycleHook operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLifecycleHook for more information on using the PutLifecycleHook
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLifecycleHookRequest method.
//    req, resp := client.PutLifecycleHookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutLifecycleHook
func (c *AutoScaling) PutLifecycleHookRequest(input *PutLifecycleHookInput) (req *request.Request, output *PutLifecycleHookOutput) {
	op := &request.Operation{
		Name:       opPutLifecycleHook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLifecycleHookInput{}
	}

	output = &PutLifecycleHookOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLifecycleHook API operation for Auto Scaling.
//
// Creates or updates a lifecycle hook for the specified Auto Scaling group.
//
// A lifecycle hook enables an Auto Scaling group to be aware of events in the
// Auto Scaling instance lifecycle, and then perform a custom action when the
// corresponding lifecycle event occurs.
//
// This step is a part of the procedure for adding a lifecycle hook to an Auto
// Scaling group:
//
// (Optional) Create a Lambda function and a rule that allows Amazon EventBridge
// to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates
// instances.
//
// (Optional) Create a notification target and an IAM role. The target can be
// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon
// EC2 Auto Scaling to publish lifecycle notifications to the target.
//
// Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
// If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state using the RecordLifecycleActionHeartbeat API
// call.
//
// If you finish before the timeout period ends, send a callback by using the
// CompleteLifecycleAction API call.
//
// For more information, see Amazon EC2 Auto Scaling lifecycle hooks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// If you exceed your maximum limit of lifecycle hooks, which by default is
// 50 per Auto Scaling group, the call fails.
//
// You can view the lifecycle hooks for an Auto Scaling group using the DescribeLifecycleHooks
// API call. If you are no longer using a lifecycle hook, you can delete it
// by calling the DeleteLifecycleHook API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutLifecycleHook for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutLifecycleHook
func (c *AutoScaling) PutLifecycleHook(input *PutLifecycleHookInput) (*PutLifecycleHookOutput, error) {
	req, out := c.PutLifecycleHookRequest(input)
	return out, req.Send()
}

// PutLifecycleHookWithContext is the same as PutLifecycleHook with the addition of
// the ability to pass a context and additional request options.
//
// See PutLifecycleHook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) PutLifecycleHookWithContext(ctx aws.Context, input *PutLifecycleHookInput, opts ...request.Option) (*PutLifecycleHookOutput, error) {
	req, out := c.PutLifecycleHookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutNotificationConfiguration = "PutNotificationConfiguration"

// PutNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutNotificationConfiguration for more information on using the PutNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutNotificationConfigurationRequest method.
//    req, resp := client.PutNotificationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration
func (c *AutoScaling) PutNotificationConfigurationRequest(input *PutNotificationConfigurationInput) (req *request.Request, output *PutNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutNotificationConfigurationInput{}
	}

	output = &PutNotificationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutNotificationConfiguration API operation for Auto Scaling.
//
// Configures an Auto Scaling group to send notifications when specified events
// take place. Subscribers to the specified topic can have messages delivered
// to an endpoint such as a web server or an email address.
//
// This configuration overwrites any existing configuration.
//
// For more information, see Getting Amazon SNS notifications when your Auto
// Scaling group scales (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling
// group, the call fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutNotificationConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration
func (c *AutoScaling) PutNotificationConfiguration(input *PutNotificationConfigurationInput) (*PutNotificationConfigurationOutput, error) {
	req, out := c.PutNotificationConfigurationRequest(input)
	return out, req.Send()
}

// PutNotificationConfigurationWithContext is the same as PutNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) PutNotificationConfigurationWithContext(ctx aws.Context, input *PutNotificationConfigurationInput, opts ...request.Option) (*PutNotificationConfigurationOutput, error) {
	req, out := c.PutNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScalingPolicy for more information on using the PutScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutScalingPolicyRequest method.
//    req, resp := client.PutScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy
func (c *AutoScaling) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	output = &PutScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutScalingPolicy API operation for Auto Scaling.
//
// Creates or updates a scaling policy for an Auto Scaling group. Scaling policies
// are used to scale an Auto Scaling group based on configurable metrics. If
// no policies are defined, the dynamic scaling and predictive scaling features
// are not used.
//
// For more information about using dynamic scaling, see Target tracking scaling
// policies (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html)
// and Step and simple scaling policies (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// For more information about using predictive scaling, see Predictive scaling
// for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// You can view the scaling policies for an Auto Scaling group using the DescribePolicies
// API call. If you are no longer using a scaling policy, you can delete it
// by calling the DeletePolicy API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy
func (c *AutoScaling) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	return out, req.Send()
}

// PutScalingPolicyWithContext is the same as PutScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) PutScalingPolicyWithContext(ctx aws.Context, input *PutScalingPolicyInput, opts ...request.Option) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScheduledUpdateGroupAction = "PutScheduledUpdateGroupAction"

// PutScheduledUpdateGroupActionRequest generates a "aws/request.Request" representing the
// client's request for the PutScheduledUpdateGroupAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScheduledUpdateGroupAction for more information on using the PutScheduledUpdateGroupAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutScheduledUpdateGroupActionRequest method.
//    req, resp := client.PutScheduledUpdateGroupActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScheduledUpdateGroupAction
func (c *AutoScaling) PutScheduledUpdateGroupActionRequest(input *PutScheduledUpdateGroupActionInput) (req *request.Request, output *PutScheduledUpdateGroupActionOutput) {
	op := &request.Operation{
		Name:       opPutScheduledUpdateGroupAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScheduledUpdateGroupActionInput{}
	}

	output = &PutScheduledUpdateGroupActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutScheduledUpdateGroupAction API operation for Auto Scaling.
//
// Creates or updates a scheduled scaling action for an Auto Scaling group.
//
// For more information, see Scheduled scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// You can view the scheduled actions for an Auto Scaling group using the DescribeScheduledActions
// API call. If you are no longer using a scheduled action, you can delete it
// by calling the DeleteScheduledAction API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutScheduledUpdateGroupAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsFault "AlreadyExists"
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScheduledUpdateGroupAction
func (c *AutoScaling) PutScheduledUpdateGroupAction(input *PutScheduledUpdateGroupActionInput) (*PutScheduledUpdateGroupActionOutput, error) {
	req, out := c.PutScheduledUpdateGroupActionRequest(input)
	return out, req.Send()
}

// PutScheduledUpdateGroupActionWithContext is the same as PutScheduledUpdateGroupAction with the addition of
// the ability to pass a context and additional request options.
//
// See PutScheduledUpdateGroupAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) PutScheduledUpdateGroupActionWithContext(ctx aws.Context, input *PutScheduledUpdateGroupActionInput, opts ...request.Option) (*PutScheduledUpdateGroupActionOutput, error) {
	req, out := c.PutScheduledUpdateGroupActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutWarmPool = "PutWarmPool"

// PutWarmPoolRequest generates a "aws/request.Request" representing the
// client's request for the PutWarmPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutWarmPool for more information on using the PutWarmPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutWarmPoolRequest method.
//    req, resp := client.PutWarmPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutWarmPool
func (c *AutoScaling) PutWarmPoolRequest(input *PutWarmPoolInput) (req *request.Request, output *PutWarmPoolOutput) {
	op := &request.Operation{
		Name:       opPutWarmPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutWarmPoolInput{}
	}

	output = &PutWarmPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutWarmPool API operation for Auto Scaling.
//
// Creates or updates a warm pool for the specified Auto Scaling group. A warm
// pool is a pool of pre-initialized EC2 instances that sits alongside the Auto
// Scaling group. Whenever your application needs to scale out, the Auto Scaling
// group can draw on the warm pool to meet its new desired capacity. For more
// information and example configurations, see Warm pools for Amazon EC2 Auto
// Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// This operation must be called from the Region in which the Auto Scaling group
// was created. This operation cannot be called on an Auto Scaling group that
// has a mixed instances policy or a launch template or launch configuration
// that requests Spot Instances.
//
// You can view the instances in the warm pool using the DescribeWarmPool API
// call. If you are no longer using a warm pool, you can delete it by calling
// the DeleteWarmPool API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutWarmPool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutWarmPool
func (c *AutoScaling) PutWarmPool(input *PutWarmPoolInput) (*PutWarmPoolOutput, error) {
	req, out := c.PutWarmPoolRequest(input)
	return out, req.Send()
}

// PutWarmPoolWithContext is the same as PutWarmPool with the addition of
// the ability to pass a context and additional request options.
//
// See PutWarmPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) PutWarmPoolWithContext(ctx aws.Context, input *PutWarmPoolInput, opts ...request.Option) (*PutWarmPoolOutput, error) {
	req, out := c.PutWarmPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRecordLifecycleActionHeartbeat = "RecordLifecycleActionHeartbeat"

// RecordLifecycleActionHeartbeatRequest generates a "aws/request.Request" representing the
// client's request for the RecordLifecycleActionHeartbeat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RecordLifecycleActionHeartbeat for more information on using the RecordLifecycleActionHeartbeat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RecordLifecycleActionHeartbeatRequest method.
//    req, resp := client.RecordLifecycleActionHeartbeatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat
func (c *AutoScaling) RecordLifecycleActionHeartbeatRequest(input *RecordLifecycleActionHeartbeatInput) (req *request.Request, output *RecordLifecycleActionHeartbeatOutput) {
	op := &request.Operation{
		Name:       opRecordLifecycleActionHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecordLifecycleActionHeartbeatInput{}
	}

	output = &RecordLifecycleActionHeartbeatOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RecordLifecycleActionHeartbeat API operation for Auto Scaling.
//
// Records a heartbeat for the lifecycle action associated with the specified
// token or instance. This extends the timeout by the length of time defined
// using the PutLifecycleHook API call.
//
// This step is a part of the procedure for adding a lifecycle hook to an Auto
// Scaling group:
//
// (Optional) Create a Lambda function and a rule that allows Amazon EventBridge
// to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates
// instances.
//
// (Optional) Create a notification target and an IAM role. The target can be
// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon
// EC2 Auto Scaling to publish lifecycle notifications to the target.
//
// Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
// If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state.
//
// If you finish before the timeout period ends, send a callback by using the
// CompleteLifecycleAction API call.
//
// For more information, see Amazon EC2 Auto Scaling lifecycle hooks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation RecordLifecycleActionHeartbeat for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat
func (c *AutoScaling) RecordLifecycleActionHeartbeat(input *RecordLifecycleActionHeartbeatInput) (*RecordLifecycleActionHeartbeatOutput, error) {
	req, out := c.RecordLifecycleActionHeartbeatRequest(input)
	return out, req.Send()
}

// RecordLifecycleActionHeartbeatWithContext is the same as RecordLifecycleActionHeartbeat with the addition of
// the ability to pass a context and additional request options.
//
// See RecordLifecycleActionHeartbeat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) RecordLifecycleActionHeartbeatWithContext(ctx aws.Context, input *RecordLifecycleActionHeartbeatInput, opts ...request.Option) (*RecordLifecycleActionHeartbeatOutput, error) {
	req, out := c.RecordLifecycleActionHeartbeatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeProcesses = "ResumeProcesses"

// ResumeProcessesRequest generates a "aws/request.Request" representing the
// client's request for the ResumeProcesses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeProcesses for more information on using the ResumeProcesses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResumeProcessesRequest method.
//    req, resp := client.ResumeProcessesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ResumeProcesses
func (c *AutoScaling) ResumeProcessesRequest(input *ScalingProcessQuery) (req *request.Request, output *ResumeProcessesOutput) {
	op := &request.Operation{
		Name:       opResumeProcesses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScalingProcessQuery{}
	}

	output = &ResumeProcessesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResumeProcesses API operation for Auto Scaling.
//
// Resumes the specified suspended auto scaling processes, or all suspended
// process, for the specified Auto Scaling group.
//
// For more information, see Suspending and resuming scaling processes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation ResumeProcesses for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseFault "ResourceInUse"
//   The operation can't be performed because the resource is in use.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ResumeProcesses
func (c *AutoScaling) ResumeProcesses(input *ScalingProcessQuery) (*ResumeProcessesOutput, error) {
	req, out := c.ResumeProcessesRequest(input)
	return out, req.Send()
}

// ResumeProcessesWithContext is the same as ResumeProcesses with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeProcesses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) ResumeProcessesWithContext(ctx aws.Context, input *ScalingProcessQuery, opts ...request.Option) (*ResumeProcessesOutput, error) {
	req, out := c.ResumeProcessesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDesiredCapacity = "SetDesiredCapacity"

// SetDesiredCapacityRequest generates a "aws/request.Request" representing the
// client's request for the SetDesiredCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDesiredCapacity for more information on using the SetDesiredCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetDesiredCapacityRequest method.
//    req, resp := client.SetDesiredCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity
func (c *AutoScaling) SetDesiredCapacityRequest(input *SetDesiredCapacityInput) (req *request.Request, output *SetDesiredCapacityOutput) {
	op := &request.Operation{
		Name:       opSetDesiredCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDesiredCapacityInput{}
	}

	output = &SetDesiredCapacityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetDesiredCapacity API operation for Auto Scaling.
//
// Sets the size of the specified Auto Scaling group.
//
// If a scale-in activity occurs as a result of a new DesiredCapacity value
// that is lower than the current size of the group, the Auto Scaling group
// uses its termination policy to determine which instances to terminate.
//
// For more information, see Manual scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation SetDesiredCapacity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScalingActivityInProgressFault "ScalingActivityInProgress"
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity
func (c *AutoScaling) SetDesiredCapacity(input *SetDesiredCapacityInput) (*SetDesiredCapacityOutput, error) {
	req, out := c.SetDesiredCapacityRequest(input)
	return out, req.Send()
}

// SetDesiredCapacityWithContext is the same as SetDesiredCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See SetDesiredCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) SetDesiredCapacityWithContext(ctx aws.Context, input *SetDesiredCapacityInput, opts ...request.Option) (*SetDesiredCapacityOutput, error) {
	req, out := c.SetDesiredCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetInstanceHealth = "SetInstanceHealth"

// SetInstanceHealthRequest generates a "aws/request.Request" representing the
// client's request for the SetInstanceHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetInstanceHealth for more information on using the SetInstanceHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetInstanceHealthRequest method.
//    req, resp := client.SetInstanceHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceHealth
func (c *AutoScaling) SetInstanceHealthRequest(input *SetInstanceHealthInput) (req *request.Request, output *SetInstanceHealthOutput) {
	op := &request.Operation{
		Name:       opSetInstanceHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetInstanceHealthInput{}
	}

	output = &SetInstanceHealthOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetInstanceHealth API operation for Auto Scaling.
//
// Sets the health status of the specified instance.
//
// For more information, see Health checks for Auto Scaling instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation SetInstanceHealth for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceHealth
func (c *AutoScaling) SetInstanceHealth(input *SetInstanceHealthInput) (*SetInstanceHealthOutput, error) {
	req, out := c.SetInstanceHealthRequest(input)
	return out, req.Send()
}

// SetInstanceHealthWithContext is the same as SetInstanceHealth with the addition of
// the ability to pass a context and additional request options.
//
// See SetInstanceHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) SetInstanceHealthWithContext(ctx aws.Context, input *SetInstanceHealthInput, opts ...request.Option) (*SetInstanceHealthOutput, error) {
	req, out := c.SetInstanceHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetInstanceProtection = "SetInstanceProtection"

// SetInstanceProtectionRequest generates a "aws/request.Request" representing the
// client's request for the SetInstanceProtection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetInstanceProtection for more information on using the SetInstanceProtection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetInstanceProtectionRequest method.
//    req, resp := client.SetInstanceProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceProtection
func (c *AutoScaling) SetInstanceProtectionRequest(input *SetInstanceProtectionInput) (req *request.Request, output *SetInstanceProtectionOutput) {
	op := &request.Operation{
		Name:       opSetInstanceProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetInstanceProtectionInput{}
	}

	output = &SetInstanceProtectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetInstanceProtection API operation for Auto Scaling.
//
// Updates the instance protection settings of the specified instances. This
// operation cannot be called on instances in a warm pool.
//
// For more information about preventing instances that are part of an Auto
// Scaling group from terminating on scale in, see Using instance scale-in protection
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling
// group, the call fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation SetInstanceProtection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceProtection
func (c *AutoScaling) SetInstanceProtection(input *SetInstanceProtectionInput) (*SetInstanceProtectionOutput, error) {
	req, out := c.SetInstanceProtectionRequest(input)
	return out, req.Send()
}

// SetInstanceProtectionWithContext is the same as SetInstanceProtection with the addition of
// the ability to pass a context and additional request options.
//
// See SetInstanceProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) SetInstanceProtectionWithContext(ctx aws.Context, input *SetInstanceProtectionInput, opts ...request.Option) (*SetInstanceProtectionOutput, error) {
	req, out := c.SetInstanceProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInstanceRefresh = "StartInstanceRefresh"

// StartInstanceRefreshRequest generates a "aws/request.Request" representing the
// client's request for the StartInstanceRefresh operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInstanceRefresh for more information on using the StartInstanceRefresh
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartInstanceRefreshRequest method.
//    req, resp := client.StartInstanceRefreshRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/StartInstanceRefresh
func (c *AutoScaling) StartInstanceRefreshRequest(input *StartInstanceRefreshInput) (req *request.Request, output *StartInstanceRefreshOutput) {
	op := &request.Operation{
		Name:       opStartInstanceRefresh,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstanceRefreshInput{}
	}

	output = &StartInstanceRefreshOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartInstanceRefresh API operation for Auto Scaling.
//
// Starts a new instance refresh operation. An instance refresh performs a rolling
// replacement of all or some instances in an Auto Scaling group. Each instance
// is terminated first and then replaced, which temporarily reduces the capacity
// available within your Auto Scaling group.
//
// This operation is part of the instance refresh feature (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
// in Amazon EC2 Auto Scaling, which helps you update instances in your Auto
// Scaling group. This feature is helpful, for example, when you have a new
// AMI or a new user data script. You just need to create a new launch template
// that specifies the new AMI or user data script. Then start an instance refresh
// to immediately begin the process of updating instances in the group.
//
// If the call succeeds, it creates a new instance refresh request with a unique
// ID that you can use to track its progress. To query its status, call the
// DescribeInstanceRefreshes API. To describe the instance refreshes that have
// already run, call the DescribeInstanceRefreshes API. To cancel an instance
// refresh operation in progress, use the CancelInstanceRefresh API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation StartInstanceRefresh for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededFault "LimitExceeded"
//   You have already reached a limit for your Amazon EC2 Auto Scaling resources
//   (for example, Auto Scaling groups, launch configurations, or lifecycle hooks).
//   For more information, see DescribeAccountLimits (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_DescribeAccountLimits.html)
//   in the Amazon EC2 Auto Scaling API Reference.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeInstanceRefreshInProgressFault "InstanceRefreshInProgress"
//   The request failed because an active instance refresh operation already exists
//   for the specified Auto Scaling group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/StartInstanceRefresh
func (c *AutoScaling) StartInstanceRefresh(input *StartInstanceRefreshInput) (*StartInstanceRefreshOutput, error) {
	req, out := c.StartInstanceRefreshRequest(input)
	return out, req.Send()
}

// StartInstanceRefreshWithContext is the same as StartInstanceRefresh with the addition of
// the ability to pass a context and additional request options.
//
// See StartInstanceRefresh for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) StartInstanceRefreshWithContext(ctx aws.Context, input *StartInstanceRefreshInput, opts ...request.Option) (*StartInstanceRefreshOutput, error) {
	req, out := c.StartInstanceRefreshRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSuspendProcesses = "SuspendProcesses"

// SuspendProcessesRequest generates a "aws/request.Request" representing the
// client's request for the SuspendProcesses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SuspendProcesses for more information on using the SuspendProcesses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SuspendProcessesRequest method.
//    req, resp := client.SuspendProcessesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses
func (c *AutoScaling) SuspendProcessesRequest(input *ScalingProcessQuery) (req *request.Request, output *SuspendProcessesOutput) {
	op := &request.Operation{
		Name:       opSuspendProcesses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScalingProcessQuery{}
	}

	output = &SuspendProcessesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SuspendProcesses API operation for Auto Scaling.
//
// Suspends the specified auto scaling processes, or all processes, for the
// specified Auto Scaling group.
//
// If you suspend either the Launch or Terminate process types, it can prevent
// other process types from functioning properly. For more information, see
// Suspending and resuming scaling processes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// To resume processes that have been suspended, call the ResumeProcesses API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation SuspendProcesses for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseFault "ResourceInUse"
//   The operation can't be performed because the resource is in use.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses
func (c *AutoScaling) SuspendProcesses(input *ScalingProcessQuery) (*SuspendProcessesOutput, error) {
	req, out := c.SuspendProcessesRequest(input)
	return out, req.Send()
}

// SuspendProcessesWithContext is the same as SuspendProcesses with the addition of
// the ability to pass a context and additional request options.
//
// See SuspendProcesses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) SuspendProcessesWithContext(ctx aws.Context, input *ScalingProcessQuery, opts ...request.Option) (*SuspendProcessesOutput, error) {
	req, out := c.SuspendProcessesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateInstanceInAutoScalingGroup = "TerminateInstanceInAutoScalingGroup"

// TerminateInstanceInAutoScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the TerminateInstanceInAutoScalingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateInstanceInAutoScalingGroup for more information on using the TerminateInstanceInAutoScalingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateInstanceInAutoScalingGroupRequest method.
//    req, resp := client.TerminateInstanceInAutoScalingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TerminateInstanceInAutoScalingGroup
func (c *AutoScaling) TerminateInstanceInAutoScalingGroupRequest(input *TerminateInstanceInAutoScalingGroupInput) (req *request.Request, output *TerminateInstanceInAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opTerminateInstanceInAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateInstanceInAutoScalingGroupInput{}
	}

	output = &TerminateInstanceInAutoScalingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateInstanceInAutoScalingGroup API operation for Auto Scaling.
//
// Terminates the specified instance and optionally adjusts the desired group
// size. This operation cannot be called on instances in a warm pool.
//
// This call simply makes a termination request. The instance is not terminated
// immediately. When an instance is terminated, the instance status changes
// to terminated. You can't connect to or start an instance after you've terminated
// it.
//
// If you do not specify the option to decrement the desired capacity, Amazon
// EC2 Auto Scaling launches instances to replace the ones that are terminated.
//
// By default, Amazon EC2 Auto Scaling balances instances across all Availability
// Zones. If you decrement the desired capacity, your Auto Scaling group can
// become unbalanced between Availability Zones. Amazon EC2 Auto Scaling tries
// to rebalance the group, and rebalancing might terminate instances in other
// zones. For more information, see Rebalancing activities (https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage)
// in the Amazon EC2 Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation TerminateInstanceInAutoScalingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScalingActivityInProgressFault "ScalingActivityInProgress"
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TerminateInstanceInAutoScalingGroup
func (c *AutoScaling) TerminateInstanceInAutoScalingGroup(input *TerminateInstanceInAutoScalingGroupInput) (*TerminateInstanceInAutoScalingGroupOutput, error) {
	req, out := c.TerminateInstanceInAutoScalingGroupRequest(input)
	return out, req.Send()
}

// TerminateInstanceInAutoScalingGroupWithContext is the same as TerminateInstanceInAutoScalingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateInstanceInAutoScalingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) TerminateInstanceInAutoScalingGroupWithContext(ctx aws.Context, input *TerminateInstanceInAutoScalingGroupInput, opts ...request.Option) (*TerminateInstanceInAutoScalingGroupOutput, error) {
	req, out := c.TerminateInstanceInAutoScalingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAutoScalingGroup = "UpdateAutoScalingGroup"

// UpdateAutoScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAutoScalingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAutoScalingGroup for more information on using the UpdateAutoScalingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAutoScalingGroupRequest method.
//    req, resp := client.UpdateAutoScalingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/UpdateAutoScalingGroup
func (c *AutoScaling) UpdateAutoScalingGroupRequest(input *UpdateAutoScalingGroupInput) (req *request.Request, output *UpdateAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAutoScalingGroupInput{}
	}

	output = &UpdateAutoScalingGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAutoScalingGroup API operation for Auto Scaling.
//
// We strongly recommend that all Auto Scaling groups use launch templates to
// ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.
//
// Updates the configuration for the specified Auto Scaling group.
//
// To update an Auto Scaling group, specify the name of the group and the parameter
// that you want to change. Any parameters that you don't specify are not changed
// by this update request. The new settings take effect on any scaling activities
// after this call returns.
//
// If you associate a new launch configuration or template with an Auto Scaling
// group, all new instances will get the updated configuration. Existing instances
// continue to run with the configuration that they were originally launched
// with. When you update a group to specify a mixed instances policy instead
// of a launch configuration or template, existing instances may be replaced
// to match the new purchasing options that you specified in the policy. For
// example, if the group currently has 100% On-Demand capacity and the policy
// specifies 50% Spot capacity, this means that half of your instances will
// be gradually terminated and relaunched as Spot Instances. When replacing
// instances, Amazon EC2 Auto Scaling launches new instances before terminating
// the old ones, so that updating your group does not compromise the performance
// or availability of your application.
//
// Note the following about changing DesiredCapacity, MaxSize, or MinSize:
//
//    * If a scale-in activity occurs as a result of a new DesiredCapacity value
//    that is lower than the current size of the group, the Auto Scaling group
//    uses its termination policy to determine which instances to terminate.
//
//    * If you specify a new value for MinSize without specifying a value for
//    DesiredCapacity, and the new MinSize is larger than the current size of
//    the group, this sets the group's DesiredCapacity to the new MinSize value.
//
//    * If you specify a new value for MaxSize without specifying a value for
//    DesiredCapacity, and the new MaxSize is smaller than the current size
//    of the group, this sets the group's DesiredCapacity to the new MaxSize
//    value.
//
// To see which parameters have been set, call the DescribeAutoScalingGroups
// API. To view the scaling policies for an Auto Scaling group, call the DescribePolicies
// API. If the group has scaling policies, you can update them by calling the
// PutScalingPolicy API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation UpdateAutoScalingGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScalingActivityInProgressFault "ScalingActivityInProgress"
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ErrCodeResourceContentionFault "ResourceContention"
//   You already have a pending update to an Amazon EC2 Auto Scaling resource
//   (for example, an Auto Scaling group, instance, or load balancer).
//
//   * ErrCodeServiceLinkedRoleFailure "ServiceLinkedRoleFailure"
//   The service-linked role is not yet ready for use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/UpdateAutoScalingGroup
func (c *AutoScaling) UpdateAutoScalingGroup(input *UpdateAutoScalingGroupInput) (*UpdateAutoScalingGroupOutput, error) {
	req, out := c.UpdateAutoScalingGroupRequest(input)
	return out, req.Send()
}

// UpdateAutoScalingGroupWithContext is the same as UpdateAutoScalingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAutoScalingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScaling) UpdateAutoScalingGroupWithContext(ctx aws.Context, input *UpdateAutoScalingGroupInput, opts ...request.Option) (*UpdateAutoScalingGroupOutput, error) {
	req, out := c.UpdateAutoScalingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies the minimum and maximum for the AcceleratorCount object when you
// specify InstanceRequirements for an Auto Scaling group.
type AcceleratorCountRequest struct {
	_ struct{} `type:"structure"`

	// The maximum value.
	Max *int64 `type:"integer"`

	// The minimum value.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorCountRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorCountRequest) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AcceleratorCountRequest) SetMax(v int64) *AcceleratorCountRequest {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AcceleratorCountRequest) SetMin(v int64) *AcceleratorCountRequest {
	s.Min = &v
	return s
}

// Specifies the minimum and maximum for the AcceleratorTotalMemoryMiB object
// when you specify InstanceRequirements for an Auto Scaling group.
type AcceleratorTotalMemoryMiBRequest struct {
	_ struct{} `type:"structure"`

	// The memory maximum in MiB.
	Max *int64 `type:"integer"`

	// The memory minimum in MiB.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorTotalMemoryMiBRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorTotalMemoryMiBRequest) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *AcceleratorTotalMemoryMiBRequest) SetMax(v int64) *AcceleratorTotalMemoryMiBRequest {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AcceleratorTotalMemoryMiBRequest) SetMin(v int64) *AcceleratorTotalMemoryMiBRequest {
	s.Min = &v
	return s
}

// Describes scaling activity, which is a long-running process that represents
// a change to your Auto Scaling group, such as changing its size or replacing
// an instance.
type Activity struct {
	_ struct{} `type:"structure"`

	// The ID of the activity.
	//
	// ActivityId is a required field
	ActivityId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupARN *string `min:"1" type:"string"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The state of the Auto Scaling group, which is either InService or Deleted.
	AutoScalingGroupState *string `min:"1" type:"string"`

	// The reason the activity began.
	//
	// Cause is a required field
	Cause *string `min:"1" type:"string" required:"true"`

	// A friendly, more verbose description of the activity.
	Description *string `type:"string"`

	// The details about the activity.
	Details *string `type:"string"`

	// The end time of the activity.
	EndTime *time.Time `type:"timestamp"`

	// A value between 0 and 100 that indicates the progress of the activity.
	Progress *int64 `type:"integer"`

	// The start time of the activity.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// The current status of the activity.
	//
	// StatusCode is a required field
	StatusCode *string `type:"string" required:"true" enum:"ScalingActivityStatusCode"`

	// A friendly, more verbose description of the activity status.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Activity) GoString() string {
	return s.String()
}

// SetActivityId sets the ActivityId field's value.
func (s *Activity) SetActivityId(v string) *Activity {
	s.ActivityId = &v
	return s
}

// SetAutoScalingGroupARN sets the AutoScalingGroupARN field's value.
func (s *Activity) SetAutoScalingGroupARN(v string) *Activity {
	s.AutoScalingGroupARN = &v
	return s
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *Activity) SetAutoScalingGroupName(v string) *Activity {
	s.AutoScalingGroupName = &v
	return s
}

// SetAutoScalingGroupState sets the AutoScalingGroupState field's value.
func (s *Activity) SetAutoScalingGroupState(v string) *Activity {
	s.AutoScalingGroupState = &v
	return s
}

// SetCause sets the Cause field's value.
func (s *Activity) SetCause(v string) *Activity {
	s.Cause = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Activity) SetDescription(v string) *Activity {
	s.Description = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *Activity) SetDetails(v string) *Activity {
	s.Details = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Activity) SetEndTime(v time.Time) *Activity {
	s.EndTime = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *Activity) SetProgress(v int64) *Activity {
	s.Progress = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Activity) SetStartTime(v time.Time) *Activity {
	s.StartTime = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *Activity) SetStatusCode(v string) *Activity {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Activity) SetStatusMessage(v string) *Activity {
	s.StatusMessage = &v
	return s
}

// Describes a policy adjustment type.
type AdjustmentType struct {
	_ struct{} `type:"structure"`

	// The policy adjustment type. The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdjustmentType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdjustmentType) GoString() string {
	return s.String()
}

// SetAdjustmentType sets the AdjustmentType field's value.
func (s *AdjustmentType) SetAdjustmentType(v string) *AdjustmentType {
	s.AdjustmentType = &v
	return s
}

// Describes an alarm.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmARN *string `min:"1" type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alarm) GoString() string {
	return s.String()
}

// SetAlarmARN sets the AlarmARN field's value.
func (s *Alarm) SetAlarmARN(v string) *Alarm {
	s.AlarmARN = &v
	return s
}

// SetAlarmName sets the AlarmName field's value.
func (s *Alarm) SetAlarmName(v string) *Alarm {
	s.AlarmName = &v
	return s
}

type AttachInstancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The IDs of the instances. You can specify up to 20 instances.
	InstanceIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachInstancesInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *AttachInstancesInput) SetAutoScalingGroupName(v string) *AttachInstancesInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *AttachInstancesInput) SetInstanceIds(v []*string) *AttachInstancesInput {
	s.InstanceIds = v
	return s
}

type AttachInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachInstancesOutput) GoString() string {
	return s.String()
}

type AttachLoadBalancerTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Names (ARN) of the target groups. You can specify up
	// to 10 target groups. To get the ARN of a target group, use the Elastic Load
	// Balancing DescribeTargetGroups (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	//
	// TargetGroupARNs is a required field
	TargetGroupARNs []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachLoadBalancerTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachLoadBalancerTargetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachLoadBalancerTargetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachLoadBalancerTargetGroupsInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.TargetGroupARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *AttachLoadBalancerTargetGroupsInput) SetAutoScalingGroupName(v string) *AttachLoadBalancerTargetGroupsInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetTargetGroupARNs sets the TargetGroupARNs field's value.
func (s *AttachLoadBalancerTargetGroupsInput) SetTargetGroupARNs(v []*string) *AttachLoadBalancerTargetGroupsInput {
	s.TargetGroupARNs = v
	return s
}

type AttachLoadBalancerTargetGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachLoadBalancerTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachLoadBalancerTargetGroupsOutput) GoString() string {
	return s.String()
}

type AttachLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The names of the load balancers. You can specify up to 10 load balancers.
	//
	// LoadBalancerNames is a required field
	LoadBalancerNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachLoadBalancersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachLoadBalancersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachLoadBalancersInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.LoadBalancerNames == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *AttachLoadBalancersInput) SetAutoScalingGroupName(v string) *AttachLoadBalancersInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetLoadBalancerNames sets the LoadBalancerNames field's value.
func (s *AttachLoadBalancersInput) SetLoadBalancerNames(v []*string) *AttachLoadBalancersInput {
	s.LoadBalancerNames = v
	return s
}

type AttachLoadBalancersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachLoadBalancersOutput) GoString() string {
	return s.String()
}

// Specifies the minimum and maximum for the BaselineEbsBandwidthMbps object
// when you specify InstanceRequirements for an Auto Scaling group.
type BaselineEbsBandwidthMbpsRequest struct {
	_ struct{} `type:"structure"`

	// The maximum value in Mbps.
	Max *int64 `type:"integer"`

	// The minimum value in Mbps.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaselineEbsBandwidthMbpsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaselineEbsBandwidthMbpsRequest) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *BaselineEbsBandwidthMbpsRequest) SetMax(v int64) *BaselineEbsBandwidthMbpsRequest {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *BaselineEbsBandwidthMbpsRequest) SetMin(v int64) *BaselineEbsBandwidthMbpsRequest {
	s.Min = &v
	return s
}

type BatchDeleteScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The names of the scheduled actions to delete. The maximum number allowed
	// is 50.
	//
	// ScheduledActionNames is a required field
	ScheduledActionNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteScheduledActionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.ScheduledActionNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *BatchDeleteScheduledActionInput) SetAutoScalingGroupName(v string) *BatchDeleteScheduledActionInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetScheduledActionNames sets the ScheduledActionNames field's value.
func (s *BatchDeleteScheduledActionInput) SetScheduledActionNames(v []*string) *BatchDeleteScheduledActionInput {
	s.ScheduledActionNames = v
	return s
}

type BatchDeleteScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// The names of the scheduled actions that could not be deleted, including an
	// error message.
	FailedScheduledActions []*FailedScheduledUpdateGroupActionRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteScheduledActionOutput) GoString() string {
	return s.String()
}

// SetFailedScheduledActions sets the FailedScheduledActions field's value.
func (s *BatchDeleteScheduledActionOutput) SetFailedScheduledActions(v []*FailedScheduledUpdateGroupActionRequest) *BatchDeleteScheduledActionOutput {
	s.FailedScheduledActions = v
	return s
}

type BatchPutScheduledUpdateGroupActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more scheduled actions. The maximum number allowed is 50.
	//
	// ScheduledUpdateGroupActions is a required field
	ScheduledUpdateGroupActions []*ScheduledUpdateGroupActionRequest `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutScheduledUpdateGroupActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutScheduledUpdateGroupActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutScheduledUpdateGroupActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutScheduledUpdateGroupActionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.ScheduledUpdateGroupActions == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledUpdateGroupActions"))
	}
	if s.ScheduledUpdateGroupActions != nil {
		for i, v := range s.ScheduledUpdateGroupActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScheduledUpdateGroupActions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *BatchPutScheduledUpdateGroupActionInput) SetAutoScalingGroupName(v string) *BatchPutScheduledUpdateGroupActionInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetScheduledUpdateGroupActions sets the ScheduledUpdateGroupActions field's value.
func (s *BatchPutScheduledUpdateGroupActionInput) SetScheduledUpdateGroupActions(v []*ScheduledUpdateGroupActionRequest) *BatchPutScheduledUpdateGroupActionInput {
	s.ScheduledUpdateGroupActions = v
	return s
}

type BatchPutScheduledUpdateGroupActionOutput struct {
	_ struct{} `type:"structure"`

	// The names of the scheduled actions that could not be created or updated,
	// including an error message.
	FailedScheduledUpdateGroupActions []*FailedScheduledUpdateGroupActionRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutScheduledUpdateGroupActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutScheduledUpdateGroupActionOutput) GoString() string {
	return s.String()
}

// SetFailedScheduledUpdateGroupActions sets the FailedScheduledUpdateGroupActions field's value.
func (s *BatchPutScheduledUpdateGroupActionOutput) SetFailedScheduledUpdateGroupActions(v []*FailedScheduledUpdateGroupActionRequest) *BatchPutScheduledUpdateGroupActionOutput {
	s.FailedScheduledUpdateGroupActions = v
	return s
}

// Describes a block device mapping.
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh).
	// For more information, see Device Naming on Linux Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// DeviceName is a required field
	DeviceName *string `min:"1" type:"string" required:"true"`

	// Parameters used to automatically set up EBS volumes when an instance is launched.
	//
	// You can specify either VirtualName or Ebs, but not both.
	Ebs *Ebs `type:"structure"`

	// Setting this value to true suppresses the specified device included in the
	// block device mapping of the AMI.
	//
	// If NoDevice is true for the root device, instances might fail the EC2 health
	// check. In that case, Amazon EC2 Auto Scaling launches replacement instances.
	//
	// If you specify NoDevice, you cannot specify Ebs.
	NoDevice *bool `type:"boolean"`

	// The name of the virtual device (for example, ephemeral0).
	//
	// You can specify either VirtualName or Ebs, but not both.
	VirtualName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockDeviceMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockDeviceMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlockDeviceMapping"}
	if s.DeviceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceName"))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}
	if s.VirtualName != nil && len(*s.VirtualName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualName", 1))
	}
	if s.Ebs != nil {
		if err := s.Ebs.Validate(); err != nil {
			invalidParams.AddNested("Ebs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceName sets the DeviceName field's value.
func (s *BlockDeviceMapping) SetDeviceName(v string) *BlockDeviceMapping {
	s.DeviceName = &v
	return s
}

// SetEbs sets the Ebs field's value.
func (s *BlockDeviceMapping) SetEbs(v *Ebs) *BlockDeviceMapping {
	s.Ebs = v
	return s
}

// SetNoDevice sets the NoDevice field's value.
func (s *BlockDeviceMapping) SetNoDevice(v bool) *BlockDeviceMapping {
	s.NoDevice = &v
	return s
}

// SetVirtualName sets the VirtualName field's value.
func (s *BlockDeviceMapping) SetVirtualName(v string) *BlockDeviceMapping {
	s.VirtualName = &v
	return s
}

type CancelInstanceRefreshInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelInstanceRefreshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelInstanceRefreshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelInstanceRefreshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelInstanceRefreshInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *CancelInstanceRefreshInput) SetAutoScalingGroupName(v string) *CancelInstanceRefreshInput {
	s.AutoScalingGroupName = &v
	return s
}

type CancelInstanceRefreshOutput struct {
	_ struct{} `type:"structure"`

	// The instance refresh ID.
	InstanceRefreshId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelInstanceRefreshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelInstanceRefreshOutput) GoString() string {
	return s.String()
}

// SetInstanceRefreshId sets the InstanceRefreshId field's value.
func (s *CancelInstanceRefreshOutput) SetInstanceRefreshId(v string) *CancelInstanceRefreshOutput {
	s.InstanceRefreshId = &v
	return s
}

// A GetPredictiveScalingForecast call returns the capacity forecast for a predictive
// scaling policy. This structure includes the data points for that capacity
// forecast, along with the timestamps of those data points.
type CapacityForecast struct {
	_ struct{} `type:"structure"`

	// The timestamps for the data points, in UTC format.
	//
	// Timestamps is a required field
	Timestamps []*time.Time `type:"list" required:"true"`

	// The values of the data points.
	//
	// Values is a required field
	Values []*float64 `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityForecast) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityForecast) GoString() string {
	return s.String()
}

// SetTimestamps sets the Timestamps field's value.
func (s *CapacityForecast) SetTimestamps(v []*time.Time) *CapacityForecast {
	s.Timestamps = v
	return s
}

// SetValues sets the Values field's value.
func (s *CapacityForecast) SetValues(v []*float64) *CapacityForecast {
	s.Values = v
	return s
}

type CompleteLifecycleActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	InstanceId *string `min:"1" type:"string"`

	// The action for the group to take. This parameter can be either CONTINUE or
	// ABANDON.
	//
	// LifecycleActionResult is a required field
	LifecycleActionResult *string `type:"string" required:"true"`

	// A universally unique identifier (UUID) that identifies a specific lifecycle
	// action associated with an instance. Amazon EC2 Auto Scaling sends this token
	// to the notification target you specified when you created the lifecycle hook.
	LifecycleActionToken *string `min:"36" type:"string"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteLifecycleActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteLifecycleActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteLifecycleActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteLifecycleActionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LifecycleActionResult == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleActionResult"))
	}
	if s.LifecycleActionToken != nil && len(*s.LifecycleActionToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleActionToken", 36))
	}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *CompleteLifecycleActionInput) SetAutoScalingGroupName(v string) *CompleteLifecycleActionInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CompleteLifecycleActionInput) SetInstanceId(v string) *CompleteLifecycleActionInput {
	s.InstanceId = &v
	return s
}

// SetLifecycleActionResult sets the LifecycleActionResult field's value.
func (s *CompleteLifecycleActionInput) SetLifecycleActionResult(v string) *CompleteLifecycleActionInput {
	s.LifecycleActionResult = &v
	return s
}

// SetLifecycleActionToken sets the LifecycleActionToken field's value.
func (s *CompleteLifecycleActionInput) SetLifecycleActionToken(v string) *CompleteLifecycleActionInput {
	s.LifecycleActionToken = &v
	return s
}

// SetLifecycleHookName sets the LifecycleHookName field's value.
func (s *CompleteLifecycleActionInput) SetLifecycleHookName(v string) *CompleteLifecycleActionInput {
	s.LifecycleHookName = &v
	return s
}

type CompleteLifecycleActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteLifecycleActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteLifecycleActionOutput) GoString() string {
	return s.String()
}

type CreateAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group. This name must be unique per Region per
	// account.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// A list of Availability Zones where instances in the Auto Scaling group can
	// be created. This parameter is optional if you specify one or more subnets
	// for VPCZoneIdentifier.
	//
	// Conditional: If your account supports EC2-Classic and VPC, this parameter
	// is required to launch instances into EC2-Classic.
	AvailabilityZones []*string `type:"list"`

	// Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing
	// is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling
	// attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot
	// Instance is at an elevated risk of interruption. After launching a new instance,
	// it then terminates an old instance. For more information, see Amazon EC2
	// Auto Scaling Capacity Rebalancing (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	CapacityRebalance *bool `type:"boolean"`

	// Reserved.
	Context *string `type:"string"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start. The default value is 300. This setting
	// applies when using simple scaling policies, but not when using other scaling
	// policies or scheduled scaling. For more information, see Scaling cooldowns
	// for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DefaultCooldown *int64 `type:"integer"`

	// The desired capacity is the initial capacity of the Auto Scaling group at
	// the time of its creation and the capacity it attempts to maintain. It can
	// scale beyond this capacity if you configure auto scaling. This number must
	// be greater than or equal to the minimum size of the group and less than or
	// equal to the maximum size of the group. If you do not specify a desired capacity,
	// the default is the minimum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The unit of measurement for the value specified for desired capacity. Amazon
	// EC2 Auto Scaling supports DesiredCapacityType for attribute-based instance
	// type selection only. For more information, see Creating an Auto Scaling group
	// using attribute-based instance type selection (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// By default, Amazon EC2 Auto Scaling specifies units, which translates into
	// number of instances.
	//
	// Valid values: units | vcpu | memory-mib
	DesiredCapacityType *string `min:"1" type:"string"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// checking the health status of an EC2 instance that has come into service
	// and marking it unhealthy due to a failed health check. The default value
	// is 0. For more information, see Health check grace period (https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Conditional: Required if you are adding an ELB health check.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 (default)
	// and ELB. If you configure an Auto Scaling group to use load balancer (ELB)
	// health checks, it considers the instance unhealthy if it fails either the
	// EC2 status checks or the load balancer health checks. For more information,
	// see Health checks for Auto Scaling instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	HealthCheckType *string `min:"1" type:"string"`

	// The ID of the instance used to base the launch configuration on. If specified,
	// Amazon EC2 Auto Scaling uses the configuration values from the specified
	// instance to create a new launch configuration. To get the instance ID, use
	// the Amazon EC2 DescribeInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html)
	// API operation. For more information, see Creating an Auto Scaling group using
	// an EC2 instance (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	InstanceId *string `min:"1" type:"string"`

	// The name of the launch configuration to use to launch instances.
	//
	// Conditional: You must specify either a launch template (LaunchTemplate or
	// MixedInstancesPolicy) or a launch configuration (LaunchConfigurationName
	// or InstanceId).
	LaunchConfigurationName *string `min:"1" type:"string"`

	// Parameters used to specify the launch template and version to use to launch
	// instances.
	//
	// Conditional: You must specify either a launch template (LaunchTemplate or
	// MixedInstancesPolicy) or a launch configuration (LaunchConfigurationName
	// or InstanceId).
	//
	// The launch template that is specified must be configured for use with an
	// Auto Scaling group. For more information, see Creating a launch template
	// for an Auto Scaling group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// One or more lifecycle hooks for the group, which specify actions to perform
	// when Amazon EC2 Auto Scaling launches or terminates instances.
	LifecycleHookSpecificationList []*LifecycleHookSpecification `type:"list"`

	// A list of Classic Load Balancers associated with this Auto Scaling group.
	// For Application Load Balancers, Network Load Balancers, and Gateway Load
	// Balancers, specify the TargetGroupARNs property instead.
	LoadBalancerNames []*string `type:"list"`

	// The maximum amount of time, in seconds, that an instance can be in service.
	// The default is null. If specified, the value must be either 0 or a number
	// equal to or greater than 86,400 seconds (1 day). For more information, see
	// Replacing Auto Scaling instances based on maximum instance lifetime (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	MaxInstanceLifetime *int64 `type:"integer"`

	// The maximum size of the group.
	//
	// With a mixed instances policy that uses instance weighting, Amazon EC2 Auto
	// Scaling may need to go above MaxSize to meet your capacity requirements.
	// In this event, Amazon EC2 Auto Scaling will never go above MaxSize by more
	// than your largest instance weight (weights that define how many units each
	// instance contributes to the desired capacity of the group).
	//
	// MaxSize is a required field
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	//
	// MinSize is a required field
	MinSize *int64 `type:"integer" required:"true"`

	// An embedded object that specifies a mixed instances policy.
	//
	// For more information, see Auto Scaling groups with multiple instance types
	// and purchase options (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	MixedInstancesPolicy *MixedInstancesPolicy `type:"structure"`

	// Indicates whether newly launched instances are protected from termination
	// by Amazon EC2 Auto Scaling when scaling in. For more information about preventing
	// instances from terminating on scale in, see Using instance scale-in protection
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of an existing placement group into which to launch your instances,
	// if any. A placement group is a logical grouping of instances within a single
	// Availability Zone. You cannot specify multiple Availability Zones and a placement
	// group. For more information, see Placement Groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	PlacementGroup *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling
	// group uses to call other Amazon Web Services on your behalf. By default,
	// Amazon EC2 Auto Scaling uses a service-linked role named AWSServiceRoleForAutoScaling,
	// which it creates if it does not exist. For more information, see Service-linked
	// roles (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	ServiceLinkedRoleARN *string `min:"1" type:"string"`

	// One or more tags. You can tag your Auto Scaling group and propagate the tags
	// to the Amazon EC2 instances it launches. Tags are not propagated to Amazon
	// EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch
	// template but use caution. If the launch template specifies an instance tag
	// with a key that is also specified for the Auto Scaling group, Amazon EC2
	// Auto Scaling overrides the value of that instance tag with the value specified
	// by the Auto Scaling group. For more information, see Tagging Auto Scaling
	// groups and instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	Tags []*Tag `type:"list"`

	// The Amazon Resource Names (ARN) of the target groups to associate with the
	// Auto Scaling group. Instances are registered as targets in a target group,
	// and traffic is routed to the target group. For more information, see Elastic
	// Load Balancing and Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	TargetGroupARNs []*string `type:"list"`

	// A policy or a list of policies that are used to select the instance to terminate.
	// These policies are executed in the order that you list them. For more information,
	// see Controlling which Auto Scaling instances terminate during scale in (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	TerminationPolicies []*string `type:"list"`

	// A comma-separated list of subnet IDs for a virtual private cloud (VPC) where
	// instances in the Auto Scaling group can be created. If you specify VPCZoneIdentifier
	// with AvailabilityZones, the subnets that you specify for this parameter must
	// reside in those Availability Zones.
	//
	// Conditional: If your account supports EC2-Classic and VPC, this parameter
	// is required to launch instances into a VPC.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAutoScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAutoScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAutoScalingGroupInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.DesiredCapacityType != nil && len(*s.DesiredCapacityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesiredCapacityType", 1))
	}
	if s.HealthCheckType != nil && len(*s.HealthCheckType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckType", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationName", 1))
	}
	if s.MaxSize == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxSize"))
	}
	if s.MinSize == nil {
		invalidParams.Add(request.NewErrParamRequired("MinSize"))
	}
	if s.PlacementGroup != nil && len(*s.PlacementGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementGroup", 1))
	}
	if s.ServiceLinkedRoleARN != nil && len(*s.ServiceLinkedRoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceLinkedRoleARN", 1))
	}
	if s.VPCZoneIdentifier != nil && len(*s.VPCZoneIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCZoneIdentifier", 1))
	}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(request.ErrInvalidParams))
		}
	}
	if s.LifecycleHookSpecificationList != nil {
		for i, v := range s.LifecycleHookSpecificationList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LifecycleHookSpecificationList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MixedInstancesPolicy != nil {
		if err := s.MixedInstancesPolicy.Validate(); err != nil {
			invalidParams.AddNested("MixedInstancesPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *CreateAutoScalingGroupInput) SetAutoScalingGroupName(v string) *CreateAutoScalingGroupInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *CreateAutoScalingGroupInput) SetAvailabilityZones(v []*string) *CreateAutoScalingGroupInput {
	s.AvailabilityZones = v
	return s
}

// SetCapacityRebalance sets the CapacityRebalance field's value.
func (s *CreateAutoScalingGroupInput) SetCapacityRebalance(v bool) *CreateAutoScalingGroupInput {
	s.CapacityRebalance = &v
	return s
}

// SetContext sets the Context field's value.
func (s *CreateAutoScalingGroupInput) SetContext(v string) *CreateAutoScalingGroupInput {
	s.Context = &v
	return s
}

// SetDefaultCooldown sets the DefaultCooldown field's value.
func (s *CreateAutoScalingGroupInput) SetDefaultCooldown(v int64) *CreateAutoScalingGroupInput {
	s.DefaultCooldown = &v
	return s
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *CreateAutoScalingGroupInput) SetDesiredCapacity(v int64) *CreateAutoScalingGroupInput {
	s.DesiredCapacity = &v
	return s
}

// SetDesiredCapacityType sets the DesiredCapacityType field's value.
func (s *CreateAutoScalingGroupInput) SetDesiredCapacityType(v string) *CreateAutoScalingGroupInput {
	s.DesiredCapacityType = &v
	return s
}

// SetHealthCheckGracePeriod sets the HealthCheckGracePeriod field's value.
func (s *CreateAutoScalingGroupInput) SetHealthCheckGracePeriod(v int64) *CreateAutoScalingGroupInput {
	s.HealthCheckGracePeriod = &v
	return s
}

// SetHealthCheckType sets the HealthCheckType field's value.
func (s *CreateAutoScalingGroupInput) SetHealthCheckType(v string) *CreateAutoScalingGroupInput {
	s.HealthCheckType = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateAutoScalingGroupInput) SetInstanceId(v string) *CreateAutoScalingGroupInput {
	s.InstanceId = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *CreateAutoScalingGroupInput) SetLaunchConfigurationName(v string) *CreateAutoScalingGroupInput {
	s.LaunchConfigurationName = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *CreateAutoScalingGroupInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *CreateAutoScalingGroupInput {
	s.LaunchTemplate = v
	return s
}

// SetLifecycleHookSpecificationList sets the LifecycleHookSpecificationList field's value.
func (s *CreateAutoScalingGroupInput) SetLifecycleHookSpecificationList(v []*LifecycleHookSpecification) *CreateAutoScalingGroupInput {
	s.LifecycleHookSpecificationList = v
	return s
}

// SetLoadBalancerNames sets the LoadBalancerNames field's value.
func (s *CreateAutoScalingGroupInput) SetLoadBalancerNames(v []*string) *CreateAutoScalingGroupInput {
	s.LoadBalancerNames = v
	return s
}

// SetMaxInstanceLifetime sets the MaxInstanceLifetime field's value.
func (s *CreateAutoScalingGroupInput) SetMaxInstanceLifetime(v int64) *CreateAutoScalingGroupInput {
	s.MaxInstanceLifetime = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *CreateAutoScalingGroupInput) SetMaxSize(v int64) *CreateAutoScalingGroupInput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *CreateAutoScalingGroupInput) SetMinSize(v int64) *CreateAutoScalingGroupInput {
	s.MinSize = &v
	return s
}

// SetMixedInstancesPolicy sets the MixedInstancesPolicy field's value.
func (s *CreateAutoScalingGroupInput) SetMixedInstancesPolicy(v *MixedInstancesPolicy) *CreateAutoScalingGroupInput {
	s.MixedInstancesPolicy = v
	return s
}

// SetNewInstancesProtectedFromScaleIn sets the NewInstancesProtectedFromScaleIn field's value.
func (s *CreateAutoScalingGroupInput) SetNewInstancesProtectedFromScaleIn(v bool) *CreateAutoScalingGroupInput {
	s.NewInstancesProtectedFromScaleIn = &v
	return s
}

// SetPlacementGroup sets the PlacementGroup field's value.
func (s *CreateAutoScalingGroupInput) SetPlacementGroup(v string) *CreateAutoScalingGroupInput {
	s.PlacementGroup = &v
	return s
}

// SetServiceLinkedRoleARN sets the ServiceLinkedRoleARN field's value.
func (s *CreateAutoScalingGroupInput) SetServiceLinkedRoleARN(v string) *CreateAutoScalingGroupInput {
	s.ServiceLinkedRoleARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAutoScalingGroupInput) SetTags(v []*Tag) *CreateAutoScalingGroupInput {
	s.Tags = v
	return s
}

// SetTargetGroupARNs sets the TargetGroupARNs field's value.
func (s *CreateAutoScalingGroupInput) SetTargetGroupARNs(v []*string) *CreateAutoScalingGroupInput {
	s.TargetGroupARNs = v
	return s
}

// SetTerminationPolicies sets the TerminationPolicies field's value.
func (s *CreateAutoScalingGroupInput) SetTerminationPolicies(v []*string) *CreateAutoScalingGroupInput {
	s.TerminationPolicies = v
	return s
}

// SetVPCZoneIdentifier sets the VPCZoneIdentifier field's value.
func (s *CreateAutoScalingGroupInput) SetVPCZoneIdentifier(v string) *CreateAutoScalingGroupInput {
	s.VPCZoneIdentifier = &v
	return s
}

type CreateAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAutoScalingGroupOutput) GoString() string {
	return s.String()
}

type CreateLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// For Auto Scaling groups that are running in a virtual private cloud (VPC),
	// specifies whether to assign a public IP address to the group's instances.
	// If you specify true, each instance in the Auto Scaling group receives a unique
	// public IP address. For more information, see Launching Auto Scaling instances
	// in a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// If you specify this parameter, you must specify at least one subnet for VPCZoneIdentifier
	// when you create your group.
	//
	// If the instance is launched into a default subnet, the default is to assign
	// a public IP address, unless you disabled the option to assign a public IP
	// address on the subnet. If the instance is launched into a nondefault subnet,
	// the default is not to assign a public IP address, unless you enabled the
	// option to assign a public IP address on the subnet.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// A block device mapping, which specifies the block devices for the instance.
	// You can specify virtual devices and EBS volumes. For more information, see
	// Block Device Mapping (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// For more information, see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
	// instances to a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// This parameter can only be used if you are launching EC2-Classic instances.
	ClassicLinkVPCId *string `min:"1" type:"string"`

	// The IDs of one or more security groups for the specified ClassicLink-enabled
	// VPC. For more information, see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
	// instances to a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// If you specify the ClassicLinkVPCId parameter, you must specify this parameter.
	ClassicLinkVPCSecurityGroups []*string `type:"list"`

	// Specifies whether the launch configuration is optimized for EBS I/O (true)
	// or not (false). The optimization provides dedicated throughput to Amazon
	// EBS and an optimized configuration stack to provide optimal I/O performance.
	// This optimization is not available with all instance types. Additional fees
	// are incurred when you enable EBS optimization for an instance type that is
	// not EBS-optimized by default. For more information, see Amazon EBS-optimized
	// instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// The default value is false.
	EbsOptimized *bool `type:"boolean"`

	// The name or the Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance. The instance profile contains the IAM
	// role.
	//
	// For more information, see IAM role for applications that run on Amazon EC2
	// instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	IamInstanceProfile *string `min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI) that was assigned during registration.
	// For more information, see Finding an AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// If you do not specify InstanceId, you must specify ImageId.
	ImageId *string `min:"1" type:"string"`

	// The ID of the instance to use to create the launch configuration. The new
	// launch configuration derives attributes from the instance, except for the
	// block device mapping.
	//
	// To create a launch configuration with a block device mapping or override
	// any other instance attributes, specify them as part of the same request.
	//
	// For more information, see Creating a launch configuration using an EC2 instance
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// If you do not specify InstanceId, you must specify both ImageId and InstanceType.
	InstanceId *string `min:"1" type:"string"`

	// Controls whether instances in this group are launched with detailed (true)
	// or basic (false) monitoring.
	//
	// The default value is true (enabled).
	//
	// When detailed monitoring is enabled, Amazon CloudWatch generates metrics
	// every minute and your account is charged a fee. When you disable detailed
	// monitoring, CloudWatch generates metrics every 5 minutes. For more information,
	// see Configure Monitoring for Auto Scaling Instances (https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// Specifies the instance type of the EC2 instance.
	//
	// For information about available instance types, see Available Instance Types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// If you do not specify InstanceId, you must specify InstanceType.
	InstanceType *string `min:"1" type:"string"`

	// The ID of the kernel associated with the AMI.
	KernelId *string `min:"1" type:"string"`

	// The name of the key pair. For more information, see Amazon EC2 Key Pairs
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	KeyName *string `min:"1" type:"string"`

	// The name of the launch configuration. This name must be unique per Region
	// per account.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The metadata options for the instances. For more information, see Configuring
	// the Instance Metadata Options (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds)
	// in the Amazon EC2 Auto Scaling User Guide.
	MetadataOptions *InstanceMetadataOptions `type:"structure"`

	// The tenancy of the instance. An instance with dedicated tenancy runs on isolated,
	// single-tenant hardware and can only be launched into a VPC.
	//
	// To launch dedicated instances into a shared tenancy VPC (a VPC with the instance
	// placement tenancy attribute set to default), you must set the value of this
	// parameter to dedicated.
	//
	// If you specify PlacementTenancy, you must specify at least one subnet for
	// VPCZoneIdentifier when you create your group.
	//
	// For more information, see Configuring instance tenancy with Amazon EC2 Auto
	// Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Valid Values: default | dedicated
	PlacementTenancy *string `min:"1" type:"string"`

	// The ID of the RAM disk to select.
	RamdiskId *string `min:"1" type:"string"`

	// A list that contains the security groups to assign to the instances in the
	// Auto Scaling group.
	//
	// [EC2-VPC] Specify the security group IDs. For more information, see Security
	// Groups for Your VPC (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	//
	// [EC2-Classic] Specify either the security group names or the security group
	// IDs. For more information, see Amazon EC2 Security Groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	SecurityGroups []*string `type:"list"`

	// The maximum hourly price to be paid for any Spot Instance launched to fulfill
	// the request. Spot Instances are launched when the price you specify exceeds
	// the current Spot price. For more information, see Requesting Spot Instances
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// When you change your maximum price by creating a new launch configuration,
	// running instances will continue to run as long as the maximum price for those
	// running instances is higher than the current Spot price.
	SpotPrice *string `min:"1" type:"string"`

	// The user data to make available to the launched EC2 instances. For more information,
	// see Instance metadata and user data (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
	// (Linux) and Instance metadata and user data (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html)
	// (Windows). If you are using a command line tool, base64-encoding is performed
	// for you, and you can load the text from a file. Otherwise, you must provide
	// base64-encoded text. User data is limited to 16 KB.
	UserData *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLaunchConfigurationInput"}
	if s.ClassicLinkVPCId != nil && len(*s.ClassicLinkVPCId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClassicLinkVPCId", 1))
	}
	if s.IamInstanceProfile != nil && len(*s.IamInstanceProfile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamInstanceProfile", 1))
	}
	if s.ImageId != nil && len(*s.ImageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageId", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.KernelId != nil && len(*s.KernelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KernelId", 1))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.LaunchConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfigurationName"))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationName", 1))
	}
	if s.PlacementTenancy != nil && len(*s.PlacementTenancy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementTenancy", 1))
	}
	if s.RamdiskId != nil && len(*s.RamdiskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RamdiskId", 1))
	}
	if s.SpotPrice != nil && len(*s.SpotPrice) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpotPrice", 1))
	}
	if s.BlockDeviceMappings != nil {
		for i, v := range s.BlockDeviceMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BlockDeviceMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MetadataOptions != nil {
		if err := s.MetadataOptions.Validate(); err != nil {
			invalidParams.AddNested("MetadataOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatePublicIpAddress sets the AssociatePublicIpAddress field's value.
func (s *CreateLaunchConfigurationInput) SetAssociatePublicIpAddress(v bool) *CreateLaunchConfigurationInput {
	s.AssociatePublicIpAddress = &v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *CreateLaunchConfigurationInput) SetBlockDeviceMappings(v []*BlockDeviceMapping) *CreateLaunchConfigurationInput {
	s.BlockDeviceMappings = v
	return s
}

// SetClassicLinkVPCId sets the ClassicLinkVPCId field's value.
func (s *CreateLaunchConfigurationInput) SetClassicLinkVPCId(v string) *CreateLaunchConfigurationInput {
	s.ClassicLinkVPCId = &v
	return s
}

// SetClassicLinkVPCSecurityGroups sets the ClassicLinkVPCSecurityGroups field's value.
func (s *CreateLaunchConfigurationInput) SetClassicLinkVPCSecurityGroups(v []*string) *CreateLaunchConfigurationInput {
	s.ClassicLinkVPCSecurityGroups = v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *CreateLaunchConfigurationInput) SetEbsOptimized(v bool) *CreateLaunchConfigurationInput {
	s.EbsOptimized = &v
	return s
}

// SetIamInstanceProfile sets the IamInstanceProfile field's value.
func (s *CreateLaunchConfigurationInput) SetIamInstanceProfile(v string) *CreateLaunchConfigurationInput {
	s.IamInstanceProfile = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *CreateLaunchConfigurationInput) SetImageId(v string) *CreateLaunchConfigurationInput {
	s.ImageId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateLaunchConfigurationInput) SetInstanceId(v string) *CreateLaunchConfigurationInput {
	s.InstanceId = &v
	return s
}

// SetInstanceMonitoring sets the InstanceMonitoring field's value.
func (s *CreateLaunchConfigurationInput) SetInstanceMonitoring(v *InstanceMonitoring) *CreateLaunchConfigurationInput {
	s.InstanceMonitoring = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateLaunchConfigurationInput) SetInstanceType(v string) *CreateLaunchConfigurationInput {
	s.InstanceType = &v
	return s
}

// SetKernelId sets the KernelId field's value.
func (s *CreateLaunchConfigurationInput) SetKernelId(v string) *CreateLaunchConfigurationInput {
	s.KernelId = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CreateLaunchConfigurationInput) SetKeyName(v string) *CreateLaunchConfigurationInput {
	s.KeyName = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *CreateLaunchConfigurationInput) SetLaunchConfigurationName(v string) *CreateLaunchConfigurationInput {
	s.LaunchConfigurationName = &v
	return s
}

// SetMetadataOptions sets the MetadataOptions field's value.
func (s *CreateLaunchConfigurationInput) SetMetadataOptions(v *InstanceMetadataOptions) *CreateLaunchConfigurationInput {
	s.MetadataOptions = v
	return s
}

// SetPlacementTenancy sets the PlacementTenancy field's value.
func (s *CreateLaunchConfigurationInput) SetPlacementTenancy(v string) *CreateLaunchConfigurationInput {
	s.PlacementTenancy = &v
	return s
}

// SetRamdiskId sets the RamdiskId field's value.
func (s *CreateLaunchConfigurationInput) SetRamdiskId(v string) *CreateLaunchConfigurationInput {
	s.RamdiskId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *CreateLaunchConfigurationInput) SetSecurityGroups(v []*string) *CreateLaunchConfigurationInput {
	s.SecurityGroups = v
	return s
}

// SetSpotPrice sets the SpotPrice field's value.
func (s *CreateLaunchConfigurationInput) SetSpotPrice(v string) *CreateLaunchConfigurationInput {
	s.SpotPrice = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *CreateLaunchConfigurationInput) SetUserData(v string) *CreateLaunchConfigurationInput {
	s.UserData = &v
	return s
}

type CreateLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLaunchConfigurationOutput) GoString() string {
	return s.String()
}

type CreateOrUpdateTagsInput struct {
	_ struct{} `type:"structure"`

	// One or more tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOrUpdateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOrUpdateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOrUpdateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOrUpdateTagsInput"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *CreateOrUpdateTagsInput) SetTags(v []*Tag) *CreateOrUpdateTagsInput {
	s.Tags = v
	return s
}

type CreateOrUpdateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOrUpdateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOrUpdateTagsOutput) GoString() string {
	return s.String()
}

// Represents a CloudWatch metric of your choosing for a target tracking scaling
// policy to use with Amazon EC2 Auto Scaling.
//
// To create your customized metric specification:
//
//    * Add values for each required parameter from CloudWatch. You can use
//    an existing metric, or a new metric that you create. To use your own metric,
//    you must first publish the metric to CloudWatch. For more information,
//    see Publish custom metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
//    in the Amazon CloudWatch User Guide.
//
//    * Choose a metric that changes proportionally with capacity. The value
//    of the metric should increase or decrease in inverse proportion to the
//    number of capacity units. That is, the value of the metric should decrease
//    when capacity increases.
//
// For more information about the CloudWatch terminology below, see Amazon CloudWatch
// concepts (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html).
//
// Each individual service provides information about the metrics, namespace,
// and dimensions they use. For more information, see Amazon Web Services services
// that publish CloudWatch metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
// in the Amazon CloudWatch User Guide.
type CustomizedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	//
	// Conditional: If you published your metric with dimensions, you must specify
	// the same dimensions in your scaling policy.
	Dimensions []*MetricDimension `type:"list"`

	// The name of the metric. To get the exact metric name, namespace, and dimensions,
	// inspect the Metric (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html)
	// object that is returned by a call to ListMetrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The statistic of the metric.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"MetricStatistic"`

	// The unit of the metric. For a complete list of the units that CloudWatch
	// supports, see the MetricDatum (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html)
	// data type in the Amazon CloudWatch API Reference.
	Unit *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomizedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomizedMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomizedMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomizedMetricSpecification"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *CustomizedMetricSpecification) SetDimensions(v []*MetricDimension) *CustomizedMetricSpecification {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CustomizedMetricSpecification) SetMetricName(v string) *CustomizedMetricSpecification {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CustomizedMetricSpecification) SetNamespace(v string) *CustomizedMetricSpecification {
	s.Namespace = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CustomizedMetricSpecification) SetStatistic(v string) *CustomizedMetricSpecification {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CustomizedMetricSpecification) SetUnit(v string) *CustomizedMetricSpecification {
	s.Unit = &v
	return s
}

type DeleteAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Specifies that the group is to be deleted along with all instances associated
	// with the group, without waiting for all instances to be terminated. This
	// parameter also deletes any outstanding lifecycle actions associated with
	// the group.
	ForceDelete *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAutoScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAutoScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAutoScalingGroupInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DeleteAutoScalingGroupInput) SetAutoScalingGroupName(v string) *DeleteAutoScalingGroupInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteAutoScalingGroupInput) SetForceDelete(v bool) *DeleteAutoScalingGroupInput {
	s.ForceDelete = &v
	return s
}

type DeleteAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAutoScalingGroupOutput) GoString() string {
	return s.String()
}

type DeleteLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the launch configuration.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLaunchConfigurationInput"}
	if s.LaunchConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfigurationName"))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *DeleteLaunchConfigurationInput) SetLaunchConfigurationName(v string) *DeleteLaunchConfigurationInput {
	s.LaunchConfigurationName = &v
	return s
}

type DeleteLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLaunchConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteLifecycleHookInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecycleHookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecycleHookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLifecycleHookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLifecycleHookInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DeleteLifecycleHookInput) SetAutoScalingGroupName(v string) *DeleteLifecycleHookInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetLifecycleHookName sets the LifecycleHookName field's value.
func (s *DeleteLifecycleHookInput) SetLifecycleHookName(v string) *DeleteLifecycleHookInput {
	s.LifecycleHookName = &v
	return s
}

type DeleteLifecycleHookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecycleHookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLifecycleHookOutput) GoString() string {
	return s.String()
}

type DeleteNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic.
	//
	// TopicARN is a required field
	TopicARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotificationConfigurationInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.TopicARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicARN"))
	}
	if s.TopicARN != nil && len(*s.TopicARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DeleteNotificationConfigurationInput) SetAutoScalingGroupName(v string) *DeleteNotificationConfigurationInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetTopicARN sets the TopicARN field's value.
func (s *DeleteNotificationConfigurationInput) SetTopicARN(v string) *DeleteNotificationConfigurationInput {
	s.TopicARN = &v
	return s
}

type DeleteNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNotificationConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The name or Amazon Resource Name (ARN) of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DeletePolicyInput) SetAutoScalingGroupName(v string) *DeletePolicyInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeletePolicyInput) SetPolicyName(v string) *DeletePolicyInput {
	s.PolicyName = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

type DeleteScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The name of the action to delete.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledActionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DeleteScheduledActionInput) SetAutoScalingGroupName(v string) *DeleteScheduledActionInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *DeleteScheduledActionInput) SetScheduledActionName(v string) *DeleteScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

type DeleteScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// One or more tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *DeleteTagsInput) SetTags(v []*Tag) *DeleteTagsInput {
	s.Tags = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DeleteWarmPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Specifies that the warm pool is to be deleted along with all of its associated
	// instances, without waiting for all instances to be terminated. This parameter
	// also deletes any outstanding lifecycle actions associated with the warm pool
	// instances.
	ForceDelete *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWarmPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWarmPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWarmPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWarmPoolInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DeleteWarmPoolInput) SetAutoScalingGroupName(v string) *DeleteWarmPoolInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetForceDelete sets the ForceDelete field's value.
func (s *DeleteWarmPoolInput) SetForceDelete(v bool) *DeleteWarmPoolInput {
	s.ForceDelete = &v
	return s
}

type DeleteWarmPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWarmPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWarmPoolOutput) GoString() string {
	return s.String()
}

type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of groups allowed for your account. The default is 200
	// groups per Region.
	MaxNumberOfAutoScalingGroups *int64 `type:"integer"`

	// The maximum number of launch configurations allowed for your account. The
	// default is 200 launch configurations per Region.
	MaxNumberOfLaunchConfigurations *int64 `type:"integer"`

	// The current number of groups for your account.
	NumberOfAutoScalingGroups *int64 `type:"integer"`

	// The current number of launch configurations for your account.
	NumberOfLaunchConfigurations *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

// SetMaxNumberOfAutoScalingGroups sets the MaxNumberOfAutoScalingGroups field's value.
func (s *DescribeAccountLimitsOutput) SetMaxNumberOfAutoScalingGroups(v int64) *DescribeAccountLimitsOutput {
	s.MaxNumberOfAutoScalingGroups = &v
	return s
}

// SetMaxNumberOfLaunchConfigurations sets the MaxNumberOfLaunchConfigurations field's value.
func (s *DescribeAccountLimitsOutput) SetMaxNumberOfLaunchConfigurations(v int64) *DescribeAccountLimitsOutput {
	s.MaxNumberOfLaunchConfigurations = &v
	return s
}

// SetNumberOfAutoScalingGroups sets the NumberOfAutoScalingGroups field's value.
func (s *DescribeAccountLimitsOutput) SetNumberOfAutoScalingGroups(v int64) *DescribeAccountLimitsOutput {
	s.NumberOfAutoScalingGroups = &v
	return s
}

// SetNumberOfLaunchConfigurations sets the NumberOfLaunchConfigurations field's value.
func (s *DescribeAccountLimitsOutput) SetNumberOfLaunchConfigurations(v int64) *DescribeAccountLimitsOutput {
	s.NumberOfLaunchConfigurations = &v
	return s
}

type DescribeAdjustmentTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAdjustmentTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAdjustmentTypesInput) GoString() string {
	return s.String()
}

type DescribeAdjustmentTypesOutput struct {
	_ struct{} `type:"structure"`

	// The policy adjustment types.
	AdjustmentTypes []*AdjustmentType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAdjustmentTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAdjustmentTypesOutput) GoString() string {
	return s.String()
}

// SetAdjustmentTypes sets the AdjustmentTypes field's value.
func (s *DescribeAdjustmentTypesOutput) SetAdjustmentTypes(v []*AdjustmentType) *DescribeAdjustmentTypesOutput {
	s.AdjustmentTypes = v
	return s
}

type DescribeAutoScalingGroupsInput struct {
	_ struct{} `type:"structure"`

	// The names of the Auto Scaling groups. By default, you can only specify up
	// to 50 names. You can optionally increase this limit using the MaxRecords
	// parameter.
	//
	// If you omit this parameter, all Auto Scaling groups are described.
	AutoScalingGroupNames []*string `type:"list"`

	// One or more filters to limit the results based on specific tags.
	Filters []*Filter `type:"list"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingGroupsInput) GoString() string {
	return s.String()
}

// SetAutoScalingGroupNames sets the AutoScalingGroupNames field's value.
func (s *DescribeAutoScalingGroupsInput) SetAutoScalingGroupNames(v []*string) *DescribeAutoScalingGroupsInput {
	s.AutoScalingGroupNames = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAutoScalingGroupsInput) SetFilters(v []*Filter) *DescribeAutoScalingGroupsInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeAutoScalingGroupsInput) SetMaxRecords(v int64) *DescribeAutoScalingGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAutoScalingGroupsInput) SetNextToken(v string) *DescribeAutoScalingGroupsInput {
	s.NextToken = &v
	return s
}

type DescribeAutoScalingGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The groups.
	//
	// AutoScalingGroups is a required field
	AutoScalingGroups []*Group `type:"list" required:"true"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingGroupsOutput) GoString() string {
	return s.String()
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *DescribeAutoScalingGroupsOutput) SetAutoScalingGroups(v []*Group) *DescribeAutoScalingGroupsOutput {
	s.AutoScalingGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAutoScalingGroupsOutput) SetNextToken(v string) *DescribeAutoScalingGroupsOutput {
	s.NextToken = &v
	return s
}

type DescribeAutoScalingInstancesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the instances. If you omit this parameter, all Auto Scaling instances
	// are described. If you specify an ID that does not exist, it is ignored with
	// no error.
	//
	// Array Members: Maximum number of 50 items.
	InstanceIds []*string `type:"list"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 50.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingInstancesInput) GoString() string {
	return s.String()
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DescribeAutoScalingInstancesInput) SetInstanceIds(v []*string) *DescribeAutoScalingInstancesInput {
	s.InstanceIds = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeAutoScalingInstancesInput) SetMaxRecords(v int64) *DescribeAutoScalingInstancesInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAutoScalingInstancesInput) SetNextToken(v string) *DescribeAutoScalingInstancesInput {
	s.NextToken = &v
	return s
}

type DescribeAutoScalingInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The instances.
	AutoScalingInstances []*InstanceDetails `type:"list"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingInstancesOutput) GoString() string {
	return s.String()
}

// SetAutoScalingInstances sets the AutoScalingInstances field's value.
func (s *DescribeAutoScalingInstancesOutput) SetAutoScalingInstances(v []*InstanceDetails) *DescribeAutoScalingInstancesOutput {
	s.AutoScalingInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAutoScalingInstancesOutput) SetNextToken(v string) *DescribeAutoScalingInstancesOutput {
	s.NextToken = &v
	return s
}

type DescribeAutoScalingNotificationTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingNotificationTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingNotificationTypesInput) GoString() string {
	return s.String()
}

type DescribeAutoScalingNotificationTypesOutput struct {
	_ struct{} `type:"structure"`

	// The notification types.
	AutoScalingNotificationTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingNotificationTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAutoScalingNotificationTypesOutput) GoString() string {
	return s.String()
}

// SetAutoScalingNotificationTypes sets the AutoScalingNotificationTypes field's value.
func (s *DescribeAutoScalingNotificationTypesOutput) SetAutoScalingNotificationTypes(v []*string) *DescribeAutoScalingNotificationTypesOutput {
	s.AutoScalingNotificationTypes = v
	return s
}

type DescribeInstanceRefreshesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance refresh IDs.
	InstanceRefreshIds []*string `type:"list"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceRefreshesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceRefreshesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceRefreshesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceRefreshesInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DescribeInstanceRefreshesInput) SetAutoScalingGroupName(v string) *DescribeInstanceRefreshesInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetInstanceRefreshIds sets the InstanceRefreshIds field's value.
func (s *DescribeInstanceRefreshesInput) SetInstanceRefreshIds(v []*string) *DescribeInstanceRefreshesInput {
	s.InstanceRefreshIds = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeInstanceRefreshesInput) SetMaxRecords(v int64) *DescribeInstanceRefreshesInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstanceRefreshesInput) SetNextToken(v string) *DescribeInstanceRefreshesInput {
	s.NextToken = &v
	return s
}

type DescribeInstanceRefreshesOutput struct {
	_ struct{} `type:"structure"`

	// The instance refreshes for the specified group.
	InstanceRefreshes []*InstanceRefresh `type:"list"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceRefreshesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceRefreshesOutput) GoString() string {
	return s.String()
}

// SetInstanceRefreshes sets the InstanceRefreshes field's value.
func (s *DescribeInstanceRefreshesOutput) SetInstanceRefreshes(v []*InstanceRefresh) *DescribeInstanceRefreshesOutput {
	s.InstanceRefreshes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstanceRefreshesOutput) SetNextToken(v string) *DescribeInstanceRefreshesOutput {
	s.NextToken = &v
	return s
}

type DescribeLaunchConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The launch configuration names. If you omit this parameter, all launch configurations
	// are described.
	//
	// Array Members: Maximum number of 50 items.
	LaunchConfigurationNames []*string `type:"list"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLaunchConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLaunchConfigurationsInput) GoString() string {
	return s.String()
}

// SetLaunchConfigurationNames sets the LaunchConfigurationNames field's value.
func (s *DescribeLaunchConfigurationsInput) SetLaunchConfigurationNames(v []*string) *DescribeLaunchConfigurationsInput {
	s.LaunchConfigurationNames = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeLaunchConfigurationsInput) SetMaxRecords(v int64) *DescribeLaunchConfigurationsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLaunchConfigurationsInput) SetNextToken(v string) *DescribeLaunchConfigurationsInput {
	s.NextToken = &v
	return s
}

type DescribeLaunchConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The launch configurations.
	//
	// LaunchConfigurations is a required field
	LaunchConfigurations []*LaunchConfiguration `type:"list" required:"true"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLaunchConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLaunchConfigurationsOutput) GoString() string {
	return s.String()
}

// SetLaunchConfigurations sets the LaunchConfigurations field's value.
func (s *DescribeLaunchConfigurationsOutput) SetLaunchConfigurations(v []*LaunchConfiguration) *DescribeLaunchConfigurationsOutput {
	s.LaunchConfigurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLaunchConfigurationsOutput) SetNextToken(v string) *DescribeLaunchConfigurationsOutput {
	s.NextToken = &v
	return s
}

type DescribeLifecycleHookTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleHookTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleHookTypesInput) GoString() string {
	return s.String()
}

type DescribeLifecycleHookTypesOutput struct {
	_ struct{} `type:"structure"`

	// The lifecycle hook types.
	LifecycleHookTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleHookTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleHookTypesOutput) GoString() string {
	return s.String()
}

// SetLifecycleHookTypes sets the LifecycleHookTypes field's value.
func (s *DescribeLifecycleHookTypesOutput) SetLifecycleHookTypes(v []*string) *DescribeLifecycleHookTypesOutput {
	s.LifecycleHookTypes = v
	return s
}

type DescribeLifecycleHooksInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The names of one or more lifecycle hooks. If you omit this parameter, all
	// lifecycle hooks are described.
	LifecycleHookNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleHooksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleHooksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLifecycleHooksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLifecycleHooksInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DescribeLifecycleHooksInput) SetAutoScalingGroupName(v string) *DescribeLifecycleHooksInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetLifecycleHookNames sets the LifecycleHookNames field's value.
func (s *DescribeLifecycleHooksInput) SetLifecycleHookNames(v []*string) *DescribeLifecycleHooksInput {
	s.LifecycleHookNames = v
	return s
}

type DescribeLifecycleHooksOutput struct {
	_ struct{} `type:"structure"`

	// The lifecycle hooks for the specified group.
	LifecycleHooks []*LifecycleHook `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleHooksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleHooksOutput) GoString() string {
	return s.String()
}

// SetLifecycleHooks sets the LifecycleHooks field's value.
func (s *DescribeLifecycleHooksOutput) SetLifecycleHooks(v []*LifecycleHook) *DescribeLifecycleHooksOutput {
	s.LifecycleHooks = v
	return s
}

type DescribeLoadBalancerTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The maximum number of items to return with this call. The default value is
	// 100 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoadBalancerTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoadBalancerTargetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoadBalancerTargetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoadBalancerTargetGroupsInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DescribeLoadBalancerTargetGroupsInput) SetAutoScalingGroupName(v string) *DescribeLoadBalancerTargetGroupsInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeLoadBalancerTargetGroupsInput) SetMaxRecords(v int64) *DescribeLoadBalancerTargetGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLoadBalancerTargetGroupsInput) SetNextToken(v string) *DescribeLoadBalancerTargetGroupsInput {
	s.NextToken = &v
	return s
}

type DescribeLoadBalancerTargetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target groups.
	LoadBalancerTargetGroups []*LoadBalancerTargetGroupState `type:"list"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoadBalancerTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoadBalancerTargetGroupsOutput) GoString() string {
	return s.String()
}

// SetLoadBalancerTargetGroups sets the LoadBalancerTargetGroups field's value.
func (s *DescribeLoadBalancerTargetGroupsOutput) SetLoadBalancerTargetGroups(v []*LoadBalancerTargetGroupState) *DescribeLoadBalancerTargetGroupsOutput {
	s.LoadBalancerTargetGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLoadBalancerTargetGroupsOutput) SetNextToken(v string) *DescribeLoadBalancerTargetGroupsOutput {
	s.NextToken = &v
	return s
}

type DescribeLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The maximum number of items to return with this call. The default value is
	// 100 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoadBalancersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoadBalancersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoadBalancersInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DescribeLoadBalancersInput) SetAutoScalingGroupName(v string) *DescribeLoadBalancersInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeLoadBalancersInput) SetMaxRecords(v int64) *DescribeLoadBalancersInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLoadBalancersInput) SetNextToken(v string) *DescribeLoadBalancersInput {
	s.NextToken = &v
	return s
}

type DescribeLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// The load balancers.
	LoadBalancers []*LoadBalancerState `type:"list"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLoadBalancersOutput) GoString() string {
	return s.String()
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *DescribeLoadBalancersOutput) SetLoadBalancers(v []*LoadBalancerState) *DescribeLoadBalancersOutput {
	s.LoadBalancers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLoadBalancersOutput) SetNextToken(v string) *DescribeLoadBalancersOutput {
	s.NextToken = &v
	return s
}

type DescribeMetricCollectionTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricCollectionTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricCollectionTypesInput) GoString() string {
	return s.String()
}

type DescribeMetricCollectionTypesOutput struct {
	_ struct{} `type:"structure"`

	// The granularities for the metrics.
	Granularities []*MetricGranularityType `type:"list"`

	// One or more metrics.
	Metrics []*MetricCollectionType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricCollectionTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMetricCollectionTypesOutput) GoString() string {
	return s.String()
}

// SetGranularities sets the Granularities field's value.
func (s *DescribeMetricCollectionTypesOutput) SetGranularities(v []*MetricGranularityType) *DescribeMetricCollectionTypesOutput {
	s.Granularities = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *DescribeMetricCollectionTypesOutput) SetMetrics(v []*MetricCollectionType) *DescribeMetricCollectionTypesOutput {
	s.Metrics = v
	return s
}

type DescribeNotificationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupNames []*string `type:"list"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNotificationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNotificationConfigurationsInput) GoString() string {
	return s.String()
}

// SetAutoScalingGroupNames sets the AutoScalingGroupNames field's value.
func (s *DescribeNotificationConfigurationsInput) SetAutoScalingGroupNames(v []*string) *DescribeNotificationConfigurationsInput {
	s.AutoScalingGroupNames = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeNotificationConfigurationsInput) SetMaxRecords(v int64) *DescribeNotificationConfigurationsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeNotificationConfigurationsInput) SetNextToken(v string) *DescribeNotificationConfigurationsInput {
	s.NextToken = &v
	return s
}

type DescribeNotificationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`

	// The notification configurations.
	//
	// NotificationConfigurations is a required field
	NotificationConfigurations []*NotificationConfiguration `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNotificationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNotificationConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeNotificationConfigurationsOutput) SetNextToken(v string) *DescribeNotificationConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetNotificationConfigurations sets the NotificationConfigurations field's value.
func (s *DescribeNotificationConfigurationsOutput) SetNotificationConfigurations(v []*NotificationConfiguration) *DescribeNotificationConfigurationsOutput {
	s.NotificationConfigurations = v
	return s
}

type DescribePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The maximum number of items to be returned with each call. The default value
	// is 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The names of one or more policies. If you omit this parameter, all policies
	// are described. If a group name is provided, the results are limited to that
	// group. If you specify an unknown policy name, it is ignored with no error.
	//
	// Array Members: Maximum number of 50 items.
	PolicyNames []*string `type:"list"`

	// One or more policy types. The valid values are SimpleScaling, StepScaling,
	// TargetTrackingScaling, and PredictiveScaling.
	PolicyTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePoliciesInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DescribePoliciesInput) SetAutoScalingGroupName(v string) *DescribePoliciesInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribePoliciesInput) SetMaxRecords(v int64) *DescribePoliciesInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePoliciesInput) SetNextToken(v string) *DescribePoliciesInput {
	s.NextToken = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *DescribePoliciesInput) SetPolicyNames(v []*string) *DescribePoliciesInput {
	s.PolicyNames = v
	return s
}

// SetPolicyTypes sets the PolicyTypes field's value.
func (s *DescribePoliciesInput) SetPolicyTypes(v []*string) *DescribePoliciesInput {
	s.PolicyTypes = v
	return s
}

type DescribePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`

	// The scaling policies.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePoliciesOutput) SetNextToken(v string) *DescribePoliciesOutput {
	s.NextToken = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *DescribePoliciesOutput) SetScalingPolicies(v []*ScalingPolicy) *DescribePoliciesOutput {
	s.ScalingPolicies = v
	return s
}

type DescribeScalingActivitiesInput struct {
	_ struct{} `type:"structure"`

	// The activity IDs of the desired scaling activities. If you omit this parameter,
	// all activities for the past six weeks are described. If unknown activities
	// are requested, they are ignored with no error. If you specify an Auto Scaling
	// group, the results are limited to that group.
	//
	// Array Members: Maximum number of 50 IDs.
	ActivityIds []*string `type:"list"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// Indicates whether to include scaling activity from deleted Auto Scaling groups.
	IncludeDeletedGroups *bool `type:"boolean"`

	// The maximum number of items to return with this call. The default value is
	// 100 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingActivitiesInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityIds sets the ActivityIds field's value.
func (s *DescribeScalingActivitiesInput) SetActivityIds(v []*string) *DescribeScalingActivitiesInput {
	s.ActivityIds = v
	return s
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DescribeScalingActivitiesInput) SetAutoScalingGroupName(v string) *DescribeScalingActivitiesInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetIncludeDeletedGroups sets the IncludeDeletedGroups field's value.
func (s *DescribeScalingActivitiesInput) SetIncludeDeletedGroups(v bool) *DescribeScalingActivitiesInput {
	s.IncludeDeletedGroups = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeScalingActivitiesInput) SetMaxRecords(v int64) *DescribeScalingActivitiesInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingActivitiesInput) SetNextToken(v string) *DescribeScalingActivitiesInput {
	s.NextToken = &v
	return s
}

type DescribeScalingActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The scaling activities. Activities are sorted by start time. Activities still
	// in progress are described first.
	//
	// Activities is a required field
	Activities []*Activity `type:"list" required:"true"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingActivitiesOutput) GoString() string {
	return s.String()
}

// SetActivities sets the Activities field's value.
func (s *DescribeScalingActivitiesOutput) SetActivities(v []*Activity) *DescribeScalingActivitiesOutput {
	s.Activities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingActivitiesOutput) SetNextToken(v string) *DescribeScalingActivitiesOutput {
	s.NextToken = &v
	return s
}

type DescribeScalingProcessTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingProcessTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingProcessTypesInput) GoString() string {
	return s.String()
}

type DescribeScalingProcessTypesOutput struct {
	_ struct{} `type:"structure"`

	// The names of the process types.
	Processes []*ProcessType `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingProcessTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingProcessTypesOutput) GoString() string {
	return s.String()
}

// SetProcesses sets the Processes field's value.
func (s *DescribeScalingProcessTypesOutput) SetProcesses(v []*ProcessType) *DescribeScalingProcessTypesOutput {
	s.Processes = v
	return s
}

type DescribeScheduledActionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The latest scheduled start time to return. If scheduled action names are
	// provided, this parameter is ignored.
	EndTime *time.Time `type:"timestamp"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The names of one or more scheduled actions. If you omit this parameter, all
	// scheduled actions are described. If you specify an unknown scheduled action,
	// it is ignored with no error.
	//
	// Array Members: Maximum number of 50 actions.
	ScheduledActionNames []*string `type:"list"`

	// The earliest scheduled start time to return. If scheduled action names are
	// provided, this parameter is ignored.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduledActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduledActionsInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DescribeScheduledActionsInput) SetAutoScalingGroupName(v string) *DescribeScheduledActionsInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeScheduledActionsInput) SetEndTime(v time.Time) *DescribeScheduledActionsInput {
	s.EndTime = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeScheduledActionsInput) SetMaxRecords(v int64) *DescribeScheduledActionsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduledActionsInput) SetNextToken(v string) *DescribeScheduledActionsInput {
	s.NextToken = &v
	return s
}

// SetScheduledActionNames sets the ScheduledActionNames field's value.
func (s *DescribeScheduledActionsInput) SetScheduledActionNames(v []*string) *DescribeScheduledActionsInput {
	s.ScheduledActionNames = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeScheduledActionsInput) SetStartTime(v time.Time) *DescribeScheduledActionsInput {
	s.StartTime = &v
	return s
}

type DescribeScheduledActionsOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`

	// The scheduled actions.
	ScheduledUpdateGroupActions []*ScheduledUpdateGroupAction `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduledActionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduledActionsOutput) SetNextToken(v string) *DescribeScheduledActionsOutput {
	s.NextToken = &v
	return s
}

// SetScheduledUpdateGroupActions sets the ScheduledUpdateGroupActions field's value.
func (s *DescribeScheduledActionsOutput) SetScheduledUpdateGroupActions(v []*ScheduledUpdateGroupAction) *DescribeScheduledActionsOutput {
	s.ScheduledUpdateGroupActions = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters to scope the tags to return. The maximum number of filters
	// per filter type (for example, auto-scaling-group) is 1000.
	Filters []*Filter `type:"list"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *DescribeTagsInput) SetFilters(v []*Filter) *DescribeTagsInput {
	s.Filters = v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeTagsInput) SetMaxRecords(v int64) *DescribeTagsInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTagsInput) SetNextToken(v string) *DescribeTagsInput {
	s.NextToken = &v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`

	// One or more tags.
	Tags []*TagDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTagsOutput) SetNextToken(v string) *DescribeTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeTagsOutput) SetTags(v []*TagDescription) *DescribeTagsOutput {
	s.Tags = v
	return s
}

type DescribeTerminationPolicyTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTerminationPolicyTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTerminationPolicyTypesInput) GoString() string {
	return s.String()
}

type DescribeTerminationPolicyTypesOutput struct {
	_ struct{} `type:"structure"`

	// The termination policies supported by Amazon EC2 Auto Scaling: OldestInstance,
	// OldestLaunchConfiguration, NewestInstance, ClosestToNextInstanceHour, Default,
	// OldestLaunchTemplate, and AllocationStrategy.
	TerminationPolicyTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTerminationPolicyTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTerminationPolicyTypesOutput) GoString() string {
	return s.String()
}

// SetTerminationPolicyTypes sets the TerminationPolicyTypes field's value.
func (s *DescribeTerminationPolicyTypesOutput) SetTerminationPolicyTypes(v []*string) *DescribeTerminationPolicyTypesOutput {
	s.TerminationPolicyTypes = v
	return s
}

type DescribeWarmPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The maximum number of instances to return with this call. The maximum value
	// is 50.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of instances to return. (You received this token
	// from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWarmPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWarmPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWarmPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWarmPoolInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DescribeWarmPoolInput) SetAutoScalingGroupName(v string) *DescribeWarmPoolInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeWarmPoolInput) SetMaxRecords(v int64) *DescribeWarmPoolInput {
	s.MaxRecords = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWarmPoolInput) SetNextToken(v string) *DescribeWarmPoolInput {
	s.NextToken = &v
	return s
}

type DescribeWarmPoolOutput struct {
	_ struct{} `type:"structure"`

	// The instances that are currently in the warm pool.
	Instances []*Instance `type:"list"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The warm pool configuration details.
	WarmPoolConfiguration *WarmPoolConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWarmPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWarmPoolOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeWarmPoolOutput) SetInstances(v []*Instance) *DescribeWarmPoolOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWarmPoolOutput) SetNextToken(v string) *DescribeWarmPoolOutput {
	s.NextToken = &v
	return s
}

// SetWarmPoolConfiguration sets the WarmPoolConfiguration field's value.
func (s *DescribeWarmPoolOutput) SetWarmPoolConfiguration(v *WarmPoolConfiguration) *DescribeWarmPoolOutput {
	s.WarmPoolConfiguration = v
	return s
}

// Describes the desired configuration for an instance refresh.
//
// If you specify a desired configuration, you must specify either a LaunchTemplate
// or a MixedInstancesPolicy.
type DesiredConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes the launch template and the version of the launch template that
	// Amazon EC2 Auto Scaling uses to launch Amazon EC2 instances. For more information
	// about launch templates, see Launch templates (https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// Describes a mixed instances policy. A mixed instances policy contains the
	// instance types that Amazon EC2 Auto Scaling can launch and other information
	// that Amazon EC2 Auto Scaling can use to launch instances and help optimize
	// your costs. For more information, see Auto Scaling groups with multiple instance
	// types and purchase options (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	MixedInstancesPolicy *MixedInstancesPolicy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DesiredConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DesiredConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DesiredConfiguration"}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(request.ErrInvalidParams))
		}
	}
	if s.MixedInstancesPolicy != nil {
		if err := s.MixedInstancesPolicy.Validate(); err != nil {
			invalidParams.AddNested("MixedInstancesPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *DesiredConfiguration) SetLaunchTemplate(v *LaunchTemplateSpecification) *DesiredConfiguration {
	s.LaunchTemplate = v
	return s
}

// SetMixedInstancesPolicy sets the MixedInstancesPolicy field's value.
func (s *DesiredConfiguration) SetMixedInstancesPolicy(v *MixedInstancesPolicy) *DesiredConfiguration {
	s.MixedInstancesPolicy = v
	return s
}

type DetachInstancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The IDs of the instances. You can specify up to 20 instances.
	InstanceIds []*string `type:"list"`

	// Indicates whether the Auto Scaling group decrements the desired capacity
	// value by the number of instances detached.
	//
	// ShouldDecrementDesiredCapacity is a required field
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachInstancesInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.ShouldDecrementDesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ShouldDecrementDesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DetachInstancesInput) SetAutoScalingGroupName(v string) *DetachInstancesInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DetachInstancesInput) SetInstanceIds(v []*string) *DetachInstancesInput {
	s.InstanceIds = v
	return s
}

// SetShouldDecrementDesiredCapacity sets the ShouldDecrementDesiredCapacity field's value.
func (s *DetachInstancesInput) SetShouldDecrementDesiredCapacity(v bool) *DetachInstancesInput {
	s.ShouldDecrementDesiredCapacity = &v
	return s
}

type DetachInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to detaching the instances from the Auto Scaling group.
	Activities []*Activity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachInstancesOutput) GoString() string {
	return s.String()
}

// SetActivities sets the Activities field's value.
func (s *DetachInstancesOutput) SetActivities(v []*Activity) *DetachInstancesOutput {
	s.Activities = v
	return s
}

type DetachLoadBalancerTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Names (ARN) of the target groups. You can specify up
	// to 10 target groups.
	//
	// TargetGroupARNs is a required field
	TargetGroupARNs []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachLoadBalancerTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachLoadBalancerTargetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachLoadBalancerTargetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachLoadBalancerTargetGroupsInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.TargetGroupARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DetachLoadBalancerTargetGroupsInput) SetAutoScalingGroupName(v string) *DetachLoadBalancerTargetGroupsInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetTargetGroupARNs sets the TargetGroupARNs field's value.
func (s *DetachLoadBalancerTargetGroupsInput) SetTargetGroupARNs(v []*string) *DetachLoadBalancerTargetGroupsInput {
	s.TargetGroupARNs = v
	return s
}

type DetachLoadBalancerTargetGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachLoadBalancerTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachLoadBalancerTargetGroupsOutput) GoString() string {
	return s.String()
}

type DetachLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The names of the load balancers. You can specify up to 10 load balancers.
	//
	// LoadBalancerNames is a required field
	LoadBalancerNames []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachLoadBalancersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachLoadBalancersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachLoadBalancersInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.LoadBalancerNames == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DetachLoadBalancersInput) SetAutoScalingGroupName(v string) *DetachLoadBalancersInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetLoadBalancerNames sets the LoadBalancerNames field's value.
func (s *DetachLoadBalancersInput) SetLoadBalancerNames(v []*string) *DetachLoadBalancersInput {
	s.LoadBalancerNames = v
	return s
}

type DetachLoadBalancersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachLoadBalancersOutput) GoString() string {
	return s.String()
}

type DisableMetricsCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Specifies one or more of the following metrics:
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	//
	//    * GroupInServiceCapacity
	//
	//    * GroupPendingCapacity
	//
	//    * GroupStandbyCapacity
	//
	//    * GroupTerminatingCapacity
	//
	//    * GroupTotalCapacity
	//
	//    * WarmPoolDesiredCapacity
	//
	//    * WarmPoolWarmedCapacity
	//
	//    * WarmPoolPendingCapacity
	//
	//    * WarmPoolTerminatingCapacity
	//
	//    * WarmPoolTotalCapacity
	//
	//    * GroupAndWarmPoolDesiredCapacity
	//
	//    * GroupAndWarmPoolTotalCapacity
	//
	// If you omit this parameter, all metrics are disabled.
	Metrics []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableMetricsCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableMetricsCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableMetricsCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableMetricsCollectionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *DisableMetricsCollectionInput) SetAutoScalingGroupName(v string) *DisableMetricsCollectionInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *DisableMetricsCollectionInput) SetMetrics(v []*string) *DisableMetricsCollectionInput {
	s.Metrics = v
	return s
}

type DisableMetricsCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableMetricsCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableMetricsCollectionOutput) GoString() string {
	return s.String()
}

// Describes information used to set up an Amazon EBS volume specified in a
// block device mapping.
type Ebs struct {
	_ struct{} `type:"structure"`

	// Indicates whether the volume is deleted on instance termination. For Amazon
	// EC2 Auto Scaling, the default value is true.
	DeleteOnTermination *bool `type:"boolean"`

	// Specifies whether the volume should be encrypted. Encrypted EBS volumes can
	// only be attached to instances that support Amazon EBS encryption. For more
	// information, see Supported instance types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances).
	// If your AMI uses encrypted volumes, you can also only launch it on supported
	// instance types.
	//
	// If you are creating a volume from a snapshot, you cannot create an unencrypted
	// volume from an encrypted snapshot. Also, you cannot specify a KMS key ID
	// when using a launch configuration.
	//
	// If you enable encryption by default, the EBS volumes that you create are
	// always encrypted, either using the Amazon Web Services managed KMS key or
	// a customer-managed KMS key, regardless of whether the snapshot was encrypted.
	//
	// For more information, see Using Amazon Web Services KMS keys to encrypt Amazon
	// EBS volumes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption)
	// in the Amazon EC2 Auto Scaling User Guide.
	Encrypted *bool `type:"boolean"`

	// The number of input/output (I/O) operations per second (IOPS) to provision
	// for the volume. For gp3 and io1 volumes, this represents the number of IOPS
	// that are provisioned for the volume. For gp2 volumes, this represents the
	// baseline performance of the volume and the rate at which the volume accumulates
	// I/O credits for bursting.
	//
	// The following are the supported values for each volume type:
	//
	//    * gp3: 3,000-16,000 IOPS
	//
	//    * io1: 100-64,000 IOPS
	//
	// For io1 volumes, we guarantee 64,000 IOPS only for Instances built on the
	// Nitro System (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances).
	// Other instance families guarantee performance up to 32,000 IOPS.
	//
	// Iops is supported when the volume type is gp3 or io1 and required only when
	// the volume type is io1. (Not used with standard, gp2, st1, or sc1 volumes.)
	Iops *int64 `min:"100" type:"integer"`

	// The snapshot ID of the volume to use.
	//
	// You must specify either a VolumeSize or a SnapshotId.
	SnapshotId *string `min:"1" type:"string"`

	// The throughput (MiBps) to provision for a gp3 volume.
	Throughput *int64 `min:"125" type:"integer"`

	// The volume size, in GiBs. The following are the supported volumes sizes for
	// each volume type:
	//
	//    * gp2 and gp3: 1-16,384
	//
	//    * io1: 4-16,384
	//
	//    * st1 and sc1: 125-16,384
	//
	//    * standard: 1-1,024
	//
	// You must specify either a SnapshotId or a VolumeSize. If you specify both
	// SnapshotId and VolumeSize, the volume size must be equal or greater than
	// the size of the snapshot.
	VolumeSize *int64 `min:"1" type:"integer"`

	// The volume type. For more information, see Amazon EBS volume types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// Valid Values: standard | io1 | gp2 | st1 | sc1 | gp3
	VolumeType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ebs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ebs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ebs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ebs"}
	if s.Iops != nil && *s.Iops < 100 {
		invalidParams.Add(request.NewErrParamMinValue("Iops", 100))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 1))
	}
	if s.Throughput != nil && *s.Throughput < 125 {
		invalidParams.Add(request.NewErrParamMinValue("Throughput", 125))
	}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSize", 1))
	}
	if s.VolumeType != nil && len(*s.VolumeType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *Ebs) SetDeleteOnTermination(v bool) *Ebs {
	s.DeleteOnTermination = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *Ebs) SetEncrypted(v bool) *Ebs {
	s.Encrypted = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *Ebs) SetIops(v int64) *Ebs {
	s.Iops = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *Ebs) SetSnapshotId(v string) *Ebs {
	s.SnapshotId = &v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *Ebs) SetThroughput(v int64) *Ebs {
	s.Throughput = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *Ebs) SetVolumeSize(v int64) *Ebs {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *Ebs) SetVolumeType(v string) *Ebs {
	s.VolumeType = &v
	return s
}

type EnableMetricsCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The granularity to associate with the metrics to collect. The only valid
	// value is 1Minute.
	//
	// Granularity is a required field
	Granularity *string `min:"1" type:"string" required:"true"`

	// Specifies which group-level metrics to start collecting. You can specify
	// one or more of the following metrics:
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	//
	// The instance weighting feature supports the following additional metrics:
	//
	//    * GroupInServiceCapacity
	//
	//    * GroupPendingCapacity
	//
	//    * GroupStandbyCapacity
	//
	//    * GroupTerminatingCapacity
	//
	//    * GroupTotalCapacity
	//
	// The warm pools feature supports the following additional metrics:
	//
	//    * WarmPoolDesiredCapacity
	//
	//    * WarmPoolWarmedCapacity
	//
	//    * WarmPoolPendingCapacity
	//
	//    * WarmPoolTerminatingCapacity
	//
	//    * WarmPoolTotalCapacity
	//
	//    * GroupAndWarmPoolDesiredCapacity
	//
	//    * GroupAndWarmPoolTotalCapacity
	//
	// If you omit this parameter, all metrics are enabled.
	Metrics []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableMetricsCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableMetricsCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableMetricsCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableMetricsCollectionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}
	if s.Granularity != nil && len(*s.Granularity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Granularity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *EnableMetricsCollectionInput) SetAutoScalingGroupName(v string) *EnableMetricsCollectionInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetGranularity sets the Granularity field's value.
func (s *EnableMetricsCollectionInput) SetGranularity(v string) *EnableMetricsCollectionInput {
	s.Granularity = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EnableMetricsCollectionInput) SetMetrics(v []*string) *EnableMetricsCollectionInput {
	s.Metrics = v
	return s
}

type EnableMetricsCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableMetricsCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableMetricsCollectionOutput) GoString() string {
	return s.String()
}

// Describes an enabled metric.
type EnabledMetric struct {
	_ struct{} `type:"structure"`

	// The granularity of the metric. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`

	// One of the following metrics:
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	//
	//    * GroupInServiceCapacity
	//
	//    * GroupPendingCapacity
	//
	//    * GroupStandbyCapacity
	//
	//    * GroupTerminatingCapacity
	//
	//    * GroupTotalCapacity
	//
	//    * WarmPoolDesiredCapacity
	//
	//    * WarmPoolWarmedCapacity
	//
	//    * WarmPoolPendingCapacity
	//
	//    * WarmPoolTerminatingCapacity
	//
	//    * WarmPoolTotalCapacity
	//
	//    * GroupAndWarmPoolDesiredCapacity
	//
	//    * GroupAndWarmPoolTotalCapacity
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnabledMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnabledMetric) GoString() string {
	return s.String()
}

// SetGranularity sets the Granularity field's value.
func (s *EnabledMetric) SetGranularity(v string) *EnabledMetric {
	s.Granularity = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *EnabledMetric) SetMetric(v string) *EnabledMetric {
	s.Metric = &v
	return s
}

type EnterStandbyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The IDs of the instances. You can specify up to 20 instances.
	InstanceIds []*string `type:"list"`

	// Indicates whether to decrement the desired capacity of the Auto Scaling group
	// by the number of instances moved to Standby mode.
	//
	// ShouldDecrementDesiredCapacity is a required field
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnterStandbyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnterStandbyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnterStandbyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnterStandbyInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.ShouldDecrementDesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ShouldDecrementDesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *EnterStandbyInput) SetAutoScalingGroupName(v string) *EnterStandbyInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *EnterStandbyInput) SetInstanceIds(v []*string) *EnterStandbyInput {
	s.InstanceIds = v
	return s
}

// SetShouldDecrementDesiredCapacity sets the ShouldDecrementDesiredCapacity field's value.
func (s *EnterStandbyInput) SetShouldDecrementDesiredCapacity(v bool) *EnterStandbyInput {
	s.ShouldDecrementDesiredCapacity = &v
	return s
}

type EnterStandbyOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to moving instances into Standby mode.
	Activities []*Activity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnterStandbyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnterStandbyOutput) GoString() string {
	return s.String()
}

// SetActivities sets the Activities field's value.
func (s *EnterStandbyOutput) SetActivities(v []*Activity) *EnterStandbyOutput {
	s.Activities = v
	return s
}

type ExecutePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The breach threshold for the alarm.
	//
	// Required if the policy type is StepScaling and not supported otherwise.
	BreachThreshold *float64 `type:"double"`

	// Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to
	// complete before executing the policy.
	//
	// Valid only if the policy type is SimpleScaling. For more information, see
	// Scaling cooldowns for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	HonorCooldown *bool `type:"boolean"`

	// The metric value to compare to BreachThreshold. This enables you to execute
	// a policy of type StepScaling and determine which step adjustment to use.
	// For example, if the breach threshold is 50 and you want to use a step adjustment
	// with a lower bound of 0 and an upper bound of 10, you can set the metric
	// value to 59.
	//
	// If you specify a metric value that doesn't correspond to a step adjustment
	// for the policy, the call returns an error.
	//
	// Required if the policy type is StepScaling and not supported otherwise.
	MetricValue *float64 `type:"double"`

	// The name or ARN of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutePolicyInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *ExecutePolicyInput) SetAutoScalingGroupName(v string) *ExecutePolicyInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetBreachThreshold sets the BreachThreshold field's value.
func (s *ExecutePolicyInput) SetBreachThreshold(v float64) *ExecutePolicyInput {
	s.BreachThreshold = &v
	return s
}

// SetHonorCooldown sets the HonorCooldown field's value.
func (s *ExecutePolicyInput) SetHonorCooldown(v bool) *ExecutePolicyInput {
	s.HonorCooldown = &v
	return s
}

// SetMetricValue sets the MetricValue field's value.
func (s *ExecutePolicyInput) SetMetricValue(v float64) *ExecutePolicyInput {
	s.MetricValue = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ExecutePolicyInput) SetPolicyName(v string) *ExecutePolicyInput {
	s.PolicyName = &v
	return s
}

type ExecutePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutePolicyOutput) GoString() string {
	return s.String()
}

type ExitStandbyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The IDs of the instances. You can specify up to 20 instances.
	InstanceIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExitStandbyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExitStandbyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExitStandbyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExitStandbyInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *ExitStandbyInput) SetAutoScalingGroupName(v string) *ExitStandbyInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *ExitStandbyInput) SetInstanceIds(v []*string) *ExitStandbyInput {
	s.InstanceIds = v
	return s
}

type ExitStandbyOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to moving instances out of Standby mode.
	Activities []*Activity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExitStandbyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExitStandbyOutput) GoString() string {
	return s.String()
}

// SetActivities sets the Activities field's value.
func (s *ExitStandbyOutput) SetActivities(v []*Activity) *ExitStandbyOutput {
	s.Activities = v
	return s
}

// Describes a scheduled action that could not be created, updated, or deleted.
type FailedScheduledUpdateGroupActionRequest struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `min:"1" type:"string"`

	// The error message accompanying the error code.
	ErrorMessage *string `type:"string"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedScheduledUpdateGroupActionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedScheduledUpdateGroupActionRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedScheduledUpdateGroupActionRequest) SetErrorCode(v string) *FailedScheduledUpdateGroupActionRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedScheduledUpdateGroupActionRequest) SetErrorMessage(v string) *FailedScheduledUpdateGroupActionRequest {
	s.ErrorMessage = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *FailedScheduledUpdateGroupActionRequest) SetScheduledActionName(v string) *FailedScheduledUpdateGroupActionRequest {
	s.ScheduledActionName = &v
	return s
}

// Describes a filter that is used to return a more specific list of results
// from a describe operation.
//
// If you specify multiple filters, the filters are automatically logically
// joined with an AND, and the request returns only the results that match all
// of the specified filters.
//
// For more information, see Tagging Auto Scaling groups and instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
// in the Amazon EC2 Auto Scaling User Guide.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// The valid values for Name depend on which API operation you're using with
	// the filter (DescribeAutoScalingGroups or DescribeTags).
	//
	// DescribeAutoScalingGroups
	//
	// Valid values for Name include the following:
	//
	//    * tag-key - Accepts tag keys. The results only include information about
	//    the Auto Scaling groups associated with these tag keys.
	//
	//    * tag-value - Accepts tag values. The results only include information
	//    about the Auto Scaling groups associated with these tag values.
	//
	//    * tag:<key> - Accepts the key/value combination of the tag. Use the tag
	//    key in the filter name and the tag value as the filter value. The results
	//    only include information about the Auto Scaling groups associated with
	//    the specified key/value combination.
	//
	// DescribeTags
	//
	// Valid values for Name include the following:
	//
	//    * auto-scaling-group - Accepts the names of Auto Scaling groups. The results
	//    only include information about the tags associated with these Auto Scaling
	//    groups.
	//
	//    * key - Accepts tag keys. The results only include information about the
	//    tags associated with these tag keys.
	//
	//    * value - Accepts tag values. The results only include information about
	//    the tags associated with these tag values.
	//
	//    * propagate-at-launch - Accepts a Boolean value, which specifies whether
	//    tags propagate to instances at launch. The results only include information
	//    about the tags associated with the specified Boolean value.
	Name *string `type:"string"`

	// One or more filter values. Filter values are case-sensitive.
	//
	// If you specify multiple values for a filter, the values are automatically
	// logically joined with an OR, and the request returns all results that match
	// any of the specified values. For example, specify "tag:environment" for the
	// filter name and "production,development" for the filter values to find Auto
	// Scaling groups with the tag "environment=production" or "environment=development".
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetPredictiveScalingForecastInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The exclusive end time of the time range for the forecast data to get. The
	// maximum time duration between the start and end time is 30 days.
	//
	// Although this parameter can accept a date and time that is more than two
	// days in the future, the availability of forecast data has limits. Amazon
	// EC2 Auto Scaling only issues forecasts for periods of two days in advance.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The inclusive start time of the time range for the forecast data to get.
	// At most, the date and time can be one year before the current date and time.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPredictiveScalingForecastInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPredictiveScalingForecastInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPredictiveScalingForecastInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPredictiveScalingForecastInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *GetPredictiveScalingForecastInput) SetAutoScalingGroupName(v string) *GetPredictiveScalingForecastInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetPredictiveScalingForecastInput) SetEndTime(v time.Time) *GetPredictiveScalingForecastInput {
	s.EndTime = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetPredictiveScalingForecastInput) SetPolicyName(v string) *GetPredictiveScalingForecastInput {
	s.PolicyName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetPredictiveScalingForecastInput) SetStartTime(v time.Time) *GetPredictiveScalingForecastInput {
	s.StartTime = &v
	return s
}

type GetPredictiveScalingForecastOutput struct {
	_ struct{} `type:"structure"`

	// The capacity forecast.
	//
	// CapacityForecast is a required field
	CapacityForecast *CapacityForecast `type:"structure" required:"true"`

	// The load forecast.
	//
	// LoadForecast is a required field
	LoadForecast []*LoadForecast `type:"list" required:"true"`

	// The time the forecast was made.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPredictiveScalingForecastOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPredictiveScalingForecastOutput) GoString() string {
	return s.String()
}

// SetCapacityForecast sets the CapacityForecast field's value.
func (s *GetPredictiveScalingForecastOutput) SetCapacityForecast(v *CapacityForecast) *GetPredictiveScalingForecastOutput {
	s.CapacityForecast = v
	return s
}

// SetLoadForecast sets the LoadForecast field's value.
func (s *GetPredictiveScalingForecastOutput) SetLoadForecast(v []*LoadForecast) *GetPredictiveScalingForecastOutput {
	s.LoadForecast = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetPredictiveScalingForecastOutput) SetUpdateTime(v time.Time) *GetPredictiveScalingForecastOutput {
	s.UpdateTime = &v
	return s
}

// Describes an Auto Scaling group.
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupARN *string `min:"1" type:"string"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []*string `type:"list" required:"true"`

	// Indicates whether Capacity Rebalancing is enabled.
	CapacityRebalance *bool `type:"boolean"`

	// Reserved.
	Context *string `type:"string"`

	// The date and time the group was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The duration of the default cooldown period, in seconds.
	//
	// DefaultCooldown is a required field
	DefaultCooldown *int64 `type:"integer" required:"true"`

	// The desired size of the group.
	//
	// DesiredCapacity is a required field
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// The unit of measurement for the value specified for desired capacity. Amazon
	// EC2 Auto Scaling supports DesiredCapacityType for attribute-based instance
	// type selection only. For more information, see Creating an Auto Scaling group
	// using attribute-based instance type selection (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// By default, Amazon EC2 Auto Scaling specifies units, which translates into
	// number of instances.
	//
	// Valid values: units | vcpu | memory-mib
	DesiredCapacityType *string `min:"1" type:"string"`

	// The metrics enabled for the group.
	EnabledMetrics []*EnabledMetric `type:"list"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// checking the health status of an EC2 instance that has come into service
	// and marking it unhealthy due to a failed health check.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	// If you configure an Auto Scaling group to use ELB health checks, it considers
	// the instance unhealthy if it fails either the EC2 status checks or the load
	// balancer health checks.
	//
	// HealthCheckType is a required field
	HealthCheckType *string `min:"1" type:"string" required:"true"`

	// The EC2 instances associated with the group.
	Instances []*Instance `type:"list"`

	// The name of the associated launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the group.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// One or more load balancers associated with the group.
	LoadBalancerNames []*string `type:"list"`

	// The maximum amount of time, in seconds, that an instance can be in service.
	//
	// Valid Range: Minimum value of 0.
	MaxInstanceLifetime *int64 `type:"integer"`

	// The maximum size of the group.
	//
	// MaxSize is a required field
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	//
	// MinSize is a required field
	MinSize *int64 `type:"integer" required:"true"`

	// The mixed instances policy for the group.
	MixedInstancesPolicy *MixedInstancesPolicy `type:"structure"`

	// Indicates whether newly launched instances are protected from termination
	// by Amazon EC2 Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which to launch your instances, if any.
	PlacementGroup *string `min:"1" type:"string"`

	// The predicted capacity of the group when it has a predictive scaling policy.
	PredictedCapacity *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling
	// group uses to call other Amazon Web Services on your behalf.
	ServiceLinkedRoleARN *string `min:"1" type:"string"`

	// The current state of the group when the DeleteAutoScalingGroup operation
	// is in progress.
	Status *string `min:"1" type:"string"`

	// The suspended processes associated with the group.
	SuspendedProcesses []*SuspendedProcess `type:"list"`

	// The tags for the group.
	Tags []*TagDescription `type:"list"`

	// The Amazon Resource Names (ARN) of the target groups for your load balancer.
	TargetGroupARNs []*string `type:"list"`

	// The termination policies for the group.
	TerminationPolicies []*string `type:"list"`

	// One or more subnet IDs, if applicable, separated by commas.
	VPCZoneIdentifier *string `min:"1" type:"string"`

	// The warm pool for the group.
	WarmPoolConfiguration *WarmPoolConfiguration `type:"structure"`

	// The current size of the warm pool.
	WarmPoolSize *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) GoString() string {
	return s.String()
}

// SetAutoScalingGroupARN sets the AutoScalingGroupARN field's value.
func (s *Group) SetAutoScalingGroupARN(v string) *Group {
	s.AutoScalingGroupARN = &v
	return s
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *Group) SetAutoScalingGroupName(v string) *Group {
	s.AutoScalingGroupName = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *Group) SetAvailabilityZones(v []*string) *Group {
	s.AvailabilityZones = v
	return s
}

// SetCapacityRebalance sets the CapacityRebalance field's value.
func (s *Group) SetCapacityRebalance(v bool) *Group {
	s.CapacityRebalance = &v
	return s
}

// SetContext sets the Context field's value.
func (s *Group) SetContext(v string) *Group {
	s.Context = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Group) SetCreatedTime(v time.Time) *Group {
	s.CreatedTime = &v
	return s
}

// SetDefaultCooldown sets the DefaultCooldown field's value.
func (s *Group) SetDefaultCooldown(v int64) *Group {
	s.DefaultCooldown = &v
	return s
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *Group) SetDesiredCapacity(v int64) *Group {
	s.DesiredCapacity = &v
	return s
}

// SetDesiredCapacityType sets the DesiredCapacityType field's value.
func (s *Group) SetDesiredCapacityType(v string) *Group {
	s.DesiredCapacityType = &v
	return s
}

// SetEnabledMetrics sets the EnabledMetrics field's value.
func (s *Group) SetEnabledMetrics(v []*EnabledMetric) *Group {
	s.EnabledMetrics = v
	return s
}

// SetHealthCheckGracePeriod sets the HealthCheckGracePeriod field's value.
func (s *Group) SetHealthCheckGracePeriod(v int64) *Group {
	s.HealthCheckGracePeriod = &v
	return s
}

// SetHealthCheckType sets the HealthCheckType field's value.
func (s *Group) SetHealthCheckType(v string) *Group {
	s.HealthCheckType = &v
	return s
}

// SetInstances sets the Instances field's value.
func (s *Group) SetInstances(v []*Instance) *Group {
	s.Instances = v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *Group) SetLaunchConfigurationName(v string) *Group {
	s.LaunchConfigurationName = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *Group) SetLaunchTemplate(v *LaunchTemplateSpecification) *Group {
	s.LaunchTemplate = v
	return s
}

// SetLoadBalancerNames sets the LoadBalancerNames field's value.
func (s *Group) SetLoadBalancerNames(v []*string) *Group {
	s.LoadBalancerNames = v
	return s
}

// SetMaxInstanceLifetime sets the MaxInstanceLifetime field's value.
func (s *Group) SetMaxInstanceLifetime(v int64) *Group {
	s.MaxInstanceLifetime = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *Group) SetMaxSize(v int64) *Group {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *Group) SetMinSize(v int64) *Group {
	s.MinSize = &v
	return s
}

// SetMixedInstancesPolicy sets the MixedInstancesPolicy field's value.
func (s *Group) SetMixedInstancesPolicy(v *MixedInstancesPolicy) *Group {
	s.MixedInstancesPolicy = v
	return s
}

// SetNewInstancesProtectedFromScaleIn sets the NewInstancesProtectedFromScaleIn field's value.
func (s *Group) SetNewInstancesProtectedFromScaleIn(v bool) *Group {
	s.NewInstancesProtectedFromScaleIn = &v
	return s
}

// SetPlacementGroup sets the PlacementGroup field's value.
func (s *Group) SetPlacementGroup(v string) *Group {
	s.PlacementGroup = &v
	return s
}

// SetPredictedCapacity sets the PredictedCapacity field's value.
func (s *Group) SetPredictedCapacity(v int64) *Group {
	s.PredictedCapacity = &v
	return s
}

// SetServiceLinkedRoleARN sets the ServiceLinkedRoleARN field's value.
func (s *Group) SetServiceLinkedRoleARN(v string) *Group {
	s.ServiceLinkedRoleARN = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Group) SetStatus(v string) *Group {
	s.Status = &v
	return s
}

// SetSuspendedProcesses sets the SuspendedProcesses field's value.
func (s *Group) SetSuspendedProcesses(v []*SuspendedProcess) *Group {
	s.SuspendedProcesses = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Group) SetTags(v []*TagDescription) *Group {
	s.Tags = v
	return s
}

// SetTargetGroupARNs sets the TargetGroupARNs field's value.
func (s *Group) SetTargetGroupARNs(v []*string) *Group {
	s.TargetGroupARNs = v
	return s
}

// SetTerminationPolicies sets the TerminationPolicies field's value.
func (s *Group) SetTerminationPolicies(v []*string) *Group {
	s.TerminationPolicies = v
	return s
}

// SetVPCZoneIdentifier sets the VPCZoneIdentifier field's value.
func (s *Group) SetVPCZoneIdentifier(v string) *Group {
	s.VPCZoneIdentifier = &v
	return s
}

// SetWarmPoolConfiguration sets the WarmPoolConfiguration field's value.
func (s *Group) SetWarmPoolConfiguration(v *WarmPoolConfiguration) *Group {
	s.WarmPoolConfiguration = v
	return s
}

// SetWarmPoolSize sets the WarmPoolSize field's value.
func (s *Group) SetWarmPoolSize(v int64) *Group {
	s.WarmPoolSize = &v
	return s
}

// Describes an EC2 instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the instance is running.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The last reported health status of the instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that
	// the instance is unhealthy and that Amazon EC2 Auto Scaling should terminate
	// and replace it.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The instance type of the EC2 instance.
	InstanceType *string `min:"1" type:"string"`

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// A description of the current lifecycle state. The Quarantined state is not
	// used. For information about lifecycle states, see Instance lifecycle (https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// LifecycleState is a required field
	LifecycleState *string `type:"string" required:"true" enum:"LifecycleState"`

	// Indicates whether the instance is protected from termination by Amazon EC2
	// Auto Scaling when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`

	// The number of capacity units contributed by the instance based on its instance
	// type.
	//
	// Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Instance) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Instance) SetAvailabilityZone(v string) *Instance {
	s.AvailabilityZone = &v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *Instance) SetHealthStatus(v string) *Instance {
	s.HealthStatus = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Instance) SetInstanceId(v string) *Instance {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Instance) SetInstanceType(v string) *Instance {
	s.InstanceType = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *Instance) SetLaunchConfigurationName(v string) *Instance {
	s.LaunchConfigurationName = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *Instance) SetLaunchTemplate(v *LaunchTemplateSpecification) *Instance {
	s.LaunchTemplate = v
	return s
}

// SetLifecycleState sets the LifecycleState field's value.
func (s *Instance) SetLifecycleState(v string) *Instance {
	s.LifecycleState = &v
	return s
}

// SetProtectedFromScaleIn sets the ProtectedFromScaleIn field's value.
func (s *Instance) SetProtectedFromScaleIn(v bool) *Instance {
	s.ProtectedFromScaleIn = &v
	return s
}

// SetWeightedCapacity sets the WeightedCapacity field's value.
func (s *Instance) SetWeightedCapacity(v string) *Instance {
	s.WeightedCapacity = &v
	return s
}

// Describes an EC2 instance associated with an Auto Scaling group.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the instance.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Availability Zone for the instance.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The last reported health status of this instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that
	// the instance is unhealthy and Amazon EC2 Auto Scaling should terminate and
	// replace it.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The instance type of the EC2 instance.
	InstanceType *string `min:"1" type:"string"`

	// The launch configuration used to launch the instance. This value is not available
	// if you attached the instance to the Auto Scaling group.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// The lifecycle state for the instance. The Quarantined state is not used.
	// For information about lifecycle states, see Instance lifecycle (https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Valid Values: Pending | Pending:Wait | Pending:Proceed | Quarantined | InService
	// | Terminating | Terminating:Wait | Terminating:Proceed | Terminated | Detaching
	// | Detached | EnteringStandby | Standby | Warmed:Pending | Warmed:Pending:Wait
	// | Warmed:Pending:Proceed | Warmed:Terminating | Warmed:Terminating:Wait |
	// Warmed:Terminating:Proceed | Warmed:Terminated | Warmed:Stopped | Warmed:Running
	//
	// LifecycleState is a required field
	LifecycleState *string `min:"1" type:"string" required:"true"`

	// Indicates whether the instance is protected from termination by Amazon EC2
	// Auto Scaling when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`

	// The number of capacity units contributed by the instance based on its instance
	// type.
	//
	// Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceDetails) GoString() string {
	return s.String()
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *InstanceDetails) SetAutoScalingGroupName(v string) *InstanceDetails {
	s.AutoScalingGroupName = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *InstanceDetails) SetAvailabilityZone(v string) *InstanceDetails {
	s.AvailabilityZone = &v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *InstanceDetails) SetHealthStatus(v string) *InstanceDetails {
	s.HealthStatus = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceDetails) SetInstanceId(v string) *InstanceDetails {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceDetails) SetInstanceType(v string) *InstanceDetails {
	s.InstanceType = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *InstanceDetails) SetLaunchConfigurationName(v string) *InstanceDetails {
	s.LaunchConfigurationName = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *InstanceDetails) SetLaunchTemplate(v *LaunchTemplateSpecification) *InstanceDetails {
	s.LaunchTemplate = v
	return s
}

// SetLifecycleState sets the LifecycleState field's value.
func (s *InstanceDetails) SetLifecycleState(v string) *InstanceDetails {
	s.LifecycleState = &v
	return s
}

// SetProtectedFromScaleIn sets the ProtectedFromScaleIn field's value.
func (s *InstanceDetails) SetProtectedFromScaleIn(v bool) *InstanceDetails {
	s.ProtectedFromScaleIn = &v
	return s
}

// SetWeightedCapacity sets the WeightedCapacity field's value.
func (s *InstanceDetails) SetWeightedCapacity(v string) *InstanceDetails {
	s.WeightedCapacity = &v
	return s
}

// The metadata options for the instances. For more information, see Configuring
// the Instance Metadata Options (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds)
// in the Amazon EC2 Auto Scaling User Guide.
type InstanceMetadataOptions struct {
	_ struct{} `type:"structure"`

	// This parameter enables or disables the HTTP metadata endpoint on your instances.
	// If the parameter is not specified, the default state is enabled.
	//
	// If you specify a value of disabled, you will not be able to access your instance
	// metadata.
	HttpEndpoint *string `type:"string" enum:"InstanceMetadataEndpointState"`

	// The desired HTTP PUT response hop limit for instance metadata requests. The
	// larger the number, the further instance metadata requests can travel.
	//
	// Default: 1
	HttpPutResponseHopLimit *int64 `min:"1" type:"integer"`

	// The state of token usage for your instance metadata requests. If the parameter
	// is not specified in the request, the default state is optional.
	//
	// If the state is optional, you can choose to retrieve instance metadata with
	// or without a signed token header on your request. If you retrieve the IAM
	// role credentials without a token, the version 1.0 role credentials are returned.
	// If you retrieve the IAM role credentials using a valid signed token, the
	// version 2.0 role credentials are returned.
	//
	// If the state is required, you must send a signed token header with any instance
	// metadata retrieval requests. In this state, retrieving the IAM role credentials
	// always returns the version 2.0 credentials; the version 1.0 credentials are
	// not available.
	HttpTokens *string `type:"string" enum:"InstanceMetadataHttpTokensState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceMetadataOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceMetadataOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceMetadataOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceMetadataOptions"}
	if s.HttpPutResponseHopLimit != nil && *s.HttpPutResponseHopLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HttpPutResponseHopLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpEndpoint sets the HttpEndpoint field's value.
func (s *InstanceMetadataOptions) SetHttpEndpoint(v string) *InstanceMetadataOptions {
	s.HttpEndpoint = &v
	return s
}

// SetHttpPutResponseHopLimit sets the HttpPutResponseHopLimit field's value.
func (s *InstanceMetadataOptions) SetHttpPutResponseHopLimit(v int64) *InstanceMetadataOptions {
	s.HttpPutResponseHopLimit = &v
	return s
}

// SetHttpTokens sets the HttpTokens field's value.
func (s *InstanceMetadataOptions) SetHttpTokens(v string) *InstanceMetadataOptions {
	s.HttpTokens = &v
	return s
}

// Describes whether detailed monitoring is enabled for the Auto Scaling instances.
type InstanceMonitoring struct {
	_ struct{} `type:"structure"`

	// If true, detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceMonitoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceMonitoring) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *InstanceMonitoring) SetEnabled(v bool) *InstanceMonitoring {
	s.Enabled = &v
	return s
}

// Describes an instance refresh for an Auto Scaling group.
type InstanceRefresh struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// Describes the specific update you want to deploy.
	DesiredConfiguration *DesiredConfiguration `type:"structure"`

	// The date and time at which the instance refresh ended.
	EndTime *time.Time `type:"timestamp"`

	// The instance refresh ID.
	InstanceRefreshId *string `min:"1" type:"string"`

	// The number of instances remaining to update before the instance refresh is
	// complete.
	InstancesToUpdate *int64 `type:"integer"`

	// The percentage of the instance refresh that is complete. For each instance
	// replacement, Amazon EC2 Auto Scaling tracks the instance's health status
	// and warm-up time. When the instance's health status changes to healthy and
	// the specified warm-up time passes, the instance is considered updated and
	// is added to the percentage complete.
	PercentageComplete *int64 `type:"integer"`

	// Describes the preferences for an instance refresh.
	Preferences *RefreshPreferences `type:"structure"`

	// Additional progress details for an Auto Scaling group that has a warm pool.
	ProgressDetails *InstanceRefreshProgressDetails `type:"structure"`

	// The date and time at which the instance refresh began.
	StartTime *time.Time `type:"timestamp"`

	// The current status for the instance refresh operation:
	//
	//    * Pending - The request was created, but the operation has not started.
	//
	//    * InProgress - The operation is in progress.
	//
	//    * Successful - The operation completed successfully.
	//
	//    * Failed - The operation failed to complete. You can troubleshoot using
	//    the status reason and the scaling activities.
	//
	//    * Cancelling - An ongoing operation is being cancelled. Cancellation does
	//    not roll back any replacements that have already been completed, but it
	//    prevents new replacements from being started.
	//
	//    * Cancelled - The operation is cancelled.
	Status *string `type:"string" enum:"InstanceRefreshStatus"`

	// Provides more details about the current status of the instance refresh.
	StatusReason *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRefresh) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRefresh) GoString() string {
	return s.String()
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *InstanceRefresh) SetAutoScalingGroupName(v string) *InstanceRefresh {
	s.AutoScalingGroupName = &v
	return s
}

// SetDesiredConfiguration sets the DesiredConfiguration field's value.
func (s *InstanceRefresh) SetDesiredConfiguration(v *DesiredConfiguration) *InstanceRefresh {
	s.DesiredConfiguration = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *InstanceRefresh) SetEndTime(v time.Time) *InstanceRefresh {
	s.EndTime = &v
	return s
}

// SetInstanceRefreshId sets the InstanceRefreshId field's value.
func (s *InstanceRefresh) SetInstanceRefreshId(v string) *InstanceRefresh {
	s.InstanceRefreshId = &v
	return s
}

// SetInstancesToUpdate sets the InstancesToUpdate field's value.
func (s *InstanceRefresh) SetInstancesToUpdate(v int64) *InstanceRefresh {
	s.InstancesToUpdate = &v
	return s
}

// SetPercentageComplete sets the PercentageComplete field's value.
func (s *InstanceRefresh) SetPercentageComplete(v int64) *InstanceRefresh {
	s.PercentageComplete = &v
	return s
}

// SetPreferences sets the Preferences field's value.
func (s *InstanceRefresh) SetPreferences(v *RefreshPreferences) *InstanceRefresh {
	s.Preferences = v
	return s
}

// SetProgressDetails sets the ProgressDetails field's value.
func (s *InstanceRefresh) SetProgressDetails(v *InstanceRefreshProgressDetails) *InstanceRefresh {
	s.ProgressDetails = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *InstanceRefresh) SetStartTime(v time.Time) *InstanceRefresh {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceRefresh) SetStatus(v string) *InstanceRefresh {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *InstanceRefresh) SetStatusReason(v string) *InstanceRefresh {
	s.StatusReason = &v
	return s
}

// Reports the progress of an instance refresh on instances that are in the
// Auto Scaling group.
type InstanceRefreshLivePoolProgress struct {
	_ struct{} `type:"structure"`

	// The number of instances remaining to update.
	InstancesToUpdate *int64 `type:"integer"`

	// The percentage of instances in the Auto Scaling group that have been replaced.
	// For each instance replacement, Amazon EC2 Auto Scaling tracks the instance's
	// health status and warm-up time. When the instance's health status changes
	// to healthy and the specified warm-up time passes, the instance is considered
	// updated and is added to the percentage complete.
	PercentageComplete *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRefreshLivePoolProgress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRefreshLivePoolProgress) GoString() string {
	return s.String()
}

// SetInstancesToUpdate sets the InstancesToUpdate field's value.
func (s *InstanceRefreshLivePoolProgress) SetInstancesToUpdate(v int64) *InstanceRefreshLivePoolProgress {
	s.InstancesToUpdate = &v
	return s
}

// SetPercentageComplete sets the PercentageComplete field's value.
func (s *InstanceRefreshLivePoolProgress) SetPercentageComplete(v int64) *InstanceRefreshLivePoolProgress {
	s.PercentageComplete = &v
	return s
}

// Reports the progress of an instance refresh on an Auto Scaling group that
// has a warm pool. This includes separate details for instances in the warm
// pool and instances in the Auto Scaling group (the live pool).
type InstanceRefreshProgressDetails struct {
	_ struct{} `type:"structure"`

	// Indicates the progress of an instance refresh on instances that are in the
	// Auto Scaling group.
	LivePoolProgress *InstanceRefreshLivePoolProgress `type:"structure"`

	// Indicates the progress of an instance refresh on instances that are in the
	// warm pool.
	WarmPoolProgress *InstanceRefreshWarmPoolProgress `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRefreshProgressDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRefreshProgressDetails) GoString() string {
	return s.String()
}

// SetLivePoolProgress sets the LivePoolProgress field's value.
func (s *InstanceRefreshProgressDetails) SetLivePoolProgress(v *InstanceRefreshLivePoolProgress) *InstanceRefreshProgressDetails {
	s.LivePoolProgress = v
	return s
}

// SetWarmPoolProgress sets the WarmPoolProgress field's value.
func (s *InstanceRefreshProgressDetails) SetWarmPoolProgress(v *InstanceRefreshWarmPoolProgress) *InstanceRefreshProgressDetails {
	s.WarmPoolProgress = v
	return s
}

// Reports the progress of an instance refresh on instances that are in the
// warm pool.
type InstanceRefreshWarmPoolProgress struct {
	_ struct{} `type:"structure"`

	// The number of instances remaining to update.
	InstancesToUpdate *int64 `type:"integer"`

	// The percentage of instances in the warm pool that have been replaced. For
	// each instance replacement, Amazon EC2 Auto Scaling tracks the instance's
	// health status and warm-up time. When the instance's health status changes
	// to healthy and the specified warm-up time passes, the instance is considered
	// updated and is added to the percentage complete.
	PercentageComplete *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRefreshWarmPoolProgress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRefreshWarmPoolProgress) GoString() string {
	return s.String()
}

// SetInstancesToUpdate sets the InstancesToUpdate field's value.
func (s *InstanceRefreshWarmPoolProgress) SetInstancesToUpdate(v int64) *InstanceRefreshWarmPoolProgress {
	s.InstancesToUpdate = &v
	return s
}

// SetPercentageComplete sets the PercentageComplete field's value.
func (s *InstanceRefreshWarmPoolProgress) SetPercentageComplete(v int64) *InstanceRefreshWarmPoolProgress {
	s.PercentageComplete = &v
	return s
}

// When you specify multiple parameters, you get instance types that satisfy
// all of the specified parameters. If you specify multiple values for a parameter,
// you get instance types that satisfy any of the specified values.
//
// Represents requirements for the types of instances that can be launched.
// You must specify VCpuCount and MemoryMiB, but all other parameters are optional.
// For more information, see Creating an Auto Scaling group using attribute-based
// instance type selection (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html)
// in the Amazon EC2 Auto Scaling User Guide.
type InstanceRequirements struct {
	_ struct{} `type:"structure"`

	// The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web
	// Services Inferentia chips) for an instance type.
	//
	// To exclude accelerator-enabled instance types, set Max to 0.
	//
	// Default: No minimum or maximum
	AcceleratorCount *AcceleratorCountRequest `type:"structure"`

	// Indicates whether instance types must have accelerators by specific manufacturers.
	//
	//    * For instance types with NVIDIA devices, specify nvidia.
	//
	//    * For instance types with AMD devices, specify amd.
	//
	//    * For instance types with Amazon Web Services devices, specify amazon-web-services.
	//
	//    * For instance types with Xilinx devices, specify xilinx.
	//
	// Default: Any manufacturer
	AcceleratorManufacturers []*string `type:"list"`

	// Lists the accelerators that must be on an instance type.
	//
	//    * For instance types with NVIDIA A100 GPUs, specify a100.
	//
	//    * For instance types with NVIDIA V100 GPUs, specify v100.
	//
	//    * For instance types with NVIDIA K80 GPUs, specify k80.
	//
	//    * For instance types with NVIDIA T4 GPUs, specify t4.
	//
	//    * For instance types with NVIDIA M60 GPUs, specify m60.
	//
	//    * For instance types with AMD Radeon Pro V520 GPUs, specify radeon-pro-v520.
	//
	//    * For instance types with Xilinx VU9P FPGAs, specify vu9p.
	//
	// Default: Any accelerator
	AcceleratorNames []*string `type:"list"`

	// The minimum and maximum total memory size for the accelerators on an instance
	// type, in MiB.
	//
	// Default: No minimum or maximum
	AcceleratorTotalMemoryMiB *AcceleratorTotalMemoryMiBRequest `type:"structure"`

	// Lists the accelerator types that must be on an instance type.
	//
	//    * For instance types with GPU accelerators, specify gpu.
	//
	//    * For instance types with FPGA accelerators, specify fpga.
	//
	//    * For instance types with inference accelerators, specify inference.
	//
	// Default: Any accelerator type
	AcceleratorTypes []*string `type:"list"`

	// Indicates whether bare metal instance types are included, excluded, or required.
	//
	// Default: excluded
	BareMetal *string `type:"string" enum:"BareMetal"`

	// The minimum and maximum baseline bandwidth performance for an instance type,
	// in Mbps. For more information, see Amazon EBS–optimized instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// Default: No minimum or maximum
	BaselineEbsBandwidthMbps *BaselineEbsBandwidthMbpsRequest `type:"structure"`

	// Indicates whether burstable performance instance types are included, excluded,
	// or required. For more information, see Burstable performance instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// Default: excluded
	BurstablePerformance *string `type:"string" enum:"BurstablePerformance"`

	// Lists which specific CPU manufacturers to include.
	//
	//    * For instance types with Intel CPUs, specify intel.
	//
	//    * For instance types with AMD CPUs, specify amd.
	//
	//    * For instance types with Amazon Web Services CPUs, specify amazon-web-services.
	//
	// Don't confuse the CPU hardware manufacturer with the CPU hardware architecture.
	// Instances will be launched with a compatible CPU architecture based on the
	// Amazon Machine Image (AMI) that you specify in your launch template.
	//
	// Default: Any manufacturer
	CpuManufacturers []*string `type:"list"`

	// Lists which instance types to exclude. You can use strings with one or more
	// wild cards, represented by an asterisk (*). The following are examples: c5*,
	// m5a.*, r*, *3*.
	//
	// For example, if you specify c5*, you are excluding the entire C5 instance
	// family, which includes all C5a and C5n instance types. If you specify m5a.*,
	// you are excluding all the M5a instance types, but not the M5n instance types.
	//
	// Default: No excluded instance types
	ExcludedInstanceTypes []*string `type:"list"`

	// Indicates whether current or previous generation instance types are included.
	//
	//    * For current generation instance types, specify current. The current
	//    generation includes EC2 instance types currently recommended for use.
	//    This typically includes the latest two to three generations in each instance
	//    family. For more information, see Instance types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
	//    in the Amazon EC2 User Guide for Linux Instances.
	//
	//    * For previous generation instance types, specify previous.
	//
	// Default: Any current or previous generation
	InstanceGenerations []*string `type:"list"`

	// Indicates whether instance types with instance store volumes are included,
	// excluded, or required. For more information, see Amazon EC2 instance store
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// Default: included
	LocalStorage *string `type:"string" enum:"LocalStorage"`

	// Indicates the type of local storage that is required.
	//
	//    * For instance types with hard disk drive (HDD) storage, specify hdd.
	//
	//    * For instance types with solid state drive (SSD) storage, specify sdd.
	//
	// Default: Any local storage type
	LocalStorageTypes []*string `type:"list"`

	// The minimum and maximum amount of memory per vCPU for an instance type, in
	// GiB.
	//
	// Default: No minimum or maximum
	MemoryGiBPerVCpu *MemoryGiBPerVCpuRequest `type:"structure"`

	// The minimum and maximum instance memory size for an instance type, in MiB.
	//
	// MemoryMiB is a required field
	MemoryMiB *MemoryMiBRequest `type:"structure" required:"true"`

	// The minimum and maximum number of network interfaces for an instance type.
	//
	// Default: No minimum or maximum
	NetworkInterfaceCount *NetworkInterfaceCountRequest `type:"structure"`

	// The price protection threshold for On-Demand Instances. This is the maximum
	// you’ll pay for an On-Demand Instance, expressed as a percentage higher
	// than the cheapest M, C, or R instance type with your specified attributes.
	// When Amazon EC2 Auto Scaling selects instance types with your attributes,
	// we will exclude instance types whose price is higher than your threshold.
	// The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets
	// as a percentage. To turn off price protection, specify a high value, such
	// as 999999.
	//
	// Default: 20
	OnDemandMaxPricePercentageOverLowestPrice *int64 `type:"integer"`

	// Indicates whether instance types must provide On-Demand Instance hibernation
	// support.
	//
	// Default: false
	RequireHibernateSupport *bool `type:"boolean"`

	// The price protection threshold for Spot Instances. This is the maximum you’ll
	// pay for a Spot Instance, expressed as a percentage higher than the cheapest
	// M, C, or R instance type with your specified attributes. When Amazon EC2
	// Auto Scaling selects instance types with your attributes, we will exclude
	// instance types whose price is higher than your threshold. The parameter accepts
	// an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To
	// turn off price protection, specify a high value, such as 999999.
	//
	// Default: 100
	SpotMaxPricePercentageOverLowestPrice *int64 `type:"integer"`

	// The minimum and maximum total local storage size for an instance type, in
	// GB.
	//
	// Default: No minimum or maximum
	TotalLocalStorageGB *TotalLocalStorageGBRequest `type:"structure"`

	// The minimum and maximum number of vCPUs for an instance type.
	//
	// VCpuCount is a required field
	VCpuCount *VCpuCountRequest `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRequirements) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceRequirements) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceRequirements) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceRequirements"}
	if s.MemoryMiB == nil {
		invalidParams.Add(request.NewErrParamRequired("MemoryMiB"))
	}
	if s.VCpuCount == nil {
		invalidParams.Add(request.NewErrParamRequired("VCpuCount"))
	}
	if s.MemoryMiB != nil {
		if err := s.MemoryMiB.Validate(); err != nil {
			invalidParams.AddNested("MemoryMiB", err.(request.ErrInvalidParams))
		}
	}
	if s.VCpuCount != nil {
		if err := s.VCpuCount.Validate(); err != nil {
			invalidParams.AddNested("VCpuCount", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorCount sets the AcceleratorCount field's value.
func (s *InstanceRequirements) SetAcceleratorCount(v *AcceleratorCountRequest) *InstanceRequirements {
	s.AcceleratorCount = v
	return s
}

// SetAcceleratorManufacturers sets the AcceleratorManufacturers field's value.
func (s *InstanceRequirements) SetAcceleratorManufacturers(v []*string) *InstanceRequirements {
	s.AcceleratorManufacturers = v
	return s
}

// SetAcceleratorNames sets the AcceleratorNames field's value.
func (s *InstanceRequirements) SetAcceleratorNames(v []*string) *InstanceRequirements {
	s.AcceleratorNames = v
	return s
}

// SetAcceleratorTotalMemoryMiB sets the AcceleratorTotalMemoryMiB field's value.
func (s *InstanceRequirements) SetAcceleratorTotalMemoryMiB(v *AcceleratorTotalMemoryMiBRequest) *InstanceRequirements {
	s.AcceleratorTotalMemoryMiB = v
	return s
}

// SetAcceleratorTypes sets the AcceleratorTypes field's value.
func (s *InstanceRequirements) SetAcceleratorTypes(v []*string) *InstanceRequirements {
	s.AcceleratorTypes = v
	return s
}

// SetBareMetal sets the BareMetal field's value.
func (s *InstanceRequirements) SetBareMetal(v string) *InstanceRequirements {
	s.BareMetal = &v
	return s
}

// SetBaselineEbsBandwidthMbps sets the BaselineEbsBandwidthMbps field's value.
func (s *InstanceRequirements) SetBaselineEbsBandwidthMbps(v *BaselineEbsBandwidthMbpsRequest) *InstanceRequirements {
	s.BaselineEbsBandwidthMbps = v
	return s
}

// SetBurstablePerformance sets the BurstablePerformance field's value.
func (s *InstanceRequirements) SetBurstablePerformance(v string) *InstanceRequirements {
	s.BurstablePerformance = &v
	return s
}

// SetCpuManufacturers sets the CpuManufacturers field's value.
func (s *InstanceRequirements) SetCpuManufacturers(v []*string) *InstanceRequirements {
	s.CpuManufacturers = v
	return s
}

// SetExcludedInstanceTypes sets the ExcludedInstanceTypes field's value.
func (s *InstanceRequirements) SetExcludedInstanceTypes(v []*string) *InstanceRequirements {
	s.ExcludedInstanceTypes = v
	return s
}

// SetInstanceGenerations sets the InstanceGenerations field's value.
func (s *InstanceRequirements) SetInstanceGenerations(v []*string) *InstanceRequirements {
	s.InstanceGenerations = v
	return s
}

// SetLocalStorage sets the LocalStorage field's value.
func (s *InstanceRequirements) SetLocalStorage(v string) *InstanceRequirements {
	s.LocalStorage = &v
	return s
}

// SetLocalStorageTypes sets the LocalStorageTypes field's value.
func (s *InstanceRequirements) SetLocalStorageTypes(v []*string) *InstanceRequirements {
	s.LocalStorageTypes = v
	return s
}

// SetMemoryGiBPerVCpu sets the MemoryGiBPerVCpu field's value.
func (s *InstanceRequirements) SetMemoryGiBPerVCpu(v *MemoryGiBPerVCpuRequest) *InstanceRequirements {
	s.MemoryGiBPerVCpu = v
	return s
}

// SetMemoryMiB sets the MemoryMiB field's value.
func (s *InstanceRequirements) SetMemoryMiB(v *MemoryMiBRequest) *InstanceRequirements {
	s.MemoryMiB = v
	return s
}

// SetNetworkInterfaceCount sets the NetworkInterfaceCount field's value.
func (s *InstanceRequirements) SetNetworkInterfaceCount(v *NetworkInterfaceCountRequest) *InstanceRequirements {
	s.NetworkInterfaceCount = v
	return s
}

// SetOnDemandMaxPricePercentageOverLowestPrice sets the OnDemandMaxPricePercentageOverLowestPrice field's value.
func (s *InstanceRequirements) SetOnDemandMaxPricePercentageOverLowestPrice(v int64) *InstanceRequirements {
	s.OnDemandMaxPricePercentageOverLowestPrice = &v
	return s
}

// SetRequireHibernateSupport sets the RequireHibernateSupport field's value.
func (s *InstanceRequirements) SetRequireHibernateSupport(v bool) *InstanceRequirements {
	s.RequireHibernateSupport = &v
	return s
}

// SetSpotMaxPricePercentageOverLowestPrice sets the SpotMaxPricePercentageOverLowestPrice field's value.
func (s *InstanceRequirements) SetSpotMaxPricePercentageOverLowestPrice(v int64) *InstanceRequirements {
	s.SpotMaxPricePercentageOverLowestPrice = &v
	return s
}

// SetTotalLocalStorageGB sets the TotalLocalStorageGB field's value.
func (s *InstanceRequirements) SetTotalLocalStorageGB(v *TotalLocalStorageGBRequest) *InstanceRequirements {
	s.TotalLocalStorageGB = v
	return s
}

// SetVCpuCount sets the VCpuCount field's value.
func (s *InstanceRequirements) SetVCpuCount(v *VCpuCountRequest) *InstanceRequirements {
	s.VCpuCount = v
	return s
}

// Describes an instances distribution for an Auto Scaling group.
type InstancesDistribution struct {
	_ struct{} `type:"structure"`

	// The order of the launch template overrides to use in fulfilling On-Demand
	// capacity.
	//
	// If you specify lowest-price, Amazon EC2 Auto Scaling uses price to determine
	// the order, launching the lowest price first.
	//
	// If you specify prioritized, Amazon EC2 Auto Scaling uses the priority that
	// you assigned to each launch template override, launching the highest priority
	// first. If all your On-Demand capacity cannot be fulfilled using your highest
	// priority instance, then Amazon EC2 Auto Scaling launches the remaining capacity
	// using the second priority instance type, and so on.
	//
	// Default: lowest-price for Auto Scaling groups that specify InstanceRequirements
	// in the overrides and prioritized for Auto Scaling groups that don't.
	OnDemandAllocationStrategy *string `type:"string"`

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances. This base portion is launched first as your group
	// scales.
	//
	// If you specify weights for the instance types in the overrides, the base
	// capacity is measured in the same unit of measurement as the instance types.
	// If you specify InstanceRequirements in the overrides, the base capacity is
	// measured in the same unit of measurement as your group's desired capacity.
	//
	// Default: 0
	OnDemandBaseCapacity *int64 `type:"integer"`

	// Controls the percentages of On-Demand Instances and Spot Instances for your
	// additional capacity beyond OnDemandBaseCapacity. Expressed as a number (for
	// example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set
	// to 100, only On-Demand Instances are used.
	//
	// Default: 100
	OnDemandPercentageAboveBaseCapacity *int64 `type:"integer"`

	// Indicates how to allocate instances across Spot Instance pools.
	//
	// If the allocation strategy is lowest-price, the Auto Scaling group launches
	// instances using the Spot pools with the lowest price, and evenly allocates
	// your instances across the number of Spot pools that you specify.
	//
	// If the allocation strategy is capacity-optimized (recommended), the Auto
	// Scaling group launches instances using Spot pools that are optimally chosen
	// based on the available Spot capacity. Alternatively, you can use capacity-optimized-prioritized
	// and set the order of instance types in the list of launch template overrides
	// from highest to lowest priority (from first to last in the list). Amazon
	// EC2 Auto Scaling honors the instance type priorities on a best-effort basis
	// but optimizes for capacity first.
	//
	// Default: lowest-price
	SpotAllocationStrategy *string `type:"string"`

	// The number of Spot Instance pools across which to allocate your Spot Instances.
	// The Spot pools are determined from the different instance types in the overrides.
	// Valid only when the Spot allocation strategy is lowest-price. Value must
	// be in the range of 1–20.
	//
	// Default: 2
	SpotInstancePools *int64 `type:"integer"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	// If you keep the value at its default (unspecified), Amazon EC2 Auto Scaling
	// uses the On-Demand price as the maximum Spot price. To remove a value that
	// you previously set, include the property but specify an empty string ("")
	// for the value.
	SpotMaxPrice *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstancesDistribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstancesDistribution) GoString() string {
	return s.String()
}

// SetOnDemandAllocationStrategy sets the OnDemandAllocationStrategy field's value.
func (s *InstancesDistribution) SetOnDemandAllocationStrategy(v string) *InstancesDistribution {
	s.OnDemandAllocationStrategy = &v
	return s
}

// SetOnDemandBaseCapacity sets the OnDemandBaseCapacity field's value.
func (s *InstancesDistribution) SetOnDemandBaseCapacity(v int64) *InstancesDistribution {
	s.OnDemandBaseCapacity = &v
	return s
}

// SetOnDemandPercentageAboveBaseCapacity sets the OnDemandPercentageAboveBaseCapacity field's value.
func (s *InstancesDistribution) SetOnDemandPercentageAboveBaseCapacity(v int64) *InstancesDistribution {
	s.OnDemandPercentageAboveBaseCapacity = &v
	return s
}

// SetSpotAllocationStrategy sets the SpotAllocationStrategy field's value.
func (s *InstancesDistribution) SetSpotAllocationStrategy(v string) *InstancesDistribution {
	s.SpotAllocationStrategy = &v
	return s
}

// SetSpotInstancePools sets the SpotInstancePools field's value.
func (s *InstancesDistribution) SetSpotInstancePools(v int64) *InstancesDistribution {
	s.SpotInstancePools = &v
	return s
}

// SetSpotMaxPrice sets the SpotMaxPrice field's value.
func (s *InstancesDistribution) SetSpotMaxPrice(v string) *InstancesDistribution {
	s.SpotMaxPrice = &v
	return s
}

// Describes a launch configuration.
type LaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// For Auto Scaling groups that are running in a VPC, specifies whether to assign
	// a public IP address to the group's instances. For more information, see Launching
	// Auto Scaling instances in a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// A block device mapping, which specifies the block devices for the instance.
	// For more information, see Block Device Mapping (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// For more information, see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
	// instances to a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	ClassicLinkVPCId *string `min:"1" type:"string"`

	// The IDs of one or more security groups for the VPC specified in ClassicLinkVPCId.
	//
	// For more information, see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
	// instances to a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	ClassicLinkVPCSecurityGroups []*string `type:"list"`

	// The creation date and time for the launch configuration.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// Specifies whether the launch configuration is optimized for EBS I/O (true)
	// or not (false). For more information, see Amazon EBS-Optimized Instances
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) in
	// the Amazon EC2 User Guide for Linux Instances.
	EbsOptimized *bool `type:"boolean"`

	// The name or the Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance. The instance profile contains the IAM
	// role. For more information, see IAM role for applications that run on Amazon
	// EC2 instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	IamInstanceProfile *string `min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
	// For more information, see Finding an AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// ImageId is a required field
	ImageId *string `min:"1" type:"string" required:"true"`

	// Controls whether instances in this group are launched with detailed (true)
	// or basic (false) monitoring.
	//
	// For more information, see Configure Monitoring for Auto Scaling Instances
	// (https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type for the instances.
	//
	// For information about available instance types, see Available Instance Types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The ID of the kernel associated with the AMI.
	KernelId *string `min:"1" type:"string"`

	// The name of the key pair.
	//
	// For more information, see Amazon EC2 Key Pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	KeyName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the launch configuration.
	LaunchConfigurationARN *string `min:"1" type:"string"`

	// The name of the launch configuration.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The metadata options for the instances. For more information, see Configuring
	// the Instance Metadata Options (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds)
	// in the Amazon EC2 Auto Scaling User Guide.
	MetadataOptions *InstanceMetadataOptions `type:"structure"`

	// The tenancy of the instance, either default or dedicated. An instance with
	// dedicated tenancy runs on isolated, single-tenant hardware and can only be
	// launched into a VPC.
	//
	// For more information, see Configuring instance tenancy with Amazon EC2 Auto
	// Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	PlacementTenancy *string `min:"1" type:"string"`

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string `min:"1" type:"string"`

	// A list that contains the security groups to assign to the instances in the
	// Auto Scaling group. For more information, see Security Groups for Your VPC
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SecurityGroups []*string `type:"list"`

	// The maximum hourly price to be paid for any Spot Instance launched to fulfill
	// the request. Spot Instances are launched when the price you specify exceeds
	// the current Spot price. For more information, see Requesting Spot Instances
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	SpotPrice *string `min:"1" type:"string"`

	// The user data to make available to the launched EC2 instances. For more information,
	// see Instance metadata and user data (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
	// (Linux) and Instance metadata and user data (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html)
	// (Windows). If you are using a command line tool, base64-encoding is performed
	// for you, and you can load the text from a file. Otherwise, you must provide
	// base64-encoded text. User data is limited to 16 KB.
	UserData *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchConfiguration) GoString() string {
	return s.String()
}

// SetAssociatePublicIpAddress sets the AssociatePublicIpAddress field's value.
func (s *LaunchConfiguration) SetAssociatePublicIpAddress(v bool) *LaunchConfiguration {
	s.AssociatePublicIpAddress = &v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *LaunchConfiguration) SetBlockDeviceMappings(v []*BlockDeviceMapping) *LaunchConfiguration {
	s.BlockDeviceMappings = v
	return s
}

// SetClassicLinkVPCId sets the ClassicLinkVPCId field's value.
func (s *LaunchConfiguration) SetClassicLinkVPCId(v string) *LaunchConfiguration {
	s.ClassicLinkVPCId = &v
	return s
}

// SetClassicLinkVPCSecurityGroups sets the ClassicLinkVPCSecurityGroups field's value.
func (s *LaunchConfiguration) SetClassicLinkVPCSecurityGroups(v []*string) *LaunchConfiguration {
	s.ClassicLinkVPCSecurityGroups = v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *LaunchConfiguration) SetCreatedTime(v time.Time) *LaunchConfiguration {
	s.CreatedTime = &v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *LaunchConfiguration) SetEbsOptimized(v bool) *LaunchConfiguration {
	s.EbsOptimized = &v
	return s
}

// SetIamInstanceProfile sets the IamInstanceProfile field's value.
func (s *LaunchConfiguration) SetIamInstanceProfile(v string) *LaunchConfiguration {
	s.IamInstanceProfile = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *LaunchConfiguration) SetImageId(v string) *LaunchConfiguration {
	s.ImageId = &v
	return s
}

// SetInstanceMonitoring sets the InstanceMonitoring field's value.
func (s *LaunchConfiguration) SetInstanceMonitoring(v *InstanceMonitoring) *LaunchConfiguration {
	s.InstanceMonitoring = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *LaunchConfiguration) SetInstanceType(v string) *LaunchConfiguration {
	s.InstanceType = &v
	return s
}

// SetKernelId sets the KernelId field's value.
func (s *LaunchConfiguration) SetKernelId(v string) *LaunchConfiguration {
	s.KernelId = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *LaunchConfiguration) SetKeyName(v string) *LaunchConfiguration {
	s.KeyName = &v
	return s
}

// SetLaunchConfigurationARN sets the LaunchConfigurationARN field's value.
func (s *LaunchConfiguration) SetLaunchConfigurationARN(v string) *LaunchConfiguration {
	s.LaunchConfigurationARN = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *LaunchConfiguration) SetLaunchConfigurationName(v string) *LaunchConfiguration {
	s.LaunchConfigurationName = &v
	return s
}

// SetMetadataOptions sets the MetadataOptions field's value.
func (s *LaunchConfiguration) SetMetadataOptions(v *InstanceMetadataOptions) *LaunchConfiguration {
	s.MetadataOptions = v
	return s
}

// SetPlacementTenancy sets the PlacementTenancy field's value.
func (s *LaunchConfiguration) SetPlacementTenancy(v string) *LaunchConfiguration {
	s.PlacementTenancy = &v
	return s
}

// SetRamdiskId sets the RamdiskId field's value.
func (s *LaunchConfiguration) SetRamdiskId(v string) *LaunchConfiguration {
	s.RamdiskId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *LaunchConfiguration) SetSecurityGroups(v []*string) *LaunchConfiguration {
	s.SecurityGroups = v
	return s
}

// SetSpotPrice sets the SpotPrice field's value.
func (s *LaunchConfiguration) SetSpotPrice(v string) *LaunchConfiguration {
	s.SpotPrice = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *LaunchConfiguration) SetUserData(v string) *LaunchConfiguration {
	s.UserData = &v
	return s
}

// Describes a launch template and overrides. You specify these properties as
// part of a mixed instances policy.
type LaunchTemplate struct {
	_ struct{} `type:"structure"`

	// The launch template to use.
	LaunchTemplateSpecification *LaunchTemplateSpecification `type:"structure"`

	// Any properties that you specify override the same properties in the launch
	// template. If not provided, Amazon EC2 Auto Scaling uses the instance type
	// or instance type requirements specified in the launch template when it launches
	// an instance.
	//
	// The overrides can include either one or more instance types or a set of instance
	// requirements, but not both.
	Overrides []*LaunchTemplateOverrides `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchTemplate"}
	if s.LaunchTemplateSpecification != nil {
		if err := s.LaunchTemplateSpecification.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplateSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.Overrides != nil {
		for i, v := range s.Overrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Overrides", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchTemplateSpecification sets the LaunchTemplateSpecification field's value.
func (s *LaunchTemplate) SetLaunchTemplateSpecification(v *LaunchTemplateSpecification) *LaunchTemplate {
	s.LaunchTemplateSpecification = v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *LaunchTemplate) SetOverrides(v []*LaunchTemplateOverrides) *LaunchTemplate {
	s.Overrides = v
	return s
}

// Describes an override for a launch template. For more information, see Configuring
// overrides (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-configuring-overrides.html)
// in the Amazon EC2 Auto Scaling User Guide.
type LaunchTemplateOverrides struct {
	_ struct{} `type:"structure"`

	// The instance requirements. When you specify instance requirements, Amazon
	// EC2 Auto Scaling finds instance types that satisfy your requirements, and
	// then uses your On-Demand and Spot allocation strategies to launch instances
	// from these instance types, in the same way as when you specify a list of
	// specific instance types.
	InstanceRequirements *InstanceRequirements `type:"structure"`

	// The instance type, such as m3.xlarge. You must use an instance type that
	// is supported in your requested Region and Availability Zones. For more information,
	// see Instance types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	InstanceType *string `min:"1" type:"string"`

	// Provides the launch template to be used when launching the instance type
	// specified in InstanceType. For example, some instance types might require
	// a launch template with a different AMI. If not provided, Amazon EC2 Auto
	// Scaling uses the launch template that's defined for your mixed instances
	// policy. For more information, see Specifying a different launch template
	// for an instance type (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	LaunchTemplateSpecification *LaunchTemplateSpecification `type:"structure"`

	// The number of capacity units provided by the instance type specified in InstanceType
	// in terms of virtual CPUs, memory, storage, throughput, or other relative
	// performance characteristic. When a Spot or On-Demand Instance is launched,
	// the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling
	// launches instances until the desired capacity is totally fulfilled, even
	// if this results in an overage. For example, if there are two units remaining
	// to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance
	// with a WeightedCapacity of five units, the instance is launched, and the
	// desired capacity is exceeded by three units. For more information, see Instance
	// weighting for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html)
	// in the Amazon EC2 Auto Scaling User Guide. Value must be in the range of
	// 1–999.
	WeightedCapacity *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateOverrides) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateOverrides) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchTemplateOverrides"}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.WeightedCapacity != nil && len(*s.WeightedCapacity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeightedCapacity", 1))
	}
	if s.InstanceRequirements != nil {
		if err := s.InstanceRequirements.Validate(); err != nil {
			invalidParams.AddNested("InstanceRequirements", err.(request.ErrInvalidParams))
		}
	}
	if s.LaunchTemplateSpecification != nil {
		if err := s.LaunchTemplateSpecification.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplateSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceRequirements sets the InstanceRequirements field's value.
func (s *LaunchTemplateOverrides) SetInstanceRequirements(v *InstanceRequirements) *LaunchTemplateOverrides {
	s.InstanceRequirements = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *LaunchTemplateOverrides) SetInstanceType(v string) *LaunchTemplateOverrides {
	s.InstanceType = &v
	return s
}

// SetLaunchTemplateSpecification sets the LaunchTemplateSpecification field's value.
func (s *LaunchTemplateOverrides) SetLaunchTemplateSpecification(v *LaunchTemplateSpecification) *LaunchTemplateOverrides {
	s.LaunchTemplateSpecification = v
	return s
}

// SetWeightedCapacity sets the WeightedCapacity field's value.
func (s *LaunchTemplateOverrides) SetWeightedCapacity(v string) *LaunchTemplateOverrides {
	s.WeightedCapacity = &v
	return s
}

// Describes the launch template and the version of the launch template that
// Amazon EC2 Auto Scaling uses to launch Amazon EC2 instances. For more information
// about launch templates, see Launch templates (https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html)
// in the Amazon EC2 Auto Scaling User Guide.
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template. To get the template ID, use the Amazon EC2
	// DescribeLaunchTemplates (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html)
	// API operation. New launch templates can be created using the Amazon EC2 CreateLaunchTemplate
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
	// API.
	//
	// Conditional: You must specify either a LaunchTemplateId or a LaunchTemplateName.
	LaunchTemplateId *string `min:"1" type:"string"`

	// The name of the launch template. To get the template name, use the Amazon
	// EC2 DescribeLaunchTemplates (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html)
	// API operation. New launch templates can be created using the Amazon EC2 CreateLaunchTemplate
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
	// API.
	//
	// Conditional: You must specify either a LaunchTemplateId or a LaunchTemplateName.
	LaunchTemplateName *string `min:"3" type:"string"`

	// The version number, $Latest, or $Default. To get the version number, use
	// the Amazon EC2 DescribeLaunchTemplateVersions (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html)
	// API operation. New launch template versions can be created using the Amazon
	// EC2 CreateLaunchTemplateVersion (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html)
	// API. If the value is $Latest, Amazon EC2 Auto Scaling selects the latest
	// version of the launch template when launching instances. If the value is
	// $Default, Amazon EC2 Auto Scaling selects the default version of the launch
	// template when launching instances. The default value is $Default.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchTemplateSpecification"}
	if s.LaunchTemplateId != nil && len(*s.LaunchTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchTemplateId", 1))
	}
	if s.LaunchTemplateName != nil && len(*s.LaunchTemplateName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchTemplateName", 3))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *LaunchTemplateSpecification) SetLaunchTemplateId(v string) *LaunchTemplateSpecification {
	s.LaunchTemplateId = &v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *LaunchTemplateSpecification) SetLaunchTemplateName(v string) *LaunchTemplateSpecification {
	s.LaunchTemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *LaunchTemplateSpecification) SetVersion(v string) *LaunchTemplateSpecification {
	s.Version = &v
	return s
}

// Describes a lifecycle hook, which enables an Auto Scaling group to be aware
// of events in the Auto Scaling instance lifecycle, and then perform a custom
// action when the corresponding lifecycle event occurs.
type LifecycleHook struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The possible values
	// are CONTINUE and ABANDON.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that an instance can remain in a Pending:Wait
	// or Terminating:Wait state. The maximum is 172800 seconds (48 hours) or 100
	// times HeartbeatTimeout, whichever is smaller.
	GlobalTimeout *int64 `type:"integer"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the
	// action that you specified in the DefaultResult parameter.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string"`

	// The state of the EC2 instance to which to attach the lifecycle hook. The
	// following are possible values:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATING
	LifecycleTransition *string `type:"string"`

	// Additional information that is included any time Amazon EC2 Auto Scaling
	// sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to
	// when an instance is in the transition state for the lifecycle hook. The notification
	// target can be either an SQS queue or an SNS topic.
	NotificationTargetARN *string `type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleHook) GoString() string {
	return s.String()
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *LifecycleHook) SetAutoScalingGroupName(v string) *LifecycleHook {
	s.AutoScalingGroupName = &v
	return s
}

// SetDefaultResult sets the DefaultResult field's value.
func (s *LifecycleHook) SetDefaultResult(v string) *LifecycleHook {
	s.DefaultResult = &v
	return s
}

// SetGlobalTimeout sets the GlobalTimeout field's value.
func (s *LifecycleHook) SetGlobalTimeout(v int64) *LifecycleHook {
	s.GlobalTimeout = &v
	return s
}

// SetHeartbeatTimeout sets the HeartbeatTimeout field's value.
func (s *LifecycleHook) SetHeartbeatTimeout(v int64) *LifecycleHook {
	s.HeartbeatTimeout = &v
	return s
}

// SetLifecycleHookName sets the LifecycleHookName field's value.
func (s *LifecycleHook) SetLifecycleHookName(v string) *LifecycleHook {
	s.LifecycleHookName = &v
	return s
}

// SetLifecycleTransition sets the LifecycleTransition field's value.
func (s *LifecycleHook) SetLifecycleTransition(v string) *LifecycleHook {
	s.LifecycleTransition = &v
	return s
}

// SetNotificationMetadata sets the NotificationMetadata field's value.
func (s *LifecycleHook) SetNotificationMetadata(v string) *LifecycleHook {
	s.NotificationMetadata = &v
	return s
}

// SetNotificationTargetARN sets the NotificationTargetARN field's value.
func (s *LifecycleHook) SetNotificationTargetARN(v string) *LifecycleHook {
	s.NotificationTargetARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *LifecycleHook) SetRoleARN(v string) *LifecycleHook {
	s.RoleARN = &v
	return s
}

// Describes information used to specify a lifecycle hook for an Auto Scaling
// group.
//
// For more information, see Amazon EC2 Auto Scaling lifecycle hooks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
// in the Amazon EC2 Auto Scaling User Guide.
type LifecycleHookSpecification struct {
	_ struct{} `type:"structure"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The valid values
	// are CONTINUE and ABANDON. The default value is ABANDON.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out.
	//
	// If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action
	// that you specified in the DefaultResult parameter. You can prevent the lifecycle
	// hook from timing out by calling RecordLifecycleActionHeartbeat.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`

	// The state of the EC2 instance to which you want to attach the lifecycle hook.
	// The valid values are:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATING
	//
	// LifecycleTransition is a required field
	LifecycleTransition *string `type:"string" required:"true"`

	// Additional information that you want to include any time Amazon EC2 Auto
	// Scaling sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to
	// when an instance is in the transition state for the lifecycle hook. The notification
	// target can be either an SQS queue or an SNS topic.
	NotificationTargetARN *string `type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target, for example, an Amazon SNS topic or an
	// Amazon SQS queue.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleHookSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleHookSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleHookSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleHookSpecification"}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}
	if s.LifecycleTransition == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleTransition"))
	}
	if s.NotificationMetadata != nil && len(*s.NotificationMetadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationMetadata", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultResult sets the DefaultResult field's value.
func (s *LifecycleHookSpecification) SetDefaultResult(v string) *LifecycleHookSpecification {
	s.DefaultResult = &v
	return s
}

// SetHeartbeatTimeout sets the HeartbeatTimeout field's value.
func (s *LifecycleHookSpecification) SetHeartbeatTimeout(v int64) *LifecycleHookSpecification {
	s.HeartbeatTimeout = &v
	return s
}

// SetLifecycleHookName sets the LifecycleHookName field's value.
func (s *LifecycleHookSpecification) SetLifecycleHookName(v string) *LifecycleHookSpecification {
	s.LifecycleHookName = &v
	return s
}

// SetLifecycleTransition sets the LifecycleTransition field's value.
func (s *LifecycleHookSpecification) SetLifecycleTransition(v string) *LifecycleHookSpecification {
	s.LifecycleTransition = &v
	return s
}

// SetNotificationMetadata sets the NotificationMetadata field's value.
func (s *LifecycleHookSpecification) SetNotificationMetadata(v string) *LifecycleHookSpecification {
	s.NotificationMetadata = &v
	return s
}

// SetNotificationTargetARN sets the NotificationTargetARN field's value.
func (s *LifecycleHookSpecification) SetNotificationTargetARN(v string) *LifecycleHookSpecification {
	s.NotificationTargetARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *LifecycleHookSpecification) SetRoleARN(v string) *LifecycleHookSpecification {
	s.RoleARN = &v
	return s
}

// Describes the state of a Classic Load Balancer.
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `min:"1" type:"string"`

	// One of the following load balancer states:
	//
	//    * Adding - The Auto Scaling instances are being registered with the load
	//    balancer.
	//
	//    * Added - All Auto Scaling instances are registered with the load balancer.
	//
	//    * InService - At least one Auto Scaling instance passed an ELB health
	//    check.
	//
	//    * Removing - The Auto Scaling instances are being deregistered from the
	//    load balancer. If connection draining is enabled, Elastic Load Balancing
	//    waits for in-flight requests to complete before deregistering the instances.
	//
	//    * Removed - All Auto Scaling instances are deregistered from the load
	//    balancer.
	State *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadBalancerState) GoString() string {
	return s.String()
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *LoadBalancerState) SetLoadBalancerName(v string) *LoadBalancerState {
	s.LoadBalancerName = &v
	return s
}

// SetState sets the State field's value.
func (s *LoadBalancerState) SetState(v string) *LoadBalancerState {
	s.State = &v
	return s
}

// Describes the state of a target group.
type LoadBalancerTargetGroupState struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	LoadBalancerTargetGroupARN *string `min:"1" type:"string"`

	// The state of the target group.
	//
	//    * Adding - The Auto Scaling instances are being registered with the target
	//    group.
	//
	//    * Added - All Auto Scaling instances are registered with the target group.
	//
	//    * InService - At least one Auto Scaling instance passed an ELB health
	//    check.
	//
	//    * Removing - The Auto Scaling instances are being deregistered from the
	//    target group. If connection draining is enabled, Elastic Load Balancing
	//    waits for in-flight requests to complete before deregistering the instances.
	//
	//    * Removed - All Auto Scaling instances are deregistered from the target
	//    group.
	State *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadBalancerTargetGroupState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadBalancerTargetGroupState) GoString() string {
	return s.String()
}

// SetLoadBalancerTargetGroupARN sets the LoadBalancerTargetGroupARN field's value.
func (s *LoadBalancerTargetGroupState) SetLoadBalancerTargetGroupARN(v string) *LoadBalancerTargetGroupState {
	s.LoadBalancerTargetGroupARN = &v
	return s
}

// SetState sets the State field's value.
func (s *LoadBalancerTargetGroupState) SetState(v string) *LoadBalancerTargetGroupState {
	s.State = &v
	return s
}

// A GetPredictiveScalingForecast call returns the load forecast for a predictive
// scaling policy. This structure includes the data points for that load forecast,
// along with the timestamps of those data points and the metric specification.
type LoadForecast struct {
	_ struct{} `type:"structure"`

	// The metric specification for the load forecast.
	//
	// MetricSpecification is a required field
	MetricSpecification *PredictiveScalingMetricSpecification `type:"structure" required:"true"`

	// The timestamps for the data points, in UTC format.
	//
	// Timestamps is a required field
	Timestamps []*time.Time `type:"list" required:"true"`

	// The values of the data points.
	//
	// Values is a required field
	Values []*float64 `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadForecast) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoadForecast) GoString() string {
	return s.String()
}

// SetMetricSpecification sets the MetricSpecification field's value.
func (s *LoadForecast) SetMetricSpecification(v *PredictiveScalingMetricSpecification) *LoadForecast {
	s.MetricSpecification = v
	return s
}

// SetTimestamps sets the Timestamps field's value.
func (s *LoadForecast) SetTimestamps(v []*time.Time) *LoadForecast {
	s.Timestamps = v
	return s
}

// SetValues sets the Values field's value.
func (s *LoadForecast) SetValues(v []*float64) *LoadForecast {
	s.Values = v
	return s
}

// Specifies the minimum and maximum for the MemoryGiBPerVCpu object when you
// specify InstanceRequirements for an Auto Scaling group.
type MemoryGiBPerVCpuRequest struct {
	_ struct{} `type:"structure"`

	// The memory maximum in GiB.
	Max *float64 `type:"double"`

	// The memory minimum in GiB.
	Min *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryGiBPerVCpuRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryGiBPerVCpuRequest) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *MemoryGiBPerVCpuRequest) SetMax(v float64) *MemoryGiBPerVCpuRequest {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *MemoryGiBPerVCpuRequest) SetMin(v float64) *MemoryGiBPerVCpuRequest {
	s.Min = &v
	return s
}

// Specifies the minimum and maximum for the MemoryMiB object when you specify
// InstanceRequirements for an Auto Scaling group.
type MemoryMiBRequest struct {
	_ struct{} `type:"structure"`

	// The memory maximum in MiB.
	Max *int64 `type:"integer"`

	// The memory minimum in MiB.
	//
	// Min is a required field
	Min *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryMiBRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryMiBRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemoryMiBRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemoryMiBRequest"}
	if s.Min == nil {
		invalidParams.Add(request.NewErrParamRequired("Min"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMax sets the Max field's value.
func (s *MemoryMiBRequest) SetMax(v int64) *MemoryMiBRequest {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *MemoryMiBRequest) SetMin(v int64) *MemoryMiBRequest {
	s.Min = &v
	return s
}

// Represents a specific metric.
type Metric struct {
	_ struct{} `type:"structure"`

	// The dimensions for the metric. For the list of available dimensions, see
	// the Amazon Web Services documentation available from the table in Amazon
	// Web Services services that publish CloudWatch metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
	// in the Amazon CloudWatch User Guide.
	//
	// Conditional: If you published your metric with dimensions, you must specify
	// the same dimensions in your scaling policy.
	Dimensions []*MetricDimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace of the metric. For more information, see the table in Amazon
	// Web Services services that publish CloudWatch metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
	// in the Amazon CloudWatch User Guide.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metric"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *Metric) SetDimensions(v []*MetricDimension) *Metric {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *Metric) SetMetricName(v string) *Metric {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *Metric) SetNamespace(v string) *Metric {
	s.Namespace = &v
	return s
}

// Describes a metric.
type MetricCollectionType struct {
	_ struct{} `type:"structure"`

	// One of the following metrics:
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	//
	//    * GroupInServiceCapacity
	//
	//    * GroupPendingCapacity
	//
	//    * GroupStandbyCapacity
	//
	//    * GroupTerminatingCapacity
	//
	//    * GroupTotalCapacity
	//
	//    * WarmPoolDesiredCapacity
	//
	//    * WarmPoolWarmedCapacity
	//
	//    * WarmPoolPendingCapacity
	//
	//    * WarmPoolTerminatingCapacity
	//
	//    * WarmPoolTotalCapacity
	//
	//    * GroupAndWarmPoolDesiredCapacity
	//
	//    * GroupAndWarmPoolTotalCapacity
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricCollectionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricCollectionType) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *MetricCollectionType) SetMetric(v string) *MetricCollectionType {
	s.Metric = &v
	return s
}

// The metric data to return. Also defines whether this call is returning data
// for one metric only, or whether it is performing a math expression on the
// values of returned metric statistics to create a new time series. A time
// series is a series of data points, each of which is associated with a timestamp.
//
// For more information and examples, see Advanced predictive scaling policy
// configurations using custom metrics (https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html)
// in the Amazon EC2 Auto Scaling User Guide.
type MetricDataQuery struct {
	_ struct{} `type:"structure"`

	// The math expression to perform on the returned data, if this object is performing
	// a math expression. This expression can use the Id of the other metrics to
	// refer to those metrics, and can also use the Id of other expressions to use
	// the result of those expressions.
	//
	// Conditional: Within each MetricDataQuery object, you must specify either
	// Expression or MetricStat, but not both.
	Expression *string `min:"1" type:"string"`

	// A short name that identifies the object's results in the response. This name
	// must be unique among all MetricDataQuery objects specified for a single scaling
	// policy. If you are performing math expressions on this set of data, this
	// name represents that data and can serve as a variable in the mathematical
	// expression. The valid characters are letters, numbers, and underscores. The
	// first character must be a lowercase letter.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A human-readable label for this metric or expression. This is especially
	// useful if this is a math expression, so that you know what the value represents.
	Label *string `type:"string"`

	// Information about the metric data to return.
	//
	// Conditional: Within each MetricDataQuery object, you must specify either
	// Expression or MetricStat, but not both.
	MetricStat *MetricStat `type:"structure"`

	// Indicates whether to return the timestamps and raw data values of this metric.
	//
	// If you use any math expressions, specify true for this value for only the
	// final math expression that the metric specification is based on. You must
	// specify false for ReturnData for all the other metrics and expressions used
	// in the metric specification.
	//
	// If you are only retrieving metrics and not performing any math expressions,
	// do not specify anything for ReturnData. This sets it to its default (true).
	ReturnData *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDataQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDataQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDataQuery"}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.MetricStat != nil {
		if err := s.MetricStat.Validate(); err != nil {
			invalidParams.AddNested("MetricStat", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *MetricDataQuery) SetExpression(v string) *MetricDataQuery {
	s.Expression = &v
	return s
}

// SetId sets the Id field's value.
func (s *MetricDataQuery) SetId(v string) *MetricDataQuery {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *MetricDataQuery) SetLabel(v string) *MetricDataQuery {
	s.Label = &v
	return s
}

// SetMetricStat sets the MetricStat field's value.
func (s *MetricDataQuery) SetMetricStat(v *MetricStat) *MetricDataQuery {
	s.MetricStat = v
	return s
}

// SetReturnData sets the ReturnData field's value.
func (s *MetricDataQuery) SetReturnData(v bool) *MetricDataQuery {
	s.ReturnData = &v
	return s
}

// Describes the dimension of a metric.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MetricDimension) SetName(v string) *MetricDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDimension) SetValue(v string) *MetricDimension {
	s.Value = &v
	return s
}

// Describes a granularity of a metric.
type MetricGranularityType struct {
	_ struct{} `type:"structure"`

	// The granularity. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricGranularityType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricGranularityType) GoString() string {
	return s.String()
}

// SetGranularity sets the Granularity field's value.
func (s *MetricGranularityType) SetGranularity(v string) *MetricGranularityType {
	s.Granularity = &v
	return s
}

// This structure defines the CloudWatch metric to return, along with the statistic,
// period, and unit.
//
// For more information about the CloudWatch terminology below, see Amazon CloudWatch
// concepts (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html)
// in the Amazon CloudWatch User Guide.
type MetricStat struct {
	_ struct{} `type:"structure"`

	// The CloudWatch metric to return, including the metric name, namespace, and
	// dimensions. To get the exact metric name, namespace, and dimensions, inspect
	// the Metric (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html)
	// object that is returned by a call to ListMetrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
	//
	// Metric is a required field
	Metric *Metric `type:"structure" required:"true"`

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic. For a list of valid values, see the table in Statistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic)
	// in the Amazon CloudWatch User Guide.
	//
	// The most commonly used metrics for predictive scaling are Average and Sum.
	//
	// Stat is a required field
	Stat *string `min:"1" type:"string" required:"true"`

	// The unit to use for the returned data points. For a complete list of the
	// units that CloudWatch supports, see the MetricDatum (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html)
	// data type in the Amazon CloudWatch API Reference.
	Unit *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricStat) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricStat) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricStat"}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.Stat == nil {
		invalidParams.Add(request.NewErrParamRequired("Stat"))
	}
	if s.Stat != nil && len(*s.Stat) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Stat", 1))
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetric sets the Metric field's value.
func (s *MetricStat) SetMetric(v *Metric) *MetricStat {
	s.Metric = v
	return s
}

// SetStat sets the Stat field's value.
func (s *MetricStat) SetStat(v string) *MetricStat {
	s.Stat = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricStat) SetUnit(v string) *MetricStat {
	s.Unit = &v
	return s
}

// Describes a mixed instances policy. A mixed instances policy contains the
// instance types that Amazon EC2 Auto Scaling can launch and other information
// that Amazon EC2 Auto Scaling can use to launch instances and help optimize
// your costs. For more information, see Auto Scaling groups with multiple instance
// types and purchase options (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html)
// in the Amazon EC2 Auto Scaling User Guide.
type MixedInstancesPolicy struct {
	_ struct{} `type:"structure"`

	// Specifies the instances distribution.
	InstancesDistribution *InstancesDistribution `type:"structure"`

	// Specifies the launch template to use and the instance types (overrides) that
	// are used to launch EC2 instances to fulfill On-Demand and Spot capacities.
	// Required when creating a mixed instances policy.
	LaunchTemplate *LaunchTemplate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MixedInstancesPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MixedInstancesPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MixedInstancesPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MixedInstancesPolicy"}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstancesDistribution sets the InstancesDistribution field's value.
func (s *MixedInstancesPolicy) SetInstancesDistribution(v *InstancesDistribution) *MixedInstancesPolicy {
	s.InstancesDistribution = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *MixedInstancesPolicy) SetLaunchTemplate(v *LaunchTemplate) *MixedInstancesPolicy {
	s.LaunchTemplate = v
	return s
}

// Specifies the minimum and maximum for the NetworkInterfaceCount object when
// you specify InstanceRequirements for an Auto Scaling group.
type NetworkInterfaceCountRequest struct {
	_ struct{} `type:"structure"`

	// The maximum number of network interfaces.
	Max *int64 `type:"integer"`

	// The minimum number of network interfaces.
	Min *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterfaceCountRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterfaceCountRequest) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *NetworkInterfaceCountRequest) SetMax(v int64) *NetworkInterfaceCountRequest {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *NetworkInterfaceCountRequest) SetMin(v int64) *NetworkInterfaceCountRequest {
	s.Min = &v
	return s
}

// Describes a notification.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// One of the following event notification types:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCH
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATE
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	//    * autoscaling:TEST_NOTIFICATION
	NotificationType *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic.
	TopicARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *NotificationConfiguration) SetAutoScalingGroupName(v string) *NotificationConfiguration {
	s.AutoScalingGroupName = &v
	return s
}

// SetNotificationType sets the NotificationType field's value.
func (s *NotificationConfiguration) SetNotificationType(v string) *NotificationConfiguration {
	s.NotificationType = &v
	return s
}

// SetTopicARN sets the TopicARN field's value.
func (s *NotificationConfiguration) SetTopicARN(v string) *NotificationConfiguration {
	s.TopicARN = &v
	return s
}

// Represents a predefined metric for a target tracking scaling policy to use
// with Amazon EC2 Auto Scaling.
type PredefinedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The metric type. The following predefined metrics are available:
	//
	//    * ASGAverageCPUUtilization - Average CPU utilization of the Auto Scaling
	//    group.
	//
	//    * ASGAverageNetworkIn - Average number of bytes received on all network
	//    interfaces by the Auto Scaling group.
	//
	//    * ASGAverageNetworkOut - Average number of bytes sent out on all network
	//    interfaces by the Auto Scaling group.
	//
	//    * ALBRequestCountPerTarget - Number of requests completed per target in
	//    an Application Load Balancer target group.
	//
	// PredefinedMetricType is a required field
	PredefinedMetricType *string `type:"string" required:"true" enum:"MetricType"`

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the average request count served by your Auto
	// Scaling group. You can't specify a resource label unless the target group
	// is attached to the Auto Scaling group.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single
	// value, separated by a forward slash (/). The format of the resource label
	// is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	//
	// Where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredefinedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredefinedMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredefinedMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredefinedMetricSpecification"}
	if s.PredefinedMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedMetricType sets the PredefinedMetricType field's value.
func (s *PredefinedMetricSpecification) SetPredefinedMetricType(v string) *PredefinedMetricSpecification {
	s.PredefinedMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredefinedMetricSpecification) SetResourceLabel(v string) *PredefinedMetricSpecification {
	s.ResourceLabel = &v
	return s
}

// Represents a predictive scaling policy configuration to use with Amazon EC2
// Auto Scaling.
type PredictiveScalingConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the behavior that should be applied if the forecast capacity approaches
	// or exceeds the maximum capacity of the Auto Scaling group. Defaults to HonorMaxCapacity
	// if not specified.
	//
	// The following are possible values:
	//
	//    * HonorMaxCapacity - Amazon EC2 Auto Scaling cannot scale out capacity
	//    higher than the maximum capacity. The maximum capacity is enforced as
	//    a hard limit.
	//
	//    * IncreaseMaxCapacity - Amazon EC2 Auto Scaling can scale out capacity
	//    higher than the maximum capacity when the forecast capacity is close to
	//    or exceeds the maximum capacity. The upper limit is determined by the
	//    forecasted capacity and the value for MaxCapacityBuffer.
	MaxCapacityBreachBehavior *string `type:"string" enum:"PredictiveScalingMaxCapacityBreachBehavior"`

	// The size of the capacity buffer to use when the forecast capacity is close
	// to or exceeds the maximum capacity. The value is specified as a percentage
	// relative to the forecast capacity. For example, if the buffer is 10, this
	// means a 10 percent buffer, such that if the forecast capacity is 50, and
	// the maximum capacity is 40, then the effective maximum capacity is 55.
	//
	// If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum
	// capacity to equal but not exceed forecast capacity.
	//
	// Required if the MaxCapacityBreachBehavior property is set to IncreaseMaxCapacity,
	// and cannot be used otherwise.
	MaxCapacityBuffer *int64 `type:"integer"`

	// This structure includes the metrics and target utilization to use for predictive
	// scaling.
	//
	// This is an array, but we currently only support a single metric specification.
	// That is, you can specify a target value and a single metric pair, or a target
	// value and one scaling metric and one load metric.
	//
	// MetricSpecifications is a required field
	MetricSpecifications []*PredictiveScalingMetricSpecification `type:"list" required:"true"`

	// The predictive scaling mode. Defaults to ForecastOnly if not specified.
	Mode *string `type:"string" enum:"PredictiveScalingMode"`

	// The amount of time, in seconds, by which the instance launch time can be
	// advanced. For example, the forecast says to add capacity at 10:00 AM, and
	// you choose to pre-launch instances by 5 minutes. In that case, the instances
	// will be launched at 9:55 AM. The intention is to give resources time to be
	// provisioned. It can take a few minutes to launch an EC2 instance. The actual
	// amount of time required depends on several factors, such as the size of the
	// instance and whether there are startup scripts to complete.
	//
	// The value must be less than the forecast interval duration of 3600 seconds
	// (60 minutes). Defaults to 300 seconds if not specified.
	SchedulingBufferTime *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveScalingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveScalingConfiguration"}
	if s.MetricSpecifications == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricSpecifications"))
	}
	if s.MetricSpecifications != nil {
		for i, v := range s.MetricSpecifications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricSpecifications", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxCapacityBreachBehavior sets the MaxCapacityBreachBehavior field's value.
func (s *PredictiveScalingConfiguration) SetMaxCapacityBreachBehavior(v string) *PredictiveScalingConfiguration {
	s.MaxCapacityBreachBehavior = &v
	return s
}

// SetMaxCapacityBuffer sets the MaxCapacityBuffer field's value.
func (s *PredictiveScalingConfiguration) SetMaxCapacityBuffer(v int64) *PredictiveScalingConfiguration {
	s.MaxCapacityBuffer = &v
	return s
}

// SetMetricSpecifications sets the MetricSpecifications field's value.
func (s *PredictiveScalingConfiguration) SetMetricSpecifications(v []*PredictiveScalingMetricSpecification) *PredictiveScalingConfiguration {
	s.MetricSpecifications = v
	return s
}

// SetMode sets the Mode field's value.
func (s *PredictiveScalingConfiguration) SetMode(v string) *PredictiveScalingConfiguration {
	s.Mode = &v
	return s
}

// SetSchedulingBufferTime sets the SchedulingBufferTime field's value.
func (s *PredictiveScalingConfiguration) SetSchedulingBufferTime(v int64) *PredictiveScalingConfiguration {
	s.SchedulingBufferTime = &v
	return s
}

// Describes a customized capacity metric for a predictive scaling policy.
type PredictiveScalingCustomizedCapacityMetric struct {
	_ struct{} `type:"structure"`

	// One or more metric data queries to provide the data points for a capacity
	// metric. Use multiple metric data queries only if you are performing a math
	// expression on returned data.
	//
	// MetricDataQueries is a required field
	MetricDataQueries []*MetricDataQuery `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingCustomizedCapacityMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingCustomizedCapacityMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveScalingCustomizedCapacityMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveScalingCustomizedCapacityMetric"}
	if s.MetricDataQueries == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricDataQueries"))
	}
	if s.MetricDataQueries != nil {
		for i, v := range s.MetricDataQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDataQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricDataQueries sets the MetricDataQueries field's value.
func (s *PredictiveScalingCustomizedCapacityMetric) SetMetricDataQueries(v []*MetricDataQuery) *PredictiveScalingCustomizedCapacityMetric {
	s.MetricDataQueries = v
	return s
}

// Describes a custom load metric for a predictive scaling policy.
type PredictiveScalingCustomizedLoadMetric struct {
	_ struct{} `type:"structure"`

	// One or more metric data queries to provide the data points for a load metric.
	// Use multiple metric data queries only if you are performing a math expression
	// on returned data.
	//
	// MetricDataQueries is a required field
	MetricDataQueries []*MetricDataQuery `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingCustomizedLoadMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingCustomizedLoadMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveScalingCustomizedLoadMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveScalingCustomizedLoadMetric"}
	if s.MetricDataQueries == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricDataQueries"))
	}
	if s.MetricDataQueries != nil {
		for i, v := range s.MetricDataQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDataQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricDataQueries sets the MetricDataQueries field's value.
func (s *PredictiveScalingCustomizedLoadMetric) SetMetricDataQueries(v []*MetricDataQuery) *PredictiveScalingCustomizedLoadMetric {
	s.MetricDataQueries = v
	return s
}

// Describes a custom scaling metric for a predictive scaling policy.
type PredictiveScalingCustomizedScalingMetric struct {
	_ struct{} `type:"structure"`

	// One or more metric data queries to provide the data points for a scaling
	// metric. Use multiple metric data queries only if you are performing a math
	// expression on returned data.
	//
	// MetricDataQueries is a required field
	MetricDataQueries []*MetricDataQuery `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingCustomizedScalingMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingCustomizedScalingMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveScalingCustomizedScalingMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveScalingCustomizedScalingMetric"}
	if s.MetricDataQueries == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricDataQueries"))
	}
	if s.MetricDataQueries != nil {
		for i, v := range s.MetricDataQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDataQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricDataQueries sets the MetricDataQueries field's value.
func (s *PredictiveScalingCustomizedScalingMetric) SetMetricDataQueries(v []*MetricDataQuery) *PredictiveScalingCustomizedScalingMetric {
	s.MetricDataQueries = v
	return s
}

// This structure specifies the metrics and target utilization settings for
// a predictive scaling policy.
//
// You must specify either a metric pair, or a load metric and a scaling metric
// individually. Specifying a metric pair instead of individual metrics provides
// a simpler way to configure metrics for a scaling policy. You choose the metric
// pair, and the policy automatically knows the correct sum and average statistics
// to use for the load metric and the scaling metric.
//
// Example
//
//    * You create a predictive scaling policy and specify ALBRequestCount as
//    the value for the metric pair and 1000.0 as the target value. For this
//    type of metric, you must provide the metric dimension for the corresponding
//    target group, so you also provide a resource label for the Application
//    Load Balancer target group that is attached to your Auto Scaling group.
//
//    * The number of requests the target group receives per minute provides
//    the load metric, and the request count averaged between the members of
//    the target group provides the scaling metric. In CloudWatch, this refers
//    to the RequestCount and RequestCountPerTarget metrics, respectively.
//
//    * For optimal use of predictive scaling, you adhere to the best practice
//    of using a dynamic scaling policy to automatically scale between the minimum
//    capacity and maximum capacity in response to real-time changes in resource
//    utilization.
//
//    * Amazon EC2 Auto Scaling consumes data points for the load metric over
//    the last 14 days and creates an hourly load forecast for predictive scaling.
//    (A minimum of 24 hours of data is required.)
//
//    * After creating the load forecast, Amazon EC2 Auto Scaling determines
//    when to reduce or increase the capacity of your Auto Scaling group in
//    each hour of the forecast period so that the average number of requests
//    received by each instance is as close to 1000 requests per minute as possible
//    at all times.
//
// For information about using custom metrics with predictive scaling, see Advanced
// predictive scaling policy configurations using custom metrics (https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html)
// in the Amazon EC2 Auto Scaling User Guide.
type PredictiveScalingMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The customized capacity metric specification.
	CustomizedCapacityMetricSpecification *PredictiveScalingCustomizedCapacityMetric `type:"structure"`

	// The customized load metric specification.
	CustomizedLoadMetricSpecification *PredictiveScalingCustomizedLoadMetric `type:"structure"`

	// The customized scaling metric specification.
	CustomizedScalingMetricSpecification *PredictiveScalingCustomizedScalingMetric `type:"structure"`

	// The predefined load metric specification.
	PredefinedLoadMetricSpecification *PredictiveScalingPredefinedLoadMetric `type:"structure"`

	// The predefined metric pair specification from which Amazon EC2 Auto Scaling
	// determines the appropriate scaling metric and load metric to use.
	PredefinedMetricPairSpecification *PredictiveScalingPredefinedMetricPair `type:"structure"`

	// The predefined scaling metric specification.
	PredefinedScalingMetricSpecification *PredictiveScalingPredefinedScalingMetric `type:"structure"`

	// Specifies the target utilization.
	//
	// Some metrics are based on a count instead of a percentage, such as the request
	// count for an Application Load Balancer or the number of messages in an SQS
	// queue. If the scaling policy specifies one of these metrics, specify the
	// target utilization as the optimal average request or message count per instance
	// during any one-minute interval.
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveScalingMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveScalingMetricSpecification"}
	if s.TargetValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetValue"))
	}
	if s.CustomizedCapacityMetricSpecification != nil {
		if err := s.CustomizedCapacityMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedCapacityMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomizedLoadMetricSpecification != nil {
		if err := s.CustomizedLoadMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedLoadMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomizedScalingMetricSpecification != nil {
		if err := s.CustomizedScalingMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedScalingMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedLoadMetricSpecification != nil {
		if err := s.PredefinedLoadMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedLoadMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedMetricPairSpecification != nil {
		if err := s.PredefinedMetricPairSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedMetricPairSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedScalingMetricSpecification != nil {
		if err := s.PredefinedScalingMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedScalingMetricSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizedCapacityMetricSpecification sets the CustomizedCapacityMetricSpecification field's value.
func (s *PredictiveScalingMetricSpecification) SetCustomizedCapacityMetricSpecification(v *PredictiveScalingCustomizedCapacityMetric) *PredictiveScalingMetricSpecification {
	s.CustomizedCapacityMetricSpecification = v
	return s
}

// SetCustomizedLoadMetricSpecification sets the CustomizedLoadMetricSpecification field's value.
func (s *PredictiveScalingMetricSpecification) SetCustomizedLoadMetricSpecification(v *PredictiveScalingCustomizedLoadMetric) *PredictiveScalingMetricSpecification {
	s.CustomizedLoadMetricSpecification = v
	return s
}

// SetCustomizedScalingMetricSpecification sets the CustomizedScalingMetricSpecification field's value.
func (s *PredictiveScalingMetricSpecification) SetCustomizedScalingMetricSpecification(v *PredictiveScalingCustomizedScalingMetric) *PredictiveScalingMetricSpecification {
	s.CustomizedScalingMetricSpecification = v
	return s
}

// SetPredefinedLoadMetricSpecification sets the PredefinedLoadMetricSpecification field's value.
func (s *PredictiveScalingMetricSpecification) SetPredefinedLoadMetricSpecification(v *PredictiveScalingPredefinedLoadMetric) *PredictiveScalingMetricSpecification {
	s.PredefinedLoadMetricSpecification = v
	return s
}

// SetPredefinedMetricPairSpecification sets the PredefinedMetricPairSpecification field's value.
func (s *PredictiveScalingMetricSpecification) SetPredefinedMetricPairSpecification(v *PredictiveScalingPredefinedMetricPair) *PredictiveScalingMetricSpecification {
	s.PredefinedMetricPairSpecification = v
	return s
}

// SetPredefinedScalingMetricSpecification sets the PredefinedScalingMetricSpecification field's value.
func (s *PredictiveScalingMetricSpecification) SetPredefinedScalingMetricSpecification(v *PredictiveScalingPredefinedScalingMetric) *PredictiveScalingMetricSpecification {
	s.PredefinedScalingMetricSpecification = v
	return s
}

// SetTargetValue sets the TargetValue field's value.
func (s *PredictiveScalingMetricSpecification) SetTargetValue(v float64) *PredictiveScalingMetricSpecification {
	s.TargetValue = &v
	return s
}

// Describes a load metric for a predictive scaling policy.
//
// When returned in the output of DescribePolicies, it indicates that a predictive
// scaling policy uses individually specified load and scaling metrics instead
// of a metric pair.
type PredictiveScalingPredefinedLoadMetric struct {
	_ struct{} `type:"structure"`

	// The metric type.
	//
	// PredefinedMetricType is a required field
	PredefinedMetricType *string `type:"string" required:"true" enum:"PredefinedLoadMetricType"`

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the request count served by your Auto Scaling
	// group. You can't specify a resource label unless the target group is attached
	// to the Auto Scaling group.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single
	// value, separated by a forward slash (/). The format of the resource label
	// is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	//
	// Where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingPredefinedLoadMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingPredefinedLoadMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveScalingPredefinedLoadMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveScalingPredefinedLoadMetric"}
	if s.PredefinedMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedMetricType sets the PredefinedMetricType field's value.
func (s *PredictiveScalingPredefinedLoadMetric) SetPredefinedMetricType(v string) *PredictiveScalingPredefinedLoadMetric {
	s.PredefinedMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredictiveScalingPredefinedLoadMetric) SetResourceLabel(v string) *PredictiveScalingPredefinedLoadMetric {
	s.ResourceLabel = &v
	return s
}

// Represents a metric pair for a predictive scaling policy.
type PredictiveScalingPredefinedMetricPair struct {
	_ struct{} `type:"structure"`

	// Indicates which metrics to use. There are two different types of metrics
	// for each metric type: one is a load metric and one is a scaling metric. For
	// example, if the metric type is ASGCPUUtilization, the Auto Scaling group's
	// total CPU metric is used as the load metric, and the average CPU metric is
	// used for the scaling metric.
	//
	// PredefinedMetricType is a required field
	PredefinedMetricType *string `type:"string" required:"true" enum:"PredefinedMetricPairType"`

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the total and average request count served
	// by your Auto Scaling group. You can't specify a resource label unless the
	// target group is attached to the Auto Scaling group.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single
	// value, separated by a forward slash (/). The format of the resource label
	// is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	//
	// Where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingPredefinedMetricPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingPredefinedMetricPair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveScalingPredefinedMetricPair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveScalingPredefinedMetricPair"}
	if s.PredefinedMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedMetricType sets the PredefinedMetricType field's value.
func (s *PredictiveScalingPredefinedMetricPair) SetPredefinedMetricType(v string) *PredictiveScalingPredefinedMetricPair {
	s.PredefinedMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredictiveScalingPredefinedMetricPair) SetResourceLabel(v string) *PredictiveScalingPredefinedMetricPair {
	s.ResourceLabel = &v
	return s
}

// Describes a scaling metric for a predictive scaling policy.
//
// When returned in the output of DescribePolicies, it indicates that a predictive
// scaling policy uses individually specified load and scaling metrics instead
// of a metric pair.
type PredictiveScalingPredefinedScalingMetric struct {
	_ struct{} `type:"structure"`

	// The metric type.
	//
	// PredefinedMetricType is a required field
	PredefinedMetricType *string `type:"string" required:"true" enum:"PredefinedScalingMetricType"`

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the average request count served by your Auto
	// Scaling group. You can't specify a resource label unless the target group
	// is attached to the Auto Scaling group.
	//
	// You create the resource label by appending the final portion of the load
	// balancer ARN and the final portion of the target group ARN into a single
	// value, separated by a forward slash (/). The format of the resource label
	// is:
	//
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	//
	// Where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingPredefinedScalingMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictiveScalingPredefinedScalingMetric) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictiveScalingPredefinedScalingMetric) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictiveScalingPredefinedScalingMetric"}
	if s.PredefinedMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedMetricType sets the PredefinedMetricType field's value.
func (s *PredictiveScalingPredefinedScalingMetric) SetPredefinedMetricType(v string) *PredictiveScalingPredefinedScalingMetric {
	s.PredefinedMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredictiveScalingPredefinedScalingMetric) SetResourceLabel(v string) *PredictiveScalingPredefinedScalingMetric {
	s.ResourceLabel = &v
	return s
}

// Describes a process type.
//
// For more information, see Scaling processes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types)
// in the Amazon EC2 Auto Scaling User Guide.
type ProcessType struct {
	_ struct{} `type:"structure"`

	// One of the following processes:
	//
	//    * Launch
	//
	//    * Terminate
	//
	//    * AddToLoadBalancer
	//
	//    * AlarmNotification
	//
	//    * AZRebalance
	//
	//    * HealthCheck
	//
	//    * InstanceRefresh
	//
	//    * ReplaceUnhealthy
	//
	//    * ScheduledActions
	//
	// ProcessName is a required field
	ProcessName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessType) GoString() string {
	return s.String()
}

// SetProcessName sets the ProcessName field's value.
func (s *ProcessType) SetProcessName(v string) *ProcessType {
	s.ProcessName = &v
	return s
}

type PutLifecycleHookInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. This parameter can
	// be either CONTINUE or ABANDON. The default value is ABANDON.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. The range is from 30 to 7200 seconds. The default value is 3600 seconds
	// (1 hour).
	//
	// If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action
	// that you specified in the DefaultResult parameter. You can prevent the lifecycle
	// hook from timing out by calling the RecordLifecycleActionHeartbeat API.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`

	// The instance state to which you want to attach the lifecycle hook. The valid
	// values are:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATING
	//
	// Required for new lifecycle hooks, but optional when updating existing hooks.
	LifecycleTransition *string `type:"string"`

	// Additional information that you want to include any time Amazon EC2 Auto
	// Scaling sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the notification target that Amazon EC2 Auto Scaling uses to notify
	// you when an instance is in the transition state for the lifecycle hook. This
	// target can be either an SQS queue or an SNS topic.
	//
	// If you specify an empty string, this overrides the current ARN.
	//
	// This operation uses the JSON format when sending notifications to an Amazon
	// SQS queue, and an email key-value pair format when sending notifications
	// to an Amazon SNS topic.
	//
	// When you specify a notification target, Amazon EC2 Auto Scaling sends it
	// a test message. Test messages contain the following additional key-value
	// pair: "Event": "autoscaling:TEST_NOTIFICATION".
	NotificationTargetARN *string `type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target, for example, an Amazon SNS topic or an
	// Amazon SQS queue.
	//
	// Required for new lifecycle hooks, but optional when updating existing hooks.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecycleHookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecycleHookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLifecycleHookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLifecycleHookInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}
	if s.NotificationMetadata != nil && len(*s.NotificationMetadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationMetadata", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *PutLifecycleHookInput) SetAutoScalingGroupName(v string) *PutLifecycleHookInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetDefaultResult sets the DefaultResult field's value.
func (s *PutLifecycleHookInput) SetDefaultResult(v string) *PutLifecycleHookInput {
	s.DefaultResult = &v
	return s
}

// SetHeartbeatTimeout sets the HeartbeatTimeout field's value.
func (s *PutLifecycleHookInput) SetHeartbeatTimeout(v int64) *PutLifecycleHookInput {
	s.HeartbeatTimeout = &v
	return s
}

// SetLifecycleHookName sets the LifecycleHookName field's value.
func (s *PutLifecycleHookInput) SetLifecycleHookName(v string) *PutLifecycleHookInput {
	s.LifecycleHookName = &v
	return s
}

// SetLifecycleTransition sets the LifecycleTransition field's value.
func (s *PutLifecycleHookInput) SetLifecycleTransition(v string) *PutLifecycleHookInput {
	s.LifecycleTransition = &v
	return s
}

// SetNotificationMetadata sets the NotificationMetadata field's value.
func (s *PutLifecycleHookInput) SetNotificationMetadata(v string) *PutLifecycleHookInput {
	s.NotificationMetadata = &v
	return s
}

// SetNotificationTargetARN sets the NotificationTargetARN field's value.
func (s *PutLifecycleHookInput) SetNotificationTargetARN(v string) *PutLifecycleHookInput {
	s.NotificationTargetARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *PutLifecycleHookInput) SetRoleARN(v string) *PutLifecycleHookInput {
	s.RoleARN = &v
	return s
}

type PutLifecycleHookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecycleHookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecycleHookOutput) GoString() string {
	return s.String()
}

type PutNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The type of event that causes the notification to be sent. To query the notification
	// types supported by Amazon EC2 Auto Scaling, call the DescribeAutoScalingNotificationTypes
	// API.
	//
	// NotificationTypes is a required field
	NotificationTypes []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic.
	//
	// TopicARN is a required field
	TopicARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutNotificationConfigurationInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.NotificationTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationTypes"))
	}
	if s.TopicARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicARN"))
	}
	if s.TopicARN != nil && len(*s.TopicARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *PutNotificationConfigurationInput) SetAutoScalingGroupName(v string) *PutNotificationConfigurationInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetNotificationTypes sets the NotificationTypes field's value.
func (s *PutNotificationConfigurationInput) SetNotificationTypes(v []*string) *PutNotificationConfigurationInput {
	s.NotificationTypes = v
	return s
}

// SetTopicARN sets the TopicARN field's value.
func (s *PutNotificationConfigurationInput) SetTopicARN(v string) *PutNotificationConfigurationInput {
	s.TopicARN = &v
	return s
}

type PutNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationConfigurationOutput) GoString() string {
	return s.String()
}

type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies how the scaling adjustment is interpreted (for example, an absolute
	// number or a percentage). The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	//
	// Required if the policy type is StepScaling or SimpleScaling. For more information,
	// see Scaling adjustment types (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment)
	// in the Amazon EC2 Auto Scaling User Guide.
	AdjustmentType *string `min:"1" type:"string"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The duration of the policy's cooldown period, in seconds. When a cooldown
	// period is specified here, it overrides the default cooldown period defined
	// for the Auto Scaling group.
	//
	// Valid only if the policy type is SimpleScaling. For more information, see
	// Scaling cooldowns for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	Cooldown *int64 `type:"integer"`

	// Indicates whether the scaling policy is enabled or disabled. The default
	// is enabled. For more information, see Disabling a scaling policy for an Auto
	// Scaling group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	Enabled *bool `type:"boolean"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics. If not provided, the default is to use the value
	// from the default cooldown period for the Auto Scaling group.
	//
	// Valid only if the policy type is TargetTrackingScaling or StepScaling.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. The valid values are Minimum,
	// Maximum, and Average. If the aggregation type is null, the value is treated
	// as Average.
	//
	// Valid only if the policy type is StepScaling.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
	// For example, suppose that you create a step scaling policy to scale out an
	// Auto Scaling group by 25 percent and you specify a MinAdjustmentMagnitude
	// of 2. If the group has 4 instances and the scaling policy is performed, 25
	// percent of 4 is 1. However, because you specified a MinAdjustmentMagnitude
	// of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
	//
	// Valid only if the policy type is StepScaling or SimpleScaling. For more information,
	// see Scaling adjustment types (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Some Auto Scaling groups use instance weights. In this case, set the MinAdjustmentMagnitude
	// to a value that is at least as large as your largest instance weight.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `deprecated:"true" type:"integer"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// One of the following policy types:
	//
	//    * TargetTrackingScaling
	//
	//    * StepScaling
	//
	//    * SimpleScaling (default)
	//
	//    * PredictiveScaling
	PolicyType *string `min:"1" type:"string"`

	// A predictive scaling policy. Provides support for predefined and custom metrics.
	//
	// Predefined metrics include CPU utilization, network in/out, and the Application
	// Load Balancer request count.
	//
	// For more information, see PredictiveScalingConfiguration (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html)
	// in the Amazon EC2 Auto Scaling API Reference.
	//
	// Required if the policy type is PredictiveScaling.
	PredictiveScalingConfiguration *PredictiveScalingConfiguration `type:"structure"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity. For exact capacity, you must specify a positive value.
	//
	// Required if the policy type is SimpleScaling. (Not used with any other policy
	// type.)
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	//
	// Required if the policy type is StepScaling. (Not used with any other policy
	// type.)
	StepAdjustments []*StepAdjustment `type:"list"`

	// A target tracking scaling policy. Provides support for predefined or custom
	// metrics.
	//
	// The following predefined metrics are available:
	//
	//    * ASGAverageCPUUtilization
	//
	//    * ASGAverageNetworkIn
	//
	//    * ASGAverageNetworkOut
	//
	//    * ALBRequestCountPerTarget
	//
	// If you specify ALBRequestCountPerTarget for the metric, you must specify
	// the ResourceLabel parameter with the PredefinedMetricSpecification.
	//
	// For more information, see TargetTrackingConfiguration (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html)
	// in the Amazon EC2 Auto Scaling API Reference.
	//
	// Required if the policy type is TargetTrackingScaling.
	TargetTrackingConfiguration *TargetTrackingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScalingPolicyInput"}
	if s.AdjustmentType != nil && len(*s.AdjustmentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdjustmentType", 1))
	}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.MetricAggregationType != nil && len(*s.MetricAggregationType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricAggregationType", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyType != nil && len(*s.PolicyType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyType", 1))
	}
	if s.PredictiveScalingConfiguration != nil {
		if err := s.PredictiveScalingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PredictiveScalingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StepAdjustments != nil {
		for i, v := range s.StepAdjustments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StepAdjustments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetTrackingConfiguration != nil {
		if err := s.TargetTrackingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetTrackingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdjustmentType sets the AdjustmentType field's value.
func (s *PutScalingPolicyInput) SetAdjustmentType(v string) *PutScalingPolicyInput {
	s.AdjustmentType = &v
	return s
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *PutScalingPolicyInput) SetAutoScalingGroupName(v string) *PutScalingPolicyInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetCooldown sets the Cooldown field's value.
func (s *PutScalingPolicyInput) SetCooldown(v int64) *PutScalingPolicyInput {
	s.Cooldown = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *PutScalingPolicyInput) SetEnabled(v bool) *PutScalingPolicyInput {
	s.Enabled = &v
	return s
}

// SetEstimatedInstanceWarmup sets the EstimatedInstanceWarmup field's value.
func (s *PutScalingPolicyInput) SetEstimatedInstanceWarmup(v int64) *PutScalingPolicyInput {
	s.EstimatedInstanceWarmup = &v
	return s
}

// SetMetricAggregationType sets the MetricAggregationType field's value.
func (s *PutScalingPolicyInput) SetMetricAggregationType(v string) *PutScalingPolicyInput {
	s.MetricAggregationType = &v
	return s
}

// SetMinAdjustmentMagnitude sets the MinAdjustmentMagnitude field's value.
func (s *PutScalingPolicyInput) SetMinAdjustmentMagnitude(v int64) *PutScalingPolicyInput {
	s.MinAdjustmentMagnitude = &v
	return s
}

// SetMinAdjustmentStep sets the MinAdjustmentStep field's value.
func (s *PutScalingPolicyInput) SetMinAdjustmentStep(v int64) *PutScalingPolicyInput {
	s.MinAdjustmentStep = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutScalingPolicyInput) SetPolicyName(v string) *PutScalingPolicyInput {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *PutScalingPolicyInput) SetPolicyType(v string) *PutScalingPolicyInput {
	s.PolicyType = &v
	return s
}

// SetPredictiveScalingConfiguration sets the PredictiveScalingConfiguration field's value.
func (s *PutScalingPolicyInput) SetPredictiveScalingConfiguration(v *PredictiveScalingConfiguration) *PutScalingPolicyInput {
	s.PredictiveScalingConfiguration = v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *PutScalingPolicyInput) SetScalingAdjustment(v int64) *PutScalingPolicyInput {
	s.ScalingAdjustment = &v
	return s
}

// SetStepAdjustments sets the StepAdjustments field's value.
func (s *PutScalingPolicyInput) SetStepAdjustments(v []*StepAdjustment) *PutScalingPolicyInput {
	s.StepAdjustments = v
	return s
}

// SetTargetTrackingConfiguration sets the TargetTrackingConfiguration field's value.
func (s *PutScalingPolicyInput) SetTargetTrackingConfiguration(v *TargetTrackingConfiguration) *PutScalingPolicyInput {
	s.TargetTrackingConfiguration = v
	return s
}

// Contains the output of PutScalingPolicy.
type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarms created for the target tracking scaling policy.
	Alarms []*Alarm `type:"list"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

// SetAlarms sets the Alarms field's value.
func (s *PutScalingPolicyOutput) SetAlarms(v []*Alarm) *PutScalingPolicyOutput {
	s.Alarms = v
	return s
}

// SetPolicyARN sets the PolicyARN field's value.
func (s *PutScalingPolicyOutput) SetPolicyARN(v string) *PutScalingPolicyOutput {
	s.PolicyARN = &v
	return s
}

type PutScheduledUpdateGroupActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// the scheduled action runs and the capacity it attempts to maintain. It can
	// scale beyond this capacity if you add more scaling conditions.
	DesiredCapacity *int64 `type:"integer"`

	// The date and time for the recurring schedule to end, in UTC.
	EndTime *time.Time `type:"timestamp"`

	// The maximum size of the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for this action. This format consists of five fields
	// separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year]
	// [Day_of_Week]. The value must be in quotes (for example, "30 0 1 1,6,12 *").
	// For more information about this format, see Crontab (http://crontab.org).
	//
	// When StartTime and EndTime are specified with Recurrence, they form the boundaries
	// of when the recurring action starts and stops.
	//
	// Cron expressions use Universal Coordinated Time (UTC) by default.
	Recurrence *string `min:"1" type:"string"`

	// The name of this scaling action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format
	// in UTC/GMT only and in quotes (for example, "2019-06-01T00:00:00Z").
	//
	// If you specify Recurrence and StartTime, Amazon EC2 Auto Scaling performs
	// the action at this time, and then performs the action based on the specified
	// recurrence.
	//
	// If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns
	// an error message.
	StartTime *time.Time `type:"timestamp"`

	// This parameter is no longer used.
	Time *time.Time `type:"timestamp"`

	// Specifies the time zone for a cron expression. If a time zone is not provided,
	// UTC is used by default.
	//
	// Valid values are the canonical names of the IANA time zones, derived from
	// the IANA Time Zone Database (such as Etc/GMT+9 or Pacific/Tahiti). For more
	// information, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
	// (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
	TimeZone *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScheduledUpdateGroupActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScheduledUpdateGroupActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScheduledUpdateGroupActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScheduledUpdateGroupActionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.Recurrence != nil && len(*s.Recurrence) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Recurrence", 1))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}
	if s.TimeZone != nil && len(*s.TimeZone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeZone", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *PutScheduledUpdateGroupActionInput) SetAutoScalingGroupName(v string) *PutScheduledUpdateGroupActionInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *PutScheduledUpdateGroupActionInput) SetDesiredCapacity(v int64) *PutScheduledUpdateGroupActionInput {
	s.DesiredCapacity = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *PutScheduledUpdateGroupActionInput) SetEndTime(v time.Time) *PutScheduledUpdateGroupActionInput {
	s.EndTime = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *PutScheduledUpdateGroupActionInput) SetMaxSize(v int64) *PutScheduledUpdateGroupActionInput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *PutScheduledUpdateGroupActionInput) SetMinSize(v int64) *PutScheduledUpdateGroupActionInput {
	s.MinSize = &v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *PutScheduledUpdateGroupActionInput) SetRecurrence(v string) *PutScheduledUpdateGroupActionInput {
	s.Recurrence = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *PutScheduledUpdateGroupActionInput) SetScheduledActionName(v string) *PutScheduledUpdateGroupActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PutScheduledUpdateGroupActionInput) SetStartTime(v time.Time) *PutScheduledUpdateGroupActionInput {
	s.StartTime = &v
	return s
}

// SetTime sets the Time field's value.
func (s *PutScheduledUpdateGroupActionInput) SetTime(v time.Time) *PutScheduledUpdateGroupActionInput {
	s.Time = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *PutScheduledUpdateGroupActionInput) SetTimeZone(v string) *PutScheduledUpdateGroupActionInput {
	s.TimeZone = &v
	return s
}

type PutScheduledUpdateGroupActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScheduledUpdateGroupActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutScheduledUpdateGroupActionOutput) GoString() string {
	return s.String()
}

type PutWarmPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Specifies the maximum number of instances that are allowed to be in the warm
	// pool or in any state except Terminated for the Auto Scaling group. This is
	// an optional property. Specify it only if you do not want the warm pool size
	// to be determined by the difference between the group's maximum capacity and
	// its desired capacity.
	//
	// If a value for MaxGroupPreparedCapacity is not specified, Amazon EC2 Auto
	// Scaling launches and maintains the difference between the group's maximum
	// capacity and its desired capacity. If you specify a value for MaxGroupPreparedCapacity,
	// Amazon EC2 Auto Scaling uses the difference between the MaxGroupPreparedCapacity
	// and the desired capacity instead.
	//
	// The size of the warm pool is dynamic. Only when MaxGroupPreparedCapacity
	// and MinSize are set to the same value does the warm pool have an absolute
	// size.
	//
	// If the desired capacity of the Auto Scaling group is higher than the MaxGroupPreparedCapacity,
	// the capacity of the warm pool is 0, unless you specify a value for MinSize.
	// To remove a value that you previously set, include the property but specify
	// -1 for the value.
	MaxGroupPreparedCapacity *int64 `type:"integer"`

	// Specifies the minimum number of instances to maintain in the warm pool. This
	// helps you to ensure that there is always a certain number of warmed instances
	// available to handle traffic spikes. Defaults to 0 if not specified.
	MinSize *int64 `type:"integer"`

	// Sets the instance state to transition to after the lifecycle actions are
	// complete. Default is Stopped.
	PoolState *string `type:"string" enum:"WarmPoolState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutWarmPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutWarmPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutWarmPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutWarmPoolInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.MaxGroupPreparedCapacity != nil && *s.MaxGroupPreparedCapacity < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxGroupPreparedCapacity", -1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *PutWarmPoolInput) SetAutoScalingGroupName(v string) *PutWarmPoolInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetMaxGroupPreparedCapacity sets the MaxGroupPreparedCapacity field's value.
func (s *PutWarmPoolInput) SetMaxGroupPreparedCapacity(v int64) *PutWarmPoolInput {
	s.MaxGroupPreparedCapacity = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *PutWarmPoolInput) SetMinSize(v int64) *PutWarmPoolInput {
	s.MinSize = &v
	return s
}

// SetPoolState sets the PoolState field's value.
func (s *PutWarmPoolInput) SetPoolState(v string) *PutWarmPoolInput {
	s.PoolState = &v
	return s
}

type PutWarmPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutWarmPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutWarmPoolOutput) GoString() string {
	return s.String()
}

type RecordLifecycleActionHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	InstanceId *string `min:"1" type:"string"`

	// A token that uniquely identifies a specific lifecycle action associated with
	// an instance. Amazon EC2 Auto Scaling sends this token to the notification
	// target that you specified when you created the lifecycle hook.
	LifecycleActionToken *string `min:"36" type:"string"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordLifecycleActionHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordLifecycleActionHeartbeatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordLifecycleActionHeartbeatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordLifecycleActionHeartbeatInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LifecycleActionToken != nil && len(*s.LifecycleActionToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleActionToken", 36))
	}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *RecordLifecycleActionHeartbeatInput) SetAutoScalingGroupName(v string) *RecordLifecycleActionHeartbeatInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *RecordLifecycleActionHeartbeatInput) SetInstanceId(v string) *RecordLifecycleActionHeartbeatInput {
	s.InstanceId = &v
	return s
}

// SetLifecycleActionToken sets the LifecycleActionToken field's value.
func (s *RecordLifecycleActionHeartbeatInput) SetLifecycleActionToken(v string) *RecordLifecycleActionHeartbeatInput {
	s.LifecycleActionToken = &v
	return s
}

// SetLifecycleHookName sets the LifecycleHookName field's value.
func (s *RecordLifecycleActionHeartbeatInput) SetLifecycleHookName(v string) *RecordLifecycleActionHeartbeatInput {
	s.LifecycleHookName = &v
	return s
}

type RecordLifecycleActionHeartbeatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordLifecycleActionHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordLifecycleActionHeartbeatOutput) GoString() string {
	return s.String()
}

// Describes the preferences for an instance refresh.
type RefreshPreferences struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, to wait after a checkpoint before continuing.
	// This property is optional, but if you specify a value for it, you must also
	// specify a value for CheckpointPercentages. If you specify a value for CheckpointPercentages
	// and not for CheckpointDelay, the CheckpointDelay defaults to 3600 (1 hour).
	CheckpointDelay *int64 `type:"integer"`

	// Threshold values for each checkpoint in ascending order. Each number must
	// be unique. To replace all instances in the Auto Scaling group, the last number
	// in the array must be 100.
	//
	// For usage examples, see Adding checkpoints to an instance refresh (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	CheckpointPercentages []*int64 `type:"list"`

	// The number of seconds until a newly launched instance is configured and ready
	// to use. During this time, Amazon EC2 Auto Scaling does not immediately move
	// on to the next replacement. The default is to use the value for the health
	// check grace period defined for the group.
	InstanceWarmup *int64 `type:"integer"`

	// The amount of capacity in the Auto Scaling group that must remain healthy
	// during an instance refresh to allow the operation to continue. The value
	// is expressed as a percentage of the desired capacity of the Auto Scaling
	// group (rounded up to the nearest integer). The default is 90.
	//
	// Setting the minimum healthy percentage to 100 percent limits the rate of
	// replacement to one instance at a time. In contrast, setting it to 0 percent
	// has the effect of replacing all instances at the same time.
	MinHealthyPercentage *int64 `type:"integer"`

	// A boolean value that indicates whether skip matching is enabled. If true,
	// then Amazon EC2 Auto Scaling skips replacing instances that match the desired
	// configuration. If no desired configuration is specified, then it skips replacing
	// instances that have the same configuration that is already set on the group.
	// The default is false.
	SkipMatching *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshPreferences) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshPreferences) GoString() string {
	return s.String()
}

// SetCheckpointDelay sets the CheckpointDelay field's value.
func (s *RefreshPreferences) SetCheckpointDelay(v int64) *RefreshPreferences {
	s.CheckpointDelay = &v
	return s
}

// SetCheckpointPercentages sets the CheckpointPercentages field's value.
func (s *RefreshPreferences) SetCheckpointPercentages(v []*int64) *RefreshPreferences {
	s.CheckpointPercentages = v
	return s
}

// SetInstanceWarmup sets the InstanceWarmup field's value.
func (s *RefreshPreferences) SetInstanceWarmup(v int64) *RefreshPreferences {
	s.InstanceWarmup = &v
	return s
}

// SetMinHealthyPercentage sets the MinHealthyPercentage field's value.
func (s *RefreshPreferences) SetMinHealthyPercentage(v int64) *RefreshPreferences {
	s.MinHealthyPercentage = &v
	return s
}

// SetSkipMatching sets the SkipMatching field's value.
func (s *RefreshPreferences) SetSkipMatching(v bool) *RefreshPreferences {
	s.SkipMatching = &v
	return s
}

type ResumeProcessesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeProcessesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResumeProcessesOutput) GoString() string {
	return s.String()
}

// Describes a scaling policy.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// Specifies how the scaling adjustment is interpreted (for example, an absolute
	// number or a percentage). The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`

	// The CloudWatch alarms related to the policy.
	Alarms []*Alarm `type:"list"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The duration of the policy's cooldown period, in seconds.
	Cooldown *int64 `type:"integer"`

	// Indicates whether the policy is enabled (true) or disabled (false).
	Enabled *bool `type:"boolean"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. The valid values are Minimum,
	// Maximum, and Average.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `deprecated:"true" type:"integer"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// One of the following policy types:
	//
	//    * TargetTrackingScaling
	//
	//    * StepScaling
	//
	//    * SimpleScaling (default)
	//
	//    * PredictiveScaling
	//
	// For more information, see Target tracking scaling policies (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html)
	// and Step and simple scaling policies (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	PolicyType *string `min:"1" type:"string"`

	// A predictive scaling policy.
	PredictiveScalingConfiguration *PredictiveScalingConfiguration `type:"structure"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []*StepAdjustment `type:"list"`

	// A target tracking scaling policy.
	TargetTrackingConfiguration *TargetTrackingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// SetAdjustmentType sets the AdjustmentType field's value.
func (s *ScalingPolicy) SetAdjustmentType(v string) *ScalingPolicy {
	s.AdjustmentType = &v
	return s
}

// SetAlarms sets the Alarms field's value.
func (s *ScalingPolicy) SetAlarms(v []*Alarm) *ScalingPolicy {
	s.Alarms = v
	return s
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *ScalingPolicy) SetAutoScalingGroupName(v string) *ScalingPolicy {
	s.AutoScalingGroupName = &v
	return s
}

// SetCooldown sets the Cooldown field's value.
func (s *ScalingPolicy) SetCooldown(v int64) *ScalingPolicy {
	s.Cooldown = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ScalingPolicy) SetEnabled(v bool) *ScalingPolicy {
	s.Enabled = &v
	return s
}

// SetEstimatedInstanceWarmup sets the EstimatedInstanceWarmup field's value.
func (s *ScalingPolicy) SetEstimatedInstanceWarmup(v int64) *ScalingPolicy {
	s.EstimatedInstanceWarmup = &v
	return s
}

// SetMetricAggregationType sets the MetricAggregationType field's value.
func (s *ScalingPolicy) SetMetricAggregationType(v string) *ScalingPolicy {
	s.MetricAggregationType = &v
	return s
}

// SetMinAdjustmentMagnitude sets the MinAdjustmentMagnitude field's value.
func (s *ScalingPolicy) SetMinAdjustmentMagnitude(v int64) *ScalingPolicy {
	s.MinAdjustmentMagnitude = &v
	return s
}

// SetMinAdjustmentStep sets the MinAdjustmentStep field's value.
func (s *ScalingPolicy) SetMinAdjustmentStep(v int64) *ScalingPolicy {
	s.MinAdjustmentStep = &v
	return s
}

// SetPolicyARN sets the PolicyARN field's value.
func (s *ScalingPolicy) SetPolicyARN(v string) *ScalingPolicy {
	s.PolicyARN = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ScalingPolicy) SetPolicyName(v string) *ScalingPolicy {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *ScalingPolicy) SetPolicyType(v string) *ScalingPolicy {
	s.PolicyType = &v
	return s
}

// SetPredictiveScalingConfiguration sets the PredictiveScalingConfiguration field's value.
func (s *ScalingPolicy) SetPredictiveScalingConfiguration(v *PredictiveScalingConfiguration) *ScalingPolicy {
	s.PredictiveScalingConfiguration = v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *ScalingPolicy) SetScalingAdjustment(v int64) *ScalingPolicy {
	s.ScalingAdjustment = &v
	return s
}

// SetStepAdjustments sets the StepAdjustments field's value.
func (s *ScalingPolicy) SetStepAdjustments(v []*StepAdjustment) *ScalingPolicy {
	s.StepAdjustments = v
	return s
}

// SetTargetTrackingConfiguration sets the TargetTrackingConfiguration field's value.
func (s *ScalingPolicy) SetTargetTrackingConfiguration(v *TargetTrackingConfiguration) *ScalingPolicy {
	s.TargetTrackingConfiguration = v
	return s
}

type ScalingProcessQuery struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more of the following processes:
	//
	//    * Launch
	//
	//    * Terminate
	//
	//    * AddToLoadBalancer
	//
	//    * AlarmNotification
	//
	//    * AZRebalance
	//
	//    * HealthCheck
	//
	//    * InstanceRefresh
	//
	//    * ReplaceUnhealthy
	//
	//    * ScheduledActions
	//
	// If you omit this parameter, all processes are specified.
	ScalingProcesses []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalingProcessQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScalingProcessQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingProcessQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScalingProcessQuery"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *ScalingProcessQuery) SetAutoScalingGroupName(v string) *ScalingProcessQuery {
	s.AutoScalingGroupName = &v
	return s
}

// SetScalingProcesses sets the ScalingProcesses field's value.
func (s *ScalingProcessQuery) SetScalingProcesses(v []*string) *ScalingProcessQuery {
	s.ScalingProcesses = v
	return s
}

// Describes a scheduled scaling action.
type ScheduledUpdateGroupAction struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// the scheduled action runs and the capacity it attempts to maintain.
	DesiredCapacity *int64 `type:"integer"`

	// The date and time in UTC for the recurring schedule to end. For example,
	// "2019-06-01T00:00:00Z".
	EndTime *time.Time `type:"timestamp"`

	// The maximum size of the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for the action, in Unix cron syntax format.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the boundaries
	// of when the recurring action starts and stops.
	Recurrence *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the scheduled action.
	ScheduledActionARN *string `min:"1" type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `min:"1" type:"string"`

	// The date and time in UTC for this action to start. For example, "2019-06-01T00:00:00Z".
	StartTime *time.Time `type:"timestamp"`

	// This parameter is no longer used.
	Time *time.Time `type:"timestamp"`

	// The time zone for the cron expression.
	TimeZone *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledUpdateGroupAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledUpdateGroupAction) GoString() string {
	return s.String()
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *ScheduledUpdateGroupAction) SetAutoScalingGroupName(v string) *ScheduledUpdateGroupAction {
	s.AutoScalingGroupName = &v
	return s
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *ScheduledUpdateGroupAction) SetDesiredCapacity(v int64) *ScheduledUpdateGroupAction {
	s.DesiredCapacity = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ScheduledUpdateGroupAction) SetEndTime(v time.Time) *ScheduledUpdateGroupAction {
	s.EndTime = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *ScheduledUpdateGroupAction) SetMaxSize(v int64) *ScheduledUpdateGroupAction {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *ScheduledUpdateGroupAction) SetMinSize(v int64) *ScheduledUpdateGroupAction {
	s.MinSize = &v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *ScheduledUpdateGroupAction) SetRecurrence(v string) *ScheduledUpdateGroupAction {
	s.Recurrence = &v
	return s
}

// SetScheduledActionARN sets the ScheduledActionARN field's value.
func (s *ScheduledUpdateGroupAction) SetScheduledActionARN(v string) *ScheduledUpdateGroupAction {
	s.ScheduledActionARN = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ScheduledUpdateGroupAction) SetScheduledActionName(v string) *ScheduledUpdateGroupAction {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScheduledUpdateGroupAction) SetStartTime(v time.Time) *ScheduledUpdateGroupAction {
	s.StartTime = &v
	return s
}

// SetTime sets the Time field's value.
func (s *ScheduledUpdateGroupAction) SetTime(v time.Time) *ScheduledUpdateGroupAction {
	s.Time = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *ScheduledUpdateGroupAction) SetTimeZone(v string) *ScheduledUpdateGroupAction {
	s.TimeZone = &v
	return s
}

// Describes information used for one or more scheduled scaling action updates
// in a BatchPutScheduledUpdateGroupAction operation.
type ScheduledUpdateGroupActionRequest struct {
	_ struct{} `type:"structure"`

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// the scheduled action runs and the capacity it attempts to maintain.
	DesiredCapacity *int64 `type:"integer"`

	// The date and time for the recurring schedule to end, in UTC.
	EndTime *time.Time `type:"timestamp"`

	// The maximum size of the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for the action, in Unix cron syntax format. This format
	// consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month]
	// [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example,
	// "30 0 1 1,6,12 *"). For more information about this format, see Crontab (http://crontab.org).
	//
	// When StartTime and EndTime are specified with Recurrence, they form the boundaries
	// of when the recurring action starts and stops.
	//
	// Cron expressions use Universal Coordinated Time (UTC) by default.
	Recurrence *string `min:"1" type:"string"`

	// The name of the scaling action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format
	// in UTC/GMT only and in quotes (for example, "2019-06-01T00:00:00Z").
	//
	// If you specify Recurrence and StartTime, Amazon EC2 Auto Scaling performs
	// the action at this time, and then performs the action based on the specified
	// recurrence.
	//
	// If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns
	// an error message.
	StartTime *time.Time `type:"timestamp"`

	// Specifies the time zone for a cron expression. If a time zone is not provided,
	// UTC is used by default.
	//
	// Valid values are the canonical names of the IANA time zones, derived from
	// the IANA Time Zone Database (such as Etc/GMT+9 or Pacific/Tahiti). For more
	// information, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
	// (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
	TimeZone *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledUpdateGroupActionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledUpdateGroupActionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledUpdateGroupActionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduledUpdateGroupActionRequest"}
	if s.Recurrence != nil && len(*s.Recurrence) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Recurrence", 1))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}
	if s.TimeZone != nil && len(*s.TimeZone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeZone", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *ScheduledUpdateGroupActionRequest) SetDesiredCapacity(v int64) *ScheduledUpdateGroupActionRequest {
	s.DesiredCapacity = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ScheduledUpdateGroupActionRequest) SetEndTime(v time.Time) *ScheduledUpdateGroupActionRequest {
	s.EndTime = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *ScheduledUpdateGroupActionRequest) SetMaxSize(v int64) *ScheduledUpdateGroupActionRequest {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *ScheduledUpdateGroupActionRequest) SetMinSize(v int64) *ScheduledUpdateGroupActionRequest {
	s.MinSize = &v
	return s
}

// SetRecurrence sets the Recurrence field's value.
func (s *ScheduledUpdateGroupActionRequest) SetRecurrence(v string) *ScheduledUpdateGroupActionRequest {
	s.Recurrence = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ScheduledUpdateGroupActionRequest) SetScheduledActionName(v string) *ScheduledUpdateGroupActionRequest {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScheduledUpdateGroupActionRequest) SetStartTime(v time.Time) *ScheduledUpdateGroupActionRequest {
	s.StartTime = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *ScheduledUpdateGroupActionRequest) SetTimeZone(v string) *ScheduledUpdateGroupActionRequest {
	s.TimeZone = &v
	return s
}

type SetDesiredCapacityInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// this operation completes and the capacity it attempts to maintain.
	//
	// DesiredCapacity is a required field
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to
	// complete before initiating a scaling activity to set your Auto Scaling group
	// to its new capacity. By default, Amazon EC2 Auto Scaling does not honor the
	// cooldown period during manual scaling activities.
	HonorCooldown *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDesiredCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDesiredCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDesiredCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDesiredCapacityInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.DesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *SetDesiredCapacityInput) SetAutoScalingGroupName(v string) *SetDesiredCapacityInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *SetDesiredCapacityInput) SetDesiredCapacity(v int64) *SetDesiredCapacityInput {
	s.DesiredCapacity = &v
	return s
}

// SetHonorCooldown sets the HonorCooldown field's value.
func (s *SetDesiredCapacityInput) SetHonorCooldown(v bool) *SetDesiredCapacityInput {
	s.HonorCooldown = &v
	return s
}

type SetDesiredCapacityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDesiredCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDesiredCapacityOutput) GoString() string {
	return s.String()
}

type SetInstanceHealthInput struct {
	_ struct{} `type:"structure"`

	// The health status of the instance. Set to Healthy to have the instance remain
	// in service. Set to Unhealthy to have the instance be out of service. Amazon
	// EC2 Auto Scaling terminates and replaces the unhealthy instance.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// If the Auto Scaling group of the specified instance has a HealthCheckGracePeriod
	// specified for the group, by default, this call respects the grace period.
	// Set this to False, to have the call not respect the grace period associated
	// with the group.
	//
	// For more information about the health check grace period, see CreateAutoScalingGroup
	// (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html)
	// in the Amazon EC2 Auto Scaling API Reference.
	ShouldRespectGracePeriod *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetInstanceHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetInstanceHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetInstanceHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetInstanceHealthInput"}
	if s.HealthStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthStatus"))
	}
	if s.HealthStatus != nil && len(*s.HealthStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthStatus", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *SetInstanceHealthInput) SetHealthStatus(v string) *SetInstanceHealthInput {
	s.HealthStatus = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *SetInstanceHealthInput) SetInstanceId(v string) *SetInstanceHealthInput {
	s.InstanceId = &v
	return s
}

// SetShouldRespectGracePeriod sets the ShouldRespectGracePeriod field's value.
func (s *SetInstanceHealthInput) SetShouldRespectGracePeriod(v bool) *SetInstanceHealthInput {
	s.ShouldRespectGracePeriod = &v
	return s
}

type SetInstanceHealthOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetInstanceHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetInstanceHealthOutput) GoString() string {
	return s.String()
}

type SetInstanceProtectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance IDs. You can specify up to 50 instances.
	//
	// InstanceIds is a required field
	InstanceIds []*string `type:"list" required:"true"`

	// Indicates whether the instance is protected from termination by Amazon EC2
	// Auto Scaling when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetInstanceProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetInstanceProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetInstanceProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetInstanceProtectionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}
	if s.ProtectedFromScaleIn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtectedFromScaleIn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *SetInstanceProtectionInput) SetAutoScalingGroupName(v string) *SetInstanceProtectionInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *SetInstanceProtectionInput) SetInstanceIds(v []*string) *SetInstanceProtectionInput {
	s.InstanceIds = v
	return s
}

// SetProtectedFromScaleIn sets the ProtectedFromScaleIn field's value.
func (s *SetInstanceProtectionInput) SetProtectedFromScaleIn(v bool) *SetInstanceProtectionInput {
	s.ProtectedFromScaleIn = &v
	return s
}

type SetInstanceProtectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetInstanceProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetInstanceProtectionOutput) GoString() string {
	return s.String()
}

type StartInstanceRefreshInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The desired configuration. For example, the desired configuration can specify
	// a new launch template or a new version of the current launch template.
	//
	// Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings
	// of the Auto Scaling group to reflect the new desired configuration.
	//
	// When you specify a new launch template or a new version of the current launch
	// template for your desired configuration, consider enabling the SkipMatching
	// property in preferences. If it's enabled, Amazon EC2 Auto Scaling skips replacing
	// instances that already use the specified launch template and version. This
	// can help you reduce the number of replacements that are required to apply
	// updates.
	DesiredConfiguration *DesiredConfiguration `type:"structure"`

	// Set of preferences associated with the instance refresh request. If not provided,
	// the default values are used.
	Preferences *RefreshPreferences `type:"structure"`

	// The strategy to use for the instance refresh. The only valid value is Rolling.
	//
	// A rolling update helps you update your instances gradually. A rolling update
	// can fail due to failed health checks or if instances are on standby or are
	// protected from scale in. If the rolling update process fails, any instances
	// that are replaced are not rolled back to their previous configuration.
	Strategy *string `type:"string" enum:"RefreshStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInstanceRefreshInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInstanceRefreshInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInstanceRefreshInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartInstanceRefreshInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.DesiredConfiguration != nil {
		if err := s.DesiredConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DesiredConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *StartInstanceRefreshInput) SetAutoScalingGroupName(v string) *StartInstanceRefreshInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetDesiredConfiguration sets the DesiredConfiguration field's value.
func (s *StartInstanceRefreshInput) SetDesiredConfiguration(v *DesiredConfiguration) *StartInstanceRefreshInput {
	s.DesiredConfiguration = v
	return s
}

// SetPreferences sets the Preferences field's value.
func (s *StartInstanceRefreshInput) SetPreferences(v *RefreshPreferences) *StartInstanceRefreshInput {
	s.Preferences = v
	return s
}

// SetStrategy sets the Strategy field's value.
func (s *StartInstanceRefreshInput) SetStrategy(v string) *StartInstanceRefreshInput {
	s.Strategy = &v
	return s
}

type StartInstanceRefreshOutput struct {
	_ struct{} `type:"structure"`

	// A unique ID for tracking the progress of the request.
	InstanceRefreshId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInstanceRefreshOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInstanceRefreshOutput) GoString() string {
	return s.String()
}

// SetInstanceRefreshId sets the InstanceRefreshId field's value.
func (s *StartInstanceRefreshOutput) SetInstanceRefreshId(v string) *StartInstanceRefreshOutput {
	s.InstanceRefreshId = &v
	return s
}

// Describes information used to create a step adjustment for a step scaling
// policy.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//    * To trigger the adjustment when the metric is greater than or equal to
//    50 and less than 60, specify a lower bound of 0 and an upper bound of
//    10.
//
//    * To trigger the adjustment when the metric is greater than 40 and less
//    than or equal to 50, specify a lower bound of -10 and an upper bound of
//    0.
//
// There are a few rules for the step adjustments for your step policy:
//
//    * The ranges of your step adjustments can't overlap or have a gap.
//
//    * At most, one step adjustment can have a null lower bound. If one step
//    adjustment has a negative lower bound, then there must be a step adjustment
//    with a null lower bound.
//
//    * At most, one step adjustment can have a null upper bound. If one step
//    adjustment has a positive upper bound, then there must be a step adjustment
//    with a null upper bound.
//
//    * The upper and lower bound can't be null in the same step adjustment.
//
// For more information, see Step adjustments (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-steps)
// in the Amazon EC2 Auto Scaling User Guide.
type StepAdjustment struct {
	_ struct{} `type:"structure"`

	// The lower bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the lower bound
	// is inclusive (the metric must be greater than or equal to the threshold plus
	// the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64 `type:"double"`

	// The upper bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the upper bound
	// is exclusive (the metric must be less than the threshold plus the upper bound).
	// Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64 `type:"double"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepAdjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StepAdjustment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepAdjustment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepAdjustment"}
	if s.ScalingAdjustment == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricIntervalLowerBound sets the MetricIntervalLowerBound field's value.
func (s *StepAdjustment) SetMetricIntervalLowerBound(v float64) *StepAdjustment {
	s.MetricIntervalLowerBound = &v
	return s
}

// SetMetricIntervalUpperBound sets the MetricIntervalUpperBound field's value.
func (s *StepAdjustment) SetMetricIntervalUpperBound(v float64) *StepAdjustment {
	s.MetricIntervalUpperBound = &v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *StepAdjustment) SetScalingAdjustment(v int64) *StepAdjustment {
	s.ScalingAdjustment = &v
	return s
}

type SuspendProcessesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuspendProcessesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuspendProcessesOutput) GoString() string {
	return s.String()
}

// Describes an auto scaling process that has been suspended.
//
// For more information, see Scaling processes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types)
// in the Amazon EC2 Auto Scaling User Guide.
type SuspendedProcess struct {
	_ struct{} `type:"structure"`

	// The name of the suspended process.
	ProcessName *string `min:"1" type:"string"`

	// The reason that the process was suspended.
	SuspensionReason *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuspendedProcess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuspendedProcess) GoString() string {
	return s.String()
}

// SetProcessName sets the ProcessName field's value.
func (s *SuspendedProcess) SetProcessName(v string) *SuspendedProcess {
	s.ProcessName = &v
	return s
}

// SetSuspensionReason sets the SuspensionReason field's value.
func (s *SuspendedProcess) SetSuspensionReason(v string) *SuspendedProcess {
	s.SuspensionReason = &v
	return s
}

// Describes a tag for an Auto Scaling group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the Auto Scaling group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetPropagateAtLaunch sets the PropagateAtLaunch field's value.
func (s *Tag) SetPropagateAtLaunch(v bool) *Tag {
	s.PropagateAtLaunch = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Tag) SetResourceId(v string) *Tag {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Tag) SetResourceType(v string) *Tag {
	s.ResourceType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Describes a tag for an Auto Scaling group.
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `min:"1" type:"string"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagDescription) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagDescription) SetKey(v string) *TagDescription {
	s.Key = &v
	return s
}

// SetPropagateAtLaunch sets the PropagateAtLaunch field's value.
func (s *TagDescription) SetPropagateAtLaunch(v bool) *TagDescription {
	s.PropagateAtLaunch = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *TagDescription) SetResourceId(v string) *TagDescription {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TagDescription) SetResourceType(v string) *TagDescription {
	s.ResourceType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagDescription) SetValue(v string) *TagDescription {
	s.Value = &v
	return s
}

// Represents a target tracking scaling policy configuration to use with Amazon
// EC2 Auto Scaling.
type TargetTrackingConfiguration struct {
	_ struct{} `type:"structure"`

	// A customized metric. You must specify either a predefined metric or a customized
	// metric.
	CustomizedMetricSpecification *CustomizedMetricSpecification `type:"structure"`

	// Indicates whether scaling in by the target tracking scaling policy is disabled.
	// If scaling in is disabled, the target tracking scaling policy doesn't remove
	// instances from the Auto Scaling group. Otherwise, the target tracking scaling
	// policy can remove instances from the Auto Scaling group. The default is false.
	DisableScaleIn *bool `type:"boolean"`

	// A predefined metric. You must specify either a predefined metric or a customized
	// metric.
	PredefinedMetricSpecification *PredefinedMetricSpecification `type:"structure"`

	// The target value for the metric.
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetTrackingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingConfiguration"}
	if s.TargetValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetValue"))
	}
	if s.CustomizedMetricSpecification != nil {
		if err := s.CustomizedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedMetricSpecification != nil {
		if err := s.PredefinedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedMetricSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizedMetricSpecification sets the CustomizedMetricSpecification field's value.
func (s *TargetTrackingConfiguration) SetCustomizedMetricSpecification(v *CustomizedMetricSpecification) *TargetTrackingConfiguration {
	s.CustomizedMetricSpecification = v
	return s
}

// SetDisableScaleIn sets the DisableScaleIn field's value.
func (s *TargetTrackingConfiguration) SetDisableScaleIn(v bool) *TargetTrackingConfiguration {
	s.DisableScaleIn = &v
	return s
}

// SetPredefinedMetricSpecification sets the PredefinedMetricSpecification field's value.
func (s *TargetTrackingConfiguration) SetPredefinedMetricSpecification(v *PredefinedMetricSpecification) *TargetTrackingConfiguration {
	s.PredefinedMetricSpecification = v
	return s
}

// SetTargetValue sets the TargetValue field's value.
func (s *TargetTrackingConfiguration) SetTargetValue(v float64) *TargetTrackingConfiguration {
	s.TargetValue = &v
	return s
}

type TerminateInstanceInAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// Indicates whether terminating the instance also decrements the size of the
	// Auto Scaling group.
	//
	// ShouldDecrementDesiredCapacity is a required field
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateInstanceInAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateInstanceInAutoScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateInstanceInAutoScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateInstanceInAutoScalingGroupInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.ShouldDecrementDesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ShouldDecrementDesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *TerminateInstanceInAutoScalingGroupInput) SetInstanceId(v string) *TerminateInstanceInAutoScalingGroupInput {
	s.InstanceId = &v
	return s
}

// SetShouldDecrementDesiredCapacity sets the ShouldDecrementDesiredCapacity field's value.
func (s *TerminateInstanceInAutoScalingGroupInput) SetShouldDecrementDesiredCapacity(v bool) *TerminateInstanceInAutoScalingGroupInput {
	s.ShouldDecrementDesiredCapacity = &v
	return s
}

type TerminateInstanceInAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`

	// A scaling activity.
	Activity *Activity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateInstanceInAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateInstanceInAutoScalingGroupOutput) GoString() string {
	return s.String()
}

// SetActivity sets the Activity field's value.
func (s *TerminateInstanceInAutoScalingGroupOutput) SetActivity(v *Activity) *TerminateInstanceInAutoScalingGroupOutput {
	s.Activity = v
	return s
}

// Specifies the minimum and maximum for the TotalLocalStorageGB object when
// you specify InstanceRequirements for an Auto Scaling group.
type TotalLocalStorageGBRequest struct {
	_ struct{} `type:"structure"`

	// The storage maximum in GB.
	Max *float64 `type:"double"`

	// The storage minimum in GB.
	Min *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TotalLocalStorageGBRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TotalLocalStorageGBRequest) GoString() string {
	return s.String()
}

// SetMax sets the Max field's value.
func (s *TotalLocalStorageGBRequest) SetMax(v float64) *TotalLocalStorageGBRequest {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *TotalLocalStorageGBRequest) SetMin(v float64) *TotalLocalStorageGBRequest {
	s.Min = &v
	return s
}

type UpdateAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group.
	AvailabilityZones []*string `type:"list"`

	// Enables or disables Capacity Rebalancing. For more information, see Amazon
	// EC2 Auto Scaling Capacity Rebalancing (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	CapacityRebalance *bool `type:"boolean"`

	// Reserved.
	Context *string `type:"string"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start. The default value is 300. This setting
	// applies when using simple scaling policies, but not when using other scaling
	// policies or scheduled scaling. For more information, see Scaling cooldowns
	// for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DefaultCooldown *int64 `type:"integer"`

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// this operation completes and the capacity it attempts to maintain. This number
	// must be greater than or equal to the minimum size of the group and less than
	// or equal to the maximum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The unit of measurement for the value specified for desired capacity. Amazon
	// EC2 Auto Scaling supports DesiredCapacityType for attribute-based instance
	// type selection only. For more information, see Creating an Auto Scaling group
	// using attribute-based instance type selection (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// By default, Amazon EC2 Auto Scaling specifies units, which translates into
	// number of instances.
	//
	// Valid values: units | vcpu | memory-mib
	DesiredCapacityType *string `min:"1" type:"string"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// checking the health status of an EC2 instance that has come into service
	// and marking it unhealthy due to a failed health check. The default value
	// is 0. For more information, see Health check grace period (https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Conditional: Required if you are adding an ELB health check.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	// If you configure an Auto Scaling group to use ELB health checks, it considers
	// the instance unhealthy if it fails either the EC2 status checks or the load
	// balancer health checks.
	HealthCheckType *string `min:"1" type:"string"`

	// The name of the launch configuration. If you specify LaunchConfigurationName
	// in your update request, you can't specify LaunchTemplate or MixedInstancesPolicy.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template and version to use to specify the updates. If you specify
	// LaunchTemplate in your update request, you can't specify LaunchConfigurationName
	// or MixedInstancesPolicy.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// The maximum amount of time, in seconds, that an instance can be in service.
	// The default is null. If specified, the value must be either 0 or a number
	// equal to or greater than 86,400 seconds (1 day). To clear a previously set
	// value, specify a new value of 0. For more information, see Replacing Auto
	// Scaling instances based on maximum instance lifetime (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	MaxInstanceLifetime *int64 `type:"integer"`

	// The maximum size of the Auto Scaling group.
	//
	// With a mixed instances policy that uses instance weighting, Amazon EC2 Auto
	// Scaling may need to go above MaxSize to meet your capacity requirements.
	// In this event, Amazon EC2 Auto Scaling will never go above MaxSize by more
	// than your largest instance weight (weights that define how many units each
	// instance contributes to the desired capacity of the group).
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// An embedded object that specifies a mixed instances policy. For more information,
	// see Auto Scaling groups with multiple instance types and purchase options
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	MixedInstancesPolicy *MixedInstancesPolicy `type:"structure"`

	// Indicates whether newly launched instances are protected from termination
	// by Amazon EC2 Auto Scaling when scaling in. For more information about preventing
	// instances from terminating on scale in, see Using instance scale-in protection
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of an existing placement group into which to launch your instances,
	// if any. A placement group is a logical grouping of instances within a single
	// Availability Zone. You cannot specify multiple Availability Zones and a placement
	// group. For more information, see Placement Groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	PlacementGroup *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling
	// group uses to call other Amazon Web Services on your behalf. For more information,
	// see Service-linked roles (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	ServiceLinkedRoleARN *string `min:"1" type:"string"`

	// A policy or a list of policies that are used to select the instances to terminate.
	// The policies are executed in the order that you list them. For more information,
	// see Controlling which Auto Scaling instances terminate during scale in (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	TerminationPolicies []*string `type:"list"`

	// A comma-separated list of subnet IDs for a virtual private cloud (VPC). If
	// you specify VPCZoneIdentifier with AvailabilityZones, the subnets that you
	// specify for this parameter must reside in those Availability Zones.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAutoScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAutoScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAutoScalingGroupInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.DesiredCapacityType != nil && len(*s.DesiredCapacityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesiredCapacityType", 1))
	}
	if s.HealthCheckType != nil && len(*s.HealthCheckType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckType", 1))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationName", 1))
	}
	if s.PlacementGroup != nil && len(*s.PlacementGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementGroup", 1))
	}
	if s.ServiceLinkedRoleARN != nil && len(*s.ServiceLinkedRoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceLinkedRoleARN", 1))
	}
	if s.VPCZoneIdentifier != nil && len(*s.VPCZoneIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCZoneIdentifier", 1))
	}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(request.ErrInvalidParams))
		}
	}
	if s.MixedInstancesPolicy != nil {
		if err := s.MixedInstancesPolicy.Validate(); err != nil {
			invalidParams.AddNested("MixedInstancesPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *UpdateAutoScalingGroupInput) SetAutoScalingGroupName(v string) *UpdateAutoScalingGroupInput {
	s.AutoScalingGroupName = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *UpdateAutoScalingGroupInput) SetAvailabilityZones(v []*string) *UpdateAutoScalingGroupInput {
	s.AvailabilityZones = v
	return s
}

// SetCapacityRebalance sets the CapacityRebalance field's value.
func (s *UpdateAutoScalingGroupInput) SetCapacityRebalance(v bool) *UpdateAutoScalingGroupInput {
	s.CapacityRebalance = &v
	return s
}

// SetContext sets the Context field's value.
func (s *UpdateAutoScalingGroupInput) SetContext(v string) *UpdateAutoScalingGroupInput {
	s.Context = &v
	return s
}

// SetDefaultCooldown sets the DefaultCooldown field's value.
func (s *UpdateAutoScalingGroupInput) SetDefaultCooldown(v int64) *UpdateAutoScalingGroupInput {
	s.DefaultCooldown = &v
	return s
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *UpdateAutoScalingGroupInput) SetDesiredCapacity(v int64) *UpdateAutoScalingGroupInput {
	s.DesiredCapacity = &v
	return s
}

// SetDesiredCapacityType sets the DesiredCapacityType field's value.
func (s *UpdateAutoScalingGroupInput) SetDesiredCapacityType(v string) *UpdateAutoScalingGroupInput {
	s.DesiredCapacityType = &v
	return s
}

// SetHealthCheckGracePeriod sets the HealthCheckGracePeriod field's value.
func (s *UpdateAutoScalingGroupInput) SetHealthCheckGracePeriod(v int64) *UpdateAutoScalingGroupInput {
	s.HealthCheckGracePeriod = &v
	return s
}

// SetHealthCheckType sets the HealthCheckType field's value.
func (s *UpdateAutoScalingGroupInput) SetHealthCheckType(v string) *UpdateAutoScalingGroupInput {
	s.HealthCheckType = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *UpdateAutoScalingGroupInput) SetLaunchConfigurationName(v string) *UpdateAutoScalingGroupInput {
	s.LaunchConfigurationName = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *UpdateAutoScalingGroupInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *UpdateAutoScalingGroupInput {
	s.LaunchTemplate = v
	return s
}

// SetMaxInstanceLifetime sets the MaxInstanceLifetime field's value.
func (s *UpdateAutoScalingGroupInput) SetMaxInstanceLifetime(v int64) *UpdateAutoScalingGroupInput {
	s.MaxInstanceLifetime = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *UpdateAutoScalingGroupInput) SetMaxSize(v int64) *UpdateAutoScalingGroupInput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *UpdateAutoScalingGroupInput) SetMinSize(v int64) *UpdateAutoScalingGroupInput {
	s.MinSize = &v
	return s
}

// SetMixedInstancesPolicy sets the MixedInstancesPolicy field's value.
func (s *UpdateAutoScalingGroupInput) SetMixedInstancesPolicy(v *MixedInstancesPolicy) *UpdateAutoScalingGroupInput {
	s.MixedInstancesPolicy = v
	return s
}

// SetNewInstancesProtectedFromScaleIn sets the NewInstancesProtectedFromScaleIn field's value.
func (s *UpdateAutoScalingGroupInput) SetNewInstancesProtectedFromScaleIn(v bool) *UpdateAutoScalingGroupInput {
	s.NewInstancesProtectedFromScaleIn = &v
	return s
}

// SetPlacementGroup sets the PlacementGroup field's value.
func (s *UpdateAutoScalingGroupInput) SetPlacementGroup(v string) *UpdateAutoScalingGroupInput {
	s.PlacementGroup = &v
	return s
}

// SetServiceLinkedRoleARN sets the ServiceLinkedRoleARN field's value.
func (s *UpdateAutoScalingGroupInput) SetServiceLinkedRoleARN(v string) *UpdateAutoScalingGroupInput {
	s.ServiceLinkedRoleARN = &v
	return s
}

// SetTerminationPolicies sets the TerminationPolicies field's value.
func (s *UpdateAutoScalingGroupInput) SetTerminationPolicies(v []*string) *UpdateAutoScalingGroupInput {
	s.TerminationPolicies = v
	return s
}

// SetVPCZoneIdentifier sets the VPCZoneIdentifier field's value.
func (s *UpdateAutoScalingGroupInput) SetVPCZoneIdentifier(v string) *UpdateAutoScalingGroupInput {
	s.VPCZoneIdentifier = &v
	return s
}

type UpdateAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAutoScalingGroupOutput) GoString() string {
	return s.String()
}

// Specifies the minimum and maximum for the VCpuCount object when you specify
// InstanceRequirements for an Auto Scaling group.
type VCpuCountRequest struct {
	_ struct{} `type:"structure"`

	// The maximum number of vCPUs.
	Max *int64 `type:"integer"`

	// The minimum number of vCPUs.
	//
	// Min is a required field
	Min *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VCpuCountRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VCpuCountRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VCpuCountRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VCpuCountRequest"}
	if s.Min == nil {
		invalidParams.Add(request.NewErrParamRequired("Min"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMax sets the Max field's value.
func (s *VCpuCountRequest) SetMax(v int64) *VCpuCountRequest {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *VCpuCountRequest) SetMin(v int64) *VCpuCountRequest {
	s.Min = &v
	return s
}

// Describes a warm pool configuration.
type WarmPoolConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of instances that are allowed to be in the warm pool or
	// in any state except Terminated for the Auto Scaling group.
	MaxGroupPreparedCapacity *int64 `type:"integer"`

	// The minimum number of instances to maintain in the warm pool.
	MinSize *int64 `type:"integer"`

	// The instance state to transition to after the lifecycle actions are complete.
	PoolState *string `type:"string" enum:"WarmPoolState"`

	// The status of a warm pool that is marked for deletion.
	Status *string `type:"string" enum:"WarmPoolStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WarmPoolConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WarmPoolConfiguration) GoString() string {
	return s.String()
}

// SetMaxGroupPreparedCapacity sets the MaxGroupPreparedCapacity field's value.
func (s *WarmPoolConfiguration) SetMaxGroupPreparedCapacity(v int64) *WarmPoolConfiguration {
	s.MaxGroupPreparedCapacity = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *WarmPoolConfiguration) SetMinSize(v int64) *WarmPoolConfiguration {
	s.MinSize = &v
	return s
}

// SetPoolState sets the PoolState field's value.
func (s *WarmPoolConfiguration) SetPoolState(v string) *WarmPoolConfiguration {
	s.PoolState = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WarmPoolConfiguration) SetStatus(v string) *WarmPoolConfiguration {
	s.Status = &v
	return s
}

const (
	// AcceleratorManufacturerNvidia is a AcceleratorManufacturer enum value
	AcceleratorManufacturerNvidia = "nvidia"

	// AcceleratorManufacturerAmd is a AcceleratorManufacturer enum value
	AcceleratorManufacturerAmd = "amd"

	// AcceleratorManufacturerAmazonWebServices is a AcceleratorManufacturer enum value
	AcceleratorManufacturerAmazonWebServices = "amazon-web-services"

	// AcceleratorManufacturerXilinx is a AcceleratorManufacturer enum value
	AcceleratorManufacturerXilinx = "xilinx"
)

// AcceleratorManufacturer_Values returns all elements of the AcceleratorManufacturer enum
func AcceleratorManufacturer_Values() []string {
	return []string{
		AcceleratorManufacturerNvidia,
		AcceleratorManufacturerAmd,
		AcceleratorManufacturerAmazonWebServices,
		AcceleratorManufacturerXilinx,
	}
}

const (
	// AcceleratorNameA100 is a AcceleratorName enum value
	AcceleratorNameA100 = "a100"

	// AcceleratorNameV100 is a AcceleratorName enum value
	AcceleratorNameV100 = "v100"

	// AcceleratorNameK80 is a AcceleratorName enum value
	AcceleratorNameK80 = "k80"

	// AcceleratorNameT4 is a AcceleratorName enum value
	AcceleratorNameT4 = "t4"

	// AcceleratorNameM60 is a AcceleratorName enum value
	AcceleratorNameM60 = "m60"

	// AcceleratorNameRadeonProV520 is a AcceleratorName enum value
	AcceleratorNameRadeonProV520 = "radeon-pro-v520"

	// AcceleratorNameVu9p is a AcceleratorName enum value
	AcceleratorNameVu9p = "vu9p"
)

// AcceleratorName_Values returns all elements of the AcceleratorName enum
func AcceleratorName_Values() []string {
	return []string{
		AcceleratorNameA100,
		AcceleratorNameV100,
		AcceleratorNameK80,
		AcceleratorNameT4,
		AcceleratorNameM60,
		AcceleratorNameRadeonProV520,
		AcceleratorNameVu9p,
	}
}

const (
	// AcceleratorTypeGpu is a AcceleratorType enum value
	AcceleratorTypeGpu = "gpu"

	// AcceleratorTypeFpga is a AcceleratorType enum value
	AcceleratorTypeFpga = "fpga"

	// AcceleratorTypeInference is a AcceleratorType enum value
	AcceleratorTypeInference = "inference"
)

// AcceleratorType_Values returns all elements of the AcceleratorType enum
func AcceleratorType_Values() []string {
	return []string{
		AcceleratorTypeGpu,
		AcceleratorTypeFpga,
		AcceleratorTypeInference,
	}
}

const (
	// BareMetalIncluded is a BareMetal enum value
	BareMetalIncluded = "included"

	// BareMetalExcluded is a BareMetal enum value
	BareMetalExcluded = "excluded"

	// BareMetalRequired is a BareMetal enum value
	BareMetalRequired = "required"
)

// BareMetal_Values returns all elements of the BareMetal enum
func BareMetal_Values() []string {
	return []string{
		BareMetalIncluded,
		BareMetalExcluded,
		BareMetalRequired,
	}
}

const (
	// BurstablePerformanceIncluded is a BurstablePerformance enum value
	BurstablePerformanceIncluded = "included"

	// BurstablePerformanceExcluded is a BurstablePerformance enum value
	BurstablePerformanceExcluded = "excluded"

	// BurstablePerformanceRequired is a BurstablePerformance enum value
	BurstablePerformanceRequired = "required"
)

// BurstablePerformance_Values returns all elements of the BurstablePerformance enum
func BurstablePerformance_Values() []string {
	return []string{
		BurstablePerformanceIncluded,
		BurstablePerformanceExcluded,
		BurstablePerformanceRequired,
	}
}

const (
	// CpuManufacturerIntel is a CpuManufacturer enum value
	CpuManufacturerIntel = "intel"

	// CpuManufacturerAmd is a CpuManufacturer enum value
	CpuManufacturerAmd = "amd"

	// CpuManufacturerAmazonWebServices is a CpuManufacturer enum value
	CpuManufacturerAmazonWebServices = "amazon-web-services"
)

// CpuManufacturer_Values returns all elements of the CpuManufacturer enum
func CpuManufacturer_Values() []string {
	return []string{
		CpuManufacturerIntel,
		CpuManufacturerAmd,
		CpuManufacturerAmazonWebServices,
	}
}

const (
	// InstanceGenerationCurrent is a InstanceGeneration enum value
	InstanceGenerationCurrent = "current"

	// InstanceGenerationPrevious is a InstanceGeneration enum value
	InstanceGenerationPrevious = "previous"
)

// InstanceGeneration_Values returns all elements of the InstanceGeneration enum
func InstanceGeneration_Values() []string {
	return []string{
		InstanceGenerationCurrent,
		InstanceGenerationPrevious,
	}
}

const (
	// InstanceMetadataEndpointStateDisabled is a InstanceMetadataEndpointState enum value
	InstanceMetadataEndpointStateDisabled = "disabled"

	// InstanceMetadataEndpointStateEnabled is a InstanceMetadataEndpointState enum value
	InstanceMetadataEndpointStateEnabled = "enabled"
)

// InstanceMetadataEndpointState_Values returns all elements of the InstanceMetadataEndpointState enum
func InstanceMetadataEndpointState_Values() []string {
	return []string{
		InstanceMetadataEndpointStateDisabled,
		InstanceMetadataEndpointStateEnabled,
	}
}

const (
	// InstanceMetadataHttpTokensStateOptional is a InstanceMetadataHttpTokensState enum value
	InstanceMetadataHttpTokensStateOptional = "optional"

	// InstanceMetadataHttpTokensStateRequired is a InstanceMetadataHttpTokensState enum value
	InstanceMetadataHttpTokensStateRequired = "required"
)

// InstanceMetadataHttpTokensState_Values returns all elements of the InstanceMetadataHttpTokensState enum
func InstanceMetadataHttpTokensState_Values() []string {
	return []string{
		InstanceMetadataHttpTokensStateOptional,
		InstanceMetadataHttpTokensStateRequired,
	}
}

const (
	// InstanceRefreshStatusPending is a InstanceRefreshStatus enum value
	InstanceRefreshStatusPending = "Pending"

	// InstanceRefreshStatusInProgress is a InstanceRefreshStatus enum value
	InstanceRefreshStatusInProgress = "InProgress"

	// InstanceRefreshStatusSuccessful is a InstanceRefreshStatus enum value
	InstanceRefreshStatusSuccessful = "Successful"

	// InstanceRefreshStatusFailed is a InstanceRefreshStatus enum value
	InstanceRefreshStatusFailed = "Failed"

	// InstanceRefreshStatusCancelling is a InstanceRefreshStatus enum value
	InstanceRefreshStatusCancelling = "Cancelling"

	// InstanceRefreshStatusCancelled is a InstanceRefreshStatus enum value
	InstanceRefreshStatusCancelled = "Cancelled"
)

// InstanceRefreshStatus_Values returns all elements of the InstanceRefreshStatus enum
func InstanceRefreshStatus_Values() []string {
	return []string{
		InstanceRefreshStatusPending,
		InstanceRefreshStatusInProgress,
		InstanceRefreshStatusSuccessful,
		InstanceRefreshStatusFailed,
		InstanceRefreshStatusCancelling,
		InstanceRefreshStatusCancelled,
	}
}

const (
	// LifecycleStatePending is a LifecycleState enum value
	LifecycleStatePending = "Pending"

	// LifecycleStatePendingWait is a LifecycleState enum value
	LifecycleStatePendingWait = "Pending:Wait"

	// LifecycleStatePendingProceed is a LifecycleState enum value
	LifecycleStatePendingProceed = "Pending:Proceed"

	// LifecycleStateQuarantined is a LifecycleState enum value
	LifecycleStateQuarantined = "Quarantined"

	// LifecycleStateInService is a LifecycleState enum value
	LifecycleStateInService = "InService"

	// LifecycleStateTerminating is a LifecycleState enum value
	LifecycleStateTerminating = "Terminating"

	// LifecycleStateTerminatingWait is a LifecycleState enum value
	LifecycleStateTerminatingWait = "Terminating:Wait"

	// LifecycleStateTerminatingProceed is a LifecycleState enum value
	LifecycleStateTerminatingProceed = "Terminating:Proceed"

	// LifecycleStateTerminated is a LifecycleState enum value
	LifecycleStateTerminated = "Terminated"

	// LifecycleStateDetaching is a LifecycleState enum value
	LifecycleStateDetaching = "Detaching"

	// LifecycleStateDetached is a LifecycleState enum value
	LifecycleStateDetached = "Detached"

	// LifecycleStateEnteringStandby is a LifecycleState enum value
	LifecycleStateEnteringStandby = "EnteringStandby"

	// LifecycleStateStandby is a LifecycleState enum value
	LifecycleStateStandby = "Standby"

	// LifecycleStateWarmedPending is a LifecycleState enum value
	LifecycleStateWarmedPending = "Warmed:Pending"

	// LifecycleStateWarmedPendingWait is a LifecycleState enum value
	LifecycleStateWarmedPendingWait = "Warmed:Pending:Wait"

	// LifecycleStateWarmedPendingProceed is a LifecycleState enum value
	LifecycleStateWarmedPendingProceed = "Warmed:Pending:Proceed"

	// LifecycleStateWarmedTerminating is a LifecycleState enum value
	LifecycleStateWarmedTerminating = "Warmed:Terminating"

	// LifecycleStateWarmedTerminatingWait is a LifecycleState enum value
	LifecycleStateWarmedTerminatingWait = "Warmed:Terminating:Wait"

	// LifecycleStateWarmedTerminatingProceed is a LifecycleState enum value
	LifecycleStateWarmedTerminatingProceed = "Warmed:Terminating:Proceed"

	// LifecycleStateWarmedTerminated is a LifecycleState enum value
	LifecycleStateWarmedTerminated = "Warmed:Terminated"

	// LifecycleStateWarmedStopped is a LifecycleState enum value
	LifecycleStateWarmedStopped = "Warmed:Stopped"

	// LifecycleStateWarmedRunning is a LifecycleState enum value
	LifecycleStateWarmedRunning = "Warmed:Running"
)

// LifecycleState_Values returns all elements of the LifecycleState enum
func LifecycleState_Values() []string {
	return []string{
		LifecycleStatePending,
		LifecycleStatePendingWait,
		LifecycleStatePendingProceed,
		LifecycleStateQuarantined,
		LifecycleStateInService,
		LifecycleStateTerminating,
		LifecycleStateTerminatingWait,
		LifecycleStateTerminatingProceed,
		LifecycleStateTerminated,
		LifecycleStateDetaching,
		LifecycleStateDetached,
		LifecycleStateEnteringStandby,
		LifecycleStateStandby,
		LifecycleStateWarmedPending,
		LifecycleStateWarmedPendingWait,
		LifecycleStateWarmedPendingProceed,
		LifecycleStateWarmedTerminating,
		LifecycleStateWarmedTerminatingWait,
		LifecycleStateWarmedTerminatingProceed,
		LifecycleStateWarmedTerminated,
		LifecycleStateWarmedStopped,
		LifecycleStateWarmedRunning,
	}
}

const (
	// LocalStorageIncluded is a LocalStorage enum value
	LocalStorageIncluded = "included"

	// LocalStorageExcluded is a LocalStorage enum value
	LocalStorageExcluded = "excluded"

	// LocalStorageRequired is a LocalStorage enum value
	LocalStorageRequired = "required"
)

// LocalStorage_Values returns all elements of the LocalStorage enum
func LocalStorage_Values() []string {
	return []string{
		LocalStorageIncluded,
		LocalStorageExcluded,
		LocalStorageRequired,
	}
}

const (
	// LocalStorageTypeHdd is a LocalStorageType enum value
	LocalStorageTypeHdd = "hdd"

	// LocalStorageTypeSsd is a LocalStorageType enum value
	LocalStorageTypeSsd = "ssd"
)

// LocalStorageType_Values returns all elements of the LocalStorageType enum
func LocalStorageType_Values() []string {
	return []string{
		LocalStorageTypeHdd,
		LocalStorageTypeSsd,
	}
}

const (
	// MetricStatisticAverage is a MetricStatistic enum value
	MetricStatisticAverage = "Average"

	// MetricStatisticMinimum is a MetricStatistic enum value
	MetricStatisticMinimum = "Minimum"

	// MetricStatisticMaximum is a MetricStatistic enum value
	MetricStatisticMaximum = "Maximum"

	// MetricStatisticSampleCount is a MetricStatistic enum value
	MetricStatisticSampleCount = "SampleCount"

	// MetricStatisticSum is a MetricStatistic enum value
	MetricStatisticSum = "Sum"
)

// MetricStatistic_Values returns all elements of the MetricStatistic enum
func MetricStatistic_Values() []string {
	return []string{
		MetricStatisticAverage,
		MetricStatisticMinimum,
		MetricStatisticMaximum,
		MetricStatisticSampleCount,
		MetricStatisticSum,
	}
}

const (
	// MetricTypeAsgaverageCpuutilization is a MetricType enum value
	MetricTypeAsgaverageCpuutilization = "ASGAverageCPUUtilization"

	// MetricTypeAsgaverageNetworkIn is a MetricType enum value
	MetricTypeAsgaverageNetworkIn = "ASGAverageNetworkIn"

	// MetricTypeAsgaverageNetworkOut is a MetricType enum value
	MetricTypeAsgaverageNetworkOut = "ASGAverageNetworkOut"

	// MetricTypeAlbrequestCountPerTarget is a MetricType enum value
	MetricTypeAlbrequestCountPerTarget = "ALBRequestCountPerTarget"
)

// MetricType_Values returns all elements of the MetricType enum
func MetricType_Values() []string {
	return []string{
		MetricTypeAsgaverageCpuutilization,
		MetricTypeAsgaverageNetworkIn,
		MetricTypeAsgaverageNetworkOut,
		MetricTypeAlbrequestCountPerTarget,
	}
}

const (
	// PredefinedLoadMetricTypeAsgtotalCpuutilization is a PredefinedLoadMetricType enum value
	PredefinedLoadMetricTypeAsgtotalCpuutilization = "ASGTotalCPUUtilization"

	// PredefinedLoadMetricTypeAsgtotalNetworkIn is a PredefinedLoadMetricType enum value
	PredefinedLoadMetricTypeAsgtotalNetworkIn = "ASGTotalNetworkIn"

	// PredefinedLoadMetricTypeAsgtotalNetworkOut is a PredefinedLoadMetricType enum value
	PredefinedLoadMetricTypeAsgtotalNetworkOut = "ASGTotalNetworkOut"

	// PredefinedLoadMetricTypeAlbtargetGroupRequestCount is a PredefinedLoadMetricType enum value
	PredefinedLoadMetricTypeAlbtargetGroupRequestCount = "ALBTargetGroupRequestCount"
)

// PredefinedLoadMetricType_Values returns all elements of the PredefinedLoadMetricType enum
func PredefinedLoadMetricType_Values() []string {
	return []string{
		PredefinedLoadMetricTypeAsgtotalCpuutilization,
		PredefinedLoadMetricTypeAsgtotalNetworkIn,
		PredefinedLoadMetricTypeAsgtotalNetworkOut,
		PredefinedLoadMetricTypeAlbtargetGroupRequestCount,
	}
}

const (
	// PredefinedMetricPairTypeAsgcpuutilization is a PredefinedMetricPairType enum value
	PredefinedMetricPairTypeAsgcpuutilization = "ASGCPUUtilization"

	// PredefinedMetricPairTypeAsgnetworkIn is a PredefinedMetricPairType enum value
	PredefinedMetricPairTypeAsgnetworkIn = "ASGNetworkIn"

	// PredefinedMetricPairTypeAsgnetworkOut is a PredefinedMetricPairType enum value
	PredefinedMetricPairTypeAsgnetworkOut = "ASGNetworkOut"

	// PredefinedMetricPairTypeAlbrequestCount is a PredefinedMetricPairType enum value
	PredefinedMetricPairTypeAlbrequestCount = "ALBRequestCount"
)

// PredefinedMetricPairType_Values returns all elements of the PredefinedMetricPairType enum
func PredefinedMetricPairType_Values() []string {
	return []string{
		PredefinedMetricPairTypeAsgcpuutilization,
		PredefinedMetricPairTypeAsgnetworkIn,
		PredefinedMetricPairTypeAsgnetworkOut,
		PredefinedMetricPairTypeAlbrequestCount,
	}
}

const (
	// PredefinedScalingMetricTypeAsgaverageCpuutilization is a PredefinedScalingMetricType enum value
	PredefinedScalingMetricTypeAsgaverageCpuutilization = "ASGAverageCPUUtilization"

	// PredefinedScalingMetricTypeAsgaverageNetworkIn is a PredefinedScalingMetricType enum value
	PredefinedScalingMetricTypeAsgaverageNetworkIn = "ASGAverageNetworkIn"

	// PredefinedScalingMetricTypeAsgaverageNetworkOut is a PredefinedScalingMetricType enum value
	PredefinedScalingMetricTypeAsgaverageNetworkOut = "ASGAverageNetworkOut"

	// PredefinedScalingMetricTypeAlbrequestCountPerTarget is a PredefinedScalingMetricType enum value
	PredefinedScalingMetricTypeAlbrequestCountPerTarget = "ALBRequestCountPerTarget"
)

// PredefinedScalingMetricType_Values returns all elements of the PredefinedScalingMetricType enum
func PredefinedScalingMetricType_Values() []string {
	return []string{
		PredefinedScalingMetricTypeAsgaverageCpuutilization,
		PredefinedScalingMetricTypeAsgaverageNetworkIn,
		PredefinedScalingMetricTypeAsgaverageNetworkOut,
		PredefinedScalingMetricTypeAlbrequestCountPerTarget,
	}
}

const (
	// PredictiveScalingMaxCapacityBreachBehaviorHonorMaxCapacity is a PredictiveScalingMaxCapacityBreachBehavior enum value
	PredictiveScalingMaxCapacityBreachBehaviorHonorMaxCapacity = "HonorMaxCapacity"

	// PredictiveScalingMaxCapacityBreachBehaviorIncreaseMaxCapacity is a PredictiveScalingMaxCapacityBreachBehavior enum value
	PredictiveScalingMaxCapacityBreachBehaviorIncreaseMaxCapacity = "IncreaseMaxCapacity"
)

// PredictiveScalingMaxCapacityBreachBehavior_Values returns all elements of the PredictiveScalingMaxCapacityBreachBehavior enum
func PredictiveScalingMaxCapacityBreachBehavior_Values() []string {
	return []string{
		PredictiveScalingMaxCapacityBreachBehaviorHonorMaxCapacity,
		PredictiveScalingMaxCapacityBreachBehaviorIncreaseMaxCapacity,
	}
}

const (
	// PredictiveScalingModeForecastAndScale is a PredictiveScalingMode enum value
	PredictiveScalingModeForecastAndScale = "ForecastAndScale"

	// PredictiveScalingModeForecastOnly is a PredictiveScalingMode enum value
	PredictiveScalingModeForecastOnly = "ForecastOnly"
)

// PredictiveScalingMode_Values returns all elements of the PredictiveScalingMode enum
func PredictiveScalingMode_Values() []string {
	return []string{
		PredictiveScalingModeForecastAndScale,
		PredictiveScalingModeForecastOnly,
	}
}

const (
	// RefreshStrategyRolling is a RefreshStrategy enum value
	RefreshStrategyRolling = "Rolling"
)

// RefreshStrategy_Values returns all elements of the RefreshStrategy enum
func RefreshStrategy_Values() []string {
	return []string{
		RefreshStrategyRolling,
	}
}

const (
	// ScalingActivityStatusCodePendingSpotBidPlacement is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodePendingSpotBidPlacement = "PendingSpotBidPlacement"

	// ScalingActivityStatusCodeWaitingForSpotInstanceRequestId is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForSpotInstanceRequestId = "WaitingForSpotInstanceRequestId"

	// ScalingActivityStatusCodeWaitingForSpotInstanceId is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForSpotInstanceId = "WaitingForSpotInstanceId"

	// ScalingActivityStatusCodeWaitingForInstanceId is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForInstanceId = "WaitingForInstanceId"

	// ScalingActivityStatusCodePreInService is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodePreInService = "PreInService"

	// ScalingActivityStatusCodeInProgress is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeInProgress = "InProgress"

	// ScalingActivityStatusCodeWaitingForElbconnectionDraining is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForElbconnectionDraining = "WaitingForELBConnectionDraining"

	// ScalingActivityStatusCodeMidLifecycleAction is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeMidLifecycleAction = "MidLifecycleAction"

	// ScalingActivityStatusCodeWaitingForInstanceWarmup is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForInstanceWarmup = "WaitingForInstanceWarmup"

	// ScalingActivityStatusCodeSuccessful is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeSuccessful = "Successful"

	// ScalingActivityStatusCodeFailed is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeFailed = "Failed"

	// ScalingActivityStatusCodeCancelled is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeCancelled = "Cancelled"
)

// ScalingActivityStatusCode_Values returns all elements of the ScalingActivityStatusCode enum
func ScalingActivityStatusCode_Values() []string {
	return []string{
		ScalingActivityStatusCodePendingSpotBidPlacement,
		ScalingActivityStatusCodeWaitingForSpotInstanceRequestId,
		ScalingActivityStatusCodeWaitingForSpotInstanceId,
		ScalingActivityStatusCodeWaitingForInstanceId,
		ScalingActivityStatusCodePreInService,
		ScalingActivityStatusCodeInProgress,
		ScalingActivityStatusCodeWaitingForElbconnectionDraining,
		ScalingActivityStatusCodeMidLifecycleAction,
		ScalingActivityStatusCodeWaitingForInstanceWarmup,
		ScalingActivityStatusCodeSuccessful,
		ScalingActivityStatusCodeFailed,
		ScalingActivityStatusCodeCancelled,
	}
}

const (
	// WarmPoolStateStopped is a WarmPoolState enum value
	WarmPoolStateStopped = "Stopped"

	// WarmPoolStateRunning is a WarmPoolState enum value
	WarmPoolStateRunning = "Running"
)

// WarmPoolState_Values returns all elements of the WarmPoolState enum
func WarmPoolState_Values() []string {
	return []string{
		WarmPoolStateStopped,
		WarmPoolStateRunning,
	}
}

const (
	// WarmPoolStatusPendingDelete is a WarmPoolStatus enum value
	WarmPoolStatusPendingDelete = "PendingDelete"
)

// WarmPoolStatus_Values returns all elements of the WarmPoolStatus enum
func WarmPoolStatus_Values() []string {
	return []string{
		WarmPoolStatusPendingDelete,
	}
}
