// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package outposts

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateOutpost = "CreateOutpost"

// CreateOutpostRequest generates a "aws/request.Request" representing the
// client's request for the CreateOutpost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOutpost for more information on using the CreateOutpost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOutpostRequest method.
//    req, resp := client.CreateOutpostRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost
func (c *Outposts) CreateOutpostRequest(input *CreateOutpostInput) (req *request.Request, output *CreateOutpostOutput) {
	op := &request.Operation{
		Name:       opCreateOutpost,
		HTTPMethod: "POST",
		HTTPPath:   "/outposts",
	}

	if input == nil {
		input = &CreateOutpostInput{}
	}

	output = &CreateOutpostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOutpost API operation for AWS Outposts.
//
// Creates an Outpost.
//
// You can specify AvailabilityZone or AvailabilityZoneId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation CreateOutpost for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * ConflictException
//   Updating or deleting this resource can cause an inconsistent state.
//
//   * NotFoundException
//   The specified request is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
//   * ServiceQuotaExceededException
//   You have exceeded a service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost
func (c *Outposts) CreateOutpost(input *CreateOutpostInput) (*CreateOutpostOutput, error) {
	req, out := c.CreateOutpostRequest(input)
	return out, req.Send()
}

// CreateOutpostWithContext is the same as CreateOutpost with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOutpost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) CreateOutpostWithContext(ctx aws.Context, input *CreateOutpostInput, opts ...request.Option) (*CreateOutpostOutput, error) {
	req, out := c.CreateOutpostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOutpost = "DeleteOutpost"

// DeleteOutpostRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOutpost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOutpost for more information on using the DeleteOutpost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOutpostRequest method.
//    req, resp := client.DeleteOutpostRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteOutpost
func (c *Outposts) DeleteOutpostRequest(input *DeleteOutpostInput) (req *request.Request, output *DeleteOutpostOutput) {
	op := &request.Operation{
		Name:       opDeleteOutpost,
		HTTPMethod: "DELETE",
		HTTPPath:   "/outposts/{OutpostId}",
	}

	if input == nil {
		input = &DeleteOutpostInput{}
	}

	output = &DeleteOutpostOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOutpost API operation for AWS Outposts.
//
// Deletes the Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation DeleteOutpost for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * ConflictException
//   Updating or deleting this resource can cause an inconsistent state.
//
//   * NotFoundException
//   The specified request is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteOutpost
func (c *Outposts) DeleteOutpost(input *DeleteOutpostInput) (*DeleteOutpostOutput, error) {
	req, out := c.DeleteOutpostRequest(input)
	return out, req.Send()
}

// DeleteOutpostWithContext is the same as DeleteOutpost with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOutpost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) DeleteOutpostWithContext(ctx aws.Context, input *DeleteOutpostInput, opts ...request.Option) (*DeleteOutpostOutput, error) {
	req, out := c.DeleteOutpostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSite = "DeleteSite"

// DeleteSiteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSite for more information on using the DeleteSite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSiteRequest method.
//    req, resp := client.DeleteSiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteSite
func (c *Outposts) DeleteSiteRequest(input *DeleteSiteInput) (req *request.Request, output *DeleteSiteOutput) {
	op := &request.Operation{
		Name:       opDeleteSite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sites/{SiteId}",
	}

	if input == nil {
		input = &DeleteSiteInput{}
	}

	output = &DeleteSiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSite API operation for AWS Outposts.
//
// Deletes the site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation DeleteSite for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * ConflictException
//   Updating or deleting this resource can cause an inconsistent state.
//
//   * NotFoundException
//   The specified request is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteSite
func (c *Outposts) DeleteSite(input *DeleteSiteInput) (*DeleteSiteOutput, error) {
	req, out := c.DeleteSiteRequest(input)
	return out, req.Send()
}

// DeleteSiteWithContext is the same as DeleteSite with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) DeleteSiteWithContext(ctx aws.Context, input *DeleteSiteInput, opts ...request.Option) (*DeleteSiteOutput, error) {
	req, out := c.DeleteSiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOutpost = "GetOutpost"

// GetOutpostRequest generates a "aws/request.Request" representing the
// client's request for the GetOutpost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOutpost for more information on using the GetOutpost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOutpostRequest method.
//    req, resp := client.GetOutpostRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost
func (c *Outposts) GetOutpostRequest(input *GetOutpostInput) (req *request.Request, output *GetOutpostOutput) {
	op := &request.Operation{
		Name:       opGetOutpost,
		HTTPMethod: "GET",
		HTTPPath:   "/outposts/{OutpostId}",
	}

	if input == nil {
		input = &GetOutpostInput{}
	}

	output = &GetOutpostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOutpost API operation for AWS Outposts.
//
// Gets information about the specified Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation GetOutpost for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * NotFoundException
//   The specified request is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost
func (c *Outposts) GetOutpost(input *GetOutpostInput) (*GetOutpostOutput, error) {
	req, out := c.GetOutpostRequest(input)
	return out, req.Send()
}

// GetOutpostWithContext is the same as GetOutpost with the addition of
// the ability to pass a context and additional request options.
//
// See GetOutpost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) GetOutpostWithContext(ctx aws.Context, input *GetOutpostInput, opts ...request.Option) (*GetOutpostOutput, error) {
	req, out := c.GetOutpostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOutpostInstanceTypes = "GetOutpostInstanceTypes"

// GetOutpostInstanceTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetOutpostInstanceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOutpostInstanceTypes for more information on using the GetOutpostInstanceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOutpostInstanceTypesRequest method.
//    req, resp := client.GetOutpostInstanceTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes
func (c *Outposts) GetOutpostInstanceTypesRequest(input *GetOutpostInstanceTypesInput) (req *request.Request, output *GetOutpostInstanceTypesOutput) {
	op := &request.Operation{
		Name:       opGetOutpostInstanceTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/outposts/{OutpostId}/instanceTypes",
	}

	if input == nil {
		input = &GetOutpostInstanceTypesInput{}
	}

	output = &GetOutpostInstanceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOutpostInstanceTypes API operation for AWS Outposts.
//
// Lists the instance types for the specified Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation GetOutpostInstanceTypes for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * NotFoundException
//   The specified request is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes
func (c *Outposts) GetOutpostInstanceTypes(input *GetOutpostInstanceTypesInput) (*GetOutpostInstanceTypesOutput, error) {
	req, out := c.GetOutpostInstanceTypesRequest(input)
	return out, req.Send()
}

// GetOutpostInstanceTypesWithContext is the same as GetOutpostInstanceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetOutpostInstanceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) GetOutpostInstanceTypesWithContext(ctx aws.Context, input *GetOutpostInstanceTypesInput, opts ...request.Option) (*GetOutpostInstanceTypesOutput, error) {
	req, out := c.GetOutpostInstanceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOutposts = "ListOutposts"

// ListOutpostsRequest generates a "aws/request.Request" representing the
// client's request for the ListOutposts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOutposts for more information on using the ListOutposts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOutpostsRequest method.
//    req, resp := client.ListOutpostsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts
func (c *Outposts) ListOutpostsRequest(input *ListOutpostsInput) (req *request.Request, output *ListOutpostsOutput) {
	op := &request.Operation{
		Name:       opListOutposts,
		HTTPMethod: "GET",
		HTTPPath:   "/outposts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOutpostsInput{}
	}

	output = &ListOutpostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOutposts API operation for AWS Outposts.
//
// Create a list of the Outposts for your AWS account. Add filters to your request
// to return a more specific list of results. Use filters to match an Outpost
// lifecycle status, Availibility Zone (us-east-1a), and AZ ID (use1-az1).
//
// If you specify multiple filters, the filters are joined with an AND, and
// the request returns only results that match all of the specified filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation ListOutposts for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts
func (c *Outposts) ListOutposts(input *ListOutpostsInput) (*ListOutpostsOutput, error) {
	req, out := c.ListOutpostsRequest(input)
	return out, req.Send()
}

// ListOutpostsWithContext is the same as ListOutposts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOutposts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListOutpostsWithContext(ctx aws.Context, input *ListOutpostsInput, opts ...request.Option) (*ListOutpostsOutput, error) {
	req, out := c.ListOutpostsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOutpostsPages iterates over the pages of a ListOutposts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOutposts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOutposts operation.
//    pageNum := 0
//    err := client.ListOutpostsPages(params,
//        func(page *outposts.ListOutpostsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Outposts) ListOutpostsPages(input *ListOutpostsInput, fn func(*ListOutpostsOutput, bool) bool) error {
	return c.ListOutpostsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOutpostsPagesWithContext same as ListOutpostsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListOutpostsPagesWithContext(ctx aws.Context, input *ListOutpostsInput, fn func(*ListOutpostsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOutpostsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOutpostsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOutpostsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSites = "ListSites"

// ListSitesRequest generates a "aws/request.Request" representing the
// client's request for the ListSites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSites for more information on using the ListSites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSitesRequest method.
//    req, resp := client.ListSitesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites
func (c *Outposts) ListSitesRequest(input *ListSitesInput) (req *request.Request, output *ListSitesOutput) {
	op := &request.Operation{
		Name:       opListSites,
		HTTPMethod: "GET",
		HTTPPath:   "/sites",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSitesInput{}
	}

	output = &ListSitesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSites API operation for AWS Outposts.
//
// Lists the sites for the specified AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation ListSites for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites
func (c *Outposts) ListSites(input *ListSitesInput) (*ListSitesOutput, error) {
	req, out := c.ListSitesRequest(input)
	return out, req.Send()
}

// ListSitesWithContext is the same as ListSites with the addition of
// the ability to pass a context and additional request options.
//
// See ListSites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListSitesWithContext(ctx aws.Context, input *ListSitesInput, opts ...request.Option) (*ListSitesOutput, error) {
	req, out := c.ListSitesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSitesPages iterates over the pages of a ListSites operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSites method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSites operation.
//    pageNum := 0
//    err := client.ListSitesPages(params,
//        func(page *outposts.ListSitesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Outposts) ListSitesPages(input *ListSitesInput, fn func(*ListSitesOutput, bool) bool) error {
	return c.ListSitesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSitesPagesWithContext same as ListSitesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListSitesPagesWithContext(ctx aws.Context, input *ListSitesInput, fn func(*ListSitesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSitesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSitesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSitesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListTagsForResource
func (c *Outposts) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Outposts.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred.
//
//   * ValidationException
//   A parameter is not valid.
//
//   * NotFoundException
//   The specified request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListTagsForResource
func (c *Outposts) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/TagResource
func (c *Outposts) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Outposts.
//
// Adds tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred.
//
//   * ValidationException
//   A parameter is not valid.
//
//   * NotFoundException
//   The specified request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/TagResource
func (c *Outposts) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UntagResource
func (c *Outposts) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Outposts.
//
// Removes tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred.
//
//   * ValidationException
//   A parameter is not valid.
//
//   * NotFoundException
//   The specified request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UntagResource
func (c *Outposts) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have permission to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Updating or deleting this resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// The ID of the resource causing the conflict.
	ResourceId *string `min:"1" type:"string"`

	// The type of the resource causing the conflict.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateOutpostInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `min:"1" type:"string"`

	// The ID of the Availability Zone.
	AvailabilityZoneId *string `min:"1" type:"string"`

	// The description of the Outpost.
	Description *string `type:"string"`

	// The name of the Outpost.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The ID of the site.
	//
	// SiteId is a required field
	SiteId *string `min:"1" type:"string" required:"true"`

	// The tags to apply to the Outpost.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s CreateOutpostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOutpostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOutpostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOutpostInput"}
	if s.AvailabilityZone != nil && len(*s.AvailabilityZone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZone", 1))
	}
	if s.AvailabilityZoneId != nil && len(*s.AvailabilityZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZoneId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SiteId == nil {
		invalidParams.Add(request.NewErrParamRequired("SiteId"))
	}
	if s.SiteId != nil && len(*s.SiteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SiteId", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateOutpostInput) SetAvailabilityZone(v string) *CreateOutpostInput {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateOutpostInput) SetAvailabilityZoneId(v string) *CreateOutpostInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateOutpostInput) SetDescription(v string) *CreateOutpostInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateOutpostInput) SetName(v string) *CreateOutpostInput {
	s.Name = &v
	return s
}

// SetSiteId sets the SiteId field's value.
func (s *CreateOutpostInput) SetSiteId(v string) *CreateOutpostInput {
	s.SiteId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOutpostInput) SetTags(v map[string]*string) *CreateOutpostInput {
	s.Tags = v
	return s
}

type CreateOutpostOutput struct {
	_ struct{} `type:"structure"`

	// Information about an Outpost.
	Outpost *Outpost `type:"structure"`
}

// String returns the string representation
func (s CreateOutpostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOutpostOutput) GoString() string {
	return s.String()
}

// SetOutpost sets the Outpost field's value.
func (s *CreateOutpostOutput) SetOutpost(v *Outpost) *CreateOutpostOutput {
	s.Outpost = v
	return s
}

type DeleteOutpostInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Outpost.
	//
	// OutpostId is a required field
	OutpostId *string `location:"uri" locationName:"OutpostId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOutpostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOutpostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOutpostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOutpostInput"}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutpostId sets the OutpostId field's value.
func (s *DeleteOutpostInput) SetOutpostId(v string) *DeleteOutpostInput {
	s.OutpostId = &v
	return s
}

type DeleteOutpostOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOutpostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOutpostOutput) GoString() string {
	return s.String()
}

type DeleteSiteInput struct {
	_ struct{} `type:"structure"`

	// The ID of the site.
	//
	// SiteId is a required field
	SiteId *string `location:"uri" locationName:"SiteId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSiteInput"}
	if s.SiteId == nil {
		invalidParams.Add(request.NewErrParamRequired("SiteId"))
	}
	if s.SiteId != nil && len(*s.SiteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SiteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSiteId sets the SiteId field's value.
func (s *DeleteSiteInput) SetSiteId(v string) *DeleteSiteInput {
	s.SiteId = &v
	return s
}

type DeleteSiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSiteOutput) GoString() string {
	return s.String()
}

type GetOutpostInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Outpost.
	//
	// OutpostId is a required field
	OutpostId *string `location:"uri" locationName:"OutpostId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOutpostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutpostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutpostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOutpostInput"}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutpostId sets the OutpostId field's value.
func (s *GetOutpostInput) SetOutpostId(v string) *GetOutpostInput {
	s.OutpostId = &v
	return s
}

type GetOutpostInstanceTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum page size.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// The ID of the Outpost.
	//
	// OutpostId is a required field
	OutpostId *string `location:"uri" locationName:"OutpostId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOutpostInstanceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutpostInstanceTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutpostInstanceTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOutpostInstanceTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetOutpostInstanceTypesInput) SetMaxResults(v int64) *GetOutpostInstanceTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutpostInstanceTypesInput) SetNextToken(v string) *GetOutpostInstanceTypesInput {
	s.NextToken = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *GetOutpostInstanceTypesInput) SetOutpostId(v string) *GetOutpostInstanceTypesInput {
	s.OutpostId = &v
	return s
}

type GetOutpostInstanceTypesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instance types.
	InstanceTypes []*InstanceTypeItem `type:"list"`

	// The pagination token.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Outpost.
	OutpostArn *string `min:"1" type:"string"`

	// The ID of the Outpost.
	OutpostId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetOutpostInstanceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutpostInstanceTypesOutput) GoString() string {
	return s.String()
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *GetOutpostInstanceTypesOutput) SetInstanceTypes(v []*InstanceTypeItem) *GetOutpostInstanceTypesOutput {
	s.InstanceTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutpostInstanceTypesOutput) SetNextToken(v string) *GetOutpostInstanceTypesOutput {
	s.NextToken = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *GetOutpostInstanceTypesOutput) SetOutpostArn(v string) *GetOutpostInstanceTypesOutput {
	s.OutpostArn = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *GetOutpostInstanceTypesOutput) SetOutpostId(v string) *GetOutpostInstanceTypesOutput {
	s.OutpostId = &v
	return s
}

type GetOutpostOutput struct {
	_ struct{} `type:"structure"`

	// Information about an Outpost.
	Outpost *Outpost `type:"structure"`
}

// String returns the string representation
func (s GetOutpostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutpostOutput) GoString() string {
	return s.String()
}

// SetOutpost sets the Outpost field's value.
func (s *GetOutpostOutput) SetOutpost(v *Outpost) *GetOutpostOutput {
	s.Outpost = v
	return s
}

// Information about an instance type.
type InstanceTypeItem struct {
	_ struct{} `type:"structure"`

	// The instance type.
	InstanceType *string `type:"string"`
}

// String returns the string representation
func (s InstanceTypeItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTypeItem) GoString() string {
	return s.String()
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceTypeItem) SetInstanceType(v string) *InstanceTypeItem {
	s.InstanceType = &v
	return s
}

// An internal error has occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListOutpostsInput struct {
	_ struct{} `type:"structure"`

	// A filter for the Availibility Zone (us-east-1a) of the Outpost.
	//
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR, and the request returns all results that
	// match any of the specified values.
	AvailabilityZoneFilter []*string `location:"querystring" locationName:"AvailabilityZoneFilter" min:"1" type:"list"`

	// A filter for the AZ IDs (use1-az1) of the Outpost.
	//
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR, and the request returns all results that
	// match any of the specified values.
	AvailabilityZoneIdFilter []*string `location:"querystring" locationName:"AvailabilityZoneIdFilter" min:"1" type:"list"`

	// A filter for the lifecycle status of the Outpost.
	//
	// Filter values are case sensitive. If you specify multiple values for a filter,
	// the values are joined with an OR, and the request returns all results that
	// match any of the specified values.
	LifeCycleStatusFilter []*string `location:"querystring" locationName:"LifeCycleStatusFilter" min:"1" type:"list"`

	// The maximum page size.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListOutpostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutpostsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutpostsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOutpostsInput"}
	if s.AvailabilityZoneFilter != nil && len(s.AvailabilityZoneFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZoneFilter", 1))
	}
	if s.AvailabilityZoneIdFilter != nil && len(s.AvailabilityZoneIdFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZoneIdFilter", 1))
	}
	if s.LifeCycleStatusFilter != nil && len(s.LifeCycleStatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifeCycleStatusFilter", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZoneFilter sets the AvailabilityZoneFilter field's value.
func (s *ListOutpostsInput) SetAvailabilityZoneFilter(v []*string) *ListOutpostsInput {
	s.AvailabilityZoneFilter = v
	return s
}

// SetAvailabilityZoneIdFilter sets the AvailabilityZoneIdFilter field's value.
func (s *ListOutpostsInput) SetAvailabilityZoneIdFilter(v []*string) *ListOutpostsInput {
	s.AvailabilityZoneIdFilter = v
	return s
}

// SetLifeCycleStatusFilter sets the LifeCycleStatusFilter field's value.
func (s *ListOutpostsInput) SetLifeCycleStatusFilter(v []*string) *ListOutpostsInput {
	s.LifeCycleStatusFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOutpostsInput) SetMaxResults(v int64) *ListOutpostsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutpostsInput) SetNextToken(v string) *ListOutpostsInput {
	s.NextToken = &v
	return s
}

type ListOutpostsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `min:"1" type:"string"`

	// Information about the Outposts.
	Outposts []*Outpost `type:"list"`
}

// String returns the string representation
func (s ListOutpostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutpostsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutpostsOutput) SetNextToken(v string) *ListOutpostsOutput {
	s.NextToken = &v
	return s
}

// SetOutposts sets the Outposts field's value.
func (s *ListOutpostsOutput) SetOutposts(v []*Outpost) *ListOutpostsOutput {
	s.Outposts = v
	return s
}

type ListSitesInput struct {
	_ struct{} `type:"structure"`

	// The maximum page size.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListSitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSitesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSitesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSitesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSitesInput) SetMaxResults(v int64) *ListSitesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSitesInput) SetNextToken(v string) *ListSitesInput {
	s.NextToken = &v
	return s
}

type ListSitesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `min:"1" type:"string"`

	// Information about the sites.
	Sites []*Site `type:"list"`
}

// String returns the string representation
func (s ListSitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSitesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSitesOutput) SetNextToken(v string) *ListSitesOutput {
	s.NextToken = &v
	return s
}

// SetSites sets the Sites field's value.
func (s *ListSitesOutput) SetSites(v []*Site) *ListSitesOutput {
	s.Sites = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The resource tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The specified request is not valid.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about an Outpost.
type Outpost struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `min:"1" type:"string"`

	// The ID of the Availability Zone.
	AvailabilityZoneId *string `min:"1" type:"string"`

	// The description of the Outpost.
	Description *string `type:"string"`

	// The life cycle status.
	LifeCycleStatus *string `min:"1" type:"string"`

	// The name of the Outpost.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Outpost.
	OutpostArn *string `min:"1" type:"string"`

	// The ID of the Outpost.
	OutpostId *string `min:"1" type:"string"`

	// The AWS account ID of the Outpost owner.
	OwnerId *string `min:"12" type:"string"`

	// The Amazon Resource Name (ARN) of the site.
	SiteArn *string `min:"1" type:"string"`

	// The ID of the site.
	SiteId *string `min:"1" type:"string"`

	// The Outpost tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s Outpost) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Outpost) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Outpost) SetAvailabilityZone(v string) *Outpost {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *Outpost) SetAvailabilityZoneId(v string) *Outpost {
	s.AvailabilityZoneId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Outpost) SetDescription(v string) *Outpost {
	s.Description = &v
	return s
}

// SetLifeCycleStatus sets the LifeCycleStatus field's value.
func (s *Outpost) SetLifeCycleStatus(v string) *Outpost {
	s.LifeCycleStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *Outpost) SetName(v string) *Outpost {
	s.Name = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *Outpost) SetOutpostArn(v string) *Outpost {
	s.OutpostArn = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *Outpost) SetOutpostId(v string) *Outpost {
	s.OutpostId = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *Outpost) SetOwnerId(v string) *Outpost {
	s.OwnerId = &v
	return s
}

// SetSiteArn sets the SiteArn field's value.
func (s *Outpost) SetSiteArn(v string) *Outpost {
	s.SiteArn = &v
	return s
}

// SetSiteId sets the SiteId field's value.
func (s *Outpost) SetSiteId(v string) *Outpost {
	s.SiteId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Outpost) SetTags(v map[string]*string) *Outpost {
	s.Tags = v
	return s
}

// You have exceeded a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a site.
type Site struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account.
	AccountId *string `min:"12" type:"string"`

	// The description of the site.
	Description *string `min:"1" type:"string"`

	// The name of the site.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the site.
	SiteArn *string `min:"1" type:"string"`

	// The ID of the site.
	SiteId *string `min:"1" type:"string"`

	// The site tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s Site) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Site) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Site) SetAccountId(v string) *Site {
	s.AccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Site) SetDescription(v string) *Site {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Site) SetName(v string) *Site {
	s.Name = &v
	return s
}

// SetSiteArn sets the SiteArn field's value.
func (s *Site) SetSiteArn(v string) *Site {
	s.SiteArn = &v
	return s
}

// SetSiteId sets the SiteId field's value.
func (s *Site) SetSiteId(v string) *Site {
	s.SiteId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Site) SetTags(v map[string]*string) *Site {
	s.Tags = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// A parameter is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ResourceTypeOutpost is a ResourceType enum value
	ResourceTypeOutpost = "OUTPOST"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeOutpost,
	}
}
