// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package managedblockchain

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateMember = "CreateMember"

// CreateMemberRequest generates a "aws/request.Request" representing the
// client's request for the CreateMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMember for more information on using the CreateMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMemberRequest method.
//    req, resp := client.CreateMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateMember
func (c *ManagedBlockchain) CreateMemberRequest(input *CreateMemberInput) (req *request.Request, output *CreateMemberOutput) {
	op := &request.Operation{
		Name:       opCreateMember,
		HTTPMethod: "POST",
		HTTPPath:   "/networks/{networkId}/members",
	}

	if input == nil {
		input = &CreateMemberInput{}
	}

	output = &CreateMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMember API operation for Amazon Managed Blockchain.
//
// Creates a member within a Managed Blockchain network.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation CreateMember for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ResourceAlreadyExistsException
//   A resource request is issued for a resource that already exists.
//
//   * ResourceNotReadyException
//   The requested resource exists but is not in a status that can complete the
//   operation.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * ResourceLimitExceededException
//   The maximum number of resources of that type already exist. Ensure the resources
//   requested are within the boundaries of the service edition and your account
//   limits.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
//   * TooManyTagsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateMember
func (c *ManagedBlockchain) CreateMember(input *CreateMemberInput) (*CreateMemberOutput, error) {
	req, out := c.CreateMemberRequest(input)
	return out, req.Send()
}

// CreateMemberWithContext is the same as CreateMember with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) CreateMemberWithContext(ctx aws.Context, input *CreateMemberInput, opts ...request.Option) (*CreateMemberOutput, error) {
	req, out := c.CreateMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetwork = "CreateNetwork"

// CreateNetworkRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetwork for more information on using the CreateNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNetworkRequest method.
//    req, resp := client.CreateNetworkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNetwork
func (c *ManagedBlockchain) CreateNetworkRequest(input *CreateNetworkInput) (req *request.Request, output *CreateNetworkOutput) {
	op := &request.Operation{
		Name:       opCreateNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/networks",
	}

	if input == nil {
		input = &CreateNetworkInput{}
	}

	output = &CreateNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetwork API operation for Amazon Managed Blockchain.
//
// Creates a new blockchain network using Amazon Managed Blockchain.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation CreateNetwork for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceAlreadyExistsException
//   A resource request is issued for a resource that already exists.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * ResourceLimitExceededException
//   The maximum number of resources of that type already exist. Ensure the resources
//   requested are within the boundaries of the service edition and your account
//   limits.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
//   * TooManyTagsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNetwork
func (c *ManagedBlockchain) CreateNetwork(input *CreateNetworkInput) (*CreateNetworkOutput, error) {
	req, out := c.CreateNetworkRequest(input)
	return out, req.Send()
}

// CreateNetworkWithContext is the same as CreateNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) CreateNetworkWithContext(ctx aws.Context, input *CreateNetworkInput, opts ...request.Option) (*CreateNetworkOutput, error) {
	req, out := c.CreateNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNode = "CreateNode"

// CreateNodeRequest generates a "aws/request.Request" representing the
// client's request for the CreateNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNode for more information on using the CreateNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNodeRequest method.
//    req, resp := client.CreateNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNode
func (c *ManagedBlockchain) CreateNodeRequest(input *CreateNodeInput) (req *request.Request, output *CreateNodeOutput) {
	op := &request.Operation{
		Name:       opCreateNode,
		HTTPMethod: "POST",
		HTTPPath:   "/networks/{networkId}/nodes",
	}

	if input == nil {
		input = &CreateNodeInput{}
	}

	output = &CreateNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNode API operation for Amazon Managed Blockchain.
//
// Creates a node on the specified blockchain network.
//
// Applies to Hyperledger Fabric and Ethereum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation CreateNode for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ResourceAlreadyExistsException
//   A resource request is issued for a resource that already exists.
//
//   * ResourceNotReadyException
//   The requested resource exists but is not in a status that can complete the
//   operation.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * ResourceLimitExceededException
//   The maximum number of resources of that type already exist. Ensure the resources
//   requested are within the boundaries of the service edition and your account
//   limits.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
//   * TooManyTagsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNode
func (c *ManagedBlockchain) CreateNode(input *CreateNodeInput) (*CreateNodeOutput, error) {
	req, out := c.CreateNodeRequest(input)
	return out, req.Send()
}

// CreateNodeWithContext is the same as CreateNode with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) CreateNodeWithContext(ctx aws.Context, input *CreateNodeInput, opts ...request.Option) (*CreateNodeOutput, error) {
	req, out := c.CreateNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProposal = "CreateProposal"

// CreateProposalRequest generates a "aws/request.Request" representing the
// client's request for the CreateProposal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProposal for more information on using the CreateProposal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProposalRequest method.
//    req, resp := client.CreateProposalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateProposal
func (c *ManagedBlockchain) CreateProposalRequest(input *CreateProposalInput) (req *request.Request, output *CreateProposalOutput) {
	op := &request.Operation{
		Name:       opCreateProposal,
		HTTPMethod: "POST",
		HTTPPath:   "/networks/{networkId}/proposals",
	}

	if input == nil {
		input = &CreateProposalInput{}
	}

	output = &CreateProposalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProposal API operation for Amazon Managed Blockchain.
//
// Creates a proposal for a change to the network that other members of the
// network can vote on, for example, a proposal to add a new member to the network.
// Any member can create a proposal.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation CreateProposal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ResourceNotReadyException
//   The requested resource exists but is not in a status that can complete the
//   operation.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
//   * TooManyTagsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateProposal
func (c *ManagedBlockchain) CreateProposal(input *CreateProposalInput) (*CreateProposalOutput, error) {
	req, out := c.CreateProposalRequest(input)
	return out, req.Send()
}

// CreateProposalWithContext is the same as CreateProposal with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProposal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) CreateProposalWithContext(ctx aws.Context, input *CreateProposalInput, opts ...request.Option) (*CreateProposalOutput, error) {
	req, out := c.CreateProposalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMember = "DeleteMember"

// DeleteMemberRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMember for more information on using the DeleteMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMemberRequest method.
//    req, resp := client.DeleteMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteMember
func (c *ManagedBlockchain) DeleteMemberRequest(input *DeleteMemberInput) (req *request.Request, output *DeleteMemberOutput) {
	op := &request.Operation{
		Name:       opDeleteMember,
		HTTPMethod: "DELETE",
		HTTPPath:   "/networks/{networkId}/members/{memberId}",
	}

	if input == nil {
		input = &DeleteMemberInput{}
	}

	output = &DeleteMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMember API operation for Amazon Managed Blockchain.
//
// Deletes a member. Deleting a member removes the member and all associated
// resources from the network. DeleteMember can only be called for a specified
// MemberId if the principal performing the action is associated with the AWS
// account that owns the member. In all other cases, the DeleteMember action
// is carried out as the result of an approved proposal to remove a member.
// If MemberId is the last member in a network specified by the last AWS account,
// the network is deleted also.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation DeleteMember for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ResourceNotReadyException
//   The requested resource exists but is not in a status that can complete the
//   operation.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteMember
func (c *ManagedBlockchain) DeleteMember(input *DeleteMemberInput) (*DeleteMemberOutput, error) {
	req, out := c.DeleteMemberRequest(input)
	return out, req.Send()
}

// DeleteMemberWithContext is the same as DeleteMember with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) DeleteMemberWithContext(ctx aws.Context, input *DeleteMemberInput, opts ...request.Option) (*DeleteMemberOutput, error) {
	req, out := c.DeleteMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNode = "DeleteNode"

// DeleteNodeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNode for more information on using the DeleteNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNodeRequest method.
//    req, resp := client.DeleteNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteNode
func (c *ManagedBlockchain) DeleteNodeRequest(input *DeleteNodeInput) (req *request.Request, output *DeleteNodeOutput) {
	op := &request.Operation{
		Name:       opDeleteNode,
		HTTPMethod: "DELETE",
		HTTPPath:   "/networks/{networkId}/nodes/{nodeId}",
	}

	if input == nil {
		input = &DeleteNodeInput{}
	}

	output = &DeleteNodeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNode API operation for Amazon Managed Blockchain.
//
// Deletes a node that your AWS account owns. All data on the node is lost and
// cannot be recovered.
//
// Applies to Hyperledger Fabric and Ethereum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation DeleteNode for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ResourceNotReadyException
//   The requested resource exists but is not in a status that can complete the
//   operation.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteNode
func (c *ManagedBlockchain) DeleteNode(input *DeleteNodeInput) (*DeleteNodeOutput, error) {
	req, out := c.DeleteNodeRequest(input)
	return out, req.Send()
}

// DeleteNodeWithContext is the same as DeleteNode with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) DeleteNodeWithContext(ctx aws.Context, input *DeleteNodeInput, opts ...request.Option) (*DeleteNodeOutput, error) {
	req, out := c.DeleteNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMember = "GetMember"

// GetMemberRequest generates a "aws/request.Request" representing the
// client's request for the GetMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMember for more information on using the GetMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMemberRequest method.
//    req, resp := client.GetMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetMember
func (c *ManagedBlockchain) GetMemberRequest(input *GetMemberInput) (req *request.Request, output *GetMemberOutput) {
	op := &request.Operation{
		Name:       opGetMember,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}/members/{memberId}",
	}

	if input == nil {
		input = &GetMemberInput{}
	}

	output = &GetMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMember API operation for Amazon Managed Blockchain.
//
// Returns detailed information about a member.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation GetMember for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetMember
func (c *ManagedBlockchain) GetMember(input *GetMemberInput) (*GetMemberOutput, error) {
	req, out := c.GetMemberRequest(input)
	return out, req.Send()
}

// GetMemberWithContext is the same as GetMember with the addition of
// the ability to pass a context and additional request options.
//
// See GetMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) GetMemberWithContext(ctx aws.Context, input *GetMemberInput, opts ...request.Option) (*GetMemberOutput, error) {
	req, out := c.GetMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNetwork = "GetNetwork"

// GetNetworkRequest generates a "aws/request.Request" representing the
// client's request for the GetNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNetwork for more information on using the GetNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNetworkRequest method.
//    req, resp := client.GetNetworkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNetwork
func (c *ManagedBlockchain) GetNetworkRequest(input *GetNetworkInput) (req *request.Request, output *GetNetworkOutput) {
	op := &request.Operation{
		Name:       opGetNetwork,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}",
	}

	if input == nil {
		input = &GetNetworkInput{}
	}

	output = &GetNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNetwork API operation for Amazon Managed Blockchain.
//
// Returns detailed information about a network.
//
// Applies to Hyperledger Fabric and Ethereum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation GetNetwork for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNetwork
func (c *ManagedBlockchain) GetNetwork(input *GetNetworkInput) (*GetNetworkOutput, error) {
	req, out := c.GetNetworkRequest(input)
	return out, req.Send()
}

// GetNetworkWithContext is the same as GetNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See GetNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) GetNetworkWithContext(ctx aws.Context, input *GetNetworkInput, opts ...request.Option) (*GetNetworkOutput, error) {
	req, out := c.GetNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNode = "GetNode"

// GetNodeRequest generates a "aws/request.Request" representing the
// client's request for the GetNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNode for more information on using the GetNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNodeRequest method.
//    req, resp := client.GetNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNode
func (c *ManagedBlockchain) GetNodeRequest(input *GetNodeInput) (req *request.Request, output *GetNodeOutput) {
	op := &request.Operation{
		Name:       opGetNode,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}/nodes/{nodeId}",
	}

	if input == nil {
		input = &GetNodeInput{}
	}

	output = &GetNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNode API operation for Amazon Managed Blockchain.
//
// Returns detailed information about a node.
//
// Applies to Hyperledger Fabric and Ethereum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation GetNode for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNode
func (c *ManagedBlockchain) GetNode(input *GetNodeInput) (*GetNodeOutput, error) {
	req, out := c.GetNodeRequest(input)
	return out, req.Send()
}

// GetNodeWithContext is the same as GetNode with the addition of
// the ability to pass a context and additional request options.
//
// See GetNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) GetNodeWithContext(ctx aws.Context, input *GetNodeInput, opts ...request.Option) (*GetNodeOutput, error) {
	req, out := c.GetNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProposal = "GetProposal"

// GetProposalRequest generates a "aws/request.Request" representing the
// client's request for the GetProposal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProposal for more information on using the GetProposal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetProposalRequest method.
//    req, resp := client.GetProposalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetProposal
func (c *ManagedBlockchain) GetProposalRequest(input *GetProposalInput) (req *request.Request, output *GetProposalOutput) {
	op := &request.Operation{
		Name:       opGetProposal,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}/proposals/{proposalId}",
	}

	if input == nil {
		input = &GetProposalInput{}
	}

	output = &GetProposalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProposal API operation for Amazon Managed Blockchain.
//
// Returns detailed information about a proposal.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation GetProposal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetProposal
func (c *ManagedBlockchain) GetProposal(input *GetProposalInput) (*GetProposalOutput, error) {
	req, out := c.GetProposalRequest(input)
	return out, req.Send()
}

// GetProposalWithContext is the same as GetProposal with the addition of
// the ability to pass a context and additional request options.
//
// See GetProposal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) GetProposalWithContext(ctx aws.Context, input *GetProposalInput, opts ...request.Option) (*GetProposalOutput, error) {
	req, out := c.GetProposalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations
func (c *ManagedBlockchain) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for Amazon Managed Blockchain.
//
// Returns a list of all invitations for the current AWS account.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * ResourceLimitExceededException
//   The maximum number of resources of that type already exist. Ensure the resources
//   requested are within the boundaries of the service edition and your account
//   limits.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations
func (c *ManagedBlockchain) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvitations operation.
//    pageNum := 0
//    err := client.ListInvitationsPages(params,
//        func(page *managedblockchain.ListInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ManagedBlockchain) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers
func (c *ManagedBlockchain) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for Amazon Managed Blockchain.
//
// Returns a list of the members in a network and properties of their configurations.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers
func (c *ManagedBlockchain) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMembers operation.
//    pageNum := 0
//    err := client.ListMembersPages(params,
//        func(page *managedblockchain.ListMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ManagedBlockchain) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNetworks = "ListNetworks"

// ListNetworksRequest generates a "aws/request.Request" representing the
// client's request for the ListNetworks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNetworks for more information on using the ListNetworks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNetworksRequest method.
//    req, resp := client.ListNetworksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks
func (c *ManagedBlockchain) ListNetworksRequest(input *ListNetworksInput) (req *request.Request, output *ListNetworksOutput) {
	op := &request.Operation{
		Name:       opListNetworks,
		HTTPMethod: "GET",
		HTTPPath:   "/networks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNetworksInput{}
	}

	output = &ListNetworksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNetworks API operation for Amazon Managed Blockchain.
//
// Returns information about the networks in which the current AWS account participates.
//
// Applies to Hyperledger Fabric and Ethereum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation ListNetworks for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks
func (c *ManagedBlockchain) ListNetworks(input *ListNetworksInput) (*ListNetworksOutput, error) {
	req, out := c.ListNetworksRequest(input)
	return out, req.Send()
}

// ListNetworksWithContext is the same as ListNetworks with the addition of
// the ability to pass a context and additional request options.
//
// See ListNetworks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListNetworksWithContext(ctx aws.Context, input *ListNetworksInput, opts ...request.Option) (*ListNetworksOutput, error) {
	req, out := c.ListNetworksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNetworksPages iterates over the pages of a ListNetworks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNetworks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNetworks operation.
//    pageNum := 0
//    err := client.ListNetworksPages(params,
//        func(page *managedblockchain.ListNetworksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ManagedBlockchain) ListNetworksPages(input *ListNetworksInput, fn func(*ListNetworksOutput, bool) bool) error {
	return c.ListNetworksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNetworksPagesWithContext same as ListNetworksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListNetworksPagesWithContext(ctx aws.Context, input *ListNetworksInput, fn func(*ListNetworksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNetworksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNetworksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNetworksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodes = "ListNodes"

// ListNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodes for more information on using the ListNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNodesRequest method.
//    req, resp := client.ListNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes
func (c *ManagedBlockchain) ListNodesRequest(input *ListNodesInput) (req *request.Request, output *ListNodesOutput) {
	op := &request.Operation{
		Name:       opListNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}/nodes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodesInput{}
	}

	output = &ListNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodes API operation for Amazon Managed Blockchain.
//
// Returns information about the nodes within a network.
//
// Applies to Hyperledger Fabric and Ethereum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation ListNodes for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes
func (c *ManagedBlockchain) ListNodes(input *ListNodesInput) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	return out, req.Send()
}

// ListNodesWithContext is the same as ListNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListNodesWithContext(ctx aws.Context, input *ListNodesInput, opts ...request.Option) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodesPages iterates over the pages of a ListNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNodes operation.
//    pageNum := 0
//    err := client.ListNodesPages(params,
//        func(page *managedblockchain.ListNodesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ManagedBlockchain) ListNodesPages(input *ListNodesInput, fn func(*ListNodesOutput, bool) bool) error {
	return c.ListNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodesPagesWithContext same as ListNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListNodesPagesWithContext(ctx aws.Context, input *ListNodesInput, fn func(*ListNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProposalVotes = "ListProposalVotes"

// ListProposalVotesRequest generates a "aws/request.Request" representing the
// client's request for the ListProposalVotes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProposalVotes for more information on using the ListProposalVotes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProposalVotesRequest method.
//    req, resp := client.ListProposalVotesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes
func (c *ManagedBlockchain) ListProposalVotesRequest(input *ListProposalVotesInput) (req *request.Request, output *ListProposalVotesOutput) {
	op := &request.Operation{
		Name:       opListProposalVotes,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}/proposals/{proposalId}/votes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProposalVotesInput{}
	}

	output = &ListProposalVotesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProposalVotes API operation for Amazon Managed Blockchain.
//
// Returns the list of votes for a specified proposal, including the value of
// each vote and the unique identifier of the member that cast the vote.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation ListProposalVotes for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes
func (c *ManagedBlockchain) ListProposalVotes(input *ListProposalVotesInput) (*ListProposalVotesOutput, error) {
	req, out := c.ListProposalVotesRequest(input)
	return out, req.Send()
}

// ListProposalVotesWithContext is the same as ListProposalVotes with the addition of
// the ability to pass a context and additional request options.
//
// See ListProposalVotes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListProposalVotesWithContext(ctx aws.Context, input *ListProposalVotesInput, opts ...request.Option) (*ListProposalVotesOutput, error) {
	req, out := c.ListProposalVotesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProposalVotesPages iterates over the pages of a ListProposalVotes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProposalVotes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProposalVotes operation.
//    pageNum := 0
//    err := client.ListProposalVotesPages(params,
//        func(page *managedblockchain.ListProposalVotesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ManagedBlockchain) ListProposalVotesPages(input *ListProposalVotesInput, fn func(*ListProposalVotesOutput, bool) bool) error {
	return c.ListProposalVotesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProposalVotesPagesWithContext same as ListProposalVotesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListProposalVotesPagesWithContext(ctx aws.Context, input *ListProposalVotesInput, fn func(*ListProposalVotesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProposalVotesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProposalVotesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProposalVotesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProposals = "ListProposals"

// ListProposalsRequest generates a "aws/request.Request" representing the
// client's request for the ListProposals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProposals for more information on using the ListProposals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProposalsRequest method.
//    req, resp := client.ListProposalsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals
func (c *ManagedBlockchain) ListProposalsRequest(input *ListProposalsInput) (req *request.Request, output *ListProposalsOutput) {
	op := &request.Operation{
		Name:       opListProposals,
		HTTPMethod: "GET",
		HTTPPath:   "/networks/{networkId}/proposals",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProposalsInput{}
	}

	output = &ListProposalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProposals API operation for Amazon Managed Blockchain.
//
// Returns a list of proposals for the network.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation ListProposals for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals
func (c *ManagedBlockchain) ListProposals(input *ListProposalsInput) (*ListProposalsOutput, error) {
	req, out := c.ListProposalsRequest(input)
	return out, req.Send()
}

// ListProposalsWithContext is the same as ListProposals with the addition of
// the ability to pass a context and additional request options.
//
// See ListProposals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListProposalsWithContext(ctx aws.Context, input *ListProposalsInput, opts ...request.Option) (*ListProposalsOutput, error) {
	req, out := c.ListProposalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProposalsPages iterates over the pages of a ListProposals operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProposals method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProposals operation.
//    pageNum := 0
//    err := client.ListProposalsPages(params,
//        func(page *managedblockchain.ListProposalsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ManagedBlockchain) ListProposalsPages(input *ListProposalsInput, fn func(*ListProposalsOutput, bool) bool) error {
	return c.ListProposalsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProposalsPagesWithContext same as ListProposalsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListProposalsPagesWithContext(ctx aws.Context, input *ListProposalsInput, fn func(*ListProposalsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProposalsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProposalsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProposalsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListTagsForResource
func (c *ManagedBlockchain) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Managed Blockchain.
//
// Returns a list of tags for the specified resource. Each tag consists of a
// key and optional value.
//
// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ResourceNotReadyException
//   The requested resource exists but is not in a status that can complete the
//   operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListTagsForResource
func (c *ManagedBlockchain) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectInvitation = "RejectInvitation"

// RejectInvitationRequest generates a "aws/request.Request" representing the
// client's request for the RejectInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectInvitation for more information on using the RejectInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectInvitationRequest method.
//    req, resp := client.RejectInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/RejectInvitation
func (c *ManagedBlockchain) RejectInvitationRequest(input *RejectInvitationInput) (req *request.Request, output *RejectInvitationOutput) {
	op := &request.Operation{
		Name:       opRejectInvitation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/invitations/{invitationId}",
	}

	if input == nil {
		input = &RejectInvitationInput{}
	}

	output = &RejectInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectInvitation API operation for Amazon Managed Blockchain.
//
// Rejects an invitation to join a network. This action can be called by a principal
// in an AWS account that has received an invitation to create a member and
// join a network.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation RejectInvitation for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * IllegalActionException
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/RejectInvitation
func (c *ManagedBlockchain) RejectInvitation(input *RejectInvitationInput) (*RejectInvitationOutput, error) {
	req, out := c.RejectInvitationRequest(input)
	return out, req.Send()
}

// RejectInvitationWithContext is the same as RejectInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See RejectInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) RejectInvitationWithContext(ctx aws.Context, input *RejectInvitationInput, opts ...request.Option) (*RejectInvitationOutput, error) {
	req, out := c.RejectInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/TagResource
func (c *ManagedBlockchain) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Managed Blockchain.
//
// Adds or overwrites the specified tags for the specified Amazon Managed Blockchain
// resource. Each tag consists of a key and optional value.
//
// When you specify a tag key that already exists, the tag value is overwritten
// with the new value. Use UntagResource to remove tag keys.
//
// A resource can have up to 50 tags. If you try to create more than 50 tags
// for a resource, your request fails and returns an error.
//
// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * TooManyTagsException
//
//   * ResourceNotReadyException
//   The requested resource exists but is not in a status that can complete the
//   operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/TagResource
func (c *ManagedBlockchain) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UntagResource
func (c *ManagedBlockchain) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Managed Blockchain.
//
// Removes the specified tags from the Amazon Managed Blockchain resource.
//
// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ResourceNotReadyException
//   The requested resource exists but is not in a status that can complete the
//   operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UntagResource
func (c *ManagedBlockchain) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMember = "UpdateMember"

// UpdateMemberRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMember for more information on using the UpdateMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMemberRequest method.
//    req, resp := client.UpdateMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateMember
func (c *ManagedBlockchain) UpdateMemberRequest(input *UpdateMemberInput) (req *request.Request, output *UpdateMemberOutput) {
	op := &request.Operation{
		Name:       opUpdateMember,
		HTTPMethod: "PATCH",
		HTTPPath:   "/networks/{networkId}/members/{memberId}",
	}

	if input == nil {
		input = &UpdateMemberInput{}
	}

	output = &UpdateMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateMember API operation for Amazon Managed Blockchain.
//
// Updates a member configuration with new parameters.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation UpdateMember for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateMember
func (c *ManagedBlockchain) UpdateMember(input *UpdateMemberInput) (*UpdateMemberOutput, error) {
	req, out := c.UpdateMemberRequest(input)
	return out, req.Send()
}

// UpdateMemberWithContext is the same as UpdateMember with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) UpdateMemberWithContext(ctx aws.Context, input *UpdateMemberInput, opts ...request.Option) (*UpdateMemberOutput, error) {
	req, out := c.UpdateMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNode = "UpdateNode"

// UpdateNodeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNode for more information on using the UpdateNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNodeRequest method.
//    req, resp := client.UpdateNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateNode
func (c *ManagedBlockchain) UpdateNodeRequest(input *UpdateNodeInput) (req *request.Request, output *UpdateNodeOutput) {
	op := &request.Operation{
		Name:       opUpdateNode,
		HTTPMethod: "PATCH",
		HTTPPath:   "/networks/{networkId}/nodes/{nodeId}",
	}

	if input == nil {
		input = &UpdateNodeInput{}
	}

	output = &UpdateNodeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNode API operation for Amazon Managed Blockchain.
//
// Updates a node configuration with new parameters.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation UpdateNode for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateNode
func (c *ManagedBlockchain) UpdateNode(input *UpdateNodeInput) (*UpdateNodeOutput, error) {
	req, out := c.UpdateNodeRequest(input)
	return out, req.Send()
}

// UpdateNodeWithContext is the same as UpdateNode with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) UpdateNodeWithContext(ctx aws.Context, input *UpdateNodeInput, opts ...request.Option) (*UpdateNodeOutput, error) {
	req, out := c.UpdateNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVoteOnProposal = "VoteOnProposal"

// VoteOnProposalRequest generates a "aws/request.Request" representing the
// client's request for the VoteOnProposal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VoteOnProposal for more information on using the VoteOnProposal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the VoteOnProposalRequest method.
//    req, resp := client.VoteOnProposalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/VoteOnProposal
func (c *ManagedBlockchain) VoteOnProposalRequest(input *VoteOnProposalInput) (req *request.Request, output *VoteOnProposalOutput) {
	op := &request.Operation{
		Name:       opVoteOnProposal,
		HTTPMethod: "POST",
		HTTPPath:   "/networks/{networkId}/proposals/{proposalId}/votes",
	}

	if input == nil {
		input = &VoteOnProposalInput{}
	}

	output = &VoteOnProposalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// VoteOnProposal API operation for Amazon Managed Blockchain.
//
// Casts a vote for a specified ProposalId on behalf of a member. The member
// to vote as, specified by VoterMemberId, must be in the same AWS account as
// the principal that calls the action.
//
// Applies only to Hyperledger Fabric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain's
// API operation VoteOnProposal for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The action or operation requested is invalid. Verify that the action is typed
//   correctly.
//
//   * IllegalActionException
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   A requested resource does not exist. It may have been deleted or referenced
//   inaccurately.
//
//   * ThrottlingException
//   The request or operation could not be performed because a service is throttling
//   requests. The most common source of throttling errors is launching EC2 instances
//   such that your service limit for EC2 instances is exceeded. Request a limit
//   increase or delete unused resources if possible.
//
//   * InternalServiceErrorException
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/VoteOnProposal
func (c *ManagedBlockchain) VoteOnProposal(input *VoteOnProposalInput) (*VoteOnProposalOutput, error) {
	req, out := c.VoteOnProposalRequest(input)
	return out, req.Send()
}

// VoteOnProposalWithContext is the same as VoteOnProposal with the addition of
// the ability to pass a context and additional request options.
//
// See VoteOnProposal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchain) VoteOnProposalWithContext(ctx aws.Context, input *VoteOnProposalInput, opts ...request.Option) (*VoteOnProposalOutput, error) {
	req, out := c.VoteOnProposalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A policy type that defines the voting rules for the network. The rules decide
// if a proposal is approved. Approval may be based on criteria such as the
// percentage of YES votes and the duration of the proposal. The policy applies
// to all proposals and is specified when the network is created.
//
// Applies only to Hyperledger Fabric.
type ApprovalThresholdPolicy struct {
	_ struct{} `type:"structure"`

	// The duration from the time that a proposal is created until it expires. If
	// members cast neither the required number of YES votes to approve the proposal
	// nor the number of NO votes required to reject it before the duration expires,
	// the proposal is EXPIRED and ProposalActions are not carried out.
	ProposalDurationInHours *int64 `min:"1" type:"integer"`

	// Determines whether the vote percentage must be greater than the ThresholdPercentage
	// or must be greater than or equal to the ThreholdPercentage to be approved.
	ThresholdComparator *string `type:"string" enum:"ThresholdComparator"`

	// The percentage of votes among all members that must be YES for a proposal
	// to be approved. For example, a ThresholdPercentage value of 50 indicates
	// 50%. The ThresholdComparator determines the precise comparison. If a ThresholdPercentage
	// value of 50 is specified on a network with 10 members, along with a ThresholdComparator
	// value of GREATER_THAN, this indicates that 6 YES votes are required for the
	// proposal to be approved.
	ThresholdPercentage *int64 `type:"integer"`
}

// String returns the string representation
func (s ApprovalThresholdPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApprovalThresholdPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApprovalThresholdPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApprovalThresholdPolicy"}
	if s.ProposalDurationInHours != nil && *s.ProposalDurationInHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ProposalDurationInHours", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProposalDurationInHours sets the ProposalDurationInHours field's value.
func (s *ApprovalThresholdPolicy) SetProposalDurationInHours(v int64) *ApprovalThresholdPolicy {
	s.ProposalDurationInHours = &v
	return s
}

// SetThresholdComparator sets the ThresholdComparator field's value.
func (s *ApprovalThresholdPolicy) SetThresholdComparator(v string) *ApprovalThresholdPolicy {
	s.ThresholdComparator = &v
	return s
}

// SetThresholdPercentage sets the ThresholdPercentage field's value.
func (s *ApprovalThresholdPolicy) SetThresholdPercentage(v int64) *ApprovalThresholdPolicy {
	s.ThresholdPercentage = &v
	return s
}

type CreateMemberInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the operation. An idempotent operation completes no more than one time.
	// This identifier is required only if you make a service request directly using
	// an HTTP client. It is generated automatically if you use an AWS SDK or the
	// AWS CLI.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The unique identifier of the invitation that is sent to the member to join
	// the network.
	//
	// InvitationId is a required field
	InvitationId *string `min:"1" type:"string" required:"true"`

	// Member configuration parameters.
	//
	// MemberConfiguration is a required field
	MemberConfiguration *MemberConfiguration `type:"structure" required:"true"`

	// The unique identifier of the network in which the member is created.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMemberInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}
	if s.InvitationId != nil && len(*s.InvitationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InvitationId", 1))
	}
	if s.MemberConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberConfiguration"))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.MemberConfiguration != nil {
		if err := s.MemberConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MemberConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMemberInput) SetClientRequestToken(v string) *CreateMemberInput {
	s.ClientRequestToken = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *CreateMemberInput) SetInvitationId(v string) *CreateMemberInput {
	s.InvitationId = &v
	return s
}

// SetMemberConfiguration sets the MemberConfiguration field's value.
func (s *CreateMemberInput) SetMemberConfiguration(v *MemberConfiguration) *CreateMemberInput {
	s.MemberConfiguration = v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *CreateMemberInput) SetNetworkId(v string) *CreateMemberInput {
	s.NetworkId = &v
	return s
}

type CreateMemberOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member.
	MemberId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMemberOutput) GoString() string {
	return s.String()
}

// SetMemberId sets the MemberId field's value.
func (s *CreateMemberOutput) SetMemberId(v string) *CreateMemberOutput {
	s.MemberId = &v
	return s
}

type CreateNetworkInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the operation. An idempotent operation completes no more than one time.
	// This identifier is required only if you make a service request directly using
	// an HTTP client. It is generated automatically if you use an AWS SDK or the
	// AWS CLI.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// An optional description for the network.
	Description *string `type:"string"`

	// The blockchain framework that the network uses.
	//
	// Framework is a required field
	Framework *string `type:"string" required:"true" enum:"Framework"`

	// Configuration properties of the blockchain framework relevant to the network
	// configuration.
	FrameworkConfiguration *NetworkFrameworkConfiguration `type:"structure"`

	// The version of the blockchain framework that the network uses.
	//
	// FrameworkVersion is a required field
	FrameworkVersion *string `min:"1" type:"string" required:"true"`

	// Configuration properties for the first member within the network.
	//
	// MemberConfiguration is a required field
	MemberConfiguration *MemberConfiguration `type:"structure" required:"true"`

	// The name of the network.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Tags to assign to the network. Each tag consists of a key and optional value.
	//
	// When specifying tags during creation, you can specify multiple key-value
	// pairs in a single request, with an overall maximum of 50 tags added to each
	// resource.
	//
	// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]*string `type:"map"`

	// The voting rules used by the network to determine if a proposal is approved.
	//
	// VotingPolicy is a required field
	VotingPolicy *VotingPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Framework == nil {
		invalidParams.Add(request.NewErrParamRequired("Framework"))
	}
	if s.FrameworkVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkVersion"))
	}
	if s.FrameworkVersion != nil && len(*s.FrameworkVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FrameworkVersion", 1))
	}
	if s.MemberConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberConfiguration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VotingPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("VotingPolicy"))
	}
	if s.FrameworkConfiguration != nil {
		if err := s.FrameworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FrameworkConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.MemberConfiguration != nil {
		if err := s.MemberConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MemberConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VotingPolicy != nil {
		if err := s.VotingPolicy.Validate(); err != nil {
			invalidParams.AddNested("VotingPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNetworkInput) SetClientRequestToken(v string) *CreateNetworkInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNetworkInput) SetDescription(v string) *CreateNetworkInput {
	s.Description = &v
	return s
}

// SetFramework sets the Framework field's value.
func (s *CreateNetworkInput) SetFramework(v string) *CreateNetworkInput {
	s.Framework = &v
	return s
}

// SetFrameworkConfiguration sets the FrameworkConfiguration field's value.
func (s *CreateNetworkInput) SetFrameworkConfiguration(v *NetworkFrameworkConfiguration) *CreateNetworkInput {
	s.FrameworkConfiguration = v
	return s
}

// SetFrameworkVersion sets the FrameworkVersion field's value.
func (s *CreateNetworkInput) SetFrameworkVersion(v string) *CreateNetworkInput {
	s.FrameworkVersion = &v
	return s
}

// SetMemberConfiguration sets the MemberConfiguration field's value.
func (s *CreateNetworkInput) SetMemberConfiguration(v *MemberConfiguration) *CreateNetworkInput {
	s.MemberConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNetworkInput) SetName(v string) *CreateNetworkInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkInput) SetTags(v map[string]*string) *CreateNetworkInput {
	s.Tags = v
	return s
}

// SetVotingPolicy sets the VotingPolicy field's value.
func (s *CreateNetworkInput) SetVotingPolicy(v *VotingPolicy) *CreateNetworkInput {
	s.VotingPolicy = v
	return s
}

type CreateNetworkOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the first member within the network.
	MemberId *string `min:"1" type:"string"`

	// The unique identifier for the network.
	NetworkId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkOutput) GoString() string {
	return s.String()
}

// SetMemberId sets the MemberId field's value.
func (s *CreateNetworkOutput) SetMemberId(v string) *CreateNetworkOutput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *CreateNetworkOutput) SetNetworkId(v string) *CreateNetworkOutput {
	s.NetworkId = &v
	return s
}

type CreateNodeInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the operation. An idempotent operation completes no more than one time.
	// This identifier is required only if you make a service request directly using
	// an HTTP client. It is generated automatically if you use an AWS SDK or the
	// AWS CLI.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The unique identifier of the member that owns this node.
	//
	// Applies only to Hyperledger Fabric.
	MemberId *string `min:"1" type:"string"`

	// The unique identifier of the network for the node.
	//
	// Ethereum public networks have the following NetworkIds:
	//
	//    * n-ethereum-mainnet
	//
	//    * n-ethereum-rinkeby
	//
	//    * n-ethereum-ropsten
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The properties of a node configuration.
	//
	// NodeConfiguration is a required field
	NodeConfiguration *NodeConfiguration `type:"structure" required:"true"`

	// Tags to assign to the node. Each tag consists of a key and optional value.
	//
	// When specifying tags during creation, you can specify multiple key-value
	// pairs in a single request, with an overall maximum of 50 tags added to each
	// resource.
	//
	// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNodeInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.NodeConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeConfiguration"))
	}
	if s.NodeConfiguration != nil {
		if err := s.NodeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NodeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNodeInput) SetClientRequestToken(v string) *CreateNodeInput {
	s.ClientRequestToken = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *CreateNodeInput) SetMemberId(v string) *CreateNodeInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *CreateNodeInput) SetNetworkId(v string) *CreateNodeInput {
	s.NetworkId = &v
	return s
}

// SetNodeConfiguration sets the NodeConfiguration field's value.
func (s *CreateNodeInput) SetNodeConfiguration(v *NodeConfiguration) *CreateNodeInput {
	s.NodeConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNodeInput) SetTags(v map[string]*string) *CreateNodeInput {
	s.Tags = v
	return s
}

type CreateNodeOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the node.
	NodeId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNodeOutput) GoString() string {
	return s.String()
}

// SetNodeId sets the NodeId field's value.
func (s *CreateNodeOutput) SetNodeId(v string) *CreateNodeOutput {
	s.NodeId = &v
	return s
}

type CreateProposalInput struct {
	_ struct{} `type:"structure"`

	// The type of actions proposed, such as inviting a member or removing a member.
	// The types of Actions in a proposal are mutually exclusive. For example, a
	// proposal with Invitations actions cannot also contain Removals actions.
	//
	// Actions is a required field
	Actions *ProposalActions `type:"structure" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the operation. An idempotent operation completes no more than one time.
	// This identifier is required only if you make a service request directly using
	// an HTTP client. It is generated automatically if you use an AWS SDK or the
	// AWS CLI.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description for the proposal that is visible to voting members, for example,
	// "Proposal to add Example Corp. as member."
	Description *string `type:"string"`

	// The unique identifier of the member that is creating the proposal. This identifier
	// is especially useful for identifying the member making the proposal when
	// multiple members exist in a single AWS account.
	//
	// MemberId is a required field
	MemberId *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the network for which the proposal is made.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// Tags to assign to the proposal. Each tag consists of a key and optional value.
	//
	// When specifying tags during creation, you can specify multiple key-value
	// pairs in a single request, with an overall maximum of 50 tags added to each
	// resource. If the proposal is for a network invitation, the invitation inherits
	// the tags added to the proposal.
	//
	// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateProposalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProposalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProposalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProposalInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.Actions != nil {
		if err := s.Actions.Validate(); err != nil {
			invalidParams.AddNested("Actions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateProposalInput) SetActions(v *ProposalActions) *CreateProposalInput {
	s.Actions = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProposalInput) SetClientRequestToken(v string) *CreateProposalInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateProposalInput) SetDescription(v string) *CreateProposalInput {
	s.Description = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *CreateProposalInput) SetMemberId(v string) *CreateProposalInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *CreateProposalInput) SetNetworkId(v string) *CreateProposalInput {
	s.NetworkId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProposalInput) SetTags(v map[string]*string) *CreateProposalInput {
	s.Tags = v
	return s
}

type CreateProposalOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the proposal.
	ProposalId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateProposalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProposalOutput) GoString() string {
	return s.String()
}

// SetProposalId sets the ProposalId field's value.
func (s *CreateProposalOutput) SetProposalId(v string) *CreateProposalOutput {
	s.ProposalId = &v
	return s
}

type DeleteMemberInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member to remove.
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"memberId" min:"1" type:"string" required:"true"`

	// The unique identifier of the network from which the member is removed.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMemberInput"}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberId sets the MemberId field's value.
func (s *DeleteMemberInput) SetMemberId(v string) *DeleteMemberInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *DeleteMemberInput) SetNetworkId(v string) *DeleteMemberInput {
	s.NetworkId = &v
	return s
}

type DeleteMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMemberOutput) GoString() string {
	return s.String()
}

type DeleteNodeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member that owns this node.
	//
	// Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.
	MemberId *string `location:"querystring" locationName:"memberId" min:"1" type:"string"`

	// The unique identifier of the network that the node is on.
	//
	// Ethereum public networks have the following NetworkIds:
	//
	//    * n-ethereum-mainnet
	//
	//    * n-ethereum-rinkeby
	//
	//    * n-ethereum-ropsten
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The unique identifier of the node.
	//
	// NodeId is a required field
	NodeId *string `location:"uri" locationName:"nodeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNodeInput"}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.NodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeId"))
	}
	if s.NodeId != nil && len(*s.NodeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberId sets the MemberId field's value.
func (s *DeleteNodeInput) SetMemberId(v string) *DeleteNodeInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *DeleteNodeInput) SetNetworkId(v string) *DeleteNodeInput {
	s.NetworkId = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *DeleteNodeInput) SetNodeId(v string) *DeleteNodeInput {
	s.NodeId = &v
	return s
}

type DeleteNodeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNodeOutput) GoString() string {
	return s.String()
}

type GetMemberInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member.
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"memberId" min:"1" type:"string" required:"true"`

	// The unique identifier of the network to which the member belongs.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMemberInput"}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberId sets the MemberId field's value.
func (s *GetMemberInput) SetMemberId(v string) *GetMemberInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *GetMemberInput) SetNetworkId(v string) *GetMemberInput {
	s.NetworkId = &v
	return s
}

type GetMemberOutput struct {
	_ struct{} `type:"structure"`

	// The properties of a member.
	Member *Member `type:"structure"`
}

// String returns the string representation
func (s GetMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMemberOutput) GoString() string {
	return s.String()
}

// SetMember sets the Member field's value.
func (s *GetMemberOutput) SetMember(v *Member) *GetMemberOutput {
	s.Member = v
	return s
}

type GetNetworkInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the network to get information about.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNetworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNetworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNetworkInput"}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkId sets the NetworkId field's value.
func (s *GetNetworkInput) SetNetworkId(v string) *GetNetworkInput {
	s.NetworkId = &v
	return s
}

type GetNetworkOutput struct {
	_ struct{} `type:"structure"`

	// An object containing network configuration parameters.
	Network *Network `type:"structure"`
}

// String returns the string representation
func (s GetNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNetworkOutput) GoString() string {
	return s.String()
}

// SetNetwork sets the Network field's value.
func (s *GetNetworkOutput) SetNetwork(v *Network) *GetNetworkOutput {
	s.Network = v
	return s
}

type GetNodeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member that owns the node.
	//
	// Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.
	MemberId *string `location:"querystring" locationName:"memberId" min:"1" type:"string"`

	// The unique identifier of the network that the node is on.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The unique identifier of the node.
	//
	// NodeId is a required field
	NodeId *string `location:"uri" locationName:"nodeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNodeInput"}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.NodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeId"))
	}
	if s.NodeId != nil && len(*s.NodeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberId sets the MemberId field's value.
func (s *GetNodeInput) SetMemberId(v string) *GetNodeInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *GetNodeInput) SetNetworkId(v string) *GetNodeInput {
	s.NetworkId = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *GetNodeInput) SetNodeId(v string) *GetNodeInput {
	s.NodeId = &v
	return s
}

type GetNodeOutput struct {
	_ struct{} `type:"structure"`

	// Properties of the node configuration.
	Node *Node `type:"structure"`
}

// String returns the string representation
func (s GetNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNodeOutput) GoString() string {
	return s.String()
}

// SetNode sets the Node field's value.
func (s *GetNodeOutput) SetNode(v *Node) *GetNodeOutput {
	s.Node = v
	return s
}

type GetProposalInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the network for which the proposal is made.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The unique identifier of the proposal.
	//
	// ProposalId is a required field
	ProposalId *string `location:"uri" locationName:"proposalId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetProposalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProposalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProposalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProposalInput"}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.ProposalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProposalId"))
	}
	if s.ProposalId != nil && len(*s.ProposalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProposalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkId sets the NetworkId field's value.
func (s *GetProposalInput) SetNetworkId(v string) *GetProposalInput {
	s.NetworkId = &v
	return s
}

// SetProposalId sets the ProposalId field's value.
func (s *GetProposalInput) SetProposalId(v string) *GetProposalInput {
	s.ProposalId = &v
	return s
}

type GetProposalOutput struct {
	_ struct{} `type:"structure"`

	// Information about a proposal.
	Proposal *Proposal `type:"structure"`
}

// String returns the string representation
func (s GetProposalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProposalOutput) GoString() string {
	return s.String()
}

// SetProposal sets the Proposal field's value.
func (s *GetProposalOutput) SetProposal(v *Proposal) *GetProposalOutput {
	s.Proposal = v
	return s
}

type IllegalActionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s IllegalActionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IllegalActionException) GoString() string {
	return s.String()
}

func newErrorIllegalActionException(v protocol.ResponseMetadata) error {
	return &IllegalActionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IllegalActionException) Code() string {
	return "IllegalActionException"
}

// Message returns the exception's message.
func (s *IllegalActionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IllegalActionException) OrigErr() error {
	return nil
}

func (s *IllegalActionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IllegalActionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IllegalActionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request processing has failed because of an unknown error, exception
// or failure.
type InternalServiceErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s *InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The action or operation requested is invalid. Verify that the action is typed
// correctly.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An invitation to an AWS account to create a member and join the network.
//
// Applies only to Hyperledger Fabric.
type Invitation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the invitation. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The date and time that the invitation was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date and time that the invitation expires. This is the CreationDate plus
	// the ProposalDurationInHours that is specified in the ProposalThresholdPolicy.
	// After this date and time, the invitee can no longer create a member and join
	// the network using this InvitationId.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier for the invitation.
	InvitationId *string `min:"1" type:"string"`

	// A summary of network configuration properties.
	NetworkSummary *NetworkSummary `type:"structure"`

	// The status of the invitation:
	//
	//    * PENDING - The invitee has not created a member to join the network,
	//    and the invitation has not yet expired.
	//
	//    * ACCEPTING - The invitee has begun creating a member, and creation has
	//    not yet completed.
	//
	//    * ACCEPTED - The invitee created a member and joined the network using
	//    the InvitationID.
	//
	//    * REJECTED - The invitee rejected the invitation.
	//
	//    * EXPIRED - The invitee neither created a member nor rejected the invitation
	//    before the ExpirationDate.
	Status *string `type:"string" enum:"InvitationStatus"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invitation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Invitation) SetArn(v string) *Invitation {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Invitation) SetCreationDate(v time.Time) *Invitation {
	s.CreationDate = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *Invitation) SetExpirationDate(v time.Time) *Invitation {
	s.ExpirationDate = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Invitation) SetInvitationId(v string) *Invitation {
	s.InvitationId = &v
	return s
}

// SetNetworkSummary sets the NetworkSummary field's value.
func (s *Invitation) SetNetworkSummary(v *NetworkSummary) *Invitation {
	s.NetworkSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Invitation) SetStatus(v string) *Invitation {
	s.Status = &v
	return s
}

// An action to invite a specific AWS account to create a member and join the
// network. The InviteAction is carried out when a Proposal is APPROVED.
//
// Applies only to Hyperledger Fabric.
type InviteAction struct {
	_ struct{} `type:"structure"`

	// The AWS account ID to invite.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InviteAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteAction"}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrincipal sets the Principal field's value.
func (s *InviteAction) SetPrincipal(v string) *InviteAction {
	s.Principal = &v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of invitations to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The invitations for the network.
	Invitations []*Invitation `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*Invitation) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// An optional Boolean value. If provided, the request is limited either to
	// members that the current AWS account owns (true) or that other AWS accounts
	// own (false). If omitted, all members are listed.
	IsOwned *bool `location:"querystring" locationName:"isOwned" type:"boolean"`

	// The maximum number of members to return in the request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The optional name of the member to list.
	Name *string `location:"querystring" locationName:"name" type:"string"`

	// The unique identifier of the network for which to list members.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An optional status specifier. If provided, only members currently in this
	// status are listed.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"MemberStatus"`
}

// String returns the string representation
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsOwned sets the IsOwned field's value.
func (s *ListMembersInput) SetIsOwned(v bool) *ListMembersInput {
	s.IsOwned = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListMembersInput) SetName(v string) *ListMembersInput {
	s.Name = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *ListMembersInput) SetNetworkId(v string) *ListMembersInput {
	s.NetworkId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMembersInput) SetStatus(v string) *ListMembersInput {
	s.Status = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// An array of MemberSummary objects. Each object contains details about a network
	// member.
	Members []*MemberSummary `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListMembersOutput) SetMembers(v []*MemberSummary) *ListMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListNetworksInput struct {
	_ struct{} `type:"structure"`

	// An optional framework specifier. If provided, only networks of this framework
	// type are listed.
	Framework *string `location:"querystring" locationName:"framework" type:"string" enum:"Framework"`

	// The maximum number of networks to list.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the network.
	Name *string `location:"querystring" locationName:"name" type:"string"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An optional status specifier. If provided, only networks currently in this
	// status are listed.
	//
	// Applies only to Hyperledger Fabric.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"NetworkStatus"`
}

// String returns the string representation
func (s ListNetworksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNetworksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNetworksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNetworksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFramework sets the Framework field's value.
func (s *ListNetworksInput) SetFramework(v string) *ListNetworksInput {
	s.Framework = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNetworksInput) SetMaxResults(v int64) *ListNetworksInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListNetworksInput) SetName(v string) *ListNetworksInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworksInput) SetNextToken(v string) *ListNetworksInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListNetworksInput) SetStatus(v string) *ListNetworksInput {
	s.Status = &v
	return s
}

type ListNetworksOutput struct {
	_ struct{} `type:"structure"`

	// An array of NetworkSummary objects that contain configuration properties
	// for each network.
	Networks []*NetworkSummary `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListNetworksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNetworksOutput) GoString() string {
	return s.String()
}

// SetNetworks sets the Networks field's value.
func (s *ListNetworksOutput) SetNetworks(v []*NetworkSummary) *ListNetworksOutput {
	s.Networks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNetworksOutput) SetNextToken(v string) *ListNetworksOutput {
	s.NextToken = &v
	return s
}

type ListNodesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of nodes to list.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The unique identifier of the member who owns the nodes to list.
	//
	// Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.
	MemberId *string `location:"querystring" locationName:"memberId" min:"1" type:"string"`

	// The unique identifier of the network for which to list nodes.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An optional status specifier. If provided, only nodes currently in this status
	// are listed.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"NodeStatus"`
}

// String returns the string representation
func (s ListNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodesInput) SetMaxResults(v int64) *ListNodesInput {
	s.MaxResults = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *ListNodesInput) SetMemberId(v string) *ListNodesInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *ListNodesInput) SetNetworkId(v string) *ListNodesInput {
	s.NetworkId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesInput) SetNextToken(v string) *ListNodesInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListNodesInput) SetStatus(v string) *ListNodesInput {
	s.Status = &v
	return s
}

type ListNodesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `type:"string"`

	// An array of NodeSummary objects that contain configuration properties for
	// each node.
	Nodes []*NodeSummary `type:"list"`
}

// String returns the string representation
func (s ListNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesOutput) SetNextToken(v string) *ListNodesOutput {
	s.NextToken = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *ListNodesOutput) SetNodes(v []*NodeSummary) *ListNodesOutput {
	s.Nodes = v
	return s
}

type ListProposalVotesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of votes to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The unique identifier of the network.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The unique identifier of the proposal.
	//
	// ProposalId is a required field
	ProposalId *string `location:"uri" locationName:"proposalId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProposalVotesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProposalVotesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProposalVotesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProposalVotesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.ProposalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProposalId"))
	}
	if s.ProposalId != nil && len(*s.ProposalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProposalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProposalVotesInput) SetMaxResults(v int64) *ListProposalVotesInput {
	s.MaxResults = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *ListProposalVotesInput) SetNetworkId(v string) *ListProposalVotesInput {
	s.NetworkId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProposalVotesInput) SetNextToken(v string) *ListProposalVotesInput {
	s.NextToken = &v
	return s
}

// SetProposalId sets the ProposalId field's value.
func (s *ListProposalVotesInput) SetProposalId(v string) *ListProposalVotesInput {
	s.ProposalId = &v
	return s
}

type ListProposalVotesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `type:"string"`

	// The list of votes.
	ProposalVotes []*VoteSummary `type:"list"`
}

// String returns the string representation
func (s ListProposalVotesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProposalVotesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProposalVotesOutput) SetNextToken(v string) *ListProposalVotesOutput {
	s.NextToken = &v
	return s
}

// SetProposalVotes sets the ProposalVotes field's value.
func (s *ListProposalVotesOutput) SetProposalVotes(v []*VoteSummary) *ListProposalVotesOutput {
	s.ProposalVotes = v
	return s
}

type ListProposalsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of proposals to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The unique identifier of the network.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListProposalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProposalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProposalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProposalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProposalsInput) SetMaxResults(v int64) *ListProposalsInput {
	s.MaxResults = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *ListProposalsInput) SetNetworkId(v string) *ListProposalsInput {
	s.NetworkId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProposalsInput) SetNextToken(v string) *ListProposalsInput {
	s.NextToken = &v
	return s
}

type ListProposalsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `type:"string"`

	// The summary of each proposal made on the network.
	Proposals []*ProposalSummary `type:"list"`
}

// String returns the string representation
func (s ListProposalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProposalsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProposalsOutput) SetNextToken(v string) *ListProposalsOutput {
	s.NextToken = &v
	return s
}

// SetProposals sets the Proposals field's value.
func (s *ListProposalsOutput) SetProposals(v []*ProposalSummary) *ListProposalsOutput {
	s.Proposals = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags assigned to the resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A configuration for logging events.
type LogConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether logging is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s LogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogConfiguration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *LogConfiguration) SetEnabled(v bool) *LogConfiguration {
	s.Enabled = &v
	return s
}

// A collection of log configurations.
type LogConfigurations struct {
	_ struct{} `type:"structure"`

	// Parameters for publishing logs to Amazon CloudWatch Logs.
	Cloudwatch *LogConfiguration `type:"structure"`
}

// String returns the string representation
func (s LogConfigurations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogConfigurations) GoString() string {
	return s.String()
}

// SetCloudwatch sets the Cloudwatch field's value.
func (s *LogConfigurations) SetCloudwatch(v *LogConfiguration) *LogConfigurations {
	s.Cloudwatch = v
	return s
}

// Member configuration properties.
//
// Applies only to Hyperledger Fabric.
type Member struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the member. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The date and time that the member was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional description for the member.
	Description *string `type:"string"`

	// Attributes relevant to a member for the blockchain framework that the Managed
	// Blockchain network uses.
	FrameworkAttributes *MemberFrameworkAttributes `type:"structure"`

	// The unique identifier of the member.
	Id *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management
	// Service (AWS KMS) that the member uses for encryption at rest. If the value
	// of this parameter is "AWS Owned KMS Key", the member uses an AWS owned KMS
	// key for encryption. This parameter is inherited by the nodes that this member
	// owns.
	KmsKeyArn *string `type:"string"`

	// Configuration properties for logging events associated with a member.
	LogPublishingConfiguration *MemberLogPublishingConfiguration `type:"structure"`

	// The name of the member.
	Name *string `min:"1" type:"string"`

	// The unique identifier of the network to which the member belongs.
	NetworkId *string `min:"1" type:"string"`

	// The status of a member.
	//
	//    * CREATING - The AWS account is in the process of creating a member.
	//
	//    * AVAILABLE - The member has been created and can participate in the network.
	//
	//    * CREATE_FAILED - The AWS account attempted to create a member and creation
	//    failed.
	//
	//    * UPDATING - The member is in the process of being updated.
	//
	//    * DELETING - The member and all associated resources are in the process
	//    of being deleted. Either the AWS account that owns the member deleted
	//    it, or the member is being deleted as the result of an APPROVED PROPOSAL
	//    to remove the member.
	//
	//    * DELETED - The member can no longer participate on the network and all
	//    associated resources are deleted. Either the AWS account that owns the
	//    member deleted it, or the member is being deleted as the result of an
	//    APPROVED PROPOSAL to remove the member.
	//
	//    * INACCESSIBLE_ENCRYPTION_KEY - The member is impaired and might not function
	//    as expected because it cannot access the specified customer managed key
	//    in AWS KMS for encryption at rest. Either the KMS key was disabled or
	//    deleted, or the grants on the key were revoked. The effect of disabling
	//    or deleting a key, or revoking a grant is not immediate. The member resource
	//    might take some time to find that the key is inaccessible. When a resource
	//    is in this state, we recommend deleting and recreating the resource.
	Status *string `type:"string" enum:"MemberStatus"`

	// Tags assigned to the member. Tags consist of a key and optional value. For
	// more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Member) SetArn(v string) *Member {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Member) SetCreationDate(v time.Time) *Member {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Member) SetDescription(v string) *Member {
	s.Description = &v
	return s
}

// SetFrameworkAttributes sets the FrameworkAttributes field's value.
func (s *Member) SetFrameworkAttributes(v *MemberFrameworkAttributes) *Member {
	s.FrameworkAttributes = v
	return s
}

// SetId sets the Id field's value.
func (s *Member) SetId(v string) *Member {
	s.Id = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *Member) SetKmsKeyArn(v string) *Member {
	s.KmsKeyArn = &v
	return s
}

// SetLogPublishingConfiguration sets the LogPublishingConfiguration field's value.
func (s *Member) SetLogPublishingConfiguration(v *MemberLogPublishingConfiguration) *Member {
	s.LogPublishingConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *Member) SetName(v string) *Member {
	s.Name = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *Member) SetNetworkId(v string) *Member {
	s.NetworkId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Member) SetStatus(v string) *Member {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Member) SetTags(v map[string]*string) *Member {
	s.Tags = v
	return s
}

// Configuration properties of the member.
//
// Applies only to Hyperledger Fabric.
type MemberConfiguration struct {
	_ struct{} `type:"structure"`

	// An optional description of the member.
	Description *string `type:"string"`

	// Configuration properties of the blockchain framework relevant to the member.
	//
	// FrameworkConfiguration is a required field
	FrameworkConfiguration *MemberFrameworkConfiguration `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management
	// Service (AWS KMS) to use for encryption at rest in the member. This parameter
	// is inherited by any nodes that this member creates.
	//
	// Use one of the following options to specify this parameter:
	//
	//    * Undefined or empty string - The member uses an AWS owned KMS key for
	//    encryption by default.
	//
	//    * A valid symmetric customer managed KMS key - The member uses the specified
	//    key for encryption. Amazon Managed Blockchain doesn't support asymmetric
	//    keys. For more information, see Using symmetric and asymmetric keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	//    in the AWS Key Management Service Developer Guide. The following is an
	//    example of a KMS key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	KmsKeyArn *string `min:"1" type:"string"`

	// Configuration properties for logging events associated with a member of a
	// Managed Blockchain network.
	LogPublishingConfiguration *MemberLogPublishingConfiguration `type:"structure"`

	// The name of the member.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Tags assigned to the member. Tags consist of a key and optional value. For
	// more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	//
	// When specifying tags during creation, you can specify multiple key-value
	// pairs in a single request, with an overall maximum of 50 tags added to each
	// resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s MemberConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberConfiguration"}
	if s.FrameworkConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkConfiguration"))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.FrameworkConfiguration != nil {
		if err := s.FrameworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FrameworkConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *MemberConfiguration) SetDescription(v string) *MemberConfiguration {
	s.Description = &v
	return s
}

// SetFrameworkConfiguration sets the FrameworkConfiguration field's value.
func (s *MemberConfiguration) SetFrameworkConfiguration(v *MemberFrameworkConfiguration) *MemberConfiguration {
	s.FrameworkConfiguration = v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *MemberConfiguration) SetKmsKeyArn(v string) *MemberConfiguration {
	s.KmsKeyArn = &v
	return s
}

// SetLogPublishingConfiguration sets the LogPublishingConfiguration field's value.
func (s *MemberConfiguration) SetLogPublishingConfiguration(v *MemberLogPublishingConfiguration) *MemberConfiguration {
	s.LogPublishingConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *MemberConfiguration) SetName(v string) *MemberConfiguration {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MemberConfiguration) SetTags(v map[string]*string) *MemberConfiguration {
	s.Tags = v
	return s
}

// Attributes of Hyperledger Fabric for a member in a Managed Blockchain network
// using the Hyperledger Fabric framework.
type MemberFabricAttributes struct {
	_ struct{} `type:"structure"`

	// The user name for the initial administrator user for the member.
	AdminUsername *string `min:"1" type:"string"`

	// The endpoint used to access the member's certificate authority.
	CaEndpoint *string `type:"string"`
}

// String returns the string representation
func (s MemberFabricAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberFabricAttributes) GoString() string {
	return s.String()
}

// SetAdminUsername sets the AdminUsername field's value.
func (s *MemberFabricAttributes) SetAdminUsername(v string) *MemberFabricAttributes {
	s.AdminUsername = &v
	return s
}

// SetCaEndpoint sets the CaEndpoint field's value.
func (s *MemberFabricAttributes) SetCaEndpoint(v string) *MemberFabricAttributes {
	s.CaEndpoint = &v
	return s
}

// Configuration properties for Hyperledger Fabric for a member in a Managed
// Blockchain network using the Hyperledger Fabric framework.
type MemberFabricConfiguration struct {
	_ struct{} `type:"structure"`

	// The password for the member's initial administrative user. The AdminPassword
	// must be at least eight characters long and no more than 32 characters. It
	// must contain at least one uppercase letter, one lowercase letter, and one
	// digit. It cannot have a single quotation mark (‘), a double quotation marks
	// (“), a forward slash(/), a backward slash(\), @, or a space.
	//
	// AdminPassword is a required field
	AdminPassword *string `min:"8" type:"string" required:"true" sensitive:"true"`

	// The user name for the member's initial administrative user.
	//
	// AdminUsername is a required field
	AdminUsername *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MemberFabricConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberFabricConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberFabricConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberFabricConfiguration"}
	if s.AdminPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminPassword"))
	}
	if s.AdminPassword != nil && len(*s.AdminPassword) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("AdminPassword", 8))
	}
	if s.AdminUsername == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminUsername"))
	}
	if s.AdminUsername != nil && len(*s.AdminUsername) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdminUsername", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminPassword sets the AdminPassword field's value.
func (s *MemberFabricConfiguration) SetAdminPassword(v string) *MemberFabricConfiguration {
	s.AdminPassword = &v
	return s
}

// SetAdminUsername sets the AdminUsername field's value.
func (s *MemberFabricConfiguration) SetAdminUsername(v string) *MemberFabricConfiguration {
	s.AdminUsername = &v
	return s
}

// Configuration properties for logging events associated with a member of a
// Managed Blockchain network using the Hyperledger Fabric framework.
type MemberFabricLogPublishingConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration properties for logging events associated with a member's Certificate
	// Authority (CA). CA logs help you determine when a member in your account
	// joins the network, or when new peers register with a member CA.
	CaLogs *LogConfigurations `type:"structure"`
}

// String returns the string representation
func (s MemberFabricLogPublishingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberFabricLogPublishingConfiguration) GoString() string {
	return s.String()
}

// SetCaLogs sets the CaLogs field's value.
func (s *MemberFabricLogPublishingConfiguration) SetCaLogs(v *LogConfigurations) *MemberFabricLogPublishingConfiguration {
	s.CaLogs = v
	return s
}

// Attributes relevant to a member for the blockchain framework that the Managed
// Blockchain network uses.
type MemberFrameworkAttributes struct {
	_ struct{} `type:"structure"`

	// Attributes of Hyperledger Fabric relevant to a member on a Managed Blockchain
	// network that uses Hyperledger Fabric.
	Fabric *MemberFabricAttributes `type:"structure"`
}

// String returns the string representation
func (s MemberFrameworkAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberFrameworkAttributes) GoString() string {
	return s.String()
}

// SetFabric sets the Fabric field's value.
func (s *MemberFrameworkAttributes) SetFabric(v *MemberFabricAttributes) *MemberFrameworkAttributes {
	s.Fabric = v
	return s
}

// Configuration properties relevant to a member for the blockchain framework
// that the Managed Blockchain network uses.
type MemberFrameworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Attributes of Hyperledger Fabric for a member on a Managed Blockchain network
	// that uses Hyperledger Fabric.
	Fabric *MemberFabricConfiguration `type:"structure"`
}

// String returns the string representation
func (s MemberFrameworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberFrameworkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberFrameworkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberFrameworkConfiguration"}
	if s.Fabric != nil {
		if err := s.Fabric.Validate(); err != nil {
			invalidParams.AddNested("Fabric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFabric sets the Fabric field's value.
func (s *MemberFrameworkConfiguration) SetFabric(v *MemberFabricConfiguration) *MemberFrameworkConfiguration {
	s.Fabric = v
	return s
}

// Configuration properties for logging events associated with a member of a
// Managed Blockchain network.
type MemberLogPublishingConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration properties for logging events associated with a member of a
	// Managed Blockchain network using the Hyperledger Fabric framework.
	Fabric *MemberFabricLogPublishingConfiguration `type:"structure"`
}

// String returns the string representation
func (s MemberLogPublishingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberLogPublishingConfiguration) GoString() string {
	return s.String()
}

// SetFabric sets the Fabric field's value.
func (s *MemberLogPublishingConfiguration) SetFabric(v *MemberFabricLogPublishingConfiguration) *MemberLogPublishingConfiguration {
	s.Fabric = v
	return s
}

// A summary of configuration properties for a member.
//
// Applies only to Hyperledger Fabric.
type MemberSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the member. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The date and time that the member was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional description of the member.
	Description *string `type:"string"`

	// The unique identifier of the member.
	Id *string `min:"1" type:"string"`

	// An indicator of whether the member is owned by your AWS account or a different
	// AWS account.
	IsOwned *bool `type:"boolean"`

	// The name of the member.
	Name *string `min:"1" type:"string"`

	// The status of the member.
	//
	//    * CREATING - The AWS account is in the process of creating a member.
	//
	//    * AVAILABLE - The member has been created and can participate in the network.
	//
	//    * CREATE_FAILED - The AWS account attempted to create a member and creation
	//    failed.
	//
	//    * UPDATING - The member is in the process of being updated.
	//
	//    * DELETING - The member and all associated resources are in the process
	//    of being deleted. Either the AWS account that owns the member deleted
	//    it, or the member is being deleted as the result of an APPROVED PROPOSAL
	//    to remove the member.
	//
	//    * DELETED - The member can no longer participate on the network and all
	//    associated resources are deleted. Either the AWS account that owns the
	//    member deleted it, or the member is being deleted as the result of an
	//    APPROVED PROPOSAL to remove the member.
	//
	//    * INACCESSIBLE_ENCRYPTION_KEY - The member is impaired and might not function
	//    as expected because it cannot access the specified customer managed key
	//    in AWS Key Management Service (AWS KMS) for encryption at rest. Either
	//    the KMS key was disabled or deleted, or the grants on the key were revoked.
	//    The effect of disabling or deleting a key, or revoking a grant is not
	//    immediate. The member resource might take some time to find that the key
	//    is inaccessible. When a resource is in this state, we recommend deleting
	//    and recreating the resource.
	Status *string `type:"string" enum:"MemberStatus"`
}

// String returns the string representation
func (s MemberSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MemberSummary) SetArn(v string) *MemberSummary {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *MemberSummary) SetCreationDate(v time.Time) *MemberSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *MemberSummary) SetDescription(v string) *MemberSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *MemberSummary) SetId(v string) *MemberSummary {
	s.Id = &v
	return s
}

// SetIsOwned sets the IsOwned field's value.
func (s *MemberSummary) SetIsOwned(v bool) *MemberSummary {
	s.IsOwned = &v
	return s
}

// SetName sets the Name field's value.
func (s *MemberSummary) SetName(v string) *MemberSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MemberSummary) SetStatus(v string) *MemberSummary {
	s.Status = &v
	return s
}

// Network configuration properties.
type Network struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the network. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The date and time that the network was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Attributes of the blockchain framework for the network.
	Description *string `type:"string"`

	// The blockchain framework that the network uses.
	Framework *string `type:"string" enum:"Framework"`

	// Attributes of the blockchain framework that the network uses.
	FrameworkAttributes *NetworkFrameworkAttributes `type:"structure"`

	// The version of the blockchain framework that the network uses.
	FrameworkVersion *string `min:"1" type:"string"`

	// The unique identifier of the network.
	Id *string `min:"1" type:"string"`

	// The name of the network.
	Name *string `min:"1" type:"string"`

	// The current status of the network.
	Status *string `type:"string" enum:"NetworkStatus"`

	// Tags assigned to the network. Each tag consists of a key and optional value.
	//
	// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]*string `type:"map"`

	// The voting rules for the network to decide if a proposal is accepted.
	VotingPolicy *VotingPolicy `type:"structure"`

	// The VPC endpoint service name of the VPC endpoint service of the network.
	// Members use the VPC endpoint service name to create a VPC endpoint to access
	// network resources.
	VpcEndpointServiceName *string `type:"string"`
}

// String returns the string representation
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Network) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Network) SetArn(v string) *Network {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Network) SetCreationDate(v time.Time) *Network {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Network) SetDescription(v string) *Network {
	s.Description = &v
	return s
}

// SetFramework sets the Framework field's value.
func (s *Network) SetFramework(v string) *Network {
	s.Framework = &v
	return s
}

// SetFrameworkAttributes sets the FrameworkAttributes field's value.
func (s *Network) SetFrameworkAttributes(v *NetworkFrameworkAttributes) *Network {
	s.FrameworkAttributes = v
	return s
}

// SetFrameworkVersion sets the FrameworkVersion field's value.
func (s *Network) SetFrameworkVersion(v string) *Network {
	s.FrameworkVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *Network) SetId(v string) *Network {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Network) SetName(v string) *Network {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Network) SetStatus(v string) *Network {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Network) SetTags(v map[string]*string) *Network {
	s.Tags = v
	return s
}

// SetVotingPolicy sets the VotingPolicy field's value.
func (s *Network) SetVotingPolicy(v *VotingPolicy) *Network {
	s.VotingPolicy = v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *Network) SetVpcEndpointServiceName(v string) *Network {
	s.VpcEndpointServiceName = &v
	return s
}

// Attributes of Ethereum for a network.
type NetworkEthereumAttributes struct {
	_ struct{} `type:"structure"`

	// The Ethereum CHAIN_ID associated with the Ethereum network. Chain IDs are
	// as follows:
	//
	//    * mainnet = 1
	//
	//    * rinkeby = 4
	//
	//    * ropsten = 3
	ChainId *string `type:"string"`
}

// String returns the string representation
func (s NetworkEthereumAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkEthereumAttributes) GoString() string {
	return s.String()
}

// SetChainId sets the ChainId field's value.
func (s *NetworkEthereumAttributes) SetChainId(v string) *NetworkEthereumAttributes {
	s.ChainId = &v
	return s
}

// Attributes of Hyperledger Fabric for a network.
type NetworkFabricAttributes struct {
	_ struct{} `type:"structure"`

	// The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For
	// more information, see Amazon Managed Blockchain Pricing (http://aws.amazon.com/managed-blockchain/pricing/).
	Edition *string `type:"string" enum:"Edition"`

	// The endpoint of the ordering service for the network.
	OrderingServiceEndpoint *string `type:"string"`
}

// String returns the string representation
func (s NetworkFabricAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkFabricAttributes) GoString() string {
	return s.String()
}

// SetEdition sets the Edition field's value.
func (s *NetworkFabricAttributes) SetEdition(v string) *NetworkFabricAttributes {
	s.Edition = &v
	return s
}

// SetOrderingServiceEndpoint sets the OrderingServiceEndpoint field's value.
func (s *NetworkFabricAttributes) SetOrderingServiceEndpoint(v string) *NetworkFabricAttributes {
	s.OrderingServiceEndpoint = &v
	return s
}

// Hyperledger Fabric configuration properties for the network.
type NetworkFabricConfiguration struct {
	_ struct{} `type:"structure"`

	// The edition of Amazon Managed Blockchain that the network uses. For more
	// information, see Amazon Managed Blockchain Pricing (http://aws.amazon.com/managed-blockchain/pricing/).
	//
	// Edition is a required field
	Edition *string `type:"string" required:"true" enum:"Edition"`
}

// String returns the string representation
func (s NetworkFabricConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkFabricConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkFabricConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkFabricConfiguration"}
	if s.Edition == nil {
		invalidParams.Add(request.NewErrParamRequired("Edition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEdition sets the Edition field's value.
func (s *NetworkFabricConfiguration) SetEdition(v string) *NetworkFabricConfiguration {
	s.Edition = &v
	return s
}

// Attributes relevant to the network for the blockchain framework that the
// network uses.
type NetworkFrameworkAttributes struct {
	_ struct{} `type:"structure"`

	// Attributes of an Ethereum network for Managed Blockchain resources participating
	// in an Ethereum network.
	Ethereum *NetworkEthereumAttributes `type:"structure"`

	// Attributes of Hyperledger Fabric for a Managed Blockchain network that uses
	// Hyperledger Fabric.
	Fabric *NetworkFabricAttributes `type:"structure"`
}

// String returns the string representation
func (s NetworkFrameworkAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkFrameworkAttributes) GoString() string {
	return s.String()
}

// SetEthereum sets the Ethereum field's value.
func (s *NetworkFrameworkAttributes) SetEthereum(v *NetworkEthereumAttributes) *NetworkFrameworkAttributes {
	s.Ethereum = v
	return s
}

// SetFabric sets the Fabric field's value.
func (s *NetworkFrameworkAttributes) SetFabric(v *NetworkFabricAttributes) *NetworkFrameworkAttributes {
	s.Fabric = v
	return s
}

// Configuration properties relevant to the network for the blockchain framework
// that the network uses.
type NetworkFrameworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Hyperledger Fabric configuration properties for a Managed Blockchain network
	// that uses Hyperledger Fabric.
	Fabric *NetworkFabricConfiguration `type:"structure"`
}

// String returns the string representation
func (s NetworkFrameworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkFrameworkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkFrameworkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkFrameworkConfiguration"}
	if s.Fabric != nil {
		if err := s.Fabric.Validate(); err != nil {
			invalidParams.AddNested("Fabric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFabric sets the Fabric field's value.
func (s *NetworkFrameworkConfiguration) SetFabric(v *NetworkFabricConfiguration) *NetworkFrameworkConfiguration {
	s.Fabric = v
	return s
}

// A summary of network configuration properties.
type NetworkSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the network. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The date and time that the network was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional description of the network.
	Description *string `type:"string"`

	// The blockchain framework that the network uses.
	Framework *string `type:"string" enum:"Framework"`

	// The version of the blockchain framework that the network uses.
	FrameworkVersion *string `min:"1" type:"string"`

	// The unique identifier of the network.
	Id *string `min:"1" type:"string"`

	// The name of the network.
	Name *string `min:"1" type:"string"`

	// The current status of the network.
	Status *string `type:"string" enum:"NetworkStatus"`
}

// String returns the string representation
func (s NetworkSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *NetworkSummary) SetArn(v string) *NetworkSummary {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *NetworkSummary) SetCreationDate(v time.Time) *NetworkSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NetworkSummary) SetDescription(v string) *NetworkSummary {
	s.Description = &v
	return s
}

// SetFramework sets the Framework field's value.
func (s *NetworkSummary) SetFramework(v string) *NetworkSummary {
	s.Framework = &v
	return s
}

// SetFrameworkVersion sets the FrameworkVersion field's value.
func (s *NetworkSummary) SetFrameworkVersion(v string) *NetworkSummary {
	s.FrameworkVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *NetworkSummary) SetId(v string) *NetworkSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *NetworkSummary) SetName(v string) *NetworkSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NetworkSummary) SetStatus(v string) *NetworkSummary {
	s.Status = &v
	return s
}

// Configuration properties of a node.
type Node struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the node. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The Availability Zone in which the node exists. Required for Ethereum nodes.
	AvailabilityZone *string `type:"string"`

	// The date and time that the node was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Attributes of the blockchain framework being used.
	FrameworkAttributes *NodeFrameworkAttributes `type:"structure"`

	// The unique identifier of the node.
	Id *string `min:"1" type:"string"`

	// The instance type of the node.
	InstanceType *string `type:"string"`

	// The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management
	// Service (AWS KMS) that the node uses for encryption at rest. If the value
	// of this parameter is "AWS Owned KMS Key", the node uses an AWS owned KMS
	// key for encryption. The node inherits this parameter from the member that
	// it belongs to.
	//
	// Applies only to Hyperledger Fabric.
	KmsKeyArn *string `type:"string"`

	// Configuration properties for logging events associated with a peer node on
	// a Hyperledger Fabric network on Managed Blockchain.
	LogPublishingConfiguration *NodeLogPublishingConfiguration `type:"structure"`

	// The unique identifier of the member to which the node belongs.
	//
	// Applies only to Hyperledger Fabric.
	MemberId *string `min:"1" type:"string"`

	// The unique identifier of the network that the node is on.
	NetworkId *string `min:"1" type:"string"`

	// The state database that the node uses. Values are LevelDB or CouchDB.
	//
	// Applies only to Hyperledger Fabric.
	StateDB *string `type:"string" enum:"StateDBType"`

	// The status of the node.
	//
	//    * CREATING - The AWS account is in the process of creating a node.
	//
	//    * AVAILABLE - The node has been created and can participate in the network.
	//
	//    * UNHEALTHY - The node is impaired and might not function as expected.
	//    Amazon Managed Blockchain automatically finds nodes in this state and
	//    tries to recover them. If a node is recoverable, it returns to AVAILABLE.
	//    Otherwise, it moves to FAILED status.
	//
	//    * CREATE_FAILED - The AWS account attempted to create a node and creation
	//    failed.
	//
	//    * UPDATING - The node is in the process of being updated.
	//
	//    * DELETING - The node is in the process of being deleted.
	//
	//    * DELETED - The node can no longer participate on the network.
	//
	//    * FAILED - The node is no longer functional, cannot be recovered, and
	//    must be deleted.
	//
	//    * INACCESSIBLE_ENCRYPTION_KEY - The node is impaired and might not function
	//    as expected because it cannot access the specified customer managed key
	//    in AWS KMS for encryption at rest. Either the KMS key was disabled or
	//    deleted, or the grants on the key were revoked. The effect of disabling
	//    or deleting a key, or revoking a grant is not immediate. The node resource
	//    might take some time to find that the key is inaccessible. When a resource
	//    is in this state, we recommend deleting and recreating the resource.
	Status *string `type:"string" enum:"NodeStatus"`

	// Tags assigned to the node. Each tag consists of a key and optional value.
	//
	// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s Node) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Node) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Node) SetArn(v string) *Node {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Node) SetAvailabilityZone(v string) *Node {
	s.AvailabilityZone = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Node) SetCreationDate(v time.Time) *Node {
	s.CreationDate = &v
	return s
}

// SetFrameworkAttributes sets the FrameworkAttributes field's value.
func (s *Node) SetFrameworkAttributes(v *NodeFrameworkAttributes) *Node {
	s.FrameworkAttributes = v
	return s
}

// SetId sets the Id field's value.
func (s *Node) SetId(v string) *Node {
	s.Id = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Node) SetInstanceType(v string) *Node {
	s.InstanceType = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *Node) SetKmsKeyArn(v string) *Node {
	s.KmsKeyArn = &v
	return s
}

// SetLogPublishingConfiguration sets the LogPublishingConfiguration field's value.
func (s *Node) SetLogPublishingConfiguration(v *NodeLogPublishingConfiguration) *Node {
	s.LogPublishingConfiguration = v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *Node) SetMemberId(v string) *Node {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *Node) SetNetworkId(v string) *Node {
	s.NetworkId = &v
	return s
}

// SetStateDB sets the StateDB field's value.
func (s *Node) SetStateDB(v string) *Node {
	s.StateDB = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Node) SetStatus(v string) *Node {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Node) SetTags(v map[string]*string) *Node {
	s.Tags = v
	return s
}

// Configuration properties of a node.
type NodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the node exists. Required for Ethereum nodes.
	AvailabilityZone *string `type:"string"`

	// The Amazon Managed Blockchain instance type for the node.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true"`

	// Configuration properties for logging events associated with a peer node on
	// a Hyperledger Fabric network on Managed Blockchain.
	LogPublishingConfiguration *NodeLogPublishingConfiguration `type:"structure"`

	// The state database that the node uses. Values are LevelDB or CouchDB. When
	// using an Amazon Managed Blockchain network with Hyperledger Fabric version
	// 1.4 or later, the default is CouchDB.
	//
	// Applies only to Hyperledger Fabric.
	StateDB *string `type:"string" enum:"StateDBType"`
}

// String returns the string representation
func (s NodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodeConfiguration"}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *NodeConfiguration) SetAvailabilityZone(v string) *NodeConfiguration {
	s.AvailabilityZone = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *NodeConfiguration) SetInstanceType(v string) *NodeConfiguration {
	s.InstanceType = &v
	return s
}

// SetLogPublishingConfiguration sets the LogPublishingConfiguration field's value.
func (s *NodeConfiguration) SetLogPublishingConfiguration(v *NodeLogPublishingConfiguration) *NodeConfiguration {
	s.LogPublishingConfiguration = v
	return s
}

// SetStateDB sets the StateDB field's value.
func (s *NodeConfiguration) SetStateDB(v string) *NodeConfiguration {
	s.StateDB = &v
	return s
}

// Attributes of an Ethereum node.
type NodeEthereumAttributes struct {
	_ struct{} `type:"structure"`

	// The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC
	// methods over HTTP connections from a client. Use this endpoint in client
	// code for smart contracts when using an HTTP connection. Connections to this
	// endpoint are authenticated using Signature Version 4 (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	HttpEndpoint *string `type:"string"`

	// The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC
	// methods over WebSockets connections from a client. Use this endpoint in client
	// code for smart contracts when using a WebSockets connection. Connections
	// to this endpoint are authenticated using Signature Version 4 (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	WebSocketEndpoint *string `type:"string"`
}

// String returns the string representation
func (s NodeEthereumAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeEthereumAttributes) GoString() string {
	return s.String()
}

// SetHttpEndpoint sets the HttpEndpoint field's value.
func (s *NodeEthereumAttributes) SetHttpEndpoint(v string) *NodeEthereumAttributes {
	s.HttpEndpoint = &v
	return s
}

// SetWebSocketEndpoint sets the WebSocketEndpoint field's value.
func (s *NodeEthereumAttributes) SetWebSocketEndpoint(v string) *NodeEthereumAttributes {
	s.WebSocketEndpoint = &v
	return s
}

// Attributes of Hyperledger Fabric for a peer node on a Hyperledger Fabric
// network on Managed Blockchain.
type NodeFabricAttributes struct {
	_ struct{} `type:"structure"`

	// The endpoint that identifies the peer node for all services except peer channel-based
	// event services.
	PeerEndpoint *string `type:"string"`

	// The endpoint that identifies the peer node for peer channel-based event services.
	PeerEventEndpoint *string `type:"string"`
}

// String returns the string representation
func (s NodeFabricAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeFabricAttributes) GoString() string {
	return s.String()
}

// SetPeerEndpoint sets the PeerEndpoint field's value.
func (s *NodeFabricAttributes) SetPeerEndpoint(v string) *NodeFabricAttributes {
	s.PeerEndpoint = &v
	return s
}

// SetPeerEventEndpoint sets the PeerEventEndpoint field's value.
func (s *NodeFabricAttributes) SetPeerEventEndpoint(v string) *NodeFabricAttributes {
	s.PeerEventEndpoint = &v
	return s
}

// Configuration properties for logging events associated with a peer node owned
// by a member in a Managed Blockchain network.
type NodeFabricLogPublishingConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration properties for logging events associated with chaincode execution
	// on a peer node. Chaincode logs contain the results of instantiating, invoking,
	// and querying the chaincode. A peer can run multiple instances of chaincode.
	// When enabled, a log stream is created for all chaincodes, with an individual
	// log stream for each chaincode.
	ChaincodeLogs *LogConfigurations `type:"structure"`

	// Configuration properties for a peer node log. Peer node logs contain messages
	// generated when your client submits transaction proposals to peer nodes, requests
	// to join channels, enrolls an admin peer, and lists the chaincode instances
	// on a peer node.
	PeerLogs *LogConfigurations `type:"structure"`
}

// String returns the string representation
func (s NodeFabricLogPublishingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeFabricLogPublishingConfiguration) GoString() string {
	return s.String()
}

// SetChaincodeLogs sets the ChaincodeLogs field's value.
func (s *NodeFabricLogPublishingConfiguration) SetChaincodeLogs(v *LogConfigurations) *NodeFabricLogPublishingConfiguration {
	s.ChaincodeLogs = v
	return s
}

// SetPeerLogs sets the PeerLogs field's value.
func (s *NodeFabricLogPublishingConfiguration) SetPeerLogs(v *LogConfigurations) *NodeFabricLogPublishingConfiguration {
	s.PeerLogs = v
	return s
}

// Attributes relevant to a node on a Managed Blockchain network for the blockchain
// framework that the network uses.
type NodeFrameworkAttributes struct {
	_ struct{} `type:"structure"`

	// Attributes of Ethereum for a node on a Managed Blockchain network that uses
	// Ethereum.
	Ethereum *NodeEthereumAttributes `type:"structure"`

	// Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain
	// network that uses Hyperledger Fabric.
	Fabric *NodeFabricAttributes `type:"structure"`
}

// String returns the string representation
func (s NodeFrameworkAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeFrameworkAttributes) GoString() string {
	return s.String()
}

// SetEthereum sets the Ethereum field's value.
func (s *NodeFrameworkAttributes) SetEthereum(v *NodeEthereumAttributes) *NodeFrameworkAttributes {
	s.Ethereum = v
	return s
}

// SetFabric sets the Fabric field's value.
func (s *NodeFrameworkAttributes) SetFabric(v *NodeFabricAttributes) *NodeFrameworkAttributes {
	s.Fabric = v
	return s
}

// Configuration properties for logging events associated with a peer node on
// a Hyperledger Fabric network on Managed Blockchain.
type NodeLogPublishingConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration properties for logging events associated with a node that is
	// owned by a member of a Managed Blockchain network using the Hyperledger Fabric
	// framework.
	Fabric *NodeFabricLogPublishingConfiguration `type:"structure"`
}

// String returns the string representation
func (s NodeLogPublishingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeLogPublishingConfiguration) GoString() string {
	return s.String()
}

// SetFabric sets the Fabric field's value.
func (s *NodeLogPublishingConfiguration) SetFabric(v *NodeFabricLogPublishingConfiguration) *NodeLogPublishingConfiguration {
	s.Fabric = v
	return s
}

// A summary of configuration properties for a node.
type NodeSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the node. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The Availability Zone in which the node exists.
	AvailabilityZone *string `type:"string"`

	// The date and time that the node was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the node.
	Id *string `min:"1" type:"string"`

	// The EC2 instance type for the node.
	InstanceType *string `type:"string"`

	// The status of the node.
	Status *string `type:"string" enum:"NodeStatus"`
}

// String returns the string representation
func (s NodeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *NodeSummary) SetArn(v string) *NodeSummary {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *NodeSummary) SetAvailabilityZone(v string) *NodeSummary {
	s.AvailabilityZone = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *NodeSummary) SetCreationDate(v time.Time) *NodeSummary {
	s.CreationDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *NodeSummary) SetId(v string) *NodeSummary {
	s.Id = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *NodeSummary) SetInstanceType(v string) *NodeSummary {
	s.InstanceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NodeSummary) SetStatus(v string) *NodeSummary {
	s.Status = &v
	return s
}

// Properties of a proposal on a Managed Blockchain network.
//
// Applies only to Hyperledger Fabric.
type Proposal struct {
	_ struct{} `type:"structure"`

	// The actions to perform on the network if the proposal is APPROVED.
	Actions *ProposalActions `type:"structure"`

	// The Amazon Resource Name (ARN) of the proposal. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The date and time that the proposal was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the proposal.
	Description *string `type:"string"`

	// The date and time that the proposal expires. This is the CreationDate plus
	// the ProposalDurationInHours that is specified in the ProposalThresholdPolicy.
	// After this date and time, if members have not cast enough votes to determine
	// the outcome according to the voting policy, the proposal is EXPIRED and Actions
	// are not carried out.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the network for which the proposal is made.
	NetworkId *string `min:"1" type:"string"`

	// The current total of NO votes cast on the proposal by members.
	NoVoteCount *int64 `type:"integer"`

	// The number of votes remaining to be cast on the proposal by members. In other
	// words, the number of members minus the sum of YES votes and NO votes.
	OutstandingVoteCount *int64 `type:"integer"`

	// The unique identifier of the proposal.
	ProposalId *string `min:"1" type:"string"`

	// The unique identifier of the member that created the proposal.
	ProposedByMemberId *string `min:"1" type:"string"`

	// The name of the member that created the proposal.
	ProposedByMemberName *string `min:"1" type:"string"`

	// The status of the proposal. Values are as follows:
	//
	//    * IN_PROGRESS - The proposal is active and open for member voting.
	//
	//    * APPROVED - The proposal was approved with sufficient YES votes among
	//    members according to the VotingPolicy specified for the Network. The specified
	//    proposal actions are carried out.
	//
	//    * REJECTED - The proposal was rejected with insufficient YES votes among
	//    members according to the VotingPolicy specified for the Network. The specified
	//    ProposalActions are not carried out.
	//
	//    * EXPIRED - Members did not cast the number of votes required to determine
	//    the proposal outcome before the proposal expired. The specified ProposalActions
	//    are not carried out.
	//
	//    * ACTION_FAILED - One or more of the specified ProposalActions in a proposal
	//    that was approved could not be completed because of an error. The ACTION_FAILED
	//    status occurs even if only one ProposalAction fails and other actions
	//    are successful.
	Status *string `type:"string" enum:"ProposalStatus"`

	// Tags assigned to the proposal. Each tag consists of a key and optional value.
	//
	// For more information about tags, see Tagging Resources (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]*string `type:"map"`

	// The current total of YES votes cast on the proposal by members.
	YesVoteCount *int64 `type:"integer"`
}

// String returns the string representation
func (s Proposal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Proposal) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *Proposal) SetActions(v *ProposalActions) *Proposal {
	s.Actions = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Proposal) SetArn(v string) *Proposal {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Proposal) SetCreationDate(v time.Time) *Proposal {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Proposal) SetDescription(v string) *Proposal {
	s.Description = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *Proposal) SetExpirationDate(v time.Time) *Proposal {
	s.ExpirationDate = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *Proposal) SetNetworkId(v string) *Proposal {
	s.NetworkId = &v
	return s
}

// SetNoVoteCount sets the NoVoteCount field's value.
func (s *Proposal) SetNoVoteCount(v int64) *Proposal {
	s.NoVoteCount = &v
	return s
}

// SetOutstandingVoteCount sets the OutstandingVoteCount field's value.
func (s *Proposal) SetOutstandingVoteCount(v int64) *Proposal {
	s.OutstandingVoteCount = &v
	return s
}

// SetProposalId sets the ProposalId field's value.
func (s *Proposal) SetProposalId(v string) *Proposal {
	s.ProposalId = &v
	return s
}

// SetProposedByMemberId sets the ProposedByMemberId field's value.
func (s *Proposal) SetProposedByMemberId(v string) *Proposal {
	s.ProposedByMemberId = &v
	return s
}

// SetProposedByMemberName sets the ProposedByMemberName field's value.
func (s *Proposal) SetProposedByMemberName(v string) *Proposal {
	s.ProposedByMemberName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Proposal) SetStatus(v string) *Proposal {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Proposal) SetTags(v map[string]*string) *Proposal {
	s.Tags = v
	return s
}

// SetYesVoteCount sets the YesVoteCount field's value.
func (s *Proposal) SetYesVoteCount(v int64) *Proposal {
	s.YesVoteCount = &v
	return s
}

// The actions to carry out if a proposal is APPROVED.
//
// Applies only to Hyperledger Fabric.
type ProposalActions struct {
	_ struct{} `type:"structure"`

	// The actions to perform for an APPROVED proposal to invite an AWS account
	// to create a member and join the network.
	Invitations []*InviteAction `type:"list"`

	// The actions to perform for an APPROVED proposal to remove a member from the
	// network, which deletes the member and all associated member resources from
	// the network.
	Removals []*RemoveAction `type:"list"`
}

// String returns the string representation
func (s ProposalActions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProposalActions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProposalActions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProposalActions"}
	if s.Invitations != nil {
		for i, v := range s.Invitations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Invitations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Removals != nil {
		for i, v := range s.Removals {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Removals", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvitations sets the Invitations field's value.
func (s *ProposalActions) SetInvitations(v []*InviteAction) *ProposalActions {
	s.Invitations = v
	return s
}

// SetRemovals sets the Removals field's value.
func (s *ProposalActions) SetRemovals(v []*RemoveAction) *ProposalActions {
	s.Removals = v
	return s
}

// Properties of a proposal.
//
// Applies only to Hyperledger Fabric.
type ProposalSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the proposal. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"1" type:"string"`

	// The date and time that the proposal was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the proposal.
	Description *string `type:"string"`

	// The date and time that the proposal expires. This is the CreationDate plus
	// the ProposalDurationInHours that is specified in the ProposalThresholdPolicy.
	// After this date and time, if members have not cast enough votes to determine
	// the outcome according to the voting policy, the proposal is EXPIRED and Actions
	// are not carried out.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the proposal.
	ProposalId *string `min:"1" type:"string"`

	// The unique identifier of the member that created the proposal.
	ProposedByMemberId *string `min:"1" type:"string"`

	// The name of the member that created the proposal.
	ProposedByMemberName *string `min:"1" type:"string"`

	// The status of the proposal. Values are as follows:
	//
	//    * IN_PROGRESS - The proposal is active and open for member voting.
	//
	//    * APPROVED - The proposal was approved with sufficient YES votes among
	//    members according to the VotingPolicy specified for the Network. The specified
	//    proposal actions are carried out.
	//
	//    * REJECTED - The proposal was rejected with insufficient YES votes among
	//    members according to the VotingPolicy specified for the Network. The specified
	//    ProposalActions are not carried out.
	//
	//    * EXPIRED - Members did not cast the number of votes required to determine
	//    the proposal outcome before the proposal expired. The specified ProposalActions
	//    are not carried out.
	//
	//    * ACTION_FAILED - One or more of the specified ProposalActions in a proposal
	//    that was approved could not be completed because of an error.
	Status *string `type:"string" enum:"ProposalStatus"`
}

// String returns the string representation
func (s ProposalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProposalSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ProposalSummary) SetArn(v string) *ProposalSummary {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ProposalSummary) SetCreationDate(v time.Time) *ProposalSummary {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProposalSummary) SetDescription(v string) *ProposalSummary {
	s.Description = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *ProposalSummary) SetExpirationDate(v time.Time) *ProposalSummary {
	s.ExpirationDate = &v
	return s
}

// SetProposalId sets the ProposalId field's value.
func (s *ProposalSummary) SetProposalId(v string) *ProposalSummary {
	s.ProposalId = &v
	return s
}

// SetProposedByMemberId sets the ProposedByMemberId field's value.
func (s *ProposalSummary) SetProposedByMemberId(v string) *ProposalSummary {
	s.ProposedByMemberId = &v
	return s
}

// SetProposedByMemberName sets the ProposedByMemberName field's value.
func (s *ProposalSummary) SetProposedByMemberName(v string) *ProposalSummary {
	s.ProposedByMemberName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProposalSummary) SetStatus(v string) *ProposalSummary {
	s.Status = &v
	return s
}

type RejectInvitationInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the invitation to reject.
	//
	// InvitationId is a required field
	InvitationId *string `location:"uri" locationName:"invitationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RejectInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectInvitationInput"}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}
	if s.InvitationId != nil && len(*s.InvitationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InvitationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvitationId sets the InvitationId field's value.
func (s *RejectInvitationInput) SetInvitationId(v string) *RejectInvitationInput {
	s.InvitationId = &v
	return s
}

type RejectInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectInvitationOutput) GoString() string {
	return s.String()
}

// An action to remove a member from a Managed Blockchain network as the result
// of a removal proposal that is APPROVED. The member and all associated resources
// are deleted from the network.
//
// Applies only to Hyperledger Fabric.
type RemoveAction struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member to remove.
	//
	// MemberId is a required field
	MemberId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAction"}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberId sets the MemberId field's value.
func (s *RemoveAction) SetMemberId(v string) *RemoveAction {
	s.MemberId = &v
	return s
}

// A resource request is issued for a resource that already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum number of resources of that type already exist. Ensure the resources
// requested are within the boundaries of the service edition and your account
// limits.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A requested resource does not exist. It may have been deleted or referenced
// inaccurately.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// A requested resource does not exist. It may have been deleted or referenced
	// inaccurately.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource exists but is not in a status that can complete the
// operation.
type ResourceNotReadyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotReadyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotReadyException) GoString() string {
	return s.String()
}

func newErrorResourceNotReadyException(v protocol.ResponseMetadata) error {
	return &ResourceNotReadyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotReadyException) Code() string {
	return "ResourceNotReadyException"
}

// Message returns the exception's message.
func (s *ResourceNotReadyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotReadyException) OrigErr() error {
	return nil
}

func (s *ResourceNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotReadyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotReadyException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags to assign to the specified resource. Tag values can be empty, for
	// example, "MyTagKey" : "". You can specify multiple key-value pairs in a single
	// request, with an overall maximum of 50 tags added to each resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request or operation could not be performed because a service is throttling
// requests. The most common source of throttling errors is launching EC2 instances
// such that your service limit for EC2 instances is exceeded. Request a limit
// increase or delete unused resources if possible.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateMemberInput struct {
	_ struct{} `type:"structure"`

	// Configuration properties for publishing to Amazon CloudWatch Logs.
	LogPublishingConfiguration *MemberLogPublishingConfiguration `type:"structure"`

	// The unique identifier of the member.
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"memberId" min:"1" type:"string" required:"true"`

	// The unique identifier of the Managed Blockchain network to which the member
	// belongs.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMemberInput"}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogPublishingConfiguration sets the LogPublishingConfiguration field's value.
func (s *UpdateMemberInput) SetLogPublishingConfiguration(v *MemberLogPublishingConfiguration) *UpdateMemberInput {
	s.LogPublishingConfiguration = v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *UpdateMemberInput) SetMemberId(v string) *UpdateMemberInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *UpdateMemberInput) SetNetworkId(v string) *UpdateMemberInput {
	s.NetworkId = &v
	return s
}

type UpdateMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMemberOutput) GoString() string {
	return s.String()
}

type UpdateNodeInput struct {
	_ struct{} `type:"structure"`

	// Configuration properties for publishing to Amazon CloudWatch Logs.
	LogPublishingConfiguration *NodeLogPublishingConfiguration `type:"structure"`

	// The unique identifier of the member that owns the node.
	//
	// Applies only to Hyperledger Fabric.
	MemberId *string `min:"1" type:"string"`

	// The unique identifier of the network that the node is on.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The unique identifier of the node.
	//
	// NodeId is a required field
	NodeId *string `location:"uri" locationName:"nodeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNodeInput"}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.NodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeId"))
	}
	if s.NodeId != nil && len(*s.NodeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogPublishingConfiguration sets the LogPublishingConfiguration field's value.
func (s *UpdateNodeInput) SetLogPublishingConfiguration(v *NodeLogPublishingConfiguration) *UpdateNodeInput {
	s.LogPublishingConfiguration = v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *UpdateNodeInput) SetMemberId(v string) *UpdateNodeInput {
	s.MemberId = &v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *UpdateNodeInput) SetNetworkId(v string) *UpdateNodeInput {
	s.NetworkId = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *UpdateNodeInput) SetNodeId(v string) *UpdateNodeInput {
	s.NodeId = &v
	return s
}

type UpdateNodeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNodeOutput) GoString() string {
	return s.String()
}

type VoteOnProposalInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the network.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The unique identifier of the proposal.
	//
	// ProposalId is a required field
	ProposalId *string `location:"uri" locationName:"proposalId" min:"1" type:"string" required:"true"`

	// The value of the vote.
	//
	// Vote is a required field
	Vote *string `type:"string" required:"true" enum:"VoteValue"`

	// The unique identifier of the member casting the vote.
	//
	// VoterMemberId is a required field
	VoterMemberId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VoteOnProposalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoteOnProposalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VoteOnProposalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VoteOnProposalInput"}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 1))
	}
	if s.ProposalId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProposalId"))
	}
	if s.ProposalId != nil && len(*s.ProposalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProposalId", 1))
	}
	if s.Vote == nil {
		invalidParams.Add(request.NewErrParamRequired("Vote"))
	}
	if s.VoterMemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoterMemberId"))
	}
	if s.VoterMemberId != nil && len(*s.VoterMemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoterMemberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkId sets the NetworkId field's value.
func (s *VoteOnProposalInput) SetNetworkId(v string) *VoteOnProposalInput {
	s.NetworkId = &v
	return s
}

// SetProposalId sets the ProposalId field's value.
func (s *VoteOnProposalInput) SetProposalId(v string) *VoteOnProposalInput {
	s.ProposalId = &v
	return s
}

// SetVote sets the Vote field's value.
func (s *VoteOnProposalInput) SetVote(v string) *VoteOnProposalInput {
	s.Vote = &v
	return s
}

// SetVoterMemberId sets the VoterMemberId field's value.
func (s *VoteOnProposalInput) SetVoterMemberId(v string) *VoteOnProposalInput {
	s.VoterMemberId = &v
	return s
}

type VoteOnProposalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s VoteOnProposalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoteOnProposalOutput) GoString() string {
	return s.String()
}

// Properties of an individual vote that a member cast for a proposal.
//
// Applies only to Hyperledger Fabric.
type VoteSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member that cast the vote.
	MemberId *string `min:"1" type:"string"`

	// The name of the member that cast the vote.
	MemberName *string `min:"1" type:"string"`

	// The vote value, either YES or NO.
	Vote *string `type:"string" enum:"VoteValue"`
}

// String returns the string representation
func (s VoteSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoteSummary) GoString() string {
	return s.String()
}

// SetMemberId sets the MemberId field's value.
func (s *VoteSummary) SetMemberId(v string) *VoteSummary {
	s.MemberId = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *VoteSummary) SetMemberName(v string) *VoteSummary {
	s.MemberName = &v
	return s
}

// SetVote sets the Vote field's value.
func (s *VoteSummary) SetVote(v string) *VoteSummary {
	s.Vote = &v
	return s
}

// The voting rules for the network to decide if a proposal is accepted
//
// Applies only to Hyperledger Fabric.
type VotingPolicy struct {
	_ struct{} `type:"structure"`

	// Defines the rules for the network for voting on proposals, such as the percentage
	// of YES votes required for the proposal to be approved and the duration of
	// the proposal. The policy applies to all proposals and is specified when the
	// network is created.
	ApprovalThresholdPolicy *ApprovalThresholdPolicy `type:"structure"`
}

// String returns the string representation
func (s VotingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VotingPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VotingPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VotingPolicy"}
	if s.ApprovalThresholdPolicy != nil {
		if err := s.ApprovalThresholdPolicy.Validate(); err != nil {
			invalidParams.AddNested("ApprovalThresholdPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApprovalThresholdPolicy sets the ApprovalThresholdPolicy field's value.
func (s *VotingPolicy) SetApprovalThresholdPolicy(v *ApprovalThresholdPolicy) *VotingPolicy {
	s.ApprovalThresholdPolicy = v
	return s
}

const (
	// EditionStarter is a Edition enum value
	EditionStarter = "STARTER"

	// EditionStandard is a Edition enum value
	EditionStandard = "STANDARD"
)

// Edition_Values returns all elements of the Edition enum
func Edition_Values() []string {
	return []string{
		EditionStarter,
		EditionStandard,
	}
}

const (
	// FrameworkHyperledgerFabric is a Framework enum value
	FrameworkHyperledgerFabric = "HYPERLEDGER_FABRIC"

	// FrameworkEthereum is a Framework enum value
	FrameworkEthereum = "ETHEREUM"
)

// Framework_Values returns all elements of the Framework enum
func Framework_Values() []string {
	return []string{
		FrameworkHyperledgerFabric,
		FrameworkEthereum,
	}
}

const (
	// InvitationStatusPending is a InvitationStatus enum value
	InvitationStatusPending = "PENDING"

	// InvitationStatusAccepted is a InvitationStatus enum value
	InvitationStatusAccepted = "ACCEPTED"

	// InvitationStatusAccepting is a InvitationStatus enum value
	InvitationStatusAccepting = "ACCEPTING"

	// InvitationStatusRejected is a InvitationStatus enum value
	InvitationStatusRejected = "REJECTED"

	// InvitationStatusExpired is a InvitationStatus enum value
	InvitationStatusExpired = "EXPIRED"
)

// InvitationStatus_Values returns all elements of the InvitationStatus enum
func InvitationStatus_Values() []string {
	return []string{
		InvitationStatusPending,
		InvitationStatusAccepted,
		InvitationStatusAccepting,
		InvitationStatusRejected,
		InvitationStatusExpired,
	}
}

const (
	// MemberStatusCreating is a MemberStatus enum value
	MemberStatusCreating = "CREATING"

	// MemberStatusAvailable is a MemberStatus enum value
	MemberStatusAvailable = "AVAILABLE"

	// MemberStatusCreateFailed is a MemberStatus enum value
	MemberStatusCreateFailed = "CREATE_FAILED"

	// MemberStatusUpdating is a MemberStatus enum value
	MemberStatusUpdating = "UPDATING"

	// MemberStatusDeleting is a MemberStatus enum value
	MemberStatusDeleting = "DELETING"

	// MemberStatusDeleted is a MemberStatus enum value
	MemberStatusDeleted = "DELETED"

	// MemberStatusInaccessibleEncryptionKey is a MemberStatus enum value
	MemberStatusInaccessibleEncryptionKey = "INACCESSIBLE_ENCRYPTION_KEY"
)

// MemberStatus_Values returns all elements of the MemberStatus enum
func MemberStatus_Values() []string {
	return []string{
		MemberStatusCreating,
		MemberStatusAvailable,
		MemberStatusCreateFailed,
		MemberStatusUpdating,
		MemberStatusDeleting,
		MemberStatusDeleted,
		MemberStatusInaccessibleEncryptionKey,
	}
}

const (
	// NetworkStatusCreating is a NetworkStatus enum value
	NetworkStatusCreating = "CREATING"

	// NetworkStatusAvailable is a NetworkStatus enum value
	NetworkStatusAvailable = "AVAILABLE"

	// NetworkStatusCreateFailed is a NetworkStatus enum value
	NetworkStatusCreateFailed = "CREATE_FAILED"

	// NetworkStatusDeleting is a NetworkStatus enum value
	NetworkStatusDeleting = "DELETING"

	// NetworkStatusDeleted is a NetworkStatus enum value
	NetworkStatusDeleted = "DELETED"
)

// NetworkStatus_Values returns all elements of the NetworkStatus enum
func NetworkStatus_Values() []string {
	return []string{
		NetworkStatusCreating,
		NetworkStatusAvailable,
		NetworkStatusCreateFailed,
		NetworkStatusDeleting,
		NetworkStatusDeleted,
	}
}

const (
	// NodeStatusCreating is a NodeStatus enum value
	NodeStatusCreating = "CREATING"

	// NodeStatusAvailable is a NodeStatus enum value
	NodeStatusAvailable = "AVAILABLE"

	// NodeStatusUnhealthy is a NodeStatus enum value
	NodeStatusUnhealthy = "UNHEALTHY"

	// NodeStatusCreateFailed is a NodeStatus enum value
	NodeStatusCreateFailed = "CREATE_FAILED"

	// NodeStatusUpdating is a NodeStatus enum value
	NodeStatusUpdating = "UPDATING"

	// NodeStatusDeleting is a NodeStatus enum value
	NodeStatusDeleting = "DELETING"

	// NodeStatusDeleted is a NodeStatus enum value
	NodeStatusDeleted = "DELETED"

	// NodeStatusFailed is a NodeStatus enum value
	NodeStatusFailed = "FAILED"

	// NodeStatusInaccessibleEncryptionKey is a NodeStatus enum value
	NodeStatusInaccessibleEncryptionKey = "INACCESSIBLE_ENCRYPTION_KEY"
)

// NodeStatus_Values returns all elements of the NodeStatus enum
func NodeStatus_Values() []string {
	return []string{
		NodeStatusCreating,
		NodeStatusAvailable,
		NodeStatusUnhealthy,
		NodeStatusCreateFailed,
		NodeStatusUpdating,
		NodeStatusDeleting,
		NodeStatusDeleted,
		NodeStatusFailed,
		NodeStatusInaccessibleEncryptionKey,
	}
}

const (
	// ProposalStatusInProgress is a ProposalStatus enum value
	ProposalStatusInProgress = "IN_PROGRESS"

	// ProposalStatusApproved is a ProposalStatus enum value
	ProposalStatusApproved = "APPROVED"

	// ProposalStatusRejected is a ProposalStatus enum value
	ProposalStatusRejected = "REJECTED"

	// ProposalStatusExpired is a ProposalStatus enum value
	ProposalStatusExpired = "EXPIRED"

	// ProposalStatusActionFailed is a ProposalStatus enum value
	ProposalStatusActionFailed = "ACTION_FAILED"
)

// ProposalStatus_Values returns all elements of the ProposalStatus enum
func ProposalStatus_Values() []string {
	return []string{
		ProposalStatusInProgress,
		ProposalStatusApproved,
		ProposalStatusRejected,
		ProposalStatusExpired,
		ProposalStatusActionFailed,
	}
}

const (
	// StateDBTypeLevelDb is a StateDBType enum value
	StateDBTypeLevelDb = "LevelDB"

	// StateDBTypeCouchDb is a StateDBType enum value
	StateDBTypeCouchDb = "CouchDB"
)

// StateDBType_Values returns all elements of the StateDBType enum
func StateDBType_Values() []string {
	return []string{
		StateDBTypeLevelDb,
		StateDBTypeCouchDb,
	}
}

const (
	// ThresholdComparatorGreaterThan is a ThresholdComparator enum value
	ThresholdComparatorGreaterThan = "GREATER_THAN"

	// ThresholdComparatorGreaterThanOrEqualTo is a ThresholdComparator enum value
	ThresholdComparatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"
)

// ThresholdComparator_Values returns all elements of the ThresholdComparator enum
func ThresholdComparator_Values() []string {
	return []string{
		ThresholdComparatorGreaterThan,
		ThresholdComparatorGreaterThanOrEqualTo,
	}
}

const (
	// VoteValueYes is a VoteValue enum value
	VoteValueYes = "YES"

	// VoteValueNo is a VoteValue enum value
	VoteValueNo = "NO"
)

// VoteValue_Values returns all elements of the VoteValue enum
func VoteValue_Values() []string {
	return []string{
		VoteValueYes,
		VoteValueNo,
	}
}
