// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mwaa

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateCliToken = "CreateCliToken"

// CreateCliTokenRequest generates a "aws/request.Request" representing the
// client's request for the CreateCliToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCliToken for more information on using the CreateCliToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCliTokenRequest method.
//    req, resp := client.CreateCliTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/CreateCliToken
func (c *MWAA) CreateCliTokenRequest(input *CreateCliTokenInput) (req *request.Request, output *CreateCliTokenOutput) {
	op := &request.Operation{
		Name:       opCreateCliToken,
		HTTPMethod: "POST",
		HTTPPath:   "/clitoken/{Name}",
	}

	if input == nil {
		input = &CreateCliTokenInput{}
	}

	output = &CreateCliTokenOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("env.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateCliToken API operation for AmazonMWAA.
//
// Create a CLI token to use Airflow CLI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation CreateCliToken for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   ResourceNotFoundException: The resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/CreateCliToken
func (c *MWAA) CreateCliToken(input *CreateCliTokenInput) (*CreateCliTokenOutput, error) {
	req, out := c.CreateCliTokenRequest(input)
	return out, req.Send()
}

// CreateCliTokenWithContext is the same as CreateCliToken with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCliToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) CreateCliTokenWithContext(ctx aws.Context, input *CreateCliTokenInput, opts ...request.Option) (*CreateCliTokenOutput, error) {
	req, out := c.CreateCliTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEnvironmentRequest method.
//    req, resp := client.CreateEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/CreateEnvironment
func (c *MWAA) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *CreateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "PUT",
		HTTPPath:   "/environments/{Name}",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &CreateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateEnvironment API operation for AmazonMWAA.
//
// JSON blob that describes the environment to create.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/CreateEnvironment
func (c *MWAA) CreateEnvironment(input *CreateEnvironmentInput) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWebLoginToken = "CreateWebLoginToken"

// CreateWebLoginTokenRequest generates a "aws/request.Request" representing the
// client's request for the CreateWebLoginToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWebLoginToken for more information on using the CreateWebLoginToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWebLoginTokenRequest method.
//    req, resp := client.CreateWebLoginTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/CreateWebLoginToken
func (c *MWAA) CreateWebLoginTokenRequest(input *CreateWebLoginTokenInput) (req *request.Request, output *CreateWebLoginTokenOutput) {
	op := &request.Operation{
		Name:       opCreateWebLoginToken,
		HTTPMethod: "POST",
		HTTPPath:   "/webtoken/{Name}",
	}

	if input == nil {
		input = &CreateWebLoginTokenInput{}
	}

	output = &CreateWebLoginTokenOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("env.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateWebLoginToken API operation for AmazonMWAA.
//
// Create a JWT token to be used to login to Airflow Web UI with claims based
// Authentication.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation CreateWebLoginToken for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access to the Airflow Web UI or CLI has been Denied. Please follow the MWAA
//   user guide to setup permissions to access the Web UI and CLI functionality.
//
//   * ResourceNotFoundException
//   ResourceNotFoundException: The resource is not available.
//
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/CreateWebLoginToken
func (c *MWAA) CreateWebLoginToken(input *CreateWebLoginTokenInput) (*CreateWebLoginTokenOutput, error) {
	req, out := c.CreateWebLoginTokenRequest(input)
	return out, req.Send()
}

// CreateWebLoginTokenWithContext is the same as CreateWebLoginToken with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebLoginToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) CreateWebLoginTokenWithContext(ctx aws.Context, input *CreateWebLoginTokenInput, opts ...request.Option) (*CreateWebLoginTokenOutput, error) {
	req, out := c.CreateWebLoginTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEnvironmentRequest method.
//    req, resp := client.DeleteEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/DeleteEnvironment
func (c *MWAA) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/environments/{Name}",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteEnvironment API operation for AmazonMWAA.
//
// Delete an existing environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   ResourceNotFoundException: The resource is not available.
//
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/DeleteEnvironment
func (c *MWAA) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironment = "GetEnvironment"

// GetEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironment for more information on using the GetEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEnvironmentRequest method.
//    req, resp := client.GetEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/GetEnvironment
func (c *MWAA) GetEnvironmentRequest(input *GetEnvironmentInput) (req *request.Request, output *GetEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/environments/{Name}",
	}

	if input == nil {
		input = &GetEnvironmentInput{}
	}

	output = &GetEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetEnvironment API operation for AmazonMWAA.
//
// Get details of an existing environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation GetEnvironment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   ResourceNotFoundException: The resource is not available.
//
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/GetEnvironment
func (c *MWAA) GetEnvironment(input *GetEnvironmentInput) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	return out, req.Send()
}

// GetEnvironmentWithContext is the same as GetEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) GetEnvironmentWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.Option) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEnvironmentsRequest method.
//    req, resp := client.ListEnvironmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/ListEnvironments
func (c *MWAA) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/environments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListEnvironments API operation for AmazonMWAA.
//
// List Amazon MWAA Environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/ListEnvironments
func (c *MWAA) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentsPages iterates over the pages of a ListEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEnvironments operation.
//    pageNum := 0
//    err := client.ListEnvironmentsPages(params,
//        func(page *mwaa.ListEnvironmentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MWAA) ListEnvironmentsPages(input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool) error {
	return c.ListEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentsPagesWithContext same as ListEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) ListEnvironmentsPagesWithContext(ctx aws.Context, input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/ListTagsForResource
func (c *MWAA) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTagsForResource API operation for AmazonMWAA.
//
// List the tags for MWAA environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   ResourceNotFoundException: The resource is not available.
//
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/ListTagsForResource
func (c *MWAA) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPublishMetrics = "PublishMetrics"

// PublishMetricsRequest generates a "aws/request.Request" representing the
// client's request for the PublishMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishMetrics for more information on using the PublishMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PublishMetricsRequest method.
//    req, resp := client.PublishMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/PublishMetrics
func (c *MWAA) PublishMetricsRequest(input *PublishMetricsInput) (req *request.Request, output *PublishMetricsOutput) {
	op := &request.Operation{
		Name:       opPublishMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/environments/{EnvironmentName}",
	}

	if input == nil {
		input = &PublishMetricsInput{}
	}

	output = &PublishMetricsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("ops.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PublishMetrics API operation for AmazonMWAA.
//
// An operation for publishing metrics from the customers to the Ops plane.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation PublishMetrics for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/PublishMetrics
func (c *MWAA) PublishMetrics(input *PublishMetricsInput) (*PublishMetricsOutput, error) {
	req, out := c.PublishMetricsRequest(input)
	return out, req.Send()
}

// PublishMetricsWithContext is the same as PublishMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See PublishMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) PublishMetricsWithContext(ctx aws.Context, input *PublishMetricsInput, opts ...request.Option) (*PublishMetricsOutput, error) {
	req, out := c.PublishMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/TagResource
func (c *MWAA) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// TagResource API operation for AmazonMWAA.
//
// Add tag to the MWAA environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   ResourceNotFoundException: The resource is not available.
//
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/TagResource
func (c *MWAA) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/UntagResource
func (c *MWAA) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UntagResource API operation for AmazonMWAA.
//
// Remove a tag from the MWAA environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   ResourceNotFoundException: The resource is not available.
//
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/UntagResource
func (c *MWAA) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEnvironmentRequest method.
//    req, resp := client.UpdateEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/UpdateEnvironment
func (c *MWAA) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *UpdateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/environments/{Name}",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &UpdateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("api.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateEnvironment API operation for AmazonMWAA.
//
// Update an MWAA environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmazonMWAA's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   ResourceNotFoundException: The resource is not available.
//
//   * ValidationException
//   ValidationException: The provided input is not valid.
//
//   * InternalServerException
//   InternalServerException: An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mwaa-2020-07-01/UpdateEnvironment
func (c *MWAA) UpdateEnvironment(input *UpdateEnvironmentInput) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MWAA) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access to the Airflow Web UI or CLI has been Denied. Please follow the MWAA
// user guide to setup permissions to access the Web UI and CLI functionality.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateCliTokenInput struct {
	_ struct{} `type:"structure"`

	// Create a CLI token request for a MWAA environment.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCliTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCliTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCliTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCliTokenInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateCliTokenInput) SetName(v string) *CreateCliTokenInput {
	s.Name = &v
	return s
}

type CreateCliTokenOutput struct {
	_ struct{} `type:"structure"`

	// Create an Airflow CLI login token response for the provided JWT token.
	CliToken *string `type:"string" sensitive:"true"`

	// Create an Airflow CLI login token response for the provided webserver hostname.
	WebServerHostname *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCliTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCliTokenOutput) GoString() string {
	return s.String()
}

// SetCliToken sets the CliToken field's value.
func (s *CreateCliTokenOutput) SetCliToken(v string) *CreateCliTokenOutput {
	s.CliToken = &v
	return s
}

// SetWebServerHostname sets the WebServerHostname field's value.
func (s *CreateCliTokenOutput) SetWebServerHostname(v string) *CreateCliTokenOutput {
	s.WebServerHostname = &v
	return s
}

// This section contains the Amazon Managed Workflows for Apache Airflow (MWAA)
// API reference documentation to create an environment. For more information,
// see Get started with Amazon Managed Workflows for Apache Airflow (https://docs.aws.amazon.com/mwaa/latest/userguide/get-started.html).
type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The Apache Airflow configuration setting you want to override in your environment.
	// For more information, see Environment configuration (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
	AirflowConfigurationOptions map[string]*string `type:"map" sensitive:"true"`

	// The Apache Airflow version you want to use for your environment.
	AirflowVersion *string `min:"1" type:"string"`

	// The relative path to the DAG folder on your Amazon S3 storage bucket. For
	// example, dags. For more information, see Importing DAGs on Amazon MWAA (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import.html).
	//
	// DagS3Path is a required field
	DagS3Path *string `min:"1" type:"string" required:"true"`

	// The environment class you want to use for your environment. The environment
	// class determines the size of the containers and database used for your Apache
	// Airflow services.
	EnvironmentClass *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the execution role for your environment.
	// An execution role is an AWS Identity and Access Management (IAM) role that
	// grants MWAA permission to access AWS services and resources used by your
	// environment. For example, arn:aws:iam::123456789:role/my-execution-role.
	// For more information, see Managing access to Amazon Managed Workflows for
	// Apache Airflow (https://docs.aws.amazon.com/mwaa/latest/userguide/manage-access.html).
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `min:"1" type:"string" required:"true"`

	// The AWS Key Management Service (KMS) key to encrypt and decrypt the data
	// in your environment. You can use an AWS KMS key managed by MWAA, or a custom
	// KMS key (advanced). For more information, see Customer master keys (CMKs)
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html?icmpid=docs_console_unmapped#master_keys)
	// in the AWS KMS developer guide.
	KmsKey *string `min:"1" type:"string"`

	// The Apache Airflow logs you want to send to Amazon CloudWatch Logs.
	LoggingConfiguration *LoggingConfigurationInput `type:"structure"`

	// The maximum number of workers that you want to run in your environment. MWAA
	// scales the number of Apache Airflow workers and the Fargate containers that
	// run your tasks up to the number you specify in this field. When there are
	// no more tasks running, and no more in the queue, MWAA disposes of the extra
	// containers leaving the one worker that is included with your environment.
	MaxWorkers *int64 `min:"1" type:"integer"`

	// The minimum number of workers that you want to run in your environment. MWAA
	// scales the number of Apache Airflow workers and the Fargate containers that
	// run your tasks up to the number you specify in the MaxWorkers field. When
	// there are no more tasks running, and no more in the queue, MWAA disposes
	// of the extra containers leaving the worker count you specify in the MinWorkers
	// field.
	MinWorkers *int64 `min:"1" type:"integer"`

	// The name of your MWAA environment.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The VPC networking components you want to use for your environment. At least
	// two private subnet identifiers and one VPC security group identifier are
	// required to create an environment. For more information, see Creating the
	// VPC network for a MWAA environment (https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-mwaa.html).
	//
	// NetworkConfiguration is a required field
	NetworkConfiguration *NetworkConfiguration `type:"structure" required:"true"`

	// The plugins.zip file version you want to use.
	PluginsS3ObjectVersion *string `min:"1" type:"string"`

	// The relative path to the plugins.zip file on your Amazon S3 storage bucket.
	// For example, plugins.zip. If a relative path is provided in the request,
	// then PluginsS3ObjectVersion is required. For more information, see Importing
	// DAGs on Amazon MWAA (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import.html).
	PluginsS3Path *string `min:"1" type:"string"`

	// The requirements.txt file version you want to use.
	RequirementsS3ObjectVersion *string `min:"1" type:"string"`

	// The relative path to the requirements.txt file on your Amazon S3 storage
	// bucket. For example, requirements.txt. If a relative path is provided in
	// the request, then RequirementsS3ObjectVersion is required. For more information,
	// see Importing DAGs on Amazon MWAA (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import.html).
	RequirementsS3Path *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of your Amazon S3 storage bucket. For example,
	// arn:aws:s3:::airflow-mybucketname.
	//
	// SourceBucketArn is a required field
	SourceBucketArn *string `min:"1" type:"string" required:"true"`

	// The metadata tags you want to attach to your environment. For more information,
	// see Tagging AWS resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
	Tags map[string]*string `min:"1" type:"map"`

	// The networking access of your Apache Airflow web server. A public network
	// allows your Airflow UI to be accessed over the Internet by users granted
	// access in your IAM policy. A private network limits access of your Airflow
	// UI to users within your VPC. For more information, see Creating the VPC network
	// for a MWAA environment (https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-mwaa.html).
	WebserverAccessMode *string `type:"string" enum:"WebserverAccessMode"`

	// The day and time you want MWAA to start weekly maintenance updates on your
	// environment.
	WeeklyMaintenanceWindowStart *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.AirflowVersion != nil && len(*s.AirflowVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AirflowVersion", 1))
	}
	if s.DagS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("DagS3Path"))
	}
	if s.DagS3Path != nil && len(*s.DagS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DagS3Path", 1))
	}
	if s.EnvironmentClass != nil && len(*s.EnvironmentClass) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentClass", 1))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 1))
	}
	if s.KmsKey != nil && len(*s.KmsKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKey", 1))
	}
	if s.MaxWorkers != nil && *s.MaxWorkers < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxWorkers", 1))
	}
	if s.MinWorkers != nil && *s.MinWorkers < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinWorkers", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NetworkConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkConfiguration"))
	}
	if s.PluginsS3ObjectVersion != nil && len(*s.PluginsS3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PluginsS3ObjectVersion", 1))
	}
	if s.PluginsS3Path != nil && len(*s.PluginsS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PluginsS3Path", 1))
	}
	if s.RequirementsS3ObjectVersion != nil && len(*s.RequirementsS3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequirementsS3ObjectVersion", 1))
	}
	if s.RequirementsS3Path != nil && len(*s.RequirementsS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequirementsS3Path", 1))
	}
	if s.SourceBucketArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceBucketArn"))
	}
	if s.SourceBucketArn != nil && len(*s.SourceBucketArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceBucketArn", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.WeeklyMaintenanceWindowStart != nil && len(*s.WeeklyMaintenanceWindowStart) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceWindowStart", 1))
	}
	if s.LoggingConfiguration != nil {
		if err := s.LoggingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAirflowConfigurationOptions sets the AirflowConfigurationOptions field's value.
func (s *CreateEnvironmentInput) SetAirflowConfigurationOptions(v map[string]*string) *CreateEnvironmentInput {
	s.AirflowConfigurationOptions = v
	return s
}

// SetAirflowVersion sets the AirflowVersion field's value.
func (s *CreateEnvironmentInput) SetAirflowVersion(v string) *CreateEnvironmentInput {
	s.AirflowVersion = &v
	return s
}

// SetDagS3Path sets the DagS3Path field's value.
func (s *CreateEnvironmentInput) SetDagS3Path(v string) *CreateEnvironmentInput {
	s.DagS3Path = &v
	return s
}

// SetEnvironmentClass sets the EnvironmentClass field's value.
func (s *CreateEnvironmentInput) SetEnvironmentClass(v string) *CreateEnvironmentInput {
	s.EnvironmentClass = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateEnvironmentInput) SetExecutionRoleArn(v string) *CreateEnvironmentInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *CreateEnvironmentInput) SetKmsKey(v string) *CreateEnvironmentInput {
	s.KmsKey = &v
	return s
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *CreateEnvironmentInput) SetLoggingConfiguration(v *LoggingConfigurationInput) *CreateEnvironmentInput {
	s.LoggingConfiguration = v
	return s
}

// SetMaxWorkers sets the MaxWorkers field's value.
func (s *CreateEnvironmentInput) SetMaxWorkers(v int64) *CreateEnvironmentInput {
	s.MaxWorkers = &v
	return s
}

// SetMinWorkers sets the MinWorkers field's value.
func (s *CreateEnvironmentInput) SetMinWorkers(v int64) *CreateEnvironmentInput {
	s.MinWorkers = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentInput) SetName(v string) *CreateEnvironmentInput {
	s.Name = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *CreateEnvironmentInput) SetNetworkConfiguration(v *NetworkConfiguration) *CreateEnvironmentInput {
	s.NetworkConfiguration = v
	return s
}

// SetPluginsS3ObjectVersion sets the PluginsS3ObjectVersion field's value.
func (s *CreateEnvironmentInput) SetPluginsS3ObjectVersion(v string) *CreateEnvironmentInput {
	s.PluginsS3ObjectVersion = &v
	return s
}

// SetPluginsS3Path sets the PluginsS3Path field's value.
func (s *CreateEnvironmentInput) SetPluginsS3Path(v string) *CreateEnvironmentInput {
	s.PluginsS3Path = &v
	return s
}

// SetRequirementsS3ObjectVersion sets the RequirementsS3ObjectVersion field's value.
func (s *CreateEnvironmentInput) SetRequirementsS3ObjectVersion(v string) *CreateEnvironmentInput {
	s.RequirementsS3ObjectVersion = &v
	return s
}

// SetRequirementsS3Path sets the RequirementsS3Path field's value.
func (s *CreateEnvironmentInput) SetRequirementsS3Path(v string) *CreateEnvironmentInput {
	s.RequirementsS3Path = &v
	return s
}

// SetSourceBucketArn sets the SourceBucketArn field's value.
func (s *CreateEnvironmentInput) SetSourceBucketArn(v string) *CreateEnvironmentInput {
	s.SourceBucketArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentInput) SetTags(v map[string]*string) *CreateEnvironmentInput {
	s.Tags = v
	return s
}

// SetWebserverAccessMode sets the WebserverAccessMode field's value.
func (s *CreateEnvironmentInput) SetWebserverAccessMode(v string) *CreateEnvironmentInput {
	s.WebserverAccessMode = &v
	return s
}

// SetWeeklyMaintenanceWindowStart sets the WeeklyMaintenanceWindowStart field's value.
func (s *CreateEnvironmentInput) SetWeeklyMaintenanceWindowStart(v string) *CreateEnvironmentInput {
	s.WeeklyMaintenanceWindowStart = &v
	return s
}

type CreateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The resulting Amazon MWAA envirnonment ARN.
	Arn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateEnvironmentOutput) SetArn(v string) *CreateEnvironmentOutput {
	s.Arn = &v
	return s
}

type CreateWebLoginTokenInput struct {
	_ struct{} `type:"structure"`

	// Create an Airflow Web UI login token request for a MWAA environment.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateWebLoginTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebLoginTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWebLoginTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWebLoginTokenInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateWebLoginTokenInput) SetName(v string) *CreateWebLoginTokenInput {
	s.Name = &v
	return s
}

type CreateWebLoginTokenOutput struct {
	_ struct{} `type:"structure"`

	// Create an Airflow Web UI login token response for the provided webserver
	// hostname.
	WebServerHostname *string `min:"1" type:"string"`

	// Create an Airflow Web UI login token response for the provided JWT token.
	WebToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s CreateWebLoginTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebLoginTokenOutput) GoString() string {
	return s.String()
}

// SetWebServerHostname sets the WebServerHostname field's value.
func (s *CreateWebLoginTokenOutput) SetWebServerHostname(v string) *CreateWebLoginTokenOutput {
	s.WebServerHostname = &v
	return s
}

// SetWebToken sets the WebToken field's value.
func (s *CreateWebLoginTokenOutput) SetWebToken(v string) *CreateWebLoginTokenOutput {
	s.WebToken = &v
	return s
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEnvironmentInput) SetName(v string) *DeleteEnvironmentInput {
	s.Name = &v
	return s
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

// Internal only API.
type Dimension struct {
	_ struct{} `type:"structure"`

	// Internal only API.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Internal only API.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Dimension) SetName(v string) *Dimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Dimension) SetValue(v string) *Dimension {
	s.Value = &v
	return s
}

// An Amazon MWAA environment.
type Environment struct {
	_ struct{} `type:"structure"`

	// The Airflow Configuration Options of the Amazon MWAA Environment.
	AirflowConfigurationOptions map[string]*string `type:"map"`

	// The AirflowV ersion of the Amazon MWAA Environment.
	AirflowVersion *string `min:"1" type:"string"`

	// The ARN of the Amazon MWAA Environment.
	Arn *string `min:"1" type:"string"`

	// The Created At date of the Amazon MWAA Environment.
	CreatedAt *time.Time `type:"timestamp"`

	// The Dags S3 Path of the Amazon MWAA Environment.
	DagS3Path *string `min:"1" type:"string"`

	// The Environment Class (size) of the Amazon MWAA Environment.
	EnvironmentClass *string `min:"1" type:"string"`

	// The Execution Role ARN of the Amazon MWAA Environment.
	ExecutionRoleArn *string `min:"1" type:"string"`

	// The Kms Key of the Amazon MWAA Environment.
	KmsKey *string `min:"1" type:"string"`

	// Last update information for the environment.
	LastUpdate *LastUpdate `type:"structure"`

	// The Logging Configuration of the Amazon MWAA Environment.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`

	// The maximum number of workers to run in your Amazon MWAA Environment.
	MaxWorkers *int64 `min:"1" type:"integer"`

	// The minimum number of workers to run in your Amazon MWAA Environment.
	MinWorkers *int64 `min:"1" type:"integer"`

	// The name of the Amazon MWAA Environment.
	Name *string `min:"1" type:"string"`

	// Provide the security group and subnet IDs for the workers and scheduler.
	NetworkConfiguration *NetworkConfiguration `type:"structure"`

	// The Plugins.zip S3 Object Version of the Amazon MWAA Environment.
	PluginsS3ObjectVersion *string `min:"1" type:"string"`

	// The Plugins.zip S3 Path of the Amazon MWAA Environment.
	PluginsS3Path *string `min:"1" type:"string"`

	// The Requirements.txt file S3 Object Version of the Amazon MWAA Environment.
	RequirementsS3ObjectVersion *string `min:"1" type:"string"`

	// The Requirement.txt S3 Path of the Amazon MWAA Environment.
	RequirementsS3Path *string `min:"1" type:"string"`

	// The Service Role ARN of the Amazon MWAA Environment.
	ServiceRoleArn *string `min:"1" type:"string"`

	// The Source S3 Bucket ARN of the Amazon MWAA Environment.
	SourceBucketArn *string `min:"1" type:"string"`

	// The status of the Amazon MWAA Environment.
	Status *string `type:"string" enum:"EnvironmentStatus"`

	// The Tags of the Amazon MWAA Environment.
	Tags map[string]*string `min:"1" type:"map"`

	// The Webserver Access Mode of the Amazon MWAA Environment (public or private
	// only).
	WebserverAccessMode *string `type:"string" enum:"WebserverAccessMode"`

	// The Webserver URL of the Amazon MWAA Environment.
	WebserverUrl *string `min:"1" type:"string"`

	// The Weekly Maintenance Window Start of the Amazon MWAA Environment.
	WeeklyMaintenanceWindowStart *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Environment) GoString() string {
	return s.String()
}

// SetAirflowConfigurationOptions sets the AirflowConfigurationOptions field's value.
func (s *Environment) SetAirflowConfigurationOptions(v map[string]*string) *Environment {
	s.AirflowConfigurationOptions = v
	return s
}

// SetAirflowVersion sets the AirflowVersion field's value.
func (s *Environment) SetAirflowVersion(v string) *Environment {
	s.AirflowVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Environment) SetArn(v string) *Environment {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Environment) SetCreatedAt(v time.Time) *Environment {
	s.CreatedAt = &v
	return s
}

// SetDagS3Path sets the DagS3Path field's value.
func (s *Environment) SetDagS3Path(v string) *Environment {
	s.DagS3Path = &v
	return s
}

// SetEnvironmentClass sets the EnvironmentClass field's value.
func (s *Environment) SetEnvironmentClass(v string) *Environment {
	s.EnvironmentClass = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *Environment) SetExecutionRoleArn(v string) *Environment {
	s.ExecutionRoleArn = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *Environment) SetKmsKey(v string) *Environment {
	s.KmsKey = &v
	return s
}

// SetLastUpdate sets the LastUpdate field's value.
func (s *Environment) SetLastUpdate(v *LastUpdate) *Environment {
	s.LastUpdate = v
	return s
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *Environment) SetLoggingConfiguration(v *LoggingConfiguration) *Environment {
	s.LoggingConfiguration = v
	return s
}

// SetMaxWorkers sets the MaxWorkers field's value.
func (s *Environment) SetMaxWorkers(v int64) *Environment {
	s.MaxWorkers = &v
	return s
}

// SetMinWorkers sets the MinWorkers field's value.
func (s *Environment) SetMinWorkers(v int64) *Environment {
	s.MinWorkers = &v
	return s
}

// SetName sets the Name field's value.
func (s *Environment) SetName(v string) *Environment {
	s.Name = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *Environment) SetNetworkConfiguration(v *NetworkConfiguration) *Environment {
	s.NetworkConfiguration = v
	return s
}

// SetPluginsS3ObjectVersion sets the PluginsS3ObjectVersion field's value.
func (s *Environment) SetPluginsS3ObjectVersion(v string) *Environment {
	s.PluginsS3ObjectVersion = &v
	return s
}

// SetPluginsS3Path sets the PluginsS3Path field's value.
func (s *Environment) SetPluginsS3Path(v string) *Environment {
	s.PluginsS3Path = &v
	return s
}

// SetRequirementsS3ObjectVersion sets the RequirementsS3ObjectVersion field's value.
func (s *Environment) SetRequirementsS3ObjectVersion(v string) *Environment {
	s.RequirementsS3ObjectVersion = &v
	return s
}

// SetRequirementsS3Path sets the RequirementsS3Path field's value.
func (s *Environment) SetRequirementsS3Path(v string) *Environment {
	s.RequirementsS3Path = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *Environment) SetServiceRoleArn(v string) *Environment {
	s.ServiceRoleArn = &v
	return s
}

// SetSourceBucketArn sets the SourceBucketArn field's value.
func (s *Environment) SetSourceBucketArn(v string) *Environment {
	s.SourceBucketArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Environment) SetStatus(v string) *Environment {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Environment) SetTags(v map[string]*string) *Environment {
	s.Tags = v
	return s
}

// SetWebserverAccessMode sets the WebserverAccessMode field's value.
func (s *Environment) SetWebserverAccessMode(v string) *Environment {
	s.WebserverAccessMode = &v
	return s
}

// SetWebserverUrl sets the WebserverUrl field's value.
func (s *Environment) SetWebserverUrl(v string) *Environment {
	s.WebserverUrl = &v
	return s
}

// SetWeeklyMaintenanceWindowStart sets the WeeklyMaintenanceWindowStart field's value.
func (s *Environment) SetWeeklyMaintenanceWindowStart(v string) *Environment {
	s.WeeklyMaintenanceWindowStart = &v
	return s
}

type GetEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetEnvironmentInput) SetName(v string) *GetEnvironmentInput {
	s.Name = &v
	return s
}

type GetEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// A JSON blob with environment details.
	Environment *Environment `type:"structure"`
}

// String returns the string representation
func (s GetEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *GetEnvironmentOutput) SetEnvironment(v *Environment) *GetEnvironmentOutput {
	s.Environment = v
	return s
}

// InternalServerException: An internal error has occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Last update information for the environment.
type LastUpdate struct {
	_ struct{} `type:"structure"`

	// Time that last update occurred.
	CreatedAt *time.Time `type:"timestamp"`

	// Error string of last update, if applicable.
	Error *UpdateError `type:"structure"`

	// Status of last update of SUCCESS, FAILED, CREATING, DELETING.
	Status *string `type:"string" enum:"UpdateStatus"`
}

// String returns the string representation
func (s LastUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LastUpdate) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LastUpdate) SetCreatedAt(v time.Time) *LastUpdate {
	s.CreatedAt = &v
	return s
}

// SetError sets the Error field's value.
func (s *LastUpdate) SetError(v *UpdateError) *LastUpdate {
	s.Error = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LastUpdate) SetStatus(v string) *LastUpdate {
	s.Status = &v
	return s
}

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum results when listing MWAA environments.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The Next Token when listing MWAA environments.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentsInput) SetMaxResults(v int64) *ListEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsInput) SetNextToken(v string) *ListEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon MWAA Environments.
	//
	// Environments is a required field
	Environments []*string `type:"list" required:"true"`

	// The Next Token when listing MWAA environments.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *ListEnvironmentsOutput) SetEnvironments(v []*string) *ListEnvironmentsOutput {
	s.Environments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsOutput) SetNextToken(v string) *ListEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the MWAA environment.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags of the MWAA environments.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The Logging Configuration of your Amazon MWAA environment.
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	DagProcessingLogs *ModuleLoggingConfiguration `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	SchedulerLogs *ModuleLoggingConfiguration `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	TaskLogs *ModuleLoggingConfiguration `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	WebserverLogs *ModuleLoggingConfiguration `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	WorkerLogs *ModuleLoggingConfiguration `type:"structure"`
}

// String returns the string representation
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfiguration) GoString() string {
	return s.String()
}

// SetDagProcessingLogs sets the DagProcessingLogs field's value.
func (s *LoggingConfiguration) SetDagProcessingLogs(v *ModuleLoggingConfiguration) *LoggingConfiguration {
	s.DagProcessingLogs = v
	return s
}

// SetSchedulerLogs sets the SchedulerLogs field's value.
func (s *LoggingConfiguration) SetSchedulerLogs(v *ModuleLoggingConfiguration) *LoggingConfiguration {
	s.SchedulerLogs = v
	return s
}

// SetTaskLogs sets the TaskLogs field's value.
func (s *LoggingConfiguration) SetTaskLogs(v *ModuleLoggingConfiguration) *LoggingConfiguration {
	s.TaskLogs = v
	return s
}

// SetWebserverLogs sets the WebserverLogs field's value.
func (s *LoggingConfiguration) SetWebserverLogs(v *ModuleLoggingConfiguration) *LoggingConfiguration {
	s.WebserverLogs = v
	return s
}

// SetWorkerLogs sets the WorkerLogs field's value.
func (s *LoggingConfiguration) SetWorkerLogs(v *ModuleLoggingConfiguration) *LoggingConfiguration {
	s.WorkerLogs = v
	return s
}

// The Logging Configuration of your Amazon MWAA environment.
type LoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	DagProcessingLogs *ModuleLoggingConfigurationInput `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	SchedulerLogs *ModuleLoggingConfigurationInput `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	TaskLogs *ModuleLoggingConfigurationInput `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	WebserverLogs *ModuleLoggingConfigurationInput `type:"structure"`

	// A JSON blob that provides configuration to use for logging with respect to
	// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
	// WebserverLogs, and WorkerLogs.
	WorkerLogs *ModuleLoggingConfigurationInput `type:"structure"`
}

// String returns the string representation
func (s LoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfigurationInput"}
	if s.DagProcessingLogs != nil {
		if err := s.DagProcessingLogs.Validate(); err != nil {
			invalidParams.AddNested("DagProcessingLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.SchedulerLogs != nil {
		if err := s.SchedulerLogs.Validate(); err != nil {
			invalidParams.AddNested("SchedulerLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.TaskLogs != nil {
		if err := s.TaskLogs.Validate(); err != nil {
			invalidParams.AddNested("TaskLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.WebserverLogs != nil {
		if err := s.WebserverLogs.Validate(); err != nil {
			invalidParams.AddNested("WebserverLogs", err.(request.ErrInvalidParams))
		}
	}
	if s.WorkerLogs != nil {
		if err := s.WorkerLogs.Validate(); err != nil {
			invalidParams.AddNested("WorkerLogs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDagProcessingLogs sets the DagProcessingLogs field's value.
func (s *LoggingConfigurationInput) SetDagProcessingLogs(v *ModuleLoggingConfigurationInput) *LoggingConfigurationInput {
	s.DagProcessingLogs = v
	return s
}

// SetSchedulerLogs sets the SchedulerLogs field's value.
func (s *LoggingConfigurationInput) SetSchedulerLogs(v *ModuleLoggingConfigurationInput) *LoggingConfigurationInput {
	s.SchedulerLogs = v
	return s
}

// SetTaskLogs sets the TaskLogs field's value.
func (s *LoggingConfigurationInput) SetTaskLogs(v *ModuleLoggingConfigurationInput) *LoggingConfigurationInput {
	s.TaskLogs = v
	return s
}

// SetWebserverLogs sets the WebserverLogs field's value.
func (s *LoggingConfigurationInput) SetWebserverLogs(v *ModuleLoggingConfigurationInput) *LoggingConfigurationInput {
	s.WebserverLogs = v
	return s
}

// SetWorkerLogs sets the WorkerLogs field's value.
func (s *LoggingConfigurationInput) SetWorkerLogs(v *ModuleLoggingConfigurationInput) *LoggingConfigurationInput {
	s.WorkerLogs = v
	return s
}

// Internal only API.
type MetricDatum struct {
	_ struct{} `type:"structure"`

	// Internal only API.
	Dimensions []*Dimension `type:"list"`

	// Internal only API.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// Internal only API.
	StatisticValues *StatisticSet `type:"structure"`

	// Internal only API.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`

	// Unit
	Unit *string `type:"string" enum:"Unit"`

	// Internal only API.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s MetricDatum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDatum) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDatum) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDatum"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *MetricDatum) SetDimensions(v []*Dimension) *MetricDatum {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *MetricDatum) SetMetricName(v string) *MetricDatum {
	s.MetricName = &v
	return s
}

// SetStatisticValues sets the StatisticValues field's value.
func (s *MetricDatum) SetStatisticValues(v *StatisticSet) *MetricDatum {
	s.StatisticValues = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *MetricDatum) SetTimestamp(v time.Time) *MetricDatum {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricDatum) SetUnit(v string) *MetricDatum {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDatum) SetValue(v float64) *MetricDatum {
	s.Value = &v
	return s
}

// A JSON blob that provides configuration to use for logging with respect to
// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
// WebserverLogs, and WorkerLogs.
type ModuleLoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides the ARN for the CloudWatch group where the logs will be published.
	CloudWatchLogGroupArn *string `min:"1" type:"string"`

	// Defines that the logging module is enabled.
	Enabled *bool `type:"boolean"`

	// Defines the log level, which can be CRITICAL, ERROR, WARNING, or INFO.
	LogLevel *string `type:"string" enum:"LoggingLevel"`
}

// String returns the string representation
func (s ModuleLoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModuleLoggingConfiguration) GoString() string {
	return s.String()
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *ModuleLoggingConfiguration) SetCloudWatchLogGroupArn(v string) *ModuleLoggingConfiguration {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ModuleLoggingConfiguration) SetEnabled(v bool) *ModuleLoggingConfiguration {
	s.Enabled = &v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *ModuleLoggingConfiguration) SetLogLevel(v string) *ModuleLoggingConfiguration {
	s.LogLevel = &v
	return s
}

// A JSON blob that provides configuration to use for logging with respect to
// the various Apache Airflow services: DagProcessingLogs, SchedulerLogs, TaskLogs,
// WebserverLogs, and WorkerLogs.
type ModuleLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Defines that the logging module is enabled.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Defines the log level, which can be CRITICAL, ERROR, WARNING, or INFO.
	//
	// LogLevel is a required field
	LogLevel *string `type:"string" required:"true" enum:"LoggingLevel"`
}

// String returns the string representation
func (s ModuleLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModuleLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModuleLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModuleLoggingConfigurationInput"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.LogLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("LogLevel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ModuleLoggingConfigurationInput) SetEnabled(v bool) *ModuleLoggingConfigurationInput {
	s.Enabled = &v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *ModuleLoggingConfigurationInput) SetLogLevel(v string) *ModuleLoggingConfigurationInput {
	s.LogLevel = &v
	return s
}

// Provide the security group and subnet IDs for the workers and scheduler.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// A JSON list of 1 or more security groups IDs by name, in the same VPC as
	// the subnets.
	SecurityGroupIds []*string `min:"1" type:"list"`

	// Provide a JSON list of 2 subnet IDs by name. These must be private subnets,
	// in the same VPC, in two different availability zones.
	SubnetIds []*string `min:"2" type:"list"`
}

// String returns the string representation
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkConfiguration"}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *NetworkConfiguration) SetSecurityGroupIds(v []*string) *NetworkConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *NetworkConfiguration) SetSubnetIds(v []*string) *NetworkConfiguration {
	s.SubnetIds = v
	return s
}

type PublishMetricsInput struct {
	_ struct{} `type:"structure"`

	// Publishes environment metric data to Amazon CloudWatch.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `location:"uri" locationName:"EnvironmentName" min:"1" type:"string" required:"true"`

	// Publishes metric data points to Amazon CloudWatch. CloudWatch associates
	// the data points with the specified metrica.
	//
	// MetricData is a required field
	MetricData []*MetricDatum `type:"list" required:"true"`
}

// String returns the string representation
func (s PublishMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishMetricsInput"}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.MetricData == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricData"))
	}
	if s.MetricData != nil {
		for i, v := range s.MetricData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *PublishMetricsInput) SetEnvironmentName(v string) *PublishMetricsInput {
	s.EnvironmentName = &v
	return s
}

// SetMetricData sets the MetricData field's value.
func (s *PublishMetricsInput) SetMetricData(v []*MetricDatum) *PublishMetricsInput {
	s.MetricData = v
	return s
}

type PublishMetricsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PublishMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishMetricsOutput) GoString() string {
	return s.String()
}

// ResourceNotFoundException: The resource is not available.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Internal only API.
type StatisticSet struct {
	_ struct{} `type:"structure"`

	// Internal only API.
	Maximum *float64 `type:"double"`

	// Internal only API.
	Minimum *float64 `type:"double"`

	// Internal only API.
	SampleCount *int64 `type:"integer"`

	// Internal only API.
	Sum *float64 `type:"double"`
}

// String returns the string representation
func (s StatisticSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatisticSet) GoString() string {
	return s.String()
}

// SetMaximum sets the Maximum field's value.
func (s *StatisticSet) SetMaximum(v float64) *StatisticSet {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *StatisticSet) SetMinimum(v float64) *StatisticSet {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *StatisticSet) SetSampleCount(v int64) *StatisticSet {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *StatisticSet) SetSum(v float64) *StatisticSet {
	s.Sum = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The tag resource ARN of the MWAA environments.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// The tag resource tag of the MWAA environments.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The tag resource ARN of the MWAA environments.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// The tag resource key of the MWAA environments.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The Airflow Configuration Options to update of your Amazon MWAA environment.
	AirflowConfigurationOptions map[string]*string `type:"map" sensitive:"true"`

	// The Airflow Version to update of your Amazon MWAA environment.
	AirflowVersion *string `min:"1" type:"string"`

	// The Dags folder S3 Path to update of your Amazon MWAA environment.
	DagS3Path *string `min:"1" type:"string"`

	// The Environment Class to update of your Amazon MWAA environment.
	EnvironmentClass *string `min:"1" type:"string"`

	// The Executio Role ARN to update of your Amazon MWAA environment.
	ExecutionRoleArn *string `min:"1" type:"string"`

	// The Logging Configuration to update of your Amazon MWAA environment.
	LoggingConfiguration *LoggingConfigurationInput `type:"structure"`

	// The maximum number of workers to update of your Amazon MWAA environment.
	MaxWorkers *int64 `min:"1" type:"integer"`

	// The minimum number of workers to update of your Amazon MWAA environment.
	MinWorkers *int64 `min:"1" type:"integer"`

	// The name of your Amazon MWAA environment that you wish to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The Network Configuration to update of your Amazon MWAA environment.
	NetworkConfiguration *UpdateNetworkConfigurationInput `type:"structure"`

	// The Plugins.zip S3 Object Version to update of your Amazon MWAA environment.
	PluginsS3ObjectVersion *string `min:"1" type:"string"`

	// The Plugins.zip S3 Path to update of your Amazon MWAA environment.
	PluginsS3Path *string `min:"1" type:"string"`

	// The Requirements.txt S3 ObjectV ersion to update of your Amazon MWAA environment.
	RequirementsS3ObjectVersion *string `min:"1" type:"string"`

	// The Requirements.txt S3 Path to update of your Amazon MWAA environment.
	RequirementsS3Path *string `min:"1" type:"string"`

	// The S3 Source Bucket ARN to update of your Amazon MWAA environment.
	SourceBucketArn *string `min:"1" type:"string"`

	// The Webserver Access Mode to update of your Amazon MWAA environment.
	WebserverAccessMode *string `type:"string" enum:"WebserverAccessMode"`

	// The Weekly Maintenance Window Start to update of your Amazon MWAA environment.
	WeeklyMaintenanceWindowStart *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.AirflowVersion != nil && len(*s.AirflowVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AirflowVersion", 1))
	}
	if s.DagS3Path != nil && len(*s.DagS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DagS3Path", 1))
	}
	if s.EnvironmentClass != nil && len(*s.EnvironmentClass) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentClass", 1))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 1))
	}
	if s.MaxWorkers != nil && *s.MaxWorkers < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxWorkers", 1))
	}
	if s.MinWorkers != nil && *s.MinWorkers < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinWorkers", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PluginsS3ObjectVersion != nil && len(*s.PluginsS3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PluginsS3ObjectVersion", 1))
	}
	if s.PluginsS3Path != nil && len(*s.PluginsS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PluginsS3Path", 1))
	}
	if s.RequirementsS3ObjectVersion != nil && len(*s.RequirementsS3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequirementsS3ObjectVersion", 1))
	}
	if s.RequirementsS3Path != nil && len(*s.RequirementsS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequirementsS3Path", 1))
	}
	if s.SourceBucketArn != nil && len(*s.SourceBucketArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceBucketArn", 1))
	}
	if s.WeeklyMaintenanceWindowStart != nil && len(*s.WeeklyMaintenanceWindowStart) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeeklyMaintenanceWindowStart", 1))
	}
	if s.LoggingConfiguration != nil {
		if err := s.LoggingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAirflowConfigurationOptions sets the AirflowConfigurationOptions field's value.
func (s *UpdateEnvironmentInput) SetAirflowConfigurationOptions(v map[string]*string) *UpdateEnvironmentInput {
	s.AirflowConfigurationOptions = v
	return s
}

// SetAirflowVersion sets the AirflowVersion field's value.
func (s *UpdateEnvironmentInput) SetAirflowVersion(v string) *UpdateEnvironmentInput {
	s.AirflowVersion = &v
	return s
}

// SetDagS3Path sets the DagS3Path field's value.
func (s *UpdateEnvironmentInput) SetDagS3Path(v string) *UpdateEnvironmentInput {
	s.DagS3Path = &v
	return s
}

// SetEnvironmentClass sets the EnvironmentClass field's value.
func (s *UpdateEnvironmentInput) SetEnvironmentClass(v string) *UpdateEnvironmentInput {
	s.EnvironmentClass = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *UpdateEnvironmentInput) SetExecutionRoleArn(v string) *UpdateEnvironmentInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *UpdateEnvironmentInput) SetLoggingConfiguration(v *LoggingConfigurationInput) *UpdateEnvironmentInput {
	s.LoggingConfiguration = v
	return s
}

// SetMaxWorkers sets the MaxWorkers field's value.
func (s *UpdateEnvironmentInput) SetMaxWorkers(v int64) *UpdateEnvironmentInput {
	s.MaxWorkers = &v
	return s
}

// SetMinWorkers sets the MinWorkers field's value.
func (s *UpdateEnvironmentInput) SetMinWorkers(v int64) *UpdateEnvironmentInput {
	s.MinWorkers = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEnvironmentInput) SetName(v string) *UpdateEnvironmentInput {
	s.Name = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *UpdateEnvironmentInput) SetNetworkConfiguration(v *UpdateNetworkConfigurationInput) *UpdateEnvironmentInput {
	s.NetworkConfiguration = v
	return s
}

// SetPluginsS3ObjectVersion sets the PluginsS3ObjectVersion field's value.
func (s *UpdateEnvironmentInput) SetPluginsS3ObjectVersion(v string) *UpdateEnvironmentInput {
	s.PluginsS3ObjectVersion = &v
	return s
}

// SetPluginsS3Path sets the PluginsS3Path field's value.
func (s *UpdateEnvironmentInput) SetPluginsS3Path(v string) *UpdateEnvironmentInput {
	s.PluginsS3Path = &v
	return s
}

// SetRequirementsS3ObjectVersion sets the RequirementsS3ObjectVersion field's value.
func (s *UpdateEnvironmentInput) SetRequirementsS3ObjectVersion(v string) *UpdateEnvironmentInput {
	s.RequirementsS3ObjectVersion = &v
	return s
}

// SetRequirementsS3Path sets the RequirementsS3Path field's value.
func (s *UpdateEnvironmentInput) SetRequirementsS3Path(v string) *UpdateEnvironmentInput {
	s.RequirementsS3Path = &v
	return s
}

// SetSourceBucketArn sets the SourceBucketArn field's value.
func (s *UpdateEnvironmentInput) SetSourceBucketArn(v string) *UpdateEnvironmentInput {
	s.SourceBucketArn = &v
	return s
}

// SetWebserverAccessMode sets the WebserverAccessMode field's value.
func (s *UpdateEnvironmentInput) SetWebserverAccessMode(v string) *UpdateEnvironmentInput {
	s.WebserverAccessMode = &v
	return s
}

// SetWeeklyMaintenanceWindowStart sets the WeeklyMaintenanceWindowStart field's value.
func (s *UpdateEnvironmentInput) SetWeeklyMaintenanceWindowStart(v string) *UpdateEnvironmentInput {
	s.WeeklyMaintenanceWindowStart = &v
	return s
}

type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The ARN to update of your Amazon MWAA environment.
	Arn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateEnvironmentOutput) SetArn(v string) *UpdateEnvironmentOutput {
	s.Arn = &v
	return s
}

// Error information of update, if applicable.
type UpdateError struct {
	_ struct{} `type:"structure"`

	// Error code of update.
	ErrorCode *string `type:"string"`

	// Error message of update.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UpdateError) SetErrorCode(v string) *UpdateError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UpdateError) SetErrorMessage(v string) *UpdateError {
	s.ErrorMessage = &v
	return s
}

// Provide the security group and subnet IDs for the workers and scheduler.
type UpdateNetworkConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Provide a JSON list of 1 or more security groups IDs by name, in the same
	// VPC as the subnets.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateNetworkConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNetworkConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNetworkConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNetworkConfigurationInput"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateNetworkConfigurationInput) SetSecurityGroupIds(v []*string) *UpdateNetworkConfigurationInput {
	s.SecurityGroupIds = v
	return s
}

// ValidationException: The provided input is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// EnvironmentStatusCreating is a EnvironmentStatus enum value
	EnvironmentStatusCreating = "CREATING"

	// EnvironmentStatusCreateFailed is a EnvironmentStatus enum value
	EnvironmentStatusCreateFailed = "CREATE_FAILED"

	// EnvironmentStatusAvailable is a EnvironmentStatus enum value
	EnvironmentStatusAvailable = "AVAILABLE"

	// EnvironmentStatusUpdating is a EnvironmentStatus enum value
	EnvironmentStatusUpdating = "UPDATING"

	// EnvironmentStatusDeleting is a EnvironmentStatus enum value
	EnvironmentStatusDeleting = "DELETING"

	// EnvironmentStatusDeleted is a EnvironmentStatus enum value
	EnvironmentStatusDeleted = "DELETED"

	// EnvironmentStatusUnavailable is a EnvironmentStatus enum value
	EnvironmentStatusUnavailable = "UNAVAILABLE"

	// EnvironmentStatusUpdateFailed is a EnvironmentStatus enum value
	EnvironmentStatusUpdateFailed = "UPDATE_FAILED"
)

// EnvironmentStatus_Values returns all elements of the EnvironmentStatus enum
func EnvironmentStatus_Values() []string {
	return []string{
		EnvironmentStatusCreating,
		EnvironmentStatusCreateFailed,
		EnvironmentStatusAvailable,
		EnvironmentStatusUpdating,
		EnvironmentStatusDeleting,
		EnvironmentStatusDeleted,
		EnvironmentStatusUnavailable,
		EnvironmentStatusUpdateFailed,
	}
}

const (
	// LoggingLevelCritical is a LoggingLevel enum value
	LoggingLevelCritical = "CRITICAL"

	// LoggingLevelError is a LoggingLevel enum value
	LoggingLevelError = "ERROR"

	// LoggingLevelWarning is a LoggingLevel enum value
	LoggingLevelWarning = "WARNING"

	// LoggingLevelInfo is a LoggingLevel enum value
	LoggingLevelInfo = "INFO"

	// LoggingLevelDebug is a LoggingLevel enum value
	LoggingLevelDebug = "DEBUG"
)

// LoggingLevel_Values returns all elements of the LoggingLevel enum
func LoggingLevel_Values() []string {
	return []string{
		LoggingLevelCritical,
		LoggingLevelError,
		LoggingLevelWarning,
		LoggingLevelInfo,
		LoggingLevelDebug,
	}
}

// Unit
const (
	// UnitSeconds is a Unit enum value
	UnitSeconds = "Seconds"

	// UnitMicroseconds is a Unit enum value
	UnitMicroseconds = "Microseconds"

	// UnitMilliseconds is a Unit enum value
	UnitMilliseconds = "Milliseconds"

	// UnitBytes is a Unit enum value
	UnitBytes = "Bytes"

	// UnitKilobytes is a Unit enum value
	UnitKilobytes = "Kilobytes"

	// UnitMegabytes is a Unit enum value
	UnitMegabytes = "Megabytes"

	// UnitGigabytes is a Unit enum value
	UnitGigabytes = "Gigabytes"

	// UnitTerabytes is a Unit enum value
	UnitTerabytes = "Terabytes"

	// UnitBits is a Unit enum value
	UnitBits = "Bits"

	// UnitKilobits is a Unit enum value
	UnitKilobits = "Kilobits"

	// UnitMegabits is a Unit enum value
	UnitMegabits = "Megabits"

	// UnitGigabits is a Unit enum value
	UnitGigabits = "Gigabits"

	// UnitTerabits is a Unit enum value
	UnitTerabits = "Terabits"

	// UnitPercent is a Unit enum value
	UnitPercent = "Percent"

	// UnitCount is a Unit enum value
	UnitCount = "Count"

	// UnitBytesSecond is a Unit enum value
	UnitBytesSecond = "Bytes/Second"

	// UnitKilobytesSecond is a Unit enum value
	UnitKilobytesSecond = "Kilobytes/Second"

	// UnitMegabytesSecond is a Unit enum value
	UnitMegabytesSecond = "Megabytes/Second"

	// UnitGigabytesSecond is a Unit enum value
	UnitGigabytesSecond = "Gigabytes/Second"

	// UnitTerabytesSecond is a Unit enum value
	UnitTerabytesSecond = "Terabytes/Second"

	// UnitBitsSecond is a Unit enum value
	UnitBitsSecond = "Bits/Second"

	// UnitKilobitsSecond is a Unit enum value
	UnitKilobitsSecond = "Kilobits/Second"

	// UnitMegabitsSecond is a Unit enum value
	UnitMegabitsSecond = "Megabits/Second"

	// UnitGigabitsSecond is a Unit enum value
	UnitGigabitsSecond = "Gigabits/Second"

	// UnitTerabitsSecond is a Unit enum value
	UnitTerabitsSecond = "Terabits/Second"

	// UnitCountSecond is a Unit enum value
	UnitCountSecond = "Count/Second"

	// UnitNone is a Unit enum value
	UnitNone = "None"
)

// Unit_Values returns all elements of the Unit enum
func Unit_Values() []string {
	return []string{
		UnitSeconds,
		UnitMicroseconds,
		UnitMilliseconds,
		UnitBytes,
		UnitKilobytes,
		UnitMegabytes,
		UnitGigabytes,
		UnitTerabytes,
		UnitBits,
		UnitKilobits,
		UnitMegabits,
		UnitGigabits,
		UnitTerabits,
		UnitPercent,
		UnitCount,
		UnitBytesSecond,
		UnitKilobytesSecond,
		UnitMegabytesSecond,
		UnitGigabytesSecond,
		UnitTerabytesSecond,
		UnitBitsSecond,
		UnitKilobitsSecond,
		UnitMegabitsSecond,
		UnitGigabitsSecond,
		UnitTerabitsSecond,
		UnitCountSecond,
		UnitNone,
	}
}

const (
	// UpdateStatusSuccess is a UpdateStatus enum value
	UpdateStatusSuccess = "SUCCESS"

	// UpdateStatusPending is a UpdateStatus enum value
	UpdateStatusPending = "PENDING"

	// UpdateStatusFailed is a UpdateStatus enum value
	UpdateStatusFailed = "FAILED"
)

// UpdateStatus_Values returns all elements of the UpdateStatus enum
func UpdateStatus_Values() []string {
	return []string{
		UpdateStatusSuccess,
		UpdateStatusPending,
		UpdateStatusFailed,
	}
}

const (
	// WebserverAccessModePrivateOnly is a WebserverAccessMode enum value
	WebserverAccessModePrivateOnly = "PRIVATE_ONLY"

	// WebserverAccessModePublicOnly is a WebserverAccessMode enum value
	WebserverAccessModePublicOnly = "PUBLIC_ONLY"
)

// WebserverAccessMode_Values returns all elements of the WebserverAccessMode enum
func WebserverAccessMode_Values() []string {
	return []string{
		WebserverAccessModePrivateOnly,
		WebserverAccessModePublicOnly,
	}
}
