// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package healthlake

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCreateFHIRDatastore = "CreateFHIRDatastore"

// CreateFHIRDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateFHIRDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFHIRDatastore for more information on using the CreateFHIRDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFHIRDatastoreRequest method.
//    req, resp := client.CreateFHIRDatastoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/CreateFHIRDatastore
func (c *HealthLake) CreateFHIRDatastoreRequest(input *CreateFHIRDatastoreInput) (req *request.Request, output *CreateFHIRDatastoreOutput) {
	op := &request.Operation{
		Name:       opCreateFHIRDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFHIRDatastoreInput{}
	}

	output = &CreateFHIRDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFHIRDatastore API operation for Amazon HealthLake.
//
// Creates a datastore that can ingest and export FHIR data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation CreateFHIRDatastore for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input parameter was invalid.
//
//   * ThrottlingException
//   The user has exceeded their maximum number of allowed calls to the given
//   API.
//
//   * InternalServerException
//   Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/CreateFHIRDatastore
func (c *HealthLake) CreateFHIRDatastore(input *CreateFHIRDatastoreInput) (*CreateFHIRDatastoreOutput, error) {
	req, out := c.CreateFHIRDatastoreRequest(input)
	return out, req.Send()
}

// CreateFHIRDatastoreWithContext is the same as CreateFHIRDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFHIRDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) CreateFHIRDatastoreWithContext(ctx aws.Context, input *CreateFHIRDatastoreInput, opts ...request.Option) (*CreateFHIRDatastoreOutput, error) {
	req, out := c.CreateFHIRDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFHIRDatastore = "DeleteFHIRDatastore"

// DeleteFHIRDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFHIRDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFHIRDatastore for more information on using the DeleteFHIRDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFHIRDatastoreRequest method.
//    req, resp := client.DeleteFHIRDatastoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DeleteFHIRDatastore
func (c *HealthLake) DeleteFHIRDatastoreRequest(input *DeleteFHIRDatastoreInput) (req *request.Request, output *DeleteFHIRDatastoreOutput) {
	op := &request.Operation{
		Name:       opDeleteFHIRDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFHIRDatastoreInput{}
	}

	output = &DeleteFHIRDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFHIRDatastore API operation for Amazon HealthLake.
//
// Deletes a datastore.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation DeleteFHIRDatastore for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   Access is denied. Your account is not authorized to perform this operation.
//
//   * ConflictException
//   The datastore is in a transition state and the user requested action can
//   not be performed.
//
//   * ValidationException
//   The user input parameter was invalid.
//
//   * ResourceNotFoundException
//   The requested datastore was not found.
//
//   * ThrottlingException
//   The user has exceeded their maximum number of allowed calls to the given
//   API.
//
//   * InternalServerException
//   Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DeleteFHIRDatastore
func (c *HealthLake) DeleteFHIRDatastore(input *DeleteFHIRDatastoreInput) (*DeleteFHIRDatastoreOutput, error) {
	req, out := c.DeleteFHIRDatastoreRequest(input)
	return out, req.Send()
}

// DeleteFHIRDatastoreWithContext is the same as DeleteFHIRDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFHIRDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) DeleteFHIRDatastoreWithContext(ctx aws.Context, input *DeleteFHIRDatastoreInput, opts ...request.Option) (*DeleteFHIRDatastoreOutput, error) {
	req, out := c.DeleteFHIRDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFHIRDatastore = "DescribeFHIRDatastore"

// DescribeFHIRDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFHIRDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFHIRDatastore for more information on using the DescribeFHIRDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFHIRDatastoreRequest method.
//    req, resp := client.DescribeFHIRDatastoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRDatastore
func (c *HealthLake) DescribeFHIRDatastoreRequest(input *DescribeFHIRDatastoreInput) (req *request.Request, output *DescribeFHIRDatastoreOutput) {
	op := &request.Operation{
		Name:       opDescribeFHIRDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFHIRDatastoreInput{}
	}

	output = &DescribeFHIRDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFHIRDatastore API operation for Amazon HealthLake.
//
// Gets the properties associated with the FHIR datastore, including the datastore
// ID, datastore ARN, datastore name, datastore status, created at, datastore
// type version, and datastore endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation DescribeFHIRDatastore for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input parameter was invalid.
//
//   * ResourceNotFoundException
//   The requested datastore was not found.
//
//   * ThrottlingException
//   The user has exceeded their maximum number of allowed calls to the given
//   API.
//
//   * InternalServerException
//   Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRDatastore
func (c *HealthLake) DescribeFHIRDatastore(input *DescribeFHIRDatastoreInput) (*DescribeFHIRDatastoreOutput, error) {
	req, out := c.DescribeFHIRDatastoreRequest(input)
	return out, req.Send()
}

// DescribeFHIRDatastoreWithContext is the same as DescribeFHIRDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFHIRDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) DescribeFHIRDatastoreWithContext(ctx aws.Context, input *DescribeFHIRDatastoreInput, opts ...request.Option) (*DescribeFHIRDatastoreOutput, error) {
	req, out := c.DescribeFHIRDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFHIRImportJob = "DescribeFHIRImportJob"

// DescribeFHIRImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFHIRImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFHIRImportJob for more information on using the DescribeFHIRImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFHIRImportJobRequest method.
//    req, resp := client.DescribeFHIRImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRImportJob
func (c *HealthLake) DescribeFHIRImportJobRequest(input *DescribeFHIRImportJobInput) (req *request.Request, output *DescribeFHIRImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeFHIRImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFHIRImportJobInput{}
	}

	output = &DescribeFHIRImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFHIRImportJob API operation for Amazon HealthLake.
//
// Displays the properties of a FHIR import job, including the ID, ARN, name,
// and the status of the datastore.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation DescribeFHIRImportJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input parameter was invalid.
//
//   * ResourceNotFoundException
//   The requested datastore was not found.
//
//   * ThrottlingException
//   The user has exceeded their maximum number of allowed calls to the given
//   API.
//
//   * InternalServerException
//   Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRImportJob
func (c *HealthLake) DescribeFHIRImportJob(input *DescribeFHIRImportJobInput) (*DescribeFHIRImportJobOutput, error) {
	req, out := c.DescribeFHIRImportJobRequest(input)
	return out, req.Send()
}

// DescribeFHIRImportJobWithContext is the same as DescribeFHIRImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFHIRImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) DescribeFHIRImportJobWithContext(ctx aws.Context, input *DescribeFHIRImportJobInput, opts ...request.Option) (*DescribeFHIRImportJobOutput, error) {
	req, out := c.DescribeFHIRImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFHIRDatastores = "ListFHIRDatastores"

// ListFHIRDatastoresRequest generates a "aws/request.Request" representing the
// client's request for the ListFHIRDatastores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFHIRDatastores for more information on using the ListFHIRDatastores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFHIRDatastoresRequest method.
//    req, resp := client.ListFHIRDatastoresRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores
func (c *HealthLake) ListFHIRDatastoresRequest(input *ListFHIRDatastoresInput) (req *request.Request, output *ListFHIRDatastoresOutput) {
	op := &request.Operation{
		Name:       opListFHIRDatastores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFHIRDatastoresInput{}
	}

	output = &ListFHIRDatastoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFHIRDatastores API operation for Amazon HealthLake.
//
// Lists all FHIR datastores that are in the user’s account, regardless of
// datastore status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation ListFHIRDatastores for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input parameter was invalid.
//
//   * ThrottlingException
//   The user has exceeded their maximum number of allowed calls to the given
//   API.
//
//   * InternalServerException
//   Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores
func (c *HealthLake) ListFHIRDatastores(input *ListFHIRDatastoresInput) (*ListFHIRDatastoresOutput, error) {
	req, out := c.ListFHIRDatastoresRequest(input)
	return out, req.Send()
}

// ListFHIRDatastoresWithContext is the same as ListFHIRDatastores with the addition of
// the ability to pass a context and additional request options.
//
// See ListFHIRDatastores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListFHIRDatastoresWithContext(ctx aws.Context, input *ListFHIRDatastoresInput, opts ...request.Option) (*ListFHIRDatastoresOutput, error) {
	req, out := c.ListFHIRDatastoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFHIRDatastoresPages iterates over the pages of a ListFHIRDatastores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFHIRDatastores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFHIRDatastores operation.
//    pageNum := 0
//    err := client.ListFHIRDatastoresPages(params,
//        func(page *healthlake.ListFHIRDatastoresOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *HealthLake) ListFHIRDatastoresPages(input *ListFHIRDatastoresInput, fn func(*ListFHIRDatastoresOutput, bool) bool) error {
	return c.ListFHIRDatastoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFHIRDatastoresPagesWithContext same as ListFHIRDatastoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListFHIRDatastoresPagesWithContext(ctx aws.Context, input *ListFHIRDatastoresInput, fn func(*ListFHIRDatastoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFHIRDatastoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFHIRDatastoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFHIRDatastoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartFHIRImportJob = "StartFHIRImportJob"

// StartFHIRImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartFHIRImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFHIRImportJob for more information on using the StartFHIRImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFHIRImportJobRequest method.
//    req, resp := client.StartFHIRImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRImportJob
func (c *HealthLake) StartFHIRImportJobRequest(input *StartFHIRImportJobInput) (req *request.Request, output *StartFHIRImportJobOutput) {
	op := &request.Operation{
		Name:       opStartFHIRImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFHIRImportJobInput{}
	}

	output = &StartFHIRImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFHIRImportJob API operation for Amazon HealthLake.
//
// Begins a FHIR Import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation StartFHIRImportJob for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The user input parameter was invalid.
//
//   * ThrottlingException
//   The user has exceeded their maximum number of allowed calls to the given
//   API.
//
//   * AccessDeniedException
//   Access is denied. Your account is not authorized to perform this operation.
//
//   * ResourceNotFoundException
//   The requested datastore was not found.
//
//   * InternalServerException
//   Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRImportJob
func (c *HealthLake) StartFHIRImportJob(input *StartFHIRImportJobInput) (*StartFHIRImportJobOutput, error) {
	req, out := c.StartFHIRImportJobRequest(input)
	return out, req.Send()
}

// StartFHIRImportJobWithContext is the same as StartFHIRImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartFHIRImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) StartFHIRImportJobWithContext(ctx aws.Context, input *StartFHIRImportJobInput, opts ...request.Option) (*StartFHIRImportJobOutput, error) {
	req, out := c.StartFHIRImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access is denied. Your account is not authorized to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The datastore is in a transition state and the user requested action can
// not be performed.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateFHIRDatastoreInput struct {
	_ struct{} `type:"structure"`

	// Optional user provided token used for ensuring idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The user generated name for the datastore.
	DatastoreName *string `min:"1" type:"string"`

	// The FHIR version of the datastore. The only supported version is R4.
	//
	// DatastoreTypeVersion is a required field
	DatastoreTypeVersion *string `type:"string" required:"true" enum:"FHIRVersion"`

	// Optional parameter to preload data upon creation of the datastore. Currently,
	// the only supported preloaded data is synthetic data generated from Synthea.
	PreloadDataConfig *PreloadDataConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFHIRDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFHIRDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFHIRDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFHIRDatastoreInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}
	if s.DatastoreTypeVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreTypeVersion"))
	}
	if s.PreloadDataConfig != nil {
		if err := s.PreloadDataConfig.Validate(); err != nil {
			invalidParams.AddNested("PreloadDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFHIRDatastoreInput) SetClientToken(v string) *CreateFHIRDatastoreInput {
	s.ClientToken = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *CreateFHIRDatastoreInput) SetDatastoreName(v string) *CreateFHIRDatastoreInput {
	s.DatastoreName = &v
	return s
}

// SetDatastoreTypeVersion sets the DatastoreTypeVersion field's value.
func (s *CreateFHIRDatastoreInput) SetDatastoreTypeVersion(v string) *CreateFHIRDatastoreInput {
	s.DatastoreTypeVersion = &v
	return s
}

// SetPreloadDataConfig sets the PreloadDataConfig field's value.
func (s *CreateFHIRDatastoreInput) SetPreloadDataConfig(v *PreloadDataConfig) *CreateFHIRDatastoreInput {
	s.PreloadDataConfig = v
	return s
}

type CreateFHIRDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The datastore ARN is generated during the creation of the datastore and can
	// be found in the output from the initial datastore creation call.
	//
	// DatastoreArn is a required field
	DatastoreArn *string `type:"string" required:"true"`

	// The AWS endpoint for the created datastore. For preview, only US-east-1 endpoints
	// are supported.
	//
	// DatastoreEndpoint is a required field
	DatastoreEndpoint *string `min:"1" type:"string" required:"true"`

	// The AWS-generated datastore id. This id is in the output from the initial
	// datastore creation call.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The status of the FHIR datastore. Possible statuses are ‘CREATING’, ‘ACTIVE’,
	// ‘DELETING’, ‘DELETED’.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `type:"string" required:"true" enum:"DatastoreStatus"`
}

// String returns the string representation
func (s CreateFHIRDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFHIRDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *CreateFHIRDatastoreOutput) SetDatastoreArn(v string) *CreateFHIRDatastoreOutput {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreEndpoint sets the DatastoreEndpoint field's value.
func (s *CreateFHIRDatastoreOutput) SetDatastoreEndpoint(v string) *CreateFHIRDatastoreOutput {
	s.DatastoreEndpoint = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *CreateFHIRDatastoreOutput) SetDatastoreId(v string) *CreateFHIRDatastoreOutput {
	s.DatastoreId = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *CreateFHIRDatastoreOutput) SetDatastoreStatus(v string) *CreateFHIRDatastoreOutput {
	s.DatastoreStatus = &v
	return s
}

// The filters applied to datastore query.
type DatastoreFilter struct {
	_ struct{} `type:"structure"`

	// A filter that allows the user to set cutoff dates for records. All datastores
	// created after the specified date will be included in the results.
	CreatedAfter *time.Time `type:"timestamp"`

	// A filter that allows the user to set cutoff dates for records. All datastores
	// created before the specified date will be included in the results.
	CreatedBefore *time.Time `type:"timestamp"`

	// Allows the user to filter datastore results by name.
	DatastoreName *string `min:"1" type:"string"`

	// Allows the user to filter datastore results by status.
	DatastoreStatus *string `type:"string" enum:"DatastoreStatus"`
}

// String returns the string representation
func (s DatastoreFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatastoreFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatastoreFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatastoreFilter"}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *DatastoreFilter) SetCreatedAfter(v time.Time) *DatastoreFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *DatastoreFilter) SetCreatedBefore(v time.Time) *DatastoreFilter {
	s.CreatedBefore = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DatastoreFilter) SetDatastoreName(v string) *DatastoreFilter {
	s.DatastoreName = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DatastoreFilter) SetDatastoreStatus(v string) *DatastoreFilter {
	s.DatastoreStatus = &v
	return s
}

// Displays the properties of the datastore, including the ID, Arn, name, and
// the status of the datastore.
type DatastoreProperties struct {
	_ struct{} `type:"structure"`

	// The time that a datastore was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name used in the creation of the datastore.
	//
	// DatastoreArn is a required field
	DatastoreArn *string `type:"string" required:"true"`

	// The AWS endpoint for the datastore. Each datastore will have it's own endpoint
	// with datastore ID in the endpoint URL.
	//
	// DatastoreEndpoint is a required field
	DatastoreEndpoint *string `type:"string" required:"true"`

	// The AWS-generated ID number for the datastore.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The user-generated name for the datastore.
	DatastoreName *string `min:"1" type:"string"`

	// The status of the datastore. Possible statuses are 'CREATING', 'ACTIVE',
	// 'DELETING', or 'DELETED'.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `type:"string" required:"true" enum:"DatastoreStatus"`

	// The FHIR version. Only R4 version data is supported.
	//
	// DatastoreTypeVersion is a required field
	DatastoreTypeVersion *string `type:"string" required:"true" enum:"FHIRVersion"`

	// The preloaded data configuration for the datastore. Only data preloaded from
	// Synthea is supported.
	PreloadDataConfig *PreloadDataConfig `type:"structure"`
}

// String returns the string representation
func (s DatastoreProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatastoreProperties) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DatastoreProperties) SetCreatedAt(v time.Time) *DatastoreProperties {
	s.CreatedAt = &v
	return s
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *DatastoreProperties) SetDatastoreArn(v string) *DatastoreProperties {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreEndpoint sets the DatastoreEndpoint field's value.
func (s *DatastoreProperties) SetDatastoreEndpoint(v string) *DatastoreProperties {
	s.DatastoreEndpoint = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DatastoreProperties) SetDatastoreId(v string) *DatastoreProperties {
	s.DatastoreId = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DatastoreProperties) SetDatastoreName(v string) *DatastoreProperties {
	s.DatastoreName = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DatastoreProperties) SetDatastoreStatus(v string) *DatastoreProperties {
	s.DatastoreStatus = &v
	return s
}

// SetDatastoreTypeVersion sets the DatastoreTypeVersion field's value.
func (s *DatastoreProperties) SetDatastoreTypeVersion(v string) *DatastoreProperties {
	s.DatastoreTypeVersion = &v
	return s
}

// SetPreloadDataConfig sets the PreloadDataConfig field's value.
func (s *DatastoreProperties) SetPreloadDataConfig(v *PreloadDataConfig) *DatastoreProperties {
	s.PreloadDataConfig = v
	return s
}

type DeleteFHIRDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The AWS-generated ID for the datastore to be deleted.
	DatastoreId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteFHIRDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFHIRDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFHIRDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFHIRDatastoreInput"}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DeleteFHIRDatastoreInput) SetDatastoreId(v string) *DeleteFHIRDatastoreInput {
	s.DatastoreId = &v
	return s
}

type DeleteFHIRDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
	//
	// DatastoreArn is a required field
	DatastoreArn *string `type:"string" required:"true"`

	// The AWS endpoint for the datastore the user has requested to be deleted.
	//
	// DatastoreEndpoint is a required field
	DatastoreEndpoint *string `min:"1" type:"string" required:"true"`

	// The AWS-generated ID for the datastore to be deleted.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The status of the datastore that the user has requested to be deleted.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `type:"string" required:"true" enum:"DatastoreStatus"`
}

// String returns the string representation
func (s DeleteFHIRDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFHIRDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *DeleteFHIRDatastoreOutput) SetDatastoreArn(v string) *DeleteFHIRDatastoreOutput {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreEndpoint sets the DatastoreEndpoint field's value.
func (s *DeleteFHIRDatastoreOutput) SetDatastoreEndpoint(v string) *DeleteFHIRDatastoreOutput {
	s.DatastoreEndpoint = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DeleteFHIRDatastoreOutput) SetDatastoreId(v string) *DeleteFHIRDatastoreOutput {
	s.DatastoreId = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DeleteFHIRDatastoreOutput) SetDatastoreStatus(v string) *DeleteFHIRDatastoreOutput {
	s.DatastoreStatus = &v
	return s
}

type DescribeFHIRDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The AWS-generated datastore id. This is part of the ‘CreateFHIRDatastore’
	// output.
	DatastoreId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFHIRDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFHIRDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFHIRDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFHIRDatastoreInput"}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DescribeFHIRDatastoreInput) SetDatastoreId(v string) *DescribeFHIRDatastoreInput {
	s.DatastoreId = &v
	return s
}

type DescribeFHIRDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// All properties associated with a datastore, including the datastore ID, datastore
	// ARN, datastore name, datastore status, created at, datastore type version,
	// and datastore endpoint.
	//
	// DatastoreProperties is a required field
	DatastoreProperties *DatastoreProperties `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeFHIRDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFHIRDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreProperties sets the DatastoreProperties field's value.
func (s *DescribeFHIRDatastoreOutput) SetDatastoreProperties(v *DatastoreProperties) *DescribeFHIRDatastoreOutput {
	s.DatastoreProperties = v
	return s
}

type DescribeFHIRImportJobInput struct {
	_ struct{} `type:"structure"`

	// The AWS-generated ID of the datastore.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The AWS-generated job ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFHIRImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFHIRImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFHIRImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFHIRImportJobInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DescribeFHIRImportJobInput) SetDatastoreId(v string) *DescribeFHIRImportJobInput {
	s.DatastoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeFHIRImportJobInput) SetJobId(v string) *DescribeFHIRImportJobInput {
	s.JobId = &v
	return s
}

type DescribeFHIRImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the Import job request, including the ID, ARN, name, and
	// the status of the datastore.
	//
	// ImportJobProperties is a required field
	ImportJobProperties *ImportJobProperties `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeFHIRImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFHIRImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobProperties sets the ImportJobProperties field's value.
func (s *DescribeFHIRImportJobOutput) SetImportJobProperties(v *ImportJobProperties) *DescribeFHIRImportJobOutput {
	s.ImportJobProperties = v
	return s
}

// Displays the properties of the import job, including the ID, Arn, Name, and
// the status of the datastore.
type ImportJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon HealthLake access to your
	// input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The datastore id used when the Import job was created.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The time that the Import job was completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that was supplied when the Import job was created.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The AWS-generated id number for the Import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user-generated name for an Import job.
	JobName *string `min:"1" type:"string"`

	// The job status for an Import job. Possible statuses are SUBMITTED, IN_PROGRESS,
	// COMPLETED, FAILED.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`

	// An explanation of any errors that may have occurred during the FHIR import
	// job.
	Message *string `min:"1" type:"string"`

	// The time that the Import job was submitted for processing.
	//
	// SubmitTime is a required field
	SubmitTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ImportJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *ImportJobProperties) SetDataAccessRoleArn(v string) *ImportJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *ImportJobProperties) SetDatastoreId(v string) *ImportJobProperties {
	s.DatastoreId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ImportJobProperties) SetEndTime(v time.Time) *ImportJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *ImportJobProperties) SetInputDataConfig(v *InputDataConfig) *ImportJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ImportJobProperties) SetJobId(v string) *ImportJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ImportJobProperties) SetJobName(v string) *ImportJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ImportJobProperties) SetJobStatus(v string) *ImportJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ImportJobProperties) SetMessage(v string) *ImportJobProperties {
	s.Message = &v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *ImportJobProperties) SetSubmitTime(v time.Time) *ImportJobProperties {
	s.SubmitTime = &v
	return s
}

// The input properties for an import job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3Uri is the user specified S3 location of the FHIR data to be imported
	// into Amazon HealthLake.
	S3Uri *string `type:"string"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDataConfig) GoString() string {
	return s.String()
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// Unknown error occurs in the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListFHIRDatastoresInput struct {
	_ struct{} `type:"structure"`

	// Lists all filters associated with a FHIR datastore request.
	Filter *DatastoreFilter `type:"structure"`

	// The maximum number of datastores returned in a single page of a ListFHIRDatastoresRequest
	// call.
	MaxResults *int64 `min:"1" type:"integer"`

	// Fetches the next page of datastores when results are paginated.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFHIRDatastoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFHIRDatastoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFHIRDatastoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFHIRDatastoresInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListFHIRDatastoresInput) SetFilter(v *DatastoreFilter) *ListFHIRDatastoresInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFHIRDatastoresInput) SetMaxResults(v int64) *ListFHIRDatastoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFHIRDatastoresInput) SetNextToken(v string) *ListFHIRDatastoresInput {
	s.NextToken = &v
	return s
}

type ListFHIRDatastoresOutput struct {
	_ struct{} `type:"structure"`

	// All properties associated with the listed datastores.
	//
	// DatastorePropertiesList is a required field
	DatastorePropertiesList []*DatastoreProperties `type:"list" required:"true"`

	// Pagination token that can be used to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFHIRDatastoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFHIRDatastoresOutput) GoString() string {
	return s.String()
}

// SetDatastorePropertiesList sets the DatastorePropertiesList field's value.
func (s *ListFHIRDatastoresOutput) SetDatastorePropertiesList(v []*DatastoreProperties) *ListFHIRDatastoresOutput {
	s.DatastorePropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFHIRDatastoresOutput) SetNextToken(v string) *ListFHIRDatastoresOutput {
	s.NextToken = &v
	return s
}

// The input properties for the preloaded datastore. Only data preloaded from
// Synthea is supported.
type PreloadDataConfig struct {
	_ struct{} `type:"structure"`

	// The type of preloaded data. Only Synthea preloaded data is supported.
	//
	// PreloadDataType is a required field
	PreloadDataType *string `type:"string" required:"true" enum:"PreloadDataType"`
}

// String returns the string representation
func (s PreloadDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreloadDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PreloadDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PreloadDataConfig"}
	if s.PreloadDataType == nil {
		invalidParams.Add(request.NewErrParamRequired("PreloadDataType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPreloadDataType sets the PreloadDataType field's value.
func (s *PreloadDataConfig) SetPreloadDataType(v string) *PreloadDataConfig {
	s.PreloadDataType = &v
	return s
}

// The requested datastore was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartFHIRImportJobInput struct {
	_ struct{} `type:"structure"`

	// Optional user provided token used for ensuring idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The AWS-generated datastore ID.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The input properties of the FHIR Import job in the StartFHIRImport job request.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The name of the FHIR Import job in the StartFHIRImport job request.
	JobName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartFHIRImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFHIRImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFHIRImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFHIRImportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartFHIRImportJobInput) SetClientToken(v string) *StartFHIRImportJobInput {
	s.ClientToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartFHIRImportJobInput) SetDataAccessRoleArn(v string) *StartFHIRImportJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *StartFHIRImportJobInput) SetDatastoreId(v string) *StartFHIRImportJobInput {
	s.DatastoreId = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartFHIRImportJobInput) SetInputDataConfig(v *InputDataConfig) *StartFHIRImportJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartFHIRImportJobInput) SetJobName(v string) *StartFHIRImportJobInput {
	s.JobName = &v
	return s
}

type StartFHIRImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The AWS-generated datastore ID.
	DatastoreId *string `min:"1" type:"string"`

	// The AWS-generated job ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The status of an import job.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation
func (s StartFHIRImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFHIRImportJobOutput) GoString() string {
	return s.String()
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *StartFHIRImportJobOutput) SetDatastoreId(v string) *StartFHIRImportJobOutput {
	s.DatastoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartFHIRImportJobOutput) SetJobId(v string) *StartFHIRImportJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartFHIRImportJobOutput) SetJobStatus(v string) *StartFHIRImportJobOutput {
	s.JobStatus = &v
	return s
}

// The user has exceeded their maximum number of allowed calls to the given
// API.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The user input parameter was invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DatastoreStatusCreating is a DatastoreStatus enum value
	DatastoreStatusCreating = "CREATING"

	// DatastoreStatusActive is a DatastoreStatus enum value
	DatastoreStatusActive = "ACTIVE"

	// DatastoreStatusDeleting is a DatastoreStatus enum value
	DatastoreStatusDeleting = "DELETING"

	// DatastoreStatusDeleted is a DatastoreStatus enum value
	DatastoreStatusDeleted = "DELETED"
)

// DatastoreStatus_Values returns all elements of the DatastoreStatus enum
func DatastoreStatus_Values() []string {
	return []string{
		DatastoreStatusCreating,
		DatastoreStatusActive,
		DatastoreStatusDeleting,
		DatastoreStatusDeleted,
	}
}

const (
	// FHIRVersionR4 is a FHIRVersion enum value
	FHIRVersionR4 = "R4"
)

// FHIRVersion_Values returns all elements of the FHIRVersion enum
func FHIRVersion_Values() []string {
	return []string{
		FHIRVersionR4,
	}
}

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusSubmitted,
		JobStatusInProgress,
		JobStatusCompleted,
		JobStatusFailed,
	}
}

const (
	// PreloadDataTypeSynthea is a PreloadDataType enum value
	PreloadDataTypeSynthea = "SYNTHEA"
)

// PreloadDataType_Values returns all elements of the PreloadDataType enum
func PreloadDataType_Values() []string {
	return []string{
		PreloadDataTypeSynthea,
	}
}
