// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateRoleToGroup = "AssociateRoleToGroup"

// AssociateRoleToGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociateRoleToGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateRoleToGroup for more information on using the AssociateRoleToGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateRoleToGroupRequest method.
//    req, resp := client.AssociateRoleToGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup
func (c *Greengrass) AssociateRoleToGroupRequest(input *AssociateRoleToGroupInput) (req *request.Request, output *AssociateRoleToGroupOutput) {
	op := &request.Operation{
		Name:       opAssociateRoleToGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/groups/{GroupId}/role",
	}

	if input == nil {
		input = &AssociateRoleToGroupInput{}
	}

	output = &AssociateRoleToGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateRoleToGroup API operation for AWS Greengrass.
//
// Associates a role with a group. Your Greengrass core will use the role to
// access AWS cloud services. The role's permissions should allow Greengrass
// core Lambda functions to perform actions against the cloud.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation AssociateRoleToGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup
func (c *Greengrass) AssociateRoleToGroup(input *AssociateRoleToGroupInput) (*AssociateRoleToGroupOutput, error) {
	req, out := c.AssociateRoleToGroupRequest(input)
	return out, req.Send()
}

// AssociateRoleToGroupWithContext is the same as AssociateRoleToGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRoleToGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) AssociateRoleToGroupWithContext(ctx aws.Context, input *AssociateRoleToGroupInput, opts ...request.Option) (*AssociateRoleToGroupOutput, error) {
	req, out := c.AssociateRoleToGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateServiceRoleToAccount = "AssociateServiceRoleToAccount"

// AssociateServiceRoleToAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateServiceRoleToAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateServiceRoleToAccount for more information on using the AssociateServiceRoleToAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateServiceRoleToAccountRequest method.
//    req, resp := client.AssociateServiceRoleToAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount
func (c *Greengrass) AssociateServiceRoleToAccountRequest(input *AssociateServiceRoleToAccountInput) (req *request.Request, output *AssociateServiceRoleToAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateServiceRoleToAccount,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &AssociateServiceRoleToAccountInput{}
	}

	output = &AssociateServiceRoleToAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateServiceRoleToAccount API operation for AWS Greengrass.
//
// Associates a role with your account. AWS IoT Greengrass will use the role
// to access your Lambda functions and AWS IoT resources. This is necessary
// for deployments to succeed. The role must have at least minimum permissions
// in the policy ''AWSGreengrassResourceAccessRolePolicy''.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation AssociateServiceRoleToAccount for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount
func (c *Greengrass) AssociateServiceRoleToAccount(input *AssociateServiceRoleToAccountInput) (*AssociateServiceRoleToAccountOutput, error) {
	req, out := c.AssociateServiceRoleToAccountRequest(input)
	return out, req.Send()
}

// AssociateServiceRoleToAccountWithContext is the same as AssociateServiceRoleToAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateServiceRoleToAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) AssociateServiceRoleToAccountWithContext(ctx aws.Context, input *AssociateServiceRoleToAccountInput, opts ...request.Option) (*AssociateServiceRoleToAccountOutput, error) {
	req, out := c.AssociateServiceRoleToAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnectorDefinition = "CreateConnectorDefinition"

// CreateConnectorDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnectorDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnectorDefinition for more information on using the CreateConnectorDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectorDefinitionRequest method.
//    req, resp := client.CreateConnectorDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition
func (c *Greengrass) CreateConnectorDefinitionRequest(input *CreateConnectorDefinitionInput) (req *request.Request, output *CreateConnectorDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateConnectorDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/connectors",
	}

	if input == nil {
		input = &CreateConnectorDefinitionInput{}
	}

	output = &CreateConnectorDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnectorDefinition API operation for AWS Greengrass.
//
// Creates a connector definition. You may provide the initial version of the
// connector definition now or use ''CreateConnectorDefinitionVersion'' at a
// later time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateConnectorDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition
func (c *Greengrass) CreateConnectorDefinition(input *CreateConnectorDefinitionInput) (*CreateConnectorDefinitionOutput, error) {
	req, out := c.CreateConnectorDefinitionRequest(input)
	return out, req.Send()
}

// CreateConnectorDefinitionWithContext is the same as CreateConnectorDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnectorDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateConnectorDefinitionWithContext(ctx aws.Context, input *CreateConnectorDefinitionInput, opts ...request.Option) (*CreateConnectorDefinitionOutput, error) {
	req, out := c.CreateConnectorDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnectorDefinitionVersion = "CreateConnectorDefinitionVersion"

// CreateConnectorDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnectorDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnectorDefinitionVersion for more information on using the CreateConnectorDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectorDefinitionVersionRequest method.
//    req, resp := client.CreateConnectorDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion
func (c *Greengrass) CreateConnectorDefinitionVersionRequest(input *CreateConnectorDefinitionVersionInput) (req *request.Request, output *CreateConnectorDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateConnectorDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateConnectorDefinitionVersionInput{}
	}

	output = &CreateConnectorDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnectorDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a connector definition which has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateConnectorDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion
func (c *Greengrass) CreateConnectorDefinitionVersion(input *CreateConnectorDefinitionVersionInput) (*CreateConnectorDefinitionVersionOutput, error) {
	req, out := c.CreateConnectorDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateConnectorDefinitionVersionWithContext is the same as CreateConnectorDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnectorDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateConnectorDefinitionVersionWithContext(ctx aws.Context, input *CreateConnectorDefinitionVersionInput, opts ...request.Option) (*CreateConnectorDefinitionVersionOutput, error) {
	req, out := c.CreateConnectorDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCoreDefinition = "CreateCoreDefinition"

// CreateCoreDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCoreDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCoreDefinition for more information on using the CreateCoreDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCoreDefinitionRequest method.
//    req, resp := client.CreateCoreDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition
func (c *Greengrass) CreateCoreDefinitionRequest(input *CreateCoreDefinitionInput) (req *request.Request, output *CreateCoreDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateCoreDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/cores",
	}

	if input == nil {
		input = &CreateCoreDefinitionInput{}
	}

	output = &CreateCoreDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCoreDefinition API operation for AWS Greengrass.
//
// Creates a core definition. You may provide the initial version of the core
// definition now or use ''CreateCoreDefinitionVersion'' at a later time. Greengrass
// groups must each contain exactly one Greengrass core.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateCoreDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition
func (c *Greengrass) CreateCoreDefinition(input *CreateCoreDefinitionInput) (*CreateCoreDefinitionOutput, error) {
	req, out := c.CreateCoreDefinitionRequest(input)
	return out, req.Send()
}

// CreateCoreDefinitionWithContext is the same as CreateCoreDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCoreDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateCoreDefinitionWithContext(ctx aws.Context, input *CreateCoreDefinitionInput, opts ...request.Option) (*CreateCoreDefinitionOutput, error) {
	req, out := c.CreateCoreDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCoreDefinitionVersion = "CreateCoreDefinitionVersion"

// CreateCoreDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCoreDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCoreDefinitionVersion for more information on using the CreateCoreDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCoreDefinitionVersionRequest method.
//    req, resp := client.CreateCoreDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion
func (c *Greengrass) CreateCoreDefinitionVersionRequest(input *CreateCoreDefinitionVersionInput) (req *request.Request, output *CreateCoreDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateCoreDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateCoreDefinitionVersionInput{}
	}

	output = &CreateCoreDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCoreDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a core definition that has already been defined. Greengrass
// groups must each contain exactly one Greengrass core.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateCoreDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion
func (c *Greengrass) CreateCoreDefinitionVersion(input *CreateCoreDefinitionVersionInput) (*CreateCoreDefinitionVersionOutput, error) {
	req, out := c.CreateCoreDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateCoreDefinitionVersionWithContext is the same as CreateCoreDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCoreDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateCoreDefinitionVersionWithContext(ctx aws.Context, input *CreateCoreDefinitionVersionInput, opts ...request.Option) (*CreateCoreDefinitionVersionOutput, error) {
	req, out := c.CreateCoreDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment
func (c *Greengrass) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups/{GroupId}/deployments",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for AWS Greengrass.
//
// Creates a deployment. ''CreateDeployment'' requests are idempotent with respect
// to the ''X-Amzn-Client-Token'' token and the request parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment
func (c *Greengrass) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeviceDefinition = "CreateDeviceDefinition"

// CreateDeviceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeviceDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeviceDefinition for more information on using the CreateDeviceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeviceDefinitionRequest method.
//    req, resp := client.CreateDeviceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition
func (c *Greengrass) CreateDeviceDefinitionRequest(input *CreateDeviceDefinitionInput) (req *request.Request, output *CreateDeviceDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateDeviceDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/devices",
	}

	if input == nil {
		input = &CreateDeviceDefinitionInput{}
	}

	output = &CreateDeviceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeviceDefinition API operation for AWS Greengrass.
//
// Creates a device definition. You may provide the initial version of the device
// definition now or use ''CreateDeviceDefinitionVersion'' at a later time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateDeviceDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition
func (c *Greengrass) CreateDeviceDefinition(input *CreateDeviceDefinitionInput) (*CreateDeviceDefinitionOutput, error) {
	req, out := c.CreateDeviceDefinitionRequest(input)
	return out, req.Send()
}

// CreateDeviceDefinitionWithContext is the same as CreateDeviceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeviceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateDeviceDefinitionWithContext(ctx aws.Context, input *CreateDeviceDefinitionInput, opts ...request.Option) (*CreateDeviceDefinitionOutput, error) {
	req, out := c.CreateDeviceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeviceDefinitionVersion = "CreateDeviceDefinitionVersion"

// CreateDeviceDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeviceDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeviceDefinitionVersion for more information on using the CreateDeviceDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeviceDefinitionVersionRequest method.
//    req, resp := client.CreateDeviceDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion
func (c *Greengrass) CreateDeviceDefinitionVersionRequest(input *CreateDeviceDefinitionVersionInput) (req *request.Request, output *CreateDeviceDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateDeviceDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateDeviceDefinitionVersionInput{}
	}

	output = &CreateDeviceDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeviceDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a device definition that has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateDeviceDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion
func (c *Greengrass) CreateDeviceDefinitionVersion(input *CreateDeviceDefinitionVersionInput) (*CreateDeviceDefinitionVersionOutput, error) {
	req, out := c.CreateDeviceDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateDeviceDefinitionVersionWithContext is the same as CreateDeviceDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeviceDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateDeviceDefinitionVersionWithContext(ctx aws.Context, input *CreateDeviceDefinitionVersionInput, opts ...request.Option) (*CreateDeviceDefinitionVersionOutput, error) {
	req, out := c.CreateDeviceDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFunctionDefinition = "CreateFunctionDefinition"

// CreateFunctionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFunctionDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFunctionDefinition for more information on using the CreateFunctionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFunctionDefinitionRequest method.
//    req, resp := client.CreateFunctionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition
func (c *Greengrass) CreateFunctionDefinitionRequest(input *CreateFunctionDefinitionInput) (req *request.Request, output *CreateFunctionDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateFunctionDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/functions",
	}

	if input == nil {
		input = &CreateFunctionDefinitionInput{}
	}

	output = &CreateFunctionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFunctionDefinition API operation for AWS Greengrass.
//
// Creates a Lambda function definition which contains a list of Lambda functions
// and their configurations to be used in a group. You can create an initial
// version of the definition by providing a list of Lambda functions and their
// configurations now, or use ''CreateFunctionDefinitionVersion'' later.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateFunctionDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition
func (c *Greengrass) CreateFunctionDefinition(input *CreateFunctionDefinitionInput) (*CreateFunctionDefinitionOutput, error) {
	req, out := c.CreateFunctionDefinitionRequest(input)
	return out, req.Send()
}

// CreateFunctionDefinitionWithContext is the same as CreateFunctionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunctionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateFunctionDefinitionWithContext(ctx aws.Context, input *CreateFunctionDefinitionInput, opts ...request.Option) (*CreateFunctionDefinitionOutput, error) {
	req, out := c.CreateFunctionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFunctionDefinitionVersion = "CreateFunctionDefinitionVersion"

// CreateFunctionDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFunctionDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFunctionDefinitionVersion for more information on using the CreateFunctionDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFunctionDefinitionVersionRequest method.
//    req, resp := client.CreateFunctionDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion
func (c *Greengrass) CreateFunctionDefinitionVersionRequest(input *CreateFunctionDefinitionVersionInput) (req *request.Request, output *CreateFunctionDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateFunctionDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateFunctionDefinitionVersionInput{}
	}

	output = &CreateFunctionDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFunctionDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a Lambda function definition that has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateFunctionDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion
func (c *Greengrass) CreateFunctionDefinitionVersion(input *CreateFunctionDefinitionVersionInput) (*CreateFunctionDefinitionVersionOutput, error) {
	req, out := c.CreateFunctionDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateFunctionDefinitionVersionWithContext is the same as CreateFunctionDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunctionDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateFunctionDefinitionVersionWithContext(ctx aws.Context, input *CreateFunctionDefinitionVersionInput, opts ...request.Option) (*CreateFunctionDefinitionVersionOutput, error) {
	req, out := c.CreateFunctionDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup
func (c *Greengrass) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for AWS Greengrass.
//
// Creates a group. You may provide the initial version of the group or use
// ''CreateGroupVersion'' at a later time. Tip: You can use the ''gg_group_setup''
// package (https://github.com/awslabs/aws-greengrass-group-setup) as a library
// or command-line application to create and deploy Greengrass groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup
func (c *Greengrass) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupCertificateAuthority = "CreateGroupCertificateAuthority"

// CreateGroupCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupCertificateAuthority for more information on using the CreateGroupCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupCertificateAuthorityRequest method.
//    req, resp := client.CreateGroupCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority
func (c *Greengrass) CreateGroupCertificateAuthorityRequest(input *CreateGroupCertificateAuthorityInput) (req *request.Request, output *CreateGroupCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opCreateGroupCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities",
	}

	if input == nil {
		input = &CreateGroupCertificateAuthorityInput{}
	}

	output = &CreateGroupCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupCertificateAuthority API operation for AWS Greengrass.
//
// Creates a CA for the group. If a CA already exists, it will rotate the existing
// CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateGroupCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority
func (c *Greengrass) CreateGroupCertificateAuthority(input *CreateGroupCertificateAuthorityInput) (*CreateGroupCertificateAuthorityOutput, error) {
	req, out := c.CreateGroupCertificateAuthorityRequest(input)
	return out, req.Send()
}

// CreateGroupCertificateAuthorityWithContext is the same as CreateGroupCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateGroupCertificateAuthorityWithContext(ctx aws.Context, input *CreateGroupCertificateAuthorityInput, opts ...request.Option) (*CreateGroupCertificateAuthorityOutput, error) {
	req, out := c.CreateGroupCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupVersion = "CreateGroupVersion"

// CreateGroupVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupVersion for more information on using the CreateGroupVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupVersionRequest method.
//    req, resp := client.CreateGroupVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion
func (c *Greengrass) CreateGroupVersionRequest(input *CreateGroupVersionInput) (req *request.Request, output *CreateGroupVersionOutput) {
	op := &request.Operation{
		Name:       opCreateGroupVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups/{GroupId}/versions",
	}

	if input == nil {
		input = &CreateGroupVersionInput{}
	}

	output = &CreateGroupVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupVersion API operation for AWS Greengrass.
//
// Creates a version of a group which has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateGroupVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion
func (c *Greengrass) CreateGroupVersion(input *CreateGroupVersionInput) (*CreateGroupVersionOutput, error) {
	req, out := c.CreateGroupVersionRequest(input)
	return out, req.Send()
}

// CreateGroupVersionWithContext is the same as CreateGroupVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateGroupVersionWithContext(ctx aws.Context, input *CreateGroupVersionInput, opts ...request.Option) (*CreateGroupVersionOutput, error) {
	req, out := c.CreateGroupVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoggerDefinition = "CreateLoggerDefinition"

// CreateLoggerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoggerDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoggerDefinition for more information on using the CreateLoggerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLoggerDefinitionRequest method.
//    req, resp := client.CreateLoggerDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition
func (c *Greengrass) CreateLoggerDefinitionRequest(input *CreateLoggerDefinitionInput) (req *request.Request, output *CreateLoggerDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateLoggerDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/loggers",
	}

	if input == nil {
		input = &CreateLoggerDefinitionInput{}
	}

	output = &CreateLoggerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoggerDefinition API operation for AWS Greengrass.
//
// Creates a logger definition. You may provide the initial version of the logger
// definition now or use ''CreateLoggerDefinitionVersion'' at a later time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateLoggerDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition
func (c *Greengrass) CreateLoggerDefinition(input *CreateLoggerDefinitionInput) (*CreateLoggerDefinitionOutput, error) {
	req, out := c.CreateLoggerDefinitionRequest(input)
	return out, req.Send()
}

// CreateLoggerDefinitionWithContext is the same as CreateLoggerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoggerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateLoggerDefinitionWithContext(ctx aws.Context, input *CreateLoggerDefinitionInput, opts ...request.Option) (*CreateLoggerDefinitionOutput, error) {
	req, out := c.CreateLoggerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoggerDefinitionVersion = "CreateLoggerDefinitionVersion"

// CreateLoggerDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoggerDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoggerDefinitionVersion for more information on using the CreateLoggerDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLoggerDefinitionVersionRequest method.
//    req, resp := client.CreateLoggerDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion
func (c *Greengrass) CreateLoggerDefinitionVersionRequest(input *CreateLoggerDefinitionVersionInput) (req *request.Request, output *CreateLoggerDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateLoggerDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateLoggerDefinitionVersionInput{}
	}

	output = &CreateLoggerDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoggerDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a logger definition that has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateLoggerDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion
func (c *Greengrass) CreateLoggerDefinitionVersion(input *CreateLoggerDefinitionVersionInput) (*CreateLoggerDefinitionVersionOutput, error) {
	req, out := c.CreateLoggerDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateLoggerDefinitionVersionWithContext is the same as CreateLoggerDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoggerDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateLoggerDefinitionVersionWithContext(ctx aws.Context, input *CreateLoggerDefinitionVersionInput, opts ...request.Option) (*CreateLoggerDefinitionVersionOutput, error) {
	req, out := c.CreateLoggerDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceDefinition = "CreateResourceDefinition"

// CreateResourceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceDefinition for more information on using the CreateResourceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceDefinitionRequest method.
//    req, resp := client.CreateResourceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition
func (c *Greengrass) CreateResourceDefinitionRequest(input *CreateResourceDefinitionInput) (req *request.Request, output *CreateResourceDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateResourceDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/resources",
	}

	if input == nil {
		input = &CreateResourceDefinitionInput{}
	}

	output = &CreateResourceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceDefinition API operation for AWS Greengrass.
//
// Creates a resource definition which contains a list of resources to be used
// in a group. You can create an initial version of the definition by providing
// a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateResourceDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition
func (c *Greengrass) CreateResourceDefinition(input *CreateResourceDefinitionInput) (*CreateResourceDefinitionOutput, error) {
	req, out := c.CreateResourceDefinitionRequest(input)
	return out, req.Send()
}

// CreateResourceDefinitionWithContext is the same as CreateResourceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateResourceDefinitionWithContext(ctx aws.Context, input *CreateResourceDefinitionInput, opts ...request.Option) (*CreateResourceDefinitionOutput, error) {
	req, out := c.CreateResourceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceDefinitionVersion = "CreateResourceDefinitionVersion"

// CreateResourceDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceDefinitionVersion for more information on using the CreateResourceDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceDefinitionVersionRequest method.
//    req, resp := client.CreateResourceDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion
func (c *Greengrass) CreateResourceDefinitionVersionRequest(input *CreateResourceDefinitionVersionInput) (req *request.Request, output *CreateResourceDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateResourceDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateResourceDefinitionVersionInput{}
	}

	output = &CreateResourceDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a resource definition that has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateResourceDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion
func (c *Greengrass) CreateResourceDefinitionVersion(input *CreateResourceDefinitionVersionInput) (*CreateResourceDefinitionVersionOutput, error) {
	req, out := c.CreateResourceDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateResourceDefinitionVersionWithContext is the same as CreateResourceDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateResourceDefinitionVersionWithContext(ctx aws.Context, input *CreateResourceDefinitionVersionInput, opts ...request.Option) (*CreateResourceDefinitionVersionOutput, error) {
	req, out := c.CreateResourceDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSoftwareUpdateJob = "CreateSoftwareUpdateJob"

// CreateSoftwareUpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateSoftwareUpdateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSoftwareUpdateJob for more information on using the CreateSoftwareUpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSoftwareUpdateJobRequest method.
//    req, resp := client.CreateSoftwareUpdateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob
func (c *Greengrass) CreateSoftwareUpdateJobRequest(input *CreateSoftwareUpdateJobInput) (req *request.Request, output *CreateSoftwareUpdateJobOutput) {
	op := &request.Operation{
		Name:       opCreateSoftwareUpdateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/updates",
	}

	if input == nil {
		input = &CreateSoftwareUpdateJobInput{}
	}

	output = &CreateSoftwareUpdateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSoftwareUpdateJob API operation for AWS Greengrass.
//
// Creates a software update for a core or group of cores (specified as an IoT
// thing group.) Use this to update the OTA Agent as well as the Greengrass
// core software. It makes use of the IoT Jobs feature which provides additional
// commands to manage a Greengrass core software update job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateSoftwareUpdateJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob
func (c *Greengrass) CreateSoftwareUpdateJob(input *CreateSoftwareUpdateJobInput) (*CreateSoftwareUpdateJobOutput, error) {
	req, out := c.CreateSoftwareUpdateJobRequest(input)
	return out, req.Send()
}

// CreateSoftwareUpdateJobWithContext is the same as CreateSoftwareUpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSoftwareUpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateSoftwareUpdateJobWithContext(ctx aws.Context, input *CreateSoftwareUpdateJobInput, opts ...request.Option) (*CreateSoftwareUpdateJobOutput, error) {
	req, out := c.CreateSoftwareUpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriptionDefinition = "CreateSubscriptionDefinition"

// CreateSubscriptionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriptionDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriptionDefinition for more information on using the CreateSubscriptionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSubscriptionDefinitionRequest method.
//    req, resp := client.CreateSubscriptionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition
func (c *Greengrass) CreateSubscriptionDefinitionRequest(input *CreateSubscriptionDefinitionInput) (req *request.Request, output *CreateSubscriptionDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriptionDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/subscriptions",
	}

	if input == nil {
		input = &CreateSubscriptionDefinitionInput{}
	}

	output = &CreateSubscriptionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriptionDefinition API operation for AWS Greengrass.
//
// Creates a subscription definition. You may provide the initial version of
// the subscription definition now or use ''CreateSubscriptionDefinitionVersion''
// at a later time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateSubscriptionDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition
func (c *Greengrass) CreateSubscriptionDefinition(input *CreateSubscriptionDefinitionInput) (*CreateSubscriptionDefinitionOutput, error) {
	req, out := c.CreateSubscriptionDefinitionRequest(input)
	return out, req.Send()
}

// CreateSubscriptionDefinitionWithContext is the same as CreateSubscriptionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriptionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateSubscriptionDefinitionWithContext(ctx aws.Context, input *CreateSubscriptionDefinitionInput, opts ...request.Option) (*CreateSubscriptionDefinitionOutput, error) {
	req, out := c.CreateSubscriptionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriptionDefinitionVersion = "CreateSubscriptionDefinitionVersion"

// CreateSubscriptionDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriptionDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriptionDefinitionVersion for more information on using the CreateSubscriptionDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSubscriptionDefinitionVersionRequest method.
//    req, resp := client.CreateSubscriptionDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion
func (c *Greengrass) CreateSubscriptionDefinitionVersionRequest(input *CreateSubscriptionDefinitionVersionInput) (req *request.Request, output *CreateSubscriptionDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriptionDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateSubscriptionDefinitionVersionInput{}
	}

	output = &CreateSubscriptionDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriptionDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a subscription definition which has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateSubscriptionDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion
func (c *Greengrass) CreateSubscriptionDefinitionVersion(input *CreateSubscriptionDefinitionVersionInput) (*CreateSubscriptionDefinitionVersionOutput, error) {
	req, out := c.CreateSubscriptionDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateSubscriptionDefinitionVersionWithContext is the same as CreateSubscriptionDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriptionDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateSubscriptionDefinitionVersionWithContext(ctx aws.Context, input *CreateSubscriptionDefinitionVersionInput, opts ...request.Option) (*CreateSubscriptionDefinitionVersionOutput, error) {
	req, out := c.CreateSubscriptionDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnectorDefinition = "DeleteConnectorDefinition"

// DeleteConnectorDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnectorDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnectorDefinition for more information on using the DeleteConnectorDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectorDefinitionRequest method.
//    req, resp := client.DeleteConnectorDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition
func (c *Greengrass) DeleteConnectorDefinitionRequest(input *DeleteConnectorDefinitionInput) (req *request.Request, output *DeleteConnectorDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteConnectorDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}",
	}

	if input == nil {
		input = &DeleteConnectorDefinitionInput{}
	}

	output = &DeleteConnectorDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnectorDefinition API operation for AWS Greengrass.
//
// Deletes a connector definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteConnectorDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition
func (c *Greengrass) DeleteConnectorDefinition(input *DeleteConnectorDefinitionInput) (*DeleteConnectorDefinitionOutput, error) {
	req, out := c.DeleteConnectorDefinitionRequest(input)
	return out, req.Send()
}

// DeleteConnectorDefinitionWithContext is the same as DeleteConnectorDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnectorDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteConnectorDefinitionWithContext(ctx aws.Context, input *DeleteConnectorDefinitionInput, opts ...request.Option) (*DeleteConnectorDefinitionOutput, error) {
	req, out := c.DeleteConnectorDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCoreDefinition = "DeleteCoreDefinition"

// DeleteCoreDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCoreDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCoreDefinition for more information on using the DeleteCoreDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCoreDefinitionRequest method.
//    req, resp := client.DeleteCoreDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition
func (c *Greengrass) DeleteCoreDefinitionRequest(input *DeleteCoreDefinitionInput) (req *request.Request, output *DeleteCoreDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteCoreDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}",
	}

	if input == nil {
		input = &DeleteCoreDefinitionInput{}
	}

	output = &DeleteCoreDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCoreDefinition API operation for AWS Greengrass.
//
// Deletes a core definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteCoreDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition
func (c *Greengrass) DeleteCoreDefinition(input *DeleteCoreDefinitionInput) (*DeleteCoreDefinitionOutput, error) {
	req, out := c.DeleteCoreDefinitionRequest(input)
	return out, req.Send()
}

// DeleteCoreDefinitionWithContext is the same as DeleteCoreDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCoreDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteCoreDefinitionWithContext(ctx aws.Context, input *DeleteCoreDefinitionInput, opts ...request.Option) (*DeleteCoreDefinitionOutput, error) {
	req, out := c.DeleteCoreDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeviceDefinition = "DeleteDeviceDefinition"

// DeleteDeviceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeviceDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeviceDefinition for more information on using the DeleteDeviceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeviceDefinitionRequest method.
//    req, resp := client.DeleteDeviceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition
func (c *Greengrass) DeleteDeviceDefinitionRequest(input *DeleteDeviceDefinitionInput) (req *request.Request, output *DeleteDeviceDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteDeviceDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}",
	}

	if input == nil {
		input = &DeleteDeviceDefinitionInput{}
	}

	output = &DeleteDeviceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeviceDefinition API operation for AWS Greengrass.
//
// Deletes a device definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteDeviceDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition
func (c *Greengrass) DeleteDeviceDefinition(input *DeleteDeviceDefinitionInput) (*DeleteDeviceDefinitionOutput, error) {
	req, out := c.DeleteDeviceDefinitionRequest(input)
	return out, req.Send()
}

// DeleteDeviceDefinitionWithContext is the same as DeleteDeviceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeviceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteDeviceDefinitionWithContext(ctx aws.Context, input *DeleteDeviceDefinitionInput, opts ...request.Option) (*DeleteDeviceDefinitionOutput, error) {
	req, out := c.DeleteDeviceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFunctionDefinition = "DeleteFunctionDefinition"

// DeleteFunctionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunctionDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFunctionDefinition for more information on using the DeleteFunctionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFunctionDefinitionRequest method.
//    req, resp := client.DeleteFunctionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition
func (c *Greengrass) DeleteFunctionDefinitionRequest(input *DeleteFunctionDefinitionInput) (req *request.Request, output *DeleteFunctionDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteFunctionDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}",
	}

	if input == nil {
		input = &DeleteFunctionDefinitionInput{}
	}

	output = &DeleteFunctionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFunctionDefinition API operation for AWS Greengrass.
//
// Deletes a Lambda function definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteFunctionDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition
func (c *Greengrass) DeleteFunctionDefinition(input *DeleteFunctionDefinitionInput) (*DeleteFunctionDefinitionOutput, error) {
	req, out := c.DeleteFunctionDefinitionRequest(input)
	return out, req.Send()
}

// DeleteFunctionDefinitionWithContext is the same as DeleteFunctionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFunctionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteFunctionDefinitionWithContext(ctx aws.Context, input *DeleteFunctionDefinitionInput, opts ...request.Option) (*DeleteFunctionDefinitionOutput, error) {
	req, out := c.DeleteFunctionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup
func (c *Greengrass) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/groups/{GroupId}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroup API operation for AWS Greengrass.
//
// Deletes a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup
func (c *Greengrass) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoggerDefinition = "DeleteLoggerDefinition"

// DeleteLoggerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoggerDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoggerDefinition for more information on using the DeleteLoggerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoggerDefinitionRequest method.
//    req, resp := client.DeleteLoggerDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition
func (c *Greengrass) DeleteLoggerDefinitionRequest(input *DeleteLoggerDefinitionInput) (req *request.Request, output *DeleteLoggerDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteLoggerDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}",
	}

	if input == nil {
		input = &DeleteLoggerDefinitionInput{}
	}

	output = &DeleteLoggerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLoggerDefinition API operation for AWS Greengrass.
//
// Deletes a logger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteLoggerDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition
func (c *Greengrass) DeleteLoggerDefinition(input *DeleteLoggerDefinitionInput) (*DeleteLoggerDefinitionOutput, error) {
	req, out := c.DeleteLoggerDefinitionRequest(input)
	return out, req.Send()
}

// DeleteLoggerDefinitionWithContext is the same as DeleteLoggerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoggerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteLoggerDefinitionWithContext(ctx aws.Context, input *DeleteLoggerDefinitionInput, opts ...request.Option) (*DeleteLoggerDefinitionOutput, error) {
	req, out := c.DeleteLoggerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceDefinition = "DeleteResourceDefinition"

// DeleteResourceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceDefinition for more information on using the DeleteResourceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceDefinitionRequest method.
//    req, resp := client.DeleteResourceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition
func (c *Greengrass) DeleteResourceDefinitionRequest(input *DeleteResourceDefinitionInput) (req *request.Request, output *DeleteResourceDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}",
	}

	if input == nil {
		input = &DeleteResourceDefinitionInput{}
	}

	output = &DeleteResourceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceDefinition API operation for AWS Greengrass.
//
// Deletes a resource definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteResourceDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition
func (c *Greengrass) DeleteResourceDefinition(input *DeleteResourceDefinitionInput) (*DeleteResourceDefinitionOutput, error) {
	req, out := c.DeleteResourceDefinitionRequest(input)
	return out, req.Send()
}

// DeleteResourceDefinitionWithContext is the same as DeleteResourceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteResourceDefinitionWithContext(ctx aws.Context, input *DeleteResourceDefinitionInput, opts ...request.Option) (*DeleteResourceDefinitionOutput, error) {
	req, out := c.DeleteResourceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriptionDefinition = "DeleteSubscriptionDefinition"

// DeleteSubscriptionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriptionDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriptionDefinition for more information on using the DeleteSubscriptionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSubscriptionDefinitionRequest method.
//    req, resp := client.DeleteSubscriptionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition
func (c *Greengrass) DeleteSubscriptionDefinitionRequest(input *DeleteSubscriptionDefinitionInput) (req *request.Request, output *DeleteSubscriptionDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriptionDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
	}

	if input == nil {
		input = &DeleteSubscriptionDefinitionInput{}
	}

	output = &DeleteSubscriptionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubscriptionDefinition API operation for AWS Greengrass.
//
// Deletes a subscription definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteSubscriptionDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition
func (c *Greengrass) DeleteSubscriptionDefinition(input *DeleteSubscriptionDefinitionInput) (*DeleteSubscriptionDefinitionOutput, error) {
	req, out := c.DeleteSubscriptionDefinitionRequest(input)
	return out, req.Send()
}

// DeleteSubscriptionDefinitionWithContext is the same as DeleteSubscriptionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriptionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteSubscriptionDefinitionWithContext(ctx aws.Context, input *DeleteSubscriptionDefinitionInput, opts ...request.Option) (*DeleteSubscriptionDefinitionOutput, error) {
	req, out := c.DeleteSubscriptionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateRoleFromGroup = "DisassociateRoleFromGroup"

// DisassociateRoleFromGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateRoleFromGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateRoleFromGroup for more information on using the DisassociateRoleFromGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateRoleFromGroupRequest method.
//    req, resp := client.DisassociateRoleFromGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup
func (c *Greengrass) DisassociateRoleFromGroupRequest(input *DisassociateRoleFromGroupInput) (req *request.Request, output *DisassociateRoleFromGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociateRoleFromGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/groups/{GroupId}/role",
	}

	if input == nil {
		input = &DisassociateRoleFromGroupInput{}
	}

	output = &DisassociateRoleFromGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateRoleFromGroup API operation for AWS Greengrass.
//
// Disassociates the role from a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DisassociateRoleFromGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup
func (c *Greengrass) DisassociateRoleFromGroup(input *DisassociateRoleFromGroupInput) (*DisassociateRoleFromGroupOutput, error) {
	req, out := c.DisassociateRoleFromGroupRequest(input)
	return out, req.Send()
}

// DisassociateRoleFromGroupWithContext is the same as DisassociateRoleFromGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateRoleFromGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DisassociateRoleFromGroupWithContext(ctx aws.Context, input *DisassociateRoleFromGroupInput, opts ...request.Option) (*DisassociateRoleFromGroupOutput, error) {
	req, out := c.DisassociateRoleFromGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateServiceRoleFromAccount = "DisassociateServiceRoleFromAccount"

// DisassociateServiceRoleFromAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateServiceRoleFromAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateServiceRoleFromAccount for more information on using the DisassociateServiceRoleFromAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateServiceRoleFromAccountRequest method.
//    req, resp := client.DisassociateServiceRoleFromAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount
func (c *Greengrass) DisassociateServiceRoleFromAccountRequest(input *DisassociateServiceRoleFromAccountInput) (req *request.Request, output *DisassociateServiceRoleFromAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateServiceRoleFromAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &DisassociateServiceRoleFromAccountInput{}
	}

	output = &DisassociateServiceRoleFromAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateServiceRoleFromAccount API operation for AWS Greengrass.
//
// Disassociates the service role from your account. Without a service role,
// deployments will not work.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DisassociateServiceRoleFromAccount for usage and error information.
//
// Returned Error Types:
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount
func (c *Greengrass) DisassociateServiceRoleFromAccount(input *DisassociateServiceRoleFromAccountInput) (*DisassociateServiceRoleFromAccountOutput, error) {
	req, out := c.DisassociateServiceRoleFromAccountRequest(input)
	return out, req.Send()
}

// DisassociateServiceRoleFromAccountWithContext is the same as DisassociateServiceRoleFromAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateServiceRoleFromAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DisassociateServiceRoleFromAccountWithContext(ctx aws.Context, input *DisassociateServiceRoleFromAccountInput, opts ...request.Option) (*DisassociateServiceRoleFromAccountOutput, error) {
	req, out := c.DisassociateServiceRoleFromAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssociatedRole = "GetAssociatedRole"

// GetAssociatedRoleRequest generates a "aws/request.Request" representing the
// client's request for the GetAssociatedRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssociatedRole for more information on using the GetAssociatedRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssociatedRoleRequest method.
//    req, resp := client.GetAssociatedRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole
func (c *Greengrass) GetAssociatedRoleRequest(input *GetAssociatedRoleInput) (req *request.Request, output *GetAssociatedRoleOutput) {
	op := &request.Operation{
		Name:       opGetAssociatedRole,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/role",
	}

	if input == nil {
		input = &GetAssociatedRoleInput{}
	}

	output = &GetAssociatedRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssociatedRole API operation for AWS Greengrass.
//
// Retrieves the role associated with a particular group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetAssociatedRole for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole
func (c *Greengrass) GetAssociatedRole(input *GetAssociatedRoleInput) (*GetAssociatedRoleOutput, error) {
	req, out := c.GetAssociatedRoleRequest(input)
	return out, req.Send()
}

// GetAssociatedRoleWithContext is the same as GetAssociatedRole with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssociatedRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetAssociatedRoleWithContext(ctx aws.Context, input *GetAssociatedRoleInput, opts ...request.Option) (*GetAssociatedRoleOutput, error) {
	req, out := c.GetAssociatedRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBulkDeploymentStatus = "GetBulkDeploymentStatus"

// GetBulkDeploymentStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetBulkDeploymentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBulkDeploymentStatus for more information on using the GetBulkDeploymentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBulkDeploymentStatusRequest method.
//    req, resp := client.GetBulkDeploymentStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus
func (c *Greengrass) GetBulkDeploymentStatusRequest(input *GetBulkDeploymentStatusInput) (req *request.Request, output *GetBulkDeploymentStatusOutput) {
	op := &request.Operation{
		Name:       opGetBulkDeploymentStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/bulk/deployments/{BulkDeploymentId}/status",
	}

	if input == nil {
		input = &GetBulkDeploymentStatusInput{}
	}

	output = &GetBulkDeploymentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBulkDeploymentStatus API operation for AWS Greengrass.
//
// Returns the status of a bulk deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetBulkDeploymentStatus for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus
func (c *Greengrass) GetBulkDeploymentStatus(input *GetBulkDeploymentStatusInput) (*GetBulkDeploymentStatusOutput, error) {
	req, out := c.GetBulkDeploymentStatusRequest(input)
	return out, req.Send()
}

// GetBulkDeploymentStatusWithContext is the same as GetBulkDeploymentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetBulkDeploymentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetBulkDeploymentStatusWithContext(ctx aws.Context, input *GetBulkDeploymentStatusInput, opts ...request.Option) (*GetBulkDeploymentStatusOutput, error) {
	req, out := c.GetBulkDeploymentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectivityInfo = "GetConnectivityInfo"

// GetConnectivityInfoRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectivityInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectivityInfo for more information on using the GetConnectivityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectivityInfoRequest method.
//    req, resp := client.GetConnectivityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo
func (c *Greengrass) GetConnectivityInfoRequest(input *GetConnectivityInfoInput) (req *request.Request, output *GetConnectivityInfoOutput) {
	op := &request.Operation{
		Name:       opGetConnectivityInfo,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/things/{ThingName}/connectivityInfo",
	}

	if input == nil {
		input = &GetConnectivityInfoInput{}
	}

	output = &GetConnectivityInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectivityInfo API operation for AWS Greengrass.
//
// Retrieves the connectivity information for a core.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetConnectivityInfo for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo
func (c *Greengrass) GetConnectivityInfo(input *GetConnectivityInfoInput) (*GetConnectivityInfoOutput, error) {
	req, out := c.GetConnectivityInfoRequest(input)
	return out, req.Send()
}

// GetConnectivityInfoWithContext is the same as GetConnectivityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectivityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetConnectivityInfoWithContext(ctx aws.Context, input *GetConnectivityInfoInput, opts ...request.Option) (*GetConnectivityInfoOutput, error) {
	req, out := c.GetConnectivityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectorDefinition = "GetConnectorDefinition"

// GetConnectorDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectorDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectorDefinition for more information on using the GetConnectorDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectorDefinitionRequest method.
//    req, resp := client.GetConnectorDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition
func (c *Greengrass) GetConnectorDefinitionRequest(input *GetConnectorDefinitionInput) (req *request.Request, output *GetConnectorDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetConnectorDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}",
	}

	if input == nil {
		input = &GetConnectorDefinitionInput{}
	}

	output = &GetConnectorDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectorDefinition API operation for AWS Greengrass.
//
// Retrieves information about a connector definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetConnectorDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition
func (c *Greengrass) GetConnectorDefinition(input *GetConnectorDefinitionInput) (*GetConnectorDefinitionOutput, error) {
	req, out := c.GetConnectorDefinitionRequest(input)
	return out, req.Send()
}

// GetConnectorDefinitionWithContext is the same as GetConnectorDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectorDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetConnectorDefinitionWithContext(ctx aws.Context, input *GetConnectorDefinitionInput, opts ...request.Option) (*GetConnectorDefinitionOutput, error) {
	req, out := c.GetConnectorDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectorDefinitionVersion = "GetConnectorDefinitionVersion"

// GetConnectorDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectorDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectorDefinitionVersion for more information on using the GetConnectorDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectorDefinitionVersionRequest method.
//    req, resp := client.GetConnectorDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion
func (c *Greengrass) GetConnectorDefinitionVersionRequest(input *GetConnectorDefinitionVersionInput) (req *request.Request, output *GetConnectorDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetConnectorDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}/versions/{ConnectorDefinitionVersionId}",
	}

	if input == nil {
		input = &GetConnectorDefinitionVersionInput{}
	}

	output = &GetConnectorDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectorDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a connector definition version, including the
// connectors that the version contains. Connectors are prebuilt modules that
// interact with local infrastructure, device protocols, AWS, and other cloud
// services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetConnectorDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion
func (c *Greengrass) GetConnectorDefinitionVersion(input *GetConnectorDefinitionVersionInput) (*GetConnectorDefinitionVersionOutput, error) {
	req, out := c.GetConnectorDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetConnectorDefinitionVersionWithContext is the same as GetConnectorDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectorDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetConnectorDefinitionVersionWithContext(ctx aws.Context, input *GetConnectorDefinitionVersionInput, opts ...request.Option) (*GetConnectorDefinitionVersionOutput, error) {
	req, out := c.GetConnectorDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCoreDefinition = "GetCoreDefinition"

// GetCoreDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetCoreDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCoreDefinition for more information on using the GetCoreDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCoreDefinitionRequest method.
//    req, resp := client.GetCoreDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition
func (c *Greengrass) GetCoreDefinitionRequest(input *GetCoreDefinitionInput) (req *request.Request, output *GetCoreDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetCoreDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}",
	}

	if input == nil {
		input = &GetCoreDefinitionInput{}
	}

	output = &GetCoreDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCoreDefinition API operation for AWS Greengrass.
//
// Retrieves information about a core definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetCoreDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition
func (c *Greengrass) GetCoreDefinition(input *GetCoreDefinitionInput) (*GetCoreDefinitionOutput, error) {
	req, out := c.GetCoreDefinitionRequest(input)
	return out, req.Send()
}

// GetCoreDefinitionWithContext is the same as GetCoreDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetCoreDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetCoreDefinitionWithContext(ctx aws.Context, input *GetCoreDefinitionInput, opts ...request.Option) (*GetCoreDefinitionOutput, error) {
	req, out := c.GetCoreDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCoreDefinitionVersion = "GetCoreDefinitionVersion"

// GetCoreDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetCoreDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCoreDefinitionVersion for more information on using the GetCoreDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCoreDefinitionVersionRequest method.
//    req, resp := client.GetCoreDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion
func (c *Greengrass) GetCoreDefinitionVersionRequest(input *GetCoreDefinitionVersionInput) (req *request.Request, output *GetCoreDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetCoreDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}/versions/{CoreDefinitionVersionId}",
	}

	if input == nil {
		input = &GetCoreDefinitionVersionInput{}
	}

	output = &GetCoreDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCoreDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a core definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetCoreDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion
func (c *Greengrass) GetCoreDefinitionVersion(input *GetCoreDefinitionVersionInput) (*GetCoreDefinitionVersionOutput, error) {
	req, out := c.GetCoreDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetCoreDefinitionVersionWithContext is the same as GetCoreDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetCoreDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetCoreDefinitionVersionWithContext(ctx aws.Context, input *GetCoreDefinitionVersionInput, opts ...request.Option) (*GetCoreDefinitionVersionOutput, error) {
	req, out := c.GetCoreDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeploymentStatus = "GetDeploymentStatus"

// GetDeploymentStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeploymentStatus for more information on using the GetDeploymentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentStatusRequest method.
//    req, resp := client.GetDeploymentStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus
func (c *Greengrass) GetDeploymentStatusRequest(input *GetDeploymentStatusInput) (req *request.Request, output *GetDeploymentStatusOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/deployments/{DeploymentId}/status",
	}

	if input == nil {
		input = &GetDeploymentStatusInput{}
	}

	output = &GetDeploymentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeploymentStatus API operation for AWS Greengrass.
//
// Returns the status of a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetDeploymentStatus for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus
func (c *Greengrass) GetDeploymentStatus(input *GetDeploymentStatusInput) (*GetDeploymentStatusOutput, error) {
	req, out := c.GetDeploymentStatusRequest(input)
	return out, req.Send()
}

// GetDeploymentStatusWithContext is the same as GetDeploymentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeploymentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetDeploymentStatusWithContext(ctx aws.Context, input *GetDeploymentStatusInput, opts ...request.Option) (*GetDeploymentStatusOutput, error) {
	req, out := c.GetDeploymentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceDefinition = "GetDeviceDefinition"

// GetDeviceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceDefinition for more information on using the GetDeviceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceDefinitionRequest method.
//    req, resp := client.GetDeviceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition
func (c *Greengrass) GetDeviceDefinitionRequest(input *GetDeviceDefinitionInput) (req *request.Request, output *GetDeviceDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetDeviceDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}",
	}

	if input == nil {
		input = &GetDeviceDefinitionInput{}
	}

	output = &GetDeviceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceDefinition API operation for AWS Greengrass.
//
// Retrieves information about a device definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetDeviceDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition
func (c *Greengrass) GetDeviceDefinition(input *GetDeviceDefinitionInput) (*GetDeviceDefinitionOutput, error) {
	req, out := c.GetDeviceDefinitionRequest(input)
	return out, req.Send()
}

// GetDeviceDefinitionWithContext is the same as GetDeviceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetDeviceDefinitionWithContext(ctx aws.Context, input *GetDeviceDefinitionInput, opts ...request.Option) (*GetDeviceDefinitionOutput, error) {
	req, out := c.GetDeviceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceDefinitionVersion = "GetDeviceDefinitionVersion"

// GetDeviceDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceDefinitionVersion for more information on using the GetDeviceDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceDefinitionVersionRequest method.
//    req, resp := client.GetDeviceDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion
func (c *Greengrass) GetDeviceDefinitionVersionRequest(input *GetDeviceDefinitionVersionInput) (req *request.Request, output *GetDeviceDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetDeviceDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}/versions/{DeviceDefinitionVersionId}",
	}

	if input == nil {
		input = &GetDeviceDefinitionVersionInput{}
	}

	output = &GetDeviceDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a device definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetDeviceDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion
func (c *Greengrass) GetDeviceDefinitionVersion(input *GetDeviceDefinitionVersionInput) (*GetDeviceDefinitionVersionOutput, error) {
	req, out := c.GetDeviceDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetDeviceDefinitionVersionWithContext is the same as GetDeviceDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetDeviceDefinitionVersionWithContext(ctx aws.Context, input *GetDeviceDefinitionVersionInput, opts ...request.Option) (*GetDeviceDefinitionVersionOutput, error) {
	req, out := c.GetDeviceDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunctionDefinition = "GetFunctionDefinition"

// GetFunctionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunctionDefinition for more information on using the GetFunctionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionDefinitionRequest method.
//    req, resp := client.GetFunctionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition
func (c *Greengrass) GetFunctionDefinitionRequest(input *GetFunctionDefinitionInput) (req *request.Request, output *GetFunctionDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetFunctionDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}",
	}

	if input == nil {
		input = &GetFunctionDefinitionInput{}
	}

	output = &GetFunctionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionDefinition API operation for AWS Greengrass.
//
// Retrieves information about a Lambda function definition, including its creation
// time and latest version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetFunctionDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition
func (c *Greengrass) GetFunctionDefinition(input *GetFunctionDefinitionInput) (*GetFunctionDefinitionOutput, error) {
	req, out := c.GetFunctionDefinitionRequest(input)
	return out, req.Send()
}

// GetFunctionDefinitionWithContext is the same as GetFunctionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunctionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetFunctionDefinitionWithContext(ctx aws.Context, input *GetFunctionDefinitionInput, opts ...request.Option) (*GetFunctionDefinitionOutput, error) {
	req, out := c.GetFunctionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunctionDefinitionVersion = "GetFunctionDefinitionVersion"

// GetFunctionDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunctionDefinitionVersion for more information on using the GetFunctionDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionDefinitionVersionRequest method.
//    req, resp := client.GetFunctionDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion
func (c *Greengrass) GetFunctionDefinitionVersionRequest(input *GetFunctionDefinitionVersionInput) (req *request.Request, output *GetFunctionDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetFunctionDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}/versions/{FunctionDefinitionVersionId}",
	}

	if input == nil {
		input = &GetFunctionDefinitionVersionInput{}
	}

	output = &GetFunctionDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a Lambda function definition version, including
// which Lambda functions are included in the version and their configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetFunctionDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion
func (c *Greengrass) GetFunctionDefinitionVersion(input *GetFunctionDefinitionVersionInput) (*GetFunctionDefinitionVersionOutput, error) {
	req, out := c.GetFunctionDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetFunctionDefinitionVersionWithContext is the same as GetFunctionDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunctionDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetFunctionDefinitionVersionWithContext(ctx aws.Context, input *GetFunctionDefinitionVersionInput, opts ...request.Option) (*GetFunctionDefinitionVersionOutput, error) {
	req, out := c.GetFunctionDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroup for more information on using the GetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupRequest method.
//    req, resp := client.GetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup
func (c *Greengrass) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for AWS Greengrass.
//
// Retrieves information about a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup
func (c *Greengrass) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	return out, req.Send()
}

// GetGroupWithContext is the same as GetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetGroupWithContext(ctx aws.Context, input *GetGroupInput, opts ...request.Option) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupCertificateAuthority = "GetGroupCertificateAuthority"

// GetGroupCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupCertificateAuthority for more information on using the GetGroupCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupCertificateAuthorityRequest method.
//    req, resp := client.GetGroupCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority
func (c *Greengrass) GetGroupCertificateAuthorityRequest(input *GetGroupCertificateAuthorityInput) (req *request.Request, output *GetGroupCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opGetGroupCertificateAuthority,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities/{CertificateAuthorityId}",
	}

	if input == nil {
		input = &GetGroupCertificateAuthorityInput{}
	}

	output = &GetGroupCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupCertificateAuthority API operation for AWS Greengrass.
//
// Retreives the CA associated with a group. Returns the public key of the CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetGroupCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority
func (c *Greengrass) GetGroupCertificateAuthority(input *GetGroupCertificateAuthorityInput) (*GetGroupCertificateAuthorityOutput, error) {
	req, out := c.GetGroupCertificateAuthorityRequest(input)
	return out, req.Send()
}

// GetGroupCertificateAuthorityWithContext is the same as GetGroupCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetGroupCertificateAuthorityWithContext(ctx aws.Context, input *GetGroupCertificateAuthorityInput, opts ...request.Option) (*GetGroupCertificateAuthorityOutput, error) {
	req, out := c.GetGroupCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupCertificateConfiguration = "GetGroupCertificateConfiguration"

// GetGroupCertificateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupCertificateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupCertificateConfiguration for more information on using the GetGroupCertificateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupCertificateConfigurationRequest method.
//    req, resp := client.GetGroupCertificateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration
func (c *Greengrass) GetGroupCertificateConfigurationRequest(input *GetGroupCertificateConfigurationInput) (req *request.Request, output *GetGroupCertificateConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetGroupCertificateConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities/configuration/expiry",
	}

	if input == nil {
		input = &GetGroupCertificateConfigurationInput{}
	}

	output = &GetGroupCertificateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupCertificateConfiguration API operation for AWS Greengrass.
//
// Retrieves the current configuration for the CA used by the group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetGroupCertificateConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration
func (c *Greengrass) GetGroupCertificateConfiguration(input *GetGroupCertificateConfigurationInput) (*GetGroupCertificateConfigurationOutput, error) {
	req, out := c.GetGroupCertificateConfigurationRequest(input)
	return out, req.Send()
}

// GetGroupCertificateConfigurationWithContext is the same as GetGroupCertificateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupCertificateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetGroupCertificateConfigurationWithContext(ctx aws.Context, input *GetGroupCertificateConfigurationInput, opts ...request.Option) (*GetGroupCertificateConfigurationOutput, error) {
	req, out := c.GetGroupCertificateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupVersion = "GetGroupVersion"

// GetGroupVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupVersion for more information on using the GetGroupVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupVersionRequest method.
//    req, resp := client.GetGroupVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion
func (c *Greengrass) GetGroupVersionRequest(input *GetGroupVersionInput) (req *request.Request, output *GetGroupVersionOutput) {
	op := &request.Operation{
		Name:       opGetGroupVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/versions/{GroupVersionId}",
	}

	if input == nil {
		input = &GetGroupVersionInput{}
	}

	output = &GetGroupVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupVersion API operation for AWS Greengrass.
//
// Retrieves information about a group version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetGroupVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion
func (c *Greengrass) GetGroupVersion(input *GetGroupVersionInput) (*GetGroupVersionOutput, error) {
	req, out := c.GetGroupVersionRequest(input)
	return out, req.Send()
}

// GetGroupVersionWithContext is the same as GetGroupVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetGroupVersionWithContext(ctx aws.Context, input *GetGroupVersionInput, opts ...request.Option) (*GetGroupVersionOutput, error) {
	req, out := c.GetGroupVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggerDefinition = "GetLoggerDefinition"

// GetLoggerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggerDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggerDefinition for more information on using the GetLoggerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggerDefinitionRequest method.
//    req, resp := client.GetLoggerDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition
func (c *Greengrass) GetLoggerDefinitionRequest(input *GetLoggerDefinitionInput) (req *request.Request, output *GetLoggerDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetLoggerDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}",
	}

	if input == nil {
		input = &GetLoggerDefinitionInput{}
	}

	output = &GetLoggerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggerDefinition API operation for AWS Greengrass.
//
// Retrieves information about a logger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetLoggerDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition
func (c *Greengrass) GetLoggerDefinition(input *GetLoggerDefinitionInput) (*GetLoggerDefinitionOutput, error) {
	req, out := c.GetLoggerDefinitionRequest(input)
	return out, req.Send()
}

// GetLoggerDefinitionWithContext is the same as GetLoggerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetLoggerDefinitionWithContext(ctx aws.Context, input *GetLoggerDefinitionInput, opts ...request.Option) (*GetLoggerDefinitionOutput, error) {
	req, out := c.GetLoggerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggerDefinitionVersion = "GetLoggerDefinitionVersion"

// GetLoggerDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggerDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggerDefinitionVersion for more information on using the GetLoggerDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggerDefinitionVersionRequest method.
//    req, resp := client.GetLoggerDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion
func (c *Greengrass) GetLoggerDefinitionVersionRequest(input *GetLoggerDefinitionVersionInput) (req *request.Request, output *GetLoggerDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetLoggerDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}/versions/{LoggerDefinitionVersionId}",
	}

	if input == nil {
		input = &GetLoggerDefinitionVersionInput{}
	}

	output = &GetLoggerDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggerDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a logger definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetLoggerDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion
func (c *Greengrass) GetLoggerDefinitionVersion(input *GetLoggerDefinitionVersionInput) (*GetLoggerDefinitionVersionOutput, error) {
	req, out := c.GetLoggerDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetLoggerDefinitionVersionWithContext is the same as GetLoggerDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggerDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetLoggerDefinitionVersionWithContext(ctx aws.Context, input *GetLoggerDefinitionVersionInput, opts ...request.Option) (*GetLoggerDefinitionVersionOutput, error) {
	req, out := c.GetLoggerDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceDefinition = "GetResourceDefinition"

// GetResourceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceDefinition for more information on using the GetResourceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceDefinitionRequest method.
//    req, resp := client.GetResourceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition
func (c *Greengrass) GetResourceDefinitionRequest(input *GetResourceDefinitionInput) (req *request.Request, output *GetResourceDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetResourceDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}",
	}

	if input == nil {
		input = &GetResourceDefinitionInput{}
	}

	output = &GetResourceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceDefinition API operation for AWS Greengrass.
//
// Retrieves information about a resource definition, including its creation
// time and latest version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetResourceDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition
func (c *Greengrass) GetResourceDefinition(input *GetResourceDefinitionInput) (*GetResourceDefinitionOutput, error) {
	req, out := c.GetResourceDefinitionRequest(input)
	return out, req.Send()
}

// GetResourceDefinitionWithContext is the same as GetResourceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetResourceDefinitionWithContext(ctx aws.Context, input *GetResourceDefinitionInput, opts ...request.Option) (*GetResourceDefinitionOutput, error) {
	req, out := c.GetResourceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceDefinitionVersion = "GetResourceDefinitionVersion"

// GetResourceDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceDefinitionVersion for more information on using the GetResourceDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceDefinitionVersionRequest method.
//    req, resp := client.GetResourceDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion
func (c *Greengrass) GetResourceDefinitionVersionRequest(input *GetResourceDefinitionVersionInput) (req *request.Request, output *GetResourceDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetResourceDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}/versions/{ResourceDefinitionVersionId}",
	}

	if input == nil {
		input = &GetResourceDefinitionVersionInput{}
	}

	output = &GetResourceDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a resource definition version, including which
// resources are included in the version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetResourceDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion
func (c *Greengrass) GetResourceDefinitionVersion(input *GetResourceDefinitionVersionInput) (*GetResourceDefinitionVersionOutput, error) {
	req, out := c.GetResourceDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetResourceDefinitionVersionWithContext is the same as GetResourceDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetResourceDefinitionVersionWithContext(ctx aws.Context, input *GetResourceDefinitionVersionInput, opts ...request.Option) (*GetResourceDefinitionVersionOutput, error) {
	req, out := c.GetResourceDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceRoleForAccount = "GetServiceRoleForAccount"

// GetServiceRoleForAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceRoleForAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceRoleForAccount for more information on using the GetServiceRoleForAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceRoleForAccountRequest method.
//    req, resp := client.GetServiceRoleForAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount
func (c *Greengrass) GetServiceRoleForAccountRequest(input *GetServiceRoleForAccountInput) (req *request.Request, output *GetServiceRoleForAccountOutput) {
	op := &request.Operation{
		Name:       opGetServiceRoleForAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &GetServiceRoleForAccountInput{}
	}

	output = &GetServiceRoleForAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceRoleForAccount API operation for AWS Greengrass.
//
// Retrieves the service role that is attached to your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetServiceRoleForAccount for usage and error information.
//
// Returned Error Types:
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount
func (c *Greengrass) GetServiceRoleForAccount(input *GetServiceRoleForAccountInput) (*GetServiceRoleForAccountOutput, error) {
	req, out := c.GetServiceRoleForAccountRequest(input)
	return out, req.Send()
}

// GetServiceRoleForAccountWithContext is the same as GetServiceRoleForAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceRoleForAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetServiceRoleForAccountWithContext(ctx aws.Context, input *GetServiceRoleForAccountInput, opts ...request.Option) (*GetServiceRoleForAccountOutput, error) {
	req, out := c.GetServiceRoleForAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubscriptionDefinition = "GetSubscriptionDefinition"

// GetSubscriptionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriptionDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriptionDefinition for more information on using the GetSubscriptionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSubscriptionDefinitionRequest method.
//    req, resp := client.GetSubscriptionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition
func (c *Greengrass) GetSubscriptionDefinitionRequest(input *GetSubscriptionDefinitionInput) (req *request.Request, output *GetSubscriptionDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
	}

	if input == nil {
		input = &GetSubscriptionDefinitionInput{}
	}

	output = &GetSubscriptionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriptionDefinition API operation for AWS Greengrass.
//
// Retrieves information about a subscription definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetSubscriptionDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition
func (c *Greengrass) GetSubscriptionDefinition(input *GetSubscriptionDefinitionInput) (*GetSubscriptionDefinitionOutput, error) {
	req, out := c.GetSubscriptionDefinitionRequest(input)
	return out, req.Send()
}

// GetSubscriptionDefinitionWithContext is the same as GetSubscriptionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriptionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetSubscriptionDefinitionWithContext(ctx aws.Context, input *GetSubscriptionDefinitionInput, opts ...request.Option) (*GetSubscriptionDefinitionOutput, error) {
	req, out := c.GetSubscriptionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubscriptionDefinitionVersion = "GetSubscriptionDefinitionVersion"

// GetSubscriptionDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriptionDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriptionDefinitionVersion for more information on using the GetSubscriptionDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSubscriptionDefinitionVersionRequest method.
//    req, resp := client.GetSubscriptionDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion
func (c *Greengrass) GetSubscriptionDefinitionVersionRequest(input *GetSubscriptionDefinitionVersionInput) (req *request.Request, output *GetSubscriptionDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions/{SubscriptionDefinitionVersionId}",
	}

	if input == nil {
		input = &GetSubscriptionDefinitionVersionInput{}
	}

	output = &GetSubscriptionDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriptionDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a subscription definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetSubscriptionDefinitionVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion
func (c *Greengrass) GetSubscriptionDefinitionVersion(input *GetSubscriptionDefinitionVersionInput) (*GetSubscriptionDefinitionVersionOutput, error) {
	req, out := c.GetSubscriptionDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetSubscriptionDefinitionVersionWithContext is the same as GetSubscriptionDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriptionDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetSubscriptionDefinitionVersionWithContext(ctx aws.Context, input *GetSubscriptionDefinitionVersionInput, opts ...request.Option) (*GetSubscriptionDefinitionVersionOutput, error) {
	req, out := c.GetSubscriptionDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBulkDeploymentDetailedReports = "ListBulkDeploymentDetailedReports"

// ListBulkDeploymentDetailedReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListBulkDeploymentDetailedReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBulkDeploymentDetailedReports for more information on using the ListBulkDeploymentDetailedReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBulkDeploymentDetailedReportsRequest method.
//    req, resp := client.ListBulkDeploymentDetailedReportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports
func (c *Greengrass) ListBulkDeploymentDetailedReportsRequest(input *ListBulkDeploymentDetailedReportsInput) (req *request.Request, output *ListBulkDeploymentDetailedReportsOutput) {
	op := &request.Operation{
		Name:       opListBulkDeploymentDetailedReports,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/bulk/deployments/{BulkDeploymentId}/detailed-reports",
	}

	if input == nil {
		input = &ListBulkDeploymentDetailedReportsInput{}
	}

	output = &ListBulkDeploymentDetailedReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBulkDeploymentDetailedReports API operation for AWS Greengrass.
//
// Gets a paginated list of the deployments that have been started in a bulk
// deployment operation, and their current deployment status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListBulkDeploymentDetailedReports for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports
func (c *Greengrass) ListBulkDeploymentDetailedReports(input *ListBulkDeploymentDetailedReportsInput) (*ListBulkDeploymentDetailedReportsOutput, error) {
	req, out := c.ListBulkDeploymentDetailedReportsRequest(input)
	return out, req.Send()
}

// ListBulkDeploymentDetailedReportsWithContext is the same as ListBulkDeploymentDetailedReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListBulkDeploymentDetailedReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListBulkDeploymentDetailedReportsWithContext(ctx aws.Context, input *ListBulkDeploymentDetailedReportsInput, opts ...request.Option) (*ListBulkDeploymentDetailedReportsOutput, error) {
	req, out := c.ListBulkDeploymentDetailedReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBulkDeployments = "ListBulkDeployments"

// ListBulkDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListBulkDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBulkDeployments for more information on using the ListBulkDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBulkDeploymentsRequest method.
//    req, resp := client.ListBulkDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments
func (c *Greengrass) ListBulkDeploymentsRequest(input *ListBulkDeploymentsInput) (req *request.Request, output *ListBulkDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListBulkDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/bulk/deployments",
	}

	if input == nil {
		input = &ListBulkDeploymentsInput{}
	}

	output = &ListBulkDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBulkDeployments API operation for AWS Greengrass.
//
// Returns a list of bulk deployments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListBulkDeployments for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments
func (c *Greengrass) ListBulkDeployments(input *ListBulkDeploymentsInput) (*ListBulkDeploymentsOutput, error) {
	req, out := c.ListBulkDeploymentsRequest(input)
	return out, req.Send()
}

// ListBulkDeploymentsWithContext is the same as ListBulkDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListBulkDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListBulkDeploymentsWithContext(ctx aws.Context, input *ListBulkDeploymentsInput, opts ...request.Option) (*ListBulkDeploymentsOutput, error) {
	req, out := c.ListBulkDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConnectorDefinitionVersions = "ListConnectorDefinitionVersions"

// ListConnectorDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListConnectorDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnectorDefinitionVersions for more information on using the ListConnectorDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConnectorDefinitionVersionsRequest method.
//    req, resp := client.ListConnectorDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions
func (c *Greengrass) ListConnectorDefinitionVersionsRequest(input *ListConnectorDefinitionVersionsInput) (req *request.Request, output *ListConnectorDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListConnectorDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}/versions",
	}

	if input == nil {
		input = &ListConnectorDefinitionVersionsInput{}
	}

	output = &ListConnectorDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnectorDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a connector definition, which are containers for connectors.
// Connectors run on the Greengrass core and contain built-in integration with
// local infrastructure, device protocols, AWS, and other cloud services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListConnectorDefinitionVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions
func (c *Greengrass) ListConnectorDefinitionVersions(input *ListConnectorDefinitionVersionsInput) (*ListConnectorDefinitionVersionsOutput, error) {
	req, out := c.ListConnectorDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListConnectorDefinitionVersionsWithContext is the same as ListConnectorDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnectorDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListConnectorDefinitionVersionsWithContext(ctx aws.Context, input *ListConnectorDefinitionVersionsInput, opts ...request.Option) (*ListConnectorDefinitionVersionsOutput, error) {
	req, out := c.ListConnectorDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConnectorDefinitions = "ListConnectorDefinitions"

// ListConnectorDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListConnectorDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConnectorDefinitions for more information on using the ListConnectorDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConnectorDefinitionsRequest method.
//    req, resp := client.ListConnectorDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions
func (c *Greengrass) ListConnectorDefinitionsRequest(input *ListConnectorDefinitionsInput) (req *request.Request, output *ListConnectorDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListConnectorDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/connectors",
	}

	if input == nil {
		input = &ListConnectorDefinitionsInput{}
	}

	output = &ListConnectorDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConnectorDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of connector definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListConnectorDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions
func (c *Greengrass) ListConnectorDefinitions(input *ListConnectorDefinitionsInput) (*ListConnectorDefinitionsOutput, error) {
	req, out := c.ListConnectorDefinitionsRequest(input)
	return out, req.Send()
}

// ListConnectorDefinitionsWithContext is the same as ListConnectorDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListConnectorDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListConnectorDefinitionsWithContext(ctx aws.Context, input *ListConnectorDefinitionsInput, opts ...request.Option) (*ListConnectorDefinitionsOutput, error) {
	req, out := c.ListConnectorDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCoreDefinitionVersions = "ListCoreDefinitionVersions"

// ListCoreDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCoreDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCoreDefinitionVersions for more information on using the ListCoreDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCoreDefinitionVersionsRequest method.
//    req, resp := client.ListCoreDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions
func (c *Greengrass) ListCoreDefinitionVersionsRequest(input *ListCoreDefinitionVersionsInput) (req *request.Request, output *ListCoreDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListCoreDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}/versions",
	}

	if input == nil {
		input = &ListCoreDefinitionVersionsInput{}
	}

	output = &ListCoreDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCoreDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a core definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListCoreDefinitionVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions
func (c *Greengrass) ListCoreDefinitionVersions(input *ListCoreDefinitionVersionsInput) (*ListCoreDefinitionVersionsOutput, error) {
	req, out := c.ListCoreDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListCoreDefinitionVersionsWithContext is the same as ListCoreDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCoreDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListCoreDefinitionVersionsWithContext(ctx aws.Context, input *ListCoreDefinitionVersionsInput, opts ...request.Option) (*ListCoreDefinitionVersionsOutput, error) {
	req, out := c.ListCoreDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCoreDefinitions = "ListCoreDefinitions"

// ListCoreDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCoreDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCoreDefinitions for more information on using the ListCoreDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCoreDefinitionsRequest method.
//    req, resp := client.ListCoreDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions
func (c *Greengrass) ListCoreDefinitionsRequest(input *ListCoreDefinitionsInput) (req *request.Request, output *ListCoreDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListCoreDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores",
	}

	if input == nil {
		input = &ListCoreDefinitionsInput{}
	}

	output = &ListCoreDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCoreDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of core definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListCoreDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions
func (c *Greengrass) ListCoreDefinitions(input *ListCoreDefinitionsInput) (*ListCoreDefinitionsOutput, error) {
	req, out := c.ListCoreDefinitionsRequest(input)
	return out, req.Send()
}

// ListCoreDefinitionsWithContext is the same as ListCoreDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCoreDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListCoreDefinitionsWithContext(ctx aws.Context, input *ListCoreDefinitionsInput, opts ...request.Option) (*ListCoreDefinitionsOutput, error) {
	req, out := c.ListCoreDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeployments for more information on using the ListDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeploymentsRequest method.
//    req, resp := client.ListDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments
func (c *Greengrass) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/deployments",
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	output = &ListDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeployments API operation for AWS Greengrass.
//
// Returns a history of deployments for the group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListDeployments for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments
func (c *Greengrass) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	return out, req.Send()
}

// ListDeploymentsWithContext is the same as ListDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListDeploymentsWithContext(ctx aws.Context, input *ListDeploymentsInput, opts ...request.Option) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeviceDefinitionVersions = "ListDeviceDefinitionVersions"

// ListDeviceDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceDefinitionVersions for more information on using the ListDeviceDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeviceDefinitionVersionsRequest method.
//    req, resp := client.ListDeviceDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions
func (c *Greengrass) ListDeviceDefinitionVersionsRequest(input *ListDeviceDefinitionVersionsInput) (req *request.Request, output *ListDeviceDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListDeviceDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}/versions",
	}

	if input == nil {
		input = &ListDeviceDefinitionVersionsInput{}
	}

	output = &ListDeviceDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a device definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListDeviceDefinitionVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions
func (c *Greengrass) ListDeviceDefinitionVersions(input *ListDeviceDefinitionVersionsInput) (*ListDeviceDefinitionVersionsOutput, error) {
	req, out := c.ListDeviceDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListDeviceDefinitionVersionsWithContext is the same as ListDeviceDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListDeviceDefinitionVersionsWithContext(ctx aws.Context, input *ListDeviceDefinitionVersionsInput, opts ...request.Option) (*ListDeviceDefinitionVersionsOutput, error) {
	req, out := c.ListDeviceDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeviceDefinitions = "ListDeviceDefinitions"

// ListDeviceDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceDefinitions for more information on using the ListDeviceDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeviceDefinitionsRequest method.
//    req, resp := client.ListDeviceDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions
func (c *Greengrass) ListDeviceDefinitionsRequest(input *ListDeviceDefinitionsInput) (req *request.Request, output *ListDeviceDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListDeviceDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/devices",
	}

	if input == nil {
		input = &ListDeviceDefinitionsInput{}
	}

	output = &ListDeviceDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of device definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListDeviceDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions
func (c *Greengrass) ListDeviceDefinitions(input *ListDeviceDefinitionsInput) (*ListDeviceDefinitionsOutput, error) {
	req, out := c.ListDeviceDefinitionsRequest(input)
	return out, req.Send()
}

// ListDeviceDefinitionsWithContext is the same as ListDeviceDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListDeviceDefinitionsWithContext(ctx aws.Context, input *ListDeviceDefinitionsInput, opts ...request.Option) (*ListDeviceDefinitionsOutput, error) {
	req, out := c.ListDeviceDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFunctionDefinitionVersions = "ListFunctionDefinitionVersions"

// ListFunctionDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctionDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFunctionDefinitionVersions for more information on using the ListFunctionDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFunctionDefinitionVersionsRequest method.
//    req, resp := client.ListFunctionDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions
func (c *Greengrass) ListFunctionDefinitionVersionsRequest(input *ListFunctionDefinitionVersionsInput) (req *request.Request, output *ListFunctionDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListFunctionDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}/versions",
	}

	if input == nil {
		input = &ListFunctionDefinitionVersionsInput{}
	}

	output = &ListFunctionDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctionDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a Lambda function definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListFunctionDefinitionVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions
func (c *Greengrass) ListFunctionDefinitionVersions(input *ListFunctionDefinitionVersionsInput) (*ListFunctionDefinitionVersionsOutput, error) {
	req, out := c.ListFunctionDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListFunctionDefinitionVersionsWithContext is the same as ListFunctionDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFunctionDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListFunctionDefinitionVersionsWithContext(ctx aws.Context, input *ListFunctionDefinitionVersionsInput, opts ...request.Option) (*ListFunctionDefinitionVersionsOutput, error) {
	req, out := c.ListFunctionDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFunctionDefinitions = "ListFunctionDefinitions"

// ListFunctionDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctionDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFunctionDefinitions for more information on using the ListFunctionDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFunctionDefinitionsRequest method.
//    req, resp := client.ListFunctionDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions
func (c *Greengrass) ListFunctionDefinitionsRequest(input *ListFunctionDefinitionsInput) (req *request.Request, output *ListFunctionDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListFunctionDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/functions",
	}

	if input == nil {
		input = &ListFunctionDefinitionsInput{}
	}

	output = &ListFunctionDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctionDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of Lambda function definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListFunctionDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions
func (c *Greengrass) ListFunctionDefinitions(input *ListFunctionDefinitionsInput) (*ListFunctionDefinitionsOutput, error) {
	req, out := c.ListFunctionDefinitionsRequest(input)
	return out, req.Send()
}

// ListFunctionDefinitionsWithContext is the same as ListFunctionDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFunctionDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListFunctionDefinitionsWithContext(ctx aws.Context, input *ListFunctionDefinitionsInput, opts ...request.Option) (*ListFunctionDefinitionsOutput, error) {
	req, out := c.ListFunctionDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupCertificateAuthorities = "ListGroupCertificateAuthorities"

// ListGroupCertificateAuthoritiesRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupCertificateAuthorities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupCertificateAuthorities for more information on using the ListGroupCertificateAuthorities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupCertificateAuthoritiesRequest method.
//    req, resp := client.ListGroupCertificateAuthoritiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities
func (c *Greengrass) ListGroupCertificateAuthoritiesRequest(input *ListGroupCertificateAuthoritiesInput) (req *request.Request, output *ListGroupCertificateAuthoritiesOutput) {
	op := &request.Operation{
		Name:       opListGroupCertificateAuthorities,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities",
	}

	if input == nil {
		input = &ListGroupCertificateAuthoritiesInput{}
	}

	output = &ListGroupCertificateAuthoritiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupCertificateAuthorities API operation for AWS Greengrass.
//
// Retrieves the current CAs for a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListGroupCertificateAuthorities for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities
func (c *Greengrass) ListGroupCertificateAuthorities(input *ListGroupCertificateAuthoritiesInput) (*ListGroupCertificateAuthoritiesOutput, error) {
	req, out := c.ListGroupCertificateAuthoritiesRequest(input)
	return out, req.Send()
}

// ListGroupCertificateAuthoritiesWithContext is the same as ListGroupCertificateAuthorities with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupCertificateAuthorities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListGroupCertificateAuthoritiesWithContext(ctx aws.Context, input *ListGroupCertificateAuthoritiesInput, opts ...request.Option) (*ListGroupCertificateAuthoritiesOutput, error) {
	req, out := c.ListGroupCertificateAuthoritiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupVersions = "ListGroupVersions"

// ListGroupVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupVersions for more information on using the ListGroupVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupVersionsRequest method.
//    req, resp := client.ListGroupVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions
func (c *Greengrass) ListGroupVersionsRequest(input *ListGroupVersionsInput) (req *request.Request, output *ListGroupVersionsOutput) {
	op := &request.Operation{
		Name:       opListGroupVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/versions",
	}

	if input == nil {
		input = &ListGroupVersionsInput{}
	}

	output = &ListGroupVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupVersions API operation for AWS Greengrass.
//
// Lists the versions of a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListGroupVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions
func (c *Greengrass) ListGroupVersions(input *ListGroupVersionsInput) (*ListGroupVersionsOutput, error) {
	req, out := c.ListGroupVersionsRequest(input)
	return out, req.Send()
}

// ListGroupVersionsWithContext is the same as ListGroupVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListGroupVersionsWithContext(ctx aws.Context, input *ListGroupVersionsInput, opts ...request.Option) (*ListGroupVersionsOutput, error) {
	req, out := c.ListGroupVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups
func (c *Greengrass) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups",
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for AWS Greengrass.
//
// Retrieves a list of groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups
func (c *Greengrass) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoggerDefinitionVersions = "ListLoggerDefinitionVersions"

// ListLoggerDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoggerDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoggerDefinitionVersions for more information on using the ListLoggerDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLoggerDefinitionVersionsRequest method.
//    req, resp := client.ListLoggerDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions
func (c *Greengrass) ListLoggerDefinitionVersionsRequest(input *ListLoggerDefinitionVersionsInput) (req *request.Request, output *ListLoggerDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListLoggerDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}/versions",
	}

	if input == nil {
		input = &ListLoggerDefinitionVersionsInput{}
	}

	output = &ListLoggerDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoggerDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a logger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListLoggerDefinitionVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions
func (c *Greengrass) ListLoggerDefinitionVersions(input *ListLoggerDefinitionVersionsInput) (*ListLoggerDefinitionVersionsOutput, error) {
	req, out := c.ListLoggerDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListLoggerDefinitionVersionsWithContext is the same as ListLoggerDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoggerDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListLoggerDefinitionVersionsWithContext(ctx aws.Context, input *ListLoggerDefinitionVersionsInput, opts ...request.Option) (*ListLoggerDefinitionVersionsOutput, error) {
	req, out := c.ListLoggerDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoggerDefinitions = "ListLoggerDefinitions"

// ListLoggerDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoggerDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoggerDefinitions for more information on using the ListLoggerDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLoggerDefinitionsRequest method.
//    req, resp := client.ListLoggerDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions
func (c *Greengrass) ListLoggerDefinitionsRequest(input *ListLoggerDefinitionsInput) (req *request.Request, output *ListLoggerDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListLoggerDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers",
	}

	if input == nil {
		input = &ListLoggerDefinitionsInput{}
	}

	output = &ListLoggerDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoggerDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of logger definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListLoggerDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions
func (c *Greengrass) ListLoggerDefinitions(input *ListLoggerDefinitionsInput) (*ListLoggerDefinitionsOutput, error) {
	req, out := c.ListLoggerDefinitionsRequest(input)
	return out, req.Send()
}

// ListLoggerDefinitionsWithContext is the same as ListLoggerDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoggerDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListLoggerDefinitionsWithContext(ctx aws.Context, input *ListLoggerDefinitionsInput, opts ...request.Option) (*ListLoggerDefinitionsOutput, error) {
	req, out := c.ListLoggerDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceDefinitionVersions = "ListResourceDefinitionVersions"

// ListResourceDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceDefinitionVersions for more information on using the ListResourceDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceDefinitionVersionsRequest method.
//    req, resp := client.ListResourceDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions
func (c *Greengrass) ListResourceDefinitionVersionsRequest(input *ListResourceDefinitionVersionsInput) (req *request.Request, output *ListResourceDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListResourceDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}/versions",
	}

	if input == nil {
		input = &ListResourceDefinitionVersionsInput{}
	}

	output = &ListResourceDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a resource definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListResourceDefinitionVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions
func (c *Greengrass) ListResourceDefinitionVersions(input *ListResourceDefinitionVersionsInput) (*ListResourceDefinitionVersionsOutput, error) {
	req, out := c.ListResourceDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListResourceDefinitionVersionsWithContext is the same as ListResourceDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListResourceDefinitionVersionsWithContext(ctx aws.Context, input *ListResourceDefinitionVersionsInput, opts ...request.Option) (*ListResourceDefinitionVersionsOutput, error) {
	req, out := c.ListResourceDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceDefinitions = "ListResourceDefinitions"

// ListResourceDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceDefinitions for more information on using the ListResourceDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceDefinitionsRequest method.
//    req, resp := client.ListResourceDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions
func (c *Greengrass) ListResourceDefinitionsRequest(input *ListResourceDefinitionsInput) (req *request.Request, output *ListResourceDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListResourceDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources",
	}

	if input == nil {
		input = &ListResourceDefinitionsInput{}
	}

	output = &ListResourceDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of resource definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListResourceDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions
func (c *Greengrass) ListResourceDefinitions(input *ListResourceDefinitionsInput) (*ListResourceDefinitionsOutput, error) {
	req, out := c.ListResourceDefinitionsRequest(input)
	return out, req.Send()
}

// ListResourceDefinitionsWithContext is the same as ListResourceDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListResourceDefinitionsWithContext(ctx aws.Context, input *ListResourceDefinitionsInput, opts ...request.Option) (*ListResourceDefinitionsOutput, error) {
	req, out := c.ListResourceDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSubscriptionDefinitionVersions = "ListSubscriptionDefinitionVersions"

// ListSubscriptionDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptionDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscriptionDefinitionVersions for more information on using the ListSubscriptionDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSubscriptionDefinitionVersionsRequest method.
//    req, resp := client.ListSubscriptionDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions
func (c *Greengrass) ListSubscriptionDefinitionVersionsRequest(input *ListSubscriptionDefinitionVersionsInput) (req *request.Request, output *ListSubscriptionDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions",
	}

	if input == nil {
		input = &ListSubscriptionDefinitionVersionsInput{}
	}

	output = &ListSubscriptionDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptionDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a subscription definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListSubscriptionDefinitionVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions
func (c *Greengrass) ListSubscriptionDefinitionVersions(input *ListSubscriptionDefinitionVersionsInput) (*ListSubscriptionDefinitionVersionsOutput, error) {
	req, out := c.ListSubscriptionDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListSubscriptionDefinitionVersionsWithContext is the same as ListSubscriptionDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscriptionDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListSubscriptionDefinitionVersionsWithContext(ctx aws.Context, input *ListSubscriptionDefinitionVersionsInput, opts ...request.Option) (*ListSubscriptionDefinitionVersionsOutput, error) {
	req, out := c.ListSubscriptionDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSubscriptionDefinitions = "ListSubscriptionDefinitions"

// ListSubscriptionDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptionDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscriptionDefinitions for more information on using the ListSubscriptionDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSubscriptionDefinitionsRequest method.
//    req, resp := client.ListSubscriptionDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions
func (c *Greengrass) ListSubscriptionDefinitionsRequest(input *ListSubscriptionDefinitionsInput) (req *request.Request, output *ListSubscriptionDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/subscriptions",
	}

	if input == nil {
		input = &ListSubscriptionDefinitionsInput{}
	}

	output = &ListSubscriptionDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptionDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of subscription definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListSubscriptionDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions
func (c *Greengrass) ListSubscriptionDefinitions(input *ListSubscriptionDefinitionsInput) (*ListSubscriptionDefinitionsOutput, error) {
	req, out := c.ListSubscriptionDefinitionsRequest(input)
	return out, req.Send()
}

// ListSubscriptionDefinitionsWithContext is the same as ListSubscriptionDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscriptionDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListSubscriptionDefinitionsWithContext(ctx aws.Context, input *ListSubscriptionDefinitionsInput, opts ...request.Option) (*ListSubscriptionDefinitionsOutput, error) {
	req, out := c.ListSubscriptionDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListTagsForResource
func (c *Greengrass) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Greengrass.
//
// Retrieves a list of resource tags for a resource arn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListTagsForResource
func (c *Greengrass) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDeployments = "ResetDeployments"

// ResetDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ResetDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDeployments for more information on using the ResetDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDeploymentsRequest method.
//    req, resp := client.ResetDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments
func (c *Greengrass) ResetDeploymentsRequest(input *ResetDeploymentsInput) (req *request.Request, output *ResetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opResetDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups/{GroupId}/deployments/$reset",
	}

	if input == nil {
		input = &ResetDeploymentsInput{}
	}

	output = &ResetDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDeployments API operation for AWS Greengrass.
//
// Resets a group's deployments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ResetDeployments for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments
func (c *Greengrass) ResetDeployments(input *ResetDeploymentsInput) (*ResetDeploymentsOutput, error) {
	req, out := c.ResetDeploymentsRequest(input)
	return out, req.Send()
}

// ResetDeploymentsWithContext is the same as ResetDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ResetDeploymentsWithContext(ctx aws.Context, input *ResetDeploymentsInput, opts ...request.Option) (*ResetDeploymentsOutput, error) {
	req, out := c.ResetDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartBulkDeployment = "StartBulkDeployment"

// StartBulkDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StartBulkDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartBulkDeployment for more information on using the StartBulkDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartBulkDeploymentRequest method.
//    req, resp := client.StartBulkDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment
func (c *Greengrass) StartBulkDeploymentRequest(input *StartBulkDeploymentInput) (req *request.Request, output *StartBulkDeploymentOutput) {
	op := &request.Operation{
		Name:       opStartBulkDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/bulk/deployments",
	}

	if input == nil {
		input = &StartBulkDeploymentInput{}
	}

	output = &StartBulkDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBulkDeployment API operation for AWS Greengrass.
//
// Deploys multiple groups in one operation. This action starts the bulk deployment
// of a specified set of group versions. Each group version deployment will
// be triggered with an adaptive rate that has a fixed upper limit. We recommend
// that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment''
// request. These requests are idempotent with respect to the token and the
// request parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation StartBulkDeployment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment
func (c *Greengrass) StartBulkDeployment(input *StartBulkDeploymentInput) (*StartBulkDeploymentOutput, error) {
	req, out := c.StartBulkDeploymentRequest(input)
	return out, req.Send()
}

// StartBulkDeploymentWithContext is the same as StartBulkDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StartBulkDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) StartBulkDeploymentWithContext(ctx aws.Context, input *StartBulkDeploymentInput, opts ...request.Option) (*StartBulkDeploymentOutput, error) {
	req, out := c.StartBulkDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopBulkDeployment = "StopBulkDeployment"

// StopBulkDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StopBulkDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopBulkDeployment for more information on using the StopBulkDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopBulkDeploymentRequest method.
//    req, resp := client.StopBulkDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment
func (c *Greengrass) StopBulkDeploymentRequest(input *StopBulkDeploymentInput) (req *request.Request, output *StopBulkDeploymentOutput) {
	op := &request.Operation{
		Name:       opStopBulkDeployment,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/bulk/deployments/{BulkDeploymentId}/$stop",
	}

	if input == nil {
		input = &StopBulkDeploymentInput{}
	}

	output = &StopBulkDeploymentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopBulkDeployment API operation for AWS Greengrass.
//
// Stops the execution of a bulk deployment. This action returns a status of
// ''Stopping'' until the deployment is stopped. You cannot start a new bulk
// deployment while a previous deployment is in the ''Stopping'' state. This
// action doesn't rollback completed deployments or cancel pending deployments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation StopBulkDeployment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment
func (c *Greengrass) StopBulkDeployment(input *StopBulkDeploymentInput) (*StopBulkDeploymentOutput, error) {
	req, out := c.StopBulkDeploymentRequest(input)
	return out, req.Send()
}

// StopBulkDeploymentWithContext is the same as StopBulkDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StopBulkDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) StopBulkDeploymentWithContext(ctx aws.Context, input *StopBulkDeploymentInput, opts ...request.Option) (*StopBulkDeploymentOutput, error) {
	req, out := c.StopBulkDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/TagResource
func (c *Greengrass) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Greengrass.
//
// Adds tags to a Greengrass resource. Valid resources are 'Group', 'ConnectorDefinition',
// 'CoreDefinition', 'DeviceDefinition', 'FunctionDefinition', 'LoggerDefinition',
// 'SubscriptionDefinition', 'ResourceDefinition', and 'BulkDeployment'.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/TagResource
func (c *Greengrass) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UntagResource
func (c *Greengrass) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Greengrass.
//
// Remove resource tags from a Greengrass Resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UntagResource
func (c *Greengrass) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectivityInfo = "UpdateConnectivityInfo"

// UpdateConnectivityInfoRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectivityInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectivityInfo for more information on using the UpdateConnectivityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectivityInfoRequest method.
//    req, resp := client.UpdateConnectivityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo
func (c *Greengrass) UpdateConnectivityInfoRequest(input *UpdateConnectivityInfoInput) (req *request.Request, output *UpdateConnectivityInfoOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectivityInfo,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/things/{ThingName}/connectivityInfo",
	}

	if input == nil {
		input = &UpdateConnectivityInfoInput{}
	}

	output = &UpdateConnectivityInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConnectivityInfo API operation for AWS Greengrass.
//
// Updates the connectivity information for the core. Any devices that belong
// to the group which has this core will receive this information in order to
// find the location of the core and connect to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateConnectivityInfo for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo
func (c *Greengrass) UpdateConnectivityInfo(input *UpdateConnectivityInfoInput) (*UpdateConnectivityInfoOutput, error) {
	req, out := c.UpdateConnectivityInfoRequest(input)
	return out, req.Send()
}

// UpdateConnectivityInfoWithContext is the same as UpdateConnectivityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectivityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateConnectivityInfoWithContext(ctx aws.Context, input *UpdateConnectivityInfoInput, opts ...request.Option) (*UpdateConnectivityInfoOutput, error) {
	req, out := c.UpdateConnectivityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectorDefinition = "UpdateConnectorDefinition"

// UpdateConnectorDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectorDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectorDefinition for more information on using the UpdateConnectorDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectorDefinitionRequest method.
//    req, resp := client.UpdateConnectorDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition
func (c *Greengrass) UpdateConnectorDefinitionRequest(input *UpdateConnectorDefinitionInput) (req *request.Request, output *UpdateConnectorDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectorDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}",
	}

	if input == nil {
		input = &UpdateConnectorDefinitionInput{}
	}

	output = &UpdateConnectorDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConnectorDefinition API operation for AWS Greengrass.
//
// Updates a connector definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateConnectorDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition
func (c *Greengrass) UpdateConnectorDefinition(input *UpdateConnectorDefinitionInput) (*UpdateConnectorDefinitionOutput, error) {
	req, out := c.UpdateConnectorDefinitionRequest(input)
	return out, req.Send()
}

// UpdateConnectorDefinitionWithContext is the same as UpdateConnectorDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectorDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateConnectorDefinitionWithContext(ctx aws.Context, input *UpdateConnectorDefinitionInput, opts ...request.Option) (*UpdateConnectorDefinitionOutput, error) {
	req, out := c.UpdateConnectorDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCoreDefinition = "UpdateCoreDefinition"

// UpdateCoreDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCoreDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCoreDefinition for more information on using the UpdateCoreDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCoreDefinitionRequest method.
//    req, resp := client.UpdateCoreDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition
func (c *Greengrass) UpdateCoreDefinitionRequest(input *UpdateCoreDefinitionInput) (req *request.Request, output *UpdateCoreDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateCoreDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}",
	}

	if input == nil {
		input = &UpdateCoreDefinitionInput{}
	}

	output = &UpdateCoreDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCoreDefinition API operation for AWS Greengrass.
//
// Updates a core definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateCoreDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition
func (c *Greengrass) UpdateCoreDefinition(input *UpdateCoreDefinitionInput) (*UpdateCoreDefinitionOutput, error) {
	req, out := c.UpdateCoreDefinitionRequest(input)
	return out, req.Send()
}

// UpdateCoreDefinitionWithContext is the same as UpdateCoreDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCoreDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateCoreDefinitionWithContext(ctx aws.Context, input *UpdateCoreDefinitionInput, opts ...request.Option) (*UpdateCoreDefinitionOutput, error) {
	req, out := c.UpdateCoreDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeviceDefinition = "UpdateDeviceDefinition"

// UpdateDeviceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeviceDefinition for more information on using the UpdateDeviceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceDefinitionRequest method.
//    req, resp := client.UpdateDeviceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition
func (c *Greengrass) UpdateDeviceDefinitionRequest(input *UpdateDeviceDefinitionInput) (req *request.Request, output *UpdateDeviceDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}",
	}

	if input == nil {
		input = &UpdateDeviceDefinitionInput{}
	}

	output = &UpdateDeviceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDeviceDefinition API operation for AWS Greengrass.
//
// Updates a device definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateDeviceDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition
func (c *Greengrass) UpdateDeviceDefinition(input *UpdateDeviceDefinitionInput) (*UpdateDeviceDefinitionOutput, error) {
	req, out := c.UpdateDeviceDefinitionRequest(input)
	return out, req.Send()
}

// UpdateDeviceDefinitionWithContext is the same as UpdateDeviceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeviceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateDeviceDefinitionWithContext(ctx aws.Context, input *UpdateDeviceDefinitionInput, opts ...request.Option) (*UpdateDeviceDefinitionOutput, error) {
	req, out := c.UpdateDeviceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFunctionDefinition = "UpdateFunctionDefinition"

// UpdateFunctionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFunctionDefinition for more information on using the UpdateFunctionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFunctionDefinitionRequest method.
//    req, resp := client.UpdateFunctionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition
func (c *Greengrass) UpdateFunctionDefinitionRequest(input *UpdateFunctionDefinitionInput) (req *request.Request, output *UpdateFunctionDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateFunctionDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}",
	}

	if input == nil {
		input = &UpdateFunctionDefinitionInput{}
	}

	output = &UpdateFunctionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFunctionDefinition API operation for AWS Greengrass.
//
// Updates a Lambda function definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateFunctionDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition
func (c *Greengrass) UpdateFunctionDefinition(input *UpdateFunctionDefinitionInput) (*UpdateFunctionDefinitionOutput, error) {
	req, out := c.UpdateFunctionDefinitionRequest(input)
	return out, req.Send()
}

// UpdateFunctionDefinitionWithContext is the same as UpdateFunctionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFunctionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateFunctionDefinitionWithContext(ctx aws.Context, input *UpdateFunctionDefinitionInput, opts ...request.Option) (*UpdateFunctionDefinitionOutput, error) {
	req, out := c.UpdateFunctionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup
func (c *Greengrass) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/groups/{GroupId}",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGroup API operation for AWS Greengrass.
//
// Updates a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup
func (c *Greengrass) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroupCertificateConfiguration = "UpdateGroupCertificateConfiguration"

// UpdateGroupCertificateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroupCertificateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroupCertificateConfiguration for more information on using the UpdateGroupCertificateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupCertificateConfigurationRequest method.
//    req, resp := client.UpdateGroupCertificateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration
func (c *Greengrass) UpdateGroupCertificateConfigurationRequest(input *UpdateGroupCertificateConfigurationInput) (req *request.Request, output *UpdateGroupCertificateConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateGroupCertificateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities/configuration/expiry",
	}

	if input == nil {
		input = &UpdateGroupCertificateConfigurationInput{}
	}

	output = &UpdateGroupCertificateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroupCertificateConfiguration API operation for AWS Greengrass.
//
// Updates the Certificate expiry time for a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateGroupCertificateConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
//   * InternalServerErrorException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration
func (c *Greengrass) UpdateGroupCertificateConfiguration(input *UpdateGroupCertificateConfigurationInput) (*UpdateGroupCertificateConfigurationOutput, error) {
	req, out := c.UpdateGroupCertificateConfigurationRequest(input)
	return out, req.Send()
}

// UpdateGroupCertificateConfigurationWithContext is the same as UpdateGroupCertificateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroupCertificateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateGroupCertificateConfigurationWithContext(ctx aws.Context, input *UpdateGroupCertificateConfigurationInput, opts ...request.Option) (*UpdateGroupCertificateConfigurationOutput, error) {
	req, out := c.UpdateGroupCertificateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLoggerDefinition = "UpdateLoggerDefinition"

// UpdateLoggerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLoggerDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLoggerDefinition for more information on using the UpdateLoggerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLoggerDefinitionRequest method.
//    req, resp := client.UpdateLoggerDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition
func (c *Greengrass) UpdateLoggerDefinitionRequest(input *UpdateLoggerDefinitionInput) (req *request.Request, output *UpdateLoggerDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateLoggerDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}",
	}

	if input == nil {
		input = &UpdateLoggerDefinitionInput{}
	}

	output = &UpdateLoggerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLoggerDefinition API operation for AWS Greengrass.
//
// Updates a logger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateLoggerDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition
func (c *Greengrass) UpdateLoggerDefinition(input *UpdateLoggerDefinitionInput) (*UpdateLoggerDefinitionOutput, error) {
	req, out := c.UpdateLoggerDefinitionRequest(input)
	return out, req.Send()
}

// UpdateLoggerDefinitionWithContext is the same as UpdateLoggerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLoggerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateLoggerDefinitionWithContext(ctx aws.Context, input *UpdateLoggerDefinitionInput, opts ...request.Option) (*UpdateLoggerDefinitionOutput, error) {
	req, out := c.UpdateLoggerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceDefinition = "UpdateResourceDefinition"

// UpdateResourceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceDefinition for more information on using the UpdateResourceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceDefinitionRequest method.
//    req, resp := client.UpdateResourceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition
func (c *Greengrass) UpdateResourceDefinitionRequest(input *UpdateResourceDefinitionInput) (req *request.Request, output *UpdateResourceDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}",
	}

	if input == nil {
		input = &UpdateResourceDefinitionInput{}
	}

	output = &UpdateResourceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResourceDefinition API operation for AWS Greengrass.
//
// Updates a resource definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateResourceDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition
func (c *Greengrass) UpdateResourceDefinition(input *UpdateResourceDefinitionInput) (*UpdateResourceDefinitionOutput, error) {
	req, out := c.UpdateResourceDefinitionRequest(input)
	return out, req.Send()
}

// UpdateResourceDefinitionWithContext is the same as UpdateResourceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateResourceDefinitionWithContext(ctx aws.Context, input *UpdateResourceDefinitionInput, opts ...request.Option) (*UpdateResourceDefinitionOutput, error) {
	req, out := c.UpdateResourceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriptionDefinition = "UpdateSubscriptionDefinition"

// UpdateSubscriptionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriptionDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriptionDefinition for more information on using the UpdateSubscriptionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSubscriptionDefinitionRequest method.
//    req, resp := client.UpdateSubscriptionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition
func (c *Greengrass) UpdateSubscriptionDefinitionRequest(input *UpdateSubscriptionDefinitionInput) (req *request.Request, output *UpdateSubscriptionDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriptionDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
	}

	if input == nil {
		input = &UpdateSubscriptionDefinitionInput{}
	}

	output = &UpdateSubscriptionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSubscriptionDefinition API operation for AWS Greengrass.
//
// Updates a subscription definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateSubscriptionDefinition for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   General error information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition
func (c *Greengrass) UpdateSubscriptionDefinition(input *UpdateSubscriptionDefinitionInput) (*UpdateSubscriptionDefinitionOutput, error) {
	req, out := c.UpdateSubscriptionDefinitionRequest(input)
	return out, req.Send()
}

// UpdateSubscriptionDefinitionWithContext is the same as UpdateSubscriptionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriptionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateSubscriptionDefinitionWithContext(ctx aws.Context, input *UpdateSubscriptionDefinitionInput, opts ...request.Option) (*UpdateSubscriptionDefinitionOutput, error) {
	req, out := c.UpdateSubscriptionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateRoleToGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	// The ARN of the role you wish to associate with this group. The existence
	// of the role is not validated.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateRoleToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRoleToGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateRoleToGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateRoleToGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AssociateRoleToGroupInput) SetGroupId(v string) *AssociateRoleToGroupInput {
	s.GroupId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AssociateRoleToGroupInput) SetRoleArn(v string) *AssociateRoleToGroupInput {
	s.RoleArn = &v
	return s
}

type AssociateRoleToGroupOutput struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds since the epoch, when the role ARN was associated
	// with the group.
	AssociatedAt *string `type:"string"`
}

// String returns the string representation
func (s AssociateRoleToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRoleToGroupOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *AssociateRoleToGroupOutput) SetAssociatedAt(v string) *AssociateRoleToGroupOutput {
	s.AssociatedAt = &v
	return s
}

type AssociateServiceRoleToAccountInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the service role you wish to associate with your account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateServiceRoleToAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateServiceRoleToAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateServiceRoleToAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateServiceRoleToAccountInput"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *AssociateServiceRoleToAccountInput) SetRoleArn(v string) *AssociateServiceRoleToAccountInput {
	s.RoleArn = &v
	return s
}

type AssociateServiceRoleToAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time when the service role was associated with the account.
	AssociatedAt *string `type:"string"`
}

// String returns the string representation
func (s AssociateServiceRoleToAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateServiceRoleToAccountOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *AssociateServiceRoleToAccountOutput) SetAssociatedAt(v string) *AssociateServiceRoleToAccountOutput {
	s.AssociatedAt = &v
	return s
}

// General error information.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of error details.
	ErrorDetails []*ErrorDetail `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a bulk deployment. You cannot start a new bulk deployment
// while another one is still running or in a non-terminal state.
type BulkDeployment struct {
	_ struct{} `type:"structure"`

	// The ARN of the bulk deployment.
	BulkDeploymentArn *string `type:"string"`

	// The ID of the bulk deployment.
	BulkDeploymentId *string `type:"string"`

	// The time, in ISO format, when the deployment was created.
	CreatedAt *string `type:"string"`
}

// String returns the string representation
func (s BulkDeployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BulkDeployment) GoString() string {
	return s.String()
}

// SetBulkDeploymentArn sets the BulkDeploymentArn field's value.
func (s *BulkDeployment) SetBulkDeploymentArn(v string) *BulkDeployment {
	s.BulkDeploymentArn = &v
	return s
}

// SetBulkDeploymentId sets the BulkDeploymentId field's value.
func (s *BulkDeployment) SetBulkDeploymentId(v string) *BulkDeployment {
	s.BulkDeploymentId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *BulkDeployment) SetCreatedAt(v string) *BulkDeployment {
	s.CreatedAt = &v
	return s
}

// Relevant metrics on input records processed during bulk deployment.
type BulkDeploymentMetrics struct {
	_ struct{} `type:"structure"`

	// The total number of records that returned a non-retryable error. For example,
	// this can occur if a group record from the input file uses an invalid format
	// or specifies a nonexistent group version, or if the execution role doesn't
	// grant permission to deploy a group or group version.
	InvalidInputRecords *int64 `type:"integer"`

	// The total number of group records from the input file that have been processed
	// so far, or attempted.
	RecordsProcessed *int64 `type:"integer"`

	// The total number of deployment attempts that returned a retryable error.
	// For example, a retry is triggered if the attempt to deploy a group returns
	// a throttling error. ''StartBulkDeployment'' retries a group deployment up
	// to five times.
	RetryAttempts *int64 `type:"integer"`
}

// String returns the string representation
func (s BulkDeploymentMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BulkDeploymentMetrics) GoString() string {
	return s.String()
}

// SetInvalidInputRecords sets the InvalidInputRecords field's value.
func (s *BulkDeploymentMetrics) SetInvalidInputRecords(v int64) *BulkDeploymentMetrics {
	s.InvalidInputRecords = &v
	return s
}

// SetRecordsProcessed sets the RecordsProcessed field's value.
func (s *BulkDeploymentMetrics) SetRecordsProcessed(v int64) *BulkDeploymentMetrics {
	s.RecordsProcessed = &v
	return s
}

// SetRetryAttempts sets the RetryAttempts field's value.
func (s *BulkDeploymentMetrics) SetRetryAttempts(v int64) *BulkDeploymentMetrics {
	s.RetryAttempts = &v
	return s
}

// Information about an individual group deployment in a bulk deployment operation.
type BulkDeploymentResult struct {
	_ struct{} `type:"structure"`

	// The time, in ISO format, when the deployment was created.
	CreatedAt *string `type:"string"`

	// The ARN of the group deployment.
	DeploymentArn *string `type:"string"`

	// The ID of the group deployment.
	DeploymentId *string `type:"string"`

	// The current status of the group deployment: ''InProgress'', ''Building'',
	// ''Success'', or ''Failure''.
	DeploymentStatus *string `type:"string"`

	// The type of the deployment.
	DeploymentType *string `type:"string" enum:"DeploymentType"`

	// Details about the error.
	ErrorDetails []*ErrorDetail `type:"list"`

	// The error message for a failed deployment
	ErrorMessage *string `type:"string"`

	// The ARN of the Greengrass group.
	GroupArn *string `type:"string"`
}

// String returns the string representation
func (s BulkDeploymentResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BulkDeploymentResult) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *BulkDeploymentResult) SetCreatedAt(v string) *BulkDeploymentResult {
	s.CreatedAt = &v
	return s
}

// SetDeploymentArn sets the DeploymentArn field's value.
func (s *BulkDeploymentResult) SetDeploymentArn(v string) *BulkDeploymentResult {
	s.DeploymentArn = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *BulkDeploymentResult) SetDeploymentId(v string) *BulkDeploymentResult {
	s.DeploymentId = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *BulkDeploymentResult) SetDeploymentStatus(v string) *BulkDeploymentResult {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *BulkDeploymentResult) SetDeploymentType(v string) *BulkDeploymentResult {
	s.DeploymentType = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *BulkDeploymentResult) SetErrorDetails(v []*ErrorDetail) *BulkDeploymentResult {
	s.ErrorDetails = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BulkDeploymentResult) SetErrorMessage(v string) *BulkDeploymentResult {
	s.ErrorMessage = &v
	return s
}

// SetGroupArn sets the GroupArn field's value.
func (s *BulkDeploymentResult) SetGroupArn(v string) *BulkDeploymentResult {
	s.GroupArn = &v
	return s
}

// Information about a Greengrass core's connectivity.
type ConnectivityInfo struct {
	_ struct{} `type:"structure"`

	// The endpoint for the Greengrass core. Can be an IP address or DNS.
	HostAddress *string `type:"string"`

	// The ID of the connectivity information.
	Id *string `type:"string"`

	// Metadata for this endpoint.
	Metadata *string `type:"string"`

	// The port of the Greengrass core. Usually 8883.
	PortNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s ConnectivityInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectivityInfo) GoString() string {
	return s.String()
}

// SetHostAddress sets the HostAddress field's value.
func (s *ConnectivityInfo) SetHostAddress(v string) *ConnectivityInfo {
	s.HostAddress = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConnectivityInfo) SetId(v string) *ConnectivityInfo {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ConnectivityInfo) SetMetadata(v string) *ConnectivityInfo {
	s.Metadata = &v
	return s
}

// SetPortNumber sets the PortNumber field's value.
func (s *ConnectivityInfo) SetPortNumber(v int64) *ConnectivityInfo {
	s.PortNumber = &v
	return s
}

// Information about a connector. Connectors run on the Greengrass core and
// contain built-in integration with local infrastructure, device protocols,
// AWS, and other cloud services.
type Connector struct {
	_ struct{} `type:"structure"`

	// The ARN of the connector.
	//
	// ConnectorArn is a required field
	ConnectorArn *string `type:"string" required:"true"`

	// A descriptive or arbitrary ID for the connector. This value must be unique
	// within the connector definition version. Max length is 128 characters with
	// pattern [a-zA-Z0-9:_-]+.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The parameters or configuration that the connector uses.
	Parameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s Connector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Connector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Connector"}
	if s.ConnectorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorArn"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorArn sets the ConnectorArn field's value.
func (s *Connector) SetConnectorArn(v string) *Connector {
	s.ConnectorArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Connector) SetId(v string) *Connector {
	s.Id = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Connector) SetParameters(v map[string]*string) *Connector {
	s.Parameters = v
	return s
}

// Information about the connector definition version, which is a container
// for connectors.
type ConnectorDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of references to connectors in this version, with their corresponding
	// configuration settings.
	Connectors []*Connector `type:"list"`
}

// String returns the string representation
func (s ConnectorDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorDefinitionVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectorDefinitionVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectorDefinitionVersion"}
	if s.Connectors != nil {
		for i, v := range s.Connectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Connectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectors sets the Connectors field's value.
func (s *ConnectorDefinitionVersion) SetConnectors(v []*Connector) *ConnectorDefinitionVersion {
	s.Connectors = v
	return s
}

// Information about a core.
type Core struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate associated with the core.
	//
	// CertificateArn is a required field
	CertificateArn *string `type:"string" required:"true"`

	// A descriptive or arbitrary ID for the core. This value must be unique within
	// the core definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If true, the core's local shadow is automatically synced with the cloud.
	SyncShadow *bool `type:"boolean"`

	// The ARN of the thing which is the core.
	//
	// ThingArn is a required field
	ThingArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Core) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Core) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Core) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Core"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ThingArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Core) SetCertificateArn(v string) *Core {
	s.CertificateArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Core) SetId(v string) *Core {
	s.Id = &v
	return s
}

// SetSyncShadow sets the SyncShadow field's value.
func (s *Core) SetSyncShadow(v bool) *Core {
	s.SyncShadow = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *Core) SetThingArn(v string) *Core {
	s.ThingArn = &v
	return s
}

// Information about a core definition version.
type CoreDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of cores in the core definition version.
	Cores []*Core `type:"list"`
}

// String returns the string representation
func (s CoreDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CoreDefinitionVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CoreDefinitionVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CoreDefinitionVersion"}
	if s.Cores != nil {
		for i, v := range s.Cores {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Cores", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCores sets the Cores field's value.
func (s *CoreDefinitionVersion) SetCores(v []*Core) *CoreDefinitionVersion {
	s.Cores = v
	return s
}

type CreateConnectorDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about the connector definition version, which is a container
	// for connectors.
	InitialVersion *ConnectorDefinitionVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateConnectorDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectorDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectorDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectorDefinitionInput"}
	if s.InitialVersion != nil {
		if err := s.InitialVersion.Validate(); err != nil {
			invalidParams.AddNested("InitialVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateConnectorDefinitionInput) SetAmznClientToken(v string) *CreateConnectorDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateConnectorDefinitionInput) SetInitialVersion(v *ConnectorDefinitionVersion) *CreateConnectorDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConnectorDefinitionInput) SetName(v string) *CreateConnectorDefinitionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectorDefinitionInput) SetTags(v map[string]*string) *CreateConnectorDefinitionInput {
	s.Tags = v
	return s
}

type CreateConnectorDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateConnectorDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectorDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateConnectorDefinitionOutput) SetArn(v string) *CreateConnectorDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateConnectorDefinitionOutput) SetCreationTimestamp(v string) *CreateConnectorDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateConnectorDefinitionOutput) SetId(v string) *CreateConnectorDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateConnectorDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateConnectorDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateConnectorDefinitionOutput) SetLatestVersion(v string) *CreateConnectorDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateConnectorDefinitionOutput) SetLatestVersionArn(v string) *CreateConnectorDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConnectorDefinitionOutput) SetName(v string) *CreateConnectorDefinitionOutput {
	s.Name = &v
	return s
}

type CreateConnectorDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`

	Connectors []*Connector `type:"list"`
}

// String returns the string representation
func (s CreateConnectorDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectorDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectorDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectorDefinitionVersionInput"}
	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorDefinitionId"))
	}
	if s.ConnectorDefinitionId != nil && len(*s.ConnectorDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorDefinitionId", 1))
	}
	if s.Connectors != nil {
		for i, v := range s.Connectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Connectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateConnectorDefinitionVersionInput) SetAmznClientToken(v string) *CreateConnectorDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetConnectorDefinitionId sets the ConnectorDefinitionId field's value.
func (s *CreateConnectorDefinitionVersionInput) SetConnectorDefinitionId(v string) *CreateConnectorDefinitionVersionInput {
	s.ConnectorDefinitionId = &v
	return s
}

// SetConnectors sets the Connectors field's value.
func (s *CreateConnectorDefinitionVersionInput) SetConnectors(v []*Connector) *CreateConnectorDefinitionVersionInput {
	s.Connectors = v
	return s
}

type CreateConnectorDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateConnectorDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectorDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateConnectorDefinitionVersionOutput) SetArn(v string) *CreateConnectorDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateConnectorDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateConnectorDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateConnectorDefinitionVersionOutput) SetId(v string) *CreateConnectorDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateConnectorDefinitionVersionOutput) SetVersion(v string) *CreateConnectorDefinitionVersionOutput {
	s.Version = &v
	return s
}

type CreateCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about a core definition version.
	InitialVersion *CoreDefinitionVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCoreDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCoreDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCoreDefinitionInput"}
	if s.InitialVersion != nil {
		if err := s.InitialVersion.Validate(); err != nil {
			invalidParams.AddNested("InitialVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateCoreDefinitionInput) SetAmznClientToken(v string) *CreateCoreDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateCoreDefinitionInput) SetInitialVersion(v *CoreDefinitionVersion) *CreateCoreDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCoreDefinitionInput) SetName(v string) *CreateCoreDefinitionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCoreDefinitionInput) SetTags(v map[string]*string) *CreateCoreDefinitionInput {
	s.Tags = v
	return s
}

type CreateCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCoreDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCoreDefinitionOutput) SetArn(v string) *CreateCoreDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateCoreDefinitionOutput) SetCreationTimestamp(v string) *CreateCoreDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateCoreDefinitionOutput) SetId(v string) *CreateCoreDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateCoreDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateCoreDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateCoreDefinitionOutput) SetLatestVersion(v string) *CreateCoreDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateCoreDefinitionOutput) SetLatestVersionArn(v string) *CreateCoreDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCoreDefinitionOutput) SetName(v string) *CreateCoreDefinitionOutput {
	s.Name = &v
	return s
}

type CreateCoreDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	Cores []*Core `type:"list"`
}

// String returns the string representation
func (s CreateCoreDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCoreDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCoreDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCoreDefinitionVersionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}
	if s.CoreDefinitionId != nil && len(*s.CoreDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDefinitionId", 1))
	}
	if s.Cores != nil {
		for i, v := range s.Cores {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Cores", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateCoreDefinitionVersionInput) SetAmznClientToken(v string) *CreateCoreDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *CreateCoreDefinitionVersionInput) SetCoreDefinitionId(v string) *CreateCoreDefinitionVersionInput {
	s.CoreDefinitionId = &v
	return s
}

// SetCores sets the Cores field's value.
func (s *CreateCoreDefinitionVersionInput) SetCores(v []*Core) *CreateCoreDefinitionVersionInput {
	s.Cores = v
	return s
}

type CreateCoreDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateCoreDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCoreDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCoreDefinitionVersionOutput) SetArn(v string) *CreateCoreDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateCoreDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateCoreDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateCoreDefinitionVersionOutput) SetId(v string) *CreateCoreDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateCoreDefinitionVersionOutput) SetVersion(v string) *CreateCoreDefinitionVersionOutput {
	s.Version = &v
	return s
}

// Information about a deployment.
type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// The ID of the deployment if you wish to redeploy a previous deployment.
	DeploymentId *string `type:"string"`

	// The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment''
	// and ''Redeployment'' are valid.
	//
	// DeploymentType is a required field
	DeploymentType *string `type:"string" required:"true" enum:"DeploymentType"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	// The ID of the group version to be deployed.
	GroupVersionId *string `type:"string"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.DeploymentType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentType"))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateDeploymentInput) SetAmznClientToken(v string) *CreateDeploymentInput {
	s.AmznClientToken = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentInput) SetDeploymentId(v string) *CreateDeploymentInput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *CreateDeploymentInput) SetDeploymentType(v string) *CreateDeploymentInput {
	s.DeploymentType = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateDeploymentInput) SetGroupId(v string) *CreateDeploymentInput {
	s.GroupId = &v
	return s
}

// SetGroupVersionId sets the GroupVersionId field's value.
func (s *CreateDeploymentInput) SetGroupVersionId(v string) *CreateDeploymentInput {
	s.GroupVersionId = &v
	return s
}

type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the deployment.
	DeploymentArn *string `type:"string"`

	// The ID of the deployment.
	DeploymentId *string `type:"string"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentArn sets the DeploymentArn field's value.
func (s *CreateDeploymentOutput) SetDeploymentArn(v string) *CreateDeploymentOutput {
	s.DeploymentArn = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

type CreateDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about a device definition version.
	InitialVersion *DeviceDefinitionVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeviceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeviceDefinitionInput"}
	if s.InitialVersion != nil {
		if err := s.InitialVersion.Validate(); err != nil {
			invalidParams.AddNested("InitialVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateDeviceDefinitionInput) SetAmznClientToken(v string) *CreateDeviceDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateDeviceDefinitionInput) SetInitialVersion(v *DeviceDefinitionVersion) *CreateDeviceDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDeviceDefinitionInput) SetName(v string) *CreateDeviceDefinitionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeviceDefinitionInput) SetTags(v map[string]*string) *CreateDeviceDefinitionInput {
	s.Tags = v
	return s
}

type CreateDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDeviceDefinitionOutput) SetArn(v string) *CreateDeviceDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateDeviceDefinitionOutput) SetCreationTimestamp(v string) *CreateDeviceDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDeviceDefinitionOutput) SetId(v string) *CreateDeviceDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateDeviceDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateDeviceDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateDeviceDefinitionOutput) SetLatestVersion(v string) *CreateDeviceDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateDeviceDefinitionOutput) SetLatestVersionArn(v string) *CreateDeviceDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDeviceDefinitionOutput) SetName(v string) *CreateDeviceDefinitionOutput {
	s.Name = &v
	return s
}

type CreateDeviceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	Devices []*Device `type:"list"`
}

// String returns the string representation
func (s CreateDeviceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeviceDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeviceDefinitionVersionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}
	if s.DeviceDefinitionId != nil && len(*s.DeviceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceDefinitionId", 1))
	}
	if s.Devices != nil {
		for i, v := range s.Devices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Devices", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateDeviceDefinitionVersionInput) SetAmznClientToken(v string) *CreateDeviceDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *CreateDeviceDefinitionVersionInput) SetDeviceDefinitionId(v string) *CreateDeviceDefinitionVersionInput {
	s.DeviceDefinitionId = &v
	return s
}

// SetDevices sets the Devices field's value.
func (s *CreateDeviceDefinitionVersionInput) SetDevices(v []*Device) *CreateDeviceDefinitionVersionInput {
	s.Devices = v
	return s
}

type CreateDeviceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateDeviceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDeviceDefinitionVersionOutput) SetArn(v string) *CreateDeviceDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateDeviceDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateDeviceDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDeviceDefinitionVersionOutput) SetId(v string) *CreateDeviceDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateDeviceDefinitionVersionOutput) SetVersion(v string) *CreateDeviceDefinitionVersionOutput {
	s.Version = &v
	return s
}

type CreateFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about a function definition version.
	InitialVersion *FunctionDefinitionVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFunctionDefinitionInput"}
	if s.InitialVersion != nil {
		if err := s.InitialVersion.Validate(); err != nil {
			invalidParams.AddNested("InitialVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateFunctionDefinitionInput) SetAmznClientToken(v string) *CreateFunctionDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateFunctionDefinitionInput) SetInitialVersion(v *FunctionDefinitionVersion) *CreateFunctionDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFunctionDefinitionInput) SetName(v string) *CreateFunctionDefinitionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFunctionDefinitionInput) SetTags(v map[string]*string) *CreateFunctionDefinitionInput {
	s.Tags = v
	return s
}

type CreateFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFunctionDefinitionOutput) SetArn(v string) *CreateFunctionDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateFunctionDefinitionOutput) SetCreationTimestamp(v string) *CreateFunctionDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFunctionDefinitionOutput) SetId(v string) *CreateFunctionDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateFunctionDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateFunctionDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateFunctionDefinitionOutput) SetLatestVersion(v string) *CreateFunctionDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateFunctionDefinitionOutput) SetLatestVersionArn(v string) *CreateFunctionDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFunctionDefinitionOutput) SetName(v string) *CreateFunctionDefinitionOutput {
	s.Name = &v
	return s
}

type CreateFunctionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// The default configuration that applies to all Lambda functions in the group.
	// Individual Lambda functions can override these settings.
	DefaultConfig *FunctionDefaultConfig `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	Functions []*Function `type:"list"`
}

// String returns the string representation
func (s CreateFunctionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFunctionDefinitionVersionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}
	if s.FunctionDefinitionId != nil && len(*s.FunctionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionDefinitionId", 1))
	}
	if s.Functions != nil {
		for i, v := range s.Functions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Functions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateFunctionDefinitionVersionInput) SetAmznClientToken(v string) *CreateFunctionDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetDefaultConfig sets the DefaultConfig field's value.
func (s *CreateFunctionDefinitionVersionInput) SetDefaultConfig(v *FunctionDefaultConfig) *CreateFunctionDefinitionVersionInput {
	s.DefaultConfig = v
	return s
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *CreateFunctionDefinitionVersionInput) SetFunctionDefinitionId(v string) *CreateFunctionDefinitionVersionInput {
	s.FunctionDefinitionId = &v
	return s
}

// SetFunctions sets the Functions field's value.
func (s *CreateFunctionDefinitionVersionInput) SetFunctions(v []*Function) *CreateFunctionDefinitionVersionInput {
	s.Functions = v
	return s
}

type CreateFunctionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateFunctionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFunctionDefinitionVersionOutput) SetArn(v string) *CreateFunctionDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateFunctionDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateFunctionDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFunctionDefinitionVersionOutput) SetId(v string) *CreateFunctionDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateFunctionDefinitionVersionOutput) SetVersion(v string) *CreateFunctionDefinitionVersionOutput {
	s.Version = &v
	return s
}

type CreateGroupCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupCertificateAuthorityInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateGroupCertificateAuthorityInput) SetAmznClientToken(v string) *CreateGroupCertificateAuthorityInput {
	s.AmznClientToken = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupCertificateAuthorityInput) SetGroupId(v string) *CreateGroupCertificateAuthorityInput {
	s.GroupId = &v
	return s
}

type CreateGroupCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the group certificate authority.
	GroupCertificateAuthorityArn *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetGroupCertificateAuthorityArn sets the GroupCertificateAuthorityArn field's value.
func (s *CreateGroupCertificateAuthorityOutput) SetGroupCertificateAuthorityArn(v string) *CreateGroupCertificateAuthorityOutput {
	s.GroupCertificateAuthorityArn = &v
	return s
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about a group version.
	InitialVersion *GroupVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateGroupInput) SetAmznClientToken(v string) *CreateGroupInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateGroupInput) SetInitialVersion(v *GroupVersion) *CreateGroupInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGroupInput) SetName(v string) *CreateGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGroupInput) SetTags(v map[string]*string) *CreateGroupInput {
	s.Tags = v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateGroupOutput) SetArn(v string) *CreateGroupOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateGroupOutput) SetCreationTimestamp(v string) *CreateGroupOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateGroupOutput) SetId(v string) *CreateGroupOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateGroupOutput) SetLastUpdatedTimestamp(v string) *CreateGroupOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateGroupOutput) SetLatestVersion(v string) *CreateGroupOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateGroupOutput) SetLatestVersionArn(v string) *CreateGroupOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGroupOutput) SetName(v string) *CreateGroupOutput {
	s.Name = &v
	return s
}

type CreateGroupVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	ConnectorDefinitionVersionArn *string `type:"string"`

	CoreDefinitionVersionArn *string `type:"string"`

	DeviceDefinitionVersionArn *string `type:"string"`

	FunctionDefinitionVersionArn *string `type:"string"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	LoggerDefinitionVersionArn *string `type:"string"`

	ResourceDefinitionVersionArn *string `type:"string"`

	SubscriptionDefinitionVersionArn *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupVersionInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateGroupVersionInput) SetAmznClientToken(v string) *CreateGroupVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetConnectorDefinitionVersionArn sets the ConnectorDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetConnectorDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.ConnectorDefinitionVersionArn = &v
	return s
}

// SetCoreDefinitionVersionArn sets the CoreDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetCoreDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.CoreDefinitionVersionArn = &v
	return s
}

// SetDeviceDefinitionVersionArn sets the DeviceDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetDeviceDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.DeviceDefinitionVersionArn = &v
	return s
}

// SetFunctionDefinitionVersionArn sets the FunctionDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetFunctionDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.FunctionDefinitionVersionArn = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupVersionInput) SetGroupId(v string) *CreateGroupVersionInput {
	s.GroupId = &v
	return s
}

// SetLoggerDefinitionVersionArn sets the LoggerDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetLoggerDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.LoggerDefinitionVersionArn = &v
	return s
}

// SetResourceDefinitionVersionArn sets the ResourceDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetResourceDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.ResourceDefinitionVersionArn = &v
	return s
}

// SetSubscriptionDefinitionVersionArn sets the SubscriptionDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetSubscriptionDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.SubscriptionDefinitionVersionArn = &v
	return s
}

type CreateGroupVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateGroupVersionOutput) SetArn(v string) *CreateGroupVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateGroupVersionOutput) SetCreationTimestamp(v string) *CreateGroupVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateGroupVersionOutput) SetId(v string) *CreateGroupVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateGroupVersionOutput) SetVersion(v string) *CreateGroupVersionOutput {
	s.Version = &v
	return s
}

type CreateLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about a logger definition version.
	InitialVersion *LoggerDefinitionVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoggerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoggerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoggerDefinitionInput"}
	if s.InitialVersion != nil {
		if err := s.InitialVersion.Validate(); err != nil {
			invalidParams.AddNested("InitialVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateLoggerDefinitionInput) SetAmznClientToken(v string) *CreateLoggerDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateLoggerDefinitionInput) SetInitialVersion(v *LoggerDefinitionVersion) *CreateLoggerDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLoggerDefinitionInput) SetName(v string) *CreateLoggerDefinitionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLoggerDefinitionInput) SetTags(v map[string]*string) *CreateLoggerDefinitionInput {
	s.Tags = v
	return s
}

type CreateLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoggerDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateLoggerDefinitionOutput) SetArn(v string) *CreateLoggerDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateLoggerDefinitionOutput) SetCreationTimestamp(v string) *CreateLoggerDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateLoggerDefinitionOutput) SetId(v string) *CreateLoggerDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateLoggerDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateLoggerDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateLoggerDefinitionOutput) SetLatestVersion(v string) *CreateLoggerDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateLoggerDefinitionOutput) SetLatestVersionArn(v string) *CreateLoggerDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLoggerDefinitionOutput) SetName(v string) *CreateLoggerDefinitionOutput {
	s.Name = &v
	return s
}

type CreateLoggerDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	Loggers []*Logger `type:"list"`
}

// String returns the string representation
func (s CreateLoggerDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoggerDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoggerDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoggerDefinitionVersionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}
	if s.LoggerDefinitionId != nil && len(*s.LoggerDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoggerDefinitionId", 1))
	}
	if s.Loggers != nil {
		for i, v := range s.Loggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Loggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateLoggerDefinitionVersionInput) SetAmznClientToken(v string) *CreateLoggerDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *CreateLoggerDefinitionVersionInput) SetLoggerDefinitionId(v string) *CreateLoggerDefinitionVersionInput {
	s.LoggerDefinitionId = &v
	return s
}

// SetLoggers sets the Loggers field's value.
func (s *CreateLoggerDefinitionVersionInput) SetLoggers(v []*Logger) *CreateLoggerDefinitionVersionInput {
	s.Loggers = v
	return s
}

type CreateLoggerDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateLoggerDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoggerDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateLoggerDefinitionVersionOutput) SetArn(v string) *CreateLoggerDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateLoggerDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateLoggerDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateLoggerDefinitionVersionOutput) SetId(v string) *CreateLoggerDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateLoggerDefinitionVersionOutput) SetVersion(v string) *CreateLoggerDefinitionVersionOutput {
	s.Version = &v
	return s
}

type CreateResourceDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about a resource definition version.
	InitialVersion *ResourceDefinitionVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateResourceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceDefinitionInput"}
	if s.InitialVersion != nil {
		if err := s.InitialVersion.Validate(); err != nil {
			invalidParams.AddNested("InitialVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateResourceDefinitionInput) SetAmznClientToken(v string) *CreateResourceDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateResourceDefinitionInput) SetInitialVersion(v *ResourceDefinitionVersion) *CreateResourceDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceDefinitionInput) SetName(v string) *CreateResourceDefinitionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResourceDefinitionInput) SetTags(v map[string]*string) *CreateResourceDefinitionInput {
	s.Tags = v
	return s
}

type CreateResourceDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateResourceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateResourceDefinitionOutput) SetArn(v string) *CreateResourceDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateResourceDefinitionOutput) SetCreationTimestamp(v string) *CreateResourceDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateResourceDefinitionOutput) SetId(v string) *CreateResourceDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateResourceDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateResourceDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateResourceDefinitionOutput) SetLatestVersion(v string) *CreateResourceDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateResourceDefinitionOutput) SetLatestVersionArn(v string) *CreateResourceDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceDefinitionOutput) SetName(v string) *CreateResourceDefinitionOutput {
	s.Name = &v
	return s
}

type CreateResourceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`

	Resources []*Resource `type:"list"`
}

// String returns the string representation
func (s CreateResourceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceDefinitionVersionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}
	if s.ResourceDefinitionId != nil && len(*s.ResourceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceDefinitionId", 1))
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateResourceDefinitionVersionInput) SetAmznClientToken(v string) *CreateResourceDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *CreateResourceDefinitionVersionInput) SetResourceDefinitionId(v string) *CreateResourceDefinitionVersionInput {
	s.ResourceDefinitionId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateResourceDefinitionVersionInput) SetResources(v []*Resource) *CreateResourceDefinitionVersionInput {
	s.Resources = v
	return s
}

type CreateResourceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateResourceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateResourceDefinitionVersionOutput) SetArn(v string) *CreateResourceDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateResourceDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateResourceDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateResourceDefinitionVersionOutput) SetId(v string) *CreateResourceDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateResourceDefinitionVersionOutput) SetVersion(v string) *CreateResourceDefinitionVersionOutput {
	s.Version = &v
	return s
}

// Request for the CreateSoftwareUpdateJob API.
type CreateSoftwareUpdateJobInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// The IAM Role that Greengrass will use to create pre-signed URLs pointing
	// towards the update artifact.
	//
	// S3UrlSignerRole is a required field
	S3UrlSignerRole *string `type:"string" required:"true"`

	// The piece of software on the Greengrass core that will be updated.
	//
	// SoftwareToUpdate is a required field
	SoftwareToUpdate *string `type:"string" required:"true" enum:"SoftwareToUpdate"`

	// The minimum level of log statements that should be logged by the OTA Agent
	// during an update.
	UpdateAgentLogLevel *string `type:"string" enum:"UpdateAgentLogLevel"`

	// The ARNs of the targets (IoT things or IoT thing groups) that this update
	// will be applied to.
	//
	// UpdateTargets is a required field
	UpdateTargets []*string `type:"list" required:"true"`

	// The architecture of the cores which are the targets of an update.
	//
	// UpdateTargetsArchitecture is a required field
	UpdateTargetsArchitecture *string `type:"string" required:"true" enum:"UpdateTargetsArchitecture"`

	// The operating system of the cores which are the targets of an update.
	//
	// UpdateTargetsOperatingSystem is a required field
	UpdateTargetsOperatingSystem *string `type:"string" required:"true" enum:"UpdateTargetsOperatingSystem"`
}

// String returns the string representation
func (s CreateSoftwareUpdateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSoftwareUpdateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSoftwareUpdateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSoftwareUpdateJobInput"}
	if s.S3UrlSignerRole == nil {
		invalidParams.Add(request.NewErrParamRequired("S3UrlSignerRole"))
	}
	if s.SoftwareToUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("SoftwareToUpdate"))
	}
	if s.UpdateTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateTargets"))
	}
	if s.UpdateTargetsArchitecture == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateTargetsArchitecture"))
	}
	if s.UpdateTargetsOperatingSystem == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateTargetsOperatingSystem"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateSoftwareUpdateJobInput) SetAmznClientToken(v string) *CreateSoftwareUpdateJobInput {
	s.AmznClientToken = &v
	return s
}

// SetS3UrlSignerRole sets the S3UrlSignerRole field's value.
func (s *CreateSoftwareUpdateJobInput) SetS3UrlSignerRole(v string) *CreateSoftwareUpdateJobInput {
	s.S3UrlSignerRole = &v
	return s
}

// SetSoftwareToUpdate sets the SoftwareToUpdate field's value.
func (s *CreateSoftwareUpdateJobInput) SetSoftwareToUpdate(v string) *CreateSoftwareUpdateJobInput {
	s.SoftwareToUpdate = &v
	return s
}

// SetUpdateAgentLogLevel sets the UpdateAgentLogLevel field's value.
func (s *CreateSoftwareUpdateJobInput) SetUpdateAgentLogLevel(v string) *CreateSoftwareUpdateJobInput {
	s.UpdateAgentLogLevel = &v
	return s
}

// SetUpdateTargets sets the UpdateTargets field's value.
func (s *CreateSoftwareUpdateJobInput) SetUpdateTargets(v []*string) *CreateSoftwareUpdateJobInput {
	s.UpdateTargets = v
	return s
}

// SetUpdateTargetsArchitecture sets the UpdateTargetsArchitecture field's value.
func (s *CreateSoftwareUpdateJobInput) SetUpdateTargetsArchitecture(v string) *CreateSoftwareUpdateJobInput {
	s.UpdateTargetsArchitecture = &v
	return s
}

// SetUpdateTargetsOperatingSystem sets the UpdateTargetsOperatingSystem field's value.
func (s *CreateSoftwareUpdateJobInput) SetUpdateTargetsOperatingSystem(v string) *CreateSoftwareUpdateJobInput {
	s.UpdateTargetsOperatingSystem = &v
	return s
}

type CreateSoftwareUpdateJobOutput struct {
	_ struct{} `type:"structure"`

	// The IoT Job ARN corresponding to this update.
	IotJobArn *string `type:"string"`

	// The IoT Job Id corresponding to this update.
	IotJobId *string `type:"string"`

	// The software version installed on the device or devices after the update.
	PlatformSoftwareVersion *string `type:"string"`
}

// String returns the string representation
func (s CreateSoftwareUpdateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSoftwareUpdateJobOutput) GoString() string {
	return s.String()
}

// SetIotJobArn sets the IotJobArn field's value.
func (s *CreateSoftwareUpdateJobOutput) SetIotJobArn(v string) *CreateSoftwareUpdateJobOutput {
	s.IotJobArn = &v
	return s
}

// SetIotJobId sets the IotJobId field's value.
func (s *CreateSoftwareUpdateJobOutput) SetIotJobId(v string) *CreateSoftwareUpdateJobOutput {
	s.IotJobId = &v
	return s
}

// SetPlatformSoftwareVersion sets the PlatformSoftwareVersion field's value.
func (s *CreateSoftwareUpdateJobOutput) SetPlatformSoftwareVersion(v string) *CreateSoftwareUpdateJobOutput {
	s.PlatformSoftwareVersion = &v
	return s
}

type CreateSubscriptionDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information about a subscription definition version.
	InitialVersion *SubscriptionDefinitionVersion `type:"structure"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateSubscriptionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriptionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriptionDefinitionInput"}
	if s.InitialVersion != nil {
		if err := s.InitialVersion.Validate(); err != nil {
			invalidParams.AddNested("InitialVersion", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateSubscriptionDefinitionInput) SetAmznClientToken(v string) *CreateSubscriptionDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateSubscriptionDefinitionInput) SetInitialVersion(v *SubscriptionDefinitionVersion) *CreateSubscriptionDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSubscriptionDefinitionInput) SetName(v string) *CreateSubscriptionDefinitionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSubscriptionDefinitionInput) SetTags(v map[string]*string) *CreateSubscriptionDefinitionInput {
	s.Tags = v
	return s
}

type CreateSubscriptionDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateSubscriptionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSubscriptionDefinitionOutput) SetArn(v string) *CreateSubscriptionDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateSubscriptionDefinitionOutput) SetCreationTimestamp(v string) *CreateSubscriptionDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSubscriptionDefinitionOutput) SetId(v string) *CreateSubscriptionDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateSubscriptionDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateSubscriptionDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateSubscriptionDefinitionOutput) SetLatestVersion(v string) *CreateSubscriptionDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateSubscriptionDefinitionOutput) SetLatestVersionArn(v string) *CreateSubscriptionDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSubscriptionDefinitionOutput) SetName(v string) *CreateSubscriptionDefinitionOutput {
	s.Name = &v
	return s
}

type CreateSubscriptionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`

	Subscriptions []*Subscription `type:"list"`
}

// String returns the string representation
func (s CreateSubscriptionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriptionDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriptionDefinitionVersionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}
	if s.SubscriptionDefinitionId != nil && len(*s.SubscriptionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionDefinitionId", 1))
	}
	if s.Subscriptions != nil {
		for i, v := range s.Subscriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateSubscriptionDefinitionVersionInput) SetAmznClientToken(v string) *CreateSubscriptionDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *CreateSubscriptionDefinitionVersionInput) SetSubscriptionDefinitionId(v string) *CreateSubscriptionDefinitionVersionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *CreateSubscriptionDefinitionVersionInput) SetSubscriptions(v []*Subscription) *CreateSubscriptionDefinitionVersionInput {
	s.Subscriptions = v
	return s
}

type CreateSubscriptionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateSubscriptionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSubscriptionDefinitionVersionOutput) SetArn(v string) *CreateSubscriptionDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateSubscriptionDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateSubscriptionDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSubscriptionDefinitionVersionOutput) SetId(v string) *CreateSubscriptionDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateSubscriptionDefinitionVersionOutput) SetVersion(v string) *CreateSubscriptionDefinitionVersionOutput {
	s.Version = &v
	return s
}

// Information about a definition.
type DefinitionInformation struct {
	_ struct{} `type:"structure"`

	// The ARN of the definition.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the definition was created.
	CreationTimestamp *string `type:"string"`

	// The ID of the definition.
	Id *string `type:"string"`

	// The time, in milliseconds since the epoch, when the definition was last updated.
	LastUpdatedTimestamp *string `type:"string"`

	// The ID of the latest version associated with the definition.
	LatestVersion *string `type:"string"`

	// The ARN of the latest version associated with the definition.
	LatestVersionArn *string `type:"string"`

	// The name of the definition.
	Name *string `type:"string"`

	// Tag(s) attached to the resource arn.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DefinitionInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefinitionInformation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DefinitionInformation) SetArn(v string) *DefinitionInformation {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DefinitionInformation) SetCreationTimestamp(v string) *DefinitionInformation {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *DefinitionInformation) SetId(v string) *DefinitionInformation {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *DefinitionInformation) SetLastUpdatedTimestamp(v string) *DefinitionInformation {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *DefinitionInformation) SetLatestVersion(v string) *DefinitionInformation {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *DefinitionInformation) SetLatestVersionArn(v string) *DefinitionInformation {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DefinitionInformation) SetName(v string) *DefinitionInformation {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DefinitionInformation) SetTags(v map[string]*string) *DefinitionInformation {
	s.Tags = v
	return s
}

type DeleteConnectorDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectorDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectorDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectorDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectorDefinitionInput"}
	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorDefinitionId"))
	}
	if s.ConnectorDefinitionId != nil && len(*s.ConnectorDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorDefinitionId sets the ConnectorDefinitionId field's value.
func (s *DeleteConnectorDefinitionInput) SetConnectorDefinitionId(v string) *DeleteConnectorDefinitionInput {
	s.ConnectorDefinitionId = &v
	return s
}

type DeleteConnectorDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConnectorDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectorDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCoreDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCoreDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCoreDefinitionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}
	if s.CoreDefinitionId != nil && len(*s.CoreDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *DeleteCoreDefinitionInput) SetCoreDefinitionId(v string) *DeleteCoreDefinitionInput {
	s.CoreDefinitionId = &v
	return s
}

type DeleteCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCoreDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeviceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeviceDefinitionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}
	if s.DeviceDefinitionId != nil && len(*s.DeviceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *DeleteDeviceDefinitionInput) SetDeviceDefinitionId(v string) *DeleteDeviceDefinitionInput {
	s.DeviceDefinitionId = &v
	return s
}

type DeleteDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeviceDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionDefinitionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}
	if s.FunctionDefinitionId != nil && len(*s.FunctionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *DeleteFunctionDefinitionInput) SetFunctionDefinitionId(v string) *DeleteFunctionDefinitionInput {
	s.FunctionDefinitionId = &v
	return s
}

type DeleteFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteGroupInput) SetGroupId(v string) *DeleteGroupInput {
	s.GroupId = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoggerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoggerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoggerDefinitionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}
	if s.LoggerDefinitionId != nil && len(*s.LoggerDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoggerDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *DeleteLoggerDefinitionInput) SetLoggerDefinitionId(v string) *DeleteLoggerDefinitionInput {
	s.LoggerDefinitionId = &v
	return s
}

type DeleteLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoggerDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteResourceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceDefinitionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}
	if s.ResourceDefinitionId != nil && len(*s.ResourceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *DeleteResourceDefinitionInput) SetResourceDefinitionId(v string) *DeleteResourceDefinitionInput {
	s.ResourceDefinitionId = &v
	return s
}

type DeleteResourceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceDefinitionOutput) GoString() string {
	return s.String()
}

type DeleteSubscriptionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSubscriptionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriptionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriptionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriptionDefinitionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}
	if s.SubscriptionDefinitionId != nil && len(*s.SubscriptionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *DeleteSubscriptionDefinitionInput) SetSubscriptionDefinitionId(v string) *DeleteSubscriptionDefinitionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

type DeleteSubscriptionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubscriptionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriptionDefinitionOutput) GoString() string {
	return s.String()
}

// Information about a deployment.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds since the epoch, when the deployment was created.
	CreatedAt *string `type:"string"`

	// The ARN of the deployment.
	DeploymentArn *string `type:"string"`

	// The ID of the deployment.
	DeploymentId *string `type:"string"`

	// The type of the deployment.
	DeploymentType *string `type:"string" enum:"DeploymentType"`

	// The ARN of the group for this deployment.
	GroupArn *string `type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Deployment) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Deployment) SetCreatedAt(v string) *Deployment {
	s.CreatedAt = &v
	return s
}

// SetDeploymentArn sets the DeploymentArn field's value.
func (s *Deployment) SetDeploymentArn(v string) *Deployment {
	s.DeploymentArn = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Deployment) SetDeploymentId(v string) *Deployment {
	s.DeploymentId = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *Deployment) SetDeploymentType(v string) *Deployment {
	s.DeploymentType = &v
	return s
}

// SetGroupArn sets the GroupArn field's value.
func (s *Deployment) SetGroupArn(v string) *Deployment {
	s.GroupArn = &v
	return s
}

// Information about a device.
type Device struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate associated with the device.
	//
	// CertificateArn is a required field
	CertificateArn *string `type:"string" required:"true"`

	// A descriptive or arbitrary ID for the device. This value must be unique within
	// the device definition version. Max length is 128 characters with pattern
	// ''[a-zA-Z0-9:_-]+''.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If true, the device's local shadow will be automatically synced with the
	// cloud.
	SyncShadow *bool `type:"boolean"`

	// The thing ARN of the device.
	//
	// ThingArn is a required field
	ThingArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Device) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Device) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Device"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ThingArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Device) SetCertificateArn(v string) *Device {
	s.CertificateArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Device) SetId(v string) *Device {
	s.Id = &v
	return s
}

// SetSyncShadow sets the SyncShadow field's value.
func (s *Device) SetSyncShadow(v bool) *Device {
	s.SyncShadow = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *Device) SetThingArn(v string) *Device {
	s.ThingArn = &v
	return s
}

// Information about a device definition version.
type DeviceDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of devices in the definition version.
	Devices []*Device `type:"list"`
}

// String returns the string representation
func (s DeviceDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceDefinitionVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceDefinitionVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeviceDefinitionVersion"}
	if s.Devices != nil {
		for i, v := range s.Devices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Devices", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevices sets the Devices field's value.
func (s *DeviceDefinitionVersion) SetDevices(v []*Device) *DeviceDefinitionVersion {
	s.Devices = v
	return s
}

type DisassociateRoleFromGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateRoleFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRoleFromGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateRoleFromGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateRoleFromGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DisassociateRoleFromGroupInput) SetGroupId(v string) *DisassociateRoleFromGroupInput {
	s.GroupId = &v
	return s
}

type DisassociateRoleFromGroupOutput struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds since the epoch, when the role was disassociated
	// from the group.
	DisassociatedAt *string `type:"string"`
}

// String returns the string representation
func (s DisassociateRoleFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRoleFromGroupOutput) GoString() string {
	return s.String()
}

// SetDisassociatedAt sets the DisassociatedAt field's value.
func (s *DisassociateRoleFromGroupOutput) SetDisassociatedAt(v string) *DisassociateRoleFromGroupOutput {
	s.DisassociatedAt = &v
	return s
}

type DisassociateServiceRoleFromAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceRoleFromAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateServiceRoleFromAccountInput) GoString() string {
	return s.String()
}

type DisassociateServiceRoleFromAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time when the service role was disassociated from the account.
	DisassociatedAt *string `type:"string"`
}

// String returns the string representation
func (s DisassociateServiceRoleFromAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateServiceRoleFromAccountOutput) GoString() string {
	return s.String()
}

// SetDisassociatedAt sets the DisassociatedAt field's value.
func (s *DisassociateServiceRoleFromAccountOutput) SetDisassociatedAt(v string) *DisassociateServiceRoleFromAccountOutput {
	s.DisassociatedAt = &v
	return s
}

// Details about the error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// A detailed error code.
	DetailedErrorCode *string `type:"string"`

	// A detailed error message.
	DetailedErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetDetailedErrorCode sets the DetailedErrorCode field's value.
func (s *ErrorDetail) SetDetailedErrorCode(v string) *ErrorDetail {
	s.DetailedErrorCode = &v
	return s
}

// SetDetailedErrorMessage sets the DetailedErrorMessage field's value.
func (s *ErrorDetail) SetDetailedErrorMessage(v string) *ErrorDetail {
	s.DetailedErrorMessage = &v
	return s
}

// Information about a Lambda function.
type Function struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function.
	FunctionArn *string `type:"string"`

	// The configuration of the Lambda function.
	FunctionConfiguration *FunctionConfiguration `type:"structure"`

	// A descriptive or arbitrary ID for the function. This value must be unique
	// within the function definition version. Max length is 128 characters with
	// pattern ''[a-zA-Z0-9:_-]+''.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Function) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Function) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Function) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Function"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.FunctionConfiguration != nil {
		if err := s.FunctionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FunctionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *Function) SetFunctionArn(v string) *Function {
	s.FunctionArn = &v
	return s
}

// SetFunctionConfiguration sets the FunctionConfiguration field's value.
func (s *Function) SetFunctionConfiguration(v *FunctionConfiguration) *Function {
	s.FunctionConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *Function) SetId(v string) *Function {
	s.Id = &v
	return s
}

// The configuration of the Lambda function.
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// The expected encoding type of the input payload for the function. The default
	// is ''json''.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// The environment configuration of the function.
	Environment *FunctionConfigurationEnvironment `type:"structure"`

	// The execution arguments.
	ExecArgs *string `type:"string"`

	// The name of the function executable.
	Executable *string `type:"string"`

	// The memory size, in KB, which the function requires. This setting is not
	// applicable and should be cleared when you run the Lambda function without
	// containerization.
	MemorySize *int64 `type:"integer"`

	// True if the function is pinned. Pinned means the function is long-lived and
	// starts when the core starts.
	Pinned *bool `type:"boolean"`

	// The allowed function execution time, after which Lambda should terminate
	// the function. This timeout still applies to pinned Lambda functions for each
	// request.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionConfiguration"}
	if s.Environment != nil {
		if err := s.Environment.Validate(); err != nil {
			invalidParams.AddNested("Environment", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncodingType sets the EncodingType field's value.
func (s *FunctionConfiguration) SetEncodingType(v string) *FunctionConfiguration {
	s.EncodingType = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *FunctionConfiguration) SetEnvironment(v *FunctionConfigurationEnvironment) *FunctionConfiguration {
	s.Environment = v
	return s
}

// SetExecArgs sets the ExecArgs field's value.
func (s *FunctionConfiguration) SetExecArgs(v string) *FunctionConfiguration {
	s.ExecArgs = &v
	return s
}

// SetExecutable sets the Executable field's value.
func (s *FunctionConfiguration) SetExecutable(v string) *FunctionConfiguration {
	s.Executable = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *FunctionConfiguration) SetMemorySize(v int64) *FunctionConfiguration {
	s.MemorySize = &v
	return s
}

// SetPinned sets the Pinned field's value.
func (s *FunctionConfiguration) SetPinned(v bool) *FunctionConfiguration {
	s.Pinned = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *FunctionConfiguration) SetTimeout(v int64) *FunctionConfiguration {
	s.Timeout = &v
	return s
}

// The environment configuration of the function.
type FunctionConfigurationEnvironment struct {
	_ struct{} `type:"structure"`

	// If true, the Lambda function is allowed to access the host's /sys folder.
	// Use this when the Lambda function needs to read device information from /sys.
	// This setting applies only when you run the Lambda function in a Greengrass
	// container.
	AccessSysfs *bool `type:"boolean"`

	// Configuration related to executing the Lambda function
	Execution *FunctionExecutionConfig `type:"structure"`

	// A list of the resources, with their permissions, to which the Lambda function
	// will be granted access. A Lambda function can have at most 10 resources.
	// ResourceAccessPolicies apply only when you run the Lambda function in a Greengrass
	// container.
	ResourceAccessPolicies []*ResourceAccessPolicy `type:"list"`

	// Environment variables for the Lambda function's configuration.
	Variables map[string]*string `type:"map"`
}

// String returns the string representation
func (s FunctionConfigurationEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfigurationEnvironment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionConfigurationEnvironment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionConfigurationEnvironment"}
	if s.ResourceAccessPolicies != nil {
		for i, v := range s.ResourceAccessPolicies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceAccessPolicies", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessSysfs sets the AccessSysfs field's value.
func (s *FunctionConfigurationEnvironment) SetAccessSysfs(v bool) *FunctionConfigurationEnvironment {
	s.AccessSysfs = &v
	return s
}

// SetExecution sets the Execution field's value.
func (s *FunctionConfigurationEnvironment) SetExecution(v *FunctionExecutionConfig) *FunctionConfigurationEnvironment {
	s.Execution = v
	return s
}

// SetResourceAccessPolicies sets the ResourceAccessPolicies field's value.
func (s *FunctionConfigurationEnvironment) SetResourceAccessPolicies(v []*ResourceAccessPolicy) *FunctionConfigurationEnvironment {
	s.ResourceAccessPolicies = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *FunctionConfigurationEnvironment) SetVariables(v map[string]*string) *FunctionConfigurationEnvironment {
	s.Variables = v
	return s
}

// The default configuration that applies to all Lambda functions in the group.
// Individual Lambda functions can override these settings.
type FunctionDefaultConfig struct {
	_ struct{} `type:"structure"`

	// Configuration information that specifies how a Lambda function runs.
	Execution *FunctionDefaultExecutionConfig `type:"structure"`
}

// String returns the string representation
func (s FunctionDefaultConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionDefaultConfig) GoString() string {
	return s.String()
}

// SetExecution sets the Execution field's value.
func (s *FunctionDefaultConfig) SetExecution(v *FunctionDefaultExecutionConfig) *FunctionDefaultConfig {
	s.Execution = v
	return s
}

// Configuration information that specifies how a Lambda function runs.
type FunctionDefaultExecutionConfig struct {
	_ struct{} `type:"structure"`

	// Specifies whether the Lambda function runs in a Greengrass container (default)
	// or without containerization. Unless your scenario requires that you run without
	// containerization, we recommend that you run in a Greengrass container. Omit
	// this value to run the Lambda function with the default containerization for
	// the group.
	IsolationMode *string `type:"string" enum:"FunctionIsolationMode"`

	// Specifies the user and group whose permissions are used when running the
	// Lambda function. You can specify one or both values to override the default
	// values. We recommend that you avoid running as root unless absolutely necessary
	// to minimize the risk of unintended changes or malicious attacks. To run as
	// root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json
	// in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
	RunAs *FunctionRunAsConfig `type:"structure"`
}

// String returns the string representation
func (s FunctionDefaultExecutionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionDefaultExecutionConfig) GoString() string {
	return s.String()
}

// SetIsolationMode sets the IsolationMode field's value.
func (s *FunctionDefaultExecutionConfig) SetIsolationMode(v string) *FunctionDefaultExecutionConfig {
	s.IsolationMode = &v
	return s
}

// SetRunAs sets the RunAs field's value.
func (s *FunctionDefaultExecutionConfig) SetRunAs(v *FunctionRunAsConfig) *FunctionDefaultExecutionConfig {
	s.RunAs = v
	return s
}

// Information about a function definition version.
type FunctionDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// The default configuration that applies to all Lambda functions in this function
	// definition version. Individual Lambda functions can override these settings.
	DefaultConfig *FunctionDefaultConfig `type:"structure"`

	// A list of Lambda functions in this function definition version.
	Functions []*Function `type:"list"`
}

// String returns the string representation
func (s FunctionDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionDefinitionVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionDefinitionVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionDefinitionVersion"}
	if s.Functions != nil {
		for i, v := range s.Functions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Functions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultConfig sets the DefaultConfig field's value.
func (s *FunctionDefinitionVersion) SetDefaultConfig(v *FunctionDefaultConfig) *FunctionDefinitionVersion {
	s.DefaultConfig = v
	return s
}

// SetFunctions sets the Functions field's value.
func (s *FunctionDefinitionVersion) SetFunctions(v []*Function) *FunctionDefinitionVersion {
	s.Functions = v
	return s
}

// Configuration information that specifies how a Lambda function runs.
type FunctionExecutionConfig struct {
	_ struct{} `type:"structure"`

	// Specifies whether the Lambda function runs in a Greengrass container (default)
	// or without containerization. Unless your scenario requires that you run without
	// containerization, we recommend that you run in a Greengrass container. Omit
	// this value to run the Lambda function with the default containerization for
	// the group.
	IsolationMode *string `type:"string" enum:"FunctionIsolationMode"`

	// Specifies the user and group whose permissions are used when running the
	// Lambda function. You can specify one or both values to override the default
	// values. We recommend that you avoid running as root unless absolutely necessary
	// to minimize the risk of unintended changes or malicious attacks. To run as
	// root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json
	// in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
	RunAs *FunctionRunAsConfig `type:"structure"`
}

// String returns the string representation
func (s FunctionExecutionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionExecutionConfig) GoString() string {
	return s.String()
}

// SetIsolationMode sets the IsolationMode field's value.
func (s *FunctionExecutionConfig) SetIsolationMode(v string) *FunctionExecutionConfig {
	s.IsolationMode = &v
	return s
}

// SetRunAs sets the RunAs field's value.
func (s *FunctionExecutionConfig) SetRunAs(v *FunctionRunAsConfig) *FunctionExecutionConfig {
	s.RunAs = v
	return s
}

// Specifies the user and group whose permissions are used when running the
// Lambda function. You can specify one or both values to override the default
// values. We recommend that you avoid running as root unless absolutely necessary
// to minimize the risk of unintended changes or malicious attacks. To run as
// root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json
// in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
type FunctionRunAsConfig struct {
	_ struct{} `type:"structure"`

	// The group ID whose permissions are used to run a Lambda function.
	Gid *int64 `type:"integer"`

	// The user ID whose permissions are used to run a Lambda function.
	Uid *int64 `type:"integer"`
}

// String returns the string representation
func (s FunctionRunAsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionRunAsConfig) GoString() string {
	return s.String()
}

// SetGid sets the Gid field's value.
func (s *FunctionRunAsConfig) SetGid(v int64) *FunctionRunAsConfig {
	s.Gid = &v
	return s
}

// SetUid sets the Uid field's value.
func (s *FunctionRunAsConfig) SetUid(v int64) *FunctionRunAsConfig {
	s.Uid = &v
	return s
}

type GetAssociatedRoleInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAssociatedRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssociatedRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssociatedRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssociatedRoleInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetAssociatedRoleInput) SetGroupId(v string) *GetAssociatedRoleInput {
	s.GroupId = &v
	return s
}

type GetAssociatedRoleOutput struct {
	_ struct{} `type:"structure"`

	// The time when the role was associated with the group.
	AssociatedAt *string `type:"string"`

	// The ARN of the role that is associated with the group.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s GetAssociatedRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssociatedRoleOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *GetAssociatedRoleOutput) SetAssociatedAt(v string) *GetAssociatedRoleOutput {
	s.AssociatedAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetAssociatedRoleOutput) SetRoleArn(v string) *GetAssociatedRoleOutput {
	s.RoleArn = &v
	return s
}

type GetBulkDeploymentStatusInput struct {
	_ struct{} `type:"structure"`

	// BulkDeploymentId is a required field
	BulkDeploymentId *string `location:"uri" locationName:"BulkDeploymentId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBulkDeploymentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBulkDeploymentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBulkDeploymentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBulkDeploymentStatusInput"}
	if s.BulkDeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("BulkDeploymentId"))
	}
	if s.BulkDeploymentId != nil && len(*s.BulkDeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BulkDeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBulkDeploymentId sets the BulkDeploymentId field's value.
func (s *GetBulkDeploymentStatusInput) SetBulkDeploymentId(v string) *GetBulkDeploymentStatusInput {
	s.BulkDeploymentId = &v
	return s
}

// Information about the status of a bulk deployment at the time of the request.
type GetBulkDeploymentStatusOutput struct {
	_ struct{} `type:"structure"`

	// Relevant metrics on input records processed during bulk deployment.
	BulkDeploymentMetrics *BulkDeploymentMetrics `type:"structure"`

	// The status of the bulk deployment.
	BulkDeploymentStatus *string `type:"string" enum:"BulkDeploymentStatus"`

	// The time, in ISO format, when the deployment was created.
	CreatedAt *string `type:"string"`

	// Error details
	ErrorDetails []*ErrorDetail `type:"list"`

	// Error message
	ErrorMessage *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetBulkDeploymentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBulkDeploymentStatusOutput) GoString() string {
	return s.String()
}

// SetBulkDeploymentMetrics sets the BulkDeploymentMetrics field's value.
func (s *GetBulkDeploymentStatusOutput) SetBulkDeploymentMetrics(v *BulkDeploymentMetrics) *GetBulkDeploymentStatusOutput {
	s.BulkDeploymentMetrics = v
	return s
}

// SetBulkDeploymentStatus sets the BulkDeploymentStatus field's value.
func (s *GetBulkDeploymentStatusOutput) SetBulkDeploymentStatus(v string) *GetBulkDeploymentStatusOutput {
	s.BulkDeploymentStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetBulkDeploymentStatusOutput) SetCreatedAt(v string) *GetBulkDeploymentStatusOutput {
	s.CreatedAt = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *GetBulkDeploymentStatusOutput) SetErrorDetails(v []*ErrorDetail) *GetBulkDeploymentStatusOutput {
	s.ErrorDetails = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetBulkDeploymentStatusOutput) SetErrorMessage(v string) *GetBulkDeploymentStatusOutput {
	s.ErrorMessage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetBulkDeploymentStatusOutput) SetTags(v map[string]*string) *GetBulkDeploymentStatusOutput {
	s.Tags = v
	return s
}

type GetConnectivityInfoInput struct {
	_ struct{} `type:"structure"`

	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"ThingName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConnectivityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectivityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectivityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectivityInfoInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingName sets the ThingName field's value.
func (s *GetConnectivityInfoInput) SetThingName(v string) *GetConnectivityInfoInput {
	s.ThingName = &v
	return s
}

// Information about a Greengrass core's connectivity.
type GetConnectivityInfoOutput struct {
	_ struct{} `type:"structure"`

	// Connectivity info list.
	ConnectivityInfo []*ConnectivityInfo `type:"list"`

	// A message about the connectivity info request.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s GetConnectivityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectivityInfoOutput) GoString() string {
	return s.String()
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *GetConnectivityInfoOutput) SetConnectivityInfo(v []*ConnectivityInfo) *GetConnectivityInfoOutput {
	s.ConnectivityInfo = v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetConnectivityInfoOutput) SetMessage(v string) *GetConnectivityInfoOutput {
	s.Message = &v
	return s
}

type GetConnectorDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConnectorDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectorDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectorDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectorDefinitionInput"}
	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorDefinitionId"))
	}
	if s.ConnectorDefinitionId != nil && len(*s.ConnectorDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorDefinitionId sets the ConnectorDefinitionId field's value.
func (s *GetConnectorDefinitionInput) SetConnectorDefinitionId(v string) *GetConnectorDefinitionInput {
	s.ConnectorDefinitionId = &v
	return s
}

type GetConnectorDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetConnectorDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectorDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetConnectorDefinitionOutput) SetArn(v string) *GetConnectorDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetConnectorDefinitionOutput) SetCreationTimestamp(v string) *GetConnectorDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetConnectorDefinitionOutput) SetId(v string) *GetConnectorDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetConnectorDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetConnectorDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetConnectorDefinitionOutput) SetLatestVersion(v string) *GetConnectorDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetConnectorDefinitionOutput) SetLatestVersionArn(v string) *GetConnectorDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetConnectorDefinitionOutput) SetName(v string) *GetConnectorDefinitionOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetConnectorDefinitionOutput) SetTags(v map[string]*string) *GetConnectorDefinitionOutput {
	s.Tags = v
	return s
}

type GetConnectorDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`

	// ConnectorDefinitionVersionId is a required field
	ConnectorDefinitionVersionId *string `location:"uri" locationName:"ConnectorDefinitionVersionId" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s GetConnectorDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectorDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectorDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectorDefinitionVersionInput"}
	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorDefinitionId"))
	}
	if s.ConnectorDefinitionId != nil && len(*s.ConnectorDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorDefinitionId", 1))
	}
	if s.ConnectorDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorDefinitionVersionId"))
	}
	if s.ConnectorDefinitionVersionId != nil && len(*s.ConnectorDefinitionVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorDefinitionVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorDefinitionId sets the ConnectorDefinitionId field's value.
func (s *GetConnectorDefinitionVersionInput) SetConnectorDefinitionId(v string) *GetConnectorDefinitionVersionInput {
	s.ConnectorDefinitionId = &v
	return s
}

// SetConnectorDefinitionVersionId sets the ConnectorDefinitionVersionId field's value.
func (s *GetConnectorDefinitionVersionInput) SetConnectorDefinitionVersionId(v string) *GetConnectorDefinitionVersionInput {
	s.ConnectorDefinitionVersionId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConnectorDefinitionVersionInput) SetNextToken(v string) *GetConnectorDefinitionVersionInput {
	s.NextToken = &v
	return s
}

// Information about a connector definition version.
type GetConnectorDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the connector definition version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the connector definition
	// version was created.
	CreationTimestamp *string `type:"string"`

	// Information about the connector definition version.
	Definition *ConnectorDefinitionVersion `type:"structure"`

	// The ID of the connector definition version.
	Id *string `type:"string"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`

	// The version of the connector definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetConnectorDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectorDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetConnectorDefinitionVersionOutput) SetArn(v string) *GetConnectorDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetConnectorDefinitionVersionOutput) SetCreationTimestamp(v string) *GetConnectorDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetConnectorDefinitionVersionOutput) SetDefinition(v *ConnectorDefinitionVersion) *GetConnectorDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetConnectorDefinitionVersionOutput) SetId(v string) *GetConnectorDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConnectorDefinitionVersionOutput) SetNextToken(v string) *GetConnectorDefinitionVersionOutput {
	s.NextToken = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetConnectorDefinitionVersionOutput) SetVersion(v string) *GetConnectorDefinitionVersionOutput {
	s.Version = &v
	return s
}

type GetCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCoreDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCoreDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCoreDefinitionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}
	if s.CoreDefinitionId != nil && len(*s.CoreDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *GetCoreDefinitionInput) SetCoreDefinitionId(v string) *GetCoreDefinitionInput {
	s.CoreDefinitionId = &v
	return s
}

type GetCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCoreDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetCoreDefinitionOutput) SetArn(v string) *GetCoreDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetCoreDefinitionOutput) SetCreationTimestamp(v string) *GetCoreDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetCoreDefinitionOutput) SetId(v string) *GetCoreDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetCoreDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetCoreDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetCoreDefinitionOutput) SetLatestVersion(v string) *GetCoreDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetCoreDefinitionOutput) SetLatestVersionArn(v string) *GetCoreDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetCoreDefinitionOutput) SetName(v string) *GetCoreDefinitionOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetCoreDefinitionOutput) SetTags(v map[string]*string) *GetCoreDefinitionOutput {
	s.Tags = v
	return s
}

type GetCoreDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	// CoreDefinitionVersionId is a required field
	CoreDefinitionVersionId *string `location:"uri" locationName:"CoreDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCoreDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCoreDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCoreDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCoreDefinitionVersionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}
	if s.CoreDefinitionId != nil && len(*s.CoreDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDefinitionId", 1))
	}
	if s.CoreDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionVersionId"))
	}
	if s.CoreDefinitionVersionId != nil && len(*s.CoreDefinitionVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDefinitionVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *GetCoreDefinitionVersionInput) SetCoreDefinitionId(v string) *GetCoreDefinitionVersionInput {
	s.CoreDefinitionId = &v
	return s
}

// SetCoreDefinitionVersionId sets the CoreDefinitionVersionId field's value.
func (s *GetCoreDefinitionVersionInput) SetCoreDefinitionVersionId(v string) *GetCoreDefinitionVersionInput {
	s.CoreDefinitionVersionId = &v
	return s
}

type GetCoreDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the core definition version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the core definition version
	// was created.
	CreationTimestamp *string `type:"string"`

	// Information about the core definition version.
	Definition *CoreDefinitionVersion `type:"structure"`

	// The ID of the core definition version.
	Id *string `type:"string"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`

	// The version of the core definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetCoreDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCoreDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetCoreDefinitionVersionOutput) SetArn(v string) *GetCoreDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetCoreDefinitionVersionOutput) SetCreationTimestamp(v string) *GetCoreDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetCoreDefinitionVersionOutput) SetDefinition(v *CoreDefinitionVersion) *GetCoreDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetCoreDefinitionVersionOutput) SetId(v string) *GetCoreDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCoreDefinitionVersionOutput) SetNextToken(v string) *GetCoreDefinitionVersionOutput {
	s.NextToken = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetCoreDefinitionVersionOutput) SetVersion(v string) *GetCoreDefinitionVersionOutput {
	s.Version = &v
	return s
}

type GetDeploymentStatusInput struct {
	_ struct{} `type:"structure"`

	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"DeploymentId" type:"string" required:"true"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentStatusInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentStatusInput) SetDeploymentId(v string) *GetDeploymentStatusInput {
	s.DeploymentId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GetDeploymentStatusInput) SetGroupId(v string) *GetDeploymentStatusInput {
	s.GroupId = &v
	return s
}

// Information about the status of a deployment for a group.
type GetDeploymentStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the deployment: ''InProgress'', ''Building'', ''Success'',
	// or ''Failure''.
	DeploymentStatus *string `type:"string"`

	// The type of the deployment.
	DeploymentType *string `type:"string" enum:"DeploymentType"`

	// Error details
	ErrorDetails []*ErrorDetail `type:"list"`

	// Error message
	ErrorMessage *string `type:"string"`

	// The time, in milliseconds since the epoch, when the deployment status was
	// updated.
	UpdatedAt *string `type:"string"`
}

// String returns the string representation
func (s GetDeploymentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentStatusOutput) GoString() string {
	return s.String()
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *GetDeploymentStatusOutput) SetDeploymentStatus(v string) *GetDeploymentStatusOutput {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *GetDeploymentStatusOutput) SetDeploymentType(v string) *GetDeploymentStatusOutput {
	s.DeploymentType = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *GetDeploymentStatusOutput) SetErrorDetails(v []*ErrorDetail) *GetDeploymentStatusOutput {
	s.ErrorDetails = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetDeploymentStatusOutput) SetErrorMessage(v string) *GetDeploymentStatusOutput {
	s.ErrorMessage = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDeploymentStatusOutput) SetUpdatedAt(v string) *GetDeploymentStatusOutput {
	s.UpdatedAt = &v
	return s
}

type GetDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceDefinitionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}
	if s.DeviceDefinitionId != nil && len(*s.DeviceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *GetDeviceDefinitionInput) SetDeviceDefinitionId(v string) *GetDeviceDefinitionInput {
	s.DeviceDefinitionId = &v
	return s
}

type GetDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDeviceDefinitionOutput) SetArn(v string) *GetDeviceDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetDeviceDefinitionOutput) SetCreationTimestamp(v string) *GetDeviceDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeviceDefinitionOutput) SetId(v string) *GetDeviceDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetDeviceDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetDeviceDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetDeviceDefinitionOutput) SetLatestVersion(v string) *GetDeviceDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetDeviceDefinitionOutput) SetLatestVersionArn(v string) *GetDeviceDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDeviceDefinitionOutput) SetName(v string) *GetDeviceDefinitionOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDeviceDefinitionOutput) SetTags(v map[string]*string) *GetDeviceDefinitionOutput {
	s.Tags = v
	return s
}

type GetDeviceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	// DeviceDefinitionVersionId is a required field
	DeviceDefinitionVersionId *string `location:"uri" locationName:"DeviceDefinitionVersionId" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s GetDeviceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceDefinitionVersionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}
	if s.DeviceDefinitionId != nil && len(*s.DeviceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceDefinitionId", 1))
	}
	if s.DeviceDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionVersionId"))
	}
	if s.DeviceDefinitionVersionId != nil && len(*s.DeviceDefinitionVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceDefinitionVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *GetDeviceDefinitionVersionInput) SetDeviceDefinitionId(v string) *GetDeviceDefinitionVersionInput {
	s.DeviceDefinitionId = &v
	return s
}

// SetDeviceDefinitionVersionId sets the DeviceDefinitionVersionId field's value.
func (s *GetDeviceDefinitionVersionInput) SetDeviceDefinitionVersionId(v string) *GetDeviceDefinitionVersionInput {
	s.DeviceDefinitionVersionId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDeviceDefinitionVersionInput) SetNextToken(v string) *GetDeviceDefinitionVersionInput {
	s.NextToken = &v
	return s
}

type GetDeviceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device definition version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the device definition version
	// was created.
	CreationTimestamp *string `type:"string"`

	// Information about the device definition version.
	Definition *DeviceDefinitionVersion `type:"structure"`

	// The ID of the device definition version.
	Id *string `type:"string"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`

	// The version of the device definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetDeviceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDeviceDefinitionVersionOutput) SetArn(v string) *GetDeviceDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetDeviceDefinitionVersionOutput) SetCreationTimestamp(v string) *GetDeviceDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetDeviceDefinitionVersionOutput) SetDefinition(v *DeviceDefinitionVersion) *GetDeviceDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeviceDefinitionVersionOutput) SetId(v string) *GetDeviceDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDeviceDefinitionVersionOutput) SetNextToken(v string) *GetDeviceDefinitionVersionOutput {
	s.NextToken = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetDeviceDefinitionVersionOutput) SetVersion(v string) *GetDeviceDefinitionVersionOutput {
	s.Version = &v
	return s
}

type GetFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionDefinitionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}
	if s.FunctionDefinitionId != nil && len(*s.FunctionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *GetFunctionDefinitionInput) SetFunctionDefinitionId(v string) *GetFunctionDefinitionInput {
	s.FunctionDefinitionId = &v
	return s
}

type GetFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetFunctionDefinitionOutput) SetArn(v string) *GetFunctionDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetFunctionDefinitionOutput) SetCreationTimestamp(v string) *GetFunctionDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetFunctionDefinitionOutput) SetId(v string) *GetFunctionDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetFunctionDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetFunctionDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetFunctionDefinitionOutput) SetLatestVersion(v string) *GetFunctionDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetFunctionDefinitionOutput) SetLatestVersionArn(v string) *GetFunctionDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetFunctionDefinitionOutput) SetName(v string) *GetFunctionDefinitionOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetFunctionDefinitionOutput) SetTags(v map[string]*string) *GetFunctionDefinitionOutput {
	s.Tags = v
	return s
}

type GetFunctionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	// FunctionDefinitionVersionId is a required field
	FunctionDefinitionVersionId *string `location:"uri" locationName:"FunctionDefinitionVersionId" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s GetFunctionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionDefinitionVersionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}
	if s.FunctionDefinitionId != nil && len(*s.FunctionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionDefinitionId", 1))
	}
	if s.FunctionDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionVersionId"))
	}
	if s.FunctionDefinitionVersionId != nil && len(*s.FunctionDefinitionVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionDefinitionVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *GetFunctionDefinitionVersionInput) SetFunctionDefinitionId(v string) *GetFunctionDefinitionVersionInput {
	s.FunctionDefinitionId = &v
	return s
}

// SetFunctionDefinitionVersionId sets the FunctionDefinitionVersionId field's value.
func (s *GetFunctionDefinitionVersionInput) SetFunctionDefinitionVersionId(v string) *GetFunctionDefinitionVersionInput {
	s.FunctionDefinitionVersionId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFunctionDefinitionVersionInput) SetNextToken(v string) *GetFunctionDefinitionVersionInput {
	s.NextToken = &v
	return s
}

// Information about a function definition version.
type GetFunctionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the function definition version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the function definition version
	// was created.
	CreationTimestamp *string `type:"string"`

	// Information on the definition.
	Definition *FunctionDefinitionVersion `type:"structure"`

	// The ID of the function definition version.
	Id *string `type:"string"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`

	// The version of the function definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetFunctionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetFunctionDefinitionVersionOutput) SetArn(v string) *GetFunctionDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetFunctionDefinitionVersionOutput) SetCreationTimestamp(v string) *GetFunctionDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetFunctionDefinitionVersionOutput) SetDefinition(v *FunctionDefinitionVersion) *GetFunctionDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetFunctionDefinitionVersionOutput) SetId(v string) *GetFunctionDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFunctionDefinitionVersionOutput) SetNextToken(v string) *GetFunctionDefinitionVersionOutput {
	s.NextToken = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetFunctionDefinitionVersionOutput) SetVersion(v string) *GetFunctionDefinitionVersionOutput {
	s.Version = &v
	return s
}

type GetGroupCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// CertificateAuthorityId is a required field
	CertificateAuthorityId *string `location:"uri" locationName:"CertificateAuthorityId" type:"string" required:"true"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupCertificateAuthorityInput"}
	if s.CertificateAuthorityId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityId"))
	}
	if s.CertificateAuthorityId != nil && len(*s.CertificateAuthorityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityId", 1))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityId sets the CertificateAuthorityId field's value.
func (s *GetGroupCertificateAuthorityInput) SetCertificateAuthorityId(v string) *GetGroupCertificateAuthorityInput {
	s.CertificateAuthorityId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupCertificateAuthorityInput) SetGroupId(v string) *GetGroupCertificateAuthorityInput {
	s.GroupId = &v
	return s
}

// Information about a certificate authority for a group.
type GetGroupCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate authority for the group.
	GroupCertificateAuthorityArn *string `type:"string"`

	// The ID of the certificate authority for the group.
	GroupCertificateAuthorityId *string `type:"string"`

	// The PEM encoded certificate for the group.
	PemEncodedCertificate *string `type:"string"`
}

// String returns the string representation
func (s GetGroupCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetGroupCertificateAuthorityArn sets the GroupCertificateAuthorityArn field's value.
func (s *GetGroupCertificateAuthorityOutput) SetGroupCertificateAuthorityArn(v string) *GetGroupCertificateAuthorityOutput {
	s.GroupCertificateAuthorityArn = &v
	return s
}

// SetGroupCertificateAuthorityId sets the GroupCertificateAuthorityId field's value.
func (s *GetGroupCertificateAuthorityOutput) SetGroupCertificateAuthorityId(v string) *GetGroupCertificateAuthorityOutput {
	s.GroupCertificateAuthorityId = &v
	return s
}

// SetPemEncodedCertificate sets the PemEncodedCertificate field's value.
func (s *GetGroupCertificateAuthorityOutput) SetPemEncodedCertificate(v string) *GetGroupCertificateAuthorityOutput {
	s.PemEncodedCertificate = &v
	return s
}

type GetGroupCertificateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupCertificateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupCertificateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupCertificateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupCertificateConfigurationInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupCertificateConfigurationInput) SetGroupId(v string) *GetGroupCertificateConfigurationInput {
	s.GroupId = &v
	return s
}

type GetGroupCertificateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	CertificateAuthorityExpiryInMilliseconds *string `type:"string"`

	CertificateExpiryInMilliseconds *string `type:"string"`

	GroupId *string `type:"string"`
}

// String returns the string representation
func (s GetGroupCertificateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupCertificateConfigurationOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthorityExpiryInMilliseconds sets the CertificateAuthorityExpiryInMilliseconds field's value.
func (s *GetGroupCertificateConfigurationOutput) SetCertificateAuthorityExpiryInMilliseconds(v string) *GetGroupCertificateConfigurationOutput {
	s.CertificateAuthorityExpiryInMilliseconds = &v
	return s
}

// SetCertificateExpiryInMilliseconds sets the CertificateExpiryInMilliseconds field's value.
func (s *GetGroupCertificateConfigurationOutput) SetCertificateExpiryInMilliseconds(v string) *GetGroupCertificateConfigurationOutput {
	s.CertificateExpiryInMilliseconds = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupCertificateConfigurationOutput) SetGroupId(v string) *GetGroupCertificateConfigurationOutput {
	s.GroupId = &v
	return s
}

type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupInput) SetGroupId(v string) *GetGroupInput {
	s.GroupId = &v
	return s
}

type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetGroupOutput) SetArn(v string) *GetGroupOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetGroupOutput) SetCreationTimestamp(v string) *GetGroupOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetGroupOutput) SetId(v string) *GetGroupOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetGroupOutput) SetLastUpdatedTimestamp(v string) *GetGroupOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetGroupOutput) SetLatestVersion(v string) *GetGroupOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetGroupOutput) SetLatestVersionArn(v string) *GetGroupOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetGroupOutput) SetName(v string) *GetGroupOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetGroupOutput) SetTags(v map[string]*string) *GetGroupOutput {
	s.Tags = v
	return s
}

type GetGroupVersionInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	// GroupVersionId is a required field
	GroupVersionId *string `location:"uri" locationName:"GroupVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupVersionInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.GroupVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupVersionId"))
	}
	if s.GroupVersionId != nil && len(*s.GroupVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupVersionInput) SetGroupId(v string) *GetGroupVersionInput {
	s.GroupId = &v
	return s
}

// SetGroupVersionId sets the GroupVersionId field's value.
func (s *GetGroupVersionInput) SetGroupVersionId(v string) *GetGroupVersionInput {
	s.GroupVersionId = &v
	return s
}

// Information about a group version.
type GetGroupVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the group version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the group version was created.
	CreationTimestamp *string `type:"string"`

	// Information about the group version definition.
	Definition *GroupVersion `type:"structure"`

	// The ID of the group that the version is associated with.
	Id *string `type:"string"`

	// The ID of the group version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetGroupVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetGroupVersionOutput) SetArn(v string) *GetGroupVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetGroupVersionOutput) SetCreationTimestamp(v string) *GetGroupVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetGroupVersionOutput) SetDefinition(v *GroupVersion) *GetGroupVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetGroupVersionOutput) SetId(v string) *GetGroupVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetGroupVersionOutput) SetVersion(v string) *GetGroupVersionOutput {
	s.Version = &v
	return s
}

type GetLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoggerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoggerDefinitionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}
	if s.LoggerDefinitionId != nil && len(*s.LoggerDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoggerDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *GetLoggerDefinitionInput) SetLoggerDefinitionId(v string) *GetLoggerDefinitionInput {
	s.LoggerDefinitionId = &v
	return s
}

type GetLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggerDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetLoggerDefinitionOutput) SetArn(v string) *GetLoggerDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetLoggerDefinitionOutput) SetCreationTimestamp(v string) *GetLoggerDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetLoggerDefinitionOutput) SetId(v string) *GetLoggerDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetLoggerDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetLoggerDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetLoggerDefinitionOutput) SetLatestVersion(v string) *GetLoggerDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetLoggerDefinitionOutput) SetLatestVersionArn(v string) *GetLoggerDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetLoggerDefinitionOutput) SetName(v string) *GetLoggerDefinitionOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetLoggerDefinitionOutput) SetTags(v map[string]*string) *GetLoggerDefinitionOutput {
	s.Tags = v
	return s
}

type GetLoggerDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	// LoggerDefinitionVersionId is a required field
	LoggerDefinitionVersionId *string `location:"uri" locationName:"LoggerDefinitionVersionId" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s GetLoggerDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggerDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoggerDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoggerDefinitionVersionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}
	if s.LoggerDefinitionId != nil && len(*s.LoggerDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoggerDefinitionId", 1))
	}
	if s.LoggerDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionVersionId"))
	}
	if s.LoggerDefinitionVersionId != nil && len(*s.LoggerDefinitionVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoggerDefinitionVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *GetLoggerDefinitionVersionInput) SetLoggerDefinitionId(v string) *GetLoggerDefinitionVersionInput {
	s.LoggerDefinitionId = &v
	return s
}

// SetLoggerDefinitionVersionId sets the LoggerDefinitionVersionId field's value.
func (s *GetLoggerDefinitionVersionInput) SetLoggerDefinitionVersionId(v string) *GetLoggerDefinitionVersionInput {
	s.LoggerDefinitionVersionId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetLoggerDefinitionVersionInput) SetNextToken(v string) *GetLoggerDefinitionVersionInput {
	s.NextToken = &v
	return s
}

// Information about a logger definition version.
type GetLoggerDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the logger definition version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the logger definition version
	// was created.
	CreationTimestamp *string `type:"string"`

	// Information about the logger definition version.
	Definition *LoggerDefinitionVersion `type:"structure"`

	// The ID of the logger definition version.
	Id *string `type:"string"`

	// The version of the logger definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetLoggerDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggerDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetLoggerDefinitionVersionOutput) SetArn(v string) *GetLoggerDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetLoggerDefinitionVersionOutput) SetCreationTimestamp(v string) *GetLoggerDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetLoggerDefinitionVersionOutput) SetDefinition(v *LoggerDefinitionVersion) *GetLoggerDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetLoggerDefinitionVersionOutput) SetId(v string) *GetLoggerDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetLoggerDefinitionVersionOutput) SetVersion(v string) *GetLoggerDefinitionVersionOutput {
	s.Version = &v
	return s
}

type GetResourceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceDefinitionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}
	if s.ResourceDefinitionId != nil && len(*s.ResourceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *GetResourceDefinitionInput) SetResourceDefinitionId(v string) *GetResourceDefinitionInput {
	s.ResourceDefinitionId = &v
	return s
}

type GetResourceDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetResourceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetResourceDefinitionOutput) SetArn(v string) *GetResourceDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetResourceDefinitionOutput) SetCreationTimestamp(v string) *GetResourceDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetResourceDefinitionOutput) SetId(v string) *GetResourceDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetResourceDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetResourceDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetResourceDefinitionOutput) SetLatestVersion(v string) *GetResourceDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetResourceDefinitionOutput) SetLatestVersionArn(v string) *GetResourceDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetResourceDefinitionOutput) SetName(v string) *GetResourceDefinitionOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetResourceDefinitionOutput) SetTags(v map[string]*string) *GetResourceDefinitionOutput {
	s.Tags = v
	return s
}

type GetResourceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`

	// ResourceDefinitionVersionId is a required field
	ResourceDefinitionVersionId *string `location:"uri" locationName:"ResourceDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceDefinitionVersionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}
	if s.ResourceDefinitionId != nil && len(*s.ResourceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceDefinitionId", 1))
	}
	if s.ResourceDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionVersionId"))
	}
	if s.ResourceDefinitionVersionId != nil && len(*s.ResourceDefinitionVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceDefinitionVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *GetResourceDefinitionVersionInput) SetResourceDefinitionId(v string) *GetResourceDefinitionVersionInput {
	s.ResourceDefinitionId = &v
	return s
}

// SetResourceDefinitionVersionId sets the ResourceDefinitionVersionId field's value.
func (s *GetResourceDefinitionVersionInput) SetResourceDefinitionVersionId(v string) *GetResourceDefinitionVersionInput {
	s.ResourceDefinitionVersionId = &v
	return s
}

// Information about a resource definition version.
type GetResourceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the resource definition version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the resource definition version
	// was created.
	CreationTimestamp *string `type:"string"`

	// Information about the definition.
	Definition *ResourceDefinitionVersion `type:"structure"`

	// The ID of the resource definition version.
	Id *string `type:"string"`

	// The version of the resource definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetResourceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetResourceDefinitionVersionOutput) SetArn(v string) *GetResourceDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetResourceDefinitionVersionOutput) SetCreationTimestamp(v string) *GetResourceDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetResourceDefinitionVersionOutput) SetDefinition(v *ResourceDefinitionVersion) *GetResourceDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetResourceDefinitionVersionOutput) SetId(v string) *GetResourceDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetResourceDefinitionVersionOutput) SetVersion(v string) *GetResourceDefinitionVersionOutput {
	s.Version = &v
	return s
}

type GetServiceRoleForAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetServiceRoleForAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceRoleForAccountInput) GoString() string {
	return s.String()
}

type GetServiceRoleForAccountOutput struct {
	_ struct{} `type:"structure"`

	// The time when the service role was associated with the account.
	AssociatedAt *string `type:"string"`

	// The ARN of the role which is associated with the account.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s GetServiceRoleForAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceRoleForAccountOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *GetServiceRoleForAccountOutput) SetAssociatedAt(v string) *GetServiceRoleForAccountOutput {
	s.AssociatedAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetServiceRoleForAccountOutput) SetRoleArn(v string) *GetServiceRoleForAccountOutput {
	s.RoleArn = &v
	return s
}

type GetSubscriptionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSubscriptionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSubscriptionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSubscriptionDefinitionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}
	if s.SubscriptionDefinitionId != nil && len(*s.SubscriptionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *GetSubscriptionDefinitionInput) SetSubscriptionDefinitionId(v string) *GetSubscriptionDefinitionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

type GetSubscriptionDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetSubscriptionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSubscriptionDefinitionOutput) SetArn(v string) *GetSubscriptionDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetSubscriptionDefinitionOutput) SetCreationTimestamp(v string) *GetSubscriptionDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSubscriptionDefinitionOutput) SetId(v string) *GetSubscriptionDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetSubscriptionDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetSubscriptionDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetSubscriptionDefinitionOutput) SetLatestVersion(v string) *GetSubscriptionDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetSubscriptionDefinitionOutput) SetLatestVersionArn(v string) *GetSubscriptionDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSubscriptionDefinitionOutput) SetName(v string) *GetSubscriptionDefinitionOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSubscriptionDefinitionOutput) SetTags(v map[string]*string) *GetSubscriptionDefinitionOutput {
	s.Tags = v
	return s
}

type GetSubscriptionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`

	// SubscriptionDefinitionVersionId is a required field
	SubscriptionDefinitionVersionId *string `location:"uri" locationName:"SubscriptionDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSubscriptionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSubscriptionDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSubscriptionDefinitionVersionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}
	if s.SubscriptionDefinitionId != nil && len(*s.SubscriptionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionDefinitionId", 1))
	}
	if s.SubscriptionDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionVersionId"))
	}
	if s.SubscriptionDefinitionVersionId != nil && len(*s.SubscriptionDefinitionVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionDefinitionVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetSubscriptionDefinitionVersionInput) SetNextToken(v string) *GetSubscriptionDefinitionVersionInput {
	s.NextToken = &v
	return s
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *GetSubscriptionDefinitionVersionInput) SetSubscriptionDefinitionId(v string) *GetSubscriptionDefinitionVersionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

// SetSubscriptionDefinitionVersionId sets the SubscriptionDefinitionVersionId field's value.
func (s *GetSubscriptionDefinitionVersionInput) SetSubscriptionDefinitionVersionId(v string) *GetSubscriptionDefinitionVersionInput {
	s.SubscriptionDefinitionVersionId = &v
	return s
}

// Information about a subscription definition version.
type GetSubscriptionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the subscription definition version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the subscription definition
	// version was created.
	CreationTimestamp *string `type:"string"`

	// Information about the subscription definition version.
	Definition *SubscriptionDefinitionVersion `type:"structure"`

	// The ID of the subscription definition version.
	Id *string `type:"string"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`

	// The version of the subscription definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetSubscriptionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetArn(v string) *GetSubscriptionDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetCreationTimestamp(v string) *GetSubscriptionDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetDefinition(v *SubscriptionDefinitionVersion) *GetSubscriptionDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetId(v string) *GetSubscriptionDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetNextToken(v string) *GetSubscriptionDefinitionVersionOutput {
	s.NextToken = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetVersion(v string) *GetSubscriptionDefinitionVersionOutput {
	s.Version = &v
	return s
}

// Information about a certificate authority for a group.
type GroupCertificateAuthorityProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate authority for the group.
	GroupCertificateAuthorityArn *string `type:"string"`

	// The ID of the certificate authority for the group.
	GroupCertificateAuthorityId *string `type:"string"`
}

// String returns the string representation
func (s GroupCertificateAuthorityProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupCertificateAuthorityProperties) GoString() string {
	return s.String()
}

// SetGroupCertificateAuthorityArn sets the GroupCertificateAuthorityArn field's value.
func (s *GroupCertificateAuthorityProperties) SetGroupCertificateAuthorityArn(v string) *GroupCertificateAuthorityProperties {
	s.GroupCertificateAuthorityArn = &v
	return s
}

// SetGroupCertificateAuthorityId sets the GroupCertificateAuthorityId field's value.
func (s *GroupCertificateAuthorityProperties) SetGroupCertificateAuthorityId(v string) *GroupCertificateAuthorityProperties {
	s.GroupCertificateAuthorityId = &v
	return s
}

// Information about a group.
type GroupInformation struct {
	_ struct{} `type:"structure"`

	// The ARN of the group.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the group was created.
	CreationTimestamp *string `type:"string"`

	// The ID of the group.
	Id *string `type:"string"`

	// The time, in milliseconds since the epoch, when the group was last updated.
	LastUpdatedTimestamp *string `type:"string"`

	// The ID of the latest version associated with the group.
	LatestVersion *string `type:"string"`

	// The ARN of the latest version associated with the group.
	LatestVersionArn *string `type:"string"`

	// The name of the group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GroupInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupInformation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GroupInformation) SetArn(v string) *GroupInformation {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GroupInformation) SetCreationTimestamp(v string) *GroupInformation {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GroupInformation) SetId(v string) *GroupInformation {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GroupInformation) SetLastUpdatedTimestamp(v string) *GroupInformation {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GroupInformation) SetLatestVersion(v string) *GroupInformation {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GroupInformation) SetLatestVersionArn(v string) *GroupInformation {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GroupInformation) SetName(v string) *GroupInformation {
	s.Name = &v
	return s
}

// Group owner related settings for local resources.
type GroupOwnerSetting struct {
	_ struct{} `type:"structure"`

	// If true, AWS IoT Greengrass automatically adds the specified Linux OS group
	// owner of the resource to the Lambda process privileges. Thus the Lambda process
	// will have the file access permissions of the added Linux group.
	AutoAddGroupOwner *bool `type:"boolean"`

	// The name of the Linux OS group whose privileges will be added to the Lambda
	// process. This field is optional.
	GroupOwner *string `type:"string"`
}

// String returns the string representation
func (s GroupOwnerSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupOwnerSetting) GoString() string {
	return s.String()
}

// SetAutoAddGroupOwner sets the AutoAddGroupOwner field's value.
func (s *GroupOwnerSetting) SetAutoAddGroupOwner(v bool) *GroupOwnerSetting {
	s.AutoAddGroupOwner = &v
	return s
}

// SetGroupOwner sets the GroupOwner field's value.
func (s *GroupOwnerSetting) SetGroupOwner(v string) *GroupOwnerSetting {
	s.GroupOwner = &v
	return s
}

// Information about a group version.
type GroupVersion struct {
	_ struct{} `type:"structure"`

	// The ARN of the connector definition version for this group.
	ConnectorDefinitionVersionArn *string `type:"string"`

	// The ARN of the core definition version for this group.
	CoreDefinitionVersionArn *string `type:"string"`

	// The ARN of the device definition version for this group.
	DeviceDefinitionVersionArn *string `type:"string"`

	// The ARN of the function definition version for this group.
	FunctionDefinitionVersionArn *string `type:"string"`

	// The ARN of the logger definition version for this group.
	LoggerDefinitionVersionArn *string `type:"string"`

	// The ARN of the resource definition version for this group.
	ResourceDefinitionVersionArn *string `type:"string"`

	// The ARN of the subscription definition version for this group.
	SubscriptionDefinitionVersionArn *string `type:"string"`
}

// String returns the string representation
func (s GroupVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupVersion) GoString() string {
	return s.String()
}

// SetConnectorDefinitionVersionArn sets the ConnectorDefinitionVersionArn field's value.
func (s *GroupVersion) SetConnectorDefinitionVersionArn(v string) *GroupVersion {
	s.ConnectorDefinitionVersionArn = &v
	return s
}

// SetCoreDefinitionVersionArn sets the CoreDefinitionVersionArn field's value.
func (s *GroupVersion) SetCoreDefinitionVersionArn(v string) *GroupVersion {
	s.CoreDefinitionVersionArn = &v
	return s
}

// SetDeviceDefinitionVersionArn sets the DeviceDefinitionVersionArn field's value.
func (s *GroupVersion) SetDeviceDefinitionVersionArn(v string) *GroupVersion {
	s.DeviceDefinitionVersionArn = &v
	return s
}

// SetFunctionDefinitionVersionArn sets the FunctionDefinitionVersionArn field's value.
func (s *GroupVersion) SetFunctionDefinitionVersionArn(v string) *GroupVersion {
	s.FunctionDefinitionVersionArn = &v
	return s
}

// SetLoggerDefinitionVersionArn sets the LoggerDefinitionVersionArn field's value.
func (s *GroupVersion) SetLoggerDefinitionVersionArn(v string) *GroupVersion {
	s.LoggerDefinitionVersionArn = &v
	return s
}

// SetResourceDefinitionVersionArn sets the ResourceDefinitionVersionArn field's value.
func (s *GroupVersion) SetResourceDefinitionVersionArn(v string) *GroupVersion {
	s.ResourceDefinitionVersionArn = &v
	return s
}

// SetSubscriptionDefinitionVersionArn sets the SubscriptionDefinitionVersionArn field's value.
func (s *GroupVersion) SetSubscriptionDefinitionVersionArn(v string) *GroupVersion {
	s.SubscriptionDefinitionVersionArn = &v
	return s
}

// General error information.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of error details.
	ErrorDetails []*ErrorDetail `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListBulkDeploymentDetailedReportsInput struct {
	_ struct{} `type:"structure"`

	// BulkDeploymentId is a required field
	BulkDeploymentId *string `location:"uri" locationName:"BulkDeploymentId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListBulkDeploymentDetailedReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBulkDeploymentDetailedReportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBulkDeploymentDetailedReportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBulkDeploymentDetailedReportsInput"}
	if s.BulkDeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("BulkDeploymentId"))
	}
	if s.BulkDeploymentId != nil && len(*s.BulkDeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BulkDeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBulkDeploymentId sets the BulkDeploymentId field's value.
func (s *ListBulkDeploymentDetailedReportsInput) SetBulkDeploymentId(v string) *ListBulkDeploymentDetailedReportsInput {
	s.BulkDeploymentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBulkDeploymentDetailedReportsInput) SetMaxResults(v string) *ListBulkDeploymentDetailedReportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBulkDeploymentDetailedReportsInput) SetNextToken(v string) *ListBulkDeploymentDetailedReportsInput {
	s.NextToken = &v
	return s
}

type ListBulkDeploymentDetailedReportsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the individual group deployments in the bulk deployment operation.
	Deployments []*BulkDeploymentResult `type:"list"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListBulkDeploymentDetailedReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBulkDeploymentDetailedReportsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *ListBulkDeploymentDetailedReportsOutput) SetDeployments(v []*BulkDeploymentResult) *ListBulkDeploymentDetailedReportsOutput {
	s.Deployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBulkDeploymentDetailedReportsOutput) SetNextToken(v string) *ListBulkDeploymentDetailedReportsOutput {
	s.NextToken = &v
	return s
}

type ListBulkDeploymentsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListBulkDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBulkDeploymentsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBulkDeploymentsInput) SetMaxResults(v string) *ListBulkDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBulkDeploymentsInput) SetNextToken(v string) *ListBulkDeploymentsInput {
	s.NextToken = &v
	return s
}

type ListBulkDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of bulk deployments.
	BulkDeployments []*BulkDeployment `type:"list"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListBulkDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBulkDeploymentsOutput) GoString() string {
	return s.String()
}

// SetBulkDeployments sets the BulkDeployments field's value.
func (s *ListBulkDeploymentsOutput) SetBulkDeployments(v []*BulkDeployment) *ListBulkDeploymentsOutput {
	s.BulkDeployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBulkDeploymentsOutput) SetNextToken(v string) *ListBulkDeploymentsOutput {
	s.NextToken = &v
	return s
}

type ListConnectorDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListConnectorDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConnectorDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConnectorDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConnectorDefinitionVersionsInput"}
	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorDefinitionId"))
	}
	if s.ConnectorDefinitionId != nil && len(*s.ConnectorDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorDefinitionId sets the ConnectorDefinitionId field's value.
func (s *ListConnectorDefinitionVersionsInput) SetConnectorDefinitionId(v string) *ListConnectorDefinitionVersionsInput {
	s.ConnectorDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConnectorDefinitionVersionsInput) SetMaxResults(v string) *ListConnectorDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorDefinitionVersionsInput) SetNextToken(v string) *ListConnectorDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

type ListConnectorDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListConnectorDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConnectorDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorDefinitionVersionsOutput) SetNextToken(v string) *ListConnectorDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListConnectorDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListConnectorDefinitionVersionsOutput {
	s.Versions = v
	return s
}

type ListConnectorDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListConnectorDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConnectorDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConnectorDefinitionsInput) SetMaxResults(v string) *ListConnectorDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorDefinitionsInput) SetNextToken(v string) *ListConnectorDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListConnectorDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListConnectorDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConnectorDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListConnectorDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListConnectorDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConnectorDefinitionsOutput) SetNextToken(v string) *ListConnectorDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListCoreDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListCoreDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCoreDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCoreDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCoreDefinitionVersionsInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}
	if s.CoreDefinitionId != nil && len(*s.CoreDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *ListCoreDefinitionVersionsInput) SetCoreDefinitionId(v string) *ListCoreDefinitionVersionsInput {
	s.CoreDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCoreDefinitionVersionsInput) SetMaxResults(v string) *ListCoreDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDefinitionVersionsInput) SetNextToken(v string) *ListCoreDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

type ListCoreDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListCoreDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCoreDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDefinitionVersionsOutput) SetNextToken(v string) *ListCoreDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListCoreDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListCoreDefinitionVersionsOutput {
	s.Versions = v
	return s
}

type ListCoreDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListCoreDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCoreDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCoreDefinitionsInput) SetMaxResults(v string) *ListCoreDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDefinitionsInput) SetNextToken(v string) *ListCoreDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListCoreDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCoreDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCoreDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListCoreDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListCoreDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDefinitionsOutput) SetNextToken(v string) *ListCoreDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListDeploymentsInput) SetGroupId(v string) *ListDeploymentsInput {
	s.GroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentsInput) SetMaxResults(v string) *ListDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsInput) SetNextToken(v string) *ListDeploymentsInput {
	s.NextToken = &v
	return s
}

type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of deployments for the requested groups.
	Deployments []*Deployment `type:"list"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *ListDeploymentsOutput) SetDeployments(v []*Deployment) *ListDeploymentsOutput {
	s.Deployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsOutput) SetNextToken(v string) *ListDeploymentsOutput {
	s.NextToken = &v
	return s
}

type ListDeviceDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListDeviceDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeviceDefinitionVersionsInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}
	if s.DeviceDefinitionId != nil && len(*s.DeviceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *ListDeviceDefinitionVersionsInput) SetDeviceDefinitionId(v string) *ListDeviceDefinitionVersionsInput {
	s.DeviceDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceDefinitionVersionsInput) SetMaxResults(v string) *ListDeviceDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceDefinitionVersionsInput) SetNextToken(v string) *ListDeviceDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

type ListDeviceDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListDeviceDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceDefinitionVersionsOutput) SetNextToken(v string) *ListDeviceDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListDeviceDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListDeviceDefinitionVersionsOutput {
	s.Versions = v
	return s
}

type ListDeviceDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListDeviceDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceDefinitionsInput) SetMaxResults(v string) *ListDeviceDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceDefinitionsInput) SetNextToken(v string) *ListDeviceDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListDeviceDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDeviceDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListDeviceDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListDeviceDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceDefinitionsOutput) SetNextToken(v string) *ListDeviceDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListFunctionDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListFunctionDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFunctionDefinitionVersionsInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}
	if s.FunctionDefinitionId != nil && len(*s.FunctionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *ListFunctionDefinitionVersionsInput) SetFunctionDefinitionId(v string) *ListFunctionDefinitionVersionsInput {
	s.FunctionDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFunctionDefinitionVersionsInput) SetMaxResults(v string) *ListFunctionDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionDefinitionVersionsInput) SetNextToken(v string) *ListFunctionDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

type ListFunctionDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListFunctionDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionDefinitionVersionsOutput) SetNextToken(v string) *ListFunctionDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListFunctionDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListFunctionDefinitionVersionsOutput {
	s.Versions = v
	return s
}

type ListFunctionDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListFunctionDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFunctionDefinitionsInput) SetMaxResults(v string) *ListFunctionDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionDefinitionsInput) SetNextToken(v string) *ListFunctionDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListFunctionDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListFunctionDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListFunctionDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionDefinitionsOutput) SetNextToken(v string) *ListFunctionDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListGroupCertificateAuthoritiesInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupCertificateAuthoritiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupCertificateAuthoritiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupCertificateAuthoritiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupCertificateAuthoritiesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListGroupCertificateAuthoritiesInput) SetGroupId(v string) *ListGroupCertificateAuthoritiesInput {
	s.GroupId = &v
	return s
}

type ListGroupCertificateAuthoritiesOutput struct {
	_ struct{} `type:"structure"`

	// A list of certificate authorities associated with the group.
	GroupCertificateAuthorities []*GroupCertificateAuthorityProperties `type:"list"`
}

// String returns the string representation
func (s ListGroupCertificateAuthoritiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupCertificateAuthoritiesOutput) GoString() string {
	return s.String()
}

// SetGroupCertificateAuthorities sets the GroupCertificateAuthorities field's value.
func (s *ListGroupCertificateAuthoritiesOutput) SetGroupCertificateAuthorities(v []*GroupCertificateAuthorityProperties) *ListGroupCertificateAuthoritiesOutput {
	s.GroupCertificateAuthorities = v
	return s
}

type ListGroupVersionsInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListGroupVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupVersionsInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListGroupVersionsInput) SetGroupId(v string) *ListGroupVersionsInput {
	s.GroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupVersionsInput) SetMaxResults(v string) *ListGroupVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupVersionsInput) SetNextToken(v string) *ListGroupVersionsInput {
	s.NextToken = &v
	return s
}

type ListGroupVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListGroupVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupVersionsOutput) SetNextToken(v string) *ListGroupVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListGroupVersionsOutput) SetVersions(v []*VersionInformation) *ListGroupVersionsOutput {
	s.Versions = v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v string) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Information about a group.
	Groups []*GroupInformation `type:"list"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*GroupInformation) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

type ListLoggerDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListLoggerDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggerDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLoggerDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLoggerDefinitionVersionsInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}
	if s.LoggerDefinitionId != nil && len(*s.LoggerDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoggerDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *ListLoggerDefinitionVersionsInput) SetLoggerDefinitionId(v string) *ListLoggerDefinitionVersionsInput {
	s.LoggerDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLoggerDefinitionVersionsInput) SetMaxResults(v string) *ListLoggerDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggerDefinitionVersionsInput) SetNextToken(v string) *ListLoggerDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

type ListLoggerDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListLoggerDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggerDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggerDefinitionVersionsOutput) SetNextToken(v string) *ListLoggerDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListLoggerDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListLoggerDefinitionVersionsOutput {
	s.Versions = v
	return s
}

type ListLoggerDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListLoggerDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggerDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLoggerDefinitionsInput) SetMaxResults(v string) *ListLoggerDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggerDefinitionsInput) SetNextToken(v string) *ListLoggerDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListLoggerDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLoggerDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggerDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListLoggerDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListLoggerDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggerDefinitionsOutput) SetNextToken(v string) *ListLoggerDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListResourceDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourceDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceDefinitionVersionsInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}
	if s.ResourceDefinitionId != nil && len(*s.ResourceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceDefinitionVersionsInput) SetMaxResults(v string) *ListResourceDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDefinitionVersionsInput) SetNextToken(v string) *ListResourceDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *ListResourceDefinitionVersionsInput) SetResourceDefinitionId(v string) *ListResourceDefinitionVersionsInput {
	s.ResourceDefinitionId = &v
	return s
}

type ListResourceDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListResourceDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDefinitionVersionsOutput) SetNextToken(v string) *ListResourceDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListResourceDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListResourceDefinitionVersionsOutput {
	s.Versions = v
	return s
}

type ListResourceDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListResourceDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceDefinitionsInput) SetMaxResults(v string) *ListResourceDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDefinitionsInput) SetNextToken(v string) *ListResourceDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListResourceDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourceDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListResourceDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListResourceDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDefinitionsOutput) SetNextToken(v string) *ListResourceDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListSubscriptionDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListSubscriptionDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSubscriptionDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSubscriptionDefinitionVersionsInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}
	if s.SubscriptionDefinitionId != nil && len(*s.SubscriptionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSubscriptionDefinitionVersionsInput) SetMaxResults(v string) *ListSubscriptionDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionDefinitionVersionsInput) SetNextToken(v string) *ListSubscriptionDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *ListSubscriptionDefinitionVersionsInput) SetSubscriptionDefinitionId(v string) *ListSubscriptionDefinitionVersionsInput {
	s.SubscriptionDefinitionId = &v
	return s
}

type ListSubscriptionDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListSubscriptionDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionDefinitionVersionsOutput) SetNextToken(v string) *ListSubscriptionDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListSubscriptionDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListSubscriptionDefinitionVersionsOutput {
	s.Versions = v
	return s
}

type ListSubscriptionDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListSubscriptionDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSubscriptionDefinitionsInput) SetMaxResults(v string) *ListSubscriptionDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionDefinitionsInput) SetNextToken(v string) *ListSubscriptionDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListSubscriptionDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListSubscriptionDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListSubscriptionDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListSubscriptionDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionDefinitionsOutput) SetNextToken(v string) *ListSubscriptionDefinitionsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Attributes that define a local device resource.
type LocalDeviceResourceData struct {
	_ struct{} `type:"structure"`

	// Group/owner related settings for local resources.
	GroupOwnerSetting *GroupOwnerSetting `type:"structure"`

	// The local absolute path of the device resource. The source path for a device
	// resource can refer only to a character device or block device under ''/dev''.
	SourcePath *string `type:"string"`
}

// String returns the string representation
func (s LocalDeviceResourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalDeviceResourceData) GoString() string {
	return s.String()
}

// SetGroupOwnerSetting sets the GroupOwnerSetting field's value.
func (s *LocalDeviceResourceData) SetGroupOwnerSetting(v *GroupOwnerSetting) *LocalDeviceResourceData {
	s.GroupOwnerSetting = v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *LocalDeviceResourceData) SetSourcePath(v string) *LocalDeviceResourceData {
	s.SourcePath = &v
	return s
}

// Attributes that define a local volume resource.
type LocalVolumeResourceData struct {
	_ struct{} `type:"structure"`

	// The absolute local path of the resource inside the Lambda environment.
	DestinationPath *string `type:"string"`

	// Allows you to configure additional group privileges for the Lambda process.
	// This field is optional.
	GroupOwnerSetting *GroupOwnerSetting `type:"structure"`

	// The local absolute path of the volume resource on the host. The source path
	// for a volume resource type cannot start with ''/sys''.
	SourcePath *string `type:"string"`
}

// String returns the string representation
func (s LocalVolumeResourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalVolumeResourceData) GoString() string {
	return s.String()
}

// SetDestinationPath sets the DestinationPath field's value.
func (s *LocalVolumeResourceData) SetDestinationPath(v string) *LocalVolumeResourceData {
	s.DestinationPath = &v
	return s
}

// SetGroupOwnerSetting sets the GroupOwnerSetting field's value.
func (s *LocalVolumeResourceData) SetGroupOwnerSetting(v *GroupOwnerSetting) *LocalVolumeResourceData {
	s.GroupOwnerSetting = v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *LocalVolumeResourceData) SetSourcePath(v string) *LocalVolumeResourceData {
	s.SourcePath = &v
	return s
}

// Information about a logger
type Logger struct {
	_ struct{} `type:"structure"`

	// The component that will be subject to logging.
	//
	// Component is a required field
	Component *string `type:"string" required:"true" enum:"LoggerComponent"`

	// A descriptive or arbitrary ID for the logger. This value must be unique within
	// the logger definition version. Max length is 128 characters with pattern
	// ''[a-zA-Z0-9:_-]+''.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The level of the logs.
	//
	// Level is a required field
	Level *string `type:"string" required:"true" enum:"LoggerLevel"`

	// The amount of file space, in KB, to use if the local file system is used
	// for logging purposes.
	Space *int64 `type:"integer"`

	// The type of log output which will be used.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"LoggerType"`
}

// String returns the string representation
func (s Logger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Logger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Logger) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Logger"}
	if s.Component == nil {
		invalidParams.Add(request.NewErrParamRequired("Component"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponent sets the Component field's value.
func (s *Logger) SetComponent(v string) *Logger {
	s.Component = &v
	return s
}

// SetId sets the Id field's value.
func (s *Logger) SetId(v string) *Logger {
	s.Id = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *Logger) SetLevel(v string) *Logger {
	s.Level = &v
	return s
}

// SetSpace sets the Space field's value.
func (s *Logger) SetSpace(v int64) *Logger {
	s.Space = &v
	return s
}

// SetType sets the Type field's value.
func (s *Logger) SetType(v string) *Logger {
	s.Type = &v
	return s
}

// Information about a logger definition version.
type LoggerDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of loggers.
	Loggers []*Logger `type:"list"`
}

// String returns the string representation
func (s LoggerDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggerDefinitionVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggerDefinitionVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggerDefinitionVersion"}
	if s.Loggers != nil {
		for i, v := range s.Loggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Loggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggers sets the Loggers field's value.
func (s *LoggerDefinitionVersion) SetLoggers(v []*Logger) *LoggerDefinitionVersion {
	s.Loggers = v
	return s
}

// Information about a group reset request.
type ResetDeploymentsInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// If true, performs a best-effort only core reset.
	Force *bool `type:"boolean"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetDeploymentsInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *ResetDeploymentsInput) SetAmznClientToken(v string) *ResetDeploymentsInput {
	s.AmznClientToken = &v
	return s
}

// SetForce sets the Force field's value.
func (s *ResetDeploymentsInput) SetForce(v bool) *ResetDeploymentsInput {
	s.Force = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *ResetDeploymentsInput) SetGroupId(v string) *ResetDeploymentsInput {
	s.GroupId = &v
	return s
}

type ResetDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the deployment.
	DeploymentArn *string `type:"string"`

	// The ID of the deployment.
	DeploymentId *string `type:"string"`
}

// String returns the string representation
func (s ResetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeploymentArn sets the DeploymentArn field's value.
func (s *ResetDeploymentsOutput) SetDeploymentArn(v string) *ResetDeploymentsOutput {
	s.DeploymentArn = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ResetDeploymentsOutput) SetDeploymentId(v string) *ResetDeploymentsOutput {
	s.DeploymentId = &v
	return s
}

// Information about a resource.
type Resource struct {
	_ struct{} `type:"structure"`

	// The resource ID, used to refer to a resource in the Lambda function configuration.
	// Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must
	// be unique within a Greengrass group.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The descriptive resource name, which is displayed on the AWS IoT Greengrass
	// console. Max length 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This
	// must be unique within a Greengrass group.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A container of data for all resource types.
	//
	// ResourceDataContainer is a required field
	ResourceDataContainer *ResourceDataContainer `type:"structure" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ResourceDataContainer == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDataContainer"))
	}
	if s.ResourceDataContainer != nil {
		if err := s.ResourceDataContainer.Validate(); err != nil {
			invalidParams.AddNested("ResourceDataContainer", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Resource) SetName(v string) *Resource {
	s.Name = &v
	return s
}

// SetResourceDataContainer sets the ResourceDataContainer field's value.
func (s *Resource) SetResourceDataContainer(v *ResourceDataContainer) *Resource {
	s.ResourceDataContainer = v
	return s
}

// A policy used by the function to access a resource.
type ResourceAccessPolicy struct {
	_ struct{} `type:"structure"`

	// The permissions that the Lambda function has to the resource. Can be one
	// of ''rw'' (read/write) or ''ro'' (read-only).
	Permission *string `type:"string" enum:"Permission"`

	// The ID of the resource. (This ID is assigned to the resource when you create
	// the resource definiton.)
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceAccessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAccessPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceAccessPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceAccessPolicy"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermission sets the Permission field's value.
func (s *ResourceAccessPolicy) SetPermission(v string) *ResourceAccessPolicy {
	s.Permission = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceAccessPolicy) SetResourceId(v string) *ResourceAccessPolicy {
	s.ResourceId = &v
	return s
}

// A container for resource data. The container takes only one of the following
// supported resource data types: ''LocalDeviceResourceData'', ''LocalVolumeResourceData'',
// ''SageMakerMachineLearningModelResourceData'', ''S3MachineLearningModelResourceData'',
// ''SecretsManagerSecretResourceData''.
type ResourceDataContainer struct {
	_ struct{} `type:"structure"`

	// Attributes that define the local device resource.
	LocalDeviceResourceData *LocalDeviceResourceData `type:"structure"`

	// Attributes that define the local volume resource.
	LocalVolumeResourceData *LocalVolumeResourceData `type:"structure"`

	// Attributes that define an Amazon S3 machine learning resource.
	S3MachineLearningModelResourceData *S3MachineLearningModelResourceData `type:"structure"`

	// Attributes that define an Amazon SageMaker machine learning resource.
	SageMakerMachineLearningModelResourceData *SageMakerMachineLearningModelResourceData `type:"structure"`

	// Attributes that define a secret resource, which references a secret from
	// AWS Secrets Manager.
	SecretsManagerSecretResourceData *SecretsManagerSecretResourceData `type:"structure"`
}

// String returns the string representation
func (s ResourceDataContainer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDataContainer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDataContainer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceDataContainer"}
	if s.S3MachineLearningModelResourceData != nil {
		if err := s.S3MachineLearningModelResourceData.Validate(); err != nil {
			invalidParams.AddNested("S3MachineLearningModelResourceData", err.(request.ErrInvalidParams))
		}
	}
	if s.SageMakerMachineLearningModelResourceData != nil {
		if err := s.SageMakerMachineLearningModelResourceData.Validate(); err != nil {
			invalidParams.AddNested("SageMakerMachineLearningModelResourceData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocalDeviceResourceData sets the LocalDeviceResourceData field's value.
func (s *ResourceDataContainer) SetLocalDeviceResourceData(v *LocalDeviceResourceData) *ResourceDataContainer {
	s.LocalDeviceResourceData = v
	return s
}

// SetLocalVolumeResourceData sets the LocalVolumeResourceData field's value.
func (s *ResourceDataContainer) SetLocalVolumeResourceData(v *LocalVolumeResourceData) *ResourceDataContainer {
	s.LocalVolumeResourceData = v
	return s
}

// SetS3MachineLearningModelResourceData sets the S3MachineLearningModelResourceData field's value.
func (s *ResourceDataContainer) SetS3MachineLearningModelResourceData(v *S3MachineLearningModelResourceData) *ResourceDataContainer {
	s.S3MachineLearningModelResourceData = v
	return s
}

// SetSageMakerMachineLearningModelResourceData sets the SageMakerMachineLearningModelResourceData field's value.
func (s *ResourceDataContainer) SetSageMakerMachineLearningModelResourceData(v *SageMakerMachineLearningModelResourceData) *ResourceDataContainer {
	s.SageMakerMachineLearningModelResourceData = v
	return s
}

// SetSecretsManagerSecretResourceData sets the SecretsManagerSecretResourceData field's value.
func (s *ResourceDataContainer) SetSecretsManagerSecretResourceData(v *SecretsManagerSecretResourceData) *ResourceDataContainer {
	s.SecretsManagerSecretResourceData = v
	return s
}

// Information about a resource definition version.
type ResourceDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of resources.
	Resources []*Resource `type:"list"`
}

// String returns the string representation
func (s ResourceDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDefinitionVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDefinitionVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceDefinitionVersion"}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResources sets the Resources field's value.
func (s *ResourceDefinitionVersion) SetResources(v []*Resource) *ResourceDefinitionVersion {
	s.Resources = v
	return s
}

// The owner setting for downloaded machine learning resources.
type ResourceDownloadOwnerSetting struct {
	_ struct{} `type:"structure"`

	// The group owner of the resource. This is the name of an existing Linux OS
	// group on the system or a GID. The group's permissions are added to the Lambda
	// process.
	//
	// GroupOwner is a required field
	GroupOwner *string `type:"string" required:"true"`

	// The permissions that the group owner has to the resource. Valid values are
	// ''rw'' (read/write) or ''ro'' (read-only).
	//
	// GroupPermission is a required field
	GroupPermission *string `type:"string" required:"true" enum:"Permission"`
}

// String returns the string representation
func (s ResourceDownloadOwnerSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDownloadOwnerSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDownloadOwnerSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceDownloadOwnerSetting"}
	if s.GroupOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupOwner"))
	}
	if s.GroupPermission == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupPermission"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupOwner sets the GroupOwner field's value.
func (s *ResourceDownloadOwnerSetting) SetGroupOwner(v string) *ResourceDownloadOwnerSetting {
	s.GroupOwner = &v
	return s
}

// SetGroupPermission sets the GroupPermission field's value.
func (s *ResourceDownloadOwnerSetting) SetGroupPermission(v string) *ResourceDownloadOwnerSetting {
	s.GroupPermission = &v
	return s
}

// Attributes that define an Amazon S3 machine learning resource.
type S3MachineLearningModelResourceData struct {
	_ struct{} `type:"structure"`

	// The absolute local path of the resource inside the Lambda environment.
	DestinationPath *string `type:"string"`

	// The owner setting for downloaded machine learning resources.
	OwnerSetting *ResourceDownloadOwnerSetting `type:"structure"`

	// The URI of the source model in an S3 bucket. The model package must be in
	// tar.gz or .zip format.
	S3Uri *string `type:"string"`
}

// String returns the string representation
func (s S3MachineLearningModelResourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3MachineLearningModelResourceData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3MachineLearningModelResourceData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3MachineLearningModelResourceData"}
	if s.OwnerSetting != nil {
		if err := s.OwnerSetting.Validate(); err != nil {
			invalidParams.AddNested("OwnerSetting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationPath sets the DestinationPath field's value.
func (s *S3MachineLearningModelResourceData) SetDestinationPath(v string) *S3MachineLearningModelResourceData {
	s.DestinationPath = &v
	return s
}

// SetOwnerSetting sets the OwnerSetting field's value.
func (s *S3MachineLearningModelResourceData) SetOwnerSetting(v *ResourceDownloadOwnerSetting) *S3MachineLearningModelResourceData {
	s.OwnerSetting = v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *S3MachineLearningModelResourceData) SetS3Uri(v string) *S3MachineLearningModelResourceData {
	s.S3Uri = &v
	return s
}

// Attributes that define an Amazon SageMaker machine learning resource.
type SageMakerMachineLearningModelResourceData struct {
	_ struct{} `type:"structure"`

	// The absolute local path of the resource inside the Lambda environment.
	DestinationPath *string `type:"string"`

	// The owner setting for downloaded machine learning resources.
	OwnerSetting *ResourceDownloadOwnerSetting `type:"structure"`

	// The ARN of the Amazon SageMaker training job that represents the source model.
	SageMakerJobArn *string `type:"string"`
}

// String returns the string representation
func (s SageMakerMachineLearningModelResourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SageMakerMachineLearningModelResourceData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SageMakerMachineLearningModelResourceData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SageMakerMachineLearningModelResourceData"}
	if s.OwnerSetting != nil {
		if err := s.OwnerSetting.Validate(); err != nil {
			invalidParams.AddNested("OwnerSetting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationPath sets the DestinationPath field's value.
func (s *SageMakerMachineLearningModelResourceData) SetDestinationPath(v string) *SageMakerMachineLearningModelResourceData {
	s.DestinationPath = &v
	return s
}

// SetOwnerSetting sets the OwnerSetting field's value.
func (s *SageMakerMachineLearningModelResourceData) SetOwnerSetting(v *ResourceDownloadOwnerSetting) *SageMakerMachineLearningModelResourceData {
	s.OwnerSetting = v
	return s
}

// SetSageMakerJobArn sets the SageMakerJobArn field's value.
func (s *SageMakerMachineLearningModelResourceData) SetSageMakerJobArn(v string) *SageMakerMachineLearningModelResourceData {
	s.SageMakerJobArn = &v
	return s
}

// Attributes that define a secret resource, which references a secret from
// AWS Secrets Manager. AWS IoT Greengrass stores a local, encrypted copy of
// the secret on the Greengrass core, where it can be securely accessed by connectors
// and Lambda functions.
type SecretsManagerSecretResourceData struct {
	_ struct{} `type:"structure"`

	// The ARN of the Secrets Manager secret to make available on the core. The
	// value of the secret's latest version (represented by the ''AWSCURRENT'' staging
	// label) is included by default.
	ARN *string `type:"string"`

	// Optional. The staging labels whose values you want to make available on the
	// core, in addition to ''AWSCURRENT''.
	AdditionalStagingLabelsToDownload []*string `type:"list"`
}

// String returns the string representation
func (s SecretsManagerSecretResourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecretsManagerSecretResourceData) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *SecretsManagerSecretResourceData) SetARN(v string) *SecretsManagerSecretResourceData {
	s.ARN = &v
	return s
}

// SetAdditionalStagingLabelsToDownload sets the AdditionalStagingLabelsToDownload field's value.
func (s *SecretsManagerSecretResourceData) SetAdditionalStagingLabelsToDownload(v []*string) *SecretsManagerSecretResourceData {
	s.AdditionalStagingLabelsToDownload = v
	return s
}

// Information about a bulk deployment. You cannot start a new bulk deployment
// while another one is still running or in a non-terminal state.
type StartBulkDeploymentInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// The ARN of the execution role to associate with the bulk deployment operation.
	// This IAM role must allow the ''greengrass:CreateDeployment'' action for all
	// group versions that are listed in the input file. This IAM role must have
	// access to the S3 bucket containing the input file.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `type:"string" required:"true"`

	// The URI of the input file contained in the S3 bucket. The execution role
	// must have ''getObject'' permissions on this bucket to access the input file.
	// The input file is a JSON-serialized, line delimited file with UTF-8 encoding
	// that provides a list of group and version IDs and the deployment type. This
	// file must be less than 100 MB. Currently, AWS IoT Greengrass supports only
	// ''NewDeployment'' deployment types.
	//
	// InputFileUri is a required field
	InputFileUri *string `type:"string" required:"true"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StartBulkDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartBulkDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartBulkDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartBulkDeploymentInput"}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.InputFileUri == nil {
		invalidParams.Add(request.NewErrParamRequired("InputFileUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *StartBulkDeploymentInput) SetAmznClientToken(v string) *StartBulkDeploymentInput {
	s.AmznClientToken = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *StartBulkDeploymentInput) SetExecutionRoleArn(v string) *StartBulkDeploymentInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetInputFileUri sets the InputFileUri field's value.
func (s *StartBulkDeploymentInput) SetInputFileUri(v string) *StartBulkDeploymentInput {
	s.InputFileUri = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartBulkDeploymentInput) SetTags(v map[string]*string) *StartBulkDeploymentInput {
	s.Tags = v
	return s
}

type StartBulkDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the bulk deployment.
	BulkDeploymentArn *string `type:"string"`

	// The ID of the bulk deployment.
	BulkDeploymentId *string `type:"string"`
}

// String returns the string representation
func (s StartBulkDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartBulkDeploymentOutput) GoString() string {
	return s.String()
}

// SetBulkDeploymentArn sets the BulkDeploymentArn field's value.
func (s *StartBulkDeploymentOutput) SetBulkDeploymentArn(v string) *StartBulkDeploymentOutput {
	s.BulkDeploymentArn = &v
	return s
}

// SetBulkDeploymentId sets the BulkDeploymentId field's value.
func (s *StartBulkDeploymentOutput) SetBulkDeploymentId(v string) *StartBulkDeploymentOutput {
	s.BulkDeploymentId = &v
	return s
}

type StopBulkDeploymentInput struct {
	_ struct{} `type:"structure"`

	// BulkDeploymentId is a required field
	BulkDeploymentId *string `location:"uri" locationName:"BulkDeploymentId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopBulkDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopBulkDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopBulkDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopBulkDeploymentInput"}
	if s.BulkDeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("BulkDeploymentId"))
	}
	if s.BulkDeploymentId != nil && len(*s.BulkDeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BulkDeploymentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBulkDeploymentId sets the BulkDeploymentId field's value.
func (s *StopBulkDeploymentInput) SetBulkDeploymentId(v string) *StopBulkDeploymentInput {
	s.BulkDeploymentId = &v
	return s
}

type StopBulkDeploymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopBulkDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopBulkDeploymentOutput) GoString() string {
	return s.String()
}

// Information about a subscription.
type Subscription struct {
	_ struct{} `type:"structure"`

	// A descriptive or arbitrary ID for the subscription. This value must be unique
	// within the subscription definition version. Max length is 128 characters
	// with pattern ''[a-zA-Z0-9:_-]+''.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The source of the subscription. Can be a thing ARN, a Lambda function ARN,
	// a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
	//
	// Source is a required field
	Source *string `type:"string" required:"true"`

	// The MQTT topic used to route the message.
	//
	// Subject is a required field
	Subject *string `type:"string" required:"true"`

	// Where the message is sent to. Can be a thing ARN, a Lambda function ARN,
	// a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
	//
	// Target is a required field
	Target *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Subscription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Subscription"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *Subscription) SetId(v string) *Subscription {
	s.Id = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Subscription) SetSource(v string) *Subscription {
	s.Source = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *Subscription) SetSubject(v string) *Subscription {
	s.Subject = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *Subscription) SetTarget(v string) *Subscription {
	s.Target = &v
	return s
}

// Information about a subscription definition version.
type SubscriptionDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of subscriptions.
	Subscriptions []*Subscription `type:"list"`
}

// String returns the string representation
func (s SubscriptionDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscriptionDefinitionVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscriptionDefinitionVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubscriptionDefinitionVersion"}
	if s.Subscriptions != nil {
		for i, v := range s.Subscriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *SubscriptionDefinitionVersion) SetSubscriptions(v []*Subscription) *SubscriptionDefinitionVersion {
	s.Subscriptions = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// The key-value pair for the resource tag.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Information required to update a Greengrass core's connectivity.
type UpdateConnectivityInfoInput struct {
	_ struct{} `type:"structure"`

	// A list of connectivity info.
	ConnectivityInfo []*ConnectivityInfo `type:"list"`

	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"ThingName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConnectivityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectivityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectivityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectivityInfoInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *UpdateConnectivityInfoInput) SetConnectivityInfo(v []*ConnectivityInfo) *UpdateConnectivityInfoInput {
	s.ConnectivityInfo = v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *UpdateConnectivityInfoInput) SetThingName(v string) *UpdateConnectivityInfoInput {
	s.ThingName = &v
	return s
}

type UpdateConnectivityInfoOutput struct {
	_ struct{} `type:"structure"`

	// A message about the connectivity info update request.
	Message *string `locationName:"message" type:"string"`

	// The new version of the connectivity info.
	Version *string `type:"string"`
}

// String returns the string representation
func (s UpdateConnectivityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectivityInfoOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *UpdateConnectivityInfoOutput) SetMessage(v string) *UpdateConnectivityInfoOutput {
	s.Message = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateConnectivityInfoOutput) SetVersion(v string) *UpdateConnectivityInfoOutput {
	s.Version = &v
	return s
}

type UpdateConnectorDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateConnectorDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectorDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectorDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectorDefinitionInput"}
	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorDefinitionId"))
	}
	if s.ConnectorDefinitionId != nil && len(*s.ConnectorDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectorDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorDefinitionId sets the ConnectorDefinitionId field's value.
func (s *UpdateConnectorDefinitionInput) SetConnectorDefinitionId(v string) *UpdateConnectorDefinitionInput {
	s.ConnectorDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConnectorDefinitionInput) SetName(v string) *UpdateConnectorDefinitionInput {
	s.Name = &v
	return s
}

type UpdateConnectorDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConnectorDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectorDefinitionOutput) GoString() string {
	return s.String()
}

type UpdateCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCoreDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCoreDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCoreDefinitionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}
	if s.CoreDefinitionId != nil && len(*s.CoreDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CoreDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *UpdateCoreDefinitionInput) SetCoreDefinitionId(v string) *UpdateCoreDefinitionInput {
	s.CoreDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCoreDefinitionInput) SetName(v string) *UpdateCoreDefinitionInput {
	s.Name = &v
	return s
}

type UpdateCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCoreDefinitionOutput) GoString() string {
	return s.String()
}

type UpdateDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceDefinitionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}
	if s.DeviceDefinitionId != nil && len(*s.DeviceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *UpdateDeviceDefinitionInput) SetDeviceDefinitionId(v string) *UpdateDeviceDefinitionInput {
	s.DeviceDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDeviceDefinitionInput) SetName(v string) *UpdateDeviceDefinitionInput {
	s.Name = &v
	return s
}

type UpdateDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceDefinitionOutput) GoString() string {
	return s.String()
}

type UpdateFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionDefinitionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}
	if s.FunctionDefinitionId != nil && len(*s.FunctionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *UpdateFunctionDefinitionInput) SetFunctionDefinitionId(v string) *UpdateFunctionDefinitionInput {
	s.FunctionDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFunctionDefinitionInput) SetName(v string) *UpdateFunctionDefinitionInput {
	s.Name = &v
	return s
}

type UpdateFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionDefinitionOutput) GoString() string {
	return s.String()
}

type UpdateGroupCertificateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The amount of time remaining before the certificate expires, in milliseconds.
	CertificateExpiryInMilliseconds *string `type:"string"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGroupCertificateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupCertificateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupCertificateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupCertificateConfigurationInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateExpiryInMilliseconds sets the CertificateExpiryInMilliseconds field's value.
func (s *UpdateGroupCertificateConfigurationInput) SetCertificateExpiryInMilliseconds(v string) *UpdateGroupCertificateConfigurationInput {
	s.CertificateExpiryInMilliseconds = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateGroupCertificateConfigurationInput) SetGroupId(v string) *UpdateGroupCertificateConfigurationInput {
	s.GroupId = &v
	return s
}

type UpdateGroupCertificateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	CertificateAuthorityExpiryInMilliseconds *string `type:"string"`

	CertificateExpiryInMilliseconds *string `type:"string"`

	GroupId *string `type:"string"`
}

// String returns the string representation
func (s UpdateGroupCertificateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupCertificateConfigurationOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthorityExpiryInMilliseconds sets the CertificateAuthorityExpiryInMilliseconds field's value.
func (s *UpdateGroupCertificateConfigurationOutput) SetCertificateAuthorityExpiryInMilliseconds(v string) *UpdateGroupCertificateConfigurationOutput {
	s.CertificateAuthorityExpiryInMilliseconds = &v
	return s
}

// SetCertificateExpiryInMilliseconds sets the CertificateExpiryInMilliseconds field's value.
func (s *UpdateGroupCertificateConfigurationOutput) SetCertificateExpiryInMilliseconds(v string) *UpdateGroupCertificateConfigurationOutput {
	s.CertificateExpiryInMilliseconds = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateGroupCertificateConfigurationOutput) SetGroupId(v string) *UpdateGroupCertificateConfigurationOutput {
	s.GroupId = &v
	return s
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateGroupInput) SetGroupId(v string) *UpdateGroupInput {
	s.GroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGroupInput) SetName(v string) *UpdateGroupInput {
	s.Name = &v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

type UpdateLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoggerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLoggerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLoggerDefinitionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}
	if s.LoggerDefinitionId != nil && len(*s.LoggerDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LoggerDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *UpdateLoggerDefinitionInput) SetLoggerDefinitionId(v string) *UpdateLoggerDefinitionInput {
	s.LoggerDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLoggerDefinitionInput) SetName(v string) *UpdateLoggerDefinitionInput {
	s.Name = &v
	return s
}

type UpdateLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoggerDefinitionOutput) GoString() string {
	return s.String()
}

type UpdateResourceDefinitionInput struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceDefinitionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}
	if s.ResourceDefinitionId != nil && len(*s.ResourceDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateResourceDefinitionInput) SetName(v string) *UpdateResourceDefinitionInput {
	s.Name = &v
	return s
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *UpdateResourceDefinitionInput) SetResourceDefinitionId(v string) *UpdateResourceDefinitionInput {
	s.ResourceDefinitionId = &v
	return s
}

type UpdateResourceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceDefinitionOutput) GoString() string {
	return s.String()
}

type UpdateSubscriptionDefinitionInput struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSubscriptionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSubscriptionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubscriptionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubscriptionDefinitionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}
	if s.SubscriptionDefinitionId != nil && len(*s.SubscriptionDefinitionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscriptionDefinitionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateSubscriptionDefinitionInput) SetName(v string) *UpdateSubscriptionDefinitionInput {
	s.Name = &v
	return s
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *UpdateSubscriptionDefinitionInput) SetSubscriptionDefinitionId(v string) *UpdateSubscriptionDefinitionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

type UpdateSubscriptionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSubscriptionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSubscriptionDefinitionOutput) GoString() string {
	return s.String()
}

// Information about a version.
type VersionInformation struct {
	_ struct{} `type:"structure"`

	// The ARN of the version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the version was created.
	CreationTimestamp *string `type:"string"`

	// The ID of the parent definition that the version is associated with.
	Id *string `type:"string"`

	// The ID of the version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s VersionInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersionInformation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VersionInformation) SetArn(v string) *VersionInformation {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *VersionInformation) SetCreationTimestamp(v string) *VersionInformation {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *VersionInformation) SetId(v string) *VersionInformation {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *VersionInformation) SetVersion(v string) *VersionInformation {
	s.Version = &v
	return s
}

// The current status of the bulk deployment.
const (
	// BulkDeploymentStatusInitializing is a BulkDeploymentStatus enum value
	BulkDeploymentStatusInitializing = "Initializing"

	// BulkDeploymentStatusRunning is a BulkDeploymentStatus enum value
	BulkDeploymentStatusRunning = "Running"

	// BulkDeploymentStatusCompleted is a BulkDeploymentStatus enum value
	BulkDeploymentStatusCompleted = "Completed"

	// BulkDeploymentStatusStopping is a BulkDeploymentStatus enum value
	BulkDeploymentStatusStopping = "Stopping"

	// BulkDeploymentStatusStopped is a BulkDeploymentStatus enum value
	BulkDeploymentStatusStopped = "Stopped"

	// BulkDeploymentStatusFailed is a BulkDeploymentStatus enum value
	BulkDeploymentStatusFailed = "Failed"
)

// BulkDeploymentStatus_Values returns all elements of the BulkDeploymentStatus enum
func BulkDeploymentStatus_Values() []string {
	return []string{
		BulkDeploymentStatusInitializing,
		BulkDeploymentStatusRunning,
		BulkDeploymentStatusCompleted,
		BulkDeploymentStatusStopping,
		BulkDeploymentStatusStopped,
		BulkDeploymentStatusFailed,
	}
}

// The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment''
// and ''Redeployment'' are valid.
const (
	// DeploymentTypeNewDeployment is a DeploymentType enum value
	DeploymentTypeNewDeployment = "NewDeployment"

	// DeploymentTypeRedeployment is a DeploymentType enum value
	DeploymentTypeRedeployment = "Redeployment"

	// DeploymentTypeResetDeployment is a DeploymentType enum value
	DeploymentTypeResetDeployment = "ResetDeployment"

	// DeploymentTypeForceResetDeployment is a DeploymentType enum value
	DeploymentTypeForceResetDeployment = "ForceResetDeployment"
)

// DeploymentType_Values returns all elements of the DeploymentType enum
func DeploymentType_Values() []string {
	return []string{
		DeploymentTypeNewDeployment,
		DeploymentTypeRedeployment,
		DeploymentTypeResetDeployment,
		DeploymentTypeForceResetDeployment,
	}
}

const (
	// EncodingTypeBinary is a EncodingType enum value
	EncodingTypeBinary = "binary"

	// EncodingTypeJson is a EncodingType enum value
	EncodingTypeJson = "json"
)

// EncodingType_Values returns all elements of the EncodingType enum
func EncodingType_Values() []string {
	return []string{
		EncodingTypeBinary,
		EncodingTypeJson,
	}
}

// Specifies whether the Lambda function runs in a Greengrass container (default)
// or without containerization. Unless your scenario requires that you run without
// containerization, we recommend that you run in a Greengrass container. Omit
// this value to run the Lambda function with the default containerization for
// the group.
const (
	// FunctionIsolationModeGreengrassContainer is a FunctionIsolationMode enum value
	FunctionIsolationModeGreengrassContainer = "GreengrassContainer"

	// FunctionIsolationModeNoContainer is a FunctionIsolationMode enum value
	FunctionIsolationModeNoContainer = "NoContainer"
)

// FunctionIsolationMode_Values returns all elements of the FunctionIsolationMode enum
func FunctionIsolationMode_Values() []string {
	return []string{
		FunctionIsolationModeGreengrassContainer,
		FunctionIsolationModeNoContainer,
	}
}

const (
	// LoggerComponentGreengrassSystem is a LoggerComponent enum value
	LoggerComponentGreengrassSystem = "GreengrassSystem"

	// LoggerComponentLambda is a LoggerComponent enum value
	LoggerComponentLambda = "Lambda"
)

// LoggerComponent_Values returns all elements of the LoggerComponent enum
func LoggerComponent_Values() []string {
	return []string{
		LoggerComponentGreengrassSystem,
		LoggerComponentLambda,
	}
}

const (
	// LoggerLevelDebug is a LoggerLevel enum value
	LoggerLevelDebug = "DEBUG"

	// LoggerLevelInfo is a LoggerLevel enum value
	LoggerLevelInfo = "INFO"

	// LoggerLevelWarn is a LoggerLevel enum value
	LoggerLevelWarn = "WARN"

	// LoggerLevelError is a LoggerLevel enum value
	LoggerLevelError = "ERROR"

	// LoggerLevelFatal is a LoggerLevel enum value
	LoggerLevelFatal = "FATAL"
)

// LoggerLevel_Values returns all elements of the LoggerLevel enum
func LoggerLevel_Values() []string {
	return []string{
		LoggerLevelDebug,
		LoggerLevelInfo,
		LoggerLevelWarn,
		LoggerLevelError,
		LoggerLevelFatal,
	}
}

const (
	// LoggerTypeFileSystem is a LoggerType enum value
	LoggerTypeFileSystem = "FileSystem"

	// LoggerTypeAwscloudWatch is a LoggerType enum value
	LoggerTypeAwscloudWatch = "AWSCloudWatch"
)

// LoggerType_Values returns all elements of the LoggerType enum
func LoggerType_Values() []string {
	return []string{
		LoggerTypeFileSystem,
		LoggerTypeAwscloudWatch,
	}
}

// The type of permission a function has to access a resource.
const (
	// PermissionRo is a Permission enum value
	PermissionRo = "ro"

	// PermissionRw is a Permission enum value
	PermissionRw = "rw"
)

// Permission_Values returns all elements of the Permission enum
func Permission_Values() []string {
	return []string{
		PermissionRo,
		PermissionRw,
	}
}

// The piece of software on the Greengrass core that will be updated.
const (
	// SoftwareToUpdateCore is a SoftwareToUpdate enum value
	SoftwareToUpdateCore = "core"

	// SoftwareToUpdateOtaAgent is a SoftwareToUpdate enum value
	SoftwareToUpdateOtaAgent = "ota_agent"
)

// SoftwareToUpdate_Values returns all elements of the SoftwareToUpdate enum
func SoftwareToUpdate_Values() []string {
	return []string{
		SoftwareToUpdateCore,
		SoftwareToUpdateOtaAgent,
	}
}

// The minimum level of log statements that should be logged by the OTA Agent
// during an update.
const (
	// UpdateAgentLogLevelNone is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelNone = "NONE"

	// UpdateAgentLogLevelTrace is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelTrace = "TRACE"

	// UpdateAgentLogLevelDebug is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelDebug = "DEBUG"

	// UpdateAgentLogLevelVerbose is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelVerbose = "VERBOSE"

	// UpdateAgentLogLevelInfo is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelInfo = "INFO"

	// UpdateAgentLogLevelWarn is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelWarn = "WARN"

	// UpdateAgentLogLevelError is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelError = "ERROR"

	// UpdateAgentLogLevelFatal is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelFatal = "FATAL"
)

// UpdateAgentLogLevel_Values returns all elements of the UpdateAgentLogLevel enum
func UpdateAgentLogLevel_Values() []string {
	return []string{
		UpdateAgentLogLevelNone,
		UpdateAgentLogLevelTrace,
		UpdateAgentLogLevelDebug,
		UpdateAgentLogLevelVerbose,
		UpdateAgentLogLevelInfo,
		UpdateAgentLogLevelWarn,
		UpdateAgentLogLevelError,
		UpdateAgentLogLevelFatal,
	}
}

// The architecture of the cores which are the targets of an update.
const (
	// UpdateTargetsArchitectureArmv6l is a UpdateTargetsArchitecture enum value
	UpdateTargetsArchitectureArmv6l = "armv6l"

	// UpdateTargetsArchitectureArmv7l is a UpdateTargetsArchitecture enum value
	UpdateTargetsArchitectureArmv7l = "armv7l"

	// UpdateTargetsArchitectureX8664 is a UpdateTargetsArchitecture enum value
	UpdateTargetsArchitectureX8664 = "x86_64"

	// UpdateTargetsArchitectureAarch64 is a UpdateTargetsArchitecture enum value
	UpdateTargetsArchitectureAarch64 = "aarch64"
)

// UpdateTargetsArchitecture_Values returns all elements of the UpdateTargetsArchitecture enum
func UpdateTargetsArchitecture_Values() []string {
	return []string{
		UpdateTargetsArchitectureArmv6l,
		UpdateTargetsArchitectureArmv7l,
		UpdateTargetsArchitectureX8664,
		UpdateTargetsArchitectureAarch64,
	}
}

// The operating system of the cores which are the targets of an update.
const (
	// UpdateTargetsOperatingSystemUbuntu is a UpdateTargetsOperatingSystem enum value
	UpdateTargetsOperatingSystemUbuntu = "ubuntu"

	// UpdateTargetsOperatingSystemRaspbian is a UpdateTargetsOperatingSystem enum value
	UpdateTargetsOperatingSystemRaspbian = "raspbian"

	// UpdateTargetsOperatingSystemAmazonLinux is a UpdateTargetsOperatingSystem enum value
	UpdateTargetsOperatingSystemAmazonLinux = "amazon_linux"

	// UpdateTargetsOperatingSystemOpenwrt is a UpdateTargetsOperatingSystem enum value
	UpdateTargetsOperatingSystemOpenwrt = "openwrt"
)

// UpdateTargetsOperatingSystem_Values returns all elements of the UpdateTargetsOperatingSystem enum
func UpdateTargetsOperatingSystem_Values() []string {
	return []string{
		UpdateTargetsOperatingSystemUbuntu,
		UpdateTargetsOperatingSystemRaspbian,
		UpdateTargetsOperatingSystemAmazonLinux,
		UpdateTargetsOperatingSystemOpenwrt,
	}
}
