// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateRoleToGroup = "AssociateRoleToGroup"

// AssociateRoleToGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociateRoleToGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateRoleToGroup for more information on using the AssociateRoleToGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateRoleToGroupRequest method.
//    req, resp := client.AssociateRoleToGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup
func (c *Greengrass) AssociateRoleToGroupRequest(input *AssociateRoleToGroupInput) (req *request.Request, output *AssociateRoleToGroupOutput) {
	op := &request.Operation{
		Name:       opAssociateRoleToGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/groups/{GroupId}/role",
	}

	if input == nil {
		input = &AssociateRoleToGroupInput{}
	}

	output = &AssociateRoleToGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateRoleToGroup API operation for AWS Greengrass.
//
// Associates a role with a group. The role will be used by the AWS Greengrass
// core in order to access AWS cloud services. The role's permissions will allow
// Greengrass core Lambda functions to perform actions against the cloud.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation AssociateRoleToGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup
func (c *Greengrass) AssociateRoleToGroup(input *AssociateRoleToGroupInput) (*AssociateRoleToGroupOutput, error) {
	req, out := c.AssociateRoleToGroupRequest(input)
	return out, req.Send()
}

// AssociateRoleToGroupWithContext is the same as AssociateRoleToGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRoleToGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) AssociateRoleToGroupWithContext(ctx aws.Context, input *AssociateRoleToGroupInput, opts ...request.Option) (*AssociateRoleToGroupOutput, error) {
	req, out := c.AssociateRoleToGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateServiceRoleToAccount = "AssociateServiceRoleToAccount"

// AssociateServiceRoleToAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateServiceRoleToAccount operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateServiceRoleToAccount for more information on using the AssociateServiceRoleToAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateServiceRoleToAccountRequest method.
//    req, resp := client.AssociateServiceRoleToAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount
func (c *Greengrass) AssociateServiceRoleToAccountRequest(input *AssociateServiceRoleToAccountInput) (req *request.Request, output *AssociateServiceRoleToAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateServiceRoleToAccount,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &AssociateServiceRoleToAccountInput{}
	}

	output = &AssociateServiceRoleToAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateServiceRoleToAccount API operation for AWS Greengrass.
//
// Associates a role which is used by AWS Greengrass. AWS Greengrass uses the
// role to access your Lambda functions and AWS IoT resources. This is necessary
// for deployments to succeed. It needs to have minimum permissions in policy
// ``AWSGreengrassResourceAccessRolePolicy``
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation AssociateServiceRoleToAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount
func (c *Greengrass) AssociateServiceRoleToAccount(input *AssociateServiceRoleToAccountInput) (*AssociateServiceRoleToAccountOutput, error) {
	req, out := c.AssociateServiceRoleToAccountRequest(input)
	return out, req.Send()
}

// AssociateServiceRoleToAccountWithContext is the same as AssociateServiceRoleToAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateServiceRoleToAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) AssociateServiceRoleToAccountWithContext(ctx aws.Context, input *AssociateServiceRoleToAccountInput, opts ...request.Option) (*AssociateServiceRoleToAccountOutput, error) {
	req, out := c.AssociateServiceRoleToAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCoreDefinition = "CreateCoreDefinition"

// CreateCoreDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCoreDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCoreDefinition for more information on using the CreateCoreDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCoreDefinitionRequest method.
//    req, resp := client.CreateCoreDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition
func (c *Greengrass) CreateCoreDefinitionRequest(input *CreateCoreDefinitionInput) (req *request.Request, output *CreateCoreDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateCoreDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/cores",
	}

	if input == nil {
		input = &CreateCoreDefinitionInput{}
	}

	output = &CreateCoreDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCoreDefinition API operation for AWS Greengrass.
//
// Creates a core definition. You may optionally provide the initial version
// of the core definition or use ''CreateCoreDefinitionVersion'' at a later
// time. AWS Greengrass Groups must each contain exactly 1 AWS Greengrass Core.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateCoreDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition
func (c *Greengrass) CreateCoreDefinition(input *CreateCoreDefinitionInput) (*CreateCoreDefinitionOutput, error) {
	req, out := c.CreateCoreDefinitionRequest(input)
	return out, req.Send()
}

// CreateCoreDefinitionWithContext is the same as CreateCoreDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCoreDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateCoreDefinitionWithContext(ctx aws.Context, input *CreateCoreDefinitionInput, opts ...request.Option) (*CreateCoreDefinitionOutput, error) {
	req, out := c.CreateCoreDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCoreDefinitionVersion = "CreateCoreDefinitionVersion"

// CreateCoreDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCoreDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCoreDefinitionVersion for more information on using the CreateCoreDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCoreDefinitionVersionRequest method.
//    req, resp := client.CreateCoreDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion
func (c *Greengrass) CreateCoreDefinitionVersionRequest(input *CreateCoreDefinitionVersionInput) (req *request.Request, output *CreateCoreDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateCoreDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateCoreDefinitionVersionInput{}
	}

	output = &CreateCoreDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCoreDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a core definition that has already been defined. AWS
// Greengrass Groups must each contain exactly 1 AWS Greengrass Core.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateCoreDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion
func (c *Greengrass) CreateCoreDefinitionVersion(input *CreateCoreDefinitionVersionInput) (*CreateCoreDefinitionVersionOutput, error) {
	req, out := c.CreateCoreDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateCoreDefinitionVersionWithContext is the same as CreateCoreDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCoreDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateCoreDefinitionVersionWithContext(ctx aws.Context, input *CreateCoreDefinitionVersionInput, opts ...request.Option) (*CreateCoreDefinitionVersionOutput, error) {
	req, out := c.CreateCoreDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment
func (c *Greengrass) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups/{GroupId}/deployments",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for AWS Greengrass.
//
// Creates a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment
func (c *Greengrass) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeviceDefinition = "CreateDeviceDefinition"

// CreateDeviceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeviceDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeviceDefinition for more information on using the CreateDeviceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeviceDefinitionRequest method.
//    req, resp := client.CreateDeviceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition
func (c *Greengrass) CreateDeviceDefinitionRequest(input *CreateDeviceDefinitionInput) (req *request.Request, output *CreateDeviceDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateDeviceDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/devices",
	}

	if input == nil {
		input = &CreateDeviceDefinitionInput{}
	}

	output = &CreateDeviceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeviceDefinition API operation for AWS Greengrass.
//
// Creates a device definition. You may optinally provide the initial version
// of the device definition or use ``CreateDeviceDefinitionVersion`` at a later
// time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateDeviceDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition
func (c *Greengrass) CreateDeviceDefinition(input *CreateDeviceDefinitionInput) (*CreateDeviceDefinitionOutput, error) {
	req, out := c.CreateDeviceDefinitionRequest(input)
	return out, req.Send()
}

// CreateDeviceDefinitionWithContext is the same as CreateDeviceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeviceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateDeviceDefinitionWithContext(ctx aws.Context, input *CreateDeviceDefinitionInput, opts ...request.Option) (*CreateDeviceDefinitionOutput, error) {
	req, out := c.CreateDeviceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeviceDefinitionVersion = "CreateDeviceDefinitionVersion"

// CreateDeviceDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeviceDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeviceDefinitionVersion for more information on using the CreateDeviceDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeviceDefinitionVersionRequest method.
//    req, resp := client.CreateDeviceDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion
func (c *Greengrass) CreateDeviceDefinitionVersionRequest(input *CreateDeviceDefinitionVersionInput) (req *request.Request, output *CreateDeviceDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateDeviceDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateDeviceDefinitionVersionInput{}
	}

	output = &CreateDeviceDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeviceDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a device definition that has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateDeviceDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion
func (c *Greengrass) CreateDeviceDefinitionVersion(input *CreateDeviceDefinitionVersionInput) (*CreateDeviceDefinitionVersionOutput, error) {
	req, out := c.CreateDeviceDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateDeviceDefinitionVersionWithContext is the same as CreateDeviceDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeviceDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateDeviceDefinitionVersionWithContext(ctx aws.Context, input *CreateDeviceDefinitionVersionInput, opts ...request.Option) (*CreateDeviceDefinitionVersionOutput, error) {
	req, out := c.CreateDeviceDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFunctionDefinition = "CreateFunctionDefinition"

// CreateFunctionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFunctionDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFunctionDefinition for more information on using the CreateFunctionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFunctionDefinitionRequest method.
//    req, resp := client.CreateFunctionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition
func (c *Greengrass) CreateFunctionDefinitionRequest(input *CreateFunctionDefinitionInput) (req *request.Request, output *CreateFunctionDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateFunctionDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/functions",
	}

	if input == nil {
		input = &CreateFunctionDefinitionInput{}
	}

	output = &CreateFunctionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFunctionDefinition API operation for AWS Greengrass.
//
// Creates a Lambda function definition which contains a list of Lambda functions
// and their configurations to be used in a group. You can create an initial
// version of the definition by providing a list of Lambda functions and their
// configurations now, or use ``CreateFunctionDefinitionVersion`` later.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateFunctionDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition
func (c *Greengrass) CreateFunctionDefinition(input *CreateFunctionDefinitionInput) (*CreateFunctionDefinitionOutput, error) {
	req, out := c.CreateFunctionDefinitionRequest(input)
	return out, req.Send()
}

// CreateFunctionDefinitionWithContext is the same as CreateFunctionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunctionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateFunctionDefinitionWithContext(ctx aws.Context, input *CreateFunctionDefinitionInput, opts ...request.Option) (*CreateFunctionDefinitionOutput, error) {
	req, out := c.CreateFunctionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFunctionDefinitionVersion = "CreateFunctionDefinitionVersion"

// CreateFunctionDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFunctionDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFunctionDefinitionVersion for more information on using the CreateFunctionDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFunctionDefinitionVersionRequest method.
//    req, resp := client.CreateFunctionDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion
func (c *Greengrass) CreateFunctionDefinitionVersionRequest(input *CreateFunctionDefinitionVersionInput) (req *request.Request, output *CreateFunctionDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateFunctionDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateFunctionDefinitionVersionInput{}
	}

	output = &CreateFunctionDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFunctionDefinitionVersion API operation for AWS Greengrass.
//
// Create a version of a Lambda function definition that has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateFunctionDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion
func (c *Greengrass) CreateFunctionDefinitionVersion(input *CreateFunctionDefinitionVersionInput) (*CreateFunctionDefinitionVersionOutput, error) {
	req, out := c.CreateFunctionDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateFunctionDefinitionVersionWithContext is the same as CreateFunctionDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunctionDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateFunctionDefinitionVersionWithContext(ctx aws.Context, input *CreateFunctionDefinitionVersionInput, opts ...request.Option) (*CreateFunctionDefinitionVersionOutput, error) {
	req, out := c.CreateFunctionDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup
func (c *Greengrass) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for AWS Greengrass.
//
// Creates a group. You may optionally provide the initial version of the group
// or use ''CreateGroupVersion'' at a later time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup
func (c *Greengrass) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupCertificateAuthority = "CreateGroupCertificateAuthority"

// CreateGroupCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupCertificateAuthority for more information on using the CreateGroupCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupCertificateAuthorityRequest method.
//    req, resp := client.CreateGroupCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority
func (c *Greengrass) CreateGroupCertificateAuthorityRequest(input *CreateGroupCertificateAuthorityInput) (req *request.Request, output *CreateGroupCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opCreateGroupCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities",
	}

	if input == nil {
		input = &CreateGroupCertificateAuthorityInput{}
	}

	output = &CreateGroupCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupCertificateAuthority API operation for AWS Greengrass.
//
// Creates a CA for the group. If a CA already exists, it will rotate the existing
// CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateGroupCertificateAuthority for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority
func (c *Greengrass) CreateGroupCertificateAuthority(input *CreateGroupCertificateAuthorityInput) (*CreateGroupCertificateAuthorityOutput, error) {
	req, out := c.CreateGroupCertificateAuthorityRequest(input)
	return out, req.Send()
}

// CreateGroupCertificateAuthorityWithContext is the same as CreateGroupCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateGroupCertificateAuthorityWithContext(ctx aws.Context, input *CreateGroupCertificateAuthorityInput, opts ...request.Option) (*CreateGroupCertificateAuthorityOutput, error) {
	req, out := c.CreateGroupCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupVersion = "CreateGroupVersion"

// CreateGroupVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupVersion for more information on using the CreateGroupVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupVersionRequest method.
//    req, resp := client.CreateGroupVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion
func (c *Greengrass) CreateGroupVersionRequest(input *CreateGroupVersionInput) (req *request.Request, output *CreateGroupVersionOutput) {
	op := &request.Operation{
		Name:       opCreateGroupVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups/{GroupId}/versions",
	}

	if input == nil {
		input = &CreateGroupVersionInput{}
	}

	output = &CreateGroupVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupVersion API operation for AWS Greengrass.
//
// Creates a version of a group which has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateGroupVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion
func (c *Greengrass) CreateGroupVersion(input *CreateGroupVersionInput) (*CreateGroupVersionOutput, error) {
	req, out := c.CreateGroupVersionRequest(input)
	return out, req.Send()
}

// CreateGroupVersionWithContext is the same as CreateGroupVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateGroupVersionWithContext(ctx aws.Context, input *CreateGroupVersionInput, opts ...request.Option) (*CreateGroupVersionOutput, error) {
	req, out := c.CreateGroupVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoggerDefinition = "CreateLoggerDefinition"

// CreateLoggerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoggerDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoggerDefinition for more information on using the CreateLoggerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLoggerDefinitionRequest method.
//    req, resp := client.CreateLoggerDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition
func (c *Greengrass) CreateLoggerDefinitionRequest(input *CreateLoggerDefinitionInput) (req *request.Request, output *CreateLoggerDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateLoggerDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/loggers",
	}

	if input == nil {
		input = &CreateLoggerDefinitionInput{}
	}

	output = &CreateLoggerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoggerDefinition API operation for AWS Greengrass.
//
// Creates a logger definition. You may optionally provide the initial version
// of the logger definition or use ``CreateLoggerDefinitionVersion`` at a later
// time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateLoggerDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition
func (c *Greengrass) CreateLoggerDefinition(input *CreateLoggerDefinitionInput) (*CreateLoggerDefinitionOutput, error) {
	req, out := c.CreateLoggerDefinitionRequest(input)
	return out, req.Send()
}

// CreateLoggerDefinitionWithContext is the same as CreateLoggerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoggerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateLoggerDefinitionWithContext(ctx aws.Context, input *CreateLoggerDefinitionInput, opts ...request.Option) (*CreateLoggerDefinitionOutput, error) {
	req, out := c.CreateLoggerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoggerDefinitionVersion = "CreateLoggerDefinitionVersion"

// CreateLoggerDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoggerDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoggerDefinitionVersion for more information on using the CreateLoggerDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLoggerDefinitionVersionRequest method.
//    req, resp := client.CreateLoggerDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion
func (c *Greengrass) CreateLoggerDefinitionVersionRequest(input *CreateLoggerDefinitionVersionInput) (req *request.Request, output *CreateLoggerDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateLoggerDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateLoggerDefinitionVersionInput{}
	}

	output = &CreateLoggerDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoggerDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a logger definition that has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateLoggerDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion
func (c *Greengrass) CreateLoggerDefinitionVersion(input *CreateLoggerDefinitionVersionInput) (*CreateLoggerDefinitionVersionOutput, error) {
	req, out := c.CreateLoggerDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateLoggerDefinitionVersionWithContext is the same as CreateLoggerDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoggerDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateLoggerDefinitionVersionWithContext(ctx aws.Context, input *CreateLoggerDefinitionVersionInput, opts ...request.Option) (*CreateLoggerDefinitionVersionOutput, error) {
	req, out := c.CreateLoggerDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceDefinition = "CreateResourceDefinition"

// CreateResourceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceDefinition for more information on using the CreateResourceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceDefinitionRequest method.
//    req, resp := client.CreateResourceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition
func (c *Greengrass) CreateResourceDefinitionRequest(input *CreateResourceDefinitionInput) (req *request.Request, output *CreateResourceDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateResourceDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/resources",
	}

	if input == nil {
		input = &CreateResourceDefinitionInput{}
	}

	output = &CreateResourceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceDefinition API operation for AWS Greengrass.
//
// Creates a resource definition which contains a list of resources to be used
// in a group. You can create an initial version of the definition by providing
// a list of resources now, or use ``CreateResourceDefinitionVersion`` later.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateResourceDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition
func (c *Greengrass) CreateResourceDefinition(input *CreateResourceDefinitionInput) (*CreateResourceDefinitionOutput, error) {
	req, out := c.CreateResourceDefinitionRequest(input)
	return out, req.Send()
}

// CreateResourceDefinitionWithContext is the same as CreateResourceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateResourceDefinitionWithContext(ctx aws.Context, input *CreateResourceDefinitionInput, opts ...request.Option) (*CreateResourceDefinitionOutput, error) {
	req, out := c.CreateResourceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceDefinitionVersion = "CreateResourceDefinitionVersion"

// CreateResourceDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceDefinitionVersion for more information on using the CreateResourceDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceDefinitionVersionRequest method.
//    req, resp := client.CreateResourceDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion
func (c *Greengrass) CreateResourceDefinitionVersionRequest(input *CreateResourceDefinitionVersionInput) (req *request.Request, output *CreateResourceDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateResourceDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateResourceDefinitionVersionInput{}
	}

	output = &CreateResourceDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceDefinitionVersion API operation for AWS Greengrass.
//
// Create a version of a resource definition that has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateResourceDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion
func (c *Greengrass) CreateResourceDefinitionVersion(input *CreateResourceDefinitionVersionInput) (*CreateResourceDefinitionVersionOutput, error) {
	req, out := c.CreateResourceDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateResourceDefinitionVersionWithContext is the same as CreateResourceDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateResourceDefinitionVersionWithContext(ctx aws.Context, input *CreateResourceDefinitionVersionInput, opts ...request.Option) (*CreateResourceDefinitionVersionOutput, error) {
	req, out := c.CreateResourceDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSoftwareUpdateJob = "CreateSoftwareUpdateJob"

// CreateSoftwareUpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateSoftwareUpdateJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSoftwareUpdateJob for more information on using the CreateSoftwareUpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSoftwareUpdateJobRequest method.
//    req, resp := client.CreateSoftwareUpdateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob
func (c *Greengrass) CreateSoftwareUpdateJobRequest(input *CreateSoftwareUpdateJobInput) (req *request.Request, output *CreateSoftwareUpdateJobOutput) {
	op := &request.Operation{
		Name:       opCreateSoftwareUpdateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/updates",
	}

	if input == nil {
		input = &CreateSoftwareUpdateJobInput{}
	}

	output = &CreateSoftwareUpdateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSoftwareUpdateJob API operation for AWS Greengrass.
//
// Creates an Iot Job that will trigger your Greengrass Cores to update the
// software they are running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateSoftwareUpdateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob
func (c *Greengrass) CreateSoftwareUpdateJob(input *CreateSoftwareUpdateJobInput) (*CreateSoftwareUpdateJobOutput, error) {
	req, out := c.CreateSoftwareUpdateJobRequest(input)
	return out, req.Send()
}

// CreateSoftwareUpdateJobWithContext is the same as CreateSoftwareUpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSoftwareUpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateSoftwareUpdateJobWithContext(ctx aws.Context, input *CreateSoftwareUpdateJobInput, opts ...request.Option) (*CreateSoftwareUpdateJobOutput, error) {
	req, out := c.CreateSoftwareUpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriptionDefinition = "CreateSubscriptionDefinition"

// CreateSubscriptionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriptionDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriptionDefinition for more information on using the CreateSubscriptionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSubscriptionDefinitionRequest method.
//    req, resp := client.CreateSubscriptionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition
func (c *Greengrass) CreateSubscriptionDefinitionRequest(input *CreateSubscriptionDefinitionInput) (req *request.Request, output *CreateSubscriptionDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriptionDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/subscriptions",
	}

	if input == nil {
		input = &CreateSubscriptionDefinitionInput{}
	}

	output = &CreateSubscriptionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriptionDefinition API operation for AWS Greengrass.
//
// Creates a subscription definition. You may optionally provide the initial
// version of the subscription definition or use ``CreateSubscriptionDefinitionVersion``
// at a later time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateSubscriptionDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition
func (c *Greengrass) CreateSubscriptionDefinition(input *CreateSubscriptionDefinitionInput) (*CreateSubscriptionDefinitionOutput, error) {
	req, out := c.CreateSubscriptionDefinitionRequest(input)
	return out, req.Send()
}

// CreateSubscriptionDefinitionWithContext is the same as CreateSubscriptionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriptionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateSubscriptionDefinitionWithContext(ctx aws.Context, input *CreateSubscriptionDefinitionInput, opts ...request.Option) (*CreateSubscriptionDefinitionOutput, error) {
	req, out := c.CreateSubscriptionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriptionDefinitionVersion = "CreateSubscriptionDefinitionVersion"

// CreateSubscriptionDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriptionDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriptionDefinitionVersion for more information on using the CreateSubscriptionDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSubscriptionDefinitionVersionRequest method.
//    req, resp := client.CreateSubscriptionDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion
func (c *Greengrass) CreateSubscriptionDefinitionVersionRequest(input *CreateSubscriptionDefinitionVersionInput) (req *request.Request, output *CreateSubscriptionDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriptionDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateSubscriptionDefinitionVersionInput{}
	}

	output = &CreateSubscriptionDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriptionDefinitionVersion API operation for AWS Greengrass.
//
// Creates a version of a subscription definition which has already been defined.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation CreateSubscriptionDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion
func (c *Greengrass) CreateSubscriptionDefinitionVersion(input *CreateSubscriptionDefinitionVersionInput) (*CreateSubscriptionDefinitionVersionOutput, error) {
	req, out := c.CreateSubscriptionDefinitionVersionRequest(input)
	return out, req.Send()
}

// CreateSubscriptionDefinitionVersionWithContext is the same as CreateSubscriptionDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriptionDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) CreateSubscriptionDefinitionVersionWithContext(ctx aws.Context, input *CreateSubscriptionDefinitionVersionInput, opts ...request.Option) (*CreateSubscriptionDefinitionVersionOutput, error) {
	req, out := c.CreateSubscriptionDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCoreDefinition = "DeleteCoreDefinition"

// DeleteCoreDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCoreDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCoreDefinition for more information on using the DeleteCoreDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCoreDefinitionRequest method.
//    req, resp := client.DeleteCoreDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition
func (c *Greengrass) DeleteCoreDefinitionRequest(input *DeleteCoreDefinitionInput) (req *request.Request, output *DeleteCoreDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteCoreDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}",
	}

	if input == nil {
		input = &DeleteCoreDefinitionInput{}
	}

	output = &DeleteCoreDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCoreDefinition API operation for AWS Greengrass.
//
// Deletes a core definition. The core definition must not have been used in
// a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteCoreDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition
func (c *Greengrass) DeleteCoreDefinition(input *DeleteCoreDefinitionInput) (*DeleteCoreDefinitionOutput, error) {
	req, out := c.DeleteCoreDefinitionRequest(input)
	return out, req.Send()
}

// DeleteCoreDefinitionWithContext is the same as DeleteCoreDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCoreDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteCoreDefinitionWithContext(ctx aws.Context, input *DeleteCoreDefinitionInput, opts ...request.Option) (*DeleteCoreDefinitionOutput, error) {
	req, out := c.DeleteCoreDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeviceDefinition = "DeleteDeviceDefinition"

// DeleteDeviceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeviceDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeviceDefinition for more information on using the DeleteDeviceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeviceDefinitionRequest method.
//    req, resp := client.DeleteDeviceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition
func (c *Greengrass) DeleteDeviceDefinitionRequest(input *DeleteDeviceDefinitionInput) (req *request.Request, output *DeleteDeviceDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteDeviceDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}",
	}

	if input == nil {
		input = &DeleteDeviceDefinitionInput{}
	}

	output = &DeleteDeviceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDeviceDefinition API operation for AWS Greengrass.
//
// Deletes a device definition. The device definition must not have been used
// in a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteDeviceDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition
func (c *Greengrass) DeleteDeviceDefinition(input *DeleteDeviceDefinitionInput) (*DeleteDeviceDefinitionOutput, error) {
	req, out := c.DeleteDeviceDefinitionRequest(input)
	return out, req.Send()
}

// DeleteDeviceDefinitionWithContext is the same as DeleteDeviceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeviceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteDeviceDefinitionWithContext(ctx aws.Context, input *DeleteDeviceDefinitionInput, opts ...request.Option) (*DeleteDeviceDefinitionOutput, error) {
	req, out := c.DeleteDeviceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFunctionDefinition = "DeleteFunctionDefinition"

// DeleteFunctionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunctionDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFunctionDefinition for more information on using the DeleteFunctionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFunctionDefinitionRequest method.
//    req, resp := client.DeleteFunctionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition
func (c *Greengrass) DeleteFunctionDefinitionRequest(input *DeleteFunctionDefinitionInput) (req *request.Request, output *DeleteFunctionDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteFunctionDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}",
	}

	if input == nil {
		input = &DeleteFunctionDefinitionInput{}
	}

	output = &DeleteFunctionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFunctionDefinition API operation for AWS Greengrass.
//
// Deletes a Lambda function definition. The Lambda function definition must
// not have been used in a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteFunctionDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition
func (c *Greengrass) DeleteFunctionDefinition(input *DeleteFunctionDefinitionInput) (*DeleteFunctionDefinitionOutput, error) {
	req, out := c.DeleteFunctionDefinitionRequest(input)
	return out, req.Send()
}

// DeleteFunctionDefinitionWithContext is the same as DeleteFunctionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFunctionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteFunctionDefinitionWithContext(ctx aws.Context, input *DeleteFunctionDefinitionInput, opts ...request.Option) (*DeleteFunctionDefinitionOutput, error) {
	req, out := c.DeleteFunctionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup
func (c *Greengrass) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/groups/{GroupId}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for AWS Greengrass.
//
// Deletes a group. The group must not have been used in deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup
func (c *Greengrass) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoggerDefinition = "DeleteLoggerDefinition"

// DeleteLoggerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoggerDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoggerDefinition for more information on using the DeleteLoggerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoggerDefinitionRequest method.
//    req, resp := client.DeleteLoggerDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition
func (c *Greengrass) DeleteLoggerDefinitionRequest(input *DeleteLoggerDefinitionInput) (req *request.Request, output *DeleteLoggerDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteLoggerDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}",
	}

	if input == nil {
		input = &DeleteLoggerDefinitionInput{}
	}

	output = &DeleteLoggerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLoggerDefinition API operation for AWS Greengrass.
//
// Deletes a logger definition. The logger definition must not have been used
// in a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteLoggerDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition
func (c *Greengrass) DeleteLoggerDefinition(input *DeleteLoggerDefinitionInput) (*DeleteLoggerDefinitionOutput, error) {
	req, out := c.DeleteLoggerDefinitionRequest(input)
	return out, req.Send()
}

// DeleteLoggerDefinitionWithContext is the same as DeleteLoggerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoggerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteLoggerDefinitionWithContext(ctx aws.Context, input *DeleteLoggerDefinitionInput, opts ...request.Option) (*DeleteLoggerDefinitionOutput, error) {
	req, out := c.DeleteLoggerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceDefinition = "DeleteResourceDefinition"

// DeleteResourceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceDefinition for more information on using the DeleteResourceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceDefinitionRequest method.
//    req, resp := client.DeleteResourceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition
func (c *Greengrass) DeleteResourceDefinitionRequest(input *DeleteResourceDefinitionInput) (req *request.Request, output *DeleteResourceDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}",
	}

	if input == nil {
		input = &DeleteResourceDefinitionInput{}
	}

	output = &DeleteResourceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourceDefinition API operation for AWS Greengrass.
//
// Deletes a resource definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteResourceDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition
func (c *Greengrass) DeleteResourceDefinition(input *DeleteResourceDefinitionInput) (*DeleteResourceDefinitionOutput, error) {
	req, out := c.DeleteResourceDefinitionRequest(input)
	return out, req.Send()
}

// DeleteResourceDefinitionWithContext is the same as DeleteResourceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteResourceDefinitionWithContext(ctx aws.Context, input *DeleteResourceDefinitionInput, opts ...request.Option) (*DeleteResourceDefinitionOutput, error) {
	req, out := c.DeleteResourceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriptionDefinition = "DeleteSubscriptionDefinition"

// DeleteSubscriptionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriptionDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriptionDefinition for more information on using the DeleteSubscriptionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSubscriptionDefinitionRequest method.
//    req, resp := client.DeleteSubscriptionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition
func (c *Greengrass) DeleteSubscriptionDefinitionRequest(input *DeleteSubscriptionDefinitionInput) (req *request.Request, output *DeleteSubscriptionDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriptionDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
	}

	if input == nil {
		input = &DeleteSubscriptionDefinitionInput{}
	}

	output = &DeleteSubscriptionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSubscriptionDefinition API operation for AWS Greengrass.
//
// Deletes a subscription definition. The subscription definition must not have
// been used in a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DeleteSubscriptionDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition
func (c *Greengrass) DeleteSubscriptionDefinition(input *DeleteSubscriptionDefinitionInput) (*DeleteSubscriptionDefinitionOutput, error) {
	req, out := c.DeleteSubscriptionDefinitionRequest(input)
	return out, req.Send()
}

// DeleteSubscriptionDefinitionWithContext is the same as DeleteSubscriptionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriptionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DeleteSubscriptionDefinitionWithContext(ctx aws.Context, input *DeleteSubscriptionDefinitionInput, opts ...request.Option) (*DeleteSubscriptionDefinitionOutput, error) {
	req, out := c.DeleteSubscriptionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateRoleFromGroup = "DisassociateRoleFromGroup"

// DisassociateRoleFromGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateRoleFromGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateRoleFromGroup for more information on using the DisassociateRoleFromGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateRoleFromGroupRequest method.
//    req, resp := client.DisassociateRoleFromGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup
func (c *Greengrass) DisassociateRoleFromGroupRequest(input *DisassociateRoleFromGroupInput) (req *request.Request, output *DisassociateRoleFromGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociateRoleFromGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/groups/{GroupId}/role",
	}

	if input == nil {
		input = &DisassociateRoleFromGroupInput{}
	}

	output = &DisassociateRoleFromGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateRoleFromGroup API operation for AWS Greengrass.
//
// Disassociates the role from a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DisassociateRoleFromGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup
func (c *Greengrass) DisassociateRoleFromGroup(input *DisassociateRoleFromGroupInput) (*DisassociateRoleFromGroupOutput, error) {
	req, out := c.DisassociateRoleFromGroupRequest(input)
	return out, req.Send()
}

// DisassociateRoleFromGroupWithContext is the same as DisassociateRoleFromGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateRoleFromGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DisassociateRoleFromGroupWithContext(ctx aws.Context, input *DisassociateRoleFromGroupInput, opts ...request.Option) (*DisassociateRoleFromGroupOutput, error) {
	req, out := c.DisassociateRoleFromGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateServiceRoleFromAccount = "DisassociateServiceRoleFromAccount"

// DisassociateServiceRoleFromAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateServiceRoleFromAccount operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateServiceRoleFromAccount for more information on using the DisassociateServiceRoleFromAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateServiceRoleFromAccountRequest method.
//    req, resp := client.DisassociateServiceRoleFromAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount
func (c *Greengrass) DisassociateServiceRoleFromAccountRequest(input *DisassociateServiceRoleFromAccountInput) (req *request.Request, output *DisassociateServiceRoleFromAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateServiceRoleFromAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &DisassociateServiceRoleFromAccountInput{}
	}

	output = &DisassociateServiceRoleFromAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateServiceRoleFromAccount API operation for AWS Greengrass.
//
// Disassociates the service role from the account. Without a service role,
// deployments will not work.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation DisassociateServiceRoleFromAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount
func (c *Greengrass) DisassociateServiceRoleFromAccount(input *DisassociateServiceRoleFromAccountInput) (*DisassociateServiceRoleFromAccountOutput, error) {
	req, out := c.DisassociateServiceRoleFromAccountRequest(input)
	return out, req.Send()
}

// DisassociateServiceRoleFromAccountWithContext is the same as DisassociateServiceRoleFromAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateServiceRoleFromAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) DisassociateServiceRoleFromAccountWithContext(ctx aws.Context, input *DisassociateServiceRoleFromAccountInput, opts ...request.Option) (*DisassociateServiceRoleFromAccountOutput, error) {
	req, out := c.DisassociateServiceRoleFromAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssociatedRole = "GetAssociatedRole"

// GetAssociatedRoleRequest generates a "aws/request.Request" representing the
// client's request for the GetAssociatedRole operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssociatedRole for more information on using the GetAssociatedRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssociatedRoleRequest method.
//    req, resp := client.GetAssociatedRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole
func (c *Greengrass) GetAssociatedRoleRequest(input *GetAssociatedRoleInput) (req *request.Request, output *GetAssociatedRoleOutput) {
	op := &request.Operation{
		Name:       opGetAssociatedRole,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/role",
	}

	if input == nil {
		input = &GetAssociatedRoleInput{}
	}

	output = &GetAssociatedRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssociatedRole API operation for AWS Greengrass.
//
// Retrieves the role associated with a particular group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetAssociatedRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole
func (c *Greengrass) GetAssociatedRole(input *GetAssociatedRoleInput) (*GetAssociatedRoleOutput, error) {
	req, out := c.GetAssociatedRoleRequest(input)
	return out, req.Send()
}

// GetAssociatedRoleWithContext is the same as GetAssociatedRole with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssociatedRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetAssociatedRoleWithContext(ctx aws.Context, input *GetAssociatedRoleInput, opts ...request.Option) (*GetAssociatedRoleOutput, error) {
	req, out := c.GetAssociatedRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectivityInfo = "GetConnectivityInfo"

// GetConnectivityInfoRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectivityInfo operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectivityInfo for more information on using the GetConnectivityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectivityInfoRequest method.
//    req, resp := client.GetConnectivityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo
func (c *Greengrass) GetConnectivityInfoRequest(input *GetConnectivityInfoInput) (req *request.Request, output *GetConnectivityInfoOutput) {
	op := &request.Operation{
		Name:       opGetConnectivityInfo,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/things/{ThingName}/connectivityInfo",
	}

	if input == nil {
		input = &GetConnectivityInfoInput{}
	}

	output = &GetConnectivityInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectivityInfo API operation for AWS Greengrass.
//
// Retrieves the connectivity information for a core.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetConnectivityInfo for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo
func (c *Greengrass) GetConnectivityInfo(input *GetConnectivityInfoInput) (*GetConnectivityInfoOutput, error) {
	req, out := c.GetConnectivityInfoRequest(input)
	return out, req.Send()
}

// GetConnectivityInfoWithContext is the same as GetConnectivityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectivityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetConnectivityInfoWithContext(ctx aws.Context, input *GetConnectivityInfoInput, opts ...request.Option) (*GetConnectivityInfoOutput, error) {
	req, out := c.GetConnectivityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCoreDefinition = "GetCoreDefinition"

// GetCoreDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetCoreDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCoreDefinition for more information on using the GetCoreDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCoreDefinitionRequest method.
//    req, resp := client.GetCoreDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition
func (c *Greengrass) GetCoreDefinitionRequest(input *GetCoreDefinitionInput) (req *request.Request, output *GetCoreDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetCoreDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}",
	}

	if input == nil {
		input = &GetCoreDefinitionInput{}
	}

	output = &GetCoreDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCoreDefinition API operation for AWS Greengrass.
//
// Retrieves information about a core definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetCoreDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition
func (c *Greengrass) GetCoreDefinition(input *GetCoreDefinitionInput) (*GetCoreDefinitionOutput, error) {
	req, out := c.GetCoreDefinitionRequest(input)
	return out, req.Send()
}

// GetCoreDefinitionWithContext is the same as GetCoreDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetCoreDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetCoreDefinitionWithContext(ctx aws.Context, input *GetCoreDefinitionInput, opts ...request.Option) (*GetCoreDefinitionOutput, error) {
	req, out := c.GetCoreDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCoreDefinitionVersion = "GetCoreDefinitionVersion"

// GetCoreDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetCoreDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCoreDefinitionVersion for more information on using the GetCoreDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCoreDefinitionVersionRequest method.
//    req, resp := client.GetCoreDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion
func (c *Greengrass) GetCoreDefinitionVersionRequest(input *GetCoreDefinitionVersionInput) (req *request.Request, output *GetCoreDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetCoreDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}/versions/{CoreDefinitionVersionId}",
	}

	if input == nil {
		input = &GetCoreDefinitionVersionInput{}
	}

	output = &GetCoreDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCoreDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a core definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetCoreDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion
func (c *Greengrass) GetCoreDefinitionVersion(input *GetCoreDefinitionVersionInput) (*GetCoreDefinitionVersionOutput, error) {
	req, out := c.GetCoreDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetCoreDefinitionVersionWithContext is the same as GetCoreDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetCoreDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetCoreDefinitionVersionWithContext(ctx aws.Context, input *GetCoreDefinitionVersionInput, opts ...request.Option) (*GetCoreDefinitionVersionOutput, error) {
	req, out := c.GetCoreDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeploymentStatus = "GetDeploymentStatus"

// GetDeploymentStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentStatus operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeploymentStatus for more information on using the GetDeploymentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentStatusRequest method.
//    req, resp := client.GetDeploymentStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus
func (c *Greengrass) GetDeploymentStatusRequest(input *GetDeploymentStatusInput) (req *request.Request, output *GetDeploymentStatusOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/deployments/{DeploymentId}/status",
	}

	if input == nil {
		input = &GetDeploymentStatusInput{}
	}

	output = &GetDeploymentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeploymentStatus API operation for AWS Greengrass.
//
// Returns the status of a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetDeploymentStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus
func (c *Greengrass) GetDeploymentStatus(input *GetDeploymentStatusInput) (*GetDeploymentStatusOutput, error) {
	req, out := c.GetDeploymentStatusRequest(input)
	return out, req.Send()
}

// GetDeploymentStatusWithContext is the same as GetDeploymentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeploymentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetDeploymentStatusWithContext(ctx aws.Context, input *GetDeploymentStatusInput, opts ...request.Option) (*GetDeploymentStatusOutput, error) {
	req, out := c.GetDeploymentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceDefinition = "GetDeviceDefinition"

// GetDeviceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceDefinition for more information on using the GetDeviceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceDefinitionRequest method.
//    req, resp := client.GetDeviceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition
func (c *Greengrass) GetDeviceDefinitionRequest(input *GetDeviceDefinitionInput) (req *request.Request, output *GetDeviceDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetDeviceDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}",
	}

	if input == nil {
		input = &GetDeviceDefinitionInput{}
	}

	output = &GetDeviceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceDefinition API operation for AWS Greengrass.
//
// Retrieves information about a device definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetDeviceDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition
func (c *Greengrass) GetDeviceDefinition(input *GetDeviceDefinitionInput) (*GetDeviceDefinitionOutput, error) {
	req, out := c.GetDeviceDefinitionRequest(input)
	return out, req.Send()
}

// GetDeviceDefinitionWithContext is the same as GetDeviceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetDeviceDefinitionWithContext(ctx aws.Context, input *GetDeviceDefinitionInput, opts ...request.Option) (*GetDeviceDefinitionOutput, error) {
	req, out := c.GetDeviceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceDefinitionVersion = "GetDeviceDefinitionVersion"

// GetDeviceDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceDefinitionVersion for more information on using the GetDeviceDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceDefinitionVersionRequest method.
//    req, resp := client.GetDeviceDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion
func (c *Greengrass) GetDeviceDefinitionVersionRequest(input *GetDeviceDefinitionVersionInput) (req *request.Request, output *GetDeviceDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetDeviceDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}/versions/{DeviceDefinitionVersionId}",
	}

	if input == nil {
		input = &GetDeviceDefinitionVersionInput{}
	}

	output = &GetDeviceDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a device definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetDeviceDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion
func (c *Greengrass) GetDeviceDefinitionVersion(input *GetDeviceDefinitionVersionInput) (*GetDeviceDefinitionVersionOutput, error) {
	req, out := c.GetDeviceDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetDeviceDefinitionVersionWithContext is the same as GetDeviceDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetDeviceDefinitionVersionWithContext(ctx aws.Context, input *GetDeviceDefinitionVersionInput, opts ...request.Option) (*GetDeviceDefinitionVersionOutput, error) {
	req, out := c.GetDeviceDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunctionDefinition = "GetFunctionDefinition"

// GetFunctionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunctionDefinition for more information on using the GetFunctionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionDefinitionRequest method.
//    req, resp := client.GetFunctionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition
func (c *Greengrass) GetFunctionDefinitionRequest(input *GetFunctionDefinitionInput) (req *request.Request, output *GetFunctionDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetFunctionDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}",
	}

	if input == nil {
		input = &GetFunctionDefinitionInput{}
	}

	output = &GetFunctionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionDefinition API operation for AWS Greengrass.
//
// Retrieves information about a Lambda function definition, such as its creation
// time and latest version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetFunctionDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition
func (c *Greengrass) GetFunctionDefinition(input *GetFunctionDefinitionInput) (*GetFunctionDefinitionOutput, error) {
	req, out := c.GetFunctionDefinitionRequest(input)
	return out, req.Send()
}

// GetFunctionDefinitionWithContext is the same as GetFunctionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunctionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetFunctionDefinitionWithContext(ctx aws.Context, input *GetFunctionDefinitionInput, opts ...request.Option) (*GetFunctionDefinitionOutput, error) {
	req, out := c.GetFunctionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunctionDefinitionVersion = "GetFunctionDefinitionVersion"

// GetFunctionDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunctionDefinitionVersion for more information on using the GetFunctionDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionDefinitionVersionRequest method.
//    req, resp := client.GetFunctionDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion
func (c *Greengrass) GetFunctionDefinitionVersionRequest(input *GetFunctionDefinitionVersionInput) (req *request.Request, output *GetFunctionDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetFunctionDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}/versions/{FunctionDefinitionVersionId}",
	}

	if input == nil {
		input = &GetFunctionDefinitionVersionInput{}
	}

	output = &GetFunctionDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a Lambda function definition version, such as
// which Lambda functions are included in the version and their configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetFunctionDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion
func (c *Greengrass) GetFunctionDefinitionVersion(input *GetFunctionDefinitionVersionInput) (*GetFunctionDefinitionVersionOutput, error) {
	req, out := c.GetFunctionDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetFunctionDefinitionVersionWithContext is the same as GetFunctionDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunctionDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetFunctionDefinitionVersionWithContext(ctx aws.Context, input *GetFunctionDefinitionVersionInput, opts ...request.Option) (*GetFunctionDefinitionVersionOutput, error) {
	req, out := c.GetFunctionDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroup for more information on using the GetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupRequest method.
//    req, resp := client.GetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup
func (c *Greengrass) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for AWS Greengrass.
//
// Retrieves information about a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup
func (c *Greengrass) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	return out, req.Send()
}

// GetGroupWithContext is the same as GetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetGroupWithContext(ctx aws.Context, input *GetGroupInput, opts ...request.Option) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupCertificateAuthority = "GetGroupCertificateAuthority"

// GetGroupCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupCertificateAuthority for more information on using the GetGroupCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupCertificateAuthorityRequest method.
//    req, resp := client.GetGroupCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority
func (c *Greengrass) GetGroupCertificateAuthorityRequest(input *GetGroupCertificateAuthorityInput) (req *request.Request, output *GetGroupCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opGetGroupCertificateAuthority,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities/{CertificateAuthorityId}",
	}

	if input == nil {
		input = &GetGroupCertificateAuthorityInput{}
	}

	output = &GetGroupCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupCertificateAuthority API operation for AWS Greengrass.
//
// Retreives the CA associated with a group. Returns the public key of the CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetGroupCertificateAuthority for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority
func (c *Greengrass) GetGroupCertificateAuthority(input *GetGroupCertificateAuthorityInput) (*GetGroupCertificateAuthorityOutput, error) {
	req, out := c.GetGroupCertificateAuthorityRequest(input)
	return out, req.Send()
}

// GetGroupCertificateAuthorityWithContext is the same as GetGroupCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetGroupCertificateAuthorityWithContext(ctx aws.Context, input *GetGroupCertificateAuthorityInput, opts ...request.Option) (*GetGroupCertificateAuthorityOutput, error) {
	req, out := c.GetGroupCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupCertificateConfiguration = "GetGroupCertificateConfiguration"

// GetGroupCertificateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupCertificateConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupCertificateConfiguration for more information on using the GetGroupCertificateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupCertificateConfigurationRequest method.
//    req, resp := client.GetGroupCertificateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration
func (c *Greengrass) GetGroupCertificateConfigurationRequest(input *GetGroupCertificateConfigurationInput) (req *request.Request, output *GetGroupCertificateConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetGroupCertificateConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities/configuration/expiry",
	}

	if input == nil {
		input = &GetGroupCertificateConfigurationInput{}
	}

	output = &GetGroupCertificateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupCertificateConfiguration API operation for AWS Greengrass.
//
// Retrieves the current configuration for the CA used by the group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetGroupCertificateConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration
func (c *Greengrass) GetGroupCertificateConfiguration(input *GetGroupCertificateConfigurationInput) (*GetGroupCertificateConfigurationOutput, error) {
	req, out := c.GetGroupCertificateConfigurationRequest(input)
	return out, req.Send()
}

// GetGroupCertificateConfigurationWithContext is the same as GetGroupCertificateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupCertificateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetGroupCertificateConfigurationWithContext(ctx aws.Context, input *GetGroupCertificateConfigurationInput, opts ...request.Option) (*GetGroupCertificateConfigurationOutput, error) {
	req, out := c.GetGroupCertificateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupVersion = "GetGroupVersion"

// GetGroupVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupVersion for more information on using the GetGroupVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupVersionRequest method.
//    req, resp := client.GetGroupVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion
func (c *Greengrass) GetGroupVersionRequest(input *GetGroupVersionInput) (req *request.Request, output *GetGroupVersionOutput) {
	op := &request.Operation{
		Name:       opGetGroupVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/versions/{GroupVersionId}",
	}

	if input == nil {
		input = &GetGroupVersionInput{}
	}

	output = &GetGroupVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupVersion API operation for AWS Greengrass.
//
// Retrieves information about a group version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetGroupVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion
func (c *Greengrass) GetGroupVersion(input *GetGroupVersionInput) (*GetGroupVersionOutput, error) {
	req, out := c.GetGroupVersionRequest(input)
	return out, req.Send()
}

// GetGroupVersionWithContext is the same as GetGroupVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetGroupVersionWithContext(ctx aws.Context, input *GetGroupVersionInput, opts ...request.Option) (*GetGroupVersionOutput, error) {
	req, out := c.GetGroupVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggerDefinition = "GetLoggerDefinition"

// GetLoggerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggerDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggerDefinition for more information on using the GetLoggerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggerDefinitionRequest method.
//    req, resp := client.GetLoggerDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition
func (c *Greengrass) GetLoggerDefinitionRequest(input *GetLoggerDefinitionInput) (req *request.Request, output *GetLoggerDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetLoggerDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}",
	}

	if input == nil {
		input = &GetLoggerDefinitionInput{}
	}

	output = &GetLoggerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggerDefinition API operation for AWS Greengrass.
//
// Retrieves information about a logger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetLoggerDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition
func (c *Greengrass) GetLoggerDefinition(input *GetLoggerDefinitionInput) (*GetLoggerDefinitionOutput, error) {
	req, out := c.GetLoggerDefinitionRequest(input)
	return out, req.Send()
}

// GetLoggerDefinitionWithContext is the same as GetLoggerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetLoggerDefinitionWithContext(ctx aws.Context, input *GetLoggerDefinitionInput, opts ...request.Option) (*GetLoggerDefinitionOutput, error) {
	req, out := c.GetLoggerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggerDefinitionVersion = "GetLoggerDefinitionVersion"

// GetLoggerDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggerDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggerDefinitionVersion for more information on using the GetLoggerDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggerDefinitionVersionRequest method.
//    req, resp := client.GetLoggerDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion
func (c *Greengrass) GetLoggerDefinitionVersionRequest(input *GetLoggerDefinitionVersionInput) (req *request.Request, output *GetLoggerDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetLoggerDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}/versions/{LoggerDefinitionVersionId}",
	}

	if input == nil {
		input = &GetLoggerDefinitionVersionInput{}
	}

	output = &GetLoggerDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggerDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a logger definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetLoggerDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion
func (c *Greengrass) GetLoggerDefinitionVersion(input *GetLoggerDefinitionVersionInput) (*GetLoggerDefinitionVersionOutput, error) {
	req, out := c.GetLoggerDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetLoggerDefinitionVersionWithContext is the same as GetLoggerDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggerDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetLoggerDefinitionVersionWithContext(ctx aws.Context, input *GetLoggerDefinitionVersionInput, opts ...request.Option) (*GetLoggerDefinitionVersionOutput, error) {
	req, out := c.GetLoggerDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceDefinition = "GetResourceDefinition"

// GetResourceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceDefinition for more information on using the GetResourceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceDefinitionRequest method.
//    req, resp := client.GetResourceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition
func (c *Greengrass) GetResourceDefinitionRequest(input *GetResourceDefinitionInput) (req *request.Request, output *GetResourceDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetResourceDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}",
	}

	if input == nil {
		input = &GetResourceDefinitionInput{}
	}

	output = &GetResourceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceDefinition API operation for AWS Greengrass.
//
// Retrieves information about a resource definition, such as its creation time
// and latest version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetResourceDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition
func (c *Greengrass) GetResourceDefinition(input *GetResourceDefinitionInput) (*GetResourceDefinitionOutput, error) {
	req, out := c.GetResourceDefinitionRequest(input)
	return out, req.Send()
}

// GetResourceDefinitionWithContext is the same as GetResourceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetResourceDefinitionWithContext(ctx aws.Context, input *GetResourceDefinitionInput, opts ...request.Option) (*GetResourceDefinitionOutput, error) {
	req, out := c.GetResourceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceDefinitionVersion = "GetResourceDefinitionVersion"

// GetResourceDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceDefinitionVersion for more information on using the GetResourceDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceDefinitionVersionRequest method.
//    req, resp := client.GetResourceDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion
func (c *Greengrass) GetResourceDefinitionVersionRequest(input *GetResourceDefinitionVersionInput) (req *request.Request, output *GetResourceDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetResourceDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}/versions/{ResourceDefinitionVersionId}",
	}

	if input == nil {
		input = &GetResourceDefinitionVersionInput{}
	}

	output = &GetResourceDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a resource definition version, such as which
// resources are included in the version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetResourceDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion
func (c *Greengrass) GetResourceDefinitionVersion(input *GetResourceDefinitionVersionInput) (*GetResourceDefinitionVersionOutput, error) {
	req, out := c.GetResourceDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetResourceDefinitionVersionWithContext is the same as GetResourceDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetResourceDefinitionVersionWithContext(ctx aws.Context, input *GetResourceDefinitionVersionInput, opts ...request.Option) (*GetResourceDefinitionVersionOutput, error) {
	req, out := c.GetResourceDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceRoleForAccount = "GetServiceRoleForAccount"

// GetServiceRoleForAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceRoleForAccount operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceRoleForAccount for more information on using the GetServiceRoleForAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceRoleForAccountRequest method.
//    req, resp := client.GetServiceRoleForAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount
func (c *Greengrass) GetServiceRoleForAccountRequest(input *GetServiceRoleForAccountInput) (req *request.Request, output *GetServiceRoleForAccountOutput) {
	op := &request.Operation{
		Name:       opGetServiceRoleForAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/servicerole",
	}

	if input == nil {
		input = &GetServiceRoleForAccountInput{}
	}

	output = &GetServiceRoleForAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceRoleForAccount API operation for AWS Greengrass.
//
// Retrieves the service role that is attached to the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetServiceRoleForAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount
func (c *Greengrass) GetServiceRoleForAccount(input *GetServiceRoleForAccountInput) (*GetServiceRoleForAccountOutput, error) {
	req, out := c.GetServiceRoleForAccountRequest(input)
	return out, req.Send()
}

// GetServiceRoleForAccountWithContext is the same as GetServiceRoleForAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceRoleForAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetServiceRoleForAccountWithContext(ctx aws.Context, input *GetServiceRoleForAccountInput, opts ...request.Option) (*GetServiceRoleForAccountOutput, error) {
	req, out := c.GetServiceRoleForAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubscriptionDefinition = "GetSubscriptionDefinition"

// GetSubscriptionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriptionDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriptionDefinition for more information on using the GetSubscriptionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSubscriptionDefinitionRequest method.
//    req, resp := client.GetSubscriptionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition
func (c *Greengrass) GetSubscriptionDefinitionRequest(input *GetSubscriptionDefinitionInput) (req *request.Request, output *GetSubscriptionDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
	}

	if input == nil {
		input = &GetSubscriptionDefinitionInput{}
	}

	output = &GetSubscriptionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriptionDefinition API operation for AWS Greengrass.
//
// Retrieves information about a subscription definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetSubscriptionDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition
func (c *Greengrass) GetSubscriptionDefinition(input *GetSubscriptionDefinitionInput) (*GetSubscriptionDefinitionOutput, error) {
	req, out := c.GetSubscriptionDefinitionRequest(input)
	return out, req.Send()
}

// GetSubscriptionDefinitionWithContext is the same as GetSubscriptionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriptionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetSubscriptionDefinitionWithContext(ctx aws.Context, input *GetSubscriptionDefinitionInput, opts ...request.Option) (*GetSubscriptionDefinitionOutput, error) {
	req, out := c.GetSubscriptionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubscriptionDefinitionVersion = "GetSubscriptionDefinitionVersion"

// GetSubscriptionDefinitionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriptionDefinitionVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriptionDefinitionVersion for more information on using the GetSubscriptionDefinitionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSubscriptionDefinitionVersionRequest method.
//    req, resp := client.GetSubscriptionDefinitionVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion
func (c *Greengrass) GetSubscriptionDefinitionVersionRequest(input *GetSubscriptionDefinitionVersionInput) (req *request.Request, output *GetSubscriptionDefinitionVersionOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions/{SubscriptionDefinitionVersionId}",
	}

	if input == nil {
		input = &GetSubscriptionDefinitionVersionInput{}
	}

	output = &GetSubscriptionDefinitionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriptionDefinitionVersion API operation for AWS Greengrass.
//
// Retrieves information about a subscription definition version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation GetSubscriptionDefinitionVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion
func (c *Greengrass) GetSubscriptionDefinitionVersion(input *GetSubscriptionDefinitionVersionInput) (*GetSubscriptionDefinitionVersionOutput, error) {
	req, out := c.GetSubscriptionDefinitionVersionRequest(input)
	return out, req.Send()
}

// GetSubscriptionDefinitionVersionWithContext is the same as GetSubscriptionDefinitionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriptionDefinitionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) GetSubscriptionDefinitionVersionWithContext(ctx aws.Context, input *GetSubscriptionDefinitionVersionInput, opts ...request.Option) (*GetSubscriptionDefinitionVersionOutput, error) {
	req, out := c.GetSubscriptionDefinitionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCoreDefinitionVersions = "ListCoreDefinitionVersions"

// ListCoreDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCoreDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCoreDefinitionVersions for more information on using the ListCoreDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCoreDefinitionVersionsRequest method.
//    req, resp := client.ListCoreDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions
func (c *Greengrass) ListCoreDefinitionVersionsRequest(input *ListCoreDefinitionVersionsInput) (req *request.Request, output *ListCoreDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListCoreDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}/versions",
	}

	if input == nil {
		input = &ListCoreDefinitionVersionsInput{}
	}

	output = &ListCoreDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCoreDefinitionVersions API operation for AWS Greengrass.
//
// Lists versions of a core definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListCoreDefinitionVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions
func (c *Greengrass) ListCoreDefinitionVersions(input *ListCoreDefinitionVersionsInput) (*ListCoreDefinitionVersionsOutput, error) {
	req, out := c.ListCoreDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListCoreDefinitionVersionsWithContext is the same as ListCoreDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCoreDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListCoreDefinitionVersionsWithContext(ctx aws.Context, input *ListCoreDefinitionVersionsInput, opts ...request.Option) (*ListCoreDefinitionVersionsOutput, error) {
	req, out := c.ListCoreDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCoreDefinitions = "ListCoreDefinitions"

// ListCoreDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCoreDefinitions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCoreDefinitions for more information on using the ListCoreDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCoreDefinitionsRequest method.
//    req, resp := client.ListCoreDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions
func (c *Greengrass) ListCoreDefinitionsRequest(input *ListCoreDefinitionsInput) (req *request.Request, output *ListCoreDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListCoreDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores",
	}

	if input == nil {
		input = &ListCoreDefinitionsInput{}
	}

	output = &ListCoreDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCoreDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of core definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListCoreDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions
func (c *Greengrass) ListCoreDefinitions(input *ListCoreDefinitionsInput) (*ListCoreDefinitionsOutput, error) {
	req, out := c.ListCoreDefinitionsRequest(input)
	return out, req.Send()
}

// ListCoreDefinitionsWithContext is the same as ListCoreDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCoreDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListCoreDefinitionsWithContext(ctx aws.Context, input *ListCoreDefinitionsInput, opts ...request.Option) (*ListCoreDefinitionsOutput, error) {
	req, out := c.ListCoreDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeployments for more information on using the ListDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeploymentsRequest method.
//    req, resp := client.ListDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments
func (c *Greengrass) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/deployments",
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	output = &ListDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeployments API operation for AWS Greengrass.
//
// Returns a history of deployments for the group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListDeployments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments
func (c *Greengrass) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	return out, req.Send()
}

// ListDeploymentsWithContext is the same as ListDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListDeploymentsWithContext(ctx aws.Context, input *ListDeploymentsInput, opts ...request.Option) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeviceDefinitionVersions = "ListDeviceDefinitionVersions"

// ListDeviceDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceDefinitionVersions for more information on using the ListDeviceDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeviceDefinitionVersionsRequest method.
//    req, resp := client.ListDeviceDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions
func (c *Greengrass) ListDeviceDefinitionVersionsRequest(input *ListDeviceDefinitionVersionsInput) (req *request.Request, output *ListDeviceDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListDeviceDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}/versions",
	}

	if input == nil {
		input = &ListDeviceDefinitionVersionsInput{}
	}

	output = &ListDeviceDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a device definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListDeviceDefinitionVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions
func (c *Greengrass) ListDeviceDefinitionVersions(input *ListDeviceDefinitionVersionsInput) (*ListDeviceDefinitionVersionsOutput, error) {
	req, out := c.ListDeviceDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListDeviceDefinitionVersionsWithContext is the same as ListDeviceDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListDeviceDefinitionVersionsWithContext(ctx aws.Context, input *ListDeviceDefinitionVersionsInput, opts ...request.Option) (*ListDeviceDefinitionVersionsOutput, error) {
	req, out := c.ListDeviceDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeviceDefinitions = "ListDeviceDefinitions"

// ListDeviceDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceDefinitions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceDefinitions for more information on using the ListDeviceDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeviceDefinitionsRequest method.
//    req, resp := client.ListDeviceDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions
func (c *Greengrass) ListDeviceDefinitionsRequest(input *ListDeviceDefinitionsInput) (req *request.Request, output *ListDeviceDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListDeviceDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/devices",
	}

	if input == nil {
		input = &ListDeviceDefinitionsInput{}
	}

	output = &ListDeviceDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of device definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListDeviceDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions
func (c *Greengrass) ListDeviceDefinitions(input *ListDeviceDefinitionsInput) (*ListDeviceDefinitionsOutput, error) {
	req, out := c.ListDeviceDefinitionsRequest(input)
	return out, req.Send()
}

// ListDeviceDefinitionsWithContext is the same as ListDeviceDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListDeviceDefinitionsWithContext(ctx aws.Context, input *ListDeviceDefinitionsInput, opts ...request.Option) (*ListDeviceDefinitionsOutput, error) {
	req, out := c.ListDeviceDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFunctionDefinitionVersions = "ListFunctionDefinitionVersions"

// ListFunctionDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctionDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFunctionDefinitionVersions for more information on using the ListFunctionDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFunctionDefinitionVersionsRequest method.
//    req, resp := client.ListFunctionDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions
func (c *Greengrass) ListFunctionDefinitionVersionsRequest(input *ListFunctionDefinitionVersionsInput) (req *request.Request, output *ListFunctionDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListFunctionDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}/versions",
	}

	if input == nil {
		input = &ListFunctionDefinitionVersionsInput{}
	}

	output = &ListFunctionDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctionDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a Lambda function definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListFunctionDefinitionVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions
func (c *Greengrass) ListFunctionDefinitionVersions(input *ListFunctionDefinitionVersionsInput) (*ListFunctionDefinitionVersionsOutput, error) {
	req, out := c.ListFunctionDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListFunctionDefinitionVersionsWithContext is the same as ListFunctionDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFunctionDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListFunctionDefinitionVersionsWithContext(ctx aws.Context, input *ListFunctionDefinitionVersionsInput, opts ...request.Option) (*ListFunctionDefinitionVersionsOutput, error) {
	req, out := c.ListFunctionDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFunctionDefinitions = "ListFunctionDefinitions"

// ListFunctionDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctionDefinitions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFunctionDefinitions for more information on using the ListFunctionDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFunctionDefinitionsRequest method.
//    req, resp := client.ListFunctionDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions
func (c *Greengrass) ListFunctionDefinitionsRequest(input *ListFunctionDefinitionsInput) (req *request.Request, output *ListFunctionDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListFunctionDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/functions",
	}

	if input == nil {
		input = &ListFunctionDefinitionsInput{}
	}

	output = &ListFunctionDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctionDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of Lambda function definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListFunctionDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions
func (c *Greengrass) ListFunctionDefinitions(input *ListFunctionDefinitionsInput) (*ListFunctionDefinitionsOutput, error) {
	req, out := c.ListFunctionDefinitionsRequest(input)
	return out, req.Send()
}

// ListFunctionDefinitionsWithContext is the same as ListFunctionDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFunctionDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListFunctionDefinitionsWithContext(ctx aws.Context, input *ListFunctionDefinitionsInput, opts ...request.Option) (*ListFunctionDefinitionsOutput, error) {
	req, out := c.ListFunctionDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupCertificateAuthorities = "ListGroupCertificateAuthorities"

// ListGroupCertificateAuthoritiesRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupCertificateAuthorities operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupCertificateAuthorities for more information on using the ListGroupCertificateAuthorities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupCertificateAuthoritiesRequest method.
//    req, resp := client.ListGroupCertificateAuthoritiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities
func (c *Greengrass) ListGroupCertificateAuthoritiesRequest(input *ListGroupCertificateAuthoritiesInput) (req *request.Request, output *ListGroupCertificateAuthoritiesOutput) {
	op := &request.Operation{
		Name:       opListGroupCertificateAuthorities,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities",
	}

	if input == nil {
		input = &ListGroupCertificateAuthoritiesInput{}
	}

	output = &ListGroupCertificateAuthoritiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupCertificateAuthorities API operation for AWS Greengrass.
//
// Retrieves the current CAs for a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListGroupCertificateAuthorities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities
func (c *Greengrass) ListGroupCertificateAuthorities(input *ListGroupCertificateAuthoritiesInput) (*ListGroupCertificateAuthoritiesOutput, error) {
	req, out := c.ListGroupCertificateAuthoritiesRequest(input)
	return out, req.Send()
}

// ListGroupCertificateAuthoritiesWithContext is the same as ListGroupCertificateAuthorities with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupCertificateAuthorities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListGroupCertificateAuthoritiesWithContext(ctx aws.Context, input *ListGroupCertificateAuthoritiesInput, opts ...request.Option) (*ListGroupCertificateAuthoritiesOutput, error) {
	req, out := c.ListGroupCertificateAuthoritiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupVersions = "ListGroupVersions"

// ListGroupVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupVersions for more information on using the ListGroupVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupVersionsRequest method.
//    req, resp := client.ListGroupVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions
func (c *Greengrass) ListGroupVersionsRequest(input *ListGroupVersionsInput) (req *request.Request, output *ListGroupVersionsOutput) {
	op := &request.Operation{
		Name:       opListGroupVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/versions",
	}

	if input == nil {
		input = &ListGroupVersionsInput{}
	}

	output = &ListGroupVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupVersions API operation for AWS Greengrass.
//
// List the versions of a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListGroupVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions
func (c *Greengrass) ListGroupVersions(input *ListGroupVersionsInput) (*ListGroupVersionsOutput, error) {
	req, out := c.ListGroupVersionsRequest(input)
	return out, req.Send()
}

// ListGroupVersionsWithContext is the same as ListGroupVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListGroupVersionsWithContext(ctx aws.Context, input *ListGroupVersionsInput, opts ...request.Option) (*ListGroupVersionsOutput, error) {
	req, out := c.ListGroupVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups
func (c *Greengrass) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups",
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for AWS Greengrass.
//
// Retrieves a list of groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups
func (c *Greengrass) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoggerDefinitionVersions = "ListLoggerDefinitionVersions"

// ListLoggerDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoggerDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoggerDefinitionVersions for more information on using the ListLoggerDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLoggerDefinitionVersionsRequest method.
//    req, resp := client.ListLoggerDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions
func (c *Greengrass) ListLoggerDefinitionVersionsRequest(input *ListLoggerDefinitionVersionsInput) (req *request.Request, output *ListLoggerDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListLoggerDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}/versions",
	}

	if input == nil {
		input = &ListLoggerDefinitionVersionsInput{}
	}

	output = &ListLoggerDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoggerDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a logger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListLoggerDefinitionVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions
func (c *Greengrass) ListLoggerDefinitionVersions(input *ListLoggerDefinitionVersionsInput) (*ListLoggerDefinitionVersionsOutput, error) {
	req, out := c.ListLoggerDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListLoggerDefinitionVersionsWithContext is the same as ListLoggerDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoggerDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListLoggerDefinitionVersionsWithContext(ctx aws.Context, input *ListLoggerDefinitionVersionsInput, opts ...request.Option) (*ListLoggerDefinitionVersionsOutput, error) {
	req, out := c.ListLoggerDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoggerDefinitions = "ListLoggerDefinitions"

// ListLoggerDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoggerDefinitions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoggerDefinitions for more information on using the ListLoggerDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLoggerDefinitionsRequest method.
//    req, resp := client.ListLoggerDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions
func (c *Greengrass) ListLoggerDefinitionsRequest(input *ListLoggerDefinitionsInput) (req *request.Request, output *ListLoggerDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListLoggerDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/loggers",
	}

	if input == nil {
		input = &ListLoggerDefinitionsInput{}
	}

	output = &ListLoggerDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoggerDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of logger definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListLoggerDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions
func (c *Greengrass) ListLoggerDefinitions(input *ListLoggerDefinitionsInput) (*ListLoggerDefinitionsOutput, error) {
	req, out := c.ListLoggerDefinitionsRequest(input)
	return out, req.Send()
}

// ListLoggerDefinitionsWithContext is the same as ListLoggerDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoggerDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListLoggerDefinitionsWithContext(ctx aws.Context, input *ListLoggerDefinitionsInput, opts ...request.Option) (*ListLoggerDefinitionsOutput, error) {
	req, out := c.ListLoggerDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceDefinitionVersions = "ListResourceDefinitionVersions"

// ListResourceDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceDefinitionVersions for more information on using the ListResourceDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceDefinitionVersionsRequest method.
//    req, resp := client.ListResourceDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions
func (c *Greengrass) ListResourceDefinitionVersionsRequest(input *ListResourceDefinitionVersionsInput) (req *request.Request, output *ListResourceDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListResourceDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}/versions",
	}

	if input == nil {
		input = &ListResourceDefinitionVersionsInput{}
	}

	output = &ListResourceDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a resource definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListResourceDefinitionVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions
func (c *Greengrass) ListResourceDefinitionVersions(input *ListResourceDefinitionVersionsInput) (*ListResourceDefinitionVersionsOutput, error) {
	req, out := c.ListResourceDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListResourceDefinitionVersionsWithContext is the same as ListResourceDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListResourceDefinitionVersionsWithContext(ctx aws.Context, input *ListResourceDefinitionVersionsInput, opts ...request.Option) (*ListResourceDefinitionVersionsOutput, error) {
	req, out := c.ListResourceDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceDefinitions = "ListResourceDefinitions"

// ListResourceDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceDefinitions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceDefinitions for more information on using the ListResourceDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceDefinitionsRequest method.
//    req, resp := client.ListResourceDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions
func (c *Greengrass) ListResourceDefinitionsRequest(input *ListResourceDefinitionsInput) (req *request.Request, output *ListResourceDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListResourceDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources",
	}

	if input == nil {
		input = &ListResourceDefinitionsInput{}
	}

	output = &ListResourceDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of resource definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListResourceDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions
func (c *Greengrass) ListResourceDefinitions(input *ListResourceDefinitionsInput) (*ListResourceDefinitionsOutput, error) {
	req, out := c.ListResourceDefinitionsRequest(input)
	return out, req.Send()
}

// ListResourceDefinitionsWithContext is the same as ListResourceDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListResourceDefinitionsWithContext(ctx aws.Context, input *ListResourceDefinitionsInput, opts ...request.Option) (*ListResourceDefinitionsOutput, error) {
	req, out := c.ListResourceDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSubscriptionDefinitionVersions = "ListSubscriptionDefinitionVersions"

// ListSubscriptionDefinitionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptionDefinitionVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscriptionDefinitionVersions for more information on using the ListSubscriptionDefinitionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSubscriptionDefinitionVersionsRequest method.
//    req, resp := client.ListSubscriptionDefinitionVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions
func (c *Greengrass) ListSubscriptionDefinitionVersionsRequest(input *ListSubscriptionDefinitionVersionsInput) (req *request.Request, output *ListSubscriptionDefinitionVersionsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionDefinitionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions",
	}

	if input == nil {
		input = &ListSubscriptionDefinitionVersionsInput{}
	}

	output = &ListSubscriptionDefinitionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptionDefinitionVersions API operation for AWS Greengrass.
//
// Lists the versions of a subscription definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListSubscriptionDefinitionVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions
func (c *Greengrass) ListSubscriptionDefinitionVersions(input *ListSubscriptionDefinitionVersionsInput) (*ListSubscriptionDefinitionVersionsOutput, error) {
	req, out := c.ListSubscriptionDefinitionVersionsRequest(input)
	return out, req.Send()
}

// ListSubscriptionDefinitionVersionsWithContext is the same as ListSubscriptionDefinitionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscriptionDefinitionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListSubscriptionDefinitionVersionsWithContext(ctx aws.Context, input *ListSubscriptionDefinitionVersionsInput, opts ...request.Option) (*ListSubscriptionDefinitionVersionsOutput, error) {
	req, out := c.ListSubscriptionDefinitionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSubscriptionDefinitions = "ListSubscriptionDefinitions"

// ListSubscriptionDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptionDefinitions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscriptionDefinitions for more information on using the ListSubscriptionDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSubscriptionDefinitionsRequest method.
//    req, resp := client.ListSubscriptionDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions
func (c *Greengrass) ListSubscriptionDefinitionsRequest(input *ListSubscriptionDefinitionsInput) (req *request.Request, output *ListSubscriptionDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/subscriptions",
	}

	if input == nil {
		input = &ListSubscriptionDefinitionsInput{}
	}

	output = &ListSubscriptionDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptionDefinitions API operation for AWS Greengrass.
//
// Retrieves a list of subscription definitions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ListSubscriptionDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions
func (c *Greengrass) ListSubscriptionDefinitions(input *ListSubscriptionDefinitionsInput) (*ListSubscriptionDefinitionsOutput, error) {
	req, out := c.ListSubscriptionDefinitionsRequest(input)
	return out, req.Send()
}

// ListSubscriptionDefinitionsWithContext is the same as ListSubscriptionDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscriptionDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ListSubscriptionDefinitionsWithContext(ctx aws.Context, input *ListSubscriptionDefinitionsInput, opts ...request.Option) (*ListSubscriptionDefinitionsOutput, error) {
	req, out := c.ListSubscriptionDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDeployments = "ResetDeployments"

// ResetDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ResetDeployments operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDeployments for more information on using the ResetDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDeploymentsRequest method.
//    req, resp := client.ResetDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments
func (c *Greengrass) ResetDeploymentsRequest(input *ResetDeploymentsInput) (req *request.Request, output *ResetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opResetDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/groups/{GroupId}/deployments/$reset",
	}

	if input == nil {
		input = &ResetDeploymentsInput{}
	}

	output = &ResetDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDeployments API operation for AWS Greengrass.
//
// Resets a group's deployments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation ResetDeployments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments
func (c *Greengrass) ResetDeployments(input *ResetDeploymentsInput) (*ResetDeploymentsOutput, error) {
	req, out := c.ResetDeploymentsRequest(input)
	return out, req.Send()
}

// ResetDeploymentsWithContext is the same as ResetDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) ResetDeploymentsWithContext(ctx aws.Context, input *ResetDeploymentsInput, opts ...request.Option) (*ResetDeploymentsOutput, error) {
	req, out := c.ResetDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectivityInfo = "UpdateConnectivityInfo"

// UpdateConnectivityInfoRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectivityInfo operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectivityInfo for more information on using the UpdateConnectivityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectivityInfoRequest method.
//    req, resp := client.UpdateConnectivityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo
func (c *Greengrass) UpdateConnectivityInfoRequest(input *UpdateConnectivityInfoInput) (req *request.Request, output *UpdateConnectivityInfoOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectivityInfo,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/things/{ThingName}/connectivityInfo",
	}

	if input == nil {
		input = &UpdateConnectivityInfoInput{}
	}

	output = &UpdateConnectivityInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConnectivityInfo API operation for AWS Greengrass.
//
// Updates the connectivity information for the core. Any devices that belong
// to the group which has this core will receive this information in order to
// find the location of the core and connect to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateConnectivityInfo for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo
func (c *Greengrass) UpdateConnectivityInfo(input *UpdateConnectivityInfoInput) (*UpdateConnectivityInfoOutput, error) {
	req, out := c.UpdateConnectivityInfoRequest(input)
	return out, req.Send()
}

// UpdateConnectivityInfoWithContext is the same as UpdateConnectivityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectivityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateConnectivityInfoWithContext(ctx aws.Context, input *UpdateConnectivityInfoInput, opts ...request.Option) (*UpdateConnectivityInfoOutput, error) {
	req, out := c.UpdateConnectivityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCoreDefinition = "UpdateCoreDefinition"

// UpdateCoreDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCoreDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCoreDefinition for more information on using the UpdateCoreDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCoreDefinitionRequest method.
//    req, resp := client.UpdateCoreDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition
func (c *Greengrass) UpdateCoreDefinitionRequest(input *UpdateCoreDefinitionInput) (req *request.Request, output *UpdateCoreDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateCoreDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}",
	}

	if input == nil {
		input = &UpdateCoreDefinitionInput{}
	}

	output = &UpdateCoreDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCoreDefinition API operation for AWS Greengrass.
//
// Updates a core definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateCoreDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition
func (c *Greengrass) UpdateCoreDefinition(input *UpdateCoreDefinitionInput) (*UpdateCoreDefinitionOutput, error) {
	req, out := c.UpdateCoreDefinitionRequest(input)
	return out, req.Send()
}

// UpdateCoreDefinitionWithContext is the same as UpdateCoreDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCoreDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateCoreDefinitionWithContext(ctx aws.Context, input *UpdateCoreDefinitionInput, opts ...request.Option) (*UpdateCoreDefinitionOutput, error) {
	req, out := c.UpdateCoreDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeviceDefinition = "UpdateDeviceDefinition"

// UpdateDeviceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeviceDefinition for more information on using the UpdateDeviceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceDefinitionRequest method.
//    req, resp := client.UpdateDeviceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition
func (c *Greengrass) UpdateDeviceDefinitionRequest(input *UpdateDeviceDefinitionInput) (req *request.Request, output *UpdateDeviceDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}",
	}

	if input == nil {
		input = &UpdateDeviceDefinitionInput{}
	}

	output = &UpdateDeviceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDeviceDefinition API operation for AWS Greengrass.
//
// Updates a device definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateDeviceDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition
func (c *Greengrass) UpdateDeviceDefinition(input *UpdateDeviceDefinitionInput) (*UpdateDeviceDefinitionOutput, error) {
	req, out := c.UpdateDeviceDefinitionRequest(input)
	return out, req.Send()
}

// UpdateDeviceDefinitionWithContext is the same as UpdateDeviceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeviceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateDeviceDefinitionWithContext(ctx aws.Context, input *UpdateDeviceDefinitionInput, opts ...request.Option) (*UpdateDeviceDefinitionOutput, error) {
	req, out := c.UpdateDeviceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFunctionDefinition = "UpdateFunctionDefinition"

// UpdateFunctionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFunctionDefinition for more information on using the UpdateFunctionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFunctionDefinitionRequest method.
//    req, resp := client.UpdateFunctionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition
func (c *Greengrass) UpdateFunctionDefinitionRequest(input *UpdateFunctionDefinitionInput) (req *request.Request, output *UpdateFunctionDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateFunctionDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}",
	}

	if input == nil {
		input = &UpdateFunctionDefinitionInput{}
	}

	output = &UpdateFunctionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunctionDefinition API operation for AWS Greengrass.
//
// Updates a Lambda function definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateFunctionDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition
func (c *Greengrass) UpdateFunctionDefinition(input *UpdateFunctionDefinitionInput) (*UpdateFunctionDefinitionOutput, error) {
	req, out := c.UpdateFunctionDefinitionRequest(input)
	return out, req.Send()
}

// UpdateFunctionDefinitionWithContext is the same as UpdateFunctionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFunctionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateFunctionDefinitionWithContext(ctx aws.Context, input *UpdateFunctionDefinitionInput, opts ...request.Option) (*UpdateFunctionDefinitionOutput, error) {
	req, out := c.UpdateFunctionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup
func (c *Greengrass) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/groups/{GroupId}",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for AWS Greengrass.
//
// Updates a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup
func (c *Greengrass) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroupCertificateConfiguration = "UpdateGroupCertificateConfiguration"

// UpdateGroupCertificateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroupCertificateConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroupCertificateConfiguration for more information on using the UpdateGroupCertificateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupCertificateConfigurationRequest method.
//    req, resp := client.UpdateGroupCertificateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration
func (c *Greengrass) UpdateGroupCertificateConfigurationRequest(input *UpdateGroupCertificateConfigurationInput) (req *request.Request, output *UpdateGroupCertificateConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateGroupCertificateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities/configuration/expiry",
	}

	if input == nil {
		input = &UpdateGroupCertificateConfigurationInput{}
	}

	output = &UpdateGroupCertificateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroupCertificateConfiguration API operation for AWS Greengrass.
//
// Updates the Cert expiry time for a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateGroupCertificateConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   The server encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration
func (c *Greengrass) UpdateGroupCertificateConfiguration(input *UpdateGroupCertificateConfigurationInput) (*UpdateGroupCertificateConfigurationOutput, error) {
	req, out := c.UpdateGroupCertificateConfigurationRequest(input)
	return out, req.Send()
}

// UpdateGroupCertificateConfigurationWithContext is the same as UpdateGroupCertificateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroupCertificateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateGroupCertificateConfigurationWithContext(ctx aws.Context, input *UpdateGroupCertificateConfigurationInput, opts ...request.Option) (*UpdateGroupCertificateConfigurationOutput, error) {
	req, out := c.UpdateGroupCertificateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLoggerDefinition = "UpdateLoggerDefinition"

// UpdateLoggerDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLoggerDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLoggerDefinition for more information on using the UpdateLoggerDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLoggerDefinitionRequest method.
//    req, resp := client.UpdateLoggerDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition
func (c *Greengrass) UpdateLoggerDefinitionRequest(input *UpdateLoggerDefinitionInput) (req *request.Request, output *UpdateLoggerDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateLoggerDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}",
	}

	if input == nil {
		input = &UpdateLoggerDefinitionInput{}
	}

	output = &UpdateLoggerDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLoggerDefinition API operation for AWS Greengrass.
//
// Updates a logger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateLoggerDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition
func (c *Greengrass) UpdateLoggerDefinition(input *UpdateLoggerDefinitionInput) (*UpdateLoggerDefinitionOutput, error) {
	req, out := c.UpdateLoggerDefinitionRequest(input)
	return out, req.Send()
}

// UpdateLoggerDefinitionWithContext is the same as UpdateLoggerDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLoggerDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateLoggerDefinitionWithContext(ctx aws.Context, input *UpdateLoggerDefinitionInput, opts ...request.Option) (*UpdateLoggerDefinitionOutput, error) {
	req, out := c.UpdateLoggerDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceDefinition = "UpdateResourceDefinition"

// UpdateResourceDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceDefinition for more information on using the UpdateResourceDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceDefinitionRequest method.
//    req, resp := client.UpdateResourceDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition
func (c *Greengrass) UpdateResourceDefinitionRequest(input *UpdateResourceDefinitionInput) (req *request.Request, output *UpdateResourceDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}",
	}

	if input == nil {
		input = &UpdateResourceDefinitionInput{}
	}

	output = &UpdateResourceDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourceDefinition API operation for AWS Greengrass.
//
// Updates a resource definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateResourceDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition
func (c *Greengrass) UpdateResourceDefinition(input *UpdateResourceDefinitionInput) (*UpdateResourceDefinitionOutput, error) {
	req, out := c.UpdateResourceDefinitionRequest(input)
	return out, req.Send()
}

// UpdateResourceDefinitionWithContext is the same as UpdateResourceDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateResourceDefinitionWithContext(ctx aws.Context, input *UpdateResourceDefinitionInput, opts ...request.Option) (*UpdateResourceDefinitionOutput, error) {
	req, out := c.UpdateResourceDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriptionDefinition = "UpdateSubscriptionDefinition"

// UpdateSubscriptionDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriptionDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriptionDefinition for more information on using the UpdateSubscriptionDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSubscriptionDefinitionRequest method.
//    req, resp := client.UpdateSubscriptionDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition
func (c *Greengrass) UpdateSubscriptionDefinitionRequest(input *UpdateSubscriptionDefinitionInput) (req *request.Request, output *UpdateSubscriptionDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriptionDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
	}

	if input == nil {
		input = &UpdateSubscriptionDefinitionInput{}
	}

	output = &UpdateSubscriptionDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriptionDefinition API operation for AWS Greengrass.
//
// Updates a subscription definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Greengrass's
// API operation UpdateSubscriptionDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   user error
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition
func (c *Greengrass) UpdateSubscriptionDefinition(input *UpdateSubscriptionDefinitionInput) (*UpdateSubscriptionDefinitionOutput, error) {
	req, out := c.UpdateSubscriptionDefinitionRequest(input)
	return out, req.Send()
}

// UpdateSubscriptionDefinitionWithContext is the same as UpdateSubscriptionDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriptionDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Greengrass) UpdateSubscriptionDefinitionWithContext(ctx aws.Context, input *UpdateSubscriptionDefinitionInput, opts ...request.Option) (*UpdateSubscriptionDefinitionOutput, error) {
	req, out := c.UpdateSubscriptionDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroupRequest
type AssociateRoleToGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	// Role arn you wish to associate with this group.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s AssociateRoleToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRoleToGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateRoleToGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateRoleToGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AssociateRoleToGroupInput) SetGroupId(v string) *AssociateRoleToGroupInput {
	s.GroupId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AssociateRoleToGroupInput) SetRoleArn(v string) *AssociateRoleToGroupInput {
	s.RoleArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroupResponse
type AssociateRoleToGroupOutput struct {
	_ struct{} `type:"structure"`

	// Time the role arn was associated to your group.
	AssociatedAt *string `type:"string"`
}

// String returns the string representation
func (s AssociateRoleToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateRoleToGroupOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *AssociateRoleToGroupOutput) SetAssociatedAt(v string) *AssociateRoleToGroupOutput {
	s.AssociatedAt = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccountRequest
type AssociateServiceRoleToAccountInput struct {
	_ struct{} `type:"structure"`

	// Role arn you wish to associate with this account.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s AssociateServiceRoleToAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateServiceRoleToAccountInput) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *AssociateServiceRoleToAccountInput) SetRoleArn(v string) *AssociateServiceRoleToAccountInput {
	s.RoleArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccountResponse
type AssociateServiceRoleToAccountOutput struct {
	_ struct{} `type:"structure"`

	// Time when the service role was associated to the account.
	AssociatedAt *string `type:"string"`
}

// String returns the string representation
func (s AssociateServiceRoleToAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateServiceRoleToAccountOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *AssociateServiceRoleToAccountOutput) SetAssociatedAt(v string) *AssociateServiceRoleToAccountOutput {
	s.AssociatedAt = &v
	return s
}

// Connectivity Info
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ConnectivityInfo
type ConnectivityInfo struct {
	_ struct{} `type:"structure"`

	// Endpoint for the GGC. Can be an IP address or DNS.
	HostAddress *string `type:"string"`

	// Element Id for this entry in the list.
	Id *string `type:"string"`

	// Metadata for this endpoint.
	Metadata *string `type:"string"`

	// Port of the GGC. Usually 8883.
	PortNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s ConnectivityInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectivityInfo) GoString() string {
	return s.String()
}

// SetHostAddress sets the HostAddress field's value.
func (s *ConnectivityInfo) SetHostAddress(v string) *ConnectivityInfo {
	s.HostAddress = &v
	return s
}

// SetId sets the Id field's value.
func (s *ConnectivityInfo) SetId(v string) *ConnectivityInfo {
	s.Id = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ConnectivityInfo) SetMetadata(v string) *ConnectivityInfo {
	s.Metadata = &v
	return s
}

// SetPortNumber sets the PortNumber field's value.
func (s *ConnectivityInfo) SetPortNumber(v int64) *ConnectivityInfo {
	s.PortNumber = &v
	return s
}

// Information on the core
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Core
type Core struct {
	_ struct{} `type:"structure"`

	// Certificate arn of the core.
	CertificateArn *string `type:"string"`

	// Element Id for this entry in the list.
	Id *string `type:"string"`

	// If true, the local shadow value automatically syncs with the cloud's shadow
	// state.
	SyncShadow *bool `type:"boolean"`

	// Thing arn of the core.
	ThingArn *string `type:"string"`
}

// String returns the string representation
func (s Core) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Core) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Core) SetCertificateArn(v string) *Core {
	s.CertificateArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Core) SetId(v string) *Core {
	s.Id = &v
	return s
}

// SetSyncShadow sets the SyncShadow field's value.
func (s *Core) SetSyncShadow(v bool) *Core {
	s.SyncShadow = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *Core) SetThingArn(v string) *Core {
	s.ThingArn = &v
	return s
}

// Information on core definition version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CoreDefinitionVersion
type CoreDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// Cores in the definition version.
	Cores []*Core `type:"list"`
}

// String returns the string representation
func (s CoreDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CoreDefinitionVersion) GoString() string {
	return s.String()
}

// SetCores sets the Cores field's value.
func (s *CoreDefinitionVersion) SetCores(v []*Core) *CoreDefinitionVersion {
	s.Cores = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionRequest
type CreateCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information on core definition version
	InitialVersion *CoreDefinitionVersion `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCoreDefinitionInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateCoreDefinitionInput) SetAmznClientToken(v string) *CreateCoreDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateCoreDefinitionInput) SetInitialVersion(v *CoreDefinitionVersion) *CreateCoreDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCoreDefinitionInput) SetName(v string) *CreateCoreDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionResponse
type CreateCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCoreDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCoreDefinitionOutput) SetArn(v string) *CreateCoreDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateCoreDefinitionOutput) SetCreationTimestamp(v string) *CreateCoreDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateCoreDefinitionOutput) SetId(v string) *CreateCoreDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateCoreDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateCoreDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateCoreDefinitionOutput) SetLatestVersion(v string) *CreateCoreDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateCoreDefinitionOutput) SetLatestVersionArn(v string) *CreateCoreDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCoreDefinitionOutput) SetName(v string) *CreateCoreDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersionRequest
type CreateCoreDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	Cores []*Core `type:"list"`
}

// String returns the string representation
func (s CreateCoreDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCoreDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCoreDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCoreDefinitionVersionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateCoreDefinitionVersionInput) SetAmznClientToken(v string) *CreateCoreDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *CreateCoreDefinitionVersionInput) SetCoreDefinitionId(v string) *CreateCoreDefinitionVersionInput {
	s.CoreDefinitionId = &v
	return s
}

// SetCores sets the Cores field's value.
func (s *CreateCoreDefinitionVersionInput) SetCores(v []*Core) *CreateCoreDefinitionVersionInput {
	s.Cores = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersionResponse
type CreateCoreDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateCoreDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCoreDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCoreDefinitionVersionOutput) SetArn(v string) *CreateCoreDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateCoreDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateCoreDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateCoreDefinitionVersionOutput) SetId(v string) *CreateCoreDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateCoreDefinitionVersionOutput) SetVersion(v string) *CreateCoreDefinitionVersionOutput {
	s.Version = &v
	return s
}

// Information on Deployment
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeploymentRequest
type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Id of the deployment if you wish to redeploy a previous deployment.
	DeploymentId *string `type:"string"`

	// Type of deployment. When used in CreateDeployment, only NewDeployment and
	// Redeployment are valid.
	DeploymentType *string `type:"string" enum:"DeploymentType"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	// Group Version you wish to deploy.
	GroupVersionId *string `type:"string"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateDeploymentInput) SetAmznClientToken(v string) *CreateDeploymentInput {
	s.AmznClientToken = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentInput) SetDeploymentId(v string) *CreateDeploymentInput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *CreateDeploymentInput) SetDeploymentType(v string) *CreateDeploymentInput {
	s.DeploymentType = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateDeploymentInput) SetGroupId(v string) *CreateDeploymentInput {
	s.GroupId = &v
	return s
}

// SetGroupVersionId sets the GroupVersionId field's value.
func (s *CreateDeploymentInput) SetGroupVersionId(v string) *CreateDeploymentInput {
	s.GroupVersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeploymentResponse
type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The arn of the deployment.
	DeploymentArn *string `type:"string"`

	// The id of the deployment.
	DeploymentId *string `type:"string"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentArn sets the DeploymentArn field's value.
func (s *CreateDeploymentOutput) SetDeploymentArn(v string) *CreateDeploymentOutput {
	s.DeploymentArn = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionRequest
type CreateDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information on device definition version
	InitialVersion *DeviceDefinitionVersion `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceDefinitionInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateDeviceDefinitionInput) SetAmznClientToken(v string) *CreateDeviceDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateDeviceDefinitionInput) SetInitialVersion(v *DeviceDefinitionVersion) *CreateDeviceDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDeviceDefinitionInput) SetName(v string) *CreateDeviceDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionResponse
type CreateDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDeviceDefinitionOutput) SetArn(v string) *CreateDeviceDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateDeviceDefinitionOutput) SetCreationTimestamp(v string) *CreateDeviceDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDeviceDefinitionOutput) SetId(v string) *CreateDeviceDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateDeviceDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateDeviceDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateDeviceDefinitionOutput) SetLatestVersion(v string) *CreateDeviceDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateDeviceDefinitionOutput) SetLatestVersionArn(v string) *CreateDeviceDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDeviceDefinitionOutput) SetName(v string) *CreateDeviceDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersionRequest
type CreateDeviceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	Devices []*Device `type:"list"`
}

// String returns the string representation
func (s CreateDeviceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeviceDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeviceDefinitionVersionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateDeviceDefinitionVersionInput) SetAmznClientToken(v string) *CreateDeviceDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *CreateDeviceDefinitionVersionInput) SetDeviceDefinitionId(v string) *CreateDeviceDefinitionVersionInput {
	s.DeviceDefinitionId = &v
	return s
}

// SetDevices sets the Devices field's value.
func (s *CreateDeviceDefinitionVersionInput) SetDevices(v []*Device) *CreateDeviceDefinitionVersionInput {
	s.Devices = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersionResponse
type CreateDeviceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateDeviceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeviceDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDeviceDefinitionVersionOutput) SetArn(v string) *CreateDeviceDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateDeviceDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateDeviceDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDeviceDefinitionVersionOutput) SetId(v string) *CreateDeviceDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateDeviceDefinitionVersionOutput) SetVersion(v string) *CreateDeviceDefinitionVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionRequest
type CreateFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information on the function definition version
	InitialVersion *FunctionDefinitionVersion `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionDefinitionInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateFunctionDefinitionInput) SetAmznClientToken(v string) *CreateFunctionDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateFunctionDefinitionInput) SetInitialVersion(v *FunctionDefinitionVersion) *CreateFunctionDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFunctionDefinitionInput) SetName(v string) *CreateFunctionDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionResponse
type CreateFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFunctionDefinitionOutput) SetArn(v string) *CreateFunctionDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateFunctionDefinitionOutput) SetCreationTimestamp(v string) *CreateFunctionDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFunctionDefinitionOutput) SetId(v string) *CreateFunctionDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateFunctionDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateFunctionDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateFunctionDefinitionOutput) SetLatestVersion(v string) *CreateFunctionDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateFunctionDefinitionOutput) SetLatestVersionArn(v string) *CreateFunctionDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFunctionDefinitionOutput) SetName(v string) *CreateFunctionDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersionRequest
type CreateFunctionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	Functions []*Function `type:"list"`
}

// String returns the string representation
func (s CreateFunctionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFunctionDefinitionVersionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateFunctionDefinitionVersionInput) SetAmznClientToken(v string) *CreateFunctionDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *CreateFunctionDefinitionVersionInput) SetFunctionDefinitionId(v string) *CreateFunctionDefinitionVersionInput {
	s.FunctionDefinitionId = &v
	return s
}

// SetFunctions sets the Functions field's value.
func (s *CreateFunctionDefinitionVersionInput) SetFunctions(v []*Function) *CreateFunctionDefinitionVersionInput {
	s.Functions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersionResponse
type CreateFunctionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateFunctionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFunctionDefinitionVersionOutput) SetArn(v string) *CreateFunctionDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateFunctionDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateFunctionDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFunctionDefinitionVersionOutput) SetId(v string) *CreateFunctionDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateFunctionDefinitionVersionOutput) SetVersion(v string) *CreateFunctionDefinitionVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthorityRequest
type CreateGroupCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupCertificateAuthorityInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateGroupCertificateAuthorityInput) SetAmznClientToken(v string) *CreateGroupCertificateAuthorityInput {
	s.AmznClientToken = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupCertificateAuthorityInput) SetGroupId(v string) *CreateGroupCertificateAuthorityInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthorityResponse
type CreateGroupCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the group certificate authority.
	GroupCertificateAuthorityArn *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetGroupCertificateAuthorityArn sets the GroupCertificateAuthorityArn field's value.
func (s *CreateGroupCertificateAuthorityOutput) SetGroupCertificateAuthorityArn(v string) *CreateGroupCertificateAuthorityOutput {
	s.GroupCertificateAuthorityArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupRequest
type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information on group version
	InitialVersion *GroupVersion `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateGroupInput) SetAmznClientToken(v string) *CreateGroupInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateGroupInput) SetInitialVersion(v *GroupVersion) *CreateGroupInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGroupInput) SetName(v string) *CreateGroupInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupResponse
type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateGroupOutput) SetArn(v string) *CreateGroupOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateGroupOutput) SetCreationTimestamp(v string) *CreateGroupOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateGroupOutput) SetId(v string) *CreateGroupOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateGroupOutput) SetLastUpdatedTimestamp(v string) *CreateGroupOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateGroupOutput) SetLatestVersion(v string) *CreateGroupOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateGroupOutput) SetLatestVersionArn(v string) *CreateGroupOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGroupOutput) SetName(v string) *CreateGroupOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersionRequest
type CreateGroupVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	CoreDefinitionVersionArn *string `type:"string"`

	DeviceDefinitionVersionArn *string `type:"string"`

	FunctionDefinitionVersionArn *string `type:"string"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	LoggerDefinitionVersionArn *string `type:"string"`

	ResourceDefinitionVersionArn *string `type:"string"`

	SubscriptionDefinitionVersionArn *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupVersionInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateGroupVersionInput) SetAmznClientToken(v string) *CreateGroupVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetCoreDefinitionVersionArn sets the CoreDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetCoreDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.CoreDefinitionVersionArn = &v
	return s
}

// SetDeviceDefinitionVersionArn sets the DeviceDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetDeviceDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.DeviceDefinitionVersionArn = &v
	return s
}

// SetFunctionDefinitionVersionArn sets the FunctionDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetFunctionDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.FunctionDefinitionVersionArn = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupVersionInput) SetGroupId(v string) *CreateGroupVersionInput {
	s.GroupId = &v
	return s
}

// SetLoggerDefinitionVersionArn sets the LoggerDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetLoggerDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.LoggerDefinitionVersionArn = &v
	return s
}

// SetResourceDefinitionVersionArn sets the ResourceDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetResourceDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.ResourceDefinitionVersionArn = &v
	return s
}

// SetSubscriptionDefinitionVersionArn sets the SubscriptionDefinitionVersionArn field's value.
func (s *CreateGroupVersionInput) SetSubscriptionDefinitionVersionArn(v string) *CreateGroupVersionInput {
	s.SubscriptionDefinitionVersionArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersionResponse
type CreateGroupVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateGroupVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateGroupVersionOutput) SetArn(v string) *CreateGroupVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateGroupVersionOutput) SetCreationTimestamp(v string) *CreateGroupVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateGroupVersionOutput) SetId(v string) *CreateGroupVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateGroupVersionOutput) SetVersion(v string) *CreateGroupVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionRequest
type CreateLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information on logger definition version
	InitialVersion *LoggerDefinitionVersion `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoggerDefinitionInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateLoggerDefinitionInput) SetAmznClientToken(v string) *CreateLoggerDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateLoggerDefinitionInput) SetInitialVersion(v *LoggerDefinitionVersion) *CreateLoggerDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLoggerDefinitionInput) SetName(v string) *CreateLoggerDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionResponse
type CreateLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoggerDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateLoggerDefinitionOutput) SetArn(v string) *CreateLoggerDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateLoggerDefinitionOutput) SetCreationTimestamp(v string) *CreateLoggerDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateLoggerDefinitionOutput) SetId(v string) *CreateLoggerDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateLoggerDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateLoggerDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateLoggerDefinitionOutput) SetLatestVersion(v string) *CreateLoggerDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateLoggerDefinitionOutput) SetLatestVersionArn(v string) *CreateLoggerDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLoggerDefinitionOutput) SetName(v string) *CreateLoggerDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersionRequest
type CreateLoggerDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	Loggers []*Logger `type:"list"`
}

// String returns the string representation
func (s CreateLoggerDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoggerDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoggerDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoggerDefinitionVersionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateLoggerDefinitionVersionInput) SetAmznClientToken(v string) *CreateLoggerDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *CreateLoggerDefinitionVersionInput) SetLoggerDefinitionId(v string) *CreateLoggerDefinitionVersionInput {
	s.LoggerDefinitionId = &v
	return s
}

// SetLoggers sets the Loggers field's value.
func (s *CreateLoggerDefinitionVersionInput) SetLoggers(v []*Logger) *CreateLoggerDefinitionVersionInput {
	s.Loggers = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersionResponse
type CreateLoggerDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateLoggerDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoggerDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateLoggerDefinitionVersionOutput) SetArn(v string) *CreateLoggerDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateLoggerDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateLoggerDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateLoggerDefinitionVersionOutput) SetId(v string) *CreateLoggerDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateLoggerDefinitionVersionOutput) SetVersion(v string) *CreateLoggerDefinitionVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionRequest
type CreateResourceDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information on resource definition version
	InitialVersion *ResourceDefinitionVersion `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateResourceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDefinitionInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateResourceDefinitionInput) SetAmznClientToken(v string) *CreateResourceDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateResourceDefinitionInput) SetInitialVersion(v *ResourceDefinitionVersion) *CreateResourceDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceDefinitionInput) SetName(v string) *CreateResourceDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionResponse
type CreateResourceDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateResourceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateResourceDefinitionOutput) SetArn(v string) *CreateResourceDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateResourceDefinitionOutput) SetCreationTimestamp(v string) *CreateResourceDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateResourceDefinitionOutput) SetId(v string) *CreateResourceDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateResourceDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateResourceDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateResourceDefinitionOutput) SetLatestVersion(v string) *CreateResourceDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateResourceDefinitionOutput) SetLatestVersionArn(v string) *CreateResourceDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceDefinitionOutput) SetName(v string) *CreateResourceDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersionRequest
type CreateResourceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`

	Resources []*Resource `type:"list"`
}

// String returns the string representation
func (s CreateResourceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceDefinitionVersionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateResourceDefinitionVersionInput) SetAmznClientToken(v string) *CreateResourceDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *CreateResourceDefinitionVersionInput) SetResourceDefinitionId(v string) *CreateResourceDefinitionVersionInput {
	s.ResourceDefinitionId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateResourceDefinitionVersionInput) SetResources(v []*Resource) *CreateResourceDefinitionVersionInput {
	s.Resources = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersionResponse
type CreateResourceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateResourceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateResourceDefinitionVersionOutput) SetArn(v string) *CreateResourceDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateResourceDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateResourceDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateResourceDefinitionVersionOutput) SetId(v string) *CreateResourceDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateResourceDefinitionVersionOutput) SetVersion(v string) *CreateResourceDefinitionVersionOutput {
	s.Version = &v
	return s
}

// Request for the CreateSoftwareUpdateJob API
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJobRequest
type CreateSoftwareUpdateJobInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// The IAM Role that Greengrass will use to create pre-signed URLs pointing
	// towards the update artifact.
	S3UrlSignerRole *string `type:"string"`

	// The piece of software on the Greengrass Core that will be updated.
	SoftwareToUpdate *string `type:"string" enum:"SoftwareToUpdate"`

	// The minimum level of log statements that should be logged by the OTA Agent
	// during an update.
	UpdateAgentLogLevel *string `type:"string" enum:"UpdateAgentLogLevel"`

	// The target arns that this update will be applied to.
	UpdateTargets []*string `type:"list"`

	// The architecture of the Cores in the targets of an update
	UpdateTargetsArchitecture *string `type:"string" enum:"UpdateTargetsArchitecture"`

	// The operating system of the Cores in the targets of an update
	UpdateTargetsOperatingSystem *string `type:"string" enum:"UpdateTargetsOperatingSystem"`
}

// String returns the string representation
func (s CreateSoftwareUpdateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSoftwareUpdateJobInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateSoftwareUpdateJobInput) SetAmznClientToken(v string) *CreateSoftwareUpdateJobInput {
	s.AmznClientToken = &v
	return s
}

// SetS3UrlSignerRole sets the S3UrlSignerRole field's value.
func (s *CreateSoftwareUpdateJobInput) SetS3UrlSignerRole(v string) *CreateSoftwareUpdateJobInput {
	s.S3UrlSignerRole = &v
	return s
}

// SetSoftwareToUpdate sets the SoftwareToUpdate field's value.
func (s *CreateSoftwareUpdateJobInput) SetSoftwareToUpdate(v string) *CreateSoftwareUpdateJobInput {
	s.SoftwareToUpdate = &v
	return s
}

// SetUpdateAgentLogLevel sets the UpdateAgentLogLevel field's value.
func (s *CreateSoftwareUpdateJobInput) SetUpdateAgentLogLevel(v string) *CreateSoftwareUpdateJobInput {
	s.UpdateAgentLogLevel = &v
	return s
}

// SetUpdateTargets sets the UpdateTargets field's value.
func (s *CreateSoftwareUpdateJobInput) SetUpdateTargets(v []*string) *CreateSoftwareUpdateJobInput {
	s.UpdateTargets = v
	return s
}

// SetUpdateTargetsArchitecture sets the UpdateTargetsArchitecture field's value.
func (s *CreateSoftwareUpdateJobInput) SetUpdateTargetsArchitecture(v string) *CreateSoftwareUpdateJobInput {
	s.UpdateTargetsArchitecture = &v
	return s
}

// SetUpdateTargetsOperatingSystem sets the UpdateTargetsOperatingSystem field's value.
func (s *CreateSoftwareUpdateJobInput) SetUpdateTargetsOperatingSystem(v string) *CreateSoftwareUpdateJobInput {
	s.UpdateTargetsOperatingSystem = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJobResponse
type CreateSoftwareUpdateJobOutput struct {
	_ struct{} `type:"structure"`

	// The Iot Job Arn corresponding to this update.
	IotJobArn *string `type:"string"`

	// The Iot Job Id corresponding to this update.
	IotJobId *string `type:"string"`
}

// String returns the string representation
func (s CreateSoftwareUpdateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSoftwareUpdateJobOutput) GoString() string {
	return s.String()
}

// SetIotJobArn sets the IotJobArn field's value.
func (s *CreateSoftwareUpdateJobOutput) SetIotJobArn(v string) *CreateSoftwareUpdateJobOutput {
	s.IotJobArn = &v
	return s
}

// SetIotJobId sets the IotJobId field's value.
func (s *CreateSoftwareUpdateJobOutput) SetIotJobId(v string) *CreateSoftwareUpdateJobOutput {
	s.IotJobId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionRequest
type CreateSubscriptionDefinitionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// Information on subscription definition version
	InitialVersion *SubscriptionDefinitionVersion `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateSubscriptionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionDefinitionInput) GoString() string {
	return s.String()
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateSubscriptionDefinitionInput) SetAmznClientToken(v string) *CreateSubscriptionDefinitionInput {
	s.AmznClientToken = &v
	return s
}

// SetInitialVersion sets the InitialVersion field's value.
func (s *CreateSubscriptionDefinitionInput) SetInitialVersion(v *SubscriptionDefinitionVersion) *CreateSubscriptionDefinitionInput {
	s.InitialVersion = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSubscriptionDefinitionInput) SetName(v string) *CreateSubscriptionDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionResponse
type CreateSubscriptionDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateSubscriptionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSubscriptionDefinitionOutput) SetArn(v string) *CreateSubscriptionDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateSubscriptionDefinitionOutput) SetCreationTimestamp(v string) *CreateSubscriptionDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSubscriptionDefinitionOutput) SetId(v string) *CreateSubscriptionDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *CreateSubscriptionDefinitionOutput) SetLastUpdatedTimestamp(v string) *CreateSubscriptionDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *CreateSubscriptionDefinitionOutput) SetLatestVersion(v string) *CreateSubscriptionDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *CreateSubscriptionDefinitionOutput) SetLatestVersionArn(v string) *CreateSubscriptionDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSubscriptionDefinitionOutput) SetName(v string) *CreateSubscriptionDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersionRequest
type CreateSubscriptionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`

	Subscriptions []*Subscription `type:"list"`
}

// String returns the string representation
func (s CreateSubscriptionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriptionDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriptionDefinitionVersionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *CreateSubscriptionDefinitionVersionInput) SetAmznClientToken(v string) *CreateSubscriptionDefinitionVersionInput {
	s.AmznClientToken = &v
	return s
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *CreateSubscriptionDefinitionVersionInput) SetSubscriptionDefinitionId(v string) *CreateSubscriptionDefinitionVersionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *CreateSubscriptionDefinitionVersionInput) SetSubscriptions(v []*Subscription) *CreateSubscriptionDefinitionVersionInput {
	s.Subscriptions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersionResponse
type CreateSubscriptionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateSubscriptionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubscriptionDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSubscriptionDefinitionVersionOutput) SetArn(v string) *CreateSubscriptionDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *CreateSubscriptionDefinitionVersionOutput) SetCreationTimestamp(v string) *CreateSubscriptionDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSubscriptionDefinitionVersionOutput) SetId(v string) *CreateSubscriptionDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateSubscriptionDefinitionVersionOutput) SetVersion(v string) *CreateSubscriptionDefinitionVersionOutput {
	s.Version = &v
	return s
}

// Information on the Definition
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DefinitionInformation
type DefinitionInformation struct {
	_ struct{} `type:"structure"`

	// Arn of the definition.
	Arn *string `type:"string"`

	// Timestamp of when the definition was created.
	CreationTimestamp *string `type:"string"`

	// Id of the definition.
	Id *string `type:"string"`

	// Last updated timestamp of the definition.
	LastUpdatedTimestamp *string `type:"string"`

	// Last version of the definition.
	LatestVersion *string `type:"string"`

	// Latest version arn of the definition.
	LatestVersionArn *string `type:"string"`

	// Name of the definition.
	Name *string `type:"string"`
}

// String returns the string representation
func (s DefinitionInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefinitionInformation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DefinitionInformation) SetArn(v string) *DefinitionInformation {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DefinitionInformation) SetCreationTimestamp(v string) *DefinitionInformation {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *DefinitionInformation) SetId(v string) *DefinitionInformation {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *DefinitionInformation) SetLastUpdatedTimestamp(v string) *DefinitionInformation {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *DefinitionInformation) SetLatestVersion(v string) *DefinitionInformation {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *DefinitionInformation) SetLatestVersionArn(v string) *DefinitionInformation {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DefinitionInformation) SetName(v string) *DefinitionInformation {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinitionRequest
type DeleteCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCoreDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCoreDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCoreDefinitionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *DeleteCoreDefinitionInput) SetCoreDefinitionId(v string) *DeleteCoreDefinitionInput {
	s.CoreDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinitionResponse
type DeleteCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCoreDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinitionRequest
type DeleteDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeviceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeviceDefinitionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *DeleteDeviceDefinitionInput) SetDeviceDefinitionId(v string) *DeleteDeviceDefinitionInput {
	s.DeviceDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinitionResponse
type DeleteDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeviceDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinitionRequest
type DeleteFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionDefinitionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *DeleteFunctionDefinitionInput) SetFunctionDefinitionId(v string) *DeleteFunctionDefinitionInput {
	s.FunctionDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinitionResponse
type DeleteFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroupRequest
type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteGroupInput) SetGroupId(v string) *DeleteGroupInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroupResponse
type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinitionRequest
type DeleteLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoggerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoggerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoggerDefinitionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *DeleteLoggerDefinitionInput) SetLoggerDefinitionId(v string) *DeleteLoggerDefinitionInput {
	s.LoggerDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinitionResponse
type DeleteLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoggerDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinitionRequest
type DeleteResourceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceDefinitionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *DeleteResourceDefinitionInput) SetResourceDefinitionId(v string) *DeleteResourceDefinitionInput {
	s.ResourceDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinitionResponse
type DeleteResourceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinitionRequest
type DeleteSubscriptionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSubscriptionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriptionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriptionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriptionDefinitionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *DeleteSubscriptionDefinitionInput) SetSubscriptionDefinitionId(v string) *DeleteSubscriptionDefinitionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinitionResponse
type DeleteSubscriptionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubscriptionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubscriptionDefinitionOutput) GoString() string {
	return s.String()
}

// Information on the deployment
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Deployment
type Deployment struct {
	_ struct{} `type:"structure"`

	// Timestamp when the deployment was created.
	CreatedAt *string `type:"string"`

	// Arn of the deployment.
	DeploymentArn *string `type:"string"`

	// Id of the deployment.
	DeploymentId *string `type:"string"`

	// The type of deployment.
	DeploymentType *string `type:"string" enum:"DeploymentType"`

	// Arn of the group for this deployment.
	GroupArn *string `type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Deployment) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Deployment) SetCreatedAt(v string) *Deployment {
	s.CreatedAt = &v
	return s
}

// SetDeploymentArn sets the DeploymentArn field's value.
func (s *Deployment) SetDeploymentArn(v string) *Deployment {
	s.DeploymentArn = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Deployment) SetDeploymentId(v string) *Deployment {
	s.DeploymentId = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *Deployment) SetDeploymentType(v string) *Deployment {
	s.DeploymentType = &v
	return s
}

// SetGroupArn sets the GroupArn field's value.
func (s *Deployment) SetGroupArn(v string) *Deployment {
	s.GroupArn = &v
	return s
}

// Information on a Device
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Device
type Device struct {
	_ struct{} `type:"structure"`

	// Certificate arn of the device.
	CertificateArn *string `type:"string"`

	// Element Id for this entry in the list.
	Id *string `type:"string"`

	// If true, the local shadow value automatically syncs with the cloud's shadow
	// state.
	SyncShadow *bool `type:"boolean"`

	// Thing arn of the device.
	ThingArn *string `type:"string"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Device) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Device) SetCertificateArn(v string) *Device {
	s.CertificateArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Device) SetId(v string) *Device {
	s.Id = &v
	return s
}

// SetSyncShadow sets the SyncShadow field's value.
func (s *Device) SetSyncShadow(v bool) *Device {
	s.SyncShadow = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *Device) SetThingArn(v string) *Device {
	s.ThingArn = &v
	return s
}

// Information on device definition version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeviceDefinitionVersion
type DeviceDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// Devices in the definition version.
	Devices []*Device `type:"list"`
}

// String returns the string representation
func (s DeviceDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceDefinitionVersion) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *DeviceDefinitionVersion) SetDevices(v []*Device) *DeviceDefinitionVersion {
	s.Devices = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroupRequest
type DisassociateRoleFromGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateRoleFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRoleFromGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateRoleFromGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateRoleFromGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DisassociateRoleFromGroupInput) SetGroupId(v string) *DisassociateRoleFromGroupInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroupResponse
type DisassociateRoleFromGroupOutput struct {
	_ struct{} `type:"structure"`

	// Time when the role was disassociated from the group.
	DisassociatedAt *string `type:"string"`
}

// String returns the string representation
func (s DisassociateRoleFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateRoleFromGroupOutput) GoString() string {
	return s.String()
}

// SetDisassociatedAt sets the DisassociatedAt field's value.
func (s *DisassociateRoleFromGroupOutput) SetDisassociatedAt(v string) *DisassociateRoleFromGroupOutput {
	s.DisassociatedAt = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccountRequest
type DisassociateServiceRoleFromAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceRoleFromAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateServiceRoleFromAccountInput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccountResponse
type DisassociateServiceRoleFromAccountOutput struct {
	_ struct{} `type:"structure"`

	// Time when the service role was disassociated from the account.
	DisassociatedAt *string `type:"string"`
}

// String returns the string representation
func (s DisassociateServiceRoleFromAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateServiceRoleFromAccountOutput) GoString() string {
	return s.String()
}

// SetDisassociatedAt sets the DisassociatedAt field's value.
func (s *DisassociateServiceRoleFromAccountOutput) SetDisassociatedAt(v string) *DisassociateServiceRoleFromAccountOutput {
	s.DisassociatedAt = &v
	return s
}

// ErrorDetail
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ErrorDetail
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// Detailed Error Code
	DetailedErrorCode *string `type:"string"`

	// Detailed Error Message
	DetailedErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetDetailedErrorCode sets the DetailedErrorCode field's value.
func (s *ErrorDetail) SetDetailedErrorCode(v string) *ErrorDetail {
	s.DetailedErrorCode = &v
	return s
}

// SetDetailedErrorMessage sets the DetailedErrorMessage field's value.
func (s *ErrorDetail) SetDetailedErrorMessage(v string) *ErrorDetail {
	s.DetailedErrorMessage = &v
	return s
}

// Information on function
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Function
type Function struct {
	_ struct{} `type:"structure"`

	// Arn of the Lambda function.
	FunctionArn *string `type:"string"`

	// Configuration of the function
	FunctionConfiguration *FunctionConfiguration `type:"structure"`

	// Id of the function in this version.
	Id *string `type:"string"`
}

// String returns the string representation
func (s Function) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Function) GoString() string {
	return s.String()
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *Function) SetFunctionArn(v string) *Function {
	s.FunctionArn = &v
	return s
}

// SetFunctionConfiguration sets the FunctionConfiguration field's value.
func (s *Function) SetFunctionConfiguration(v *FunctionConfiguration) *Function {
	s.FunctionConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *Function) SetId(v string) *Function {
	s.Id = &v
	return s
}

// Configuration of the function
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionConfiguration
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// Environment of the function configuration
	Environment *FunctionConfigurationEnvironment `type:"structure"`

	// Execution Arguments
	ExecArgs *string `type:"string"`

	// Executable
	Executable *string `type:"string"`

	// The memory size, in KB, you configured for the function.
	MemorySize *int64 `type:"integer"`

	// Whether the function is pinned or not. Pinned means the function is long-lived
	// and starts when the core starts.
	Pinned *bool `type:"boolean"`

	// The function execution time at which Lambda should terminate the function.
	// This timeout still applies to pinned lambdas for each request.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfiguration) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *FunctionConfiguration) SetEnvironment(v *FunctionConfigurationEnvironment) *FunctionConfiguration {
	s.Environment = v
	return s
}

// SetExecArgs sets the ExecArgs field's value.
func (s *FunctionConfiguration) SetExecArgs(v string) *FunctionConfiguration {
	s.ExecArgs = &v
	return s
}

// SetExecutable sets the Executable field's value.
func (s *FunctionConfiguration) SetExecutable(v string) *FunctionConfiguration {
	s.Executable = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *FunctionConfiguration) SetMemorySize(v int64) *FunctionConfiguration {
	s.MemorySize = &v
	return s
}

// SetPinned sets the Pinned field's value.
func (s *FunctionConfiguration) SetPinned(v bool) *FunctionConfiguration {
	s.Pinned = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *FunctionConfiguration) SetTimeout(v int64) *FunctionConfiguration {
	s.Timeout = &v
	return s
}

// Environment of the function configuration
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionConfigurationEnvironment
type FunctionConfigurationEnvironment struct {
	_ struct{} `type:"structure"`

	// Flag to allow lambda access sys filesystem.
	AccessSysfs *bool `type:"boolean"`

	// Policies for the function to access resources.
	ResourceAccessPolicies []*ResourceAccessPolicy `type:"list"`

	Variables map[string]*string `type:"map"`
}

// String returns the string representation
func (s FunctionConfigurationEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfigurationEnvironment) GoString() string {
	return s.String()
}

// SetAccessSysfs sets the AccessSysfs field's value.
func (s *FunctionConfigurationEnvironment) SetAccessSysfs(v bool) *FunctionConfigurationEnvironment {
	s.AccessSysfs = &v
	return s
}

// SetResourceAccessPolicies sets the ResourceAccessPolicies field's value.
func (s *FunctionConfigurationEnvironment) SetResourceAccessPolicies(v []*ResourceAccessPolicy) *FunctionConfigurationEnvironment {
	s.ResourceAccessPolicies = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *FunctionConfigurationEnvironment) SetVariables(v map[string]*string) *FunctionConfigurationEnvironment {
	s.Variables = v
	return s
}

// Information on the function definition version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionDefinitionVersion
type FunctionDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// Lambda functions in this function definition version.
	Functions []*Function `type:"list"`
}

// String returns the string representation
func (s FunctionDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionDefinitionVersion) GoString() string {
	return s.String()
}

// SetFunctions sets the Functions field's value.
func (s *FunctionDefinitionVersion) SetFunctions(v []*Function) *FunctionDefinitionVersion {
	s.Functions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRoleRequest
type GetAssociatedRoleInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAssociatedRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssociatedRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssociatedRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssociatedRoleInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetAssociatedRoleInput) SetGroupId(v string) *GetAssociatedRoleInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRoleResponse
type GetAssociatedRoleOutput struct {
	_ struct{} `type:"structure"`

	// Time when the role was associated for the group.
	AssociatedAt *string `type:"string"`

	// Arn of the role that is associated with the group.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s GetAssociatedRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssociatedRoleOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *GetAssociatedRoleOutput) SetAssociatedAt(v string) *GetAssociatedRoleOutput {
	s.AssociatedAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetAssociatedRoleOutput) SetRoleArn(v string) *GetAssociatedRoleOutput {
	s.RoleArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfoRequest
type GetConnectivityInfoInput struct {
	_ struct{} `type:"structure"`

	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"ThingName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConnectivityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectivityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectivityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectivityInfoInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThingName sets the ThingName field's value.
func (s *GetConnectivityInfoInput) SetThingName(v string) *GetConnectivityInfoInput {
	s.ThingName = &v
	return s
}

// connectivity info response
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfoResponse
type GetConnectivityInfoOutput struct {
	_ struct{} `type:"structure"`

	// Connectivity info list
	ConnectivityInfo []*ConnectivityInfo `type:"list"`

	// Response Text
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s GetConnectivityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectivityInfoOutput) GoString() string {
	return s.String()
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *GetConnectivityInfoOutput) SetConnectivityInfo(v []*ConnectivityInfo) *GetConnectivityInfoOutput {
	s.ConnectivityInfo = v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetConnectivityInfoOutput) SetMessage(v string) *GetConnectivityInfoOutput {
	s.Message = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionRequest
type GetCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCoreDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCoreDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCoreDefinitionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *GetCoreDefinitionInput) SetCoreDefinitionId(v string) *GetCoreDefinitionInput {
	s.CoreDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionResponse
type GetCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s GetCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCoreDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetCoreDefinitionOutput) SetArn(v string) *GetCoreDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetCoreDefinitionOutput) SetCreationTimestamp(v string) *GetCoreDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetCoreDefinitionOutput) SetId(v string) *GetCoreDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetCoreDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetCoreDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetCoreDefinitionOutput) SetLatestVersion(v string) *GetCoreDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetCoreDefinitionOutput) SetLatestVersionArn(v string) *GetCoreDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetCoreDefinitionOutput) SetName(v string) *GetCoreDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersionRequest
type GetCoreDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	// CoreDefinitionVersionId is a required field
	CoreDefinitionVersionId *string `location:"uri" locationName:"CoreDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCoreDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCoreDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCoreDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCoreDefinitionVersionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}
	if s.CoreDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *GetCoreDefinitionVersionInput) SetCoreDefinitionId(v string) *GetCoreDefinitionVersionInput {
	s.CoreDefinitionId = &v
	return s
}

// SetCoreDefinitionVersionId sets the CoreDefinitionVersionId field's value.
func (s *GetCoreDefinitionVersionInput) SetCoreDefinitionVersionId(v string) *GetCoreDefinitionVersionInput {
	s.CoreDefinitionVersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersionResponse
type GetCoreDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the core definition version.
	Arn *string `type:"string"`

	// Timestamp of when the core definition version was created.
	CreationTimestamp *string `type:"string"`

	// Information on definition
	Definition *CoreDefinitionVersion `type:"structure"`

	// Id of the core definition the version belongs to.
	Id *string `type:"string"`

	// Version of the core definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetCoreDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCoreDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetCoreDefinitionVersionOutput) SetArn(v string) *GetCoreDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetCoreDefinitionVersionOutput) SetCreationTimestamp(v string) *GetCoreDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetCoreDefinitionVersionOutput) SetDefinition(v *CoreDefinitionVersion) *GetCoreDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetCoreDefinitionVersionOutput) SetId(v string) *GetCoreDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetCoreDefinitionVersionOutput) SetVersion(v string) *GetCoreDefinitionVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatusRequest
type GetDeploymentStatusInput struct {
	_ struct{} `type:"structure"`

	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"DeploymentId" type:"string" required:"true"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentStatusInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentStatusInput) SetDeploymentId(v string) *GetDeploymentStatusInput {
	s.DeploymentId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GetDeploymentStatusInput) SetGroupId(v string) *GetDeploymentStatusInput {
	s.GroupId = &v
	return s
}

// The response body contains the status of a deployment for a group.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatusResponse
type GetDeploymentStatusOutput struct {
	_ struct{} `type:"structure"`

	// Status of the deployment.
	DeploymentStatus *string `type:"string"`

	// The type of the deployment.
	DeploymentType *string `type:"string" enum:"DeploymentType"`

	// The error Details
	ErrorDetails []*ErrorDetail `type:"list"`

	// Error Message
	ErrorMessage *string `type:"string"`

	// Last time the deployment status was updated.
	UpdatedAt *string `type:"string"`
}

// String returns the string representation
func (s GetDeploymentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentStatusOutput) GoString() string {
	return s.String()
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *GetDeploymentStatusOutput) SetDeploymentStatus(v string) *GetDeploymentStatusOutput {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *GetDeploymentStatusOutput) SetDeploymentType(v string) *GetDeploymentStatusOutput {
	s.DeploymentType = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *GetDeploymentStatusOutput) SetErrorDetails(v []*ErrorDetail) *GetDeploymentStatusOutput {
	s.ErrorDetails = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetDeploymentStatusOutput) SetErrorMessage(v string) *GetDeploymentStatusOutput {
	s.ErrorMessage = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDeploymentStatusOutput) SetUpdatedAt(v string) *GetDeploymentStatusOutput {
	s.UpdatedAt = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionRequest
type GetDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceDefinitionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *GetDeviceDefinitionInput) SetDeviceDefinitionId(v string) *GetDeviceDefinitionInput {
	s.DeviceDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionResponse
type GetDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s GetDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDeviceDefinitionOutput) SetArn(v string) *GetDeviceDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetDeviceDefinitionOutput) SetCreationTimestamp(v string) *GetDeviceDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeviceDefinitionOutput) SetId(v string) *GetDeviceDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetDeviceDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetDeviceDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetDeviceDefinitionOutput) SetLatestVersion(v string) *GetDeviceDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetDeviceDefinitionOutput) SetLatestVersionArn(v string) *GetDeviceDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDeviceDefinitionOutput) SetName(v string) *GetDeviceDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersionRequest
type GetDeviceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	// DeviceDefinitionVersionId is a required field
	DeviceDefinitionVersionId *string `location:"uri" locationName:"DeviceDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceDefinitionVersionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}
	if s.DeviceDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *GetDeviceDefinitionVersionInput) SetDeviceDefinitionId(v string) *GetDeviceDefinitionVersionInput {
	s.DeviceDefinitionId = &v
	return s
}

// SetDeviceDefinitionVersionId sets the DeviceDefinitionVersionId field's value.
func (s *GetDeviceDefinitionVersionInput) SetDeviceDefinitionVersionId(v string) *GetDeviceDefinitionVersionInput {
	s.DeviceDefinitionVersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersionResponse
type GetDeviceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the device definition version.
	Arn *string `type:"string"`

	// Timestamp of when the device definition version was created.
	CreationTimestamp *string `type:"string"`

	// Device definition version
	Definition *DeviceDefinitionVersion `type:"structure"`

	// Id of the device definition the version belongs to.
	Id *string `type:"string"`

	// Version of the device definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetDeviceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDeviceDefinitionVersionOutput) SetArn(v string) *GetDeviceDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetDeviceDefinitionVersionOutput) SetCreationTimestamp(v string) *GetDeviceDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetDeviceDefinitionVersionOutput) SetDefinition(v *DeviceDefinitionVersion) *GetDeviceDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeviceDefinitionVersionOutput) SetId(v string) *GetDeviceDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetDeviceDefinitionVersionOutput) SetVersion(v string) *GetDeviceDefinitionVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionRequest
type GetFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionDefinitionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *GetFunctionDefinitionInput) SetFunctionDefinitionId(v string) *GetFunctionDefinitionInput {
	s.FunctionDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionResponse
type GetFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s GetFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetFunctionDefinitionOutput) SetArn(v string) *GetFunctionDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetFunctionDefinitionOutput) SetCreationTimestamp(v string) *GetFunctionDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetFunctionDefinitionOutput) SetId(v string) *GetFunctionDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetFunctionDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetFunctionDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetFunctionDefinitionOutput) SetLatestVersion(v string) *GetFunctionDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetFunctionDefinitionOutput) SetLatestVersionArn(v string) *GetFunctionDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetFunctionDefinitionOutput) SetName(v string) *GetFunctionDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersionRequest
type GetFunctionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	// FunctionDefinitionVersionId is a required field
	FunctionDefinitionVersionId *string `location:"uri" locationName:"FunctionDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFunctionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionDefinitionVersionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}
	if s.FunctionDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *GetFunctionDefinitionVersionInput) SetFunctionDefinitionId(v string) *GetFunctionDefinitionVersionInput {
	s.FunctionDefinitionId = &v
	return s
}

// SetFunctionDefinitionVersionId sets the FunctionDefinitionVersionId field's value.
func (s *GetFunctionDefinitionVersionInput) SetFunctionDefinitionVersionId(v string) *GetFunctionDefinitionVersionInput {
	s.FunctionDefinitionVersionId = &v
	return s
}

// Function definition version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersionResponse
type GetFunctionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the function definition version.
	Arn *string `type:"string"`

	// Timestamp when the funtion definition version was created.
	CreationTimestamp *string `type:"string"`

	// Information on the definition.
	Definition *FunctionDefinitionVersion `type:"structure"`

	// Id of the function definition the version belongs to.
	Id *string `type:"string"`

	// Version of the function definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetFunctionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetFunctionDefinitionVersionOutput) SetArn(v string) *GetFunctionDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetFunctionDefinitionVersionOutput) SetCreationTimestamp(v string) *GetFunctionDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetFunctionDefinitionVersionOutput) SetDefinition(v *FunctionDefinitionVersion) *GetFunctionDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetFunctionDefinitionVersionOutput) SetId(v string) *GetFunctionDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetFunctionDefinitionVersionOutput) SetVersion(v string) *GetFunctionDefinitionVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthorityRequest
type GetGroupCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// CertificateAuthorityId is a required field
	CertificateAuthorityId *string `location:"uri" locationName:"CertificateAuthorityId" type:"string" required:"true"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupCertificateAuthorityInput"}
	if s.CertificateAuthorityId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityId"))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityId sets the CertificateAuthorityId field's value.
func (s *GetGroupCertificateAuthorityInput) SetCertificateAuthorityId(v string) *GetGroupCertificateAuthorityInput {
	s.CertificateAuthorityId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupCertificateAuthorityInput) SetGroupId(v string) *GetGroupCertificateAuthorityInput {
	s.GroupId = &v
	return s
}

// Certificate authority for the group.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthorityResponse
type GetGroupCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the certificate authority for the group.
	GroupCertificateAuthorityArn *string `type:"string"`

	// Id of the certificate authority for the group.
	GroupCertificateAuthorityId *string `type:"string"`

	// PEM encoded certificate for the group.
	PemEncodedCertificate *string `type:"string"`
}

// String returns the string representation
func (s GetGroupCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetGroupCertificateAuthorityArn sets the GroupCertificateAuthorityArn field's value.
func (s *GetGroupCertificateAuthorityOutput) SetGroupCertificateAuthorityArn(v string) *GetGroupCertificateAuthorityOutput {
	s.GroupCertificateAuthorityArn = &v
	return s
}

// SetGroupCertificateAuthorityId sets the GroupCertificateAuthorityId field's value.
func (s *GetGroupCertificateAuthorityOutput) SetGroupCertificateAuthorityId(v string) *GetGroupCertificateAuthorityOutput {
	s.GroupCertificateAuthorityId = &v
	return s
}

// SetPemEncodedCertificate sets the PemEncodedCertificate field's value.
func (s *GetGroupCertificateAuthorityOutput) SetPemEncodedCertificate(v string) *GetGroupCertificateAuthorityOutput {
	s.PemEncodedCertificate = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfigurationRequest
type GetGroupCertificateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupCertificateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupCertificateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupCertificateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupCertificateConfigurationInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupCertificateConfigurationInput) SetGroupId(v string) *GetGroupCertificateConfigurationInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfigurationResponse
type GetGroupCertificateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	CertificateAuthorityExpiryInMilliseconds *string `type:"string"`

	CertificateExpiryInMilliseconds *string `type:"string"`

	GroupId *string `type:"string"`
}

// String returns the string representation
func (s GetGroupCertificateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupCertificateConfigurationOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthorityExpiryInMilliseconds sets the CertificateAuthorityExpiryInMilliseconds field's value.
func (s *GetGroupCertificateConfigurationOutput) SetCertificateAuthorityExpiryInMilliseconds(v string) *GetGroupCertificateConfigurationOutput {
	s.CertificateAuthorityExpiryInMilliseconds = &v
	return s
}

// SetCertificateExpiryInMilliseconds sets the CertificateExpiryInMilliseconds field's value.
func (s *GetGroupCertificateConfigurationOutput) SetCertificateExpiryInMilliseconds(v string) *GetGroupCertificateConfigurationOutput {
	s.CertificateExpiryInMilliseconds = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupCertificateConfigurationOutput) SetGroupId(v string) *GetGroupCertificateConfigurationOutput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupRequest
type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupInput) SetGroupId(v string) *GetGroupInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupResponse
type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetGroupOutput) SetArn(v string) *GetGroupOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetGroupOutput) SetCreationTimestamp(v string) *GetGroupOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetGroupOutput) SetId(v string) *GetGroupOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetGroupOutput) SetLastUpdatedTimestamp(v string) *GetGroupOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetGroupOutput) SetLatestVersion(v string) *GetGroupOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetGroupOutput) SetLatestVersionArn(v string) *GetGroupOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetGroupOutput) SetName(v string) *GetGroupOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersionRequest
type GetGroupVersionInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	// GroupVersionId is a required field
	GroupVersionId *string `location:"uri" locationName:"GroupVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupVersionInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *GetGroupVersionInput) SetGroupId(v string) *GetGroupVersionInput {
	s.GroupId = &v
	return s
}

// SetGroupVersionId sets the GroupVersionId field's value.
func (s *GetGroupVersionInput) SetGroupVersionId(v string) *GetGroupVersionInput {
	s.GroupVersionId = &v
	return s
}

// Information on the group version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersionResponse
type GetGroupVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the group version.
	Arn *string `type:"string"`

	// Timestamp when the group version was created.
	CreationTimestamp *string `type:"string"`

	// Information on the definition
	Definition *GroupVersion `type:"structure"`

	// Id of the group version.
	Id *string `type:"string"`

	// Unique Id for a version of the Group.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetGroupVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetGroupVersionOutput) SetArn(v string) *GetGroupVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetGroupVersionOutput) SetCreationTimestamp(v string) *GetGroupVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetGroupVersionOutput) SetDefinition(v *GroupVersion) *GetGroupVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetGroupVersionOutput) SetId(v string) *GetGroupVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetGroupVersionOutput) SetVersion(v string) *GetGroupVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionRequest
type GetLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoggerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoggerDefinitionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *GetLoggerDefinitionInput) SetLoggerDefinitionId(v string) *GetLoggerDefinitionInput {
	s.LoggerDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionResponse
type GetLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s GetLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggerDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetLoggerDefinitionOutput) SetArn(v string) *GetLoggerDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetLoggerDefinitionOutput) SetCreationTimestamp(v string) *GetLoggerDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetLoggerDefinitionOutput) SetId(v string) *GetLoggerDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetLoggerDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetLoggerDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetLoggerDefinitionOutput) SetLatestVersion(v string) *GetLoggerDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetLoggerDefinitionOutput) SetLatestVersionArn(v string) *GetLoggerDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetLoggerDefinitionOutput) SetName(v string) *GetLoggerDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersionRequest
type GetLoggerDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	// LoggerDefinitionVersionId is a required field
	LoggerDefinitionVersionId *string `location:"uri" locationName:"LoggerDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoggerDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggerDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoggerDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoggerDefinitionVersionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}
	if s.LoggerDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *GetLoggerDefinitionVersionInput) SetLoggerDefinitionId(v string) *GetLoggerDefinitionVersionInput {
	s.LoggerDefinitionId = &v
	return s
}

// SetLoggerDefinitionVersionId sets the LoggerDefinitionVersionId field's value.
func (s *GetLoggerDefinitionVersionInput) SetLoggerDefinitionVersionId(v string) *GetLoggerDefinitionVersionInput {
	s.LoggerDefinitionVersionId = &v
	return s
}

// Information on logger definition version response
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersionResponse
type GetLoggerDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the logger definition version.
	Arn *string `type:"string"`

	// Timestamp of when the logger definition version was created.
	CreationTimestamp *string `type:"string"`

	// Information on definition
	Definition *LoggerDefinitionVersion `type:"structure"`

	// Id of the logger definition the version belongs to.
	Id *string `type:"string"`

	// Version of the logger definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetLoggerDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggerDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetLoggerDefinitionVersionOutput) SetArn(v string) *GetLoggerDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetLoggerDefinitionVersionOutput) SetCreationTimestamp(v string) *GetLoggerDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetLoggerDefinitionVersionOutput) SetDefinition(v *LoggerDefinitionVersion) *GetLoggerDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetLoggerDefinitionVersionOutput) SetId(v string) *GetLoggerDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetLoggerDefinitionVersionOutput) SetVersion(v string) *GetLoggerDefinitionVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionRequest
type GetResourceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceDefinitionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *GetResourceDefinitionInput) SetResourceDefinitionId(v string) *GetResourceDefinitionInput {
	s.ResourceDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionResponse
type GetResourceDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s GetResourceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetResourceDefinitionOutput) SetArn(v string) *GetResourceDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetResourceDefinitionOutput) SetCreationTimestamp(v string) *GetResourceDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetResourceDefinitionOutput) SetId(v string) *GetResourceDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetResourceDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetResourceDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetResourceDefinitionOutput) SetLatestVersion(v string) *GetResourceDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetResourceDefinitionOutput) SetLatestVersionArn(v string) *GetResourceDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetResourceDefinitionOutput) SetName(v string) *GetResourceDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersionRequest
type GetResourceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`

	// ResourceDefinitionVersionId is a required field
	ResourceDefinitionVersionId *string `location:"uri" locationName:"ResourceDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceDefinitionVersionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}
	if s.ResourceDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *GetResourceDefinitionVersionInput) SetResourceDefinitionId(v string) *GetResourceDefinitionVersionInput {
	s.ResourceDefinitionId = &v
	return s
}

// SetResourceDefinitionVersionId sets the ResourceDefinitionVersionId field's value.
func (s *GetResourceDefinitionVersionInput) SetResourceDefinitionVersionId(v string) *GetResourceDefinitionVersionInput {
	s.ResourceDefinitionVersionId = &v
	return s
}

// Information on resource definition version response
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersionResponse
type GetResourceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the resource definition version.
	Arn *string `type:"string"`

	// Timestamp of when the resource definition version was created.
	CreationTimestamp *string `type:"string"`

	// Information on definition.
	Definition *ResourceDefinitionVersion `type:"structure"`

	// Id of the resource definition the version belongs to.
	Id *string `type:"string"`

	// Version of the resource definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetResourceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetResourceDefinitionVersionOutput) SetArn(v string) *GetResourceDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetResourceDefinitionVersionOutput) SetCreationTimestamp(v string) *GetResourceDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetResourceDefinitionVersionOutput) SetDefinition(v *ResourceDefinitionVersion) *GetResourceDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetResourceDefinitionVersionOutput) SetId(v string) *GetResourceDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetResourceDefinitionVersionOutput) SetVersion(v string) *GetResourceDefinitionVersionOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccountRequest
type GetServiceRoleForAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetServiceRoleForAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceRoleForAccountInput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccountResponse
type GetServiceRoleForAccountOutput struct {
	_ struct{} `type:"structure"`

	// Time when the service role was associated to the account.
	AssociatedAt *string `type:"string"`

	// Role arn which is associated to the account.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s GetServiceRoleForAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceRoleForAccountOutput) GoString() string {
	return s.String()
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *GetServiceRoleForAccountOutput) SetAssociatedAt(v string) *GetServiceRoleForAccountOutput {
	s.AssociatedAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetServiceRoleForAccountOutput) SetRoleArn(v string) *GetServiceRoleForAccountOutput {
	s.RoleArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionRequest
type GetSubscriptionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSubscriptionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSubscriptionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSubscriptionDefinitionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *GetSubscriptionDefinitionInput) SetSubscriptionDefinitionId(v string) *GetSubscriptionDefinitionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionResponse
type GetSubscriptionDefinitionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	LastUpdatedTimestamp *string `type:"string"`

	LatestVersion *string `type:"string"`

	LatestVersionArn *string `type:"string"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s GetSubscriptionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionDefinitionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSubscriptionDefinitionOutput) SetArn(v string) *GetSubscriptionDefinitionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetSubscriptionDefinitionOutput) SetCreationTimestamp(v string) *GetSubscriptionDefinitionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSubscriptionDefinitionOutput) SetId(v string) *GetSubscriptionDefinitionOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GetSubscriptionDefinitionOutput) SetLastUpdatedTimestamp(v string) *GetSubscriptionDefinitionOutput {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetSubscriptionDefinitionOutput) SetLatestVersion(v string) *GetSubscriptionDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GetSubscriptionDefinitionOutput) SetLatestVersionArn(v string) *GetSubscriptionDefinitionOutput {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSubscriptionDefinitionOutput) SetName(v string) *GetSubscriptionDefinitionOutput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersionRequest
type GetSubscriptionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`

	// SubscriptionDefinitionVersionId is a required field
	SubscriptionDefinitionVersionId *string `location:"uri" locationName:"SubscriptionDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSubscriptionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionDefinitionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSubscriptionDefinitionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSubscriptionDefinitionVersionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}
	if s.SubscriptionDefinitionVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *GetSubscriptionDefinitionVersionInput) SetSubscriptionDefinitionId(v string) *GetSubscriptionDefinitionVersionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

// SetSubscriptionDefinitionVersionId sets the SubscriptionDefinitionVersionId field's value.
func (s *GetSubscriptionDefinitionVersionInput) SetSubscriptionDefinitionVersionId(v string) *GetSubscriptionDefinitionVersionInput {
	s.SubscriptionDefinitionVersionId = &v
	return s
}

// Information on the Subscription Definition Version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersionResponse
type GetSubscriptionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the subscription definition version.
	Arn *string `type:"string"`

	// Timestamp of when the subscription definition version was created.
	CreationTimestamp *string `type:"string"`

	// Information on the definition
	Definition *SubscriptionDefinitionVersion `type:"structure"`

	// Id of the subscription definition the version belongs to.
	Id *string `type:"string"`

	// Version of the subscription definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetSubscriptionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionDefinitionVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetArn(v string) *GetSubscriptionDefinitionVersionOutput {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetCreationTimestamp(v string) *GetSubscriptionDefinitionVersionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetDefinition(v *SubscriptionDefinitionVersion) *GetSubscriptionDefinitionVersionOutput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetId(v string) *GetSubscriptionDefinitionVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSubscriptionDefinitionVersionOutput) SetVersion(v string) *GetSubscriptionDefinitionVersionOutput {
	s.Version = &v
	return s
}

// Information on group certificate authority properties
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GroupCertificateAuthorityProperties
type GroupCertificateAuthorityProperties struct {
	_ struct{} `type:"structure"`

	// Arn of the certificate authority for the group.
	GroupCertificateAuthorityArn *string `type:"string"`

	// Id of the certificate authority for the group.
	GroupCertificateAuthorityId *string `type:"string"`
}

// String returns the string representation
func (s GroupCertificateAuthorityProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupCertificateAuthorityProperties) GoString() string {
	return s.String()
}

// SetGroupCertificateAuthorityArn sets the GroupCertificateAuthorityArn field's value.
func (s *GroupCertificateAuthorityProperties) SetGroupCertificateAuthorityArn(v string) *GroupCertificateAuthorityProperties {
	s.GroupCertificateAuthorityArn = &v
	return s
}

// SetGroupCertificateAuthorityId sets the GroupCertificateAuthorityId field's value.
func (s *GroupCertificateAuthorityProperties) SetGroupCertificateAuthorityId(v string) *GroupCertificateAuthorityProperties {
	s.GroupCertificateAuthorityId = &v
	return s
}

// Information on the group
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GroupInformation
type GroupInformation struct {
	_ struct{} `type:"structure"`

	// Arn of a group.
	Arn *string `type:"string"`

	// Timestamp of when the group was created.
	CreationTimestamp *string `type:"string"`

	// Id of a group.
	Id *string `type:"string"`

	// Last updated timestamp of the group.
	LastUpdatedTimestamp *string `type:"string"`

	// Last version of the group.
	LatestVersion *string `type:"string"`

	// Latest version arn of the group.
	LatestVersionArn *string `type:"string"`

	// Name of a group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GroupInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupInformation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GroupInformation) SetArn(v string) *GroupInformation {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GroupInformation) SetCreationTimestamp(v string) *GroupInformation {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *GroupInformation) SetId(v string) *GroupInformation {
	s.Id = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *GroupInformation) SetLastUpdatedTimestamp(v string) *GroupInformation {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GroupInformation) SetLatestVersion(v string) *GroupInformation {
	s.LatestVersion = &v
	return s
}

// SetLatestVersionArn sets the LatestVersionArn field's value.
func (s *GroupInformation) SetLatestVersionArn(v string) *GroupInformation {
	s.LatestVersionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GroupInformation) SetName(v string) *GroupInformation {
	s.Name = &v
	return s
}

// Group owner related settings for local resources.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GroupOwnerSetting
type GroupOwnerSetting struct {
	_ struct{} `type:"structure"`

	// Eanble the auto added group owner.
	AutoAddGroupOwner *bool `type:"boolean"`

	// Name of the group owner.
	GroupOwner *string `type:"string"`
}

// String returns the string representation
func (s GroupOwnerSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupOwnerSetting) GoString() string {
	return s.String()
}

// SetAutoAddGroupOwner sets the AutoAddGroupOwner field's value.
func (s *GroupOwnerSetting) SetAutoAddGroupOwner(v bool) *GroupOwnerSetting {
	s.AutoAddGroupOwner = &v
	return s
}

// SetGroupOwner sets the GroupOwner field's value.
func (s *GroupOwnerSetting) SetGroupOwner(v string) *GroupOwnerSetting {
	s.GroupOwner = &v
	return s
}

// Information on group version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GroupVersion
type GroupVersion struct {
	_ struct{} `type:"structure"`

	// Core definition version arn for this group.
	CoreDefinitionVersionArn *string `type:"string"`

	// Device definition version arn for this group.
	DeviceDefinitionVersionArn *string `type:"string"`

	// Function definition version arn for this group.
	FunctionDefinitionVersionArn *string `type:"string"`

	// Logger definition version arn for this group.
	LoggerDefinitionVersionArn *string `type:"string"`

	// Resource definition version arn for this group.
	ResourceDefinitionVersionArn *string `type:"string"`

	// Subscription definition version arn for this group.
	SubscriptionDefinitionVersionArn *string `type:"string"`
}

// String returns the string representation
func (s GroupVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupVersion) GoString() string {
	return s.String()
}

// SetCoreDefinitionVersionArn sets the CoreDefinitionVersionArn field's value.
func (s *GroupVersion) SetCoreDefinitionVersionArn(v string) *GroupVersion {
	s.CoreDefinitionVersionArn = &v
	return s
}

// SetDeviceDefinitionVersionArn sets the DeviceDefinitionVersionArn field's value.
func (s *GroupVersion) SetDeviceDefinitionVersionArn(v string) *GroupVersion {
	s.DeviceDefinitionVersionArn = &v
	return s
}

// SetFunctionDefinitionVersionArn sets the FunctionDefinitionVersionArn field's value.
func (s *GroupVersion) SetFunctionDefinitionVersionArn(v string) *GroupVersion {
	s.FunctionDefinitionVersionArn = &v
	return s
}

// SetLoggerDefinitionVersionArn sets the LoggerDefinitionVersionArn field's value.
func (s *GroupVersion) SetLoggerDefinitionVersionArn(v string) *GroupVersion {
	s.LoggerDefinitionVersionArn = &v
	return s
}

// SetResourceDefinitionVersionArn sets the ResourceDefinitionVersionArn field's value.
func (s *GroupVersion) SetResourceDefinitionVersionArn(v string) *GroupVersion {
	s.ResourceDefinitionVersionArn = &v
	return s
}

// SetSubscriptionDefinitionVersionArn sets the SubscriptionDefinitionVersionArn field's value.
func (s *GroupVersion) SetSubscriptionDefinitionVersionArn(v string) *GroupVersion {
	s.SubscriptionDefinitionVersionArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersionsRequest
type ListCoreDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListCoreDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCoreDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCoreDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCoreDefinitionVersionsInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *ListCoreDefinitionVersionsInput) SetCoreDefinitionId(v string) *ListCoreDefinitionVersionsInput {
	s.CoreDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCoreDefinitionVersionsInput) SetMaxResults(v string) *ListCoreDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDefinitionVersionsInput) SetNextToken(v string) *ListCoreDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersionsResponse
type ListCoreDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListCoreDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCoreDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDefinitionVersionsOutput) SetNextToken(v string) *ListCoreDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListCoreDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListCoreDefinitionVersionsOutput {
	s.Versions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionsRequest
type ListCoreDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListCoreDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCoreDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCoreDefinitionsInput) SetMaxResults(v string) *ListCoreDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDefinitionsInput) SetNextToken(v string) *ListCoreDefinitionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionsResponse
type ListCoreDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCoreDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCoreDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListCoreDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListCoreDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCoreDefinitionsOutput) SetNextToken(v string) *ListCoreDefinitionsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeploymentsRequest
type ListDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListDeploymentsInput) SetGroupId(v string) *ListDeploymentsInput {
	s.GroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentsInput) SetMaxResults(v string) *ListDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsInput) SetNextToken(v string) *ListDeploymentsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeploymentsResponse
type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// List of deployments for the requested groups
	Deployments []*Deployment `type:"list"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *ListDeploymentsOutput) SetDeployments(v []*Deployment) *ListDeploymentsOutput {
	s.Deployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsOutput) SetNextToken(v string) *ListDeploymentsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersionsRequest
type ListDeviceDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListDeviceDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeviceDefinitionVersionsInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *ListDeviceDefinitionVersionsInput) SetDeviceDefinitionId(v string) *ListDeviceDefinitionVersionsInput {
	s.DeviceDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceDefinitionVersionsInput) SetMaxResults(v string) *ListDeviceDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceDefinitionVersionsInput) SetNextToken(v string) *ListDeviceDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersionsResponse
type ListDeviceDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListDeviceDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceDefinitionVersionsOutput) SetNextToken(v string) *ListDeviceDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListDeviceDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListDeviceDefinitionVersionsOutput {
	s.Versions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionsRequest
type ListDeviceDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListDeviceDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeviceDefinitionsInput) SetMaxResults(v string) *ListDeviceDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceDefinitionsInput) SetNextToken(v string) *ListDeviceDefinitionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionsResponse
type ListDeviceDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDeviceDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeviceDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListDeviceDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListDeviceDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeviceDefinitionsOutput) SetNextToken(v string) *ListDeviceDefinitionsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersionsRequest
type ListFunctionDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListFunctionDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFunctionDefinitionVersionsInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *ListFunctionDefinitionVersionsInput) SetFunctionDefinitionId(v string) *ListFunctionDefinitionVersionsInput {
	s.FunctionDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFunctionDefinitionVersionsInput) SetMaxResults(v string) *ListFunctionDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionDefinitionVersionsInput) SetNextToken(v string) *ListFunctionDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersionsResponse
type ListFunctionDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListFunctionDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionDefinitionVersionsOutput) SetNextToken(v string) *ListFunctionDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListFunctionDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListFunctionDefinitionVersionsOutput {
	s.Versions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionsRequest
type ListFunctionDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListFunctionDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFunctionDefinitionsInput) SetMaxResults(v string) *ListFunctionDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionDefinitionsInput) SetNextToken(v string) *ListFunctionDefinitionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionsResponse
type ListFunctionDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListFunctionDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListFunctionDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFunctionDefinitionsOutput) SetNextToken(v string) *ListFunctionDefinitionsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthoritiesRequest
type ListGroupCertificateAuthoritiesInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupCertificateAuthoritiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupCertificateAuthoritiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupCertificateAuthoritiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupCertificateAuthoritiesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListGroupCertificateAuthoritiesInput) SetGroupId(v string) *ListGroupCertificateAuthoritiesInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthoritiesResponse
type ListGroupCertificateAuthoritiesOutput struct {
	_ struct{} `type:"structure"`

	// List of certificate authorities associated with the group.
	GroupCertificateAuthorities []*GroupCertificateAuthorityProperties `type:"list"`
}

// String returns the string representation
func (s ListGroupCertificateAuthoritiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupCertificateAuthoritiesOutput) GoString() string {
	return s.String()
}

// SetGroupCertificateAuthorities sets the GroupCertificateAuthorities field's value.
func (s *ListGroupCertificateAuthoritiesOutput) SetGroupCertificateAuthorities(v []*GroupCertificateAuthorityProperties) *ListGroupCertificateAuthoritiesOutput {
	s.GroupCertificateAuthorities = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersionsRequest
type ListGroupVersionsInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListGroupVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupVersionsInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListGroupVersionsInput) SetGroupId(v string) *ListGroupVersionsInput {
	s.GroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupVersionsInput) SetMaxResults(v string) *ListGroupVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupVersionsInput) SetNextToken(v string) *ListGroupVersionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersionsResponse
type ListGroupVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListGroupVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupVersionsOutput) SetNextToken(v string) *ListGroupVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListGroupVersionsOutput) SetVersions(v []*VersionInformation) *ListGroupVersionsOutput {
	s.Versions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupsRequest
type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v string) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupsResponse
type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Groups
	Groups []*GroupInformation `type:"list"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*GroupInformation) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersionsRequest
type ListLoggerDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListLoggerDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggerDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLoggerDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLoggerDefinitionVersionsInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *ListLoggerDefinitionVersionsInput) SetLoggerDefinitionId(v string) *ListLoggerDefinitionVersionsInput {
	s.LoggerDefinitionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLoggerDefinitionVersionsInput) SetMaxResults(v string) *ListLoggerDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggerDefinitionVersionsInput) SetNextToken(v string) *ListLoggerDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersionsResponse
type ListLoggerDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListLoggerDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggerDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggerDefinitionVersionsOutput) SetNextToken(v string) *ListLoggerDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListLoggerDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListLoggerDefinitionVersionsOutput {
	s.Versions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionsRequest
type ListLoggerDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListLoggerDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggerDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLoggerDefinitionsInput) SetMaxResults(v string) *ListLoggerDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggerDefinitionsInput) SetNextToken(v string) *ListLoggerDefinitionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionsResponse
type ListLoggerDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLoggerDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggerDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListLoggerDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListLoggerDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLoggerDefinitionsOutput) SetNextToken(v string) *ListLoggerDefinitionsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersionsRequest
type ListResourceDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourceDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceDefinitionVersionsInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceDefinitionVersionsInput) SetMaxResults(v string) *ListResourceDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDefinitionVersionsInput) SetNextToken(v string) *ListResourceDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *ListResourceDefinitionVersionsInput) SetResourceDefinitionId(v string) *ListResourceDefinitionVersionsInput {
	s.ResourceDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersionsResponse
type ListResourceDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListResourceDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDefinitionVersionsOutput) SetNextToken(v string) *ListResourceDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListResourceDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListResourceDefinitionVersionsOutput {
	s.Versions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionsRequest
type ListResourceDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListResourceDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceDefinitionsInput) SetMaxResults(v string) *ListResourceDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDefinitionsInput) SetNextToken(v string) *ListResourceDefinitionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionsResponse
type ListResourceDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourceDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListResourceDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListResourceDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDefinitionsOutput) SetNextToken(v string) *ListResourceDefinitionsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersionsRequest
type ListSubscriptionDefinitionVersionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListSubscriptionDefinitionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionDefinitionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSubscriptionDefinitionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSubscriptionDefinitionVersionsInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSubscriptionDefinitionVersionsInput) SetMaxResults(v string) *ListSubscriptionDefinitionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionDefinitionVersionsInput) SetNextToken(v string) *ListSubscriptionDefinitionVersionsInput {
	s.NextToken = &v
	return s
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *ListSubscriptionDefinitionVersionsInput) SetSubscriptionDefinitionId(v string) *ListSubscriptionDefinitionVersionsInput {
	s.SubscriptionDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersionsResponse
type ListSubscriptionDefinitionVersionsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Versions []*VersionInformation `type:"list"`
}

// String returns the string representation
func (s ListSubscriptionDefinitionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionDefinitionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionDefinitionVersionsOutput) SetNextToken(v string) *ListSubscriptionDefinitionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListSubscriptionDefinitionVersionsOutput) SetVersions(v []*VersionInformation) *ListSubscriptionDefinitionVersionsOutput {
	s.Versions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionsRequest
type ListSubscriptionDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListSubscriptionDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionDefinitionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSubscriptionDefinitionsInput) SetMaxResults(v string) *ListSubscriptionDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionDefinitionsInput) SetNextToken(v string) *ListSubscriptionDefinitionsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionsResponse
type ListSubscriptionDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []*DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListSubscriptionDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionDefinitionsOutput) GoString() string {
	return s.String()
}

// SetDefinitions sets the Definitions field's value.
func (s *ListSubscriptionDefinitionsOutput) SetDefinitions(v []*DefinitionInformation) *ListSubscriptionDefinitionsOutput {
	s.Definitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionDefinitionsOutput) SetNextToken(v string) *ListSubscriptionDefinitionsOutput {
	s.NextToken = &v
	return s
}

// Attributes that define the Local Device Resource.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/LocalDeviceResourceData
type LocalDeviceResourceData struct {
	_ struct{} `type:"structure"`

	// Group owner related settings for local resources.
	GroupOwnerSetting *GroupOwnerSetting `type:"structure"`

	// Local source path of the resource.
	SourcePath *string `type:"string"`
}

// String returns the string representation
func (s LocalDeviceResourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalDeviceResourceData) GoString() string {
	return s.String()
}

// SetGroupOwnerSetting sets the GroupOwnerSetting field's value.
func (s *LocalDeviceResourceData) SetGroupOwnerSetting(v *GroupOwnerSetting) *LocalDeviceResourceData {
	s.GroupOwnerSetting = v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *LocalDeviceResourceData) SetSourcePath(v string) *LocalDeviceResourceData {
	s.SourcePath = &v
	return s
}

// Attributes that define the Local Volume Resource.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/LocalVolumeResourceData
type LocalVolumeResourceData struct {
	_ struct{} `type:"structure"`

	// Local destination path of the resource.
	DestinationPath *string `type:"string"`

	// Group owner related settings for local resources.
	GroupOwnerSetting *GroupOwnerSetting `type:"structure"`

	// Local source path of the resource.
	SourcePath *string `type:"string"`
}

// String returns the string representation
func (s LocalVolumeResourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalVolumeResourceData) GoString() string {
	return s.String()
}

// SetDestinationPath sets the DestinationPath field's value.
func (s *LocalVolumeResourceData) SetDestinationPath(v string) *LocalVolumeResourceData {
	s.DestinationPath = &v
	return s
}

// SetGroupOwnerSetting sets the GroupOwnerSetting field's value.
func (s *LocalVolumeResourceData) SetGroupOwnerSetting(v *GroupOwnerSetting) *LocalVolumeResourceData {
	s.GroupOwnerSetting = v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *LocalVolumeResourceData) SetSourcePath(v string) *LocalVolumeResourceData {
	s.SourcePath = &v
	return s
}

// Information on the Logger
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Logger
type Logger struct {
	_ struct{} `type:"structure"`

	// The component that will be subject to logs
	Component *string `type:"string" enum:"LoggerComponent"`

	// Element Id for this entry in the list.
	Id *string `type:"string"`

	// The level of the logs
	Level *string `type:"string" enum:"LoggerLevel"`

	// Amount of hardware space, in KB, to use if file system is used for logging
	// purposes.
	Space *int64 `type:"integer"`

	// The type which will be use for log output
	Type *string `type:"string" enum:"LoggerType"`
}

// String returns the string representation
func (s Logger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Logger) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *Logger) SetComponent(v string) *Logger {
	s.Component = &v
	return s
}

// SetId sets the Id field's value.
func (s *Logger) SetId(v string) *Logger {
	s.Id = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *Logger) SetLevel(v string) *Logger {
	s.Level = &v
	return s
}

// SetSpace sets the Space field's value.
func (s *Logger) SetSpace(v int64) *Logger {
	s.Space = &v
	return s
}

// SetType sets the Type field's value.
func (s *Logger) SetType(v string) *Logger {
	s.Type = &v
	return s
}

// Information on logger definition version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/LoggerDefinitionVersion
type LoggerDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// List of loggers.
	Loggers []*Logger `type:"list"`
}

// String returns the string representation
func (s LoggerDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggerDefinitionVersion) GoString() string {
	return s.String()
}

// SetLoggers sets the Loggers field's value.
func (s *LoggerDefinitionVersion) SetLoggers(v []*Logger) *LoggerDefinitionVersion {
	s.Loggers = v
	return s
}

// Information needed to perform a reset of a group's deployments.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeploymentsRequest
type ResetDeploymentsInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// When set to true, perform a best-effort only core reset.
	Force *bool `type:"boolean"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetDeploymentsInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmznClientToken sets the AmznClientToken field's value.
func (s *ResetDeploymentsInput) SetAmznClientToken(v string) *ResetDeploymentsInput {
	s.AmznClientToken = &v
	return s
}

// SetForce sets the Force field's value.
func (s *ResetDeploymentsInput) SetForce(v bool) *ResetDeploymentsInput {
	s.Force = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *ResetDeploymentsInput) SetGroupId(v string) *ResetDeploymentsInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeploymentsResponse
type ResetDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// The arn of the reset deployment.
	DeploymentArn *string `type:"string"`

	// The id of the reset deployment.
	DeploymentId *string `type:"string"`
}

// String returns the string representation
func (s ResetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeploymentArn sets the DeploymentArn field's value.
func (s *ResetDeploymentsOutput) SetDeploymentArn(v string) *ResetDeploymentsOutput {
	s.DeploymentArn = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ResetDeploymentsOutput) SetDeploymentId(v string) *ResetDeploymentsOutput {
	s.DeploymentId = &v
	return s
}

// Information on the resource.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Resource
type Resource struct {
	_ struct{} `type:"structure"`

	// Resource Id.
	Id *string `type:"string"`

	// A descriptive resource name.
	Name *string `type:"string"`

	// A container of data for all resource types.
	ResourceDataContainer *ResourceDataContainer `type:"structure"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Resource) SetName(v string) *Resource {
	s.Name = &v
	return s
}

// SetResourceDataContainer sets the ResourceDataContainer field's value.
func (s *Resource) SetResourceDataContainer(v *ResourceDataContainer) *Resource {
	s.ResourceDataContainer = v
	return s
}

// Policy for the function to access a resource.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResourceAccessPolicy
type ResourceAccessPolicy struct {
	_ struct{} `type:"structure"`

	// The function's access permission to the resource.
	Permission *string `type:"string" enum:"Permission"`

	// Id of the resource. A reference to the resource definiton.
	ResourceId *string `type:"string"`
}

// String returns the string representation
func (s ResourceAccessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAccessPolicy) GoString() string {
	return s.String()
}

// SetPermission sets the Permission field's value.
func (s *ResourceAccessPolicy) SetPermission(v string) *ResourceAccessPolicy {
	s.Permission = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceAccessPolicy) SetResourceId(v string) *ResourceAccessPolicy {
	s.ResourceId = &v
	return s
}

// A container of data for all resource types.
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResourceDataContainer
type ResourceDataContainer struct {
	_ struct{} `type:"structure"`

	// Attributes that define the Local Device Resource.
	LocalDeviceResourceData *LocalDeviceResourceData `type:"structure"`

	// Attributes that define the Local Volume Resource.
	LocalVolumeResourceData *LocalVolumeResourceData `type:"structure"`
}

// String returns the string representation
func (s ResourceDataContainer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDataContainer) GoString() string {
	return s.String()
}

// SetLocalDeviceResourceData sets the LocalDeviceResourceData field's value.
func (s *ResourceDataContainer) SetLocalDeviceResourceData(v *LocalDeviceResourceData) *ResourceDataContainer {
	s.LocalDeviceResourceData = v
	return s
}

// SetLocalVolumeResourceData sets the LocalVolumeResourceData field's value.
func (s *ResourceDataContainer) SetLocalVolumeResourceData(v *LocalVolumeResourceData) *ResourceDataContainer {
	s.LocalVolumeResourceData = v
	return s
}

// Information on resource definition version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResourceDefinitionVersion
type ResourceDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// List of resources.
	Resources []*Resource `type:"list"`
}

// String returns the string representation
func (s ResourceDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDefinitionVersion) GoString() string {
	return s.String()
}

// SetResources sets the Resources field's value.
func (s *ResourceDefinitionVersion) SetResources(v []*Resource) *ResourceDefinitionVersion {
	s.Resources = v
	return s
}

// Information on subscription
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Subscription
type Subscription struct {
	_ struct{} `type:"structure"`

	// Element Id for this entry in the list.
	Id *string `type:"string"`

	// Source of the subscription. Can be a thing arn, lambda arn or word 'cloud'
	Source *string `type:"string"`

	// Subject of the message.
	Subject *string `type:"string"`

	// Where the message is sent to. Can be a thing arn, lambda arn or word 'cloud'.
	Target *string `type:"string"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscription) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Subscription) SetId(v string) *Subscription {
	s.Id = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Subscription) SetSource(v string) *Subscription {
	s.Source = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *Subscription) SetSubject(v string) *Subscription {
	s.Subject = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *Subscription) SetTarget(v string) *Subscription {
	s.Target = &v
	return s
}

// Information on subscription definition version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/SubscriptionDefinitionVersion
type SubscriptionDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// Subscriptions in the version.
	Subscriptions []*Subscription `type:"list"`
}

// String returns the string representation
func (s SubscriptionDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscriptionDefinitionVersion) GoString() string {
	return s.String()
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *SubscriptionDefinitionVersion) SetSubscriptions(v []*Subscription) *SubscriptionDefinitionVersion {
	s.Subscriptions = v
	return s
}

// Information on connectivity info
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfoRequest
type UpdateConnectivityInfoInput struct {
	_ struct{} `type:"structure"`

	// Connectivity info list
	ConnectivityInfo []*ConnectivityInfo `type:"list"`

	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"ThingName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConnectivityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectivityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectivityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectivityInfoInput"}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectivityInfo sets the ConnectivityInfo field's value.
func (s *UpdateConnectivityInfoInput) SetConnectivityInfo(v []*ConnectivityInfo) *UpdateConnectivityInfoInput {
	s.ConnectivityInfo = v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *UpdateConnectivityInfoInput) SetThingName(v string) *UpdateConnectivityInfoInput {
	s.ThingName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfoResponse
type UpdateConnectivityInfoOutput struct {
	_ struct{} `type:"structure"`

	// Response Text
	Message *string `locationName:"message" type:"string"`

	// New Version
	Version *string `type:"string"`
}

// String returns the string representation
func (s UpdateConnectivityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectivityInfoOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *UpdateConnectivityInfoOutput) SetMessage(v string) *UpdateConnectivityInfoOutput {
	s.Message = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateConnectivityInfoOutput) SetVersion(v string) *UpdateConnectivityInfoOutput {
	s.Version = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinitionRequest
type UpdateCoreDefinitionInput struct {
	_ struct{} `type:"structure"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateCoreDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCoreDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCoreDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCoreDefinitionInput"}
	if s.CoreDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CoreDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoreDefinitionId sets the CoreDefinitionId field's value.
func (s *UpdateCoreDefinitionInput) SetCoreDefinitionId(v string) *UpdateCoreDefinitionInput {
	s.CoreDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCoreDefinitionInput) SetName(v string) *UpdateCoreDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinitionResponse
type UpdateCoreDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCoreDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCoreDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinitionRequest
type UpdateDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceDefinitionInput"}
	if s.DeviceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceDefinitionId sets the DeviceDefinitionId field's value.
func (s *UpdateDeviceDefinitionInput) SetDeviceDefinitionId(v string) *UpdateDeviceDefinitionInput {
	s.DeviceDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDeviceDefinitionInput) SetName(v string) *UpdateDeviceDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinitionResponse
type UpdateDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinitionRequest
type UpdateFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionDefinitionInput"}
	if s.FunctionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionDefinitionId sets the FunctionDefinitionId field's value.
func (s *UpdateFunctionDefinitionInput) SetFunctionDefinitionId(v string) *UpdateFunctionDefinitionInput {
	s.FunctionDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFunctionDefinitionInput) SetName(v string) *UpdateFunctionDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinitionResponse
type UpdateFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfigurationRequest
type UpdateGroupCertificateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Amount of time when the certificate expires in milliseconds.
	CertificateExpiryInMilliseconds *string `type:"string"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGroupCertificateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupCertificateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupCertificateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupCertificateConfigurationInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateExpiryInMilliseconds sets the CertificateExpiryInMilliseconds field's value.
func (s *UpdateGroupCertificateConfigurationInput) SetCertificateExpiryInMilliseconds(v string) *UpdateGroupCertificateConfigurationInput {
	s.CertificateExpiryInMilliseconds = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateGroupCertificateConfigurationInput) SetGroupId(v string) *UpdateGroupCertificateConfigurationInput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfigurationResponse
type UpdateGroupCertificateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	CertificateAuthorityExpiryInMilliseconds *string `type:"string"`

	CertificateExpiryInMilliseconds *string `type:"string"`

	GroupId *string `type:"string"`
}

// String returns the string representation
func (s UpdateGroupCertificateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupCertificateConfigurationOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthorityExpiryInMilliseconds sets the CertificateAuthorityExpiryInMilliseconds field's value.
func (s *UpdateGroupCertificateConfigurationOutput) SetCertificateAuthorityExpiryInMilliseconds(v string) *UpdateGroupCertificateConfigurationOutput {
	s.CertificateAuthorityExpiryInMilliseconds = &v
	return s
}

// SetCertificateExpiryInMilliseconds sets the CertificateExpiryInMilliseconds field's value.
func (s *UpdateGroupCertificateConfigurationOutput) SetCertificateExpiryInMilliseconds(v string) *UpdateGroupCertificateConfigurationOutput {
	s.CertificateExpiryInMilliseconds = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateGroupCertificateConfigurationOutput) SetGroupId(v string) *UpdateGroupCertificateConfigurationOutput {
	s.GroupId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupRequest
type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateGroupInput) SetGroupId(v string) *UpdateGroupInput {
	s.GroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGroupInput) SetName(v string) *UpdateGroupInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupResponse
type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinitionRequest
type UpdateLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoggerDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLoggerDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLoggerDefinitionInput"}
	if s.LoggerDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggerDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggerDefinitionId sets the LoggerDefinitionId field's value.
func (s *UpdateLoggerDefinitionInput) SetLoggerDefinitionId(v string) *UpdateLoggerDefinitionInput {
	s.LoggerDefinitionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLoggerDefinitionInput) SetName(v string) *UpdateLoggerDefinitionInput {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinitionResponse
type UpdateLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoggerDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinitionRequest
type UpdateResourceDefinitionInput struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceDefinitionInput"}
	if s.ResourceDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateResourceDefinitionInput) SetName(v string) *UpdateResourceDefinitionInput {
	s.Name = &v
	return s
}

// SetResourceDefinitionId sets the ResourceDefinitionId field's value.
func (s *UpdateResourceDefinitionInput) SetResourceDefinitionId(v string) *UpdateResourceDefinitionInput {
	s.ResourceDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinitionResponse
type UpdateResourceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceDefinitionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinitionRequest
type UpdateSubscriptionDefinitionInput struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	// SubscriptionDefinitionId is a required field
	SubscriptionDefinitionId *string `location:"uri" locationName:"SubscriptionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSubscriptionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSubscriptionDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubscriptionDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubscriptionDefinitionInput"}
	if s.SubscriptionDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateSubscriptionDefinitionInput) SetName(v string) *UpdateSubscriptionDefinitionInput {
	s.Name = &v
	return s
}

// SetSubscriptionDefinitionId sets the SubscriptionDefinitionId field's value.
func (s *UpdateSubscriptionDefinitionInput) SetSubscriptionDefinitionId(v string) *UpdateSubscriptionDefinitionInput {
	s.SubscriptionDefinitionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinitionResponse
type UpdateSubscriptionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSubscriptionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSubscriptionDefinitionOutput) GoString() string {
	return s.String()
}

// Information on the version
// See also, https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/VersionInformation
type VersionInformation struct {
	_ struct{} `type:"structure"`

	// Arn of the version.
	Arn *string `type:"string"`

	// Timestamp of when the version was created.
	CreationTimestamp *string `type:"string"`

	// Id of the resource container.
	Id *string `type:"string"`

	// Unique Id of a version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s VersionInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersionInformation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VersionInformation) SetArn(v string) *VersionInformation {
	s.Arn = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *VersionInformation) SetCreationTimestamp(v string) *VersionInformation {
	s.CreationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *VersionInformation) SetId(v string) *VersionInformation {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *VersionInformation) SetVersion(v string) *VersionInformation {
	s.Version = &v
	return s
}

const (
	// DeploymentTypeNewDeployment is a DeploymentType enum value
	DeploymentTypeNewDeployment = "NewDeployment"

	// DeploymentTypeRedeployment is a DeploymentType enum value
	DeploymentTypeRedeployment = "Redeployment"

	// DeploymentTypeResetDeployment is a DeploymentType enum value
	DeploymentTypeResetDeployment = "ResetDeployment"

	// DeploymentTypeForceResetDeployment is a DeploymentType enum value
	DeploymentTypeForceResetDeployment = "ForceResetDeployment"
)

const (
	// LoggerComponentGreengrassSystem is a LoggerComponent enum value
	LoggerComponentGreengrassSystem = "GreengrassSystem"

	// LoggerComponentLambda is a LoggerComponent enum value
	LoggerComponentLambda = "Lambda"
)

const (
	// LoggerLevelDebug is a LoggerLevel enum value
	LoggerLevelDebug = "DEBUG"

	// LoggerLevelInfo is a LoggerLevel enum value
	LoggerLevelInfo = "INFO"

	// LoggerLevelWarn is a LoggerLevel enum value
	LoggerLevelWarn = "WARN"

	// LoggerLevelError is a LoggerLevel enum value
	LoggerLevelError = "ERROR"

	// LoggerLevelFatal is a LoggerLevel enum value
	LoggerLevelFatal = "FATAL"
)

const (
	// LoggerTypeFileSystem is a LoggerType enum value
	LoggerTypeFileSystem = "FileSystem"

	// LoggerTypeAwscloudWatch is a LoggerType enum value
	LoggerTypeAwscloudWatch = "AWSCloudWatch"
)

// Type of permissions a function could have to access a resource.
const (
	// PermissionRo is a Permission enum value
	PermissionRo = "ro"

	// PermissionRw is a Permission enum value
	PermissionRw = "rw"
)

// The piece of software on the Greengrass Core that will be updated.
const (
	// SoftwareToUpdateCore is a SoftwareToUpdate enum value
	SoftwareToUpdateCore = "core"

	// SoftwareToUpdateOtaAgent is a SoftwareToUpdate enum value
	SoftwareToUpdateOtaAgent = "ota_agent"
)

// The minimum level of log statements that should be logged by the OTA Agent
// during an update.
const (
	// UpdateAgentLogLevelNone is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelNone = "NONE"

	// UpdateAgentLogLevelTrace is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelTrace = "TRACE"

	// UpdateAgentLogLevelDebug is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelDebug = "DEBUG"

	// UpdateAgentLogLevelVerbose is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelVerbose = "VERBOSE"

	// UpdateAgentLogLevelInfo is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelInfo = "INFO"

	// UpdateAgentLogLevelWarn is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelWarn = "WARN"

	// UpdateAgentLogLevelError is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelError = "ERROR"

	// UpdateAgentLogLevelFatal is a UpdateAgentLogLevel enum value
	UpdateAgentLogLevelFatal = "FATAL"
)

// The architecture of the Cores in the targets of an update
const (
	// UpdateTargetsArchitectureArmv7l is a UpdateTargetsArchitecture enum value
	UpdateTargetsArchitectureArmv7l = "armv7l"

	// UpdateTargetsArchitectureX8664 is a UpdateTargetsArchitecture enum value
	UpdateTargetsArchitectureX8664 = "x86_64"

	// UpdateTargetsArchitectureAarch64 is a UpdateTargetsArchitecture enum value
	UpdateTargetsArchitectureAarch64 = "aarch64"
)

// The operating system of the Cores in the targets of an update
const (
	// UpdateTargetsOperatingSystemUbuntu is a UpdateTargetsOperatingSystem enum value
	UpdateTargetsOperatingSystemUbuntu = "ubuntu"

	// UpdateTargetsOperatingSystemRaspbian is a UpdateTargetsOperatingSystem enum value
	UpdateTargetsOperatingSystemRaspbian = "raspbian"

	// UpdateTargetsOperatingSystemAmazonLinux is a UpdateTargetsOperatingSystem enum value
	UpdateTargetsOperatingSystemAmazonLinux = "amazon_linux"
)
