// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTagsToCertificate = "AddTagsToCertificate"

// AddTagsToCertificateRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToCertificate for more information on using the AddTagsToCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToCertificateRequest method.
//    req, resp := client.AddTagsToCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/AddTagsToCertificate
func (c *ACM) AddTagsToCertificateRequest(input *AddTagsToCertificateInput) (req *request.Request, output *AddTagsToCertificateOutput) {
	op := &request.Operation{
		Name:       opAddTagsToCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToCertificateInput{}
	}

	output = &AddTagsToCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToCertificate API operation for AWS Certificate Manager.
//
// Adds one or more tags to an ACM Certificate. Tags are labels that you can
// use to identify and organize your AWS resources. Each tag consists of a key
// and an optional value. You specify the certificate on input by its Amazon
// Resource Name (ARN). You specify the tag by using a key-value pair.
//
// You can apply a tag to just one certificate if you want to identify a specific
// characteristic of that certificate, or you can apply the same tag to multiple
// certificates if you want to filter for a common relationship among those
// certificates. Similarly, you can apply the same tag to multiple resources
// if you want to specify a relationship among those resources. For example,
// you can add the same tag to an ACM Certificate and an Elastic Load Balancing
// load balancer to indicate that they are both used by the same website. For
// more information, see Tagging ACM Certificates (http://docs.aws.amazon.com/acm/latest/userguide/tags.html).
//
// To remove one or more tags, use the RemoveTagsFromCertificate action. To
// view all of the tags that have been applied to the certificate, use the ListTagsForCertificate
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation AddTagsToCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//   One or both of the values that make up the key-value pair is not valid. For
//   example, you cannot specify a tag value that begins with aws:.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   The request contains too many tags. Try the request again with fewer tags.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/AddTagsToCertificate
func (c *ACM) AddTagsToCertificate(input *AddTagsToCertificateInput) (*AddTagsToCertificateOutput, error) {
	req, out := c.AddTagsToCertificateRequest(input)
	return out, req.Send()
}

// AddTagsToCertificateWithContext is the same as AddTagsToCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) AddTagsToCertificateWithContext(ctx aws.Context, input *AddTagsToCertificateInput, opts ...request.Option) (*AddTagsToCertificateOutput, error) {
	req, out := c.AddTagsToCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificate for more information on using the DeleteCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DeleteCertificate
func (c *ACM) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	output = &DeleteCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCertificate API operation for AWS Certificate Manager.
//
// Deletes a certificate and its associated private key. If this action succeeds,
// the certificate no longer appears in the list that can be displayed by calling
// the ListCertificates action or be retrieved by calling the GetCertificate
// action. The certificate will not be available for use by AWS services integrated
// with ACM.
//
// You cannot delete an ACM Certificate that is being used by another AWS service.
// To delete a certificate that is in use, the certificate association must
// first be removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The certificate is in use by another AWS service in the caller's account.
//   Remove the association and try again.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DeleteCertificate
func (c *ACM) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	return out, req.Send()
}

// DeleteCertificateWithContext is the same as DeleteCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) DeleteCertificateWithContext(ctx aws.Context, input *DeleteCertificateInput, opts ...request.Option) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificate = "DescribeCertificate"

// DescribeCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificate for more information on using the DescribeCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificateRequest method.
//    req, resp := client.DescribeCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DescribeCertificate
func (c *ACM) DescribeCertificateRequest(input *DescribeCertificateInput) (req *request.Request, output *DescribeCertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificateInput{}
	}

	output = &DescribeCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificate API operation for AWS Certificate Manager.
//
// Returns detailed metadata about the specified ACM Certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation DescribeCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DescribeCertificate
func (c *ACM) DescribeCertificate(input *DescribeCertificateInput) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	return out, req.Send()
}

// DescribeCertificateWithContext is the same as DescribeCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) DescribeCertificateWithContext(ctx aws.Context, input *DescribeCertificateInput, opts ...request.Option) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCertificate = "GetCertificate"

// GetCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCertificate for more information on using the GetCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCertificateRequest method.
//    req, resp := client.GetCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/GetCertificate
func (c *ACM) GetCertificateRequest(input *GetCertificateInput) (req *request.Request, output *GetCertificateOutput) {
	op := &request.Operation{
		Name:       opGetCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateInput{}
	}

	output = &GetCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCertificate API operation for AWS Certificate Manager.
//
// Retrieves a certificate specified by an ARN and its certificate chain . The
// chain is an ordered list of certificates that contains the end entity ertificate,
// intermediate certificates of subordinate CAs, and the root certificate in
// that order. The certificate and certificate chain are base64 encoded. If
// you want to decode the certificate to see the individual fields, you can
// use OpenSSL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation GetCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ErrCodeRequestInProgressException "RequestInProgressException"
//   The certificate request is in process and the certificate in your account
//   has not yet been issued.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/GetCertificate
func (c *ACM) GetCertificate(input *GetCertificateInput) (*GetCertificateOutput, error) {
	req, out := c.GetCertificateRequest(input)
	return out, req.Send()
}

// GetCertificateWithContext is the same as GetCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) GetCertificateWithContext(ctx aws.Context, input *GetCertificateInput, opts ...request.Option) (*GetCertificateOutput, error) {
	req, out := c.GetCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportCertificate = "ImportCertificate"

// ImportCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ImportCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCertificate for more information on using the ImportCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportCertificateRequest method.
//    req, resp := client.ImportCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ImportCertificate
func (c *ACM) ImportCertificateRequest(input *ImportCertificateInput) (req *request.Request, output *ImportCertificateOutput) {
	op := &request.Operation{
		Name:       opImportCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCertificateInput{}
	}

	output = &ImportCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportCertificate API operation for AWS Certificate Manager.
//
// Imports a certificate into AWS Certificate Manager (ACM) to use with services
// that are integrated with ACM. For more information, see Integrated Services
// (http://docs.aws.amazon.com/acm/latest/userguide/acm-services.html).
//
// ACM does not provide managed renewal (http://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
// for certificates that you import.
//
// For more information about importing certificates into ACM, including the
// differences between certificates that you import and those that ACM provides,
// see Importing Certificates (http://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
// in the AWS Certificate Manager User Guide.
//
// In general, you can import almost any valid certificate. However, services
// integrated with ACM allow only certificate types they support to be associated
// with their resources. The following guidelines are also important:
//
//    * You must enter the private key that matches the certificate you are
//    importing.
//
//    * The private key must be unencrypted. You cannot import a private key
//    that is protected by a password or a passphrase.
//
//    * If the certificate you are importing is not self-signed, you must enter
//    its certificate chain.
//
//    * If a certificate chain is included, the issuer must be the subject of
//    one of the certificates in the chain.
//
//    * The certificate, private key, and certificate chain must be PEM-encoded.
//
//    * The current time must be between the Not Before and Not After certificate
//    fields.
//
//    * The Issuer field must not be empty.
//
//    * The OCSP authority URL must not exceed 1000 characters.
//
//    * To import a new certificate, omit the CertificateArn field. Include
//    this field only when you want to replace a previously imported certificate.
//
//    * When you import a certificate by using the CLI or one of the SDKs, you
//    must specify the certificate, certificate chain, and private key parameters
//    as file names preceded by file://. For example, you can specify a certificate
//    saved in the C:\temp folder as C:\temp\certificate_to_import.pem. If you
//    are making an HTTP or HTTPS Query request, include these parameters as
//    BLOBs.
//
// This operation returns the Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
// of the imported certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation ImportCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An ACM limit has been exceeded. For example, you may have input more domains
//   than are allowed or you've requested too many certificates for your account.
//   See the exception message returned by ACM to determine which limit you have
//   violated. For more information about ACM limits, see the Limits (http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html)
//   topic.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ImportCertificate
func (c *ACM) ImportCertificate(input *ImportCertificateInput) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	return out, req.Send()
}

// ImportCertificateWithContext is the same as ImportCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) ImportCertificateWithContext(ctx aws.Context, input *ImportCertificateInput, opts ...request.Option) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificates = "ListCertificates"

// ListCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCertificates operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCertificates for more information on using the ListCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCertificatesRequest method.
//    req, resp := client.ListCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ListCertificates
func (c *ACM) ListCertificatesRequest(input *ListCertificatesInput) (req *request.Request, output *ListCertificatesOutput) {
	op := &request.Operation{
		Name:       opListCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCertificatesInput{}
	}

	output = &ListCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificates API operation for AWS Certificate Manager.
//
// Retrieves a list of certificate ARNs and domain names. You can request that
// only certificates that match a specific status be listed. You can also filter
// by specific attributes of the certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation ListCertificates for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ListCertificates
func (c *ACM) ListCertificates(input *ListCertificatesInput) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	return out, req.Send()
}

// ListCertificatesWithContext is the same as ListCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) ListCertificatesWithContext(ctx aws.Context, input *ListCertificatesInput, opts ...request.Option) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCertificatesPages iterates over the pages of a ListCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCertificates operation.
//    pageNum := 0
//    err := client.ListCertificatesPages(params,
//        func(page *ListCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ACM) ListCertificatesPages(input *ListCertificatesInput, fn func(*ListCertificatesOutput, bool) bool) error {
	return c.ListCertificatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCertificatesPagesWithContext same as ListCertificatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) ListCertificatesPagesWithContext(ctx aws.Context, input *ListCertificatesInput, fn func(*ListCertificatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCertificatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCertificatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListCertificatesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForCertificate = "ListTagsForCertificate"

// ListTagsForCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForCertificate for more information on using the ListTagsForCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForCertificateRequest method.
//    req, resp := client.ListTagsForCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ListTagsForCertificate
func (c *ACM) ListTagsForCertificateRequest(input *ListTagsForCertificateInput) (req *request.Request, output *ListTagsForCertificateOutput) {
	op := &request.Operation{
		Name:       opListTagsForCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForCertificateInput{}
	}

	output = &ListTagsForCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForCertificate API operation for AWS Certificate Manager.
//
// Lists the tags that have been applied to the ACM Certificate. Use the certificate's
// Amazon Resource Name (ARN) to specify the certificate. To add a tag to an
// ACM Certificate, use the AddTagsToCertificate action. To delete a tag, use
// the RemoveTagsFromCertificate action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation ListTagsForCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ListTagsForCertificate
func (c *ACM) ListTagsForCertificate(input *ListTagsForCertificateInput) (*ListTagsForCertificateOutput, error) {
	req, out := c.ListTagsForCertificateRequest(input)
	return out, req.Send()
}

// ListTagsForCertificateWithContext is the same as ListTagsForCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) ListTagsForCertificateWithContext(ctx aws.Context, input *ListTagsForCertificateInput, opts ...request.Option) (*ListTagsForCertificateOutput, error) {
	req, out := c.ListTagsForCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromCertificate = "RemoveTagsFromCertificate"

// RemoveTagsFromCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromCertificate for more information on using the RemoveTagsFromCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromCertificateRequest method.
//    req, resp := client.RemoveTagsFromCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RemoveTagsFromCertificate
func (c *ACM) RemoveTagsFromCertificateRequest(input *RemoveTagsFromCertificateInput) (req *request.Request, output *RemoveTagsFromCertificateOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromCertificateInput{}
	}

	output = &RemoveTagsFromCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromCertificate API operation for AWS Certificate Manager.
//
// Remove one or more tags from an ACM Certificate. A tag consists of a key-value
// pair. If you do not specify the value portion of the tag when calling this
// function, the tag will be removed regardless of value. If you specify a value,
// the tag is removed only if it is associated with the specified value.
//
// To add tags to a certificate, use the AddTagsToCertificate action. To view
// all of the tags that have been applied to a specific ACM Certificate, use
// the ListTagsForCertificate action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation RemoveTagsFromCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//   One or both of the values that make up the key-value pair is not valid. For
//   example, you cannot specify a tag value that begins with aws:.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RemoveTagsFromCertificate
func (c *ACM) RemoveTagsFromCertificate(input *RemoveTagsFromCertificateInput) (*RemoveTagsFromCertificateOutput, error) {
	req, out := c.RemoveTagsFromCertificateRequest(input)
	return out, req.Send()
}

// RemoveTagsFromCertificateWithContext is the same as RemoveTagsFromCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) RemoveTagsFromCertificateWithContext(ctx aws.Context, input *RemoveTagsFromCertificateInput, opts ...request.Option) (*RemoveTagsFromCertificateOutput, error) {
	req, out := c.RemoveTagsFromCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestCertificate = "RequestCertificate"

// RequestCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RequestCertificate operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestCertificate for more information on using the RequestCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RequestCertificateRequest method.
//    req, resp := client.RequestCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RequestCertificate
func (c *ACM) RequestCertificateRequest(input *RequestCertificateInput) (req *request.Request, output *RequestCertificateOutput) {
	op := &request.Operation{
		Name:       opRequestCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestCertificateInput{}
	}

	output = &RequestCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestCertificate API operation for AWS Certificate Manager.
//
// Requests an ACM Certificate for use with other AWS services. To request an
// ACM Certificate, you must specify the fully qualified domain name (FQDN)
// for your site in the DomainName parameter. You can also specify additional
// FQDNs in the SubjectAlternativeNames parameter if users can reach your site
// by using other names.
//
// For each domain name you specify, email is sent to the domain owner to request
// approval to issue the certificate. Email is sent to three registered contact
// addresses in the WHOIS database and to five common system administration
// addresses formed from the DomainName you enter or the optional ValidationDomain
// parameter. For more information, see Validate Domain Ownership (http://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate.html).
//
// After receiving approval from the domain owner, the ACM Certificate is issued.
// For more information, see the AWS Certificate Manager User Guide (http://docs.aws.amazon.com/acm/latest/userguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation RequestCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An ACM limit has been exceeded. For example, you may have input more domains
//   than are allowed or you've requested too many certificates for your account.
//   See the exception message returned by ACM to determine which limit you have
//   violated. For more information about ACM limits, see the Limits (http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html)
//   topic.
//
//   * ErrCodeInvalidDomainValidationOptionsException "InvalidDomainValidationOptionsException"
//   One or more values in the DomainValidationOption structure is incorrect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RequestCertificate
func (c *ACM) RequestCertificate(input *RequestCertificateInput) (*RequestCertificateOutput, error) {
	req, out := c.RequestCertificateRequest(input)
	return out, req.Send()
}

// RequestCertificateWithContext is the same as RequestCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RequestCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) RequestCertificateWithContext(ctx aws.Context, input *RequestCertificateInput, opts ...request.Option) (*RequestCertificateOutput, error) {
	req, out := c.RequestCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResendValidationEmail = "ResendValidationEmail"

// ResendValidationEmailRequest generates a "aws/request.Request" representing the
// client's request for the ResendValidationEmail operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResendValidationEmail for more information on using the ResendValidationEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResendValidationEmailRequest method.
//    req, resp := client.ResendValidationEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ResendValidationEmail
func (c *ACM) ResendValidationEmailRequest(input *ResendValidationEmailInput) (req *request.Request, output *ResendValidationEmailOutput) {
	op := &request.Operation{
		Name:       opResendValidationEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResendValidationEmailInput{}
	}

	output = &ResendValidationEmailOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResendValidationEmail API operation for AWS Certificate Manager.
//
// Resends the email that requests domain ownership validation. The domain owner
// or an authorized representative must approve the ACM Certificate before it
// can be issued. The certificate can be approved by clicking a link in the
// mail to navigate to the Amazon certificate approval website and then clicking
// I Approve. However, the validation email can be blocked by spam filters.
// Therefore, if you do not receive the original mail, you can request that
// the mail be resent within 72 hours of requesting the ACM Certificate. If
// more than 72 hours have elapsed since your original request or since your
// last attempt to resend validation mail, you must request a new certificate.
// For more information about setting up your contact email addresses, see Configure
// Email for your Domain (http://docs.aws.amazon.com/acm/latest/userguide/setup-email.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation ResendValidationEmail for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ErrCodeInvalidStateException "InvalidStateException"
//   Processing has reached an invalid state. For example, this exception can
//   occur if the specified domain is not using email validation, or the current
//   certificate status does not permit the requested operation. See the exception
//   message returned by ACM to determine which state is not valid.
//
//   * ErrCodeInvalidArnException "InvalidArnException"
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * ErrCodeInvalidDomainValidationOptionsException "InvalidDomainValidationOptionsException"
//   One or more values in the DomainValidationOption structure is incorrect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ResendValidationEmail
func (c *ACM) ResendValidationEmail(input *ResendValidationEmailInput) (*ResendValidationEmailOutput, error) {
	req, out := c.ResendValidationEmailRequest(input)
	return out, req.Send()
}

// ResendValidationEmailWithContext is the same as ResendValidationEmail with the addition of
// the ability to pass a context and additional request options.
//
// See ResendValidationEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACM) ResendValidationEmailWithContext(ctx aws.Context, input *ResendValidationEmailInput, opts ...request.Option) (*ResendValidationEmailOutput, error) {
	req, out := c.ResendValidationEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/AddTagsToCertificateRequest
type AddTagsToCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate to which the tag is to
	// be applied. This must be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// The key-value pair that defines the tag. The tag value is optional.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *AddTagsToCertificateInput) SetCertificateArn(v string) *AddTagsToCertificateInput {
	s.CertificateArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToCertificateInput) SetTags(v []*Tag) *AddTagsToCertificateInput {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/AddTagsToCertificateOutput
type AddTagsToCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToCertificateOutput) GoString() string {
	return s.String()
}

// Contains metadata about an ACM certificate. This structure is returned in
// the response to a DescribeCertificate request.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/CertificateDetail
type CertificateDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate. For more information about
	// ARNs, see Amazon Resource Names (ARNs) and AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	CertificateArn *string `min:"20" type:"string"`

	// The time at which the certificate was requested. This value exists only when
	// the certificate type is AMAZON_ISSUED.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The fully qualified domain name for the certificate, such as www.example.com
	// or example.com.
	DomainName *string `min:"1" type:"string"`

	// Contains information about the initial validation of each domain name that
	// occurs as a result of the RequestCertificate request. This field exists only
	// when the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []*DomainValidation `min:"1" type:"list"`

	// Contains a list of Extended Key Usage X.509 v3 extension objects. Each object
	// specifies a purpose for which the certificate public key can be used and
	// consists of a name and an object identifier (OID).
	ExtendedKeyUsages []*ExtendedKeyUsage `type:"list"`

	// The reason the certificate request failed. This value exists only when the
	// certificate status is FAILED. For more information, see Certificate Request
	// Failed (http://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed)
	// in the AWS Certificate Manager User Guide.
	FailureReason *string `type:"string" enum:"FailureReason"`

	// The date and time at which the certificate was imported. This value exists
	// only when the certificate type is IMPORTED.
	ImportedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of ARNs for the AWS resources that are using the certificate. A certificate
	// can be used by multiple AWS resources.
	InUseBy []*string `type:"list"`

	// The time at which the certificate was issued. This value exists only when
	// the certificate type is AMAZON_ISSUED.
	IssuedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the certificate authority that issued and signed the certificate.
	Issuer *string `type:"string"`

	// The algorithm that was used to generate the public-private key pair.
	KeyAlgorithm *string `type:"string" enum:"KeyAlgorithm"`

	// A list of Key Usage X.509 v3 extension objects. Each object is a string value
	// that identifies the purpose of the public key contained in the certificate.
	// Possible extension values include DIGITAL_SIGNATURE, KEY_ENCHIPHERMENT, NON_REPUDIATION,
	// and more.
	KeyUsages []*KeyUsage `type:"list"`

	// The time after which the certificate is not valid.
	NotAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time before which the certificate is not valid.
	NotBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Contains information about the status of ACM's managed renewal (http://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
	// for the certificate. This field exists only when the certificate type is
	// AMAZON_ISSUED.
	RenewalSummary *RenewalSummary `type:"structure"`

	// The reason the certificate was revoked. This value exists only when the certificate
	// status is REVOKED.
	RevocationReason *string `type:"string" enum:"RevocationReason"`

	// The time at which the certificate was revoked. This value exists only when
	// the certificate status is REVOKED.
	RevokedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The serial number of the certificate.
	Serial *string `type:"string"`

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string `type:"string"`

	// The status of the certificate.
	Status *string `type:"string" enum:"CertificateStatus"`

	// The name of the entity that is associated with the public key contained in
	// the certificate.
	Subject *string `type:"string"`

	// One or more domain names (subject alternative names) included in the certificate.
	// This list contains the domain names that are bound to the public key that
	// is contained in the certificate. The subject alternative names include the
	// canonical domain name (CN) of the certificate and additional domain names
	// that can be used to connect to the website.
	SubjectAlternativeNames []*string `min:"1" type:"list"`

	// The source of the certificate. For certificates provided by ACM, this value
	// is AMAZON_ISSUED. For certificates that you imported with ImportCertificate,
	// this value is IMPORTED. ACM does not provide managed renewal (http://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
	// for imported certificates. For more information about the differences between
	// certificates that you import and those that ACM provides, see Importing Certificates
	// (http://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the AWS Certificate Manager User Guide.
	Type *string `type:"string" enum:"CertificateType"`
}

// String returns the string representation
func (s CertificateDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateDetail) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CertificateDetail) SetCertificateArn(v string) *CertificateDetail {
	s.CertificateArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CertificateDetail) SetCreatedAt(v time.Time) *CertificateDetail {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CertificateDetail) SetDomainName(v string) *CertificateDetail {
	s.DomainName = &v
	return s
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *CertificateDetail) SetDomainValidationOptions(v []*DomainValidation) *CertificateDetail {
	s.DomainValidationOptions = v
	return s
}

// SetExtendedKeyUsages sets the ExtendedKeyUsages field's value.
func (s *CertificateDetail) SetExtendedKeyUsages(v []*ExtendedKeyUsage) *CertificateDetail {
	s.ExtendedKeyUsages = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CertificateDetail) SetFailureReason(v string) *CertificateDetail {
	s.FailureReason = &v
	return s
}

// SetImportedAt sets the ImportedAt field's value.
func (s *CertificateDetail) SetImportedAt(v time.Time) *CertificateDetail {
	s.ImportedAt = &v
	return s
}

// SetInUseBy sets the InUseBy field's value.
func (s *CertificateDetail) SetInUseBy(v []*string) *CertificateDetail {
	s.InUseBy = v
	return s
}

// SetIssuedAt sets the IssuedAt field's value.
func (s *CertificateDetail) SetIssuedAt(v time.Time) *CertificateDetail {
	s.IssuedAt = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *CertificateDetail) SetIssuer(v string) *CertificateDetail {
	s.Issuer = &v
	return s
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *CertificateDetail) SetKeyAlgorithm(v string) *CertificateDetail {
	s.KeyAlgorithm = &v
	return s
}

// SetKeyUsages sets the KeyUsages field's value.
func (s *CertificateDetail) SetKeyUsages(v []*KeyUsage) *CertificateDetail {
	s.KeyUsages = v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *CertificateDetail) SetNotAfter(v time.Time) *CertificateDetail {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *CertificateDetail) SetNotBefore(v time.Time) *CertificateDetail {
	s.NotBefore = &v
	return s
}

// SetRenewalSummary sets the RenewalSummary field's value.
func (s *CertificateDetail) SetRenewalSummary(v *RenewalSummary) *CertificateDetail {
	s.RenewalSummary = v
	return s
}

// SetRevocationReason sets the RevocationReason field's value.
func (s *CertificateDetail) SetRevocationReason(v string) *CertificateDetail {
	s.RevocationReason = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *CertificateDetail) SetRevokedAt(v time.Time) *CertificateDetail {
	s.RevokedAt = &v
	return s
}

// SetSerial sets the Serial field's value.
func (s *CertificateDetail) SetSerial(v string) *CertificateDetail {
	s.Serial = &v
	return s
}

// SetSignatureAlgorithm sets the SignatureAlgorithm field's value.
func (s *CertificateDetail) SetSignatureAlgorithm(v string) *CertificateDetail {
	s.SignatureAlgorithm = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertificateDetail) SetStatus(v string) *CertificateDetail {
	s.Status = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *CertificateDetail) SetSubject(v string) *CertificateDetail {
	s.Subject = &v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *CertificateDetail) SetSubjectAlternativeNames(v []*string) *CertificateDetail {
	s.SubjectAlternativeNames = v
	return s
}

// SetType sets the Type field's value.
func (s *CertificateDetail) SetType(v string) *CertificateDetail {
	s.Type = &v
	return s
}

// This structure is returned in the response object of ListCertificates action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/CertificateSummary
type CertificateSummary struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the certificate. This is of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	CertificateArn *string `min:"20" type:"string"`

	// Fully qualified domain name (FQDN), such as www.example.com or example.com,
	// for the certificate.
	DomainName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CertificateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateSummary) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CertificateSummary) SetCertificateArn(v string) *CertificateSummary {
	s.CertificateArn = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CertificateSummary) SetDomainName(v string) *CertificateSummary {
	s.DomainName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DeleteCertificateRequest
type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate to be deleted. This must
	// be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DeleteCertificateInput) SetCertificateArn(v string) *DeleteCertificateInput {
	s.CertificateArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DeleteCertificateOutput
type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DescribeCertificateRequest
type DescribeCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the ACM Certificate. The ARN must have
	// the following form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DescribeCertificateInput) SetCertificateArn(v string) *DescribeCertificateInput {
	s.CertificateArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DescribeCertificateResponse
type DescribeCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Metadata about an ACM certificate.
	Certificate *CertificateDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *DescribeCertificateOutput) SetCertificate(v *CertificateDetail) *DescribeCertificateOutput {
	s.Certificate = v
	return s
}

// Contains information about the validation of each domain name in the certificate.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DomainValidation
type DomainValidation struct {
	_ struct{} `type:"structure"`

	// A fully qualified domain name (FQDN) in the certificate. For example, www.example.com
	// or example.com.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// Contains the CNAME record that you add to your DNS database for domain validation.
	// For more information, see Use DNS to Validate Domain Ownership (http://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html).
	ResourceRecord *ResourceRecord `type:"structure"`

	// The domain name that ACM used to send domain validation emails.
	ValidationDomain *string `min:"1" type:"string"`

	// A list of email addresses that ACM used to send domain validation emails.
	ValidationEmails []*string `type:"list"`

	// Specifies the domain validation method.
	ValidationMethod *string `type:"string" enum:"ValidationMethod"`

	// The validation status of the domain name. This can be one of the following
	// values:
	//
	//    * PENDING_VALIDATION
	//
	//    * SUCCESS
	//
	//    * FAILED
	ValidationStatus *string `type:"string" enum:"DomainStatus"`
}

// String returns the string representation
func (s DomainValidation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainValidation) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainValidation) SetDomainName(v string) *DomainValidation {
	s.DomainName = &v
	return s
}

// SetResourceRecord sets the ResourceRecord field's value.
func (s *DomainValidation) SetResourceRecord(v *ResourceRecord) *DomainValidation {
	s.ResourceRecord = v
	return s
}

// SetValidationDomain sets the ValidationDomain field's value.
func (s *DomainValidation) SetValidationDomain(v string) *DomainValidation {
	s.ValidationDomain = &v
	return s
}

// SetValidationEmails sets the ValidationEmails field's value.
func (s *DomainValidation) SetValidationEmails(v []*string) *DomainValidation {
	s.ValidationEmails = v
	return s
}

// SetValidationMethod sets the ValidationMethod field's value.
func (s *DomainValidation) SetValidationMethod(v string) *DomainValidation {
	s.ValidationMethod = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *DomainValidation) SetValidationStatus(v string) *DomainValidation {
	s.ValidationStatus = &v
	return s
}

// Contains information about the domain names that you want ACM to use to send
// you emails that enable you to validate domain ownership.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/DomainValidationOption
type DomainValidationOption struct {
	_ struct{} `type:"structure"`

	// A fully qualified domain name (FQDN) in the certificate request.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The domain name that you want ACM to use to send you validation emails. This
	// domain name is the suffix of the email addresses that you want ACM to use.
	// This must be the same as the DomainName value or a superdomain of the DomainName
	// value. For example, if you request a certificate for testing.example.com,
	// you can specify example.com for this value. In that case, ACM sends domain
	// validation emails to the following five addresses:
	//
	//    * admin@example.com
	//
	//    * administrator@example.com
	//
	//    * hostmaster@example.com
	//
	//    * postmaster@example.com
	//
	//    * webmaster@example.com
	//
	// ValidationDomain is a required field
	ValidationDomain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DomainValidationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainValidationOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainValidationOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainValidationOption"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ValidationDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationDomain"))
	}
	if s.ValidationDomain != nil && len(*s.ValidationDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationDomain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DomainValidationOption) SetDomainName(v string) *DomainValidationOption {
	s.DomainName = &v
	return s
}

// SetValidationDomain sets the ValidationDomain field's value.
func (s *DomainValidationOption) SetValidationDomain(v string) *DomainValidationOption {
	s.ValidationDomain = &v
	return s
}

// The Extended Key Usage X.509 v3 extension defines one or more purposes for
// which the public key can be used. This is in addition to or in place of the
// basic purposes specified by the Key Usage extension.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ExtendedKeyUsage
type ExtendedKeyUsage struct {
	_ struct{} `type:"structure"`

	// The name of an Extended Key Usage value.
	Name *string `type:"string" enum:"ExtendedKeyUsageName"`

	// An object identifier (OID) for the extension value. OIDs are strings of numbers
	// separated by periods. The following OIDs are defined in RFC 3280 and RFC
	// 5280.
	//
	//    * 1.3.6.1.5.5.7.3.1 (TLS_WEB_SERVER_AUTHENTICATION)
	//
	//    * 1.3.6.1.5.5.7.3.2 (TLS_WEB_CLIENT_AUTHENTICATION)
	//
	//    * 1.3.6.1.5.5.7.3.3 (CODE_SIGNING)
	//
	//    * 1.3.6.1.5.5.7.3.4 (EMAIL_PROTECTION)
	//
	//    * 1.3.6.1.5.5.7.3.8 (TIME_STAMPING)
	//
	//    * 1.3.6.1.5.5.7.3.9 (OCSP_SIGNING)
	//
	//    * 1.3.6.1.5.5.7.3.5 (IPSEC_END_SYSTEM)
	//
	//    * 1.3.6.1.5.5.7.3.6 (IPSEC_TUNNEL)
	//
	//    * 1.3.6.1.5.5.7.3.7 (IPSEC_USER)
	OID *string `type:"string"`
}

// String returns the string representation
func (s ExtendedKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtendedKeyUsage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ExtendedKeyUsage) SetName(v string) *ExtendedKeyUsage {
	s.Name = &v
	return s
}

// SetOID sets the OID field's value.
func (s *ExtendedKeyUsage) SetOID(v string) *ExtendedKeyUsage {
	s.OID = &v
	return s
}

// This structure can be used in the ListCertificates action to filter the output
// of the certificate list.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/Filters
type Filters struct {
	_ struct{} `type:"structure"`

	// Specify one or more ExtendedKeyUsage extension values.
	ExtendedKeyUsage []*string `locationName:"extendedKeyUsage" type:"list"`

	// Specify one or more algorithms that can be used to generate key pairs.
	KeyTypes []*string `locationName:"keyTypes" type:"list"`

	// Specify one or more KeyUsage extension values.
	KeyUsage []*string `locationName:"keyUsage" type:"list"`
}

// String returns the string representation
func (s Filters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filters) GoString() string {
	return s.String()
}

// SetExtendedKeyUsage sets the ExtendedKeyUsage field's value.
func (s *Filters) SetExtendedKeyUsage(v []*string) *Filters {
	s.ExtendedKeyUsage = v
	return s
}

// SetKeyTypes sets the KeyTypes field's value.
func (s *Filters) SetKeyTypes(v []*string) *Filters {
	s.KeyTypes = v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *Filters) SetKeyUsage(v []*string) *Filters {
	s.KeyUsage = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/GetCertificateRequest
type GetCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains a certificate ARN in the following format:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *GetCertificateInput) SetCertificateArn(v string) *GetCertificateInput {
	s.CertificateArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/GetCertificateResponse
type GetCertificateOutput struct {
	_ struct{} `type:"structure"`

	// String that contains the ACM Certificate represented by the ARN specified
	// at input.
	Certificate *string `min:"1" type:"string"`

	// The certificate chain that contains the root certificate issued by the certificate
	// authority (CA).
	CertificateChain *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *GetCertificateOutput) SetCertificate(v string) *GetCertificateOutput {
	s.Certificate = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *GetCertificateOutput) SetCertificateChain(v string) *GetCertificateOutput {
	s.CertificateChain = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ImportCertificateRequest
type ImportCertificateInput struct {
	_ struct{} `type:"structure"`

	// The certificate to import.
	//
	// Certificate is automatically base64 encoded/decoded by the SDK.
	//
	// Certificate is a required field
	Certificate []byte `min:"1" type:"blob" required:"true"`

	// The Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an imported certificate to replace. To import a new certificate, omit
	// this field.
	CertificateArn *string `min:"20" type:"string"`

	// The PEM encoded certificate chain.
	//
	// CertificateChain is automatically base64 encoded/decoded by the SDK.
	CertificateChain []byte `min:"1" type:"blob"`

	// The private key that matches the public key in the certificate.
	//
	// PrivateKey is automatically base64 encoded/decoded by the SDK.
	//
	// PrivateKey is a required field
	PrivateKey []byte `min:"1" type:"blob" required:"true"`
}

// String returns the string representation
func (s ImportCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCertificateInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(s.Certificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 1))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.CertificateChain != nil && len(s.CertificateChain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateChain", 1))
	}
	if s.PrivateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKey"))
	}
	if s.PrivateKey != nil && len(s.PrivateKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrivateKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *ImportCertificateInput) SetCertificate(v []byte) *ImportCertificateInput {
	s.Certificate = v
	return s
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *ImportCertificateInput) SetCertificateArn(v string) *ImportCertificateInput {
	s.CertificateArn = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *ImportCertificateInput) SetCertificateChain(v []byte) *ImportCertificateInput {
	s.CertificateChain = v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *ImportCertificateInput) SetPrivateKey(v []byte) *ImportCertificateInput {
	s.PrivateKey = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ImportCertificateResponse
type ImportCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the imported certificate.
	CertificateArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s ImportCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *ImportCertificateOutput) SetCertificateArn(v string) *ImportCertificateOutput {
	s.CertificateArn = &v
	return s
}

// The Key Usage X.509 v3 extension defines the purpose of the public key contained
// in the certificate.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/KeyUsage
type KeyUsage struct {
	_ struct{} `type:"structure"`

	// A string value that contains a Key Usage extension name.
	Name *string `type:"string" enum:"KeyUsageName"`
}

// String returns the string representation
func (s KeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyUsage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *KeyUsage) SetName(v string) *KeyUsage {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ListCertificatesRequest
type ListCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Filter the certificate list by status value.
	CertificateStatuses []*string `type:"list"`

	// Filter the certificate list by one or more of the following values. For more
	// information, see the Filters structure.
	//
	//    * extendedKeyUsage
	//
	//    * keyUsage
	//
	//    * keyTypes
	Includes *Filters `type:"structure"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response. If additional items exist beyond the
	// number you specify, the NextToken element is sent in the response. Use this
	// NextToken value in a subsequent request to retrieve additional items.
	MaxItems *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you receive a response with truncated results. Set it to the
	// value of NextToken from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificatesInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateStatuses sets the CertificateStatuses field's value.
func (s *ListCertificatesInput) SetCertificateStatuses(v []*string) *ListCertificatesInput {
	s.CertificateStatuses = v
	return s
}

// SetIncludes sets the Includes field's value.
func (s *ListCertificatesInput) SetIncludes(v *Filters) *ListCertificatesInput {
	s.Includes = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListCertificatesInput) SetMaxItems(v int64) *ListCertificatesInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCertificatesInput) SetNextToken(v string) *ListCertificatesInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ListCertificatesResponse
type ListCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ACM Certificates.
	CertificateSummaryList []*CertificateSummary `type:"list"`

	// When the list is truncated, this value is present and contains the value
	// to use for the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificateSummaryList sets the CertificateSummaryList field's value.
func (s *ListCertificatesOutput) SetCertificateSummaryList(v []*CertificateSummary) *ListCertificatesOutput {
	s.CertificateSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCertificatesOutput) SetNextToken(v string) *ListCertificatesOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ListTagsForCertificateRequest
type ListTagsForCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate for which you want to
	// list the tags. This must have the following form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *ListTagsForCertificateInput) SetCertificateArn(v string) *ListTagsForCertificateInput {
	s.CertificateArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ListTagsForCertificateResponse
type ListTagsForCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The key-value pairs that define the applied tags.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForCertificateOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForCertificateOutput) SetTags(v []*Tag) *ListTagsForCertificateOutput {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RemoveTagsFromCertificateRequest
type RemoveTagsFromCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate with one or more tags
	// that you want to remove. This must be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// The key-value pair that defines the tag to remove.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *RemoveTagsFromCertificateInput) SetCertificateArn(v string) *RemoveTagsFromCertificateInput {
	s.CertificateArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RemoveTagsFromCertificateInput) SetTags(v []*Tag) *RemoveTagsFromCertificateInput {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RemoveTagsFromCertificateOutput
type RemoveTagsFromCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromCertificateOutput) GoString() string {
	return s.String()
}

// Contains information about the status of ACM's managed renewal (http://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
// for the certificate. This structure exists only when the certificate type
// is AMAZON_ISSUED.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RenewalSummary
type RenewalSummary struct {
	_ struct{} `type:"structure"`

	// Contains information about the validation of each domain name in the certificate,
	// as it pertains to ACM's managed renewal (http://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html).
	// This is different from the initial validation that occurs as a result of
	// the RequestCertificate request. This field exists only when the certificate
	// type is AMAZON_ISSUED.
	//
	// DomainValidationOptions is a required field
	DomainValidationOptions []*DomainValidation `min:"1" type:"list" required:"true"`

	// The status of ACM's managed renewal (http://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
	// of the certificate.
	//
	// RenewalStatus is a required field
	RenewalStatus *string `type:"string" required:"true" enum:"RenewalStatus"`
}

// String returns the string representation
func (s RenewalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RenewalSummary) GoString() string {
	return s.String()
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *RenewalSummary) SetDomainValidationOptions(v []*DomainValidation) *RenewalSummary {
	s.DomainValidationOptions = v
	return s
}

// SetRenewalStatus sets the RenewalStatus field's value.
func (s *RenewalSummary) SetRenewalStatus(v string) *RenewalSummary {
	s.RenewalStatus = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RequestCertificateRequest
type RequestCertificateInput struct {
	_ struct{} `type:"structure"`

	// Fully qualified domain name (FQDN), such as www.example.com, of the site
	// that you want to secure with an ACM Certificate. Use an asterisk (*) to create
	// a wildcard certificate that protects several sites in the same domain. For
	// example, *.example.com protects www.example.com, site.example.com, and images.example.com.
	//
	// The first domain name you enter cannot exceed 63 octets, including periods.
	// Each subsequent Subject Alternative Name (SAN), however, can be up to 253
	// octets in length.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The domain name that you want ACM to use to send you emails so taht your
	// can validate domain ownership.
	DomainValidationOptions []*DomainValidationOption `min:"1" type:"list"`

	// Customer chosen string that can be used to distinguish between calls to RequestCertificate.
	// Idempotency tokens time out after one hour. Therefore, if you call RequestCertificate
	// multiple times with the same idempotency token within one hour, ACM recognizes
	// that you are requesting only one certificate and will issue only one. If
	// you change the idempotency token for each call, ACM recognizes that you are
	// requesting multiple certificates.
	IdempotencyToken *string `min:"1" type:"string"`

	// Additional FQDNs to be included in the Subject Alternative Name extension
	// of the ACM Certificate. For example, add the name www.example.net to a certificate
	// for which the DomainName field is www.example.com if users can reach your
	// site by using either name. The maximum number of domain names that you can
	// add to an ACM Certificate is 100. However, the initial limit is 10 domain
	// names. If you need more than 10 names, you must request a limit increase.
	// For more information, see Limits (http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
	//
	// The maximum length of a SAN DNS name is 253 octets. The name is made up of
	// multiple labels separated by periods. No label can be longer than 63 octets.
	// Consider the following examples:
	//
	//    * (63 octets).(63 octets).(63 octets).(61 octets) is legal because the
	//    total length is 253 octets (63+1+63+1+63+1+61) and no label exceeds 63
	//    octets.
	//
	//    * (64 octets).(63 octets).(63 octets).(61 octets) is not legal because
	//    the total length exceeds 253 octets (64+1+63+1+63+1+61) and the first
	//    label exceeds 63 octets.
	//
	//    * (63 octets).(63 octets).(63 octets).(62 octets) is not legal because
	//    the total length of the DNS name (63+1+63+1+63+1+62) exceeds 253 octets.
	SubjectAlternativeNames []*string `min:"1" type:"list"`

	// The method you want to use to validate your domain.
	ValidationMethod *string `type:"string" enum:"ValidationMethod"`
}

// String returns the string representation
func (s RequestCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestCertificateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.DomainValidationOptions != nil && len(s.DomainValidationOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainValidationOptions", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.SubjectAlternativeNames != nil && len(s.SubjectAlternativeNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubjectAlternativeNames", 1))
	}
	if s.DomainValidationOptions != nil {
		for i, v := range s.DomainValidationOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DomainValidationOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *RequestCertificateInput) SetDomainName(v string) *RequestCertificateInput {
	s.DomainName = &v
	return s
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *RequestCertificateInput) SetDomainValidationOptions(v []*DomainValidationOption) *RequestCertificateInput {
	s.DomainValidationOptions = v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *RequestCertificateInput) SetIdempotencyToken(v string) *RequestCertificateInput {
	s.IdempotencyToken = &v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *RequestCertificateInput) SetSubjectAlternativeNames(v []*string) *RequestCertificateInput {
	s.SubjectAlternativeNames = v
	return s
}

// SetValidationMethod sets the ValidationMethod field's value.
func (s *RequestCertificateInput) SetValidationMethod(v string) *RequestCertificateInput {
	s.ValidationMethod = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RequestCertificateResponse
type RequestCertificateOutput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the issued certificate. This must be of the
	// form:
	//
	// arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
	CertificateArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s RequestCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *RequestCertificateOutput) SetCertificateArn(v string) *RequestCertificateOutput {
	s.CertificateArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ResendValidationEmailRequest
type ResendValidationEmailInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the requested certificate. The certificate
	// ARN is generated and returned by the RequestCertificate action as soon as
	// the request is made. By default, using this parameter causes email to be
	// sent to all top-level domains you specified in the certificate request. The
	// ARN must be of the form:
	//
	// arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// The fully qualified domain name (FQDN) of the certificate that needs to be
	// validated.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The base validation domain that will act as the suffix of the email addresses
	// that are used to send the emails. This must be the same as the Domain value
	// or a superdomain of the Domain value. For example, if you requested a certificate
	// for site.subdomain.example.com and specify a ValidationDomain of subdomain.example.com,
	// ACM sends email to the domain registrant, technical contact, and administrative
	// contact in WHOIS and the following five addresses:
	//
	//    * admin@subdomain.example.com
	//
	//    * administrator@subdomain.example.com
	//
	//    * hostmaster@subdomain.example.com
	//
	//    * postmaster@subdomain.example.com
	//
	//    * webmaster@subdomain.example.com
	//
	// ValidationDomain is a required field
	ValidationDomain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResendValidationEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendValidationEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResendValidationEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResendValidationEmailInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.ValidationDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationDomain"))
	}
	if s.ValidationDomain != nil && len(*s.ValidationDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationDomain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *ResendValidationEmailInput) SetCertificateArn(v string) *ResendValidationEmailInput {
	s.CertificateArn = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ResendValidationEmailInput) SetDomain(v string) *ResendValidationEmailInput {
	s.Domain = &v
	return s
}

// SetValidationDomain sets the ValidationDomain field's value.
func (s *ResendValidationEmailInput) SetValidationDomain(v string) *ResendValidationEmailInput {
	s.ValidationDomain = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ResendValidationEmailOutput
type ResendValidationEmailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResendValidationEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendValidationEmailOutput) GoString() string {
	return s.String()
}

// Contains a DNS record value that you can use to can use to validate ownership
// or control of a domain. This is used by the DescribeCertificate action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ResourceRecord
type ResourceRecord struct {
	_ struct{} `type:"structure"`

	// The name of the DNS record to create in your domain. This is supplied by
	// ACM.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The type of DNS record. Currently this can be CNAME.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RecordType"`

	// The value of the CNAME record to add to your DNS database. This is supplied
	// by ACM.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecord) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ResourceRecord) SetName(v string) *ResourceRecord {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceRecord) SetType(v string) *ResourceRecord {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceRecord) SetValue(v string) *ResourceRecord {
	s.Value = &v
	return s
}

// A key-value pair that identifies or specifies metadata about an ACM resource.
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

const (
	// CertificateStatusPendingValidation is a CertificateStatus enum value
	CertificateStatusPendingValidation = "PENDING_VALIDATION"

	// CertificateStatusIssued is a CertificateStatus enum value
	CertificateStatusIssued = "ISSUED"

	// CertificateStatusInactive is a CertificateStatus enum value
	CertificateStatusInactive = "INACTIVE"

	// CertificateStatusExpired is a CertificateStatus enum value
	CertificateStatusExpired = "EXPIRED"

	// CertificateStatusValidationTimedOut is a CertificateStatus enum value
	CertificateStatusValidationTimedOut = "VALIDATION_TIMED_OUT"

	// CertificateStatusRevoked is a CertificateStatus enum value
	CertificateStatusRevoked = "REVOKED"

	// CertificateStatusFailed is a CertificateStatus enum value
	CertificateStatusFailed = "FAILED"
)

const (
	// CertificateTypeImported is a CertificateType enum value
	CertificateTypeImported = "IMPORTED"

	// CertificateTypeAmazonIssued is a CertificateType enum value
	CertificateTypeAmazonIssued = "AMAZON_ISSUED"
)

const (
	// DomainStatusPendingValidation is a DomainStatus enum value
	DomainStatusPendingValidation = "PENDING_VALIDATION"

	// DomainStatusSuccess is a DomainStatus enum value
	DomainStatusSuccess = "SUCCESS"

	// DomainStatusFailed is a DomainStatus enum value
	DomainStatusFailed = "FAILED"
)

const (
	// ExtendedKeyUsageNameTlsWebServerAuthentication is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameTlsWebServerAuthentication = "TLS_WEB_SERVER_AUTHENTICATION"

	// ExtendedKeyUsageNameTlsWebClientAuthentication is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameTlsWebClientAuthentication = "TLS_WEB_CLIENT_AUTHENTICATION"

	// ExtendedKeyUsageNameCodeSigning is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameCodeSigning = "CODE_SIGNING"

	// ExtendedKeyUsageNameEmailProtection is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameEmailProtection = "EMAIL_PROTECTION"

	// ExtendedKeyUsageNameTimeStamping is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameTimeStamping = "TIME_STAMPING"

	// ExtendedKeyUsageNameOcspSigning is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameOcspSigning = "OCSP_SIGNING"

	// ExtendedKeyUsageNameIpsecEndSystem is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameIpsecEndSystem = "IPSEC_END_SYSTEM"

	// ExtendedKeyUsageNameIpsecTunnel is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameIpsecTunnel = "IPSEC_TUNNEL"

	// ExtendedKeyUsageNameIpsecUser is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameIpsecUser = "IPSEC_USER"

	// ExtendedKeyUsageNameAny is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameAny = "ANY"

	// ExtendedKeyUsageNameNone is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameNone = "NONE"

	// ExtendedKeyUsageNameCustom is a ExtendedKeyUsageName enum value
	ExtendedKeyUsageNameCustom = "CUSTOM"
)

const (
	// FailureReasonNoAvailableContacts is a FailureReason enum value
	FailureReasonNoAvailableContacts = "NO_AVAILABLE_CONTACTS"

	// FailureReasonAdditionalVerificationRequired is a FailureReason enum value
	FailureReasonAdditionalVerificationRequired = "ADDITIONAL_VERIFICATION_REQUIRED"

	// FailureReasonDomainNotAllowed is a FailureReason enum value
	FailureReasonDomainNotAllowed = "DOMAIN_NOT_ALLOWED"

	// FailureReasonInvalidPublicDomain is a FailureReason enum value
	FailureReasonInvalidPublicDomain = "INVALID_PUBLIC_DOMAIN"

	// FailureReasonCaaError is a FailureReason enum value
	FailureReasonCaaError = "CAA_ERROR"

	// FailureReasonOther is a FailureReason enum value
	FailureReasonOther = "OTHER"
)

const (
	// KeyAlgorithmRsa2048 is a KeyAlgorithm enum value
	KeyAlgorithmRsa2048 = "RSA_2048"

	// KeyAlgorithmRsa1024 is a KeyAlgorithm enum value
	KeyAlgorithmRsa1024 = "RSA_1024"

	// KeyAlgorithmRsa4096 is a KeyAlgorithm enum value
	KeyAlgorithmRsa4096 = "RSA_4096"

	// KeyAlgorithmEcPrime256v1 is a KeyAlgorithm enum value
	KeyAlgorithmEcPrime256v1 = "EC_prime256v1"

	// KeyAlgorithmEcSecp384r1 is a KeyAlgorithm enum value
	KeyAlgorithmEcSecp384r1 = "EC_secp384r1"

	// KeyAlgorithmEcSecp521r1 is a KeyAlgorithm enum value
	KeyAlgorithmEcSecp521r1 = "EC_secp521r1"
)

const (
	// KeyUsageNameDigitalSignature is a KeyUsageName enum value
	KeyUsageNameDigitalSignature = "DIGITAL_SIGNATURE"

	// KeyUsageNameNonRepudiation is a KeyUsageName enum value
	KeyUsageNameNonRepudiation = "NON_REPUDIATION"

	// KeyUsageNameKeyEncipherment is a KeyUsageName enum value
	KeyUsageNameKeyEncipherment = "KEY_ENCIPHERMENT"

	// KeyUsageNameDataEncipherment is a KeyUsageName enum value
	KeyUsageNameDataEncipherment = "DATA_ENCIPHERMENT"

	// KeyUsageNameKeyAgreement is a KeyUsageName enum value
	KeyUsageNameKeyAgreement = "KEY_AGREEMENT"

	// KeyUsageNameCertificateSigning is a KeyUsageName enum value
	KeyUsageNameCertificateSigning = "CERTIFICATE_SIGNING"

	// KeyUsageNameCrlSigning is a KeyUsageName enum value
	KeyUsageNameCrlSigning = "CRL_SIGNING"

	// KeyUsageNameEncipherOnly is a KeyUsageName enum value
	KeyUsageNameEncipherOnly = "ENCIPHER_ONLY"

	// KeyUsageNameDecipherOnly is a KeyUsageName enum value
	KeyUsageNameDecipherOnly = "DECIPHER_ONLY"

	// KeyUsageNameAny is a KeyUsageName enum value
	KeyUsageNameAny = "ANY"

	// KeyUsageNameCustom is a KeyUsageName enum value
	KeyUsageNameCustom = "CUSTOM"
)

const (
	// RecordTypeCname is a RecordType enum value
	RecordTypeCname = "CNAME"
)

const (
	// RenewalStatusPendingAutoRenewal is a RenewalStatus enum value
	RenewalStatusPendingAutoRenewal = "PENDING_AUTO_RENEWAL"

	// RenewalStatusPendingValidation is a RenewalStatus enum value
	RenewalStatusPendingValidation = "PENDING_VALIDATION"

	// RenewalStatusSuccess is a RenewalStatus enum value
	RenewalStatusSuccess = "SUCCESS"

	// RenewalStatusFailed is a RenewalStatus enum value
	RenewalStatusFailed = "FAILED"
)

const (
	// RevocationReasonUnspecified is a RevocationReason enum value
	RevocationReasonUnspecified = "UNSPECIFIED"

	// RevocationReasonKeyCompromise is a RevocationReason enum value
	RevocationReasonKeyCompromise = "KEY_COMPROMISE"

	// RevocationReasonCaCompromise is a RevocationReason enum value
	RevocationReasonCaCompromise = "CA_COMPROMISE"

	// RevocationReasonAffiliationChanged is a RevocationReason enum value
	RevocationReasonAffiliationChanged = "AFFILIATION_CHANGED"

	// RevocationReasonSuperceded is a RevocationReason enum value
	RevocationReasonSuperceded = "SUPERCEDED"

	// RevocationReasonCessationOfOperation is a RevocationReason enum value
	RevocationReasonCessationOfOperation = "CESSATION_OF_OPERATION"

	// RevocationReasonCertificateHold is a RevocationReason enum value
	RevocationReasonCertificateHold = "CERTIFICATE_HOLD"

	// RevocationReasonRemoveFromCrl is a RevocationReason enum value
	RevocationReasonRemoveFromCrl = "REMOVE_FROM_CRL"

	// RevocationReasonPrivilegeWithdrawn is a RevocationReason enum value
	RevocationReasonPrivilegeWithdrawn = "PRIVILEGE_WITHDRAWN"

	// RevocationReasonAACompromise is a RevocationReason enum value
	RevocationReasonAACompromise = "A_A_COMPROMISE"
)

const (
	// ValidationMethodEmail is a ValidationMethod enum value
	ValidationMethodEmail = "EMAIL"

	// ValidationMethodDns is a ValidationMethod enum value
	ValidationMethodDns = "DNS"
)
