# v2.1 to 2.2

## Upgraded Helm Version

Note that bundled Helm has been upgraded from 3.6.0 to v3.7+. This includes following breaking changes:

- Repository credentials are no longer passed to download charts that
  are being served from a different domain than the repository.

  You can still force older behavior with `--helm-pass-credentials` option to `argocd app create`.

  More information in the [Helm v3.6.1 release notes](https://github.com/helm/helm/releases/tag/v3.6.1).

- Experimental OCI support has been rewritten.

  More information in the [Helm v3.7.0 release notes](https://github.com/helm/helm/releases/tag/v3.7.0).

## Support for private repo SSH keys using the SHA-1 signature hash algorithm is removed in 2.2.12

Argo CD 2.2.12 upgraded its base image from Ubuntu 21.10 to Ubuntu 22.04, which upgraded OpenSSH to 8.9. OpenSSH starting
with 8.8 [dropped support for the `ssh-rsa` SHA-1 key signature algorithm](https://www.openssh.com/txt/release-8.8).

The signature algorithm is _not_ the same as the algorithm used when generating the key. There is no need to update
keys.

The signature algorithm is negotiated with the SSH server when the connection is being set up. The client offers its
list of accepted signature algorithms, and if the server has a match, the connection proceeds. For most SSH servers on
up-to-date git providers, acceptable algorithms other than `ssh-rsa` should be available.

Before upgrading to Argo CD 2.2.12, check whether your git provider(s) using SSH authentication support algorithms newer
than `rsa-ssh`.

1. Make sure your version of SSH >= 8.9 (the version used by Argo CD). If not, upgrade it before proceeding.

   ```shell
   ssh -V
   ```

   Example output: `OpenSSH_8.9p1 Ubuntu-3, OpenSSL 3.0.2 15 Mar 2022`

2. Once you have a recent version of OpenSSH, follow the directions from the [OpenSSH 8.8 release notes](https://www.openssh.com/txt/release-8.7):

   > To check whether a server is using the weak ssh-rsa public key
   > algorithm, for host authentication, try to connect to it after
   > removing the ssh-rsa algorithm from ssh(1)'s allowed list:
   >
   > ```shell
   > ssh -oHostKeyAlgorithms=-ssh-rsa user@host
   > ```
   >
   > If the host key verification fails and no other supported host key
   > types are available, the server software on that host should be
   > upgraded.

   If the server does not support an acceptable version, you will get an error similar to this;

   ```
   $ ssh -oHostKeyAlgorithms=-ssh-rsa vs-ssh.visualstudio.com
   Unable to negotiate with 20.42.134.1 port 22: no matching host key type found. Their offer: ssh-rsa
   ```

   This indicates that the server needs to update its supported key signature algorithms, and Argo CD will not connect
   to it.

### Workaround

The [OpenSSH 8.8 release notes](https://www.openssh.com/txt/release-8.8) describe a workaround if you cannot change the
server's key signature algorithms configuration.

> Incompatibility is more likely when connecting to older SSH
> implementations that have not been upgraded or have not closely tracked
> improvements in the SSH protocol. For these cases, it may be necessary
> to selectively re-enable RSA/SHA1 to allow connection and/or user
> authentication via the HostkeyAlgorithms and PubkeyAcceptedAlgorithms
> options. For example, the following stanza in ~/.ssh/config will enable
> RSA/SHA1 for host and user authentication for a single destination host:
>
> ```
> Host old-host
>     HostkeyAlgorithms +ssh-rsa
>     PubkeyAcceptedAlgorithms +ssh-rsa
> ```
>
> We recommend enabling RSA/SHA1 only as a stopgap measure until legacy
> implementations can be upgraded or reconfigured with another key type
> (such as ECDSA or Ed25519).

To apply this to Argo CD, you could create a ConfigMap with the desired ssh config file and then mount it at
`/home/argocd/.ssh/config`.
