// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: cc/arduino/cli/commands/v1/core.proto

package commands

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type PlatformInstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Platform version to install.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Set to true to not run (eventual) post install scripts for trusted
	// platforms.
	SkipPostInstall bool `protobuf:"varint,5,opt,name=skip_post_install,json=skipPostInstall,proto3" json:"skip_post_install,omitempty"`
	// Set to true to skip installation if a different version of the platform
	// is already installed.
	NoOverwrite bool `protobuf:"varint,6,opt,name=no_overwrite,json=noOverwrite,proto3" json:"no_overwrite,omitempty"`
	// Set to true to not run (eventual) pre uninstall scripts for trusted
	// platforms when performing platform upgrades.
	SkipPreUninstall bool `protobuf:"varint,7,opt,name=skip_pre_uninstall,json=skipPreUninstall,proto3" json:"skip_pre_uninstall,omitempty"`
}

func (x *PlatformInstallRequest) Reset() {
	*x = PlatformInstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformInstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformInstallRequest) ProtoMessage() {}

func (x *PlatformInstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformInstallRequest.ProtoReflect.Descriptor instead.
func (*PlatformInstallRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{0}
}

func (x *PlatformInstallRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformInstallRequest) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformInstallRequest) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformInstallRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *PlatformInstallRequest) GetSkipPostInstall() bool {
	if x != nil {
		return x.SkipPostInstall
	}
	return false
}

func (x *PlatformInstallRequest) GetNoOverwrite() bool {
	if x != nil {
		return x.NoOverwrite
	}
	return false
}

func (x *PlatformInstallRequest) GetSkipPreUninstall() bool {
	if x != nil {
		return x.SkipPreUninstall
	}
	return false
}

type PlatformInstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*PlatformInstallResponse_Progress
	//	*PlatformInstallResponse_TaskProgress
	//	*PlatformInstallResponse_Result_
	Message isPlatformInstallResponse_Message `protobuf_oneof:"message"`
}

func (x *PlatformInstallResponse) Reset() {
	*x = PlatformInstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformInstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformInstallResponse) ProtoMessage() {}

func (x *PlatformInstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformInstallResponse.ProtoReflect.Descriptor instead.
func (*PlatformInstallResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{1}
}

func (m *PlatformInstallResponse) GetMessage() isPlatformInstallResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *PlatformInstallResponse) GetProgress() *DownloadProgress {
	if x, ok := x.GetMessage().(*PlatformInstallResponse_Progress); ok {
		return x.Progress
	}
	return nil
}

func (x *PlatformInstallResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*PlatformInstallResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *PlatformInstallResponse) GetResult() *PlatformInstallResponse_Result {
	if x, ok := x.GetMessage().(*PlatformInstallResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isPlatformInstallResponse_Message interface {
	isPlatformInstallResponse_Message()
}

type PlatformInstallResponse_Progress struct {
	// Progress of the downloads of the platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type PlatformInstallResponse_TaskProgress struct {
	// Description of the current stage of the installation.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type PlatformInstallResponse_Result_ struct {
	// The installation result.
	Result *PlatformInstallResponse_Result `protobuf:"bytes,3,opt,name=result,proto3,oneof"`
}

func (*PlatformInstallResponse_Progress) isPlatformInstallResponse_Message() {}

func (*PlatformInstallResponse_TaskProgress) isPlatformInstallResponse_Message() {}

func (*PlatformInstallResponse_Result_) isPlatformInstallResponse_Message() {}

type PlatformLoadingError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PlatformLoadingError) Reset() {
	*x = PlatformLoadingError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformLoadingError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformLoadingError) ProtoMessage() {}

func (x *PlatformLoadingError) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformLoadingError.ProtoReflect.Descriptor instead.
func (*PlatformLoadingError) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{2}
}

type PlatformDownloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Platform version to download.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *PlatformDownloadRequest) Reset() {
	*x = PlatformDownloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformDownloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformDownloadRequest) ProtoMessage() {}

func (x *PlatformDownloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformDownloadRequest.ProtoReflect.Descriptor instead.
func (*PlatformDownloadRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{3}
}

func (x *PlatformDownloadRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformDownloadRequest) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformDownloadRequest) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformDownloadRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type PlatformDownloadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*PlatformDownloadResponse_Progress
	//	*PlatformDownloadResponse_Result_
	Message isPlatformDownloadResponse_Message `protobuf_oneof:"message"`
}

func (x *PlatformDownloadResponse) Reset() {
	*x = PlatformDownloadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformDownloadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformDownloadResponse) ProtoMessage() {}

func (x *PlatformDownloadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformDownloadResponse.ProtoReflect.Descriptor instead.
func (*PlatformDownloadResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{4}
}

func (m *PlatformDownloadResponse) GetMessage() isPlatformDownloadResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *PlatformDownloadResponse) GetProgress() *DownloadProgress {
	if x, ok := x.GetMessage().(*PlatformDownloadResponse_Progress); ok {
		return x.Progress
	}
	return nil
}

func (x *PlatformDownloadResponse) GetResult() *PlatformDownloadResponse_Result {
	if x, ok := x.GetMessage().(*PlatformDownloadResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isPlatformDownloadResponse_Message interface {
	isPlatformDownloadResponse_Message()
}

type PlatformDownloadResponse_Progress struct {
	// Progress of the downloads of platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type PlatformDownloadResponse_Result_ struct {
	// The download result.
	Result *PlatformDownloadResponse_Result `protobuf:"bytes,2,opt,name=result,proto3,oneof"`
}

func (*PlatformDownloadResponse_Progress) isPlatformDownloadResponse_Message() {}

func (*PlatformDownloadResponse_Result_) isPlatformDownloadResponse_Message() {}

type PlatformUninstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Set to true to not run (eventual) pre uninstall scripts for trusted
	// platforms.
	SkipPreUninstall bool `protobuf:"varint,4,opt,name=skip_pre_uninstall,json=skipPreUninstall,proto3" json:"skip_pre_uninstall,omitempty"`
}

func (x *PlatformUninstallRequest) Reset() {
	*x = PlatformUninstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUninstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUninstallRequest) ProtoMessage() {}

func (x *PlatformUninstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUninstallRequest.ProtoReflect.Descriptor instead.
func (*PlatformUninstallRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{5}
}

func (x *PlatformUninstallRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformUninstallRequest) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformUninstallRequest) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformUninstallRequest) GetSkipPreUninstall() bool {
	if x != nil {
		return x.SkipPreUninstall
	}
	return false
}

type PlatformUninstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*PlatformUninstallResponse_TaskProgress
	//	*PlatformUninstallResponse_Result_
	Message isPlatformUninstallResponse_Message `protobuf_oneof:"message"`
}

func (x *PlatformUninstallResponse) Reset() {
	*x = PlatformUninstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUninstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUninstallResponse) ProtoMessage() {}

func (x *PlatformUninstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUninstallResponse.ProtoReflect.Descriptor instead.
func (*PlatformUninstallResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{6}
}

func (m *PlatformUninstallResponse) GetMessage() isPlatformUninstallResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *PlatformUninstallResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*PlatformUninstallResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *PlatformUninstallResponse) GetResult() *PlatformUninstallResponse_Result {
	if x, ok := x.GetMessage().(*PlatformUninstallResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isPlatformUninstallResponse_Message interface {
	isPlatformUninstallResponse_Message()
}

type PlatformUninstallResponse_TaskProgress struct {
	// Description of the current stage of the uninstall.
	TaskProgress *TaskProgress `protobuf:"bytes,1,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type PlatformUninstallResponse_Result_ struct {
	// The uninstall result.
	Result *PlatformUninstallResponse_Result `protobuf:"bytes,2,opt,name=result,proto3,oneof"`
}

func (*PlatformUninstallResponse_TaskProgress) isPlatformUninstallResponse_Message() {}

func (*PlatformUninstallResponse_Result_) isPlatformUninstallResponse_Message() {}

// AlreadyAtLatestVersionError is returned when an upgrade is not possible
// because already at latest version.
type AlreadyAtLatestVersionError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AlreadyAtLatestVersionError) Reset() {
	*x = AlreadyAtLatestVersionError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlreadyAtLatestVersionError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlreadyAtLatestVersionError) ProtoMessage() {}

func (x *AlreadyAtLatestVersionError) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlreadyAtLatestVersionError.ProtoReflect.Descriptor instead.
func (*AlreadyAtLatestVersionError) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{7}
}

type PlatformUpgradeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Set to true to not run (eventual) post install scripts for trusted
	// platforms.
	SkipPostInstall bool `protobuf:"varint,4,opt,name=skip_post_install,json=skipPostInstall,proto3" json:"skip_post_install,omitempty"`
	// Set to true to not run (eventual) pre uninstall scripts for trusted
	// platforms when performing platform upgrades.
	SkipPreUninstall bool `protobuf:"varint,5,opt,name=skip_pre_uninstall,json=skipPreUninstall,proto3" json:"skip_pre_uninstall,omitempty"`
}

func (x *PlatformUpgradeRequest) Reset() {
	*x = PlatformUpgradeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUpgradeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUpgradeRequest) ProtoMessage() {}

func (x *PlatformUpgradeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUpgradeRequest.ProtoReflect.Descriptor instead.
func (*PlatformUpgradeRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{8}
}

func (x *PlatformUpgradeRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformUpgradeRequest) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformUpgradeRequest) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformUpgradeRequest) GetSkipPostInstall() bool {
	if x != nil {
		return x.SkipPostInstall
	}
	return false
}

func (x *PlatformUpgradeRequest) GetSkipPreUninstall() bool {
	if x != nil {
		return x.SkipPreUninstall
	}
	return false
}

type PlatformUpgradeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*PlatformUpgradeResponse_Progress
	//	*PlatformUpgradeResponse_TaskProgress
	//	*PlatformUpgradeResponse_Result_
	Message isPlatformUpgradeResponse_Message `protobuf_oneof:"message"`
}

func (x *PlatformUpgradeResponse) Reset() {
	*x = PlatformUpgradeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUpgradeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUpgradeResponse) ProtoMessage() {}

func (x *PlatformUpgradeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUpgradeResponse.ProtoReflect.Descriptor instead.
func (*PlatformUpgradeResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{9}
}

func (m *PlatformUpgradeResponse) GetMessage() isPlatformUpgradeResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *PlatformUpgradeResponse) GetProgress() *DownloadProgress {
	if x, ok := x.GetMessage().(*PlatformUpgradeResponse_Progress); ok {
		return x.Progress
	}
	return nil
}

func (x *PlatformUpgradeResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*PlatformUpgradeResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *PlatformUpgradeResponse) GetResult() *PlatformUpgradeResponse_Result {
	if x, ok := x.GetMessage().(*PlatformUpgradeResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isPlatformUpgradeResponse_Message interface {
	isPlatformUpgradeResponse_Message()
}

type PlatformUpgradeResponse_Progress struct {
	// Progress of the downloads of the platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type PlatformUpgradeResponse_TaskProgress struct {
	// Description of the current stage of the upgrade.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type PlatformUpgradeResponse_Result_ struct {
	// The upgrade result.
	Result *PlatformUpgradeResponse_Result `protobuf:"bytes,3,opt,name=result,proto3,oneof"`
}

func (*PlatformUpgradeResponse_Progress) isPlatformUpgradeResponse_Message() {}

func (*PlatformUpgradeResponse_TaskProgress) isPlatformUpgradeResponse_Message() {}

func (*PlatformUpgradeResponse_Result_) isPlatformUpgradeResponse_Message() {}

type PlatformSearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Keywords for the search.
	SearchArgs string `protobuf:"bytes,2,opt,name=search_args,json=searchArgs,proto3" json:"search_args,omitempty"`
	// Whether to show manually installed platforms. `false` causes to skip
	// manually installed platforms.
	ManuallyInstalled bool `protobuf:"varint,3,opt,name=manually_installed,json=manuallyInstalled,proto3" json:"manually_installed,omitempty"`
}

func (x *PlatformSearchRequest) Reset() {
	*x = PlatformSearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformSearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformSearchRequest) ProtoMessage() {}

func (x *PlatformSearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformSearchRequest.ProtoReflect.Descriptor instead.
func (*PlatformSearchRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{10}
}

func (x *PlatformSearchRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformSearchRequest) GetSearchArgs() string {
	if x != nil {
		return x.SearchArgs
	}
	return ""
}

func (x *PlatformSearchRequest) GetManuallyInstalled() bool {
	if x != nil {
		return x.ManuallyInstalled
	}
	return false
}

type PlatformSearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of the search.
	SearchOutput []*PlatformSummary `protobuf:"bytes,1,rep,name=search_output,json=searchOutput,proto3" json:"search_output,omitempty"`
}

func (x *PlatformSearchResponse) Reset() {
	*x = PlatformSearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformSearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformSearchResponse) ProtoMessage() {}

func (x *PlatformSearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformSearchResponse.ProtoReflect.Descriptor instead.
func (*PlatformSearchResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{11}
}

func (x *PlatformSearchResponse) GetSearchOutput() []*PlatformSummary {
	if x != nil {
		return x.SearchOutput
	}
	return nil
}

type PlatformInstallResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PlatformInstallResponse_Result) Reset() {
	*x = PlatformInstallResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformInstallResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformInstallResponse_Result) ProtoMessage() {}

func (x *PlatformInstallResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformInstallResponse_Result.ProtoReflect.Descriptor instead.
func (*PlatformInstallResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{1, 0}
}

type PlatformDownloadResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PlatformDownloadResponse_Result) Reset() {
	*x = PlatformDownloadResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformDownloadResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformDownloadResponse_Result) ProtoMessage() {}

func (x *PlatformDownloadResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformDownloadResponse_Result.ProtoReflect.Descriptor instead.
func (*PlatformDownloadResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{4, 0}
}

type PlatformUninstallResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PlatformUninstallResponse_Result) Reset() {
	*x = PlatformUninstallResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUninstallResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUninstallResponse_Result) ProtoMessage() {}

func (x *PlatformUninstallResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUninstallResponse_Result.ProtoReflect.Descriptor instead.
func (*PlatformUninstallResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{6, 0}
}

type PlatformUpgradeResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The upgraded platform.
	Platform *Platform `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
}

func (x *PlatformUpgradeResponse_Result) Reset() {
	*x = PlatformUpgradeResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUpgradeResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUpgradeResponse_Result) ProtoMessage() {}

func (x *PlatformUpgradeResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_core_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUpgradeResponse_Result.ProtoReflect.Descriptor instead.
func (*PlatformUpgradeResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP(), []int{9, 0}
}

func (x *PlatformUpgradeResponse_Result) GetPlatform() *Platform {
	if x != nil {
		return x.Platform
	}
	return nil
}

var File_cc_arduino_cli_commands_v1_core_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_core_proto_rawDesc = []byte{
	0x0a, 0x25, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f,
	0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc0, 0x02, 0x0a,
	0x16, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73,
	0x6b, 0x69, 0x70, 0x50, 0x6f, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x12, 0x21,
	0x0a, 0x0c, 0x6e, 0x6f, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6e, 0x6f, 0x4f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70, 0x72, 0x65, 0x5f, 0x75, 0x6e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73,
	0x6b, 0x69, 0x70, 0x50, 0x72, 0x65, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x22,
	0xa1, 0x02, 0x0a, 0x17, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x54, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x08,
	0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0x16, 0x0a, 0x14, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c,
	0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xc4, 0x01, 0x0a, 0x17,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xd2, 0x01, 0x0a, 0x18, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48,
	0x00, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x55, 0x0a, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x09, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x18, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70, 0x72,
	0x65, 0x5f, 0x75, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x72, 0x65, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x22, 0xd9, 0x01, 0x0a, 0x19, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x1d, 0x0a, 0x1b, 0x41, 0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x41, 0x74, 0x4c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x83,
	0x02, 0x0a, 0x16, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6b,
	0x69, 0x70, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x6f, 0x73, 0x74, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x70,
	0x72, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x72, 0x65, 0x55, 0x6e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x22, 0xe3, 0x02, 0x0a, 0x17, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x48, 0x00, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4f, 0x0a, 0x0d,
	0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52,
	0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x54, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x1a, 0x4a, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x40, 0x0a,
	0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x15, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x61, 0x72, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x72, 0x67, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x6d, 0x61, 0x6e, 0x75, 0x61,
	0x6c, 0x6c, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x11, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x22, 0x6a, 0x0a, 0x16, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x50, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x42, 0x48, 0x5a, 0x46, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_core_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_core_proto_rawDescData = file_cc_arduino_cli_commands_v1_core_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_core_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_core_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_core_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_core_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_core_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_core_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_cc_arduino_cli_commands_v1_core_proto_goTypes = []any{
	(*PlatformInstallRequest)(nil),           // 0: cc.arduino.cli.commands.v1.PlatformInstallRequest
	(*PlatformInstallResponse)(nil),          // 1: cc.arduino.cli.commands.v1.PlatformInstallResponse
	(*PlatformLoadingError)(nil),             // 2: cc.arduino.cli.commands.v1.PlatformLoadingError
	(*PlatformDownloadRequest)(nil),          // 3: cc.arduino.cli.commands.v1.PlatformDownloadRequest
	(*PlatformDownloadResponse)(nil),         // 4: cc.arduino.cli.commands.v1.PlatformDownloadResponse
	(*PlatformUninstallRequest)(nil),         // 5: cc.arduino.cli.commands.v1.PlatformUninstallRequest
	(*PlatformUninstallResponse)(nil),        // 6: cc.arduino.cli.commands.v1.PlatformUninstallResponse
	(*AlreadyAtLatestVersionError)(nil),      // 7: cc.arduino.cli.commands.v1.AlreadyAtLatestVersionError
	(*PlatformUpgradeRequest)(nil),           // 8: cc.arduino.cli.commands.v1.PlatformUpgradeRequest
	(*PlatformUpgradeResponse)(nil),          // 9: cc.arduino.cli.commands.v1.PlatformUpgradeResponse
	(*PlatformSearchRequest)(nil),            // 10: cc.arduino.cli.commands.v1.PlatformSearchRequest
	(*PlatformSearchResponse)(nil),           // 11: cc.arduino.cli.commands.v1.PlatformSearchResponse
	(*PlatformInstallResponse_Result)(nil),   // 12: cc.arduino.cli.commands.v1.PlatformInstallResponse.Result
	(*PlatformDownloadResponse_Result)(nil),  // 13: cc.arduino.cli.commands.v1.PlatformDownloadResponse.Result
	(*PlatformUninstallResponse_Result)(nil), // 14: cc.arduino.cli.commands.v1.PlatformUninstallResponse.Result
	(*PlatformUpgradeResponse_Result)(nil),   // 15: cc.arduino.cli.commands.v1.PlatformUpgradeResponse.Result
	(*Instance)(nil),                         // 16: cc.arduino.cli.commands.v1.Instance
	(*DownloadProgress)(nil),                 // 17: cc.arduino.cli.commands.v1.DownloadProgress
	(*TaskProgress)(nil),                     // 18: cc.arduino.cli.commands.v1.TaskProgress
	(*PlatformSummary)(nil),                  // 19: cc.arduino.cli.commands.v1.PlatformSummary
	(*Platform)(nil),                         // 20: cc.arduino.cli.commands.v1.Platform
}
var file_cc_arduino_cli_commands_v1_core_proto_depIdxs = []int32{
	16, // 0: cc.arduino.cli.commands.v1.PlatformInstallRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	17, // 1: cc.arduino.cli.commands.v1.PlatformInstallResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	18, // 2: cc.arduino.cli.commands.v1.PlatformInstallResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	12, // 3: cc.arduino.cli.commands.v1.PlatformInstallResponse.result:type_name -> cc.arduino.cli.commands.v1.PlatformInstallResponse.Result
	16, // 4: cc.arduino.cli.commands.v1.PlatformDownloadRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	17, // 5: cc.arduino.cli.commands.v1.PlatformDownloadResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	13, // 6: cc.arduino.cli.commands.v1.PlatformDownloadResponse.result:type_name -> cc.arduino.cli.commands.v1.PlatformDownloadResponse.Result
	16, // 7: cc.arduino.cli.commands.v1.PlatformUninstallRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	18, // 8: cc.arduino.cli.commands.v1.PlatformUninstallResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	14, // 9: cc.arduino.cli.commands.v1.PlatformUninstallResponse.result:type_name -> cc.arduino.cli.commands.v1.PlatformUninstallResponse.Result
	16, // 10: cc.arduino.cli.commands.v1.PlatformUpgradeRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	17, // 11: cc.arduino.cli.commands.v1.PlatformUpgradeResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	18, // 12: cc.arduino.cli.commands.v1.PlatformUpgradeResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	15, // 13: cc.arduino.cli.commands.v1.PlatformUpgradeResponse.result:type_name -> cc.arduino.cli.commands.v1.PlatformUpgradeResponse.Result
	16, // 14: cc.arduino.cli.commands.v1.PlatformSearchRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	19, // 15: cc.arduino.cli.commands.v1.PlatformSearchResponse.search_output:type_name -> cc.arduino.cli.commands.v1.PlatformSummary
	20, // 16: cc.arduino.cli.commands.v1.PlatformUpgradeResponse.Result.platform:type_name -> cc.arduino.cli.commands.v1.Platform
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_core_proto_init() }
func file_cc_arduino_cli_commands_v1_core_proto_init() {
	if File_cc_arduino_cli_commands_v1_core_proto != nil {
		return
	}
	file_cc_arduino_cli_commands_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformInstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformInstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformLoadingError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformDownloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformDownloadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformUninstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformUninstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*AlreadyAtLatestVersionError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformUpgradeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformUpgradeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformSearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformSearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformInstallResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformDownloadResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformUninstallResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_core_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*PlatformUpgradeResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cc_arduino_cli_commands_v1_core_proto_msgTypes[1].OneofWrappers = []any{
		(*PlatformInstallResponse_Progress)(nil),
		(*PlatformInstallResponse_TaskProgress)(nil),
		(*PlatformInstallResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_core_proto_msgTypes[4].OneofWrappers = []any{
		(*PlatformDownloadResponse_Progress)(nil),
		(*PlatformDownloadResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_core_proto_msgTypes[6].OneofWrappers = []any{
		(*PlatformUninstallResponse_TaskProgress)(nil),
		(*PlatformUninstallResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_core_proto_msgTypes[9].OneofWrappers = []any{
		(*PlatformUpgradeResponse_Progress)(nil),
		(*PlatformUpgradeResponse_TaskProgress)(nil),
		(*PlatformUpgradeResponse_Result_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_core_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_core_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_core_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_core_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_core_proto = out.File
	file_cc_arduino_cli_commands_v1_core_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_core_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_core_proto_depIdxs = nil
}
