package pixivision

import (
	"github.com/iawia002/annie/downloader"
	"github.com/iawia002/annie/parser"
	"github.com/iawia002/annie/request"
)

// Download main download function
func Download(url string) ([]downloader.VideoData, error) {
	html, err := request.Get(url, url, nil)
	if err != nil {
		return downloader.EmptyData, err
	}
	title, urls, err := parser.GetImages(url, html, "am__work__illust  ", nil)
	if err != nil {
		return downloader.EmptyData, err
	}
	format := map[string]downloader.FormatData{
		"default": {
			URLs: urls,
			Size: 0,
		},
	}

	return []downloader.VideoData{
		{
			Site:    "pixivision pixivision.net",
			Title:   title,
			Type:    "image",
			Formats: format,
		},
	}, nil
}
