// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestScopes(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.ScopesOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.Scopes([]string{}...),
		},
		{
			opts:     []interface{}{opt.Scopes("value1")},
			expected: opt.Scopes("value1"),
		},
		{
			opts:     []interface{}{opt.Scopes("value1", "value2", "value3")},
			expected: opt.Scopes("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractScopes(c.opts...)
			out opt.ScopesOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestScopes_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.ScopesOption
	}{
		{
			payload:  `""`,
			expected: opt.Scopes([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.Scopes("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.Scopes("value1", "value2", "value3"),
		},
	} {
		var got opt.ScopesOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
