# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.7.3"
  license "MIT"

  on_macos do
    on_intel do
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.3/actionlint_1.7.3_darwin_amd64.tar.gz"
      sha256 "33e960b719c87ecc0c807cf4945fd4078980cd2e626b27ded0e9551c757fa8f6"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    on_arm do
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.3/actionlint_1.7.3_darwin_arm64.tar.gz"
      sha256 "b4e8dab8dda48eceff6afea67d0fe4a14b8d4ea7191cf233c1e1af8a62f37c24"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    on_intel do
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.3/actionlint_1.7.3_linux_amd64.tar.gz"
        sha256 "37252b4d440b56374b0fc1726e05fd7452d30d6d774f6e9b52e65bb64475f9db"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    on_arm do
      if !Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.3/actionlint_1.7.3_linux_armv6.tar.gz"
        sha256 "fb57cd56cbce9f2c1751275fc4f4add1780dbf33273b0fe6a8b7abbc15f751a1"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    on_arm do
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.3/actionlint_1.7.3_linux_arm64.tar.gz"
        sha256 "5fd82142c39208bfdc51b929ff9bd84c38bcc10b4362ef2261a5d70d38e68e05"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
