# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.22"
  license "MIT"

  on_macos do
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.22/actionlint_1.6.22_darwin_arm64.tar.gz"
      sha256 "cb6c1b2baaf275aa4c61a5163e8734d11d3066eea84f792545e45dbd84701049"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.22/actionlint_1.6.22_darwin_amd64.tar.gz"
      sha256 "6a1a522521e2fa0351328c439a63fc1c51611d45fc8156af15ad8690165f27c3"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.22/actionlint_1.6.22_linux_armv6.tar.gz"
      sha256 "6fb0ab3dbf2f3448f1096bd01c884186070899555dbe5b0a12c94203618e7217"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.22/actionlint_1.6.22_linux_amd64.tar.gz"
      sha256 "7d7a3061b59718728788e75e6a177c621a31a683ffd21fedeabc1296fc2ee289"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.22/actionlint_1.6.22_linux_arm64.tar.gz"
      sha256 "dc1920ba4d82eb724c3a02afc6db2efff8efed9a2f4f57496e35a0c7922a5573"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
