# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.18"
  license "MIT"

  on_macos do
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.18/actionlint_1.6.18_darwin_arm64.tar.gz"
      sha256 "df1e430fd5e16f312c96ea791927ca59645ae0a64c54615406b229a1534d2af7"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.18/actionlint_1.6.18_darwin_amd64.tar.gz"
      sha256 "a4bb46f60f169892a5d15a7f599ee82c9a3f34d8e3bae0254de02ae683e9e3c2"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.18/actionlint_1.6.18_linux_armv6.tar.gz"
      sha256 "24678fec5a849c98fe4ac4aabd80569a07e855982e8f5a2cad8b8457423fff63"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.18/actionlint_1.6.18_linux_amd64.tar.gz"
      sha256 "4b852eb02a7baac8c04f3b20304d2b98e6d6a2e411152f0e4a7c7ed924247fc7"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.18/actionlint_1.6.18_linux_arm64.tar.gz"
      sha256 "5aa77fcc2ba7ab6948f7e749f0060b4f20a4fdf19cb4a810794a5fb26c2d0811"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
