# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.13"
  license "MIT"

  on_macos do
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.13/actionlint_1.6.13_darwin_amd64.tar.gz"
      sha256 "3ce46db92615011ff0bbd7f7c03bd7e3d57cfd9ef42401e7c1e5ba0ab6ed2ecc"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.13/actionlint_1.6.13_darwin_arm64.tar.gz"
      sha256 "337aec36614c6a9fc1273ebed03bdb29f8389d72a5a6ac2cfc338881f34361f1"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.13/actionlint_1.6.13_linux_arm64.tar.gz"
      sha256 "c7cb0f7d984bb39c1f52cb6131d766d198d20601b934d80279a4a8d59e119839"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.13/actionlint_1.6.13_linux_amd64.tar.gz"
      sha256 "6c4b8928bf44c54817adbd603c2bb880b9bcb90d1fcde69a96b5306120c702b7"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.13/actionlint_1.6.13_linux_armv6.tar.gz"
      sha256 "28468c69bf31f933e7d58a7ea1c6b8fe73e42377a54a2c83a71573ed42f2319b"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
