# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.6.11"
  license "MIT"

  on_macos do
    if Hardware::CPU.arm?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.11/actionlint_1.6.11_darwin_arm64.tar.gz"
      sha256 "ab030a3e7ddfff94a0816d1cfb09423f5b4d184cec1d7782edd4de13856d00f6"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.11/actionlint_1.6.11_darwin_amd64.tar.gz"
      sha256 "c367a7324ca6f2d50196516711f5923bcf84306d936c7cd4fad0093999efe0d4"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.11/actionlint_1.6.11_linux_arm64.tar.gz"
      sha256 "e9daa5901f05b552488bc9c020118cd872c72b5c75f47c66898b4835516fd2d7"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.11/actionlint_1.6.11_linux_armv6.tar.gz"
      sha256 "bb9f733d3aa628b68bb22e36ae0d9229bc26a57c7b349522ec300cc0c4775cc9"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    if Hardware::CPU.intel?
      url "https://github.com/rhysd/actionlint/releases/download/v1.6.11/actionlint_1.6.11_linux_amd64.tar.gz"
      sha256 "67d7078dd47383a12e4f26288e0e140e6cd0c59e6fa576d29b741fee4659a581"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
