---
title: FAQ
---

### Where can I get help?

There are several ways you can get help from the community and Acorn's maintainers:

- For bugs or feature requests, open an issue [here](https://github.com/acorn-io/acorn/issues/new)
- For questions or discussions, visit our [forum](https://github.com/acorn-io/acorn/discussions)
- To reach out to and interact with the rest of the community, [join our Slack](https://slack.acorn.io)

### How can I report a security issue?

Please see our [security docs](/architecture/security-considerations).

### How can I troubleshoot issues with the Acorn control plane?

First, check that the Acorn control plane pods are running on the cluster. Using a tool like `kubectl` you can run:

```bash
kubectl get deploy -n acorn-system
```

To gather more information, you can view the Acorn control plane logs by running:

```bash
kubectl logs -n acorn-system -f -l app=acorn-api

- and - 

kubectl logs -n acorn-system -f -l app=acorn-controller
```

#### Does Acorn support CustomResourceDefinitions (CRDs)?

CRD support is a commonly requested feature and we are thinking hard about how and whether we can support this. We recognize CRDs' value and prominence in the Kubernetes ecosystem, but because every CRD has its own unique impact and lifecycle, Acorn cannot reliably and predictably manage CustomResources generically. We are investigating different approaches and solutions.

If you have a specific CRD use-case, please share it [here](https://github.com/acorn-io/acorn/issues/329).

#### What is an Acorn image? Are you bundling and duplicating the container images I reference in my Acornfile?

Acorn images leverage existing container image standards and functionality. A normal [OCI container image](https://github.com/opencontainers/image-spec/blob/main/spec.md) is a collection of layers stored in a OCI registry and linked together with an image manifest. An Acorn image is just that as well.  It is an OCI index that has references to the Acorn metadata manifest and existing container image manifests. Its manifest references existing image manifests in the registry by digest.

There is no duplication of content in the registry as all the existing image digests do not change (by design). The only time content is duplicated is if a referenced image is in a different OCI registry than the one you are pushing the Acorn to.  This is by design and viewed as a feature.  This keeps all content specific to your app in one registry so that you don't have to deal with multiple registry auth and proxy issue at deployment.  Also this model ensures your app will stay fully intact even if an image is deleted or a tag is changed.

#### I deployed an Acorn app and the endpoint says "pending". What's broken?

If the endpoint is HTTP/HTTPS, you either don't have an ingress controller or it isn't set up properly. If you are sure your ingress controller is functioning properly, it may not be set as the default for your cluster and you need to tell Acorn to use it as part of the install command:

```shell
acorn install --ingress-class-name nginx
```

"nginx" is just an example in this case. Your actual ingress class name may vary.

If the endpoint is non-HTTP, like TCP, your cluster needs the ability to support [services of type LoadBalancer](https://kubernetes.io/docs/concepts/services-networking/service/#loadbalancer).

#### I am hitting rate limits from DockerHub

If you are experiencing rate limiting issues from DockerHub, you can log in to your account to increase the number of requests.

```yaml
apiVersion: v1
kind: Secret
metadata:
  name: index.docker.io
  labels:
    acorn.io/credential: "true"
type: acorn.io/credential
data:
  username: # base64-encoded username
  password: # base64-encoded password
  serverAddress: # base64-encoded "index.docker.io"
```

```shell
#apply yaml to the acorn-image-system namespace
kubectl apply -f dockersecret.yaml -n acorn-image-system

#verify secret was created
kubectl get secrets -n acorn-image-system

#acorn build/push/pull will now use these credentials
```

