---
title: "acorn"
---
## acorn



### Synopsis

Acorn: Containerized Application Packaging Framework

```
acorn [flags]
```

### Options

```
  -A, --all-namespaces      Namespace to work in
      --context string      Context to use in the kubeconfig file
      --debug               Enable debug logging
      --debug-level int     Debug log level (valid 0-9) (default 7)
  -h, --help                help for acorn
      --kubeconfig string   Location of a kubeconfig file
      --namespace string    Namespace to work in (default "acorn")
```

### SEE ALSO

* [acorn all](acorn_all.md)	 - List (almost) all objects
* [acorn app](acorn_app.md)	 - List or get apps
* [acorn build](acorn_build.md)	 - Build an app from a Acornfile file
* [acorn check](acorn_check.md)	 - Check if the cluster is ready for Acorn
* [acorn container](acorn_container.md)	 - Manage containers
* [acorn credential](acorn_credential.md)	 - Manage registry credentials
* [acorn exec](acorn_exec.md)	 - Run a command in a container
* [acorn image](acorn_image.md)	 - Manage images
* [acorn info](acorn_info.md)	 - Info about acorn installation
* [acorn install](acorn_install.md)	 - Install and configure acorn in the cluster
* [acorn login](acorn_login.md)	 - Add registry credentials
* [acorn logout](acorn_logout.md)	 - Remove registry credentials
* [acorn logs](acorn_logs.md)	 - Log all pods from app
* [acorn pull](acorn_pull.md)	 - Pull an image from a remote registry
* [acorn push](acorn_push.md)	 - Push an image to a remote registry
* [acorn render](acorn_render.md)	 - Evaluate and display an Acornfile with args
* [acorn rm](acorn_rm.md)	 - Delete an app, container, secret or volume
* [acorn run](acorn_run.md)	 - Run an app from an image or Acornfile
* [acorn secret](acorn_secret.md)	 - Manage secrets
* [acorn start](acorn_start.md)	 - Start an app
* [acorn stop](acorn_stop.md)	 - Stop an app
* [acorn tag](acorn_tag.md)	 - Tag an image
* [acorn uninstall](acorn_uninstall.md)	 - Uninstall acorn and associated resources
* [acorn update](acorn_update.md)	 - Update a deployed app
* [acorn volume](acorn_volume.md)	 - Manage volumes
* [acorn wait](acorn_wait.md)	 - Wait an app to be ready then exit with status code 0

