// Code generated by command: go run main.go -out ../../lsh256_amd64.s -stubs ../../lsh256_amd64_stubs.go -pkg lsh256. DO NOT EDIT.

//go:build amd64 && gc && !purego

#include "textflag.h"

DATA g_IV224<>+0(SB)/4, $0x068608d3
DATA g_IV224<>+4(SB)/4, $0x62d8f7a7
DATA g_IV224<>+8(SB)/4, $0xd76652ab
DATA g_IV224<>+12(SB)/4, $0x4c600a43
DATA g_IV224<>+16(SB)/4, $0xbdc40aa8
DATA g_IV224<>+20(SB)/4, $0x1eca0b68
DATA g_IV224<>+24(SB)/4, $0xda1a89be
DATA g_IV224<>+28(SB)/4, $0x3147d354
DATA g_IV224<>+32(SB)/4, $0x707eb4f9
DATA g_IV224<>+36(SB)/4, $0xf65b3862
DATA g_IV224<>+40(SB)/4, $0x6b0b2abe
DATA g_IV224<>+44(SB)/4, $0x56b8ec0a
DATA g_IV224<>+48(SB)/4, $0xcf237286
DATA g_IV224<>+52(SB)/4, $0xee0d1727
DATA g_IV224<>+56(SB)/4, $0x33636595
DATA g_IV224<>+60(SB)/4, $0x8bb8d05f
GLOBL g_IV224<>(SB), RODATA|NOPTR, $64

DATA g_IV256<>+0(SB)/4, $0x46a10f1f
DATA g_IV256<>+4(SB)/4, $0xfddce486
DATA g_IV256<>+8(SB)/4, $0xb41443a8
DATA g_IV256<>+12(SB)/4, $0x198e6b9d
DATA g_IV256<>+16(SB)/4, $0x3304388d
DATA g_IV256<>+20(SB)/4, $0xb0f5a3c7
DATA g_IV256<>+24(SB)/4, $0xb36061c4
DATA g_IV256<>+28(SB)/4, $0x7adbd553
DATA g_IV256<>+32(SB)/4, $0x105d5378
DATA g_IV256<>+36(SB)/4, $0x2f74de54
DATA g_IV256<>+40(SB)/4, $0x5c2f2d95
DATA g_IV256<>+44(SB)/4, $0xf2553fbe
DATA g_IV256<>+48(SB)/4, $0x8051357a
DATA g_IV256<>+52(SB)/4, $0x138668c8
DATA g_IV256<>+56(SB)/4, $0x47aa4484
DATA g_IV256<>+60(SB)/4, $0xe01afb41
GLOBL g_IV256<>(SB), RODATA|NOPTR, $64

DATA g_StepConstants<>+0(SB)/4, $0x917caf90
DATA g_StepConstants<>+4(SB)/4, $0x6c1b10a2
DATA g_StepConstants<>+8(SB)/4, $0x6f352943
DATA g_StepConstants<>+12(SB)/4, $0xcf778243
DATA g_StepConstants<>+16(SB)/4, $0x2ceb7472
DATA g_StepConstants<>+20(SB)/4, $0x29e96ff2
DATA g_StepConstants<>+24(SB)/4, $0x8a9ba428
DATA g_StepConstants<>+28(SB)/4, $0x2eeb2642
DATA g_StepConstants<>+32(SB)/4, $0x0e2c4021
DATA g_StepConstants<>+36(SB)/4, $0x872bb30e
DATA g_StepConstants<>+40(SB)/4, $0xa45e6cb2
DATA g_StepConstants<>+44(SB)/4, $0x46f9c612
DATA g_StepConstants<>+48(SB)/4, $0x185fe69e
DATA g_StepConstants<>+52(SB)/4, $0x1359621b
DATA g_StepConstants<>+56(SB)/4, $0x263fccb2
DATA g_StepConstants<>+60(SB)/4, $0x1a116870
DATA g_StepConstants<>+64(SB)/4, $0x3a6c612f
DATA g_StepConstants<>+68(SB)/4, $0xb2dec195
DATA g_StepConstants<>+72(SB)/4, $0x02cb1f56
DATA g_StepConstants<>+76(SB)/4, $0x40bfd858
DATA g_StepConstants<>+80(SB)/4, $0x784684b6
DATA g_StepConstants<>+84(SB)/4, $0x6cbb7d2e
DATA g_StepConstants<>+88(SB)/4, $0x660c7ed8
DATA g_StepConstants<>+92(SB)/4, $0x2b79d88a
DATA g_StepConstants<>+96(SB)/4, $0xa6cd9069
DATA g_StepConstants<>+100(SB)/4, $0x91a05747
DATA g_StepConstants<>+104(SB)/4, $0xcdea7558
DATA g_StepConstants<>+108(SB)/4, $0x00983098
DATA g_StepConstants<>+112(SB)/4, $0xbecb3b2e
DATA g_StepConstants<>+116(SB)/4, $0x2838ab9a
DATA g_StepConstants<>+120(SB)/4, $0x728b573e
DATA g_StepConstants<>+124(SB)/4, $0xa55262b5
DATA g_StepConstants<>+128(SB)/4, $0x745dfa0f
DATA g_StepConstants<>+132(SB)/4, $0x31f79ed8
DATA g_StepConstants<>+136(SB)/4, $0xb85fce25
DATA g_StepConstants<>+140(SB)/4, $0x98c8c898
DATA g_StepConstants<>+144(SB)/4, $0x8a0669ec
DATA g_StepConstants<>+148(SB)/4, $0x60e445c2
DATA g_StepConstants<>+152(SB)/4, $0xfde295b0
DATA g_StepConstants<>+156(SB)/4, $0xf7b5185a
DATA g_StepConstants<>+160(SB)/4, $0xd2580983
DATA g_StepConstants<>+164(SB)/4, $0x29967709
DATA g_StepConstants<>+168(SB)/4, $0x182df3dd
DATA g_StepConstants<>+172(SB)/4, $0x61916130
DATA g_StepConstants<>+176(SB)/4, $0x90705676
DATA g_StepConstants<>+180(SB)/4, $0x452a0822
DATA g_StepConstants<>+184(SB)/4, $0xe07846ad
DATA g_StepConstants<>+188(SB)/4, $0xaccd7351
DATA g_StepConstants<>+192(SB)/4, $0x2a618d55
DATA g_StepConstants<>+196(SB)/4, $0xc00d8032
DATA g_StepConstants<>+200(SB)/4, $0x4621d0f5
DATA g_StepConstants<>+204(SB)/4, $0xf2f29191
DATA g_StepConstants<>+208(SB)/4, $0x00c6cd06
DATA g_StepConstants<>+212(SB)/4, $0x6f322a67
DATA g_StepConstants<>+216(SB)/4, $0x58bef48d
DATA g_StepConstants<>+220(SB)/4, $0x7a40c4fd
DATA g_StepConstants<>+224(SB)/4, $0x8beee27f
DATA g_StepConstants<>+228(SB)/4, $0xcd8db2f2
DATA g_StepConstants<>+232(SB)/4, $0x67f2c63b
DATA g_StepConstants<>+236(SB)/4, $0xe5842383
DATA g_StepConstants<>+240(SB)/4, $0xc793d306
DATA g_StepConstants<>+244(SB)/4, $0xa15c91d6
DATA g_StepConstants<>+248(SB)/4, $0x17b381e5
DATA g_StepConstants<>+252(SB)/4, $0xbb05c277
DATA g_StepConstants<>+256(SB)/4, $0x7ad1620a
DATA g_StepConstants<>+260(SB)/4, $0x5b40a5bf
DATA g_StepConstants<>+264(SB)/4, $0x5ab901a2
DATA g_StepConstants<>+268(SB)/4, $0x69a7a768
DATA g_StepConstants<>+272(SB)/4, $0x5b66d9cd
DATA g_StepConstants<>+276(SB)/4, $0xfdee6877
DATA g_StepConstants<>+280(SB)/4, $0xcb3566fc
DATA g_StepConstants<>+284(SB)/4, $0xc0c83a32
DATA g_StepConstants<>+288(SB)/4, $0x4c336c84
DATA g_StepConstants<>+292(SB)/4, $0x9be6651a
DATA g_StepConstants<>+296(SB)/4, $0x13baa3fc
DATA g_StepConstants<>+300(SB)/4, $0x114f0fd1
DATA g_StepConstants<>+304(SB)/4, $0xc240a728
DATA g_StepConstants<>+308(SB)/4, $0xec56e074
DATA g_StepConstants<>+312(SB)/4, $0x009c63c7
DATA g_StepConstants<>+316(SB)/4, $0x89026cf2
DATA g_StepConstants<>+320(SB)/4, $0x7f9ff0d0
DATA g_StepConstants<>+324(SB)/4, $0x824b7fb5
DATA g_StepConstants<>+328(SB)/4, $0xce5ea00f
DATA g_StepConstants<>+332(SB)/4, $0x605ee0e2
DATA g_StepConstants<>+336(SB)/4, $0x02e7cfea
DATA g_StepConstants<>+340(SB)/4, $0x43375560
DATA g_StepConstants<>+344(SB)/4, $0x9d002ac7
DATA g_StepConstants<>+348(SB)/4, $0x8b6f5f7b
DATA g_StepConstants<>+352(SB)/4, $0x1f90c14f
DATA g_StepConstants<>+356(SB)/4, $0xcdcb3537
DATA g_StepConstants<>+360(SB)/4, $0x2cfeafdd
DATA g_StepConstants<>+364(SB)/4, $0xbf3fc342
DATA g_StepConstants<>+368(SB)/4, $0xeab7b9ec
DATA g_StepConstants<>+372(SB)/4, $0x7a8cb5a3
DATA g_StepConstants<>+376(SB)/4, $0x9d2af264
DATA g_StepConstants<>+380(SB)/4, $0xfacedb06
DATA g_StepConstants<>+384(SB)/4, $0xb052106e
DATA g_StepConstants<>+388(SB)/4, $0x99006d04
DATA g_StepConstants<>+392(SB)/4, $0x2bae8d09
DATA g_StepConstants<>+396(SB)/4, $0xff030601
DATA g_StepConstants<>+400(SB)/4, $0xa271a6d6
DATA g_StepConstants<>+404(SB)/4, $0x0742591d
DATA g_StepConstants<>+408(SB)/4, $0xc81d5701
DATA g_StepConstants<>+412(SB)/4, $0xc9a9e200
DATA g_StepConstants<>+416(SB)/4, $0x02627f1e
DATA g_StepConstants<>+420(SB)/4, $0x996d719d
DATA g_StepConstants<>+424(SB)/4, $0xda3b9634
DATA g_StepConstants<>+428(SB)/4, $0x02090800
DATA g_StepConstants<>+432(SB)/4, $0x14187d78
DATA g_StepConstants<>+436(SB)/4, $0x499b7624
DATA g_StepConstants<>+440(SB)/4, $0xe57458c9
DATA g_StepConstants<>+444(SB)/4, $0x738be2c9
DATA g_StepConstants<>+448(SB)/4, $0x64e19d20
DATA g_StepConstants<>+452(SB)/4, $0x06df0f36
DATA g_StepConstants<>+456(SB)/4, $0x15d1cb0e
DATA g_StepConstants<>+460(SB)/4, $0x0b110802
DATA g_StepConstants<>+464(SB)/4, $0x2c95f58c
DATA g_StepConstants<>+468(SB)/4, $0xe5119a6d
DATA g_StepConstants<>+472(SB)/4, $0x59cd22ae
DATA g_StepConstants<>+476(SB)/4, $0xff6eac3c
DATA g_StepConstants<>+480(SB)/4, $0x467ebd84
DATA g_StepConstants<>+484(SB)/4, $0xe5ee453c
DATA g_StepConstants<>+488(SB)/4, $0xe79cd923
DATA g_StepConstants<>+492(SB)/4, $0x1c190a0d
DATA g_StepConstants<>+496(SB)/4, $0xc28b81b8
DATA g_StepConstants<>+500(SB)/4, $0xf6ac0852
DATA g_StepConstants<>+504(SB)/4, $0x26efd107
DATA g_StepConstants<>+508(SB)/4, $0x6e1ae93b
DATA g_StepConstants<>+512(SB)/4, $0xc53c41ca
DATA g_StepConstants<>+516(SB)/4, $0xd4338221
DATA g_StepConstants<>+520(SB)/4, $0x8475fd0a
DATA g_StepConstants<>+524(SB)/4, $0x35231729
DATA g_StepConstants<>+528(SB)/4, $0x4e0d3a7a
DATA g_StepConstants<>+532(SB)/4, $0xa2b45b48
DATA g_StepConstants<>+536(SB)/4, $0x16c0d82d
DATA g_StepConstants<>+540(SB)/4, $0x890424a9
DATA g_StepConstants<>+544(SB)/4, $0x017e0c8f
DATA g_StepConstants<>+548(SB)/4, $0x07b5a3f5
DATA g_StepConstants<>+552(SB)/4, $0xfa73078e
DATA g_StepConstants<>+556(SB)/4, $0x583a405e
DATA g_StepConstants<>+560(SB)/4, $0x5b47b4c8
DATA g_StepConstants<>+564(SB)/4, $0x570fa3ea
DATA g_StepConstants<>+568(SB)/4, $0xd7990543
DATA g_StepConstants<>+572(SB)/4, $0x8d28ce32
DATA g_StepConstants<>+576(SB)/4, $0x7f8a9b90
DATA g_StepConstants<>+580(SB)/4, $0xbd5998fc
DATA g_StepConstants<>+584(SB)/4, $0x6d7a9688
DATA g_StepConstants<>+588(SB)/4, $0x927a9eb6
DATA g_StepConstants<>+592(SB)/4, $0xa2fc7d23
DATA g_StepConstants<>+596(SB)/4, $0x66b38e41
DATA g_StepConstants<>+600(SB)/4, $0x709e491a
DATA g_StepConstants<>+604(SB)/4, $0xb5f700bf
DATA g_StepConstants<>+608(SB)/4, $0x0a262c0f
DATA g_StepConstants<>+612(SB)/4, $0x16f295b9
DATA g_StepConstants<>+616(SB)/4, $0xe8111ef5
DATA g_StepConstants<>+620(SB)/4, $0x0d195548
DATA g_StepConstants<>+624(SB)/4, $0x9f79a0c5
DATA g_StepConstants<>+628(SB)/4, $0x1a41cfa7
DATA g_StepConstants<>+632(SB)/4, $0x0ee7638a
DATA g_StepConstants<>+636(SB)/4, $0xacf7c074
DATA g_StepConstants<>+640(SB)/4, $0x30523b19
DATA g_StepConstants<>+644(SB)/4, $0x09884ecf
DATA g_StepConstants<>+648(SB)/4, $0xf93014dd
DATA g_StepConstants<>+652(SB)/4, $0x266e9d55
DATA g_StepConstants<>+656(SB)/4, $0x191a6664
DATA g_StepConstants<>+660(SB)/4, $0x5c1176c1
DATA g_StepConstants<>+664(SB)/4, $0xf64aed98
DATA g_StepConstants<>+668(SB)/4, $0xa4b83520
DATA g_StepConstants<>+672(SB)/4, $0x828d5449
DATA g_StepConstants<>+676(SB)/4, $0x91d71dd8
DATA g_StepConstants<>+680(SB)/4, $0x2944f2d6
DATA g_StepConstants<>+684(SB)/4, $0x950bf27b
DATA g_StepConstants<>+688(SB)/4, $0x3380ca7d
DATA g_StepConstants<>+692(SB)/4, $0x6d88381d
DATA g_StepConstants<>+696(SB)/4, $0x4138868e
DATA g_StepConstants<>+700(SB)/4, $0x5ced55c4
DATA g_StepConstants<>+704(SB)/4, $0x0fe19dcb
DATA g_StepConstants<>+708(SB)/4, $0x68f4f669
DATA g_StepConstants<>+712(SB)/4, $0x6e37c8ff
DATA g_StepConstants<>+716(SB)/4, $0xa0fe6e10
DATA g_StepConstants<>+720(SB)/4, $0xb44b47b0
DATA g_StepConstants<>+724(SB)/4, $0xf5c0558a
DATA g_StepConstants<>+728(SB)/4, $0x79bf14cf
DATA g_StepConstants<>+732(SB)/4, $0x4a431a20
DATA g_StepConstants<>+736(SB)/4, $0xf17f68da
DATA g_StepConstants<>+740(SB)/4, $0x5deb5fd1
DATA g_StepConstants<>+744(SB)/4, $0xa600c86d
DATA g_StepConstants<>+748(SB)/4, $0x9f6c7eb0
DATA g_StepConstants<>+752(SB)/4, $0xff92f864
DATA g_StepConstants<>+756(SB)/4, $0xb615e07f
DATA g_StepConstants<>+760(SB)/4, $0x38d3e448
DATA g_StepConstants<>+764(SB)/4, $0x8d5d3a6a
DATA g_StepConstants<>+768(SB)/4, $0x70e843cb
DATA g_StepConstants<>+772(SB)/4, $0x494b312e
DATA g_StepConstants<>+776(SB)/4, $0xa6c93613
DATA g_StepConstants<>+780(SB)/4, $0x0beb2f4f
DATA g_StepConstants<>+784(SB)/4, $0x928b5d63
DATA g_StepConstants<>+788(SB)/4, $0xcbf66035
DATA g_StepConstants<>+792(SB)/4, $0x0cb82c80
DATA g_StepConstants<>+796(SB)/4, $0xea97a4f7
DATA g_StepConstants<>+800(SB)/4, $0x592c0f3b
DATA g_StepConstants<>+804(SB)/4, $0x947c5f77
DATA g_StepConstants<>+808(SB)/4, $0x6fff49b9
DATA g_StepConstants<>+812(SB)/4, $0xf71a7e5a
DATA g_StepConstants<>+816(SB)/4, $0x1de8c0f5
DATA g_StepConstants<>+820(SB)/4, $0xc2569600
DATA g_StepConstants<>+824(SB)/4, $0xc4e4ac8c
DATA g_StepConstants<>+828(SB)/4, $0x823c9ce1
GLOBL g_StepConstants<>(SB), RODATA|NOPTR, $832

DATA g_BytePermInfo_avx2<>+0(SB)/4, $0x03020100
DATA g_BytePermInfo_avx2<>+4(SB)/4, $0x06050407
DATA g_BytePermInfo_avx2<>+8(SB)/4, $0x09080b0a
DATA g_BytePermInfo_avx2<>+12(SB)/4, $0x0c0f0e0d
DATA g_BytePermInfo_avx2<>+16(SB)/4, $0x10131211
DATA g_BytePermInfo_avx2<>+20(SB)/4, $0x15141716
DATA g_BytePermInfo_avx2<>+24(SB)/4, $0x1a19181b
DATA g_BytePermInfo_avx2<>+28(SB)/4, $0x1f1e1d1c
GLOBL g_BytePermInfo_avx2<>(SB), RODATA|NOPTR, $32

DATA g_MsgWordPermInfo_avx2<>+0(SB)/4, $0x0f0e0d0c
DATA g_MsgWordPermInfo_avx2<>+4(SB)/4, $0x0b0a0908
DATA g_MsgWordPermInfo_avx2<>+8(SB)/4, $0x03020100
DATA g_MsgWordPermInfo_avx2<>+12(SB)/4, $0x07060504
DATA g_MsgWordPermInfo_avx2<>+16(SB)/4, $0x1f1e1d1c
DATA g_MsgWordPermInfo_avx2<>+20(SB)/4, $0x13121110
DATA g_MsgWordPermInfo_avx2<>+24(SB)/4, $0x17161514
DATA g_MsgWordPermInfo_avx2<>+28(SB)/4, $0x1b1a1918
GLOBL g_MsgWordPermInfo_avx2<>(SB), RODATA|NOPTR, $32

DATA g_BytePermInfo_sse2<>+0(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+4(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+8(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+12(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+16(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+20(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+24(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+28(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+32(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+36(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+40(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+44(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+48(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+52(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+56(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+60(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+64(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+68(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+72(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+76(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+80(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+84(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+88(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+92(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+96(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+100(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+104(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+108(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+112(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+116(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+120(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+124(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+128(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+132(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+136(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+140(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+144(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+148(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+152(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+156(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+160(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+164(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+168(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+172(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+176(SB)/4, $0x00000000
DATA g_BytePermInfo_sse2<>+180(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+184(SB)/4, $0xffffffff
DATA g_BytePermInfo_sse2<>+188(SB)/4, $0xffffffff
GLOBL g_BytePermInfo_sse2<>(SB), RODATA|NOPTR, $192

DATA g_BytePermInfo_ssse3<>+0(SB)/4, $0x03020100
DATA g_BytePermInfo_ssse3<>+4(SB)/4, $0x06050407
DATA g_BytePermInfo_ssse3<>+8(SB)/4, $0x09080b0a
DATA g_BytePermInfo_ssse3<>+12(SB)/4, $0x0c0f0e0d
DATA g_BytePermInfo_ssse3<>+16(SB)/4, $0x00030201
DATA g_BytePermInfo_ssse3<>+20(SB)/4, $0x05040706
DATA g_BytePermInfo_ssse3<>+24(SB)/4, $0x0a09080b
DATA g_BytePermInfo_ssse3<>+28(SB)/4, $0x0f0e0d0c
GLOBL g_BytePermInfo_ssse3<>(SB), RODATA|NOPTR, $32

// func lsh256InitSSE2(ctx *lsh256ContextAsmData)
// Requires: SSE2
TEXT ·lsh256InitSSE2(SB), NOSPLIT, $0-8
	MOVQ ctx+0(FP), AX
	MOVL (AX), CX
	MOVQ 8(AX), DX

	// lsh256_sse2_init
	CMPL CX, $0x00000020
	JNE  lsh256_sse2_init_if0_end

	// init256
	// load_blk_mem2mem
	// MemcpyStatic
	MOVOA g_IV256<>+0(SB), X0
	MOVOU X0, 16(AX)
	MOVOA g_IV256<>+16(SB), X0
	MOVOU X0, 32(AX)

	// load_blk_mem2mem
	// MemcpyStatic
	MOVOA g_IV256<>+32(SB), X0
	MOVOU X0, 48(AX)
	MOVOA g_IV256<>+48(SB), X0
	MOVOU X0, 64(AX)
	JMP   lsh256_sse2_init_ret

lsh256_sse2_init_if0_end:
	// init224
	// load_blk_mem2mem
	// MemcpyStatic
	MOVOA g_IV224<>+0(SB), X0
	MOVOU X0, 16(AX)
	MOVOA g_IV224<>+16(SB), X0
	MOVOU X0, 32(AX)

	// load_blk_mem2mem
	// MemcpyStatic
	MOVOA g_IV224<>+32(SB), X0
	MOVOU X0, 48(AX)
	MOVOA g_IV224<>+48(SB), X0
	MOVOU X0, 64(AX)

lsh256_sse2_init_ret:
	MOVQ ctx+0(FP), AX
	MOVQ DX, 8(AX)
	RET

// func lsh256UpdateSSE2(ctx *lsh256ContextAsmData, data []byte)
// Requires: SSE2
TEXT ·lsh256UpdateSSE2(SB), NOSPLIT, $0-32
	MOVQ ctx+0(FP), AX
	MOVL (AX), CX
	MOVQ 8(AX), CX
	MOVQ data_base+8(FP), DX
	MOVQ data_len+16(FP), BX

	// lsh256_sse2_update
	MOVQ CX, SI
	MOVQ BX, DI
	ADDQ SI, DI
	CMPQ DI, $0x00000080
	JGE  lsh256_sse2_update_if0_end

	// Memcpy
	LEAQ 80(AX)(SI*1), AX
	LEAQ (DX), SI
	MOVQ BX, DI

memcpy_1_sz16_start:
	CMPQ  DI, $0x00000010
	JL    memcpy_1_sz16_end
	MOVOU (SI), X0
	MOVOU X0, (AX)
	ADDQ  $0x00000010, SI
	ADDQ  $0x00000010, AX
	SUBQ  $0x00000010, DI
	JMP   memcpy_1_sz16_start

memcpy_1_sz16_end:
memcpy_1_sz8_start:
	CMPQ DI, $0x00000008
	JL   memcpy_1_sz8_end
	MOVQ (SI), DX
	MOVQ DX, (AX)
	ADDQ $0x00000008, SI
	ADDQ $0x00000008, AX
	SUBQ $0x00000008, DI
	JMP  memcpy_1_sz8_start

memcpy_1_sz8_end:
memcpy_1_sz4_start:
	CMPQ DI, $0x00000004
	JL   memcpy_1_sz4_end
	MOVL (SI), DX
	MOVL DX, (AX)
	ADDQ $0x00000004, SI
	ADDQ $0x00000004, AX
	SUBQ $0x00000004, DI
	JMP  memcpy_1_sz4_start

memcpy_1_sz4_end:
memcpy_1_sz2_start:
	CMPQ DI, $0x00000002
	JL   memcpy_1_sz2_end
	MOVW (SI), DX
	MOVW DX, (AX)
	ADDQ $0x00000002, SI
	ADDQ $0x00000002, AX
	SUBQ $0x00000002, DI
	JMP  memcpy_1_sz2_start

memcpy_1_sz2_end:
memcpy_1_sz1_start:
	CMPQ DI, $0x00000001
	JL   memcpy_1_sz1_end
	MOVB (SI), DL
	MOVB DL, (AX)
	ADDQ $0x00000001, SI
	ADDQ $0x00000001, AX
	SUBQ $0x00000001, DI
	JMP  memcpy_1_sz1_start

memcpy_1_sz1_end:
	ADDQ BX, CX
	JMP  lsh256_sse2_update_ret

lsh256_sse2_update_if0_end:
	// load_blk_mem2vec
	MOVOU 16(AX), X0
	MOVOU 32(AX), X1

	// load_blk_mem2vec
	MOVOU 48(AX), X2
	MOVOU 64(AX), X3
	CMPQ  SI, $0x00000000
	JE    lsh256_sse2_update_if2_end
	MOVQ  $0x00000080, CX
	SUBQ  SI, CX

	// Memcpy
	LEAQ 80(AX)(SI*1), DI
	LEAQ (DX), R8
	MOVQ CX, R9

memcpy_2_sz16_start:
	CMPQ  R9, $0x00000010
	JL    memcpy_2_sz16_end
	MOVOU (R8), X4
	MOVOU X4, (DI)
	ADDQ  $0x00000010, R8
	ADDQ  $0x00000010, DI
	SUBQ  $0x00000010, R9
	JMP   memcpy_2_sz16_start

memcpy_2_sz16_end:
memcpy_2_sz8_start:
	CMPQ R9, $0x00000008
	JL   memcpy_2_sz8_end
	MOVQ (R8), SI
	MOVQ SI, (DI)
	ADDQ $0x00000008, R8
	ADDQ $0x00000008, DI
	SUBQ $0x00000008, R9
	JMP  memcpy_2_sz8_start

memcpy_2_sz8_end:
memcpy_2_sz4_start:
	CMPQ R9, $0x00000004
	JL   memcpy_2_sz4_end
	MOVL (R8), SI
	MOVL SI, (DI)
	ADDQ $0x00000004, R8
	ADDQ $0x00000004, DI
	SUBQ $0x00000004, R9
	JMP  memcpy_2_sz4_start

memcpy_2_sz4_end:
memcpy_2_sz2_start:
	CMPQ R9, $0x00000002
	JL   memcpy_2_sz2_end
	MOVW (R8), SI
	MOVW SI, (DI)
	ADDQ $0x00000002, R8
	ADDQ $0x00000002, DI
	SUBQ $0x00000002, R9
	JMP  memcpy_2_sz2_start

memcpy_2_sz2_end:
memcpy_2_sz1_start:
	CMPQ R9, $0x00000001
	JL   memcpy_2_sz1_end
	MOVB (R8), SI
	MOVB SI, (DI)
	ADDQ $0x00000001, R8
	ADDQ $0x00000001, DI
	SUBQ $0x00000001, R9
	JMP  memcpy_2_sz1_start

memcpy_2_sz1_end:
	// compress
	// load_msg_blk
	// load_blk_mem2vec
	MOVOU 80(AX), X6
	MOVOU 96(AX), X7

	// load_blk_mem2vec
	MOVOU 112(AX), X8
	MOVOU 128(AX), X9

	// load_blk_mem2vec
	MOVOU 144(AX), X10
	MOVOU 160(AX), X11

	// load_blk_mem2vec
	MOVOU 176(AX), X12
	MOVOU 192(AX), X13

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+0(SB), X4
	MOVOA g_StepConstants<>+16(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+32(SB), X4
	MOVOA g_StepConstants<>+48(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+64(SB), X4
	MOVOA g_StepConstants<>+80(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+96(SB), X4
	MOVOA g_StepConstants<>+112(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+128(SB), X4
	MOVOA g_StepConstants<>+144(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+160(SB), X4
	MOVOA g_StepConstants<>+176(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+192(SB), X4
	MOVOA g_StepConstants<>+208(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+224(SB), X4
	MOVOA g_StepConstants<>+240(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+256(SB), X4
	MOVOA g_StepConstants<>+272(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+288(SB), X4
	MOVOA g_StepConstants<>+304(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+320(SB), X4
	MOVOA g_StepConstants<>+336(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+352(SB), X4
	MOVOA g_StepConstants<>+368(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+384(SB), X4
	MOVOA g_StepConstants<>+400(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+416(SB), X4
	MOVOA g_StepConstants<>+432(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+448(SB), X4
	MOVOA g_StepConstants<>+464(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+480(SB), X4
	MOVOA g_StepConstants<>+496(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+512(SB), X4
	MOVOA g_StepConstants<>+528(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+544(SB), X4
	MOVOA g_StepConstants<>+560(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+576(SB), X4
	MOVOA g_StepConstants<>+592(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+608(SB), X4
	MOVOA g_StepConstants<>+624(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+640(SB), X4
	MOVOA g_StepConstants<>+656(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+672(SB), X4
	MOVOA g_StepConstants<>+688(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+704(SB), X4
	MOVOA g_StepConstants<>+720(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+736(SB), X4
	MOVOA g_StepConstants<>+752(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+768(SB), X4
	MOVOA g_StepConstants<>+784(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+800(SB), X4
	MOVOA g_StepConstants<>+816(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3
	ADDQ CX, DX
	SUBQ CX, BX
	MOVQ $0x00000000, SI
	MOVQ $0x00000000, CX

lsh256_sse2_update_if2_end:
lsh256_sse2_update_while_start:
	CMPQ BX, $0x00000080
	JL   lsh256_sse2_update_while_end

	// compress
	// load_msg_blk
	// load_blk_mem2vec
	MOVOU (DX), X6
	MOVOU 16(DX), X7

	// load_blk_mem2vec
	MOVOU 32(DX), X8
	MOVOU 48(DX), X9

	// load_blk_mem2vec
	MOVOU 64(DX), X10
	MOVOU 80(DX), X11

	// load_blk_mem2vec
	MOVOU 96(DX), X12
	MOVOU 112(DX), X13

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+0(SB), X4
	MOVOA g_StepConstants<>+16(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+32(SB), X4
	MOVOA g_StepConstants<>+48(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+64(SB), X4
	MOVOA g_StepConstants<>+80(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+96(SB), X4
	MOVOA g_StepConstants<>+112(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+128(SB), X4
	MOVOA g_StepConstants<>+144(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+160(SB), X4
	MOVOA g_StepConstants<>+176(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+192(SB), X4
	MOVOA g_StepConstants<>+208(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+224(SB), X4
	MOVOA g_StepConstants<>+240(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+256(SB), X4
	MOVOA g_StepConstants<>+272(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+288(SB), X4
	MOVOA g_StepConstants<>+304(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+320(SB), X4
	MOVOA g_StepConstants<>+336(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+352(SB), X4
	MOVOA g_StepConstants<>+368(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+384(SB), X4
	MOVOA g_StepConstants<>+400(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+416(SB), X4
	MOVOA g_StepConstants<>+432(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+448(SB), X4
	MOVOA g_StepConstants<>+464(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+480(SB), X4
	MOVOA g_StepConstants<>+496(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+512(SB), X4
	MOVOA g_StepConstants<>+528(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+544(SB), X4
	MOVOA g_StepConstants<>+560(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+576(SB), X4
	MOVOA g_StepConstants<>+592(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+608(SB), X4
	MOVOA g_StepConstants<>+624(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+640(SB), X4
	MOVOA g_StepConstants<>+656(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+672(SB), X4
	MOVOA g_StepConstants<>+688(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+704(SB), X4
	MOVOA g_StepConstants<>+720(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+736(SB), X4
	MOVOA g_StepConstants<>+752(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+768(SB), X4
	MOVOA g_StepConstants<>+784(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+800(SB), X4
	MOVOA g_StepConstants<>+816(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3
	ADDQ $0x00000080, DX
	SUBQ $0x00000080, BX
	JMP  lsh256_sse2_update_while_start

lsh256_sse2_update_while_end:
	// store_blk
	MOVOU X0, 16(AX)
	MOVOU X1, 32(AX)

	// store_blk
	MOVOU X2, 48(AX)
	MOVOU X3, 64(AX)
	CMPQ  BX, $0x00000000
	JE    lsh256_sse2_update_if3_end

	// Memcpy
	LEAQ 80(AX), AX
	LEAQ (DX), DX
	MOVQ BX, SI

memcpy_3_sz16_start:
	CMPQ  SI, $0x00000010
	JL    memcpy_3_sz16_end
	MOVOU (DX), X0
	MOVOU X0, (AX)
	ADDQ  $0x00000010, DX
	ADDQ  $0x00000010, AX
	SUBQ  $0x00000010, SI
	JMP   memcpy_3_sz16_start

memcpy_3_sz16_end:
memcpy_3_sz8_start:
	CMPQ SI, $0x00000008
	JL   memcpy_3_sz8_end
	MOVQ (DX), CX
	MOVQ CX, (AX)
	ADDQ $0x00000008, DX
	ADDQ $0x00000008, AX
	SUBQ $0x00000008, SI
	JMP  memcpy_3_sz8_start

memcpy_3_sz8_end:
memcpy_3_sz4_start:
	CMPQ SI, $0x00000004
	JL   memcpy_3_sz4_end
	MOVL (DX), CX
	MOVL CX, (AX)
	ADDQ $0x00000004, DX
	ADDQ $0x00000004, AX
	SUBQ $0x00000004, SI
	JMP  memcpy_3_sz4_start

memcpy_3_sz4_end:
memcpy_3_sz2_start:
	CMPQ SI, $0x00000002
	JL   memcpy_3_sz2_end
	MOVW (DX), CX
	MOVW CX, (AX)
	ADDQ $0x00000002, DX
	ADDQ $0x00000002, AX
	SUBQ $0x00000002, SI
	JMP  memcpy_3_sz2_start

memcpy_3_sz2_end:
memcpy_3_sz1_start:
	CMPQ SI, $0x00000001
	JL   memcpy_3_sz1_end
	MOVB (DX), CL
	MOVB CL, (AX)
	ADDQ $0x00000001, DX
	ADDQ $0x00000001, AX
	SUBQ $0x00000001, SI
	JMP  memcpy_3_sz1_start

memcpy_3_sz1_end:
	MOVQ BX, CX

lsh256_sse2_update_if3_end:
lsh256_sse2_update_ret:
	MOVQ ctx+0(FP), AX
	MOVQ CX, 8(AX)
	RET

// func lsh256FinalSSE2(ctx *lsh256ContextAsmData, hashval []byte)
// Requires: SSE2
TEXT ·lsh256FinalSSE2(SB), NOSPLIT, $0-32
	MOVQ ctx+0(FP), AX
	MOVL (AX), CX
	MOVQ 8(AX), CX
	MOVQ hashval_base+8(FP), DX

	// lsh256_sse2_final
	MOVQ CX, BX
	MOVB $0x80, 80(AX)(BX*1)
	MOVQ $0x0000007f, SI
	SUBQ BX, SI

	// memset
	LEAQ 81(AX)(BX*1), BX
	CMPQ SI, $0x00000010
	JL   memset_1_sz16_end
	MOVO memset_value_0<>+0(SB), X0

memset_1_sz16_start:
	MOVOU X0, (BX)
	SUBQ  $0x00000010, SI
	ADDQ  $0x00000010, BX
	CMPQ  SI, $0x00000010
	JL    memset_1_sz16_end
	JMP   memset_1_sz16_start

memset_1_sz16_end:
	CMPQ SI, $0x00000008
	JL   memset_1_sz8_end
	MOVQ memset_value_0<>+0(SB), DI

memset_1_sz8_start:
	MOVQ DI, (BX)
	SUBQ $0x00000008, SI
	ADDQ $0x00000008, BX
	CMPQ SI, $0x00000008
	JL   memset_1_sz8_end
	JMP  memset_1_sz8_start

memset_1_sz8_end:
	CMPQ SI, $0x00000004
	JL   memset_1_sz4_end
	MOVL memset_value_0<>+0(SB), DI

memset_1_sz4_start:
	MOVL DI, (BX)
	SUBQ $0x00000004, SI
	ADDQ $0x00000004, BX
	CMPQ SI, $0x00000004
	JL   memset_1_sz4_end
	JMP  memset_1_sz4_start

memset_1_sz4_end:
	CMPQ SI, $0x00000002
	JL   memset_1_sz2_end
	MOVW memset_value_0<>+0(SB), DI

memset_1_sz2_start:
	MOVW DI, (BX)
	SUBQ $0x00000002, SI
	ADDQ $0x00000002, BX
	CMPQ SI, $0x00000002
	JL   memset_1_sz2_end
	JMP  memset_1_sz2_start

memset_1_sz2_end:
memset_1_1_start:
	CMPQ SI, $0x00000000
	JE   memset_1_1_end
	MOVB $0x00, (BX)
	SUBQ $0x00000001, SI
	ADDQ $0x00000001, BX
	JMP  memset_1_1_start

memset_1_1_end:
	// load_blk_mem2vec
	MOVOU 16(AX), X0
	MOVOU 32(AX), X1

	// load_blk_mem2vec
	MOVOU 48(AX), X2
	MOVOU 64(AX), X3

	// compress
	// load_msg_blk
	// load_blk_mem2vec
	MOVOU 80(AX), X6
	MOVOU 96(AX), X7

	// load_blk_mem2vec
	MOVOU 112(AX), X8
	MOVOU 128(AX), X9

	// load_blk_mem2vec
	MOVOU 144(AX), X10
	MOVOU 160(AX), X11

	// load_blk_mem2vec
	MOVOU 176(AX), X12
	MOVOU 192(AX), X13

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+0(SB), X4
	MOVOA g_StepConstants<>+16(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+32(SB), X4
	MOVOA g_StepConstants<>+48(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+64(SB), X4
	MOVOA g_StepConstants<>+80(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+96(SB), X4
	MOVOA g_StepConstants<>+112(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+128(SB), X4
	MOVOA g_StepConstants<>+144(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+160(SB), X4
	MOVOA g_StepConstants<>+176(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+192(SB), X4
	MOVOA g_StepConstants<>+208(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+224(SB), X4
	MOVOA g_StepConstants<>+240(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+256(SB), X4
	MOVOA g_StepConstants<>+272(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+288(SB), X4
	MOVOA g_StepConstants<>+304(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+320(SB), X4
	MOVOA g_StepConstants<>+336(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+352(SB), X4
	MOVOA g_StepConstants<>+368(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+384(SB), X4
	MOVOA g_StepConstants<>+400(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+416(SB), X4
	MOVOA g_StepConstants<>+432(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+448(SB), X4
	MOVOA g_StepConstants<>+464(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+480(SB), X4
	MOVOA g_StepConstants<>+496(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+512(SB), X4
	MOVOA g_StepConstants<>+528(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+544(SB), X4
	MOVOA g_StepConstants<>+560(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+576(SB), X4
	MOVOA g_StepConstants<>+592(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+608(SB), X4
	MOVOA g_StepConstants<>+624(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+640(SB), X4
	MOVOA g_StepConstants<>+656(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+672(SB), X4
	MOVOA g_StepConstants<>+688(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+704(SB), X4
	MOVOA g_StepConstants<>+720(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+736(SB), X4
	MOVOA g_StepConstants<>+752(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+768(SB), X4
	MOVOA g_StepConstants<>+784(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+800(SB), X4
	MOVOA g_StepConstants<>+816(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_msg_gamma
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+0(SB), X4
	PAND  g_BytePermInfo_sse2<>+16(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+32(SB), X4
	PAND  g_BytePermInfo_sse2<>+48(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X2, X4
	PAND  g_BytePermInfo_sse2<>+64(SB), X4
	PAND  g_BytePermInfo_sse2<>+80(SB), X2
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X2
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+96(SB), X4
	PAND  g_BytePermInfo_sse2<>+112(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+128(SB), X4
	PAND  g_BytePermInfo_sse2<>+144(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3
	MOVOA X3, X4
	PAND  g_BytePermInfo_sse2<>+160(SB), X4
	PAND  g_BytePermInfo_sse2<>+176(SB), X3
	MOVOA X4, X5
	PSLLL $0x08, X5
	PSRLL $0x18, X4
	PXOR  X5, X4
	PXOR  X4, X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// fin
	PXOR X2, X0
	PXOR X3, X1

	// get_hash
	MOVOU X0, (DX)
	MOVOU X1, 16(DX)
	MOVQ  ctx+0(FP), AX
	MOVQ  CX, 8(AX)
	RET

DATA memset_value_0<>+0(SB)/8, $0x0000000000000000
DATA memset_value_0<>+8(SB)/8, $0x0000000000000000
DATA memset_value_0<>+16(SB)/8, $0x0000000000000000
DATA memset_value_0<>+24(SB)/8, $0x0000000000000000
GLOBL memset_value_0<>(SB), RODATA|NOPTR, $32

// func lsh256UpdateSSSE3(ctx *lsh256ContextAsmData, data []byte)
// Requires: SSE2, SSSE3
TEXT ·lsh256UpdateSSSE3(SB), NOSPLIT, $0-32
	MOVQ ctx+0(FP), AX
	MOVL (AX), CX
	MOVQ 8(AX), CX
	MOVQ data_base+8(FP), DX
	MOVQ data_len+16(FP), BX

	// lsh256_ssse3_update
	MOVQ CX, SI
	MOVQ BX, DI
	ADDQ SI, DI
	CMPQ DI, $0x00000080
	JGE  lsh256_ssse3_update_if0_end

	// Memcpy
	LEAQ 80(AX)(SI*1), AX
	LEAQ (DX), SI
	MOVQ BX, DI

memcpy_4_sz16_start:
	CMPQ  DI, $0x00000010
	JL    memcpy_4_sz16_end
	MOVOU (SI), X0
	MOVOU X0, (AX)
	ADDQ  $0x00000010, SI
	ADDQ  $0x00000010, AX
	SUBQ  $0x00000010, DI
	JMP   memcpy_4_sz16_start

memcpy_4_sz16_end:
memcpy_4_sz8_start:
	CMPQ DI, $0x00000008
	JL   memcpy_4_sz8_end
	MOVQ (SI), DX
	MOVQ DX, (AX)
	ADDQ $0x00000008, SI
	ADDQ $0x00000008, AX
	SUBQ $0x00000008, DI
	JMP  memcpy_4_sz8_start

memcpy_4_sz8_end:
memcpy_4_sz4_start:
	CMPQ DI, $0x00000004
	JL   memcpy_4_sz4_end
	MOVL (SI), DX
	MOVL DX, (AX)
	ADDQ $0x00000004, SI
	ADDQ $0x00000004, AX
	SUBQ $0x00000004, DI
	JMP  memcpy_4_sz4_start

memcpy_4_sz4_end:
memcpy_4_sz2_start:
	CMPQ DI, $0x00000002
	JL   memcpy_4_sz2_end
	MOVW (SI), DX
	MOVW DX, (AX)
	ADDQ $0x00000002, SI
	ADDQ $0x00000002, AX
	SUBQ $0x00000002, DI
	JMP  memcpy_4_sz2_start

memcpy_4_sz2_end:
memcpy_4_sz1_start:
	CMPQ DI, $0x00000001
	JL   memcpy_4_sz1_end
	MOVB (SI), DL
	MOVB DL, (AX)
	ADDQ $0x00000001, SI
	ADDQ $0x00000001, AX
	SUBQ $0x00000001, DI
	JMP  memcpy_4_sz1_start

memcpy_4_sz1_end:
	ADDQ BX, CX
	JMP  lsh256_ssse3_update_ret

lsh256_ssse3_update_if0_end:
	// load_blk_mem2vec
	MOVOU 16(AX), X0
	MOVOU 32(AX), X1

	// load_blk_mem2vec
	MOVOU 48(AX), X2
	MOVOU 64(AX), X3
	CMPQ  SI, $0x00000000
	JE    lsh256_ssse3_update_if2_end
	MOVQ  $0x00000080, CX
	SUBQ  SI, CX

	// Memcpy
	LEAQ 80(AX)(SI*1), DI
	LEAQ (DX), R8
	MOVQ CX, R9

memcpy_5_sz16_start:
	CMPQ  R9, $0x00000010
	JL    memcpy_5_sz16_end
	MOVOU (R8), X4
	MOVOU X4, (DI)
	ADDQ  $0x00000010, R8
	ADDQ  $0x00000010, DI
	SUBQ  $0x00000010, R9
	JMP   memcpy_5_sz16_start

memcpy_5_sz16_end:
memcpy_5_sz8_start:
	CMPQ R9, $0x00000008
	JL   memcpy_5_sz8_end
	MOVQ (R8), SI
	MOVQ SI, (DI)
	ADDQ $0x00000008, R8
	ADDQ $0x00000008, DI
	SUBQ $0x00000008, R9
	JMP  memcpy_5_sz8_start

memcpy_5_sz8_end:
memcpy_5_sz4_start:
	CMPQ R9, $0x00000004
	JL   memcpy_5_sz4_end
	MOVL (R8), SI
	MOVL SI, (DI)
	ADDQ $0x00000004, R8
	ADDQ $0x00000004, DI
	SUBQ $0x00000004, R9
	JMP  memcpy_5_sz4_start

memcpy_5_sz4_end:
memcpy_5_sz2_start:
	CMPQ R9, $0x00000002
	JL   memcpy_5_sz2_end
	MOVW (R8), SI
	MOVW SI, (DI)
	ADDQ $0x00000002, R8
	ADDQ $0x00000002, DI
	SUBQ $0x00000002, R9
	JMP  memcpy_5_sz2_start

memcpy_5_sz2_end:
memcpy_5_sz1_start:
	CMPQ R9, $0x00000001
	JL   memcpy_5_sz1_end
	MOVB (R8), SI
	MOVB SI, (DI)
	ADDQ $0x00000001, R8
	ADDQ $0x00000001, DI
	SUBQ $0x00000001, R9
	JMP  memcpy_5_sz1_start

memcpy_5_sz1_end:
	// compress
	// load_msg_blk
	// load_blk_mem2vec
	MOVOU 80(AX), X6
	MOVOU 96(AX), X7

	// load_blk_mem2vec
	MOVOU 112(AX), X8
	MOVOU 128(AX), X9

	// load_blk_mem2vec
	MOVOU 144(AX), X10
	MOVOU 160(AX), X11

	// load_blk_mem2vec
	MOVOU 176(AX), X12
	MOVOU 192(AX), X13

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+0(SB), X4
	MOVOA g_StepConstants<>+16(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+32(SB), X4
	MOVOA g_StepConstants<>+48(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+64(SB), X4
	MOVOA g_StepConstants<>+80(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+96(SB), X4
	MOVOA g_StepConstants<>+112(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+128(SB), X4
	MOVOA g_StepConstants<>+144(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+160(SB), X4
	MOVOA g_StepConstants<>+176(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+192(SB), X4
	MOVOA g_StepConstants<>+208(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+224(SB), X4
	MOVOA g_StepConstants<>+240(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+256(SB), X4
	MOVOA g_StepConstants<>+272(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+288(SB), X4
	MOVOA g_StepConstants<>+304(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+320(SB), X4
	MOVOA g_StepConstants<>+336(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+352(SB), X4
	MOVOA g_StepConstants<>+368(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+384(SB), X4
	MOVOA g_StepConstants<>+400(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+416(SB), X4
	MOVOA g_StepConstants<>+432(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+448(SB), X4
	MOVOA g_StepConstants<>+464(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+480(SB), X4
	MOVOA g_StepConstants<>+496(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+512(SB), X4
	MOVOA g_StepConstants<>+528(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+544(SB), X4
	MOVOA g_StepConstants<>+560(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+576(SB), X4
	MOVOA g_StepConstants<>+592(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+608(SB), X4
	MOVOA g_StepConstants<>+624(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+640(SB), X4
	MOVOA g_StepConstants<>+656(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+672(SB), X4
	MOVOA g_StepConstants<>+688(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+704(SB), X4
	MOVOA g_StepConstants<>+720(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+736(SB), X4
	MOVOA g_StepConstants<>+752(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+768(SB), X4
	MOVOA g_StepConstants<>+784(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+800(SB), X4
	MOVOA g_StepConstants<>+816(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3
	ADDQ CX, DX
	SUBQ CX, BX
	MOVQ $0x00000000, SI
	MOVQ $0x00000000, CX

lsh256_ssse3_update_if2_end:
lsh256_ssse3_update_while_start:
	CMPQ BX, $0x00000080
	JL   lsh256_ssse3_update_while_end

	// compress
	// load_msg_blk
	// load_blk_mem2vec
	MOVOU (DX), X6
	MOVOU 16(DX), X7

	// load_blk_mem2vec
	MOVOU 32(DX), X8
	MOVOU 48(DX), X9

	// load_blk_mem2vec
	MOVOU 64(DX), X10
	MOVOU 80(DX), X11

	// load_blk_mem2vec
	MOVOU 96(DX), X12
	MOVOU 112(DX), X13

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+0(SB), X4
	MOVOA g_StepConstants<>+16(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+32(SB), X4
	MOVOA g_StepConstants<>+48(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+64(SB), X4
	MOVOA g_StepConstants<>+80(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+96(SB), X4
	MOVOA g_StepConstants<>+112(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+128(SB), X4
	MOVOA g_StepConstants<>+144(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+160(SB), X4
	MOVOA g_StepConstants<>+176(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+192(SB), X4
	MOVOA g_StepConstants<>+208(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+224(SB), X4
	MOVOA g_StepConstants<>+240(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+256(SB), X4
	MOVOA g_StepConstants<>+272(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+288(SB), X4
	MOVOA g_StepConstants<>+304(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+320(SB), X4
	MOVOA g_StepConstants<>+336(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+352(SB), X4
	MOVOA g_StepConstants<>+368(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+384(SB), X4
	MOVOA g_StepConstants<>+400(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+416(SB), X4
	MOVOA g_StepConstants<>+432(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+448(SB), X4
	MOVOA g_StepConstants<>+464(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+480(SB), X4
	MOVOA g_StepConstants<>+496(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+512(SB), X4
	MOVOA g_StepConstants<>+528(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+544(SB), X4
	MOVOA g_StepConstants<>+560(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+576(SB), X4
	MOVOA g_StepConstants<>+592(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+608(SB), X4
	MOVOA g_StepConstants<>+624(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+640(SB), X4
	MOVOA g_StepConstants<>+656(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+672(SB), X4
	MOVOA g_StepConstants<>+688(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+704(SB), X4
	MOVOA g_StepConstants<>+720(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+736(SB), X4
	MOVOA g_StepConstants<>+752(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+768(SB), X4
	MOVOA g_StepConstants<>+784(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+800(SB), X4
	MOVOA g_StepConstants<>+816(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3
	ADDQ $0x00000080, DX
	SUBQ $0x00000080, BX
	JMP  lsh256_ssse3_update_while_start

lsh256_ssse3_update_while_end:
	// store_blk
	MOVOU X0, 16(AX)
	MOVOU X1, 32(AX)

	// store_blk
	MOVOU X2, 48(AX)
	MOVOU X3, 64(AX)
	CMPQ  BX, $0x00000000
	JE    lsh256_ssse3_update_if3_end

	// Memcpy
	LEAQ 80(AX), AX
	LEAQ (DX), DX
	MOVQ BX, SI

memcpy_6_sz16_start:
	CMPQ  SI, $0x00000010
	JL    memcpy_6_sz16_end
	MOVOU (DX), X0
	MOVOU X0, (AX)
	ADDQ  $0x00000010, DX
	ADDQ  $0x00000010, AX
	SUBQ  $0x00000010, SI
	JMP   memcpy_6_sz16_start

memcpy_6_sz16_end:
memcpy_6_sz8_start:
	CMPQ SI, $0x00000008
	JL   memcpy_6_sz8_end
	MOVQ (DX), CX
	MOVQ CX, (AX)
	ADDQ $0x00000008, DX
	ADDQ $0x00000008, AX
	SUBQ $0x00000008, SI
	JMP  memcpy_6_sz8_start

memcpy_6_sz8_end:
memcpy_6_sz4_start:
	CMPQ SI, $0x00000004
	JL   memcpy_6_sz4_end
	MOVL (DX), CX
	MOVL CX, (AX)
	ADDQ $0x00000004, DX
	ADDQ $0x00000004, AX
	SUBQ $0x00000004, SI
	JMP  memcpy_6_sz4_start

memcpy_6_sz4_end:
memcpy_6_sz2_start:
	CMPQ SI, $0x00000002
	JL   memcpy_6_sz2_end
	MOVW (DX), CX
	MOVW CX, (AX)
	ADDQ $0x00000002, DX
	ADDQ $0x00000002, AX
	SUBQ $0x00000002, SI
	JMP  memcpy_6_sz2_start

memcpy_6_sz2_end:
memcpy_6_sz1_start:
	CMPQ SI, $0x00000001
	JL   memcpy_6_sz1_end
	MOVB (DX), CL
	MOVB CL, (AX)
	ADDQ $0x00000001, DX
	ADDQ $0x00000001, AX
	SUBQ $0x00000001, SI
	JMP  memcpy_6_sz1_start

memcpy_6_sz1_end:
	MOVQ BX, CX

lsh256_ssse3_update_if3_end:
lsh256_ssse3_update_ret:
	MOVQ ctx+0(FP), AX
	MOVQ CX, 8(AX)
	RET

// func lsh256FinalSSSE3(ctx *lsh256ContextAsmData, hashval []byte)
// Requires: SSE2, SSSE3
TEXT ·lsh256FinalSSSE3(SB), NOSPLIT, $0-32
	MOVQ ctx+0(FP), AX
	MOVL (AX), CX
	MOVQ 8(AX), CX
	MOVQ hashval_base+8(FP), DX

	// lsh256_ssse3_final
	MOVQ CX, BX
	MOVB $0x80, 80(AX)(BX*1)
	MOVQ $0x0000007f, SI
	SUBQ BX, SI

	// memset
	LEAQ 81(AX)(BX*1), BX
	CMPQ SI, $0x00000010
	JL   memset_2_sz16_end
	MOVO memset_value_0<>+0(SB), X0

memset_2_sz16_start:
	MOVOU X0, (BX)
	SUBQ  $0x00000010, SI
	ADDQ  $0x00000010, BX
	CMPQ  SI, $0x00000010
	JL    memset_2_sz16_end
	JMP   memset_2_sz16_start

memset_2_sz16_end:
	CMPQ SI, $0x00000008
	JL   memset_2_sz8_end
	MOVQ memset_value_0<>+0(SB), DI

memset_2_sz8_start:
	MOVQ DI, (BX)
	SUBQ $0x00000008, SI
	ADDQ $0x00000008, BX
	CMPQ SI, $0x00000008
	JL   memset_2_sz8_end
	JMP  memset_2_sz8_start

memset_2_sz8_end:
	CMPQ SI, $0x00000004
	JL   memset_2_sz4_end
	MOVL memset_value_0<>+0(SB), DI

memset_2_sz4_start:
	MOVL DI, (BX)
	SUBQ $0x00000004, SI
	ADDQ $0x00000004, BX
	CMPQ SI, $0x00000004
	JL   memset_2_sz4_end
	JMP  memset_2_sz4_start

memset_2_sz4_end:
	CMPQ SI, $0x00000002
	JL   memset_2_sz2_end
	MOVW memset_value_0<>+0(SB), DI

memset_2_sz2_start:
	MOVW DI, (BX)
	SUBQ $0x00000002, SI
	ADDQ $0x00000002, BX
	CMPQ SI, $0x00000002
	JL   memset_2_sz2_end
	JMP  memset_2_sz2_start

memset_2_sz2_end:
memset_2_1_start:
	CMPQ SI, $0x00000000
	JE   memset_2_1_end
	MOVB $0x00, (BX)
	SUBQ $0x00000001, SI
	ADDQ $0x00000001, BX
	JMP  memset_2_1_start

memset_2_1_end:
	// load_blk_mem2vec
	MOVOU 16(AX), X0
	MOVOU 32(AX), X1

	// load_blk_mem2vec
	MOVOU 48(AX), X2
	MOVOU 64(AX), X3

	// compress
	// load_msg_blk
	// load_blk_mem2vec
	MOVOU 80(AX), X6
	MOVOU 96(AX), X7

	// load_blk_mem2vec
	MOVOU 112(AX), X8
	MOVOU 128(AX), X9

	// load_blk_mem2vec
	MOVOU 144(AX), X10
	MOVOU 160(AX), X11

	// load_blk_mem2vec
	MOVOU 176(AX), X12
	MOVOU 192(AX), X13

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+0(SB), X4
	MOVOA g_StepConstants<>+16(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+32(SB), X4
	MOVOA g_StepConstants<>+48(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+64(SB), X4
	MOVOA g_StepConstants<>+80(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+96(SB), X4
	MOVOA g_StepConstants<>+112(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+128(SB), X4
	MOVOA g_StepConstants<>+144(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+160(SB), X4
	MOVOA g_StepConstants<>+176(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+192(SB), X4
	MOVOA g_StepConstants<>+208(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+224(SB), X4
	MOVOA g_StepConstants<>+240(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+256(SB), X4
	MOVOA g_StepConstants<>+272(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+288(SB), X4
	MOVOA g_StepConstants<>+304(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+320(SB), X4
	MOVOA g_StepConstants<>+336(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+352(SB), X4
	MOVOA g_StepConstants<>+368(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+384(SB), X4
	MOVOA g_StepConstants<>+400(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+416(SB), X4
	MOVOA g_StepConstants<>+432(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+448(SB), X4
	MOVOA g_StepConstants<>+464(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+480(SB), X4
	MOVOA g_StepConstants<>+496(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+512(SB), X4
	MOVOA g_StepConstants<>+528(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+544(SB), X4
	MOVOA g_StepConstants<>+560(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+576(SB), X4
	MOVOA g_StepConstants<>+592(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+608(SB), X4
	MOVOA g_StepConstants<>+624(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+640(SB), X4
	MOVOA g_StepConstants<>+656(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+672(SB), X4
	MOVOA g_StepConstants<>+688(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+704(SB), X4
	MOVOA g_StepConstants<>+720(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+736(SB), X4
	MOVOA g_StepConstants<>+752(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+768(SB), X4
	MOVOA g_StepConstants<>+784(SB), X5

	// mix_even
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_even_alpha
	MOVOA X0, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x1d, X14
	PSRLL $0x03, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_even_beta
	MOVOA X2, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x01, X4
	PSRLL $0x1f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_odd
	PSHUFD $0x4b, X10, X10
	PADDD  X6, X10
	PSHUFD $0x93, X11, X11
	PADDD  X7, X11
	PSHUFD $0x4b, X12, X12
	PADDD  X8, X12
	PSHUFD $0x93, X13, X13
	PADDD  X9, X13

	// msg_add_odd
	PXOR X10, X0
	PXOR X12, X2
	PXOR X11, X1
	PXOR X13, X3

	// load_sc
	// load_blk_mem2vec
	MOVOA g_StepConstants<>+800(SB), X4
	MOVOA g_StepConstants<>+816(SB), X5

	// mix_odd
	// add_blk
	PADDD X2, X0
	PADDD X3, X1

	// rotate_blk_odd_alpha
	MOVOA X0, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X0
	POR   X14, X0
	MOVOA X1, X14
	PSLLL $0x05, X14
	PSRLL $0x1b, X1
	POR   X14, X1

	// xor_with_const
	PXOR X4, X0
	PXOR X5, X1

	// add_blk
	PADDD X0, X2
	PADDD X1, X3

	// rotate_blk_odd_beta
	MOVOA X2, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X2
	POR   X4, X2
	MOVOA X3, X4
	PSLLL $0x11, X4
	PSRLL $0x0f, X3
	POR   X4, X3

	// add_blk
	PADDD  X2, X0
	PADDD  X3, X1
	PSHUFB g_BytePermInfo_ssse3<>+0(SB), X2
	PSHUFB g_BytePermInfo_ssse3<>+16(SB), X3

	// word_perm
	PSHUFD $0xd2, X0, X0
	PSHUFD $0xd2, X1, X1
	PSHUFD $0x6c, X2, X2
	PSHUFD $0x6c, X3, X3
	MOVOA  X0, X4
	MOVOA  X1, X0
	MOVOA  X3, X1
	MOVOA  X2, X3
	MOVOA  X4, X2

	// msg_exp_even
	PSHUFD $0x4b, X6, X6
	PADDD  X10, X6
	PSHUFD $0x93, X7, X7
	PADDD  X11, X7
	PSHUFD $0x4b, X8, X8
	PADDD  X12, X8
	PSHUFD $0x93, X9, X9
	PADDD  X13, X9

	// msg_add_even
	PXOR X6, X0
	PXOR X8, X2
	PXOR X7, X1
	PXOR X9, X3

	// fin
	PXOR X2, X0
	PXOR X3, X1

	// get_hash
	MOVOU X0, (DX)
	MOVOU X1, 16(DX)
	MOVQ  ctx+0(FP), AX
	MOVQ  CX, 8(AX)
	RET

// func lsh256InitAVX2(ctx *lsh256ContextAsmData)
// Requires: AVX
TEXT ·lsh256InitAVX2(SB), NOSPLIT, $0-8
	MOVQ ctx+0(FP), AX
	MOVL (AX), CX
	MOVQ 8(AX), DX

	// lsh256_avx2_init
	CMPL CX, $0x00000020
	JNE  lsh256_avx2_init_if0_end

	// init256
	// load_blk_mem2mem
	// MemcpyStatic
	VMOVDQA g_IV256<>+0(SB), Y0
	VMOVDQU Y0, 16(AX)

	// load_blk_mem2mem
	// MemcpyStatic
	VMOVDQA g_IV256<>+32(SB), Y0
	VMOVDQU Y0, 48(AX)
	JMP     lsh256_avx2_init_ret

lsh256_avx2_init_if0_end:
	// init224
	// load_blk_mem2mem
	// MemcpyStatic
	VMOVDQA g_IV224<>+0(SB), Y0
	VMOVDQU Y0, 16(AX)

	// load_blk_mem2mem
	// MemcpyStatic
	VMOVDQA g_IV224<>+32(SB), Y0
	VMOVDQU Y0, 48(AX)

lsh256_avx2_init_ret:
	MOVQ ctx+0(FP), AX
	MOVQ DX, 8(AX)
	RET

// func lsh256UpdateAVX2(ctx *lsh256ContextAsmData, data []byte)
// Requires: AVX, AVX2, SSE2
TEXT ·lsh256UpdateAVX2(SB), NOSPLIT, $0-32
	MOVQ ctx+0(FP), AX
	MOVL (AX), CX
	MOVQ 8(AX), CX
	MOVQ data_base+8(FP), DX
	MOVQ data_len+16(FP), BX

	// lsh256_avx2_update
	MOVQ CX, SI
	MOVQ BX, DI
	ADDQ SI, DI
	CMPQ DI, $0x00000080
	JGE  lsh256_avx2_update_if0_end

	// Memcpy
	LEAQ 80(AX)(SI*1), AX
	LEAQ (DX), SI
	MOVQ BX, DI

memcpy_7_sz32_start:
	CMPQ    DI, $0x00000020
	JL      memcpy_7_sz32_end
	VMOVDQU (SI), Y0
	VMOVDQU Y0, (AX)
	ADDQ    $0x00000020, SI
	ADDQ    $0x00000020, AX
	SUBQ    $0x00000020, DI
	JMP     memcpy_7_sz32_start

memcpy_7_sz32_end:
memcpy_7_sz16_start:
	CMPQ  DI, $0x00000010
	JL    memcpy_7_sz16_end
	MOVOU (SI), X0
	MOVOU X0, (AX)
	ADDQ  $0x00000010, SI
	ADDQ  $0x00000010, AX
	SUBQ  $0x00000010, DI
	JMP   memcpy_7_sz16_start

memcpy_7_sz16_end:
memcpy_7_sz8_start:
	CMPQ DI, $0x00000008
	JL   memcpy_7_sz8_end
	MOVQ (SI), DX
	MOVQ DX, (AX)
	ADDQ $0x00000008, SI
	ADDQ $0x00000008, AX
	SUBQ $0x00000008, DI
	JMP  memcpy_7_sz8_start

memcpy_7_sz8_end:
memcpy_7_sz4_start:
	CMPQ DI, $0x00000004
	JL   memcpy_7_sz4_end
	MOVL (SI), DX
	MOVL DX, (AX)
	ADDQ $0x00000004, SI
	ADDQ $0x00000004, AX
	SUBQ $0x00000004, DI
	JMP  memcpy_7_sz4_start

memcpy_7_sz4_end:
memcpy_7_sz2_start:
	CMPQ DI, $0x00000002
	JL   memcpy_7_sz2_end
	MOVW (SI), DX
	MOVW DX, (AX)
	ADDQ $0x00000002, SI
	ADDQ $0x00000002, AX
	SUBQ $0x00000002, DI
	JMP  memcpy_7_sz2_start

memcpy_7_sz2_end:
memcpy_7_sz1_start:
	CMPQ DI, $0x00000001
	JL   memcpy_7_sz1_end
	MOVB (SI), DL
	MOVB DL, (AX)
	ADDQ $0x00000001, SI
	ADDQ $0x00000001, AX
	SUBQ $0x00000001, DI
	JMP  memcpy_7_sz1_start

memcpy_7_sz1_end:
	ADDQ BX, CX
	JMP  lsh256_avx2_update_ret

lsh256_avx2_update_if0_end:
	// load_blk_mem2vec
	VMOVDQU 16(AX), Y0

	// load_blk_mem2vec
	VMOVDQU 48(AX), Y1
	CMPQ    SI, $0x00000000
	JE      lsh256_avx2_update_if2_end
	MOVQ    $0x00000080, CX
	SUBQ    SI, CX

	// Memcpy
	LEAQ 80(AX)(SI*1), DI
	LEAQ (DX), R8
	MOVQ CX, R9

memcpy_8_sz32_start:
	CMPQ    R9, $0x00000020
	JL      memcpy_8_sz32_end
	VMOVDQU (R8), Y2
	VMOVDQU Y2, (DI)
	ADDQ    $0x00000020, R8
	ADDQ    $0x00000020, DI
	SUBQ    $0x00000020, R9
	JMP     memcpy_8_sz32_start

memcpy_8_sz32_end:
memcpy_8_sz16_start:
	CMPQ  R9, $0x00000010
	JL    memcpy_8_sz16_end
	MOVOU (R8), X2
	MOVOU X2, (DI)
	ADDQ  $0x00000010, R8
	ADDQ  $0x00000010, DI
	SUBQ  $0x00000010, R9
	JMP   memcpy_8_sz16_start

memcpy_8_sz16_end:
memcpy_8_sz8_start:
	CMPQ R9, $0x00000008
	JL   memcpy_8_sz8_end
	MOVQ (R8), SI
	MOVQ SI, (DI)
	ADDQ $0x00000008, R8
	ADDQ $0x00000008, DI
	SUBQ $0x00000008, R9
	JMP  memcpy_8_sz8_start

memcpy_8_sz8_end:
memcpy_8_sz4_start:
	CMPQ R9, $0x00000004
	JL   memcpy_8_sz4_end
	MOVL (R8), SI
	MOVL SI, (DI)
	ADDQ $0x00000004, R8
	ADDQ $0x00000004, DI
	SUBQ $0x00000004, R9
	JMP  memcpy_8_sz4_start

memcpy_8_sz4_end:
memcpy_8_sz2_start:
	CMPQ R9, $0x00000002
	JL   memcpy_8_sz2_end
	MOVW (R8), SI
	MOVW SI, (DI)
	ADDQ $0x00000002, R8
	ADDQ $0x00000002, DI
	SUBQ $0x00000002, R9
	JMP  memcpy_8_sz2_start

memcpy_8_sz2_end:
memcpy_8_sz1_start:
	CMPQ R9, $0x00000001
	JL   memcpy_8_sz1_end
	MOVB (R8), SI
	MOVB SI, (DI)
	ADDQ $0x00000001, R8
	ADDQ $0x00000001, DI
	SUBQ $0x00000001, R9
	JMP  memcpy_8_sz1_start

memcpy_8_sz1_end:
	// compress
	VMOVDQA g_BytePermInfo_avx2<>+0(SB), Y3
	VMOVDQA g_MsgWordPermInfo_avx2<>+0(SB), Y4

	// load_msg_blk
	// load_blk_mem2vec
	VMOVDQU 80(AX), Y5

	// load_blk_mem2vec
	VMOVDQU 112(AX), Y6

	// load_blk_mem2vec
	VMOVDQU 144(AX), Y7

	// load_blk_mem2vec
	VMOVDQU 176(AX), Y8

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+0(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+32(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+64(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+96(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+128(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+160(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+192(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+224(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+256(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+288(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+320(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+352(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+384(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+416(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+448(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+480(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+512(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+544(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+576(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+608(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+640(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+672(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+704(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+736(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+768(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+800(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1
	ADDQ  CX, DX
	SUBQ  CX, BX
	MOVQ  $0x00000000, SI
	MOVQ  $0x00000000, CX

lsh256_avx2_update_if2_end:
lsh256_avx2_update_while_start:
	CMPQ BX, $0x00000080
	JL   lsh256_avx2_update_while_end

	// compress
	VMOVDQA g_BytePermInfo_avx2<>+0(SB), Y3
	VMOVDQA g_MsgWordPermInfo_avx2<>+0(SB), Y4

	// load_msg_blk
	// load_blk_mem2vec
	VMOVDQU (DX), Y5

	// load_blk_mem2vec
	VMOVDQU 32(DX), Y6

	// load_blk_mem2vec
	VMOVDQU 64(DX), Y7

	// load_blk_mem2vec
	VMOVDQU 96(DX), Y8

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+0(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+32(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+64(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+96(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+128(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+160(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+192(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+224(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+256(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+288(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+320(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+352(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+384(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+416(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+448(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+480(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+512(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+544(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+576(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+608(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+640(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+672(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+704(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+736(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+768(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+800(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1
	ADDQ  $0x00000080, DX
	SUBQ  $0x00000080, BX
	JMP   lsh256_avx2_update_while_start

lsh256_avx2_update_while_end:
	// store_blk
	VMOVDQU Y0, 16(AX)

	// store_blk
	VMOVDQU Y1, 48(AX)
	CMPQ    BX, $0x00000000
	JE      lsh256_avx2_update_if3_end

	// Memcpy
	LEAQ 80(AX), AX
	LEAQ (DX), DX
	MOVQ BX, SI

memcpy_9_sz32_start:
	CMPQ    SI, $0x00000020
	JL      memcpy_9_sz32_end
	VMOVDQU (DX), Y0
	VMOVDQU Y0, (AX)
	ADDQ    $0x00000020, DX
	ADDQ    $0x00000020, AX
	SUBQ    $0x00000020, SI
	JMP     memcpy_9_sz32_start

memcpy_9_sz32_end:
memcpy_9_sz16_start:
	CMPQ  SI, $0x00000010
	JL    memcpy_9_sz16_end
	MOVOU (DX), X0
	MOVOU X0, (AX)
	ADDQ  $0x00000010, DX
	ADDQ  $0x00000010, AX
	SUBQ  $0x00000010, SI
	JMP   memcpy_9_sz16_start

memcpy_9_sz16_end:
memcpy_9_sz8_start:
	CMPQ SI, $0x00000008
	JL   memcpy_9_sz8_end
	MOVQ (DX), CX
	MOVQ CX, (AX)
	ADDQ $0x00000008, DX
	ADDQ $0x00000008, AX
	SUBQ $0x00000008, SI
	JMP  memcpy_9_sz8_start

memcpy_9_sz8_end:
memcpy_9_sz4_start:
	CMPQ SI, $0x00000004
	JL   memcpy_9_sz4_end
	MOVL (DX), CX
	MOVL CX, (AX)
	ADDQ $0x00000004, DX
	ADDQ $0x00000004, AX
	SUBQ $0x00000004, SI
	JMP  memcpy_9_sz4_start

memcpy_9_sz4_end:
memcpy_9_sz2_start:
	CMPQ SI, $0x00000002
	JL   memcpy_9_sz2_end
	MOVW (DX), CX
	MOVW CX, (AX)
	ADDQ $0x00000002, DX
	ADDQ $0x00000002, AX
	SUBQ $0x00000002, SI
	JMP  memcpy_9_sz2_start

memcpy_9_sz2_end:
memcpy_9_sz1_start:
	CMPQ SI, $0x00000001
	JL   memcpy_9_sz1_end
	MOVB (DX), CL
	MOVB CL, (AX)
	ADDQ $0x00000001, DX
	ADDQ $0x00000001, AX
	SUBQ $0x00000001, SI
	JMP  memcpy_9_sz1_start

memcpy_9_sz1_end:
	MOVQ BX, CX

lsh256_avx2_update_if3_end:
lsh256_avx2_update_ret:
	MOVQ ctx+0(FP), AX
	MOVQ CX, 8(AX)
	RET

// func lsh256FinalAVX2(ctx *lsh256ContextAsmData, hashval []byte)
// Requires: AVX, AVX2, SSE2
TEXT ·lsh256FinalAVX2(SB), NOSPLIT, $0-32
	MOVQ ctx+0(FP), AX
	MOVL (AX), CX
	MOVQ 8(AX), CX
	MOVQ hashval_base+8(FP), DX

	// lsh256_avx2_final
	MOVQ CX, BX
	MOVB $0x80, 80(AX)(BX*1)
	MOVQ $0x000000000000007f, SI
	SUBQ BX, SI

	// memset
	LEAQ 81(AX)(BX*1), BX
	CMPQ SI, $0x00000010
	JL   memset_3_sz16_end
	MOVO memset_value_0<>+0(SB), X0

memset_3_sz16_start:
	MOVOU X0, (BX)
	SUBQ  $0x00000010, SI
	ADDQ  $0x00000010, BX
	CMPQ  SI, $0x00000010
	JL    memset_3_sz16_end
	JMP   memset_3_sz16_start

memset_3_sz16_end:
	CMPQ SI, $0x00000008
	JL   memset_3_sz8_end
	MOVQ memset_value_0<>+0(SB), DI

memset_3_sz8_start:
	MOVQ DI, (BX)
	SUBQ $0x00000008, SI
	ADDQ $0x00000008, BX
	CMPQ SI, $0x00000008
	JL   memset_3_sz8_end
	JMP  memset_3_sz8_start

memset_3_sz8_end:
	CMPQ SI, $0x00000004
	JL   memset_3_sz4_end
	MOVL memset_value_0<>+0(SB), DI

memset_3_sz4_start:
	MOVL DI, (BX)
	SUBQ $0x00000004, SI
	ADDQ $0x00000004, BX
	CMPQ SI, $0x00000004
	JL   memset_3_sz4_end
	JMP  memset_3_sz4_start

memset_3_sz4_end:
	CMPQ SI, $0x00000002
	JL   memset_3_sz2_end
	MOVW memset_value_0<>+0(SB), DI

memset_3_sz2_start:
	MOVW DI, (BX)
	SUBQ $0x00000002, SI
	ADDQ $0x00000002, BX
	CMPQ SI, $0x00000002
	JL   memset_3_sz2_end
	JMP  memset_3_sz2_start

memset_3_sz2_end:
memset_3_1_start:
	CMPQ SI, $0x00000000
	JE   memset_3_1_end
	MOVB $0x00, (BX)
	SUBQ $0x00000001, SI
	ADDQ $0x00000001, BX
	JMP  memset_3_1_start

memset_3_1_end:
	// load_blk_mem2vec
	VMOVDQU 16(AX), Y0

	// load_blk_mem2vec
	VMOVDQU 48(AX), Y1

	// compress
	VMOVDQA g_BytePermInfo_avx2<>+0(SB), Y3
	VMOVDQA g_MsgWordPermInfo_avx2<>+0(SB), Y4

	// load_msg_blk
	// load_blk_mem2vec
	VMOVDQU 80(AX), Y5

	// load_blk_mem2vec
	VMOVDQU 112(AX), Y6

	// load_blk_mem2vec
	VMOVDQU 144(AX), Y7

	// load_blk_mem2vec
	VMOVDQU 176(AX), Y8

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+0(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+32(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+64(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+96(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+128(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+160(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+192(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+224(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+256(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+288(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+320(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+352(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+384(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+416(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+448(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+480(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+512(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+544(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+576(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+608(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+640(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+672(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+704(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+736(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+768(SB), Y2

	// mix_even
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_even_alpha
	VPSLLD $0x1d, Y0, Y9
	VPSRLD $0x03, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_even_beta
	VPSLLD $0x01, Y1, Y2
	VPSRLD $0x1f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_odd
	VPSHUFB Y4, Y7, Y7
	VPADDD  Y7, Y5, Y7
	VPSHUFB Y4, Y8, Y8
	VPADDD  Y8, Y6, Y8

	// msg_add_odd
	VPXOR Y7, Y0, Y0
	VPXOR Y8, Y1, Y1

	// load_sc
	// load_blk_mem2vec
	VMOVDQA g_StepConstants<>+800(SB), Y2

	// mix_odd
	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_blk_odd_alpha
	VPSLLD $0x05, Y0, Y9
	VPSRLD $0x1b, Y0, Y0
	VPOR   Y0, Y9, Y0

	// xor_with_const
	VPXOR Y2, Y0, Y0

	// add_blk
	VPADDD Y0, Y1, Y1

	// rotate_blk_odd_beta
	VPSLLD $0x11, Y1, Y2
	VPSRLD $0x0f, Y1, Y1
	VPOR   Y1, Y2, Y1

	// add_blk
	VPADDD Y1, Y0, Y0

	// rotate_msg_gamma
	VPSHUFB Y3, Y1, Y1

	// word_perm
	VPSHUFD    $0xd2, Y0, Y2
	VPSHUFD    $0x6c, Y1, Y1
	VPERM2I128 $0x31, Y1, Y2, Y0
	VPERM2I128 $0x20, Y1, Y2, Y1

	// msg_exp_even
	VPSHUFB Y4, Y5, Y5
	VPADDD  Y5, Y7, Y5
	VPSHUFB Y4, Y6, Y6
	VPADDD  Y6, Y8, Y6

	// msg_add_even
	VPXOR Y5, Y0, Y0
	VPXOR Y6, Y1, Y1

	// fin
	VPXOR Y1, Y0, Y0

	// get_hash
	VMOVDQU Y0, (DX)
	MOVQ    ctx+0(FP), AX
	MOVQ    CX, 8(AX)
	RET
