package lea

import (
	"testing"

	. "github.com/RyuaNerin/go-krypto/testingutil"
)

func Test_LEA196_Encrypt(t *testing.T) { BTE(t, BIW(NewCipher), CE, testCases196, false) }
func Test_LEA196_Decrypt(t *testing.T) { BTD(t, BIW(NewCipher), CD, testCases196, false) }

// 암호알고리즘 검증기준 V3.0
// 테스트 벡터
// LEA196(ECB)KAT.txt
var testCases196 = []BlockTestCase{
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `80000000000000000000000000000000`,
		Secure: `F0DE5F8374905BB31E0110ADF109EDD2`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `C0000000000000000000000000000000`,
		Secure: `1657DF5183910346A1B6E5129C39038D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `E0000000000000000000000000000000`,
		Secure: `03E66E1A583357364A3D340193C1CFC0`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `F0000000000000000000000000000000`,
		Secure: `28B3DE63EBB937A44612919138320874`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `F8000000000000000000000000000000`,
		Secure: `D2C9FE08BDFE8C72F3E1036045BE0C6F`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FC000000000000000000000000000000`,
		Secure: `81B5ABF4A802A46F642ADCF062E06AD8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FE000000000000000000000000000000`,
		Secure: `07D0FDFD1C98C2068DBB3111E9B425CC`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FF000000000000000000000000000000`,
		Secure: `81F8FCFECE59114A5D6F563356D8E83B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FF800000000000000000000000000000`,
		Secure: `31A9FB0E0A97F7C83D344F89D5E0B9FB`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFC00000000000000000000000000000`,
		Secure: `0A9A2FC4EDA815E9EBC90D9EF1E5EDA9`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFE00000000000000000000000000000`,
		Secure: `4064A738597C1DCB1E1026E47EB5DA11`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFF00000000000000000000000000000`,
		Secure: `267296F7EDD3B143BDB34B113813C1C1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFF80000000000000000000000000000`,
		Secure: `654B8A7C03FA9C36F619C4EAA827F5ED`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFC0000000000000000000000000000`,
		Secure: `0BAF4DD68FCDEB52CB61C091DE7F4D4E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFE0000000000000000000000000000`,
		Secure: `3CE3A05F1F9FF1CB8324E0C5F605DB9A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFF0000000000000000000000000000`,
		Secure: `E6AE405630B9056C36A8CAEE2B03EB5E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFF8000000000000000000000000000`,
		Secure: `FBC8BAC283090622A434EED076E0FEFE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFC000000000000000000000000000`,
		Secure: `33C30FF376A28E8D6D0C52F80C3B61DA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFE000000000000000000000000000`,
		Secure: `860CBC4C48F6089D72C832AF97A62A7D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFF000000000000000000000000000`,
		Secure: `23536C1A69EFD1A402F525A5C497C47C`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFF800000000000000000000000000`,
		Secure: `E7DA22DD3DD2EB90535B29260D77172E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFC00000000000000000000000000`,
		Secure: `4A6A71927590DF3336873F151AE727EC`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFE00000000000000000000000000`,
		Secure: `9E13E41C138534A3AB88129D0E272051`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFF00000000000000000000000000`,
		Secure: `35964466A64FC38ADA180D8FE9DF4B46`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFF80000000000000000000000000`,
		Secure: `D3F8D8B63706482AC21469288392BEB2`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFC0000000000000000000000000`,
		Secure: `36C541E3119D16B32552EA67178DC38A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFE0000000000000000000000000`,
		Secure: `4D5524032620E3E3A6E21649FD485B86`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFF0000000000000000000000000`,
		Secure: `81FBD57EC09146E03779C39594FE0FB8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFF8000000000000000000000000`,
		Secure: `36DC21BF96367B0EFABD2233EA0382B6`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFC000000000000000000000000`,
		Secure: `4532FA275906F2A060A0E191E14AA57B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFE000000000000000000000000`,
		Secure: `9177834DE5063F3C21A5A87CFFCEE8C8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFF000000000000000000000000`,
		Secure: `AE02038EE9000CA438E80514CC21A2BF`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFF800000000000000000000000`,
		Secure: `D0855CF09F1C6ACF37CBD6750DEC2706`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFC00000000000000000000000`,
		Secure: `CB43F1B70EDADFC0F69CDA82BE58DFDD`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFE00000000000000000000000`,
		Secure: `94911284B51AA080CC1C8355449F3BCD`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFF00000000000000000000000`,
		Secure: `FE2BFB54CD93EE887A062D0055CAB94D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFF80000000000000000000000`,
		Secure: `E9B2D9BE18F8EF307648594A1BFFDA0F`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFC0000000000000000000000`,
		Secure: `4E566A74EF6CF0807000AC5E1A31E8FC`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFE0000000000000000000000`,
		Secure: `8B364C1EF528AEBB6D9E03CB36ECDD10`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF0000000000000000000000`,
		Secure: `4D9FDE0161BEBC22799231B63F1AD895`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF8000000000000000000000`,
		Secure: `42A86A11A52C3EFAFF1DF9658CFECA1A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFC000000000000000000000`,
		Secure: `FD71D2805BC17E92E590534D6FA1B190`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFE000000000000000000000`,
		Secure: `4AB3D120BF3F4D71010889E3CAD6408A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF000000000000000000000`,
		Secure: `85DD773F81146530AC0A6D5C352E2A1B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF800000000000000000000`,
		Secure: `64907FF8FFB60811ABA48B02843237E6`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFC00000000000000000000`,
		Secure: `2EF604B843408B379249771F06338702`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFE00000000000000000000`,
		Secure: `34B1AC8FE48B2E1612F2C7B8D551F580`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF00000000000000000000`,
		Secure: `727A189D6432AE91F65EB3BE1FFE6221`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF80000000000000000000`,
		Secure: `96A741A324A6FBC35495FEF3C88458EB`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFC0000000000000000000`,
		Secure: `23D38A17A0561E3D0AFA28EBD4380375`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFE0000000000000000000`,
		Secure: `54C326D08E7BA0D6316744C1B5CEF305`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF0000000000000000000`,
		Secure: `82C639281D58DC36A8E0DCADB54CE7A5`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF8000000000000000000`,
		Secure: `AE437EA5E97EA93F3B6A668ECA9B5551`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFC000000000000000000`,
		Secure: `6E053332D9AB0B58666B70DF6CABD6B2`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFE000000000000000000`,
		Secure: `56360308A094F8017432D089887AF569`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF000000000000000000`,
		Secure: `ADF991503994FAC4FC02E941AB4445E5`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF800000000000000000`,
		Secure: `9141B1DDF50EECE9EDD85FA53FCDDFC0`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFC00000000000000000`,
		Secure: `E38F53A5CBC3905DDE99F0C70FF479C1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFE00000000000000000`,
		Secure: `76AB72AFA40202185414EC3DE8CB6B72`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF00000000000000000`,
		Secure: `19BC59A3B974F89595E60ABE0E314FF0`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF80000000000000000`,
		Secure: `8D3AEA4F0CE0496C17EC0A4C1EC08130`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFC0000000000000000`,
		Secure: `F878085F4F36F5F303340D6AFAE432BE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFE0000000000000000`,
		Secure: `4A560C802AD3DB31FA6C6560C4BA2207`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF0000000000000000`,
		Secure: `45AB06F2EA96C131B955C3B3FA614293`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF8000000000000000`,
		Secure: `E03767F23E0768B63A036CD0A092B6B7`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFC000000000000000`,
		Secure: `35568830EEF29843C0911FDC409303D0`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFE000000000000000`,
		Secure: `20124C116E2F18F63C9CEF15386DB442`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF000000000000000`,
		Secure: `964D558D5215F5597BD210E97012572E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF800000000000000`,
		Secure: `D71EB0255D143F896708CE1C05C1AE60`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFC00000000000000`,
		Secure: `12CBA89AAE1FA7F02551DF9BC2AD998B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFE00000000000000`,
		Secure: `1F96415A268F9E4248707E56E1FD5B52`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF00000000000000`,
		Secure: `429D15E1030ECBC5A4957D0877D98ADA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF80000000000000`,
		Secure: `3977579668AEF686C8E1528DD20B55BE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Secure: `FC9FB0937516EEBF12A949986D6F56F7`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Secure: `A4AC75F25A2A27D1806FD9A71D9D1CC9`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Secure: `6ACD5F24598070F2543C4C26C47D8866`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Secure: `B6E54928BA98EFD59E7DCC6B36987945`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Secure: `8FBFDF9072FAABD64F9189F790736A9C`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Secure: `3B2594604FD5F4A52A372B735F6E7FA0`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Secure: `01804BE664749C540C57B1E367E4D343`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Secure: `071A17AD3D53B563E90B04E180F79021`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Secure: `76756AAC8522E2D47E46528CA262DFBD`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Secure: `106AEAAD683ED08261B379E9C423380A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Secure: `199E53ECC553C64D69B62BBC3806C484`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Secure: `050FFBCAD06C5989D047EFF112CB805E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Secure: `76078F0ADE4EA297EA6014EA622039BE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Secure: `83EBA5CEDAA010D8FF1ECEFEB47D9F63`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Secure: `3DDB5CD2CCFE835C1A3A6C69099CA640`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Secure: `D4FC023F80C746CFF58656E2B5A44869`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Secure: `A4318C095D2F2E4B568FBB646978586A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Secure: `97AE7B5B144260AC09F10B3F1DA29B53`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Secure: `6DD5EABEE6501FF0410A7219C82189B7`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Secure: `711DFA8D35FAABE7FB0B061342726E26`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Secure: `B38EAFE251852A265BF1FA7E7F1660B6`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Secure: `4AEE31DFEC906EE02D5A7E3EB4D0FB3B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Secure: `03565C310F7C26E14EF63D4E50D4CABD`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Secure: `B982CE4EA46AA6362FA22FC98D8802C9`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Secure: `92B1B5F499FAF18643B78A40DBC8B8D1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Secure: `5198EA51BEEDF01766D6179C56A098FE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Secure: `0B97D5F7DACEF1F0D93D01A2A7AC260A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Secure: `CB48270A1EF6F770630B12C878AAFD85`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Secure: `60CD00777FD8FE01BF4A335F290109E8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Secure: `3901A1FD4954FFCA2959924B0BE39EE8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Secure: `E3D602D2E4A256EF89D41606D91B7896`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Secure: `FF7D434F5312171265699EB14448FFC3`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Secure: `5D52A6E31C60D179BB512116B3422F39`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Secure: `F0B488FD3278512A65AFC8012CEADAED`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Secure: `47A0E90FA62D40567EBD9E04CD1374DD`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Secure: `9E99FE38DBEE3D09930F40648AC03F35`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Secure: `7731811DA19C008AB2E6CC5933324D86`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Secure: `BE8E3915139D0599A371E8D8B0C606D5`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Secure: `F5C1F04471A9435325C9AA4FED7FB104`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Secure: `9B5EE8F49460A5A73D03A4C5E57D80A8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Secure: `4C7FE9A0B26FAC6D936C1C15F349E854`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Secure: `B5FA5B40F72FB09CF78A6A6204EA39BE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Secure: `27AB77649ED4273B0648E9D7B2E94D08`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Secure: `9ED11A1E021B713F46AF8A2C599A1970`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Secure: `988545566FBAB9A35FDE56123D9990CA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Secure: `8C9A0D26D35D4D008E03D6B9A887AA96`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Secure: `1DCB19C679572D55B49B94CE6B417AA3`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Secure: `D7D01F8A2C5F5537B71BC90A35D09D44`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Secure: `6952110C55D599852EF8DFDA9602EA30`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Secure: `41066AC7EF009B20282B22E32AE9F55F`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Secure: `7BD5227E10E2B69110CD8F4E55D6490E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Secure: `C824D656C358C48573D070F6DED363F9`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Secure: `FD5FA90D9EC6DC72A4F2CE21E08B92DE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Secure: `8E92E174553D5F443DEA15559F0952AD`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Secure: `793AE0F13E152CD264EEEF7D88735FFB`,
	},
	{
		Key:    `800000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `694B918EB7F7DDABF49311CEB83C5D53`,
	},
	{
		Key:    `C00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `17B9134A35BA469F4F2EBFF8C1E168A8`,
	},
	{
		Key:    `E00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `701FEDC1BFFB13F93D67407393264589`,
	},
	{
		Key:    `F00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2353E16E5608A7288E3BB7EC5438A148`,
	},
	{
		Key:    `F80000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CFB0557D8B05D454F4404C2907236013`,
	},
	{
		Key:    `FC0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4CEBBF017F2758669A45CE507AFBE7E6`,
	},
	{
		Key:    `FE0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CA8F072BA722CB13F150EEBA268BF5DA`,
	},
	{
		Key:    `FF0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `39C0E4E6706B4BDF1E6E72A5EDAC08F2`,
	},
	{
		Key:    `FF8000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `25F1F10BA9A6D150DC00BFF72B4B048B`,
	},
	{
		Key:    `FFC000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1C8ED9E1FBB708D35D541118629450CE`,
	},
	{
		Key:    `FFE000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8A8167E3C15ED0B0F46E582527E42EFF`,
	},
	{
		Key:    `FFF000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B25CAE4F8D95A7D74DEE28B95992F5AF`,
	},
	{
		Key:    `FFF800000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E8F7D521A0409145EC5EF2CCA5F030B2`,
	},
	{
		Key:    `FFFC00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D37984182EDBC0F77BA871687CB57633`,
	},
	{
		Key:    `FFFE00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BB0535BBC30E741E7D55E9E421A81F56`,
	},
	{
		Key:    `FFFF00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C9F04A67CB96515DC814D78023CF1FE1`,
	},
	{
		Key:    `FFFF80000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8431723B85AB45ACBEBC8469C14CC203`,
	},
	{
		Key:    `FFFFC0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `90072FF09B5438CD2B4CCAAB35571247`,
	},
	{
		Key:    `FFFFE0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `46DD196111D676B0EA102AD9A68C87DD`,
	},
	{
		Key:    `FFFFF0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `76CC512D37353B4D29D47F2C4871A923`,
	},
	{
		Key:    `FFFFF8000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `56AFD63D0130B720E529EA4FBCD2C092`,
	},
	{
		Key:    `FFFFFC000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7420CC03ABB2405F9C74CC10070AD04D`,
	},
	{
		Key:    `FFFFFE000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `099E1FAE9A8781244F88FD06B9E1759F`,
	},
	{
		Key:    `FFFFFF000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `46507EF89A8A605021C9F03DC5EE5991`,
	},
	{
		Key:    `FFFFFF800000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `38CEFDE11376043AB42FA3495A3F732D`,
	},
	{
		Key:    `FFFFFFC00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BF1429F53487ED93C7FADCDDEAAE006A`,
	},
	{
		Key:    `FFFFFFE00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2D3B389B05760FB7D98775C2D7E88D7C`,
	},
	{
		Key:    `FFFFFFF00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `308526F33CEC944CFD57AF0FEAE0755A`,
	},
	{
		Key:    `FFFFFFF80000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `06734C9EB13BAC87C8A2DE3FE3FB1D12`,
	},
	{
		Key:    `FFFFFFFC0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `58EB139FEDECFBD0BE56F40203EC913D`,
	},
	{
		Key:    `FFFFFFFE0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1E8AB789AB8EFD66304033E66B552AC7`,
	},
	{
		Key:    `FFFFFFFF0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F960831629AD7FD3C058BEDC197B0C7E`,
	},
	{
		Key:    `FFFFFFFF8000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DA59A759A6457AE51F6836A1498AFC54`,
	},
	{
		Key:    `FFFFFFFFC000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2FB44E3711817A90ADCED7FF1F73D94F`,
	},
	{
		Key:    `FFFFFFFFE000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `858DEE10261C75EC2F44059031CFB186`,
	},
	{
		Key:    `FFFFFFFFF000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A87D2C9BEFFFDCAFC3F3449220DF1BF3`,
	},
	{
		Key:    `FFFFFFFFF800000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0B327B74A82F739D4B518FC69E8041B9`,
	},
	{
		Key:    `FFFFFFFFFC00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4ACBD78A489D7AF1AF1E9F2B84138C94`,
	},
	{
		Key:    `FFFFFFFFFE00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `64049BCA27229BEC05A4C2E5C1A4BC45`,
	},
	{
		Key:    `FFFFFFFFFF00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `02628F26CC69109AAD9CA9BE5FDB9C97`,
	},
	{
		Key:    `FFFFFFFFFF80000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B51EC0FEE521ED0A3309F08E0C5F8B9A`,
	},
	{
		Key:    `FFFFFFFFFFC0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EE5C17FCA9995CE006F932888D945B54`,
	},
	{
		Key:    `FFFFFFFFFFE0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3110D6A13BAA55E996603AEFD1A5525A`,
	},
	{
		Key:    `FFFFFFFFFFF0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `12ACE4B9D31CF8DF318F377C57B40952`,
	},
	{
		Key:    `FFFFFFFFFFF8000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `340062923066AF0D616A6FB33BFC9865`,
	},
	{
		Key:    `FFFFFFFFFFFC000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4E193D8355947A26D1929AD09D302620`,
	},
	{
		Key:    `FFFFFFFFFFFE000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DC005F318B655A86DEBD9A197BB6F25F`,
	},
	{
		Key:    `FFFFFFFFFFFF000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9183ED9EB78EA94C2693BD1D721A4A7D`,
	},
	{
		Key:    `FFFFFFFFFFFF800000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `02179A08ED0C807D4AB9DCFC605B39BF`,
	},
	{
		Key:    `FFFFFFFFFFFFC00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `324465450BC95BC0079BFA46678C3C93`,
	},
	{
		Key:    `FFFFFFFFFFFFE00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C7D5A5E9DB839B7E825DE2499CA60639`,
	},
	{
		Key:    `FFFFFFFFFFFFF00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8461062C02B8F807ABE1B64A263C83C8`,
	},
	{
		Key:    `FFFFFFFFFFFFF80000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FD4C829536E6E4A947640652D6D268E7`,
	},
	{
		Key:    `FFFFFFFFFFFFFC0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1FCDE498D4676F75771C2334F8D6251B`,
	},
	{
		Key:    `FFFFFFFFFFFFFE0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D24E5113DF1010B3C91A58EA43EE2B64`,
	},
	{
		Key:    `FFFFFFFFFFFFFF0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B4B702714D6B8E852730DBC568B989A6`,
	},
	{
		Key:    `FFFFFFFFFFFFFF8000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A88B3F49238CA6F2109188C011380A2B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFC000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `37B919EDDD957A3345D1EB1B05A53BAC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFE000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DD6468D27FFB41D0E07EAB3803691B4F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `551A0CEC23FDDABC1A1AE34CFC823FD4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF800000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B40D50030EC115CD0FB28C1BE57B5CD2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFC00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0F9A2EA2E0AB97A07EB203F63AB0B73A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFE00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C186275DEF8A04CC32466247E5010BD7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EDC16A481F3181645288FB75EE459F30`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF80000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `279AE7A1DEBCAF9EA04950F77FED9D39`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFC0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `129526957EA39E8F7057D886845E628F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFE0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `425D0D52DE0FC90728418652F879E3EB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `55E52EF609850570D4E883AAF9DE65FD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF8000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F9B3CBDEDFA3D8CF1EDEBB034763D97D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFC000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DCA7C26750BEA483EE77234E51763F30`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFE000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `86573D687F3855129A2ADCAEC4445ED8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4B5C57E903B1167265FCDB885EAD613B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF800000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C19F4237816EE25903DEE1B52C2400EE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFC00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4BC5A88C6A25CC4D8DD58710C13EC2BD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFE00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A7CD2EA0E5FE5E533B87DF328F8F2FF1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `02D4B7504CD14C2A51A9C205B8330DBD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF80000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C192CB4BD1E63ECEFC2E424954E1C736`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFC0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AA7CB151E8A8EBAC335EE4802EC5DDD7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFE0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `251205AE30CD112EA25B589D719A5AE9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B735B4F32C36DDE18C529B45171F8851`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF8000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7449C3B6D2E19A7093F671A89BE5A774`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFC000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `00BF024313FBE8FA51DE380FD8E5C827`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFE000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8B943D628FB9BBF5F051A88BC3C8C902`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E5CE9BD74CC9010E36E347A382672086`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF800000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F713ADC8DA8EA2AB9FA99244083F6816`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7DC9761D1477801072B9522A99575CB9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AFCA963DF90B98FE01A65B07B431B0F8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `18AEBC6D64ADD074ED804F7567EF45C9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D459C88E2E3ABBB601585FA098E203F8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8282FE1FCCD641661D076A328FDCF560`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `13A6BC2D2F11C8F67EC6AC06B71EB02B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `20EE510B082EE4C1FE62FE2FAB9B2B32`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2B0E41DFABFAAB83DF0D3B2D416E753B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EF9FAC5A6B9E9CDFBB87A44A80E03560`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `34ED9DEF894851800178604DACC0818E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4B096C94CF10E45F0F5E6BD2FEE65ED7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `73EF838B80FBD2722B14C9E11BA94749`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FC7A34D4C8DC441562C2422D8EFF8493`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E16989E79EF6ACA88C91F42693FCB318`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8B4CAEDB36F25CB04E5672F340537FDA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `01A334D9E84ABCC7FB1ACEEC6979BD73`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0F6025E7244855F5335486166016965E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D6357A505C353F3E864F3D36CE7C031D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EDF76532C86CFF0C30D1AC91E2DAEEB6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A8BADFEB37CDD39AC765369841F677DB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E0BD797142BB5713568D1EBB2158BFD0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `192AA0E755B054206F8C64F6FB3A8C55`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E1169315A550B41F18CBB1F184334B87`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5717D25E54453415107925B1821ECEF8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0D1FAD6E5399DEEE8CCCAD98CCA65F8C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6AD4F7648A0381CE989693CA1BD2E152`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4B3C1FC485713665822B86223870B412`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8B1E3759C88EB409FC9267EC6AE02DF3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F9686FA229AFA0B50F0CEB2C7086EC9C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `47603FC09BDC0ABB507E3BB3C3BC8C95`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `88DE0D8963E38CE9BDE4A01D378945FA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E04D601E7EDBE8F4C798F59E7ECC2C59`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AB55E7174D79F04794C88BF70666E48B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0F2219E41258379F64AE675780DFD01B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5FFA50FDF4694A37F04DA2FAC8B196D4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FDEF54AB92212C6EA3387B2D20E64C8F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CC9E5F6FCE54BA310CF44625022B2042`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D4A1A573B6447E5ECC9BADA0F6C26035`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E5E5499F22D222522366C2CB4C014B62`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1235AC9FF150D15127ACD1477B0CB1A2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D3BEAF5287DA5D8732DEBF967163B53A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5BA8614E4C26149556555BA4EBB90201`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `534A92A6305A9CDB54A219544A26B300`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2FC291384CB3FAB1A381E234A8A65986`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `94B0FDAA193368A6701B7CAA3CCA5FB2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E53828ADC131BCF0996CFF2D3CB60F6A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `13897BE957833EF777658B4758CEB488`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4165CFF197221465A9E0426EF0DEF57D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `62EEB08E428D2EE4145F10A7CF7ADE0C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `46186FD0C14DE51C6C2C627AD70742B0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C8BAD4979CC695E9AA38C66D5B8DCD42`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F5E3D26C2EF3AA7FA9BD9A96889A78EF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7CD314FD983E49A80E4732AFF1D1F205`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E207A09A55C5D955C301FBD65D59B0CE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `347A3AB9A12AB25B267E58F4CE82E15C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9161DA77DC36E1EAB37FE9C53DFBF85A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1EB23FB4F74EFBAF81FD2CE9F11ED412`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1A8EC34B11499F959FE92E8D51F2436A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `792E6FD97CC0C50078C6FE5F1F62DE99`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9D0165C50D6BB38D3C8E38AD3302CE2D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `81E1B21F3EBDFFD5EF231AB5520AA6DF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8176BDC82DBE2CEE688946D0CE755E12`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F42A93B5E55AAF0252E7A5444A6BD70D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1B9602220AB7E7500828825FEAC568D1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C4460929188DBA2528C4F3D8BB678EF8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5C5C23ED61204C441FFC86639B5C5634`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8CC3D09D2081E73B53E6B576F6B1A986`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6F430D544FBBF442BEB831CEEB9B7904`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C4774C1C2416635181A2744481C370E5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `33EA9F3A9F8FEEB55D1B672A88D36B60`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4F9CCE1914F3EB950907D4EF2EE9534D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B6C4B4EC5EDA331BFF5C55557582A317`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7D824145CD86DE9B48CB4C94A1A51C8D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `199F1896981AFD8B973E540F1435B362`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FD705883C10C0A441FA8AFCC484240AF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CFBE0C8D0A2CF79FFD7C93B490AAA614`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A3E6E1758B4F07D8DF5174291DBD1773`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E0D1D6545F2ABEBA9874F9B0AB93A4FD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3AE630EB937C6A4F78437195E85B6011`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4769D15681E876686A60085793D695D7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `26EECD56302BEF8424FFACD961594A92`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `91C4416D9557CCAE81E8231053D0B9AC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `09E75608EBADDDD72627156C49CFC159`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `76A1FA5FFDEF08787D9F291836145A99`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F0B357F2533741FD43816254E3AB72EC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CB16463CC55F693869222299962963EC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9D1B4CAF851126F887C5751C43B2C818`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1248A91AA8BA093C45AEB38D11E8B1AC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `65ECE46B0A1D65D15DEFDA6C0E100C6C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A8ABD3D57DAD34147DD6F129E8B379D6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8D7433B7EE2C5458E09ADEDD6F351B8C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `11F2197444528BB05AE25914845E3495`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5F8365CBEC208FC882B70D749670F67A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B460BD8A8868EEA6B6C1AB450F0201F7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EE45EDFBE4125E5014AD0AEA1DC43892`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7CA969273D75E7ED798F3B56057983CD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `014F84939057309F94979CBEEA9C74AE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F7CFE9D995FAE311091EAA664572EE1A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `61F700FABAFCE3A497BB90CDE1E0A932`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E6E4EAA27B749C207BF35BAAD8800294`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F47B72C66EF5CD511ACB294FB73F7F42`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `598E84EBCDC047FF0262F18ADEABC993`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B3D1DE1A2C02D61401BB6F49DCEF07A9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C78DA1569A64B9B6E2894393EDF5CDE4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D5A98C0A424A5D3992B92AD7B6C5FCCA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E9B20A7FAE806BFACE7BEE1447F3BE3B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `147ECD0C84ABABB0B22F07C53B30FBA2`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `724F8279123B9307658A109101466A15`,
		Secure: `3CAEFA9F6A239EA22053E18DE6B3BDEB`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FEF995090770B941B0BF2B120A859BB8`,
		Secure: `4A368BCDD2656E05347C3620C97AA868`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `76718FF5B60510FB4A9AA28CF9A57A60`,
		Secure: `4545AA808509A55EEEA31ECE653C1A81`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `AE38ECC785CC238F263D14285216B406`,
		Secure: `E609A55993999F8F7675064243062064`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `BB0F694719D4BF967A085D4FD98A37E3`,
		Secure: `DAAEC1BC206BA5B3F4F7018AF6E11026`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `F3F7057F5670F3E8BB9D9AAA95F12F71`,
		Secure: `CEB27BF64AF900A00406B17FBDCC17AC`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `EA30FAB7622F0A9F9EDC2821CA7D0968`,
		Secure: `56B2D169B99A9A64DA17F4AE73BBEA7D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `763DC878A1E4931417E6A4DFFE9F72C1`,
		Secure: `2C9102A4744F56CD529CD5D7ACE50BD5`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `ABDD298CBA9F58E05D1CEA4CF40758B5`,
		Secure: `13D597DC7EB46D0927F1062059474A9C`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `DE121DFC8FB169DBE3201910B2A7E7BE`,
		Secure: `3AABDE5154E75F6D92071814B1631EE8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `A51DDE1048AB121F60D28D167EAF8C94`,
		Secure: `46F076C50D032E8281D91420FBB2C022`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `D47EEC51485EDF05C753E385DC91F52F`,
		Secure: `A2089399BC6B97609682A99176BB7C8D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `81F8018935DB9E254E05F8C891FE0DCA`,
		Secure: `B8C48C5D7352C8B130665F764B8B5D34`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `008A1DC0F3735B596A88E986A2E603DE`,
		Secure: `0C843B45E840F39E097D3A7905A32431`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `E6767B40A8B765BAD0BE13A9547B4422`,
		Secure: `65C6CE96E6D8969C1C956548146BCE60`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `093D9891B97847A075C7135B2C2D7B91`,
		Secure: `12692AAA87D3146E79CE98E2322DB984`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `7DA0327DCAC8CFA58E04C603F0AE9763`,
		Secure: `616F578FFF859FD25416769E796B0FB4`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `98A0450CC1F60AA28F16494BA3EEC411`,
		Secure: `21B26E218309006FE6B606B6CA72B8CA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `EE7D0F88C29545B02FDFF91C8C1F6F54`,
		Secure: `032FCEFD4F2A64D23E1092E99A828E1F`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `54B90C7934750C27617F739F2FB24626`,
		Secure: `F4B75C83491A2BE33A9F2C722CDA78E0`,
	},
}
