package lea

import (
	"testing"

	. "github.com/RyuaNerin/go-krypto/testingutil"
)

func Test_LEA128_Encrypt(t *testing.T) { BTE(t, BIW(NewCipher), CE, testCases196, false) }
func Test_LEA128_Decrypt(t *testing.T) { BTD(t, BIW(NewCipher), CD, testCases196, false) }

// 암호알고리즘 검증기준 V3.0
// 테스트 벡터
// LEA128(ECB)KAT.txt
var testCases128 = []BlockTestCase{
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `80000000000000000000000000000000`,
		Secure: `CE8DCF04DD60982B1D8F5035FD534DE2`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `C0000000000000000000000000000000`,
		Secure: `196D7D801A91C862CB9FC739BB42EFB7`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `E0000000000000000000000000000000`,
		Secure: `9AD0A3385AF3D8A2062B67E0B162F47D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F0000000000000000000000000000000`,
		Secure: `825426C40976FB0E0DBEF135BE25CC25`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F8000000000000000000000000000000`,
		Secure: `C73F835D04197A4CAAF59AA0631A5A18`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FC000000000000000000000000000000`,
		Secure: `D39F215E6AFC8FF9B1E24DB7A9A52903`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FE000000000000000000000000000000`,
		Secure: `C1F0150CA39427CE9E1CB1A518136A4E`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FF000000000000000000000000000000`,
		Secure: `AD2FBBEC64C2E74BC447D095EC02559B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FF800000000000000000000000000000`,
		Secure: `E33EC75D3AF34FDD5D73BFE80AC92D6A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFC00000000000000000000000000000`,
		Secure: `08D7224CEEB038A21DB8F9960064DD62`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFE00000000000000000000000000000`,
		Secure: `B5E1D33CF7C943B043B1A79341A3C1CE`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFF00000000000000000000000000000`,
		Secure: `2D116F08A782B6D7D92D4A3AC3A28684`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFF80000000000000000000000000000`,
		Secure: `EC426825FA172D5C77F43F5B02726D78`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFC0000000000000000000000000000`,
		Secure: `E7CE58E798D74D5B685BD01FE222812E`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFE0000000000000000000000000000`,
		Secure: `1CFE78BB1031F68B5A0173D205C6DCD6`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFF0000000000000000000000000000`,
		Secure: `0539587EEF1313DBBCE5FF72F39FC84B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFF8000000000000000000000000000`,
		Secure: `0BB8E2793180DB07A69291F781715716`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFC000000000000000000000000000`,
		Secure: `35D5FF905F8E21C93E9016E92A42A989`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFE000000000000000000000000000`,
		Secure: `665C1BEE9EA4A6C92D78D79C61C04B49`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFF000000000000000000000000000`,
		Secure: `913C3BF589E9574A980015E814F1546C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFF800000000000000000000000000`,
		Secure: `E45E2E58E4CB593368F47B660BAE753A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFC00000000000000000000000000`,
		Secure: `5E5F431561CCD084D50EFDEFEE9435F0`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFE00000000000000000000000000`,
		Secure: `3153CAED5CD03086D25E1093A1DCD696`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFF00000000000000000000000000`,
		Secure: `1E1BE9A93ADE255FC7DE97A15FF46B3C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFF80000000000000000000000000`,
		Secure: `1DC80F97349CC8C762F955A8814B7BFE`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFC0000000000000000000000000`,
		Secure: `F40FFEF66C6D12F5F8BB60D9F55CEFB9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFE0000000000000000000000000`,
		Secure: `7273C6A85F03B32E5FAB1E888126FBE5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFF0000000000000000000000000`,
		Secure: `292FB857EEC571C02F1C700DBF29F264`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFF8000000000000000000000000`,
		Secure: `10414470B27127DF500D5D6ABA13E98D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFC000000000000000000000000`,
		Secure: `647CD211092AC976BDB9D8D472D469B3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFE000000000000000000000000`,
		Secure: `9DA369BB7A4CB52F0801A3F31C696D3D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFF000000000000000000000000`,
		Secure: `7172239F1DB2CA3B5817013FE020962C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFF800000000000000000000000`,
		Secure: `5703C50CCDE97629DCCB93DE37E42505`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFC00000000000000000000000`,
		Secure: `EE81F0BE060F5FE92E25C45E2DAE11CF`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFE00000000000000000000000`,
		Secure: `AA9BDFEFF75CB631A830DAD94CCAF081`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFF00000000000000000000000`,
		Secure: `755E2C24D72CF8091C6E90F2135A0173`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFF80000000000000000000000`,
		Secure: `B0A09CC6C62F36FC79C82C6E10A6386B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFC0000000000000000000000`,
		Secure: `D33D538DB001B329F8AC0F57DA4B74C6`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFE0000000000000000000000`,
		Secure: `52B36860EC08372A799FE60E7521965C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF0000000000000000000000`,
		Secure: `25EEEA1CAE4AB33A859E95686ED18445`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF8000000000000000000000`,
		Secure: `53322C905A32B781AA6ED9F015403566`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFC000000000000000000000`,
		Secure: `C7967E739354B1302FB4578FBD725842`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFE000000000000000000000`,
		Secure: `843BB2771C90A0E21DB399E995F022F5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF000000000000000000000`,
		Secure: `0183A2E6FFAA00A88E72EBC1807731FF`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF800000000000000000000`,
		Secure: `59CDA812AD3BABE290104BC81DB03F34`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFC00000000000000000000`,
		Secure: `C30EACC58FA34F508E5ECC4DF6CB2DE9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFE00000000000000000000`,
		Secure: `A77CFA7CE4DD1065776DFA622679349F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF00000000000000000000`,
		Secure: `4276CFB138CCD8E00954E9A29D25B8B9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF80000000000000000000`,
		Secure: `84BA1DB1E95875AF74EDFE8D1BFDC571`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFC0000000000000000000`,
		Secure: `FDD6291756537136C90BA3EE718B8CFB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFE0000000000000000000`,
		Secure: `F7F13E1D62367630C7F9E9499873E9C0`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF0000000000000000000`,
		Secure: `8F8E69C9FC90642D0A13A70E134756F7`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF8000000000000000000`,
		Secure: `BBBAFC3B8EA00DE2975FEF090B7C2167`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFC000000000000000000`,
		Secure: `FB7217CCE67D123107A9E29B6D8F3C7B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFE000000000000000000`,
		Secure: `0CC662EFF553B1D940CF75416DB667DA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF000000000000000000`,
		Secure: `A42A3C5F269DA61B308578542C90173C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF800000000000000000`,
		Secure: `266963E494A1CA9BC46773A5A1FF68A4`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFC00000000000000000`,
		Secure: `BBF8D055CD4C9413722625FB508AA310`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFE00000000000000000`,
		Secure: `EA072663B2F702176D62D859CBB687B3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF00000000000000000`,
		Secure: `87A2A798920788BB9A527AFD9294F550`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF80000000000000000`,
		Secure: `5F39F71BC6A297B017B6F6023F71AE4C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFC0000000000000000`,
		Secure: `31A81D816EAAB0A363B81B5DC82DBD57`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFE0000000000000000`,
		Secure: `BCDFEB36C74AE08F0277FD6D5AB9F685`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF0000000000000000`,
		Secure: `E49609E2FE47B273CEE4D0202B117E38`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF8000000000000000`,
		Secure: `ACAE35F0FF36A57058988B74C78E4483`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFC000000000000000`,
		Secure: `A490DE333E151CF96C0BACF671F10829`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFE000000000000000`,
		Secure: `5D1F93E7DFA3614442898442E8A2261C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF000000000000000`,
		Secure: `972924787763694BCB11249F2749A5AF`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF800000000000000`,
		Secure: `C8326E0477F1235BA61897AA8730D137`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFC00000000000000`,
		Secure: `E8E1101790C8DCBC509C7F4AF17BD036`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFE00000000000000`,
		Secure: `0C356BF0788AC4A3D755933B143087FD`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF00000000000000`,
		Secure: `DB1ADEB2E36CE367B09F77480EB813A2`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF80000000000000`,
		Secure: `CB0FB53ED9AEEBB0CD02FF97BB58D037`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Secure: `954F31F785EFCE400B47AE8EC3CD8FB7`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Secure: `F9451258416B3D64A4BAF2DC9EA591A8`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Secure: `8A686CCFD69078ADF0225E9502075563`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Secure: `5E5D7280C37B1DC096C06C2F9AD8ECDF`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Secure: `C5D9A71D6C09392FC4870C0B0B7E1E8F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Secure: `D846CEADE7A6CD06619C08D9B7CDE682`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Secure: `351BED04F949C3163198950565DBFF40`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Secure: `4626CBDE45DDF87072BAD9634BAE6499`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Secure: `79C031960F24622657B2E8A1F707C5DB`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Secure: `74E2D62A3153E2A68804FC017C1BB4F5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Secure: `244FE1C0A89B3CD5A5ED9DD4C7B6BBCE`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Secure: `06C3A6715172F7BD69217C5E302CBB5D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Secure: `34D185919D633211DCF0960FC6F5B252`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Secure: `3114C1E01C092F4D40F09395D877826A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Secure: `E01A250934DA0A743ECD17D123054099`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Secure: `F1C876EA91B4C2F02CEC0696FFD37F5F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Secure: `BD06E4A45F3DD62CE9AC4B5F3E1BFB3F`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Secure: `3316FE34467E233AEEDDFF9CD367655D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Secure: `0AF6572CD29F895C4065230011A4CAE1`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Secure: `5316EFF7892A30AC4817994369524BFC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Secure: `C5CDDACDA663C11F9A6A72E7234347ED`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Secure: `40B2E96385B4ECE6CC025D1DDBB7D425`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Secure: `BD9DDEF5A3F8F7594AE428A59F902AA6`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Secure: `712071D3ADA6532D07A20D03AF649B88`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Secure: `8DDD1D809106399353B19B1C5BB2C067`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Secure: `11932D5C751F63349CE4A82D7809970B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Secure: `D3140DED37A637F1E4E7B5180434313B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Secure: `5B18BF419519DF77484619272BFE95F3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Secure: `DD1E816A72AF5B0BFA9C9498133E31F8`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Secure: `0B334A72C3B59FBB7180C4E809A077A9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Secure: `037F190320DEE1EEC2A586E6E2D97D87`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Secure: `9E2631B6B92CB108C9DE544FAFCD9D20`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Secure: `D9ED3DCF946D65AAFCED541D227F89E9`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Secure: `C4D856F41AE51F5B7A741A2407EC703B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Secure: `7070E50DEE9B3C3249871D955CAD00A4`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Secure: `2CA5C7F0E0836F8646A7D20BC77B5B0C`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Secure: `FAA101F6F47A3CE5EE68268A0C1C32A5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Secure: `231E5386F9A918E0B12CF4AF968AC0DD`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Secure: `7F33CDE311B8201A3E468C1CB948E236`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Secure: `63E35D7A58876FEF288B1CC9D4B1979A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Secure: `62D75F3BDC019332D49E8DD900958BEC`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Secure: `D77F98C50E8F70F2C3323A6FE903CB53`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Secure: `FF82A84FC55250B8173D80573598321A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Secure: `9C9A71ED4CBA875A5D5369F736E58106`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Secure: `E32C52820E4CFCE1ADD98CD854BCE5D4`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Secure: `146DFE1B7B0185F0531E6D924D8CE530`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Secure: `151F27AA0F4709DAB1C0BD5A37F5B336`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Secure: `AF0662EA274E477C8F60D7780D9F9CD7`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Secure: `02658859C0F7873F07A9B79C1D9335A3`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Secure: `D84E25589EA0150B54984C43D04A0A34`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Secure: `94B692A5938CCA2CEF604732B73D5229`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Secure: `2BE3EB5A2A543F3B4BEA76E9D63331E1`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Secure: `33F038E4AF78989E02E1CB89275DD54D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Secure: `3A01FDC8CB58D29907DAD9DE198392EA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Secure: `5311E9CF5A38D30FFAB396F4BEFD4A62`,
	},
	{
		Key:    `80000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4D83E55D4BA87093B609C574E4F65A23`,
	},
	{
		Key:    `C0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E88C3F0294A029AAAFFE5C5CCF1C00CE`,
	},
	{
		Key:    `E0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `61B6A8C4513BC625EC4787F90705D734`,
	},
	{
		Key:    `F0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `714949B9E7AFA3393B0B3CF3DF546FC3`,
	},
	{
		Key:    `F8000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E2DB7082611BB498A079EA8E8C53F88D`,
	},
	{
		Key:    `FC000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E52F254632324D1493822A27408726F5`,
	},
	{
		Key:    `FE000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9407C26622BE16101D97D3E40EEDD0F4`,
	},
	{
		Key:    `FF000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6935C7978C3C7A9EDA8924F6949F9B6F`,
	},
	{
		Key:    `FF800000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7B2743FBADA83881094B63F5089107B6`,
	},
	{
		Key:    `FFC00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0E25B9BBD07CE47553A09985423ECF72`,
	},
	{
		Key:    `FFE00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B0D144890704581CE6B1635544BE82BF`,
	},
	{
		Key:    `FFF00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B14B669ADBFF39F56B609A58A7225078`,
	},
	{
		Key:    `FFF80000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `85AB6B304D05B1626098B7D47EBC2BFD`,
	},
	{
		Key:    `FFFC0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EAE4D1C6190F19635064C4A79A2B8D57`,
	},
	{
		Key:    `FFFE0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D96AE7784A0F85DB4C2E8BA31B866DC9`,
	},
	{
		Key:    `FFFF0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7A66635DEAE4BF2B9C5C374F80CAF49C`,
	},
	{
		Key:    `FFFF8000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `257E0CFF96148C15AEE61D3058AE3EA4`,
	},
	{
		Key:    `FFFFC000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D7A651EFC30498CEB869D8746DDC1C98`,
	},
	{
		Key:    `FFFFE000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E68AB12EDFC2D483E19F450D431F9624`,
	},
	{
		Key:    `FFFFF000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6006735A54430E8505B826D6CF7B2540`,
	},
	{
		Key:    `FFFFF800000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BDA3ACC58E8FC48AD4F4C143F1C0773D`,
	},
	{
		Key:    `FFFFFC00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `880182BE64407B31CF4CE4B50290FDAC`,
	},
	{
		Key:    `FFFFFE00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1DD2B51066895585864ACE6A9B9759BB`,
	},
	{
		Key:    `FFFFFF00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `979B19C765FB634B62E17B8DB916B861`,
	},
	{
		Key:    `FFFFFF80000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BDB10B34BFCEC6BEE08F44DB7A750973`,
	},
	{
		Key:    `FFFFFFC0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5F91D78C375915A9191A6E3B87FFA34D`,
	},
	{
		Key:    `FFFFFFE0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `17806E0A55B7118E2C240C74CA0FE48B`,
	},
	{
		Key:    `FFFFFFF0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `110531FB9EFC8629EB9F8A3C16BF9782`,
	},
	{
		Key:    `FFFFFFF8000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `51C215198F24E8B1581FAD211F93A429`,
	},
	{
		Key:    `FFFFFFFC000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8B165D701E44BA61DAFE6169CD9993E9`,
	},
	{
		Key:    `FFFFFFFE000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A145536098C06DE6666575944AD079D4`,
	},
	{
		Key:    `FFFFFFFF000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `00051DA2418063E0FE7564F4F7BE1885`,
	},
	{
		Key:    `FFFFFFFF800000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FF0D1391672414E6DC8E16A2CD6B056F`,
	},
	{
		Key:    `FFFFFFFFC00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C5F4FB7E61B1252BA2248D79B74B05E4`,
	},
	{
		Key:    `FFFFFFFFE00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6BA19D3CBD0E373FB6FAAB3337419C06`,
	},
	{
		Key:    `FFFFFFFFF00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D43B38EF5C906961B5DD7E45DB476283`,
	},
	{
		Key:    `FFFFFFFFF80000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `281860584B49D8E4F80F712D7D12205C`,
	},
	{
		Key:    `FFFFFFFFFC0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C5DE51EBFFB3D3274FCCDA7DCE622C49`,
	},
	{
		Key:    `FFFFFFFFFE0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `46373EA8B2555FABBDA077F9DE7764B3`,
	},
	{
		Key:    `FFFFFFFFFF0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FD03A797083B310D3C1CE3CF2416573E`,
	},
	{
		Key:    `FFFFFFFFFF8000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4C79CEFE3503A6424B352923E05C233F`,
	},
	{
		Key:    `FFFFFFFFFFC000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FD1B4F0A6EB0EEBE8E102BC067AC604F`,
	},
	{
		Key:    `FFFFFFFFFFE000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `802367AE8A10B315B1CE7DB4195F98C2`,
	},
	{
		Key:    `FFFFFFFFFFF000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `47EFF98595BD0CC4F2B3E84F51AE41A5`,
	},
	{
		Key:    `FFFFFFFFFFF800000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2EDFA2C18CB27DF4732613808F79EE89`,
	},
	{
		Key:    `FFFFFFFFFFFC00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2B942597C6EA720BFAC77D6497D5A3CF`,
	},
	{
		Key:    `FFFFFFFFFFFE00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A162270ADB575B945209F245E8298358`,
	},
	{
		Key:    `FFFFFFFFFFFF00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BF55FD25C66FA6D22E5B4496952965CF`,
	},
	{
		Key:    `FFFFFFFFFFFF80000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `51D7D5FC72F7DDAFD11E4845C4458F4E`,
	},
	{
		Key:    `FFFFFFFFFFFFC0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6BD584B789FABB4C8BA0A9D6D915DC8B`,
	},
	{
		Key:    `FFFFFFFFFFFFE0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7E3B3ED61CF19123E438ACEF9965F1A3`,
	},
	{
		Key:    `FFFFFFFFFFFFF0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6F5AFEB31ABF4116920C1C98644FD497`,
	},
	{
		Key:    `FFFFFFFFFFFFF8000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4714547E153CDA3C50F6C5A95F4CB437`,
	},
	{
		Key:    `FFFFFFFFFFFFFC000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B39E8CAE24D08464A6249DF6829A8C7F`,
	},
	{
		Key:    `FFFFFFFFFFFFFE000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `030EC10B16EA74B1E24210C9D1FECCB8`,
	},
	{
		Key:    `FFFFFFFFFFFFFF000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `ADB7664E78DB54F031720BA3673F12B3`,
	},
	{
		Key:    `FFFFFFFFFFFFFF800000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4F8856C9432B8F6E0D00AD8F94180E33`,
	},
	{
		Key:    `FFFFFFFFFFFFFFC00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A911D1CFF90337155F6A23CB99A4BCFB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFE00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AD9074BF91A1D7404D3CD511D7F2D6A8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `12DC1BCC0C53BE870BCA3CB4192F8B6D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF80000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `33AEBC615345621569A83419AF321ACF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFC0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A34C28C481A204AC497E65641FE4393D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFE0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6714041F8DDD04110DD3A52E60F0D061`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F3C8BC941ABE5345FF78B729C0EEB321`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF8000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AA7B10BDE7D4504BA924D09DC074284F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFC000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `023EFE4E4CB9288EDE577581EB4F78C5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFE000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F7DA83B05B43B364C44B86FEC5AB3114`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8C21FD8433482B6D0019C4838BA1C7FA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF800000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E15D32DE5CAED3A030256A6AC003A8A6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFC00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2038E47C015494BD6B0A151EF53DF5F9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFE00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0B228743D6A8F0B7EBA6CD0F4C41E977`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0C441C78023DDC73A7C2BD4E3A917858`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF80000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `362D69FB68427855C8928604E7CD9C65`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `232EDF1E9CF04519FDD89631415F1EFC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F7CA12BBA8B9FD32971AE86879D45A42`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1411193286A448EF5B21B0300DCDE76D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `912B7C2A0C623E2148902DB7F8758658`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4024E61FC8A51940A170C7E1159A8745`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BFC57EEEFC1CE15CB9FDFA3200D7B3D8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `62C54A219DD9F647857730C1B1FFE562`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C53B3B1F2250432BF5E669854FD56C67`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `36601C40A2088E013ED74ABEE848EBEB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8468C9240AA1425290B435EE3615C9F3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2978F6BE27F551FDC1505C32A7C6B112`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2C2163B7EA3D64F9AAC7E4E44D48DAED`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8EE94847184286FA7FD95A80D826A345`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `132661B98803678C4C2F83C5949CA2B3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DD290C5C7BE64FAA4A4A210F9CA357F0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2FF8837E9A5A11AC0FFF3C3A351B6C18`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AD0390E0CEA89AFECB74199BD04FF960`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `51EC9BAA356B8F12CBA48AB2A30742C6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9F1167B341C1038C91C9839E40776593`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F81FCE369F112EB4F577E0AB19043BB3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `24483BC48308D7A1C99D1CFD527AF997`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F5545706DC2AC20F0D51B34D212E17BE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `064B7DC9B1E7852DD0222929B4D28838`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C7F0BD4E70D634D477AF690EB7006233`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1BF418CF0C0A80546671A9221859BC6C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `19C40495F80AB6CF85FEC3289495DD68`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `17BCED8D639BE99D93B97B709D6EBCE1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B3377E382E36B0A97317C3004B164F73`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5BBAA15E4EB4D7D0A828B2BA88306764`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `160717DDC0A1DC9FD6D688D750652AAF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2B7D4252C4E9D6E3BA00368E3AD5B6CD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `89019039003CD6D07712D5BF95C38D20`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7D19AADB1C2A9E7FBBED5563082E5CDE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `66D1D0A36FFCFF1F61442AF14A0DAF91`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `823B798A1156356A45DE81D8321281D6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A2C383A5194B11D7067A2850E8775D60`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `45CBD80AF24C251C639FE43C6F6C2E58`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1FCBE3096F66BD120D381C8E353C39B7`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5997335D517A5D513B3598DE58AF2CB9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9C895525D796515CC26AA9048D2FC23C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3CF4E0A67B3094CE879E8D65F03F3789`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `319E47AD78977136D887CDB27CE2168F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `90DF738B0451897E17D1E382AFFE37A4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `68A3596D1587B4F743F790C7FAA0F348`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `30A2CEBBE33B014FB343609B55B53971`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5A3713DBB73D3DFE137C14F3841059D3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `01FEDC921BC0B1C634B4FBBFEF26344B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3A755276D0BBCCA7DB22404C0E791D55`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `76D71E5FB2B61DE5CF3D476887A494F1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A15A22521F9F78A0FFB457FA9880F54E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `473AE0BD5C11804F1C6068CC28FCC50A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1D518BEB5BD67623654BA8088D97C338`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `318714C37E6F9CFC69ADB2B069BD168D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A160DAEC139B24F5A004FB9D9F410E20`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `35760B28A6575BFC90408A80872B0BB2`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `6E52BA79C8E46A76E58EA46586A4BA5B`,
		Secure: `95477D37FAB6EA969AF30A6F3DE2288D`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `3C006E246FF712DAA58CEEB601E4E227`,
		Secure: `2394F5896B9F786168DF1075BE2309BA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `0AFA4D21AF942DB8877687ED5DD509C8`,
		Secure: `9A2D9364FA4E69451FC153DCA2D3A689`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `EB0EEEA7E69822D53B37A65E99733722`,
		Secure: `8A88615E094904843316B6B5F2823053`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `2F492A29B7209B36B3FFC69FF6FCB55B`,
		Secure: `DE812EA64447B0131FE14E1BC4EF07B5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `67F81C5D028981201F389F84F7ED0DD8`,
		Secure: `500D91F09BA3C75A3C4464E26BA552A8`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `64A71B38E870FD19F1912B225B02073E`,
		Secure: `81AE4769F620610F6D43A6F455557337`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `3724C0EFCBB277E5D9F5A1CF2538AD71`,
		Secure: `D87D949C8144226D7F8892D8E8395556`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `317CE6F64B6D9A88C9947C1F94CD4796`,
		Secure: `D804DCA59831ECC2D4FBE5FA956DFF35`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `E3FCA40449FC4E49F2D874E72A3E5F14`,
		Secure: `3819623A8DB8F4BB4B5C2962B5758C81`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `1E30540DE7FDBCACC470823DA747BD8E`,
		Secure: `07E54C4E66085E108A6CD8C58B6F7938`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F4E68F45854D4C76F148DF750EE56AE9`,
		Secure: `8B26C3E901A7250430210F4B99C765E5`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `B42B2D22C409A9AD698D05259E57B04B`,
		Secure: `44DF3D0AE663A5448CAE29107492CECA`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F14C4859868FBB945EADAC21D9171819`,
		Secure: `9B8C0886EB1731B566E50C25DB561E3B`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `7AD639E0EB7AAAB24153CD7E80E46AF8`,
		Secure: `13F3CECE6036713B49A46F0DC8481C15`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `629598EA54A8E1CAC26EA19294BBAFCC`,
		Secure: `230CFB57AEF6A09F6EF980ED74AB3B97`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `F9973FEC633607E3D32BA1F156D831BB`,
		Secure: `20CEFF372C7AE23D2D98464463F53645`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `CF29479DF8820741A4F5877147B97829`,
		Secure: `31CBFA52745001E38E3698212E1FA16A`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `B7D709F134270869A77B4A26271A4EBC`,
		Secure: `FA72B144B376FB286CE03894BD549350`,
	},
	{
		Key:    `00000000000000000000000000000000`,
		Plain:  `C1701D1C790374218CA92565F8F9BB59`,
		Secure: `3B8E8ACB7031747BB78E7D68379BFA8B`,
	},
}
