package eckcdsa

import (
	"testing"

	"github.com/RyuaNerin/go-krypto/internal"
)

func Test_Verify_K283_SHA256(t *testing.T) {
	testVerify(t, testCases_K283_SHA256, k283, hashSHA256)
}

var testCases_K283_SHA256 = []testCase{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(K-283)(SHA-256)_SGT.txt
	{
		M:  internal.HB(`553C9AF8EFE7BB92F10713CE27897BC1E534CECEB8BF4990494AC06E36EC96CC3376122E34170E44E40D90463EFE507E8834B674714E549AA9A469E7B2F46E4A308E414F8A98E8F514A27E069F294AEDA0319660CA9D38D25A756A15D4BCF10B91F513D4CB1A7566830955E9FD2E40D12580B00D9382B23D8F661055C5090995`),
		Qx: internal.HI(`5DB7704D7B00F6EFA5FF56ED75DDB71D8F4EF35F2C66DE14CA56D9766BD881956B22CA4`),
		Qy: internal.HI(`73D831E5B3D8E66AACD9E5C8C45565A7F28C7A39879B945B35C35C543017DBD2A365589`),
		R:  internal.HI(`282B0D92601DC109F8C382480C44599B347F8ABA0E8DB380046A8009BD7AE64C`),
		S:  internal.HI(`01A3710965EAD2258F9B6C2569F88A866641AD44C0C99165C490D385457F165BFCE94075`),
	},
	{
		M:  internal.HB(`03E41F3CB99906DF954E36D0F5792E75783FED00801AA968E3E34D0D95EDC6F79A5CA20DFD5517301B43E7A30BBD38AA6352DFC431CD2C665926BEA93CC060C6D52481D82BD94AB24C82D854AAF6ABCC1765BFEB2A4671D45C2BA69E9921382298CF4A33BCF66944C66F21DE2768FBBB2CEE6E12DB7DD7D6BFBAF06B75F7D7B0`),
		Qx: internal.HI(`46F259F65130A785CD040946A0DEA6325FFB64BEFD470881B4D0BFF806663AD1164DFF8`),
		Qy: internal.HI(`5E70323B9C4DED35F8465EDD8242F15570914CA303B29E6CBC34980FAAA84CCF629E80B`),
		R:  internal.HI(`DAB2E6D3461AC56A851090E26A3C13C7D4222F18D548C72EBA5DFE7B988F0CE7`),
		S:  internal.HI(`00493F5C332AAC7EA989BE2E97A580E2E235A02BF9FB533DEEA3B38D0039D8CAF30B0463`),
	},
	{
		M:  internal.HB(`30B532BD11C6675191358140BF9FC5E3A42977DB98AFE518BE6330958074EE9F52F7181F76AB5FC61CC56084946FCE36E81B0BF1A16248CFFA7BA1A8520E54A51B7D81081D4F931E3EDCCDBCB3F3022EC89204091B64D7B78121283A6B850A0011F9992E1EA46E5735FC8000108F75CE7F21E2DD15CA9214C33D4FE933E13A77`),
		Qx: internal.HI(`7AF95285C9B5A1651321DC22E5230ABBEE2D0BFDF2614A6164816C3F5F88EE365F3DAF3`),
		Qy: internal.HI(`5336D64076A6DA68D241CE171518344E909399E4A8DBBF69E4D9F60C704CDB3859E0E1D`),
		R:  internal.HI(`E63723D098B3843ED7BD9196A57A25A1F2D99ACA84031DBBE2197D899C7132BD`),
		S:  internal.HI(`013DEDE5E1CC8FF41D9C7545F50FF8B9566FBB18521B478A908A43F90B07A256EC273139`),
	},
	{
		M:  internal.HB(`21E338517DE382FCA96FD97387F065A0AC26D03184F29FB49D7C4B5AFB7333589E7CDA38238E8A1BAA49DE3DDC0835B65AC59FD046824BE95257F63AF9D16E7948CDA5B3E36F694DAD644190BC1473AAF8ECC98D22690E908C0BD53E4FDC8C3942A76699779828B3936457A5BA98D29F614F6F44C5DB870E5FA0132404BB547E`),
		Qx: internal.HI(`3D2230FE327BEB70901A08283B6C2F028EBF1D860DF1A3586D9F50FCB323E1BEDF2FA4`),
		Qy: internal.HI(`3C8C20A30C06FDCFD0C40DE84F3D7AA1EAAD9FE947A5A94477289D12C7BAB48A91FF249`),
		R:  internal.HI(`D3AA9634A19500F8B8DF7194DE5950BDA64E36DF0B5C05EF2ADF808E5D148380`),
		S:  internal.HI(`01A7C8B0A8886D013ADFE2653C202DD9F50B662D3AFADCA5528CCDAFEC8948496C1B366B`),
	},
	{
		M:  internal.HB(`19A293CA8063FCF4A2B221BD535F313FD56A5BD8C6567B4F45E483B109DFB9B6C41F4A2C88713D4289824622EA7D92BDFD830034A3A1DAC7226FA1B23500D2D79E4751AE03AC6F545FCE1625CB4E23D2EAA7734BC2CABA73419E91FD491AE0616D0C144A49473C6AA45A891F2B7637C116AA7A1A702559D755991E6FEC794B59`),
		Qx: internal.HI(`D9BF049A77942B0FE0EC82F36AFE21662BCFEAECFC610F3825B47BA7A99DCDD9C3C41B`),
		Qy: internal.HI(`5F52CEFEF45C5D7F0F5CE7793791AAED22A6FEC47F60EDF2932CC6200C846E74375F1F9`),
		R:  internal.HI(`897B50A39C99F7B91FADE1E929C23481AA515F6EF4756923044BF3F8B2BA3393`),
		S:  internal.HI(`01BDD69529D2D543A94E25D0A1D153FA57603216581C90FD35EE9267855518F06117E92E`),
	},
	{
		M:  internal.HB(`5E25A9FC9DBA774E3EB03D7226E14D5561297DA2E4511F007A4FBCEDAFACA44D0613CECE29C81B4F7C237B87BFC108DF158A8EF13D33997F317686650A8AA4546220E9CD007A494617CE32CFE395353BE3F866187FFA7E74668D40CC5C332B0CD75C061319234D922B93FAC4661EC8C9E3686733991BAD826CDC551FEE0F419C`),
		Qx: internal.HI(`59B6CFE3A7BACF6F98E55A75056E18E7D8B4F1057D5DC20AA1CB24EB6C867976A0F1B38`),
		Qy: internal.HI(`691A34D27EE17441884A0D53791D9379B9DF124B6C8EB4179037B5B62BC638C7C13991B`),
		R:  internal.HI(`39D0F61F47F83316293FED1F181D9BB3D3E2890D65F0C7D223630A063AB6EF0F`),
		S:  internal.HI(`019A5598C3BAB803BDF5B8E2A22FEF7F235B10639EBBF1D8FEA96AFFDBB01E7395AD2C2B`),
	},
	{
		M:  internal.HB(`32A0DDBD5A5C991D421E12E60369DE7596989A6562552DD60070DA63F1CE18B1A88DC9F38A07C85749E162C060C9BCB1E70CB1DB97AC2B23402189A67B680882D78CD1E45D4E9C37981879E208DCCD78251105C6DE6F00A7BC8DC6FE8D1C91CEC3CDA2C86CA2003FEEC48FE66F83A84B0ABC9963C5332724661B9C870F715CDB`),
		Qx: internal.HI(`153FEE9DA9AF2FA994A298CBAFBACD0021B637686F5ED98135CEAAEF50F5F1ED10C184`),
		Qy: internal.HI(`5BDC0C5218DBFE8A4EB8A92E52E1D81DEDADBDF2FC5D05D735C4C1CC736BD05C371129F`),
		R:  internal.HI(`E391FC7F0225BCDC5967A3E5481942123794AB3774A89C5BBDD4677BC0E6EB84`),
		S:  internal.HI(`008310BC2574BD0558CDD9E4A87DEF28CC2F78D950C2FEACC683D0AC470ABBBEA84BF96F`),
	},
	{
		M:  internal.HB(`DA4993DF39BE057672B0836DF1EB0734B8E915F5C3D64AE998FBC066D2393976F0C19F6E2FA3E86DB371DD20D289D1C7B63ECBC6357F36C816238DCA8D8B22F743BE6DC79F9B0A3CA85FCDB23E17111EF628B52B629BE11F0A5106E7E0C7363B77914B3FC438F783B09F2ADA4A9AFBDAD2DA747E77DF6BD1080DD7FB5394BEAA`),
		Qx: internal.HI(`1C8196F34ABC7228C1D9847E50DEB96FC5B3844B9D92CABD480ED419B6A2AFCB44CAFFC`),
		Qy: internal.HI(`5AA6E74C819849B1EECD49F2DBE08390B9F3E8BCBAB6644667B05F2D83F6897A8D12DBE`),
		R:  internal.HI(`80642FCB75625F3328D6EA5BCAD8C9DF4136D4404FABD6AD940521956E431901`),
		S:  internal.HI(`018CC56549B3CEE32745AED15C062622F6175EAA66DC8D8731A47B4AE023160463FD95C0`),
	},
	{
		M:  internal.HB(`9A522E36BF53606C931A745BF15DED26095253248B4A194C0AA5544B57E22B3020E2B4159B0F20A57E85D2FD17F46CB5C65541879C215C827430772443E91546E8EB22494AD539680A5914938A3B22C0996FDA1A90F2C8F1128DE6DC58293EE835DC664AA657D77435D9B2F4FB56E60A7CF65E5934941C9D1563EAD0BD6A8C9D`),
		Qx: internal.HI(`6B94E216DFF462C8E9E2BA3BFA05B0A36958865878C1CE295B6A92E0EA88EBDD7FC8F2E`),
		Qy: internal.HI(`7489C36CBF3AB2DB16DF75B8ECA5DBA6501017344BCF63E321B6BCBDE78B623119F35B7`),
		R:  internal.HI(`B6FF3D6558154BEFF2B106EEE06BB2095C5EB7EDC955950AF748ACA75704A23E`),
		S:  internal.HI(`01FAF5C5259BE504F4435A3F398227FC5D02F8B95EF9CD8D37FD6BAD6C6F0437E3DC924E`),
	},
	{
		M:  internal.HB(`B5EF1498708F4C136710CA0408B0B4DECF06B7C73F2340121921786584BB12747E256CBA54BF12136ED225AA35FEB00D5C8477F04F06416521FD2B09A27407020B46533EE270CCCF82B832D8EE3B26F3531CD767EBEA573198F64830FA36CD6742E355BE967545254126088987AC8D704E44B9C77FC6DF9C51D3B95953E8EB48`),
		Qx: internal.HI(`18621050E672CAFBEA2C51E09CC6AEE8BFAD581F497225F9D78D94A004533ABFF89AF8E`),
		Qy: internal.HI(`81F5122C2060E9AD5BC5693FECD9B9DAEFAA4F571718281606831A973BA689FAADA045`),
		R:  internal.HI(`55C45B384104B0F62952099025FFA063A266EC590D9E6FC96A4845B9FCE09BA7`),
		S:  internal.HI(`01C691388154EF3D79FD0A31B5D4A7865BDF2105B1BBA64871B93D38F7AF7F3563B139C2`),
	},
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(K-283)(SHA-256)_SVT.txt
	{
		M:    internal.HB(`279C63A0B12C0AF5D928093DDF6A7E8CC9A1953B599647E8BA45B857721726E7AE3888BE5465C3540423AB8D73BCA5F83BF42277A0E1CED453B7AC8DBA15EF6FCB95D420FA21475445EF99C5EB81159FC89FB47FF5B0B9B89C5186FE949B6622D0029D0722288076599CE0FB4DE39174D3B4547729D1E53AE367881FDB57C298`),
		Qx:   internal.HI(`5DE9FEA9AA2F0A0F4BEC73AEC94AD1277E3CA16A1EDD501B841A4D57D228B0C5B4F7FC7`),
		Qy:   internal.HI(`17F9AB8F1D19C80CD241845564FA8EC1BBB6FBBA048435D2489A4E07E80F3F16D1AB435`),
		R:    internal.HI(`E0B33C163FC50AA3F658420F30FF0A62F495B1A86F179D621FB2E6C6049E600C`),
		S:    internal.HI(`FC25749660C998282530D2B4E61EB7CEF4E5D96012C69FC6BFB2C995AB05B6F09D6B34`),
		Fail: true,
	},
	{
		M:  internal.HB(`F9E7E39713B19079940914F9E0F2522907F221D6306564D8CF8F11A5FD18BF3AF256F9D3F11EE6859C687F3D168DFA2DD9648136A512F54577C5D742EF2CFA8300F43A606D07CADED7EB4B00ECF05BD07683B390DA728D37CA596DAEB20FFED8B15727FB8D96007D96E1CA8BC920A8B530991DF5DAA5123C5BCE8B043637A4F2`),
		Qx: internal.HI(`761F568AEF1BF673FEEFEFE9D7F9B837968D321CB389C0D7C6CEA4F82E505841AEEE287`),
		Qy: internal.HI(`7FAF6B6B00FB46CBCB51894A4C170E3731B6B9AE0DC651DE28D5844A9BA3A628F915AD5`),
		R:  internal.HI(`8D65256C53055E9DD578A02E55D08F6453957C5E64C51128F108B77708FE454A`),
		S:  internal.HI(`5EE3975D36BBD6D5B48587F5C885BBC444D89969D85DCCD1C92BD50239F207FDB36025`),
	},
	{
		M:  internal.HB(`7C080A62DD8E85B00016CE20085EABE057EA20B9AFB10A470FAF086E050AB1DAC9EE9902D6CA408767135F697E3FA5EAD50F71927FE07F326F202658C19A1D1809B25F8D644C21019F6C7E263C59C037964AF388EC5DA348A9EC70FA9B02688273F5B92A4FF6C391959312E0E7FE413B801F57C8B32EA43EE1ECA361AB3BEA4E`),
		Qx: internal.HI(`1B737DF7ED3197E854B773D29E53067D32107D181E2FB035437C4272DBD233C668D1326`),
		Qy: internal.HI(`2A77FFF678C463CEE193DE1F4A19A65DCC14C4273EF99F4355BFE0523220C87498A8B52`),
		R:  internal.HI(`DD77A489F0DD43D5E488636DC681C07A6804A0110CD66F68E37286CD7733B8E7`),
		S:  internal.HI(`4CBBAA2EA9BD910FFC098E898B16F38BBE8E9B29FAC3B24F8BA0C1726244D192DCAC82`),
	},
	{
		M:  internal.HB(`20AD094BF1E92DA1C2AD280CCA94EEE7DCF6837AA0D850A0BD23A2F084233A9E63E860F1B07C5681FE84991DA24DD48294D2F6CF4ABF43DCC6F9DA5465BB8CD2B7BF6FC3ED8F155E1077D277B129F774249564290AFE62EE36DC2FA6AE851414DE327E2CA95DFAC68C0F7F5F6B0EE944329017E5046482990425CF9F787727A0`),
		Qx: internal.HI(`6C4016DB544D7BC50332C1050C8B123893BA6310C760F79E45E0D18D6213B59CCC90CB0`),
		Qy: internal.HI(`687D7785502D1029DC84C9EC48736EBE3DE1EED7BC1DC251281982B107C424D10610153`),
		R:  internal.HI(`635F9FFAEF81287C1C0DA851C9FB468DA2D6201C879E3E0F46903FEA30744B8F`),
		S:  internal.HI(`014C7A11E84AEDD0B2A883C1E3B3C840B9CAF098B6C1CEF10292A437BDC96AA6A21DB5A9`),
	},
	{
		M:    internal.HB(`E4DB7D2D491CB0CC7A4E008B06C5E52BBC644AA8E80009EFD8EDDD20B3A41B8B23DEF10DDD1E7BF490FB6E16482CAF42BCA586AAA8BFD17DA1C9EA5181F0937DE6E7AA21CB26EEEDD146A6582F4A6375D93FAE09EB2CEBFED4A635F852FB7D13C95CB18CEFE5386B65F98BE340D02A89049CC00A203BBB886BD3174FBF3BB6F8`),
		Qx:   internal.HI(`161523E363E7E58F14C38A134F5F33455A58D21FB502807E76D51E52084CA32ED2D66DC`),
		Qy:   internal.HI(`462D16C1D161885C59E02E96E8214F89B66E8BF30259041B226D302649ADE4ADE22A581`),
		R:    internal.HI(`7735F9C174B8754B14631F05DD1A33BFF108BA34FF97B7BE9FE89658C5DEECC2`),
		S:    internal.HI(`6199B9BAC43F0AD0E5DEC2EF7A83FE3EFD040E12653A0E52CCBBDA54E6BACFA0879CBA`),
		Fail: true,
	},
	{
		M:    internal.HB(`5341028FA528CA7041CCDB1C1C3CB0ABB80BCE59A06E91A31ACC93C2E919C7F28DB4F99FE61ACFF0A53703C97595EDBE363618084761F1FC3B2E5816D90D1916E71B143E8F8D1D37D3EC60A0F7814DDA469DCC0E1F1FD9FBA7EF329119BB37E608C2B38792EFA6ACD20FC6659369D4319480711A5B4CA2DBEEA79B0C60400AE9`),
		Qx:   internal.HI(`6B49A09448DBBBC5425FFB42DA112602A028FFA10C3C0EB7D0EAB82ABF3F5AE574A3F03`),
		Qy:   internal.HI(`5829E640C14BA6B45DC73D55BC92D7F052BB2E07BDC24221F1A2CF19DAA79F493D35E36`),
		R:    internal.HI(`728E2A2F02476D0243ECA667E19B69A25DCFABEB1B7CDBEB2CECF058A77339E9`),
		S:    internal.HI(`01936282817575DF4E6C6E83662A0CEC0A39F44ED20C462D81CA88A2ACD7E2B2ADF569F1`),
		Fail: true,
	},
	{
		M:    internal.HB(`48AB75EC88AFCF978DEC0B867C1A0D5512C47DC85C348995F101FC4BE24125AF3E2EA57F65479C07F9A64764A9B196E3AFC8BE6B3F1A564EAC4FF97195290D2ED8C399DE9C9DCD6B301332DD1171153EDA462CC1651E059FE751437B4B022FD0A30CAC39DBE6090B9448D0245D9FFB511103B33FB3D9125379BFF15E61F75082`),
		Qx:   internal.HI(`57EA1304D4038C0E63488F98396045BF9D7A2A15CEA79089AABE686C73D94168EACDB53`),
		Qy:   internal.HI(`5D6C5A996C48C61A39ECA15A3D7AF100F1F65DA73B1CB54E74031D2A2EB0A57CBB86D15`),
		R:    internal.HI(`A39DDAC7F5E0957E17330D33D31AA89CA9A944576F28D0219AD4EB15A1AEA98A`),
		S:    internal.HI(`336EA34DECCDA1BCFCC0003A0A635FD5EE9B1B7496048E7FCE48E0DB2CC8F4E5936BAA`),
		Fail: true,
	},
	{
		M:  internal.HB(`C91C90F01CB8F1635FF4A1C60901DA7E287416F579ABFE6D0B8269969ADDE3AF4C11897DFAB6C1D49FE4990A2E644D125CECCA8C98CFA485D64D5A4D4AEE5C01D0FEB23B0DB5AF8F10079F3182AAC7851764B3DE6D122C3DF389C14F14C55274357E791BC89C443A07A124268A847393610C8610CE30A2AE5B8ED43A5E68F3B8`),
		Qx: internal.HI(`52E16EF7D00EA1A46EC52EC2BE116CEDDFA925226AE00611D49804F1A721101E9A63BB8`),
		Qy: internal.HI(`0F51ADA70E97E767AD2FC90EC82B6AF8D3E9C8CB7157905823B175DD62C721F77CB6FB3`),
		R:  internal.HI(`548F0E29AC4C65CB29C0CF8016FF09BFE295E423D8D291588EC401C4EF18C854`),
		S:  internal.HI(`7994A722F9CC05C6C20010053BB6FACD228D6E5BA7DF1B7F38436ECB178502A5567F33`),
	},
	{
		M:  internal.HB(`52D67267FA125F20202438944B86E486387FAC5A8C1DD64DDB51125C84766995674B00EB06B1743E172021B3023B061C6962A57932B99E511B7F44046F1C08BBCEE0EB20A2C4D48C442302C551D36D02457C5759D59DD6381E2CA619262B001AC124C49953F2C3808ABF646E8A9C795D99A084F1D0F43718DBAE752250F3A2FC`),
		Qx: internal.HI(`29C8D22DC8BF5A9E7AAD291130975213F9A517D443CEA588BD79FCBEFAE320C7FABB0DB`),
		Qy: internal.HI(`24720B29AF8CD322B58636537764CBE11A567C516F8DB947A87AA4AD851EC951697F9AE`),
		R:  internal.HI(`E6C79EC097F41AA02B4EF3E8870DC8C9F14EAE273683AD3584EC696FFB5D4194`),
		S:  internal.HI(`01CF2BE138CBCB25689870186FF5FEE7E2CAF505B7A5B280C74757C0F62523788414DC20`),
	},
	{
		M:  internal.HB(`3081B04AEF6DD5F60F381CA7E9709B5E2D580028F4605274E4557139CA29F402A581885E73E78EBEB5D80349137F72B004660C88DBD98D3133541FD711B6D98BAB8B0C0F3F2CF73DDA031FBA80BDDFD894A96444EF13B9838BE60BC72F54CF1CF2CEEF841D20A5F832E437EC9A282943D08320567B650F0262EAE05092F540B7`),
		Qx: internal.HI(`5FFC4E1816DE73B8EB42EFB6E5ADD4B86ED91221EA779A938244ACDED50D6FC29A984DB`),
		Qy: internal.HI(`73C9E954481F692FC915F7B687ADD6FDE972C4037B32E6F5E951A5244D876BFD894C8CA`),
		R:  internal.HI(`AFA6491416250DAC3C7C63FD5C4E24C81A4C8455281CD4664DA0563856B175FC`),
		S:  internal.HI(`43FE5C798A3D50A7238D2CE30F5973A1401DCE9D5AAC5A695F130F9599CCF780A71219`),
	},
	{
		M:  internal.HB(`E2AB8CDD90729CF70BD577D5A5DD8834C01E63D7100D6FB6A30E5EB372DD86ACC583A15B3083FCEB72509EAC03D165C69304B65E3B7CB30CBFCE88108F9FDB28DF83E0759B44175878C54AA1F822C21097424376F76CDE7453200B31F4C933F6FE7D121756691011E9170D422337AC28CF0EA68D3C342884DCCDCCA534E52E6F`),
		Qx: internal.HI(`0EB99D41EABD50D4062EDBF23A459FCC2ADDD6BB3F24AA718BEBB926372CB5EC273C3A9`),
		Qy: internal.HI(`54EE9FCE44304919721C248961FBEFDAFB02BB2CF7F57E3756B430515F3F6F7B599416B`),
		R:  internal.HI(`B510AC684C6724298B7ED569ADC3E269E501BCC84BBA3EFFC3873187340BA5B1`),
		S:  internal.HI(`01552091F8EE49AC004FE6CC08ABA15DF18425762286AB4FABBFBE1E34FDDA262A907E4F`),
	},
}
