package eckcdsa

import (
	"testing"

	"github.com/RyuaNerin/go-krypto/internal"
)

func Test_Verify_K233_SHA224(t *testing.T) {
	testVerify(t, testCases_K233_SHA224, k233, hashSHA256_224)
}

var testCases_K233_SHA224 = []testCase{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(K-233)(SHA-224)_SGT.txt
	{
		M:  internal.HB(`D6CA1AE519DD9772F22C0830FEDD8D91E66BD4A99A156F4D7C7BA9AC4DFEF23116255D2CD89E3D135B0668DFCA222A4D7EB46E8CA48E261F270876798995B527007EB9F79D8E9003D2BC120DFC89680A60370E4B5180462BC1F7A1AE13B38BEA6F7D74B65B17937BF0CAD68D5EEEF6021F7F4E58877B66EE1325CC9F2CD83577`),
		Qx: internal.HI(`0A640E6077AEBC5948D3B84E20779DFCAF767EFBADE0DBA46A4722A9E98`),
		Qy: internal.HI(`0CAAC4A9D8E812BA8353790E8679086728AC97D427D2556D6121ED7F54E`),
		R:  internal.HI(`343A5C3BF36AE65277ED949B9777FFD7BAE4E14DAEA81F9E562BAFEC`),
		S:  internal.HI(`2283E5B2120F94B0F49D16215DC87889C2782325AA4DC4D07343C95486`),
	},
	{
		M:  internal.HB(`AA937AE0ECE9703AB3722B37A774A6F6B3E16F2F1354456C513A43AAFBCB9B555FF961F512007A8983C031ED718976327D7A5C53AD28C93016A5FA35919DCE93A2AF677C779C2B382E85B09840DE8B884730A550F15E0051659C8CACE5A607C7F07F7203AC4727A1EC5E16298271305142AE84B967A42269A91E3E85D884A60F`),
		Qx: internal.HI(`1487BBB9E3A683624E38BCB447977C11EC71696E67873BCBC07F52762C9`),
		Qy: internal.HI(`04D971F02E8A7129E40499E384C0BA16BB8C3FA572228EC87EDCC3BF97D`),
		R:  internal.HI(`BC08162BF6FCAE531BB26B46BA9341EA2B2B2C0F171EBDBE05A43252`),
		S:  internal.HI(`406021C1C2372C6473CB8E92C1DCF9AAC745A366821AD15BA20DDCBA57`),
	},
	{
		M:  internal.HB(`2DF90E242DD437A25BAB7D998985DB710669DC287BEE8C9DB5F2F93D33213411A876727C5B5C4DA4839AA2EB92A62852959F3443857CC69AC5A7535AA4AB61FC16167CB380418698D31BEF26C1A8DBE55855C0B3C2D37E937B948669C49B058792C3B079CE2D23F622EB725D23A6E1A52056572C58C08A45E2D7760013B023EE`),
		Qx: internal.HI(`1759AACCB4AEC25A4A0D2E34ADB1ED8DED6BFC085DA7C01E18FCD9B7B43`),
		Qy: internal.HI(`1274151B32DE7AA842D5F31CD87814B0B58E37A69034171E4F16AC291A0`),
		R:  internal.HI(`14C3D26119862688E1B64DB387DCF2284E0D355618009A1DB40BA6B8`),
		S:  internal.HI(`08678BE183D8999675A4EA20A82345F08A26862D262A0BFB9C712EAF4A`),
	},
	{
		M:  internal.HB(`A32E3C8460118EBEAE8BE2A9AA044F9625387D69555AEAF56E58AFB9F9F2E1F936CFF69437285B791F48A02B336E62400A585B2EB0FEC26FF9C4643DC7B190F79EE65C713DF343368532B30C83D87DB6D6DAC24647526406C6947138B385AABC9B7E92E9453C2B8F5526CB7F447E2D92FCAB2B85DF45439881055A60DF4ECEA8`),
		Qx: internal.HI(`07A3662AF7DBF9BD216068F7608892C959EE6EF8CB0D19054DFB312CAB6`),
		Qy: internal.HI(`19CB5159861432B01C2CFD05AF2ACE64FFED07CB0DFE064066DC36F01C4`),
		R:  internal.HI(`C75D795F59E77988F54104B4522160C39B521AF11BB877D0CBA978E0`),
		S:  internal.HI(`405887D184214A05B163C130E1139B60A57DC5CE2FD2B947785D17F9E6`),
	},
	{
		M:  internal.HB(`506667D509151BA370C63FBB0CE427F85481B9C5260A00883D1E49715333C5A14A3850122AD7461A1C7D0F0257D548901ED735EAB32261C375AF1331FDA5801680546B8A32250826087EE19F8865948E06F310DF045155BE0B4F326EB75A18FC4DE47C2A95E8E37E4BC307E1EBEF37AB1AE264987FA5F1744B5BCCFC4153CCD2`),
		Qx: internal.HI(`17058A80C049A159F041CCA74D7875CDD00DF744C0E3B76585E75D94A8A`),
		Qy: internal.HI(`1E6B4AF6D6A50CC01F6A3AB40EE94704A4A7107F78607F7735F8953F7EE`),
		R:  internal.HI(`DF242007D4E9447720D27090D8DA65A64540E5C2496154EFD0524731`),
		S:  internal.HI(`228B455AD8E35157BC63DDEF085A2F94C2CAAB4F4FB5DE8D7C18D21EA3`),
	},
	{
		M:  internal.HB(`77D7F3EAAB53816365107723B519862BD578F2107174756AE9FBAAB943D8069E2BE7E4CAB7DEB49D3CEFD1C502CE00D71752254A125B47ACFE1D428B4C7956EEFE940DD1E34C787D20B35D31D54044022AD50D527E42F6CF0E79AD5ED40D74D9ED28D30E42A6EFDAC77609D81BED2385BF2D653ABC5538EE048DB1283DB442FE`),
		Qx: internal.HI(`18509C8819699F74F95D1CDC5A054CADCFCC7F28D210B6E877F2AD0EE27`),
		Qy: internal.HI(`1B10175B6D0482B15FA888634A72544B05C727DC91E2B75BF3078CBA749`),
		R:  internal.HI(`51D9F0C4819C7EB1324474F1945677B8F6425A27C13368E268E26F33`),
		S:  internal.HI(`32D7F9BCD7269E85FBC417E4D0F76A1972EC560A3A52DE6FC8468BBEC7`),
	},
	{
		M:  internal.HB(`5DB34499CC3F6415511D6F34A89891C4EE518D1EBB0AEBAF33A0B8E6CDD6C7821C0E169064AF48164550CCC6384DAAA939FB9022501F183D57C1D69EB52234145DD9A61BD4DA384E918409176F5FB2A588B21E71389AEB4C92C7C65C0E92E2E9BF7FF96ACFE9F4B48DF3B6B8D96B16B42EC2923E1BC8BB1A6F50ED37D66352C1`),
		Qx: internal.HI(`1CBCFE9B5F59681D3BF8CCEF9AC432F232C987A43C8AC2D2937B437DF7F`),
		Qy: internal.HI(`1B1F0E4E95B57AC1B3F45901586ACD6710E54280EAEDA40C9091C92C6EE`),
		R:  internal.HI(`167F902EFBA3CE6825462C750DBDF042181DD4F0AFADC0A13080DD55`),
		S:  internal.HI(`2A475CF52AC146564444738F1657B8B15D99C94D2DDDEBF46A5BFE7F94`),
	},
	{
		M:  internal.HB(`462EBEB4EE4D68CAF8A00944EA556B57E240EDC48740086AE2C3554BF61F2BE260E14A37B4C0A798F956E35AFE476D99C608D947F1E077894550B3BE3F953F1AE1589A3C8945EAAD1FA7CBA559B6010C63C0A712B7CCD74B5BEC61BD68DD86BF071C5412C225952261EEF1D6275E34CBABD4507820731F0C5057647E115621B0`),
		Qx: internal.HI(`19FBB5E9C9B4F0DA56BAE92E9E7D674DFAA55CE7B4230EFEA3723172DB5`),
		Qy: internal.HI(`0CD62F141724E61E2286D7167E2B8784457F5D6B806F38E9D7C2696F869`),
		R:  internal.HI(`94D9D240F86CED0E4ECDABC6551876132E2B279113C1A67847594C85`),
		S:  internal.HI(`0B2C1F9CBB0424457AE74DE9C746DCBB0170522C7CDAF69A6719FBB2F4`),
	},
	{
		M:  internal.HB(`767DC50F97F132981E4F2CA57D433977F57977D5598C6DB0B718663DC2A858533C95E4942A8473371EB3FBD556AF6E3C04AC658B791209A58B7DBC40ECC49C95CE454D08860034AE8ECE872F973856CB00320B077E4D5FDE2E9D61D5E7E185EF083447D99DCE7637071B9E840BB9A05E7A9703BC4ECB08D76D57F950F17FD35D`),
		Qx: internal.HI(`1A594F202FE921E029858FF19FFBA4D5E6B5FDB7613DB380A57753F75FE`),
		Qy: internal.HI(`05D84E4FF8D0756CBCE33D26ADF483DF9E9C7721A1C632C937278D240F6`),
		R:  internal.HI(`A2C96001AFA25991EE23A8EA1A9E0228B9FF0C583A4594F5CB004062`),
		S:  internal.HI(`034205A7328B6A10F9D914D449E3CA25A81E49799CDD8FD2F9DF592850`),
	},
	{
		M:  internal.HB(`31D4BE8049A0659288DCB9AD67561EB96C318F24B660C1957952CF0F35667167F45E487B4B705207761CF78B467ACE25361B97C46D2B71A5EEFCD777C1A56D1A67D324524F7FB966A3AE1F092DDAD575A23CAF261291271ACF8DACF68E94010D07FB3594E6593C08432DA21788717E03E03F0EDE29411991870392017CD48D5E`),
		Qx: internal.HI(`05960D0BB6C31856AD1877A8075AE1DE80E6D7C2F2BA384F179405BFC91`),
		Qy: internal.HI(`1D191B09D2C04AB9D553579997DA62FE8A977AA15FBF9DCA33200D077B7`),
		R:  internal.HI(`93B2F4E86B02539BC0677D880BCD463899D50A73EA966AA8B121ABEF`),
		S:  internal.HI(`43D259FD6BCE7A8491F70B3E3623294E475BFD1428F5DCE6D41B8BE8D9`),
	},
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(K-233)(SHA-224)_SVT.txt
	{
		M:  internal.HB(`A82AE38DDC22E6D5DA4DFE9FB6BE8F5BCBD89C153BED6DA5ED76A1958A29814C90E7D3BCF7ECF2237B1C842500DF7FC83175DA8FD420A059D21CBA1F91B6364C99854DC70D18EF6203092DCD47E033BC88A52B6A7C94C71103D2BC96D2930000AD8AFEE9B2249E8BC65D609FAEA346A4CDB2F1C21DCA99EB672644694125EE79`),
		Qx: internal.HI(`05AB7BA73781DDAD78262478CACA6AE0AC4A02AEBC9C8925CE9105CAC9C`),
		Qy: internal.HI(`1D7EF87CBE3C3043250051343C6D8B01D2D1DC55B500B8559A7CBA892E1`),
		R:  internal.HI(`0E8C3C0657B4688F6EDC3054215C1E63C0BB53DF5ECED3C74CAD58FE`),
		S:  internal.HI(`28BA46BC8A5CCDA417C4F2A6FCF272A6105B726A08EEA652D74FD8F1F8`),
	},
	{
		M:  internal.HB(`05FA202398ABDF3FE6ED70FC103E342470F47C4850B54C0C2C54CE7ADAF90E5F8BC0374803A7E90F000AD9A01A8466DA37664438B79FE32A7F57C4BF27015F963B34BFACFD0B7A0286573EB1B96F8064EAE090CE9BC7A51F442012FD89CE5509BCA40F86243BAC0BE4DBC9F0F03A0D5EF4629D939F81D07128EA47C6860F1D6A`),
		Qx: internal.HI(`19F82F48514CEB206CD29880EAC44B5145B88E50B242FF79418C8B2C43E`),
		Qy: internal.HI(`194DEFB877A0EC66E875C17F28F39EB2D8FBC89DD765425CA2DBE9D1CE6`),
		R:  internal.HI(`29095614907241B9B5C569B736A8D60224641217BE0E6CBACD95B05C`),
		S:  internal.HI(`462B61E853DDEA75E8C9EC502CB56C58BDD0A767B530E0C4DB034B4768`),
	},
	{
		M:    internal.HB(`C349B22180E2420A046EC4C608E08C47566FB9700DEACF5E58BA57AA5E329171B056B8A20CC4EC70ABE63B4EE716DB5D8DD21ABF90C010A47689948C39527E99EFE6C45FFA4473160DB60FA1C9125F393F5D36491969323DB79C07C80A85597B6D72AB164B9D6985D2279EDF8C8056650F6B38D09D435BF5F4A0E404201B7565`),
		Qx:   internal.HI(`0E779F0A75C2DE394BB5F073C51281A0A9A2C2FC011174E1E788094BD08`),
		Qy:   internal.HI(`18030D6E956F61974A9C63C6AF7A549F2C601C18FA4BF3F7603A3658710`),
		R:    internal.HI(`699EF67596FF0A7F2821BAC22F2EACCBEE3A13F4376312185C453A67`),
		S:    internal.HI(`693D6B99FE0CC97E38D8D55F12D734B25A50EA275C741A9341D389C338`),
		Fail: true,
	},
	{
		M:  internal.HB(`2B36BB6A9FB741BFC066AD0283120545C9563700D9D18A667C6CF6FD6FA953A44A89C6FA890F524ADEF1F0D3756F28B84AE277574611844D45C28003A39E99EC93EFE85DBF38C5298A34E9E86D454310B8D7EBC455C7138FA74A6FDF4965EC7CBE7D1FD3BD0563444ECFF85F5512212EB19E977DA25A4447917AA920F191D9EA`),
		Qx: internal.HI(`0520AB2ED1CD5BBCD7AE0896556CFD204C581D9C927F5266C4B1195F211`),
		Qy: internal.HI(`11D2FE7E3A162B60AF9ABB60E49D85ADE056F6BAB5A47BE521FF4BA6B08`),
		R:  internal.HI(`DDD554C940FBFA4A407CA60F06E7241DA069AEAC83BFB50259889949`),
		S:  internal.HI(`1297BC68A0FFA7020A2AE10C4869DE16112FE2F93D1FD19A1DE1972BE6`),
	},
	{
		M:  internal.HB(`F2748743707CEA7D0A8739617A135A984987A11357ACF7BB6B1A3F71D9773188B1F48B5B9DE9D131D407650E4AF5469C91CE34D775668CA3E3B79CEB1E64B780CAB8D958D50A184FC4F2B51F77270AAFD8862563931858904C7F7FC569C74A0FF2DE53D38AC8477F1AC9E69F1C95289127D54B76B7ED1791BA7718B1EA4D1DD4`),
		Qx: internal.HI(`086C7DF35DA3F9BD0ED2474F19EE1238C59B45D6B753A1032B9DD22478E`),
		Qy: internal.HI(`0C7680949ACD609DEFE9C4D2B3BE70DB315890822EDD19CEE0A0AE4D77A`),
		R:  internal.HI(`01D4DBB33901370A0D642DF0FDA39260F0D3B59915821B85717D036F`),
		S:  internal.HI(`1F0D6FDD171D51DB5D5A1B4954102C51291FAE3862D0486C8AC9ED6C00`),
	},
	{
		M:  internal.HB(`8FC3AE59924D36BF159DE37FB189C430E46214119AEA7DE8AB7EA5FA2DCF398AF9DC13036081AE406764870C757D964DE7138CF55A5EF23B32B3E11A26656EAF54377372B4A2EAD759B06E5864BF1D7F19E973E4F46557BD289EEEF17D4B6C48DF5689BA96D7B5628CDDC41F886E336FBF5CA884B25BDB23B30F9A510256F553`),
		Qx: internal.HI(`1F36D99C4100B3695084F17B4DB5EE311A5C336B80ECD4D344954D71C36`),
		Qy: internal.HI(`16FA72FF0DB31E2BE6FFB1CBE447FC8844F02424BEA8E939948913006D1`),
		R:  internal.HI(`83A62654400D209DA2ACDB48D269AD3AC1839E48F29A1A375FCB877D`),
		S:  internal.HI(`09D837BE2145C3C6ABFBEF0A7E73DE48FC3804DCD5428F0B34E171059F`),
	},
	{
		M:    internal.HB(`A4561595AEA169AA30FD467315806F22C94FA2680276C700BE00320AC49077AA7224E5CB20091C63D4D5D93FA36E799677D8377586E5AE444C7BB473398F0091FB85B5D78B105172DD4F0D8F73342F7793F75FBA7AAF83BD3FB621A4C30AE4F6605238E1B6A28A9748B83E8D45CDD92934AB63A6D82499B00AA1E88CD7E3C13E`),
		Qx:   internal.HI(`1F3E4CF14C581D7213530037BA56F612C2F62CA4053A48BA753DAC8869E`),
		Qy:   internal.HI(`059A90C014C5E319A080CB474E9DB7BDFC829BF72D04FFCA8026E0BD9DE`),
		R:    internal.HI(`F2A017B4C685839E42E4838F1CE9D4ADBD45E0B5D9CE7D9EACE4AEC8`),
		S:    internal.HI(`3C31F4274DA8B4AF9085CAC12B1DADF50FD1975F810F0E4EB8156D894C`),
		Fail: true,
	},
	{
		M:  internal.HB(`2A96B777582D3DF8C7A8B0547784919347DDF8B3DE3B4050F47284BE031D607D22AEC93828AD8318BE22FBCA85B408DF088B6AEA88747F126656FE663C7A3EC55ABAD48ACE0C0ADE9581FDE9313CE5AA2E6358C9E499FD1BF608922CD97FB39AEEAE4074740AD186DA631FB2B6A5CD4BF8E96F8C813B3F1BD43A6FC4F9096845`),
		Qx: internal.HI(`1EF15598C4FA95F392452BF412C05FBA2629D6AA11A5507DEF009A4E0C8`),
		Qy: internal.HI(`057A954460E83854EFB701B49263E9D66B3E428690538BBA84C898FF312`),
		R:  internal.HI(`EEF82F1F7B89A52EAF27517710A33176376F939A1D71DBACE18617F0`),
		S:  internal.HI(`682ABAFFFD15A8FBD2F78005C2BBB21589D47E480312D8DA126FC998B7`),
	},
	{
		M:  internal.HB(`A3FE670D10E2345F8B54901B216B00EACEE2D4B697D4A978C34B4B869E0CFAF6DD8638542B4FF341E617522C8A72EBD3E76EAEA0904F47A1A56447306B55D306C5D728CD1431B9E38868337E619D20C933578D29B24F5C570881A4714603D0A9EE7CDCC12BA861F1AFD4D26ECFB09129D86B4AFD307938EA3CF0B888ACDDDE60`),
		Qx: internal.HI(`05CD1AB46500512B64E349AED6E89354766D4536273A52AA9C9842B4328`),
		Qy: internal.HI(`013C498A38C6E47E28E16EA902AE672992EA51479DB61140AC8631B8AE4`),
		R:  internal.HI(`A52BCE7ED23C5843AD55003B8955950ED1D03E1A9EE2573B3E3E027C`),
		S:  internal.HI(`32D1E673E3CFC10B6053AB6D7EA228CEC613F3322032FDA5A4F5D73185`),
	},
	{
		M:  internal.HB(`83644377DFB05FBF6C3920A7761F9926FC2B94E57A14F2BB873F80C3B4CCF41885372FA807506944CAD98161C28D0793E7D92D56070F4E24A55F28595D567905A335271459D792F3118C461F708CA8BD9167CFAEDE31274030A419E3B81E470D85A395BC17C0A6A9EC91ECAC63AFFC6AE75247C1C46AEC009604B57EADAE018C`),
		Qx: internal.HI(`06F739A1F6178E7D8F86BD68300124190602725AEC825F02033E485E4C4`),
		Qy: internal.HI(`0FF80F25002CC7CC4B7A11C5A7A240ADFCB9AF06BCB753E62C970C7AD45`),
		R:  internal.HI(`19CA15DE46A144A81F030B237C44C91466325C3DC03E62952A1DC4D3`),
		S:  internal.HI(`0C39B61ADD4A61B551C90BFD69C43DF73E7ADD0BC95DBA45A7B2066C0E`),
	},
	{
		M:  internal.HB(`32AE488970BA698B93B8778677C68B5B7B2E098693557CCEDC24F12B779003DCF86B0601322961ABA3B69CCC481634EB2EE2ACFA6B63F556F157A829D4261E4B758FEFD83B96E58C38BCDC327241A41A1D8A73FD9C5BD3337007BAA7073DAE6F8FA6A270A6EE72FA35669FBA29E443F66514D375B3D0A8F6EEB4E3AC3A96AF98`),
		Qx: internal.HI(`1D6D8D0B179AD51E82A062746C0CDBF0D4AF5C98E46FF5CCBC1536957B4`),
		Qy: internal.HI(`173C224F227040B95F6618089AF59DA9594A2771DC1FEF53575F4044EDF`),
		R:  internal.HI(`049D9287E996CB60D05FEEAB27D61541605EEFC13F9D849E464BCBF4`),
		S:  internal.HI(`7A00595A8832E434F9093D66FDA0E0B4512A965BDB87BB6EFF73B7233C`),
	},
}
