package eckcdsa

import (
	"testing"

	"github.com/RyuaNerin/go-krypto/internal"
)

func Test_Verify_B233_SHA224(t *testing.T) {
	testVerify(t, testCases_B233_SHA224, b233, hashSHA256_224)
}

var testCases_B233_SHA224 = []testCase{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(B-233)(SHA-224)_SGT.txt
	{
		M:  internal.HB(`F13BAE6E40F2C01DE1FA173DB5FC4DC214D2B3A4EACAA477007248C90EEEAF79D66AA1DECCA116FD9317BD99E6FA756F1C381F4CE7D8BC648519349DF85DAD1E796CE8E6D41376B8BBB14B24DFA970EBCE4F65975C57FB7BB74120F9BFDE7C3FE5675257212C7AC73577F189DC94DAA917915A4C37BC3C69D26CBFFC42127A00`),
		Qx: internal.HI(`142D5974693434B510AFC014B8A00A049CB4B42E182CA4F74060245A39C`),
		Qy: internal.HI(`135C75B7DD3F1E7108AAD6333AB974053BA6688F269C238300312C54F6F`),
		R:  internal.HI(`5FA197FFCF2F8CDAEC6D86D1157EC9E9ACA427D8400F43040EC1CA81`),
		S:  internal.HI(`8D4DAAE39E1F6B57F313912F704BCE0ED71C924E031F6BC304322CBB5B`),
	},
	{
		M:  internal.HB(`E928B8EBC7F54207A3C1EA5C6072D581AC1FD819AEA7E43FDDC6D1AEAAC18CEF1F26F8451EA275C170907619381E0AB40AC4C4933EDDDE78A8221A0066DC2200E67DFAEFC98E44A3CE89DE25779EAEEB76EF0739AE4EA0F9C9FC66C92F7B31916AF3AC5BB13A67C5B9FD75CC781D7937FDBC97700B10260B9F788DCA03DF3867`),
		Qx: internal.HI(`013C18D22AED96BB0F64160CCC151663FA554ABF6D8F46F3571CB4FDB53`),
		Qy: internal.HI(`12CAD7DA31E3A7CD7F7171A56EA18D1E655D0DA0401DD13E8F88D919262`),
		R:  internal.HI(`AD654E0D29333E9F737165165EB8257C4D41664E88760EB386838DC9`),
		S:  internal.HI(`B3867B0AD310D0D2117D16D9231CD72B2DC2E61E7D97F43DD27C07FB0D`),
	},
	{
		M:  internal.HB(`98F607E2085120A5F4E49341E1F0AE1272EB6D88AA62F36251616BAB2B703EB02C9C09C748A7352A09DC99A19C93175D74E68DB52BA91419CD2BE4FB36BFD000A5A1BA353234F8A44A2FF2EFDEAD076067BF031772751EB3CBF1E832FD8504524D6C2A3CD21D40C9D4CA0D18210758CC782FE2B2AE7D2D1CC8786AB29EA27A0E`),
		Qx: internal.HI(`1523524533C5F290159DCA7195B0091E282EB56E67B1CAACCB8C3878780`),
		Qy: internal.HI(`14301E83AFA9814EBC8EE3F9AB260302C7DEB1D06F6862762C308210855`),
		R:  internal.HI(`F71B64746A7BEC2AA5A7A35FF2FE8FB2411A3F011BD825909392A6A0`),
		S:  internal.HI(`8E5625FCC69FB7DB037EEC7F3BE6064883739344A4709584FCAE145934`),
	},
	{
		M:  internal.HB(`340A6ED777AB6EB9884666F02B996CBB9B984476539EE5A50D2969C2831F57003230A8E8BD516BFB11E27C33077D2EAE8D034F3721E0720BA81AE9915B2C4A5EEA3CFE3A84AAA67DE385D98508F90F8ED4222CB51D7089707005F8381D2289C4C3359F7EF878189738C10F72CB790BABBC4F0F9594A6665F034EABB80981D337`),
		Qx: internal.HI(`0237EAFCC7A20D6FE7E19553ACEED45004FEED7ADF32085687E3F93DF61`),
		Qy: internal.HI(`000F5019851B7AD45BFDC1B04764B2A1BE0823194AD91CCB39A6F21CD28`),
		R:  internal.HI(`B19C471E2E8AE16FCAFA6D423606E2DB16C430EFC995617E808CC066`),
		S:  internal.HI(`7602A822E4C402D6FF64F4F7344705E1FFEF3514A8C9824E110C716981`),
	},
	{
		M:  internal.HB(`EEC6C34E89A6410813CBB76E3391A4C0598A33661D01CECCC8011FF7A8F26D256546A92CF1462AF73E8371D56C00E3EC897FDC9D96250C11EED17AC7C8462662E8B39883329362F34D72E8EBEAA65CB9F17D559823E3F5F16C19EADF8374542C00B1E0A497EF03F49AC6CDDD69942819FD7FF29E3331E59901DFA3DF379ED627`),
		Qx: internal.HI(`1AC0A3D37C763304532CCB8B1CDF024C6FC9F890B32378F9AFB73DEA936`),
		Qy: internal.HI(`1B79B388B0410360B13F05B9A8FFC73F183D1EAB441E433AF440F302996`),
		R:  internal.HI(`44105E7A1B0A10442241B26FC86F6C0D85AB7DEC631E18AC1451F4AF`),
		S:  internal.HI(`D52F812BC0AA65E5AAC5CDB010250C06E40A3D2C235CCF290F749B0F20`),
	},
	{
		M:  internal.HB(`FD90D8CAB0E5AC574857D9BDECFDE963E2270DDD7C2DC19A33CCE24F8C0D1261F943DF17582886E442A5CE8AC03DCB5A9CBD0A6AFC1DF5EF5235EEA07330F74FD4685D94B19341CB3BD7742577DA8026F2335444F77275FD7414122A23A1F9CD3746C034232615A2AEBD9D5CEF7E40586F245F50FDC0BE8D780FA62C1B1F1922`),
		Qx: internal.HI(`0157D47F705C1487426761EE71CA0F381AA22DD6E98ED001F03E38C42AB`),
		Qy: internal.HI(`197D82720F5DC4234F7A21723FF15349273AD7B5FE92951E20E0D42DEA6`),
		R:  internal.HI(`C46E8EAFC2CE58F5A82F43E900E71C625939F8ABE69F42C9915FFE86`),
		S:  internal.HI(`4EDC54D4DF7B1E626E1A2C15F7464CA962B332BB3476EDCCA6E42C68EF`),
	},
	{
		M:  internal.HB(`93CA81D1620FC368DDCF22E34B00D1EA68D0A65EE3C6D3D3046F05CE2594DCF921891F2D679D9485D32BE556F65C7A3CFB22AC22C76C426A892996214F105068E1C120F1734E56C7639ACF38A4B60F180BAAFD3B0FC01E563BD9C51DF1CB0DED9D5715B111C26366288BD1F5525BEAAE46A22B3068F704001BC109A2AB262F6B`),
		Qx: internal.HI(`04159486684EAC2E3C99039C92872BC5B3D237C99C390D2EE472D9C2AA4`),
		Qy: internal.HI(`0DD15906D9CDA14A178AB7DAB8C8301E25E4C61310548BB26E1F88E4B53`),
		R:  internal.HI(`A33980EE41F10C34475A3C1C28057D18F06366FD18F2E5D55F234E2F`),
		S:  internal.HI(`D606077512D9843D036BB53DEEA71D8FEC56DCF299A51AF497496DB046`),
	},
	{
		M:  internal.HB(`E5DA94E513C59B018416E5E343BFED9821ECD26DC872193CEFCEDD7865AB5E31117E3CF19149679EA3FA0B3D037F83D7D811964A6DB607464593C84E4F08C7F34421B61EEE68B5AD779E4E2665609ED471432204DD7205C0764B57BEE11722CE6549B19ED4660005BB13BEAC864EB85FB75C29C1E57CCDB59FDB1F46DAD9AC48`),
		Qx: internal.HI(`018353085F2F72C919CF97E446E84AB4DC54B83EB6A90C82A54A819027C`),
		Qy: internal.HI(`0F2683B3714A2CE3CA02B255CFC9C2F996ACEBDBC37F57F46F5B6BA2FBF`),
		R:  internal.HI(`36F39C6E146B85856D36A4989AB82669B81E7FB809B84592EC1B498B`),
		S:  internal.HI(`23C0DE294B644402616420AA222F95657D8D95BAFA71855E8D4FBA151A`),
	},
	{
		M:  internal.HB(`2623E38C35AC47E4F21075C1C95ED3B240DD668F9DD3A599A7CDBD5042752C4D00850CE94ACE13F367F59443DACB7B6E69EF9D65609E58463D56D82B693DEF3231ECF39F9586733F2CC845F5ADFCC09C56659920D62B3B00D8501B0FE7A9CDB5C57E6881E1B601411D3AB8837E7C3EADF5B72D87EBF12B71B73F3D1C9C5A24FB`),
		Qx: internal.HI(`116DA45DBD20EFCB5CF87DA27C64BA92F42714C286638807D7E5783F3FE`),
		Qy: internal.HI(`0CAECBE00D6B9F994D5CA9C51666E351054899D8DAACD42812F596D030C`),
		R:  internal.HI(`C62FAB88C388E3941DCE899F6677BC204ED60302305CAAC453A4A301`),
		S:  internal.HI(`593B4C7E14915285EA1AA0A55A13D326D7E0F841D661CA2B7BD5695A68`),
	},
	{
		M:  internal.HB(`8B0942483E69DCD7DCA22882D000177BF9073547D68E8BADE050FA5BAF18DA901D01619707D2AC48D300D56C7064F545E12093F715C9492F225519BB90D45C6ADB86ABF8DD4BA34337FB08A870AD0AB6F07134156D91D7DA15CA6514F7A6A3E6EE5B10DCAA5678E000E314802E0812DE33160B07ECFB33F817D3B627E4CF2BC9`),
		Qx: internal.HI(`01F42118B0D25B528E455FBD2546A716BB655AD09F41B5E497D88620645`),
		Qy: internal.HI(`00630DDE56084A81B6F58F5123A2D869E1746D6E1411017F5A54EC65A22`),
		R:  internal.HI(`E235D37B22A3C2FA60F777FC1AB92F407AFF9999558D443B8445FE71`),
		S:  internal.HI(`F86B52A8750A23103EB03114EF7C8054F42BDFF5CAF3FBF824312F549D`),
	},
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 암호알고리즘 검증기준 V3.0
	// 테스트 벡터
	// EC-KCDSA_(B-233)(SHA-224)_SVT.txt
	{
		M:  internal.HB(`392D93B496F4D4A91C7FEFE47EF247590D6206C172C3020914D9812A2B21209807189AF999C6D341BEF3CDD85FF0EB05E2653730FAF8003060468C47791238FC750FB26EE72BB65668CEF85746E39CC4D02DF08D34ACBA6B90A4E7082907D3325EC502DF58DF8807FCA6F021340AE04705704AC88CE1713D5C0E87CE4E012BCF`),
		Qx: internal.HI(`16D2A442C8F38ABA6483F72507CC8F0CBECB35498A2E01F4D07408D62E9`),
		Qy: internal.HI(`0841C701541E24A21F01C869220B28909075702EAAA1F2900FB7A52114B`),
		R:  internal.HI(`38FA03F494613CD8EC88F7A152218482D54FFAD9C9486884274BE90F`),
		S:  internal.HI(`49A4D23B013F0366832947CE747830161CCF9EA44052EB7A8BF6D84A3D`),
	},
	{
		M:  internal.HB(`F59762EA27BD3C08181D3E502AA30655EE471C921ECBF124A34647268BDF304E636756C4CE2FA3BECBD000EC933A413E6FD2090374D699EE8EE96514B8F97950DA5160342922B3F96A3FFA80196303E7C1BC5BC07B0B116C001D65A520EA97C22E1A6EB01440AB3EAC8C10AC1D431B1CBCC022D45448FAF33175CB8FE88B40C7`),
		Qx: internal.HI(`12CFB952FD86FABB725D567B54FE2294BDE81156A05777C961BB814C114`),
		Qy: internal.HI(`158AD48504F96593EDE5F5E27216AB05B1E076C2A734545A757B9FC2A9E`),
		R:  internal.HI(`454895C67C91AA0FA316F6DC23230BAC59BC06D7E10CCF7FD9DBA369`),
		S:  internal.HI(`97A9D9F7F80A570CE0EFB9718368C815EA426C9A445A4A14C9A122532C`),
	},
	{
		M:  internal.HB(`71B6D8F49D91B84EBE693A836723534080BA71A6D4C184646D62ADB81EEF28DFECB572B5B4353A14C6731ABAC37BA93385C2F3A35E97C6E16A3E04C44BEA560B08316CCB682C40CD7BE863B9B44CE5854226DB02FE780AFBB8BBC1C6233E6BB12C39DD3303D7EE4E9EC758FE0188742D1117D5033126450A8A7D370020BF28CB`),
		Qx: internal.HI(`08C6294237F4DE7985AF3CBAE21FFE3CD8B41708507DFEE61EF3F769D42`),
		Qy: internal.HI(`0181F251D7CDE450056C42FFB8058EE3179E0BF69FABCF7082B4B84F825`),
		R:  internal.HI(`E430FE4BAC32B46657B3465544274A57E6B64C48705643794638E593`),
		S:  internal.HI(`303E09E68A4152A369352A6DDD117B505AE553359413871FE95758449C`),
	},
	{
		M:  internal.HB(`220470395B1073D6576090D6E56B2B330FB270E12C196FFC70E53C220AF85EAC89479025A81723B4290CFBC8E78886D4CF6E985BDDCC9513C76ECD7284EB755C5534264B75224BB0141558D3D5304D04632B5456554EECBBFE9E8CC259BC22BCB4834F943FF2DF29385A435EBF7197BF1A3303F27437EDC8D96BDD2B80CB81BA`),
		Qx: internal.HI(`08F45820A3B926E847DABAD89B5770F680B3D86BB6EA7E9B5BA05BFDD9A`),
		Qy: internal.HI(`062723A3116D49DF0739D93E79AE01A879353CF709A52CD9E5D288AE7C9`),
		R:  internal.HI(`D6639336530E46DDFAC76EFBE31F8CB3C90326B5A7D12634C13AD7EB`),
		S:  internal.HI(`A9F88C3BDFF6E59D5CE4196715686607C20218EF2AD05DCC7DCBBD2DC8`),
	},
	{
		M:    internal.HB(`12B0554FF3DE68FDE6E435800184E690F98FB6E8C61AF664F1AA2EB323B62C47E77347B23A4C9E13E8E98DB83D3B42A518679121E3FCE9F37564B37975EBD040304E8F418137E172B88804CF2BEC88845385D95B1D252C2162070C1E1A554C52467EB8982CB43258D87F9EF777CD4F9F93674E9AAC2E35D34F14F2B7142E2F14`),
		Qx:   internal.HI(`1FB6CC5D84EB3EE9309433BBF5DC191118F53DCE12F1F48D617F7A6F7A7`),
		Qy:   internal.HI(`08C8278FBF504541964609E8CDDA7296C1A9DB5124DDB67EF19C47999F7`),
		R:    internal.HI(`18DE250954C059FFB09436D194E5947162BF430545EA0822607F9579`),
		S:    internal.HI(`95323C53747A41209CB7C1733249AD915D7EECE62D597A43554B10D6ED`),
		Fail: true,
	},
	{
		M:    internal.HB(`C61A82EECF0D42A2B6D31038CF57E22B1DC81EF99C3BD118966E84193E795116A0AD5ADD397457E91C6B5BBD1F90798BE5B76FD4372806EC939049F251293A53554D3248AA499365EEAAEDC002E147BBD46CB7EAC366D92E6BAE738B5282CBB160C7EBD577CD76D42CD53530F02500E6ACE739B01AAA6EB4DFC15726BD52DAED`),
		Qx:   internal.HI(`1111BDD6AE19A7E8853FC9E4E93DDB26DC039B621A80C5B18B09A0FB59E`),
		Qy:   internal.HI(`0F3BF7E3151A60A486250CA44331463FC064C42AC5C509EDAA4DAE4C4C4`),
		R:    internal.HI(`1F727EBBF894292426D4DE8A138FB582AA73A74C046147ABE292B38D`),
		S:    internal.HI(`062FB3F6890B4A9ECFB127D69EA0FF1E3FC163B1858B5C6D3574351D99`),
		Fail: true,
	},
	{
		M:  internal.HB(`0ECBC8C3CCD68D98607217C1F45225EF2B043E8A5D47401C00012916F47220DD05CA437C69DF3FF37C05497D8CDE6BBCF220BC32481788F002F9EEDB34BEF57FC2A1B7C7D4ED898DC844C6676E103592D82A90758483449029DCDF48ED423F79506F09398EC06CA5C8E1BC36B3DAED721CA4716D07EF8701AE417E1A2E12FB11`),
		Qx: internal.HI(`11EFE37286B92BDF53774E160C400626E319A9612AA6F2AE12590E4B7E7`),
		Qy: internal.HI(`1631EAADA74439DD332ECC613C99E2ECEB14C91A9FDACAE6030C89D0C42`),
		R:  internal.HI(`D28E0D41D136B133DBB5A39F0167F0444A817DA888530731A119AB96`),
		S:  internal.HI(`C5FC6350EE42A7918A3C15263F61314079497C772B0F667552F46400EE`),
	},
	{
		M:  internal.HB(`1AC36F00600F016A5400AB5D7727E564DBC13CAB088ECB3283F513EC8C521315501910781EC4EE02DE0E8C57699DFBC1E0850936C0BF01BDC71500065790D36A8AE8C7309002444D880EA87278324BA98E6E085354A43EC2FB58B2415F2D2DCD06B14B48976C607223CCD869B7EFF8FB88D3709648F4A419D2DF064CDCC78550`),
		Qx: internal.HI(`0346E02065B59EFEF9A934FF9F4A5D6B20E6B3D7417CFEC0588A7677082`),
		Qy: internal.HI(`1F8556CAE32951185C7FFEA1A21B6BB9D95A1E5BFC0B46D33ECBC8878A7`),
		R:  internal.HI(`79F98BD1C55AD8CBC202654B2D1614B977F10D873F089CBAAC93C32A`),
		S:  internal.HI(`FA64A8A20CC5E727DB2C2D3EB35B30649296A9CF735A67C1534F00E0AB`),
	},
	{
		M:  internal.HB(`A258C65BC92AFC47BEFADD7F08A8FE39B4847C678ADC03CB73E0BC4926C96EA58DB59C4A090EE05502F65974D78C61D4B88D68C66B1B2A298829106E366C0C2EEE2EA11E46057D775DBA4F7DDF5C3C542FDBA7BFC3189DFA35D7AE58106A73C5E89896D6BF8B969C3D3F18CDCA5A0D7B10C96CF7E818D8123DE3E45EF148588F`),
		Qx: internal.HI(`154DDE2D36835808A6D778047B14886961DE91578D655CA820547BC3D4D`),
		Qy: internal.HI(`039D9D183397379E5FECF9812AC5BA92F4002DDB0D1ABC0289AABD5159F`),
		R:  internal.HI(`E30BAC27144980A8F0233E627F987333428977EAB0D13E64D75AA6C0`),
		S:  internal.HI(`6C6CB7C3812DFF334A0E1DB754104166D1FAAF48D5A686C8CFD36504D1`),
	},
	{
		M:    internal.HB(`D223B9DEA7597EB783F8DF6B4CBBD4FCB7D45955E5B90E0951E81C4013D47C81BFD75833E85C9E898E1773BC8396B23810E31AB0CF8B54AA2DD7788C5D6C42AE4F2B8A77639A44186F8894E0D95530B64384B5C5B3000FDB89B9A18B45096092757F6F8AB87981733E469222AC16310DCC8CEF88F22D34FC827B0D1C6E001D9B`),
		Qx:   internal.HI(`0F8A4FF9F6421C9058DC87FA5AC2E10C4314A71313ED792049933554DE0`),
		Qy:   internal.HI(`0F40F36FD6C101E016CEF8BA7DADB1DBA7BC3692C0B9E22AA75BB8C93A2`),
		R:    internal.HI(`B5ADE33FF118A6A5394D591871A60EE96F6CAF0A813C8ABAC21D86A1`),
		S:    internal.HI(`E7D4606979E65D3DAA3E55A5917C9682AF0F9307D6D0D52370EC6B77C9`),
		Fail: true,
	},
	{
		M:  internal.HB(`B172AEED888BE7920E734788B28D182F2AC5EE28E257076F61D2DAB1D5807C55A5E6C7163874E09BD71E18F5CFF8B166C082975C3ED18E0FAA35D79B7387EB1099CC334BAD4A641522C4706329FAA823EA18007B654711E9B6F2DD2510FCCF2D2D83136C8C5EBE572BF7DA711DB4D41FBB8B5A27AFEF315AB3C108323E67D3E8`),
		Qx: internal.HI(`139C922194360CB0C59D762E8B518B94CBDBB1F09A20FE5185DCF9A3C26`),
		Qy: internal.HI(`0C7573667B8ACAB6EED37A7A57186E49CFCF8F56BBD294C7C8FFC887BDB`),
		R:  internal.HI(`3FFDCC4AC15635CCCD399E677E7C609FFB7F6069C0A4E8EEF68EC521`),
		S:  internal.HI(`82A836640DFA59A4D03AA61B7E8D5E581530A3F2FD2F4A1FE928A91F44`),
	},
}
