package aria

import (
	"testing"

	. "github.com/RyuaNerin/go-krypto/testingutil"
)

func Test_ARIA196_Encrypt(t *testing.T) { BTE(t, BIW(NewCipher), CE, testCases196, false) }
func Test_ARIA196_Decrypt(t *testing.T) { BTD(t, BIW(NewCipher), CD, testCases196, false) }

// 암호알고리즘 검증기준 V3.0
// 테스트 벡터
// ARIA196(ECB)KAT.txt
var testCases196 = []BlockTestCase{
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `80000000000000000000000000000000`,
		Secure: `AE56BF59874ED4DBD7B905878894ADEE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `C0000000000000000000000000000000`,
		Secure: `9363A89CB6AFE4B0BDB57DBEB42D932E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `E0000000000000000000000000000000`,
		Secure: `8603867B05270D6C2C32405A496B8937`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `F0000000000000000000000000000000`,
		Secure: `09740D96AB8545757A6B3A78BC648479`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `F8000000000000000000000000000000`,
		Secure: `73360C62DCB4DF8EE231414C9E9EBB12`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FC000000000000000000000000000000`,
		Secure: `B9F63ABBF2E3497471F8211365276D0C`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FE000000000000000000000000000000`,
		Secure: `84FD06B59A101F76F4D3258FA8BFF8DE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FF000000000000000000000000000000`,
		Secure: `D1579062D4B7AC78CC68E141F7D574CB`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FF800000000000000000000000000000`,
		Secure: `AEE4217998AFBD58888234DF02636DC0`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFC00000000000000000000000000000`,
		Secure: `42167F65919BFBAB97979E468403377D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFE00000000000000000000000000000`,
		Secure: `C44745A66E26A618A20F6BA4E0FC712F`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFF00000000000000000000000000000`,
		Secure: `4E17D1D5144C92E0A5FC093D7D9BF1BA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFF80000000000000000000000000000`,
		Secure: `7A9E3A81B917295A1F10D9A8671A47D0`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFC0000000000000000000000000000`,
		Secure: `0A743CEF8E6EDACADBF58B5AEAD409EA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFE0000000000000000000000000000`,
		Secure: `5203BB905387D0EE1AC1E991B55AEBC3`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFF0000000000000000000000000000`,
		Secure: `DC87B93E66685A326052D651BEB17121`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFF8000000000000000000000000000`,
		Secure: `2F82281CBC0D407F3A502899C88D4A7B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFC000000000000000000000000000`,
		Secure: `C29BB8EC0CA59487E0ADC75FF40C1FE1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFE000000000000000000000000000`,
		Secure: `36CFDF1E2B0232B9578864DBE6AE6CBC`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFF000000000000000000000000000`,
		Secure: `D7844B1193FD80AB30A3F7B3CB9CEA07`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFF800000000000000000000000000`,
		Secure: `1E1B5C8B55FFACC923046B9862A68703`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFC00000000000000000000000000`,
		Secure: `F41E68E5781197E02450C64B56A197D1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFE00000000000000000000000000`,
		Secure: `C2A193B5B9184489A9E04A3C311734B5`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFF00000000000000000000000000`,
		Secure: `EB208B6A995D40317476398ACEEAB75F`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFF80000000000000000000000000`,
		Secure: `8E8B9B7DEF10AF59D24EA13E8375CF04`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFC0000000000000000000000000`,
		Secure: `99E4CA74712B6AAC0F5B3FC17BB5AA92`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFE0000000000000000000000000`,
		Secure: `C8B67C384BC7A834CC253C2EE0D39CC4`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFF0000000000000000000000000`,
		Secure: `0894ADE206CFF01ECE7B3DCE2698001C`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFF8000000000000000000000000`,
		Secure: `36E897B8834BC05C6D640A1D21E5692A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFC000000000000000000000000`,
		Secure: `BEF52FF189F704EA9D2B52D4B0100ABA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFE000000000000000000000000`,
		Secure: `65A567300ADB77D7C2A6CE81BD87A47D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFF000000000000000000000000`,
		Secure: `5C49A9251016A4C5E0760A701FDEFD60`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFF800000000000000000000000`,
		Secure: `3A3C9B4E7E2431EDFFC462FE40FD42C5`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFC00000000000000000000000`,
		Secure: `852A666E77C40C1BB90D2789D27087A1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFE00000000000000000000000`,
		Secure: `6117220E0876DF07F5C27C70203B0BA4`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFF00000000000000000000000`,
		Secure: `4DD972EDFD7A98DB917B9D5D9B5A8BB8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFF80000000000000000000000`,
		Secure: `BC7C2D6582F847BAF4A7CA41A4FFA5AE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFC0000000000000000000000`,
		Secure: `AA925A9CE3615602F394B954E4B2BE51`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFE0000000000000000000000`,
		Secure: `212BFC9C9D1581740A9181C1601D0D98`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF0000000000000000000000`,
		Secure: `3EE3F5CBFA0F205A7B416B895729F502`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFF8000000000000000000000`,
		Secure: `47145FF43774F0B9080658C02F1C07A1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFC000000000000000000000`,
		Secure: `99B7AB61A4C510856E1E6660796FBA4A`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFE000000000000000000000`,
		Secure: `FBAAF48E307A8F0E9D70DF036EB54505`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF000000000000000000000`,
		Secure: `FCB4986598FCE6B48C09A3CA379AFDB4`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFF800000000000000000000`,
		Secure: `776B7DCAF411D762DD198986DA0A52D2`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFC00000000000000000000`,
		Secure: `D658C8FBD9AB35403C3C1E2D4B6D4ED3`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFE00000000000000000000`,
		Secure: `89B83A496CCDC7F90AB567F04CB67C74`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF00000000000000000000`,
		Secure: `2F56BB2663F19CE5FB037D90427DF985`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFF80000000000000000000`,
		Secure: `BAAC2EF9ADC759BE13E310DD9173D814`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFC0000000000000000000`,
		Secure: `C98AAEAD71F5B616546791BB2EFAA429`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFE0000000000000000000`,
		Secure: `67F8C0C61F2E08534674DA0E81BDDA1E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF0000000000000000000`,
		Secure: `149A80D675BF5D1AA407FDD1E3C6A285`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFF8000000000000000000`,
		Secure: `BA06B1A4863F722B804204A0D5DC7535`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFC000000000000000000`,
		Secure: `CA20B7EC6829AC05A8855BA52B624A3B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFE000000000000000000`,
		Secure: `23C27C3CE72CFFC32FA55CCB5EEC51E9`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF000000000000000000`,
		Secure: `B8983EF4C69ACF5D62B600F4E2DEC883`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFF800000000000000000`,
		Secure: `B42833EB0CDE8AF1776D15A5422B23C6`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFC00000000000000000`,
		Secure: `581DFFE2988A83E5E9F720234B7AD6F1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFE00000000000000000`,
		Secure: `4BD7AD7D95FF8AEE38D8CEFFF3D076B5`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF00000000000000000`,
		Secure: `A76D2A2EA0D94016294F782445819751`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFF80000000000000000`,
		Secure: `CF40C91B238197EDEDE40DC95E20BE02`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFC0000000000000000`,
		Secure: `A7DBD0E768129BB08B0DA5679FFE77DE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFE0000000000000000`,
		Secure: `7FFC5DBFEAD1452760A2CD4A4ABE3699`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF0000000000000000`,
		Secure: `52D342D1AC41F80B84679B85170EB502`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFF8000000000000000`,
		Secure: `EDB9D98C3AB04FBFD5438B1BA2444958`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFC000000000000000`,
		Secure: `8F1A30863EA516985B4A0915E86F278E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFE000000000000000`,
		Secure: `AB4CEFFE0D0FC4188425916D30D15213`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF000000000000000`,
		Secure: `BC82F26A5D38532EA98669799CCCCAEA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFF800000000000000`,
		Secure: `8807F77650918CF0220185A76C27571E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFC00000000000000`,
		Secure: `32E001066BF23310EE37A9594B35916C`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFE00000000000000`,
		Secure: `C9DBFE283D3FBB0930F7DBF259460ED2`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF00000000000000`,
		Secure: `AFF10AC3A3F73937B0C3D1B341356696`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFF80000000000000`,
		Secure: `7DB8DAD3A47C952D15919DB37372DD0E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFC0000000000000`,
		Secure: `2C9C8C6155C8B2D702A0E1C41A382875`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFE0000000000000`,
		Secure: `B5845CF04F74DC0B4FB1F775200A9298`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF0000000000000`,
		Secure: `6EE45E8E7E222C9ED8DB6F99A4AEB643`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFF8000000000000`,
		Secure: `FD8EFAB4B17E02515F757BEE978CDE47`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFC000000000000`,
		Secure: `67F00BAD63DCE822AB32BDB561630ED4`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFE000000000000`,
		Secure: `5837009EECB0D0A7459ADE6735D4DDC8`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF000000000000`,
		Secure: `530723C108BC2F49019817166261E2CF`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFF800000000000`,
		Secure: `F87734D536E039548D000E964BDF0EE9`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFC00000000000`,
		Secure: `3A2AE06BD68DE8C94F00FEE47C907A99`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFE00000000000`,
		Secure: `632F396F004BE4F44D48F6E358F84A56`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF00000000000`,
		Secure: `6F22168DEA31AC0CCEF4EF74A9C714A1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFF80000000000`,
		Secure: `856EA37A036ED4035809D2876BC09193`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Secure: `8345A6B1ED89AAC0C85445C429CD3CD6`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Secure: `4ACB88D06DD2B5569D576DE0E501A313`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Secure: `0913DD9E748CE2E3E66B1954EFBC11F9`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Secure: `1669EBCE25891E9A0961CEBFAA1F2970`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Secure: `77D3EA11AA25EF0B0A0981BB296E1981`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Secure: `D54EB4CAF3248952C8E51398B4596D40`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Secure: `AFE2B9D9CB5D4DB93848F82ED4028AD1`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Secure: `440CD37EF7270C0870340F00E5FA03C4`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Secure: `C0C3B61717A4357A3A9F6F116D8E105C`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Secure: `AE80CEFDC4DD659AD1CB7D8C719200AD`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Secure: `A1BC133586F5025F3C4C95B92F14D78D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Secure: `C554D3EEC2832D9BC9DB9B180836713E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Secure: `07E8DADCF63744435A8D5F34E00E3CD4`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Secure: `D66EA4A6CFE4927A6D3EA67D13589F70`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Secure: `2FEE55452CBE04571E2F09F413059C61`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Secure: `4FFEBF3F41518AB3534AD6029329BF68`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Secure: `3806CAA65F35F1A270410EDC5BCE87F2`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Secure: `8302E9D83D371679F1AC2A1737B28174`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Secure: `0798319C5379DCCA3A92704ED57552BA`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Secure: `F50881F077D7342C1131A7F59D99E685`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Secure: `C5624A004A5A593E0934C9F4D8990200`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Secure: `3B65CCABA11664FDBB19B4D255481410`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Secure: `B7CAF23583DDAA9C6AA68A1D987F22D5`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Secure: `D981F7C8A1BDDE03B50C182B06A825EC`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Secure: `DB6461D6BB2809B8189D18BF2F83675D`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Secure: `73A3F542A0BF68E622B8FEE8B250A3CF`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Secure: `5A4C8461E8A8BC4EE57761C50A2F2299`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Secure: `AC868D398E0C9C31F8A5E1E9A53B6401`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Secure: `EBC45194088D64A1E8886FB1EC95D12B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Secure: `23AA22EA73ED0494705AA24128EADF22`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Secure: `AA004A23E1AE98E5B1577E257FC91936`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Secure: `C02DEC332FF4B633B89693BAADA4B60B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Secure: `B420F7DBADD33E9F1CB66640C3B919D9`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Secure: `0F6C4EDFE68B07180794FEEC2997EDBC`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Secure: `1AC1B83169F6905B1BED4F0744B3C5BE`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Secure: `FB51114A519D59443058D62B7463F524`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Secure: `B98F324EEFDD65874A3F6269107CAA7B`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Secure: `5F6A1AB0B7B2C0DFD499CEF3879C6C50`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Secure: `AF5E01BA260811C00F18244CB05EAA7C`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Secure: `A0AABB019D4D959DAEBA7E1297BFDF8F`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Secure: `746185B815A4193EDD45DC6704625DA2`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Secure: `0BA3B90278398FAA9BB1954E7FAB38F4`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Secure: `A99DA476851EBC6C3422CC5CBD5A4934`,
	},
	{
		Key:    `800000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F9BA9C6E7E3C86FAE4BEB607F387548E`,
	},
	{
		Key:    `C00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E43600A1A73E25A76A9F207761EBF24B`,
	},
	{
		Key:    `E00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4BA8B5E4C7F7F87512625D17909692CA`,
	},
	{
		Key:    `F00000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B66D5B122236F18041ADD330C8921505`,
	},
	{
		Key:    `F80000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `47112C4221BD391FE23334D41AB76C32`,
	},
	{
		Key:    `FC0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6EF3191A8C2A7DA4E237670D9986691E`,
	},
	{
		Key:    `FE0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F39A78B7A4C71623D1C651257BDFF8DD`,
	},
	{
		Key:    `FF0000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9F4D7DD4606DC65E8C137C3B4CE6E3BB`,
	},
	{
		Key:    `FF8000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `061D3F433B33C3471A375F79C05BFB3E`,
	},
	{
		Key:    `FFC000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B26EE1AAC4F38E3BBFECE768D0C3E53B`,
	},
	{
		Key:    `FFE000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `17528CD4F5617ACBFAAA7BDCDD3D89C8`,
	},
	{
		Key:    `FFF000000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F720DD867F23DF7027A377137EC3E142`,
	},
	{
		Key:    `FFF800000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3B79F17AD7DE0785FB6254A266C719EB`,
	},
	{
		Key:    `FFFC00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BC49152D09E7EAEB795CC0C62180D650`,
	},
	{
		Key:    `FFFE00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B937B17F5CD8C23373BC4B647E49BE76`,
	},
	{
		Key:    `FFFF00000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CE7A108AAF504C459A277A2A0B62AC4F`,
	},
	{
		Key:    `FFFF80000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `022112916F04DB14E98AFBBA51B5C48E`,
	},
	{
		Key:    `FFFFC0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D0DE18C3D4D9BC2422A0083D784F60F9`,
	},
	{
		Key:    `FFFFE0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `25CC01412F252EBF7CF41C1890CF6CBE`,
	},
	{
		Key:    `FFFFF0000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EE9DC6BAB35986EA0C3D00A6831D7706`,
	},
	{
		Key:    `FFFFF8000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1594B08654655B801AC0AC5E0762F692`,
	},
	{
		Key:    `FFFFFC000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AB6B32D5F29B687097BAB6D3B9E20B77`,
	},
	{
		Key:    `FFFFFE000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `38053A607C9DE85B1F50E734DF60C966`,
	},
	{
		Key:    `FFFFFF000000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F50A893337190571DD41DC46297E67D5`,
	},
	{
		Key:    `FFFFFF800000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `11D2E32C28EBB5C0EEF2BD717F5DC42F`,
	},
	{
		Key:    `FFFFFFC00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2BE694159A45B0D29E6B8207F7957DB0`,
	},
	{
		Key:    `FFFFFFE00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5DC3BBE7ABF29E45AC86D0637FFB4FB8`,
	},
	{
		Key:    `FFFFFFF00000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FD6F29770409198587C6FEDDC8A1BC11`,
	},
	{
		Key:    `FFFFFFF80000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A3616DCC329ECF6EB461F5EF31E12AC0`,
	},
	{
		Key:    `FFFFFFFC0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `50652E743D7E467E8224C7F67C0E2BC0`,
	},
	{
		Key:    `FFFFFFFE0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EB7841105F6D1ECD354D6972DC225204`,
	},
	{
		Key:    `FFFFFFFF0000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `231CE5B0F2071FDA9C484AFA7DC30AE6`,
	},
	{
		Key:    `FFFFFFFF8000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `526E31CAA55C9133ED1C10694D5E325E`,
	},
	{
		Key:    `FFFFFFFFC000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CB2D106684DA73F6CEF4B33E80705A2D`,
	},
	{
		Key:    `FFFFFFFFE000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `68525AE95BA43D0D7E6F93DA1A0BA200`,
	},
	{
		Key:    `FFFFFFFFF000000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FBA3859D11B589014BA21987B522AC88`,
	},
	{
		Key:    `FFFFFFFFF800000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EBA0F1C2090941CE7F5109858111DE8C`,
	},
	{
		Key:    `FFFFFFFFFC00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2CD6E3508822D6CA3126267BA55D1CD4`,
	},
	{
		Key:    `FFFFFFFFFE00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `912F0FC0D68F063EB195475B8845D2DD`,
	},
	{
		Key:    `FFFFFFFFFF00000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `651B31DD7E4C709CF5F9B964DDA61BBA`,
	},
	{
		Key:    `FFFFFFFFFF80000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `778425891BED81414E34810E97C79017`,
	},
	{
		Key:    `FFFFFFFFFFC0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `451005A0AC8A7F0CB66F0D9CCCE7E487`,
	},
	{
		Key:    `FFFFFFFFFFE0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B218E894BACCB3E9D9D9021E299D3866`,
	},
	{
		Key:    `FFFFFFFFFFF0000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `499EEE121F4C73AEDEF81D1D31A4F127`,
	},
	{
		Key:    `FFFFFFFFFFF8000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AF0FEAF05147CB15742B1EF903E574BE`,
	},
	{
		Key:    `FFFFFFFFFFFC000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9603ED7A16D161E823100278B7644BA2`,
	},
	{
		Key:    `FFFFFFFFFFFE000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `36C337C339B50C847646360428A9743B`,
	},
	{
		Key:    `FFFFFFFFFFFF000000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `740880027AF6F155E21E34D4920A4AA8`,
	},
	{
		Key:    `FFFFFFFFFFFF800000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FB8CA9A7F482329D197E5239D93B2E88`,
	},
	{
		Key:    `FFFFFFFFFFFFC00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `166CCB33C416D2938E6B305F58AFF702`,
	},
	{
		Key:    `FFFFFFFFFFFFE00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `64BF7DBAC5419CACA91B5E5A86688B94`,
	},
	{
		Key:    `FFFFFFFFFFFFF00000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A90D8AC7FEE906B25758D72E47E6686B`,
	},
	{
		Key:    `FFFFFFFFFFFFF80000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `96C392C91A3232ED9016617D2DE57CAF`,
	},
	{
		Key:    `FFFFFFFFFFFFFC0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D0D2B5F3C953EFC5B7E1C62927DDE97D`,
	},
	{
		Key:    `FFFFFFFFFFFFFE0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BD37A049B99828BE7DD29D32C1816800`,
	},
	{
		Key:    `FFFFFFFFFFFFFF0000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DDD562722CBD9123F82E635E7BA63A5C`,
	},
	{
		Key:    `FFFFFFFFFFFFFF8000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C53285EC0130BE39BEE63EF144F13602`,
	},
	{
		Key:    `FFFFFFFFFFFFFFC000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `999BC2418CF1EAC2602298F331B31C89`,
	},
	{
		Key:    `FFFFFFFFFFFFFFE000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `12F240AEB16E582C9227407DA30A9642`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF000000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `551185760E46ECCF0A51871CFC4B6B70`,
	},
	{
		Key:    `FFFFFFFFFFFFFFF800000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E3922E3624B1927DBEB3BFB9E90DCF7C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFC00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FDBC92DDD809AEF3AA1E87AA92FDF3E3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFE00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `020155994756B93B51681068458C0196`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF00000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C102F2CE7166D6B85731AC72188F82BD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFF80000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `93757EAAC49A69F6BBBBEFD747B25D94`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFC0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D716C2FD0321E07466A7DB9A8A828D9F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFE0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FA52D15CBF413B237FBCC28C5D6BEAE0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF0000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `57123134FF0083960ED515E6B52B48A5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFF8000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4C7A54AE248E9EE70C6FD3798C8A741B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFC000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D084D6B08ECDFDDBC22EA3A521900CDE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFE000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C86CD3ED3A9E7F7E276F1F00DA923CC8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF000000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9C51983ABFD38F8DB3494C2C8AFB201F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFF800000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E603248D7486FA20F1C1657EE42F8D7E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFC00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B9EC2252417802524AC6A996948F8885`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFE00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `29F7BB074B67D31B272E7035AABC6265`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF00000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FB696BE8FC2912AD658B5B6F9B7AC951`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFF80000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E515F64634454C54FC7E6DEA2B33F516`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFC0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `64BF4AE6E9552B9FEF75768C4BB80A9E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFE0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `943F23A80903011427E9EAA8B4265C28`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF0000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C4B9898B80F2E0A59F1A01FB15369D6C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFF8000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A9F2FC479EF563C57D481973E958D877`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFC000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3EB26BD59FF04CC9908F2116FDCABB71`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFE000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `39CE1CFC9DD1DEF5C88F470565ED1701`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF000000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `562CD161C404F5AF2268E04AC446FD78`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFF800000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4937517A5DB338F244FE3B2E7D5CAD9F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFC00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A632146EECC9E2CF4088092129DCC2D8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFE00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B2D15476AB8D1CA5A76DA44ADA35F1C6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DEF22C703F62821C298D9CEEFCF48C65`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFF80000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `001DA6FD6FCA995D41F22AA9815F5005`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `32D6170F7E5393CEAFCF775F25104132`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4196DE829B9E20489788CF025575150F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `570F18D9021240CAAB01103ECD12365C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CBF33E01F8E1515E358C40746078B1B0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A178B5AF426F7F63A634CF81439E98AC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9967C6A80FD17FFCE15CDB7ECDB4DD9A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `65C089FE2549873E65D1B437E96E9948`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `40398B8EDE11809A1577A6D0AACF89E1`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `62D3B842FA58153EB1AD068C0D7634DD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B65E51B845A42A0ECFD96F8DDB4D58FA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D96E78368CD06A2C68102827CE37B777`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5AF4185590219393D982D5A5F6D91F74`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A6450BF4A33D6868DB00B8156CF54710`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0DC2EC60B08FA55E8ECE9533B1730311`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D9F4D05D3D939E057A9A02856A653403`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `32A5182D2E57CDE13DDE73125BA38C28`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9BE7E99B20BBB94B201C007679A6409E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B9B8D13544F264E0822C9784132DFCC5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A2EE265BD162CD2475E1962A788F4EFD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `95F145A422D8D037E3CDB929C6F0CC45`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8D3D9882BDC2C64C7C630EFCAC653C06`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `81B01C0371A03FF9D67BF065428D05D3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B8D45F3EA9CEE2BEB7094F73E6A85ADB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5947B9C6E52C8E9D910924E32EA1F4F6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B67D2AA7581528B6ACE43D2C5B418CEE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B17D2A53BC28E31692421838D4F6DC09`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `23FDB4F46FDFE8E79708A60D500886B4`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `F8C8CF62E6E89224EB8736C31CDA2F6C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `92C4ED1561A844BC9C302759586E177A`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `442E67903CB84F82DADCEE51EC9E9F0B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BB4B3B0553BCA191BDCE370343A68514`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2A7AF7C2C678398DF86BF978C920179E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E01DFF47F79E6E9212F7A5CD758DBCD8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `500CBDC40E18735439F9F785404B8002`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `180C5031CD700ED9B79D9D13DE50FA36`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4466310E057D464EA2FFC364B993A8A9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9C3307BDBFAAEE3BB541F8AEC263C571`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `192B46493637AB78F7BB3B522348D61C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `56508A71078241CBA46F7082F89A65DA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `558066171977B6C09BDC4C7E05936E0F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C6C3CBE000DD3E1A270907E7E7143BCC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BCECA5982F04CDAC788961A6D675A9B9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D96DB82E7F61EA6231D500010A6570DB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D3159239D2550E8A5802315896F6CAFF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EB568C418D9E25ECCFE50B8318AC1F8F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C72A7FF611AC8040C4F1D5DAEB0DD17F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BE9930DF2FD1FE3385D78826EB00E454`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E6FAA14DD2A281B1F29F0EB734B10F7E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E3735128A435E2FF8328DC9CEDE2D9AF`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `72D96D16A48A81B88F74827F269E9509`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `EAA24DDA3BAD6F55BC69BDC4D9D9BF35`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B1E327B73DF8406A1CABEBBFFB887DFD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `3C5D58D2DD94F74B3ABB2DA3165908B0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7136590D600FFB1510E7C57D3B27DE02`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D956BF85479830C504F1A97E02D49FA0`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `BE8AA6D6909C851210BC554D2F1A53FC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A900E51940C6A42D3941A611764DDC6B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B42A78D7D9D6E898F12EF9F351B36E66`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C89B588F6D2849E43D79DA603375A6EE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `56077BB20DEE9A54EDADF95417D822CA`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `71123EA80AD12A888346DA5BC04F38CE`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `072B46AA0F9CDD34B747C97DBD200234`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AD87BF39C2CEF235E3D383D95026BB1E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2051049CEB22F6DF6679457B4E290CBB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9FAE7CCE6DA50D7641027F9C71A85713`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C90572DD23ACF2A43EAFD24C13C7D23C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B6512923B6BC39E54A2FB375D3E96768`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `D4FBDE3B3556A9868CDD900311EF068D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `2DD98AF796F45346FA3372962781F299`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A08276662FE3D15FFDB3210867BE6073`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B7722576ED58FE54C08B1F07FF7482D8`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `9E0BFFB3235D334011D55A8BB6CC0875`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `A2A201505E444DE6E186C683F0DE00F3`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `8A55073858B22854EEFA8B3E9F676046`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4B46AD97E8619D53AFB24695BC21CA45`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `DEBF4E7293223DA91D70A89DCBE03C3D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5140050C08AA1952D52757EC67CF960B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `5AAC90B2EA9888D4D35F81786FFC0F12`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `59F42B60D01ACA1E413DC348C4A8256C`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `431B84C9E29FD532879E65CE1779DCBC`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E8F1C6ED351FF8F278FE79514B7084B6`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `0EB9E58B067758D556C10B17DDCE6266`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `55BAD40D43B4E1914CC658B06EC2680F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `07BCB276C4D7D5D9F8AB8E6818B52D78`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `1E920C20B43FB591B72156AB24C384DB`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AE767451B65A4C5348E36B70442C07B2`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `B0F2BE1EA6ACDEA4ACA9D3A58B998AA5`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `509ADA19CAFED18BF1A28D3E19D5763E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E10604796643EFD634E2337DAF7E261D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FDB264ED472BD848BF9803A1FD4F059E`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `02137410500ED74536D7CBDFAE1C3C9F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4E0BE207CBD9409DF1F83A8FDAAD541B`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C7C07945EB96933BCB3885733DF90F27`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `CCA8AAB4BEFD95D6B47F3EEF72A9358F`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C65692B4C651857FC09232B6C3D167BD`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `7DE04FFA669D50413148098CF2CEDDE9`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `E612078FD804B4C4665542CBEF2D317D`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `6F12981951B58653FDE8D86AB7DAFD69`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `31DBF07065B4241CFEEC012E1FA07887`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `4BFDC239558E15AFFC7E9EFA6E9B8176`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `FED1C7B9A96807C87C6B5ED3DCAFB157`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `AB93810618D37B08CACEC8B769B91C52`,
	},
	{
		Key:    `FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF`,
		Plain:  `00000000000000000000000000000000`,
		Secure: `C4DFD15FC41636060F97E617EB0D7DD7`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `46230CD4358D3764147F55932C57A80B`,
		Secure: `8EBE829B4ABC436524304273CCBAC968`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `87EC4C14643C0B34D9FA13C93A1421C5`,
		Secure: `96CBCFCC0487928645A382FE88B7E439`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `4835204C2180779C03B241944B586DD6`,
		Secure: `99CFF43506458844CC8812BDED0AAE4E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `4F31DCF963303109FFDE69EA0C5A816A`,
		Secure: `C15AF32FD27B08E9709FBA5722D53C95`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `F51F8EAE9922D8E888D7D4437C9DC981`,
		Secure: `D1647BFAEE887EC8C336C325F5FCFD81`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `206CD56584A8FBD6DB93C5F500031398`,
		Secure: `F69E74F4CBA87F958565FB8AF43B2A5E`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `ED277450201782CEF2583009F2034789`,
		Secure: `882E291CEA8EF93287CC2EC07DC35C68`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `9F1B7348EABAA95FDB88162B5971E978`,
		Secure: `6AC6117DD3BF0C00460E74BCACEA2BA0`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `DE8500CB0F37528BCCE7F66B157E2F06`,
		Secure: `2DACD6F0C91DC634541657DAB3CFD476`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `2D9498034A4C6BDB041FAFD8F289684E`,
		Secure: `85EF3556E0A6893B938455767EB40791`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `7D5FFA85B9723F099ED13A65268994AF`,
		Secure: `B7E155A9CB8D16978B992241E45297F6`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `D82D8D8819FCC3C85121C8CB1D3BB773`,
		Secure: `27CBF0EC80DC8CB65C535D7E84725C10`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `B9743F44F44467CF834F8B1F4F753386`,
		Secure: `AC874517824D5D008DCF1FCB937ECE61`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `58A85B680E003B9D390F0735DA8FE33B`,
		Secure: `739B566EB0C0C8B15216F3E387D6DBE6`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `B50B618F70E5FEEB94C8F2E8F6A118B9`,
		Secure: `AF38422FC3FCE412C16D7F0CE69F56CF`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `05997613283E4DFB797BD698C80536A8`,
		Secure: `4EEE1CB3106043BCA7557D24C8EFD637`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `83F7A9E91771806D6641E6FB5A20C521`,
		Secure: `F2C24C1C1B6E53C8315B524928BFA270`,
	},
	{
		Key:    `000000000000000000000000000000000000000000000000`,
		Plain:  `A759154D0D4A56EAAFFD36D1C650909D`,
		Secure: `6CEFC4AAB805325FF774CCB95600B5F3`,
	},
}
