# Support

## Getting Help with Fabric

Need help with Fabric? Here are the best ways to get assistance:

## 📖 Documentation First

Before reaching out, check these resources:

- **[README.md](../README.md)** - Installation, usage, and examples
- **[docs/](./README.md)** - Detailed documentation
- **[Patterns](../data/patterns/)** - Browse available AI patterns

## 🐛 Bug Reports

Found a bug? Please create an issue:

**[Report a Bug](https://github.com/danielmiessler/fabric/issues/new?template=bug.yml)**

Include:

- Fabric version (`fabric --version`)
- Operating system
- Steps to reproduce
- Expected vs actual behavior
- Error messages/logs

## 💡 Feature Requests

Have an idea for Fabric? We'd love to hear it:

**[Request a Feature](https://github.com/danielmiessler/fabric/issues/new)**

Describe:

- What you want to achieve
- Why it would be useful
- How you envision it working
- Any alternatives you've considered

## 🤔 Questions & Discussions

For general questions, usage help, or community discussion:

**[GitHub Discussions](https://github.com/danielmiessler/fabric/discussions)**

Great for:

- "How do I...?" questions
- Sharing patterns you've created
- Getting community advice
- Feature brainstorming

## 🏷️ Issue Labels

When creating issues, maintainers will add appropriate labels:

- `bug` - Something isn't working
- `enhancement` - New feature request
- `documentation` - Documentation improvements
- `help wanted` - Community contributions welcome
- `good first issue` - Great for new contributors
- `question` - General questions
- `pattern` - Related to AI patterns

## 📋 Issue Templates

We provide templates to help you create detailed reports:

- **Bug Report** - Structured bug reporting
- **Feature Request** - Detailed feature proposals
- **Pattern Submission** - New pattern contributions

## 🔒 Security Issues

**DO NOT create public issues for security vulnerabilities.**

See our [Security Policy](./SECURITY.md) for proper reporting procedures.

## ⚡ Response Times

We're a community-driven project with volunteer maintainers:

- **Bugs**: We aim to acknowledge within 48 hours
- **Features**: Response time varies based on complexity
- **Questions**: Community often responds quickly
- **Security**: See security policy for timelines

## 🛠️ Self-Help Tips

Before creating an issue, try:

1. **Update Fabric**: `go install github.com/danielmiessler/fabric/cmd/fabric@latest`
2. **Check existing issues**: Someone might have the same problem
3. **Run setup**: `fabric --setup` can fix configuration issues
4. **Test minimal example**: Isolate the problem

## 🤝 Community Guidelines

When asking for help:

- Be specific and provide context
- Include relevant details and error messages
- Be patient - maintainers are volunteers
- Help others when you can
- Say thanks when someone helps you

## 📞 Emergency Contact

For urgent security issues only:

- Email: <security@fabric.ai> (if available)
- Maintainer: <daniel@danielmiessler.com>

## 🎯 What We Can Help With

✅ **We can help with:**

- Installation and setup issues
- Usage questions and examples
- Bug reports and fixes
- Feature discussions
- Pattern creation guidance
- Integration questions

❌ **We cannot help with:**

- Custom development for your specific use case
- Troubleshooting your specific AI provider issues
- General AI or programming tutorials
- Commercial support agreements

## 💪 Contributing Back

The best way to get help is to help others:

- Answer questions in discussions
- Improve documentation
- Share useful patterns
- Report bugs clearly
- Review pull requests

See our [Contributing Guide](./CONTRIBUTING.md) for details.

---

*Remember: We're all here to make Fabric better. Be kind, be helpful, and let's build something amazing together!*
