//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstreamanalytics

import "time"

// AggregateFunctionProperties - The properties that are associated with an aggregate function.
type AggregateFunctionProperties struct {
	// REQUIRED; Indicates the type of function.
	Type       *string
	Properties *FunctionConfiguration

	// READ-ONLY; The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string
}

// GetFunctionProperties implements the FunctionPropertiesClassification interface for type AggregateFunctionProperties.
func (a *AggregateFunctionProperties) GetFunctionProperties() *FunctionProperties {
	return &FunctionProperties{
		Etag:       a.Etag,
		Properties: a.Properties,
		Type:       a.Type,
	}
}

// AvroSerialization - Describes how data from an input is serialized or how data is serialized when written to an output
// in Avro format.
type AvroSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType

	// The properties that are associated with the Avro serialization type. Required on PUT (CreateOrReplace) requests.
	Properties any
}

// GetSerialization implements the SerializationClassification interface for type AvroSerialization.
func (a *AvroSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: a.Type,
	}
}

// AzureDataExplorerOutputDataSource - Describes an Azure Data Explorer output data source.
type AzureDataExplorerOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Azure Data Explorer output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureDataExplorerOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureDataExplorerOutputDataSource.
func (a *AzureDataExplorerOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureDataExplorerOutputDataSourceProperties - The properties that are associated with an Azure Data Explorer output.
type AzureDataExplorerOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Azure Data Explorer cluster. Required on PUT (CreateOrReplace) requests.
	Cluster *string

	// The name of the Azure Data Explorer database. Required on PUT (CreateOrReplace) requests.
	Database *string

	// The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
	Table *string
}

// AzureDataLakeStoreOutputDataSource - Describes an Azure Data Lake Store output data source.
type AzureDataLakeStoreOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Azure Data Lake Store output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureDataLakeStoreOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureDataLakeStoreOutputDataSource.
func (a *AzureDataLakeStoreOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureDataLakeStoreOutputDataSourceProperties - The properties that are associated with an Azure Data Lake Store.
type AzureDataLakeStoreOutputDataSourceProperties struct {
	// The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
	AccountName *string

	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
	DateFormat *string

	// The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
	FilePathPrefix *string

	// A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source.
	// A valid refresh token is currently only obtainable via the Azure Portal. It
	// is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate
	// the data source which will update this property with a valid refresh
	// token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string

	// The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
	TenantID *string

	// The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
	TimeFormat *string

	// The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user
	// was used to obtain the refresh token.
	TokenUserDisplayName *string

	// The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember
	// which user was used to obtain the refresh token.
	TokenUserPrincipalName *string
}

// AzureFunctionOutputDataSource - Defines the metadata of AzureFunctionOutputDataSource
type AzureFunctionOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a Azure Function output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureFunctionOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureFunctionOutputDataSource.
func (a *AzureFunctionOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureFunctionOutputDataSourceProperties - The properties that are associated with an Azure Function output.
type AzureFunctionOutputDataSourceProperties struct {
	// If you want to use an Azure Function from another subscription, you can do so by providing the key to access your function.
	APIKey *string

	// The name of your Azure Functions app.
	FunctionAppName *string

	// The name of the function in your Azure Functions app.
	FunctionName *string

	// A property that lets you specify the maximum number of events in each batch that's sent to Azure Functions. The default
	// value is 100.
	MaxBatchCount *float32

	// A property that lets you set the maximum size for each output batch that's sent to your Azure function. The input unit
	// is in bytes. By default, this value is 262,144 bytes (256 KB).
	MaxBatchSize *float32
}

// AzureMachineLearningServiceFunctionBinding - The binding to an Azure Machine Learning web service.
type AzureMachineLearningServiceFunctionBinding struct {
	// REQUIRED; Indicates the function binding type.
	Type *string

	// The binding properties associated with an Azure Machine learning web service.
	Properties *AzureMachineLearningServiceFunctionBindingProperties
}

// GetFunctionBinding implements the FunctionBindingClassification interface for type AzureMachineLearningServiceFunctionBinding.
func (a *AzureMachineLearningServiceFunctionBinding) GetFunctionBinding() *FunctionBinding {
	return &FunctionBinding{
		Type: a.Type,
	}
}

// AzureMachineLearningServiceFunctionBindingProperties - The binding properties associated with an Azure Machine learning
// web service.
type AzureMachineLearningServiceFunctionBindingProperties struct {
	// The API key used to authenticate with Request-Response endpoint.
	APIKey *string

	// Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
	BatchSize *int32

	// The Request-Response execute endpoint of the Azure Machine Learning web service.
	Endpoint *string

	// Label for the input request object.
	InputRequestName *string

	// The inputs for the Azure Machine Learning web service endpoint.
	Inputs []*AzureMachineLearningServiceInputColumn

	// The number of parallel requests that will be sent per partition of your job to the machine learning service. Default is
	// 1.
	NumberOfParallelRequests *int32

	// Label for the output request object.
	OutputResponseName *string

	// A list of outputs from the Azure Machine Learning web service endpoint execution.
	Outputs []*AzureMachineLearningServiceOutputColumn
}

// AzureMachineLearningServiceFunctionBindingRetrievalProperties - The binding retrieval properties associated with an Azure
// Machine learning web service.
type AzureMachineLearningServiceFunctionBindingRetrievalProperties struct {
	// The Request-Response execute endpoint of the Azure Machine Learning web service.
	ExecuteEndpoint *string

	// The function type.
	UdfType *string
}

// AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters - The parameters needed to retrieve the default
// function definition for an Azure Machine Learning web service function.
type AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters struct {
	// REQUIRED; Indicates the function binding type.
	BindingType *string

	// The binding retrieval properties associated with an Azure Machine learning web service.
	BindingRetrievalProperties *AzureMachineLearningServiceFunctionBindingRetrievalProperties
}

// GetFunctionRetrieveDefaultDefinitionParameters implements the FunctionRetrieveDefaultDefinitionParametersClassification
// interface for type AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters.
func (a *AzureMachineLearningServiceFunctionRetrieveDefaultDefinitionParameters) GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters {
	return &FunctionRetrieveDefaultDefinitionParameters{
		BindingType: a.BindingType,
	}
}

// AzureMachineLearningServiceInputColumn - Describes an input column for the Azure Machine Learning web service endpoint.
type AzureMachineLearningServiceInputColumn struct {
	// The (Azure Machine Learning supported) data type of the input column.
	DataType *string

	// The zero based index of the function parameter this input maps to.
	MapTo *int32

	// The name of the input column.
	Name *string
}

// AzureMachineLearningServiceInputs - The inputs for the Azure Machine Learning web service endpoint.
type AzureMachineLearningServiceInputs struct {
	// A list of input columns for the Azure Machine Learning web service endpoint.
	ColumnNames []*AzureMachineLearningServiceInputColumn

	// The name of the input. This is the name provided while authoring the endpoint.
	Name *string
}

// AzureMachineLearningServiceOutputColumn - Describes an output column for the Azure Machine Learning web service endpoint.
type AzureMachineLearningServiceOutputColumn struct {
	// The (Azure Machine Learning supported) data type of the output column.
	DataType *string

	// The zero based index of the function parameter this input maps to.
	MapTo *int32

	// The name of the output column.
	Name *string
}

// AzureMachineLearningStudioFunctionBinding - The binding to an Azure Machine Learning Studio.
type AzureMachineLearningStudioFunctionBinding struct {
	// REQUIRED; Indicates the function binding type.
	Type *string

	// The binding properties associated with an Azure Machine learning Studio.
	Properties *AzureMachineLearningStudioFunctionBindingProperties
}

// GetFunctionBinding implements the FunctionBindingClassification interface for type AzureMachineLearningStudioFunctionBinding.
func (a *AzureMachineLearningStudioFunctionBinding) GetFunctionBinding() *FunctionBinding {
	return &FunctionBinding{
		Type: a.Type,
	}
}

// AzureMachineLearningStudioFunctionBindingProperties - The binding properties associated with an Azure Machine learning
// Studio.
type AzureMachineLearningStudioFunctionBindingProperties struct {
	// The API key used to authenticate with Request-Response endpoint.
	APIKey *string

	// Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
	BatchSize *int32

	// The Request-Response execute endpoint of the Azure Machine Learning Studio. Find out more here:
	// https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
	Endpoint *string

	// The inputs for the Azure Machine Learning Studio endpoint.
	Inputs *AzureMachineLearningStudioInputs

	// A list of outputs from the Azure Machine Learning Studio endpoint execution.
	Outputs []*AzureMachineLearningStudioOutputColumn
}

// AzureMachineLearningStudioFunctionBindingRetrievalProperties - The binding retrieval properties associated with an Azure
// Machine learning Studio.
type AzureMachineLearningStudioFunctionBindingRetrievalProperties struct {
	// The Request-Response execute endpoint of the Azure Machine Learning Studio. Find out more here:
	// https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
	ExecuteEndpoint *string

	// The function type.
	UdfType *string
}

// AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters - The parameters needed to retrieve the default function
// definition for an Azure Machine Learning Studio function.
type AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters struct {
	// REQUIRED; Indicates the function binding type.
	BindingType *string

	// The binding retrieval properties associated with an Azure Machine learning Studio.
	BindingRetrievalProperties *AzureMachineLearningStudioFunctionBindingRetrievalProperties
}

// GetFunctionRetrieveDefaultDefinitionParameters implements the FunctionRetrieveDefaultDefinitionParametersClassification
// interface for type AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters.
func (a *AzureMachineLearningStudioFunctionRetrieveDefaultDefinitionParameters) GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters {
	return &FunctionRetrieveDefaultDefinitionParameters{
		BindingType: a.BindingType,
	}
}

// AzureMachineLearningStudioInputColumn - Describes an input column for the Azure Machine Learning Studio endpoint.
type AzureMachineLearningStudioInputColumn struct {
	// The (Azure Machine Learning supported) data type of the input column. A list of valid Azure Machine Learning data types
	// are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
	DataType *string

	// The zero based index of the function parameter this input maps to.
	MapTo *int32

	// The name of the input column.
	Name *string
}

// AzureMachineLearningStudioInputs - The inputs for the Azure Machine Learning Studio endpoint.
type AzureMachineLearningStudioInputs struct {
	// A list of input columns for the Azure Machine Learning Studio endpoint.
	ColumnNames []*AzureMachineLearningStudioInputColumn

	// The name of the input. This is the name provided while authoring the endpoint.
	Name *string
}

// AzureMachineLearningStudioOutputColumn - Describes an output column for the Azure Machine Learning Studio endpoint.
type AzureMachineLearningStudioOutputColumn struct {
	// The (Azure Machine Learning supported) data type of the output column. A list of valid Azure Machine Learning data types
	// are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
	DataType *string

	// The name of the output column.
	Name *string
}

// AzureSQLDatabaseDataSourceProperties - The properties that are associated with an Azure SQL database data source.
type AzureSQLDatabaseDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string

	// Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
	MaxBatchCount *float32

	// Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
	MaxWriterCount *float32

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string
}

// AzureSQLDatabaseOutputDataSource - Describes an Azure SQL database output data source.
type AzureSQLDatabaseOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Azure SQL database output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureSQLDatabaseOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureSQLDatabaseOutputDataSource.
func (a *AzureSQLDatabaseOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureSQLDatabaseOutputDataSourceProperties - The properties that are associated with an Azure SQL database output.
type AzureSQLDatabaseOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string

	// Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
	MaxBatchCount *float32

	// Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
	MaxWriterCount *float32

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string
}

// AzureSQLReferenceInputDataSource - Describes an Azure SQL database reference input data source.
type AzureSQLReferenceInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with SQL DB input containing reference data. Required on PUT (CreateOrReplace) requests.
	Properties *AzureSQLReferenceInputDataSourceProperties
}

// GetReferenceInputDataSource implements the ReferenceInputDataSourceClassification interface for type AzureSQLReferenceInputDataSource.
func (a *AzureSQLReferenceInputDataSource) GetReferenceInputDataSource() *ReferenceInputDataSource {
	return &ReferenceInputDataSource{
		Type: a.Type,
	}
}

// AzureSQLReferenceInputDataSourceProperties - The properties that are associated with SQL DB input containing reference
// data. Required on PUT (CreateOrReplace) requests.
type AzureSQLReferenceInputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// This element is associated with the datasource element. This is the name of the database that output will be written to.
	Database *string

	// This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database.
	// To use this option, we recommend using temporal tables in Azure SQL
	// Database.
	DeltaSnapshotQuery *string

	// This element is associated with the datasource element. This query is used to fetch data from the sql database.
	FullSnapshotQuery *string

	// This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database
	// instance.
	Password *string

	// This element is associated with the datasource element. This indicates how frequently the data will be fetched from the
	// database. It is of DateTime format.
	RefreshRate *string

	// Indicates the type of data refresh option.
	RefreshType *RefreshType

	// This element is associated with the datasource element. This is the name of the server that contains the database that
	// will be written to.
	Server *string

	// This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database
	// instance.
	User *string
}

// AzureSynapseDataSourceProperties - The properties that are associated with an Azure SQL database data source.
type AzureSynapseDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string
}

// AzureSynapseOutputDataSource - Describes an Azure Synapse output data source.
type AzureSynapseOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Azure Synapse output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureSynapseOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureSynapseOutputDataSource.
func (a *AzureSynapseOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureSynapseOutputDataSourceProperties - The properties that are associated with an Azure Synapse output.
type AzureSynapseOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string
}

// AzureTableOutputDataSource - Describes an Azure Table output data source.
type AzureTableOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Azure Table output. Required on PUT (CreateOrReplace) requests.
	Properties *AzureTableOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type AzureTableOutputDataSource.
func (a *AzureTableOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: a.Type,
	}
}

// AzureTableOutputDataSourceProperties - The properties that are associated with an Azure Table output.
type AzureTableOutputDataSourceProperties struct {
	// The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string

	// The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string

	// The number of rows to write to the Azure Table at a time.
	BatchSize *int32

	// If specified, each item in the array is the name of a column to remove (if present) from output event entities.
	ColumnsToRemove []*string

	// This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key
	// for the Azure Table. Required on PUT (CreateOrReplace) requests.
	PartitionKey *string

	// This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for
	// the Azure Table. Required on PUT (CreateOrReplace) requests.
	RowKey *string

	// The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
	Table *string
}

// BlobDataSourceProperties - The properties that are associated with a blob data source.
type BlobDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of a container within the associated Storage account. This container contains either the blob(s) to be read from
	// or written to. Required on PUT (CreateOrReplace) requests.
	Container *string

	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string
}

// BlobOutputDataSource - Describes a blob output data source.
type BlobOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a blob output. Required on PUT (CreateOrReplace) requests.
	Properties *BlobOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type BlobOutputDataSource.
func (b *BlobOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: b.Type,
	}
}

// BlobOutputDataSourceProperties - The properties that are associated with a blob output.
type BlobOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// Blob path prefix.
	BlobPathPrefix *string

	// Blob write mode.
	BlobWriteMode *BlobWriteMode

	// The name of a container within the associated Storage account. This container contains either the blob(s) to be read from
	// or written to. Required on PUT (CreateOrReplace) requests.
	Container *string

	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string
}

// BlobReferenceInputDataSource - Describes a blob input data source that contains reference data.
type BlobReferenceInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a blob input containing reference data. Required on PUT (CreateOrReplace) requests.
	Properties *BlobReferenceInputDataSourceProperties
}

// GetReferenceInputDataSource implements the ReferenceInputDataSourceClassification interface for type BlobReferenceInputDataSource.
func (b *BlobReferenceInputDataSource) GetReferenceInputDataSource() *ReferenceInputDataSource {
	return &ReferenceInputDataSource{
		Type: b.Type,
	}
}

// BlobReferenceInputDataSourceProperties - The properties that are associated with a blob input containing reference data.
type BlobReferenceInputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the blob input.
	BlobName *string

	// The name of a container within the associated Storage account. This container contains either the blob(s) to be read from
	// or written to. Required on PUT (CreateOrReplace) requests.
	Container *string

	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string

	// The path pattern of the delta snapshot.
	DeltaPathPattern *string

	// The interval that the user generates a delta snapshot of this reference blob input data source.
	DeltaSnapshotRefreshRate *string

	// The refresh interval of the blob input data source.
	FullSnapshotRefreshRate *string

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string

	// The partition count of the blob input data source. Range 1 - 256.
	SourcePartitionCount *int32

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string
}

// BlobStreamInputDataSource - Describes a blob input data source that contains stream data.
type BlobStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a blob input containing stream data. Required on PUT (CreateOrReplace) requests.
	Properties *BlobStreamInputDataSourceProperties
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type BlobStreamInputDataSource.
func (b *BlobStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: b.Type,
	}
}

// BlobStreamInputDataSourceProperties - The properties that are associated with a blob input containing stream data.
type BlobStreamInputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of a container within the associated Storage account. This container contains either the blob(s) to be read from
	// or written to. Required on PUT (CreateOrReplace) requests.
	Container *string

	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string

	// The partition count of the blob input data source. Range 1 - 1024.
	SourcePartitionCount *int32

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string
}

// CSVSerialization - Describes how data from an input is serialized or how data is serialized when written to an output in
// CSV format.
type CSVSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType

	// The properties that are associated with the CSV serialization type. Required on PUT (CreateOrReplace) requests.
	Properties *CSVSerializationProperties
}

// GetSerialization implements the SerializationClassification interface for type CSVSerialization.
func (c *CSVSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: c.Type,
	}
}

// CSVSerializationProperties - The properties that are associated with the CSV serialization type.
type CSVSerializationProperties struct {
	// Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output.
	// Required on PUT (CreateOrReplace) requests.
	Encoding *Encoding

	// Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input
	// or
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required
	// on PUT (CreateOrReplace) requests.
	FieldDelimiter *string
}

// CSharpFunctionBinding - The binding to a CSharp function.
type CSharpFunctionBinding struct {
	// REQUIRED; Indicates the function binding type.
	Type *string

	// The binding properties associated with a CSharp function.
	Properties *CSharpFunctionBindingProperties
}

// GetFunctionBinding implements the FunctionBindingClassification interface for type CSharpFunctionBinding.
func (c *CSharpFunctionBinding) GetFunctionBinding() *FunctionBinding {
	return &FunctionBinding{
		Type: c.Type,
	}
}

// CSharpFunctionBindingProperties - The binding properties associated with a CSharp function.
type CSharpFunctionBindingProperties struct {
	// The Csharp code containing a single function definition.
	Class *string

	// The Csharp code containing a single function definition.
	DllPath *string

	// The Csharp code containing a single function definition.
	Method *string

	// Refresh modes for Stream Analytics functions.
	UpdateMode *UpdateMode
}

// CSharpFunctionBindingRetrievalProperties - The binding retrieval properties associated with a CSharp function.
type CSharpFunctionBindingRetrievalProperties struct {
	// The CSharp code containing a single function definition.
	Script *string

	// The function type.
	UdfType *string
}

// CSharpFunctionRetrieveDefaultDefinitionParameters - The parameters needed to retrieve the default function definition for
// a CSharp function.
type CSharpFunctionRetrieveDefaultDefinitionParameters struct {
	// REQUIRED; Indicates the function binding type.
	BindingType *string

	// The binding retrieval properties associated with a CSharp function.
	BindingRetrievalProperties *CSharpFunctionBindingRetrievalProperties
}

// GetFunctionRetrieveDefaultDefinitionParameters implements the FunctionRetrieveDefaultDefinitionParametersClassification
// interface for type CSharpFunctionRetrieveDefaultDefinitionParameters.
func (c *CSharpFunctionRetrieveDefaultDefinitionParameters) GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters {
	return &FunctionRetrieveDefaultDefinitionParameters{
		BindingType: c.BindingType,
	}
}

// Cluster - A Stream Analytics Cluster object
type Cluster struct {
	// The geo-location where the resource lives
	Location *string

	// The properties associated with a Stream Analytics cluster.
	Properties *ClusterProperties

	// The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
	SKU *ClusterSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; The current entity tag for the cluster. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// ClusterInfo - The properties associated with a Stream Analytics cluster.
type ClusterInfo struct {
	// The resource id of cluster.
	ID *string
}

// ClusterJob - A streaming job.
type ClusterJob struct {
	// READ-ONLY; Resource ID of the streaming job.
	ID *string

	// READ-ONLY; The current execution state of the streaming job.
	JobState *JobState

	// READ-ONLY; The number of streaming units that are used by the streaming job.
	StreamingUnits *int32
}

// ClusterJobListResult - A list of streaming jobs. Populated by a List operation.
type ClusterJobListResult struct {
	// READ-ONLY; The URL to fetch the next set of streaming jobs.
	NextLink *string

	// READ-ONLY; A list of streaming jobs.
	Value []*ClusterJob
}

// ClusterListResult - A list of clusters populated by a 'list' operation.
type ClusterListResult struct {
	// READ-ONLY; The URL to fetch the next set of clusters.
	NextLink *string

	// READ-ONLY; A list of clusters.
	Value []*Cluster
}

// ClusterProperties - The properties associated with a Stream Analytics cluster.
type ClusterProperties struct {
	// READ-ONLY; Represents the number of streaming units currently being used on the cluster.
	CapacityAllocated *int32

	// READ-ONLY; Represents the sum of the SUs of all streaming jobs associated with the cluster. If all of the jobs were running,
	// this would be the capacity allocated.
	CapacityAssigned *int32

	// READ-ONLY; Unique identifier for the cluster.
	ClusterID *string

	// READ-ONLY; The date this cluster was created.
	CreatedDate *time.Time

	// READ-ONLY; The status of the cluster provisioning. The three terminal states are: Succeeded, Failed and Canceled
	ProvisioningState *ClusterProvisioningState
}

// ClusterSKU - The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate)
// requests.
type ClusterSKU struct {
	// Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with
	// a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate)
	// requests.
	Capacity *int32

	// Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
	Name *ClusterSKUName
}

// CompileQuery - The query compilation object which defines the input, output, and transformation for the query compilation.
type CompileQuery struct {
	// REQUIRED; Describes the type of the job. Valid values are Cloud and 'Edge'.
	JobType *JobType

	// REQUIRED; The query to compile.
	Query *string

	// The query to compile.
	CompatibilityLevel *CompatibilityLevel

	// The functions for the query compilation.
	Functions []*QueryFunction

	// The inputs for the query compilation.
	Inputs []*QueryInput
}

// Compression - Describes how input data is compressed
type Compression struct {
	// REQUIRED; Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests.
	Type *CompressionType
}

// CustomClrSerialization - Describes how data from an input is serialized or how data is serialized when written to an output
// in custom format.
type CustomClrSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType

	// The properties that are associated with the CustomClr serialization type. Required on PUT (CreateOrReplace) requests.
	Properties *CustomClrSerializationProperties
}

// GetSerialization implements the SerializationClassification interface for type CustomClrSerialization.
func (c *CustomClrSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: c.Type,
	}
}

// CustomClrSerializationProperties - The properties that are associated with the CustomClr serialization type.
type CustomClrSerializationProperties struct {
	// The serialization class name.
	SerializationClassName *string

	// The serialization library path.
	SerializationDllPath *string
}

// DeltaSerialization - Describes how data from an input is serialized or how data is serialized when written to an output
// in Delta Lake format.
type DeltaSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType

	// The properties that are associated with the Delta Lake serialization type. Required on PUT (CreateOrReplace) requests.
	Properties *DeltaSerializationProperties
}

// GetSerialization implements the SerializationClassification interface for type DeltaSerialization.
func (d *DeltaSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: d.Type,
	}
}

// DeltaSerializationProperties - The properties that are associated with the Delta Lake serialization type.
type DeltaSerializationProperties struct {
	// REQUIRED; Specifies the path of the Delta Lake table that the output will be written to.
	DeltaTablePath *string

	// Specifies the names of the columns for which the Delta Lake table will be partitioned. We are only supporting 1 partition
	// column, but keeping it as an array for extensibility.
	PartitionColumns []*string
}

// DiagnosticCondition - Condition applicable to the resource, or to the job overall, that warrant customer attention.
type DiagnosticCondition struct {
	// READ-ONLY; The opaque diagnostic code.
	Code *string

	// READ-ONLY; The human-readable message describing the condition in detail. Localized in the Accept-Language of the client
	// request.
	Message *string

	// READ-ONLY; The UTC timestamp of when the condition started. Customers should be able to find a corresponding event in the
	// ops log around this time.
	Since *string
}

// Diagnostics - Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
type Diagnostics struct {
	// READ-ONLY; A collection of zero or more conditions applicable to the resource, or to the job overall, that warrant customer
	// attention.
	Conditions []*DiagnosticCondition
}

// DocumentDbOutputDataSource - Describes a DocumentDB output data source.
type DocumentDbOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a DocumentDB output. Required on PUT (CreateOrReplace) requests.
	Properties *DocumentDbOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type DocumentDbOutputDataSource.
func (d *DocumentDbOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: d.Type,
	}
}

// DocumentDbOutputDataSourceProperties - The properties that are associated with a DocumentDB output.
type DocumentDbOutputDataSourceProperties struct {
	// The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
	AccountID *string

	// The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string

	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The collection name pattern for the collections to be used. The collection name format can be constructed using the optional
	// {partition} token, where partitions start from 0. See the DocumentDB
	// section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required
	// on PUT (CreateOrReplace) requests.
	CollectionNamePattern *string

	// The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
	Database *string

	// The name of the field in output events used to specify the primary key which insert or update operations are based on.
	DocumentID *string

	// The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern'
	// contains the {partition} token, this property is required to be
	// specified.
	PartitionKey *string
}

// Error - Common error representation.
type Error struct {
	// Error definition properties.
	Error *ErrorError
}

// ErrorDetails - Common error details representation.
type ErrorDetails struct {
	// Error code.
	Code *string

	// Error message.
	Message *string

	// Error target.
	Target *string
}

// ErrorError - Error definition properties.
type ErrorError struct {
	// Error code.
	Code *string

	// Error details.
	Details []*ErrorDetails

	// Error message.
	Message *string

	// Error target.
	Target *string
}

// ErrorResponse - Describes the error that occurred.
type ErrorResponse struct {
	// READ-ONLY; Error code associated with the error that occurred.
	Code *string

	// READ-ONLY; Describes the error in detail.
	Message *string
}

// EventGridStreamInputDataSource - Describes an event grid input data source that contains stream data.
type EventGridStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an event grid input containing stream data.
	Properties *EventGridStreamInputDataSourceProperties
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type EventGridStreamInputDataSource.
func (e *EventGridStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: e.Type,
	}
}

// EventGridStreamInputDataSourceProperties - The properties that are associated with an event grid input containing stream
// data.
type EventGridStreamInputDataSourceProperties struct {
	// List of Event Types that are supported by the Event Grid adapter.
	EventTypes []*string

	// Indicates the Event Grid schema type.
	Schema *EventGridEventSchemaType

	// A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
	StorageAccounts []*StorageAccount

	// Subscribers for the Event Grid. Currently only EventHub Subscriber is supported.
	Subscriber *EventHubV2StreamInputDataSource
}

// EventHubDataSourceProperties - The common properties that are associated with Event Hub data sources.
type EventHubDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string

	// The partition count of the event hub data source. Range 1 - 256.
	PartitionCount *int32

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string
}

// EventHubOutputDataSource - Describes an Event Hub output data source.
type EventHubOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Event Hub output. Required on PUT (CreateOrReplace) requests.
	Properties *EventHubOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type EventHubOutputDataSource.
func (e *EventHubOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: e.Type,
	}
}

// EventHubOutputDataSourceProperties - The properties that are associated with an Event Hub output.
type EventHubOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string

	// The partition count of the event hub data source. Range 1 - 256.
	PartitionCount *int32

	// The key/column that is used to determine to which partition to send event data.
	PartitionKey *string

	// The properties associated with this Event Hub output.
	PropertyColumns []*string

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string
}

// EventHubStreamInputDataSource - Describes an Event Hub input data source that contains stream data.
type EventHubStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Event Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	Properties *EventHubStreamInputDataSourceProperties
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type EventHubStreamInputDataSource.
func (e *EventHubStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: e.Type,
	}
}

// EventHubStreamInputDataSourceProperties - The properties that are associated with a Event Hub input containing stream data.
type EventHubStreamInputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer
	// group names for multiple inputs allows each of those inputs to receive the
	// same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
	ConsumerGroupName *string

	// The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
	EventHubName *string

	// The partition count of the event hub data source. Range 1 - 256.
	PartitionCount *int32

	// The number of messages that the message receiver can simultaneously request.
	PrefetchCount *int32

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string
}

// EventHubV2OutputDataSource - Describes an Event Hub output data source.
type EventHubV2OutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Event Hub output. Required on PUT (CreateOrReplace) requests.
	Properties *EventHubOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type EventHubV2OutputDataSource.
func (e *EventHubV2OutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: e.Type,
	}
}

// EventHubV2StreamInputDataSource - Describes an Event Hub input data source that contains stream data.
type EventHubV2StreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an Event Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	Properties *EventHubStreamInputDataSourceProperties
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type EventHubV2StreamInputDataSource.
func (e *EventHubV2StreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: e.Type,
	}
}

// External - The storage account where the custom code artifacts are located.
type External struct {
	// The UserCustomCode container.
	Container *string

	// The UserCustomCode path.
	Path *string

	// The refresh parameters for any/all updatable user defined functions present in the job config.
	RefreshConfiguration *RefreshConfiguration

	// The properties that are associated with an Azure Storage account
	StorageAccount *StorageAccount
}

// FileReferenceInputDataSource - Describes a file input data source that contains reference data.
type FileReferenceInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a file input containing reference data. Required on PUT (CreateOrReplace) requests.
	Properties *FileReferenceInputDataSourceProperties
}

// GetReferenceInputDataSource implements the ReferenceInputDataSourceClassification interface for type FileReferenceInputDataSource.
func (f *FileReferenceInputDataSource) GetReferenceInputDataSource() *ReferenceInputDataSource {
	return &ReferenceInputDataSource{
		Type: f.Type,
	}
}

// FileReferenceInputDataSourceProperties - The properties that are associated with a file input containing reference data.
type FileReferenceInputDataSourceProperties struct {
	// The path of the file.
	Path *string
}

// Function - A function object, containing all information associated with the named function. All functions are contained
// under a streaming job.
type Function struct {
	// Resource name
	Name *string

	// The properties that are associated with a function.
	Properties FunctionPropertiesClassification

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource type
	Type *string
}

// FunctionBinding - The physical binding of the function. For example, in the Azure Machine Learning web service’s case,
// this describes the endpoint.
type FunctionBinding struct {
	// REQUIRED; Indicates the function binding type.
	Type *string
}

// GetFunctionBinding implements the FunctionBindingClassification interface for type FunctionBinding.
func (f *FunctionBinding) GetFunctionBinding() *FunctionBinding { return f }

type FunctionConfiguration struct {
	// The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the
	// endpoint.
	Binding FunctionBindingClassification
	Inputs  []*FunctionInput

	// Describes the output of a function.
	Output *FunctionOutput
}

// FunctionInput - Describes one input parameter of a function.
type FunctionInput struct {
	// The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics
	// data types are described at
	// https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
	DataType *string

	// A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant.
	// Default is false.
	IsConfigurationParameter *bool
}

// FunctionListResult - Object containing a list of functions under a streaming job.
type FunctionListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; A list of functions under a streaming job. Populated by a 'List' operation.
	Value []*Function
}

// FunctionOutput - Describes the output of a function.
type FunctionOutput struct {
	// The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types
	// are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
	DataType *string
}

// FunctionProperties - The properties that are associated with a function.
type FunctionProperties struct {
	// REQUIRED; Indicates the type of function.
	Type       *string
	Properties *FunctionConfiguration

	// READ-ONLY; The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string
}

// GetFunctionProperties implements the FunctionPropertiesClassification interface for type FunctionProperties.
func (f *FunctionProperties) GetFunctionProperties() *FunctionProperties { return f }

// FunctionRetrieveDefaultDefinitionParameters - Parameters used to specify the type of function to retrieve the default definition
// for.
type FunctionRetrieveDefaultDefinitionParameters struct {
	// REQUIRED; Indicates the function binding type.
	BindingType *string
}

// GetFunctionRetrieveDefaultDefinitionParameters implements the FunctionRetrieveDefaultDefinitionParametersClassification
// interface for type FunctionRetrieveDefaultDefinitionParameters.
func (f *FunctionRetrieveDefaultDefinitionParameters) GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters {
	return f
}

// GatewayMessageBusOutputDataSource - Describes a Gateway Message Bus output data source.
type GatewayMessageBusOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a Gateway Message Bus output. Required on PUT (CreateOrReplace) requests.
	Properties *GatewayMessageBusOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type GatewayMessageBusOutputDataSource.
func (g *GatewayMessageBusOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: g.Type,
	}
}

// GatewayMessageBusOutputDataSourceProperties - The properties that are associated with a Gateway Message Bus.
type GatewayMessageBusOutputDataSourceProperties struct {
	// The name of the Service Bus topic.
	Topic *string
}

// GatewayMessageBusSourceProperties - The properties that are associated with a gateway message bus datasource.
type GatewayMessageBusSourceProperties struct {
	// The name of the Service Bus topic.
	Topic *string
}

// GatewayMessageBusStreamInputDataSource - Describes a blob input data source that contains stream data.
type GatewayMessageBusStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a gateway message bus input containing stream data.
	Properties *GatewayMessageBusStreamInputDataSourceProperties
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type GatewayMessageBusStreamInputDataSource.
func (g *GatewayMessageBusStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: g.Type,
	}
}

// GatewayMessageBusStreamInputDataSourceProperties - The properties that are associated with a gateway message bus input
// containing stream data.
type GatewayMessageBusStreamInputDataSourceProperties struct {
	// The name of the Service Bus topic.
	Topic *string
}

// GetStreamingJobSKUResult - Describes an available SKU information.
type GetStreamingJobSKUResult struct {
	// READ-ONLY; Describes scaling information of a SKU.
	Capacity *SKUCapacity

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *ResourceType

	// READ-ONLY; The properties that are associated with a SKU.
	SKU *GetStreamingJobSKUResultSKU
}

// GetStreamingJobSKUResultSKU - The properties that are associated with a SKU.
type GetStreamingJobSKUResultSKU struct {
	// The name of the SKU.
	Name *SKUName
}

// GetStreamingJobSKUResults - Result of the request to get streaming job SKUs.
type GetStreamingJobSKUResults struct {
	// The list of available SKUs that the streaming job can use.
	Value []*GetStreamingJobSKUResult

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// Identity - Describes how identity is verified
type Identity struct {
	// The type of identity, can be SystemAssigned or UserAssigned.
	Type *string

	// The user assigned identities associated with the streaming job resource.
	UserAssignedIdentities map[string]any

	// READ-ONLY; The principalId of the identity.
	PrincipalID *string

	// READ-ONLY; The tenantId of the identity.
	TenantID *string
}

// Input - An input object, containing all information associated with the named input. All inputs are contained under a streaming
// job.
type Input struct {
	// Resource name
	Name *string

	// The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
	Properties InputPropertiesClassification

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource type
	Type *string
}

// InputListResult - Object containing a list of inputs under a streaming job.
type InputListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; A list of inputs under a streaming job. Populated by a 'List' operation.
	Value []*Input
}

// InputProperties - The properties that are associated with an input.
type InputProperties struct {
	// REQUIRED; Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// Describes how input data is compressed
	Compression *Compression

	// partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string

	// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace)
	// requests.
	Serialization SerializationClassification

	// Settings which determine whether to read watermark events.
	WatermarkSettings *InputWatermarkProperties

	// READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics

	// READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match headers
	// for write operations for optimistic concurrency.
	Etag *string
}

// GetInputProperties implements the InputPropertiesClassification interface for type InputProperties.
func (i *InputProperties) GetInputProperties() *InputProperties { return i }

// InputWatermarkProperties - Settings which determine whether to read watermark events.
type InputWatermarkProperties struct {
	// The input watermark mode.
	WatermarkMode *InputWatermarkMode
}

// IoTHubStreamInputDataSource - Describes an IoT Hub input data source that contains stream data.
type IoTHubStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with an IoT Hub input containing stream data. Required on PUT (CreateOrReplace) requests.
	Properties *IoTHubStreamInputDataSourceProperties
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type IoTHubStreamInputDataSource.
func (i *IoTHubStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: i.Type,
	}
}

// IoTHubStreamInputDataSourceProperties - The properties that are associated with a IoT Hub input containing stream data.
type IoTHubStreamInputDataSourceProperties struct {
	// The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input
	// uses the Iot Hub’s default consumer group.
	ConsumerGroupName *string

	// The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
	Endpoint *string

	// The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
	IotHubNamespace *string

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string

	// The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required
	// on PUT (CreateOrReplace) requests.
	SharedAccessPolicyName *string
}

// JSONSerialization - Describes how data from an input is serialized or how data is serialized when written to an output
// in JSON format.
type JSONSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType

	// The properties that are associated with the JSON serialization type. Required on PUT (CreateOrReplace) requests.
	Properties *JSONSerializationProperties
}

// GetSerialization implements the SerializationClassification interface for type JSONSerialization.
func (j *JSONSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: j.Type,
	}
}

// JSONSerializationProperties - The properties that are associated with the JSON serialization type.
type JSONSerializationProperties struct {
	// Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output.
	// Required on PUT (CreateOrReplace) requests.
	Encoding *Encoding

	// This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies
	// the format of the JSON the output will be written in. The currently supported
	// values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and
	// 'array' indicating the output will be formatted as an array of JSON objects.
	// Default value is 'lineSeparated' if left null.
	Format *JSONOutputSerializationFormat
}

// JavaScriptFunctionBinding - The binding to a JavaScript function.
type JavaScriptFunctionBinding struct {
	// REQUIRED; Indicates the function binding type.
	Type *string

	// The binding properties associated with a JavaScript function.
	Properties *JavaScriptFunctionBindingProperties
}

// GetFunctionBinding implements the FunctionBindingClassification interface for type JavaScriptFunctionBinding.
func (j *JavaScriptFunctionBinding) GetFunctionBinding() *FunctionBinding {
	return &FunctionBinding{
		Type: j.Type,
	}
}

// JavaScriptFunctionBindingProperties - The binding properties associated with a JavaScript function.
type JavaScriptFunctionBindingProperties struct {
	// The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
	Script *string
}

// JavaScriptFunctionBindingRetrievalProperties - The binding retrieval properties associated with a JavaScript function.
type JavaScriptFunctionBindingRetrievalProperties struct {
	// The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'.
	Script *string

	// The function type.
	UdfType *string
}

// JavaScriptFunctionRetrieveDefaultDefinitionParameters - The parameters needed to retrieve the default function definition
// for a JavaScript function.
type JavaScriptFunctionRetrieveDefaultDefinitionParameters struct {
	// REQUIRED; Indicates the function binding type.
	BindingType *string

	// The binding retrieval properties associated with a JavaScript function.
	BindingRetrievalProperties *JavaScriptFunctionBindingRetrievalProperties
}

// GetFunctionRetrieveDefaultDefinitionParameters implements the FunctionRetrieveDefaultDefinitionParametersClassification
// interface for type JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (j *JavaScriptFunctionRetrieveDefaultDefinitionParameters) GetFunctionRetrieveDefaultDefinitionParameters() *FunctionRetrieveDefaultDefinitionParameters {
	return &FunctionRetrieveDefaultDefinitionParameters{
		BindingType: j.BindingType,
	}
}

// JobStorageAccount - The properties that are associated with an Azure Storage account with MSI
type JobStorageAccount struct {
	// The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string

	// The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string

	// Authentication Mode.
	AuthenticationMode *AuthenticationMode
}

// LastOutputEventTimestamp - An output event timestamp.
type LastOutputEventTimestamp struct {
	// The last output event time.
	LastOutputEventTime *string

	// The time that the last update happened.
	LastUpdateTime *string
}

// OAuthBasedDataSourceProperties - The properties that are associated with data sources that use OAuth as their authentication
// model.
type OAuthBasedDataSourceProperties struct {
	// A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source.
	// A valid refresh token is currently only obtainable via the Azure Portal. It
	// is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate
	// the data source which will update this property with a valid refresh
	// token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string

	// The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user
	// was used to obtain the refresh token.
	TokenUserDisplayName *string

	// The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember
	// which user was used to obtain the refresh token.
	TokenUserPrincipalName *string
}

// Operation - A Stream Analytics REST API operation
type Operation struct {
	// Indicates whether the operation is a data action
	IsDataAction *bool

	// READ-ONLY; Contains the localized display information for this particular operation / action.
	Display *OperationDisplay

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string
}

// OperationDisplay - Contains the localized display information for this particular operation / action.
type OperationDisplay struct {
	// READ-ONLY; The localized friendly description for the operation.
	Description *string

	// READ-ONLY; The localized friendly name for the operation.
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string

	// READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string
}

// OperationListResult - Result of the request to list Stream Analytics operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; List of Stream Analytics operations supported by the Microsoft.StreamAnalytics resource provider.
	Value []*Operation
}

// Output - An output object, containing all information associated with the named output. All outputs are contained under
// a streaming job.
type Output struct {
	// Resource name
	Name *string

	// The properties that are associated with an output. Required on PUT (CreateOrReplace) requests.
	Properties *OutputProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource type
	Type *string
}

// OutputDataSource - Describes the data source that output will be written to.
type OutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type OutputDataSource.
func (o *OutputDataSource) GetOutputDataSource() *OutputDataSource { return o }

// OutputListResult - Object containing a list of outputs under a streaming job.
type OutputListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; A list of outputs under a streaming job. Populated by a 'List' operation.
	Value []*Output
}

// OutputProperties - The properties that are associated with an output.
type OutputProperties struct {
	// Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
	Datasource OutputDataSourceClassification

	// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace)
	// requests.
	Serialization SerializationClassification

	// The size window to constrain a Stream Analytics output to.
	SizeWindow *int32

	// The time frame for filtering Stream Analytics job outputs.
	TimeWindow *string

	// Settings which determine whether to send watermarks to downstream.
	WatermarkSettings *OutputWatermarkProperties

	// READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics

	// READ-ONLY; The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string

	// READ-ONLY; A list of the last output event times for each output partition. The index of the array corresponds to the partition
	// number.
	LastOutputEventTimestamps []*LastOutputEventTimestamp
}

// OutputWatermarkProperties - Settings which determine whether to send watermarks to downstream.
type OutputWatermarkProperties struct {
	// Describes the maximal delta between the fastest and slowest partitions, so the out of order window that catches all necessary
	// events in downstream jobs is well defined.
	MaxWatermarkDifferenceAcrossPartitions *string

	// The output watermark mode.
	WatermarkMode *OutputWatermarkMode
}

// ParquetSerialization - Describes how data from an input is serialized or how data is serialized when written to an output
// in Parquet format.
type ParquetSerialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType

	// The properties that are associated with the Parquet serialization type. Required on PUT (CreateOrReplace) requests.
	Properties any
}

// GetSerialization implements the SerializationClassification interface for type ParquetSerialization.
func (p *ParquetSerialization) GetSerialization() *Serialization {
	return &Serialization{
		Type: p.Type,
	}
}

// PostgreSQLDataSourceProperties - The properties that are associated with an Azure SQL database data source.
type PostgreSQLDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string

	// Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
	MaxWriterCount *float32

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string
}

// PostgreSQLOutputDataSource - Describes a PostgreSQL output data source.
type PostgreSQLOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a PostgreSQL output data source. Required on PUT (CreateOrReplace) requests.
	Properties *PostgreSQLOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type PostgreSQLOutputDataSource.
func (p *PostgreSQLOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: p.Type,
	}
}

// PostgreSQLOutputDataSourceProperties - The properties that are associated with a PostgreSQL output.
type PostgreSQLOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Database *string

	// Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
	MaxWriterCount *float32

	// The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Password *string

	// The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Server *string

	// The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	Table *string

	// The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
	User *string
}

// PowerBIOutputDataSource - Describes a Power BI output data source.
type PowerBIOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a Power BI output. Required on PUT (CreateOrReplace) requests.
	Properties *PowerBIOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type PowerBIOutputDataSource.
func (p *PowerBIOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: p.Type,
	}
}

// PowerBIOutputDataSourceProperties - The properties that are associated with a Power BI output.
type PowerBIOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
	Dataset *string

	// The ID of the Power BI group.
	GroupID *string

	// The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
	GroupName *string

	// A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source.
	// A valid refresh token is currently only obtainable via the Azure Portal. It
	// is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate
	// the data source which will update this property with a valid refresh
	// token. Required on PUT (CreateOrReplace) requests.
	RefreshToken *string

	// The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
	Table *string

	// The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user
	// was used to obtain the refresh token.
	TokenUserDisplayName *string

	// The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember
	// which user was used to obtain the refresh token.
	TokenUserPrincipalName *string
}

// PrivateEndpoint - Complete information about the private endpoint.
type PrivateEndpoint struct {
	// The properties associated with a private endpoint.
	Properties *PrivateEndpointProperties

	// READ-ONLY; Unique opaque string (generally a GUID) that represents the metadata state of the resource (private endpoint)
	// and changes whenever the resource is updated. Required on PUT (CreateOrUpdate) requests.
	Etag *string

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// PrivateEndpointListResult - A list of private endpoints.
type PrivateEndpointListResult struct {
	// READ-ONLY; The URL to fetch the next set of private endpoints.
	NextLink *string

	// READ-ONLY; A list of private endpoints.
	Value []*PrivateEndpoint
}

// PrivateEndpointProperties - The properties associated with a private endpoint.
type PrivateEndpointProperties struct {
	// A list of connections to the remote resource. Immutable after it is set.
	ManualPrivateLinkServiceConnections []*PrivateLinkServiceConnection

	// READ-ONLY; The date when this private endpoint was created.
	CreatedDate *string
}

// PrivateLinkConnectionState - A collection of read-only information about the state of the connection to the private remote
// resource.
type PrivateLinkConnectionState struct {
	// READ-ONLY; A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// READ-ONLY; The reason for approval/rejection of the connection.
	Description *string

	// READ-ONLY; Indicates whether the connection has been Approved/Rejected/Removed by the owner of the remote resource/service.
	Status *string
}

// PrivateLinkServiceConnection - A grouping of information about the connection to the remote resource.
type PrivateLinkServiceConnection struct {
	// Bag of properties defining a privatelinkServiceConnection.
	Properties *PrivateLinkServiceConnectionProperties
}

// PrivateLinkServiceConnectionProperties - Bag of properties defining a privatelinkServiceConnection.
type PrivateLinkServiceConnectionProperties struct {
	// The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT
	// (CreateOrUpdate) requests.
	GroupIDs []*string

	// A collection of read-only information about the state of the connection to the private remote resource.
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState

	// The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
	PrivateLinkServiceID *string

	// READ-ONLY; A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
	RequestMessage *string
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// QueryCompilationError - An error produced by the compiler.
type QueryCompilationError struct {
	// READ-ONLY; Describes the error location in the original query. Not set if isGlobal is true.
	EndColumn *int32

	// READ-ONLY; Describes the error location in the original query. Not set if isGlobal is true.
	EndLine *int32

	// READ-ONLY; Whether the error is not for a specific part but for the entire query.
	IsGlobal *bool

	// READ-ONLY; The content of the error message.
	Message *string

	// READ-ONLY; Describes the error location in the original query. Not set if isGlobal is true.
	StartColumn *int32

	// READ-ONLY; Describes the error location in the original query. Not set if isGlobal is true.
	StartLine *int32
}

// QueryCompilationResult - The result of the query compilation request.
type QueryCompilationResult struct {
	// READ-ONLY; Error messages produced by the compiler.
	Errors []*QueryCompilationError

	// READ-ONLY; All function names used by the query.
	Functions []*string

	// READ-ONLY; All input names used by the query.
	Inputs []*string

	// READ-ONLY; All output names used by the query.
	Outputs []*string

	// READ-ONLY; Warning messages produced by the compiler.
	Warnings []*string
}

// QueryFunction - A function for the query compilation.
type QueryFunction struct {
	// REQUIRED; The type of the function binding.
	BindingType *string

	// REQUIRED; The inputs for the function.
	Inputs []*FunctionInput

	// REQUIRED; The name of the function.
	Name *string

	// REQUIRED; An output for the function.
	Output *FunctionOutput

	// REQUIRED; The type of the function.
	Type *string
}

// QueryInput - An input for the query compilation.
type QueryInput struct {
	// REQUIRED; The name of the input.
	Name *string

	// REQUIRED; The type of the input, can be Stream or Reference.
	Type *string
}

// QueryTestingResult - The result of the query testing request.
type QueryTestingResult struct {
	// Error definition properties.
	Error *ErrorError

	// READ-ONLY; The SAS URL to the outputs payload.
	OutputURI *string

	// READ-ONLY; The status of the query testing request.
	Status *QueryTestingResultStatus
}

// RawInputDatasourceProperties - The properties that are associated with a raw input.
type RawInputDatasourceProperties struct {
	// The JSON serialized content of the input data. Either payload or payloadUri must be set, but not both.
	Payload *string

	// The SAS URL to a blob containing the JSON serialized content of the input data. Either payload or payloadUri must be set,
	// but not both.
	PayloadURI *string
}

// RawOutputDatasource - Describes a raw output data source. This data source type is only applicable/usable when using the
// query testing API. You cannot create a job with this data source type or add an output of this data
// source type to an existing job.
type RawOutputDatasource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a raw output. Required on PUT (CreateOrReplace) requests.
	Properties *RawOutputDatasourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type RawOutputDatasource.
func (r *RawOutputDatasource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: r.Type,
	}
}

// RawOutputDatasourceProperties - The properties that are associated with a raw output.
type RawOutputDatasourceProperties struct {
	// The SAS URL to a blob where the output should be written. If this property is not set, output data will be written into
	// a temporary storage, and a SAS URL to that temporary storage will be included in
	// the result.
	PayloadURI *string
}

// RawReferenceInputDataSource - Describes a raw input data source that contains reference data. This data source type is
// only applicable/usable when using the query testing API. You cannot create a job with this data source type or
// add an input of this data source type to an existing job.
type RawReferenceInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a raw input containing reference data. Required on PUT (CreateOrReplace) requests.
	Properties *RawInputDatasourceProperties
}

// GetReferenceInputDataSource implements the ReferenceInputDataSourceClassification interface for type RawReferenceInputDataSource.
func (r *RawReferenceInputDataSource) GetReferenceInputDataSource() *ReferenceInputDataSource {
	return &ReferenceInputDataSource{
		Type: r.Type,
	}
}

// RawStreamInputDataSource - Describes a raw input data source that contains stream data. This data source type is only applicable/usable
// when using the query testing API. You cannot create a job with this data source type or add
// an input of this data source type to an existing job.
type RawStreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a raw input. Required on PUT (CreateOrReplace) requests.
	Properties *RawInputDatasourceProperties
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type RawStreamInputDataSource.
func (r *RawStreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource {
	return &StreamInputDataSource{
		Type: r.Type,
	}
}

// ReferenceInputDataSource - Describes an input data source that contains reference data.
type ReferenceInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
	Type *string
}

// GetReferenceInputDataSource implements the ReferenceInputDataSourceClassification interface for type ReferenceInputDataSource.
func (r *ReferenceInputDataSource) GetReferenceInputDataSource() *ReferenceInputDataSource { return r }

// ReferenceInputProperties - The properties that are associated with an input containing reference data.
type ReferenceInputProperties struct {
	// REQUIRED; Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// Describes how input data is compressed
	Compression *Compression

	// Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
	Datasource ReferenceInputDataSourceClassification

	// partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string

	// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace)
	// requests.
	Serialization SerializationClassification

	// Settings which determine whether to read watermark events.
	WatermarkSettings *InputWatermarkProperties

	// READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics

	// READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match headers
	// for write operations for optimistic concurrency.
	Etag *string
}

// GetInputProperties implements the InputPropertiesClassification interface for type ReferenceInputProperties.
func (r *ReferenceInputProperties) GetInputProperties() *InputProperties {
	return &InputProperties{
		Compression:       r.Compression,
		Diagnostics:       r.Diagnostics,
		Etag:              r.Etag,
		PartitionKey:      r.PartitionKey,
		Serialization:     r.Serialization,
		Type:              r.Type,
		WatermarkSettings: r.WatermarkSettings,
	}
}

// RefreshConfiguration - The refresh parameters for any/all updatable user defined functions present in the job config.
type RefreshConfiguration struct {
	// The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
	DateFormat *string

	// The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine
	// whether or not they should be included as input or output to the job. See
	// https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output
	// for a more detailed explanation
	// and example.
	PathPattern *string

	// The refresh interval.
	RefreshInterval *string

	// This property indicates which data refresh option to use, Blocking or Nonblocking.
	RefreshType *UpdatableUdfRefreshType

	// The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
	TimeFormat *string
}

// Resource - The base resource definition
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// ResourceTestStatus - Describes the status of the test operation along with error information, if applicable.
type ResourceTestStatus struct {
	// READ-ONLY; Describes the error that occurred.
	Error *ErrorResponse

	// READ-ONLY; The status of the test operation.
	Status *string
}

// SKU - The properties that are associated with a SKU.
type SKU struct {
	// The capacity of the SKU.
	Capacity *int32

	// The name of the SKU. Required on PUT (CreateOrReplace) requests.
	Name *SKUName
}

// SKUCapacity - Describes scaling information of a SKU.
type SKUCapacity struct {
	// READ-ONLY; Specifies the valid streaming units a streaming job can scale to.
	AllowedValues []*int32

	// READ-ONLY; Specifies the default streaming units that the streaming job can use.
	Default *int32

	// READ-ONLY; Specifies the maximum streaming units that the streaming job can use.
	Maximum *int32

	// READ-ONLY; Specifies the minimum streaming units that the streaming job can use.
	Minimum *int32

	// READ-ONLY; The scale type applicable to the SKU.
	ScaleType *SKUCapacityScaleType
}

// SampleInput - The stream analytics input to sample.
type SampleInput struct {
	// Defaults to the default ASA job compatibility level. Today it is 1.2
	CompatibilityLevel *string

	// Defaults to en-US.
	DataLocale *string

	// The SAS URI of the storage blob for service to write the sampled events to. If this parameter is not provided, service
	// will write events to he system account and share a temporary SAS URI to it.
	EventsURI *string

	// The stream analytics input to sample.
	Input *Input
}

// SampleInputResult - The result of the sample input request.
type SampleInputResult struct {
	// Error definition properties.
	Error *ErrorError

	// READ-ONLY; Diagnostics messages. E.g. message indicating some partitions from the input have no data.
	Diagnostics []*string

	// READ-ONLY; A SAS URL to download the sampled input data.
	EventsDownloadURL *string

	// READ-ONLY; The timestamp for the last event in the data. It is in DateTime format.
	LastArrivalTime *string

	// READ-ONLY; The status of the sample input request.
	Status *SampleInputResultStatus
}

// ScalarFunctionProperties - The properties that are associated with a scalar function.
type ScalarFunctionProperties struct {
	// REQUIRED; Indicates the type of function.
	Type       *string
	Properties *FunctionConfiguration

	// READ-ONLY; The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string
}

// GetFunctionProperties implements the FunctionPropertiesClassification interface for type ScalarFunctionProperties.
func (s *ScalarFunctionProperties) GetFunctionProperties() *FunctionProperties {
	return &FunctionProperties{
		Etag:       s.Etag,
		Properties: s.Properties,
		Type:       s.Type,
	}
}

// ScaleStreamingJobParameters - Parameters supplied to the Scale Streaming Job operation.
type ScaleStreamingJobParameters struct {
	// Specifies the number of streaming units that the streaming job will scale to.
	StreamingUnits *int32
}

// Serialization - Describes how data from an input is serialized or how data is serialized when written to an output.
type Serialization struct {
	// REQUIRED; Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
	Type *EventSerializationType
}

// GetSerialization implements the SerializationClassification interface for type Serialization.
func (s *Serialization) GetSerialization() *Serialization { return s }

// ServiceBusDataSourceProperties - The common properties that are associated with Service Bus data sources (Queues, Topics,
// Event Hubs, etc.).
type ServiceBusDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string
}

// ServiceBusQueueOutputDataSource - Describes a Service Bus Queue output data source.
type ServiceBusQueueOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a Service Bus Queue output. Required on PUT (CreateOrReplace) requests.
	Properties *ServiceBusQueueOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type ServiceBusQueueOutputDataSource.
func (s *ServiceBusQueueOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: s.Type,
	}
}

// ServiceBusQueueOutputDataSourceProperties - The properties that are associated with a Service Bus Queue output.
type ServiceBusQueueOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// A string array of the names of output columns to be attached to Service Bus messages as custom properties.
	PropertyColumns []*string

	// The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
	QueueName *string

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string

	// The system properties associated with the Service Bus Queue. The following system properties are supported: ReplyToSessionId,
	// ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey,
	// SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
	SystemPropertyColumns any
}

// ServiceBusTopicOutputDataSource - Describes a Service Bus Topic output data source.
type ServiceBusTopicOutputDataSource struct {
	// REQUIRED; Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
	Type *string

	// The properties that are associated with a Service Bus Topic output. Required on PUT (CreateOrReplace) requests.
	Properties *ServiceBusTopicOutputDataSourceProperties
}

// GetOutputDataSource implements the OutputDataSourceClassification interface for type ServiceBusTopicOutputDataSource.
func (s *ServiceBusTopicOutputDataSource) GetOutputDataSource() *OutputDataSource {
	return &OutputDataSource{
		Type: s.Type,
	}
}

// ServiceBusTopicOutputDataSourceProperties - The properties that are associated with a Service Bus Topic output.
type ServiceBusTopicOutputDataSourceProperties struct {
	// Authentication Mode.
	AuthenticationMode *AuthenticationMode

	// A string array of the names of output columns to be attached to Service Bus messages as custom properties.
	PropertyColumns []*string

	// The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
	// (CreateOrReplace) requests.
	ServiceBusNamespace *string

	// The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
	SharedAccessPolicyKey *string

	// The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace)
	// requests.
	SharedAccessPolicyName *string

	// The system properties associated with the Service Bus Topic Output. The following system properties are supported: ReplyToSessionId,
	// ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey,
	// SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
	SystemPropertyColumns map[string]*string

	// The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
	TopicName *string
}

// StartStreamingJobParameters - Parameters supplied to the Start Streaming Job operation.
type StartStreamingJobParameters struct {
	// Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event
	// stream should start whenever the job is started, start at a custom user time
	// stamp specified via the outputStartTime property, or start from the last event output time.
	OutputStartMode *OutputStartMode

	// Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null
	// to indicate that the output event stream will start whenever the streaming job is
	// started. This property must have a value if outputStartMode is set to CustomTime.
	OutputStartTime *time.Time
}

// StorageAccount - The properties that are associated with an Azure Storage account
type StorageAccount struct {
	// The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountKey *string

	// The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
	AccountName *string

	// Authentication Mode.
	AuthenticationMode *AuthenticationMode
}

// StreamInputDataSource - Describes an input data source that contains stream data.
type StreamInputDataSource struct {
	// REQUIRED; Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
	Type *string
}

// GetStreamInputDataSource implements the StreamInputDataSourceClassification interface for type StreamInputDataSource.
func (s *StreamInputDataSource) GetStreamInputDataSource() *StreamInputDataSource { return s }

// StreamInputProperties - The properties that are associated with an input containing stream data.
type StreamInputProperties struct {
	// REQUIRED; Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
	Type *string

	// Describes how input data is compressed
	Compression *Compression

	// Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
	Datasource StreamInputDataSourceClassification

	// partitionKey Describes a key in the input data which is used for partitioning the input data
	PartitionKey *string

	// Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace)
	// requests.
	Serialization SerializationClassification

	// Settings which determine whether to read watermark events.
	WatermarkSettings *InputWatermarkProperties

	// READ-ONLY; Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
	Diagnostics *Diagnostics

	// READ-ONLY; The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource
	// has changed between requests. You can also use it in the If-Match or If-None-Match headers
	// for write operations for optimistic concurrency.
	Etag *string
}

// GetInputProperties implements the InputPropertiesClassification interface for type StreamInputProperties.
func (s *StreamInputProperties) GetInputProperties() *InputProperties {
	return &InputProperties{
		Compression:       s.Compression,
		Diagnostics:       s.Diagnostics,
		Etag:              s.Etag,
		PartitionKey:      s.PartitionKey,
		Serialization:     s.Serialization,
		Type:              s.Type,
		WatermarkSettings: s.WatermarkSettings,
	}
}

// StreamingJob - A streaming job object, containing all information associated with the named streaming job.
type StreamingJob struct {
	// Describes the managed identity assigned to this job that can be used to authenticate with inputs and outputs.
	Identity *Identity

	// The geo-location where the resource lives
	Location *string

	// The properties that are associated with a streaming job. Required on PUT (CreateOrReplace) requests.
	Properties *StreamingJobProperties

	// Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// StreamingJobListResult - Object containing a list of streaming jobs.
type StreamingJobListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; A list of streaming jobs. Populated by a 'List' operation.
	Value []*StreamingJob
}

// StreamingJobProperties - The properties that are associated with a streaming job.
type StreamingJobProperties struct {
	// The cluster which streaming jobs will run on.
	Cluster *ClusterInfo

	// Controls certain runtime behaviors of the streaming job.
	CompatibilityLevel *CompatibilityLevel

	// Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify
	// jobStorageAccount property. .
	ContentStoragePolicy *ContentStoragePolicy

	// The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set
	// https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none
	// specified.
	DataLocale *string

	// The maximum tolerable delay in seconds where events arriving late could be included. Supported range is -1 to 1814399 (20.23:59:59
	// days) and -1 is used to specify wait indefinitely. If the property is
	// absent, it is interpreted to have a value of -1.
	EventsLateArrivalMaxDelayInSeconds *int32

	// The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
	EventsOutOfOrderMaxDelayInSeconds *int32

	// Indicates the policy to apply to events that arrive out of order in the input event stream.
	EventsOutOfOrderPolicy *EventsOutOfOrderPolicy

	// The storage account where the custom code artifacts are located.
	Externals *External

	// A list of one or more functions for the streaming job. The name property for each function is required when specifying
	// this property in a PUT request. This property cannot be modify via a PATCH
	// operation. You must use the PATCH API available for the individual transformation.
	Functions []*Function

	// A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property
	// in a PUT request. This property cannot be modify via a PATCH operation.
	// You must use the PATCH API available for the individual input.
	Inputs []*Input

	// The properties that are associated with an Azure Storage account with MSI
	JobStorageAccount *JobStorageAccount

	// Describes the type of the job. Valid modes are Cloud and 'Edge'.
	JobType *JobType

	// Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to
	// being malformed (missing column values, column values of wrong type or size).
	OutputErrorPolicy *OutputErrorPolicy

	// This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be
	// JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the
	// starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified
	// via the outputStartTime property, or start from the last event output
	// time.
	OutputStartMode *OutputStartMode

	// Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null
	// to indicate that the output event stream will start whenever the streaming job is
	// started. This property must have a value if outputStartMode is set to CustomTime.
	OutputStartTime *time.Time

	// A list of one or more outputs for the streaming job. The name property for each output is required when specifying this
	// property in a PUT request. This property cannot be modify via a PATCH operation.
	// You must use the PATCH API available for the individual output.
	Outputs []*Output

	// Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
	SKU *SKU

	// Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation
	// is required when specifying this property in a PUT request. This property
	// cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
	Transformation *Transformation

	// READ-ONLY; Value is an ISO-8601 formatted UTC timestamp indicating when the streaming job was created.
	CreatedDate *time.Time

	// READ-ONLY; The current entity tag for the streaming job. This is an opaque string. You can use it to detect whether the
	// resource has changed between requests. You can also use it in the If-Match or If-None-Match
	// headers for write operations for optimistic concurrency.
	Etag *string

	// READ-ONLY; A GUID uniquely identifying the streaming job. This GUID is generated upon creation of the streaming job.
	JobID *string

	// READ-ONLY; Describes the state of the streaming job.
	JobState *string

	// READ-ONLY; Value is either an ISO-8601 formatted timestamp indicating the last output event time of the streaming job or
	// null indicating that output has not yet been produced. In case of multiple outputs or
	// multiple streams, this shows the latest value in that set.
	LastOutputEventTime *time.Time

	// READ-ONLY; Describes the provisioning status of the streaming job.
	ProvisioningState *string
}

// SubResource - The base sub-resource model definition.
type SubResource struct {
	// Resource name
	Name *string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource type
	Type *string
}

// SubscriptionQuota - Describes the current quota for the subscription.
type SubscriptionQuota struct {
	// Resource name
	Name *string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Describes the properties of the quota.
	Properties *SubscriptionQuotaProperties

	// READ-ONLY; Resource type
	Type *string
}

// SubscriptionQuotaProperties - Describes the properties of the quota.
type SubscriptionQuotaProperties struct {
	// READ-ONLY; The current usage of this resource.
	CurrentCount *int32

	// READ-ONLY; The max permitted usage of this resource.
	MaxCount *int32
}

// SubscriptionQuotasListResult - Result of the GetQuotas operation. It contains a list of quotas for the subscription in
// a particular region.
type SubscriptionQuotasListResult struct {
	// READ-ONLY; List of quotas for the subscription in a particular region.
	Value []*SubscriptionQuota
}

// TestDatasourceResult - The result of the test input or output request.
type TestDatasourceResult struct {
	// Error definition properties.
	Error *ErrorError

	// READ-ONLY; The status of the sample output request.
	Status *TestDatasourceResultStatus
}

// TestInput - A stream analytics input.
type TestInput struct {
	// REQUIRED; The stream analytics input to test.
	Input *Input
}

// TestOutput - A stream analytics output.
type TestOutput struct {
	// REQUIRED; The stream analytics output to test.
	Output *Output
}

// TestQuery - The request object for query testing.
type TestQuery struct {
	// REQUIRED; Stream analytics job object which defines the input, output, and transformation for the query testing.
	StreamingJob *StreamingJob

	// Diagnostics information related to query testing.
	Diagnostics *TestQueryDiagnostics
}

// TestQueryDiagnostics - Diagnostics information related to query testing.
type TestQueryDiagnostics struct {
	// REQUIRED; The SAS URI to the container or directory.
	WriteURI *string

	// The path to the subdirectory.
	Path *string
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// Transformation - A transformation object, containing all information associated with the named transformation. All transformations
// are contained under a streaming job.
type Transformation struct {
	// Resource name
	Name *string

	// The properties that are associated with a transformation. Required on PUT (CreateOrReplace) requests.
	Properties *TransformationProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource type
	Type *string
}

// TransformationProperties - The properties that are associated with a transformation.
type TransformationProperties struct {
	// Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language
	// (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT
	// (CreateOrReplace) requests.
	Query *string

	// Specifies the number of streaming units that the streaming job uses.
	StreamingUnits *int32

	// Specifies the valid streaming units a streaming job can scale to.
	ValidStreamingUnits []*int32

	// READ-ONLY; The current entity tag for the transformation. This is an opaque string. You can use it to detect whether the
	// resource has changed between requests. You can also use it in the If-Match or
	// If-None-Match headers for write operations for optimistic concurrency.
	Etag *string
}
