//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql"
	moduleVersion = "v2.0.0-beta.4"
)

type AdministratorName string

const (
	AdministratorNameActiveDirectory AdministratorName = "ActiveDirectory"
)

// PossibleAdministratorNameValues returns the possible values for the AdministratorName const type.
func PossibleAdministratorNameValues() []AdministratorName {
	return []AdministratorName{
		AdministratorNameActiveDirectory,
	}
}

// AdministratorType - Type of the sever administrator.
type AdministratorType string

const (
	AdministratorTypeActiveDirectory AdministratorType = "ActiveDirectory"
)

// PossibleAdministratorTypeValues returns the possible values for the AdministratorType const type.
func PossibleAdministratorTypeValues() []AdministratorType {
	return []AdministratorType{
		AdministratorTypeActiveDirectory,
	}
}

type AdvancedThreatProtectionName string

const (
	AdvancedThreatProtectionNameDefault AdvancedThreatProtectionName = "Default"
)

// PossibleAdvancedThreatProtectionNameValues returns the possible values for the AdvancedThreatProtectionName const type.
func PossibleAdvancedThreatProtectionNameValues() []AdvancedThreatProtectionName {
	return []AdvancedThreatProtectionName{
		AdvancedThreatProtectionNameDefault,
	}
}

// AdvancedThreatProtectionState - Specifies the state of the Advanced Threat Protection, whether it is enabled or disabled
// or a state has not been applied yet on the specific database or server.
type AdvancedThreatProtectionState string

const (
	AdvancedThreatProtectionStateDisabled AdvancedThreatProtectionState = "Disabled"
	AdvancedThreatProtectionStateEnabled  AdvancedThreatProtectionState = "Enabled"
	AdvancedThreatProtectionStateNew      AdvancedThreatProtectionState = "New"
)

// PossibleAdvancedThreatProtectionStateValues returns the possible values for the AdvancedThreatProtectionState const type.
func PossibleAdvancedThreatProtectionStateValues() []AdvancedThreatProtectionState {
	return []AdvancedThreatProtectionState{
		AdvancedThreatProtectionStateDisabled,
		AdvancedThreatProtectionStateEnabled,
		AdvancedThreatProtectionStateNew,
	}
}

// AdvisorStatus - Gets the status of availability of this advisor to customers. Possible values are 'GA', 'PublicPreview',
// 'LimitedPublicPreview' and 'PrivatePreview'.
type AdvisorStatus string

const (
	AdvisorStatusGA                   AdvisorStatus = "GA"
	AdvisorStatusLimitedPublicPreview AdvisorStatus = "LimitedPublicPreview"
	AdvisorStatusPrivatePreview       AdvisorStatus = "PrivatePreview"
	AdvisorStatusPublicPreview        AdvisorStatus = "PublicPreview"
)

// PossibleAdvisorStatusValues returns the possible values for the AdvisorStatus const type.
func PossibleAdvisorStatusValues() []AdvisorStatus {
	return []AdvisorStatus{
		AdvisorStatusGA,
		AdvisorStatusLimitedPublicPreview,
		AdvisorStatusPrivatePreview,
		AdvisorStatusPublicPreview,
	}
}

type AggregationFunctionType string

const (
	AggregationFunctionTypeAvg   AggregationFunctionType = "avg"
	AggregationFunctionTypeMax   AggregationFunctionType = "max"
	AggregationFunctionTypeMin   AggregationFunctionType = "min"
	AggregationFunctionTypeStdev AggregationFunctionType = "stdev"
	AggregationFunctionTypeSum   AggregationFunctionType = "sum"
)

// PossibleAggregationFunctionTypeValues returns the possible values for the AggregationFunctionType const type.
func PossibleAggregationFunctionTypeValues() []AggregationFunctionType {
	return []AggregationFunctionType{
		AggregationFunctionTypeAvg,
		AggregationFunctionTypeMax,
		AggregationFunctionTypeMin,
		AggregationFunctionTypeStdev,
		AggregationFunctionTypeSum,
	}
}

// AlwaysEncryptedEnclaveType - Type of enclave requested on the elastic pool.
type AlwaysEncryptedEnclaveType string

const (
	AlwaysEncryptedEnclaveTypeDefault AlwaysEncryptedEnclaveType = "Default"
	AlwaysEncryptedEnclaveTypeVBS     AlwaysEncryptedEnclaveType = "VBS"
)

// PossibleAlwaysEncryptedEnclaveTypeValues returns the possible values for the AlwaysEncryptedEnclaveType const type.
func PossibleAlwaysEncryptedEnclaveTypeValues() []AlwaysEncryptedEnclaveType {
	return []AlwaysEncryptedEnclaveType{
		AlwaysEncryptedEnclaveTypeDefault,
		AlwaysEncryptedEnclaveTypeVBS,
	}
}

type AuthenticationName string

const (
	AuthenticationNameDefault AuthenticationName = "Default"
)

// PossibleAuthenticationNameValues returns the possible values for the AuthenticationName const type.
func PossibleAuthenticationNameValues() []AuthenticationName {
	return []AuthenticationName{
		AuthenticationNameDefault,
	}
}

// AutoExecuteStatus - Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor.
// Possible values are 'Enabled' and 'Disabled'
type AutoExecuteStatus string

const (
	AutoExecuteStatusDefault  AutoExecuteStatus = "Default"
	AutoExecuteStatusDisabled AutoExecuteStatus = "Disabled"
	AutoExecuteStatusEnabled  AutoExecuteStatus = "Enabled"
)

// PossibleAutoExecuteStatusValues returns the possible values for the AutoExecuteStatus const type.
func PossibleAutoExecuteStatusValues() []AutoExecuteStatus {
	return []AutoExecuteStatus{
		AutoExecuteStatusDefault,
		AutoExecuteStatusDisabled,
		AutoExecuteStatusEnabled,
	}
}

// AutoExecuteStatusInheritedFrom - Gets the resource from which current value of auto-execute status is inherited. Auto-execute
// status can be set on (and inherited from) different levels in the resource hierarchy. Possible values are
// 'Subscription', 'Server', 'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level).
type AutoExecuteStatusInheritedFrom string

const (
	AutoExecuteStatusInheritedFromDatabase     AutoExecuteStatusInheritedFrom = "Database"
	AutoExecuteStatusInheritedFromDefault      AutoExecuteStatusInheritedFrom = "Default"
	AutoExecuteStatusInheritedFromElasticPool  AutoExecuteStatusInheritedFrom = "ElasticPool"
	AutoExecuteStatusInheritedFromServer       AutoExecuteStatusInheritedFrom = "Server"
	AutoExecuteStatusInheritedFromSubscription AutoExecuteStatusInheritedFrom = "Subscription"
)

// PossibleAutoExecuteStatusInheritedFromValues returns the possible values for the AutoExecuteStatusInheritedFrom const type.
func PossibleAutoExecuteStatusInheritedFromValues() []AutoExecuteStatusInheritedFrom {
	return []AutoExecuteStatusInheritedFrom{
		AutoExecuteStatusInheritedFromDatabase,
		AutoExecuteStatusInheritedFromDefault,
		AutoExecuteStatusInheritedFromElasticPool,
		AutoExecuteStatusInheritedFromServer,
		AutoExecuteStatusInheritedFromSubscription,
	}
}

// AutomaticTuningDisabledReason - Reason description if desired and actual state are different.
type AutomaticTuningDisabledReason string

const (
	AutomaticTuningDisabledReasonAutoConfigured      AutomaticTuningDisabledReason = "AutoConfigured"
	AutomaticTuningDisabledReasonDefault             AutomaticTuningDisabledReason = "Default"
	AutomaticTuningDisabledReasonDisabled            AutomaticTuningDisabledReason = "Disabled"
	AutomaticTuningDisabledReasonInheritedFromServer AutomaticTuningDisabledReason = "InheritedFromServer"
	AutomaticTuningDisabledReasonNotSupported        AutomaticTuningDisabledReason = "NotSupported"
	AutomaticTuningDisabledReasonQueryStoreOff       AutomaticTuningDisabledReason = "QueryStoreOff"
	AutomaticTuningDisabledReasonQueryStoreReadOnly  AutomaticTuningDisabledReason = "QueryStoreReadOnly"
)

// PossibleAutomaticTuningDisabledReasonValues returns the possible values for the AutomaticTuningDisabledReason const type.
func PossibleAutomaticTuningDisabledReasonValues() []AutomaticTuningDisabledReason {
	return []AutomaticTuningDisabledReason{
		AutomaticTuningDisabledReasonAutoConfigured,
		AutomaticTuningDisabledReasonDefault,
		AutomaticTuningDisabledReasonDisabled,
		AutomaticTuningDisabledReasonInheritedFromServer,
		AutomaticTuningDisabledReasonNotSupported,
		AutomaticTuningDisabledReasonQueryStoreOff,
		AutomaticTuningDisabledReasonQueryStoreReadOnly,
	}
}

// AutomaticTuningMode - Automatic tuning desired state.
type AutomaticTuningMode string

const (
	AutomaticTuningModeAuto        AutomaticTuningMode = "Auto"
	AutomaticTuningModeCustom      AutomaticTuningMode = "Custom"
	AutomaticTuningModeInherit     AutomaticTuningMode = "Inherit"
	AutomaticTuningModeUnspecified AutomaticTuningMode = "Unspecified"
)

// PossibleAutomaticTuningModeValues returns the possible values for the AutomaticTuningMode const type.
func PossibleAutomaticTuningModeValues() []AutomaticTuningMode {
	return []AutomaticTuningMode{
		AutomaticTuningModeAuto,
		AutomaticTuningModeCustom,
		AutomaticTuningModeInherit,
		AutomaticTuningModeUnspecified,
	}
}

// AutomaticTuningOptionModeActual - Automatic tuning option actual state.
type AutomaticTuningOptionModeActual string

const (
	AutomaticTuningOptionModeActualOff AutomaticTuningOptionModeActual = "Off"
	AutomaticTuningOptionModeActualOn  AutomaticTuningOptionModeActual = "On"
)

// PossibleAutomaticTuningOptionModeActualValues returns the possible values for the AutomaticTuningOptionModeActual const type.
func PossibleAutomaticTuningOptionModeActualValues() []AutomaticTuningOptionModeActual {
	return []AutomaticTuningOptionModeActual{
		AutomaticTuningOptionModeActualOff,
		AutomaticTuningOptionModeActualOn,
	}
}

// AutomaticTuningOptionModeDesired - Automatic tuning option desired state.
type AutomaticTuningOptionModeDesired string

const (
	AutomaticTuningOptionModeDesiredDefault AutomaticTuningOptionModeDesired = "Default"
	AutomaticTuningOptionModeDesiredOff     AutomaticTuningOptionModeDesired = "Off"
	AutomaticTuningOptionModeDesiredOn      AutomaticTuningOptionModeDesired = "On"
)

// PossibleAutomaticTuningOptionModeDesiredValues returns the possible values for the AutomaticTuningOptionModeDesired const type.
func PossibleAutomaticTuningOptionModeDesiredValues() []AutomaticTuningOptionModeDesired {
	return []AutomaticTuningOptionModeDesired{
		AutomaticTuningOptionModeDesiredDefault,
		AutomaticTuningOptionModeDesiredOff,
		AutomaticTuningOptionModeDesiredOn,
	}
}

// AutomaticTuningServerMode - Automatic tuning desired state.
type AutomaticTuningServerMode string

const (
	AutomaticTuningServerModeAuto        AutomaticTuningServerMode = "Auto"
	AutomaticTuningServerModeCustom      AutomaticTuningServerMode = "Custom"
	AutomaticTuningServerModeUnspecified AutomaticTuningServerMode = "Unspecified"
)

// PossibleAutomaticTuningServerModeValues returns the possible values for the AutomaticTuningServerMode const type.
func PossibleAutomaticTuningServerModeValues() []AutomaticTuningServerMode {
	return []AutomaticTuningServerMode{
		AutomaticTuningServerModeAuto,
		AutomaticTuningServerModeCustom,
		AutomaticTuningServerModeUnspecified,
	}
}

// AutomaticTuningServerReason - Reason description if desired and actual state are different.
type AutomaticTuningServerReason string

const (
	AutomaticTuningServerReasonAutoConfigured AutomaticTuningServerReason = "AutoConfigured"
	AutomaticTuningServerReasonDefault        AutomaticTuningServerReason = "Default"
	AutomaticTuningServerReasonDisabled       AutomaticTuningServerReason = "Disabled"
)

// PossibleAutomaticTuningServerReasonValues returns the possible values for the AutomaticTuningServerReason const type.
func PossibleAutomaticTuningServerReasonValues() []AutomaticTuningServerReason {
	return []AutomaticTuningServerReason{
		AutomaticTuningServerReasonAutoConfigured,
		AutomaticTuningServerReasonDefault,
		AutomaticTuningServerReasonDisabled,
	}
}

// AvailabilityZoneType - Specifies the availability zone the pool's primary replica is pinned to.
type AvailabilityZoneType string

const (
	AvailabilityZoneTypeNoPreference AvailabilityZoneType = "NoPreference"
	AvailabilityZoneTypeOne          AvailabilityZoneType = "1"
	AvailabilityZoneTypeThree        AvailabilityZoneType = "3"
	AvailabilityZoneTypeTwo          AvailabilityZoneType = "2"
)

// PossibleAvailabilityZoneTypeValues returns the possible values for the AvailabilityZoneType const type.
func PossibleAvailabilityZoneTypeValues() []AvailabilityZoneType {
	return []AvailabilityZoneType{
		AvailabilityZoneTypeNoPreference,
		AvailabilityZoneTypeOne,
		AvailabilityZoneTypeThree,
		AvailabilityZoneTypeTwo,
	}
}

// BackupStorageAccessTier - The BackupStorageAccessTier for the LTR backup
type BackupStorageAccessTier string

const (
	BackupStorageAccessTierArchive BackupStorageAccessTier = "Archive"
	BackupStorageAccessTierHot     BackupStorageAccessTier = "Hot"
)

// PossibleBackupStorageAccessTierValues returns the possible values for the BackupStorageAccessTier const type.
func PossibleBackupStorageAccessTierValues() []BackupStorageAccessTier {
	return []BackupStorageAccessTier{
		BackupStorageAccessTierArchive,
		BackupStorageAccessTierHot,
	}
}

// BackupStorageRedundancy - The storage redundancy type of the backup
type BackupStorageRedundancy string

const (
	BackupStorageRedundancyGeo     BackupStorageRedundancy = "Geo"
	BackupStorageRedundancyGeoZone BackupStorageRedundancy = "GeoZone"
	BackupStorageRedundancyLocal   BackupStorageRedundancy = "Local"
	BackupStorageRedundancyZone    BackupStorageRedundancy = "Zone"
)

// PossibleBackupStorageRedundancyValues returns the possible values for the BackupStorageRedundancy const type.
func PossibleBackupStorageRedundancyValues() []BackupStorageRedundancy {
	return []BackupStorageRedundancy{
		BackupStorageRedundancyGeo,
		BackupStorageRedundancyGeoZone,
		BackupStorageRedundancyLocal,
		BackupStorageRedundancyZone,
	}
}

type BaselineName string

const (
	BaselineNameDefault BaselineName = "default"
)

// PossibleBaselineNameValues returns the possible values for the BaselineName const type.
func PossibleBaselineNameValues() []BaselineName {
	return []BaselineName{
		BaselineNameDefault,
	}
}

// BlobAuditingPolicyState - Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled
// are required.
type BlobAuditingPolicyState string

const (
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
	BlobAuditingPolicyStateEnabled  BlobAuditingPolicyState = "Enabled"
)

// PossibleBlobAuditingPolicyStateValues returns the possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{
		BlobAuditingPolicyStateDisabled,
		BlobAuditingPolicyStateEnabled,
	}
}

type CapabilityGroup string

const (
	CapabilityGroupSupportedEditions                CapabilityGroup = "supportedEditions"
	CapabilityGroupSupportedElasticPoolEditions     CapabilityGroup = "supportedElasticPoolEditions"
	CapabilityGroupSupportedInstancePoolEditions    CapabilityGroup = "supportedInstancePoolEditions"
	CapabilityGroupSupportedManagedInstanceEditions CapabilityGroup = "supportedManagedInstanceEditions"
	CapabilityGroupSupportedManagedInstanceVersions CapabilityGroup = "supportedManagedInstanceVersions"
)

// PossibleCapabilityGroupValues returns the possible values for the CapabilityGroup const type.
func PossibleCapabilityGroupValues() []CapabilityGroup {
	return []CapabilityGroup{
		CapabilityGroupSupportedEditions,
		CapabilityGroupSupportedElasticPoolEditions,
		CapabilityGroupSupportedInstancePoolEditions,
		CapabilityGroupSupportedManagedInstanceEditions,
		CapabilityGroupSupportedManagedInstanceVersions,
	}
}

// CapabilityStatus - The status of the capability.
type CapabilityStatus string

const (
	CapabilityStatusAvailable CapabilityStatus = "Available"
	CapabilityStatusDefault   CapabilityStatus = "Default"
	CapabilityStatusDisabled  CapabilityStatus = "Disabled"
	CapabilityStatusVisible   CapabilityStatus = "Visible"
)

// PossibleCapabilityStatusValues returns the possible values for the CapabilityStatus const type.
func PossibleCapabilityStatusValues() []CapabilityStatus {
	return []CapabilityStatus{
		CapabilityStatusAvailable,
		CapabilityStatusDefault,
		CapabilityStatusDisabled,
		CapabilityStatusVisible,
	}
}

// CatalogCollationType - Collation of the metadata catalog.
type CatalogCollationType string

const (
	CatalogCollationTypeDATABASEDEFAULT         CatalogCollationType = "DATABASE_DEFAULT"
	CatalogCollationTypeSQLLatin1GeneralCP1CIAS CatalogCollationType = "SQL_Latin1_General_CP1_CI_AS"
)

// PossibleCatalogCollationTypeValues returns the possible values for the CatalogCollationType const type.
func PossibleCatalogCollationTypeValues() []CatalogCollationType {
	return []CatalogCollationType{
		CatalogCollationTypeDATABASEDEFAULT,
		CatalogCollationTypeSQLLatin1GeneralCP1CIAS,
	}
}

// CheckNameAvailabilityReason - The reason code explaining why the name is unavailable. Will be undefined if the name is
// available.
type CheckNameAvailabilityReason string

const (
	CheckNameAvailabilityReasonAlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	CheckNameAvailabilityReasonInvalid       CheckNameAvailabilityReason = "Invalid"
)

// PossibleCheckNameAvailabilityReasonValues returns the possible values for the CheckNameAvailabilityReason const type.
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return []CheckNameAvailabilityReason{
		CheckNameAvailabilityReasonAlreadyExists,
		CheckNameAvailabilityReasonInvalid,
	}
}

// ColumnDataType - The column data type.
type ColumnDataType string

const (
	ColumnDataTypeBigint           ColumnDataType = "bigint"
	ColumnDataTypeBinary           ColumnDataType = "binary"
	ColumnDataTypeBit              ColumnDataType = "bit"
	ColumnDataTypeChar             ColumnDataType = "char"
	ColumnDataTypeDate             ColumnDataType = "date"
	ColumnDataTypeDatetime         ColumnDataType = "datetime"
	ColumnDataTypeDatetime2        ColumnDataType = "datetime2"
	ColumnDataTypeDatetimeoffset   ColumnDataType = "datetimeoffset"
	ColumnDataTypeDecimal          ColumnDataType = "decimal"
	ColumnDataTypeFloat            ColumnDataType = "float"
	ColumnDataTypeGeography        ColumnDataType = "geography"
	ColumnDataTypeGeometry         ColumnDataType = "geometry"
	ColumnDataTypeHierarchyid      ColumnDataType = "hierarchyid"
	ColumnDataTypeImage            ColumnDataType = "image"
	ColumnDataTypeInt              ColumnDataType = "int"
	ColumnDataTypeMoney            ColumnDataType = "money"
	ColumnDataTypeNchar            ColumnDataType = "nchar"
	ColumnDataTypeNtext            ColumnDataType = "ntext"
	ColumnDataTypeNumeric          ColumnDataType = "numeric"
	ColumnDataTypeNvarchar         ColumnDataType = "nvarchar"
	ColumnDataTypeReal             ColumnDataType = "real"
	ColumnDataTypeSQLVariant       ColumnDataType = "sql_variant"
	ColumnDataTypeSmalldatetime    ColumnDataType = "smalldatetime"
	ColumnDataTypeSmallint         ColumnDataType = "smallint"
	ColumnDataTypeSmallmoney       ColumnDataType = "smallmoney"
	ColumnDataTypeSysname          ColumnDataType = "sysname"
	ColumnDataTypeText             ColumnDataType = "text"
	ColumnDataTypeTime             ColumnDataType = "time"
	ColumnDataTypeTimestamp        ColumnDataType = "timestamp"
	ColumnDataTypeTinyint          ColumnDataType = "tinyint"
	ColumnDataTypeUniqueidentifier ColumnDataType = "uniqueidentifier"
	ColumnDataTypeVarbinary        ColumnDataType = "varbinary"
	ColumnDataTypeVarchar          ColumnDataType = "varchar"
	ColumnDataTypeXML              ColumnDataType = "xml"
)

// PossibleColumnDataTypeValues returns the possible values for the ColumnDataType const type.
func PossibleColumnDataTypeValues() []ColumnDataType {
	return []ColumnDataType{
		ColumnDataTypeBigint,
		ColumnDataTypeBinary,
		ColumnDataTypeBit,
		ColumnDataTypeChar,
		ColumnDataTypeDate,
		ColumnDataTypeDatetime,
		ColumnDataTypeDatetime2,
		ColumnDataTypeDatetimeoffset,
		ColumnDataTypeDecimal,
		ColumnDataTypeFloat,
		ColumnDataTypeGeography,
		ColumnDataTypeGeometry,
		ColumnDataTypeHierarchyid,
		ColumnDataTypeImage,
		ColumnDataTypeInt,
		ColumnDataTypeMoney,
		ColumnDataTypeNchar,
		ColumnDataTypeNtext,
		ColumnDataTypeNumeric,
		ColumnDataTypeNvarchar,
		ColumnDataTypeReal,
		ColumnDataTypeSQLVariant,
		ColumnDataTypeSmalldatetime,
		ColumnDataTypeSmallint,
		ColumnDataTypeSmallmoney,
		ColumnDataTypeSysname,
		ColumnDataTypeText,
		ColumnDataTypeTime,
		ColumnDataTypeTimestamp,
		ColumnDataTypeTinyint,
		ColumnDataTypeUniqueidentifier,
		ColumnDataTypeVarbinary,
		ColumnDataTypeVarchar,
		ColumnDataTypeXML,
	}
}

type ConnectionPolicyName string

const (
	ConnectionPolicyNameDefault ConnectionPolicyName = "default"
)

// PossibleConnectionPolicyNameValues returns the possible values for the ConnectionPolicyName const type.
func PossibleConnectionPolicyNameValues() []ConnectionPolicyName {
	return []ConnectionPolicyName{
		ConnectionPolicyNameDefault,
	}
}

// CreateMode - Specifies the mode of database creation.
// Default: regular database creation.
// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the
// source database.
// Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the
// resource ID of the existing primary database.
// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must
// be specified as the resource ID of the existing database, and
// restorePointInTime must be specified.
// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable
// database resource ID to restore.
// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId
// is the database's original resource ID, then sourceDatabaseDeletionDate
// must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate
// is ignored. restorePointInTime may also be specified to restore from an
// earlier point in time.
// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId
// must be specified as the recovery point resource ID.
// Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
type CreateMode string

const (
	CreateModeCopy                           CreateMode = "Copy"
	CreateModeDefault                        CreateMode = "Default"
	CreateModeOnlineSecondary                CreateMode = "OnlineSecondary"
	CreateModePointInTimeRestore             CreateMode = "PointInTimeRestore"
	CreateModeRecovery                       CreateMode = "Recovery"
	CreateModeRestore                        CreateMode = "Restore"
	CreateModeRestoreExternalBackup          CreateMode = "RestoreExternalBackup"
	CreateModeRestoreExternalBackupSecondary CreateMode = "RestoreExternalBackupSecondary"
	CreateModeRestoreLongTermRetentionBackup CreateMode = "RestoreLongTermRetentionBackup"
	CreateModeSecondary                      CreateMode = "Secondary"
)

// PossibleCreateModeValues returns the possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{
		CreateModeCopy,
		CreateModeDefault,
		CreateModeOnlineSecondary,
		CreateModePointInTimeRestore,
		CreateModeRecovery,
		CreateModeRestore,
		CreateModeRestoreExternalBackup,
		CreateModeRestoreExternalBackupSecondary,
		CreateModeRestoreLongTermRetentionBackup,
		CreateModeSecondary,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DNSRefreshOperationStatus - The status of the DNS refresh operation.
type DNSRefreshOperationStatus string

const (
	DNSRefreshOperationStatusFailed     DNSRefreshOperationStatus = "Failed"
	DNSRefreshOperationStatusInProgress DNSRefreshOperationStatus = "InProgress"
	DNSRefreshOperationStatusSucceeded  DNSRefreshOperationStatus = "Succeeded"
)

// PossibleDNSRefreshOperationStatusValues returns the possible values for the DNSRefreshOperationStatus const type.
func PossibleDNSRefreshOperationStatusValues() []DNSRefreshOperationStatus {
	return []DNSRefreshOperationStatus{
		DNSRefreshOperationStatusFailed,
		DNSRefreshOperationStatusInProgress,
		DNSRefreshOperationStatusSucceeded,
	}
}

// DataMaskingFunction - The masking function that is used for the data masking rule.
type DataMaskingFunction string

const (
	DataMaskingFunctionCCN     DataMaskingFunction = "CCN"
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	DataMaskingFunctionEmail   DataMaskingFunction = "Email"
	DataMaskingFunctionNumber  DataMaskingFunction = "Number"
	DataMaskingFunctionSSN     DataMaskingFunction = "SSN"
	DataMaskingFunctionText    DataMaskingFunction = "Text"
)

// PossibleDataMaskingFunctionValues returns the possible values for the DataMaskingFunction const type.
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return []DataMaskingFunction{
		DataMaskingFunctionCCN,
		DataMaskingFunctionDefault,
		DataMaskingFunctionEmail,
		DataMaskingFunctionNumber,
		DataMaskingFunctionSSN,
		DataMaskingFunctionText,
	}
}

// DataMaskingRuleState - The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName,
// columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't
// already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState.
type DataMaskingRuleState string

const (
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	DataMaskingRuleStateEnabled  DataMaskingRuleState = "Enabled"
)

// PossibleDataMaskingRuleStateValues returns the possible values for the DataMaskingRuleState const type.
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return []DataMaskingRuleState{
		DataMaskingRuleStateDisabled,
		DataMaskingRuleStateEnabled,
	}
}

// DataMaskingState - The state of the data masking policy.
type DataMaskingState string

const (
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	DataMaskingStateEnabled  DataMaskingState = "Enabled"
)

// PossibleDataMaskingStateValues returns the possible values for the DataMaskingState const type.
func PossibleDataMaskingStateValues() []DataMaskingState {
	return []DataMaskingState{
		DataMaskingStateDisabled,
		DataMaskingStateEnabled,
	}
}

type DataWarehouseUserActivityName string

const (
	DataWarehouseUserActivityNameCurrent DataWarehouseUserActivityName = "current"
)

// PossibleDataWarehouseUserActivityNameValues returns the possible values for the DataWarehouseUserActivityName const type.
func PossibleDataWarehouseUserActivityNameValues() []DataWarehouseUserActivityName {
	return []DataWarehouseUserActivityName{
		DataWarehouseUserActivityNameCurrent,
	}
}

// DatabaseIdentityType - The identity type
type DatabaseIdentityType string

const (
	DatabaseIdentityTypeNone         DatabaseIdentityType = "None"
	DatabaseIdentityTypeUserAssigned DatabaseIdentityType = "UserAssigned"
)

// PossibleDatabaseIdentityTypeValues returns the possible values for the DatabaseIdentityType const type.
func PossibleDatabaseIdentityTypeValues() []DatabaseIdentityType {
	return []DatabaseIdentityType{
		DatabaseIdentityTypeNone,
		DatabaseIdentityTypeUserAssigned,
	}
}

// DatabaseKeyType - The database key type. Only supported value is 'AzureKeyVault'.
type DatabaseKeyType string

const (
	DatabaseKeyTypeAzureKeyVault DatabaseKeyType = "AzureKeyVault"
)

// PossibleDatabaseKeyTypeValues returns the possible values for the DatabaseKeyType const type.
func PossibleDatabaseKeyTypeValues() []DatabaseKeyType {
	return []DatabaseKeyType{
		DatabaseKeyTypeAzureKeyVault,
	}
}

// DatabaseLicenseType - The license type to apply for this database. LicenseIncluded if you need a license, or BasePrice
// if you have a license and are eligible for the Azure Hybrid Benefit.
type DatabaseLicenseType string

const (
	DatabaseLicenseTypeBasePrice       DatabaseLicenseType = "BasePrice"
	DatabaseLicenseTypeLicenseIncluded DatabaseLicenseType = "LicenseIncluded"
)

// PossibleDatabaseLicenseTypeValues returns the possible values for the DatabaseLicenseType const type.
func PossibleDatabaseLicenseTypeValues() []DatabaseLicenseType {
	return []DatabaseLicenseType{
		DatabaseLicenseTypeBasePrice,
		DatabaseLicenseTypeLicenseIncluded,
	}
}

// DatabaseReadScale - The state of read-only routing. If enabled, connections that have application intent set to readonly
// in their connection string may be routed to a readonly secondary replica in the same region. Not
// applicable to a Hyperscale database within an elastic pool.
type DatabaseReadScale string

const (
	DatabaseReadScaleDisabled DatabaseReadScale = "Disabled"
	DatabaseReadScaleEnabled  DatabaseReadScale = "Enabled"
)

// PossibleDatabaseReadScaleValues returns the possible values for the DatabaseReadScale const type.
func PossibleDatabaseReadScaleValues() []DatabaseReadScale {
	return []DatabaseReadScale{
		DatabaseReadScaleDisabled,
		DatabaseReadScaleEnabled,
	}
}

type DatabaseState string

const (
	DatabaseStateAll     DatabaseState = "All"
	DatabaseStateDeleted DatabaseState = "Deleted"
	DatabaseStateLive    DatabaseState = "Live"
)

// PossibleDatabaseStateValues returns the possible values for the DatabaseState const type.
func PossibleDatabaseStateValues() []DatabaseState {
	return []DatabaseState{
		DatabaseStateAll,
		DatabaseStateDeleted,
		DatabaseStateLive,
	}
}

// DatabaseStatus - The status of the database.
type DatabaseStatus string

const (
	DatabaseStatusAutoClosed                        DatabaseStatus = "AutoClosed"
	DatabaseStatusCopying                           DatabaseStatus = "Copying"
	DatabaseStatusCreating                          DatabaseStatus = "Creating"
	DatabaseStatusDisabled                          DatabaseStatus = "Disabled"
	DatabaseStatusEmergencyMode                     DatabaseStatus = "EmergencyMode"
	DatabaseStatusInaccessible                      DatabaseStatus = "Inaccessible"
	DatabaseStatusOffline                           DatabaseStatus = "Offline"
	DatabaseStatusOfflineChangingDwPerformanceTiers DatabaseStatus = "OfflineChangingDwPerformanceTiers"
	DatabaseStatusOfflineSecondary                  DatabaseStatus = "OfflineSecondary"
	DatabaseStatusOnline                            DatabaseStatus = "Online"
	DatabaseStatusOnlineChangingDwPerformanceTiers  DatabaseStatus = "OnlineChangingDwPerformanceTiers"
	DatabaseStatusPaused                            DatabaseStatus = "Paused"
	DatabaseStatusPausing                           DatabaseStatus = "Pausing"
	DatabaseStatusRecovering                        DatabaseStatus = "Recovering"
	DatabaseStatusRecoveryPending                   DatabaseStatus = "RecoveryPending"
	DatabaseStatusRestoring                         DatabaseStatus = "Restoring"
	DatabaseStatusResuming                          DatabaseStatus = "Resuming"
	DatabaseStatusScaling                           DatabaseStatus = "Scaling"
	DatabaseStatusShutdown                          DatabaseStatus = "Shutdown"
	DatabaseStatusStandby                           DatabaseStatus = "Standby"
	DatabaseStatusStarting                          DatabaseStatus = "Starting"
	DatabaseStatusStopped                           DatabaseStatus = "Stopped"
	DatabaseStatusStopping                          DatabaseStatus = "Stopping"
	DatabaseStatusSuspect                           DatabaseStatus = "Suspect"
)

// PossibleDatabaseStatusValues returns the possible values for the DatabaseStatus const type.
func PossibleDatabaseStatusValues() []DatabaseStatus {
	return []DatabaseStatus{
		DatabaseStatusAutoClosed,
		DatabaseStatusCopying,
		DatabaseStatusCreating,
		DatabaseStatusDisabled,
		DatabaseStatusEmergencyMode,
		DatabaseStatusInaccessible,
		DatabaseStatusOffline,
		DatabaseStatusOfflineChangingDwPerformanceTiers,
		DatabaseStatusOfflineSecondary,
		DatabaseStatusOnline,
		DatabaseStatusOnlineChangingDwPerformanceTiers,
		DatabaseStatusPaused,
		DatabaseStatusPausing,
		DatabaseStatusRecovering,
		DatabaseStatusRecoveryPending,
		DatabaseStatusRestoring,
		DatabaseStatusResuming,
		DatabaseStatusScaling,
		DatabaseStatusShutdown,
		DatabaseStatusStandby,
		DatabaseStatusStarting,
		DatabaseStatusStopped,
		DatabaseStatusStopping,
		DatabaseStatusSuspect,
	}
}

// DayOfWeek - Day of maintenance window.
type DayOfWeek string

const (
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekFriday,
		DayOfWeekMonday,
		DayOfWeekSaturday,
		DayOfWeekSunday,
		DayOfWeekThursday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
	}
}

type DevOpsAuditingSettingsName string

const (
	DevOpsAuditingSettingsNameDefault DevOpsAuditingSettingsName = "Default"
)

// PossibleDevOpsAuditingSettingsNameValues returns the possible values for the DevOpsAuditingSettingsName const type.
func PossibleDevOpsAuditingSettingsNameValues() []DevOpsAuditingSettingsName {
	return []DevOpsAuditingSettingsName{
		DevOpsAuditingSettingsNameDefault,
	}
}

// DiffBackupIntervalInHours - The differential backup interval in hours. This is how many interval hours between each differential
// backup will be supported. This is only applicable to live databases but not dropped databases.
type DiffBackupIntervalInHours int32

const (
	DiffBackupIntervalInHoursTwelve     DiffBackupIntervalInHours = 12
	DiffBackupIntervalInHoursTwentyFour DiffBackupIntervalInHours = 24
)

// PossibleDiffBackupIntervalInHoursValues returns the possible values for the DiffBackupIntervalInHours const type.
func PossibleDiffBackupIntervalInHoursValues() []DiffBackupIntervalInHours {
	return []DiffBackupIntervalInHours{
		DiffBackupIntervalInHoursTwelve,
		DiffBackupIntervalInHoursTwentyFour,
	}
}

type DtcName string

const (
	DtcNameCurrent DtcName = "current"
)

// PossibleDtcNameValues returns the possible values for the DtcName const type.
func PossibleDtcNameValues() []DtcName {
	return []DtcName{
		DtcNameCurrent,
	}
}

// ElasticPoolLicenseType - The license type to apply for this elastic pool.
type ElasticPoolLicenseType string

const (
	ElasticPoolLicenseTypeBasePrice       ElasticPoolLicenseType = "BasePrice"
	ElasticPoolLicenseTypeLicenseIncluded ElasticPoolLicenseType = "LicenseIncluded"
)

// PossibleElasticPoolLicenseTypeValues returns the possible values for the ElasticPoolLicenseType const type.
func PossibleElasticPoolLicenseTypeValues() []ElasticPoolLicenseType {
	return []ElasticPoolLicenseType{
		ElasticPoolLicenseTypeBasePrice,
		ElasticPoolLicenseTypeLicenseIncluded,
	}
}

// ElasticPoolState - The state of the elastic pool.
type ElasticPoolState string

const (
	ElasticPoolStateCreating ElasticPoolState = "Creating"
	ElasticPoolStateDisabled ElasticPoolState = "Disabled"
	ElasticPoolStateReady    ElasticPoolState = "Ready"
)

// PossibleElasticPoolStateValues returns the possible values for the ElasticPoolState const type.
func PossibleElasticPoolStateValues() []ElasticPoolState {
	return []ElasticPoolState{
		ElasticPoolStateCreating,
		ElasticPoolStateDisabled,
		ElasticPoolStateReady,
	}
}

type EncryptionProtectorName string

const (
	EncryptionProtectorNameCurrent EncryptionProtectorName = "current"
)

// PossibleEncryptionProtectorNameValues returns the possible values for the EncryptionProtectorName const type.
func PossibleEncryptionProtectorNameValues() []EncryptionProtectorName {
	return []EncryptionProtectorName{
		EncryptionProtectorNameCurrent,
	}
}

// ExternalGovernanceStatus - Status of external governance.
type ExternalGovernanceStatus string

const (
	ExternalGovernanceStatusDisabled ExternalGovernanceStatus = "Disabled"
	ExternalGovernanceStatusEnabled  ExternalGovernanceStatus = "Enabled"
)

// PossibleExternalGovernanceStatusValues returns the possible values for the ExternalGovernanceStatus const type.
func PossibleExternalGovernanceStatusValues() []ExternalGovernanceStatus {
	return []ExternalGovernanceStatus{
		ExternalGovernanceStatusDisabled,
		ExternalGovernanceStatusEnabled,
	}
}

// FailoverGroupReplicationRole - Local replication role of the failover group instance.
type FailoverGroupReplicationRole string

const (
	FailoverGroupReplicationRolePrimary   FailoverGroupReplicationRole = "Primary"
	FailoverGroupReplicationRoleSecondary FailoverGroupReplicationRole = "Secondary"
)

// PossibleFailoverGroupReplicationRoleValues returns the possible values for the FailoverGroupReplicationRole const type.
func PossibleFailoverGroupReplicationRoleValues() []FailoverGroupReplicationRole {
	return []FailoverGroupReplicationRole{
		FailoverGroupReplicationRolePrimary,
		FailoverGroupReplicationRoleSecondary,
	}
}

// FreeLimitExhaustionBehavior - Specifies the behavior when monthly free limits are exhausted for the free database.
// AutoPause: The database will be auto paused upon exhaustion of free limits for remainder of the month.
// BillForUsage: The database will continue to be online upon exhaustion of free limits and any overage will be billed.
type FreeLimitExhaustionBehavior string

const (
	FreeLimitExhaustionBehaviorAutoPause     FreeLimitExhaustionBehavior = "AutoPause"
	FreeLimitExhaustionBehaviorBillOverUsage FreeLimitExhaustionBehavior = "BillOverUsage"
)

// PossibleFreeLimitExhaustionBehaviorValues returns the possible values for the FreeLimitExhaustionBehavior const type.
func PossibleFreeLimitExhaustionBehaviorValues() []FreeLimitExhaustionBehavior {
	return []FreeLimitExhaustionBehavior{
		FreeLimitExhaustionBehaviorAutoPause,
		FreeLimitExhaustionBehaviorBillOverUsage,
	}
}

type GeoBackupPolicyName string

const (
	GeoBackupPolicyNameDefault GeoBackupPolicyName = "Default"
)

// PossibleGeoBackupPolicyNameValues returns the possible values for the GeoBackupPolicyName const type.
func PossibleGeoBackupPolicyNameValues() []GeoBackupPolicyName {
	return []GeoBackupPolicyName{
		GeoBackupPolicyNameDefault,
	}
}

// GeoBackupPolicyState - The state of the geo backup policy.
type GeoBackupPolicyState string

const (
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	GeoBackupPolicyStateEnabled  GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns the possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{
		GeoBackupPolicyStateDisabled,
		GeoBackupPolicyStateEnabled,
	}
}

// IdentityType - The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active
// Directory principal for the resource.
type IdentityType string

const (
	IdentityTypeNone                       IdentityType = "None"
	IdentityTypeSystemAssigned             IdentityType = "SystemAssigned"
	IdentityTypeSystemAssignedUserAssigned IdentityType = "SystemAssigned,UserAssigned"
	IdentityTypeUserAssigned               IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns the possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{
		IdentityTypeNone,
		IdentityTypeSystemAssigned,
		IdentityTypeSystemAssignedUserAssigned,
		IdentityTypeUserAssigned,
	}
}

// ImplementationMethod - Gets the method in which this recommended action can be manually implemented. e.g., TSql, AzurePowerShell.
type ImplementationMethod string

const (
	ImplementationMethodAzurePowerShell ImplementationMethod = "AzurePowerShell"
	ImplementationMethodTSQL            ImplementationMethod = "TSql"
)

// PossibleImplementationMethodValues returns the possible values for the ImplementationMethod const type.
func PossibleImplementationMethodValues() []ImplementationMethod {
	return []ImplementationMethod{
		ImplementationMethodAzurePowerShell,
		ImplementationMethodTSQL,
	}
}

// InstanceFailoverGroupReplicationRole - Local replication role of the failover group instance.
type InstanceFailoverGroupReplicationRole string

const (
	InstanceFailoverGroupReplicationRolePrimary   InstanceFailoverGroupReplicationRole = "Primary"
	InstanceFailoverGroupReplicationRoleSecondary InstanceFailoverGroupReplicationRole = "Secondary"
)

// PossibleInstanceFailoverGroupReplicationRoleValues returns the possible values for the InstanceFailoverGroupReplicationRole const type.
func PossibleInstanceFailoverGroupReplicationRoleValues() []InstanceFailoverGroupReplicationRole {
	return []InstanceFailoverGroupReplicationRole{
		InstanceFailoverGroupReplicationRolePrimary,
		InstanceFailoverGroupReplicationRoleSecondary,
	}
}

// InstancePoolLicenseType - The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and
// 'BasePrice' (without SQL license price).
type InstancePoolLicenseType string

const (
	InstancePoolLicenseTypeBasePrice       InstancePoolLicenseType = "BasePrice"
	InstancePoolLicenseTypeLicenseIncluded InstancePoolLicenseType = "LicenseIncluded"
)

// PossibleInstancePoolLicenseTypeValues returns the possible values for the InstancePoolLicenseType const type.
func PossibleInstancePoolLicenseTypeValues() []InstancePoolLicenseType {
	return []InstancePoolLicenseType{
		InstancePoolLicenseTypeBasePrice,
		InstancePoolLicenseTypeLicenseIncluded,
	}
}

// IsRetryable - Gets whether the error could be ignored and recommended action could be retried. Possible values are: Yes/No
type IsRetryable string

const (
	IsRetryableNo  IsRetryable = "No"
	IsRetryableYes IsRetryable = "Yes"
)

// PossibleIsRetryableValues returns the possible values for the IsRetryable const type.
func PossibleIsRetryableValues() []IsRetryable {
	return []IsRetryable{
		IsRetryableNo,
		IsRetryableYes,
	}
}

// JobAgentState - The state of the job agent.
type JobAgentState string

const (
	JobAgentStateCreating JobAgentState = "Creating"
	JobAgentStateDeleting JobAgentState = "Deleting"
	JobAgentStateDisabled JobAgentState = "Disabled"
	JobAgentStateReady    JobAgentState = "Ready"
	JobAgentStateUpdating JobAgentState = "Updating"
)

// PossibleJobAgentStateValues returns the possible values for the JobAgentState const type.
func PossibleJobAgentStateValues() []JobAgentState {
	return []JobAgentState{
		JobAgentStateCreating,
		JobAgentStateDeleting,
		JobAgentStateDisabled,
		JobAgentStateReady,
		JobAgentStateUpdating,
	}
}

// JobExecutionLifecycle - The detailed state of the job execution.
type JobExecutionLifecycle string

const (
	JobExecutionLifecycleCanceled                     JobExecutionLifecycle = "Canceled"
	JobExecutionLifecycleCreated                      JobExecutionLifecycle = "Created"
	JobExecutionLifecycleFailed                       JobExecutionLifecycle = "Failed"
	JobExecutionLifecycleInProgress                   JobExecutionLifecycle = "InProgress"
	JobExecutionLifecycleSkipped                      JobExecutionLifecycle = "Skipped"
	JobExecutionLifecycleSucceeded                    JobExecutionLifecycle = "Succeeded"
	JobExecutionLifecycleSucceededWithSkipped         JobExecutionLifecycle = "SucceededWithSkipped"
	JobExecutionLifecycleTimedOut                     JobExecutionLifecycle = "TimedOut"
	JobExecutionLifecycleWaitingForChildJobExecutions JobExecutionLifecycle = "WaitingForChildJobExecutions"
	JobExecutionLifecycleWaitingForRetry              JobExecutionLifecycle = "WaitingForRetry"
)

// PossibleJobExecutionLifecycleValues returns the possible values for the JobExecutionLifecycle const type.
func PossibleJobExecutionLifecycleValues() []JobExecutionLifecycle {
	return []JobExecutionLifecycle{
		JobExecutionLifecycleCanceled,
		JobExecutionLifecycleCreated,
		JobExecutionLifecycleFailed,
		JobExecutionLifecycleInProgress,
		JobExecutionLifecycleSkipped,
		JobExecutionLifecycleSucceeded,
		JobExecutionLifecycleSucceededWithSkipped,
		JobExecutionLifecycleTimedOut,
		JobExecutionLifecycleWaitingForChildJobExecutions,
		JobExecutionLifecycleWaitingForRetry,
	}
}

// JobScheduleType - Schedule interval type
type JobScheduleType string

const (
	JobScheduleTypeOnce      JobScheduleType = "Once"
	JobScheduleTypeRecurring JobScheduleType = "Recurring"
)

// PossibleJobScheduleTypeValues returns the possible values for the JobScheduleType const type.
func PossibleJobScheduleTypeValues() []JobScheduleType {
	return []JobScheduleType{
		JobScheduleTypeOnce,
		JobScheduleTypeRecurring,
	}
}

// JobStepActionSource - The source of the action to execute.
type JobStepActionSource string

const (
	JobStepActionSourceInline JobStepActionSource = "Inline"
)

// PossibleJobStepActionSourceValues returns the possible values for the JobStepActionSource const type.
func PossibleJobStepActionSourceValues() []JobStepActionSource {
	return []JobStepActionSource{
		JobStepActionSourceInline,
	}
}

// JobStepActionType - Type of action being executed by the job step.
type JobStepActionType string

const (
	JobStepActionTypeTSQL JobStepActionType = "TSql"
)

// PossibleJobStepActionTypeValues returns the possible values for the JobStepActionType const type.
func PossibleJobStepActionTypeValues() []JobStepActionType {
	return []JobStepActionType{
		JobStepActionTypeTSQL,
	}
}

// JobStepOutputType - The output destination type.
type JobStepOutputType string

const (
	JobStepOutputTypeSQLDatabase JobStepOutputType = "SqlDatabase"
)

// PossibleJobStepOutputTypeValues returns the possible values for the JobStepOutputType const type.
func PossibleJobStepOutputTypeValues() []JobStepOutputType {
	return []JobStepOutputType{
		JobStepOutputTypeSQLDatabase,
	}
}

// JobTargetGroupMembershipType - Whether the target is included or excluded from the group.
type JobTargetGroupMembershipType string

const (
	JobTargetGroupMembershipTypeExclude JobTargetGroupMembershipType = "Exclude"
	JobTargetGroupMembershipTypeInclude JobTargetGroupMembershipType = "Include"
)

// PossibleJobTargetGroupMembershipTypeValues returns the possible values for the JobTargetGroupMembershipType const type.
func PossibleJobTargetGroupMembershipTypeValues() []JobTargetGroupMembershipType {
	return []JobTargetGroupMembershipType{
		JobTargetGroupMembershipTypeExclude,
		JobTargetGroupMembershipTypeInclude,
	}
}

// JobTargetType - The type of the target.
type JobTargetType string

const (
	JobTargetTypeSQLDatabase    JobTargetType = "SqlDatabase"
	JobTargetTypeSQLElasticPool JobTargetType = "SqlElasticPool"
	JobTargetTypeSQLServer      JobTargetType = "SqlServer"
	JobTargetTypeSQLShardMap    JobTargetType = "SqlShardMap"
	JobTargetTypeTargetGroup    JobTargetType = "TargetGroup"
)

// PossibleJobTargetTypeValues returns the possible values for the JobTargetType const type.
func PossibleJobTargetTypeValues() []JobTargetType {
	return []JobTargetType{
		JobTargetTypeSQLDatabase,
		JobTargetTypeSQLElasticPool,
		JobTargetTypeSQLServer,
		JobTargetTypeSQLShardMap,
		JobTargetTypeTargetGroup,
	}
}

type LedgerDigestUploadsName string

const (
	LedgerDigestUploadsNameCurrent LedgerDigestUploadsName = "current"
)

// PossibleLedgerDigestUploadsNameValues returns the possible values for the LedgerDigestUploadsName const type.
func PossibleLedgerDigestUploadsNameValues() []LedgerDigestUploadsName {
	return []LedgerDigestUploadsName{
		LedgerDigestUploadsNameCurrent,
	}
}

// LedgerDigestUploadsState - Specifies the state of ledger digest upload.
type LedgerDigestUploadsState string

const (
	LedgerDigestUploadsStateDisabled LedgerDigestUploadsState = "Disabled"
	LedgerDigestUploadsStateEnabled  LedgerDigestUploadsState = "Enabled"
)

// PossibleLedgerDigestUploadsStateValues returns the possible values for the LedgerDigestUploadsState const type.
func PossibleLedgerDigestUploadsStateValues() []LedgerDigestUploadsState {
	return []LedgerDigestUploadsState{
		LedgerDigestUploadsStateDisabled,
		LedgerDigestUploadsStateEnabled,
	}
}

// LogSizeUnit - The units that the limit is expressed in.
type LogSizeUnit string

const (
	LogSizeUnitGigabytes LogSizeUnit = "Gigabytes"
	LogSizeUnitMegabytes LogSizeUnit = "Megabytes"
	LogSizeUnitPercent   LogSizeUnit = "Percent"
	LogSizeUnitPetabytes LogSizeUnit = "Petabytes"
	LogSizeUnitTerabytes LogSizeUnit = "Terabytes"
)

// PossibleLogSizeUnitValues returns the possible values for the LogSizeUnit const type.
func PossibleLogSizeUnitValues() []LogSizeUnit {
	return []LogSizeUnit{
		LogSizeUnitGigabytes,
		LogSizeUnitMegabytes,
		LogSizeUnitPercent,
		LogSizeUnitPetabytes,
		LogSizeUnitTerabytes,
	}
}

type LongTermRetentionPolicyName string

const (
	LongTermRetentionPolicyNameDefault LongTermRetentionPolicyName = "default"
)

// PossibleLongTermRetentionPolicyNameValues returns the possible values for the LongTermRetentionPolicyName const type.
func PossibleLongTermRetentionPolicyNameValues() []LongTermRetentionPolicyName {
	return []LongTermRetentionPolicyName{
		LongTermRetentionPolicyNameDefault,
	}
}

// ManagedDatabaseCreateMode - Managed database create mode. PointInTimeRestore: Create a database by restoring a point in
// time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be
// specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri
// and StorageContainerSasToken must be specified. Recovery: Creates a database
// by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to
// restore. RestoreLongTermRetentionBackup: Create a database by restoring from a
// long term retention backup (longTermRetentionBackupResourceId required).
type ManagedDatabaseCreateMode string

const (
	ManagedDatabaseCreateModeDefault                        ManagedDatabaseCreateMode = "Default"
	ManagedDatabaseCreateModePointInTimeRestore             ManagedDatabaseCreateMode = "PointInTimeRestore"
	ManagedDatabaseCreateModeRecovery                       ManagedDatabaseCreateMode = "Recovery"
	ManagedDatabaseCreateModeRestoreExternalBackup          ManagedDatabaseCreateMode = "RestoreExternalBackup"
	ManagedDatabaseCreateModeRestoreLongTermRetentionBackup ManagedDatabaseCreateMode = "RestoreLongTermRetentionBackup"
)

// PossibleManagedDatabaseCreateModeValues returns the possible values for the ManagedDatabaseCreateMode const type.
func PossibleManagedDatabaseCreateModeValues() []ManagedDatabaseCreateMode {
	return []ManagedDatabaseCreateMode{
		ManagedDatabaseCreateModeDefault,
		ManagedDatabaseCreateModePointInTimeRestore,
		ManagedDatabaseCreateModeRecovery,
		ManagedDatabaseCreateModeRestoreExternalBackup,
		ManagedDatabaseCreateModeRestoreLongTermRetentionBackup,
	}
}

// ManagedDatabaseStatus - Status of the database.
type ManagedDatabaseStatus string

const (
	ManagedDatabaseStatusCreating     ManagedDatabaseStatus = "Creating"
	ManagedDatabaseStatusDbCopying    ManagedDatabaseStatus = "DbCopying"
	ManagedDatabaseStatusDbMoving     ManagedDatabaseStatus = "DbMoving"
	ManagedDatabaseStatusInaccessible ManagedDatabaseStatus = "Inaccessible"
	ManagedDatabaseStatusOffline      ManagedDatabaseStatus = "Offline"
	ManagedDatabaseStatusOnline       ManagedDatabaseStatus = "Online"
	ManagedDatabaseStatusRestoring    ManagedDatabaseStatus = "Restoring"
	ManagedDatabaseStatusShutdown     ManagedDatabaseStatus = "Shutdown"
	ManagedDatabaseStatusStarting     ManagedDatabaseStatus = "Starting"
	ManagedDatabaseStatusStopped      ManagedDatabaseStatus = "Stopped"
	ManagedDatabaseStatusStopping     ManagedDatabaseStatus = "Stopping"
	ManagedDatabaseStatusUpdating     ManagedDatabaseStatus = "Updating"
)

// PossibleManagedDatabaseStatusValues returns the possible values for the ManagedDatabaseStatus const type.
func PossibleManagedDatabaseStatusValues() []ManagedDatabaseStatus {
	return []ManagedDatabaseStatus{
		ManagedDatabaseStatusCreating,
		ManagedDatabaseStatusDbCopying,
		ManagedDatabaseStatusDbMoving,
		ManagedDatabaseStatusInaccessible,
		ManagedDatabaseStatusOffline,
		ManagedDatabaseStatusOnline,
		ManagedDatabaseStatusRestoring,
		ManagedDatabaseStatusShutdown,
		ManagedDatabaseStatusStarting,
		ManagedDatabaseStatusStopped,
		ManagedDatabaseStatusStopping,
		ManagedDatabaseStatusUpdating,
	}
}

// ManagedInstanceAdministratorType - Type of the managed instance administrator.
type ManagedInstanceAdministratorType string

const (
	ManagedInstanceAdministratorTypeActiveDirectory ManagedInstanceAdministratorType = "ActiveDirectory"
)

// PossibleManagedInstanceAdministratorTypeValues returns the possible values for the ManagedInstanceAdministratorType const type.
func PossibleManagedInstanceAdministratorTypeValues() []ManagedInstanceAdministratorType {
	return []ManagedInstanceAdministratorType{
		ManagedInstanceAdministratorTypeActiveDirectory,
	}
}

// ManagedInstanceLicenseType - The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new
// SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
type ManagedInstanceLicenseType string

const (
	ManagedInstanceLicenseTypeBasePrice       ManagedInstanceLicenseType = "BasePrice"
	ManagedInstanceLicenseTypeLicenseIncluded ManagedInstanceLicenseType = "LicenseIncluded"
)

// PossibleManagedInstanceLicenseTypeValues returns the possible values for the ManagedInstanceLicenseType const type.
func PossibleManagedInstanceLicenseTypeValues() []ManagedInstanceLicenseType {
	return []ManagedInstanceLicenseType{
		ManagedInstanceLicenseTypeBasePrice,
		ManagedInstanceLicenseTypeLicenseIncluded,
	}
}

type ManagedInstanceLongTermRetentionPolicyName string

const (
	ManagedInstanceLongTermRetentionPolicyNameDefault ManagedInstanceLongTermRetentionPolicyName = "default"
)

// PossibleManagedInstanceLongTermRetentionPolicyNameValues returns the possible values for the ManagedInstanceLongTermRetentionPolicyName const type.
func PossibleManagedInstanceLongTermRetentionPolicyNameValues() []ManagedInstanceLongTermRetentionPolicyName {
	return []ManagedInstanceLongTermRetentionPolicyName{
		ManagedInstanceLongTermRetentionPolicyNameDefault,
	}
}

type ManagedInstancePropertiesProvisioningState string

const (
	ManagedInstancePropertiesProvisioningStateAccepted     ManagedInstancePropertiesProvisioningState = "Accepted"
	ManagedInstancePropertiesProvisioningStateCanceled     ManagedInstancePropertiesProvisioningState = "Canceled"
	ManagedInstancePropertiesProvisioningStateCreated      ManagedInstancePropertiesProvisioningState = "Created"
	ManagedInstancePropertiesProvisioningStateCreating     ManagedInstancePropertiesProvisioningState = "Creating"
	ManagedInstancePropertiesProvisioningStateDeleted      ManagedInstancePropertiesProvisioningState = "Deleted"
	ManagedInstancePropertiesProvisioningStateDeleting     ManagedInstancePropertiesProvisioningState = "Deleting"
	ManagedInstancePropertiesProvisioningStateFailed       ManagedInstancePropertiesProvisioningState = "Failed"
	ManagedInstancePropertiesProvisioningStateNotSpecified ManagedInstancePropertiesProvisioningState = "NotSpecified"
	ManagedInstancePropertiesProvisioningStateRegistering  ManagedInstancePropertiesProvisioningState = "Registering"
	ManagedInstancePropertiesProvisioningStateRunning      ManagedInstancePropertiesProvisioningState = "Running"
	ManagedInstancePropertiesProvisioningStateSucceeded    ManagedInstancePropertiesProvisioningState = "Succeeded"
	ManagedInstancePropertiesProvisioningStateTimedOut     ManagedInstancePropertiesProvisioningState = "TimedOut"
	ManagedInstancePropertiesProvisioningStateUnknown      ManagedInstancePropertiesProvisioningState = "Unknown"
	ManagedInstancePropertiesProvisioningStateUnrecognized ManagedInstancePropertiesProvisioningState = "Unrecognized"
	ManagedInstancePropertiesProvisioningStateUpdating     ManagedInstancePropertiesProvisioningState = "Updating"
)

// PossibleManagedInstancePropertiesProvisioningStateValues returns the possible values for the ManagedInstancePropertiesProvisioningState const type.
func PossibleManagedInstancePropertiesProvisioningStateValues() []ManagedInstancePropertiesProvisioningState {
	return []ManagedInstancePropertiesProvisioningState{
		ManagedInstancePropertiesProvisioningStateAccepted,
		ManagedInstancePropertiesProvisioningStateCanceled,
		ManagedInstancePropertiesProvisioningStateCreated,
		ManagedInstancePropertiesProvisioningStateCreating,
		ManagedInstancePropertiesProvisioningStateDeleted,
		ManagedInstancePropertiesProvisioningStateDeleting,
		ManagedInstancePropertiesProvisioningStateFailed,
		ManagedInstancePropertiesProvisioningStateNotSpecified,
		ManagedInstancePropertiesProvisioningStateRegistering,
		ManagedInstancePropertiesProvisioningStateRunning,
		ManagedInstancePropertiesProvisioningStateSucceeded,
		ManagedInstancePropertiesProvisioningStateTimedOut,
		ManagedInstancePropertiesProvisioningStateUnknown,
		ManagedInstancePropertiesProvisioningStateUnrecognized,
		ManagedInstancePropertiesProvisioningStateUpdating,
	}
}

// ManagedInstanceProxyOverride - Connection type used for connecting to the instance.
type ManagedInstanceProxyOverride string

const (
	ManagedInstanceProxyOverrideDefault  ManagedInstanceProxyOverride = "Default"
	ManagedInstanceProxyOverrideProxy    ManagedInstanceProxyOverride = "Proxy"
	ManagedInstanceProxyOverrideRedirect ManagedInstanceProxyOverride = "Redirect"
)

// PossibleManagedInstanceProxyOverrideValues returns the possible values for the ManagedInstanceProxyOverride const type.
func PossibleManagedInstanceProxyOverrideValues() []ManagedInstanceProxyOverride {
	return []ManagedInstanceProxyOverride{
		ManagedInstanceProxyOverrideDefault,
		ManagedInstanceProxyOverrideProxy,
		ManagedInstanceProxyOverrideRedirect,
	}
}

type ManagedLedgerDigestUploadsName string

const (
	ManagedLedgerDigestUploadsNameCurrent ManagedLedgerDigestUploadsName = "current"
)

// PossibleManagedLedgerDigestUploadsNameValues returns the possible values for the ManagedLedgerDigestUploadsName const type.
func PossibleManagedLedgerDigestUploadsNameValues() []ManagedLedgerDigestUploadsName {
	return []ManagedLedgerDigestUploadsName{
		ManagedLedgerDigestUploadsNameCurrent,
	}
}

// ManagedLedgerDigestUploadsState - Specifies the state of ledger digest upload.
type ManagedLedgerDigestUploadsState string

const (
	ManagedLedgerDigestUploadsStateDisabled ManagedLedgerDigestUploadsState = "Disabled"
	ManagedLedgerDigestUploadsStateEnabled  ManagedLedgerDigestUploadsState = "Enabled"
)

// PossibleManagedLedgerDigestUploadsStateValues returns the possible values for the ManagedLedgerDigestUploadsState const type.
func PossibleManagedLedgerDigestUploadsStateValues() []ManagedLedgerDigestUploadsState {
	return []ManagedLedgerDigestUploadsState{
		ManagedLedgerDigestUploadsStateDisabled,
		ManagedLedgerDigestUploadsStateEnabled,
	}
}

// ManagedServerCreateMode - Specifies the mode of database creation.
// Default: Regular instance creation.
// Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId
// must be specified.
type ManagedServerCreateMode string

const (
	ManagedServerCreateModeDefault            ManagedServerCreateMode = "Default"
	ManagedServerCreateModePointInTimeRestore ManagedServerCreateMode = "PointInTimeRestore"
)

// PossibleManagedServerCreateModeValues returns the possible values for the ManagedServerCreateMode const type.
func PossibleManagedServerCreateModeValues() []ManagedServerCreateMode {
	return []ManagedServerCreateMode{
		ManagedServerCreateModeDefault,
		ManagedServerCreateModePointInTimeRestore,
	}
}

type ManagedShortTermRetentionPolicyName string

const (
	ManagedShortTermRetentionPolicyNameDefault ManagedShortTermRetentionPolicyName = "default"
)

// PossibleManagedShortTermRetentionPolicyNameValues returns the possible values for the ManagedShortTermRetentionPolicyName const type.
func PossibleManagedShortTermRetentionPolicyNameValues() []ManagedShortTermRetentionPolicyName {
	return []ManagedShortTermRetentionPolicyName{
		ManagedShortTermRetentionPolicyNameDefault,
	}
}

// ManagementOperationState - The operation state.
type ManagementOperationState string

const (
	ManagementOperationStateCancelInProgress ManagementOperationState = "CancelInProgress"
	ManagementOperationStateCancelled        ManagementOperationState = "Cancelled"
	ManagementOperationStateFailed           ManagementOperationState = "Failed"
	ManagementOperationStateInProgress       ManagementOperationState = "InProgress"
	ManagementOperationStatePending          ManagementOperationState = "Pending"
	ManagementOperationStateSucceeded        ManagementOperationState = "Succeeded"
)

// PossibleManagementOperationStateValues returns the possible values for the ManagementOperationState const type.
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return []ManagementOperationState{
		ManagementOperationStateCancelInProgress,
		ManagementOperationStateCancelled,
		ManagementOperationStateFailed,
		ManagementOperationStateInProgress,
		ManagementOperationStatePending,
		ManagementOperationStateSucceeded,
	}
}

// MaxSizeUnit - The units that the limit is expressed in.
type MaxSizeUnit string

const (
	MaxSizeUnitGigabytes MaxSizeUnit = "Gigabytes"
	MaxSizeUnitMegabytes MaxSizeUnit = "Megabytes"
	MaxSizeUnitPetabytes MaxSizeUnit = "Petabytes"
	MaxSizeUnitTerabytes MaxSizeUnit = "Terabytes"
)

// PossibleMaxSizeUnitValues returns the possible values for the MaxSizeUnit const type.
func PossibleMaxSizeUnitValues() []MaxSizeUnit {
	return []MaxSizeUnit{
		MaxSizeUnitGigabytes,
		MaxSizeUnitMegabytes,
		MaxSizeUnitPetabytes,
		MaxSizeUnitTerabytes,
	}
}

type MetricType string

const (
	MetricTypeCPU      MetricType = "cpu"
	MetricTypeDtu      MetricType = "dtu"
	MetricTypeDuration MetricType = "duration"
	MetricTypeIo       MetricType = "io"
	MetricTypeLogIo    MetricType = "logIo"
)

// PossibleMetricTypeValues returns the possible values for the MetricType const type.
func PossibleMetricTypeValues() []MetricType {
	return []MetricType{
		MetricTypeCPU,
		MetricTypeDtu,
		MetricTypeDuration,
		MetricTypeIo,
		MetricTypeLogIo,
	}
}

// MinimalTLSVersion - Minimal TLS version. Allowed values: 'None', 1.0', '1.1', '1.2', '1.3'
type MinimalTLSVersion string

const (
	MinimalTLSVersionNone MinimalTLSVersion = "None"
	MinimalTLSVersionOne0 MinimalTLSVersion = "1.0"
	MinimalTLSVersionOne1 MinimalTLSVersion = "1.1"
	MinimalTLSVersionOne2 MinimalTLSVersion = "1.2"
	MinimalTLSVersionOne3 MinimalTLSVersion = "1.3"
)

// PossibleMinimalTLSVersionValues returns the possible values for the MinimalTLSVersion const type.
func PossibleMinimalTLSVersionValues() []MinimalTLSVersion {
	return []MinimalTLSVersion{
		MinimalTLSVersionNone,
		MinimalTLSVersionOne0,
		MinimalTLSVersionOne1,
		MinimalTLSVersionOne2,
		MinimalTLSVersionOne3,
	}
}

// MoveOperationMode - Operation mode.
type MoveOperationMode string

const (
	MoveOperationModeCopy MoveOperationMode = "Copy"
	MoveOperationModeMove MoveOperationMode = "Move"
)

// PossibleMoveOperationModeValues returns the possible values for the MoveOperationMode const type.
func PossibleMoveOperationModeValues() []MoveOperationMode {
	return []MoveOperationMode{
		MoveOperationModeCopy,
		MoveOperationModeMove,
	}
}

// OperationMode - Operation Mode.
type OperationMode string

const (
	OperationModePolybaseImport OperationMode = "PolybaseImport"
)

// PossibleOperationModeValues returns the possible values for the OperationMode const type.
func PossibleOperationModeValues() []OperationMode {
	return []OperationMode{
		OperationModePolybaseImport,
	}
}

// OperationOrigin - The intended executor of the operation.
type OperationOrigin string

const (
	OperationOriginSystem OperationOrigin = "system"
	OperationOriginUser   OperationOrigin = "user"
)

// PossibleOperationOriginValues returns the possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{
		OperationOriginSystem,
		OperationOriginUser,
	}
}

// PauseDelayTimeUnit - Unit of time that delay is expressed in
type PauseDelayTimeUnit string

const (
	PauseDelayTimeUnitMinutes PauseDelayTimeUnit = "Minutes"
)

// PossiblePauseDelayTimeUnitValues returns the possible values for the PauseDelayTimeUnit const type.
func PossiblePauseDelayTimeUnitValues() []PauseDelayTimeUnit {
	return []PauseDelayTimeUnit{
		PauseDelayTimeUnitMinutes,
	}
}

// PerformanceLevelUnit - Unit type used to measure performance level.
type PerformanceLevelUnit string

const (
	PerformanceLevelUnitDTU    PerformanceLevelUnit = "DTU"
	PerformanceLevelUnitVCores PerformanceLevelUnit = "VCores"
)

// PossiblePerformanceLevelUnitValues returns the possible values for the PerformanceLevelUnit const type.
func PossiblePerformanceLevelUnitValues() []PerformanceLevelUnit {
	return []PerformanceLevelUnit{
		PerformanceLevelUnitDTU,
		PerformanceLevelUnitVCores,
	}
}

// PrimaryAggregationType - The primary aggregation type defining how metric values are displayed.
type PrimaryAggregationType string

const (
	PrimaryAggregationTypeAverage PrimaryAggregationType = "Average"
	PrimaryAggregationTypeCount   PrimaryAggregationType = "Count"
	PrimaryAggregationTypeMaximum PrimaryAggregationType = "Maximum"
	PrimaryAggregationTypeMinimum PrimaryAggregationType = "Minimum"
	PrimaryAggregationTypeNone    PrimaryAggregationType = "None"
	PrimaryAggregationTypeTotal   PrimaryAggregationType = "Total"
)

// PossiblePrimaryAggregationTypeValues returns the possible values for the PrimaryAggregationType const type.
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return []PrimaryAggregationType{
		PrimaryAggregationTypeAverage,
		PrimaryAggregationTypeCount,
		PrimaryAggregationTypeMaximum,
		PrimaryAggregationTypeMinimum,
		PrimaryAggregationTypeNone,
		PrimaryAggregationTypeTotal,
	}
}

// PrincipalType - Principal Type of the sever administrator.
type PrincipalType string

const (
	PrincipalTypeApplication PrincipalType = "Application"
	PrincipalTypeGroup       PrincipalType = "Group"
	PrincipalTypeUser        PrincipalType = "User"
)

// PossiblePrincipalTypeValues returns the possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{
		PrincipalTypeApplication,
		PrincipalTypeGroup,
		PrincipalTypeUser,
	}
}

// PrivateEndpointProvisioningState - State of the private endpoint connection.
type PrivateEndpointProvisioningState string

const (
	PrivateEndpointProvisioningStateApproving PrivateEndpointProvisioningState = "Approving"
	PrivateEndpointProvisioningStateDropping  PrivateEndpointProvisioningState = "Dropping"
	PrivateEndpointProvisioningStateFailed    PrivateEndpointProvisioningState = "Failed"
	PrivateEndpointProvisioningStateReady     PrivateEndpointProvisioningState = "Ready"
	PrivateEndpointProvisioningStateRejecting PrivateEndpointProvisioningState = "Rejecting"
)

// PossiblePrivateEndpointProvisioningStateValues returns the possible values for the PrivateEndpointProvisioningState const type.
func PossiblePrivateEndpointProvisioningStateValues() []PrivateEndpointProvisioningState {
	return []PrivateEndpointProvisioningState{
		PrivateEndpointProvisioningStateApproving,
		PrivateEndpointProvisioningStateDropping,
		PrivateEndpointProvisioningStateFailed,
		PrivateEndpointProvisioningStateReady,
		PrivateEndpointProvisioningStateRejecting,
	}
}

// PrivateLinkServiceConnectionStateActionsRequire - The actions required for private link service connection.
type PrivateLinkServiceConnectionStateActionsRequire string

const (
	PrivateLinkServiceConnectionStateActionsRequireNone PrivateLinkServiceConnectionStateActionsRequire = "None"
)

// PossiblePrivateLinkServiceConnectionStateActionsRequireValues returns the possible values for the PrivateLinkServiceConnectionStateActionsRequire const type.
func PossiblePrivateLinkServiceConnectionStateActionsRequireValues() []PrivateLinkServiceConnectionStateActionsRequire {
	return []PrivateLinkServiceConnectionStateActionsRequire{
		PrivateLinkServiceConnectionStateActionsRequireNone,
	}
}

// PrivateLinkServiceConnectionStateStatus - The private link service connection status.
type PrivateLinkServiceConnectionStateStatus string

const (
	PrivateLinkServiceConnectionStateStatusApproved     PrivateLinkServiceConnectionStateStatus = "Approved"
	PrivateLinkServiceConnectionStateStatusDisconnected PrivateLinkServiceConnectionStateStatus = "Disconnected"
	PrivateLinkServiceConnectionStateStatusPending      PrivateLinkServiceConnectionStateStatus = "Pending"
	PrivateLinkServiceConnectionStateStatusRejected     PrivateLinkServiceConnectionStateStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStateStatusValues returns the possible values for the PrivateLinkServiceConnectionStateStatus const type.
func PossiblePrivateLinkServiceConnectionStateStatusValues() []PrivateLinkServiceConnectionStateStatus {
	return []PrivateLinkServiceConnectionStateStatus{
		PrivateLinkServiceConnectionStateStatusApproved,
		PrivateLinkServiceConnectionStateStatusDisconnected,
		PrivateLinkServiceConnectionStateStatusPending,
		PrivateLinkServiceConnectionStateStatusRejected,
	}
}

// ProvisioningState - The ARM provisioning state of the job execution.
type ProvisioningState string

const (
	ProvisioningStateCanceled   ProvisioningState = "Canceled"
	ProvisioningStateCreated    ProvisioningState = "Created"
	ProvisioningStateFailed     ProvisioningState = "Failed"
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	ProvisioningStateSucceeded  ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCanceled,
		ProvisioningStateCreated,
		ProvisioningStateFailed,
		ProvisioningStateInProgress,
		ProvisioningStateSucceeded,
	}
}

// QueryMetricUnitType - The unit of the metric.
type QueryMetricUnitType string

const (
	QueryMetricUnitTypeCount        QueryMetricUnitType = "count"
	QueryMetricUnitTypeKB           QueryMetricUnitType = "KB"
	QueryMetricUnitTypeMicroseconds QueryMetricUnitType = "microseconds"
	QueryMetricUnitTypePercentage   QueryMetricUnitType = "percentage"
)

// PossibleQueryMetricUnitTypeValues returns the possible values for the QueryMetricUnitType const type.
func PossibleQueryMetricUnitTypeValues() []QueryMetricUnitType {
	return []QueryMetricUnitType{
		QueryMetricUnitTypeCount,
		QueryMetricUnitTypeKB,
		QueryMetricUnitTypeMicroseconds,
		QueryMetricUnitTypePercentage,
	}
}

// QueryTimeGrainType - Interval type (length).
type QueryTimeGrainType string

const (
	QueryTimeGrainTypeP1D  QueryTimeGrainType = "P1D"
	QueryTimeGrainTypePT1H QueryTimeGrainType = "PT1H"
)

// PossibleQueryTimeGrainTypeValues returns the possible values for the QueryTimeGrainType const type.
func PossibleQueryTimeGrainTypeValues() []QueryTimeGrainType {
	return []QueryTimeGrainType{
		QueryTimeGrainTypeP1D,
		QueryTimeGrainTypePT1H,
	}
}

// ReadOnlyEndpointFailoverPolicy - Failover policy of the read-only endpoint for the failover group.
type ReadOnlyEndpointFailoverPolicy string

const (
	ReadOnlyEndpointFailoverPolicyDisabled ReadOnlyEndpointFailoverPolicy = "Disabled"
	ReadOnlyEndpointFailoverPolicyEnabled  ReadOnlyEndpointFailoverPolicy = "Enabled"
)

// PossibleReadOnlyEndpointFailoverPolicyValues returns the possible values for the ReadOnlyEndpointFailoverPolicy const type.
func PossibleReadOnlyEndpointFailoverPolicyValues() []ReadOnlyEndpointFailoverPolicy {
	return []ReadOnlyEndpointFailoverPolicy{
		ReadOnlyEndpointFailoverPolicyDisabled,
		ReadOnlyEndpointFailoverPolicyEnabled,
	}
}

// ReadWriteEndpointFailoverPolicy - Failover policy of the read-write endpoint for the failover group. If failoverPolicy
// is Automatic then failoverWithDataLossGracePeriodMinutes is required.
type ReadWriteEndpointFailoverPolicy string

const (
	ReadWriteEndpointFailoverPolicyAutomatic ReadWriteEndpointFailoverPolicy = "Automatic"
	ReadWriteEndpointFailoverPolicyManual    ReadWriteEndpointFailoverPolicy = "Manual"
)

// PossibleReadWriteEndpointFailoverPolicyValues returns the possible values for the ReadWriteEndpointFailoverPolicy const type.
func PossibleReadWriteEndpointFailoverPolicyValues() []ReadWriteEndpointFailoverPolicy {
	return []ReadWriteEndpointFailoverPolicy{
		ReadWriteEndpointFailoverPolicyAutomatic,
		ReadWriteEndpointFailoverPolicyManual,
	}
}

// RecommendedActionCurrentState - Current state the recommended action is in. Some commonly used states are: Active -> recommended
// action is active and no action has been taken yet. Pending -> recommended action is approved for and is
// awaiting execution. Executing -> recommended action is being applied on the user database. Verifying -> recommended action
// was applied and is being verified of its usefulness by the system. Success ->
// recommended action was applied and improvement found during verification. Pending Revert -> verification found little or
// no improvement so recommended action is queued for revert or user has manually
// reverted. Reverting -> changes made while applying recommended action are being reverted on the user database. Reverted
// -> successfully reverted the changes made by recommended action on user
// database. Ignored -> user explicitly ignored/discarded the recommended action.
type RecommendedActionCurrentState string

const (
	RecommendedActionCurrentStateActive          RecommendedActionCurrentState = "Active"
	RecommendedActionCurrentStateError           RecommendedActionCurrentState = "Error"
	RecommendedActionCurrentStateExecuting       RecommendedActionCurrentState = "Executing"
	RecommendedActionCurrentStateExpired         RecommendedActionCurrentState = "Expired"
	RecommendedActionCurrentStateIgnored         RecommendedActionCurrentState = "Ignored"
	RecommendedActionCurrentStateMonitoring      RecommendedActionCurrentState = "Monitoring"
	RecommendedActionCurrentStatePending         RecommendedActionCurrentState = "Pending"
	RecommendedActionCurrentStatePendingRevert   RecommendedActionCurrentState = "PendingRevert"
	RecommendedActionCurrentStateResolved        RecommendedActionCurrentState = "Resolved"
	RecommendedActionCurrentStateRevertCancelled RecommendedActionCurrentState = "RevertCancelled"
	RecommendedActionCurrentStateReverted        RecommendedActionCurrentState = "Reverted"
	RecommendedActionCurrentStateReverting       RecommendedActionCurrentState = "Reverting"
	RecommendedActionCurrentStateSuccess         RecommendedActionCurrentState = "Success"
	RecommendedActionCurrentStateVerifying       RecommendedActionCurrentState = "Verifying"
)

// PossibleRecommendedActionCurrentStateValues returns the possible values for the RecommendedActionCurrentState const type.
func PossibleRecommendedActionCurrentStateValues() []RecommendedActionCurrentState {
	return []RecommendedActionCurrentState{
		RecommendedActionCurrentStateActive,
		RecommendedActionCurrentStateError,
		RecommendedActionCurrentStateExecuting,
		RecommendedActionCurrentStateExpired,
		RecommendedActionCurrentStateIgnored,
		RecommendedActionCurrentStateMonitoring,
		RecommendedActionCurrentStatePending,
		RecommendedActionCurrentStatePendingRevert,
		RecommendedActionCurrentStateResolved,
		RecommendedActionCurrentStateRevertCancelled,
		RecommendedActionCurrentStateReverted,
		RecommendedActionCurrentStateReverting,
		RecommendedActionCurrentStateSuccess,
		RecommendedActionCurrentStateVerifying,
	}
}

// RecommendedActionInitiatedBy - Gets if approval for applying this recommended action was given by user/system.
type RecommendedActionInitiatedBy string

const (
	RecommendedActionInitiatedBySystem RecommendedActionInitiatedBy = "System"
	RecommendedActionInitiatedByUser   RecommendedActionInitiatedBy = "User"
)

// PossibleRecommendedActionInitiatedByValues returns the possible values for the RecommendedActionInitiatedBy const type.
func PossibleRecommendedActionInitiatedByValues() []RecommendedActionInitiatedBy {
	return []RecommendedActionInitiatedBy{
		RecommendedActionInitiatedBySystem,
		RecommendedActionInitiatedByUser,
	}
}

type RecommendedSensitivityLabelUpdateKind string

const (
	RecommendedSensitivityLabelUpdateKindDisable RecommendedSensitivityLabelUpdateKind = "disable"
	RecommendedSensitivityLabelUpdateKindEnable  RecommendedSensitivityLabelUpdateKind = "enable"
)

// PossibleRecommendedSensitivityLabelUpdateKindValues returns the possible values for the RecommendedSensitivityLabelUpdateKind const type.
func PossibleRecommendedSensitivityLabelUpdateKindValues() []RecommendedSensitivityLabelUpdateKind {
	return []RecommendedSensitivityLabelUpdateKind{
		RecommendedSensitivityLabelUpdateKindDisable,
		RecommendedSensitivityLabelUpdateKindEnable,
	}
}

type ReplicaType string

const (
	ReplicaTypePrimary           ReplicaType = "Primary"
	ReplicaTypeReadableSecondary ReplicaType = "ReadableSecondary"
)

// PossibleReplicaTypeValues returns the possible values for the ReplicaType const type.
func PossibleReplicaTypeValues() []ReplicaType {
	return []ReplicaType{
		ReplicaTypePrimary,
		ReplicaTypeReadableSecondary,
	}
}

// ReplicationLinkType - Link type (GEO, NAMED, STANDBY).
type ReplicationLinkType string

const (
	ReplicationLinkTypeGEO     ReplicationLinkType = "GEO"
	ReplicationLinkTypeNAMED   ReplicationLinkType = "NAMED"
	ReplicationLinkTypeSTANDBY ReplicationLinkType = "STANDBY"
)

// PossibleReplicationLinkTypeValues returns the possible values for the ReplicationLinkType const type.
func PossibleReplicationLinkTypeValues() []ReplicationLinkType {
	return []ReplicationLinkType{
		ReplicationLinkTypeGEO,
		ReplicationLinkTypeNAMED,
		ReplicationLinkTypeSTANDBY,
	}
}

// ReplicationMode - The replication mode of a distributed availability group. Parameter will be ignored during link creation.
type ReplicationMode string

const (
	ReplicationModeAsync ReplicationMode = "Async"
	ReplicationModeSync  ReplicationMode = "Sync"
)

// PossibleReplicationModeValues returns the possible values for the ReplicationMode const type.
func PossibleReplicationModeValues() []ReplicationMode {
	return []ReplicationMode{
		ReplicationModeAsync,
		ReplicationModeSync,
	}
}

// ReplicationRole - Local replication role.
type ReplicationRole string

const (
	ReplicationRoleCopy                 ReplicationRole = "Copy"
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	ReplicationRolePrimary              ReplicationRole = "Primary"
	ReplicationRoleSecondary            ReplicationRole = "Secondary"
	ReplicationRoleSource               ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns the possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{
		ReplicationRoleCopy,
		ReplicationRoleNonReadableSecondary,
		ReplicationRolePrimary,
		ReplicationRoleSecondary,
		ReplicationRoleSource,
	}
}

// ReplicationState - Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED).
type ReplicationState string

const (
	ReplicationStateCATCHUP   ReplicationState = "CATCH_UP"
	ReplicationStatePENDING   ReplicationState = "PENDING"
	ReplicationStateSEEDING   ReplicationState = "SEEDING"
	ReplicationStateSUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns the possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{
		ReplicationStateCATCHUP,
		ReplicationStatePENDING,
		ReplicationStateSEEDING,
		ReplicationStateSUSPENDED,
	}
}

type RestoreDetailsName string

const (
	RestoreDetailsNameDefault RestoreDetailsName = "Default"
)

// PossibleRestoreDetailsNameValues returns the possible values for the RestoreDetailsName const type.
func PossibleRestoreDetailsNameValues() []RestoreDetailsName {
	return []RestoreDetailsName{
		RestoreDetailsNameDefault,
	}
}

// RestorePointType - The type of restore point
type RestorePointType string

const (
	RestorePointTypeCONTINUOUS RestorePointType = "CONTINUOUS"
	RestorePointTypeDISCRETE   RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns the possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{
		RestorePointTypeCONTINUOUS,
		RestorePointTypeDISCRETE,
	}
}

// RuleSeverity - SQL Vulnerability Assessment rule severity.
type RuleSeverity string

const (
	RuleSeverityHigh          RuleSeverity = "High"
	RuleSeverityInformational RuleSeverity = "Informational"
	RuleSeverityLow           RuleSeverity = "Low"
	RuleSeverityMedium        RuleSeverity = "Medium"
	RuleSeverityObsolete      RuleSeverity = "Obsolete"
)

// PossibleRuleSeverityValues returns the possible values for the RuleSeverity const type.
func PossibleRuleSeverityValues() []RuleSeverity {
	return []RuleSeverity{
		RuleSeverityHigh,
		RuleSeverityInformational,
		RuleSeverityLow,
		RuleSeverityMedium,
		RuleSeverityObsolete,
	}
}

// RuleStatus - SQL Vulnerability Assessment baseline status
type RuleStatus string

const (
	RuleStatusFinding       RuleStatus = "Finding"
	RuleStatusInternalError RuleStatus = "InternalError"
	RuleStatusNonFinding    RuleStatus = "NonFinding"
)

// PossibleRuleStatusValues returns the possible values for the RuleStatus const type.
func PossibleRuleStatusValues() []RuleStatus {
	return []RuleStatus{
		RuleStatusFinding,
		RuleStatusInternalError,
		RuleStatusNonFinding,
	}
}

// RuleType - SQL Vulnerability Assessment rule type.
type RuleType string

const (
	RuleTypeBaselineExpected RuleType = "BaselineExpected"
	RuleTypeBinary           RuleType = "Binary"
	RuleTypeNegativeList     RuleType = "NegativeList"
	RuleTypePositiveList     RuleType = "PositiveList"
)

// PossibleRuleTypeValues returns the possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{
		RuleTypeBaselineExpected,
		RuleTypeBinary,
		RuleTypeNegativeList,
		RuleTypePositiveList,
	}
}

// SQLAgentConfigurationPropertiesState - The state of Sql Agent.
type SQLAgentConfigurationPropertiesState string

const (
	SQLAgentConfigurationPropertiesStateDisabled SQLAgentConfigurationPropertiesState = "Disabled"
	SQLAgentConfigurationPropertiesStateEnabled  SQLAgentConfigurationPropertiesState = "Enabled"
)

// PossibleSQLAgentConfigurationPropertiesStateValues returns the possible values for the SQLAgentConfigurationPropertiesState const type.
func PossibleSQLAgentConfigurationPropertiesStateValues() []SQLAgentConfigurationPropertiesState {
	return []SQLAgentConfigurationPropertiesState{
		SQLAgentConfigurationPropertiesStateDisabled,
		SQLAgentConfigurationPropertiesStateEnabled,
	}
}

type SQLVulnerabilityAssessmentName string

const (
	SQLVulnerabilityAssessmentNameDefault SQLVulnerabilityAssessmentName = "default"
)

// PossibleSQLVulnerabilityAssessmentNameValues returns the possible values for the SQLVulnerabilityAssessmentName const type.
func PossibleSQLVulnerabilityAssessmentNameValues() []SQLVulnerabilityAssessmentName {
	return []SQLVulnerabilityAssessmentName{
		SQLVulnerabilityAssessmentNameDefault,
	}
}

// SQLVulnerabilityAssessmentState - Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled
// or a state has not been applied yet on the specific database or server.
type SQLVulnerabilityAssessmentState string

const (
	SQLVulnerabilityAssessmentStateDisabled SQLVulnerabilityAssessmentState = "Disabled"
	SQLVulnerabilityAssessmentStateEnabled  SQLVulnerabilityAssessmentState = "Enabled"
)

// PossibleSQLVulnerabilityAssessmentStateValues returns the possible values for the SQLVulnerabilityAssessmentState const type.
func PossibleSQLVulnerabilityAssessmentStateValues() []SQLVulnerabilityAssessmentState {
	return []SQLVulnerabilityAssessmentState{
		SQLVulnerabilityAssessmentStateDisabled,
		SQLVulnerabilityAssessmentStateEnabled,
	}
}

// SampleName - The name of the sample schema to apply when creating this database.
type SampleName string

const (
	SampleNameAdventureWorksLT       SampleName = "AdventureWorksLT"
	SampleNameWideWorldImportersFull SampleName = "WideWorldImportersFull"
	SampleNameWideWorldImportersStd  SampleName = "WideWorldImportersStd"
)

// PossibleSampleNameValues returns the possible values for the SampleName const type.
func PossibleSampleNameValues() []SampleName {
	return []SampleName{
		SampleNameAdventureWorksLT,
		SampleNameWideWorldImportersFull,
		SampleNameWideWorldImportersStd,
	}
}

// SecondaryInstanceType - Type of the geo-secondary instance. Set 'Standby' if the instance is used as a DR option only.
type SecondaryInstanceType string

const (
	SecondaryInstanceTypeGeo     SecondaryInstanceType = "Geo"
	SecondaryInstanceTypeStandby SecondaryInstanceType = "Standby"
)

// PossibleSecondaryInstanceTypeValues returns the possible values for the SecondaryInstanceType const type.
func PossibleSecondaryInstanceTypeValues() []SecondaryInstanceType {
	return []SecondaryInstanceType{
		SecondaryInstanceTypeGeo,
		SecondaryInstanceTypeStandby,
	}
}

// SecondaryType - The secondary type of the database if it is a secondary. Valid values are Geo, Named and Standby.
type SecondaryType string

const (
	SecondaryTypeGeo     SecondaryType = "Geo"
	SecondaryTypeNamed   SecondaryType = "Named"
	SecondaryTypeStandby SecondaryType = "Standby"
)

// PossibleSecondaryTypeValues returns the possible values for the SecondaryType const type.
func PossibleSecondaryTypeValues() []SecondaryType {
	return []SecondaryType{
		SecondaryTypeGeo,
		SecondaryTypeNamed,
		SecondaryTypeStandby,
	}
}

type SecurityAlertPolicyName string

const (
	SecurityAlertPolicyNameDefault SecurityAlertPolicyName = "Default"
)

// PossibleSecurityAlertPolicyNameValues returns the possible values for the SecurityAlertPolicyName const type.
func PossibleSecurityAlertPolicyNameValues() []SecurityAlertPolicyName {
	return []SecurityAlertPolicyName{
		SecurityAlertPolicyNameDefault,
	}
}

// SecurityAlertPolicyState - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been
// applied yet on the specific database.
type SecurityAlertPolicyState string

const (
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	SecurityAlertPolicyStateEnabled  SecurityAlertPolicyState = "Enabled"
	SecurityAlertPolicyStateNew      SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns the possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{
		SecurityAlertPolicyStateDisabled,
		SecurityAlertPolicyStateEnabled,
		SecurityAlertPolicyStateNew,
	}
}

// SecurityAlertsPolicyState - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been
// applied yet on the specific database.
type SecurityAlertsPolicyState string

const (
	SecurityAlertsPolicyStateDisabled SecurityAlertsPolicyState = "Disabled"
	SecurityAlertsPolicyStateEnabled  SecurityAlertsPolicyState = "Enabled"
)

// PossibleSecurityAlertsPolicyStateValues returns the possible values for the SecurityAlertsPolicyState const type.
func PossibleSecurityAlertsPolicyStateValues() []SecurityAlertsPolicyState {
	return []SecurityAlertsPolicyState{
		SecurityAlertsPolicyStateDisabled,
		SecurityAlertsPolicyStateEnabled,
	}
}

// SecurityEventType - The type of the security event.
type SecurityEventType string

const (
	SecurityEventTypeSQLInjectionExploit       SecurityEventType = "SqlInjectionExploit"
	SecurityEventTypeSQLInjectionVulnerability SecurityEventType = "SqlInjectionVulnerability"
	SecurityEventTypeUndefined                 SecurityEventType = "Undefined"
)

// PossibleSecurityEventTypeValues returns the possible values for the SecurityEventType const type.
func PossibleSecurityEventTypeValues() []SecurityEventType {
	return []SecurityEventType{
		SecurityEventTypeSQLInjectionExploit,
		SecurityEventTypeSQLInjectionVulnerability,
		SecurityEventTypeUndefined,
	}
}

type SensitivityLabelRank string

const (
	SensitivityLabelRankCritical SensitivityLabelRank = "Critical"
	SensitivityLabelRankHigh     SensitivityLabelRank = "High"
	SensitivityLabelRankLow      SensitivityLabelRank = "Low"
	SensitivityLabelRankMedium   SensitivityLabelRank = "Medium"
	SensitivityLabelRankNone     SensitivityLabelRank = "None"
)

// PossibleSensitivityLabelRankValues returns the possible values for the SensitivityLabelRank const type.
func PossibleSensitivityLabelRankValues() []SensitivityLabelRank {
	return []SensitivityLabelRank{
		SensitivityLabelRankCritical,
		SensitivityLabelRankHigh,
		SensitivityLabelRankLow,
		SensitivityLabelRankMedium,
		SensitivityLabelRankNone,
	}
}

type SensitivityLabelSource string

const (
	SensitivityLabelSourceCurrent     SensitivityLabelSource = "current"
	SensitivityLabelSourceRecommended SensitivityLabelSource = "recommended"
)

// PossibleSensitivityLabelSourceValues returns the possible values for the SensitivityLabelSource const type.
func PossibleSensitivityLabelSourceValues() []SensitivityLabelSource {
	return []SensitivityLabelSource{
		SensitivityLabelSourceCurrent,
		SensitivityLabelSourceRecommended,
	}
}

type SensitivityLabelUpdateKind string

const (
	SensitivityLabelUpdateKindRemove SensitivityLabelUpdateKind = "remove"
	SensitivityLabelUpdateKindSet    SensitivityLabelUpdateKind = "set"
)

// PossibleSensitivityLabelUpdateKindValues returns the possible values for the SensitivityLabelUpdateKind const type.
func PossibleSensitivityLabelUpdateKindValues() []SensitivityLabelUpdateKind {
	return []SensitivityLabelUpdateKind{
		SensitivityLabelUpdateKindRemove,
		SensitivityLabelUpdateKindSet,
	}
}

type ServerConfigurationOptionName string

const (
	ServerConfigurationOptionNameAllowPolybaseExport ServerConfigurationOptionName = "allowPolybaseExport"
)

// PossibleServerConfigurationOptionNameValues returns the possible values for the ServerConfigurationOptionName const type.
func PossibleServerConfigurationOptionNameValues() []ServerConfigurationOptionName {
	return []ServerConfigurationOptionName{
		ServerConfigurationOptionNameAllowPolybaseExport,
	}
}

// ServerConnectionType - The server connection type.
type ServerConnectionType string

const (
	ServerConnectionTypeDefault  ServerConnectionType = "Default"
	ServerConnectionTypeProxy    ServerConnectionType = "Proxy"
	ServerConnectionTypeRedirect ServerConnectionType = "Redirect"
)

// PossibleServerConnectionTypeValues returns the possible values for the ServerConnectionType const type.
func PossibleServerConnectionTypeValues() []ServerConnectionType {
	return []ServerConnectionType{
		ServerConnectionTypeDefault,
		ServerConnectionTypeProxy,
		ServerConnectionTypeRedirect,
	}
}

// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
type ServerKeyType string

const (
	ServerKeyTypeAzureKeyVault  ServerKeyType = "AzureKeyVault"
	ServerKeyTypeServiceManaged ServerKeyType = "ServiceManaged"
)

// PossibleServerKeyTypeValues returns the possible values for the ServerKeyType const type.
func PossibleServerKeyTypeValues() []ServerKeyType {
	return []ServerKeyType{
		ServerKeyTypeAzureKeyVault,
		ServerKeyTypeServiceManaged,
	}
}

// ServerNetworkAccessFlag - Whether or not to restrict outbound network access for this server. Value is optional but if
// passed in, must be 'Enabled' or 'Disabled'
type ServerNetworkAccessFlag string

const (
	ServerNetworkAccessFlagDisabled ServerNetworkAccessFlag = "Disabled"
	ServerNetworkAccessFlagEnabled  ServerNetworkAccessFlag = "Enabled"
)

// PossibleServerNetworkAccessFlagValues returns the possible values for the ServerNetworkAccessFlag const type.
func PossibleServerNetworkAccessFlagValues() []ServerNetworkAccessFlag {
	return []ServerNetworkAccessFlag{
		ServerNetworkAccessFlagDisabled,
		ServerNetworkAccessFlagEnabled,
	}
}

// ServerPublicNetworkAccessFlag - Whether or not public endpoint access is allowed for this server. Value is optional but
// if passed in, must be 'Enabled' or 'Disabled' or 'SecuredByPerimeter'
type ServerPublicNetworkAccessFlag string

const (
	ServerPublicNetworkAccessFlagDisabled           ServerPublicNetworkAccessFlag = "Disabled"
	ServerPublicNetworkAccessFlagEnabled            ServerPublicNetworkAccessFlag = "Enabled"
	ServerPublicNetworkAccessFlagSecuredByPerimeter ServerPublicNetworkAccessFlag = "SecuredByPerimeter"
)

// PossibleServerPublicNetworkAccessFlagValues returns the possible values for the ServerPublicNetworkAccessFlag const type.
func PossibleServerPublicNetworkAccessFlagValues() []ServerPublicNetworkAccessFlag {
	return []ServerPublicNetworkAccessFlag{
		ServerPublicNetworkAccessFlagDisabled,
		ServerPublicNetworkAccessFlagEnabled,
		ServerPublicNetworkAccessFlagSecuredByPerimeter,
	}
}

type ServerTrustGroupPropertiesTrustScopesItem string

const (
	ServerTrustGroupPropertiesTrustScopesItemGlobalTransactions ServerTrustGroupPropertiesTrustScopesItem = "GlobalTransactions"
	ServerTrustGroupPropertiesTrustScopesItemServiceBroker      ServerTrustGroupPropertiesTrustScopesItem = "ServiceBroker"
)

// PossibleServerTrustGroupPropertiesTrustScopesItemValues returns the possible values for the ServerTrustGroupPropertiesTrustScopesItem const type.
func PossibleServerTrustGroupPropertiesTrustScopesItemValues() []ServerTrustGroupPropertiesTrustScopesItem {
	return []ServerTrustGroupPropertiesTrustScopesItem{
		ServerTrustGroupPropertiesTrustScopesItemGlobalTransactions,
		ServerTrustGroupPropertiesTrustScopesItemServiceBroker,
	}
}

// ServerWorkspaceFeature - Whether or not existing server has a workspace created and if it allows connection from workspace
type ServerWorkspaceFeature string

const (
	ServerWorkspaceFeatureConnected    ServerWorkspaceFeature = "Connected"
	ServerWorkspaceFeatureDisconnected ServerWorkspaceFeature = "Disconnected"
)

// PossibleServerWorkspaceFeatureValues returns the possible values for the ServerWorkspaceFeature const type.
func PossibleServerWorkspaceFeatureValues() []ServerWorkspaceFeature {
	return []ServerWorkspaceFeature{
		ServerWorkspaceFeatureConnected,
		ServerWorkspaceFeatureDisconnected,
	}
}

// ServiceObjectiveName - The serviceLevelObjective for SLO usage metric.
type ServiceObjectiveName string

const (
	ServiceObjectiveNameBasic       ServiceObjectiveName = "Basic"
	ServiceObjectiveNameDS100       ServiceObjectiveName = "DS100"
	ServiceObjectiveNameDS1000      ServiceObjectiveName = "DS1000"
	ServiceObjectiveNameDS1200      ServiceObjectiveName = "DS1200"
	ServiceObjectiveNameDS1500      ServiceObjectiveName = "DS1500"
	ServiceObjectiveNameDS200       ServiceObjectiveName = "DS200"
	ServiceObjectiveNameDS2000      ServiceObjectiveName = "DS2000"
	ServiceObjectiveNameDS300       ServiceObjectiveName = "DS300"
	ServiceObjectiveNameDS400       ServiceObjectiveName = "DS400"
	ServiceObjectiveNameDS500       ServiceObjectiveName = "DS500"
	ServiceObjectiveNameDS600       ServiceObjectiveName = "DS600"
	ServiceObjectiveNameDW100       ServiceObjectiveName = "DW100"
	ServiceObjectiveNameDW1000      ServiceObjectiveName = "DW1000"
	ServiceObjectiveNameDW10000C    ServiceObjectiveName = "DW10000c"
	ServiceObjectiveNameDW1000C     ServiceObjectiveName = "DW1000c"
	ServiceObjectiveNameDW1200      ServiceObjectiveName = "DW1200"
	ServiceObjectiveNameDW1500      ServiceObjectiveName = "DW1500"
	ServiceObjectiveNameDW15000C    ServiceObjectiveName = "DW15000c"
	ServiceObjectiveNameDW1500C     ServiceObjectiveName = "DW1500c"
	ServiceObjectiveNameDW200       ServiceObjectiveName = "DW200"
	ServiceObjectiveNameDW2000      ServiceObjectiveName = "DW2000"
	ServiceObjectiveNameDW2000C     ServiceObjectiveName = "DW2000c"
	ServiceObjectiveNameDW2500C     ServiceObjectiveName = "DW2500c"
	ServiceObjectiveNameDW300       ServiceObjectiveName = "DW300"
	ServiceObjectiveNameDW3000      ServiceObjectiveName = "DW3000"
	ServiceObjectiveNameDW30000C    ServiceObjectiveName = "DW30000c"
	ServiceObjectiveNameDW3000C     ServiceObjectiveName = "DW3000c"
	ServiceObjectiveNameDW400       ServiceObjectiveName = "DW400"
	ServiceObjectiveNameDW500       ServiceObjectiveName = "DW500"
	ServiceObjectiveNameDW5000C     ServiceObjectiveName = "DW5000c"
	ServiceObjectiveNameDW600       ServiceObjectiveName = "DW600"
	ServiceObjectiveNameDW6000      ServiceObjectiveName = "DW6000"
	ServiceObjectiveNameDW6000C     ServiceObjectiveName = "DW6000c"
	ServiceObjectiveNameDW7500C     ServiceObjectiveName = "DW7500c"
	ServiceObjectiveNameElasticPool ServiceObjectiveName = "ElasticPool"
	ServiceObjectiveNameFree        ServiceObjectiveName = "Free"
	ServiceObjectiveNameP1          ServiceObjectiveName = "P1"
	ServiceObjectiveNameP11         ServiceObjectiveName = "P11"
	ServiceObjectiveNameP15         ServiceObjectiveName = "P15"
	ServiceObjectiveNameP2          ServiceObjectiveName = "P2"
	ServiceObjectiveNameP3          ServiceObjectiveName = "P3"
	ServiceObjectiveNameP4          ServiceObjectiveName = "P4"
	ServiceObjectiveNameP6          ServiceObjectiveName = "P6"
	ServiceObjectiveNamePRS1        ServiceObjectiveName = "PRS1"
	ServiceObjectiveNamePRS2        ServiceObjectiveName = "PRS2"
	ServiceObjectiveNamePRS4        ServiceObjectiveName = "PRS4"
	ServiceObjectiveNamePRS6        ServiceObjectiveName = "PRS6"
	ServiceObjectiveNameS0          ServiceObjectiveName = "S0"
	ServiceObjectiveNameS1          ServiceObjectiveName = "S1"
	ServiceObjectiveNameS12         ServiceObjectiveName = "S12"
	ServiceObjectiveNameS2          ServiceObjectiveName = "S2"
	ServiceObjectiveNameS3          ServiceObjectiveName = "S3"
	ServiceObjectiveNameS4          ServiceObjectiveName = "S4"
	ServiceObjectiveNameS6          ServiceObjectiveName = "S6"
	ServiceObjectiveNameS7          ServiceObjectiveName = "S7"
	ServiceObjectiveNameS9          ServiceObjectiveName = "S9"
	ServiceObjectiveNameSystem      ServiceObjectiveName = "System"
	ServiceObjectiveNameSystem0     ServiceObjectiveName = "System0"
	ServiceObjectiveNameSystem1     ServiceObjectiveName = "System1"
	ServiceObjectiveNameSystem2     ServiceObjectiveName = "System2"
	ServiceObjectiveNameSystem2L    ServiceObjectiveName = "System2L"
	ServiceObjectiveNameSystem3     ServiceObjectiveName = "System3"
	ServiceObjectiveNameSystem3L    ServiceObjectiveName = "System3L"
	ServiceObjectiveNameSystem4     ServiceObjectiveName = "System4"
	ServiceObjectiveNameSystem4L    ServiceObjectiveName = "System4L"
)

// PossibleServiceObjectiveNameValues returns the possible values for the ServiceObjectiveName const type.
func PossibleServiceObjectiveNameValues() []ServiceObjectiveName {
	return []ServiceObjectiveName{
		ServiceObjectiveNameBasic,
		ServiceObjectiveNameDS100,
		ServiceObjectiveNameDS1000,
		ServiceObjectiveNameDS1200,
		ServiceObjectiveNameDS1500,
		ServiceObjectiveNameDS200,
		ServiceObjectiveNameDS2000,
		ServiceObjectiveNameDS300,
		ServiceObjectiveNameDS400,
		ServiceObjectiveNameDS500,
		ServiceObjectiveNameDS600,
		ServiceObjectiveNameDW100,
		ServiceObjectiveNameDW1000,
		ServiceObjectiveNameDW10000C,
		ServiceObjectiveNameDW1000C,
		ServiceObjectiveNameDW1200,
		ServiceObjectiveNameDW1500,
		ServiceObjectiveNameDW15000C,
		ServiceObjectiveNameDW1500C,
		ServiceObjectiveNameDW200,
		ServiceObjectiveNameDW2000,
		ServiceObjectiveNameDW2000C,
		ServiceObjectiveNameDW2500C,
		ServiceObjectiveNameDW300,
		ServiceObjectiveNameDW3000,
		ServiceObjectiveNameDW30000C,
		ServiceObjectiveNameDW3000C,
		ServiceObjectiveNameDW400,
		ServiceObjectiveNameDW500,
		ServiceObjectiveNameDW5000C,
		ServiceObjectiveNameDW600,
		ServiceObjectiveNameDW6000,
		ServiceObjectiveNameDW6000C,
		ServiceObjectiveNameDW7500C,
		ServiceObjectiveNameElasticPool,
		ServiceObjectiveNameFree,
		ServiceObjectiveNameP1,
		ServiceObjectiveNameP11,
		ServiceObjectiveNameP15,
		ServiceObjectiveNameP2,
		ServiceObjectiveNameP3,
		ServiceObjectiveNameP4,
		ServiceObjectiveNameP6,
		ServiceObjectiveNamePRS1,
		ServiceObjectiveNamePRS2,
		ServiceObjectiveNamePRS4,
		ServiceObjectiveNamePRS6,
		ServiceObjectiveNameS0,
		ServiceObjectiveNameS1,
		ServiceObjectiveNameS12,
		ServiceObjectiveNameS2,
		ServiceObjectiveNameS3,
		ServiceObjectiveNameS4,
		ServiceObjectiveNameS6,
		ServiceObjectiveNameS7,
		ServiceObjectiveNameS9,
		ServiceObjectiveNameSystem,
		ServiceObjectiveNameSystem0,
		ServiceObjectiveNameSystem1,
		ServiceObjectiveNameSystem2,
		ServiceObjectiveNameSystem2L,
		ServiceObjectiveNameSystem3,
		ServiceObjectiveNameSystem3L,
		ServiceObjectiveNameSystem4,
		ServiceObjectiveNameSystem4L,
	}
}

// ServicePrincipalType - Service principal type.
type ServicePrincipalType string

const (
	ServicePrincipalTypeNone           ServicePrincipalType = "None"
	ServicePrincipalTypeSystemAssigned ServicePrincipalType = "SystemAssigned"
)

// PossibleServicePrincipalTypeValues returns the possible values for the ServicePrincipalType const type.
func PossibleServicePrincipalTypeValues() []ServicePrincipalType {
	return []ServicePrincipalType{
		ServicePrincipalTypeNone,
		ServicePrincipalTypeSystemAssigned,
	}
}

type ShortTermRetentionPolicyName string

const (
	ShortTermRetentionPolicyNameDefault ShortTermRetentionPolicyName = "default"
)

// PossibleShortTermRetentionPolicyNameValues returns the possible values for the ShortTermRetentionPolicyName const type.
func PossibleShortTermRetentionPolicyNameValues() []ShortTermRetentionPolicyName {
	return []ShortTermRetentionPolicyName{
		ShortTermRetentionPolicyNameDefault,
	}
}

type StartStopScheduleName string

const (
	StartStopScheduleNameDefault StartStopScheduleName = "default"
)

// PossibleStartStopScheduleNameValues returns the possible values for the StartStopScheduleName const type.
func PossibleStartStopScheduleNameValues() []StartStopScheduleName {
	return []StartStopScheduleName{
		StartStopScheduleNameDefault,
	}
}

// StorageCapabilityStorageAccountType - The storage account type for the database's backups.
type StorageCapabilityStorageAccountType string

const (
	StorageCapabilityStorageAccountTypeGRS StorageCapabilityStorageAccountType = "GRS"
	StorageCapabilityStorageAccountTypeLRS StorageCapabilityStorageAccountType = "LRS"
	StorageCapabilityStorageAccountTypeZRS StorageCapabilityStorageAccountType = "ZRS"
)

// PossibleStorageCapabilityStorageAccountTypeValues returns the possible values for the StorageCapabilityStorageAccountType const type.
func PossibleStorageCapabilityStorageAccountTypeValues() []StorageCapabilityStorageAccountType {
	return []StorageCapabilityStorageAccountType{
		StorageCapabilityStorageAccountTypeGRS,
		StorageCapabilityStorageAccountTypeLRS,
		StorageCapabilityStorageAccountTypeZRS,
	}
}

// StorageKeyType - Storage key type.
type StorageKeyType string

const (
	StorageKeyTypeSharedAccessKey  StorageKeyType = "SharedAccessKey"
	StorageKeyTypeStorageAccessKey StorageKeyType = "StorageAccessKey"
)

// PossibleStorageKeyTypeValues returns the possible values for the StorageKeyType const type.
func PossibleStorageKeyTypeValues() []StorageKeyType {
	return []StorageKeyType{
		StorageKeyTypeSharedAccessKey,
		StorageKeyTypeStorageAccessKey,
	}
}

// SyncAgentState - State of the sync agent.
type SyncAgentState string

const (
	SyncAgentStateNeverConnected SyncAgentState = "NeverConnected"
	SyncAgentStateOffline        SyncAgentState = "Offline"
	SyncAgentStateOnline         SyncAgentState = "Online"
)

// PossibleSyncAgentStateValues returns the possible values for the SyncAgentState const type.
func PossibleSyncAgentStateValues() []SyncAgentState {
	return []SyncAgentState{
		SyncAgentStateNeverConnected,
		SyncAgentStateOffline,
		SyncAgentStateOnline,
	}
}

// SyncConflictResolutionPolicy - Conflict resolution policy of the sync group.
type SyncConflictResolutionPolicy string

const (
	SyncConflictResolutionPolicyHubWin    SyncConflictResolutionPolicy = "HubWin"
	SyncConflictResolutionPolicyMemberWin SyncConflictResolutionPolicy = "MemberWin"
)

// PossibleSyncConflictResolutionPolicyValues returns the possible values for the SyncConflictResolutionPolicy const type.
func PossibleSyncConflictResolutionPolicyValues() []SyncConflictResolutionPolicy {
	return []SyncConflictResolutionPolicy{
		SyncConflictResolutionPolicyHubWin,
		SyncConflictResolutionPolicyMemberWin,
	}
}

// SyncDirection - Sync direction of the sync member.
type SyncDirection string

const (
	SyncDirectionBidirectional     SyncDirection = "Bidirectional"
	SyncDirectionOneWayHubToMember SyncDirection = "OneWayHubToMember"
	SyncDirectionOneWayMemberToHub SyncDirection = "OneWayMemberToHub"
)

// PossibleSyncDirectionValues returns the possible values for the SyncDirection const type.
func PossibleSyncDirectionValues() []SyncDirection {
	return []SyncDirection{
		SyncDirectionBidirectional,
		SyncDirectionOneWayHubToMember,
		SyncDirectionOneWayMemberToHub,
	}
}

// SyncGroupLogType - Type of the sync group log.
type SyncGroupLogType string

const (
	SyncGroupLogTypeAll     SyncGroupLogType = "All"
	SyncGroupLogTypeError   SyncGroupLogType = "Error"
	SyncGroupLogTypeSuccess SyncGroupLogType = "Success"
	SyncGroupLogTypeWarning SyncGroupLogType = "Warning"
)

// PossibleSyncGroupLogTypeValues returns the possible values for the SyncGroupLogType const type.
func PossibleSyncGroupLogTypeValues() []SyncGroupLogType {
	return []SyncGroupLogType{
		SyncGroupLogTypeAll,
		SyncGroupLogTypeError,
		SyncGroupLogTypeSuccess,
		SyncGroupLogTypeWarning,
	}
}

// SyncGroupState - Sync state of the sync group.
type SyncGroupState string

const (
	SyncGroupStateError       SyncGroupState = "Error"
	SyncGroupStateGood        SyncGroupState = "Good"
	SyncGroupStateNotReady    SyncGroupState = "NotReady"
	SyncGroupStateProgressing SyncGroupState = "Progressing"
	SyncGroupStateWarning     SyncGroupState = "Warning"
)

// PossibleSyncGroupStateValues returns the possible values for the SyncGroupState const type.
func PossibleSyncGroupStateValues() []SyncGroupState {
	return []SyncGroupState{
		SyncGroupStateError,
		SyncGroupStateGood,
		SyncGroupStateNotReady,
		SyncGroupStateProgressing,
		SyncGroupStateWarning,
	}
}

type SyncGroupsType string

const (
	SyncGroupsTypeAll     SyncGroupsType = "All"
	SyncGroupsTypeError   SyncGroupsType = "Error"
	SyncGroupsTypeSuccess SyncGroupsType = "Success"
	SyncGroupsTypeWarning SyncGroupsType = "Warning"
)

// PossibleSyncGroupsTypeValues returns the possible values for the SyncGroupsType const type.
func PossibleSyncGroupsTypeValues() []SyncGroupsType {
	return []SyncGroupsType{
		SyncGroupsTypeAll,
		SyncGroupsTypeError,
		SyncGroupsTypeSuccess,
		SyncGroupsTypeWarning,
	}
}

// SyncMemberDbType - Type of the sync agent linked database.
type SyncMemberDbType string

const (
	SyncMemberDbTypeAzureSQLDatabase  SyncMemberDbType = "AzureSqlDatabase"
	SyncMemberDbTypeSQLServerDatabase SyncMemberDbType = "SqlServerDatabase"
)

// PossibleSyncMemberDbTypeValues returns the possible values for the SyncMemberDbType const type.
func PossibleSyncMemberDbTypeValues() []SyncMemberDbType {
	return []SyncMemberDbType{
		SyncMemberDbTypeAzureSQLDatabase,
		SyncMemberDbTypeSQLServerDatabase,
	}
}

// SyncMemberState - Sync state of the sync member.
type SyncMemberState string

const (
	SyncMemberStateDeProvisionFailed         SyncMemberState = "DeProvisionFailed"
	SyncMemberStateDeProvisioned             SyncMemberState = "DeProvisioned"
	SyncMemberStateDeProvisioning            SyncMemberState = "DeProvisioning"
	SyncMemberStateDisabledBackupRestore     SyncMemberState = "DisabledBackupRestore"
	SyncMemberStateDisabledTombstoneCleanup  SyncMemberState = "DisabledTombstoneCleanup"
	SyncMemberStateProvisionFailed           SyncMemberState = "ProvisionFailed"
	SyncMemberStateProvisioned               SyncMemberState = "Provisioned"
	SyncMemberStateProvisioning              SyncMemberState = "Provisioning"
	SyncMemberStateReprovisionFailed         SyncMemberState = "ReprovisionFailed"
	SyncMemberStateReprovisioning            SyncMemberState = "Reprovisioning"
	SyncMemberStateSyncCancelled             SyncMemberState = "SyncCancelled"
	SyncMemberStateSyncCancelling            SyncMemberState = "SyncCancelling"
	SyncMemberStateSyncFailed                SyncMemberState = "SyncFailed"
	SyncMemberStateSyncInProgress            SyncMemberState = "SyncInProgress"
	SyncMemberStateSyncSucceeded             SyncMemberState = "SyncSucceeded"
	SyncMemberStateSyncSucceededWithWarnings SyncMemberState = "SyncSucceededWithWarnings"
	SyncMemberStateUnProvisioned             SyncMemberState = "UnProvisioned"
	SyncMemberStateUnReprovisioned           SyncMemberState = "UnReprovisioned"
)

// PossibleSyncMemberStateValues returns the possible values for the SyncMemberState const type.
func PossibleSyncMemberStateValues() []SyncMemberState {
	return []SyncMemberState{
		SyncMemberStateDeProvisionFailed,
		SyncMemberStateDeProvisioned,
		SyncMemberStateDeProvisioning,
		SyncMemberStateDisabledBackupRestore,
		SyncMemberStateDisabledTombstoneCleanup,
		SyncMemberStateProvisionFailed,
		SyncMemberStateProvisioned,
		SyncMemberStateProvisioning,
		SyncMemberStateReprovisionFailed,
		SyncMemberStateReprovisioning,
		SyncMemberStateSyncCancelled,
		SyncMemberStateSyncCancelling,
		SyncMemberStateSyncFailed,
		SyncMemberStateSyncInProgress,
		SyncMemberStateSyncSucceeded,
		SyncMemberStateSyncSucceededWithWarnings,
		SyncMemberStateUnProvisioned,
		SyncMemberStateUnReprovisioned,
	}
}

// TableTemporalType - The table temporal type.
type TableTemporalType string

const (
	TableTemporalTypeHistoryTable                 TableTemporalType = "HistoryTable"
	TableTemporalTypeNonTemporalTable             TableTemporalType = "NonTemporalTable"
	TableTemporalTypeSystemVersionedTemporalTable TableTemporalType = "SystemVersionedTemporalTable"
)

// PossibleTableTemporalTypeValues returns the possible values for the TableTemporalType const type.
func PossibleTableTemporalTypeValues() []TableTemporalType {
	return []TableTemporalType{
		TableTemporalTypeHistoryTable,
		TableTemporalTypeNonTemporalTable,
		TableTemporalTypeSystemVersionedTemporalTable,
	}
}

type TransparentDataEncryptionName string

const (
	TransparentDataEncryptionNameCurrent TransparentDataEncryptionName = "current"
)

// PossibleTransparentDataEncryptionNameValues returns the possible values for the TransparentDataEncryptionName const type.
func PossibleTransparentDataEncryptionNameValues() []TransparentDataEncryptionName {
	return []TransparentDataEncryptionName{
		TransparentDataEncryptionNameCurrent,
	}
}

// TransparentDataEncryptionState - Specifies the state of the transparent data encryption.
type TransparentDataEncryptionState string

const (
	TransparentDataEncryptionStateDisabled TransparentDataEncryptionState = "Disabled"
	TransparentDataEncryptionStateEnabled  TransparentDataEncryptionState = "Enabled"
)

// PossibleTransparentDataEncryptionStateValues returns the possible values for the TransparentDataEncryptionState const type.
func PossibleTransparentDataEncryptionStateValues() []TransparentDataEncryptionState {
	return []TransparentDataEncryptionState{
		TransparentDataEncryptionStateDisabled,
		TransparentDataEncryptionStateEnabled,
	}
}

// UnitDefinitionType - The unit of the metric.
type UnitDefinitionType string

const (
	UnitDefinitionTypeBytes          UnitDefinitionType = "Bytes"
	UnitDefinitionTypeBytesPerSecond UnitDefinitionType = "BytesPerSecond"
	UnitDefinitionTypeCount          UnitDefinitionType = "Count"
	UnitDefinitionTypeCountPerSecond UnitDefinitionType = "CountPerSecond"
	UnitDefinitionTypePercent        UnitDefinitionType = "Percent"
	UnitDefinitionTypeSeconds        UnitDefinitionType = "Seconds"
)

// PossibleUnitDefinitionTypeValues returns the possible values for the UnitDefinitionType const type.
func PossibleUnitDefinitionTypeValues() []UnitDefinitionType {
	return []UnitDefinitionType{
		UnitDefinitionTypeBytes,
		UnitDefinitionTypeBytesPerSecond,
		UnitDefinitionTypeCount,
		UnitDefinitionTypeCountPerSecond,
		UnitDefinitionTypePercent,
		UnitDefinitionTypeSeconds,
	}
}

// UnitType - The unit of the metric.
type UnitType string

const (
	UnitTypeBytes          UnitType = "bytes"
	UnitTypeBytesPerSecond UnitType = "bytesPerSecond"
	UnitTypeCount          UnitType = "count"
	UnitTypeCountPerSecond UnitType = "countPerSecond"
	UnitTypePercent        UnitType = "percent"
	UnitTypeSeconds        UnitType = "seconds"
)

// PossibleUnitTypeValues returns the possible values for the UnitType const type.
func PossibleUnitTypeValues() []UnitType {
	return []UnitType{
		UnitTypeBytes,
		UnitTypeBytesPerSecond,
		UnitTypeCount,
		UnitTypeCountPerSecond,
		UnitTypePercent,
		UnitTypeSeconds,
	}
}

type UpsertManagedServerOperationStepStatus string

const (
	UpsertManagedServerOperationStepStatusCanceled   UpsertManagedServerOperationStepStatus = "Canceled"
	UpsertManagedServerOperationStepStatusCompleted  UpsertManagedServerOperationStepStatus = "Completed"
	UpsertManagedServerOperationStepStatusFailed     UpsertManagedServerOperationStepStatus = "Failed"
	UpsertManagedServerOperationStepStatusInProgress UpsertManagedServerOperationStepStatus = "InProgress"
	UpsertManagedServerOperationStepStatusNotStarted UpsertManagedServerOperationStepStatus = "NotStarted"
	UpsertManagedServerOperationStepStatusSlowedDown UpsertManagedServerOperationStepStatus = "SlowedDown"
)

// PossibleUpsertManagedServerOperationStepStatusValues returns the possible values for the UpsertManagedServerOperationStepStatus const type.
func PossibleUpsertManagedServerOperationStepStatusValues() []UpsertManagedServerOperationStepStatus {
	return []UpsertManagedServerOperationStepStatus{
		UpsertManagedServerOperationStepStatusCanceled,
		UpsertManagedServerOperationStepStatusCompleted,
		UpsertManagedServerOperationStepStatusFailed,
		UpsertManagedServerOperationStepStatusInProgress,
		UpsertManagedServerOperationStepStatusNotStarted,
		UpsertManagedServerOperationStepStatusSlowedDown,
	}
}

// VirtualNetworkRuleState - Virtual Network Rule State
type VirtualNetworkRuleState string

const (
	VirtualNetworkRuleStateDeleting     VirtualNetworkRuleState = "Deleting"
	VirtualNetworkRuleStateFailed       VirtualNetworkRuleState = "Failed"
	VirtualNetworkRuleStateInProgress   VirtualNetworkRuleState = "InProgress"
	VirtualNetworkRuleStateInitializing VirtualNetworkRuleState = "Initializing"
	VirtualNetworkRuleStateReady        VirtualNetworkRuleState = "Ready"
	VirtualNetworkRuleStateUnknown      VirtualNetworkRuleState = "Unknown"
)

// PossibleVirtualNetworkRuleStateValues returns the possible values for the VirtualNetworkRuleState const type.
func PossibleVirtualNetworkRuleStateValues() []VirtualNetworkRuleState {
	return []VirtualNetworkRuleState{
		VirtualNetworkRuleStateDeleting,
		VirtualNetworkRuleStateFailed,
		VirtualNetworkRuleStateInProgress,
		VirtualNetworkRuleStateInitializing,
		VirtualNetworkRuleStateReady,
		VirtualNetworkRuleStateUnknown,
	}
}

type VulnerabilityAssessmentName string

const (
	VulnerabilityAssessmentNameDefault VulnerabilityAssessmentName = "default"
)

// PossibleVulnerabilityAssessmentNameValues returns the possible values for the VulnerabilityAssessmentName const type.
func PossibleVulnerabilityAssessmentNameValues() []VulnerabilityAssessmentName {
	return []VulnerabilityAssessmentName{
		VulnerabilityAssessmentNameDefault,
	}
}

type VulnerabilityAssessmentPolicyBaselineName string

const (
	VulnerabilityAssessmentPolicyBaselineNameDefault VulnerabilityAssessmentPolicyBaselineName = "default"
	VulnerabilityAssessmentPolicyBaselineNameMaster  VulnerabilityAssessmentPolicyBaselineName = "master"
)

// PossibleVulnerabilityAssessmentPolicyBaselineNameValues returns the possible values for the VulnerabilityAssessmentPolicyBaselineName const type.
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return []VulnerabilityAssessmentPolicyBaselineName{
		VulnerabilityAssessmentPolicyBaselineNameDefault,
		VulnerabilityAssessmentPolicyBaselineNameMaster,
	}
}

// VulnerabilityAssessmentScanState - The scan status.
type VulnerabilityAssessmentScanState string

const (
	VulnerabilityAssessmentScanStateFailed      VulnerabilityAssessmentScanState = "Failed"
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = "FailedToRun"
	VulnerabilityAssessmentScanStateInProgress  VulnerabilityAssessmentScanState = "InProgress"
	VulnerabilityAssessmentScanStatePassed      VulnerabilityAssessmentScanState = "Passed"
)

// PossibleVulnerabilityAssessmentScanStateValues returns the possible values for the VulnerabilityAssessmentScanState const type.
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return []VulnerabilityAssessmentScanState{
		VulnerabilityAssessmentScanStateFailed,
		VulnerabilityAssessmentScanStateFailedToRun,
		VulnerabilityAssessmentScanStateInProgress,
		VulnerabilityAssessmentScanStatePassed,
	}
}

// VulnerabilityAssessmentScanTriggerType - The scan trigger type.
type VulnerabilityAssessmentScanTriggerType string

const (
	VulnerabilityAssessmentScanTriggerTypeOnDemand  VulnerabilityAssessmentScanTriggerType = "OnDemand"
	VulnerabilityAssessmentScanTriggerTypeRecurring VulnerabilityAssessmentScanTriggerType = "Recurring"
)

// PossibleVulnerabilityAssessmentScanTriggerTypeValues returns the possible values for the VulnerabilityAssessmentScanTriggerType const type.
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return []VulnerabilityAssessmentScanTriggerType{
		VulnerabilityAssessmentScanTriggerTypeOnDemand,
		VulnerabilityAssessmentScanTriggerTypeRecurring,
	}
}
