//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import "time"

// AutomatedCheckResult - Only for AutomatedStep type
type AutomatedCheckResult struct {
	// Insight Article Content
	Result *string

	// Status for automated check result
	Status *string

	// Type of Result.
	Type *AutomatedCheckResultType

	// Version for automated check result
	Version *string
}

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string

	// The resource type.
	Type *string
}

// CheckNameAvailabilityResponse - Response for whether the requested resource name is available or not.
type CheckNameAvailabilityResponse struct {
	// Gets an error message explaining the 'reason' value with more details. This field is returned iif nameAvailable is false.
	Message *string

	// Returns true or false depending on the availability of the name
	NameAvailable *bool

	// Reason for why value is not available. This field is returned if nameAvailable is false.
	Reason *string
}

// ClassificationService - Service Classification result object.
type ClassificationService struct {
	// List of applicable ARM resource types for this service.
	ResourceTypes []*string

	// READ-ONLY; Localized name of the azure service.
	DisplayName *string

	// READ-ONLY; Azure resource Id of the service.
	ServiceID *string
}

// ContinueRequestBody - Troubleshooter ContinueRequest body.
type ContinueRequestBody struct {
	Responses []*TroubleshooterResponse

	// Unique id of the result.
	StepID *string
}

// Diagnostic - Properties returned with in an insight.
type Diagnostic struct {
	// Error definition.
	Error *Error

	// The problems (if any) detected by this insight.
	Insights []*Insight

	// Solution Id
	SolutionID *string

	// Denotes the status of the diagnostic resource.
	Status *Status
}

// DiagnosticInvocation - Solution Invocation with additional params needed for invocation.
type DiagnosticInvocation struct {
	// Additional parameters required to invoke the solutionId.
	AdditionalParameters map[string]*string

	// Solution Id to invoke.
	SolutionID *string
}

// DiagnosticResource - Diagnostic resource
type DiagnosticResource struct {
	// Diagnostic Resource properties.
	Properties *DiagnosticResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DiagnosticResourceProperties - Diagnostic resource properties.
type DiagnosticResourceProperties struct {
	// Global parameters is an optional map which can be used to add key and value to request body to improve the diagnostics
	// results
	GlobalParameters map[string]*string

	// SolutionIds that are needed to be invoked.
	Insights []*DiagnosticInvocation

	// READ-ONLY; Diagnostic Request Accepted time.
	AcceptedAt *string

	// READ-ONLY; Array of Diagnostics.
	Diagnostics []*Diagnostic

	// READ-ONLY; Status of diagnostic provisioning.
	ProvisioningState *DiagnosticProvisioningState
}

// DiscoveryNlpRequest - Discover NLP request.
type DiscoveryNlpRequest struct {
	// REQUIRED; Natural language description of the issue.
	IssueSummary *string

	// Additional information in the form of a string.
	AdditionalContext *string

	// ARM resource Id of the resource that is having the issue.
	ResourceID *string

	// ARM service Id of the service that is having the issue. For more information on service Id see https://learn.microsoft.com/rest/api/support/services/list?tabs=HTTP.
	ServiceID *string
}

// DiscoveryNlpResponse - Successfully fetched list of solution metadata.
type DiscoveryNlpResponse struct {
	// The list of solution metadata.
	Value []*SolutionNlpMetadataResource
}

// DiscoveryResponse - Discovery response.
type DiscoveryResponse struct {
	// The link used to get the next page of solution metadata.
	NextLink *string

	// The list of metadata.
	Value []*SolutionMetadataResource
}

// Error definition.
type Error struct {
	// An array of additional nested error response info objects, as described by this contract.
	Details []*Error

	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string

	// READ-ONLY; Description of the error.
	Message *string

	// READ-ONLY; Service specific error type which serves as additional context for the error herein.
	Type *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// Filter criterion
type Filter struct {
	// Filter name
	Name *string

	// Filter operator
	Operator *string

	// Filter values
	Values *string
}

// FilterGroup - Filter group
type FilterGroup struct {
	// List of filters
	Filter []*Filter
}

// Insight - Detailed insights(s) obtained via the invocation of an insight diagnostic
type Insight struct {
	// Article id.
	ID *string

	// Importance level of the insight.
	ImportanceLevel *ImportanceLevel

	// Detailed result content.
	Results *string

	// This insight's title.
	Title *string
}

// MetricsBasedChart - Solutions metrics based chart
type MetricsBasedChart struct {
	// Allowed values are Sum, Avg, Count, Min, Max. Default is Sum
	AggregationType *AggregationType

	// Filter group
	FilterGroup *FilterGroup

	// Chart name
	Name *string

	// Place holder used in HTML Content replace control with the content
	ReplacementKey *string

	// Time span duration
	TimeSpanDuration *string

	// Chart title
	Title *string
}

// NlpSolutions - Nlp metadata.
type NlpSolutions struct {
	// Id of the ProblemClassification (https://learn.microsoft.com/en-us/rest/api/support/problem-classifications?view=rest-support-2020-04-01)
	// that may be used to create a support ticket.
	ProblemClassificationID *string

	// Description of the problem classification.
	ProblemDescription *string

	// Title of the problem classification.
	ProblemTitle *string

	// The set of services that are most likely related to the request. If relatedServices is included in the response then solutions
	// may not be discovered until the client calls a second time specifying one
	// of the service Ids in the relatedServices object.
	RelatedServices []*ClassificationService

	// Id of the service (https://learn.microsoft.com/en-us/rest/api/support/services?view=rest-support-2020-04-01) that may be
	// used to create a support ticket.
	ServiceID *string

	// The list of solution metadata.
	Solutions []*SolutionMetadataProperties
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// ReplacementMaps - Solution replacement maps.
type ReplacementMaps struct {
	// Solution diagnostics results.
	Diagnostics []*SolutionsDiagnostic

	// Solution metrics based charts
	MetricsBasedCharts []*MetricsBasedChart

	// Solutions Troubleshooters
	Troubleshooters []*SolutionsTroubleshooters

	// Group of Videos
	VideoGroups []*VideoGroup

	// Video solutions, which have the power to engage the customer by stimulating their senses
	Videos []*Video

	// Solution AzureKB results
	WebResults []*WebResult
}

// ReplacementMapsSelfHelp - Solution replacement maps.
type ReplacementMapsSelfHelp struct {
	// Group of Videos
	VideoGroups []*VideoGroup

	// Video solutions, which have the power to engage the customer by stimulating their senses
	Videos []*Video

	// Solution AzureKB results
	WebResults []*WebResult
}

// ResponseOption - The status of the resource.
type ResponseOption struct {
	// Unique string.
	Key *string

	// Option description
	Value *string
}

// ResponseValidationProperties - Troubleshooter step input response validation properties
type ResponseValidationProperties struct {
	// Default True
	IsRequired *bool

	// Max text input (open Ended Text).
	MaxLength *int64

	// Regex used for the input validation.
	Regex *string

	// Validation Error Message.
	ValidationErrorMessage *string

	// Validation scope
	ValidationScope *ValidationScope
}

// RestartTroubleshooterResponse - Troubleshooter restart response
type RestartTroubleshooterResponse struct {
	// READ-ONLY; Updated TroubleshooterResource Name .
	TroubleshooterResourceName *string
}

// SearchResult - Details of an AzureKB search result.
type SearchResult struct {
	// Confidence of the search result.
	Confidence *Confidence

	// Content of the search result.
	Content *string

	// Link to the document.
	Link *string

	// rank of the search result
	Rank *int32

	// Result type of the search result.
	ResultType *ResultType

	// Unique id of the result.
	SolutionID *string

	// Source of the search result.
	Source *string

	// Title of the search result.
	Title *string
}

// Section - Part of the solution and are dividers in the solution rendering.
type Section struct {
	// Solution sections content.
	Content *string

	// Solution replacement maps.
	ReplacementMaps *ReplacementMaps

	// Solution sections title.
	Title *string
}

// SectionSelfHelp - Part of the solution and are dividers in the solution rendering.
type SectionSelfHelp struct {
	// Solution sections content.
	Content *string

	// Solution replacement maps.
	ReplacementMaps *ReplacementMapsSelfHelp

	// Solution sections title.
	Title *string
}

// SimplifiedSolutionsResource - Simplified Solutions response.
type SimplifiedSolutionsResource struct {
	// Simplified Solutions result
	Properties *SimplifiedSolutionsResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SimplifiedSolutionsResourceProperties - Simplified Solutions result
type SimplifiedSolutionsResourceProperties struct {
	// Client input parameters to run Simplified Solutions
	Parameters map[string]*string

	// Solution Id to identify single Simplified Solution.
	SolutionID *string

	// READ-ONLY; Additional parameter response for Simplified Solutions
	Appendix map[string]*string

	// READ-ONLY; The HTML content that needs to be rendered and shown to customer.
	Content *string

	// READ-ONLY; Status of Simplified Solution provisioning.
	ProvisioningState *SolutionProvisioningState

	// READ-ONLY; The title.
	Title *string
}

// SolutionMetadataProperties - Metadata Properties
type SolutionMetadataProperties struct {
	// Solution Id.
	SolutionID *string

	// READ-ONLY; A detailed description of solution.
	Description *string

	// READ-ONLY; Required parameters for invoking this particular solution.
	RequiredInputs []*string

	// READ-ONLY; Solution Type.
	SolutionType *SolutionType
}

// SolutionMetadataResource - Metadata resource
type SolutionMetadataResource struct {
	// Solution metadata Resource properties.
	Properties *Solutions

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SolutionNlpMetadataResource - Nlp Metadata resource
type SolutionNlpMetadataResource struct {
	// Solution metadata Resource properties.
	Properties *NlpSolutions

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SolutionPatchRequestBody - Solution PatchRequest body
type SolutionPatchRequestBody struct {
	// Solution result
	Properties *SolutionResourceProperties
}

// SolutionResource - Solution response.
type SolutionResource struct {
	// Solution result
	Properties *SolutionResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SolutionResourceProperties - Solution result
type SolutionResourceProperties struct {
	// Client input parameters to run Solution
	Parameters map[string]*string

	// Solution request trigger criteria
	TriggerCriteria []*TriggerCriterion

	// READ-ONLY; The HTML content that needs to be rendered and shown to customer.
	Content *string

	// READ-ONLY; Status of solution provisioning.
	ProvisioningState *SolutionProvisioningState

	// READ-ONLY; Solution replacement maps.
	ReplacementMaps *ReplacementMaps

	// READ-ONLY; List of section object.
	Sections []*Section

	// READ-ONLY; Solution Id to identify single solution.
	SolutionID *string

	// READ-ONLY; The title.
	Title *string
}

// SolutionResourceSelfHelp - Self Help Solution response.
type SolutionResourceSelfHelp struct {
	// Solution result
	Properties *SolutionsResourcePropertiesSelfHelp

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SolutionWarmUpRequestBody - Solution WarmUpRequest body
type SolutionWarmUpRequestBody struct {
	// Dictionary of
	Parameters map[string]*string
}

// Solutions - List of solutions
type Solutions struct {
	// List of metadata.
	Solutions []*SolutionMetadataProperties
}

// SolutionsDiagnostic - Solutions Diagnostic
type SolutionsDiagnostic struct {
	// Diagnostics estimated completion time in minutes
	EstimatedCompletionTime *string

	// Diagnostic insights
	Insights []*Insight

	// Place holder used in HTML Content replace control with the content
	ReplacementKey *string

	// Required parameters of this item
	RequiredParameters []*string

	// Solution Id to identify single Solutions Diagnostic
	SolutionID *string

	// Denotes the status of the diagnostic resource.
	Status *Status

	// Details of the status
	StatusDetails *string
}

// SolutionsResourcePropertiesSelfHelp - Solution result
type SolutionsResourcePropertiesSelfHelp struct {
	// READ-ONLY; The HTML content that needs to be rendered and shown to customer.
	Content *string

	// READ-ONLY; Solution replacement maps.
	ReplacementMaps *ReplacementMapsSelfHelp

	// READ-ONLY; List of section object.
	Sections []*SectionSelfHelp

	// READ-ONLY; SolutionId is a unique id to identify a solution. You can retrieve the solution id using the Discovery api -
	// https://learn.microsoft.com/en-us/rest/api/help/discovery-solution/list?view=rest-help-2023-09-01-preview&tabs=HTTP
	SolutionID *string

	// READ-ONLY; The title.
	Title *string
}

// SolutionsTroubleshooters - Troubleshooters in Solutions
type SolutionsTroubleshooters struct {
	// Solution Id to identify single Solutions Troubleshooter
	SolutionID *string

	// Troubleshooter summary
	Summary *string

	// Troubleshooter title
	Title *string
}

// Step - Troubleshooter step
type Step struct {
	// Only for AutomatedStep type
	AutomatedCheckResults *AutomatedCheckResult

	// Step description.
	Description *string

	// The error detail.
	Error *ErrorDetail

	// Status of Troubleshooter Step execution.
	ExecutionStatus *ExecutionStatus

	// This field has more detailed status description of the execution status.
	ExecutionStatusDescription *string

	// Get or sets the Step guidance.
	Guidance *string

	// Unique step id.
	ID       *string
	Inputs   []*StepInput
	Insights []*Insight

	// is this last step of the workflow.
	IsLastStep *bool

	// Step title.
	Title *string

	// Type of Troubleshooting step.
	Type *Type
}

// StepInput - Details of step input.
type StepInput struct {
	// User question content.
	QuestionContent *string

	// Default is Text.
	QuestionContentType *QuestionContentType

	// Use Index as QuestionId.
	QuestionID *string

	// Question title
	QuestionTitle *string

	// Type of Question
	QuestionType *QuestionType

	// Result of Automate step.
	RecommendedOption *string

	// Place holder text for response hints.
	ResponseHint    *string
	ResponseOptions []*ResponseOption

	// Troubleshooter step input response validation properties
	ResponseValidationProperties *ResponseValidationProperties

	// Text of response that was selected.
	SelectedOptionValue *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TriggerCriterion - Solution request trigger criterion. SolutionId/ProblemClassificationId is the only supported trigger
// type for Solution PUT request. ReplacementKey is the only supported trigger type for Solution PATCH
// request.
type TriggerCriterion struct {
	// Trigger criterion name.
	Name *Name

	// Trigger criterion value.
	Value *string
}

// TroubleshooterInstanceProperties - Troubleshooter Instance properties.
type TroubleshooterInstanceProperties struct {
	// Client input parameters to run Troubleshooter Resource
	Parameters map[string]*string

	// Solution Id to identify single troubleshooter.
	SolutionID *string

	// READ-ONLY; Status of troubleshooter provisioning.
	ProvisioningState *TroubleshooterProvisioningState

	// READ-ONLY; List of step object.
	Steps []*Step
}

// TroubleshooterResource - Troubleshooter response.
type TroubleshooterResource struct {
	// Troubleshooter Instance properties.
	Properties *TroubleshooterInstanceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TroubleshooterResponse - User Response for Troubleshooter continue request
type TroubleshooterResponse struct {
	// id of the question.
	QuestionID *string

	// Type of Question
	QuestionType *QuestionType

	// Response key for SingleInput. For Multi-line test/open ended question it is free form text
	Response *string
}

// Video detail
type Video struct {
	// Place holder used in HTML Content replace control with the insight content
	ReplacementKey *string

	// Link to the video
	Src *string

	// Title of the video
	Title *string
}

// VideoGroup - Video group detail
type VideoGroup struct {
	// Place holder used in HTML Content replace control with the insight content
	ReplacementKey *string

	// List of videos will be shown to customers
	Videos []*VideoGroupVideo
}

// VideoGroupVideo - VideoGroup video detail
type VideoGroupVideo struct {
	// Link to the video
	Src *string

	// Title of the video
	Title *string
}

// WebResult - AzureKB web result
type WebResult struct {
	// Place holder used in HTML Content replace control with the content
	ReplacementKey *string

	// AzureKB search results
	SearchResults []*SearchResult
}
