//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsearch

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/search/armsearch"
	moduleVersion = "v1.4.0-beta.1"
)

// AADAuthFailureMode - Describes what response the data plane API of a search service would send for requests that failed
// authentication.
type AADAuthFailureMode string

const (
	// AADAuthFailureModeHttp401WithBearerChallenge - Indicates that requests that failed authentication should be presented with
	// an HTTP status code of 401 (Unauthorized) and present a Bearer Challenge.
	AADAuthFailureModeHttp401WithBearerChallenge AADAuthFailureMode = "http401WithBearerChallenge"
	// AADAuthFailureModeHttp403 - Indicates that requests that failed authentication should be presented with an HTTP status
	// code of 403 (Forbidden).
	AADAuthFailureModeHttp403 AADAuthFailureMode = "http403"
)

// PossibleAADAuthFailureModeValues returns the possible values for the AADAuthFailureMode const type.
func PossibleAADAuthFailureModeValues() []AADAuthFailureMode {
	return []AADAuthFailureMode{
		AADAuthFailureModeHttp401WithBearerChallenge,
		AADAuthFailureModeHttp403,
	}
}

type AdminKeyKind string

const (
	// AdminKeyKindPrimary - The primary API key for the search service.
	AdminKeyKindPrimary AdminKeyKind = "primary"
	// AdminKeyKindSecondary - The secondary API key for the search service.
	AdminKeyKindSecondary AdminKeyKind = "secondary"
)

// PossibleAdminKeyKindValues returns the possible values for the AdminKeyKind const type.
func PossibleAdminKeyKindValues() []AdminKeyKind {
	return []AdminKeyKind{
		AdminKeyKindPrimary,
		AdminKeyKindSecondary,
	}
}

// HostingMode - Applicable only for the standard3 SKU. You can set this property to enable up to 3 high density partitions
// that allow up to 1000 indexes, which is much higher than the maximum indexes allowed for any
// other SKU. For the standard3 SKU, the value is either 'default' or 'highDensity'. For all other SKUs, this value must be
// 'default'.
type HostingMode string

const (
	// HostingModeDefault - The limit on number of indexes is determined by the default limits for the SKU.
	HostingModeDefault HostingMode = "default"
	// HostingModeHighDensity - Only application for standard3 SKU, where the search service can have up to 1000 indexes.
	HostingModeHighDensity HostingMode = "highDensity"
)

// PossibleHostingModeValues returns the possible values for the HostingMode const type.
func PossibleHostingModeValues() []HostingMode {
	return []HostingMode{
		HostingModeDefault,
		HostingModeHighDensity,
	}
}

// IdentityType - The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an identity
// created by the system and a set of user assigned identities. The type 'None' will remove
// all identities from the service.
type IdentityType string

const (
	// IdentityTypeNone - Indicates that any identity associated with the search service needs to be removed.
	IdentityTypeNone IdentityType = "None"
	// IdentityTypeSystemAssigned - Indicates that system-assigned identity for the search service will be enabled.
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
	// IdentityTypeSystemAssignedUserAssigned - Indicates that system-assigned identity for the search service will be enabled
	// along with the assignment of one or more user assigned identities.
	IdentityTypeSystemAssignedUserAssigned IdentityType = "SystemAssigned, UserAssigned"
	// IdentityTypeUserAssigned - Indicates that one or more user assigned identities will be assigned to the search service.
	IdentityTypeUserAssigned IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns the possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{
		IdentityTypeNone,
		IdentityTypeSystemAssigned,
		IdentityTypeSystemAssignedUserAssigned,
		IdentityTypeUserAssigned,
	}
}

// PrivateLinkServiceConnectionProvisioningState - The provisioning state of the private link service connection. Valid values
// are Updating, Deleting, Failed, Succeeded, Incomplete, or Canceled.
type PrivateLinkServiceConnectionProvisioningState string

const (
	// PrivateLinkServiceConnectionProvisioningStateCanceled - Provisioning request for the private link service connection resource
	// has been canceled.
	PrivateLinkServiceConnectionProvisioningStateCanceled PrivateLinkServiceConnectionProvisioningState = "Canceled"
	// PrivateLinkServiceConnectionProvisioningStateDeleting - The private link service connection is in the process of being
	// deleted.
	PrivateLinkServiceConnectionProvisioningStateDeleting PrivateLinkServiceConnectionProvisioningState = "Deleting"
	// PrivateLinkServiceConnectionProvisioningStateFailed - The private link service connection has failed to be provisioned
	// or deleted.
	PrivateLinkServiceConnectionProvisioningStateFailed PrivateLinkServiceConnectionProvisioningState = "Failed"
	// PrivateLinkServiceConnectionProvisioningStateIncomplete - Provisioning request for the private link service connection
	// resource has been accepted but the process of creation has not commenced yet.
	PrivateLinkServiceConnectionProvisioningStateIncomplete PrivateLinkServiceConnectionProvisioningState = "Incomplete"
	// PrivateLinkServiceConnectionProvisioningStateSucceeded - The private link service connection has finished provisioning
	// and is ready for approval.
	PrivateLinkServiceConnectionProvisioningStateSucceeded PrivateLinkServiceConnectionProvisioningState = "Succeeded"
	// PrivateLinkServiceConnectionProvisioningStateUpdating - The private link service connection is in the process of being
	// created along with other resources for it to be fully functional.
	PrivateLinkServiceConnectionProvisioningStateUpdating PrivateLinkServiceConnectionProvisioningState = "Updating"
)

// PossiblePrivateLinkServiceConnectionProvisioningStateValues returns the possible values for the PrivateLinkServiceConnectionProvisioningState const type.
func PossiblePrivateLinkServiceConnectionProvisioningStateValues() []PrivateLinkServiceConnectionProvisioningState {
	return []PrivateLinkServiceConnectionProvisioningState{
		PrivateLinkServiceConnectionProvisioningStateCanceled,
		PrivateLinkServiceConnectionProvisioningStateDeleting,
		PrivateLinkServiceConnectionProvisioningStateFailed,
		PrivateLinkServiceConnectionProvisioningStateIncomplete,
		PrivateLinkServiceConnectionProvisioningStateSucceeded,
		PrivateLinkServiceConnectionProvisioningStateUpdating,
	}
}

// PrivateLinkServiceConnectionStatus - Status of the the private link service connection. Valid values are Pending, Approved,
// Rejected, or Disconnected.
type PrivateLinkServiceConnectionStatus string

const (
	// PrivateLinkServiceConnectionStatusApproved - The private endpoint connection is approved and is ready for use.
	PrivateLinkServiceConnectionStatusApproved PrivateLinkServiceConnectionStatus = "Approved"
	// PrivateLinkServiceConnectionStatusDisconnected - The private endpoint connection has been removed from the service.
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = "Disconnected"
	// PrivateLinkServiceConnectionStatusPending - The private endpoint connection has been created and is pending approval.
	PrivateLinkServiceConnectionStatusPending PrivateLinkServiceConnectionStatus = "Pending"
	// PrivateLinkServiceConnectionStatusRejected - The private endpoint connection has been rejected and cannot be used.
	PrivateLinkServiceConnectionStatusRejected PrivateLinkServiceConnectionStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns the possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{
		PrivateLinkServiceConnectionStatusApproved,
		PrivateLinkServiceConnectionStatusDisconnected,
		PrivateLinkServiceConnectionStatusPending,
		PrivateLinkServiceConnectionStatusRejected,
	}
}

// ProvisioningState - The state of the last provisioning operation performed on the search service. Provisioning is an intermediate
// state that occurs while service capacity is being established. After capacity is set up,
// provisioningState changes to either 'succeeded' or 'failed'. Client applications can poll provisioning status (the recommended
// polling interval is from 30 seconds to one minute) by using the Get
// Search Service operation to see when an operation is completed. If you are using the free service, this value tends to
// come back as 'succeeded' directly in the call to Create search service. This is
// because the free service uses capacity that is already set up.
type ProvisioningState string

const (
	// ProvisioningStateFailed - The last provisioning operation has failed.
	ProvisioningStateFailed ProvisioningState = "failed"
	// ProvisioningStateProvisioning - The search service is being provisioned or scaled up or down.
	ProvisioningStateProvisioning ProvisioningState = "provisioning"
	// ProvisioningStateSucceeded - The last provisioning operation has completed successfully.
	ProvisioningStateSucceeded ProvisioningState = "succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateFailed,
		ProvisioningStateProvisioning,
		ProvisioningStateSucceeded,
	}
}

// PublicNetworkAccess - This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates.
// If set to 'disabled', traffic over public interface is not allowed, and private endpoint
// connections would be the exclusive access method.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled - The search service is not accessible from traffic originating from the public internet. Access
	// is only permitted over approved private endpoint connections.
	PublicNetworkAccessDisabled PublicNetworkAccess = "disabled"
	// PublicNetworkAccessEnabled - The search service is accessible from traffic originating from the public internet.
	PublicNetworkAccessEnabled PublicNetworkAccess = "enabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
	}
}

// SKUName - The SKU of the search service. Valid values include: 'free': Shared service. 'basic': Dedicated service with
// up to 3 replicas. 'standard': Dedicated service with up to 12 partitions and 12 replicas.
// 'standard2': Similar to standard, but with more capacity per search unit. 'standard3': The largest Standard offering with
// up to 12 partitions and 12 replicas (or up to 3 partitions with more indexes
// if you also set the hostingMode property to 'highDensity'). 'storageoptimizedl1': Supports 1TB per partition, up to 12
// partitions. 'storageoptimizedl2': Supports 2TB per partition, up to 12
// partitions.'
type SKUName string

const (
	// SKUNameBasic - Billable tier for a dedicated service having up to 3 replicas.
	SKUNameBasic SKUName = "basic"
	// SKUNameFree - Free tier, with no SLA guarantees and a subset of the features offered on billable tiers.
	SKUNameFree SKUName = "free"
	// SKUNameStandard - Billable tier for a dedicated service having up to 12 partitions and 12 replicas.
	SKUNameStandard SKUName = "standard"
	// SKUNameStandard2 - Similar to 'standard', but with more capacity per search unit.
	SKUNameStandard2 SKUName = "standard2"
	// SKUNameStandard3 - The largest Standard offering with up to 12 partitions and 12 replicas (or up to 3 partitions with more
	// indexes if you also set the hostingMode property to 'highDensity').
	SKUNameStandard3 SKUName = "standard3"
	// SKUNameStorageOptimizedL1 - Billable tier for a dedicated service that supports 1TB per partition, up to 12 partitions.
	SKUNameStorageOptimizedL1 SKUName = "storage_optimized_l1"
	// SKUNameStorageOptimizedL2 - Billable tier for a dedicated service that supports 2TB per partition, up to 12 partitions.
	SKUNameStorageOptimizedL2 SKUName = "storage_optimized_l2"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameBasic,
		SKUNameFree,
		SKUNameStandard,
		SKUNameStandard2,
		SKUNameStandard3,
		SKUNameStorageOptimizedL1,
		SKUNameStorageOptimizedL2,
	}
}

// SearchBypass - Possible origins of inbound traffic that can bypass the rules defined in the 'ipRules' section.
type SearchBypass string

const (
	// SearchBypassAzurePortal - Indicates that requests originating from the Azure portal can bypass the rules defined in the
	// 'ipRules' section.
	SearchBypassAzurePortal SearchBypass = "AzurePortal"
	// SearchBypassNone - Indicates that no origin can bypass the rules defined in the 'ipRules' section. This is the default.
	SearchBypassNone SearchBypass = "None"
)

// PossibleSearchBypassValues returns the possible values for the SearchBypass const type.
func PossibleSearchBypassValues() []SearchBypass {
	return []SearchBypass{
		SearchBypassAzurePortal,
		SearchBypassNone,
	}
}

// SearchDisabledDataExfiltrationOption - A specific data exfiltration scenario that is disabled for the service.
type SearchDisabledDataExfiltrationOption string

const (
	// SearchDisabledDataExfiltrationOptionAll - Indicates that all data exfiltration scenarios are disabled.
	SearchDisabledDataExfiltrationOptionAll SearchDisabledDataExfiltrationOption = "All"
)

// PossibleSearchDisabledDataExfiltrationOptionValues returns the possible values for the SearchDisabledDataExfiltrationOption const type.
func PossibleSearchDisabledDataExfiltrationOptionValues() []SearchDisabledDataExfiltrationOption {
	return []SearchDisabledDataExfiltrationOption{
		SearchDisabledDataExfiltrationOptionAll,
	}
}

// SearchEncryptionComplianceStatus - Returns the status of search service compliance with respect to non-CMK-encrypted objects.
// If a service has more than one unencrypted object, and enforcement is enabled, the service is marked as
// noncompliant.
type SearchEncryptionComplianceStatus string

const (
	// SearchEncryptionComplianceStatusCompliant - Indicates that the search service is compliant, either because the number of
	// non-CMK-encrypted objects is zero or enforcement is disabled.
	SearchEncryptionComplianceStatusCompliant SearchEncryptionComplianceStatus = "Compliant"
	// SearchEncryptionComplianceStatusNonCompliant - Indicates that the search service has more than one non-CMK-encrypted objects.
	SearchEncryptionComplianceStatusNonCompliant SearchEncryptionComplianceStatus = "NonCompliant"
)

// PossibleSearchEncryptionComplianceStatusValues returns the possible values for the SearchEncryptionComplianceStatus const type.
func PossibleSearchEncryptionComplianceStatusValues() []SearchEncryptionComplianceStatus {
	return []SearchEncryptionComplianceStatus{
		SearchEncryptionComplianceStatusCompliant,
		SearchEncryptionComplianceStatusNonCompliant,
	}
}

// SearchEncryptionWithCmk - Describes how a search service should enforce compliance if it finds objects that aren't encrypted
// with the customer-managed key.
type SearchEncryptionWithCmk string

const (
	// SearchEncryptionWithCmkDisabled - No enforcement of customer-managed key encryption will be made. Only the built-in service-managed
	// encryption is used.
	SearchEncryptionWithCmkDisabled SearchEncryptionWithCmk = "Disabled"
	// SearchEncryptionWithCmkEnabled - Search service will be marked as non-compliant if one or more objects aren't encrypted
	// with a customer-managed key.
	SearchEncryptionWithCmkEnabled SearchEncryptionWithCmk = "Enabled"
	// SearchEncryptionWithCmkUnspecified - Enforcement policy is not explicitly specified, with the behavior being the same as
	// if it were set to 'Disabled'.
	SearchEncryptionWithCmkUnspecified SearchEncryptionWithCmk = "Unspecified"
)

// PossibleSearchEncryptionWithCmkValues returns the possible values for the SearchEncryptionWithCmk const type.
func PossibleSearchEncryptionWithCmkValues() []SearchEncryptionWithCmk {
	return []SearchEncryptionWithCmk{
		SearchEncryptionWithCmkDisabled,
		SearchEncryptionWithCmkEnabled,
		SearchEncryptionWithCmkUnspecified,
	}
}

// SearchSemanticSearch - Sets options that control the availability of semantic search. This configuration is only possible
// for certain Azure AI Search SKUs in certain locations.
type SearchSemanticSearch string

const (
	// SearchSemanticSearchDisabled - Indicates that semantic reranker is disabled for the search service. This is the default.
	SearchSemanticSearchDisabled SearchSemanticSearch = "disabled"
	// SearchSemanticSearchFree - Enables semantic reranker on a search service and indicates that it is to be used within the
	// limits of the free plan. The free plan would cap the volume of semantic ranking requests and is offered at no extra charge.
	// This is the default for newly provisioned search services.
	SearchSemanticSearchFree SearchSemanticSearch = "free"
	// SearchSemanticSearchStandard - Enables semantic reranker on a search service as a billable feature, with higher throughput
	// and volume of semantically reranked queries.
	SearchSemanticSearchStandard SearchSemanticSearch = "standard"
)

// PossibleSearchSemanticSearchValues returns the possible values for the SearchSemanticSearch const type.
func PossibleSearchSemanticSearchValues() []SearchSemanticSearch {
	return []SearchSemanticSearch{
		SearchSemanticSearchDisabled,
		SearchSemanticSearchFree,
		SearchSemanticSearchStandard,
	}
}

// SearchServiceStatus - The status of the search service. Possible values include: 'running': The search service is running
// and no provisioning operations are underway. 'provisioning': The search service is being provisioned
// or scaled up or down. 'deleting': The search service is being deleted. 'degraded': The search service is degraded. This
// can occur when the underlying search units are not healthy. The search service
// is most likely operational, but performance might be slow and some requests might be dropped. 'disabled': The search service
// is disabled. In this state, the service will reject all API requests.
// 'error': The search service is in an error state. 'stopped': The search service is in a subscription that's disabled. If
// your service is in the degraded, disabled, or error states, it means the Azure
// AI Search team is actively investigating the underlying issue. Dedicated services in these states are still chargeable
// based on the number of search units provisioned.
type SearchServiceStatus string

const (
	// SearchServiceStatusDegraded - The search service is degraded because underlying search units are not healthy.
	SearchServiceStatusDegraded SearchServiceStatus = "degraded"
	// SearchServiceStatusDeleting - The search service is being deleted.
	SearchServiceStatusDeleting SearchServiceStatus = "deleting"
	// SearchServiceStatusDisabled - The search service is disabled and all API requests will be rejected.
	SearchServiceStatusDisabled SearchServiceStatus = "disabled"
	// SearchServiceStatusError - The search service is in error state, indicating either a failure to provision or to be deleted.
	SearchServiceStatusError SearchServiceStatus = "error"
	// SearchServiceStatusProvisioning - The search service is being provisioned or scaled up or down.
	SearchServiceStatusProvisioning SearchServiceStatus = "provisioning"
	// SearchServiceStatusRunning - The search service is running and no provisioning operations are underway.
	SearchServiceStatusRunning SearchServiceStatus = "running"
	// SearchServiceStatusStopped - The search service is in a subscription that's disabled.
	SearchServiceStatusStopped SearchServiceStatus = "stopped"
)

// PossibleSearchServiceStatusValues returns the possible values for the SearchServiceStatus const type.
func PossibleSearchServiceStatusValues() []SearchServiceStatus {
	return []SearchServiceStatus{
		SearchServiceStatusDegraded,
		SearchServiceStatusDeleting,
		SearchServiceStatusDisabled,
		SearchServiceStatusError,
		SearchServiceStatusProvisioning,
		SearchServiceStatusRunning,
		SearchServiceStatusStopped,
	}
}

// SharedPrivateLinkResourceProvisioningState - The provisioning state of the shared private link resource. Valid values are
// Updating, Deleting, Failed, Succeeded or Incomplete.
type SharedPrivateLinkResourceProvisioningState string

const (
	// SharedPrivateLinkResourceProvisioningStateDeleting - The shared private link resource is in the process of being deleted.
	SharedPrivateLinkResourceProvisioningStateDeleting SharedPrivateLinkResourceProvisioningState = "Deleting"
	// SharedPrivateLinkResourceProvisioningStateFailed - The shared private link resource has failed to be provisioned or deleted.
	SharedPrivateLinkResourceProvisioningStateFailed SharedPrivateLinkResourceProvisioningState = "Failed"
	// SharedPrivateLinkResourceProvisioningStateIncomplete - Provisioning request for the shared private link resource has been
	// accepted but the process of creation has not commenced yet.
	SharedPrivateLinkResourceProvisioningStateIncomplete SharedPrivateLinkResourceProvisioningState = "Incomplete"
	// SharedPrivateLinkResourceProvisioningStateSucceeded - The shared private link resource has finished provisioning and is
	// ready for approval.
	SharedPrivateLinkResourceProvisioningStateSucceeded SharedPrivateLinkResourceProvisioningState = "Succeeded"
	// SharedPrivateLinkResourceProvisioningStateUpdating - The shared private link resource is in the process of being created
	// along with other resources for it to be fully functional.
	SharedPrivateLinkResourceProvisioningStateUpdating SharedPrivateLinkResourceProvisioningState = "Updating"
)

// PossibleSharedPrivateLinkResourceProvisioningStateValues returns the possible values for the SharedPrivateLinkResourceProvisioningState const type.
func PossibleSharedPrivateLinkResourceProvisioningStateValues() []SharedPrivateLinkResourceProvisioningState {
	return []SharedPrivateLinkResourceProvisioningState{
		SharedPrivateLinkResourceProvisioningStateDeleting,
		SharedPrivateLinkResourceProvisioningStateFailed,
		SharedPrivateLinkResourceProvisioningStateIncomplete,
		SharedPrivateLinkResourceProvisioningStateSucceeded,
		SharedPrivateLinkResourceProvisioningStateUpdating,
	}
}

// SharedPrivateLinkResourceStatus - Status of the shared private link resource. Valid values are Pending, Approved, Rejected
// or Disconnected.
type SharedPrivateLinkResourceStatus string

const (
	// SharedPrivateLinkResourceStatusApproved - The shared private link resource is approved and is ready for use.
	SharedPrivateLinkResourceStatusApproved SharedPrivateLinkResourceStatus = "Approved"
	// SharedPrivateLinkResourceStatusDisconnected - The shared private link resource has been removed from the service.
	SharedPrivateLinkResourceStatusDisconnected SharedPrivateLinkResourceStatus = "Disconnected"
	// SharedPrivateLinkResourceStatusPending - The shared private link resource has been created and is pending approval.
	SharedPrivateLinkResourceStatusPending SharedPrivateLinkResourceStatus = "Pending"
	// SharedPrivateLinkResourceStatusRejected - The shared private link resource has been rejected and cannot be used.
	SharedPrivateLinkResourceStatusRejected SharedPrivateLinkResourceStatus = "Rejected"
)

// PossibleSharedPrivateLinkResourceStatusValues returns the possible values for the SharedPrivateLinkResourceStatus const type.
func PossibleSharedPrivateLinkResourceStatusValues() []SharedPrivateLinkResourceStatus {
	return []SharedPrivateLinkResourceStatus{
		SharedPrivateLinkResourceStatusApproved,
		SharedPrivateLinkResourceStatusDisconnected,
		SharedPrivateLinkResourceStatusPending,
		SharedPrivateLinkResourceStatusRejected,
	}
}

// UnavailableNameReason - The reason why the name is not available. 'Invalid' indicates the name provided does not match
// the naming requirements (incorrect length, unsupported characters, etc.). 'AlreadyExists' indicates that
// the name is already in use and is therefore unavailable.
type UnavailableNameReason string

const (
	// UnavailableNameReasonAlreadyExists - The search service name is already assigned to a different search service.
	UnavailableNameReasonAlreadyExists UnavailableNameReason = "AlreadyExists"
	// UnavailableNameReasonInvalid - The search service name doesn't match naming requirements.
	UnavailableNameReasonInvalid UnavailableNameReason = "Invalid"
)

// PossibleUnavailableNameReasonValues returns the possible values for the UnavailableNameReason const type.
func PossibleUnavailableNameReasonValues() []UnavailableNameReason {
	return []UnavailableNameReason{
		UnavailableNameReasonAlreadyExists,
		UnavailableNameReasonInvalid,
	}
}
