//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnotificationhubs_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/notificationhubs/armnotificationhubs/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/CheckAvailability.json
func ExampleNamespacesClient_CheckAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().CheckAvailability(ctx, armnotificationhubs.CheckAvailabilityParameters{
		Name: to.Ptr("sdk-Namespace-2924"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckAvailabilityResult = armnotificationhubs.CheckAvailabilityResult{
	// 	Name: to.Ptr("sdk-Namespace-2924"),
	// 	Type: to.Ptr("Microsoft.NotificationHubs/namespaces/checkNamespaceAvailability"),
	// 	ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/providers/Microsoft.NotificationHubs/namespaces/sdk-Namespace-2924"),
	// 	IsAvailiable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/Get.json
func ExampleNamespacesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().Get(ctx, "5ktrial", "nh-sdk-ns", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NamespaceResource = armnotificationhubs.NamespaceResource{
	// 	Name: to.Ptr("nh-sdk-ns"),
	// 	Type: to.Ptr("Microsoft.NotificationHubs/namespaces"),
	// 	ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/nh-sdk-ns"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armnotificationhubs.NamespaceProperties{
	// 		Name: to.Ptr("nh-sdk-ns"),
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.010Z"); return t}()),
	// 		Critical: to.Ptr(false),
	// 		Enabled: to.Ptr(true),
	// 		NamespaceType: to.Ptr(armnotificationhubs.NamespaceTypeNotificationHub),
	// 		NetworkACLs: &armnotificationhubs.NetworkACLs{
	// 			IPRules: []*armnotificationhubs.IPRule{
	// 				{
	// 					IPMask: to.Ptr("185.48.100.00/24"),
	// 					Rights: []*armnotificationhubs.AccessRights{
	// 						to.Ptr(armnotificationhubs.AccessRightsManage),
	// 						to.Ptr(armnotificationhubs.AccessRightsSend),
	// 						to.Ptr(armnotificationhubs.AccessRightsListen)},
	// 				}},
	// 				PublicNetworkRule: &armnotificationhubs.PublicInternetAuthorizationRule{
	// 					Rights: []*armnotificationhubs.AccessRights{
	// 						to.Ptr(armnotificationhubs.AccessRightsListen)},
	// 					},
	// 				},
	// 				PrivateEndpointConnections: []*armnotificationhubs.PrivateEndpointConnectionResource{
	// 				},
	// 				ProvisioningState: to.Ptr(armnotificationhubs.OperationProvisioningStateSucceeded),
	// 				PublicNetworkAccess: to.Ptr(armnotificationhubs.PublicNetworkAccessEnabled),
	// 				ServiceBusEndpoint: to.Ptr("https://nh-sdk-ns.servicebus.windows.net:443/"),
	// 				Status: to.Ptr(armnotificationhubs.NamespaceStatusCreated),
	// 				SubscriptionID: to.Ptr("29cfa613-cbbc-4512-b1d6-1b3a92c7fa40"),
	// 				UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.030Z"); return t}()),
	// 			},
	// 			SKU: &armnotificationhubs.SKU{
	// 				Name: to.Ptr(armnotificationhubs.SKUNameStandard),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/CreateOrUpdate.json
func ExampleNamespacesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewNamespacesClient().BeginCreateOrUpdate(ctx, "5ktrial", "nh-sdk-ns", armnotificationhubs.NamespaceResource{
		Location: to.Ptr("South Central US"),
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
		Properties: &armnotificationhubs.NamespaceProperties{
			NetworkACLs: &armnotificationhubs.NetworkACLs{
				IPRules: []*armnotificationhubs.IPRule{
					{
						IPMask: to.Ptr("185.48.100.00/24"),
						Rights: []*armnotificationhubs.AccessRights{
							to.Ptr(armnotificationhubs.AccessRightsManage),
							to.Ptr(armnotificationhubs.AccessRightsSend),
							to.Ptr(armnotificationhubs.AccessRightsListen)},
					}},
				PublicNetworkRule: &armnotificationhubs.PublicInternetAuthorizationRule{
					Rights: []*armnotificationhubs.AccessRights{
						to.Ptr(armnotificationhubs.AccessRightsListen)},
				},
			},
			ZoneRedundancy: to.Ptr(armnotificationhubs.ZoneRedundancyPreferenceEnabled),
		},
		SKU: &armnotificationhubs.SKU{
			Name: to.Ptr(armnotificationhubs.SKUNameStandard),
			Tier: to.Ptr("Standard"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NamespaceResource = armnotificationhubs.NamespaceResource{
	// 	Name: to.Ptr("nh-sdk-ns"),
	// 	Type: to.Ptr("Microsoft.NotificationHubs/namespaces"),
	// 	ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/nh-sdk-ns"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armnotificationhubs.NamespaceProperties{
	// 		Name: to.Ptr("nh-sdk-ns"),
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.010Z"); return t}()),
	// 		Critical: to.Ptr(false),
	// 		Enabled: to.Ptr(true),
	// 		NamespaceType: to.Ptr(armnotificationhubs.NamespaceTypeNotificationHub),
	// 		NetworkACLs: &armnotificationhubs.NetworkACLs{
	// 			IPRules: []*armnotificationhubs.IPRule{
	// 				{
	// 					IPMask: to.Ptr("185.48.100.00/24"),
	// 					Rights: []*armnotificationhubs.AccessRights{
	// 						to.Ptr(armnotificationhubs.AccessRightsManage),
	// 						to.Ptr(armnotificationhubs.AccessRightsSend),
	// 						to.Ptr(armnotificationhubs.AccessRightsListen)},
	// 				}},
	// 				PublicNetworkRule: &armnotificationhubs.PublicInternetAuthorizationRule{
	// 					Rights: []*armnotificationhubs.AccessRights{
	// 						to.Ptr(armnotificationhubs.AccessRightsListen)},
	// 					},
	// 				},
	// 				PrivateEndpointConnections: []*armnotificationhubs.PrivateEndpointConnectionResource{
	// 				},
	// 				ProvisioningState: to.Ptr(armnotificationhubs.OperationProvisioningStateSucceeded),
	// 				PublicNetworkAccess: to.Ptr(armnotificationhubs.PublicNetworkAccessEnabled),
	// 				ServiceBusEndpoint: to.Ptr("https://nh-sdk-ns.servicebus.windows.net:443/"),
	// 				Status: to.Ptr(armnotificationhubs.NamespaceStatusCreated),
	// 				SubscriptionID: to.Ptr("29cfa613-cbbc-4512-b1d6-1b3a92c7fa40"),
	// 				UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:16:17.697Z"); return t}()),
	// 				ZoneRedundancy: to.Ptr(armnotificationhubs.ZoneRedundancyPreferenceEnabled),
	// 			},
	// 			SKU: &armnotificationhubs.SKU{
	// 				Name: to.Ptr(armnotificationhubs.SKUNameStandard),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/Update.json
func ExampleNamespacesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().Update(ctx, "5ktrial", "nh-sdk-ns", armnotificationhubs.NamespacePatchParameters{
		Properties: &armnotificationhubs.NamespaceProperties{
			PnsCredentials: &armnotificationhubs.PnsCredentials{
				GCMCredential: &armnotificationhubs.GCMCredential{
					Properties: &armnotificationhubs.GCMCredentialProperties{
						GCMEndpoint:  to.Ptr("https://fcm.googleapis.com/fcm/send"),
						GoogleAPIKey: to.Ptr("#############################"),
					},
				},
			},
		},
		SKU: &armnotificationhubs.SKU{
			Name: to.Ptr(armnotificationhubs.SKUNameFree),
		},
		Tags: map[string]*string{
			"tag1": to.Ptr("value3"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NamespaceResource = armnotificationhubs.NamespaceResource{
	// 	Name: to.Ptr("nh-sdk-ns"),
	// 	Type: to.Ptr("Microsoft.NotificationHubs/namespaces"),
	// 	ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/nh-sdk-ns"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value3"),
	// 	},
	// 	Properties: &armnotificationhubs.NamespaceProperties{
	// 		Name: to.Ptr("nh-sdk-ns"),
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.010Z"); return t}()),
	// 		Critical: to.Ptr(false),
	// 		Enabled: to.Ptr(true),
	// 		NamespaceType: to.Ptr(armnotificationhubs.NamespaceTypeNotificationHub),
	// 		NetworkACLs: &armnotificationhubs.NetworkACLs{
	// 			IPRules: []*armnotificationhubs.IPRule{
	// 				{
	// 					IPMask: to.Ptr("185.48.100.00/24"),
	// 					Rights: []*armnotificationhubs.AccessRights{
	// 						to.Ptr(armnotificationhubs.AccessRightsManage),
	// 						to.Ptr(armnotificationhubs.AccessRightsSend),
	// 						to.Ptr(armnotificationhubs.AccessRightsListen)},
	// 				}},
	// 				PublicNetworkRule: &armnotificationhubs.PublicInternetAuthorizationRule{
	// 					Rights: []*armnotificationhubs.AccessRights{
	// 						to.Ptr(armnotificationhubs.AccessRightsListen)},
	// 					},
	// 				},
	// 				PrivateEndpointConnections: []*armnotificationhubs.PrivateEndpointConnectionResource{
	// 				},
	// 				ProvisioningState: to.Ptr(armnotificationhubs.OperationProvisioningStateSucceeded),
	// 				PublicNetworkAccess: to.Ptr(armnotificationhubs.PublicNetworkAccessEnabled),
	// 				ServiceBusEndpoint: to.Ptr("https://nh-sdk-ns.servicebus.windows.net:443/"),
	// 				Status: to.Ptr(armnotificationhubs.NamespaceStatusCreated),
	// 				SubscriptionID: to.Ptr("29cfa613-cbbc-4512-b1d6-1b3a92c7fa40"),
	// 				UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.030Z"); return t}()),
	// 			},
	// 			SKU: &armnotificationhubs.SKU{
	// 				Name: to.Ptr(armnotificationhubs.SKUNameFree),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/Delete.json
func ExampleNamespacesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewNamespacesClient().Delete(ctx, "5ktrial", "nh-sdk-ns", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/ListBySubscription.json
func ExampleNamespacesClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNamespacesClient().NewListAllPager(&armnotificationhubs.NamespacesClientListAllOptions{SkipToken: nil,
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NamespaceListResult = armnotificationhubs.NamespaceListResult{
		// 	Value: []*armnotificationhubs.NamespaceResource{
		// 		{
		// 			Name: to.Ptr("namespace-2"),
		// 			Type: to.Ptr("Microsoft.NotificationHubs/namespaces"),
		// 			ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/namespace-1"),
		// 			Location: to.Ptr("East US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armnotificationhubs.NamespaceProperties{
		// 				Name: to.Ptr("namespace-1"),
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.010Z"); return t}()),
		// 				Critical: to.Ptr(false),
		// 				Enabled: to.Ptr(true),
		// 				NamespaceType: to.Ptr(armnotificationhubs.NamespaceTypeNotificationHub),
		// 				NetworkACLs: &armnotificationhubs.NetworkACLs{
		// 					IPRules: []*armnotificationhubs.IPRule{
		// 						{
		// 							IPMask: to.Ptr("185.48.100.00/24"),
		// 							Rights: []*armnotificationhubs.AccessRights{
		// 								to.Ptr(armnotificationhubs.AccessRightsManage),
		// 								to.Ptr(armnotificationhubs.AccessRightsSend),
		// 								to.Ptr(armnotificationhubs.AccessRightsListen)},
		// 						}},
		// 						PublicNetworkRule: &armnotificationhubs.PublicInternetAuthorizationRule{
		// 							Rights: []*armnotificationhubs.AccessRights{
		// 								to.Ptr(armnotificationhubs.AccessRightsListen)},
		// 							},
		// 						},
		// 						PrivateEndpointConnections: []*armnotificationhubs.PrivateEndpointConnectionResource{
		// 						},
		// 						ProvisioningState: to.Ptr(armnotificationhubs.OperationProvisioningStateSucceeded),
		// 						PublicNetworkAccess: to.Ptr(armnotificationhubs.PublicNetworkAccessEnabled),
		// 						ServiceBusEndpoint: to.Ptr("https://namespace-1.servicebus.windows.net:443/"),
		// 						Status: to.Ptr(armnotificationhubs.NamespaceStatusCreated),
		// 						SubscriptionID: to.Ptr("29cfa613-cbbc-4512-b1d6-1b3a92c7fa40"),
		// 						UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.030Z"); return t}()),
		// 					},
		// 					SKU: &armnotificationhubs.SKU{
		// 						Name: to.Ptr(armnotificationhubs.SKUNameStandard),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("namespace-2"),
		// 					Type: to.Ptr("Microsoft.NotificationHubs/namespaces"),
		// 					ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/namespace-2"),
		// 					Location: to.Ptr("East US"),
		// 					Tags: map[string]*string{
		// 						"tag1": to.Ptr("value1"),
		// 						"tag2": to.Ptr("value2"),
		// 					},
		// 					Properties: &armnotificationhubs.NamespaceProperties{
		// 						Name: to.Ptr("namespace-2"),
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.010Z"); return t}()),
		// 						Critical: to.Ptr(false),
		// 						Enabled: to.Ptr(true),
		// 						NamespaceType: to.Ptr(armnotificationhubs.NamespaceTypeNotificationHub),
		// 						NetworkACLs: &armnotificationhubs.NetworkACLs{
		// 							IPRules: []*armnotificationhubs.IPRule{
		// 							},
		// 							PublicNetworkRule: &armnotificationhubs.PublicInternetAuthorizationRule{
		// 								Rights: []*armnotificationhubs.AccessRights{
		// 									to.Ptr(armnotificationhubs.AccessRightsManage),
		// 									to.Ptr(armnotificationhubs.AccessRightsListen),
		// 									to.Ptr(armnotificationhubs.AccessRightsSend)},
		// 								},
		// 							},
		// 							PrivateEndpointConnections: []*armnotificationhubs.PrivateEndpointConnectionResource{
		// 							},
		// 							ProvisioningState: to.Ptr(armnotificationhubs.OperationProvisioningStateSucceeded),
		// 							PublicNetworkAccess: to.Ptr(armnotificationhubs.PublicNetworkAccessEnabled),
		// 							ServiceBusEndpoint: to.Ptr("https://namespace-2.servicebus.windows.net:443/"),
		// 							Status: to.Ptr(armnotificationhubs.NamespaceStatusCreated),
		// 							SubscriptionID: to.Ptr("29cfa613-cbbc-4512-b1d6-1b3a92c7fa40"),
		// 							UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.030Z"); return t}()),
		// 						},
		// 						SKU: &armnotificationhubs.SKU{
		// 							Name: to.Ptr(armnotificationhubs.SKUNameStandard),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/ListByResourceGroup.json
func ExampleNamespacesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNamespacesClient().NewListPager("5ktrial", &armnotificationhubs.NamespacesClientListOptions{SkipToken: nil,
		Top: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NamespaceListResult = armnotificationhubs.NamespaceListResult{
		// 	Value: []*armnotificationhubs.NamespaceResource{
		// 		{
		// 			Name: to.Ptr("namespace-2"),
		// 			Type: to.Ptr("Microsoft.NotificationHubs/namespaces"),
		// 			ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/namespace-1"),
		// 			Location: to.Ptr("East US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armnotificationhubs.NamespaceProperties{
		// 				Name: to.Ptr("namespace-1"),
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.010Z"); return t}()),
		// 				Critical: to.Ptr(false),
		// 				Enabled: to.Ptr(true),
		// 				NamespaceType: to.Ptr(armnotificationhubs.NamespaceTypeNotificationHub),
		// 				NetworkACLs: &armnotificationhubs.NetworkACLs{
		// 					IPRules: []*armnotificationhubs.IPRule{
		// 						{
		// 							IPMask: to.Ptr("185.48.100.00/24"),
		// 							Rights: []*armnotificationhubs.AccessRights{
		// 								to.Ptr(armnotificationhubs.AccessRightsManage),
		// 								to.Ptr(armnotificationhubs.AccessRightsSend),
		// 								to.Ptr(armnotificationhubs.AccessRightsListen)},
		// 						}},
		// 						PublicNetworkRule: &armnotificationhubs.PublicInternetAuthorizationRule{
		// 							Rights: []*armnotificationhubs.AccessRights{
		// 								to.Ptr(armnotificationhubs.AccessRightsListen)},
		// 							},
		// 						},
		// 						PrivateEndpointConnections: []*armnotificationhubs.PrivateEndpointConnectionResource{
		// 						},
		// 						ProvisioningState: to.Ptr(armnotificationhubs.OperationProvisioningStateSucceeded),
		// 						PublicNetworkAccess: to.Ptr(armnotificationhubs.PublicNetworkAccessEnabled),
		// 						ServiceBusEndpoint: to.Ptr("https://namespace-1.servicebus.windows.net:443/"),
		// 						Status: to.Ptr(armnotificationhubs.NamespaceStatusCreated),
		// 						SubscriptionID: to.Ptr("29cfa613-cbbc-4512-b1d6-1b3a92c7fa40"),
		// 						UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.030Z"); return t}()),
		// 					},
		// 					SKU: &armnotificationhubs.SKU{
		// 						Name: to.Ptr(armnotificationhubs.SKUNameStandard),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("namespace-2"),
		// 					Type: to.Ptr("Microsoft.NotificationHubs/namespaces"),
		// 					ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/namespace-2"),
		// 					Location: to.Ptr("East US"),
		// 					Tags: map[string]*string{
		// 						"tag1": to.Ptr("value1"),
		// 						"tag2": to.Ptr("value2"),
		// 					},
		// 					Properties: &armnotificationhubs.NamespaceProperties{
		// 						Name: to.Ptr("namespace-2"),
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.010Z"); return t}()),
		// 						Critical: to.Ptr(false),
		// 						Enabled: to.Ptr(true),
		// 						NamespaceType: to.Ptr(armnotificationhubs.NamespaceTypeNotificationHub),
		// 						NetworkACLs: &armnotificationhubs.NetworkACLs{
		// 							IPRules: []*armnotificationhubs.IPRule{
		// 							},
		// 							PublicNetworkRule: &armnotificationhubs.PublicInternetAuthorizationRule{
		// 								Rights: []*armnotificationhubs.AccessRights{
		// 									to.Ptr(armnotificationhubs.AccessRightsManage),
		// 									to.Ptr(armnotificationhubs.AccessRightsListen),
		// 									to.Ptr(armnotificationhubs.AccessRightsSend)},
		// 								},
		// 							},
		// 							PrivateEndpointConnections: []*armnotificationhubs.PrivateEndpointConnectionResource{
		// 							},
		// 							ProvisioningState: to.Ptr(armnotificationhubs.OperationProvisioningStateSucceeded),
		// 							PublicNetworkAccess: to.Ptr(armnotificationhubs.PublicNetworkAccessEnabled),
		// 							ServiceBusEndpoint: to.Ptr("https://namespace-2.servicebus.windows.net:443/"),
		// 							Status: to.Ptr(armnotificationhubs.NamespaceStatusCreated),
		// 							SubscriptionID: to.Ptr("29cfa613-cbbc-4512-b1d6-1b3a92c7fa40"),
		// 							UpdatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.030Z"); return t}()),
		// 						},
		// 						SKU: &armnotificationhubs.SKU{
		// 							Name: to.Ptr(armnotificationhubs.SKUNameStandard),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/AuthorizationRuleCreateOrUpdate.json
func ExampleNamespacesClient_CreateOrUpdateAuthorizationRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().CreateOrUpdateAuthorizationRule(ctx, "5ktrial", "nh-sdk-ns", "sdk-AuthRules-1788", armnotificationhubs.SharedAccessAuthorizationRuleResource{
		Properties: &armnotificationhubs.SharedAccessAuthorizationRuleProperties{
			Rights: []*armnotificationhubs.AccessRights{
				to.Ptr(armnotificationhubs.AccessRightsListen),
				to.Ptr(armnotificationhubs.AccessRightsSend)},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SharedAccessAuthorizationRuleResource = armnotificationhubs.SharedAccessAuthorizationRuleResource{
	// 	Name: to.Ptr("NewAuthorizationRule"),
	// 	Type: to.Ptr("Microsoft.NotificationHubs/namespaces/authorizationRules"),
	// 	ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/nh-sdk-ns/authorizationRules/NewAuthorizationRule"),
	// 	Properties: &armnotificationhubs.SharedAccessAuthorizationRuleProperties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T10:09:19.967Z"); return t}()),
	// 		ModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T10:09:19.967Z"); return t}()),
	// 		Rights: []*armnotificationhubs.AccessRights{
	// 			to.Ptr(armnotificationhubs.AccessRightsListen),
	// 			to.Ptr(armnotificationhubs.AccessRightsSend)},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/AuthorizationRuleDelete.json
func ExampleNamespacesClient_DeleteAuthorizationRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewNamespacesClient().DeleteAuthorizationRule(ctx, "5ktrial", "nh-sdk-ns", "RootManageSharedAccessKey", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/AuthorizationRuleGet.json
func ExampleNamespacesClient_GetAuthorizationRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().GetAuthorizationRule(ctx, "5ktrial", "nh-sdk-ns", "RootManageSharedAccessKey", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SharedAccessAuthorizationRuleResource = armnotificationhubs.SharedAccessAuthorizationRuleResource{
	// 	Name: to.Ptr("RootManageSharedAccessKey"),
	// 	Type: to.Ptr("Microsoft.NotificationHubs/namespaces/authorizationRules"),
	// 	ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/nh-sdk-ns/authorizationRules/RootManageSharedAccessKey"),
	// 	Properties: &armnotificationhubs.SharedAccessAuthorizationRuleProperties{
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T10:19:36.331Z"); return t}()),
	// 		ModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T10:19:36.331Z"); return t}()),
	// 		Rights: []*armnotificationhubs.AccessRights{
	// 			to.Ptr(armnotificationhubs.AccessRightsManage),
	// 			to.Ptr(armnotificationhubs.AccessRightsListen),
	// 			to.Ptr(armnotificationhubs.AccessRightsSend)},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/AuthorizationRuleList.json
func ExampleNamespacesClient_NewListAuthorizationRulesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNamespacesClient().NewListAuthorizationRulesPager("5ktrial", "nh-sdk-ns", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SharedAccessAuthorizationRuleListResult = armnotificationhubs.SharedAccessAuthorizationRuleListResult{
		// 	Value: []*armnotificationhubs.SharedAccessAuthorizationRuleResource{
		// 		{
		// 			Name: to.Ptr("RootManageSharedAccessKey"),
		// 			Type: to.Ptr("Microsoft.NotificationHubs/namespaces/authorizationRules"),
		// 			ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/nh-sdk-ns/authorizationRules/RootManageSharedAccessKey"),
		// 			Properties: &armnotificationhubs.SharedAccessAuthorizationRuleProperties{
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.040Z"); return t}()),
		// 				ModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T06:10:44.040Z"); return t}()),
		// 				Rights: []*armnotificationhubs.AccessRights{
		// 					to.Ptr(armnotificationhubs.AccessRightsManage),
		// 					to.Ptr(armnotificationhubs.AccessRightsListen),
		// 					to.Ptr(armnotificationhubs.AccessRightsSend)},
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("NewAuthorizationRule"),
		// 				Type: to.Ptr("Microsoft.NotificationHubs/namespaces/authorizationRules"),
		// 				ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/nh-sdk-ns/authorizationRules/NewAuthorizationRule"),
		// 				Properties: &armnotificationhubs.SharedAccessAuthorizationRuleProperties{
		// 					CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T10:09:19.967Z"); return t}()),
		// 					ModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-04-26T10:09:19.967Z"); return t}()),
		// 					Rights: []*armnotificationhubs.AccessRights{
		// 						to.Ptr(armnotificationhubs.AccessRightsListen),
		// 						to.Ptr(armnotificationhubs.AccessRightsSend)},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/AuthorizationRuleListKeys.json
func ExampleNamespacesClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().ListKeys(ctx, "5ktrial", "nh-sdk-ns", "RootManageSharedAccessKey", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceListKeys = armnotificationhubs.ResourceListKeys{
	// 	KeyName: to.Ptr("RootManageSharedAccessKey"),
	// 	PrimaryConnectionString: to.Ptr("Endpoint=sb://nh-sdk-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=############################################"),
	// 	PrimaryKey: to.Ptr("############################################"),
	// 	SecondaryConnectionString: to.Ptr("Endpoint=sb://nh-sdk-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=############################################"),
	// 	SecondaryKey: to.Ptr("############################################"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/AuthorizationRuleRegenerateKey.json
func ExampleNamespacesClient_RegenerateKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().RegenerateKeys(ctx, "5ktrial", "nh-sdk-ns", "RootManageSharedAccessKey", armnotificationhubs.PolicyKeyResource{
		PolicyKey: to.Ptr(armnotificationhubs.PolicyKeyTypePrimaryKey),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceListKeys = armnotificationhubs.ResourceListKeys{
	// 	KeyName: to.Ptr("RootManageSharedAccessKey"),
	// 	PrimaryConnectionString: to.Ptr("Endpoint=sb://nh-sdk-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=########################################"),
	// 	PrimaryKey: to.Ptr("########################################"),
	// 	SecondaryConnectionString: to.Ptr("Endpoint=sb://nh-sdk-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=########################################"),
	// 	SecondaryKey: to.Ptr("########################################"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/85cfba195a19120f309bd292c4261aa53a586adb/specification/notificationhubs/resource-manager/Microsoft.NotificationHubs/preview/2023-10-01-preview/examples/Namespaces/PnsCredentialsGet.json
func ExampleNamespacesClient_GetPnsCredentials() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnotificationhubs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNamespacesClient().GetPnsCredentials(ctx, "5ktrial", "nh-sdk-ns", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PnsCredentialsResource = armnotificationhubs.PnsCredentialsResource{
	// 	Name: to.Ptr("nh-sdk-hub"),
	// 	Type: to.Ptr("Microsoft.NotificationHubs/namespaces/pnsCredentials"),
	// 	ID: to.Ptr("/subscriptions/29cfa613-cbbc-4512-b1d6-1b3a92c7fa40/resourceGroups/5ktrial/providers/Microsoft.NotificationHubs/namespaces/nh-sdk-ns"),
	// 	Properties: &armnotificationhubs.PnsCredentials{
	// 		MpnsCredential: &armnotificationhubs.MpnsCredential{
	// 			Properties: &armnotificationhubs.MpnsCredentialProperties{
	// 				Thumbprint: to.Ptr("#################################"),
	// 			},
	// 		},
	// 	},
	// }
}
