//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
	"net/http"
	"net/url"
	"regexp"
)

// ExpressRouteCrossConnectionsServer is a fake server for instances of the armnetwork.ExpressRouteCrossConnectionsClient type.
type ExpressRouteCrossConnectionsServer struct {
	// BeginCreateOrUpdate is the fake for method ExpressRouteCrossConnectionsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, crossConnectionName string, parameters armnetwork.ExpressRouteCrossConnection, options *armnetwork.ExpressRouteCrossConnectionsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ExpressRouteCrossConnectionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, crossConnectionName string, options *armnetwork.ExpressRouteCrossConnectionsClientGetOptions) (resp azfake.Responder[armnetwork.ExpressRouteCrossConnectionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ExpressRouteCrossConnectionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armnetwork.ExpressRouteCrossConnectionsClientListOptions) (resp azfake.PagerResponder[armnetwork.ExpressRouteCrossConnectionsClientListResponse])

	// BeginListArpTable is the fake for method ExpressRouteCrossConnectionsClient.BeginListArpTable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListArpTable func(ctx context.Context, resourceGroupName string, crossConnectionName string, peeringName string, devicePath string, options *armnetwork.ExpressRouteCrossConnectionsClientBeginListArpTableOptions) (resp azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListArpTableResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method ExpressRouteCrossConnectionsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armnetwork.ExpressRouteCrossConnectionsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armnetwork.ExpressRouteCrossConnectionsClientListByResourceGroupResponse])

	// BeginListRoutesTable is the fake for method ExpressRouteCrossConnectionsClient.BeginListRoutesTable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListRoutesTable func(ctx context.Context, resourceGroupName string, crossConnectionName string, peeringName string, devicePath string, options *armnetwork.ExpressRouteCrossConnectionsClientBeginListRoutesTableOptions) (resp azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListRoutesTableResponse], errResp azfake.ErrorResponder)

	// BeginListRoutesTableSummary is the fake for method ExpressRouteCrossConnectionsClient.BeginListRoutesTableSummary
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListRoutesTableSummary func(ctx context.Context, resourceGroupName string, crossConnectionName string, peeringName string, devicePath string, options *armnetwork.ExpressRouteCrossConnectionsClientBeginListRoutesTableSummaryOptions) (resp azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListRoutesTableSummaryResponse], errResp azfake.ErrorResponder)

	// UpdateTags is the fake for method ExpressRouteCrossConnectionsClient.UpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	UpdateTags func(ctx context.Context, resourceGroupName string, crossConnectionName string, crossConnectionParameters armnetwork.TagsObject, options *armnetwork.ExpressRouteCrossConnectionsClientUpdateTagsOptions) (resp azfake.Responder[armnetwork.ExpressRouteCrossConnectionsClientUpdateTagsResponse], errResp azfake.ErrorResponder)
}

// NewExpressRouteCrossConnectionsServerTransport creates a new instance of ExpressRouteCrossConnectionsServerTransport with the provided implementation.
// The returned ExpressRouteCrossConnectionsServerTransport instance is connected to an instance of armnetwork.ExpressRouteCrossConnectionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExpressRouteCrossConnectionsServerTransport(srv *ExpressRouteCrossConnectionsServer) *ExpressRouteCrossConnectionsServerTransport {
	return &ExpressRouteCrossConnectionsServerTransport{
		srv:                         srv,
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientCreateOrUpdateResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armnetwork.ExpressRouteCrossConnectionsClientListResponse]](),
		beginListArpTable:           newTracker[azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListArpTableResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armnetwork.ExpressRouteCrossConnectionsClientListByResourceGroupResponse]](),
		beginListRoutesTable:        newTracker[azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListRoutesTableResponse]](),
		beginListRoutesTableSummary: newTracker[azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListRoutesTableSummaryResponse]](),
	}
}

// ExpressRouteCrossConnectionsServerTransport connects instances of armnetwork.ExpressRouteCrossConnectionsClient to instances of ExpressRouteCrossConnectionsServer.
// Don't use this type directly, use NewExpressRouteCrossConnectionsServerTransport instead.
type ExpressRouteCrossConnectionsServerTransport struct {
	srv                         *ExpressRouteCrossConnectionsServer
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientCreateOrUpdateResponse]]
	newListPager                *tracker[azfake.PagerResponder[armnetwork.ExpressRouteCrossConnectionsClientListResponse]]
	beginListArpTable           *tracker[azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListArpTableResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armnetwork.ExpressRouteCrossConnectionsClientListByResourceGroupResponse]]
	beginListRoutesTable        *tracker[azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListRoutesTableResponse]]
	beginListRoutesTableSummary *tracker[azfake.PollerResponder[armnetwork.ExpressRouteCrossConnectionsClientListRoutesTableSummaryResponse]]
}

// Do implements the policy.Transporter interface for ExpressRouteCrossConnectionsServerTransport.
func (e *ExpressRouteCrossConnectionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExpressRouteCrossConnectionsClient.BeginCreateOrUpdate":
		resp, err = e.dispatchBeginCreateOrUpdate(req)
	case "ExpressRouteCrossConnectionsClient.Get":
		resp, err = e.dispatchGet(req)
	case "ExpressRouteCrossConnectionsClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	case "ExpressRouteCrossConnectionsClient.BeginListArpTable":
		resp, err = e.dispatchBeginListArpTable(req)
	case "ExpressRouteCrossConnectionsClient.NewListByResourceGroupPager":
		resp, err = e.dispatchNewListByResourceGroupPager(req)
	case "ExpressRouteCrossConnectionsClient.BeginListRoutesTable":
		resp, err = e.dispatchBeginListRoutesTable(req)
	case "ExpressRouteCrossConnectionsClient.BeginListRoutesTableSummary":
		resp, err = e.dispatchBeginListRoutesTableSummary(req)
	case "ExpressRouteCrossConnectionsClient.UpdateTags":
		resp, err = e.dispatchUpdateTags(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExpressRouteCrossConnectionsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := e.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteCrossConnections/(?P<crossConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.ExpressRouteCrossConnection](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		crossConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("crossConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, crossConnectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		e.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		e.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (e *ExpressRouteCrossConnectionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteCrossConnections/(?P<crossConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	crossConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("crossConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, crossConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExpressRouteCrossConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExpressRouteCrossConnectionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteCrossConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := e.srv.NewListPager(nil)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetwork.ExpressRouteCrossConnectionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}

func (e *ExpressRouteCrossConnectionsServerTransport) dispatchBeginListArpTable(req *http.Request) (*http.Response, error) {
	if e.srv.BeginListArpTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListArpTable not implemented")}
	}
	beginListArpTable := e.beginListArpTable.get(req)
	if beginListArpTable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteCrossConnections/(?P<crossConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/peerings/(?P<peeringName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/arpTables/(?P<devicePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		crossConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("crossConnectionName")])
		if err != nil {
			return nil, err
		}
		peeringNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringName")])
		if err != nil {
			return nil, err
		}
		devicePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("devicePath")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginListArpTable(req.Context(), resourceGroupNameParam, crossConnectionNameParam, peeringNameParam, devicePathParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListArpTable = &respr
		e.beginListArpTable.add(req, beginListArpTable)
	}

	resp, err := server.PollerResponderNext(beginListArpTable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginListArpTable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListArpTable) {
		e.beginListArpTable.remove(req)
	}

	return resp, nil
}

func (e *ExpressRouteCrossConnectionsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := e.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteCrossConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		e.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armnetwork.ExpressRouteCrossConnectionsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		e.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (e *ExpressRouteCrossConnectionsServerTransport) dispatchBeginListRoutesTable(req *http.Request) (*http.Response, error) {
	if e.srv.BeginListRoutesTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListRoutesTable not implemented")}
	}
	beginListRoutesTable := e.beginListRoutesTable.get(req)
	if beginListRoutesTable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteCrossConnections/(?P<crossConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/peerings/(?P<peeringName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routeTables/(?P<devicePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		crossConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("crossConnectionName")])
		if err != nil {
			return nil, err
		}
		peeringNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringName")])
		if err != nil {
			return nil, err
		}
		devicePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("devicePath")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginListRoutesTable(req.Context(), resourceGroupNameParam, crossConnectionNameParam, peeringNameParam, devicePathParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListRoutesTable = &respr
		e.beginListRoutesTable.add(req, beginListRoutesTable)
	}

	resp, err := server.PollerResponderNext(beginListRoutesTable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginListRoutesTable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListRoutesTable) {
		e.beginListRoutesTable.remove(req)
	}

	return resp, nil
}

func (e *ExpressRouteCrossConnectionsServerTransport) dispatchBeginListRoutesTableSummary(req *http.Request) (*http.Response, error) {
	if e.srv.BeginListRoutesTableSummary == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListRoutesTableSummary not implemented")}
	}
	beginListRoutesTableSummary := e.beginListRoutesTableSummary.get(req)
	if beginListRoutesTableSummary == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteCrossConnections/(?P<crossConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/peerings/(?P<peeringName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/routeTablesSummary/(?P<devicePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		crossConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("crossConnectionName")])
		if err != nil {
			return nil, err
		}
		peeringNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringName")])
		if err != nil {
			return nil, err
		}
		devicePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("devicePath")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginListRoutesTableSummary(req.Context(), resourceGroupNameParam, crossConnectionNameParam, peeringNameParam, devicePathParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListRoutesTableSummary = &respr
		e.beginListRoutesTableSummary.add(req, beginListRoutesTableSummary)
	}

	resp, err := server.PollerResponderNext(beginListRoutesTableSummary, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		e.beginListRoutesTableSummary.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListRoutesTableSummary) {
		e.beginListRoutesTableSummary.remove(req)
	}

	return resp, nil
}

func (e *ExpressRouteCrossConnectionsServerTransport) dispatchUpdateTags(req *http.Request) (*http.Response, error) {
	if e.srv.UpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateTags not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/expressRouteCrossConnections/(?P<crossConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.TagsObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	crossConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("crossConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.UpdateTags(req.Context(), resourceGroupNameParam, crossConnectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExpressRouteCrossConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
