//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/ExpressRouteProviderList.json
func ExampleExpressRouteServiceProvidersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewExpressRouteServiceProvidersClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ExpressRouteServiceProviderListResult = armnetwork.ExpressRouteServiceProviderListResult{
		// 	Value: []*armnetwork.ExpressRouteServiceProvider{
		// 		{
		// 			Name: to.Ptr("providerName"),
		// 			Type: to.Ptr("Microsoft.Network/expressRouteServiceProviders"),
		// 			ID: to.Ptr("/subscriptions//resourceGroups//providers/Microsoft.Network/expressRouteServiceProviders/"),
		// 			Properties: &armnetwork.ExpressRouteServiceProviderPropertiesFormat{
		// 				BandwidthsOffered: []*armnetwork.ExpressRouteServiceProviderBandwidthsOffered{
		// 					{
		// 						OfferName: to.Ptr("50Mbps"),
		// 						ValueInMbps: to.Ptr[int32](50),
		// 					},
		// 					{
		// 						OfferName: to.Ptr("100Mbps"),
		// 						ValueInMbps: to.Ptr[int32](100),
		// 					},
		// 					{
		// 						OfferName: to.Ptr("200Mbps"),
		// 						ValueInMbps: to.Ptr[int32](200),
		// 					},
		// 					{
		// 						OfferName: to.Ptr("500Mbps"),
		// 						ValueInMbps: to.Ptr[int32](500),
		// 					},
		// 					{
		// 						OfferName: to.Ptr("1Gbps"),
		// 						ValueInMbps: to.Ptr[int32](1000),
		// 					},
		// 					{
		// 						OfferName: to.Ptr("2Gbps"),
		// 						ValueInMbps: to.Ptr[int32](2000),
		// 					},
		// 					{
		// 						OfferName: to.Ptr("5Gbps"),
		// 						ValueInMbps: to.Ptr[int32](5000),
		// 					},
		// 					{
		// 						OfferName: to.Ptr("10Gbps"),
		// 						ValueInMbps: to.Ptr[int32](10000),
		// 				}},
		// 				PeeringLocations: []*string{
		// 					to.Ptr("peeringLocation1"),
		// 					to.Ptr("peeringLocation2")},
		// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				},
		// 		}},
		// 	}
	}
}
