//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mobilenetwork/armmobilenetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// PacketCoreControlPlanesServer is a fake server for instances of the armmobilenetwork.PacketCoreControlPlanesClient type.
type PacketCoreControlPlanesServer struct {
	// BeginCollectDiagnosticsPackage is the fake for method PacketCoreControlPlanesClient.BeginCollectDiagnosticsPackage
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCollectDiagnosticsPackage func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, parameters armmobilenetwork.PacketCoreControlPlaneCollectDiagnosticsPackage, options *armmobilenetwork.PacketCoreControlPlanesClientBeginCollectDiagnosticsPackageOptions) (resp azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientCollectDiagnosticsPackageResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method PacketCoreControlPlanesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, parameters armmobilenetwork.PacketCoreControlPlane, options *armmobilenetwork.PacketCoreControlPlanesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PacketCoreControlPlanesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, options *armmobilenetwork.PacketCoreControlPlanesClientBeginDeleteOptions) (resp azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PacketCoreControlPlanesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, options *armmobilenetwork.PacketCoreControlPlanesClientGetOptions) (resp azfake.Responder[armmobilenetwork.PacketCoreControlPlanesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method PacketCoreControlPlanesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armmobilenetwork.PacketCoreControlPlanesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlanesClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method PacketCoreControlPlanesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armmobilenetwork.PacketCoreControlPlanesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlanesClientListBySubscriptionResponse])

	// BeginReinstall is the fake for method PacketCoreControlPlanesClient.BeginReinstall
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReinstall func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, options *armmobilenetwork.PacketCoreControlPlanesClientBeginReinstallOptions) (resp azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientReinstallResponse], errResp azfake.ErrorResponder)

	// BeginRollback is the fake for method PacketCoreControlPlanesClient.BeginRollback
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRollback func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, options *armmobilenetwork.PacketCoreControlPlanesClientBeginRollbackOptions) (resp azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientRollbackResponse], errResp azfake.ErrorResponder)

	// UpdateTags is the fake for method PacketCoreControlPlanesClient.UpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	UpdateTags func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, parameters armmobilenetwork.IdentityAndTagsObject, options *armmobilenetwork.PacketCoreControlPlanesClientUpdateTagsOptions) (resp azfake.Responder[armmobilenetwork.PacketCoreControlPlanesClientUpdateTagsResponse], errResp azfake.ErrorResponder)
}

// NewPacketCoreControlPlanesServerTransport creates a new instance of PacketCoreControlPlanesServerTransport with the provided implementation.
// The returned PacketCoreControlPlanesServerTransport instance is connected to an instance of armmobilenetwork.PacketCoreControlPlanesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPacketCoreControlPlanesServerTransport(srv *PacketCoreControlPlanesServer) *PacketCoreControlPlanesServerTransport {
	return &PacketCoreControlPlanesServerTransport{
		srv:                            srv,
		beginCollectDiagnosticsPackage: newTracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientCollectDiagnosticsPackageResponse]](),
		beginCreateOrUpdate:            newTracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientCreateOrUpdateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientDeleteResponse]](),
		newListByResourceGroupPager:    newTracker[azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlanesClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:     newTracker[azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlanesClientListBySubscriptionResponse]](),
		beginReinstall:                 newTracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientReinstallResponse]](),
		beginRollback:                  newTracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientRollbackResponse]](),
	}
}

// PacketCoreControlPlanesServerTransport connects instances of armmobilenetwork.PacketCoreControlPlanesClient to instances of PacketCoreControlPlanesServer.
// Don't use this type directly, use NewPacketCoreControlPlanesServerTransport instead.
type PacketCoreControlPlanesServerTransport struct {
	srv                            *PacketCoreControlPlanesServer
	beginCollectDiagnosticsPackage *tracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientCollectDiagnosticsPackageResponse]]
	beginCreateOrUpdate            *tracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientCreateOrUpdateResponse]]
	beginDelete                    *tracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientDeleteResponse]]
	newListByResourceGroupPager    *tracker[azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlanesClientListByResourceGroupResponse]]
	newListBySubscriptionPager     *tracker[azfake.PagerResponder[armmobilenetwork.PacketCoreControlPlanesClientListBySubscriptionResponse]]
	beginReinstall                 *tracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientReinstallResponse]]
	beginRollback                  *tracker[azfake.PollerResponder[armmobilenetwork.PacketCoreControlPlanesClientRollbackResponse]]
}

// Do implements the policy.Transporter interface for PacketCoreControlPlanesServerTransport.
func (p *PacketCoreControlPlanesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PacketCoreControlPlanesClient.BeginCollectDiagnosticsPackage":
		resp, err = p.dispatchBeginCollectDiagnosticsPackage(req)
	case "PacketCoreControlPlanesClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PacketCoreControlPlanesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PacketCoreControlPlanesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PacketCoreControlPlanesClient.NewListByResourceGroupPager":
		resp, err = p.dispatchNewListByResourceGroupPager(req)
	case "PacketCoreControlPlanesClient.NewListBySubscriptionPager":
		resp, err = p.dispatchNewListBySubscriptionPager(req)
	case "PacketCoreControlPlanesClient.BeginReinstall":
		resp, err = p.dispatchBeginReinstall(req)
	case "PacketCoreControlPlanesClient.BeginRollback":
		resp, err = p.dispatchBeginRollback(req)
	case "PacketCoreControlPlanesClient.UpdateTags":
		resp, err = p.dispatchUpdateTags(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchBeginCollectDiagnosticsPackage(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCollectDiagnosticsPackage == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCollectDiagnosticsPackage not implemented")}
	}
	beginCollectDiagnosticsPackage := p.beginCollectDiagnosticsPackage.get(req)
	if beginCollectDiagnosticsPackage == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collectDiagnosticsPackage`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.PacketCoreControlPlaneCollectDiagnosticsPackage](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCollectDiagnosticsPackage(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCollectDiagnosticsPackage = &respr
		p.beginCollectDiagnosticsPackage.add(req, beginCollectDiagnosticsPackage)
	}

	resp, err := server.PollerResponderNext(beginCollectDiagnosticsPackage, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginCollectDiagnosticsPackage.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCollectDiagnosticsPackage) {
		p.beginCollectDiagnosticsPackage.remove(req)
	}

	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.PacketCoreControlPlane](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PacketCoreControlPlane, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := p.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		p.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armmobilenetwork.PacketCoreControlPlanesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		p.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := p.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := p.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		p.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armmobilenetwork.PacketCoreControlPlanesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		p.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchBeginReinstall(req *http.Request) (*http.Response, error) {
	if p.srv.BeginReinstall == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReinstall not implemented")}
	}
	beginReinstall := p.beginReinstall.get(req)
	if beginReinstall == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reinstall`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginReinstall(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReinstall = &respr
		p.beginReinstall.add(req, beginReinstall)
	}

	resp, err := server.PollerResponderNext(beginReinstall, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginReinstall.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReinstall) {
		p.beginReinstall.remove(req)
	}

	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchBeginRollback(req *http.Request) (*http.Response, error) {
	if p.srv.BeginRollback == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRollback not implemented")}
	}
	beginRollback := p.beginRollback.get(req)
	if beginRollback == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rollback`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginRollback(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRollback = &respr
		p.beginRollback.add(req, beginRollback)
	}

	resp, err := server.PollerResponderNext(beginRollback, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginRollback.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRollback) {
		p.beginRollback.remove(req)
	}

	return resp, nil
}

func (p *PacketCoreControlPlanesServerTransport) dispatchUpdateTags(req *http.Request) (*http.Response, error) {
	if p.srv.UpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateTags not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.IdentityAndTagsObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.UpdateTags(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PacketCoreControlPlane, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
