//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mobilenetwork/armmobilenetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// DiagnosticsPackagesServer is a fake server for instances of the armmobilenetwork.DiagnosticsPackagesClient type.
type DiagnosticsPackagesServer struct {
	// BeginCreateOrUpdate is the fake for method DiagnosticsPackagesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, diagnosticsPackageName string, options *armmobilenetwork.DiagnosticsPackagesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmobilenetwork.DiagnosticsPackagesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DiagnosticsPackagesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, diagnosticsPackageName string, options *armmobilenetwork.DiagnosticsPackagesClientBeginDeleteOptions) (resp azfake.PollerResponder[armmobilenetwork.DiagnosticsPackagesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DiagnosticsPackagesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, diagnosticsPackageName string, options *armmobilenetwork.DiagnosticsPackagesClientGetOptions) (resp azfake.Responder[armmobilenetwork.DiagnosticsPackagesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByPacketCoreControlPlanePager is the fake for method DiagnosticsPackagesClient.NewListByPacketCoreControlPlanePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPacketCoreControlPlanePager func(resourceGroupName string, packetCoreControlPlaneName string, options *armmobilenetwork.DiagnosticsPackagesClientListByPacketCoreControlPlaneOptions) (resp azfake.PagerResponder[armmobilenetwork.DiagnosticsPackagesClientListByPacketCoreControlPlaneResponse])
}

// NewDiagnosticsPackagesServerTransport creates a new instance of DiagnosticsPackagesServerTransport with the provided implementation.
// The returned DiagnosticsPackagesServerTransport instance is connected to an instance of armmobilenetwork.DiagnosticsPackagesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiagnosticsPackagesServerTransport(srv *DiagnosticsPackagesServer) *DiagnosticsPackagesServerTransport {
	return &DiagnosticsPackagesServerTransport{
		srv:                                  srv,
		beginCreateOrUpdate:                  newTracker[azfake.PollerResponder[armmobilenetwork.DiagnosticsPackagesClientCreateOrUpdateResponse]](),
		beginDelete:                          newTracker[azfake.PollerResponder[armmobilenetwork.DiagnosticsPackagesClientDeleteResponse]](),
		newListByPacketCoreControlPlanePager: newTracker[azfake.PagerResponder[armmobilenetwork.DiagnosticsPackagesClientListByPacketCoreControlPlaneResponse]](),
	}
}

// DiagnosticsPackagesServerTransport connects instances of armmobilenetwork.DiagnosticsPackagesClient to instances of DiagnosticsPackagesServer.
// Don't use this type directly, use NewDiagnosticsPackagesServerTransport instead.
type DiagnosticsPackagesServerTransport struct {
	srv                                  *DiagnosticsPackagesServer
	beginCreateOrUpdate                  *tracker[azfake.PollerResponder[armmobilenetwork.DiagnosticsPackagesClientCreateOrUpdateResponse]]
	beginDelete                          *tracker[azfake.PollerResponder[armmobilenetwork.DiagnosticsPackagesClientDeleteResponse]]
	newListByPacketCoreControlPlanePager *tracker[azfake.PagerResponder[armmobilenetwork.DiagnosticsPackagesClientListByPacketCoreControlPlaneResponse]]
}

// Do implements the policy.Transporter interface for DiagnosticsPackagesServerTransport.
func (d *DiagnosticsPackagesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiagnosticsPackagesClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DiagnosticsPackagesClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DiagnosticsPackagesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DiagnosticsPackagesClient.NewListByPacketCoreControlPlanePager":
		resp, err = d.dispatchNewListByPacketCoreControlPlanePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiagnosticsPackagesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnosticsPackages/(?P<diagnosticsPackageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		diagnosticsPackageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticsPackageName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, diagnosticsPackageNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DiagnosticsPackagesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnosticsPackages/(?P<diagnosticsPackageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		diagnosticsPackageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticsPackageName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, diagnosticsPackageNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DiagnosticsPackagesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnosticsPackages/(?P<diagnosticsPackageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
	if err != nil {
		return nil, err
	}
	diagnosticsPackageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticsPackageName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, diagnosticsPackageNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticsPackage, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiagnosticsPackagesServerTransport) dispatchNewListByPacketCoreControlPlanePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByPacketCoreControlPlanePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPacketCoreControlPlanePager not implemented")}
	}
	newListByPacketCoreControlPlanePager := d.newListByPacketCoreControlPlanePager.get(req)
	if newListByPacketCoreControlPlanePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnosticsPackages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByPacketCoreControlPlanePager(resourceGroupNameParam, packetCoreControlPlaneNameParam, nil)
		newListByPacketCoreControlPlanePager = &resp
		d.newListByPacketCoreControlPlanePager.add(req, newListByPacketCoreControlPlanePager)
		server.PagerResponderInjectNextLinks(newListByPacketCoreControlPlanePager, req, func(page *armmobilenetwork.DiagnosticsPackagesClientListByPacketCoreControlPlaneResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPacketCoreControlPlanePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByPacketCoreControlPlanePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPacketCoreControlPlanePager) {
		d.newListByPacketCoreControlPlanePager.remove(req)
	}
	return resp, nil
}
